/* parsed class NVC9C0 */

#include "nvtypes.h"
#include "clc9c0.h"

#include <assert.h>
#include <stdio.h>
#include "util/u_math.h"

struct nv_nvc9c0_SET_OBJECT {
    uint32_t class_id;
    uint32_t engine_id;
};

static inline void
__NVC9C0_SET_OBJECT(uint32_t *val_out, struct nv_nvc9c0_SET_OBJECT st)
{
    uint32_t val = 0;
    
    assert(st.class_id < (1ULL << 16));
    val |= st.class_id << 0;
    
    assert(st.engine_id < (1ULL << 5));
    val |= st.engine_id << 16;
    *val_out = val;
}

#define V_NVC9C0_SET_OBJECT(val, args...) { \
    struct nv_nvc9c0_SET_OBJECT __data = args; \
    __NVC9C0_SET_OBJECT(&val, __data); \
}

#define VA_NVC9C0_SET_OBJECT V_NVC9C0_SET_OBJECT

#define P_NVC9C0_SET_OBJECT(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_OBJECT(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_OBJECT, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_NO_OPERATION {
    uint32_t v;
};

static inline void
__NVC9C0_NO_OPERATION(uint32_t *val_out, struct nv_nvc9c0_NO_OPERATION st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_NO_OPERATION(val, args...) { \
    struct nv_nvc9c0_NO_OPERATION __data = { .v = (args) }; \
    __NVC9C0_NO_OPERATION(&val, __data); \
}

#define VA_NVC9C0_NO_OPERATION V_NVC9C0_NO_OPERATION

#define P_NVC9C0_NO_OPERATION(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_NO_OPERATION(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_NO_OPERATION, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_NOTIFY_A {
    uint32_t address_upper;
};

static inline void
__NVC9C0_SET_NOTIFY_A(uint32_t *val_out, struct nv_nvc9c0_SET_NOTIFY_A st)
{
    uint32_t val = 0;
    
    assert(st.address_upper < (1ULL << 8));
    val |= st.address_upper << 0;
    *val_out = val;
}

#define V_NVC9C0_SET_NOTIFY_A(val, args...) { \
    struct nv_nvc9c0_SET_NOTIFY_A __data = { .address_upper = (args) }; \
    __NVC9C0_SET_NOTIFY_A(&val, __data); \
}

#define VA_NVC9C0_SET_NOTIFY_A V_NVC9C0_SET_NOTIFY_A

#define P_NVC9C0_SET_NOTIFY_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_NOTIFY_A(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_NOTIFY_A, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_NOTIFY_B {
    uint32_t address_lower;
};

static inline void
__NVC9C0_SET_NOTIFY_B(uint32_t *val_out, struct nv_nvc9c0_SET_NOTIFY_B st)
{
    uint32_t val = 0;
    
    val |= st.address_lower;
    *val_out = val;
}

#define V_NVC9C0_SET_NOTIFY_B(val, args...) { \
    struct nv_nvc9c0_SET_NOTIFY_B __data = { .address_lower = (args) }; \
    __NVC9C0_SET_NOTIFY_B(&val, __data); \
}

#define VA_NVC9C0_SET_NOTIFY_B V_NVC9C0_SET_NOTIFY_B

#define P_NVC9C0_SET_NOTIFY_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_NOTIFY_B(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_NOTIFY_B, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_NOTIFY {
    uint32_t type;
};

static inline void
__NVC9C0_NOTIFY(uint32_t *val_out, struct nv_nvc9c0_NOTIFY st)
{
    uint32_t val = 0;
    
    val |= st.type;
    *val_out = val;
}

#define V_NVC9C0_NOTIFY(val, args...) { \
    UNUSED uint32_t TYPE_WRITE_ONLY = NVC9C0_NOTIFY_TYPE_WRITE_ONLY; \
    UNUSED uint32_t TYPE_WRITE_THEN_AWAKEN = NVC9C0_NOTIFY_TYPE_WRITE_THEN_AWAKEN; \
    struct nv_nvc9c0_NOTIFY __data = { .type = (args) }; \
    __NVC9C0_NOTIFY(&val, __data); \
}

#define VA_NVC9C0_NOTIFY V_NVC9C0_NOTIFY

#define P_NVC9C0_NOTIFY(push, args...) do { \
    UNUSED uint32_t TYPE_WRITE_ONLY = NVC9C0_NOTIFY_TYPE_WRITE_ONLY; \
    UNUSED uint32_t TYPE_WRITE_THEN_AWAKEN = NVC9C0_NOTIFY_TYPE_WRITE_THEN_AWAKEN; \
    uint32_t nvk_p_ret; \
    V_NVC9C0_NOTIFY(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_NOTIFY, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_WAIT_FOR_IDLE {
    uint32_t v;
};

static inline void
__NVC9C0_WAIT_FOR_IDLE(uint32_t *val_out, struct nv_nvc9c0_WAIT_FOR_IDLE st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_WAIT_FOR_IDLE(val, args...) { \
    struct nv_nvc9c0_WAIT_FOR_IDLE __data = { .v = (args) }; \
    __NVC9C0_WAIT_FOR_IDLE(&val, __data); \
}

#define VA_NVC9C0_WAIT_FOR_IDLE V_NVC9C0_WAIT_FOR_IDLE

#define P_NVC9C0_WAIT_FOR_IDLE(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_WAIT_FOR_IDLE(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_WAIT_FOR_IDLE, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_LOAD_MME_INSTRUCTION_RAM_POINTER {
    uint32_t v;
};

static inline void
__NVC9C0_LOAD_MME_INSTRUCTION_RAM_POINTER(uint32_t *val_out, struct nv_nvc9c0_LOAD_MME_INSTRUCTION_RAM_POINTER st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_LOAD_MME_INSTRUCTION_RAM_POINTER(val, args...) { \
    struct nv_nvc9c0_LOAD_MME_INSTRUCTION_RAM_POINTER __data = { .v = (args) }; \
    __NVC9C0_LOAD_MME_INSTRUCTION_RAM_POINTER(&val, __data); \
}

#define VA_NVC9C0_LOAD_MME_INSTRUCTION_RAM_POINTER V_NVC9C0_LOAD_MME_INSTRUCTION_RAM_POINTER

#define P_NVC9C0_LOAD_MME_INSTRUCTION_RAM_POINTER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_LOAD_MME_INSTRUCTION_RAM_POINTER(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_LOAD_MME_INSTRUCTION_RAM_POINTER, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_LOAD_MME_INSTRUCTION_RAM {
    uint32_t v;
};

static inline void
__NVC9C0_LOAD_MME_INSTRUCTION_RAM(uint32_t *val_out, struct nv_nvc9c0_LOAD_MME_INSTRUCTION_RAM st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_LOAD_MME_INSTRUCTION_RAM(val, args...) { \
    struct nv_nvc9c0_LOAD_MME_INSTRUCTION_RAM __data = { .v = (args) }; \
    __NVC9C0_LOAD_MME_INSTRUCTION_RAM(&val, __data); \
}

#define VA_NVC9C0_LOAD_MME_INSTRUCTION_RAM V_NVC9C0_LOAD_MME_INSTRUCTION_RAM

#define P_NVC9C0_LOAD_MME_INSTRUCTION_RAM(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_LOAD_MME_INSTRUCTION_RAM(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_LOAD_MME_INSTRUCTION_RAM, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_LOAD_MME_START_ADDRESS_RAM_POINTER {
    uint32_t v;
};

static inline void
__NVC9C0_LOAD_MME_START_ADDRESS_RAM_POINTER(uint32_t *val_out, struct nv_nvc9c0_LOAD_MME_START_ADDRESS_RAM_POINTER st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_LOAD_MME_START_ADDRESS_RAM_POINTER(val, args...) { \
    struct nv_nvc9c0_LOAD_MME_START_ADDRESS_RAM_POINTER __data = { .v = (args) }; \
    __NVC9C0_LOAD_MME_START_ADDRESS_RAM_POINTER(&val, __data); \
}

#define VA_NVC9C0_LOAD_MME_START_ADDRESS_RAM_POINTER V_NVC9C0_LOAD_MME_START_ADDRESS_RAM_POINTER

#define P_NVC9C0_LOAD_MME_START_ADDRESS_RAM_POINTER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_LOAD_MME_START_ADDRESS_RAM_POINTER(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_LOAD_MME_START_ADDRESS_RAM_POINTER, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_LOAD_MME_START_ADDRESS_RAM {
    uint32_t v;
};

static inline void
__NVC9C0_LOAD_MME_START_ADDRESS_RAM(uint32_t *val_out, struct nv_nvc9c0_LOAD_MME_START_ADDRESS_RAM st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_LOAD_MME_START_ADDRESS_RAM(val, args...) { \
    struct nv_nvc9c0_LOAD_MME_START_ADDRESS_RAM __data = { .v = (args) }; \
    __NVC9C0_LOAD_MME_START_ADDRESS_RAM(&val, __data); \
}

#define VA_NVC9C0_LOAD_MME_START_ADDRESS_RAM V_NVC9C0_LOAD_MME_START_ADDRESS_RAM

#define P_NVC9C0_LOAD_MME_START_ADDRESS_RAM(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_LOAD_MME_START_ADDRESS_RAM(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_LOAD_MME_START_ADDRESS_RAM, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_MME_SHADOW_RAM_CONTROL {
    uint32_t mode;
};

static inline void
__NVC9C0_SET_MME_SHADOW_RAM_CONTROL(uint32_t *val_out, struct nv_nvc9c0_SET_MME_SHADOW_RAM_CONTROL st)
{
    uint32_t val = 0;
    
    assert(st.mode < (1ULL << 2));
    val |= st.mode << 0;
    *val_out = val;
}

#define V_NVC9C0_SET_MME_SHADOW_RAM_CONTROL(val, args...) { \
    UNUSED uint32_t MODE_METHOD_TRACK = NVC9C0_SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_TRACK; \
    UNUSED uint32_t MODE_METHOD_TRACK_WITH_FILTER = NVC9C0_SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_TRACK_WITH_FILTER; \
    UNUSED uint32_t MODE_METHOD_PASSTHROUGH = NVC9C0_SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_PASSTHROUGH; \
    UNUSED uint32_t MODE_METHOD_REPLAY = NVC9C0_SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_REPLAY; \
    struct nv_nvc9c0_SET_MME_SHADOW_RAM_CONTROL __data = { .mode = (args) }; \
    __NVC9C0_SET_MME_SHADOW_RAM_CONTROL(&val, __data); \
}

#define VA_NVC9C0_SET_MME_SHADOW_RAM_CONTROL V_NVC9C0_SET_MME_SHADOW_RAM_CONTROL

#define P_NVC9C0_SET_MME_SHADOW_RAM_CONTROL(push, args...) do { \
    UNUSED uint32_t MODE_METHOD_TRACK = NVC9C0_SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_TRACK; \
    UNUSED uint32_t MODE_METHOD_TRACK_WITH_FILTER = NVC9C0_SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_TRACK_WITH_FILTER; \
    UNUSED uint32_t MODE_METHOD_PASSTHROUGH = NVC9C0_SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_PASSTHROUGH; \
    UNUSED uint32_t MODE_METHOD_REPLAY = NVC9C0_SET_MME_SHADOW_RAM_CONTROL_MODE_METHOD_REPLAY; \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_MME_SHADOW_RAM_CONTROL(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_MME_SHADOW_RAM_CONTROL, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_GLOBAL_RENDER_ENABLE_A {
    uint32_t offset_upper;
};

static inline void
__NVC9C0_SET_GLOBAL_RENDER_ENABLE_A(uint32_t *val_out, struct nv_nvc9c0_SET_GLOBAL_RENDER_ENABLE_A st)
{
    uint32_t val = 0;
    
    assert(st.offset_upper < (1ULL << 8));
    val |= st.offset_upper << 0;
    *val_out = val;
}

#define V_NVC9C0_SET_GLOBAL_RENDER_ENABLE_A(val, args...) { \
    struct nv_nvc9c0_SET_GLOBAL_RENDER_ENABLE_A __data = { .offset_upper = (args) }; \
    __NVC9C0_SET_GLOBAL_RENDER_ENABLE_A(&val, __data); \
}

#define VA_NVC9C0_SET_GLOBAL_RENDER_ENABLE_A V_NVC9C0_SET_GLOBAL_RENDER_ENABLE_A

#define P_NVC9C0_SET_GLOBAL_RENDER_ENABLE_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_GLOBAL_RENDER_ENABLE_A(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_GLOBAL_RENDER_ENABLE_A, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_GLOBAL_RENDER_ENABLE_B {
    uint32_t offset_lower;
};

static inline void
__NVC9C0_SET_GLOBAL_RENDER_ENABLE_B(uint32_t *val_out, struct nv_nvc9c0_SET_GLOBAL_RENDER_ENABLE_B st)
{
    uint32_t val = 0;
    
    val |= st.offset_lower;
    *val_out = val;
}

#define V_NVC9C0_SET_GLOBAL_RENDER_ENABLE_B(val, args...) { \
    struct nv_nvc9c0_SET_GLOBAL_RENDER_ENABLE_B __data = { .offset_lower = (args) }; \
    __NVC9C0_SET_GLOBAL_RENDER_ENABLE_B(&val, __data); \
}

#define VA_NVC9C0_SET_GLOBAL_RENDER_ENABLE_B V_NVC9C0_SET_GLOBAL_RENDER_ENABLE_B

#define P_NVC9C0_SET_GLOBAL_RENDER_ENABLE_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_GLOBAL_RENDER_ENABLE_B(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_GLOBAL_RENDER_ENABLE_B, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_GLOBAL_RENDER_ENABLE_C {
    uint32_t mode;
};

static inline void
__NVC9C0_SET_GLOBAL_RENDER_ENABLE_C(uint32_t *val_out, struct nv_nvc9c0_SET_GLOBAL_RENDER_ENABLE_C st)
{
    uint32_t val = 0;
    
    assert(st.mode < (1ULL << 3));
    val |= st.mode << 0;
    *val_out = val;
}

#define V_NVC9C0_SET_GLOBAL_RENDER_ENABLE_C(val, args...) { \
    UNUSED uint32_t MODE_FALSE = NVC9C0_SET_GLOBAL_RENDER_ENABLE_C_MODE_FALSE; \
    UNUSED uint32_t MODE_TRUE = NVC9C0_SET_GLOBAL_RENDER_ENABLE_C_MODE_TRUE; \
    UNUSED uint32_t MODE_CONDITIONAL = NVC9C0_SET_GLOBAL_RENDER_ENABLE_C_MODE_CONDITIONAL; \
    UNUSED uint32_t MODE_RENDER_IF_EQUAL = NVC9C0_SET_GLOBAL_RENDER_ENABLE_C_MODE_RENDER_IF_EQUAL; \
    UNUSED uint32_t MODE_RENDER_IF_NOT_EQUAL = NVC9C0_SET_GLOBAL_RENDER_ENABLE_C_MODE_RENDER_IF_NOT_EQUAL; \
    struct nv_nvc9c0_SET_GLOBAL_RENDER_ENABLE_C __data = { .mode = (args) }; \
    __NVC9C0_SET_GLOBAL_RENDER_ENABLE_C(&val, __data); \
}

#define VA_NVC9C0_SET_GLOBAL_RENDER_ENABLE_C V_NVC9C0_SET_GLOBAL_RENDER_ENABLE_C

#define P_NVC9C0_SET_GLOBAL_RENDER_ENABLE_C(push, args...) do { \
    UNUSED uint32_t MODE_FALSE = NVC9C0_SET_GLOBAL_RENDER_ENABLE_C_MODE_FALSE; \
    UNUSED uint32_t MODE_TRUE = NVC9C0_SET_GLOBAL_RENDER_ENABLE_C_MODE_TRUE; \
    UNUSED uint32_t MODE_CONDITIONAL = NVC9C0_SET_GLOBAL_RENDER_ENABLE_C_MODE_CONDITIONAL; \
    UNUSED uint32_t MODE_RENDER_IF_EQUAL = NVC9C0_SET_GLOBAL_RENDER_ENABLE_C_MODE_RENDER_IF_EQUAL; \
    UNUSED uint32_t MODE_RENDER_IF_NOT_EQUAL = NVC9C0_SET_GLOBAL_RENDER_ENABLE_C_MODE_RENDER_IF_NOT_EQUAL; \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_GLOBAL_RENDER_ENABLE_C(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_GLOBAL_RENDER_ENABLE_C, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SEND_GO_IDLE {
    uint32_t v;
};

static inline void
__NVC9C0_SEND_GO_IDLE(uint32_t *val_out, struct nv_nvc9c0_SEND_GO_IDLE st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_SEND_GO_IDLE(val, args...) { \
    struct nv_nvc9c0_SEND_GO_IDLE __data = { .v = (args) }; \
    __NVC9C0_SEND_GO_IDLE(&val, __data); \
}

#define VA_NVC9C0_SEND_GO_IDLE V_NVC9C0_SEND_GO_IDLE

#define P_NVC9C0_SEND_GO_IDLE(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SEND_GO_IDLE(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SEND_GO_IDLE, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_PM_TRIGGER {
    uint32_t v;
};

static inline void
__NVC9C0_PM_TRIGGER(uint32_t *val_out, struct nv_nvc9c0_PM_TRIGGER st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_PM_TRIGGER(val, args...) { \
    struct nv_nvc9c0_PM_TRIGGER __data = { .v = (args) }; \
    __NVC9C0_PM_TRIGGER(&val, __data); \
}

#define VA_NVC9C0_PM_TRIGGER V_NVC9C0_PM_TRIGGER

#define P_NVC9C0_PM_TRIGGER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_PM_TRIGGER(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_PM_TRIGGER, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_PM_TRIGGER_WFI {
    uint32_t v;
};

static inline void
__NVC9C0_PM_TRIGGER_WFI(uint32_t *val_out, struct nv_nvc9c0_PM_TRIGGER_WFI st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_PM_TRIGGER_WFI(val, args...) { \
    struct nv_nvc9c0_PM_TRIGGER_WFI __data = { .v = (args) }; \
    __NVC9C0_PM_TRIGGER_WFI(&val, __data); \
}

#define VA_NVC9C0_PM_TRIGGER_WFI V_NVC9C0_PM_TRIGGER_WFI

#define P_NVC9C0_PM_TRIGGER_WFI(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_PM_TRIGGER_WFI(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_PM_TRIGGER_WFI, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_FE_ATOMIC_SEQUENCE_BEGIN {
    uint32_t v;
};

static inline void
__NVC9C0_FE_ATOMIC_SEQUENCE_BEGIN(uint32_t *val_out, struct nv_nvc9c0_FE_ATOMIC_SEQUENCE_BEGIN st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_FE_ATOMIC_SEQUENCE_BEGIN(val, args...) { \
    struct nv_nvc9c0_FE_ATOMIC_SEQUENCE_BEGIN __data = { .v = (args) }; \
    __NVC9C0_FE_ATOMIC_SEQUENCE_BEGIN(&val, __data); \
}

#define VA_NVC9C0_FE_ATOMIC_SEQUENCE_BEGIN V_NVC9C0_FE_ATOMIC_SEQUENCE_BEGIN

#define P_NVC9C0_FE_ATOMIC_SEQUENCE_BEGIN(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_FE_ATOMIC_SEQUENCE_BEGIN(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_FE_ATOMIC_SEQUENCE_BEGIN, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_FE_ATOMIC_SEQUENCE_END {
    uint32_t v;
};

static inline void
__NVC9C0_FE_ATOMIC_SEQUENCE_END(uint32_t *val_out, struct nv_nvc9c0_FE_ATOMIC_SEQUENCE_END st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_FE_ATOMIC_SEQUENCE_END(val, args...) { \
    struct nv_nvc9c0_FE_ATOMIC_SEQUENCE_END __data = { .v = (args) }; \
    __NVC9C0_FE_ATOMIC_SEQUENCE_END(&val, __data); \
}

#define VA_NVC9C0_FE_ATOMIC_SEQUENCE_END V_NVC9C0_FE_ATOMIC_SEQUENCE_END

#define P_NVC9C0_FE_ATOMIC_SEQUENCE_END(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_FE_ATOMIC_SEQUENCE_END(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_FE_ATOMIC_SEQUENCE_END, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_INSTRUMENTATION_METHOD_HEADER {
    uint32_t v;
};

static inline void
__NVC9C0_SET_INSTRUMENTATION_METHOD_HEADER(uint32_t *val_out, struct nv_nvc9c0_SET_INSTRUMENTATION_METHOD_HEADER st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_SET_INSTRUMENTATION_METHOD_HEADER(val, args...) { \
    struct nv_nvc9c0_SET_INSTRUMENTATION_METHOD_HEADER __data = { .v = (args) }; \
    __NVC9C0_SET_INSTRUMENTATION_METHOD_HEADER(&val, __data); \
}

#define VA_NVC9C0_SET_INSTRUMENTATION_METHOD_HEADER V_NVC9C0_SET_INSTRUMENTATION_METHOD_HEADER

#define P_NVC9C0_SET_INSTRUMENTATION_METHOD_HEADER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_INSTRUMENTATION_METHOD_HEADER(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_INSTRUMENTATION_METHOD_HEADER, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_INSTRUMENTATION_METHOD_DATA {
    uint32_t v;
};

static inline void
__NVC9C0_SET_INSTRUMENTATION_METHOD_DATA(uint32_t *val_out, struct nv_nvc9c0_SET_INSTRUMENTATION_METHOD_DATA st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_SET_INSTRUMENTATION_METHOD_DATA(val, args...) { \
    struct nv_nvc9c0_SET_INSTRUMENTATION_METHOD_DATA __data = { .v = (args) }; \
    __NVC9C0_SET_INSTRUMENTATION_METHOD_DATA(&val, __data); \
}

#define VA_NVC9C0_SET_INSTRUMENTATION_METHOD_DATA V_NVC9C0_SET_INSTRUMENTATION_METHOD_DATA

#define P_NVC9C0_SET_INSTRUMENTATION_METHOD_DATA(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_INSTRUMENTATION_METHOD_DATA(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_INSTRUMENTATION_METHOD_DATA, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_REPORT_SEMAPHORE_PAYLOAD_LOWER {
    uint32_t payload_lower;
};

static inline void
__NVC9C0_SET_REPORT_SEMAPHORE_PAYLOAD_LOWER(uint32_t *val_out, struct nv_nvc9c0_SET_REPORT_SEMAPHORE_PAYLOAD_LOWER st)
{
    uint32_t val = 0;
    
    val |= st.payload_lower;
    *val_out = val;
}

#define V_NVC9C0_SET_REPORT_SEMAPHORE_PAYLOAD_LOWER(val, args...) { \
    struct nv_nvc9c0_SET_REPORT_SEMAPHORE_PAYLOAD_LOWER __data = { .payload_lower = (args) }; \
    __NVC9C0_SET_REPORT_SEMAPHORE_PAYLOAD_LOWER(&val, __data); \
}

#define VA_NVC9C0_SET_REPORT_SEMAPHORE_PAYLOAD_LOWER V_NVC9C0_SET_REPORT_SEMAPHORE_PAYLOAD_LOWER

#define P_NVC9C0_SET_REPORT_SEMAPHORE_PAYLOAD_LOWER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_REPORT_SEMAPHORE_PAYLOAD_LOWER(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_REPORT_SEMAPHORE_PAYLOAD_LOWER, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_REPORT_SEMAPHORE_PAYLOAD_UPPER {
    uint32_t payload_upper;
};

static inline void
__NVC9C0_SET_REPORT_SEMAPHORE_PAYLOAD_UPPER(uint32_t *val_out, struct nv_nvc9c0_SET_REPORT_SEMAPHORE_PAYLOAD_UPPER st)
{
    uint32_t val = 0;
    
    val |= st.payload_upper;
    *val_out = val;
}

#define V_NVC9C0_SET_REPORT_SEMAPHORE_PAYLOAD_UPPER(val, args...) { \
    struct nv_nvc9c0_SET_REPORT_SEMAPHORE_PAYLOAD_UPPER __data = { .payload_upper = (args) }; \
    __NVC9C0_SET_REPORT_SEMAPHORE_PAYLOAD_UPPER(&val, __data); \
}

#define VA_NVC9C0_SET_REPORT_SEMAPHORE_PAYLOAD_UPPER V_NVC9C0_SET_REPORT_SEMAPHORE_PAYLOAD_UPPER

#define P_NVC9C0_SET_REPORT_SEMAPHORE_PAYLOAD_UPPER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_REPORT_SEMAPHORE_PAYLOAD_UPPER(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_REPORT_SEMAPHORE_PAYLOAD_UPPER, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_REPORT_SEMAPHORE_ADDRESS_LOWER {
    uint32_t lower;
};

static inline void
__NVC9C0_SET_REPORT_SEMAPHORE_ADDRESS_LOWER(uint32_t *val_out, struct nv_nvc9c0_SET_REPORT_SEMAPHORE_ADDRESS_LOWER st)
{
    uint32_t val = 0;
    
    val |= st.lower;
    *val_out = val;
}

#define V_NVC9C0_SET_REPORT_SEMAPHORE_ADDRESS_LOWER(val, args...) { \
    struct nv_nvc9c0_SET_REPORT_SEMAPHORE_ADDRESS_LOWER __data = { .lower = (args) }; \
    __NVC9C0_SET_REPORT_SEMAPHORE_ADDRESS_LOWER(&val, __data); \
}

#define VA_NVC9C0_SET_REPORT_SEMAPHORE_ADDRESS_LOWER V_NVC9C0_SET_REPORT_SEMAPHORE_ADDRESS_LOWER

#define P_NVC9C0_SET_REPORT_SEMAPHORE_ADDRESS_LOWER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_REPORT_SEMAPHORE_ADDRESS_LOWER(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_REPORT_SEMAPHORE_ADDRESS_LOWER, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_REPORT_SEMAPHORE_ADDRESS_UPPER {
    uint32_t upper;
};

static inline void
__NVC9C0_SET_REPORT_SEMAPHORE_ADDRESS_UPPER(uint32_t *val_out, struct nv_nvc9c0_SET_REPORT_SEMAPHORE_ADDRESS_UPPER st)
{
    uint32_t val = 0;
    
    assert(st.upper < (1ULL << 8));
    val |= st.upper << 0;
    *val_out = val;
}

#define V_NVC9C0_SET_REPORT_SEMAPHORE_ADDRESS_UPPER(val, args...) { \
    struct nv_nvc9c0_SET_REPORT_SEMAPHORE_ADDRESS_UPPER __data = { .upper = (args) }; \
    __NVC9C0_SET_REPORT_SEMAPHORE_ADDRESS_UPPER(&val, __data); \
}

#define VA_NVC9C0_SET_REPORT_SEMAPHORE_ADDRESS_UPPER V_NVC9C0_SET_REPORT_SEMAPHORE_ADDRESS_UPPER

#define P_NVC9C0_SET_REPORT_SEMAPHORE_ADDRESS_UPPER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_REPORT_SEMAPHORE_ADDRESS_UPPER(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_REPORT_SEMAPHORE_ADDRESS_UPPER, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_REPORT_SEMAPHORE_EXECUTE {
    uint32_t operation;
    uint32_t awaken_enable;
    uint32_t structure_size;
    uint32_t flush_disable;
    uint32_t reduction_enable;
    uint32_t reduction_op;
    uint32_t reduction_format;
    uint32_t payload_size64;
    uint32_t trap_type;
};

static inline void
__NVC9C0_REPORT_SEMAPHORE_EXECUTE(uint32_t *val_out, struct nv_nvc9c0_REPORT_SEMAPHORE_EXECUTE st)
{
    uint32_t val = 0;
    
    assert(st.operation < (1ULL << 2));
    val |= st.operation << 0;
    
    assert(st.awaken_enable < (1ULL << 1));
    val |= st.awaken_enable << 2;
    
    assert(st.structure_size < (1ULL << 2));
    val |= st.structure_size << 3;
    
    assert(st.flush_disable < (1ULL << 1));
    val |= st.flush_disable << 5;
    
    assert(st.reduction_enable < (1ULL << 1));
    val |= st.reduction_enable << 6;
    
    assert(st.reduction_op < (1ULL << 3));
    val |= st.reduction_op << 7;
    
    assert(st.reduction_format < (1ULL << 2));
    val |= st.reduction_format << 10;
    
    assert(st.payload_size64 < (1ULL << 1));
    val |= st.payload_size64 << 12;
    
    assert(st.trap_type < (1ULL << 2));
    val |= st.trap_type << 13;
    *val_out = val;
}

#define V_NVC9C0_REPORT_SEMAPHORE_EXECUTE(val, args...) { \
    UNUSED uint32_t OPERATION_RELEASE = NVC9C0_REPORT_SEMAPHORE_EXECUTE_OPERATION_RELEASE; \
    UNUSED uint32_t OPERATION_ACQUIRE = NVC9C0_REPORT_SEMAPHORE_EXECUTE_OPERATION_ACQUIRE; \
    UNUSED uint32_t OPERATION_REPORT_ONLY = NVC9C0_REPORT_SEMAPHORE_EXECUTE_OPERATION_REPORT_ONLY; \
    UNUSED uint32_t OPERATION_TRAP = NVC9C0_REPORT_SEMAPHORE_EXECUTE_OPERATION_TRAP; \
    UNUSED uint32_t AWAKEN_ENABLE_FALSE = NVC9C0_REPORT_SEMAPHORE_EXECUTE_AWAKEN_ENABLE_FALSE; \
    UNUSED uint32_t AWAKEN_ENABLE_TRUE = NVC9C0_REPORT_SEMAPHORE_EXECUTE_AWAKEN_ENABLE_TRUE; \
    UNUSED uint32_t STRUCTURE_SIZE_SEMAPHORE_FOUR_WORDS = NVC9C0_REPORT_SEMAPHORE_EXECUTE_STRUCTURE_SIZE_SEMAPHORE_FOUR_WORDS; \
    UNUSED uint32_t STRUCTURE_SIZE_SEMAPHORE_ONE_WORD = NVC9C0_REPORT_SEMAPHORE_EXECUTE_STRUCTURE_SIZE_SEMAPHORE_ONE_WORD; \
    UNUSED uint32_t STRUCTURE_SIZE_SEMAPHORE_TWO_WORDS = NVC9C0_REPORT_SEMAPHORE_EXECUTE_STRUCTURE_SIZE_SEMAPHORE_TWO_WORDS; \
    UNUSED uint32_t FLUSH_DISABLE_FALSE = NVC9C0_REPORT_SEMAPHORE_EXECUTE_FLUSH_DISABLE_FALSE; \
    UNUSED uint32_t FLUSH_DISABLE_TRUE = NVC9C0_REPORT_SEMAPHORE_EXECUTE_FLUSH_DISABLE_TRUE; \
    UNUSED uint32_t REDUCTION_ENABLE_FALSE = NVC9C0_REPORT_SEMAPHORE_EXECUTE_REDUCTION_ENABLE_FALSE; \
    UNUSED uint32_t REDUCTION_ENABLE_TRUE = NVC9C0_REPORT_SEMAPHORE_EXECUTE_REDUCTION_ENABLE_TRUE; \
    UNUSED uint32_t REDUCTION_OP_RED_ADD = NVC9C0_REPORT_SEMAPHORE_EXECUTE_REDUCTION_OP_RED_ADD; \
    UNUSED uint32_t REDUCTION_OP_RED_MIN = NVC9C0_REPORT_SEMAPHORE_EXECUTE_REDUCTION_OP_RED_MIN; \
    UNUSED uint32_t REDUCTION_OP_RED_MAX = NVC9C0_REPORT_SEMAPHORE_EXECUTE_REDUCTION_OP_RED_MAX; \
    UNUSED uint32_t REDUCTION_OP_RED_INC = NVC9C0_REPORT_SEMAPHORE_EXECUTE_REDUCTION_OP_RED_INC; \
    UNUSED uint32_t REDUCTION_OP_RED_DEC = NVC9C0_REPORT_SEMAPHORE_EXECUTE_REDUCTION_OP_RED_DEC; \
    UNUSED uint32_t REDUCTION_OP_RED_AND = NVC9C0_REPORT_SEMAPHORE_EXECUTE_REDUCTION_OP_RED_AND; \
    UNUSED uint32_t REDUCTION_OP_RED_OR = NVC9C0_REPORT_SEMAPHORE_EXECUTE_REDUCTION_OP_RED_OR; \
    UNUSED uint32_t REDUCTION_OP_RED_XOR = NVC9C0_REPORT_SEMAPHORE_EXECUTE_REDUCTION_OP_RED_XOR; \
    UNUSED uint32_t REDUCTION_FORMAT_UNSIGNED = NVC9C0_REPORT_SEMAPHORE_EXECUTE_REDUCTION_FORMAT_UNSIGNED; \
    UNUSED uint32_t REDUCTION_FORMAT_SIGNED = NVC9C0_REPORT_SEMAPHORE_EXECUTE_REDUCTION_FORMAT_SIGNED; \
    UNUSED uint32_t PAYLOAD_SIZE64_FALSE = NVC9C0_REPORT_SEMAPHORE_EXECUTE_PAYLOAD_SIZE64_FALSE; \
    UNUSED uint32_t PAYLOAD_SIZE64_TRUE = NVC9C0_REPORT_SEMAPHORE_EXECUTE_PAYLOAD_SIZE64_TRUE; \
    UNUSED uint32_t TRAP_TYPE_TRAP_NONE = NVC9C0_REPORT_SEMAPHORE_EXECUTE_TRAP_TYPE_TRAP_NONE; \
    UNUSED uint32_t TRAP_TYPE_TRAP_UNCONDITIONAL = NVC9C0_REPORT_SEMAPHORE_EXECUTE_TRAP_TYPE_TRAP_UNCONDITIONAL; \
    UNUSED uint32_t TRAP_TYPE_TRAP_CONDITIONAL = NVC9C0_REPORT_SEMAPHORE_EXECUTE_TRAP_TYPE_TRAP_CONDITIONAL; \
    UNUSED uint32_t TRAP_TYPE_TRAP_CONDITIONAL_EXT = NVC9C0_REPORT_SEMAPHORE_EXECUTE_TRAP_TYPE_TRAP_CONDITIONAL_EXT; \
    struct nv_nvc9c0_REPORT_SEMAPHORE_EXECUTE __data = args; \
    __NVC9C0_REPORT_SEMAPHORE_EXECUTE(&val, __data); \
}

#define VA_NVC9C0_REPORT_SEMAPHORE_EXECUTE V_NVC9C0_REPORT_SEMAPHORE_EXECUTE

#define P_NVC9C0_REPORT_SEMAPHORE_EXECUTE(push, args...) do { \
    UNUSED uint32_t OPERATION_RELEASE = NVC9C0_REPORT_SEMAPHORE_EXECUTE_OPERATION_RELEASE; \
    UNUSED uint32_t OPERATION_ACQUIRE = NVC9C0_REPORT_SEMAPHORE_EXECUTE_OPERATION_ACQUIRE; \
    UNUSED uint32_t OPERATION_REPORT_ONLY = NVC9C0_REPORT_SEMAPHORE_EXECUTE_OPERATION_REPORT_ONLY; \
    UNUSED uint32_t OPERATION_TRAP = NVC9C0_REPORT_SEMAPHORE_EXECUTE_OPERATION_TRAP; \
    UNUSED uint32_t AWAKEN_ENABLE_FALSE = NVC9C0_REPORT_SEMAPHORE_EXECUTE_AWAKEN_ENABLE_FALSE; \
    UNUSED uint32_t AWAKEN_ENABLE_TRUE = NVC9C0_REPORT_SEMAPHORE_EXECUTE_AWAKEN_ENABLE_TRUE; \
    UNUSED uint32_t STRUCTURE_SIZE_SEMAPHORE_FOUR_WORDS = NVC9C0_REPORT_SEMAPHORE_EXECUTE_STRUCTURE_SIZE_SEMAPHORE_FOUR_WORDS; \
    UNUSED uint32_t STRUCTURE_SIZE_SEMAPHORE_ONE_WORD = NVC9C0_REPORT_SEMAPHORE_EXECUTE_STRUCTURE_SIZE_SEMAPHORE_ONE_WORD; \
    UNUSED uint32_t STRUCTURE_SIZE_SEMAPHORE_TWO_WORDS = NVC9C0_REPORT_SEMAPHORE_EXECUTE_STRUCTURE_SIZE_SEMAPHORE_TWO_WORDS; \
    UNUSED uint32_t FLUSH_DISABLE_FALSE = NVC9C0_REPORT_SEMAPHORE_EXECUTE_FLUSH_DISABLE_FALSE; \
    UNUSED uint32_t FLUSH_DISABLE_TRUE = NVC9C0_REPORT_SEMAPHORE_EXECUTE_FLUSH_DISABLE_TRUE; \
    UNUSED uint32_t REDUCTION_ENABLE_FALSE = NVC9C0_REPORT_SEMAPHORE_EXECUTE_REDUCTION_ENABLE_FALSE; \
    UNUSED uint32_t REDUCTION_ENABLE_TRUE = NVC9C0_REPORT_SEMAPHORE_EXECUTE_REDUCTION_ENABLE_TRUE; \
    UNUSED uint32_t REDUCTION_OP_RED_ADD = NVC9C0_REPORT_SEMAPHORE_EXECUTE_REDUCTION_OP_RED_ADD; \
    UNUSED uint32_t REDUCTION_OP_RED_MIN = NVC9C0_REPORT_SEMAPHORE_EXECUTE_REDUCTION_OP_RED_MIN; \
    UNUSED uint32_t REDUCTION_OP_RED_MAX = NVC9C0_REPORT_SEMAPHORE_EXECUTE_REDUCTION_OP_RED_MAX; \
    UNUSED uint32_t REDUCTION_OP_RED_INC = NVC9C0_REPORT_SEMAPHORE_EXECUTE_REDUCTION_OP_RED_INC; \
    UNUSED uint32_t REDUCTION_OP_RED_DEC = NVC9C0_REPORT_SEMAPHORE_EXECUTE_REDUCTION_OP_RED_DEC; \
    UNUSED uint32_t REDUCTION_OP_RED_AND = NVC9C0_REPORT_SEMAPHORE_EXECUTE_REDUCTION_OP_RED_AND; \
    UNUSED uint32_t REDUCTION_OP_RED_OR = NVC9C0_REPORT_SEMAPHORE_EXECUTE_REDUCTION_OP_RED_OR; \
    UNUSED uint32_t REDUCTION_OP_RED_XOR = NVC9C0_REPORT_SEMAPHORE_EXECUTE_REDUCTION_OP_RED_XOR; \
    UNUSED uint32_t REDUCTION_FORMAT_UNSIGNED = NVC9C0_REPORT_SEMAPHORE_EXECUTE_REDUCTION_FORMAT_UNSIGNED; \
    UNUSED uint32_t REDUCTION_FORMAT_SIGNED = NVC9C0_REPORT_SEMAPHORE_EXECUTE_REDUCTION_FORMAT_SIGNED; \
    UNUSED uint32_t PAYLOAD_SIZE64_FALSE = NVC9C0_REPORT_SEMAPHORE_EXECUTE_PAYLOAD_SIZE64_FALSE; \
    UNUSED uint32_t PAYLOAD_SIZE64_TRUE = NVC9C0_REPORT_SEMAPHORE_EXECUTE_PAYLOAD_SIZE64_TRUE; \
    UNUSED uint32_t TRAP_TYPE_TRAP_NONE = NVC9C0_REPORT_SEMAPHORE_EXECUTE_TRAP_TYPE_TRAP_NONE; \
    UNUSED uint32_t TRAP_TYPE_TRAP_UNCONDITIONAL = NVC9C0_REPORT_SEMAPHORE_EXECUTE_TRAP_TYPE_TRAP_UNCONDITIONAL; \
    UNUSED uint32_t TRAP_TYPE_TRAP_CONDITIONAL = NVC9C0_REPORT_SEMAPHORE_EXECUTE_TRAP_TYPE_TRAP_CONDITIONAL; \
    UNUSED uint32_t TRAP_TYPE_TRAP_CONDITIONAL_EXT = NVC9C0_REPORT_SEMAPHORE_EXECUTE_TRAP_TYPE_TRAP_CONDITIONAL_EXT; \
    uint32_t nvk_p_ret; \
    V_NVC9C0_REPORT_SEMAPHORE_EXECUTE(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_REPORT_SEMAPHORE_EXECUTE, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_LINE_LENGTH_IN {
    uint32_t value;
};

static inline void
__NVC9C0_LINE_LENGTH_IN(uint32_t *val_out, struct nv_nvc9c0_LINE_LENGTH_IN st)
{
    uint32_t val = 0;
    
    val |= st.value;
    *val_out = val;
}

#define V_NVC9C0_LINE_LENGTH_IN(val, args...) { \
    struct nv_nvc9c0_LINE_LENGTH_IN __data = { .value = (args) }; \
    __NVC9C0_LINE_LENGTH_IN(&val, __data); \
}

#define VA_NVC9C0_LINE_LENGTH_IN V_NVC9C0_LINE_LENGTH_IN

#define P_NVC9C0_LINE_LENGTH_IN(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_LINE_LENGTH_IN(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_LINE_LENGTH_IN, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_LINE_COUNT {
    uint32_t value;
};

static inline void
__NVC9C0_LINE_COUNT(uint32_t *val_out, struct nv_nvc9c0_LINE_COUNT st)
{
    uint32_t val = 0;
    
    val |= st.value;
    *val_out = val;
}

#define V_NVC9C0_LINE_COUNT(val, args...) { \
    struct nv_nvc9c0_LINE_COUNT __data = { .value = (args) }; \
    __NVC9C0_LINE_COUNT(&val, __data); \
}

#define VA_NVC9C0_LINE_COUNT V_NVC9C0_LINE_COUNT

#define P_NVC9C0_LINE_COUNT(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_LINE_COUNT(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_LINE_COUNT, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_OFFSET_OUT_UPPER {
    uint32_t value;
};

static inline void
__NVC9C0_OFFSET_OUT_UPPER(uint32_t *val_out, struct nv_nvc9c0_OFFSET_OUT_UPPER st)
{
    uint32_t val = 0;
    
    assert(st.value < (1ULL << 17));
    val |= st.value << 0;
    *val_out = val;
}

#define V_NVC9C0_OFFSET_OUT_UPPER(val, args...) { \
    struct nv_nvc9c0_OFFSET_OUT_UPPER __data = { .value = (args) }; \
    __NVC9C0_OFFSET_OUT_UPPER(&val, __data); \
}

#define VA_NVC9C0_OFFSET_OUT_UPPER V_NVC9C0_OFFSET_OUT_UPPER

#define P_NVC9C0_OFFSET_OUT_UPPER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_OFFSET_OUT_UPPER(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_OFFSET_OUT_UPPER, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_OFFSET_OUT {
    uint32_t value;
};

static inline void
__NVC9C0_OFFSET_OUT(uint32_t *val_out, struct nv_nvc9c0_OFFSET_OUT st)
{
    uint32_t val = 0;
    
    val |= st.value;
    *val_out = val;
}

#define V_NVC9C0_OFFSET_OUT(val, args...) { \
    struct nv_nvc9c0_OFFSET_OUT __data = { .value = (args) }; \
    __NVC9C0_OFFSET_OUT(&val, __data); \
}

#define VA_NVC9C0_OFFSET_OUT V_NVC9C0_OFFSET_OUT

#define P_NVC9C0_OFFSET_OUT(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_OFFSET_OUT(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_OFFSET_OUT, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_PITCH_OUT {
    uint32_t value;
};

static inline void
__NVC9C0_PITCH_OUT(uint32_t *val_out, struct nv_nvc9c0_PITCH_OUT st)
{
    uint32_t val = 0;
    
    val |= st.value;
    *val_out = val;
}

#define V_NVC9C0_PITCH_OUT(val, args...) { \
    struct nv_nvc9c0_PITCH_OUT __data = { .value = (args) }; \
    __NVC9C0_PITCH_OUT(&val, __data); \
}

#define VA_NVC9C0_PITCH_OUT V_NVC9C0_PITCH_OUT

#define P_NVC9C0_PITCH_OUT(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_PITCH_OUT(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_PITCH_OUT, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_DST_BLOCK_SIZE {
    uint32_t width;
    uint32_t height;
    uint32_t depth;
};

static inline void
__NVC9C0_SET_DST_BLOCK_SIZE(uint32_t *val_out, struct nv_nvc9c0_SET_DST_BLOCK_SIZE st)
{
    uint32_t val = 0;
    
    assert(st.width < (1ULL << 4));
    val |= st.width << 0;
    
    assert(st.height < (1ULL << 4));
    val |= st.height << 4;
    
    assert(st.depth < (1ULL << 4));
    val |= st.depth << 8;
    *val_out = val;
}

#define V_NVC9C0_SET_DST_BLOCK_SIZE(val, args...) { \
    UNUSED uint32_t WIDTH_ONE_GOB = NVC9C0_SET_DST_BLOCK_SIZE_WIDTH_ONE_GOB; \
    UNUSED uint32_t HEIGHT_ONE_GOB = NVC9C0_SET_DST_BLOCK_SIZE_HEIGHT_ONE_GOB; \
    UNUSED uint32_t HEIGHT_TWO_GOBS = NVC9C0_SET_DST_BLOCK_SIZE_HEIGHT_TWO_GOBS; \
    UNUSED uint32_t HEIGHT_FOUR_GOBS = NVC9C0_SET_DST_BLOCK_SIZE_HEIGHT_FOUR_GOBS; \
    UNUSED uint32_t HEIGHT_EIGHT_GOBS = NVC9C0_SET_DST_BLOCK_SIZE_HEIGHT_EIGHT_GOBS; \
    UNUSED uint32_t HEIGHT_SIXTEEN_GOBS = NVC9C0_SET_DST_BLOCK_SIZE_HEIGHT_SIXTEEN_GOBS; \
    UNUSED uint32_t HEIGHT_THIRTYTWO_GOBS = NVC9C0_SET_DST_BLOCK_SIZE_HEIGHT_THIRTYTWO_GOBS; \
    UNUSED uint32_t DEPTH_ONE_GOB = NVC9C0_SET_DST_BLOCK_SIZE_DEPTH_ONE_GOB; \
    UNUSED uint32_t DEPTH_TWO_GOBS = NVC9C0_SET_DST_BLOCK_SIZE_DEPTH_TWO_GOBS; \
    UNUSED uint32_t DEPTH_FOUR_GOBS = NVC9C0_SET_DST_BLOCK_SIZE_DEPTH_FOUR_GOBS; \
    UNUSED uint32_t DEPTH_EIGHT_GOBS = NVC9C0_SET_DST_BLOCK_SIZE_DEPTH_EIGHT_GOBS; \
    UNUSED uint32_t DEPTH_SIXTEEN_GOBS = NVC9C0_SET_DST_BLOCK_SIZE_DEPTH_SIXTEEN_GOBS; \
    UNUSED uint32_t DEPTH_THIRTYTWO_GOBS = NVC9C0_SET_DST_BLOCK_SIZE_DEPTH_THIRTYTWO_GOBS; \
    struct nv_nvc9c0_SET_DST_BLOCK_SIZE __data = args; \
    __NVC9C0_SET_DST_BLOCK_SIZE(&val, __data); \
}

#define VA_NVC9C0_SET_DST_BLOCK_SIZE V_NVC9C0_SET_DST_BLOCK_SIZE

#define P_NVC9C0_SET_DST_BLOCK_SIZE(push, args...) do { \
    UNUSED uint32_t WIDTH_ONE_GOB = NVC9C0_SET_DST_BLOCK_SIZE_WIDTH_ONE_GOB; \
    UNUSED uint32_t HEIGHT_ONE_GOB = NVC9C0_SET_DST_BLOCK_SIZE_HEIGHT_ONE_GOB; \
    UNUSED uint32_t HEIGHT_TWO_GOBS = NVC9C0_SET_DST_BLOCK_SIZE_HEIGHT_TWO_GOBS; \
    UNUSED uint32_t HEIGHT_FOUR_GOBS = NVC9C0_SET_DST_BLOCK_SIZE_HEIGHT_FOUR_GOBS; \
    UNUSED uint32_t HEIGHT_EIGHT_GOBS = NVC9C0_SET_DST_BLOCK_SIZE_HEIGHT_EIGHT_GOBS; \
    UNUSED uint32_t HEIGHT_SIXTEEN_GOBS = NVC9C0_SET_DST_BLOCK_SIZE_HEIGHT_SIXTEEN_GOBS; \
    UNUSED uint32_t HEIGHT_THIRTYTWO_GOBS = NVC9C0_SET_DST_BLOCK_SIZE_HEIGHT_THIRTYTWO_GOBS; \
    UNUSED uint32_t DEPTH_ONE_GOB = NVC9C0_SET_DST_BLOCK_SIZE_DEPTH_ONE_GOB; \
    UNUSED uint32_t DEPTH_TWO_GOBS = NVC9C0_SET_DST_BLOCK_SIZE_DEPTH_TWO_GOBS; \
    UNUSED uint32_t DEPTH_FOUR_GOBS = NVC9C0_SET_DST_BLOCK_SIZE_DEPTH_FOUR_GOBS; \
    UNUSED uint32_t DEPTH_EIGHT_GOBS = NVC9C0_SET_DST_BLOCK_SIZE_DEPTH_EIGHT_GOBS; \
    UNUSED uint32_t DEPTH_SIXTEEN_GOBS = NVC9C0_SET_DST_BLOCK_SIZE_DEPTH_SIXTEEN_GOBS; \
    UNUSED uint32_t DEPTH_THIRTYTWO_GOBS = NVC9C0_SET_DST_BLOCK_SIZE_DEPTH_THIRTYTWO_GOBS; \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_DST_BLOCK_SIZE(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_DST_BLOCK_SIZE, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_DST_WIDTH {
    uint32_t v;
};

static inline void
__NVC9C0_SET_DST_WIDTH(uint32_t *val_out, struct nv_nvc9c0_SET_DST_WIDTH st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_SET_DST_WIDTH(val, args...) { \
    struct nv_nvc9c0_SET_DST_WIDTH __data = { .v = (args) }; \
    __NVC9C0_SET_DST_WIDTH(&val, __data); \
}

#define VA_NVC9C0_SET_DST_WIDTH V_NVC9C0_SET_DST_WIDTH

#define P_NVC9C0_SET_DST_WIDTH(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_DST_WIDTH(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_DST_WIDTH, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_DST_HEIGHT {
    uint32_t v;
};

static inline void
__NVC9C0_SET_DST_HEIGHT(uint32_t *val_out, struct nv_nvc9c0_SET_DST_HEIGHT st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_SET_DST_HEIGHT(val, args...) { \
    struct nv_nvc9c0_SET_DST_HEIGHT __data = { .v = (args) }; \
    __NVC9C0_SET_DST_HEIGHT(&val, __data); \
}

#define VA_NVC9C0_SET_DST_HEIGHT V_NVC9C0_SET_DST_HEIGHT

#define P_NVC9C0_SET_DST_HEIGHT(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_DST_HEIGHT(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_DST_HEIGHT, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_DST_DEPTH {
    uint32_t v;
};

static inline void
__NVC9C0_SET_DST_DEPTH(uint32_t *val_out, struct nv_nvc9c0_SET_DST_DEPTH st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_SET_DST_DEPTH(val, args...) { \
    struct nv_nvc9c0_SET_DST_DEPTH __data = { .v = (args) }; \
    __NVC9C0_SET_DST_DEPTH(&val, __data); \
}

#define VA_NVC9C0_SET_DST_DEPTH V_NVC9C0_SET_DST_DEPTH

#define P_NVC9C0_SET_DST_DEPTH(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_DST_DEPTH(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_DST_DEPTH, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_DST_LAYER {
    uint32_t v;
};

static inline void
__NVC9C0_SET_DST_LAYER(uint32_t *val_out, struct nv_nvc9c0_SET_DST_LAYER st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_SET_DST_LAYER(val, args...) { \
    struct nv_nvc9c0_SET_DST_LAYER __data = { .v = (args) }; \
    __NVC9C0_SET_DST_LAYER(&val, __data); \
}

#define VA_NVC9C0_SET_DST_LAYER V_NVC9C0_SET_DST_LAYER

#define P_NVC9C0_SET_DST_LAYER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_DST_LAYER(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_DST_LAYER, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_DST_ORIGIN_BYTES_X {
    uint32_t v;
};

static inline void
__NVC9C0_SET_DST_ORIGIN_BYTES_X(uint32_t *val_out, struct nv_nvc9c0_SET_DST_ORIGIN_BYTES_X st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 21));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVC9C0_SET_DST_ORIGIN_BYTES_X(val, args...) { \
    struct nv_nvc9c0_SET_DST_ORIGIN_BYTES_X __data = { .v = (args) }; \
    __NVC9C0_SET_DST_ORIGIN_BYTES_X(&val, __data); \
}

#define VA_NVC9C0_SET_DST_ORIGIN_BYTES_X V_NVC9C0_SET_DST_ORIGIN_BYTES_X

#define P_NVC9C0_SET_DST_ORIGIN_BYTES_X(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_DST_ORIGIN_BYTES_X(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_DST_ORIGIN_BYTES_X, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_DST_ORIGIN_SAMPLES_Y {
    uint32_t v;
};

static inline void
__NVC9C0_SET_DST_ORIGIN_SAMPLES_Y(uint32_t *val_out, struct nv_nvc9c0_SET_DST_ORIGIN_SAMPLES_Y st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 17));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVC9C0_SET_DST_ORIGIN_SAMPLES_Y(val, args...) { \
    struct nv_nvc9c0_SET_DST_ORIGIN_SAMPLES_Y __data = { .v = (args) }; \
    __NVC9C0_SET_DST_ORIGIN_SAMPLES_Y(&val, __data); \
}

#define VA_NVC9C0_SET_DST_ORIGIN_SAMPLES_Y V_NVC9C0_SET_DST_ORIGIN_SAMPLES_Y

#define P_NVC9C0_SET_DST_ORIGIN_SAMPLES_Y(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_DST_ORIGIN_SAMPLES_Y(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_DST_ORIGIN_SAMPLES_Y, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_LAUNCH_DMA {
    uint32_t dst_memory_layout;
    uint32_t completion_type;
    uint32_t interrupt_type;
    uint32_t semaphore_struct_size;
    uint32_t reduction_enable;
    uint32_t reduction_op;
    uint32_t reduction_format;
    uint32_t sysmembar_disable;
};

static inline void
__NVC9C0_LAUNCH_DMA(uint32_t *val_out, struct nv_nvc9c0_LAUNCH_DMA st)
{
    uint32_t val = 0;
    
    assert(st.dst_memory_layout < (1ULL << 1));
    val |= st.dst_memory_layout << 0;
    
    assert(st.completion_type < (1ULL << 2));
    val |= st.completion_type << 4;
    
    assert(st.interrupt_type < (1ULL << 2));
    val |= st.interrupt_type << 8;
    
    assert(st.semaphore_struct_size < (1ULL << 1));
    val |= st.semaphore_struct_size << 12;
    
    assert(st.reduction_enable < (1ULL << 1));
    val |= st.reduction_enable << 1;
    
    assert(st.reduction_op < (1ULL << 3));
    val |= st.reduction_op << 13;
    
    assert(st.reduction_format < (1ULL << 2));
    val |= st.reduction_format << 2;
    
    assert(st.sysmembar_disable < (1ULL << 1));
    val |= st.sysmembar_disable << 6;
    *val_out = val;
}

#define V_NVC9C0_LAUNCH_DMA(val, args...) { \
    UNUSED uint32_t DST_MEMORY_LAYOUT_BLOCKLINEAR = NVC9C0_LAUNCH_DMA_DST_MEMORY_LAYOUT_BLOCKLINEAR; \
    UNUSED uint32_t DST_MEMORY_LAYOUT_PITCH = NVC9C0_LAUNCH_DMA_DST_MEMORY_LAYOUT_PITCH; \
    UNUSED uint32_t COMPLETION_TYPE_FLUSH_DISABLE = NVC9C0_LAUNCH_DMA_COMPLETION_TYPE_FLUSH_DISABLE; \
    UNUSED uint32_t COMPLETION_TYPE_FLUSH_ONLY = NVC9C0_LAUNCH_DMA_COMPLETION_TYPE_FLUSH_ONLY; \
    UNUSED uint32_t COMPLETION_TYPE_RELEASE_SEMAPHORE = NVC9C0_LAUNCH_DMA_COMPLETION_TYPE_RELEASE_SEMAPHORE; \
    UNUSED uint32_t INTERRUPT_TYPE_NONE = NVC9C0_LAUNCH_DMA_INTERRUPT_TYPE_NONE; \
    UNUSED uint32_t INTERRUPT_TYPE_INTERRUPT = NVC9C0_LAUNCH_DMA_INTERRUPT_TYPE_INTERRUPT; \
    UNUSED uint32_t SEMAPHORE_STRUCT_SIZE_FOUR_WORDS = NVC9C0_LAUNCH_DMA_SEMAPHORE_STRUCT_SIZE_FOUR_WORDS; \
    UNUSED uint32_t SEMAPHORE_STRUCT_SIZE_ONE_WORD = NVC9C0_LAUNCH_DMA_SEMAPHORE_STRUCT_SIZE_ONE_WORD; \
    UNUSED uint32_t REDUCTION_ENABLE_FALSE = NVC9C0_LAUNCH_DMA_REDUCTION_ENABLE_FALSE; \
    UNUSED uint32_t REDUCTION_ENABLE_TRUE = NVC9C0_LAUNCH_DMA_REDUCTION_ENABLE_TRUE; \
    UNUSED uint32_t REDUCTION_OP_RED_ADD = NVC9C0_LAUNCH_DMA_REDUCTION_OP_RED_ADD; \
    UNUSED uint32_t REDUCTION_OP_RED_MIN = NVC9C0_LAUNCH_DMA_REDUCTION_OP_RED_MIN; \
    UNUSED uint32_t REDUCTION_OP_RED_MAX = NVC9C0_LAUNCH_DMA_REDUCTION_OP_RED_MAX; \
    UNUSED uint32_t REDUCTION_OP_RED_INC = NVC9C0_LAUNCH_DMA_REDUCTION_OP_RED_INC; \
    UNUSED uint32_t REDUCTION_OP_RED_DEC = NVC9C0_LAUNCH_DMA_REDUCTION_OP_RED_DEC; \
    UNUSED uint32_t REDUCTION_OP_RED_AND = NVC9C0_LAUNCH_DMA_REDUCTION_OP_RED_AND; \
    UNUSED uint32_t REDUCTION_OP_RED_OR = NVC9C0_LAUNCH_DMA_REDUCTION_OP_RED_OR; \
    UNUSED uint32_t REDUCTION_OP_RED_XOR = NVC9C0_LAUNCH_DMA_REDUCTION_OP_RED_XOR; \
    UNUSED uint32_t REDUCTION_FORMAT_UNSIGNED_32 = NVC9C0_LAUNCH_DMA_REDUCTION_FORMAT_UNSIGNED_32; \
    UNUSED uint32_t REDUCTION_FORMAT_SIGNED_32 = NVC9C0_LAUNCH_DMA_REDUCTION_FORMAT_SIGNED_32; \
    UNUSED uint32_t SYSMEMBAR_DISABLE_FALSE = NVC9C0_LAUNCH_DMA_SYSMEMBAR_DISABLE_FALSE; \
    UNUSED uint32_t SYSMEMBAR_DISABLE_TRUE = NVC9C0_LAUNCH_DMA_SYSMEMBAR_DISABLE_TRUE; \
    struct nv_nvc9c0_LAUNCH_DMA __data = args; \
    __NVC9C0_LAUNCH_DMA(&val, __data); \
}

#define VA_NVC9C0_LAUNCH_DMA V_NVC9C0_LAUNCH_DMA

#define P_NVC9C0_LAUNCH_DMA(push, args...) do { \
    UNUSED uint32_t DST_MEMORY_LAYOUT_BLOCKLINEAR = NVC9C0_LAUNCH_DMA_DST_MEMORY_LAYOUT_BLOCKLINEAR; \
    UNUSED uint32_t DST_MEMORY_LAYOUT_PITCH = NVC9C0_LAUNCH_DMA_DST_MEMORY_LAYOUT_PITCH; \
    UNUSED uint32_t COMPLETION_TYPE_FLUSH_DISABLE = NVC9C0_LAUNCH_DMA_COMPLETION_TYPE_FLUSH_DISABLE; \
    UNUSED uint32_t COMPLETION_TYPE_FLUSH_ONLY = NVC9C0_LAUNCH_DMA_COMPLETION_TYPE_FLUSH_ONLY; \
    UNUSED uint32_t COMPLETION_TYPE_RELEASE_SEMAPHORE = NVC9C0_LAUNCH_DMA_COMPLETION_TYPE_RELEASE_SEMAPHORE; \
    UNUSED uint32_t INTERRUPT_TYPE_NONE = NVC9C0_LAUNCH_DMA_INTERRUPT_TYPE_NONE; \
    UNUSED uint32_t INTERRUPT_TYPE_INTERRUPT = NVC9C0_LAUNCH_DMA_INTERRUPT_TYPE_INTERRUPT; \
    UNUSED uint32_t SEMAPHORE_STRUCT_SIZE_FOUR_WORDS = NVC9C0_LAUNCH_DMA_SEMAPHORE_STRUCT_SIZE_FOUR_WORDS; \
    UNUSED uint32_t SEMAPHORE_STRUCT_SIZE_ONE_WORD = NVC9C0_LAUNCH_DMA_SEMAPHORE_STRUCT_SIZE_ONE_WORD; \
    UNUSED uint32_t REDUCTION_ENABLE_FALSE = NVC9C0_LAUNCH_DMA_REDUCTION_ENABLE_FALSE; \
    UNUSED uint32_t REDUCTION_ENABLE_TRUE = NVC9C0_LAUNCH_DMA_REDUCTION_ENABLE_TRUE; \
    UNUSED uint32_t REDUCTION_OP_RED_ADD = NVC9C0_LAUNCH_DMA_REDUCTION_OP_RED_ADD; \
    UNUSED uint32_t REDUCTION_OP_RED_MIN = NVC9C0_LAUNCH_DMA_REDUCTION_OP_RED_MIN; \
    UNUSED uint32_t REDUCTION_OP_RED_MAX = NVC9C0_LAUNCH_DMA_REDUCTION_OP_RED_MAX; \
    UNUSED uint32_t REDUCTION_OP_RED_INC = NVC9C0_LAUNCH_DMA_REDUCTION_OP_RED_INC; \
    UNUSED uint32_t REDUCTION_OP_RED_DEC = NVC9C0_LAUNCH_DMA_REDUCTION_OP_RED_DEC; \
    UNUSED uint32_t REDUCTION_OP_RED_AND = NVC9C0_LAUNCH_DMA_REDUCTION_OP_RED_AND; \
    UNUSED uint32_t REDUCTION_OP_RED_OR = NVC9C0_LAUNCH_DMA_REDUCTION_OP_RED_OR; \
    UNUSED uint32_t REDUCTION_OP_RED_XOR = NVC9C0_LAUNCH_DMA_REDUCTION_OP_RED_XOR; \
    UNUSED uint32_t REDUCTION_FORMAT_UNSIGNED_32 = NVC9C0_LAUNCH_DMA_REDUCTION_FORMAT_UNSIGNED_32; \
    UNUSED uint32_t REDUCTION_FORMAT_SIGNED_32 = NVC9C0_LAUNCH_DMA_REDUCTION_FORMAT_SIGNED_32; \
    UNUSED uint32_t SYSMEMBAR_DISABLE_FALSE = NVC9C0_LAUNCH_DMA_SYSMEMBAR_DISABLE_FALSE; \
    UNUSED uint32_t SYSMEMBAR_DISABLE_TRUE = NVC9C0_LAUNCH_DMA_SYSMEMBAR_DISABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVC9C0_LAUNCH_DMA(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_LAUNCH_DMA, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_LOAD_INLINE_DATA {
    uint32_t v;
};

static inline void
__NVC9C0_LOAD_INLINE_DATA(uint32_t *val_out, struct nv_nvc9c0_LOAD_INLINE_DATA st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_LOAD_INLINE_DATA(val, args...) { \
    struct nv_nvc9c0_LOAD_INLINE_DATA __data = { .v = (args) }; \
    __NVC9C0_LOAD_INLINE_DATA(&val, __data); \
}

#define VA_NVC9C0_LOAD_INLINE_DATA V_NVC9C0_LOAD_INLINE_DATA

#define P_NVC9C0_LOAD_INLINE_DATA(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_LOAD_INLINE_DATA(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_LOAD_INLINE_DATA, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_I2M_SEMAPHORE_A {
    uint32_t offset_upper;
};

static inline void
__NVC9C0_SET_I2M_SEMAPHORE_A(uint32_t *val_out, struct nv_nvc9c0_SET_I2M_SEMAPHORE_A st)
{
    uint32_t val = 0;
    
    assert(st.offset_upper < (1ULL << 8));
    val |= st.offset_upper << 0;
    *val_out = val;
}

#define V_NVC9C0_SET_I2M_SEMAPHORE_A(val, args...) { \
    struct nv_nvc9c0_SET_I2M_SEMAPHORE_A __data = { .offset_upper = (args) }; \
    __NVC9C0_SET_I2M_SEMAPHORE_A(&val, __data); \
}

#define VA_NVC9C0_SET_I2M_SEMAPHORE_A V_NVC9C0_SET_I2M_SEMAPHORE_A

#define P_NVC9C0_SET_I2M_SEMAPHORE_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_I2M_SEMAPHORE_A(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_I2M_SEMAPHORE_A, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_I2M_SEMAPHORE_B {
    uint32_t offset_lower;
};

static inline void
__NVC9C0_SET_I2M_SEMAPHORE_B(uint32_t *val_out, struct nv_nvc9c0_SET_I2M_SEMAPHORE_B st)
{
    uint32_t val = 0;
    
    val |= st.offset_lower;
    *val_out = val;
}

#define V_NVC9C0_SET_I2M_SEMAPHORE_B(val, args...) { \
    struct nv_nvc9c0_SET_I2M_SEMAPHORE_B __data = { .offset_lower = (args) }; \
    __NVC9C0_SET_I2M_SEMAPHORE_B(&val, __data); \
}

#define VA_NVC9C0_SET_I2M_SEMAPHORE_B V_NVC9C0_SET_I2M_SEMAPHORE_B

#define P_NVC9C0_SET_I2M_SEMAPHORE_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_I2M_SEMAPHORE_B(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_I2M_SEMAPHORE_B, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_I2M_SEMAPHORE_C {
    uint32_t payload;
};

static inline void
__NVC9C0_SET_I2M_SEMAPHORE_C(uint32_t *val_out, struct nv_nvc9c0_SET_I2M_SEMAPHORE_C st)
{
    uint32_t val = 0;
    
    val |= st.payload;
    *val_out = val;
}

#define V_NVC9C0_SET_I2M_SEMAPHORE_C(val, args...) { \
    struct nv_nvc9c0_SET_I2M_SEMAPHORE_C __data = { .payload = (args) }; \
    __NVC9C0_SET_I2M_SEMAPHORE_C(&val, __data); \
}

#define VA_NVC9C0_SET_I2M_SEMAPHORE_C V_NVC9C0_SET_I2M_SEMAPHORE_C

#define P_NVC9C0_SET_I2M_SEMAPHORE_C(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_I2M_SEMAPHORE_C(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_I2M_SEMAPHORE_C, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_SM_SCG_CONTROL {
    uint32_t compute_in_graphics;
};

static inline void
__NVC9C0_SET_SM_SCG_CONTROL(uint32_t *val_out, struct nv_nvc9c0_SET_SM_SCG_CONTROL st)
{
    uint32_t val = 0;
    
    assert(st.compute_in_graphics < (1ULL << 1));
    val |= st.compute_in_graphics << 0;
    *val_out = val;
}

#define V_NVC9C0_SET_SM_SCG_CONTROL(val, args...) { \
    UNUSED uint32_t COMPUTE_IN_GRAPHICS_FALSE = NVC9C0_SET_SM_SCG_CONTROL_COMPUTE_IN_GRAPHICS_FALSE; \
    UNUSED uint32_t COMPUTE_IN_GRAPHICS_TRUE = NVC9C0_SET_SM_SCG_CONTROL_COMPUTE_IN_GRAPHICS_TRUE; \
    struct nv_nvc9c0_SET_SM_SCG_CONTROL __data = { .compute_in_graphics = (args) }; \
    __NVC9C0_SET_SM_SCG_CONTROL(&val, __data); \
}

#define VA_NVC9C0_SET_SM_SCG_CONTROL V_NVC9C0_SET_SM_SCG_CONTROL

#define P_NVC9C0_SET_SM_SCG_CONTROL(push, args...) do { \
    UNUSED uint32_t COMPUTE_IN_GRAPHICS_FALSE = NVC9C0_SET_SM_SCG_CONTROL_COMPUTE_IN_GRAPHICS_FALSE; \
    UNUSED uint32_t COMPUTE_IN_GRAPHICS_TRUE = NVC9C0_SET_SM_SCG_CONTROL_COMPUTE_IN_GRAPHICS_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_SM_SCG_CONTROL(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_SM_SCG_CONTROL, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_MME_SWITCH_STATE {
    uint32_t valid;
    uint32_t save_macro;
    uint32_t restore_macro;
};

static inline void
__NVC9C0_SET_MME_SWITCH_STATE(uint32_t *val_out, struct nv_nvc9c0_SET_MME_SWITCH_STATE st)
{
    uint32_t val = 0;
    
    assert(st.valid < (1ULL << 1));
    val |= st.valid << 0;
    
    assert(st.save_macro < (1ULL << 8));
    val |= st.save_macro << 4;
    
    assert(st.restore_macro < (1ULL << 8));
    val |= st.restore_macro << 12;
    *val_out = val;
}

#define V_NVC9C0_SET_MME_SWITCH_STATE(val, args...) { \
    UNUSED uint32_t VALID_FALSE = NVC9C0_SET_MME_SWITCH_STATE_VALID_FALSE; \
    UNUSED uint32_t VALID_TRUE = NVC9C0_SET_MME_SWITCH_STATE_VALID_TRUE; \
    struct nv_nvc9c0_SET_MME_SWITCH_STATE __data = args; \
    __NVC9C0_SET_MME_SWITCH_STATE(&val, __data); \
}

#define VA_NVC9C0_SET_MME_SWITCH_STATE V_NVC9C0_SET_MME_SWITCH_STATE

#define P_NVC9C0_SET_MME_SWITCH_STATE(push, args...) do { \
    UNUSED uint32_t VALID_FALSE = NVC9C0_SET_MME_SWITCH_STATE_VALID_FALSE; \
    UNUSED uint32_t VALID_TRUE = NVC9C0_SET_MME_SWITCH_STATE_VALID_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_MME_SWITCH_STATE(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_MME_SWITCH_STATE, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_I2M_SPARE_NOOP00 {
    uint32_t v;
};

static inline void
__NVC9C0_SET_I2M_SPARE_NOOP00(uint32_t *val_out, struct nv_nvc9c0_SET_I2M_SPARE_NOOP00 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_SET_I2M_SPARE_NOOP00(val, args...) { \
    struct nv_nvc9c0_SET_I2M_SPARE_NOOP00 __data = { .v = (args) }; \
    __NVC9C0_SET_I2M_SPARE_NOOP00(&val, __data); \
}

#define VA_NVC9C0_SET_I2M_SPARE_NOOP00 V_NVC9C0_SET_I2M_SPARE_NOOP00

#define P_NVC9C0_SET_I2M_SPARE_NOOP00(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_I2M_SPARE_NOOP00(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_I2M_SPARE_NOOP00, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_I2M_SPARE_NOOP01 {
    uint32_t v;
};

static inline void
__NVC9C0_SET_I2M_SPARE_NOOP01(uint32_t *val_out, struct nv_nvc9c0_SET_I2M_SPARE_NOOP01 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_SET_I2M_SPARE_NOOP01(val, args...) { \
    struct nv_nvc9c0_SET_I2M_SPARE_NOOP01 __data = { .v = (args) }; \
    __NVC9C0_SET_I2M_SPARE_NOOP01(&val, __data); \
}

#define VA_NVC9C0_SET_I2M_SPARE_NOOP01 V_NVC9C0_SET_I2M_SPARE_NOOP01

#define P_NVC9C0_SET_I2M_SPARE_NOOP01(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_I2M_SPARE_NOOP01(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_I2M_SPARE_NOOP01, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_I2M_SPARE_NOOP02 {
    uint32_t v;
};

static inline void
__NVC9C0_SET_I2M_SPARE_NOOP02(uint32_t *val_out, struct nv_nvc9c0_SET_I2M_SPARE_NOOP02 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_SET_I2M_SPARE_NOOP02(val, args...) { \
    struct nv_nvc9c0_SET_I2M_SPARE_NOOP02 __data = { .v = (args) }; \
    __NVC9C0_SET_I2M_SPARE_NOOP02(&val, __data); \
}

#define VA_NVC9C0_SET_I2M_SPARE_NOOP02 V_NVC9C0_SET_I2M_SPARE_NOOP02

#define P_NVC9C0_SET_I2M_SPARE_NOOP02(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_I2M_SPARE_NOOP02(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_I2M_SPARE_NOOP02, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_I2M_SPARE_NOOP03 {
    uint32_t v;
};

static inline void
__NVC9C0_SET_I2M_SPARE_NOOP03(uint32_t *val_out, struct nv_nvc9c0_SET_I2M_SPARE_NOOP03 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_SET_I2M_SPARE_NOOP03(val, args...) { \
    struct nv_nvc9c0_SET_I2M_SPARE_NOOP03 __data = { .v = (args) }; \
    __NVC9C0_SET_I2M_SPARE_NOOP03(&val, __data); \
}

#define VA_NVC9C0_SET_I2M_SPARE_NOOP03 V_NVC9C0_SET_I2M_SPARE_NOOP03

#define P_NVC9C0_SET_I2M_SPARE_NOOP03(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_I2M_SPARE_NOOP03(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_I2M_SPARE_NOOP03, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_VALID_SPAN_OVERFLOW_AREA_A {
    uint32_t address_upper;
};

static inline void
__NVC9C0_SET_VALID_SPAN_OVERFLOW_AREA_A(uint32_t *val_out, struct nv_nvc9c0_SET_VALID_SPAN_OVERFLOW_AREA_A st)
{
    uint32_t val = 0;
    
    assert(st.address_upper < (1ULL << 8));
    val |= st.address_upper << 0;
    *val_out = val;
}

#define V_NVC9C0_SET_VALID_SPAN_OVERFLOW_AREA_A(val, args...) { \
    struct nv_nvc9c0_SET_VALID_SPAN_OVERFLOW_AREA_A __data = { .address_upper = (args) }; \
    __NVC9C0_SET_VALID_SPAN_OVERFLOW_AREA_A(&val, __data); \
}

#define VA_NVC9C0_SET_VALID_SPAN_OVERFLOW_AREA_A V_NVC9C0_SET_VALID_SPAN_OVERFLOW_AREA_A

#define P_NVC9C0_SET_VALID_SPAN_OVERFLOW_AREA_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_VALID_SPAN_OVERFLOW_AREA_A(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_VALID_SPAN_OVERFLOW_AREA_A, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_VALID_SPAN_OVERFLOW_AREA_B {
    uint32_t address_lower;
};

static inline void
__NVC9C0_SET_VALID_SPAN_OVERFLOW_AREA_B(uint32_t *val_out, struct nv_nvc9c0_SET_VALID_SPAN_OVERFLOW_AREA_B st)
{
    uint32_t val = 0;
    
    val |= st.address_lower;
    *val_out = val;
}

#define V_NVC9C0_SET_VALID_SPAN_OVERFLOW_AREA_B(val, args...) { \
    struct nv_nvc9c0_SET_VALID_SPAN_OVERFLOW_AREA_B __data = { .address_lower = (args) }; \
    __NVC9C0_SET_VALID_SPAN_OVERFLOW_AREA_B(&val, __data); \
}

#define VA_NVC9C0_SET_VALID_SPAN_OVERFLOW_AREA_B V_NVC9C0_SET_VALID_SPAN_OVERFLOW_AREA_B

#define P_NVC9C0_SET_VALID_SPAN_OVERFLOW_AREA_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_VALID_SPAN_OVERFLOW_AREA_B(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_VALID_SPAN_OVERFLOW_AREA_B, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_VALID_SPAN_OVERFLOW_AREA_C {
    uint32_t size;
};

static inline void
__NVC9C0_SET_VALID_SPAN_OVERFLOW_AREA_C(uint32_t *val_out, struct nv_nvc9c0_SET_VALID_SPAN_OVERFLOW_AREA_C st)
{
    uint32_t val = 0;
    
    val |= st.size;
    *val_out = val;
}

#define V_NVC9C0_SET_VALID_SPAN_OVERFLOW_AREA_C(val, args...) { \
    struct nv_nvc9c0_SET_VALID_SPAN_OVERFLOW_AREA_C __data = { .size = (args) }; \
    __NVC9C0_SET_VALID_SPAN_OVERFLOW_AREA_C(&val, __data); \
}

#define VA_NVC9C0_SET_VALID_SPAN_OVERFLOW_AREA_C V_NVC9C0_SET_VALID_SPAN_OVERFLOW_AREA_C

#define P_NVC9C0_SET_VALID_SPAN_OVERFLOW_AREA_C(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_VALID_SPAN_OVERFLOW_AREA_C(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_VALID_SPAN_OVERFLOW_AREA_C, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_PERFMON_TRANSFER {
    uint32_t v;
};

static inline void
__NVC9C0_PERFMON_TRANSFER(uint32_t *val_out, struct nv_nvc9c0_PERFMON_TRANSFER st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_PERFMON_TRANSFER(val, args...) { \
    struct nv_nvc9c0_PERFMON_TRANSFER __data = { .v = (args) }; \
    __NVC9C0_PERFMON_TRANSFER(&val, __data); \
}

#define VA_NVC9C0_PERFMON_TRANSFER V_NVC9C0_PERFMON_TRANSFER

#define P_NVC9C0_PERFMON_TRANSFER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_PERFMON_TRANSFER(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_PERFMON_TRANSFER, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_QMD_VIRTUALIZATION_BASE_A {
    uint32_t address_upper;
};

static inline void
__NVC9C0_SET_QMD_VIRTUALIZATION_BASE_A(uint32_t *val_out, struct nv_nvc9c0_SET_QMD_VIRTUALIZATION_BASE_A st)
{
    uint32_t val = 0;
    
    assert(st.address_upper < (1ULL << 8));
    val |= st.address_upper << 0;
    *val_out = val;
}

#define V_NVC9C0_SET_QMD_VIRTUALIZATION_BASE_A(val, args...) { \
    struct nv_nvc9c0_SET_QMD_VIRTUALIZATION_BASE_A __data = { .address_upper = (args) }; \
    __NVC9C0_SET_QMD_VIRTUALIZATION_BASE_A(&val, __data); \
}

#define VA_NVC9C0_SET_QMD_VIRTUALIZATION_BASE_A V_NVC9C0_SET_QMD_VIRTUALIZATION_BASE_A

#define P_NVC9C0_SET_QMD_VIRTUALIZATION_BASE_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_QMD_VIRTUALIZATION_BASE_A(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_QMD_VIRTUALIZATION_BASE_A, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_QMD_VIRTUALIZATION_BASE_B {
    uint32_t address_lower;
};

static inline void
__NVC9C0_SET_QMD_VIRTUALIZATION_BASE_B(uint32_t *val_out, struct nv_nvc9c0_SET_QMD_VIRTUALIZATION_BASE_B st)
{
    uint32_t val = 0;
    
    val |= st.address_lower;
    *val_out = val;
}

#define V_NVC9C0_SET_QMD_VIRTUALIZATION_BASE_B(val, args...) { \
    struct nv_nvc9c0_SET_QMD_VIRTUALIZATION_BASE_B __data = { .address_lower = (args) }; \
    __NVC9C0_SET_QMD_VIRTUALIZATION_BASE_B(&val, __data); \
}

#define VA_NVC9C0_SET_QMD_VIRTUALIZATION_BASE_B V_NVC9C0_SET_QMD_VIRTUALIZATION_BASE_B

#define P_NVC9C0_SET_QMD_VIRTUALIZATION_BASE_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_QMD_VIRTUALIZATION_BASE_B(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_QMD_VIRTUALIZATION_BASE_B, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_INVALIDATE_SHADER_CACHES {
    uint32_t instruction;
    uint32_t data;
    uint32_t constant;
    uint32_t locks;
    uint32_t flush_data;
};

static inline void
__NVC9C0_INVALIDATE_SHADER_CACHES(uint32_t *val_out, struct nv_nvc9c0_INVALIDATE_SHADER_CACHES st)
{
    uint32_t val = 0;
    
    assert(st.instruction < (1ULL << 1));
    val |= st.instruction << 0;
    
    assert(st.data < (1ULL << 1));
    val |= st.data << 4;
    
    assert(st.constant < (1ULL << 1));
    val |= st.constant << 12;
    
    assert(st.locks < (1ULL << 1));
    val |= st.locks << 1;
    
    assert(st.flush_data < (1ULL << 1));
    val |= st.flush_data << 2;
    *val_out = val;
}

#define V_NVC9C0_INVALIDATE_SHADER_CACHES(val, args...) { \
    UNUSED uint32_t INSTRUCTION_FALSE = NVC9C0_INVALIDATE_SHADER_CACHES_INSTRUCTION_FALSE; \
    UNUSED uint32_t INSTRUCTION_TRUE = NVC9C0_INVALIDATE_SHADER_CACHES_INSTRUCTION_TRUE; \
    UNUSED uint32_t DATA_FALSE = NVC9C0_INVALIDATE_SHADER_CACHES_DATA_FALSE; \
    UNUSED uint32_t DATA_TRUE = NVC9C0_INVALIDATE_SHADER_CACHES_DATA_TRUE; \
    UNUSED uint32_t CONSTANT_FALSE = NVC9C0_INVALIDATE_SHADER_CACHES_CONSTANT_FALSE; \
    UNUSED uint32_t CONSTANT_TRUE = NVC9C0_INVALIDATE_SHADER_CACHES_CONSTANT_TRUE; \
    UNUSED uint32_t LOCKS_FALSE = NVC9C0_INVALIDATE_SHADER_CACHES_LOCKS_FALSE; \
    UNUSED uint32_t LOCKS_TRUE = NVC9C0_INVALIDATE_SHADER_CACHES_LOCKS_TRUE; \
    UNUSED uint32_t FLUSH_DATA_FALSE = NVC9C0_INVALIDATE_SHADER_CACHES_FLUSH_DATA_FALSE; \
    UNUSED uint32_t FLUSH_DATA_TRUE = NVC9C0_INVALIDATE_SHADER_CACHES_FLUSH_DATA_TRUE; \
    struct nv_nvc9c0_INVALIDATE_SHADER_CACHES __data = args; \
    __NVC9C0_INVALIDATE_SHADER_CACHES(&val, __data); \
}

#define VA_NVC9C0_INVALIDATE_SHADER_CACHES V_NVC9C0_INVALIDATE_SHADER_CACHES

#define P_NVC9C0_INVALIDATE_SHADER_CACHES(push, args...) do { \
    UNUSED uint32_t INSTRUCTION_FALSE = NVC9C0_INVALIDATE_SHADER_CACHES_INSTRUCTION_FALSE; \
    UNUSED uint32_t INSTRUCTION_TRUE = NVC9C0_INVALIDATE_SHADER_CACHES_INSTRUCTION_TRUE; \
    UNUSED uint32_t DATA_FALSE = NVC9C0_INVALIDATE_SHADER_CACHES_DATA_FALSE; \
    UNUSED uint32_t DATA_TRUE = NVC9C0_INVALIDATE_SHADER_CACHES_DATA_TRUE; \
    UNUSED uint32_t CONSTANT_FALSE = NVC9C0_INVALIDATE_SHADER_CACHES_CONSTANT_FALSE; \
    UNUSED uint32_t CONSTANT_TRUE = NVC9C0_INVALIDATE_SHADER_CACHES_CONSTANT_TRUE; \
    UNUSED uint32_t LOCKS_FALSE = NVC9C0_INVALIDATE_SHADER_CACHES_LOCKS_FALSE; \
    UNUSED uint32_t LOCKS_TRUE = NVC9C0_INVALIDATE_SHADER_CACHES_LOCKS_TRUE; \
    UNUSED uint32_t FLUSH_DATA_FALSE = NVC9C0_INVALIDATE_SHADER_CACHES_FLUSH_DATA_FALSE; \
    UNUSED uint32_t FLUSH_DATA_TRUE = NVC9C0_INVALIDATE_SHADER_CACHES_FLUSH_DATA_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVC9C0_INVALIDATE_SHADER_CACHES(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_INVALIDATE_SHADER_CACHES, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_RESERVED_SW_METHOD00 {
    uint32_t v;
};

static inline void
__NVC9C0_SET_RESERVED_SW_METHOD00(uint32_t *val_out, struct nv_nvc9c0_SET_RESERVED_SW_METHOD00 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_SET_RESERVED_SW_METHOD00(val, args...) { \
    struct nv_nvc9c0_SET_RESERVED_SW_METHOD00 __data = { .v = (args) }; \
    __NVC9C0_SET_RESERVED_SW_METHOD00(&val, __data); \
}

#define VA_NVC9C0_SET_RESERVED_SW_METHOD00 V_NVC9C0_SET_RESERVED_SW_METHOD00

#define P_NVC9C0_SET_RESERVED_SW_METHOD00(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_RESERVED_SW_METHOD00(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_RESERVED_SW_METHOD00, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_RESERVED_SW_METHOD01 {
    uint32_t v;
};

static inline void
__NVC9C0_SET_RESERVED_SW_METHOD01(uint32_t *val_out, struct nv_nvc9c0_SET_RESERVED_SW_METHOD01 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_SET_RESERVED_SW_METHOD01(val, args...) { \
    struct nv_nvc9c0_SET_RESERVED_SW_METHOD01 __data = { .v = (args) }; \
    __NVC9C0_SET_RESERVED_SW_METHOD01(&val, __data); \
}

#define VA_NVC9C0_SET_RESERVED_SW_METHOD01 V_NVC9C0_SET_RESERVED_SW_METHOD01

#define P_NVC9C0_SET_RESERVED_SW_METHOD01(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_RESERVED_SW_METHOD01(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_RESERVED_SW_METHOD01, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_RESERVED_SW_METHOD02 {
    uint32_t v;
};

static inline void
__NVC9C0_SET_RESERVED_SW_METHOD02(uint32_t *val_out, struct nv_nvc9c0_SET_RESERVED_SW_METHOD02 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_SET_RESERVED_SW_METHOD02(val, args...) { \
    struct nv_nvc9c0_SET_RESERVED_SW_METHOD02 __data = { .v = (args) }; \
    __NVC9C0_SET_RESERVED_SW_METHOD02(&val, __data); \
}

#define VA_NVC9C0_SET_RESERVED_SW_METHOD02 V_NVC9C0_SET_RESERVED_SW_METHOD02

#define P_NVC9C0_SET_RESERVED_SW_METHOD02(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_RESERVED_SW_METHOD02(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_RESERVED_SW_METHOD02, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_RESERVED_SW_METHOD03 {
    uint32_t v;
};

static inline void
__NVC9C0_SET_RESERVED_SW_METHOD03(uint32_t *val_out, struct nv_nvc9c0_SET_RESERVED_SW_METHOD03 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_SET_RESERVED_SW_METHOD03(val, args...) { \
    struct nv_nvc9c0_SET_RESERVED_SW_METHOD03 __data = { .v = (args) }; \
    __NVC9C0_SET_RESERVED_SW_METHOD03(&val, __data); \
}

#define VA_NVC9C0_SET_RESERVED_SW_METHOD03 V_NVC9C0_SET_RESERVED_SW_METHOD03

#define P_NVC9C0_SET_RESERVED_SW_METHOD03(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_RESERVED_SW_METHOD03(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_RESERVED_SW_METHOD03, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_RESERVED_SW_METHOD04 {
    uint32_t v;
};

static inline void
__NVC9C0_SET_RESERVED_SW_METHOD04(uint32_t *val_out, struct nv_nvc9c0_SET_RESERVED_SW_METHOD04 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_SET_RESERVED_SW_METHOD04(val, args...) { \
    struct nv_nvc9c0_SET_RESERVED_SW_METHOD04 __data = { .v = (args) }; \
    __NVC9C0_SET_RESERVED_SW_METHOD04(&val, __data); \
}

#define VA_NVC9C0_SET_RESERVED_SW_METHOD04 V_NVC9C0_SET_RESERVED_SW_METHOD04

#define P_NVC9C0_SET_RESERVED_SW_METHOD04(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_RESERVED_SW_METHOD04(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_RESERVED_SW_METHOD04, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_RESERVED_SW_METHOD05 {
    uint32_t v;
};

static inline void
__NVC9C0_SET_RESERVED_SW_METHOD05(uint32_t *val_out, struct nv_nvc9c0_SET_RESERVED_SW_METHOD05 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_SET_RESERVED_SW_METHOD05(val, args...) { \
    struct nv_nvc9c0_SET_RESERVED_SW_METHOD05 __data = { .v = (args) }; \
    __NVC9C0_SET_RESERVED_SW_METHOD05(&val, __data); \
}

#define VA_NVC9C0_SET_RESERVED_SW_METHOD05 V_NVC9C0_SET_RESERVED_SW_METHOD05

#define P_NVC9C0_SET_RESERVED_SW_METHOD05(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_RESERVED_SW_METHOD05(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_RESERVED_SW_METHOD05, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_RESERVED_SW_METHOD06 {
    uint32_t v;
};

static inline void
__NVC9C0_SET_RESERVED_SW_METHOD06(uint32_t *val_out, struct nv_nvc9c0_SET_RESERVED_SW_METHOD06 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_SET_RESERVED_SW_METHOD06(val, args...) { \
    struct nv_nvc9c0_SET_RESERVED_SW_METHOD06 __data = { .v = (args) }; \
    __NVC9C0_SET_RESERVED_SW_METHOD06(&val, __data); \
}

#define VA_NVC9C0_SET_RESERVED_SW_METHOD06 V_NVC9C0_SET_RESERVED_SW_METHOD06

#define P_NVC9C0_SET_RESERVED_SW_METHOD06(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_RESERVED_SW_METHOD06(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_RESERVED_SW_METHOD06, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_RESERVED_SW_METHOD07 {
    uint32_t v;
};

static inline void
__NVC9C0_SET_RESERVED_SW_METHOD07(uint32_t *val_out, struct nv_nvc9c0_SET_RESERVED_SW_METHOD07 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_SET_RESERVED_SW_METHOD07(val, args...) { \
    struct nv_nvc9c0_SET_RESERVED_SW_METHOD07 __data = { .v = (args) }; \
    __NVC9C0_SET_RESERVED_SW_METHOD07(&val, __data); \
}

#define VA_NVC9C0_SET_RESERVED_SW_METHOD07 V_NVC9C0_SET_RESERVED_SW_METHOD07

#define P_NVC9C0_SET_RESERVED_SW_METHOD07(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_RESERVED_SW_METHOD07(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_RESERVED_SW_METHOD07, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI {
    uint32_t lines;
    uint32_t tag;
};

static inline void
__NVC9C0_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI(uint32_t *val_out, struct nv_nvc9c0_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI st)
{
    uint32_t val = 0;
    
    assert(st.lines < (1ULL << 1));
    val |= st.lines << 0;
    
    assert(st.tag < (1ULL << 22));
    val |= st.tag << 4;
    *val_out = val;
}

#define V_NVC9C0_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI(val, args...) { \
    UNUSED uint32_t LINES_ALL = NVC9C0_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI_LINES_ALL; \
    UNUSED uint32_t LINES_ONE = NVC9C0_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI_LINES_ONE; \
    struct nv_nvc9c0_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI __data = args; \
    __NVC9C0_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI(&val, __data); \
}

#define VA_NVC9C0_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI V_NVC9C0_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI

#define P_NVC9C0_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI(push, args...) do { \
    UNUSED uint32_t LINES_ALL = NVC9C0_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI_LINES_ALL; \
    UNUSED uint32_t LINES_ONE = NVC9C0_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI_LINES_ONE; \
    uint32_t nvk_p_ret; \
    V_NVC9C0_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_CWD_REF_COUNTER {
    uint32_t select;
    uint32_t value;
};

static inline void
__NVC9C0_SET_CWD_REF_COUNTER(uint32_t *val_out, struct nv_nvc9c0_SET_CWD_REF_COUNTER st)
{
    uint32_t val = 0;
    
    assert(st.select < (1ULL << 6));
    val |= st.select << 0;
    
    assert(st.value < (1ULL << 16));
    val |= st.value << 8;
    *val_out = val;
}

#define V_NVC9C0_SET_CWD_REF_COUNTER(val, args...) { \
    struct nv_nvc9c0_SET_CWD_REF_COUNTER __data = args; \
    __NVC9C0_SET_CWD_REF_COUNTER(&val, __data); \
}

#define VA_NVC9C0_SET_CWD_REF_COUNTER V_NVC9C0_SET_CWD_REF_COUNTER

#define P_NVC9C0_SET_CWD_REF_COUNTER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_CWD_REF_COUNTER(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_CWD_REF_COUNTER, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_RESERVED_SW_METHOD08 {
    uint32_t v;
};

static inline void
__NVC9C0_SET_RESERVED_SW_METHOD08(uint32_t *val_out, struct nv_nvc9c0_SET_RESERVED_SW_METHOD08 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_SET_RESERVED_SW_METHOD08(val, args...) { \
    struct nv_nvc9c0_SET_RESERVED_SW_METHOD08 __data = { .v = (args) }; \
    __NVC9C0_SET_RESERVED_SW_METHOD08(&val, __data); \
}

#define VA_NVC9C0_SET_RESERVED_SW_METHOD08 V_NVC9C0_SET_RESERVED_SW_METHOD08

#define P_NVC9C0_SET_RESERVED_SW_METHOD08(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_RESERVED_SW_METHOD08(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_RESERVED_SW_METHOD08, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_RESERVED_SW_METHOD09 {
    uint32_t v;
};

static inline void
__NVC9C0_SET_RESERVED_SW_METHOD09(uint32_t *val_out, struct nv_nvc9c0_SET_RESERVED_SW_METHOD09 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_SET_RESERVED_SW_METHOD09(val, args...) { \
    struct nv_nvc9c0_SET_RESERVED_SW_METHOD09 __data = { .v = (args) }; \
    __NVC9C0_SET_RESERVED_SW_METHOD09(&val, __data); \
}

#define VA_NVC9C0_SET_RESERVED_SW_METHOD09 V_NVC9C0_SET_RESERVED_SW_METHOD09

#define P_NVC9C0_SET_RESERVED_SW_METHOD09(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_RESERVED_SW_METHOD09(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_RESERVED_SW_METHOD09, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_RESERVED_SW_METHOD10 {
    uint32_t v;
};

static inline void
__NVC9C0_SET_RESERVED_SW_METHOD10(uint32_t *val_out, struct nv_nvc9c0_SET_RESERVED_SW_METHOD10 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_SET_RESERVED_SW_METHOD10(val, args...) { \
    struct nv_nvc9c0_SET_RESERVED_SW_METHOD10 __data = { .v = (args) }; \
    __NVC9C0_SET_RESERVED_SW_METHOD10(&val, __data); \
}

#define VA_NVC9C0_SET_RESERVED_SW_METHOD10 V_NVC9C0_SET_RESERVED_SW_METHOD10

#define P_NVC9C0_SET_RESERVED_SW_METHOD10(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_RESERVED_SW_METHOD10(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_RESERVED_SW_METHOD10, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_RESERVED_SW_METHOD11 {
    uint32_t v;
};

static inline void
__NVC9C0_SET_RESERVED_SW_METHOD11(uint32_t *val_out, struct nv_nvc9c0_SET_RESERVED_SW_METHOD11 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_SET_RESERVED_SW_METHOD11(val, args...) { \
    struct nv_nvc9c0_SET_RESERVED_SW_METHOD11 __data = { .v = (args) }; \
    __NVC9C0_SET_RESERVED_SW_METHOD11(&val, __data); \
}

#define VA_NVC9C0_SET_RESERVED_SW_METHOD11 V_NVC9C0_SET_RESERVED_SW_METHOD11

#define P_NVC9C0_SET_RESERVED_SW_METHOD11(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_RESERVED_SW_METHOD11(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_RESERVED_SW_METHOD11, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_RESERVED_SW_METHOD12 {
    uint32_t v;
};

static inline void
__NVC9C0_SET_RESERVED_SW_METHOD12(uint32_t *val_out, struct nv_nvc9c0_SET_RESERVED_SW_METHOD12 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_SET_RESERVED_SW_METHOD12(val, args...) { \
    struct nv_nvc9c0_SET_RESERVED_SW_METHOD12 __data = { .v = (args) }; \
    __NVC9C0_SET_RESERVED_SW_METHOD12(&val, __data); \
}

#define VA_NVC9C0_SET_RESERVED_SW_METHOD12 V_NVC9C0_SET_RESERVED_SW_METHOD12

#define P_NVC9C0_SET_RESERVED_SW_METHOD12(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_RESERVED_SW_METHOD12(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_RESERVED_SW_METHOD12, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_RESERVED_SW_METHOD13 {
    uint32_t v;
};

static inline void
__NVC9C0_SET_RESERVED_SW_METHOD13(uint32_t *val_out, struct nv_nvc9c0_SET_RESERVED_SW_METHOD13 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_SET_RESERVED_SW_METHOD13(val, args...) { \
    struct nv_nvc9c0_SET_RESERVED_SW_METHOD13 __data = { .v = (args) }; \
    __NVC9C0_SET_RESERVED_SW_METHOD13(&val, __data); \
}

#define VA_NVC9C0_SET_RESERVED_SW_METHOD13 V_NVC9C0_SET_RESERVED_SW_METHOD13

#define P_NVC9C0_SET_RESERVED_SW_METHOD13(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_RESERVED_SW_METHOD13(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_RESERVED_SW_METHOD13, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_RESERVED_SW_METHOD14 {
    uint32_t v;
};

static inline void
__NVC9C0_SET_RESERVED_SW_METHOD14(uint32_t *val_out, struct nv_nvc9c0_SET_RESERVED_SW_METHOD14 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_SET_RESERVED_SW_METHOD14(val, args...) { \
    struct nv_nvc9c0_SET_RESERVED_SW_METHOD14 __data = { .v = (args) }; \
    __NVC9C0_SET_RESERVED_SW_METHOD14(&val, __data); \
}

#define VA_NVC9C0_SET_RESERVED_SW_METHOD14 V_NVC9C0_SET_RESERVED_SW_METHOD14

#define P_NVC9C0_SET_RESERVED_SW_METHOD14(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_RESERVED_SW_METHOD14(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_RESERVED_SW_METHOD14, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_RESERVED_SW_METHOD15 {
    uint32_t v;
};

static inline void
__NVC9C0_SET_RESERVED_SW_METHOD15(uint32_t *val_out, struct nv_nvc9c0_SET_RESERVED_SW_METHOD15 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_SET_RESERVED_SW_METHOD15(val, args...) { \
    struct nv_nvc9c0_SET_RESERVED_SW_METHOD15 __data = { .v = (args) }; \
    __NVC9C0_SET_RESERVED_SW_METHOD15(&val, __data); \
}

#define VA_NVC9C0_SET_RESERVED_SW_METHOD15 V_NVC9C0_SET_RESERVED_SW_METHOD15

#define P_NVC9C0_SET_RESERVED_SW_METHOD15(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_RESERVED_SW_METHOD15(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_RESERVED_SW_METHOD15, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_SCG_CONTROL {
    uint32_t compute1_max_sm_count;
    uint32_t compute1_min_sm_count;
    uint32_t disable_compute1_limit_in_all_compute;
};

static inline void
__NVC9C0_SET_SCG_CONTROL(uint32_t *val_out, struct nv_nvc9c0_SET_SCG_CONTROL st)
{
    uint32_t val = 0;
    
    assert(st.compute1_max_sm_count < (1ULL << 9));
    val |= st.compute1_max_sm_count << 0;
    
    assert(st.compute1_min_sm_count < (1ULL << 9));
    val |= st.compute1_min_sm_count << 12;
    
    assert(st.disable_compute1_limit_in_all_compute < (1ULL << 1));
    val |= st.disable_compute1_limit_in_all_compute << 24;
    *val_out = val;
}

#define V_NVC9C0_SET_SCG_CONTROL(val, args...) { \
    UNUSED uint32_t DISABLE_COMPUTE1_LIMIT_IN_ALL_COMPUTE_FALSE = NVC9C0_SET_SCG_CONTROL_DISABLE_COMPUTE1_LIMIT_IN_ALL_COMPUTE_FALSE; \
    UNUSED uint32_t DISABLE_COMPUTE1_LIMIT_IN_ALL_COMPUTE_TRUE = NVC9C0_SET_SCG_CONTROL_DISABLE_COMPUTE1_LIMIT_IN_ALL_COMPUTE_TRUE; \
    struct nv_nvc9c0_SET_SCG_CONTROL __data = args; \
    __NVC9C0_SET_SCG_CONTROL(&val, __data); \
}

#define VA_NVC9C0_SET_SCG_CONTROL V_NVC9C0_SET_SCG_CONTROL

#define P_NVC9C0_SET_SCG_CONTROL(push, args...) do { \
    UNUSED uint32_t DISABLE_COMPUTE1_LIMIT_IN_ALL_COMPUTE_FALSE = NVC9C0_SET_SCG_CONTROL_DISABLE_COMPUTE1_LIMIT_IN_ALL_COMPUTE_FALSE; \
    UNUSED uint32_t DISABLE_COMPUTE1_LIMIT_IN_ALL_COMPUTE_TRUE = NVC9C0_SET_SCG_CONTROL_DISABLE_COMPUTE1_LIMIT_IN_ALL_COMPUTE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_SCG_CONTROL(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_SCG_CONTROL, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_COMPUTE_CLASS_VERSION {
    uint32_t current;
    uint32_t oldest_supported;
};

static inline void
__NVC9C0_SET_COMPUTE_CLASS_VERSION(uint32_t *val_out, struct nv_nvc9c0_SET_COMPUTE_CLASS_VERSION st)
{
    uint32_t val = 0;
    
    assert(st.current < (1ULL << 16));
    val |= st.current << 0;
    
    assert(st.oldest_supported < (1ULL << 16));
    val |= st.oldest_supported << 16;
    *val_out = val;
}

#define V_NVC9C0_SET_COMPUTE_CLASS_VERSION(val, args...) { \
    struct nv_nvc9c0_SET_COMPUTE_CLASS_VERSION __data = args; \
    __NVC9C0_SET_COMPUTE_CLASS_VERSION(&val, __data); \
}

#define VA_NVC9C0_SET_COMPUTE_CLASS_VERSION V_NVC9C0_SET_COMPUTE_CLASS_VERSION

#define P_NVC9C0_SET_COMPUTE_CLASS_VERSION(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_COMPUTE_CLASS_VERSION(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_COMPUTE_CLASS_VERSION, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_CHECK_COMPUTE_CLASS_VERSION {
    uint32_t current;
    uint32_t oldest_supported;
};

static inline void
__NVC9C0_CHECK_COMPUTE_CLASS_VERSION(uint32_t *val_out, struct nv_nvc9c0_CHECK_COMPUTE_CLASS_VERSION st)
{
    uint32_t val = 0;
    
    assert(st.current < (1ULL << 16));
    val |= st.current << 0;
    
    assert(st.oldest_supported < (1ULL << 16));
    val |= st.oldest_supported << 16;
    *val_out = val;
}

#define V_NVC9C0_CHECK_COMPUTE_CLASS_VERSION(val, args...) { \
    struct nv_nvc9c0_CHECK_COMPUTE_CLASS_VERSION __data = args; \
    __NVC9C0_CHECK_COMPUTE_CLASS_VERSION(&val, __data); \
}

#define VA_NVC9C0_CHECK_COMPUTE_CLASS_VERSION V_NVC9C0_CHECK_COMPUTE_CLASS_VERSION

#define P_NVC9C0_CHECK_COMPUTE_CLASS_VERSION(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_CHECK_COMPUTE_CLASS_VERSION(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_CHECK_COMPUTE_CLASS_VERSION, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_QMD_VERSION {
    uint32_t current;
    uint32_t oldest_supported;
};

static inline void
__NVC9C0_SET_QMD_VERSION(uint32_t *val_out, struct nv_nvc9c0_SET_QMD_VERSION st)
{
    uint32_t val = 0;
    
    assert(st.current < (1ULL << 16));
    val |= st.current << 0;
    
    assert(st.oldest_supported < (1ULL << 16));
    val |= st.oldest_supported << 16;
    *val_out = val;
}

#define V_NVC9C0_SET_QMD_VERSION(val, args...) { \
    struct nv_nvc9c0_SET_QMD_VERSION __data = args; \
    __NVC9C0_SET_QMD_VERSION(&val, __data); \
}

#define VA_NVC9C0_SET_QMD_VERSION V_NVC9C0_SET_QMD_VERSION

#define P_NVC9C0_SET_QMD_VERSION(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_QMD_VERSION(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_QMD_VERSION, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_CHECK_QMD_VERSION {
    uint32_t current;
    uint32_t oldest_supported;
};

static inline void
__NVC9C0_CHECK_QMD_VERSION(uint32_t *val_out, struct nv_nvc9c0_CHECK_QMD_VERSION st)
{
    uint32_t val = 0;
    
    assert(st.current < (1ULL << 16));
    val |= st.current << 0;
    
    assert(st.oldest_supported < (1ULL << 16));
    val |= st.oldest_supported << 16;
    *val_out = val;
}

#define V_NVC9C0_CHECK_QMD_VERSION(val, args...) { \
    struct nv_nvc9c0_CHECK_QMD_VERSION __data = args; \
    __NVC9C0_CHECK_QMD_VERSION(&val, __data); \
}

#define VA_NVC9C0_CHECK_QMD_VERSION V_NVC9C0_CHECK_QMD_VERSION

#define P_NVC9C0_CHECK_QMD_VERSION(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_CHECK_QMD_VERSION(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_CHECK_QMD_VERSION, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_INVALIDATE_SKED_CACHES {
    uint32_t v;
};

static inline void
__NVC9C0_INVALIDATE_SKED_CACHES(uint32_t *val_out, struct nv_nvc9c0_INVALIDATE_SKED_CACHES st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 1));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVC9C0_INVALIDATE_SKED_CACHES(val, args...) { \
    struct nv_nvc9c0_INVALIDATE_SKED_CACHES __data = { .v = (args) }; \
    __NVC9C0_INVALIDATE_SKED_CACHES(&val, __data); \
}

#define VA_NVC9C0_INVALIDATE_SKED_CACHES V_NVC9C0_INVALIDATE_SKED_CACHES

#define P_NVC9C0_INVALIDATE_SKED_CACHES(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_INVALIDATE_SKED_CACHES(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_INVALIDATE_SKED_CACHES, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_QMD_VIRTUALIZATION_CONTROL {
    uint32_t constant_buffer_mask;
    uint32_t i2m_addr_enable;
    uint32_t i2m_constant_buffer_enable;
    uint32_t i2m_dependent_enable;
    uint32_t iq2m_addr_enable;
    uint32_t iq2m_constant_buffer_enable;
    uint32_t iq2m_dependent_enable;
    uint32_t send_pcas_enable;
};

static inline void
__NVC9C0_SET_QMD_VIRTUALIZATION_CONTROL(uint32_t *val_out, struct nv_nvc9c0_SET_QMD_VIRTUALIZATION_CONTROL st)
{
    uint32_t val = 0;
    
    assert(st.constant_buffer_mask < (1ULL << 8));
    val |= st.constant_buffer_mask << 0;
    
    assert(st.i2m_addr_enable < (1ULL << 1));
    val |= st.i2m_addr_enable << 8;
    
    assert(st.i2m_constant_buffer_enable < (1ULL << 1));
    val |= st.i2m_constant_buffer_enable << 12;
    
    assert(st.i2m_dependent_enable < (1ULL << 1));
    val |= st.i2m_dependent_enable << 9;
    
    assert(st.iq2m_addr_enable < (1ULL << 1));
    val |= st.iq2m_addr_enable << 16;
    
    assert(st.iq2m_constant_buffer_enable < (1ULL << 1));
    val |= st.iq2m_constant_buffer_enable << 20;
    
    assert(st.iq2m_dependent_enable < (1ULL << 1));
    val |= st.iq2m_dependent_enable << 10;
    
    assert(st.send_pcas_enable < (1ULL << 1));
    val |= st.send_pcas_enable << 24;
    *val_out = val;
}

#define V_NVC9C0_SET_QMD_VIRTUALIZATION_CONTROL(val, args...) { \
    UNUSED uint32_t I2M_ADDR_ENABLE_FALSE = NVC9C0_SET_QMD_VIRTUALIZATION_CONTROL_I2M_ADDR_ENABLE_FALSE; \
    UNUSED uint32_t I2M_ADDR_ENABLE_TRUE = NVC9C0_SET_QMD_VIRTUALIZATION_CONTROL_I2M_ADDR_ENABLE_TRUE; \
    UNUSED uint32_t I2M_CONSTANT_BUFFER_ENABLE_FALSE = NVC9C0_SET_QMD_VIRTUALIZATION_CONTROL_I2M_CONSTANT_BUFFER_ENABLE_FALSE; \
    UNUSED uint32_t I2M_CONSTANT_BUFFER_ENABLE_TRUE = NVC9C0_SET_QMD_VIRTUALIZATION_CONTROL_I2M_CONSTANT_BUFFER_ENABLE_TRUE; \
    UNUSED uint32_t I2M_DEPENDENT_ENABLE_FALSE = NVC9C0_SET_QMD_VIRTUALIZATION_CONTROL_I2M_DEPENDENT_ENABLE_FALSE; \
    UNUSED uint32_t I2M_DEPENDENT_ENABLE_TRUE = NVC9C0_SET_QMD_VIRTUALIZATION_CONTROL_I2M_DEPENDENT_ENABLE_TRUE; \
    UNUSED uint32_t IQ2M_ADDR_ENABLE_FALSE = NVC9C0_SET_QMD_VIRTUALIZATION_CONTROL_IQ2M_ADDR_ENABLE_FALSE; \
    UNUSED uint32_t IQ2M_ADDR_ENABLE_TRUE = NVC9C0_SET_QMD_VIRTUALIZATION_CONTROL_IQ2M_ADDR_ENABLE_TRUE; \
    UNUSED uint32_t IQ2M_CONSTANT_BUFFER_ENABLE_FALSE = NVC9C0_SET_QMD_VIRTUALIZATION_CONTROL_IQ2M_CONSTANT_BUFFER_ENABLE_FALSE; \
    UNUSED uint32_t IQ2M_CONSTANT_BUFFER_ENABLE_TRUE = NVC9C0_SET_QMD_VIRTUALIZATION_CONTROL_IQ2M_CONSTANT_BUFFER_ENABLE_TRUE; \
    UNUSED uint32_t IQ2M_DEPENDENT_ENABLE_FALSE = NVC9C0_SET_QMD_VIRTUALIZATION_CONTROL_IQ2M_DEPENDENT_ENABLE_FALSE; \
    UNUSED uint32_t IQ2M_DEPENDENT_ENABLE_TRUE = NVC9C0_SET_QMD_VIRTUALIZATION_CONTROL_IQ2M_DEPENDENT_ENABLE_TRUE; \
    UNUSED uint32_t SEND_PCAS_ENABLE_FALSE = NVC9C0_SET_QMD_VIRTUALIZATION_CONTROL_SEND_PCAS_ENABLE_FALSE; \
    UNUSED uint32_t SEND_PCAS_ENABLE_TRUE = NVC9C0_SET_QMD_VIRTUALIZATION_CONTROL_SEND_PCAS_ENABLE_TRUE; \
    struct nv_nvc9c0_SET_QMD_VIRTUALIZATION_CONTROL __data = args; \
    __NVC9C0_SET_QMD_VIRTUALIZATION_CONTROL(&val, __data); \
}

#define VA_NVC9C0_SET_QMD_VIRTUALIZATION_CONTROL V_NVC9C0_SET_QMD_VIRTUALIZATION_CONTROL

#define P_NVC9C0_SET_QMD_VIRTUALIZATION_CONTROL(push, args...) do { \
    UNUSED uint32_t I2M_ADDR_ENABLE_FALSE = NVC9C0_SET_QMD_VIRTUALIZATION_CONTROL_I2M_ADDR_ENABLE_FALSE; \
    UNUSED uint32_t I2M_ADDR_ENABLE_TRUE = NVC9C0_SET_QMD_VIRTUALIZATION_CONTROL_I2M_ADDR_ENABLE_TRUE; \
    UNUSED uint32_t I2M_CONSTANT_BUFFER_ENABLE_FALSE = NVC9C0_SET_QMD_VIRTUALIZATION_CONTROL_I2M_CONSTANT_BUFFER_ENABLE_FALSE; \
    UNUSED uint32_t I2M_CONSTANT_BUFFER_ENABLE_TRUE = NVC9C0_SET_QMD_VIRTUALIZATION_CONTROL_I2M_CONSTANT_BUFFER_ENABLE_TRUE; \
    UNUSED uint32_t I2M_DEPENDENT_ENABLE_FALSE = NVC9C0_SET_QMD_VIRTUALIZATION_CONTROL_I2M_DEPENDENT_ENABLE_FALSE; \
    UNUSED uint32_t I2M_DEPENDENT_ENABLE_TRUE = NVC9C0_SET_QMD_VIRTUALIZATION_CONTROL_I2M_DEPENDENT_ENABLE_TRUE; \
    UNUSED uint32_t IQ2M_ADDR_ENABLE_FALSE = NVC9C0_SET_QMD_VIRTUALIZATION_CONTROL_IQ2M_ADDR_ENABLE_FALSE; \
    UNUSED uint32_t IQ2M_ADDR_ENABLE_TRUE = NVC9C0_SET_QMD_VIRTUALIZATION_CONTROL_IQ2M_ADDR_ENABLE_TRUE; \
    UNUSED uint32_t IQ2M_CONSTANT_BUFFER_ENABLE_FALSE = NVC9C0_SET_QMD_VIRTUALIZATION_CONTROL_IQ2M_CONSTANT_BUFFER_ENABLE_FALSE; \
    UNUSED uint32_t IQ2M_CONSTANT_BUFFER_ENABLE_TRUE = NVC9C0_SET_QMD_VIRTUALIZATION_CONTROL_IQ2M_CONSTANT_BUFFER_ENABLE_TRUE; \
    UNUSED uint32_t IQ2M_DEPENDENT_ENABLE_FALSE = NVC9C0_SET_QMD_VIRTUALIZATION_CONTROL_IQ2M_DEPENDENT_ENABLE_FALSE; \
    UNUSED uint32_t IQ2M_DEPENDENT_ENABLE_TRUE = NVC9C0_SET_QMD_VIRTUALIZATION_CONTROL_IQ2M_DEPENDENT_ENABLE_TRUE; \
    UNUSED uint32_t SEND_PCAS_ENABLE_FALSE = NVC9C0_SET_QMD_VIRTUALIZATION_CONTROL_SEND_PCAS_ENABLE_FALSE; \
    UNUSED uint32_t SEND_PCAS_ENABLE_TRUE = NVC9C0_SET_QMD_VIRTUALIZATION_CONTROL_SEND_PCAS_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_QMD_VIRTUALIZATION_CONTROL(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_QMD_VIRTUALIZATION_CONTROL, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_SHADER_SHARED_MEMORY_WINDOW_A {
    uint32_t base_address_upper;
};

static inline void
__NVC9C0_SET_SHADER_SHARED_MEMORY_WINDOW_A(uint32_t *val_out, struct nv_nvc9c0_SET_SHADER_SHARED_MEMORY_WINDOW_A st)
{
    uint32_t val = 0;
    
    assert(st.base_address_upper < (1ULL << 17));
    val |= st.base_address_upper << 0;
    *val_out = val;
}

#define V_NVC9C0_SET_SHADER_SHARED_MEMORY_WINDOW_A(val, args...) { \
    struct nv_nvc9c0_SET_SHADER_SHARED_MEMORY_WINDOW_A __data = { .base_address_upper = (args) }; \
    __NVC9C0_SET_SHADER_SHARED_MEMORY_WINDOW_A(&val, __data); \
}

#define VA_NVC9C0_SET_SHADER_SHARED_MEMORY_WINDOW_A V_NVC9C0_SET_SHADER_SHARED_MEMORY_WINDOW_A

#define P_NVC9C0_SET_SHADER_SHARED_MEMORY_WINDOW_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_SHADER_SHARED_MEMORY_WINDOW_A(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_SHADER_SHARED_MEMORY_WINDOW_A, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_SHADER_SHARED_MEMORY_WINDOW_B {
    uint32_t base_address;
};

static inline void
__NVC9C0_SET_SHADER_SHARED_MEMORY_WINDOW_B(uint32_t *val_out, struct nv_nvc9c0_SET_SHADER_SHARED_MEMORY_WINDOW_B st)
{
    uint32_t val = 0;
    
    val |= st.base_address;
    *val_out = val;
}

#define V_NVC9C0_SET_SHADER_SHARED_MEMORY_WINDOW_B(val, args...) { \
    struct nv_nvc9c0_SET_SHADER_SHARED_MEMORY_WINDOW_B __data = { .base_address = (args) }; \
    __NVC9C0_SET_SHADER_SHARED_MEMORY_WINDOW_B(&val, __data); \
}

#define VA_NVC9C0_SET_SHADER_SHARED_MEMORY_WINDOW_B V_NVC9C0_SET_SHADER_SHARED_MEMORY_WINDOW_B

#define P_NVC9C0_SET_SHADER_SHARED_MEMORY_WINDOW_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_SHADER_SHARED_MEMORY_WINDOW_B(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_SHADER_SHARED_MEMORY_WINDOW_B, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SCG_HYSTERESIS_CONTROL {
    uint32_t use_timeout_once;
    uint32_t use_null_timeout_once;
};

static inline void
__NVC9C0_SCG_HYSTERESIS_CONTROL(uint32_t *val_out, struct nv_nvc9c0_SCG_HYSTERESIS_CONTROL st)
{
    uint32_t val = 0;
    
    assert(st.use_timeout_once < (1ULL << 1));
    val |= st.use_timeout_once << 0;
    
    assert(st.use_null_timeout_once < (1ULL << 1));
    val |= st.use_null_timeout_once << 1;
    *val_out = val;
}

#define V_NVC9C0_SCG_HYSTERESIS_CONTROL(val, args...) { \
    UNUSED uint32_t USE_TIMEOUT_ONCE_FALSE = NVC9C0_SCG_HYSTERESIS_CONTROL_USE_TIMEOUT_ONCE_FALSE; \
    UNUSED uint32_t USE_TIMEOUT_ONCE_TRUE = NVC9C0_SCG_HYSTERESIS_CONTROL_USE_TIMEOUT_ONCE_TRUE; \
    UNUSED uint32_t USE_NULL_TIMEOUT_ONCE_FALSE = NVC9C0_SCG_HYSTERESIS_CONTROL_USE_NULL_TIMEOUT_ONCE_FALSE; \
    UNUSED uint32_t USE_NULL_TIMEOUT_ONCE_TRUE = NVC9C0_SCG_HYSTERESIS_CONTROL_USE_NULL_TIMEOUT_ONCE_TRUE; \
    struct nv_nvc9c0_SCG_HYSTERESIS_CONTROL __data = args; \
    __NVC9C0_SCG_HYSTERESIS_CONTROL(&val, __data); \
}

#define VA_NVC9C0_SCG_HYSTERESIS_CONTROL V_NVC9C0_SCG_HYSTERESIS_CONTROL

#define P_NVC9C0_SCG_HYSTERESIS_CONTROL(push, args...) do { \
    UNUSED uint32_t USE_TIMEOUT_ONCE_FALSE = NVC9C0_SCG_HYSTERESIS_CONTROL_USE_TIMEOUT_ONCE_FALSE; \
    UNUSED uint32_t USE_TIMEOUT_ONCE_TRUE = NVC9C0_SCG_HYSTERESIS_CONTROL_USE_TIMEOUT_ONCE_TRUE; \
    UNUSED uint32_t USE_NULL_TIMEOUT_ONCE_FALSE = NVC9C0_SCG_HYSTERESIS_CONTROL_USE_NULL_TIMEOUT_ONCE_FALSE; \
    UNUSED uint32_t USE_NULL_TIMEOUT_ONCE_TRUE = NVC9C0_SCG_HYSTERESIS_CONTROL_USE_NULL_TIMEOUT_ONCE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SCG_HYSTERESIS_CONTROL(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SCG_HYSTERESIS_CONTROL, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_CWD_SLOT_COUNT {
    uint32_t v;
};

static inline void
__NVC9C0_SET_CWD_SLOT_COUNT(uint32_t *val_out, struct nv_nvc9c0_SET_CWD_SLOT_COUNT st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 8));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVC9C0_SET_CWD_SLOT_COUNT(val, args...) { \
    struct nv_nvc9c0_SET_CWD_SLOT_COUNT __data = { .v = (args) }; \
    __NVC9C0_SET_CWD_SLOT_COUNT(&val, __data); \
}

#define VA_NVC9C0_SET_CWD_SLOT_COUNT V_NVC9C0_SET_CWD_SLOT_COUNT

#define P_NVC9C0_SET_CWD_SLOT_COUNT(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_CWD_SLOT_COUNT(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_CWD_SLOT_COUNT, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SEND_PCAS_A {
    uint32_t qmd_address_shifted8;
};

static inline void
__NVC9C0_SEND_PCAS_A(uint32_t *val_out, struct nv_nvc9c0_SEND_PCAS_A st)
{
    uint32_t val = 0;
    
    val |= st.qmd_address_shifted8;
    *val_out = val;
}

#define V_NVC9C0_SEND_PCAS_A(val, args...) { \
    struct nv_nvc9c0_SEND_PCAS_A __data = { .qmd_address_shifted8 = (args) }; \
    __NVC9C0_SEND_PCAS_A(&val, __data); \
}

#define VA_NVC9C0_SEND_PCAS_A V_NVC9C0_SEND_PCAS_A

#define P_NVC9C0_SEND_PCAS_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SEND_PCAS_A(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SEND_PCAS_A, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SEND_PCAS_B {
    uint32_t from;
    uint32_t delta;
};

static inline void
__NVC9C0_SEND_PCAS_B(uint32_t *val_out, struct nv_nvc9c0_SEND_PCAS_B st)
{
    uint32_t val = 0;
    
    assert(st.from < (1ULL << 24));
    val |= st.from << 0;
    
    assert(st.delta < (1ULL << 8));
    val |= st.delta << 24;
    *val_out = val;
}

#define V_NVC9C0_SEND_PCAS_B(val, args...) { \
    struct nv_nvc9c0_SEND_PCAS_B __data = args; \
    __NVC9C0_SEND_PCAS_B(&val, __data); \
}

#define VA_NVC9C0_SEND_PCAS_B V_NVC9C0_SEND_PCAS_B

#define P_NVC9C0_SEND_PCAS_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SEND_PCAS_B(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SEND_PCAS_B, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SEND_SIGNALING_PCAS_B {
    uint32_t invalidate;
    uint32_t schedule;
};

static inline void
__NVC9C0_SEND_SIGNALING_PCAS_B(uint32_t *val_out, struct nv_nvc9c0_SEND_SIGNALING_PCAS_B st)
{
    uint32_t val = 0;
    
    assert(st.invalidate < (1ULL << 1));
    val |= st.invalidate << 0;
    
    assert(st.schedule < (1ULL << 1));
    val |= st.schedule << 1;
    *val_out = val;
}

#define V_NVC9C0_SEND_SIGNALING_PCAS_B(val, args...) { \
    UNUSED uint32_t INVALIDATE_FALSE = NVC9C0_SEND_SIGNALING_PCAS_B_INVALIDATE_FALSE; \
    UNUSED uint32_t INVALIDATE_TRUE = NVC9C0_SEND_SIGNALING_PCAS_B_INVALIDATE_TRUE; \
    UNUSED uint32_t SCHEDULE_FALSE = NVC9C0_SEND_SIGNALING_PCAS_B_SCHEDULE_FALSE; \
    UNUSED uint32_t SCHEDULE_TRUE = NVC9C0_SEND_SIGNALING_PCAS_B_SCHEDULE_TRUE; \
    struct nv_nvc9c0_SEND_SIGNALING_PCAS_B __data = args; \
    __NVC9C0_SEND_SIGNALING_PCAS_B(&val, __data); \
}

#define VA_NVC9C0_SEND_SIGNALING_PCAS_B V_NVC9C0_SEND_SIGNALING_PCAS_B

#define P_NVC9C0_SEND_SIGNALING_PCAS_B(push, args...) do { \
    UNUSED uint32_t INVALIDATE_FALSE = NVC9C0_SEND_SIGNALING_PCAS_B_INVALIDATE_FALSE; \
    UNUSED uint32_t INVALIDATE_TRUE = NVC9C0_SEND_SIGNALING_PCAS_B_INVALIDATE_TRUE; \
    UNUSED uint32_t SCHEDULE_FALSE = NVC9C0_SEND_SIGNALING_PCAS_B_SCHEDULE_FALSE; \
    UNUSED uint32_t SCHEDULE_TRUE = NVC9C0_SEND_SIGNALING_PCAS_B_SCHEDULE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SEND_SIGNALING_PCAS_B(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SEND_SIGNALING_PCAS_B, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SEND_SIGNALING_PCAS2_B {
    uint32_t pcas_action;
    uint32_t select;
    uint32_t offset_minus_one;
};

static inline void
__NVC9C0_SEND_SIGNALING_PCAS2_B(uint32_t *val_out, struct nv_nvc9c0_SEND_SIGNALING_PCAS2_B st)
{
    uint32_t val = 0;
    
    assert(st.pcas_action < (1ULL << 4));
    val |= st.pcas_action << 0;
    
    assert(st.select < (1ULL << 6));
    val |= st.select << 8;
    
    assert(st.offset_minus_one < (1ULL << 10));
    val |= st.offset_minus_one << 14;
    *val_out = val;
}

#define V_NVC9C0_SEND_SIGNALING_PCAS2_B(val, args...) { \
    UNUSED uint32_t PCAS_ACTION_NOP = NVC9C0_SEND_SIGNALING_PCAS2_B_PCAS_ACTION_NOP; \
    UNUSED uint32_t PCAS_ACTION_INVALIDATE = NVC9C0_SEND_SIGNALING_PCAS2_B_PCAS_ACTION_INVALIDATE; \
    UNUSED uint32_t PCAS_ACTION_SCHEDULE = NVC9C0_SEND_SIGNALING_PCAS2_B_PCAS_ACTION_SCHEDULE; \
    UNUSED uint32_t PCAS_ACTION_INVALIDATE_COPY_SCHEDULE = NVC9C0_SEND_SIGNALING_PCAS2_B_PCAS_ACTION_INVALIDATE_COPY_SCHEDULE; \
    UNUSED uint32_t PCAS_ACTION_INCREMENT_PUT = NVC9C0_SEND_SIGNALING_PCAS2_B_PCAS_ACTION_INCREMENT_PUT; \
    UNUSED uint32_t PCAS_ACTION_DECREMENT_DEPENDENCE = NVC9C0_SEND_SIGNALING_PCAS2_B_PCAS_ACTION_DECREMENT_DEPENDENCE; \
    UNUSED uint32_t PCAS_ACTION_PREFETCH = NVC9C0_SEND_SIGNALING_PCAS2_B_PCAS_ACTION_PREFETCH; \
    UNUSED uint32_t PCAS_ACTION_PREFETCH_SCHEDULE = NVC9C0_SEND_SIGNALING_PCAS2_B_PCAS_ACTION_PREFETCH_SCHEDULE; \
    UNUSED uint32_t PCAS_ACTION_INVALIDATE_PREFETCH_COPY_SCHEDULE = NVC9C0_SEND_SIGNALING_PCAS2_B_PCAS_ACTION_INVALIDATE_PREFETCH_COPY_SCHEDULE; \
    UNUSED uint32_t PCAS_ACTION_INVALIDATE_PREFETCH_COPY_FORCE_REQUIRE_SCHEDULING = NVC9C0_SEND_SIGNALING_PCAS2_B_PCAS_ACTION_INVALIDATE_PREFETCH_COPY_FORCE_REQUIRE_SCHEDULING; \
    UNUSED uint32_t PCAS_ACTION_INCREMENT_DEPENDENCE = NVC9C0_SEND_SIGNALING_PCAS2_B_PCAS_ACTION_INCREMENT_DEPENDENCE; \
    UNUSED uint32_t PCAS_ACTION_INCREMENT_CWD_REF_COUNTER = NVC9C0_SEND_SIGNALING_PCAS2_B_PCAS_ACTION_INCREMENT_CWD_REF_COUNTER; \
    struct nv_nvc9c0_SEND_SIGNALING_PCAS2_B __data = args; \
    __NVC9C0_SEND_SIGNALING_PCAS2_B(&val, __data); \
}

#define VA_NVC9C0_SEND_SIGNALING_PCAS2_B V_NVC9C0_SEND_SIGNALING_PCAS2_B

#define P_NVC9C0_SEND_SIGNALING_PCAS2_B(push, args...) do { \
    UNUSED uint32_t PCAS_ACTION_NOP = NVC9C0_SEND_SIGNALING_PCAS2_B_PCAS_ACTION_NOP; \
    UNUSED uint32_t PCAS_ACTION_INVALIDATE = NVC9C0_SEND_SIGNALING_PCAS2_B_PCAS_ACTION_INVALIDATE; \
    UNUSED uint32_t PCAS_ACTION_SCHEDULE = NVC9C0_SEND_SIGNALING_PCAS2_B_PCAS_ACTION_SCHEDULE; \
    UNUSED uint32_t PCAS_ACTION_INVALIDATE_COPY_SCHEDULE = NVC9C0_SEND_SIGNALING_PCAS2_B_PCAS_ACTION_INVALIDATE_COPY_SCHEDULE; \
    UNUSED uint32_t PCAS_ACTION_INCREMENT_PUT = NVC9C0_SEND_SIGNALING_PCAS2_B_PCAS_ACTION_INCREMENT_PUT; \
    UNUSED uint32_t PCAS_ACTION_DECREMENT_DEPENDENCE = NVC9C0_SEND_SIGNALING_PCAS2_B_PCAS_ACTION_DECREMENT_DEPENDENCE; \
    UNUSED uint32_t PCAS_ACTION_PREFETCH = NVC9C0_SEND_SIGNALING_PCAS2_B_PCAS_ACTION_PREFETCH; \
    UNUSED uint32_t PCAS_ACTION_PREFETCH_SCHEDULE = NVC9C0_SEND_SIGNALING_PCAS2_B_PCAS_ACTION_PREFETCH_SCHEDULE; \
    UNUSED uint32_t PCAS_ACTION_INVALIDATE_PREFETCH_COPY_SCHEDULE = NVC9C0_SEND_SIGNALING_PCAS2_B_PCAS_ACTION_INVALIDATE_PREFETCH_COPY_SCHEDULE; \
    UNUSED uint32_t PCAS_ACTION_INVALIDATE_PREFETCH_COPY_FORCE_REQUIRE_SCHEDULING = NVC9C0_SEND_SIGNALING_PCAS2_B_PCAS_ACTION_INVALIDATE_PREFETCH_COPY_FORCE_REQUIRE_SCHEDULING; \
    UNUSED uint32_t PCAS_ACTION_INCREMENT_DEPENDENCE = NVC9C0_SEND_SIGNALING_PCAS2_B_PCAS_ACTION_INCREMENT_DEPENDENCE; \
    UNUSED uint32_t PCAS_ACTION_INCREMENT_CWD_REF_COUNTER = NVC9C0_SEND_SIGNALING_PCAS2_B_PCAS_ACTION_INCREMENT_CWD_REF_COUNTER; \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SEND_SIGNALING_PCAS2_B(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SEND_SIGNALING_PCAS2_B, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_SKED_CACHE_CONTROL {
    uint32_t ignore_veid;
};

static inline void
__NVC9C0_SET_SKED_CACHE_CONTROL(uint32_t *val_out, struct nv_nvc9c0_SET_SKED_CACHE_CONTROL st)
{
    uint32_t val = 0;
    
    assert(st.ignore_veid < (1ULL << 1));
    val |= st.ignore_veid << 0;
    *val_out = val;
}

#define V_NVC9C0_SET_SKED_CACHE_CONTROL(val, args...) { \
    UNUSED uint32_t IGNORE_VEID_FALSE = NVC9C0_SET_SKED_CACHE_CONTROL_IGNORE_VEID_FALSE; \
    UNUSED uint32_t IGNORE_VEID_TRUE = NVC9C0_SET_SKED_CACHE_CONTROL_IGNORE_VEID_TRUE; \
    struct nv_nvc9c0_SET_SKED_CACHE_CONTROL __data = { .ignore_veid = (args) }; \
    __NVC9C0_SET_SKED_CACHE_CONTROL(&val, __data); \
}

#define VA_NVC9C0_SET_SKED_CACHE_CONTROL V_NVC9C0_SET_SKED_CACHE_CONTROL

#define P_NVC9C0_SET_SKED_CACHE_CONTROL(push, args...) do { \
    UNUSED uint32_t IGNORE_VEID_FALSE = NVC9C0_SET_SKED_CACHE_CONTROL_IGNORE_VEID_FALSE; \
    UNUSED uint32_t IGNORE_VEID_TRUE = NVC9C0_SET_SKED_CACHE_CONTROL_IGNORE_VEID_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_SKED_CACHE_CONTROL(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_SKED_CACHE_CONTROL, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_A {
    uint32_t size_upper;
};

static inline void
__NVC9C0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_A(uint32_t *val_out, struct nv_nvc9c0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_A st)
{
    uint32_t val = 0;
    
    assert(st.size_upper < (1ULL << 8));
    val |= st.size_upper << 0;
    *val_out = val;
}

#define V_NVC9C0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_A(val, args...) { \
    struct nv_nvc9c0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_A __data = { .size_upper = (args) }; \
    __NVC9C0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_A(&val, __data); \
}

#define VA_NVC9C0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_A V_NVC9C0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_A

#define P_NVC9C0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_A(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_A, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_B {
    uint32_t size_lower;
};

static inline void
__NVC9C0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_B(uint32_t *val_out, struct nv_nvc9c0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_B st)
{
    uint32_t val = 0;
    
    val |= st.size_lower;
    *val_out = val;
}

#define V_NVC9C0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_B(val, args...) { \
    struct nv_nvc9c0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_B __data = { .size_lower = (args) }; \
    __NVC9C0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_B(&val, __data); \
}

#define VA_NVC9C0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_B V_NVC9C0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_B

#define P_NVC9C0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_B(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_B, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_C {
    uint32_t max_sm_count;
};

static inline void
__NVC9C0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_C(uint32_t *val_out, struct nv_nvc9c0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_C st)
{
    uint32_t val = 0;
    
    assert(st.max_sm_count < (1ULL << 9));
    val |= st.max_sm_count << 0;
    *val_out = val;
}

#define V_NVC9C0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_C(val, args...) { \
    struct nv_nvc9c0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_C __data = { .max_sm_count = (args) }; \
    __NVC9C0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_C(&val, __data); \
}

#define VA_NVC9C0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_C V_NVC9C0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_C

#define P_NVC9C0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_C(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_C(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_C, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_SPA_VERSION {
    uint32_t minor;
    uint32_t major;
};

static inline void
__NVC9C0_SET_SPA_VERSION(uint32_t *val_out, struct nv_nvc9c0_SET_SPA_VERSION st)
{
    uint32_t val = 0;
    
    assert(st.minor < (1ULL << 8));
    val |= st.minor << 0;
    
    assert(st.major < (1ULL << 8));
    val |= st.major << 8;
    *val_out = val;
}

#define V_NVC9C0_SET_SPA_VERSION(val, args...) { \
    struct nv_nvc9c0_SET_SPA_VERSION __data = args; \
    __NVC9C0_SET_SPA_VERSION(&val, __data); \
}

#define VA_NVC9C0_SET_SPA_VERSION V_NVC9C0_SET_SPA_VERSION

#define P_NVC9C0_SET_SPA_VERSION(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_SPA_VERSION(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_SPA_VERSION, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_INLINE_QMD_ADDRESS_A {
    uint32_t qmd_address_shifted8_upper;
};

static inline void
__NVC9C0_SET_INLINE_QMD_ADDRESS_A(uint32_t *val_out, struct nv_nvc9c0_SET_INLINE_QMD_ADDRESS_A st)
{
    uint32_t val = 0;
    
    val |= st.qmd_address_shifted8_upper;
    *val_out = val;
}

#define V_NVC9C0_SET_INLINE_QMD_ADDRESS_A(val, args...) { \
    struct nv_nvc9c0_SET_INLINE_QMD_ADDRESS_A __data = { .qmd_address_shifted8_upper = (args) }; \
    __NVC9C0_SET_INLINE_QMD_ADDRESS_A(&val, __data); \
}

#define VA_NVC9C0_SET_INLINE_QMD_ADDRESS_A V_NVC9C0_SET_INLINE_QMD_ADDRESS_A

#define P_NVC9C0_SET_INLINE_QMD_ADDRESS_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_INLINE_QMD_ADDRESS_A(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_INLINE_QMD_ADDRESS_A, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_INLINE_QMD_ADDRESS_B {
    uint32_t qmd_address_shifted8_lower;
};

static inline void
__NVC9C0_SET_INLINE_QMD_ADDRESS_B(uint32_t *val_out, struct nv_nvc9c0_SET_INLINE_QMD_ADDRESS_B st)
{
    uint32_t val = 0;
    
    val |= st.qmd_address_shifted8_lower;
    *val_out = val;
}

#define V_NVC9C0_SET_INLINE_QMD_ADDRESS_B(val, args...) { \
    struct nv_nvc9c0_SET_INLINE_QMD_ADDRESS_B __data = { .qmd_address_shifted8_lower = (args) }; \
    __NVC9C0_SET_INLINE_QMD_ADDRESS_B(&val, __data); \
}

#define VA_NVC9C0_SET_INLINE_QMD_ADDRESS_B V_NVC9C0_SET_INLINE_QMD_ADDRESS_B

#define P_NVC9C0_SET_INLINE_QMD_ADDRESS_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_INLINE_QMD_ADDRESS_B(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_INLINE_QMD_ADDRESS_B, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_LOAD_INLINE_QMD_DATA {
    uint32_t v;
};

static inline void
__NVC9C0_LOAD_INLINE_QMD_DATA(uint32_t *val_out, struct nv_nvc9c0_LOAD_INLINE_QMD_DATA st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_LOAD_INLINE_QMD_DATA(val, args...) { \
    struct nv_nvc9c0_LOAD_INLINE_QMD_DATA __data = { .v = (args) }; \
    __NVC9C0_LOAD_INLINE_QMD_DATA(&val, __data); \
}

#define VA_NVC9C0_LOAD_INLINE_QMD_DATA(i) V_NVC9C0_LOAD_INLINE_QMD_DATA

#define P_NVC9C0_LOAD_INLINE_QMD_DATA(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_LOAD_INLINE_QMD_DATA(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_LOAD_INLINE_QMD_DATA(idx), nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_FALCON00 {
    uint32_t v;
};

static inline void
__NVC9C0_SET_FALCON00(uint32_t *val_out, struct nv_nvc9c0_SET_FALCON00 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_SET_FALCON00(val, args...) { \
    struct nv_nvc9c0_SET_FALCON00 __data = { .v = (args) }; \
    __NVC9C0_SET_FALCON00(&val, __data); \
}

#define VA_NVC9C0_SET_FALCON00 V_NVC9C0_SET_FALCON00

#define P_NVC9C0_SET_FALCON00(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_FALCON00(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_FALCON00, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_FALCON01 {
    uint32_t v;
};

static inline void
__NVC9C0_SET_FALCON01(uint32_t *val_out, struct nv_nvc9c0_SET_FALCON01 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_SET_FALCON01(val, args...) { \
    struct nv_nvc9c0_SET_FALCON01 __data = { .v = (args) }; \
    __NVC9C0_SET_FALCON01(&val, __data); \
}

#define VA_NVC9C0_SET_FALCON01 V_NVC9C0_SET_FALCON01

#define P_NVC9C0_SET_FALCON01(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_FALCON01(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_FALCON01, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_FALCON02 {
    uint32_t v;
};

static inline void
__NVC9C0_SET_FALCON02(uint32_t *val_out, struct nv_nvc9c0_SET_FALCON02 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_SET_FALCON02(val, args...) { \
    struct nv_nvc9c0_SET_FALCON02 __data = { .v = (args) }; \
    __NVC9C0_SET_FALCON02(&val, __data); \
}

#define VA_NVC9C0_SET_FALCON02 V_NVC9C0_SET_FALCON02

#define P_NVC9C0_SET_FALCON02(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_FALCON02(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_FALCON02, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_FALCON03 {
    uint32_t v;
};

static inline void
__NVC9C0_SET_FALCON03(uint32_t *val_out, struct nv_nvc9c0_SET_FALCON03 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_SET_FALCON03(val, args...) { \
    struct nv_nvc9c0_SET_FALCON03 __data = { .v = (args) }; \
    __NVC9C0_SET_FALCON03(&val, __data); \
}

#define VA_NVC9C0_SET_FALCON03 V_NVC9C0_SET_FALCON03

#define P_NVC9C0_SET_FALCON03(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_FALCON03(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_FALCON03, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_FALCON04 {
    uint32_t v;
};

static inline void
__NVC9C0_SET_FALCON04(uint32_t *val_out, struct nv_nvc9c0_SET_FALCON04 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_SET_FALCON04(val, args...) { \
    struct nv_nvc9c0_SET_FALCON04 __data = { .v = (args) }; \
    __NVC9C0_SET_FALCON04(&val, __data); \
}

#define VA_NVC9C0_SET_FALCON04 V_NVC9C0_SET_FALCON04

#define P_NVC9C0_SET_FALCON04(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_FALCON04(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_FALCON04, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_FALCON05 {
    uint32_t v;
};

static inline void
__NVC9C0_SET_FALCON05(uint32_t *val_out, struct nv_nvc9c0_SET_FALCON05 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_SET_FALCON05(val, args...) { \
    struct nv_nvc9c0_SET_FALCON05 __data = { .v = (args) }; \
    __NVC9C0_SET_FALCON05(&val, __data); \
}

#define VA_NVC9C0_SET_FALCON05 V_NVC9C0_SET_FALCON05

#define P_NVC9C0_SET_FALCON05(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_FALCON05(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_FALCON05, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_FALCON06 {
    uint32_t v;
};

static inline void
__NVC9C0_SET_FALCON06(uint32_t *val_out, struct nv_nvc9c0_SET_FALCON06 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_SET_FALCON06(val, args...) { \
    struct nv_nvc9c0_SET_FALCON06 __data = { .v = (args) }; \
    __NVC9C0_SET_FALCON06(&val, __data); \
}

#define VA_NVC9C0_SET_FALCON06 V_NVC9C0_SET_FALCON06

#define P_NVC9C0_SET_FALCON06(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_FALCON06(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_FALCON06, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_FALCON07 {
    uint32_t v;
};

static inline void
__NVC9C0_SET_FALCON07(uint32_t *val_out, struct nv_nvc9c0_SET_FALCON07 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_SET_FALCON07(val, args...) { \
    struct nv_nvc9c0_SET_FALCON07 __data = { .v = (args) }; \
    __NVC9C0_SET_FALCON07(&val, __data); \
}

#define VA_NVC9C0_SET_FALCON07 V_NVC9C0_SET_FALCON07

#define P_NVC9C0_SET_FALCON07(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_FALCON07(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_FALCON07, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_FALCON08 {
    uint32_t v;
};

static inline void
__NVC9C0_SET_FALCON08(uint32_t *val_out, struct nv_nvc9c0_SET_FALCON08 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_SET_FALCON08(val, args...) { \
    struct nv_nvc9c0_SET_FALCON08 __data = { .v = (args) }; \
    __NVC9C0_SET_FALCON08(&val, __data); \
}

#define VA_NVC9C0_SET_FALCON08 V_NVC9C0_SET_FALCON08

#define P_NVC9C0_SET_FALCON08(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_FALCON08(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_FALCON08, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_FALCON09 {
    uint32_t v;
};

static inline void
__NVC9C0_SET_FALCON09(uint32_t *val_out, struct nv_nvc9c0_SET_FALCON09 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_SET_FALCON09(val, args...) { \
    struct nv_nvc9c0_SET_FALCON09 __data = { .v = (args) }; \
    __NVC9C0_SET_FALCON09(&val, __data); \
}

#define VA_NVC9C0_SET_FALCON09 V_NVC9C0_SET_FALCON09

#define P_NVC9C0_SET_FALCON09(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_FALCON09(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_FALCON09, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_FALCON10 {
    uint32_t v;
};

static inline void
__NVC9C0_SET_FALCON10(uint32_t *val_out, struct nv_nvc9c0_SET_FALCON10 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_SET_FALCON10(val, args...) { \
    struct nv_nvc9c0_SET_FALCON10 __data = { .v = (args) }; \
    __NVC9C0_SET_FALCON10(&val, __data); \
}

#define VA_NVC9C0_SET_FALCON10 V_NVC9C0_SET_FALCON10

#define P_NVC9C0_SET_FALCON10(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_FALCON10(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_FALCON10, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_FALCON11 {
    uint32_t v;
};

static inline void
__NVC9C0_SET_FALCON11(uint32_t *val_out, struct nv_nvc9c0_SET_FALCON11 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_SET_FALCON11(val, args...) { \
    struct nv_nvc9c0_SET_FALCON11 __data = { .v = (args) }; \
    __NVC9C0_SET_FALCON11(&val, __data); \
}

#define VA_NVC9C0_SET_FALCON11 V_NVC9C0_SET_FALCON11

#define P_NVC9C0_SET_FALCON11(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_FALCON11(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_FALCON11, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_FALCON12 {
    uint32_t v;
};

static inline void
__NVC9C0_SET_FALCON12(uint32_t *val_out, struct nv_nvc9c0_SET_FALCON12 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_SET_FALCON12(val, args...) { \
    struct nv_nvc9c0_SET_FALCON12 __data = { .v = (args) }; \
    __NVC9C0_SET_FALCON12(&val, __data); \
}

#define VA_NVC9C0_SET_FALCON12 V_NVC9C0_SET_FALCON12

#define P_NVC9C0_SET_FALCON12(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_FALCON12(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_FALCON12, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_FALCON13 {
    uint32_t v;
};

static inline void
__NVC9C0_SET_FALCON13(uint32_t *val_out, struct nv_nvc9c0_SET_FALCON13 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_SET_FALCON13(val, args...) { \
    struct nv_nvc9c0_SET_FALCON13 __data = { .v = (args) }; \
    __NVC9C0_SET_FALCON13(&val, __data); \
}

#define VA_NVC9C0_SET_FALCON13 V_NVC9C0_SET_FALCON13

#define P_NVC9C0_SET_FALCON13(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_FALCON13(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_FALCON13, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_FALCON14 {
    uint32_t v;
};

static inline void
__NVC9C0_SET_FALCON14(uint32_t *val_out, struct nv_nvc9c0_SET_FALCON14 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_SET_FALCON14(val, args...) { \
    struct nv_nvc9c0_SET_FALCON14 __data = { .v = (args) }; \
    __NVC9C0_SET_FALCON14(&val, __data); \
}

#define VA_NVC9C0_SET_FALCON14 V_NVC9C0_SET_FALCON14

#define P_NVC9C0_SET_FALCON14(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_FALCON14(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_FALCON14, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_FALCON15 {
    uint32_t v;
};

static inline void
__NVC9C0_SET_FALCON15(uint32_t *val_out, struct nv_nvc9c0_SET_FALCON15 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_SET_FALCON15(val, args...) { \
    struct nv_nvc9c0_SET_FALCON15 __data = { .v = (args) }; \
    __NVC9C0_SET_FALCON15(&val, __data); \
}

#define VA_NVC9C0_SET_FALCON15 V_NVC9C0_SET_FALCON15

#define P_NVC9C0_SET_FALCON15(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_FALCON15(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_FALCON15, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_MME_MEM_ADDRESS_A {
    uint32_t upper;
};

static inline void
__NVC9C0_SET_MME_MEM_ADDRESS_A(uint32_t *val_out, struct nv_nvc9c0_SET_MME_MEM_ADDRESS_A st)
{
    uint32_t val = 0;
    
    assert(st.upper < (1ULL << 17));
    val |= st.upper << 0;
    *val_out = val;
}

#define V_NVC9C0_SET_MME_MEM_ADDRESS_A(val, args...) { \
    struct nv_nvc9c0_SET_MME_MEM_ADDRESS_A __data = { .upper = (args) }; \
    __NVC9C0_SET_MME_MEM_ADDRESS_A(&val, __data); \
}

#define VA_NVC9C0_SET_MME_MEM_ADDRESS_A V_NVC9C0_SET_MME_MEM_ADDRESS_A

#define P_NVC9C0_SET_MME_MEM_ADDRESS_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_MME_MEM_ADDRESS_A(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_MME_MEM_ADDRESS_A, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_MME_MEM_ADDRESS_B {
    uint32_t lower;
};

static inline void
__NVC9C0_SET_MME_MEM_ADDRESS_B(uint32_t *val_out, struct nv_nvc9c0_SET_MME_MEM_ADDRESS_B st)
{
    uint32_t val = 0;
    
    val |= st.lower;
    *val_out = val;
}

#define V_NVC9C0_SET_MME_MEM_ADDRESS_B(val, args...) { \
    struct nv_nvc9c0_SET_MME_MEM_ADDRESS_B __data = { .lower = (args) }; \
    __NVC9C0_SET_MME_MEM_ADDRESS_B(&val, __data); \
}

#define VA_NVC9C0_SET_MME_MEM_ADDRESS_B V_NVC9C0_SET_MME_MEM_ADDRESS_B

#define P_NVC9C0_SET_MME_MEM_ADDRESS_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_MME_MEM_ADDRESS_B(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_MME_MEM_ADDRESS_B, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_MME_DATA_RAM_ADDRESS {
    uint32_t word;
};

static inline void
__NVC9C0_SET_MME_DATA_RAM_ADDRESS(uint32_t *val_out, struct nv_nvc9c0_SET_MME_DATA_RAM_ADDRESS st)
{
    uint32_t val = 0;
    
    val |= st.word;
    *val_out = val;
}

#define V_NVC9C0_SET_MME_DATA_RAM_ADDRESS(val, args...) { \
    struct nv_nvc9c0_SET_MME_DATA_RAM_ADDRESS __data = { .word = (args) }; \
    __NVC9C0_SET_MME_DATA_RAM_ADDRESS(&val, __data); \
}

#define VA_NVC9C0_SET_MME_DATA_RAM_ADDRESS V_NVC9C0_SET_MME_DATA_RAM_ADDRESS

#define P_NVC9C0_SET_MME_DATA_RAM_ADDRESS(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_MME_DATA_RAM_ADDRESS(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_MME_DATA_RAM_ADDRESS, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_MME_DMA_READ {
    uint32_t length;
};

static inline void
__NVC9C0_MME_DMA_READ(uint32_t *val_out, struct nv_nvc9c0_MME_DMA_READ st)
{
    uint32_t val = 0;
    
    val |= st.length;
    *val_out = val;
}

#define V_NVC9C0_MME_DMA_READ(val, args...) { \
    struct nv_nvc9c0_MME_DMA_READ __data = { .length = (args) }; \
    __NVC9C0_MME_DMA_READ(&val, __data); \
}

#define VA_NVC9C0_MME_DMA_READ V_NVC9C0_MME_DMA_READ

#define P_NVC9C0_MME_DMA_READ(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_MME_DMA_READ(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_MME_DMA_READ, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_MME_DMA_READ_FIFOED {
    uint32_t length;
};

static inline void
__NVC9C0_MME_DMA_READ_FIFOED(uint32_t *val_out, struct nv_nvc9c0_MME_DMA_READ_FIFOED st)
{
    uint32_t val = 0;
    
    val |= st.length;
    *val_out = val;
}

#define V_NVC9C0_MME_DMA_READ_FIFOED(val, args...) { \
    struct nv_nvc9c0_MME_DMA_READ_FIFOED __data = { .length = (args) }; \
    __NVC9C0_MME_DMA_READ_FIFOED(&val, __data); \
}

#define VA_NVC9C0_MME_DMA_READ_FIFOED V_NVC9C0_MME_DMA_READ_FIFOED

#define P_NVC9C0_MME_DMA_READ_FIFOED(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_MME_DMA_READ_FIFOED(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_MME_DMA_READ_FIFOED, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_MME_DMA_WRITE {
    uint32_t length;
};

static inline void
__NVC9C0_MME_DMA_WRITE(uint32_t *val_out, struct nv_nvc9c0_MME_DMA_WRITE st)
{
    uint32_t val = 0;
    
    val |= st.length;
    *val_out = val;
}

#define V_NVC9C0_MME_DMA_WRITE(val, args...) { \
    struct nv_nvc9c0_MME_DMA_WRITE __data = { .length = (args) }; \
    __NVC9C0_MME_DMA_WRITE(&val, __data); \
}

#define VA_NVC9C0_MME_DMA_WRITE V_NVC9C0_MME_DMA_WRITE

#define P_NVC9C0_MME_DMA_WRITE(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_MME_DMA_WRITE(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_MME_DMA_WRITE, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_MME_DMA_REDUCTION {
    uint32_t reduction_op;
    uint32_t reduction_format;
    uint32_t reduction_size;
};

static inline void
__NVC9C0_MME_DMA_REDUCTION(uint32_t *val_out, struct nv_nvc9c0_MME_DMA_REDUCTION st)
{
    uint32_t val = 0;
    
    assert(st.reduction_op < (1ULL << 3));
    val |= st.reduction_op << 0;
    
    assert(st.reduction_format < (1ULL << 2));
    val |= st.reduction_format << 4;
    
    assert(st.reduction_size < (1ULL << 1));
    val |= st.reduction_size << 8;
    *val_out = val;
}

#define V_NVC9C0_MME_DMA_REDUCTION(val, args...) { \
    UNUSED uint32_t REDUCTION_OP_RED_ADD = NVC9C0_MME_DMA_REDUCTION_REDUCTION_OP_RED_ADD; \
    UNUSED uint32_t REDUCTION_OP_RED_MIN = NVC9C0_MME_DMA_REDUCTION_REDUCTION_OP_RED_MIN; \
    UNUSED uint32_t REDUCTION_OP_RED_MAX = NVC9C0_MME_DMA_REDUCTION_REDUCTION_OP_RED_MAX; \
    UNUSED uint32_t REDUCTION_OP_RED_INC = NVC9C0_MME_DMA_REDUCTION_REDUCTION_OP_RED_INC; \
    UNUSED uint32_t REDUCTION_OP_RED_DEC = NVC9C0_MME_DMA_REDUCTION_REDUCTION_OP_RED_DEC; \
    UNUSED uint32_t REDUCTION_OP_RED_AND = NVC9C0_MME_DMA_REDUCTION_REDUCTION_OP_RED_AND; \
    UNUSED uint32_t REDUCTION_OP_RED_OR = NVC9C0_MME_DMA_REDUCTION_REDUCTION_OP_RED_OR; \
    UNUSED uint32_t REDUCTION_OP_RED_XOR = NVC9C0_MME_DMA_REDUCTION_REDUCTION_OP_RED_XOR; \
    UNUSED uint32_t REDUCTION_FORMAT_UNSIGNED = NVC9C0_MME_DMA_REDUCTION_REDUCTION_FORMAT_UNSIGNED; \
    UNUSED uint32_t REDUCTION_FORMAT_SIGNED = NVC9C0_MME_DMA_REDUCTION_REDUCTION_FORMAT_SIGNED; \
    UNUSED uint32_t REDUCTION_SIZE_FOUR_BYTES = NVC9C0_MME_DMA_REDUCTION_REDUCTION_SIZE_FOUR_BYTES; \
    UNUSED uint32_t REDUCTION_SIZE_EIGHT_BYTES = NVC9C0_MME_DMA_REDUCTION_REDUCTION_SIZE_EIGHT_BYTES; \
    struct nv_nvc9c0_MME_DMA_REDUCTION __data = args; \
    __NVC9C0_MME_DMA_REDUCTION(&val, __data); \
}

#define VA_NVC9C0_MME_DMA_REDUCTION V_NVC9C0_MME_DMA_REDUCTION

#define P_NVC9C0_MME_DMA_REDUCTION(push, args...) do { \
    UNUSED uint32_t REDUCTION_OP_RED_ADD = NVC9C0_MME_DMA_REDUCTION_REDUCTION_OP_RED_ADD; \
    UNUSED uint32_t REDUCTION_OP_RED_MIN = NVC9C0_MME_DMA_REDUCTION_REDUCTION_OP_RED_MIN; \
    UNUSED uint32_t REDUCTION_OP_RED_MAX = NVC9C0_MME_DMA_REDUCTION_REDUCTION_OP_RED_MAX; \
    UNUSED uint32_t REDUCTION_OP_RED_INC = NVC9C0_MME_DMA_REDUCTION_REDUCTION_OP_RED_INC; \
    UNUSED uint32_t REDUCTION_OP_RED_DEC = NVC9C0_MME_DMA_REDUCTION_REDUCTION_OP_RED_DEC; \
    UNUSED uint32_t REDUCTION_OP_RED_AND = NVC9C0_MME_DMA_REDUCTION_REDUCTION_OP_RED_AND; \
    UNUSED uint32_t REDUCTION_OP_RED_OR = NVC9C0_MME_DMA_REDUCTION_REDUCTION_OP_RED_OR; \
    UNUSED uint32_t REDUCTION_OP_RED_XOR = NVC9C0_MME_DMA_REDUCTION_REDUCTION_OP_RED_XOR; \
    UNUSED uint32_t REDUCTION_FORMAT_UNSIGNED = NVC9C0_MME_DMA_REDUCTION_REDUCTION_FORMAT_UNSIGNED; \
    UNUSED uint32_t REDUCTION_FORMAT_SIGNED = NVC9C0_MME_DMA_REDUCTION_REDUCTION_FORMAT_SIGNED; \
    UNUSED uint32_t REDUCTION_SIZE_FOUR_BYTES = NVC9C0_MME_DMA_REDUCTION_REDUCTION_SIZE_FOUR_BYTES; \
    UNUSED uint32_t REDUCTION_SIZE_EIGHT_BYTES = NVC9C0_MME_DMA_REDUCTION_REDUCTION_SIZE_EIGHT_BYTES; \
    uint32_t nvk_p_ret; \
    V_NVC9C0_MME_DMA_REDUCTION(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_MME_DMA_REDUCTION, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_MME_DMA_SYSMEMBAR {
    uint32_t v;
};

static inline void
__NVC9C0_MME_DMA_SYSMEMBAR(uint32_t *val_out, struct nv_nvc9c0_MME_DMA_SYSMEMBAR st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 1));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVC9C0_MME_DMA_SYSMEMBAR(val, args...) { \
    struct nv_nvc9c0_MME_DMA_SYSMEMBAR __data = { .v = (args) }; \
    __NVC9C0_MME_DMA_SYSMEMBAR(&val, __data); \
}

#define VA_NVC9C0_MME_DMA_SYSMEMBAR V_NVC9C0_MME_DMA_SYSMEMBAR

#define P_NVC9C0_MME_DMA_SYSMEMBAR(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_MME_DMA_SYSMEMBAR(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_MME_DMA_SYSMEMBAR, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_MME_DMA_SYNC {
    uint32_t value;
};

static inline void
__NVC9C0_MME_DMA_SYNC(uint32_t *val_out, struct nv_nvc9c0_MME_DMA_SYNC st)
{
    uint32_t val = 0;
    
    val |= st.value;
    *val_out = val;
}

#define V_NVC9C0_MME_DMA_SYNC(val, args...) { \
    struct nv_nvc9c0_MME_DMA_SYNC __data = { .value = (args) }; \
    __NVC9C0_MME_DMA_SYNC(&val, __data); \
}

#define VA_NVC9C0_MME_DMA_SYNC V_NVC9C0_MME_DMA_SYNC

#define P_NVC9C0_MME_DMA_SYNC(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_MME_DMA_SYNC(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_MME_DMA_SYNC, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_MME_DATA_FIFO_CONFIG {
    uint32_t fifo_size;
};

static inline void
__NVC9C0_SET_MME_DATA_FIFO_CONFIG(uint32_t *val_out, struct nv_nvc9c0_SET_MME_DATA_FIFO_CONFIG st)
{
    uint32_t val = 0;
    
    assert(st.fifo_size < (1ULL << 3));
    val |= st.fifo_size << 0;
    *val_out = val;
}

#define V_NVC9C0_SET_MME_DATA_FIFO_CONFIG(val, args...) { \
    UNUSED uint32_t FIFO_SIZE_SIZE_0KB = NVC9C0_SET_MME_DATA_FIFO_CONFIG_FIFO_SIZE_SIZE_0KB; \
    UNUSED uint32_t FIFO_SIZE_SIZE_4KB = NVC9C0_SET_MME_DATA_FIFO_CONFIG_FIFO_SIZE_SIZE_4KB; \
    UNUSED uint32_t FIFO_SIZE_SIZE_8KB = NVC9C0_SET_MME_DATA_FIFO_CONFIG_FIFO_SIZE_SIZE_8KB; \
    UNUSED uint32_t FIFO_SIZE_SIZE_12KB = NVC9C0_SET_MME_DATA_FIFO_CONFIG_FIFO_SIZE_SIZE_12KB; \
    UNUSED uint32_t FIFO_SIZE_SIZE_16KB = NVC9C0_SET_MME_DATA_FIFO_CONFIG_FIFO_SIZE_SIZE_16KB; \
    struct nv_nvc9c0_SET_MME_DATA_FIFO_CONFIG __data = { .fifo_size = (args) }; \
    __NVC9C0_SET_MME_DATA_FIFO_CONFIG(&val, __data); \
}

#define VA_NVC9C0_SET_MME_DATA_FIFO_CONFIG V_NVC9C0_SET_MME_DATA_FIFO_CONFIG

#define P_NVC9C0_SET_MME_DATA_FIFO_CONFIG(push, args...) do { \
    UNUSED uint32_t FIFO_SIZE_SIZE_0KB = NVC9C0_SET_MME_DATA_FIFO_CONFIG_FIFO_SIZE_SIZE_0KB; \
    UNUSED uint32_t FIFO_SIZE_SIZE_4KB = NVC9C0_SET_MME_DATA_FIFO_CONFIG_FIFO_SIZE_SIZE_4KB; \
    UNUSED uint32_t FIFO_SIZE_SIZE_8KB = NVC9C0_SET_MME_DATA_FIFO_CONFIG_FIFO_SIZE_SIZE_8KB; \
    UNUSED uint32_t FIFO_SIZE_SIZE_12KB = NVC9C0_SET_MME_DATA_FIFO_CONFIG_FIFO_SIZE_SIZE_12KB; \
    UNUSED uint32_t FIFO_SIZE_SIZE_16KB = NVC9C0_SET_MME_DATA_FIFO_CONFIG_FIFO_SIZE_SIZE_16KB; \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_MME_DATA_FIFO_CONFIG(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_MME_DATA_FIFO_CONFIG, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_SHADER_LOCAL_MEMORY_A {
    uint32_t address_upper;
};

static inline void
__NVC9C0_SET_SHADER_LOCAL_MEMORY_A(uint32_t *val_out, struct nv_nvc9c0_SET_SHADER_LOCAL_MEMORY_A st)
{
    uint32_t val = 0;
    
    assert(st.address_upper < (1ULL << 17));
    val |= st.address_upper << 0;
    *val_out = val;
}

#define V_NVC9C0_SET_SHADER_LOCAL_MEMORY_A(val, args...) { \
    struct nv_nvc9c0_SET_SHADER_LOCAL_MEMORY_A __data = { .address_upper = (args) }; \
    __NVC9C0_SET_SHADER_LOCAL_MEMORY_A(&val, __data); \
}

#define VA_NVC9C0_SET_SHADER_LOCAL_MEMORY_A V_NVC9C0_SET_SHADER_LOCAL_MEMORY_A

#define P_NVC9C0_SET_SHADER_LOCAL_MEMORY_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_SHADER_LOCAL_MEMORY_A(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_SHADER_LOCAL_MEMORY_A, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_SHADER_LOCAL_MEMORY_B {
    uint32_t address_lower;
};

static inline void
__NVC9C0_SET_SHADER_LOCAL_MEMORY_B(uint32_t *val_out, struct nv_nvc9c0_SET_SHADER_LOCAL_MEMORY_B st)
{
    uint32_t val = 0;
    
    val |= st.address_lower;
    *val_out = val;
}

#define V_NVC9C0_SET_SHADER_LOCAL_MEMORY_B(val, args...) { \
    struct nv_nvc9c0_SET_SHADER_LOCAL_MEMORY_B __data = { .address_lower = (args) }; \
    __NVC9C0_SET_SHADER_LOCAL_MEMORY_B(&val, __data); \
}

#define VA_NVC9C0_SET_SHADER_LOCAL_MEMORY_B V_NVC9C0_SET_SHADER_LOCAL_MEMORY_B

#define P_NVC9C0_SET_SHADER_LOCAL_MEMORY_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_SHADER_LOCAL_MEMORY_B(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_SHADER_LOCAL_MEMORY_B, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_SHADER_LOCAL_MEMORY_WINDOW_A {
    uint32_t base_address_upper;
};

static inline void
__NVC9C0_SET_SHADER_LOCAL_MEMORY_WINDOW_A(uint32_t *val_out, struct nv_nvc9c0_SET_SHADER_LOCAL_MEMORY_WINDOW_A st)
{
    uint32_t val = 0;
    
    assert(st.base_address_upper < (1ULL << 17));
    val |= st.base_address_upper << 0;
    *val_out = val;
}

#define V_NVC9C0_SET_SHADER_LOCAL_MEMORY_WINDOW_A(val, args...) { \
    struct nv_nvc9c0_SET_SHADER_LOCAL_MEMORY_WINDOW_A __data = { .base_address_upper = (args) }; \
    __NVC9C0_SET_SHADER_LOCAL_MEMORY_WINDOW_A(&val, __data); \
}

#define VA_NVC9C0_SET_SHADER_LOCAL_MEMORY_WINDOW_A V_NVC9C0_SET_SHADER_LOCAL_MEMORY_WINDOW_A

#define P_NVC9C0_SET_SHADER_LOCAL_MEMORY_WINDOW_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_SHADER_LOCAL_MEMORY_WINDOW_A(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_SHADER_LOCAL_MEMORY_WINDOW_A, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_SHADER_LOCAL_MEMORY_WINDOW_B {
    uint32_t base_address;
};

static inline void
__NVC9C0_SET_SHADER_LOCAL_MEMORY_WINDOW_B(uint32_t *val_out, struct nv_nvc9c0_SET_SHADER_LOCAL_MEMORY_WINDOW_B st)
{
    uint32_t val = 0;
    
    val |= st.base_address;
    *val_out = val;
}

#define V_NVC9C0_SET_SHADER_LOCAL_MEMORY_WINDOW_B(val, args...) { \
    struct nv_nvc9c0_SET_SHADER_LOCAL_MEMORY_WINDOW_B __data = { .base_address = (args) }; \
    __NVC9C0_SET_SHADER_LOCAL_MEMORY_WINDOW_B(&val, __data); \
}

#define VA_NVC9C0_SET_SHADER_LOCAL_MEMORY_WINDOW_B V_NVC9C0_SET_SHADER_LOCAL_MEMORY_WINDOW_B

#define P_NVC9C0_SET_SHADER_LOCAL_MEMORY_WINDOW_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_SHADER_LOCAL_MEMORY_WINDOW_B(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_SHADER_LOCAL_MEMORY_WINDOW_B, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_THROTTLE_SM {
    uint32_t multiply_add;
};

static inline void
__NVC9C0_THROTTLE_SM(uint32_t *val_out, struct nv_nvc9c0_THROTTLE_SM st)
{
    uint32_t val = 0;
    
    assert(st.multiply_add < (1ULL << 1));
    val |= st.multiply_add << 0;
    *val_out = val;
}

#define V_NVC9C0_THROTTLE_SM(val, args...) { \
    UNUSED uint32_t MULTIPLY_ADD_FALSE = NVC9C0_THROTTLE_SM_MULTIPLY_ADD_FALSE; \
    UNUSED uint32_t MULTIPLY_ADD_TRUE = NVC9C0_THROTTLE_SM_MULTIPLY_ADD_TRUE; \
    struct nv_nvc9c0_THROTTLE_SM __data = { .multiply_add = (args) }; \
    __NVC9C0_THROTTLE_SM(&val, __data); \
}

#define VA_NVC9C0_THROTTLE_SM V_NVC9C0_THROTTLE_SM

#define P_NVC9C0_THROTTLE_SM(push, args...) do { \
    UNUSED uint32_t MULTIPLY_ADD_FALSE = NVC9C0_THROTTLE_SM_MULTIPLY_ADD_FALSE; \
    UNUSED uint32_t MULTIPLY_ADD_TRUE = NVC9C0_THROTTLE_SM_MULTIPLY_ADD_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVC9C0_THROTTLE_SM(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_THROTTLE_SM, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_SHADER_CACHE_CONTROL {
    uint32_t icache_prefetch_enable;
};

static inline void
__NVC9C0_SET_SHADER_CACHE_CONTROL(uint32_t *val_out, struct nv_nvc9c0_SET_SHADER_CACHE_CONTROL st)
{
    uint32_t val = 0;
    
    assert(st.icache_prefetch_enable < (1ULL << 1));
    val |= st.icache_prefetch_enable << 0;
    *val_out = val;
}

#define V_NVC9C0_SET_SHADER_CACHE_CONTROL(val, args...) { \
    UNUSED uint32_t ICACHE_PREFETCH_ENABLE_FALSE = NVC9C0_SET_SHADER_CACHE_CONTROL_ICACHE_PREFETCH_ENABLE_FALSE; \
    UNUSED uint32_t ICACHE_PREFETCH_ENABLE_TRUE = NVC9C0_SET_SHADER_CACHE_CONTROL_ICACHE_PREFETCH_ENABLE_TRUE; \
    struct nv_nvc9c0_SET_SHADER_CACHE_CONTROL __data = { .icache_prefetch_enable = (args) }; \
    __NVC9C0_SET_SHADER_CACHE_CONTROL(&val, __data); \
}

#define VA_NVC9C0_SET_SHADER_CACHE_CONTROL V_NVC9C0_SET_SHADER_CACHE_CONTROL

#define P_NVC9C0_SET_SHADER_CACHE_CONTROL(push, args...) do { \
    UNUSED uint32_t ICACHE_PREFETCH_ENABLE_FALSE = NVC9C0_SET_SHADER_CACHE_CONTROL_ICACHE_PREFETCH_ENABLE_FALSE; \
    UNUSED uint32_t ICACHE_PREFETCH_ENABLE_TRUE = NVC9C0_SET_SHADER_CACHE_CONTROL_ICACHE_PREFETCH_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_SHADER_CACHE_CONTROL(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_SHADER_CACHE_CONTROL, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS {
    uint32_t v;
};

static inline void
__NVC9C0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(uint32_t *val_out, struct nv_nvc9c0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(val, args...) { \
    struct nv_nvc9c0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS __data = { .v = (args) }; \
    __NVC9C0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(&val, __data); \
}

#define VA_NVC9C0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(i) V_NVC9C0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS

#define P_NVC9C0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(idx), nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_SM_TIMEOUT_INTERVAL {
    uint32_t counter_bit;
};

static inline void
__NVC9C0_SET_SM_TIMEOUT_INTERVAL(uint32_t *val_out, struct nv_nvc9c0_SET_SM_TIMEOUT_INTERVAL st)
{
    uint32_t val = 0;
    
    assert(st.counter_bit < (1ULL << 6));
    val |= st.counter_bit << 0;
    *val_out = val;
}

#define V_NVC9C0_SET_SM_TIMEOUT_INTERVAL(val, args...) { \
    struct nv_nvc9c0_SET_SM_TIMEOUT_INTERVAL __data = { .counter_bit = (args) }; \
    __NVC9C0_SET_SM_TIMEOUT_INTERVAL(&val, __data); \
}

#define VA_NVC9C0_SET_SM_TIMEOUT_INTERVAL V_NVC9C0_SET_SM_TIMEOUT_INTERVAL

#define P_NVC9C0_SET_SM_TIMEOUT_INTERVAL(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_SM_TIMEOUT_INTERVAL(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_SM_TIMEOUT_INTERVAL, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_MME_DMA_WRITE_METHOD_BARRIER {
    uint32_t v;
};

static inline void
__NVC9C0_MME_DMA_WRITE_METHOD_BARRIER(uint32_t *val_out, struct nv_nvc9c0_MME_DMA_WRITE_METHOD_BARRIER st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 1));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVC9C0_MME_DMA_WRITE_METHOD_BARRIER(val, args...) { \
    struct nv_nvc9c0_MME_DMA_WRITE_METHOD_BARRIER __data = { .v = (args) }; \
    __NVC9C0_MME_DMA_WRITE_METHOD_BARRIER(&val, __data); \
}

#define VA_NVC9C0_MME_DMA_WRITE_METHOD_BARRIER V_NVC9C0_MME_DMA_WRITE_METHOD_BARRIER

#define P_NVC9C0_MME_DMA_WRITE_METHOD_BARRIER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_MME_DMA_WRITE_METHOD_BARRIER(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_MME_DMA_WRITE_METHOD_BARRIER, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI {
    uint32_t lines;
    uint32_t tag;
};

static inline void
__NVC9C0_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI(uint32_t *val_out, struct nv_nvc9c0_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI st)
{
    uint32_t val = 0;
    
    assert(st.lines < (1ULL << 1));
    val |= st.lines << 0;
    
    assert(st.tag < (1ULL << 22));
    val |= st.tag << 4;
    *val_out = val;
}

#define V_NVC9C0_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI(val, args...) { \
    UNUSED uint32_t LINES_ALL = NVC9C0_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI_LINES_ALL; \
    UNUSED uint32_t LINES_ONE = NVC9C0_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI_LINES_ONE; \
    struct nv_nvc9c0_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI __data = args; \
    __NVC9C0_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI(&val, __data); \
}

#define VA_NVC9C0_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI V_NVC9C0_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI

#define P_NVC9C0_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI(push, args...) do { \
    UNUSED uint32_t LINES_ALL = NVC9C0_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI_LINES_ALL; \
    UNUSED uint32_t LINES_ONE = NVC9C0_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI_LINES_ONE; \
    uint32_t nvk_p_ret; \
    V_NVC9C0_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_ACTIVATE_PERF_SETTINGS_FOR_COMPUTE_CONTEXT {
    uint32_t all;
};

static inline void
__NVC9C0_ACTIVATE_PERF_SETTINGS_FOR_COMPUTE_CONTEXT(uint32_t *val_out, struct nv_nvc9c0_ACTIVATE_PERF_SETTINGS_FOR_COMPUTE_CONTEXT st)
{
    uint32_t val = 0;
    
    assert(st.all < (1ULL << 1));
    val |= st.all << 0;
    *val_out = val;
}

#define V_NVC9C0_ACTIVATE_PERF_SETTINGS_FOR_COMPUTE_CONTEXT(val, args...) { \
    UNUSED uint32_t ALL_FALSE = NVC9C0_ACTIVATE_PERF_SETTINGS_FOR_COMPUTE_CONTEXT_ALL_FALSE; \
    UNUSED uint32_t ALL_TRUE = NVC9C0_ACTIVATE_PERF_SETTINGS_FOR_COMPUTE_CONTEXT_ALL_TRUE; \
    struct nv_nvc9c0_ACTIVATE_PERF_SETTINGS_FOR_COMPUTE_CONTEXT __data = { .all = (args) }; \
    __NVC9C0_ACTIVATE_PERF_SETTINGS_FOR_COMPUTE_CONTEXT(&val, __data); \
}

#define VA_NVC9C0_ACTIVATE_PERF_SETTINGS_FOR_COMPUTE_CONTEXT V_NVC9C0_ACTIVATE_PERF_SETTINGS_FOR_COMPUTE_CONTEXT

#define P_NVC9C0_ACTIVATE_PERF_SETTINGS_FOR_COMPUTE_CONTEXT(push, args...) do { \
    UNUSED uint32_t ALL_FALSE = NVC9C0_ACTIVATE_PERF_SETTINGS_FOR_COMPUTE_CONTEXT_ALL_FALSE; \
    UNUSED uint32_t ALL_TRUE = NVC9C0_ACTIVATE_PERF_SETTINGS_FOR_COMPUTE_CONTEXT_ALL_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVC9C0_ACTIVATE_PERF_SETTINGS_FOR_COMPUTE_CONTEXT(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_ACTIVATE_PERF_SETTINGS_FOR_COMPUTE_CONTEXT, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_INVALIDATE_SAMPLER_CACHE {
    uint32_t lines;
    uint32_t tag;
};

static inline void
__NVC9C0_INVALIDATE_SAMPLER_CACHE(uint32_t *val_out, struct nv_nvc9c0_INVALIDATE_SAMPLER_CACHE st)
{
    uint32_t val = 0;
    
    assert(st.lines < (1ULL << 1));
    val |= st.lines << 0;
    
    assert(st.tag < (1ULL << 22));
    val |= st.tag << 4;
    *val_out = val;
}

#define V_NVC9C0_INVALIDATE_SAMPLER_CACHE(val, args...) { \
    UNUSED uint32_t LINES_ALL = NVC9C0_INVALIDATE_SAMPLER_CACHE_LINES_ALL; \
    UNUSED uint32_t LINES_ONE = NVC9C0_INVALIDATE_SAMPLER_CACHE_LINES_ONE; \
    struct nv_nvc9c0_INVALIDATE_SAMPLER_CACHE __data = args; \
    __NVC9C0_INVALIDATE_SAMPLER_CACHE(&val, __data); \
}

#define VA_NVC9C0_INVALIDATE_SAMPLER_CACHE V_NVC9C0_INVALIDATE_SAMPLER_CACHE

#define P_NVC9C0_INVALIDATE_SAMPLER_CACHE(push, args...) do { \
    UNUSED uint32_t LINES_ALL = NVC9C0_INVALIDATE_SAMPLER_CACHE_LINES_ALL; \
    UNUSED uint32_t LINES_ONE = NVC9C0_INVALIDATE_SAMPLER_CACHE_LINES_ONE; \
    uint32_t nvk_p_ret; \
    V_NVC9C0_INVALIDATE_SAMPLER_CACHE(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_INVALIDATE_SAMPLER_CACHE, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_INVALIDATE_TEXTURE_HEADER_CACHE {
    uint32_t lines;
    uint32_t tag;
};

static inline void
__NVC9C0_INVALIDATE_TEXTURE_HEADER_CACHE(uint32_t *val_out, struct nv_nvc9c0_INVALIDATE_TEXTURE_HEADER_CACHE st)
{
    uint32_t val = 0;
    
    assert(st.lines < (1ULL << 1));
    val |= st.lines << 0;
    
    assert(st.tag < (1ULL << 22));
    val |= st.tag << 4;
    *val_out = val;
}

#define V_NVC9C0_INVALIDATE_TEXTURE_HEADER_CACHE(val, args...) { \
    UNUSED uint32_t LINES_ALL = NVC9C0_INVALIDATE_TEXTURE_HEADER_CACHE_LINES_ALL; \
    UNUSED uint32_t LINES_ONE = NVC9C0_INVALIDATE_TEXTURE_HEADER_CACHE_LINES_ONE; \
    struct nv_nvc9c0_INVALIDATE_TEXTURE_HEADER_CACHE __data = args; \
    __NVC9C0_INVALIDATE_TEXTURE_HEADER_CACHE(&val, __data); \
}

#define VA_NVC9C0_INVALIDATE_TEXTURE_HEADER_CACHE V_NVC9C0_INVALIDATE_TEXTURE_HEADER_CACHE

#define P_NVC9C0_INVALIDATE_TEXTURE_HEADER_CACHE(push, args...) do { \
    UNUSED uint32_t LINES_ALL = NVC9C0_INVALIDATE_TEXTURE_HEADER_CACHE_LINES_ALL; \
    UNUSED uint32_t LINES_ONE = NVC9C0_INVALIDATE_TEXTURE_HEADER_CACHE_LINES_ONE; \
    uint32_t nvk_p_ret; \
    V_NVC9C0_INVALIDATE_TEXTURE_HEADER_CACHE(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_INVALIDATE_TEXTURE_HEADER_CACHE, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_INVALIDATE_TEXTURE_DATA_CACHE {
    uint32_t lines;
    uint32_t tag;
};

static inline void
__NVC9C0_INVALIDATE_TEXTURE_DATA_CACHE(uint32_t *val_out, struct nv_nvc9c0_INVALIDATE_TEXTURE_DATA_CACHE st)
{
    uint32_t val = 0;
    
    assert(st.lines < (1ULL << 1));
    val |= st.lines << 0;
    
    assert(st.tag < (1ULL << 22));
    val |= st.tag << 4;
    *val_out = val;
}

#define V_NVC9C0_INVALIDATE_TEXTURE_DATA_CACHE(val, args...) { \
    UNUSED uint32_t LINES_ALL = NVC9C0_INVALIDATE_TEXTURE_DATA_CACHE_LINES_ALL; \
    UNUSED uint32_t LINES_ONE = NVC9C0_INVALIDATE_TEXTURE_DATA_CACHE_LINES_ONE; \
    struct nv_nvc9c0_INVALIDATE_TEXTURE_DATA_CACHE __data = args; \
    __NVC9C0_INVALIDATE_TEXTURE_DATA_CACHE(&val, __data); \
}

#define VA_NVC9C0_INVALIDATE_TEXTURE_DATA_CACHE V_NVC9C0_INVALIDATE_TEXTURE_DATA_CACHE

#define P_NVC9C0_INVALIDATE_TEXTURE_DATA_CACHE(push, args...) do { \
    UNUSED uint32_t LINES_ALL = NVC9C0_INVALIDATE_TEXTURE_DATA_CACHE_LINES_ALL; \
    UNUSED uint32_t LINES_ONE = NVC9C0_INVALIDATE_TEXTURE_DATA_CACHE_LINES_ONE; \
    uint32_t nvk_p_ret; \
    V_NVC9C0_INVALIDATE_TEXTURE_DATA_CACHE(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_INVALIDATE_TEXTURE_DATA_CACHE, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_INVALIDATE_SAMPLER_CACHE_NO_WFI {
    uint32_t lines;
    uint32_t tag;
};

static inline void
__NVC9C0_INVALIDATE_SAMPLER_CACHE_NO_WFI(uint32_t *val_out, struct nv_nvc9c0_INVALIDATE_SAMPLER_CACHE_NO_WFI st)
{
    uint32_t val = 0;
    
    assert(st.lines < (1ULL << 1));
    val |= st.lines << 0;
    
    assert(st.tag < (1ULL << 22));
    val |= st.tag << 4;
    *val_out = val;
}

#define V_NVC9C0_INVALIDATE_SAMPLER_CACHE_NO_WFI(val, args...) { \
    UNUSED uint32_t LINES_ALL = NVC9C0_INVALIDATE_SAMPLER_CACHE_NO_WFI_LINES_ALL; \
    UNUSED uint32_t LINES_ONE = NVC9C0_INVALIDATE_SAMPLER_CACHE_NO_WFI_LINES_ONE; \
    struct nv_nvc9c0_INVALIDATE_SAMPLER_CACHE_NO_WFI __data = args; \
    __NVC9C0_INVALIDATE_SAMPLER_CACHE_NO_WFI(&val, __data); \
}

#define VA_NVC9C0_INVALIDATE_SAMPLER_CACHE_NO_WFI V_NVC9C0_INVALIDATE_SAMPLER_CACHE_NO_WFI

#define P_NVC9C0_INVALIDATE_SAMPLER_CACHE_NO_WFI(push, args...) do { \
    UNUSED uint32_t LINES_ALL = NVC9C0_INVALIDATE_SAMPLER_CACHE_NO_WFI_LINES_ALL; \
    UNUSED uint32_t LINES_ONE = NVC9C0_INVALIDATE_SAMPLER_CACHE_NO_WFI_LINES_ONE; \
    uint32_t nvk_p_ret; \
    V_NVC9C0_INVALIDATE_SAMPLER_CACHE_NO_WFI(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_INVALIDATE_SAMPLER_CACHE_NO_WFI, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_SHADER_EXCEPTIONS {
    uint32_t enable;
};

static inline void
__NVC9C0_SET_SHADER_EXCEPTIONS(uint32_t *val_out, struct nv_nvc9c0_SET_SHADER_EXCEPTIONS st)
{
    uint32_t val = 0;
    
    assert(st.enable < (1ULL << 1));
    val |= st.enable << 0;
    *val_out = val;
}

#define V_NVC9C0_SET_SHADER_EXCEPTIONS(val, args...) { \
    UNUSED uint32_t ENABLE_FALSE = NVC9C0_SET_SHADER_EXCEPTIONS_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVC9C0_SET_SHADER_EXCEPTIONS_ENABLE_TRUE; \
    struct nv_nvc9c0_SET_SHADER_EXCEPTIONS __data = { .enable = (args) }; \
    __NVC9C0_SET_SHADER_EXCEPTIONS(&val, __data); \
}

#define VA_NVC9C0_SET_SHADER_EXCEPTIONS V_NVC9C0_SET_SHADER_EXCEPTIONS

#define P_NVC9C0_SET_SHADER_EXCEPTIONS(push, args...) do { \
    UNUSED uint32_t ENABLE_FALSE = NVC9C0_SET_SHADER_EXCEPTIONS_ENABLE_FALSE; \
    UNUSED uint32_t ENABLE_TRUE = NVC9C0_SET_SHADER_EXCEPTIONS_ENABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_SHADER_EXCEPTIONS(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_SHADER_EXCEPTIONS, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_RENDER_ENABLE_A {
    uint32_t offset_upper;
};

static inline void
__NVC9C0_SET_RENDER_ENABLE_A(uint32_t *val_out, struct nv_nvc9c0_SET_RENDER_ENABLE_A st)
{
    uint32_t val = 0;
    
    assert(st.offset_upper < (1ULL << 8));
    val |= st.offset_upper << 0;
    *val_out = val;
}

#define V_NVC9C0_SET_RENDER_ENABLE_A(val, args...) { \
    struct nv_nvc9c0_SET_RENDER_ENABLE_A __data = { .offset_upper = (args) }; \
    __NVC9C0_SET_RENDER_ENABLE_A(&val, __data); \
}

#define VA_NVC9C0_SET_RENDER_ENABLE_A V_NVC9C0_SET_RENDER_ENABLE_A

#define P_NVC9C0_SET_RENDER_ENABLE_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_RENDER_ENABLE_A(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_RENDER_ENABLE_A, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_RENDER_ENABLE_B {
    uint32_t offset_lower;
};

static inline void
__NVC9C0_SET_RENDER_ENABLE_B(uint32_t *val_out, struct nv_nvc9c0_SET_RENDER_ENABLE_B st)
{
    uint32_t val = 0;
    
    val |= st.offset_lower;
    *val_out = val;
}

#define V_NVC9C0_SET_RENDER_ENABLE_B(val, args...) { \
    struct nv_nvc9c0_SET_RENDER_ENABLE_B __data = { .offset_lower = (args) }; \
    __NVC9C0_SET_RENDER_ENABLE_B(&val, __data); \
}

#define VA_NVC9C0_SET_RENDER_ENABLE_B V_NVC9C0_SET_RENDER_ENABLE_B

#define P_NVC9C0_SET_RENDER_ENABLE_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_RENDER_ENABLE_B(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_RENDER_ENABLE_B, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_RENDER_ENABLE_C {
    uint32_t mode;
};

static inline void
__NVC9C0_SET_RENDER_ENABLE_C(uint32_t *val_out, struct nv_nvc9c0_SET_RENDER_ENABLE_C st)
{
    uint32_t val = 0;
    
    assert(st.mode < (1ULL << 3));
    val |= st.mode << 0;
    *val_out = val;
}

#define V_NVC9C0_SET_RENDER_ENABLE_C(val, args...) { \
    UNUSED uint32_t MODE_FALSE = NVC9C0_SET_RENDER_ENABLE_C_MODE_FALSE; \
    UNUSED uint32_t MODE_TRUE = NVC9C0_SET_RENDER_ENABLE_C_MODE_TRUE; \
    UNUSED uint32_t MODE_CONDITIONAL = NVC9C0_SET_RENDER_ENABLE_C_MODE_CONDITIONAL; \
    UNUSED uint32_t MODE_RENDER_IF_EQUAL = NVC9C0_SET_RENDER_ENABLE_C_MODE_RENDER_IF_EQUAL; \
    UNUSED uint32_t MODE_RENDER_IF_NOT_EQUAL = NVC9C0_SET_RENDER_ENABLE_C_MODE_RENDER_IF_NOT_EQUAL; \
    struct nv_nvc9c0_SET_RENDER_ENABLE_C __data = { .mode = (args) }; \
    __NVC9C0_SET_RENDER_ENABLE_C(&val, __data); \
}

#define VA_NVC9C0_SET_RENDER_ENABLE_C V_NVC9C0_SET_RENDER_ENABLE_C

#define P_NVC9C0_SET_RENDER_ENABLE_C(push, args...) do { \
    UNUSED uint32_t MODE_FALSE = NVC9C0_SET_RENDER_ENABLE_C_MODE_FALSE; \
    UNUSED uint32_t MODE_TRUE = NVC9C0_SET_RENDER_ENABLE_C_MODE_TRUE; \
    UNUSED uint32_t MODE_CONDITIONAL = NVC9C0_SET_RENDER_ENABLE_C_MODE_CONDITIONAL; \
    UNUSED uint32_t MODE_RENDER_IF_EQUAL = NVC9C0_SET_RENDER_ENABLE_C_MODE_RENDER_IF_EQUAL; \
    UNUSED uint32_t MODE_RENDER_IF_NOT_EQUAL = NVC9C0_SET_RENDER_ENABLE_C_MODE_RENDER_IF_NOT_EQUAL; \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_RENDER_ENABLE_C(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_RENDER_ENABLE_C, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_TEX_SAMPLER_POOL_A {
    uint32_t offset_upper;
};

static inline void
__NVC9C0_SET_TEX_SAMPLER_POOL_A(uint32_t *val_out, struct nv_nvc9c0_SET_TEX_SAMPLER_POOL_A st)
{
    uint32_t val = 0;
    
    assert(st.offset_upper < (1ULL << 17));
    val |= st.offset_upper << 0;
    *val_out = val;
}

#define V_NVC9C0_SET_TEX_SAMPLER_POOL_A(val, args...) { \
    struct nv_nvc9c0_SET_TEX_SAMPLER_POOL_A __data = { .offset_upper = (args) }; \
    __NVC9C0_SET_TEX_SAMPLER_POOL_A(&val, __data); \
}

#define VA_NVC9C0_SET_TEX_SAMPLER_POOL_A V_NVC9C0_SET_TEX_SAMPLER_POOL_A

#define P_NVC9C0_SET_TEX_SAMPLER_POOL_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_TEX_SAMPLER_POOL_A(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_TEX_SAMPLER_POOL_A, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_TEX_SAMPLER_POOL_B {
    uint32_t offset_lower;
};

static inline void
__NVC9C0_SET_TEX_SAMPLER_POOL_B(uint32_t *val_out, struct nv_nvc9c0_SET_TEX_SAMPLER_POOL_B st)
{
    uint32_t val = 0;
    
    val |= st.offset_lower;
    *val_out = val;
}

#define V_NVC9C0_SET_TEX_SAMPLER_POOL_B(val, args...) { \
    struct nv_nvc9c0_SET_TEX_SAMPLER_POOL_B __data = { .offset_lower = (args) }; \
    __NVC9C0_SET_TEX_SAMPLER_POOL_B(&val, __data); \
}

#define VA_NVC9C0_SET_TEX_SAMPLER_POOL_B V_NVC9C0_SET_TEX_SAMPLER_POOL_B

#define P_NVC9C0_SET_TEX_SAMPLER_POOL_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_TEX_SAMPLER_POOL_B(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_TEX_SAMPLER_POOL_B, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_TEX_SAMPLER_POOL_C {
    uint32_t maximum_index;
};

static inline void
__NVC9C0_SET_TEX_SAMPLER_POOL_C(uint32_t *val_out, struct nv_nvc9c0_SET_TEX_SAMPLER_POOL_C st)
{
    uint32_t val = 0;
    
    assert(st.maximum_index < (1ULL << 20));
    val |= st.maximum_index << 0;
    *val_out = val;
}

#define V_NVC9C0_SET_TEX_SAMPLER_POOL_C(val, args...) { \
    struct nv_nvc9c0_SET_TEX_SAMPLER_POOL_C __data = { .maximum_index = (args) }; \
    __NVC9C0_SET_TEX_SAMPLER_POOL_C(&val, __data); \
}

#define VA_NVC9C0_SET_TEX_SAMPLER_POOL_C V_NVC9C0_SET_TEX_SAMPLER_POOL_C

#define P_NVC9C0_SET_TEX_SAMPLER_POOL_C(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_TEX_SAMPLER_POOL_C(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_TEX_SAMPLER_POOL_C, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_TEX_HEADER_POOL_A {
    uint32_t offset_upper;
};

static inline void
__NVC9C0_SET_TEX_HEADER_POOL_A(uint32_t *val_out, struct nv_nvc9c0_SET_TEX_HEADER_POOL_A st)
{
    uint32_t val = 0;
    
    assert(st.offset_upper < (1ULL << 17));
    val |= st.offset_upper << 0;
    *val_out = val;
}

#define V_NVC9C0_SET_TEX_HEADER_POOL_A(val, args...) { \
    struct nv_nvc9c0_SET_TEX_HEADER_POOL_A __data = { .offset_upper = (args) }; \
    __NVC9C0_SET_TEX_HEADER_POOL_A(&val, __data); \
}

#define VA_NVC9C0_SET_TEX_HEADER_POOL_A V_NVC9C0_SET_TEX_HEADER_POOL_A

#define P_NVC9C0_SET_TEX_HEADER_POOL_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_TEX_HEADER_POOL_A(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_TEX_HEADER_POOL_A, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_TEX_HEADER_POOL_B {
    uint32_t offset_lower;
};

static inline void
__NVC9C0_SET_TEX_HEADER_POOL_B(uint32_t *val_out, struct nv_nvc9c0_SET_TEX_HEADER_POOL_B st)
{
    uint32_t val = 0;
    
    val |= st.offset_lower;
    *val_out = val;
}

#define V_NVC9C0_SET_TEX_HEADER_POOL_B(val, args...) { \
    struct nv_nvc9c0_SET_TEX_HEADER_POOL_B __data = { .offset_lower = (args) }; \
    __NVC9C0_SET_TEX_HEADER_POOL_B(&val, __data); \
}

#define VA_NVC9C0_SET_TEX_HEADER_POOL_B V_NVC9C0_SET_TEX_HEADER_POOL_B

#define P_NVC9C0_SET_TEX_HEADER_POOL_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_TEX_HEADER_POOL_B(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_TEX_HEADER_POOL_B, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_TEX_HEADER_POOL_C {
    uint32_t maximum_index;
};

static inline void
__NVC9C0_SET_TEX_HEADER_POOL_C(uint32_t *val_out, struct nv_nvc9c0_SET_TEX_HEADER_POOL_C st)
{
    uint32_t val = 0;
    
    assert(st.maximum_index < (1ULL << 22));
    val |= st.maximum_index << 0;
    *val_out = val;
}

#define V_NVC9C0_SET_TEX_HEADER_POOL_C(val, args...) { \
    struct nv_nvc9c0_SET_TEX_HEADER_POOL_C __data = { .maximum_index = (args) }; \
    __NVC9C0_SET_TEX_HEADER_POOL_C(&val, __data); \
}

#define VA_NVC9C0_SET_TEX_HEADER_POOL_C V_NVC9C0_SET_TEX_HEADER_POOL_C

#define P_NVC9C0_SET_TEX_HEADER_POOL_C(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_TEX_HEADER_POOL_C(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_TEX_HEADER_POOL_C, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_INVALIDATE_SHADER_CACHES_NO_WFI {
    uint32_t instruction;
    uint32_t global_data;
    uint32_t constant;
};

static inline void
__NVC9C0_INVALIDATE_SHADER_CACHES_NO_WFI(uint32_t *val_out, struct nv_nvc9c0_INVALIDATE_SHADER_CACHES_NO_WFI st)
{
    uint32_t val = 0;
    
    assert(st.instruction < (1ULL << 1));
    val |= st.instruction << 0;
    
    assert(st.global_data < (1ULL << 1));
    val |= st.global_data << 4;
    
    assert(st.constant < (1ULL << 1));
    val |= st.constant << 12;
    *val_out = val;
}

#define V_NVC9C0_INVALIDATE_SHADER_CACHES_NO_WFI(val, args...) { \
    UNUSED uint32_t INSTRUCTION_FALSE = NVC9C0_INVALIDATE_SHADER_CACHES_NO_WFI_INSTRUCTION_FALSE; \
    UNUSED uint32_t INSTRUCTION_TRUE = NVC9C0_INVALIDATE_SHADER_CACHES_NO_WFI_INSTRUCTION_TRUE; \
    UNUSED uint32_t GLOBAL_DATA_FALSE = NVC9C0_INVALIDATE_SHADER_CACHES_NO_WFI_GLOBAL_DATA_FALSE; \
    UNUSED uint32_t GLOBAL_DATA_TRUE = NVC9C0_INVALIDATE_SHADER_CACHES_NO_WFI_GLOBAL_DATA_TRUE; \
    UNUSED uint32_t CONSTANT_FALSE = NVC9C0_INVALIDATE_SHADER_CACHES_NO_WFI_CONSTANT_FALSE; \
    UNUSED uint32_t CONSTANT_TRUE = NVC9C0_INVALIDATE_SHADER_CACHES_NO_WFI_CONSTANT_TRUE; \
    struct nv_nvc9c0_INVALIDATE_SHADER_CACHES_NO_WFI __data = args; \
    __NVC9C0_INVALIDATE_SHADER_CACHES_NO_WFI(&val, __data); \
}

#define VA_NVC9C0_INVALIDATE_SHADER_CACHES_NO_WFI V_NVC9C0_INVALIDATE_SHADER_CACHES_NO_WFI

#define P_NVC9C0_INVALIDATE_SHADER_CACHES_NO_WFI(push, args...) do { \
    UNUSED uint32_t INSTRUCTION_FALSE = NVC9C0_INVALIDATE_SHADER_CACHES_NO_WFI_INSTRUCTION_FALSE; \
    UNUSED uint32_t INSTRUCTION_TRUE = NVC9C0_INVALIDATE_SHADER_CACHES_NO_WFI_INSTRUCTION_TRUE; \
    UNUSED uint32_t GLOBAL_DATA_FALSE = NVC9C0_INVALIDATE_SHADER_CACHES_NO_WFI_GLOBAL_DATA_FALSE; \
    UNUSED uint32_t GLOBAL_DATA_TRUE = NVC9C0_INVALIDATE_SHADER_CACHES_NO_WFI_GLOBAL_DATA_TRUE; \
    UNUSED uint32_t CONSTANT_FALSE = NVC9C0_INVALIDATE_SHADER_CACHES_NO_WFI_CONSTANT_FALSE; \
    UNUSED uint32_t CONSTANT_TRUE = NVC9C0_INVALIDATE_SHADER_CACHES_NO_WFI_CONSTANT_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVC9C0_INVALIDATE_SHADER_CACHES_NO_WFI(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_INVALIDATE_SHADER_CACHES_NO_WFI, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_RENDER_ENABLE_OVERRIDE {
    uint32_t mode;
};

static inline void
__NVC9C0_SET_RENDER_ENABLE_OVERRIDE(uint32_t *val_out, struct nv_nvc9c0_SET_RENDER_ENABLE_OVERRIDE st)
{
    uint32_t val = 0;
    
    assert(st.mode < (1ULL << 2));
    val |= st.mode << 0;
    *val_out = val;
}

#define V_NVC9C0_SET_RENDER_ENABLE_OVERRIDE(val, args...) { \
    UNUSED uint32_t MODE_USE_RENDER_ENABLE = NVC9C0_SET_RENDER_ENABLE_OVERRIDE_MODE_USE_RENDER_ENABLE; \
    UNUSED uint32_t MODE_ALWAYS_RENDER = NVC9C0_SET_RENDER_ENABLE_OVERRIDE_MODE_ALWAYS_RENDER; \
    UNUSED uint32_t MODE_NEVER_RENDER = NVC9C0_SET_RENDER_ENABLE_OVERRIDE_MODE_NEVER_RENDER; \
    struct nv_nvc9c0_SET_RENDER_ENABLE_OVERRIDE __data = { .mode = (args) }; \
    __NVC9C0_SET_RENDER_ENABLE_OVERRIDE(&val, __data); \
}

#define VA_NVC9C0_SET_RENDER_ENABLE_OVERRIDE V_NVC9C0_SET_RENDER_ENABLE_OVERRIDE

#define P_NVC9C0_SET_RENDER_ENABLE_OVERRIDE(push, args...) do { \
    UNUSED uint32_t MODE_USE_RENDER_ENABLE = NVC9C0_SET_RENDER_ENABLE_OVERRIDE_MODE_USE_RENDER_ENABLE; \
    UNUSED uint32_t MODE_ALWAYS_RENDER = NVC9C0_SET_RENDER_ENABLE_OVERRIDE_MODE_ALWAYS_RENDER; \
    UNUSED uint32_t MODE_NEVER_RENDER = NVC9C0_SET_RENDER_ENABLE_OVERRIDE_MODE_NEVER_RENDER; \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_RENDER_ENABLE_OVERRIDE(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_RENDER_ENABLE_OVERRIDE, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_PIPE_NOP {
    uint32_t v;
};

static inline void
__NVC9C0_PIPE_NOP(uint32_t *val_out, struct nv_nvc9c0_PIPE_NOP st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_PIPE_NOP(val, args...) { \
    struct nv_nvc9c0_PIPE_NOP __data = { .v = (args) }; \
    __NVC9C0_PIPE_NOP(&val, __data); \
}

#define VA_NVC9C0_PIPE_NOP V_NVC9C0_PIPE_NOP

#define P_NVC9C0_PIPE_NOP(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_PIPE_NOP(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_PIPE_NOP, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_SPARE00 {
    uint32_t v;
};

static inline void
__NVC9C0_SET_SPARE00(uint32_t *val_out, struct nv_nvc9c0_SET_SPARE00 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_SET_SPARE00(val, args...) { \
    struct nv_nvc9c0_SET_SPARE00 __data = { .v = (args) }; \
    __NVC9C0_SET_SPARE00(&val, __data); \
}

#define VA_NVC9C0_SET_SPARE00 V_NVC9C0_SET_SPARE00

#define P_NVC9C0_SET_SPARE00(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_SPARE00(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_SPARE00, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_SPARE01 {
    uint32_t v;
};

static inline void
__NVC9C0_SET_SPARE01(uint32_t *val_out, struct nv_nvc9c0_SET_SPARE01 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_SET_SPARE01(val, args...) { \
    struct nv_nvc9c0_SET_SPARE01 __data = { .v = (args) }; \
    __NVC9C0_SET_SPARE01(&val, __data); \
}

#define VA_NVC9C0_SET_SPARE01 V_NVC9C0_SET_SPARE01

#define P_NVC9C0_SET_SPARE01(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_SPARE01(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_SPARE01, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_SPARE02 {
    uint32_t v;
};

static inline void
__NVC9C0_SET_SPARE02(uint32_t *val_out, struct nv_nvc9c0_SET_SPARE02 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_SET_SPARE02(val, args...) { \
    struct nv_nvc9c0_SET_SPARE02 __data = { .v = (args) }; \
    __NVC9C0_SET_SPARE02(&val, __data); \
}

#define VA_NVC9C0_SET_SPARE02 V_NVC9C0_SET_SPARE02

#define P_NVC9C0_SET_SPARE02(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_SPARE02(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_SPARE02, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_SPARE03 {
    uint32_t v;
};

static inline void
__NVC9C0_SET_SPARE03(uint32_t *val_out, struct nv_nvc9c0_SET_SPARE03 st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_SET_SPARE03(val, args...) { \
    struct nv_nvc9c0_SET_SPARE03 __data = { .v = (args) }; \
    __NVC9C0_SET_SPARE03(&val, __data); \
}

#define VA_NVC9C0_SET_SPARE03 V_NVC9C0_SET_SPARE03

#define P_NVC9C0_SET_SPARE03(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_SPARE03(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_SPARE03, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_REPORT_SEMAPHORE_A {
    uint32_t offset_upper;
};

static inline void
__NVC9C0_SET_REPORT_SEMAPHORE_A(uint32_t *val_out, struct nv_nvc9c0_SET_REPORT_SEMAPHORE_A st)
{
    uint32_t val = 0;
    
    assert(st.offset_upper < (1ULL << 8));
    val |= st.offset_upper << 0;
    *val_out = val;
}

#define V_NVC9C0_SET_REPORT_SEMAPHORE_A(val, args...) { \
    struct nv_nvc9c0_SET_REPORT_SEMAPHORE_A __data = { .offset_upper = (args) }; \
    __NVC9C0_SET_REPORT_SEMAPHORE_A(&val, __data); \
}

#define VA_NVC9C0_SET_REPORT_SEMAPHORE_A V_NVC9C0_SET_REPORT_SEMAPHORE_A

#define P_NVC9C0_SET_REPORT_SEMAPHORE_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_REPORT_SEMAPHORE_A(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_REPORT_SEMAPHORE_A, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_REPORT_SEMAPHORE_B {
    uint32_t offset_lower;
};

static inline void
__NVC9C0_SET_REPORT_SEMAPHORE_B(uint32_t *val_out, struct nv_nvc9c0_SET_REPORT_SEMAPHORE_B st)
{
    uint32_t val = 0;
    
    val |= st.offset_lower;
    *val_out = val;
}

#define V_NVC9C0_SET_REPORT_SEMAPHORE_B(val, args...) { \
    struct nv_nvc9c0_SET_REPORT_SEMAPHORE_B __data = { .offset_lower = (args) }; \
    __NVC9C0_SET_REPORT_SEMAPHORE_B(&val, __data); \
}

#define VA_NVC9C0_SET_REPORT_SEMAPHORE_B V_NVC9C0_SET_REPORT_SEMAPHORE_B

#define P_NVC9C0_SET_REPORT_SEMAPHORE_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_REPORT_SEMAPHORE_B(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_REPORT_SEMAPHORE_B, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_REPORT_SEMAPHORE_C {
    uint32_t payload;
};

static inline void
__NVC9C0_SET_REPORT_SEMAPHORE_C(uint32_t *val_out, struct nv_nvc9c0_SET_REPORT_SEMAPHORE_C st)
{
    uint32_t val = 0;
    
    val |= st.payload;
    *val_out = val;
}

#define V_NVC9C0_SET_REPORT_SEMAPHORE_C(val, args...) { \
    struct nv_nvc9c0_SET_REPORT_SEMAPHORE_C __data = { .payload = (args) }; \
    __NVC9C0_SET_REPORT_SEMAPHORE_C(&val, __data); \
}

#define VA_NVC9C0_SET_REPORT_SEMAPHORE_C V_NVC9C0_SET_REPORT_SEMAPHORE_C

#define P_NVC9C0_SET_REPORT_SEMAPHORE_C(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_REPORT_SEMAPHORE_C(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_REPORT_SEMAPHORE_C, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_REPORT_SEMAPHORE_D {
    uint32_t operation;
    uint32_t awaken_enable;
    uint32_t structure_size;
    uint32_t flush_disable;
    uint32_t reduction_enable;
    uint32_t reduction_op;
    uint32_t reduction_format;
    uint32_t conditional_trap;
};

static inline void
__NVC9C0_SET_REPORT_SEMAPHORE_D(uint32_t *val_out, struct nv_nvc9c0_SET_REPORT_SEMAPHORE_D st)
{
    uint32_t val = 0;
    
    assert(st.operation < (1ULL << 2));
    val |= st.operation << 0;
    
    assert(st.awaken_enable < (1ULL << 1));
    val |= st.awaken_enable << 20;
    
    assert(st.structure_size < (1ULL << 1));
    val |= st.structure_size << 28;
    
    assert(st.flush_disable < (1ULL << 1));
    val |= st.flush_disable << 2;
    
    assert(st.reduction_enable < (1ULL << 1));
    val |= st.reduction_enable << 3;
    
    assert(st.reduction_op < (1ULL << 3));
    val |= st.reduction_op << 9;
    
    assert(st.reduction_format < (1ULL << 2));
    val |= st.reduction_format << 17;
    
    assert(st.conditional_trap < (1ULL << 1));
    val |= st.conditional_trap << 19;
    *val_out = val;
}

#define V_NVC9C0_SET_REPORT_SEMAPHORE_D(val, args...) { \
    UNUSED uint32_t OPERATION_RELEASE = NVC9C0_SET_REPORT_SEMAPHORE_D_OPERATION_RELEASE; \
    UNUSED uint32_t OPERATION_TRAP = NVC9C0_SET_REPORT_SEMAPHORE_D_OPERATION_TRAP; \
    UNUSED uint32_t AWAKEN_ENABLE_FALSE = NVC9C0_SET_REPORT_SEMAPHORE_D_AWAKEN_ENABLE_FALSE; \
    UNUSED uint32_t AWAKEN_ENABLE_TRUE = NVC9C0_SET_REPORT_SEMAPHORE_D_AWAKEN_ENABLE_TRUE; \
    UNUSED uint32_t STRUCTURE_SIZE_FOUR_WORDS = NVC9C0_SET_REPORT_SEMAPHORE_D_STRUCTURE_SIZE_FOUR_WORDS; \
    UNUSED uint32_t STRUCTURE_SIZE_ONE_WORD = NVC9C0_SET_REPORT_SEMAPHORE_D_STRUCTURE_SIZE_ONE_WORD; \
    UNUSED uint32_t FLUSH_DISABLE_FALSE = NVC9C0_SET_REPORT_SEMAPHORE_D_FLUSH_DISABLE_FALSE; \
    UNUSED uint32_t FLUSH_DISABLE_TRUE = NVC9C0_SET_REPORT_SEMAPHORE_D_FLUSH_DISABLE_TRUE; \
    UNUSED uint32_t REDUCTION_ENABLE_FALSE = NVC9C0_SET_REPORT_SEMAPHORE_D_REDUCTION_ENABLE_FALSE; \
    UNUSED uint32_t REDUCTION_ENABLE_TRUE = NVC9C0_SET_REPORT_SEMAPHORE_D_REDUCTION_ENABLE_TRUE; \
    UNUSED uint32_t REDUCTION_OP_RED_ADD = NVC9C0_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_ADD; \
    UNUSED uint32_t REDUCTION_OP_RED_MIN = NVC9C0_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_MIN; \
    UNUSED uint32_t REDUCTION_OP_RED_MAX = NVC9C0_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_MAX; \
    UNUSED uint32_t REDUCTION_OP_RED_INC = NVC9C0_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_INC; \
    UNUSED uint32_t REDUCTION_OP_RED_DEC = NVC9C0_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_DEC; \
    UNUSED uint32_t REDUCTION_OP_RED_AND = NVC9C0_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_AND; \
    UNUSED uint32_t REDUCTION_OP_RED_OR = NVC9C0_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_OR; \
    UNUSED uint32_t REDUCTION_OP_RED_XOR = NVC9C0_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_XOR; \
    UNUSED uint32_t REDUCTION_FORMAT_UNSIGNED_32 = NVC9C0_SET_REPORT_SEMAPHORE_D_REDUCTION_FORMAT_UNSIGNED_32; \
    UNUSED uint32_t REDUCTION_FORMAT_SIGNED_32 = NVC9C0_SET_REPORT_SEMAPHORE_D_REDUCTION_FORMAT_SIGNED_32; \
    UNUSED uint32_t CONDITIONAL_TRAP_FALSE = NVC9C0_SET_REPORT_SEMAPHORE_D_CONDITIONAL_TRAP_FALSE; \
    UNUSED uint32_t CONDITIONAL_TRAP_TRUE = NVC9C0_SET_REPORT_SEMAPHORE_D_CONDITIONAL_TRAP_TRUE; \
    struct nv_nvc9c0_SET_REPORT_SEMAPHORE_D __data = args; \
    __NVC9C0_SET_REPORT_SEMAPHORE_D(&val, __data); \
}

#define VA_NVC9C0_SET_REPORT_SEMAPHORE_D V_NVC9C0_SET_REPORT_SEMAPHORE_D

#define P_NVC9C0_SET_REPORT_SEMAPHORE_D(push, args...) do { \
    UNUSED uint32_t OPERATION_RELEASE = NVC9C0_SET_REPORT_SEMAPHORE_D_OPERATION_RELEASE; \
    UNUSED uint32_t OPERATION_TRAP = NVC9C0_SET_REPORT_SEMAPHORE_D_OPERATION_TRAP; \
    UNUSED uint32_t AWAKEN_ENABLE_FALSE = NVC9C0_SET_REPORT_SEMAPHORE_D_AWAKEN_ENABLE_FALSE; \
    UNUSED uint32_t AWAKEN_ENABLE_TRUE = NVC9C0_SET_REPORT_SEMAPHORE_D_AWAKEN_ENABLE_TRUE; \
    UNUSED uint32_t STRUCTURE_SIZE_FOUR_WORDS = NVC9C0_SET_REPORT_SEMAPHORE_D_STRUCTURE_SIZE_FOUR_WORDS; \
    UNUSED uint32_t STRUCTURE_SIZE_ONE_WORD = NVC9C0_SET_REPORT_SEMAPHORE_D_STRUCTURE_SIZE_ONE_WORD; \
    UNUSED uint32_t FLUSH_DISABLE_FALSE = NVC9C0_SET_REPORT_SEMAPHORE_D_FLUSH_DISABLE_FALSE; \
    UNUSED uint32_t FLUSH_DISABLE_TRUE = NVC9C0_SET_REPORT_SEMAPHORE_D_FLUSH_DISABLE_TRUE; \
    UNUSED uint32_t REDUCTION_ENABLE_FALSE = NVC9C0_SET_REPORT_SEMAPHORE_D_REDUCTION_ENABLE_FALSE; \
    UNUSED uint32_t REDUCTION_ENABLE_TRUE = NVC9C0_SET_REPORT_SEMAPHORE_D_REDUCTION_ENABLE_TRUE; \
    UNUSED uint32_t REDUCTION_OP_RED_ADD = NVC9C0_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_ADD; \
    UNUSED uint32_t REDUCTION_OP_RED_MIN = NVC9C0_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_MIN; \
    UNUSED uint32_t REDUCTION_OP_RED_MAX = NVC9C0_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_MAX; \
    UNUSED uint32_t REDUCTION_OP_RED_INC = NVC9C0_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_INC; \
    UNUSED uint32_t REDUCTION_OP_RED_DEC = NVC9C0_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_DEC; \
    UNUSED uint32_t REDUCTION_OP_RED_AND = NVC9C0_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_AND; \
    UNUSED uint32_t REDUCTION_OP_RED_OR = NVC9C0_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_OR; \
    UNUSED uint32_t REDUCTION_OP_RED_XOR = NVC9C0_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_XOR; \
    UNUSED uint32_t REDUCTION_FORMAT_UNSIGNED_32 = NVC9C0_SET_REPORT_SEMAPHORE_D_REDUCTION_FORMAT_UNSIGNED_32; \
    UNUSED uint32_t REDUCTION_FORMAT_SIGNED_32 = NVC9C0_SET_REPORT_SEMAPHORE_D_REDUCTION_FORMAT_SIGNED_32; \
    UNUSED uint32_t CONDITIONAL_TRAP_FALSE = NVC9C0_SET_REPORT_SEMAPHORE_D_CONDITIONAL_TRAP_FALSE; \
    UNUSED uint32_t CONDITIONAL_TRAP_TRUE = NVC9C0_SET_REPORT_SEMAPHORE_D_CONDITIONAL_TRAP_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_REPORT_SEMAPHORE_D(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_REPORT_SEMAPHORE_D, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_TRAP_HANDLER_A {
    uint32_t address_upper;
};

static inline void
__NVC9C0_SET_TRAP_HANDLER_A(uint32_t *val_out, struct nv_nvc9c0_SET_TRAP_HANDLER_A st)
{
    uint32_t val = 0;
    
    assert(st.address_upper < (1ULL << 17));
    val |= st.address_upper << 0;
    *val_out = val;
}

#define V_NVC9C0_SET_TRAP_HANDLER_A(val, args...) { \
    struct nv_nvc9c0_SET_TRAP_HANDLER_A __data = { .address_upper = (args) }; \
    __NVC9C0_SET_TRAP_HANDLER_A(&val, __data); \
}

#define VA_NVC9C0_SET_TRAP_HANDLER_A V_NVC9C0_SET_TRAP_HANDLER_A

#define P_NVC9C0_SET_TRAP_HANDLER_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_TRAP_HANDLER_A(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_TRAP_HANDLER_A, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_TRAP_HANDLER_B {
    uint32_t address_lower;
};

static inline void
__NVC9C0_SET_TRAP_HANDLER_B(uint32_t *val_out, struct nv_nvc9c0_SET_TRAP_HANDLER_B st)
{
    uint32_t val = 0;
    
    val |= st.address_lower;
    *val_out = val;
}

#define V_NVC9C0_SET_TRAP_HANDLER_B(val, args...) { \
    struct nv_nvc9c0_SET_TRAP_HANDLER_B __data = { .address_lower = (args) }; \
    __NVC9C0_SET_TRAP_HANDLER_B(&val, __data); \
}

#define VA_NVC9C0_SET_TRAP_HANDLER_B V_NVC9C0_SET_TRAP_HANDLER_B

#define P_NVC9C0_SET_TRAP_HANDLER_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_TRAP_HANDLER_B(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_TRAP_HANDLER_B, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_BINDLESS_TEXTURE {
    uint32_t constant_buffer_slot_select;
};

static inline void
__NVC9C0_SET_BINDLESS_TEXTURE(uint32_t *val_out, struct nv_nvc9c0_SET_BINDLESS_TEXTURE st)
{
    uint32_t val = 0;
    
    assert(st.constant_buffer_slot_select < (1ULL << 3));
    val |= st.constant_buffer_slot_select << 0;
    *val_out = val;
}

#define V_NVC9C0_SET_BINDLESS_TEXTURE(val, args...) { \
    struct nv_nvc9c0_SET_BINDLESS_TEXTURE __data = { .constant_buffer_slot_select = (args) }; \
    __NVC9C0_SET_BINDLESS_TEXTURE(&val, __data); \
}

#define VA_NVC9C0_SET_BINDLESS_TEXTURE V_NVC9C0_SET_BINDLESS_TEXTURE

#define P_NVC9C0_SET_BINDLESS_TEXTURE(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_BINDLESS_TEXTURE(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_BINDLESS_TEXTURE, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE {
    uint32_t v;
};

static inline void
__NVC9C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(uint32_t *val_out, struct nv_nvc9c0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(val, args...) { \
    struct nv_nvc9c0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE __data = { .v = (args) }; \
    __NVC9C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(&val, __data); \
}

#define VA_NVC9C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(i) V_NVC9C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE

#define P_NVC9C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(idx), nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER {
    uint32_t v;
};

static inline void
__NVC9C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(uint32_t *val_out, struct nv_nvc9c0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(val, args...) { \
    struct nv_nvc9c0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER __data = { .v = (args) }; \
    __NVC9C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(&val, __data); \
}

#define VA_NVC9C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(i) V_NVC9C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER

#define P_NVC9C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(idx), nvk_p_ret); \
} while(0)

struct nv_nvc9c0_ENABLE_SHADER_PERFORMANCE_SNAPSHOT_COUNTER {
    uint32_t v;
};

static inline void
__NVC9C0_ENABLE_SHADER_PERFORMANCE_SNAPSHOT_COUNTER(uint32_t *val_out, struct nv_nvc9c0_ENABLE_SHADER_PERFORMANCE_SNAPSHOT_COUNTER st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 1));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVC9C0_ENABLE_SHADER_PERFORMANCE_SNAPSHOT_COUNTER(val, args...) { \
    struct nv_nvc9c0_ENABLE_SHADER_PERFORMANCE_SNAPSHOT_COUNTER __data = { .v = (args) }; \
    __NVC9C0_ENABLE_SHADER_PERFORMANCE_SNAPSHOT_COUNTER(&val, __data); \
}

#define VA_NVC9C0_ENABLE_SHADER_PERFORMANCE_SNAPSHOT_COUNTER V_NVC9C0_ENABLE_SHADER_PERFORMANCE_SNAPSHOT_COUNTER

#define P_NVC9C0_ENABLE_SHADER_PERFORMANCE_SNAPSHOT_COUNTER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_ENABLE_SHADER_PERFORMANCE_SNAPSHOT_COUNTER(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_ENABLE_SHADER_PERFORMANCE_SNAPSHOT_COUNTER, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_DISABLE_SHADER_PERFORMANCE_SNAPSHOT_COUNTER {
    uint32_t v;
};

static inline void
__NVC9C0_DISABLE_SHADER_PERFORMANCE_SNAPSHOT_COUNTER(uint32_t *val_out, struct nv_nvc9c0_DISABLE_SHADER_PERFORMANCE_SNAPSHOT_COUNTER st)
{
    uint32_t val = 0;
    
    assert(st.v < (1ULL << 1));
    val |= st.v << 0;
    *val_out = val;
}

#define V_NVC9C0_DISABLE_SHADER_PERFORMANCE_SNAPSHOT_COUNTER(val, args...) { \
    struct nv_nvc9c0_DISABLE_SHADER_PERFORMANCE_SNAPSHOT_COUNTER __data = { .v = (args) }; \
    __NVC9C0_DISABLE_SHADER_PERFORMANCE_SNAPSHOT_COUNTER(&val, __data); \
}

#define VA_NVC9C0_DISABLE_SHADER_PERFORMANCE_SNAPSHOT_COUNTER V_NVC9C0_DISABLE_SHADER_PERFORMANCE_SNAPSHOT_COUNTER

#define P_NVC9C0_DISABLE_SHADER_PERFORMANCE_SNAPSHOT_COUNTER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_DISABLE_SHADER_PERFORMANCE_SNAPSHOT_COUNTER(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_DISABLE_SHADER_PERFORMANCE_SNAPSHOT_COUNTER, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER {
    uint32_t v;
};

static inline void
__NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(uint32_t *val_out, struct nv_nvc9c0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(val, args...) { \
    struct nv_nvc9c0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER __data = { .v = (args) }; \
    __NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(&val, __data); \
}

#define VA_NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(i) V_NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER

#define P_NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(idx), nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_SHADER_PERFORMANCE_COUNTER_VALUE {
    uint32_t v;
};

static inline void
__NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(uint32_t *val_out, struct nv_nvc9c0_SET_SHADER_PERFORMANCE_COUNTER_VALUE st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(val, args...) { \
    struct nv_nvc9c0_SET_SHADER_PERFORMANCE_COUNTER_VALUE __data = { .v = (args) }; \
    __NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(&val, __data); \
}

#define VA_NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(i) V_NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE

#define P_NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(idx), nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_SHADER_PERFORMANCE_COUNTER_EVENT {
    uint32_t event;
};

static inline void
__NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(uint32_t *val_out, struct nv_nvc9c0_SET_SHADER_PERFORMANCE_COUNTER_EVENT st)
{
    uint32_t val = 0;
    
    assert(st.event < (1ULL << 8));
    val |= st.event << 0;
    *val_out = val;
}

#define V_NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(val, args...) { \
    struct nv_nvc9c0_SET_SHADER_PERFORMANCE_COUNTER_EVENT __data = { .event = (args) }; \
    __NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(&val, __data); \
}

#define VA_NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(i) V_NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT

#define P_NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(idx), nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A {
    uint32_t event0;
    uint32_t bit_select0;
    uint32_t event1;
    uint32_t bit_select1;
    uint32_t event2;
    uint32_t bit_select2;
    uint32_t event3;
    uint32_t bit_select3;
    uint32_t event4;
    uint32_t bit_select4;
    uint32_t event5;
    uint32_t bit_select5;
    uint32_t spare;
};

static inline void
__NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(uint32_t *val_out, struct nv_nvc9c0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A st)
{
    uint32_t val = 0;
    
    assert(st.event0 < (1ULL << 2));
    val |= st.event0 << 0;
    
    assert(st.bit_select0 < (1ULL << 3));
    val |= st.bit_select0 << 2;
    
    assert(st.event1 < (1ULL << 2));
    val |= st.event1 << 5;
    
    assert(st.bit_select1 < (1ULL << 3));
    val |= st.bit_select1 << 7;
    
    assert(st.event2 < (1ULL << 2));
    val |= st.event2 << 10;
    
    assert(st.bit_select2 < (1ULL << 3));
    val |= st.bit_select2 << 12;
    
    assert(st.event3 < (1ULL << 2));
    val |= st.event3 << 15;
    
    assert(st.bit_select3 < (1ULL << 3));
    val |= st.bit_select3 << 17;
    
    assert(st.event4 < (1ULL << 2));
    val |= st.event4 << 20;
    
    assert(st.bit_select4 < (1ULL << 3));
    val |= st.bit_select4 << 22;
    
    assert(st.event5 < (1ULL << 2));
    val |= st.event5 << 25;
    
    assert(st.bit_select5 < (1ULL << 3));
    val |= st.bit_select5 << 27;
    
    assert(st.spare < (1ULL << 2));
    val |= st.spare << 30;
    *val_out = val;
}

#define V_NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(val, args...) { \
    struct nv_nvc9c0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A __data = args; \
    __NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(&val, __data); \
}

#define VA_NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(i) V_NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A

#define P_NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(idx), nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B {
    uint32_t edge;
    uint32_t mode;
    uint32_t windowed;
    uint32_t func;
};

static inline void
__NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(uint32_t *val_out, struct nv_nvc9c0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B st)
{
    uint32_t val = 0;
    
    assert(st.edge < (1ULL << 1));
    val |= st.edge << 0;
    
    assert(st.mode < (1ULL << 2));
    val |= st.mode << 1;
    
    assert(st.windowed < (1ULL << 1));
    val |= st.windowed << 3;
    
    assert(st.func < (1ULL << 16));
    val |= st.func << 4;
    *val_out = val;
}

#define V_NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(val, args...) { \
    struct nv_nvc9c0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B __data = args; \
    __NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(&val, __data); \
}

#define VA_NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(i) V_NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B

#define P_NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(idx), nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_SHADER_PERFORMANCE_COUNTER_TRAP_CONTROL {
    uint32_t mask;
};

static inline void
__NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_TRAP_CONTROL(uint32_t *val_out, struct nv_nvc9c0_SET_SHADER_PERFORMANCE_COUNTER_TRAP_CONTROL st)
{
    uint32_t val = 0;
    
    assert(st.mask < (1ULL << 8));
    val |= st.mask << 0;
    *val_out = val;
}

#define V_NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_TRAP_CONTROL(val, args...) { \
    struct nv_nvc9c0_SET_SHADER_PERFORMANCE_COUNTER_TRAP_CONTROL __data = { .mask = (args) }; \
    __NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_TRAP_CONTROL(&val, __data); \
}

#define VA_NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_TRAP_CONTROL V_NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_TRAP_CONTROL

#define P_NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_TRAP_CONTROL(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_TRAP_CONTROL(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_TRAP_CONTROL, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_START_SHADER_PERFORMANCE_COUNTER {
    uint32_t counter_mask;
};

static inline void
__NVC9C0_START_SHADER_PERFORMANCE_COUNTER(uint32_t *val_out, struct nv_nvc9c0_START_SHADER_PERFORMANCE_COUNTER st)
{
    uint32_t val = 0;
    
    assert(st.counter_mask < (1ULL << 8));
    val |= st.counter_mask << 0;
    *val_out = val;
}

#define V_NVC9C0_START_SHADER_PERFORMANCE_COUNTER(val, args...) { \
    struct nv_nvc9c0_START_SHADER_PERFORMANCE_COUNTER __data = { .counter_mask = (args) }; \
    __NVC9C0_START_SHADER_PERFORMANCE_COUNTER(&val, __data); \
}

#define VA_NVC9C0_START_SHADER_PERFORMANCE_COUNTER V_NVC9C0_START_SHADER_PERFORMANCE_COUNTER

#define P_NVC9C0_START_SHADER_PERFORMANCE_COUNTER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_START_SHADER_PERFORMANCE_COUNTER(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_START_SHADER_PERFORMANCE_COUNTER, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_STOP_SHADER_PERFORMANCE_COUNTER {
    uint32_t counter_mask;
};

static inline void
__NVC9C0_STOP_SHADER_PERFORMANCE_COUNTER(uint32_t *val_out, struct nv_nvc9c0_STOP_SHADER_PERFORMANCE_COUNTER st)
{
    uint32_t val = 0;
    
    assert(st.counter_mask < (1ULL << 8));
    val |= st.counter_mask << 0;
    *val_out = val;
}

#define V_NVC9C0_STOP_SHADER_PERFORMANCE_COUNTER(val, args...) { \
    struct nv_nvc9c0_STOP_SHADER_PERFORMANCE_COUNTER __data = { .counter_mask = (args) }; \
    __NVC9C0_STOP_SHADER_PERFORMANCE_COUNTER(&val, __data); \
}

#define VA_NVC9C0_STOP_SHADER_PERFORMANCE_COUNTER V_NVC9C0_STOP_SHADER_PERFORMANCE_COUNTER

#define P_NVC9C0_STOP_SHADER_PERFORMANCE_COUNTER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_STOP_SHADER_PERFORMANCE_COUNTER(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_STOP_SHADER_PERFORMANCE_COUNTER, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_SHADER_PERFORMANCE_COUNTER_SCTL_FILTER {
    uint32_t v;
};

static inline void
__NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_SCTL_FILTER(uint32_t *val_out, struct nv_nvc9c0_SET_SHADER_PERFORMANCE_COUNTER_SCTL_FILTER st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_SCTL_FILTER(val, args...) { \
    struct nv_nvc9c0_SET_SHADER_PERFORMANCE_COUNTER_SCTL_FILTER __data = { .v = (args) }; \
    __NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_SCTL_FILTER(&val, __data); \
}

#define VA_NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_SCTL_FILTER V_NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_SCTL_FILTER

#define P_NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_SCTL_FILTER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_SCTL_FILTER(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_SCTL_FILTER, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_SHADER_PERFORMANCE_COUNTER_CORE_MIO_FILTER {
    uint32_t v;
};

static inline void
__NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_CORE_MIO_FILTER(uint32_t *val_out, struct nv_nvc9c0_SET_SHADER_PERFORMANCE_COUNTER_CORE_MIO_FILTER st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_CORE_MIO_FILTER(val, args...) { \
    struct nv_nvc9c0_SET_SHADER_PERFORMANCE_COUNTER_CORE_MIO_FILTER __data = { .v = (args) }; \
    __NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_CORE_MIO_FILTER(&val, __data); \
}

#define VA_NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_CORE_MIO_FILTER V_NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_CORE_MIO_FILTER

#define P_NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_CORE_MIO_FILTER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_CORE_MIO_FILTER(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_SHADER_PERFORMANCE_COUNTER_CORE_MIO_FILTER, nvk_p_ret); \
} while(0)

struct nv_nvc9c0_SET_MME_SHADOW_SCRATCH {
    uint32_t v;
};

static inline void
__NVC9C0_SET_MME_SHADOW_SCRATCH(uint32_t *val_out, struct nv_nvc9c0_SET_MME_SHADOW_SCRATCH st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_SET_MME_SHADOW_SCRATCH(val, args...) { \
    struct nv_nvc9c0_SET_MME_SHADOW_SCRATCH __data = { .v = (args) }; \
    __NVC9C0_SET_MME_SHADOW_SCRATCH(&val, __data); \
}

#define VA_NVC9C0_SET_MME_SHADOW_SCRATCH(i) V_NVC9C0_SET_MME_SHADOW_SCRATCH

#define P_NVC9C0_SET_MME_SHADOW_SCRATCH(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_SET_MME_SHADOW_SCRATCH(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_SET_MME_SHADOW_SCRATCH(idx), nvk_p_ret); \
} while(0)

struct nv_nvc9c0_CALL_MME_MACRO {
    uint32_t v;
};

static inline void
__NVC9C0_CALL_MME_MACRO(uint32_t *val_out, struct nv_nvc9c0_CALL_MME_MACRO st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_CALL_MME_MACRO(val, args...) { \
    struct nv_nvc9c0_CALL_MME_MACRO __data = { .v = (args) }; \
    __NVC9C0_CALL_MME_MACRO(&val, __data); \
}

#define VA_NVC9C0_CALL_MME_MACRO(i) V_NVC9C0_CALL_MME_MACRO

#define P_NVC9C0_CALL_MME_MACRO(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_CALL_MME_MACRO(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_CALL_MME_MACRO(idx), nvk_p_ret); \
} while(0)

struct nv_nvc9c0_CALL_MME_DATA {
    uint32_t v;
};

static inline void
__NVC9C0_CALL_MME_DATA(uint32_t *val_out, struct nv_nvc9c0_CALL_MME_DATA st)
{
    uint32_t val = 0;
    
    val |= st.v;
    *val_out = val;
}

#define V_NVC9C0_CALL_MME_DATA(val, args...) { \
    struct nv_nvc9c0_CALL_MME_DATA __data = { .v = (args) }; \
    __NVC9C0_CALL_MME_DATA(&val, __data); \
}

#define VA_NVC9C0_CALL_MME_DATA(i) V_NVC9C0_CALL_MME_DATA

#define P_NVC9C0_CALL_MME_DATA(push, idx, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC9C0_CALL_MME_DATA(nvk_p_ret, args); \
    nv_push_val(push, NVC9C0_CALL_MME_DATA(idx), nvk_p_ret); \
} while(0)


const char *P_PARSE_NVC9C0_MTHD(uint16_t idx) ATTRIBUTE_COLD;
void P_DUMP_NVC9C0_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                              const char *prefix) ATTRIBUTE_COLD;
