/*
 * Copyright 2022, Oak Ridge National Laboratory.
 * MGARD-X: MultiGrid Adaptive Reduction of Data Portable across GPUs and CPUs
 * Author: Jieyang Chen (chenj3@ornl.gov)
 * Date: March 17, 2022
 */

#include "mgard-x/MDRHighLevel/MDRHighLevel.hpp"
// clang-format off
namespace mgard_x {
namespace MDR {

template void MDRefactor<SERIAL>(DIM D, data_type dtype, std::vector<SIZE> shape, const void *original_data,
          RefactoredMetadata &refactored_metadata,
          RefactoredData &refactored_data,
          Config config, bool output_pre_allocated);

template void MDRefactor<SERIAL>(DIM D, data_type dtype, std::vector<SIZE> shape, const void *original_data,
          std::vector<const Byte *> coords, RefactoredMetadata &refactored_metadata,
          RefactoredData &refactored_data,
          Config config, bool output_pre_allocated);

template void MDRequest<SERIAL>(RefactoredMetadata &refactored_metadata);

template SIZE MDRMaxOutputDataSize<SERIAL>(DIM D, data_type dtype, std::vector<SIZE> shape, Config config);

template void MDReconstruct<SERIAL>(RefactoredMetadata &refactored_metadata,
                  RefactoredData &refactored_data,
                  ReconstructedData &reconstructed_data, Config config,
                  bool output_pre_allocated);

template void release_cache<SERIAL>();
}
} // namespace mgard_x
// clang-format on
