// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: partition_ring_desc.proto

package ring

import (
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	github_com_gogo_protobuf_sortkeys "github.com/gogo/protobuf/sortkeys"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strconv "strconv"
	strings "strings"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type PartitionState int32

const (
	PartitionUnknown PartitionState = 0
	// Pending partition is a partition that is about to be switched to ACTIVE. This state is used
	// to let owners to attach to the partition and get ready to handle the partition.
	//
	// When a partition is in this state, it must not be used for writing or reading.
	PartitionPending PartitionState = 1
	// Active partition in read-write mode.
	PartitionActive PartitionState = 2
	// Inactive partition in read-only mode. This partition will be deleted after a grace period,
	// unless its state changes to Active again.
	PartitionInactive PartitionState = 3
	// Deleted partition. This state is not visible to ring clients: it's only used to propagate
	// via memberlist the information that a partition has been deleted.
	PartitionDeleted PartitionState = 4
)

var PartitionState_name = map[int32]string{
	0: "PartitionUnknown",
	1: "PartitionPending",
	2: "PartitionActive",
	3: "PartitionInactive",
	4: "PartitionDeleted",
}

var PartitionState_value = map[string]int32{
	"PartitionUnknown":  0,
	"PartitionPending":  1,
	"PartitionActive":   2,
	"PartitionInactive": 3,
	"PartitionDeleted":  4,
}

func (PartitionState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_4df2762174d93dc4, []int{0}
}

type OwnerState int32

const (
	OwnerUnknown OwnerState = 0
	// Active owner.
	OwnerActive OwnerState = 1
	// Deleted owner. This state is not visible to ring clients: it's only used to propagate
	// via memberlist the information that a owner has been deleted. Owners in this state
	// are removed before client can see them.
	OwnerDeleted OwnerState = 2
)

var OwnerState_name = map[int32]string{
	0: "OwnerUnknown",
	1: "OwnerActive",
	2: "OwnerDeleted",
}

var OwnerState_value = map[string]int32{
	"OwnerUnknown": 0,
	"OwnerActive":  1,
	"OwnerDeleted": 2,
}

func (OwnerState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_4df2762174d93dc4, []int{1}
}

// PartitionRingDesc holds the state of the partitions ring.
type PartitionRingDesc struct {
	// Mapping between partition ID and partition info.
	Partitions map[int32]PartitionDesc `protobuf:"bytes,1,rep,name=partitions,proto3" json:"partitions" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Mapping between instance ID and partition ownership info.
	Owners map[string]OwnerDesc `protobuf:"bytes,2,rep,name=owners,proto3" json:"owners" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (m *PartitionRingDesc) Reset()      { *m = PartitionRingDesc{} }
func (*PartitionRingDesc) ProtoMessage() {}
func (*PartitionRingDesc) Descriptor() ([]byte, []int) {
	return fileDescriptor_4df2762174d93dc4, []int{0}
}
func (m *PartitionRingDesc) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PartitionRingDesc) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PartitionRingDesc.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PartitionRingDesc) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PartitionRingDesc.Merge(m, src)
}
func (m *PartitionRingDesc) XXX_Size() int {
	return m.Size()
}
func (m *PartitionRingDesc) XXX_DiscardUnknown() {
	xxx_messageInfo_PartitionRingDesc.DiscardUnknown(m)
}

var xxx_messageInfo_PartitionRingDesc proto.InternalMessageInfo

func (m *PartitionRingDesc) GetPartitions() map[int32]PartitionDesc {
	if m != nil {
		return m.Partitions
	}
	return nil
}

func (m *PartitionRingDesc) GetOwners() map[string]OwnerDesc {
	if m != nil {
		return m.Owners
	}
	return nil
}

// PartitionDesc holds the state of a single partition.
type PartitionDesc struct {
	// The partition ID. This value is the same as the key in the partitions map in PartitionRingDesc.
	Id int32 `protobuf:"varint,4,opt,name=id,proto3" json:"id,omitempty"`
	// Unique tokens, generated with deterministic token generator. Tokens MUST be immutable:
	// if tokens get changed, the change will not be propagated via memberlist.
	Tokens []uint32 `protobuf:"varint,1,rep,packed,name=tokens,proto3" json:"tokens,omitempty"`
	// The state of the partition.
	State PartitionState `protobuf:"varint,2,opt,name=state,proto3,enum=ring.PartitionState" json:"state,omitempty"`
	// Unix timestamp (with seconds precision) of when has the state changed last time for this partition.
	StateTimestamp int64 `protobuf:"varint,3,opt,name=stateTimestamp,proto3" json:"stateTimestamp,omitempty"`
}

func (m *PartitionDesc) Reset()      { *m = PartitionDesc{} }
func (*PartitionDesc) ProtoMessage() {}
func (*PartitionDesc) Descriptor() ([]byte, []int) {
	return fileDescriptor_4df2762174d93dc4, []int{1}
}
func (m *PartitionDesc) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PartitionDesc) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PartitionDesc.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PartitionDesc) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PartitionDesc.Merge(m, src)
}
func (m *PartitionDesc) XXX_Size() int {
	return m.Size()
}
func (m *PartitionDesc) XXX_DiscardUnknown() {
	xxx_messageInfo_PartitionDesc.DiscardUnknown(m)
}

var xxx_messageInfo_PartitionDesc proto.InternalMessageInfo

func (m *PartitionDesc) GetId() int32 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *PartitionDesc) GetTokens() []uint32 {
	if m != nil {
		return m.Tokens
	}
	return nil
}

func (m *PartitionDesc) GetState() PartitionState {
	if m != nil {
		return m.State
	}
	return PartitionUnknown
}

func (m *PartitionDesc) GetStateTimestamp() int64 {
	if m != nil {
		return m.StateTimestamp
	}
	return 0
}

// OwnerDesc holds the information of a partition owner.
type OwnerDesc struct {
	// Partition that belongs to this owner. A owner can own only 1 partition, but 1 partition can be
	// owned by multiple owners.
	OwnedPartition int32 `protobuf:"varint,1,opt,name=ownedPartition,proto3" json:"ownedPartition,omitempty"`
	// The owner state. This field is used to propagate deletions via memberlist.
	State OwnerState `protobuf:"varint,2,opt,name=state,proto3,enum=ring.OwnerState" json:"state,omitempty"`
	// Unix timestamp (with seconds precision) of when the data for the owner has been updated the last time.
	// This timestamp is used to resolve conflicts when merging updates via memberlist (the most recent
	// update wins).
	UpdatedTimestamp int64 `protobuf:"varint,3,opt,name=updatedTimestamp,proto3" json:"updatedTimestamp,omitempty"`
}

func (m *OwnerDesc) Reset()      { *m = OwnerDesc{} }
func (*OwnerDesc) ProtoMessage() {}
func (*OwnerDesc) Descriptor() ([]byte, []int) {
	return fileDescriptor_4df2762174d93dc4, []int{2}
}
func (m *OwnerDesc) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *OwnerDesc) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_OwnerDesc.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *OwnerDesc) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OwnerDesc.Merge(m, src)
}
func (m *OwnerDesc) XXX_Size() int {
	return m.Size()
}
func (m *OwnerDesc) XXX_DiscardUnknown() {
	xxx_messageInfo_OwnerDesc.DiscardUnknown(m)
}

var xxx_messageInfo_OwnerDesc proto.InternalMessageInfo

func (m *OwnerDesc) GetOwnedPartition() int32 {
	if m != nil {
		return m.OwnedPartition
	}
	return 0
}

func (m *OwnerDesc) GetState() OwnerState {
	if m != nil {
		return m.State
	}
	return OwnerUnknown
}

func (m *OwnerDesc) GetUpdatedTimestamp() int64 {
	if m != nil {
		return m.UpdatedTimestamp
	}
	return 0
}

func init() {
	proto.RegisterEnum("ring.PartitionState", PartitionState_name, PartitionState_value)
	proto.RegisterEnum("ring.OwnerState", OwnerState_name, OwnerState_value)
	proto.RegisterType((*PartitionRingDesc)(nil), "ring.PartitionRingDesc")
	proto.RegisterMapType((map[string]OwnerDesc)(nil), "ring.PartitionRingDesc.OwnersEntry")
	proto.RegisterMapType((map[int32]PartitionDesc)(nil), "ring.PartitionRingDesc.PartitionsEntry")
	proto.RegisterType((*PartitionDesc)(nil), "ring.PartitionDesc")
	proto.RegisterType((*OwnerDesc)(nil), "ring.OwnerDesc")
}

func init() { proto.RegisterFile("partition_ring_desc.proto", fileDescriptor_4df2762174d93dc4) }

var fileDescriptor_4df2762174d93dc4 = []byte{
	// 497 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x74, 0x93, 0x31, 0x6f, 0xd3, 0x40,
	0x14, 0xc7, 0x7d, 0x76, 0x12, 0xa9, 0x2f, 0x34, 0x39, 0xae, 0x05, 0x99, 0x0c, 0x47, 0x14, 0x44,
	0x09, 0x91, 0x48, 0xa5, 0xc0, 0x80, 0xd8, 0x52, 0x95, 0x01, 0x24, 0x44, 0x65, 0x60, 0xae, 0x9c,
	0xf8, 0x30, 0xa7, 0x34, 0x77, 0x91, 0x7d, 0x6e, 0xd5, 0x05, 0xb1, 0x31, 0xb0, 0xf0, 0x31, 0xf8,
	0x22, 0x48, 0x1d, 0x33, 0x76, 0x42, 0xc4, 0x59, 0x18, 0xfb, 0x11, 0x90, 0xcf, 0xae, 0x63, 0xbb,
	0xea, 0x76, 0xef, 0x7f, 0xef, 0xfd, 0xfe, 0xff, 0x3b, 0x9f, 0xe1, 0xc1, 0xc2, 0x0d, 0x14, 0x57,
	0x5c, 0x8a, 0xe3, 0x80, 0x0b, 0xff, 0xd8, 0x63, 0xe1, 0x74, 0xb8, 0x08, 0xa4, 0x92, 0xa4, 0x96,
	0x08, 0x9d, 0x67, 0x3e, 0x57, 0x5f, 0xa2, 0xc9, 0x70, 0x2a, 0xe7, 0xfb, 0xbe, 0xf4, 0xe5, 0xbe,
	0xde, 0x9c, 0x44, 0x9f, 0x75, 0xa5, 0x0b, 0xbd, 0x4a, 0x87, 0x7a, 0xbf, 0x4d, 0xb8, 0x7b, 0x74,
	0x8d, 0x74, 0xb8, 0xf0, 0x0f, 0x59, 0x38, 0x25, 0xef, 0x00, 0x72, 0x9f, 0xd0, 0x46, 0x5d, 0xab,
	0xdf, 0x1c, 0x3d, 0x19, 0x26, 0xfc, 0xe1, 0x8d, 0xe6, 0x8d, 0x12, 0xbe, 0x16, 0x2a, 0x38, 0x3f,
	0xa8, 0x5d, 0xfc, 0x79, 0x68, 0x38, 0x05, 0x00, 0x19, 0x43, 0x43, 0x9e, 0x09, 0x16, 0x84, 0xb6,
	0xa9, 0x51, 0x8f, 0x6e, 0x43, 0xbd, 0xd7, 0x5d, 0x45, 0x4c, 0x36, 0xd8, 0x71, 0xa0, 0x5d, 0xf1,
	0x21, 0x18, 0xac, 0x19, 0x3b, 0xb7, 0x51, 0x17, 0xf5, 0xeb, 0x4e, 0xb2, 0x24, 0x4f, 0xa1, 0x7e,
	0xea, 0x9e, 0x44, 0xcc, 0x36, 0xbb, 0xa8, 0xdf, 0x1c, 0xed, 0x54, 0x6c, 0x12, 0x0b, 0x27, 0xed,
	0x78, 0x65, 0xbe, 0x44, 0x9d, 0xb7, 0xd0, 0x2c, 0x18, 0x16, 0x79, 0x5b, 0x29, 0xef, 0x71, 0x99,
	0xd7, 0x4e, 0x79, 0x7a, 0xa6, 0xc2, 0xea, 0xfd, 0x40, 0xb0, 0x5d, 0x32, 0x22, 0x2d, 0x30, 0xb9,
	0x67, 0xd7, 0x74, 0x3a, 0x93, 0x7b, 0xe4, 0x3e, 0x34, 0x94, 0x9c, 0xb1, 0xec, 0x3e, 0xb7, 0x9d,
	0xac, 0x22, 0x03, 0xa8, 0x87, 0xca, 0x55, 0xa9, 0x49, 0x6b, 0xb4, 0x5b, 0x09, 0xfd, 0x21, 0xd9,
	0x73, 0xd2, 0x16, 0xb2, 0x07, 0x2d, 0xbd, 0xf8, 0xc8, 0xe7, 0x2c, 0x54, 0xee, 0x7c, 0x61, 0x5b,
	0x5d, 0xd4, 0xb7, 0x9c, 0x8a, 0xda, 0xfb, 0x8e, 0x60, 0x2b, 0x8f, 0x99, 0x4c, 0x25, 0xb7, 0xe8,
	0xe5, 0xcc, 0xec, 0xce, 0x2a, 0x2a, 0xd9, 0x2b, 0x27, 0xc1, 0x85, 0xe3, 0x96, 0x52, 0x0c, 0x00,
	0x47, 0x0b, 0xcf, 0x55, 0xcc, 0xab, 0xe6, 0xb8, 0xa1, 0x0f, 0xbe, 0x42, 0xab, 0x7c, 0x14, 0xb2,
	0x0b, 0x38, 0x57, 0x3e, 0x89, 0x99, 0x90, 0x67, 0x02, 0x1b, 0x25, 0xf5, 0x88, 0x09, 0x8f, 0x0b,
	0x1f, 0x23, 0xb2, 0x53, 0xf8, 0xea, 0xe3, 0xa9, 0xe2, 0xa7, 0x0c, 0x9b, 0xe4, 0x5e, 0xe1, 0xc5,
	0xbe, 0x11, 0x6e, 0x2a, 0x5b, 0x25, 0xc2, 0x21, 0x3b, 0x61, 0x8a, 0x79, 0xb8, 0x36, 0x18, 0x03,
	0x6c, 0x0e, 0x40, 0x30, 0xdc, 0xd1, 0xd5, 0xc6, 0xb7, 0x9d, 0xbd, 0x81, 0x8c, 0x8e, 0xf2, 0x96,
	0x6b, 0x84, 0x79, 0xf0, 0x62, 0xb9, 0xa2, 0xc6, 0xe5, 0x8a, 0x1a, 0x57, 0x2b, 0x8a, 0xbe, 0xc5,
	0x14, 0xfd, 0x8a, 0x29, 0xba, 0x88, 0x29, 0x5a, 0xc6, 0x14, 0xfd, 0x8d, 0x29, 0xfa, 0x17, 0x53,
	0xe3, 0x2a, 0xa6, 0xe8, 0xe7, 0x9a, 0x1a, 0xcb, 0x35, 0x35, 0x2e, 0xd7, 0xd4, 0x98, 0x34, 0xf4,
	0xff, 0xf5, 0xfc, 0x7f, 0x00, 0x00, 0x00, 0xff, 0xff, 0xc9, 0xd1, 0xa7, 0xbd, 0xb1, 0x03, 0x00,
	0x00,
}

func (x PartitionState) String() string {
	s, ok := PartitionState_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (x OwnerState) String() string {
	s, ok := OwnerState_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (this *PartitionRingDesc) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PartitionRingDesc)
	if !ok {
		that2, ok := that.(PartitionRingDesc)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Partitions) != len(that1.Partitions) {
		return false
	}
	for i := range this.Partitions {
		a := this.Partitions[i]
		b := that1.Partitions[i]
		if !(&a).Equal(&b) {
			return false
		}
	}
	if len(this.Owners) != len(that1.Owners) {
		return false
	}
	for i := range this.Owners {
		a := this.Owners[i]
		b := that1.Owners[i]
		if !(&a).Equal(&b) {
			return false
		}
	}
	return true
}
func (this *PartitionDesc) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PartitionDesc)
	if !ok {
		that2, ok := that.(PartitionDesc)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Id != that1.Id {
		return false
	}
	if len(this.Tokens) != len(that1.Tokens) {
		return false
	}
	for i := range this.Tokens {
		if this.Tokens[i] != that1.Tokens[i] {
			return false
		}
	}
	if this.State != that1.State {
		return false
	}
	if this.StateTimestamp != that1.StateTimestamp {
		return false
	}
	return true
}
func (this *OwnerDesc) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*OwnerDesc)
	if !ok {
		that2, ok := that.(OwnerDesc)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.OwnedPartition != that1.OwnedPartition {
		return false
	}
	if this.State != that1.State {
		return false
	}
	if this.UpdatedTimestamp != that1.UpdatedTimestamp {
		return false
	}
	return true
}
func (this *PartitionRingDesc) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&ring.PartitionRingDesc{")
	keysForPartitions := make([]int32, 0, len(this.Partitions))
	for k, _ := range this.Partitions {
		keysForPartitions = append(keysForPartitions, k)
	}
	github_com_gogo_protobuf_sortkeys.Int32s(keysForPartitions)
	mapStringForPartitions := "map[int32]PartitionDesc{"
	for _, k := range keysForPartitions {
		mapStringForPartitions += fmt.Sprintf("%#v: %#v,", k, this.Partitions[k])
	}
	mapStringForPartitions += "}"
	if this.Partitions != nil {
		s = append(s, "Partitions: "+mapStringForPartitions+",\n")
	}
	keysForOwners := make([]string, 0, len(this.Owners))
	for k, _ := range this.Owners {
		keysForOwners = append(keysForOwners, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForOwners)
	mapStringForOwners := "map[string]OwnerDesc{"
	for _, k := range keysForOwners {
		mapStringForOwners += fmt.Sprintf("%#v: %#v,", k, this.Owners[k])
	}
	mapStringForOwners += "}"
	if this.Owners != nil {
		s = append(s, "Owners: "+mapStringForOwners+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *PartitionDesc) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&ring.PartitionDesc{")
	s = append(s, "Id: "+fmt.Sprintf("%#v", this.Id)+",\n")
	s = append(s, "Tokens: "+fmt.Sprintf("%#v", this.Tokens)+",\n")
	s = append(s, "State: "+fmt.Sprintf("%#v", this.State)+",\n")
	s = append(s, "StateTimestamp: "+fmt.Sprintf("%#v", this.StateTimestamp)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *OwnerDesc) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&ring.OwnerDesc{")
	s = append(s, "OwnedPartition: "+fmt.Sprintf("%#v", this.OwnedPartition)+",\n")
	s = append(s, "State: "+fmt.Sprintf("%#v", this.State)+",\n")
	s = append(s, "UpdatedTimestamp: "+fmt.Sprintf("%#v", this.UpdatedTimestamp)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringPartitionRingDesc(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func (m *PartitionRingDesc) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PartitionRingDesc) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PartitionRingDesc) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Owners) > 0 {
		for k := range m.Owners {
			v := m.Owners[k]
			baseI := i
			{
				size, err := (&v).MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPartitionRingDesc(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintPartitionRingDesc(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintPartitionRingDesc(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Partitions) > 0 {
		for k := range m.Partitions {
			v := m.Partitions[k]
			baseI := i
			{
				size, err := (&v).MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPartitionRingDesc(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
			i = encodeVarintPartitionRingDesc(dAtA, i, uint64(k))
			i--
			dAtA[i] = 0x8
			i = encodeVarintPartitionRingDesc(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *PartitionDesc) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PartitionDesc) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PartitionDesc) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Id != 0 {
		i = encodeVarintPartitionRingDesc(dAtA, i, uint64(m.Id))
		i--
		dAtA[i] = 0x20
	}
	if m.StateTimestamp != 0 {
		i = encodeVarintPartitionRingDesc(dAtA, i, uint64(m.StateTimestamp))
		i--
		dAtA[i] = 0x18
	}
	if m.State != 0 {
		i = encodeVarintPartitionRingDesc(dAtA, i, uint64(m.State))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Tokens) > 0 {
		dAtA4 := make([]byte, len(m.Tokens)*10)
		var j3 int
		for _, num := range m.Tokens {
			for num >= 1<<7 {
				dAtA4[j3] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j3++
			}
			dAtA4[j3] = uint8(num)
			j3++
		}
		i -= j3
		copy(dAtA[i:], dAtA4[:j3])
		i = encodeVarintPartitionRingDesc(dAtA, i, uint64(j3))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *OwnerDesc) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OwnerDesc) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *OwnerDesc) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.UpdatedTimestamp != 0 {
		i = encodeVarintPartitionRingDesc(dAtA, i, uint64(m.UpdatedTimestamp))
		i--
		dAtA[i] = 0x18
	}
	if m.State != 0 {
		i = encodeVarintPartitionRingDesc(dAtA, i, uint64(m.State))
		i--
		dAtA[i] = 0x10
	}
	if m.OwnedPartition != 0 {
		i = encodeVarintPartitionRingDesc(dAtA, i, uint64(m.OwnedPartition))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func encodeVarintPartitionRingDesc(dAtA []byte, offset int, v uint64) int {
	offset -= sovPartitionRingDesc(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *PartitionRingDesc) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Partitions) > 0 {
		for k, v := range m.Partitions {
			_ = k
			_ = v
			l = v.Size()
			mapEntrySize := 1 + sovPartitionRingDesc(uint64(k)) + 1 + l + sovPartitionRingDesc(uint64(l))
			n += mapEntrySize + 1 + sovPartitionRingDesc(uint64(mapEntrySize))
		}
	}
	if len(m.Owners) > 0 {
		for k, v := range m.Owners {
			_ = k
			_ = v
			l = v.Size()
			mapEntrySize := 1 + len(k) + sovPartitionRingDesc(uint64(len(k))) + 1 + l + sovPartitionRingDesc(uint64(l))
			n += mapEntrySize + 1 + sovPartitionRingDesc(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *PartitionDesc) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Tokens) > 0 {
		l = 0
		for _, e := range m.Tokens {
			l += sovPartitionRingDesc(uint64(e))
		}
		n += 1 + sovPartitionRingDesc(uint64(l)) + l
	}
	if m.State != 0 {
		n += 1 + sovPartitionRingDesc(uint64(m.State))
	}
	if m.StateTimestamp != 0 {
		n += 1 + sovPartitionRingDesc(uint64(m.StateTimestamp))
	}
	if m.Id != 0 {
		n += 1 + sovPartitionRingDesc(uint64(m.Id))
	}
	return n
}

func (m *OwnerDesc) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.OwnedPartition != 0 {
		n += 1 + sovPartitionRingDesc(uint64(m.OwnedPartition))
	}
	if m.State != 0 {
		n += 1 + sovPartitionRingDesc(uint64(m.State))
	}
	if m.UpdatedTimestamp != 0 {
		n += 1 + sovPartitionRingDesc(uint64(m.UpdatedTimestamp))
	}
	return n
}

func sovPartitionRingDesc(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozPartitionRingDesc(x uint64) (n int) {
	return sovPartitionRingDesc(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *PartitionRingDesc) String() string {
	if this == nil {
		return "nil"
	}
	keysForPartitions := make([]int32, 0, len(this.Partitions))
	for k, _ := range this.Partitions {
		keysForPartitions = append(keysForPartitions, k)
	}
	github_com_gogo_protobuf_sortkeys.Int32s(keysForPartitions)
	mapStringForPartitions := "map[int32]PartitionDesc{"
	for _, k := range keysForPartitions {
		mapStringForPartitions += fmt.Sprintf("%v: %v,", k, this.Partitions[k])
	}
	mapStringForPartitions += "}"
	keysForOwners := make([]string, 0, len(this.Owners))
	for k, _ := range this.Owners {
		keysForOwners = append(keysForOwners, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForOwners)
	mapStringForOwners := "map[string]OwnerDesc{"
	for _, k := range keysForOwners {
		mapStringForOwners += fmt.Sprintf("%v: %v,", k, this.Owners[k])
	}
	mapStringForOwners += "}"
	s := strings.Join([]string{`&PartitionRingDesc{`,
		`Partitions:` + mapStringForPartitions + `,`,
		`Owners:` + mapStringForOwners + `,`,
		`}`,
	}, "")
	return s
}
func (this *PartitionDesc) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&PartitionDesc{`,
		`Tokens:` + fmt.Sprintf("%v", this.Tokens) + `,`,
		`State:` + fmt.Sprintf("%v", this.State) + `,`,
		`StateTimestamp:` + fmt.Sprintf("%v", this.StateTimestamp) + `,`,
		`Id:` + fmt.Sprintf("%v", this.Id) + `,`,
		`}`,
	}, "")
	return s
}
func (this *OwnerDesc) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&OwnerDesc{`,
		`OwnedPartition:` + fmt.Sprintf("%v", this.OwnedPartition) + `,`,
		`State:` + fmt.Sprintf("%v", this.State) + `,`,
		`UpdatedTimestamp:` + fmt.Sprintf("%v", this.UpdatedTimestamp) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringPartitionRingDesc(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *PartitionRingDesc) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPartitionRingDesc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PartitionRingDesc: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PartitionRingDesc: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Partitions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPartitionRingDesc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPartitionRingDesc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPartitionRingDesc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Partitions == nil {
				m.Partitions = make(map[int32]PartitionDesc)
			}
			var mapkey int32
			mapvalue := &PartitionDesc{}
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowPartitionRingDesc
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowPartitionRingDesc
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkey |= int32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowPartitionRingDesc
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthPartitionRingDesc
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthPartitionRingDesc
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &PartitionDesc{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipPartitionRingDesc(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthPartitionRingDesc
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Partitions[mapkey] = *mapvalue
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Owners", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPartitionRingDesc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPartitionRingDesc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPartitionRingDesc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Owners == nil {
				m.Owners = make(map[string]OwnerDesc)
			}
			var mapkey string
			mapvalue := &OwnerDesc{}
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowPartitionRingDesc
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowPartitionRingDesc
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthPartitionRingDesc
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthPartitionRingDesc
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowPartitionRingDesc
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthPartitionRingDesc
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthPartitionRingDesc
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &OwnerDesc{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipPartitionRingDesc(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthPartitionRingDesc
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Owners[mapkey] = *mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPartitionRingDesc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPartitionRingDesc
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPartitionRingDesc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PartitionDesc) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPartitionRingDesc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PartitionDesc: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PartitionDesc: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType == 0 {
				var v uint32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowPartitionRingDesc
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= uint32(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Tokens = append(m.Tokens, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowPartitionRingDesc
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthPartitionRingDesc
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthPartitionRingDesc
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.Tokens) == 0 {
					m.Tokens = make([]uint32, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v uint32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowPartitionRingDesc
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= uint32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Tokens = append(m.Tokens, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Tokens", wireType)
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			m.State = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPartitionRingDesc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.State |= PartitionState(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StateTimestamp", wireType)
			}
			m.StateTimestamp = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPartitionRingDesc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StateTimestamp |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			m.Id = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPartitionRingDesc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Id |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipPartitionRingDesc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPartitionRingDesc
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPartitionRingDesc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OwnerDesc) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPartitionRingDesc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OwnerDesc: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OwnerDesc: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field OwnedPartition", wireType)
			}
			m.OwnedPartition = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPartitionRingDesc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.OwnedPartition |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			m.State = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPartitionRingDesc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.State |= OwnerState(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UpdatedTimestamp", wireType)
			}
			m.UpdatedTimestamp = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPartitionRingDesc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.UpdatedTimestamp |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipPartitionRingDesc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPartitionRingDesc
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPartitionRingDesc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipPartitionRingDesc(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowPartitionRingDesc
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowPartitionRingDesc
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowPartitionRingDesc
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthPartitionRingDesc
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthPartitionRingDesc
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowPartitionRingDesc
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipPartitionRingDesc(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthPartitionRingDesc
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthPartitionRingDesc = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowPartitionRingDesc   = fmt.Errorf("proto: integer overflow")
)
