// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
)

func CopyOrigScopeMetricsSlice(dest, src []*otlpmetrics.ScopeMetrics) []*otlpmetrics.ScopeMetrics {
	var newDest []*otlpmetrics.ScopeMetrics
	if cap(dest) < len(src) {
		newDest = make([]*otlpmetrics.ScopeMetrics, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewOrigScopeMetrics()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteOrigScopeMetrics(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewOrigScopeMetrics()
		}
	}
	for i := range src {
		CopyOrigScopeMetrics(newDest[i], src[i])
	}
	return newDest
}

func GenerateOrigTestScopeMetricsSlice() []*otlpmetrics.ScopeMetrics {
	orig := make([]*otlpmetrics.ScopeMetrics, 5)
	orig[0] = NewOrigScopeMetrics()
	orig[1] = GenTestOrigScopeMetrics()
	orig[2] = NewOrigScopeMetrics()
	orig[3] = GenTestOrigScopeMetrics()
	orig[4] = NewOrigScopeMetrics()
	return orig
}
