use gio::prelude::*;
use glib::Boxed;
use news_flash::models::ArticleID;
use std::fmt;

#[derive(Clone, Debug, Eq, Boxed, Hash)]
#[boxed_type(name = "GArticleID")]
pub struct GArticleID(ArticleID);

impl From<ArticleID> for GArticleID {
    fn from(id: ArticleID) -> Self {
        Self(id)
    }
}

impl AsRef<ArticleID> for GArticleID {
    fn as_ref(&self) -> &ArticleID {
        &self.0
    }
}

impl From<GArticleID> for ArticleID {
    fn from(id: GArticleID) -> Self {
        id.0
    }
}

impl Default for GArticleID {
    fn default() -> Self {
        ArticleID::from_owned(String::new()).into()
    }
}

impl ToVariant for GArticleID {
    fn to_variant(&self) -> glib::Variant {
        self.0.as_str().to_variant()
    }
}

impl FromVariant for GArticleID {
    fn from_variant(variant: &glib::Variant) -> Option<Self> {
        variant.str().map(ArticleID::new).map(GArticleID::from)
    }
}

impl StaticVariantType for GArticleID {
    fn static_variant_type() -> std::borrow::Cow<'static, glib::VariantTy> {
        std::borrow::Cow::Borrowed(glib::VariantTy::STRING)
    }
}

impl fmt::Display for GArticleID {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        write!(f, "{}", self.0)
    }
}

impl PartialEq for GArticleID {
    fn eq(&self, other: &GArticleID) -> bool {
        self.0 == other.0
    }
}
