// Automatically generated from interpreter/bytecodes.h
// The following list macro is used to populate the builtins list
// with the bytecode handlers

#include <stdint.h>

#ifndef V8_BUILTINS_GENERATED_BYTECODES_BUILTINS_LIST
#define V8_BUILTINS_GENERATED_BYTECODES_BUILTINS_LIST

namespace v8 {
namespace internal {

#define BUILTIN_LIST_BYTECODE_HANDLERS(V) \
  V(WideHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kWide) \
  V(ExtraWideHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kExtraWide) \
  V(DebugBreakWideHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kDebugBreakWide) \
  V(DebugBreakExtraWideHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kDebugBreakExtraWide) \
  V(DebugBreak0Handler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kDebugBreak0) \
  V(DebugBreak1Handler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kDebugBreak1) \
  V(DebugBreak2Handler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kDebugBreak2) \
  V(DebugBreak3Handler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kDebugBreak3) \
  V(DebugBreak4Handler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kDebugBreak4) \
  V(DebugBreak5Handler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kDebugBreak5) \
  V(DebugBreak6Handler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kDebugBreak6) \
  V(LdarHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kLdar) \
  V(LdaZeroHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kLdaZero) \
  V(LdaSmiHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kLdaSmi) \
  V(LdaUndefinedHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kLdaUndefined) \
  V(LdaNullHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kLdaNull) \
  V(LdaTheHoleHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kLdaTheHole) \
  V(LdaTrueHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kLdaTrue) \
  V(LdaFalseHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kLdaFalse) \
  V(LdaConstantHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kLdaConstant) \
  V(LdaContextSlotHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kLdaContextSlot) \
  V(LdaScriptContextSlotHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kLdaScriptContextSlot) \
  V(LdaImmutableContextSlotHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kLdaImmutableContextSlot) \
  V(LdaCurrentContextSlotHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kLdaCurrentContextSlot) \
  V(LdaCurrentScriptContextSlotHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kLdaCurrentScriptContextSlot) \
  V(LdaImmutableCurrentContextSlotHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kLdaImmutableCurrentContextSlot) \
  V(StarHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kStar) \
  V(MovHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kMov) \
  V(PushContextHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kPushContext) \
  V(PopContextHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kPopContext) \
  V(TestReferenceEqualHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kTestReferenceEqual) \
  V(TestUndetectableHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kTestUndetectable) \
  V(TestNullHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kTestNull) \
  V(TestUndefinedHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kTestUndefined) \
  V(TestTypeOfHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kTestTypeOf) \
  V(LdaGlobalHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kLdaGlobal) \
  V(LdaGlobalInsideTypeofHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kLdaGlobalInsideTypeof) \
  V(StaGlobalHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kStaGlobal) \
  V(StaContextSlotHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kStaContextSlot) \
  V(StaCurrentContextSlotHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kStaCurrentContextSlot) \
  V(StaScriptContextSlotHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kStaScriptContextSlot) \
  V(StaCurrentScriptContextSlotHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kStaCurrentScriptContextSlot) \
  V(LdaLookupSlotHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kLdaLookupSlot) \
  V(LdaLookupContextSlotHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kLdaLookupContextSlot) \
  V(LdaLookupScriptContextSlotHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kLdaLookupScriptContextSlot) \
  V(LdaLookupGlobalSlotHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kLdaLookupGlobalSlot) \
  V(LdaLookupSlotInsideTypeofHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kLdaLookupSlotInsideTypeof) \
  V(LdaLookupContextSlotInsideTypeofHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kLdaLookupContextSlotInsideTypeof) \
  V(LdaLookupScriptContextSlotInsideTypeofHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kLdaLookupScriptContextSlotInsideTypeof) \
  V(LdaLookupGlobalSlotInsideTypeofHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kLdaLookupGlobalSlotInsideTypeof) \
  V(StaLookupSlotHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kStaLookupSlot) \
  V(GetNamedPropertyHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kGetNamedProperty) \
  V(GetNamedPropertyFromSuperHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kGetNamedPropertyFromSuper) \
  V(GetKeyedPropertyHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kGetKeyedProperty) \
  V(GetEnumeratedKeyedPropertyHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kGetEnumeratedKeyedProperty) \
  V(LdaModuleVariableHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kLdaModuleVariable) \
  V(StaModuleVariableHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kStaModuleVariable) \
  V(SetNamedPropertyHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kSetNamedProperty) \
  V(DefineNamedOwnPropertyHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kDefineNamedOwnProperty) \
  V(SetKeyedPropertyHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kSetKeyedProperty) \
  V(DefineKeyedOwnPropertyHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kDefineKeyedOwnProperty) \
  V(StaInArrayLiteralHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kStaInArrayLiteral) \
  V(DefineKeyedOwnPropertyInLiteralHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kDefineKeyedOwnPropertyInLiteral) \
  V(AddHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kAdd) \
  V(SubHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kSub) \
  V(MulHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kMul) \
  V(DivHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kDiv) \
  V(ModHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kMod) \
  V(ExpHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kExp) \
  V(BitwiseOrHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kBitwiseOr) \
  V(BitwiseXorHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kBitwiseXor) \
  V(BitwiseAndHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kBitwiseAnd) \
  V(ShiftLeftHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kShiftLeft) \
  V(ShiftRightHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kShiftRight) \
  V(ShiftRightLogicalHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kShiftRightLogical) \
  V(AddSmiHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kAddSmi) \
  V(SubSmiHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kSubSmi) \
  V(MulSmiHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kMulSmi) \
  V(DivSmiHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kDivSmi) \
  V(ModSmiHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kModSmi) \
  V(ExpSmiHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kExpSmi) \
  V(BitwiseOrSmiHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kBitwiseOrSmi) \
  V(BitwiseXorSmiHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kBitwiseXorSmi) \
  V(BitwiseAndSmiHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kBitwiseAndSmi) \
  V(ShiftLeftSmiHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kShiftLeftSmi) \
  V(ShiftRightSmiHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kShiftRightSmi) \
  V(ShiftRightLogicalSmiHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kShiftRightLogicalSmi) \
  V(IncHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kInc) \
  V(DecHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kDec) \
  V(NegateHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kNegate) \
  V(BitwiseNotHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kBitwiseNot) \
  V(ToBooleanLogicalNotHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kToBooleanLogicalNot) \
  V(LogicalNotHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kLogicalNot) \
  V(TypeOfHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kTypeOf) \
  V(DeletePropertyStrictHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kDeletePropertyStrict) \
  V(DeletePropertySloppyHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kDeletePropertySloppy) \
  V(GetSuperConstructorHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kGetSuperConstructor) \
  V(FindNonDefaultConstructorOrConstructHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kFindNonDefaultConstructorOrConstruct) \
  V(CallAnyReceiverHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kCallAnyReceiver) \
  V(CallPropertyHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kCallProperty) \
  V(CallProperty0Handler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kCallProperty0) \
  V(CallProperty1Handler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kCallProperty1) \
  V(CallProperty2Handler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kCallProperty2) \
  V(CallUndefinedReceiverHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kCallUndefinedReceiver) \
  V(CallUndefinedReceiver0Handler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kCallUndefinedReceiver0) \
  V(CallUndefinedReceiver1Handler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kCallUndefinedReceiver1) \
  V(CallUndefinedReceiver2Handler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kCallUndefinedReceiver2) \
  V(CallWithSpreadHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kCallWithSpread) \
  V(CallRuntimeHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kCallRuntime) \
  V(CallRuntimeForPairHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kCallRuntimeForPair) \
  V(CallJSRuntimeHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kCallJSRuntime) \
  V(InvokeIntrinsicHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kInvokeIntrinsic) \
  V(ConstructHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kConstruct) \
  V(ConstructWithSpreadHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kConstructWithSpread) \
  V(ConstructForwardAllArgsHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kConstructForwardAllArgs) \
  V(TestEqualHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kTestEqual) \
  V(TestEqualStrictHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kTestEqualStrict) \
  V(TestLessThanHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kTestLessThan) \
  V(TestGreaterThanHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kTestGreaterThan) \
  V(TestLessThanOrEqualHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kTestLessThanOrEqual) \
  V(TestGreaterThanOrEqualHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kTestGreaterThanOrEqual) \
  V(TestInstanceOfHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kTestInstanceOf) \
  V(TestInHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kTestIn) \
  V(ToNameHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kToName) \
  V(ToNumberHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kToNumber) \
  V(ToNumericHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kToNumeric) \
  V(ToObjectHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kToObject) \
  V(ToStringHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kToString) \
  V(ToBooleanHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kToBoolean) \
  V(CreateRegExpLiteralHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kCreateRegExpLiteral) \
  V(CreateArrayLiteralHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kCreateArrayLiteral) \
  V(CreateArrayFromIterableHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kCreateArrayFromIterable) \
  V(CreateEmptyArrayLiteralHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kCreateEmptyArrayLiteral) \
  V(CreateObjectLiteralHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kCreateObjectLiteral) \
  V(CreateEmptyObjectLiteralHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kCreateEmptyObjectLiteral) \
  V(CloneObjectHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kCloneObject) \
  V(GetTemplateObjectHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kGetTemplateObject) \
  V(CreateClosureHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kCreateClosure) \
  V(CreateBlockContextHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kCreateBlockContext) \
  V(CreateCatchContextHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kCreateCatchContext) \
  V(CreateFunctionContextHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kCreateFunctionContext) \
  V(CreateEvalContextHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kCreateEvalContext) \
  V(CreateWithContextHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kCreateWithContext) \
  V(CreateMappedArgumentsHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kCreateMappedArguments) \
  V(CreateUnmappedArgumentsHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kCreateUnmappedArguments) \
  V(CreateRestParameterHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kCreateRestParameter) \
  V(JumpLoopHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kJumpLoop) \
  V(JumpHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kJump) \
  V(JumpConstantHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kJumpConstant) \
  V(JumpIfNullConstantHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kJumpIfNullConstant) \
  V(JumpIfNotNullConstantHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kJumpIfNotNullConstant) \
  V(JumpIfUndefinedConstantHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kJumpIfUndefinedConstant) \
  V(JumpIfNotUndefinedConstantHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kJumpIfNotUndefinedConstant) \
  V(JumpIfUndefinedOrNullConstantHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kJumpIfUndefinedOrNullConstant) \
  V(JumpIfTrueConstantHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kJumpIfTrueConstant) \
  V(JumpIfFalseConstantHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kJumpIfFalseConstant) \
  V(JumpIfJSReceiverConstantHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kJumpIfJSReceiverConstant) \
  V(JumpIfForInDoneConstantHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kJumpIfForInDoneConstant) \
  V(JumpIfToBooleanTrueConstantHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kJumpIfToBooleanTrueConstant) \
  V(JumpIfToBooleanFalseConstantHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kJumpIfToBooleanFalseConstant) \
  V(JumpIfToBooleanTrueHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kJumpIfToBooleanTrue) \
  V(JumpIfToBooleanFalseHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kJumpIfToBooleanFalse) \
  V(JumpIfTrueHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kJumpIfTrue) \
  V(JumpIfFalseHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kJumpIfFalse) \
  V(JumpIfNullHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kJumpIfNull) \
  V(JumpIfNotNullHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kJumpIfNotNull) \
  V(JumpIfUndefinedHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kJumpIfUndefined) \
  V(JumpIfNotUndefinedHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kJumpIfNotUndefined) \
  V(JumpIfUndefinedOrNullHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kJumpIfUndefinedOrNull) \
  V(JumpIfJSReceiverHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kJumpIfJSReceiver) \
  V(JumpIfForInDoneHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kJumpIfForInDone) \
  V(SwitchOnSmiNoFeedbackHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kSwitchOnSmiNoFeedback) \
  V(ForInEnumerateHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kForInEnumerate) \
  V(ForInPrepareHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kForInPrepare) \
  V(ForInNextHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kForInNext) \
  V(ForInStepHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kForInStep) \
  V(SetPendingMessageHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kSetPendingMessage) \
  V(ThrowHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kThrow) \
  V(ReThrowHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kReThrow) \
  V(ReturnHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kReturn) \
  V(ThrowReferenceErrorIfHoleHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kThrowReferenceErrorIfHole) \
  V(ThrowSuperNotCalledIfHoleHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kThrowSuperNotCalledIfHole) \
  V(ThrowSuperAlreadyCalledIfNotHoleHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kThrowSuperAlreadyCalledIfNotHole) \
  V(ThrowIfNotSuperConstructorHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kThrowIfNotSuperConstructor) \
  V(SwitchOnGeneratorStateHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kSwitchOnGeneratorState) \
  V(SuspendGeneratorHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kSuspendGenerator) \
  V(ResumeGeneratorHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kResumeGenerator) \
  V(GetIteratorHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kGetIterator) \
  V(DebuggerHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kDebugger) \
  V(IncBlockCounterHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kIncBlockCounter) \
  V(AbortHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kAbort) \
  V(ShortStarHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kStar0) \
  V(IllegalHandler, interpreter::OperandScale::kSingle, interpreter::Bytecode::kIllegal) \
  V(DebugBreak1WideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kDebugBreak1) \
  V(DebugBreak2WideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kDebugBreak2) \
  V(DebugBreak3WideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kDebugBreak3) \
  V(DebugBreak4WideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kDebugBreak4) \
  V(DebugBreak5WideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kDebugBreak5) \
  V(DebugBreak6WideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kDebugBreak6) \
  V(LdarWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kLdar) \
  V(LdaSmiWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kLdaSmi) \
  V(LdaConstantWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kLdaConstant) \
  V(LdaContextSlotWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kLdaContextSlot) \
  V(LdaScriptContextSlotWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kLdaScriptContextSlot) \
  V(LdaImmutableContextSlotWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kLdaImmutableContextSlot) \
  V(LdaCurrentContextSlotWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kLdaCurrentContextSlot) \
  V(LdaCurrentScriptContextSlotWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kLdaCurrentScriptContextSlot) \
  V(LdaImmutableCurrentContextSlotWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kLdaImmutableCurrentContextSlot) \
  V(StarWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kStar) \
  V(MovWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kMov) \
  V(PushContextWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kPushContext) \
  V(PopContextWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kPopContext) \
  V(TestReferenceEqualWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kTestReferenceEqual) \
  V(LdaGlobalWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kLdaGlobal) \
  V(LdaGlobalInsideTypeofWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kLdaGlobalInsideTypeof) \
  V(StaGlobalWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kStaGlobal) \
  V(StaContextSlotWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kStaContextSlot) \
  V(StaCurrentContextSlotWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kStaCurrentContextSlot) \
  V(StaScriptContextSlotWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kStaScriptContextSlot) \
  V(StaCurrentScriptContextSlotWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kStaCurrentScriptContextSlot) \
  V(LdaLookupSlotWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kLdaLookupSlot) \
  V(LdaLookupContextSlotWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kLdaLookupContextSlot) \
  V(LdaLookupScriptContextSlotWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kLdaLookupScriptContextSlot) \
  V(LdaLookupGlobalSlotWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kLdaLookupGlobalSlot) \
  V(LdaLookupSlotInsideTypeofWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kLdaLookupSlotInsideTypeof) \
  V(LdaLookupContextSlotInsideTypeofWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kLdaLookupContextSlotInsideTypeof) \
  V(LdaLookupScriptContextSlotInsideTypeofWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kLdaLookupScriptContextSlotInsideTypeof) \
  V(LdaLookupGlobalSlotInsideTypeofWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kLdaLookupGlobalSlotInsideTypeof) \
  V(StaLookupSlotWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kStaLookupSlot) \
  V(GetNamedPropertyWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kGetNamedProperty) \
  V(GetNamedPropertyFromSuperWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kGetNamedPropertyFromSuper) \
  V(GetKeyedPropertyWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kGetKeyedProperty) \
  V(GetEnumeratedKeyedPropertyWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kGetEnumeratedKeyedProperty) \
  V(LdaModuleVariableWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kLdaModuleVariable) \
  V(StaModuleVariableWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kStaModuleVariable) \
  V(SetNamedPropertyWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kSetNamedProperty) \
  V(DefineNamedOwnPropertyWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kDefineNamedOwnProperty) \
  V(SetKeyedPropertyWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kSetKeyedProperty) \
  V(DefineKeyedOwnPropertyWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kDefineKeyedOwnProperty) \
  V(StaInArrayLiteralWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kStaInArrayLiteral) \
  V(DefineKeyedOwnPropertyInLiteralWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kDefineKeyedOwnPropertyInLiteral) \
  V(AddWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kAdd) \
  V(SubWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kSub) \
  V(MulWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kMul) \
  V(DivWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kDiv) \
  V(ModWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kMod) \
  V(ExpWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kExp) \
  V(BitwiseOrWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kBitwiseOr) \
  V(BitwiseXorWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kBitwiseXor) \
  V(BitwiseAndWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kBitwiseAnd) \
  V(ShiftLeftWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kShiftLeft) \
  V(ShiftRightWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kShiftRight) \
  V(ShiftRightLogicalWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kShiftRightLogical) \
  V(AddSmiWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kAddSmi) \
  V(SubSmiWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kSubSmi) \
  V(MulSmiWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kMulSmi) \
  V(DivSmiWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kDivSmi) \
  V(ModSmiWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kModSmi) \
  V(ExpSmiWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kExpSmi) \
  V(BitwiseOrSmiWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kBitwiseOrSmi) \
  V(BitwiseXorSmiWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kBitwiseXorSmi) \
  V(BitwiseAndSmiWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kBitwiseAndSmi) \
  V(ShiftLeftSmiWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kShiftLeftSmi) \
  V(ShiftRightSmiWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kShiftRightSmi) \
  V(ShiftRightLogicalSmiWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kShiftRightLogicalSmi) \
  V(IncWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kInc) \
  V(DecWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kDec) \
  V(NegateWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kNegate) \
  V(BitwiseNotWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kBitwiseNot) \
  V(TypeOfWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kTypeOf) \
  V(DeletePropertyStrictWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kDeletePropertyStrict) \
  V(DeletePropertySloppyWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kDeletePropertySloppy) \
  V(GetSuperConstructorWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kGetSuperConstructor) \
  V(FindNonDefaultConstructorOrConstructWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kFindNonDefaultConstructorOrConstruct) \
  V(CallAnyReceiverWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kCallAnyReceiver) \
  V(CallPropertyWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kCallProperty) \
  V(CallProperty0WideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kCallProperty0) \
  V(CallProperty1WideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kCallProperty1) \
  V(CallProperty2WideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kCallProperty2) \
  V(CallUndefinedReceiverWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kCallUndefinedReceiver) \
  V(CallUndefinedReceiver0WideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kCallUndefinedReceiver0) \
  V(CallUndefinedReceiver1WideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kCallUndefinedReceiver1) \
  V(CallUndefinedReceiver2WideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kCallUndefinedReceiver2) \
  V(CallWithSpreadWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kCallWithSpread) \
  V(CallRuntimeWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kCallRuntime) \
  V(CallRuntimeForPairWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kCallRuntimeForPair) \
  V(CallJSRuntimeWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kCallJSRuntime) \
  V(InvokeIntrinsicWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kInvokeIntrinsic) \
  V(ConstructWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kConstruct) \
  V(ConstructWithSpreadWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kConstructWithSpread) \
  V(ConstructForwardAllArgsWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kConstructForwardAllArgs) \
  V(TestEqualWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kTestEqual) \
  V(TestEqualStrictWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kTestEqualStrict) \
  V(TestLessThanWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kTestLessThan) \
  V(TestGreaterThanWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kTestGreaterThan) \
  V(TestLessThanOrEqualWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kTestLessThanOrEqual) \
  V(TestGreaterThanOrEqualWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kTestGreaterThanOrEqual) \
  V(TestInstanceOfWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kTestInstanceOf) \
  V(TestInWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kTestIn) \
  V(ToNumberWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kToNumber) \
  V(ToNumericWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kToNumeric) \
  V(ToObjectWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kToObject) \
  V(CreateRegExpLiteralWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kCreateRegExpLiteral) \
  V(CreateArrayLiteralWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kCreateArrayLiteral) \
  V(CreateEmptyArrayLiteralWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kCreateEmptyArrayLiteral) \
  V(CreateObjectLiteralWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kCreateObjectLiteral) \
  V(CloneObjectWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kCloneObject) \
  V(GetTemplateObjectWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kGetTemplateObject) \
  V(CreateClosureWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kCreateClosure) \
  V(CreateBlockContextWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kCreateBlockContext) \
  V(CreateCatchContextWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kCreateCatchContext) \
  V(CreateFunctionContextWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kCreateFunctionContext) \
  V(CreateEvalContextWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kCreateEvalContext) \
  V(CreateWithContextWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kCreateWithContext) \
  V(JumpLoopWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kJumpLoop) \
  V(JumpWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kJump) \
  V(JumpConstantWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kJumpConstant) \
  V(JumpIfNullConstantWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kJumpIfNullConstant) \
  V(JumpIfNotNullConstantWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kJumpIfNotNullConstant) \
  V(JumpIfUndefinedConstantWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kJumpIfUndefinedConstant) \
  V(JumpIfNotUndefinedConstantWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kJumpIfNotUndefinedConstant) \
  V(JumpIfUndefinedOrNullConstantWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kJumpIfUndefinedOrNullConstant) \
  V(JumpIfTrueConstantWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kJumpIfTrueConstant) \
  V(JumpIfFalseConstantWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kJumpIfFalseConstant) \
  V(JumpIfJSReceiverConstantWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kJumpIfJSReceiverConstant) \
  V(JumpIfForInDoneConstantWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kJumpIfForInDoneConstant) \
  V(JumpIfToBooleanTrueConstantWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kJumpIfToBooleanTrueConstant) \
  V(JumpIfToBooleanFalseConstantWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kJumpIfToBooleanFalseConstant) \
  V(JumpIfToBooleanTrueWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kJumpIfToBooleanTrue) \
  V(JumpIfToBooleanFalseWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kJumpIfToBooleanFalse) \
  V(JumpIfTrueWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kJumpIfTrue) \
  V(JumpIfFalseWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kJumpIfFalse) \
  V(JumpIfNullWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kJumpIfNull) \
  V(JumpIfNotNullWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kJumpIfNotNull) \
  V(JumpIfUndefinedWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kJumpIfUndefined) \
  V(JumpIfNotUndefinedWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kJumpIfNotUndefined) \
  V(JumpIfUndefinedOrNullWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kJumpIfUndefinedOrNull) \
  V(JumpIfJSReceiverWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kJumpIfJSReceiver) \
  V(JumpIfForInDoneWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kJumpIfForInDone) \
  V(SwitchOnSmiNoFeedbackWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kSwitchOnSmiNoFeedback) \
  V(ForInEnumerateWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kForInEnumerate) \
  V(ForInPrepareWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kForInPrepare) \
  V(ForInNextWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kForInNext) \
  V(ForInStepWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kForInStep) \
  V(ThrowReferenceErrorIfHoleWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kThrowReferenceErrorIfHole) \
  V(ThrowIfNotSuperConstructorWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kThrowIfNotSuperConstructor) \
  V(SwitchOnGeneratorStateWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kSwitchOnGeneratorState) \
  V(SuspendGeneratorWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kSuspendGenerator) \
  V(ResumeGeneratorWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kResumeGenerator) \
  V(GetIteratorWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kGetIterator) \
  V(IncBlockCounterWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kIncBlockCounter) \
  V(AbortWideHandler, interpreter::OperandScale::kDouble, interpreter::Bytecode::kAbort) \
  V(DebugBreak1ExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kDebugBreak1) \
  V(DebugBreak2ExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kDebugBreak2) \
  V(DebugBreak3ExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kDebugBreak3) \
  V(DebugBreak4ExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kDebugBreak4) \
  V(DebugBreak5ExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kDebugBreak5) \
  V(DebugBreak6ExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kDebugBreak6) \
  V(LdarExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kLdar) \
  V(LdaSmiExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kLdaSmi) \
  V(LdaConstantExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kLdaConstant) \
  V(LdaContextSlotExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kLdaContextSlot) \
  V(LdaScriptContextSlotExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kLdaScriptContextSlot) \
  V(LdaImmutableContextSlotExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kLdaImmutableContextSlot) \
  V(LdaCurrentContextSlotExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kLdaCurrentContextSlot) \
  V(LdaCurrentScriptContextSlotExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kLdaCurrentScriptContextSlot) \
  V(LdaImmutableCurrentContextSlotExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kLdaImmutableCurrentContextSlot) \
  V(StarExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kStar) \
  V(MovExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kMov) \
  V(PushContextExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kPushContext) \
  V(PopContextExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kPopContext) \
  V(TestReferenceEqualExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kTestReferenceEqual) \
  V(LdaGlobalExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kLdaGlobal) \
  V(LdaGlobalInsideTypeofExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kLdaGlobalInsideTypeof) \
  V(StaGlobalExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kStaGlobal) \
  V(StaContextSlotExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kStaContextSlot) \
  V(StaCurrentContextSlotExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kStaCurrentContextSlot) \
  V(StaScriptContextSlotExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kStaScriptContextSlot) \
  V(StaCurrentScriptContextSlotExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kStaCurrentScriptContextSlot) \
  V(LdaLookupSlotExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kLdaLookupSlot) \
  V(LdaLookupContextSlotExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kLdaLookupContextSlot) \
  V(LdaLookupScriptContextSlotExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kLdaLookupScriptContextSlot) \
  V(LdaLookupGlobalSlotExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kLdaLookupGlobalSlot) \
  V(LdaLookupSlotInsideTypeofExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kLdaLookupSlotInsideTypeof) \
  V(LdaLookupContextSlotInsideTypeofExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kLdaLookupContextSlotInsideTypeof) \
  V(LdaLookupScriptContextSlotInsideTypeofExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kLdaLookupScriptContextSlotInsideTypeof) \
  V(LdaLookupGlobalSlotInsideTypeofExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kLdaLookupGlobalSlotInsideTypeof) \
  V(StaLookupSlotExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kStaLookupSlot) \
  V(GetNamedPropertyExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kGetNamedProperty) \
  V(GetNamedPropertyFromSuperExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kGetNamedPropertyFromSuper) \
  V(GetKeyedPropertyExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kGetKeyedProperty) \
  V(GetEnumeratedKeyedPropertyExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kGetEnumeratedKeyedProperty) \
  V(LdaModuleVariableExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kLdaModuleVariable) \
  V(StaModuleVariableExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kStaModuleVariable) \
  V(SetNamedPropertyExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kSetNamedProperty) \
  V(DefineNamedOwnPropertyExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kDefineNamedOwnProperty) \
  V(SetKeyedPropertyExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kSetKeyedProperty) \
  V(DefineKeyedOwnPropertyExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kDefineKeyedOwnProperty) \
  V(StaInArrayLiteralExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kStaInArrayLiteral) \
  V(DefineKeyedOwnPropertyInLiteralExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kDefineKeyedOwnPropertyInLiteral) \
  V(AddExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kAdd) \
  V(SubExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kSub) \
  V(MulExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kMul) \
  V(DivExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kDiv) \
  V(ModExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kMod) \
  V(ExpExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kExp) \
  V(BitwiseOrExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kBitwiseOr) \
  V(BitwiseXorExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kBitwiseXor) \
  V(BitwiseAndExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kBitwiseAnd) \
  V(ShiftLeftExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kShiftLeft) \
  V(ShiftRightExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kShiftRight) \
  V(ShiftRightLogicalExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kShiftRightLogical) \
  V(AddSmiExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kAddSmi) \
  V(SubSmiExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kSubSmi) \
  V(MulSmiExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kMulSmi) \
  V(DivSmiExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kDivSmi) \
  V(ModSmiExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kModSmi) \
  V(ExpSmiExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kExpSmi) \
  V(BitwiseOrSmiExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kBitwiseOrSmi) \
  V(BitwiseXorSmiExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kBitwiseXorSmi) \
  V(BitwiseAndSmiExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kBitwiseAndSmi) \
  V(ShiftLeftSmiExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kShiftLeftSmi) \
  V(ShiftRightSmiExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kShiftRightSmi) \
  V(ShiftRightLogicalSmiExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kShiftRightLogicalSmi) \
  V(IncExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kInc) \
  V(DecExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kDec) \
  V(NegateExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kNegate) \
  V(BitwiseNotExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kBitwiseNot) \
  V(TypeOfExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kTypeOf) \
  V(DeletePropertyStrictExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kDeletePropertyStrict) \
  V(DeletePropertySloppyExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kDeletePropertySloppy) \
  V(GetSuperConstructorExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kGetSuperConstructor) \
  V(FindNonDefaultConstructorOrConstructExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kFindNonDefaultConstructorOrConstruct) \
  V(CallAnyReceiverExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kCallAnyReceiver) \
  V(CallPropertyExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kCallProperty) \
  V(CallProperty0ExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kCallProperty0) \
  V(CallProperty1ExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kCallProperty1) \
  V(CallProperty2ExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kCallProperty2) \
  V(CallUndefinedReceiverExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kCallUndefinedReceiver) \
  V(CallUndefinedReceiver0ExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kCallUndefinedReceiver0) \
  V(CallUndefinedReceiver1ExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kCallUndefinedReceiver1) \
  V(CallUndefinedReceiver2ExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kCallUndefinedReceiver2) \
  V(CallWithSpreadExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kCallWithSpread) \
  V(CallRuntimeExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kCallRuntime) \
  V(CallRuntimeForPairExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kCallRuntimeForPair) \
  V(CallJSRuntimeExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kCallJSRuntime) \
  V(InvokeIntrinsicExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kInvokeIntrinsic) \
  V(ConstructExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kConstruct) \
  V(ConstructWithSpreadExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kConstructWithSpread) \
  V(ConstructForwardAllArgsExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kConstructForwardAllArgs) \
  V(TestEqualExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kTestEqual) \
  V(TestEqualStrictExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kTestEqualStrict) \
  V(TestLessThanExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kTestLessThan) \
  V(TestGreaterThanExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kTestGreaterThan) \
  V(TestLessThanOrEqualExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kTestLessThanOrEqual) \
  V(TestGreaterThanOrEqualExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kTestGreaterThanOrEqual) \
  V(TestInstanceOfExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kTestInstanceOf) \
  V(TestInExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kTestIn) \
  V(ToNumberExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kToNumber) \
  V(ToNumericExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kToNumeric) \
  V(ToObjectExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kToObject) \
  V(CreateRegExpLiteralExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kCreateRegExpLiteral) \
  V(CreateArrayLiteralExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kCreateArrayLiteral) \
  V(CreateEmptyArrayLiteralExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kCreateEmptyArrayLiteral) \
  V(CreateObjectLiteralExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kCreateObjectLiteral) \
  V(CloneObjectExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kCloneObject) \
  V(GetTemplateObjectExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kGetTemplateObject) \
  V(CreateClosureExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kCreateClosure) \
  V(CreateBlockContextExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kCreateBlockContext) \
  V(CreateCatchContextExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kCreateCatchContext) \
  V(CreateFunctionContextExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kCreateFunctionContext) \
  V(CreateEvalContextExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kCreateEvalContext) \
  V(CreateWithContextExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kCreateWithContext) \
  V(JumpLoopExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kJumpLoop) \
  V(JumpExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kJump) \
  V(JumpConstantExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kJumpConstant) \
  V(JumpIfNullConstantExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kJumpIfNullConstant) \
  V(JumpIfNotNullConstantExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kJumpIfNotNullConstant) \
  V(JumpIfUndefinedConstantExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kJumpIfUndefinedConstant) \
  V(JumpIfNotUndefinedConstantExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kJumpIfNotUndefinedConstant) \
  V(JumpIfUndefinedOrNullConstantExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kJumpIfUndefinedOrNullConstant) \
  V(JumpIfTrueConstantExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kJumpIfTrueConstant) \
  V(JumpIfFalseConstantExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kJumpIfFalseConstant) \
  V(JumpIfJSReceiverConstantExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kJumpIfJSReceiverConstant) \
  V(JumpIfForInDoneConstantExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kJumpIfForInDoneConstant) \
  V(JumpIfToBooleanTrueConstantExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kJumpIfToBooleanTrueConstant) \
  V(JumpIfToBooleanFalseConstantExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kJumpIfToBooleanFalseConstant) \
  V(JumpIfToBooleanTrueExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kJumpIfToBooleanTrue) \
  V(JumpIfToBooleanFalseExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kJumpIfToBooleanFalse) \
  V(JumpIfTrueExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kJumpIfTrue) \
  V(JumpIfFalseExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kJumpIfFalse) \
  V(JumpIfNullExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kJumpIfNull) \
  V(JumpIfNotNullExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kJumpIfNotNull) \
  V(JumpIfUndefinedExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kJumpIfUndefined) \
  V(JumpIfNotUndefinedExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kJumpIfNotUndefined) \
  V(JumpIfUndefinedOrNullExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kJumpIfUndefinedOrNull) \
  V(JumpIfJSReceiverExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kJumpIfJSReceiver) \
  V(JumpIfForInDoneExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kJumpIfForInDone) \
  V(SwitchOnSmiNoFeedbackExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kSwitchOnSmiNoFeedback) \
  V(ForInEnumerateExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kForInEnumerate) \
  V(ForInPrepareExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kForInPrepare) \
  V(ForInNextExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kForInNext) \
  V(ForInStepExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kForInStep) \
  V(ThrowReferenceErrorIfHoleExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kThrowReferenceErrorIfHole) \
  V(ThrowIfNotSuperConstructorExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kThrowIfNotSuperConstructor) \
  V(SwitchOnGeneratorStateExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kSwitchOnGeneratorState) \
  V(SuspendGeneratorExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kSuspendGenerator) \
  V(ResumeGeneratorExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kResumeGenerator) \
  V(GetIteratorExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kGetIterator) \
  V(IncBlockCounterExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kIncBlockCounter) \
  V(AbortExtraWideHandler, interpreter::OperandScale::kQuadruple, interpreter::Bytecode::kAbort)

constexpr int kNumberOfBytecodeHandlers = 193;
constexpr int kNumberOfWideBytecodeHandlers = 159;

constexpr uint8_t kIllegalBytecodeHandlerEncoding = 255;

// Mapping from Bytecode to a dense form with all the illegal
// wide Bytecodes removed. Used to index into the builtins table.
constexpr uint8_t kWideBytecodeToBuiltinsMapping[208] = {    
255, 255, 255, 255, 255, 0, 1, 2, 3, 4, 5, 6, 255, 7, 255, 255, 255, 255, 255, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 255, 255, 255, 255, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 255, 255, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 255, 106, 107, 108, 255, 255, 109, 110, 255, 111, 112, 255, 113, 114, 115, 116, 117, 118, 119, 120, 255, 255, 255, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 255, 255, 255, 255, 151, 255, 255, 152, 153, 154, 155, 156, 255, 157, 158, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, };

}  // namespace internal
}  // namespace v8
#endif  // V8_BUILTINS_GENERATED_BYTECODES_BUILTINS_LIST
