// Code generated by protoc-gen-go. DO NOT EDIT.
// source: plugins/base/proto/base.proto

package proto

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	hclspec "github.com/hashicorp/nomad/plugins/shared/hclspec"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// PluginType enumerates the type of plugins Nomad supports
type PluginType int32

const (
	PluginType_UNKNOWN PluginType = 0
	PluginType_DRIVER  PluginType = 2
	PluginType_DEVICE  PluginType = 3
)

var PluginType_name = map[int32]string{
	0: "UNKNOWN",
	2: "DRIVER",
	3: "DEVICE",
}

var PluginType_value = map[string]int32{
	"UNKNOWN": 0,
	"DRIVER":  2,
	"DEVICE":  3,
}

func (x PluginType) String() string {
	return proto.EnumName(PluginType_name, int32(x))
}

func (PluginType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_19edef855873449e, []int{0}
}

type CoreGrade int32

const (
	CoreGrade_Performance CoreGrade = 0
	CoreGrade_Efficiency  CoreGrade = 1
)

var CoreGrade_name = map[int32]string{
	0: "Performance",
	1: "Efficiency",
}

var CoreGrade_value = map[string]int32{
	"Performance": 0,
	"Efficiency":  1,
}

func (x CoreGrade) String() string {
	return proto.EnumName(CoreGrade_name, int32(x))
}

func (CoreGrade) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_19edef855873449e, []int{1}
}

// PluginInfoRequest is used to request the plugins basic information.
type PluginInfoRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PluginInfoRequest) Reset()         { *m = PluginInfoRequest{} }
func (m *PluginInfoRequest) String() string { return proto.CompactTextString(m) }
func (*PluginInfoRequest) ProtoMessage()    {}
func (*PluginInfoRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_19edef855873449e, []int{0}
}

func (m *PluginInfoRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PluginInfoRequest.Unmarshal(m, b)
}
func (m *PluginInfoRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PluginInfoRequest.Marshal(b, m, deterministic)
}
func (m *PluginInfoRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PluginInfoRequest.Merge(m, src)
}
func (m *PluginInfoRequest) XXX_Size() int {
	return xxx_messageInfo_PluginInfoRequest.Size(m)
}
func (m *PluginInfoRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PluginInfoRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PluginInfoRequest proto.InternalMessageInfo

// PluginInfoResponse returns basic information about the plugin such
// that Nomad can decide whether to load the plugin or not.
type PluginInfoResponse struct {
	// type indicates what type of plugin this is.
	Type PluginType `protobuf:"varint,1,opt,name=type,proto3,enum=hashicorp.nomad.plugins.base.proto.PluginType" json:"type,omitempty"`
	// plugin_api_versions indicates the versions of the Nomad Plugin API
	// this plugin supports.
	PluginApiVersions []string `protobuf:"bytes,2,rep,name=plugin_api_versions,json=pluginApiVersions,proto3" json:"plugin_api_versions,omitempty"`
	// plugin_version is the semver version of this individual plugin.
	// This is divorce from Nomad’s development and versioning.
	PluginVersion string `protobuf:"bytes,3,opt,name=plugin_version,json=pluginVersion,proto3" json:"plugin_version,omitempty"`
	// name is the name of the plugin
	Name                 string   `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PluginInfoResponse) Reset()         { *m = PluginInfoResponse{} }
func (m *PluginInfoResponse) String() string { return proto.CompactTextString(m) }
func (*PluginInfoResponse) ProtoMessage()    {}
func (*PluginInfoResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_19edef855873449e, []int{1}
}

func (m *PluginInfoResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PluginInfoResponse.Unmarshal(m, b)
}
func (m *PluginInfoResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PluginInfoResponse.Marshal(b, m, deterministic)
}
func (m *PluginInfoResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PluginInfoResponse.Merge(m, src)
}
func (m *PluginInfoResponse) XXX_Size() int {
	return xxx_messageInfo_PluginInfoResponse.Size(m)
}
func (m *PluginInfoResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_PluginInfoResponse.DiscardUnknown(m)
}

var xxx_messageInfo_PluginInfoResponse proto.InternalMessageInfo

func (m *PluginInfoResponse) GetType() PluginType {
	if m != nil {
		return m.Type
	}
	return PluginType_UNKNOWN
}

func (m *PluginInfoResponse) GetPluginApiVersions() []string {
	if m != nil {
		return m.PluginApiVersions
	}
	return nil
}

func (m *PluginInfoResponse) GetPluginVersion() string {
	if m != nil {
		return m.PluginVersion
	}
	return ""
}

func (m *PluginInfoResponse) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// ConfigSchemaRequest is used to request the configurations schema.
type ConfigSchemaRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ConfigSchemaRequest) Reset()         { *m = ConfigSchemaRequest{} }
func (m *ConfigSchemaRequest) String() string { return proto.CompactTextString(m) }
func (*ConfigSchemaRequest) ProtoMessage()    {}
func (*ConfigSchemaRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_19edef855873449e, []int{2}
}

func (m *ConfigSchemaRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ConfigSchemaRequest.Unmarshal(m, b)
}
func (m *ConfigSchemaRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ConfigSchemaRequest.Marshal(b, m, deterministic)
}
func (m *ConfigSchemaRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConfigSchemaRequest.Merge(m, src)
}
func (m *ConfigSchemaRequest) XXX_Size() int {
	return xxx_messageInfo_ConfigSchemaRequest.Size(m)
}
func (m *ConfigSchemaRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ConfigSchemaRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ConfigSchemaRequest proto.InternalMessageInfo

// ConfigSchemaResponse returns the plugins configuration schema.
type ConfigSchemaResponse struct {
	// spec is the plugins configuration schema
	Spec                 *hclspec.Spec `protobuf:"bytes,1,opt,name=spec,proto3" json:"spec,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *ConfigSchemaResponse) Reset()         { *m = ConfigSchemaResponse{} }
func (m *ConfigSchemaResponse) String() string { return proto.CompactTextString(m) }
func (*ConfigSchemaResponse) ProtoMessage()    {}
func (*ConfigSchemaResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_19edef855873449e, []int{3}
}

func (m *ConfigSchemaResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ConfigSchemaResponse.Unmarshal(m, b)
}
func (m *ConfigSchemaResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ConfigSchemaResponse.Marshal(b, m, deterministic)
}
func (m *ConfigSchemaResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConfigSchemaResponse.Merge(m, src)
}
func (m *ConfigSchemaResponse) XXX_Size() int {
	return xxx_messageInfo_ConfigSchemaResponse.Size(m)
}
func (m *ConfigSchemaResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ConfigSchemaResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ConfigSchemaResponse proto.InternalMessageInfo

func (m *ConfigSchemaResponse) GetSpec() *hclspec.Spec {
	if m != nil {
		return m.Spec
	}
	return nil
}

// SetConfigRequest is used to set the configuration
type SetConfigRequest struct {
	// msgpack_config is the configuration encoded as MessagePack.
	MsgpackConfig []byte `protobuf:"bytes,1,opt,name=msgpack_config,json=msgpackConfig,proto3" json:"msgpack_config,omitempty"`
	// nomad_config is the nomad client configuration sent to all plugins.
	NomadConfig *NomadConfig `protobuf:"bytes,2,opt,name=nomad_config,json=nomadConfig,proto3" json:"nomad_config,omitempty"`
	// plugin_api_version is the api version to use.
	PluginApiVersion     string   `protobuf:"bytes,3,opt,name=plugin_api_version,json=pluginApiVersion,proto3" json:"plugin_api_version,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SetConfigRequest) Reset()         { *m = SetConfigRequest{} }
func (m *SetConfigRequest) String() string { return proto.CompactTextString(m) }
func (*SetConfigRequest) ProtoMessage()    {}
func (*SetConfigRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_19edef855873449e, []int{4}
}

func (m *SetConfigRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SetConfigRequest.Unmarshal(m, b)
}
func (m *SetConfigRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SetConfigRequest.Marshal(b, m, deterministic)
}
func (m *SetConfigRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SetConfigRequest.Merge(m, src)
}
func (m *SetConfigRequest) XXX_Size() int {
	return xxx_messageInfo_SetConfigRequest.Size(m)
}
func (m *SetConfigRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SetConfigRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SetConfigRequest proto.InternalMessageInfo

func (m *SetConfigRequest) GetMsgpackConfig() []byte {
	if m != nil {
		return m.MsgpackConfig
	}
	return nil
}

func (m *SetConfigRequest) GetNomadConfig() *NomadConfig {
	if m != nil {
		return m.NomadConfig
	}
	return nil
}

func (m *SetConfigRequest) GetPluginApiVersion() string {
	if m != nil {
		return m.PluginApiVersion
	}
	return ""
}

// NomadConfig is the client configuration sent to all plugins
type NomadConfig struct {
	// driver specific configuration sent to all plugins
	Driver               *NomadDriverConfig `protobuf:"bytes,1,opt,name=driver,proto3" json:"driver,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *NomadConfig) Reset()         { *m = NomadConfig{} }
func (m *NomadConfig) String() string { return proto.CompactTextString(m) }
func (*NomadConfig) ProtoMessage()    {}
func (*NomadConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_19edef855873449e, []int{5}
}

func (m *NomadConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NomadConfig.Unmarshal(m, b)
}
func (m *NomadConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NomadConfig.Marshal(b, m, deterministic)
}
func (m *NomadConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NomadConfig.Merge(m, src)
}
func (m *NomadConfig) XXX_Size() int {
	return xxx_messageInfo_NomadConfig.Size(m)
}
func (m *NomadConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_NomadConfig.DiscardUnknown(m)
}

var xxx_messageInfo_NomadConfig proto.InternalMessageInfo

func (m *NomadConfig) GetDriver() *NomadDriverConfig {
	if m != nil {
		return m.Driver
	}
	return nil
}

// NomadDriverConfig is the driver specific client configuration sent to all
// driver plugins
type NomadDriverConfig struct {
	// ClientMaxPort is the upper range of the ports that the client uses for
	// communicating with plugin subsystems over loopback
	// buf:lint:ignore FIELD_LOWER_SNAKE_CASE
	ClientMaxPort uint32 `protobuf:"varint,1,opt,name=ClientMaxPort,proto3" json:"ClientMaxPort,omitempty"`
	// ClientMinPort is the lower range of the ports that the client uses for
	// communicating with plugin subsystems over loopback
	// buf:lint:ignore FIELD_LOWER_SNAKE_CASE
	ClientMinPort uint32 `protobuf:"varint,2,opt,name=ClientMinPort,proto3" json:"ClientMinPort,omitempty"`
	// Topology is the complex hardware topology detected by the client
	// combined with client configuration.
	Topology             *ClientTopology `protobuf:"bytes,3,opt,name=Topology,proto3" json:"Topology,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *NomadDriverConfig) Reset()         { *m = NomadDriverConfig{} }
func (m *NomadDriverConfig) String() string { return proto.CompactTextString(m) }
func (*NomadDriverConfig) ProtoMessage()    {}
func (*NomadDriverConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_19edef855873449e, []int{6}
}

func (m *NomadDriverConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NomadDriverConfig.Unmarshal(m, b)
}
func (m *NomadDriverConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NomadDriverConfig.Marshal(b, m, deterministic)
}
func (m *NomadDriverConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NomadDriverConfig.Merge(m, src)
}
func (m *NomadDriverConfig) XXX_Size() int {
	return xxx_messageInfo_NomadDriverConfig.Size(m)
}
func (m *NomadDriverConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_NomadDriverConfig.DiscardUnknown(m)
}

var xxx_messageInfo_NomadDriverConfig proto.InternalMessageInfo

func (m *NomadDriverConfig) GetClientMaxPort() uint32 {
	if m != nil {
		return m.ClientMaxPort
	}
	return 0
}

func (m *NomadDriverConfig) GetClientMinPort() uint32 {
	if m != nil {
		return m.ClientMinPort
	}
	return 0
}

func (m *NomadDriverConfig) GetTopology() *ClientTopology {
	if m != nil {
		return m.Topology
	}
	return nil
}

// numalib/Topology
type ClientTopology struct {
	NodeIds                []uint32              `protobuf:"varint,1,rep,packed,name=node_ids,json=nodeIds,proto3" json:"node_ids,omitempty"`
	Distances              *ClientTopologySLIT   `protobuf:"bytes,2,opt,name=distances,proto3" json:"distances,omitempty"`
	Cores                  []*ClientTopologyCore `protobuf:"bytes,3,rep,name=cores,proto3" json:"cores,omitempty"`
	OverrideTotalCompute   uint64                `protobuf:"varint,4,opt,name=override_total_compute,json=overrideTotalCompute,proto3" json:"override_total_compute,omitempty"`
	OverrideWitholdCompute uint64                `protobuf:"varint,5,opt,name=override_withold_compute,json=overrideWitholdCompute,proto3" json:"override_withold_compute,omitempty"`
	XXX_NoUnkeyedLiteral   struct{}              `json:"-"`
	XXX_unrecognized       []byte                `json:"-"`
	XXX_sizecache          int32                 `json:"-"`
}

func (m *ClientTopology) Reset()         { *m = ClientTopology{} }
func (m *ClientTopology) String() string { return proto.CompactTextString(m) }
func (*ClientTopology) ProtoMessage()    {}
func (*ClientTopology) Descriptor() ([]byte, []int) {
	return fileDescriptor_19edef855873449e, []int{7}
}

func (m *ClientTopology) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ClientTopology.Unmarshal(m, b)
}
func (m *ClientTopology) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ClientTopology.Marshal(b, m, deterministic)
}
func (m *ClientTopology) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClientTopology.Merge(m, src)
}
func (m *ClientTopology) XXX_Size() int {
	return xxx_messageInfo_ClientTopology.Size(m)
}
func (m *ClientTopology) XXX_DiscardUnknown() {
	xxx_messageInfo_ClientTopology.DiscardUnknown(m)
}

var xxx_messageInfo_ClientTopology proto.InternalMessageInfo

func (m *ClientTopology) GetNodeIds() []uint32 {
	if m != nil {
		return m.NodeIds
	}
	return nil
}

func (m *ClientTopology) GetDistances() *ClientTopologySLIT {
	if m != nil {
		return m.Distances
	}
	return nil
}

func (m *ClientTopology) GetCores() []*ClientTopologyCore {
	if m != nil {
		return m.Cores
	}
	return nil
}

func (m *ClientTopology) GetOverrideTotalCompute() uint64 {
	if m != nil {
		return m.OverrideTotalCompute
	}
	return 0
}

func (m *ClientTopology) GetOverrideWitholdCompute() uint64 {
	if m != nil {
		return m.OverrideWitholdCompute
	}
	return 0
}

// numalib/SLIT
type ClientTopologySLIT struct {
	// dimension is the row and column size of the slit matrix
	Dimension uint32 `protobuf:"varint,1,opt,name=dimension,proto3" json:"dimension,omitempty"`
	// values is the flattened matrix of slit values
	Values               []uint32 `protobuf:"varint,2,rep,packed,name=values,proto3" json:"values,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ClientTopologySLIT) Reset()         { *m = ClientTopologySLIT{} }
func (m *ClientTopologySLIT) String() string { return proto.CompactTextString(m) }
func (*ClientTopologySLIT) ProtoMessage()    {}
func (*ClientTopologySLIT) Descriptor() ([]byte, []int) {
	return fileDescriptor_19edef855873449e, []int{8}
}

func (m *ClientTopologySLIT) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ClientTopologySLIT.Unmarshal(m, b)
}
func (m *ClientTopologySLIT) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ClientTopologySLIT.Marshal(b, m, deterministic)
}
func (m *ClientTopologySLIT) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClientTopologySLIT.Merge(m, src)
}
func (m *ClientTopologySLIT) XXX_Size() int {
	return xxx_messageInfo_ClientTopologySLIT.Size(m)
}
func (m *ClientTopologySLIT) XXX_DiscardUnknown() {
	xxx_messageInfo_ClientTopologySLIT.DiscardUnknown(m)
}

var xxx_messageInfo_ClientTopologySLIT proto.InternalMessageInfo

func (m *ClientTopologySLIT) GetDimension() uint32 {
	if m != nil {
		return m.Dimension
	}
	return 0
}

func (m *ClientTopologySLIT) GetValues() []uint32 {
	if m != nil {
		return m.Values
	}
	return nil
}

// numalib/Core
type ClientTopologyCore struct {
	SocketId             uint32    `protobuf:"varint,1,opt,name=socket_id,json=socketId,proto3" json:"socket_id,omitempty"`
	NodeId               uint32    `protobuf:"varint,2,opt,name=node_id,json=nodeId,proto3" json:"node_id,omitempty"`
	CoreId               uint32    `protobuf:"varint,3,opt,name=core_id,json=coreId,proto3" json:"core_id,omitempty"`
	CoreGrade            CoreGrade `protobuf:"varint,4,opt,name=core_grade,json=coreGrade,proto3,enum=hashicorp.nomad.plugins.base.proto.CoreGrade" json:"core_grade,omitempty"`
	Disable              bool      `protobuf:"varint,5,opt,name=disable,proto3" json:"disable,omitempty"`
	BaseSpeed            uint64    `protobuf:"varint,6,opt,name=base_speed,json=baseSpeed,proto3" json:"base_speed,omitempty"`
	MaxSpeed             uint64    `protobuf:"varint,7,opt,name=max_speed,json=maxSpeed,proto3" json:"max_speed,omitempty"`
	GuessSpeed           uint64    `protobuf:"varint,8,opt,name=guess_speed,json=guessSpeed,proto3" json:"guess_speed,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *ClientTopologyCore) Reset()         { *m = ClientTopologyCore{} }
func (m *ClientTopologyCore) String() string { return proto.CompactTextString(m) }
func (*ClientTopologyCore) ProtoMessage()    {}
func (*ClientTopologyCore) Descriptor() ([]byte, []int) {
	return fileDescriptor_19edef855873449e, []int{9}
}

func (m *ClientTopologyCore) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ClientTopologyCore.Unmarshal(m, b)
}
func (m *ClientTopologyCore) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ClientTopologyCore.Marshal(b, m, deterministic)
}
func (m *ClientTopologyCore) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClientTopologyCore.Merge(m, src)
}
func (m *ClientTopologyCore) XXX_Size() int {
	return xxx_messageInfo_ClientTopologyCore.Size(m)
}
func (m *ClientTopologyCore) XXX_DiscardUnknown() {
	xxx_messageInfo_ClientTopologyCore.DiscardUnknown(m)
}

var xxx_messageInfo_ClientTopologyCore proto.InternalMessageInfo

func (m *ClientTopologyCore) GetSocketId() uint32 {
	if m != nil {
		return m.SocketId
	}
	return 0
}

func (m *ClientTopologyCore) GetNodeId() uint32 {
	if m != nil {
		return m.NodeId
	}
	return 0
}

func (m *ClientTopologyCore) GetCoreId() uint32 {
	if m != nil {
		return m.CoreId
	}
	return 0
}

func (m *ClientTopologyCore) GetCoreGrade() CoreGrade {
	if m != nil {
		return m.CoreGrade
	}
	return CoreGrade_Performance
}

func (m *ClientTopologyCore) GetDisable() bool {
	if m != nil {
		return m.Disable
	}
	return false
}

func (m *ClientTopologyCore) GetBaseSpeed() uint64 {
	if m != nil {
		return m.BaseSpeed
	}
	return 0
}

func (m *ClientTopologyCore) GetMaxSpeed() uint64 {
	if m != nil {
		return m.MaxSpeed
	}
	return 0
}

func (m *ClientTopologyCore) GetGuessSpeed() uint64 {
	if m != nil {
		return m.GuessSpeed
	}
	return 0
}

// SetConfigResponse is used to respond to setting the configuration
type SetConfigResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SetConfigResponse) Reset()         { *m = SetConfigResponse{} }
func (m *SetConfigResponse) String() string { return proto.CompactTextString(m) }
func (*SetConfigResponse) ProtoMessage()    {}
func (*SetConfigResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_19edef855873449e, []int{10}
}

func (m *SetConfigResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SetConfigResponse.Unmarshal(m, b)
}
func (m *SetConfigResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SetConfigResponse.Marshal(b, m, deterministic)
}
func (m *SetConfigResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SetConfigResponse.Merge(m, src)
}
func (m *SetConfigResponse) XXX_Size() int {
	return xxx_messageInfo_SetConfigResponse.Size(m)
}
func (m *SetConfigResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SetConfigResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SetConfigResponse proto.InternalMessageInfo

func init() {
	proto.RegisterEnum("hashicorp.nomad.plugins.base.proto.PluginType", PluginType_name, PluginType_value)
	proto.RegisterEnum("hashicorp.nomad.plugins.base.proto.CoreGrade", CoreGrade_name, CoreGrade_value)
	proto.RegisterType((*PluginInfoRequest)(nil), "hashicorp.nomad.plugins.base.proto.PluginInfoRequest")
	proto.RegisterType((*PluginInfoResponse)(nil), "hashicorp.nomad.plugins.base.proto.PluginInfoResponse")
	proto.RegisterType((*ConfigSchemaRequest)(nil), "hashicorp.nomad.plugins.base.proto.ConfigSchemaRequest")
	proto.RegisterType((*ConfigSchemaResponse)(nil), "hashicorp.nomad.plugins.base.proto.ConfigSchemaResponse")
	proto.RegisterType((*SetConfigRequest)(nil), "hashicorp.nomad.plugins.base.proto.SetConfigRequest")
	proto.RegisterType((*NomadConfig)(nil), "hashicorp.nomad.plugins.base.proto.NomadConfig")
	proto.RegisterType((*NomadDriverConfig)(nil), "hashicorp.nomad.plugins.base.proto.NomadDriverConfig")
	proto.RegisterType((*ClientTopology)(nil), "hashicorp.nomad.plugins.base.proto.ClientTopology")
	proto.RegisterType((*ClientTopologySLIT)(nil), "hashicorp.nomad.plugins.base.proto.ClientTopologySLIT")
	proto.RegisterType((*ClientTopologyCore)(nil), "hashicorp.nomad.plugins.base.proto.ClientTopologyCore")
	proto.RegisterType((*SetConfigResponse)(nil), "hashicorp.nomad.plugins.base.proto.SetConfigResponse")
}

func init() {
	proto.RegisterFile("plugins/base/proto/base.proto", fileDescriptor_19edef855873449e)
}

var fileDescriptor_19edef855873449e = []byte{
	// 861 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x55, 0x4d, 0x6f, 0x23, 0x45,
	0x10, 0xcd, 0xd8, 0x8e, 0x3f, 0xca, 0xb1, 0x71, 0x2a, 0x0b, 0x0c, 0x86, 0x15, 0xd6, 0x88, 0x95,
	0xa2, 0x55, 0x98, 0x08, 0xb3, 0x59, 0xf6, 0x08, 0xf1, 0x46, 0xc8, 0x22, 0x6b, 0xa2, 0xb6, 0xc9,
	0x22, 0x84, 0x64, 0x75, 0x66, 0xda, 0x76, 0x6b, 0x3d, 0xd3, 0xc3, 0xf4, 0x38, 0x24, 0x48, 0x9c,
	0x38, 0xf3, 0x3f, 0xb8, 0xf1, 0x03, 0x38, 0x70, 0xe0, 0x8f, 0xa1, 0xfe, 0x18, 0xdb, 0x49, 0x84,
	0xb0, 0xf7, 0xe4, 0xee, 0x7a, 0xaf, 0x5e, 0x75, 0xbd, 0x1e, 0x57, 0xc3, 0xe3, 0x64, 0xbe, 0x98,
	0xf2, 0x58, 0x1e, 0x5f, 0x51, 0xc9, 0x8e, 0x93, 0x54, 0x64, 0x42, 0x2f, 0x7d, 0xbd, 0x44, 0x6f,
	0x46, 0xe5, 0x8c, 0x07, 0x22, 0x4d, 0xfc, 0x58, 0x44, 0x34, 0xf4, 0x2d, 0xdd, 0x5f, 0x71, 0xda,
	0x4f, 0x72, 0x09, 0x39, 0xa3, 0x29, 0x0b, 0x8f, 0x67, 0xc1, 0x5c, 0x26, 0x2c, 0x50, 0xbf, 0x63,
	0xb5, 0x30, 0x34, 0xef, 0x00, 0xf6, 0x2f, 0x34, 0xb1, 0x1f, 0x4f, 0x04, 0x61, 0x3f, 0x2d, 0x98,
	0xcc, 0xbc, 0x7f, 0x1c, 0xc0, 0xf5, 0xa8, 0x4c, 0x44, 0x2c, 0x19, 0x9e, 0x42, 0x29, 0xbb, 0x4d,
	0x98, 0xeb, 0x74, 0x9c, 0xc3, 0x66, 0xd7, 0xf7, 0xff, 0xff, 0x14, 0xbe, 0x51, 0x19, 0xdd, 0x26,
	0x8c, 0xe8, 0x5c, 0xf4, 0xe1, 0xc0, 0xd0, 0xc6, 0x34, 0xe1, 0xe3, 0x6b, 0x96, 0x4a, 0x2e, 0x62,
	0xe9, 0x16, 0x3a, 0xc5, 0xc3, 0x1a, 0xd9, 0x37, 0xd0, 0x57, 0x09, 0xbf, 0xb4, 0x00, 0x3e, 0x81,
	0xa6, 0xe5, 0x5b, 0xae, 0x5b, 0xec, 0x38, 0x87, 0x35, 0xd2, 0x30, 0x51, 0xcb, 0x43, 0x84, 0x52,
	0x4c, 0x23, 0xe6, 0x96, 0x34, 0xa8, 0xd7, 0xde, 0xbb, 0x70, 0xd0, 0x13, 0xf1, 0x84, 0x4f, 0x87,
	0xc1, 0x8c, 0x45, 0x34, 0x6f, 0xee, 0x7b, 0x78, 0x74, 0x37, 0x6c, 0xbb, 0xfb, 0x12, 0x4a, 0xca,
	0x17, 0xdd, 0x5d, 0xbd, 0x7b, 0xf4, 0x9f, 0xdd, 0x19, 0x3f, 0x7d, 0xeb, 0xa7, 0x3f, 0x4c, 0x58,
	0x40, 0x74, 0xa6, 0xf7, 0x97, 0x03, 0xad, 0x21, 0xcb, 0x8c, 0xba, 0x2d, 0xa7, 0x1a, 0x88, 0xe4,
	0x34, 0xa1, 0xc1, 0x9b, 0x71, 0xa0, 0x01, 0x5d, 0x60, 0x8f, 0x34, 0x6c, 0xd4, 0xb0, 0x91, 0xc0,
	0x9e, 0x2e, 0x93, 0x93, 0x0a, 0xfa, 0x14, 0xc7, 0x9b, 0x78, 0x3c, 0x50, 0x80, 0x2d, 0x5a, 0x8f,
	0x57, 0x1b, 0x3c, 0x02, 0x7c, 0xe8, 0xb5, 0xf5, 0xaf, 0x75, 0xdf, 0x6a, 0xef, 0x47, 0xa8, 0xaf,
	0x29, 0xe1, 0x2b, 0x28, 0x87, 0x29, 0xbf, 0x66, 0xa9, 0x35, 0xe4, 0x64, 0xe3, 0xa3, 0xbc, 0xd4,
	0x69, 0xf6, 0x40, 0x56, 0xc4, 0xfb, 0xd3, 0x81, 0xfd, 0x07, 0x28, 0x7e, 0x02, 0x8d, 0xde, 0x9c,
	0xb3, 0x38, 0x7b, 0x45, 0x6f, 0x2e, 0x44, 0x9a, 0xe9, 0x5a, 0x0d, 0x72, 0x37, 0xb8, 0xc6, 0xe2,
	0xb1, 0x66, 0x15, 0xee, 0xb0, 0x4c, 0x10, 0x07, 0x50, 0x1d, 0x89, 0x44, 0xcc, 0xc5, 0xf4, 0x56,
	0xf7, 0x58, 0xef, 0x76, 0x37, 0x39, 0xb2, 0x11, 0xc9, 0x33, 0xc9, 0x52, 0xc3, 0xfb, 0xbb, 0x00,
	0xcd, 0xbb, 0x20, 0x7e, 0x00, 0xd5, 0x58, 0x84, 0x6c, 0xcc, 0x43, 0xe9, 0x3a, 0x9d, 0xe2, 0x61,
	0x83, 0x54, 0xd4, 0xbe, 0x1f, 0x4a, 0x1c, 0x41, 0x2d, 0xe4, 0x32, 0xa3, 0x71, 0xc0, 0xa4, 0xbd,
	0xbc, 0xe7, 0xdb, 0x97, 0x1f, 0x9e, 0xf7, 0x47, 0x64, 0x25, 0x84, 0xe7, 0xb0, 0x1b, 0x88, 0x94,
	0x49, 0xb7, 0xd8, 0x29, 0xbe, 0x9d, 0x62, 0x4f, 0xa4, 0x8c, 0x18, 0x11, 0x7c, 0x06, 0xef, 0x89,
	0x6b, 0x96, 0xa6, 0x3c, 0x64, 0xe3, 0x4c, 0x64, 0x74, 0x3e, 0x0e, 0x44, 0x94, 0x2c, 0x32, 0xf3,
	0xb7, 0x29, 0x91, 0x47, 0x39, 0x3a, 0x52, 0x60, 0xcf, 0x60, 0xf8, 0x02, 0xdc, 0x65, 0xd6, 0xcf,
	0x3c, 0x9b, 0x89, 0x79, 0xb8, 0xcc, 0xdb, 0xd5, 0x79, 0x4b, 0xd5, 0xd7, 0x06, 0xb6, 0x99, 0xde,
	0x00, 0xf0, 0x61, 0x7b, 0xf8, 0x91, 0x72, 0x2a, 0x62, 0xb1, 0xfe, 0x18, 0xcd, 0x7d, 0xaf, 0x02,
	0xd8, 0x86, 0xf2, 0x35, 0x9d, 0x2f, 0x98, 0x19, 0x09, 0x8d, 0xd3, 0x42, 0xcb, 0x21, 0x36, 0xe2,
	0xfd, 0x51, 0xb8, 0x2f, 0xa8, 0xba, 0xc3, 0x0f, 0xa1, 0x26, 0x45, 0xf0, 0x86, 0x65, 0x63, 0x1e,
	0x5a, 0xc1, 0xaa, 0x09, 0xf4, 0x43, 0x7c, 0x1f, 0x2a, 0xf6, 0xca, 0xec, 0x57, 0x53, 0x36, 0x37,
	0xa6, 0x00, 0xe5, 0x8a, 0x02, 0x8a, 0x06, 0x50, 0xdb, 0x7e, 0x88, 0xe7, 0x00, 0x1a, 0x98, 0xa6,
	0x34, 0x34, 0xce, 0x34, 0xbb, 0x9f, 0x6e, 0x64, 0xbc, 0x48, 0xd9, 0xd7, 0x2a, 0x89, 0xd4, 0x82,
	0x7c, 0x89, 0x2e, 0x54, 0x42, 0x2e, 0xe9, 0xd5, 0xdc, 0x98, 0x55, 0x25, 0xf9, 0x16, 0x1f, 0x03,
	0xa8, 0x64, 0x35, 0x8c, 0x59, 0xe8, 0x96, 0xb5, 0x93, 0x35, 0x15, 0x19, 0xaa, 0x80, 0xea, 0x2a,
	0xa2, 0x37, 0x16, 0xad, 0x68, 0xb4, 0x1a, 0xd1, 0x1b, 0x03, 0x7e, 0x0c, 0xf5, 0xe9, 0x82, 0x49,
	0x69, 0xe1, 0xaa, 0x86, 0x41, 0x87, 0x34, 0x41, 0x8d, 0xf5, 0xb5, 0x49, 0x64, 0x26, 0xdc, 0xd3,
	0xcf, 0x00, 0x56, 0xf3, 0x18, 0xeb, 0x50, 0xf9, 0x6e, 0xf0, 0xcd, 0xe0, 0xdb, 0xd7, 0x83, 0xd6,
	0x0e, 0x02, 0x94, 0x5f, 0x92, 0xfe, 0xe5, 0x19, 0x69, 0x15, 0xf4, 0xfa, 0xec, 0xb2, 0xdf, 0x3b,
	0x6b, 0x15, 0x9f, 0x1e, 0x41, 0x6d, 0xd9, 0x16, 0xbe, 0x03, 0xf5, 0x0b, 0x96, 0x4e, 0x44, 0x1a,
	0xa9, 0xaf, 0xb3, 0xb5, 0x83, 0x4d, 0x80, 0xb3, 0xc9, 0x84, 0x07, 0x9c, 0xc5, 0xc1, 0x6d, 0xcb,
	0xe9, 0xfe, 0x5e, 0x04, 0x38, 0xa5, 0x92, 0x99, 0x2a, 0xf8, 0x6b, 0x5e, 0x4f, 0xbd, 0x22, 0x78,
	0xb2, 0xf9, 0x7b, 0xb1, 0xf6, 0x16, 0xb5, 0x9f, 0x6f, 0x9b, 0x66, 0x9a, 0xf5, 0x76, 0xf0, 0x37,
	0x07, 0xf6, 0xd6, 0x27, 0x3d, 0x7e, 0xb1, 0xd9, 0x2d, 0x3e, 0x78, 0x32, 0xda, 0x2f, 0xb6, 0x4f,
	0x5c, 0x9e, 0xe2, 0x17, 0xa8, 0x2d, 0x6f, 0x02, 0x9f, 0x6d, 0x22, 0x74, 0xff, 0x09, 0x69, 0x9f,
	0x6c, 0x99, 0x95, 0xd7, 0x3e, 0xad, 0xfc, 0xb0, 0xab, 0xc1, 0xab, 0xb2, 0xfe, 0xf9, 0xfc, 0xdf,
	0x00, 0x00, 0x00, 0xff, 0xff, 0xe1, 0xe9, 0x67, 0x7b, 0x58, 0x08, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// BasePluginClient is the client API for BasePlugin service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type BasePluginClient interface {
	// PluginInfo describes the type and version of a plugin.
	PluginInfo(ctx context.Context, in *PluginInfoRequest, opts ...grpc.CallOption) (*PluginInfoResponse, error)
	// ConfigSchema returns the schema for parsing the plugins configuration.
	ConfigSchema(ctx context.Context, in *ConfigSchemaRequest, opts ...grpc.CallOption) (*ConfigSchemaResponse, error)
	// SetConfig is used to set the configuration.
	SetConfig(ctx context.Context, in *SetConfigRequest, opts ...grpc.CallOption) (*SetConfigResponse, error)
}

type basePluginClient struct {
	cc grpc.ClientConnInterface
}

func NewBasePluginClient(cc grpc.ClientConnInterface) BasePluginClient {
	return &basePluginClient{cc}
}

func (c *basePluginClient) PluginInfo(ctx context.Context, in *PluginInfoRequest, opts ...grpc.CallOption) (*PluginInfoResponse, error) {
	out := new(PluginInfoResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.nomad.plugins.base.proto.BasePlugin/PluginInfo", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *basePluginClient) ConfigSchema(ctx context.Context, in *ConfigSchemaRequest, opts ...grpc.CallOption) (*ConfigSchemaResponse, error) {
	out := new(ConfigSchemaResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.nomad.plugins.base.proto.BasePlugin/ConfigSchema", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *basePluginClient) SetConfig(ctx context.Context, in *SetConfigRequest, opts ...grpc.CallOption) (*SetConfigResponse, error) {
	out := new(SetConfigResponse)
	err := c.cc.Invoke(ctx, "/hashicorp.nomad.plugins.base.proto.BasePlugin/SetConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// BasePluginServer is the server API for BasePlugin service.
type BasePluginServer interface {
	// PluginInfo describes the type and version of a plugin.
	PluginInfo(context.Context, *PluginInfoRequest) (*PluginInfoResponse, error)
	// ConfigSchema returns the schema for parsing the plugins configuration.
	ConfigSchema(context.Context, *ConfigSchemaRequest) (*ConfigSchemaResponse, error)
	// SetConfig is used to set the configuration.
	SetConfig(context.Context, *SetConfigRequest) (*SetConfigResponse, error)
}

// UnimplementedBasePluginServer can be embedded to have forward compatible implementations.
type UnimplementedBasePluginServer struct {
}

func (*UnimplementedBasePluginServer) PluginInfo(ctx context.Context, req *PluginInfoRequest) (*PluginInfoResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PluginInfo not implemented")
}
func (*UnimplementedBasePluginServer) ConfigSchema(ctx context.Context, req *ConfigSchemaRequest) (*ConfigSchemaResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ConfigSchema not implemented")
}
func (*UnimplementedBasePluginServer) SetConfig(ctx context.Context, req *SetConfigRequest) (*SetConfigResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetConfig not implemented")
}

func RegisterBasePluginServer(s *grpc.Server, srv BasePluginServer) {
	s.RegisterService(&_BasePlugin_serviceDesc, srv)
}

func _BasePlugin_PluginInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PluginInfoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BasePluginServer).PluginInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.nomad.plugins.base.proto.BasePlugin/PluginInfo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BasePluginServer).PluginInfo(ctx, req.(*PluginInfoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BasePlugin_ConfigSchema_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ConfigSchemaRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BasePluginServer).ConfigSchema(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.nomad.plugins.base.proto.BasePlugin/ConfigSchema",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BasePluginServer).ConfigSchema(ctx, req.(*ConfigSchemaRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BasePlugin_SetConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BasePluginServer).SetConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hashicorp.nomad.plugins.base.proto.BasePlugin/SetConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BasePluginServer).SetConfig(ctx, req.(*SetConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _BasePlugin_serviceDesc = grpc.ServiceDesc{
	ServiceName: "hashicorp.nomad.plugins.base.proto.BasePlugin",
	HandlerType: (*BasePluginServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "PluginInfo",
			Handler:    _BasePlugin_PluginInfo_Handler,
		},
		{
			MethodName: "ConfigSchema",
			Handler:    _BasePlugin_ConfigSchema_Handler,
		},
		{
			MethodName: "SetConfig",
			Handler:    _BasePlugin_SetConfig_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "plugins/base/proto/base.proto",
}
