/**********************************************************************
 *
 *    FILE:            LightPoint.cpp
 *
 *    DESCRIPTION:    Read/Write osgSim::LightPoint in binary format to disk.
 *
 *    CREATED BY:        Auto generated by iveGenerator
 *                    and later modified by Rune Schmidt Jensen.
 *
 *    HISTORY:        Created 5.9.2003
 *
 **********************************************************************/

#include "Exception.h"
#include "LightPoint.h"
#include "BlinkSequence.h"
#include "AzimElevationSector.h"
#include "ElevationSector.h"
#include "AzimSector.h"
#include "ConeSector.h"
#include "DirectionalSector.h"

using namespace ive;

void LightPoint::write(DataOutputStream* out){
    // Write LightPoint's identification.
    out->writeInt(IVELIGHTPOINT);

    // Write LightPoint's properties.
    out->writeBool(_on);
    out->writeVec3(_position);
    out->writeVec4(_color);
    out->writeFloat(_intensity);
    out->writeFloat(_radius);

    // Write out osgSim::sector.
    out->writeBool(_sector.valid());
    if(_sector.valid()){
        if(dynamic_cast<osgSim::AzimElevationSector*>(_sector.get())){
            ((ive::AzimElevationSector*)(_sector.get()))->write(out);
        }
        else if(dynamic_cast<osgSim::ElevationSector*>(_sector.get())){
            ((ive::ElevationSector*)(_sector.get()))->write(out);
        }
        else if(dynamic_cast<osgSim::AzimSector*>(_sector.get())){
            ((ive::AzimSector*)(_sector.get()))->write(out);
        }
        else if(dynamic_cast<osgSim::ConeSector*>(_sector.get())){
            ((ive::ConeSector*)(_sector.get()))->write(out);
        }
        else if(dynamic_cast<osgSim::DirectionalSector*>(_sector.get())){
            ((ive::DirectionalSector*)(_sector.get()))->write(out);
        }
        else
            out_THROW_EXCEPTION("Unknown sector in LightPoint::write()");
    }

    // Write out osgSim::BlinkSequence.
    out->writeBool(_blinkSequence.valid());
    if(_blinkSequence.valid()){
        ((ive::BlinkSequence*)(_blinkSequence.get()))->write(out);
    }

    // Write out blendingMode.
    out->writeInt(_blendingMode);
}

void LightPoint::read(DataInputStream* in){
    // Peek on LightPoint's identification.
    int id = in->peekInt();
    if(id == IVELIGHTPOINT){
        // Read LightPoint's identification.
        id = in->readInt();

        // Read LightPoint's properties
        _on = in->readBool();
        _position = in->readVec3();
        _color = in->readVec4();
        _intensity = in->readFloat();
        _radius = in->readFloat();

        // read in osgSim::sector.
        if(in->readBool()){
            osgSim::Sector* sector;
            int attributeID = in->peekInt();
            if(attributeID == IVEAZIMELEVATIONSECTOR){
                sector = new osgSim::AzimElevationSector();
                ((ive::AzimElevationSector*)(sector))->read(in);
                _sector = sector;
            }
            else if(attributeID == IVEELEVATIONSECTOR){
                sector = new osgSim::ElevationSector();
                ((ive::ElevationSector*)(sector))->read(in);
                _sector = sector;
            }
            else if(attributeID == IVEAZIMSECTOR){
                sector = new osgSim::AzimSector();
                ((ive::AzimSector*)(sector))->read(in);
                _sector = sector;
            }
            else if(attributeID == IVECONESECTOR){
                sector = new osgSim::ConeSector();
                ((ive::ConeSector*)(sector))->read(in);
                _sector = sector;
            }
            else if(attributeID == IVEDIRECTIONALSECTOR){
                sector = new osgSim::DirectionalSector();
                ((ive::DirectionalSector*)(sector))->read(in);
                _sector = sector;
            }
            else
                in_THROW_EXCEPTION("Unknown sector in LightPoint::read()");
        }

        // Read in osgSim::BlinkSequence.
        if(in->readBool()){
            osgSim::BlinkSequence* blinkSequence = new osgSim::BlinkSequence();
            ((ive::BlinkSequence*)(blinkSequence))->read(in);
            _blinkSequence = blinkSequence;
        }

        // Read in blendingMode.
        _blendingMode = (osgSim::LightPoint::BlendingMode)in->readInt();
    }
    else{
        in_THROW_EXCEPTION("LightPoint::read(): Expected LightPoint identification.");
    }
}
