// Code generated by protoc-gen-go.
// source: table_store.proto
// DO NOT EDIT!

package otsprotocol

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

type PrimaryKeyType int32

const (
	PrimaryKeyType_INTEGER PrimaryKeyType = 1
	PrimaryKeyType_STRING  PrimaryKeyType = 2
	PrimaryKeyType_BINARY  PrimaryKeyType = 3
)

var PrimaryKeyType_name = map[int32]string{
	1: "INTEGER",
	2: "STRING",
	3: "BINARY",
}
var PrimaryKeyType_value = map[string]int32{
	"INTEGER": 1,
	"STRING":  2,
	"BINARY":  3,
}

func (x PrimaryKeyType) Enum() *PrimaryKeyType {
	p := new(PrimaryKeyType)
	*p = x
	return p
}
func (x PrimaryKeyType) String() string {
	return proto.EnumName(PrimaryKeyType_name, int32(x))
}
func (x *PrimaryKeyType) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(PrimaryKeyType_value, data, "PrimaryKeyType")
	if err != nil {
		return err
	}
	*x = PrimaryKeyType(value)
	return nil
}
func (PrimaryKeyType) EnumDescriptor() ([]byte, []int) { return fileDescriptor2, []int{0} }

type PrimaryKeyOption int32

const (
	PrimaryKeyOption_AUTO_INCREMENT PrimaryKeyOption = 1
)

var PrimaryKeyOption_name = map[int32]string{
	1: "AUTO_INCREMENT",
}
var PrimaryKeyOption_value = map[string]int32{
	"AUTO_INCREMENT": 1,
}

func (x PrimaryKeyOption) Enum() *PrimaryKeyOption {
	p := new(PrimaryKeyOption)
	*p = x
	return p
}
func (x PrimaryKeyOption) String() string {
	return proto.EnumName(PrimaryKeyOption_name, int32(x))
}
func (x *PrimaryKeyOption) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(PrimaryKeyOption_value, data, "PrimaryKeyOption")
	if err != nil {
		return err
	}
	*x = PrimaryKeyOption(value)
	return nil
}
func (PrimaryKeyOption) EnumDescriptor() ([]byte, []int) { return fileDescriptor2, []int{1} }

type BloomFilterType int32

const (
	BloomFilterType_NONE BloomFilterType = 1
	BloomFilterType_CELL BloomFilterType = 2
	BloomFilterType_ROW  BloomFilterType = 3
)

var BloomFilterType_name = map[int32]string{
	1: "NONE",
	2: "CELL",
	3: "ROW",
}
var BloomFilterType_value = map[string]int32{
	"NONE": 1,
	"CELL": 2,
	"ROW":  3,
}

func (x BloomFilterType) Enum() *BloomFilterType {
	p := new(BloomFilterType)
	*p = x
	return p
}
func (x BloomFilterType) String() string {
	return proto.EnumName(BloomFilterType_name, int32(x))
}
func (x *BloomFilterType) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(BloomFilterType_value, data, "BloomFilterType")
	if err != nil {
		return err
	}
	*x = BloomFilterType(value)
	return nil
}
func (BloomFilterType) EnumDescriptor() ([]byte, []int) { return fileDescriptor2, []int{2} }

// *
// 表的状态变更只与用户的操作对应，内部的机器failover等状况不对应表的状态变更。
// 有三个考虑：
//     一是一般场景下用户只会在做了对表的修改操作后才会去检查表的状态；
//     二是内部机器failover导致访问异常到用户能够查看到表的状态变更这两个时刻之间会有一段延迟，无法将表的不可服务状态与用户查看到的表的状态完全匹配上。
//     三是内部机器failover后不能说是表的整个状态变更，而应该是partition的状态变更，对应表的状态就是PARTIAL_FAILOVER，这个partial的粒度无法体现，会让用户更加困惑。
type TableStatus int32

const (
	TableStatus_ACTIVE    TableStatus = 1
	TableStatus_INACTIVE  TableStatus = 2
	TableStatus_LOADING   TableStatus = 3
	TableStatus_UNLOADING TableStatus = 4
	TableStatus_UPDATING  TableStatus = 5
)

var TableStatus_name = map[int32]string{
	1: "ACTIVE",
	2: "INACTIVE",
	3: "LOADING",
	4: "UNLOADING",
	5: "UPDATING",
}
var TableStatus_value = map[string]int32{
	"ACTIVE":    1,
	"INACTIVE":  2,
	"LOADING":   3,
	"UNLOADING": 4,
	"UPDATING":  5,
}

func (x TableStatus) Enum() *TableStatus {
	p := new(TableStatus)
	*p = x
	return p
}
func (x TableStatus) String() string {
	return proto.EnumName(TableStatus_name, int32(x))
}
func (x *TableStatus) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(TableStatus_value, data, "TableStatus")
	if err != nil {
		return err
	}
	*x = TableStatus(value)
	return nil
}
func (TableStatus) EnumDescriptor() ([]byte, []int) { return fileDescriptor2, []int{3} }

type RowExistenceExpectation int32

const (
	RowExistenceExpectation_IGNORE           RowExistenceExpectation = 0
	RowExistenceExpectation_EXPECT_EXIST     RowExistenceExpectation = 1
	RowExistenceExpectation_EXPECT_NOT_EXIST RowExistenceExpectation = 2
)

var RowExistenceExpectation_name = map[int32]string{
	0: "IGNORE",
	1: "EXPECT_EXIST",
	2: "EXPECT_NOT_EXIST",
}
var RowExistenceExpectation_value = map[string]int32{
	"IGNORE":           0,
	"EXPECT_EXIST":     1,
	"EXPECT_NOT_EXIST": 2,
}

func (x RowExistenceExpectation) Enum() *RowExistenceExpectation {
	p := new(RowExistenceExpectation)
	*p = x
	return p
}
func (x RowExistenceExpectation) String() string {
	return proto.EnumName(RowExistenceExpectation_name, int32(x))
}
func (x *RowExistenceExpectation) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(RowExistenceExpectation_value, data, "RowExistenceExpectation")
	if err != nil {
		return err
	}
	*x = RowExistenceExpectation(value)
	return nil
}
func (RowExistenceExpectation) EnumDescriptor() ([]byte, []int) { return fileDescriptor2, []int{4} }

type ReturnType int32

const (
	ReturnType_RT_NONE         ReturnType = 0
	ReturnType_RT_PK           ReturnType = 1
	ReturnType_RT_AFTER_MODIFY ReturnType = 2
)

var ReturnType_name = map[int32]string{
	0: "RT_NONE",
	1: "RT_PK",
	2: "RT_AFTER_MODIFY",
}
var ReturnType_value = map[string]int32{
	"RT_NONE":         0,
	"RT_PK":           1,
	"RT_AFTER_MODIFY": 2,
}

func (x ReturnType) Enum() *ReturnType {
	p := new(ReturnType)
	*p = x
	return p
}
func (x ReturnType) String() string {
	return proto.EnumName(ReturnType_name, int32(x))
}
func (x *ReturnType) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(ReturnType_value, data, "ReturnType")
	if err != nil {
		return err
	}
	*x = ReturnType(value)
	return nil
}
func (ReturnType) EnumDescriptor() ([]byte, []int) { return fileDescriptor2, []int{5} }

type OperationType int32

const (
	OperationType_PUT    OperationType = 1
	OperationType_UPDATE OperationType = 2
	OperationType_DELETE OperationType = 3
)

var OperationType_name = map[int32]string{
	1: "PUT",
	2: "UPDATE",
	3: "DELETE",
}
var OperationType_value = map[string]int32{
	"PUT":    1,
	"UPDATE": 2,
	"DELETE": 3,
}

func (x OperationType) Enum() *OperationType {
	p := new(OperationType)
	*p = x
	return p
}
func (x OperationType) String() string {
	return proto.EnumName(OperationType_name, int32(x))
}
func (x *OperationType) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(OperationType_value, data, "OperationType")
	if err != nil {
		return err
	}
	*x = OperationType(value)
	return nil
}
func (OperationType) EnumDescriptor() ([]byte, []int) { return fileDescriptor2, []int{6} }

// #############################################  GetRange  #############################################
type Direction int32

const (
	Direction_FORWARD  Direction = 0
	Direction_BACKWARD Direction = 1
)

var Direction_name = map[int32]string{
	0: "FORWARD",
	1: "BACKWARD",
}
var Direction_value = map[string]int32{
	"FORWARD":  0,
	"BACKWARD": 1,
}

func (x Direction) Enum() *Direction {
	p := new(Direction)
	*p = x
	return p
}
func (x Direction) String() string {
	return proto.EnumName(Direction_name, int32(x))
}
func (x *Direction) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Direction_value, data, "Direction")
	if err != nil {
		return err
	}
	*x = Direction(value)
	return nil
}
func (Direction) EnumDescriptor() ([]byte, []int) { return fileDescriptor2, []int{7} }

type StreamStatus int32

const (
	StreamStatus_STREAM_ENABLING StreamStatus = 1
	StreamStatus_STREAM_ACTIVE   StreamStatus = 2
)

var StreamStatus_name = map[int32]string{
	1: "STREAM_ENABLING",
	2: "STREAM_ACTIVE",
}
var StreamStatus_value = map[string]int32{
	"STREAM_ENABLING": 1,
	"STREAM_ACTIVE":   2,
}

func (x StreamStatus) Enum() *StreamStatus {
	p := new(StreamStatus)
	*p = x
	return p
}
func (x StreamStatus) String() string {
	return proto.EnumName(StreamStatus_name, int32(x))
}
func (x *StreamStatus) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(StreamStatus_value, data, "StreamStatus")
	if err != nil {
		return err
	}
	*x = StreamStatus(value)
	return nil
}
func (StreamStatus) EnumDescriptor() ([]byte, []int) { return fileDescriptor2, []int{8} }

type ActionType int32

const (
	ActionType_PUT_ROW    ActionType = 1
	ActionType_UPDATE_ROW ActionType = 2
	ActionType_DELETE_ROW ActionType = 3
)

var ActionType_name = map[int32]string{
	1: "PUT_ROW",
	2: "UPDATE_ROW",
	3: "DELETE_ROW",
}
var ActionType_value = map[string]int32{
	"PUT_ROW":    1,
	"UPDATE_ROW": 2,
	"DELETE_ROW": 3,
}

func (x ActionType) Enum() *ActionType {
	p := new(ActionType)
	*p = x
	return p
}
func (x ActionType) String() string {
	return proto.EnumName(ActionType_name, int32(x))
}
func (x *ActionType) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(ActionType_value, data, "ActionType")
	if err != nil {
		return err
	}
	*x = ActionType(value)
	return nil
}
func (ActionType) EnumDescriptor() ([]byte, []int) { return fileDescriptor2, []int{9} }

type DefinedColumnType int32

const (
	DefinedColumnType_DCT_INTEGER DefinedColumnType = 1
	DefinedColumnType_DCT_DOUBLE  DefinedColumnType = 2
	DefinedColumnType_DCT_BOOLEAN DefinedColumnType = 3
	DefinedColumnType_DCT_STRING  DefinedColumnType = 4
	// field 5 is reserved for date type, not supported yet
	// field 6 is reserved for decimal type, not supported yet
	DefinedColumnType_DCT_BLOB DefinedColumnType = 7
)

var DefinedColumnType_name = map[int32]string{
	1: "DCT_INTEGER",
	2: "DCT_DOUBLE",
	3: "DCT_BOOLEAN",
	4: "DCT_STRING",
	7: "DCT_BLOB",
}
var DefinedColumnType_value = map[string]int32{
	"DCT_INTEGER": 1,
	"DCT_DOUBLE":  2,
	"DCT_BOOLEAN": 3,
	"DCT_STRING":  4,
	"DCT_BLOB":    7,
}

func (x DefinedColumnType) Enum() *DefinedColumnType {
	p := new(DefinedColumnType)
	*p = x
	return p
}
func (x DefinedColumnType) String() string {
	return proto.EnumName(DefinedColumnType_name, int32(x))
}
func (x *DefinedColumnType) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(DefinedColumnType_value, data, "DefinedColumnType")
	if err != nil {
		return err
	}
	*x = DefinedColumnType(value)
	return nil
}
func (DefinedColumnType) EnumDescriptor() ([]byte, []int) { return fileDescriptor2, []int{10} }

type IndexUpdateMode int32

const (
	IndexUpdateMode_IUM_ASYNC_INDEX IndexUpdateMode = 0
	IndexUpdateMode_IUM_SYNC_INDEX  IndexUpdateMode = 1
)

var IndexUpdateMode_name = map[int32]string{
	0: "IUM_ASYNC_INDEX",
	1: "IUM_SYNC_INDEX",
}
var IndexUpdateMode_value = map[string]int32{
	"IUM_ASYNC_INDEX": 0,
	"IUM_SYNC_INDEX":  1,
}

func (x IndexUpdateMode) Enum() *IndexUpdateMode {
	p := new(IndexUpdateMode)
	*p = x
	return p
}
func (x IndexUpdateMode) String() string {
	return proto.EnumName(IndexUpdateMode_name, int32(x))
}
func (x *IndexUpdateMode) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(IndexUpdateMode_value, data, "IndexUpdateMode")
	if err != nil {
		return err
	}
	*x = IndexUpdateMode(value)
	return nil
}
func (IndexUpdateMode) EnumDescriptor() ([]byte, []int) { return fileDescriptor2, []int{11} }

type IndexType int32

const (
	IndexType_IT_GLOBAL_INDEX IndexType = 0
	IndexType_IT_LOCAL_INDEX  IndexType = 1
)

var IndexType_name = map[int32]string{
	0: "IT_GLOBAL_INDEX",
	1: "IT_LOCAL_INDEX",
}
var IndexType_value = map[string]int32{
	"IT_GLOBAL_INDEX": 0,
	"IT_LOCAL_INDEX":  1,
}

func (x IndexType) Enum() *IndexType {
	p := new(IndexType)
	*p = x
	return p
}
func (x IndexType) String() string {
	return proto.EnumName(IndexType_name, int32(x))
}
func (x *IndexType) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(IndexType_value, data, "IndexType")
	if err != nil {
		return err
	}
	*x = IndexType(value)
	return nil
}
func (IndexType) EnumDescriptor() ([]byte, []int) { return fileDescriptor2, []int{12} }

type Error struct {
	Code             *string `protobuf:"bytes,1,req,name=code" json:"code,omitempty"`
	Message          *string `protobuf:"bytes,2,opt,name=message" json:"message,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *Error) Reset()                    { *m = Error{} }
func (m *Error) String() string            { return proto.CompactTextString(m) }
func (*Error) ProtoMessage()               {}
func (*Error) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{0} }

func (m *Error) GetCode() string {
	if m != nil && m.Code != nil {
		return *m.Code
	}
	return ""
}

func (m *Error) GetMessage() string {
	if m != nil && m.Message != nil {
		return *m.Message
	}
	return ""
}

type PrimaryKeySchema struct {
	Name             *string           `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Type             *PrimaryKeyType   `protobuf:"varint,2,req,name=type,enum=otsprotocol.PrimaryKeyType" json:"type,omitempty"`
	Option           *PrimaryKeyOption `protobuf:"varint,3,opt,name=option,enum=otsprotocol.PrimaryKeyOption" json:"option,omitempty"`
	XXX_unrecognized []byte            `json:"-"`
}

func (m *PrimaryKeySchema) Reset()                    { *m = PrimaryKeySchema{} }
func (m *PrimaryKeySchema) String() string            { return proto.CompactTextString(m) }
func (*PrimaryKeySchema) ProtoMessage()               {}
func (*PrimaryKeySchema) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{1} }

func (m *PrimaryKeySchema) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *PrimaryKeySchema) GetType() PrimaryKeyType {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return PrimaryKeyType_INTEGER
}

func (m *PrimaryKeySchema) GetOption() PrimaryKeyOption {
	if m != nil && m.Option != nil {
		return *m.Option
	}
	return PrimaryKeyOption_AUTO_INCREMENT
}

type PartitionRange struct {
	Begin            []byte `protobuf:"bytes,1,req,name=begin" json:"begin,omitempty"`
	End              []byte `protobuf:"bytes,2,req,name=end" json:"end,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *PartitionRange) Reset()                    { *m = PartitionRange{} }
func (m *PartitionRange) String() string            { return proto.CompactTextString(m) }
func (*PartitionRange) ProtoMessage()               {}
func (*PartitionRange) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{2} }

func (m *PartitionRange) GetBegin() []byte {
	if m != nil {
		return m.Begin
	}
	return nil
}

func (m *PartitionRange) GetEnd() []byte {
	if m != nil {
		return m.End
	}
	return nil
}

type TableOptions struct {
	TimeToLive                *int32           `protobuf:"varint,1,opt,name=time_to_live" json:"time_to_live,omitempty"`
	MaxVersions               *int32           `protobuf:"varint,2,opt,name=max_versions" json:"max_versions,omitempty"`
	BloomFilterType           *BloomFilterType `protobuf:"varint,3,opt,name=bloom_filter_type,enum=otsprotocol.BloomFilterType" json:"bloom_filter_type,omitempty"`
	BlockSize                 *int32           `protobuf:"varint,4,opt,name=block_size" json:"block_size,omitempty"`
	DeviationCellVersionInSec *int64           `protobuf:"varint,5,opt,name=deviation_cell_version_in_sec" json:"deviation_cell_version_in_sec,omitempty"`
	XXX_unrecognized          []byte           `json:"-"`
}

func (m *TableOptions) Reset()                    { *m = TableOptions{} }
func (m *TableOptions) String() string            { return proto.CompactTextString(m) }
func (*TableOptions) ProtoMessage()               {}
func (*TableOptions) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{3} }

func (m *TableOptions) GetTimeToLive() int32 {
	if m != nil && m.TimeToLive != nil {
		return *m.TimeToLive
	}
	return 0
}

func (m *TableOptions) GetMaxVersions() int32 {
	if m != nil && m.MaxVersions != nil {
		return *m.MaxVersions
	}
	return 0
}

func (m *TableOptions) GetBloomFilterType() BloomFilterType {
	if m != nil && m.BloomFilterType != nil {
		return *m.BloomFilterType
	}
	return BloomFilterType_NONE
}

func (m *TableOptions) GetBlockSize() int32 {
	if m != nil && m.BlockSize != nil {
		return *m.BlockSize
	}
	return 0
}

func (m *TableOptions) GetDeviationCellVersionInSec() int64 {
	if m != nil && m.DeviationCellVersionInSec != nil {
		return *m.DeviationCellVersionInSec
	}
	return 0
}

type TableMeta struct {
	TableName        *string                `protobuf:"bytes,1,req,name=table_name" json:"table_name,omitempty"`
	PrimaryKey       []*PrimaryKeySchema    `protobuf:"bytes,2,rep,name=primary_key" json:"primary_key,omitempty"`
	DefinedColumn    []*DefinedColumnSchema `protobuf:"bytes,3,rep,name=defined_column" json:"defined_column,omitempty"`
	IndexMeta        []*IndexMeta           `protobuf:"bytes,4,rep,name=index_meta" json:"index_meta,omitempty"`
	XXX_unrecognized []byte                 `json:"-"`
}

func (m *TableMeta) Reset()                    { *m = TableMeta{} }
func (m *TableMeta) String() string            { return proto.CompactTextString(m) }
func (*TableMeta) ProtoMessage()               {}
func (*TableMeta) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{4} }

func (m *TableMeta) GetTableName() string {
	if m != nil && m.TableName != nil {
		return *m.TableName
	}
	return ""
}

func (m *TableMeta) GetPrimaryKey() []*PrimaryKeySchema {
	if m != nil {
		return m.PrimaryKey
	}
	return nil
}

func (m *TableMeta) GetDefinedColumn() []*DefinedColumnSchema {
	if m != nil {
		return m.DefinedColumn
	}
	return nil
}

func (m *TableMeta) GetIndexMeta() []*IndexMeta {
	if m != nil {
		return m.IndexMeta
	}
	return nil
}

type Condition struct {
	RowExistence     *RowExistenceExpectation `protobuf:"varint,1,req,name=row_existence,enum=otsprotocol.RowExistenceExpectation" json:"row_existence,omitempty"`
	ColumnCondition  []byte                   `protobuf:"bytes,2,opt,name=column_condition" json:"column_condition,omitempty"`
	XXX_unrecognized []byte                   `json:"-"`
}

func (m *Condition) Reset()                    { *m = Condition{} }
func (m *Condition) String() string            { return proto.CompactTextString(m) }
func (*Condition) ProtoMessage()               {}
func (*Condition) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{5} }

func (m *Condition) GetRowExistence() RowExistenceExpectation {
	if m != nil && m.RowExistence != nil {
		return *m.RowExistence
	}
	return RowExistenceExpectation_IGNORE
}

func (m *Condition) GetColumnCondition() []byte {
	if m != nil {
		return m.ColumnCondition
	}
	return nil
}

type CapacityUnit struct {
	Read             *int32 `protobuf:"varint,1,opt,name=read" json:"read,omitempty"`
	Write            *int32 `protobuf:"varint,2,opt,name=write" json:"write,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *CapacityUnit) Reset()                    { *m = CapacityUnit{} }
func (m *CapacityUnit) String() string            { return proto.CompactTextString(m) }
func (*CapacityUnit) ProtoMessage()               {}
func (*CapacityUnit) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{6} }

func (m *CapacityUnit) GetRead() int32 {
	if m != nil && m.Read != nil {
		return *m.Read
	}
	return 0
}

func (m *CapacityUnit) GetWrite() int32 {
	if m != nil && m.Write != nil {
		return *m.Write
	}
	return 0
}

type ReservedThroughputDetails struct {
	CapacityUnit     *CapacityUnit `protobuf:"bytes,1,req,name=capacity_unit" json:"capacity_unit,omitempty"`
	LastIncreaseTime *int64        `protobuf:"varint,2,req,name=last_increase_time" json:"last_increase_time,omitempty"`
	LastDecreaseTime *int64        `protobuf:"varint,3,opt,name=last_decrease_time" json:"last_decrease_time,omitempty"`
	XXX_unrecognized []byte        `json:"-"`
}

func (m *ReservedThroughputDetails) Reset()                    { *m = ReservedThroughputDetails{} }
func (m *ReservedThroughputDetails) String() string            { return proto.CompactTextString(m) }
func (*ReservedThroughputDetails) ProtoMessage()               {}
func (*ReservedThroughputDetails) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{7} }

func (m *ReservedThroughputDetails) GetCapacityUnit() *CapacityUnit {
	if m != nil {
		return m.CapacityUnit
	}
	return nil
}

func (m *ReservedThroughputDetails) GetLastIncreaseTime() int64 {
	if m != nil && m.LastIncreaseTime != nil {
		return *m.LastIncreaseTime
	}
	return 0
}

func (m *ReservedThroughputDetails) GetLastDecreaseTime() int64 {
	if m != nil && m.LastDecreaseTime != nil {
		return *m.LastDecreaseTime
	}
	return 0
}

type ReservedThroughput struct {
	CapacityUnit     *CapacityUnit `protobuf:"bytes,1,req,name=capacity_unit" json:"capacity_unit,omitempty"`
	XXX_unrecognized []byte        `json:"-"`
}

func (m *ReservedThroughput) Reset()                    { *m = ReservedThroughput{} }
func (m *ReservedThroughput) String() string            { return proto.CompactTextString(m) }
func (*ReservedThroughput) ProtoMessage()               {}
func (*ReservedThroughput) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{8} }

func (m *ReservedThroughput) GetCapacityUnit() *CapacityUnit {
	if m != nil {
		return m.CapacityUnit
	}
	return nil
}

type ConsumedCapacity struct {
	CapacityUnit     *CapacityUnit `protobuf:"bytes,1,req,name=capacity_unit" json:"capacity_unit,omitempty"`
	XXX_unrecognized []byte        `json:"-"`
}

func (m *ConsumedCapacity) Reset()                    { *m = ConsumedCapacity{} }
func (m *ConsumedCapacity) String() string            { return proto.CompactTextString(m) }
func (*ConsumedCapacity) ProtoMessage()               {}
func (*ConsumedCapacity) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{9} }

func (m *ConsumedCapacity) GetCapacityUnit() *CapacityUnit {
	if m != nil {
		return m.CapacityUnit
	}
	return nil
}

type StreamSpecification struct {
	EnableStream     *bool  `protobuf:"varint,1,req,name=enable_stream" json:"enable_stream,omitempty"`
	ExpirationTime   *int32 `protobuf:"varint,2,opt,name=expiration_time" json:"expiration_time,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *StreamSpecification) Reset()                    { *m = StreamSpecification{} }
func (m *StreamSpecification) String() string            { return proto.CompactTextString(m) }
func (*StreamSpecification) ProtoMessage()               {}
func (*StreamSpecification) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{10} }

func (m *StreamSpecification) GetEnableStream() bool {
	if m != nil && m.EnableStream != nil {
		return *m.EnableStream
	}
	return false
}

func (m *StreamSpecification) GetExpirationTime() int32 {
	if m != nil && m.ExpirationTime != nil {
		return *m.ExpirationTime
	}
	return 0
}

type StreamDetails struct {
	EnableStream     *bool   `protobuf:"varint,1,req,name=enable_stream" json:"enable_stream,omitempty"`
	StreamId         *string `protobuf:"bytes,2,opt,name=stream_id" json:"stream_id,omitempty"`
	ExpirationTime   *int32  `protobuf:"varint,3,opt,name=expiration_time" json:"expiration_time,omitempty"`
	LastEnableTime   *int64  `protobuf:"varint,4,opt,name=last_enable_time" json:"last_enable_time,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *StreamDetails) Reset()                    { *m = StreamDetails{} }
func (m *StreamDetails) String() string            { return proto.CompactTextString(m) }
func (*StreamDetails) ProtoMessage()               {}
func (*StreamDetails) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{11} }

func (m *StreamDetails) GetEnableStream() bool {
	if m != nil && m.EnableStream != nil {
		return *m.EnableStream
	}
	return false
}

func (m *StreamDetails) GetStreamId() string {
	if m != nil && m.StreamId != nil {
		return *m.StreamId
	}
	return ""
}

func (m *StreamDetails) GetExpirationTime() int32 {
	if m != nil && m.ExpirationTime != nil {
		return *m.ExpirationTime
	}
	return 0
}

func (m *StreamDetails) GetLastEnableTime() int64 {
	if m != nil && m.LastEnableTime != nil {
		return *m.LastEnableTime
	}
	return 0
}

// *
// table_meta用于存储表中不可更改的schema属性，可以更改的ReservedThroughput和TableOptions独立出来，作为UpdateTable的参数。
// 加入GlobalIndex和LocalIndex之后，结构会变为：
// message CreateTableRequest {
//         required TableMeta table_meta = 1;
//         required ReservedThroughput reserved_throughput = 2;
//         required TableOptions table_options = 3;
//         repeated LocalIndex local_indexes = 4; // LocalIndex不再单独包含ReservedThroughput和TableOptions，其与主表共享配置。
//         repeated GlobalIndex global_indexes = 5; // GlobalIndex内单独包含ReservedThroughput和TableOptions
// }
type CreateTableRequest struct {
	TableMeta          *TableMeta           `protobuf:"bytes,1,req,name=table_meta" json:"table_meta,omitempty"`
	ReservedThroughput *ReservedThroughput  `protobuf:"bytes,2,req,name=reserved_throughput" json:"reserved_throughput,omitempty"`
	TableOptions       *TableOptions        `protobuf:"bytes,3,opt,name=table_options" json:"table_options,omitempty"`
	Partitions         []*PartitionRange    `protobuf:"bytes,4,rep,name=partitions" json:"partitions,omitempty"`
	StreamSpec         *StreamSpecification `protobuf:"bytes,5,opt,name=stream_spec" json:"stream_spec,omitempty"`
	IndexMetas         []*IndexMeta         `protobuf:"bytes,7,rep,name=index_metas" json:"index_metas,omitempty"`
	XXX_unrecognized   []byte               `json:"-"`
}

func (m *CreateTableRequest) Reset()                    { *m = CreateTableRequest{} }
func (m *CreateTableRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateTableRequest) ProtoMessage()               {}
func (*CreateTableRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{12} }

func (m *CreateTableRequest) GetTableMeta() *TableMeta {
	if m != nil {
		return m.TableMeta
	}
	return nil
}

func (m *CreateTableRequest) GetReservedThroughput() *ReservedThroughput {
	if m != nil {
		return m.ReservedThroughput
	}
	return nil
}

func (m *CreateTableRequest) GetTableOptions() *TableOptions {
	if m != nil {
		return m.TableOptions
	}
	return nil
}

func (m *CreateTableRequest) GetPartitions() []*PartitionRange {
	if m != nil {
		return m.Partitions
	}
	return nil
}

func (m *CreateTableRequest) GetStreamSpec() *StreamSpecification {
	if m != nil {
		return m.StreamSpec
	}
	return nil
}

func (m *CreateTableRequest) GetIndexMetas() []*IndexMeta {
	if m != nil {
		return m.IndexMetas
	}
	return nil
}

type CreateTableResponse struct {
	XXX_unrecognized []byte `json:"-"`
}

func (m *CreateTableResponse) Reset()                    { *m = CreateTableResponse{} }
func (m *CreateTableResponse) String() string            { return proto.CompactTextString(m) }
func (*CreateTableResponse) ProtoMessage()               {}
func (*CreateTableResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{13} }

// #############################################  UpdateTable  #############################################
type UpdateTableRequest struct {
	TableName          *string              `protobuf:"bytes,1,req,name=table_name" json:"table_name,omitempty"`
	ReservedThroughput *ReservedThroughput  `protobuf:"bytes,2,opt,name=reserved_throughput" json:"reserved_throughput,omitempty"`
	TableOptions       *TableOptions        `protobuf:"bytes,3,opt,name=table_options" json:"table_options,omitempty"`
	StreamSpec         *StreamSpecification `protobuf:"bytes,4,opt,name=stream_spec" json:"stream_spec,omitempty"`
	XXX_unrecognized   []byte               `json:"-"`
}

func (m *UpdateTableRequest) Reset()                    { *m = UpdateTableRequest{} }
func (m *UpdateTableRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateTableRequest) ProtoMessage()               {}
func (*UpdateTableRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{14} }

func (m *UpdateTableRequest) GetTableName() string {
	if m != nil && m.TableName != nil {
		return *m.TableName
	}
	return ""
}

func (m *UpdateTableRequest) GetReservedThroughput() *ReservedThroughput {
	if m != nil {
		return m.ReservedThroughput
	}
	return nil
}

func (m *UpdateTableRequest) GetTableOptions() *TableOptions {
	if m != nil {
		return m.TableOptions
	}
	return nil
}

func (m *UpdateTableRequest) GetStreamSpec() *StreamSpecification {
	if m != nil {
		return m.StreamSpec
	}
	return nil
}

type UpdateTableResponse struct {
	ReservedThroughputDetails *ReservedThroughputDetails `protobuf:"bytes,1,req,name=reserved_throughput_details" json:"reserved_throughput_details,omitempty"`
	TableOptions              *TableOptions              `protobuf:"bytes,2,req,name=table_options" json:"table_options,omitempty"`
	StreamDetails             *StreamDetails             `protobuf:"bytes,3,opt,name=stream_details" json:"stream_details,omitempty"`
	XXX_unrecognized          []byte                     `json:"-"`
}

func (m *UpdateTableResponse) Reset()                    { *m = UpdateTableResponse{} }
func (m *UpdateTableResponse) String() string            { return proto.CompactTextString(m) }
func (*UpdateTableResponse) ProtoMessage()               {}
func (*UpdateTableResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{15} }

func (m *UpdateTableResponse) GetReservedThroughputDetails() *ReservedThroughputDetails {
	if m != nil {
		return m.ReservedThroughputDetails
	}
	return nil
}

func (m *UpdateTableResponse) GetTableOptions() *TableOptions {
	if m != nil {
		return m.TableOptions
	}
	return nil
}

func (m *UpdateTableResponse) GetStreamDetails() *StreamDetails {
	if m != nil {
		return m.StreamDetails
	}
	return nil
}

// #############################################  DescribeTable  #############################################
type DescribeTableRequest struct {
	TableName        *string `protobuf:"bytes,1,req,name=table_name" json:"table_name,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *DescribeTableRequest) Reset()                    { *m = DescribeTableRequest{} }
func (m *DescribeTableRequest) String() string            { return proto.CompactTextString(m) }
func (*DescribeTableRequest) ProtoMessage()               {}
func (*DescribeTableRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{16} }

func (m *DescribeTableRequest) GetTableName() string {
	if m != nil && m.TableName != nil {
		return *m.TableName
	}
	return ""
}

type DescribeTableResponse struct {
	TableMeta                 *TableMeta                 `protobuf:"bytes,1,req,name=table_meta" json:"table_meta,omitempty"`
	ReservedThroughputDetails *ReservedThroughputDetails `protobuf:"bytes,2,req,name=reserved_throughput_details" json:"reserved_throughput_details,omitempty"`
	TableOptions              *TableOptions              `protobuf:"bytes,3,req,name=table_options" json:"table_options,omitempty"`
	TableStatus               *TableStatus               `protobuf:"varint,4,req,name=table_status,enum=otsprotocol.TableStatus" json:"table_status,omitempty"`
	StreamDetails             *StreamDetails             `protobuf:"bytes,5,opt,name=stream_details" json:"stream_details,omitempty"`
	ShardSplits               [][]byte                   `protobuf:"bytes,6,rep,name=shard_splits" json:"shard_splits,omitempty"`
	IndexMetas                []*IndexMeta               `protobuf:"bytes,8,rep,name=index_metas" json:"index_metas,omitempty"`
	XXX_unrecognized          []byte                     `json:"-"`
}

func (m *DescribeTableResponse) Reset()                    { *m = DescribeTableResponse{} }
func (m *DescribeTableResponse) String() string            { return proto.CompactTextString(m) }
func (*DescribeTableResponse) ProtoMessage()               {}
func (*DescribeTableResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{17} }

func (m *DescribeTableResponse) GetTableMeta() *TableMeta {
	if m != nil {
		return m.TableMeta
	}
	return nil
}

func (m *DescribeTableResponse) GetReservedThroughputDetails() *ReservedThroughputDetails {
	if m != nil {
		return m.ReservedThroughputDetails
	}
	return nil
}

func (m *DescribeTableResponse) GetTableOptions() *TableOptions {
	if m != nil {
		return m.TableOptions
	}
	return nil
}

func (m *DescribeTableResponse) GetTableStatus() TableStatus {
	if m != nil && m.TableStatus != nil {
		return *m.TableStatus
	}
	return TableStatus_ACTIVE
}

func (m *DescribeTableResponse) GetStreamDetails() *StreamDetails {
	if m != nil {
		return m.StreamDetails
	}
	return nil
}

func (m *DescribeTableResponse) GetShardSplits() [][]byte {
	if m != nil {
		return m.ShardSplits
	}
	return nil
}

func (m *DescribeTableResponse) GetIndexMetas() []*IndexMeta {
	if m != nil {
		return m.IndexMetas
	}
	return nil
}

// #############################################  ListTable  #############################################
type ListTableRequest struct {
	XXX_unrecognized []byte `json:"-"`
}

func (m *ListTableRequest) Reset()                    { *m = ListTableRequest{} }
func (m *ListTableRequest) String() string            { return proto.CompactTextString(m) }
func (*ListTableRequest) ProtoMessage()               {}
func (*ListTableRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{18} }

// *
// 当前只返回一个简单的名称列表，需要讨论是否有业务场景需要获取除了表名之外的其他信息。
// 其他信息可以包含预留吞吐量以及表的状态，这个信息只能是一个粗略的信息，表的详细信息还是需要通过DescribeTable来获取。
type ListTableResponse struct {
	TableNames       []string `protobuf:"bytes,1,rep,name=table_names" json:"table_names,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *ListTableResponse) Reset()                    { *m = ListTableResponse{} }
func (m *ListTableResponse) String() string            { return proto.CompactTextString(m) }
func (*ListTableResponse) ProtoMessage()               {}
func (*ListTableResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{19} }

func (m *ListTableResponse) GetTableNames() []string {
	if m != nil {
		return m.TableNames
	}
	return nil
}

// #############################################  DeleteTable  #############################################
type DeleteTableRequest struct {
	TableName        *string `protobuf:"bytes,1,req,name=table_name" json:"table_name,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *DeleteTableRequest) Reset()                    { *m = DeleteTableRequest{} }
func (m *DeleteTableRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteTableRequest) ProtoMessage()               {}
func (*DeleteTableRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{20} }

func (m *DeleteTableRequest) GetTableName() string {
	if m != nil && m.TableName != nil {
		return *m.TableName
	}
	return ""
}

type DeleteTableResponse struct {
	XXX_unrecognized []byte `json:"-"`
}

func (m *DeleteTableResponse) Reset()                    { *m = DeleteTableResponse{} }
func (m *DeleteTableResponse) String() string            { return proto.CompactTextString(m) }
func (*DeleteTableResponse) ProtoMessage()               {}
func (*DeleteTableResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{21} }

// #############################################  LoadTable  #############################################
type LoadTableRequest struct {
	TableName        *string `protobuf:"bytes,1,req,name=table_name" json:"table_name,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *LoadTableRequest) Reset()                    { *m = LoadTableRequest{} }
func (m *LoadTableRequest) String() string            { return proto.CompactTextString(m) }
func (*LoadTableRequest) ProtoMessage()               {}
func (*LoadTableRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{22} }

func (m *LoadTableRequest) GetTableName() string {
	if m != nil && m.TableName != nil {
		return *m.TableName
	}
	return ""
}

type LoadTableResponse struct {
	XXX_unrecognized []byte `json:"-"`
}

func (m *LoadTableResponse) Reset()                    { *m = LoadTableResponse{} }
func (m *LoadTableResponse) String() string            { return proto.CompactTextString(m) }
func (*LoadTableResponse) ProtoMessage()               {}
func (*LoadTableResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{23} }

// #############################################  UnloadTable  #############################################
type UnloadTableRequest struct {
	TableName        *string `protobuf:"bytes,1,req,name=table_name" json:"table_name,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *UnloadTableRequest) Reset()                    { *m = UnloadTableRequest{} }
func (m *UnloadTableRequest) String() string            { return proto.CompactTextString(m) }
func (*UnloadTableRequest) ProtoMessage()               {}
func (*UnloadTableRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{24} }

func (m *UnloadTableRequest) GetTableName() string {
	if m != nil && m.TableName != nil {
		return *m.TableName
	}
	return ""
}

type UnloadTableResponse struct {
	XXX_unrecognized []byte `json:"-"`
}

func (m *UnloadTableResponse) Reset()                    { *m = UnloadTableResponse{} }
func (m *UnloadTableResponse) String() string            { return proto.CompactTextString(m) }
func (*UnloadTableResponse) ProtoMessage()               {}
func (*UnloadTableResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{25} }

// *
// 时间戳的取值最小值为0，最大值为INT64.MAX
// 1. 若要查询一个范围，则指定start_time和end_time
// 2. 若要查询一个特定时间戳，则指定specific_time
type TimeRange struct {
	StartTime        *int64 `protobuf:"varint,1,opt,name=start_time" json:"start_time,omitempty"`
	EndTime          *int64 `protobuf:"varint,2,opt,name=end_time" json:"end_time,omitempty"`
	SpecificTime     *int64 `protobuf:"varint,3,opt,name=specific_time" json:"specific_time,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *TimeRange) Reset()                    { *m = TimeRange{} }
func (m *TimeRange) String() string            { return proto.CompactTextString(m) }
func (*TimeRange) ProtoMessage()               {}
func (*TimeRange) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{26} }

func (m *TimeRange) GetStartTime() int64 {
	if m != nil && m.StartTime != nil {
		return *m.StartTime
	}
	return 0
}

func (m *TimeRange) GetEndTime() int64 {
	if m != nil && m.EndTime != nil {
		return *m.EndTime
	}
	return 0
}

func (m *TimeRange) GetSpecificTime() int64 {
	if m != nil && m.SpecificTime != nil {
		return *m.SpecificTime
	}
	return 0
}

type ReturnContent struct {
	ReturnType        *ReturnType `protobuf:"varint,1,opt,name=return_type,enum=otsprotocol.ReturnType" json:"return_type,omitempty"`
	ReturnColumnNames []string    `protobuf:"bytes,2,rep,name=return_column_names" json:"return_column_names,omitempty"`
	XXX_unrecognized  []byte      `json:"-"`
}

func (m *ReturnContent) Reset()                    { *m = ReturnContent{} }
func (m *ReturnContent) String() string            { return proto.CompactTextString(m) }
func (*ReturnContent) ProtoMessage()               {}
func (*ReturnContent) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{27} }

func (m *ReturnContent) GetReturnType() ReturnType {
	if m != nil && m.ReturnType != nil {
		return *m.ReturnType
	}
	return ReturnType_RT_NONE
}

func (m *ReturnContent) GetReturnColumnNames() []string {
	if m != nil {
		return m.ReturnColumnNames
	}
	return nil
}

// *
// 1. 支持用户指定版本时间戳范围或者特定的版本时间来读取指定版本的列
// 2. 目前暂不支持行内的断点
type GetRowRequest struct {
	TableName        *string    `protobuf:"bytes,1,req,name=table_name" json:"table_name,omitempty"`
	PrimaryKey       []byte     `protobuf:"bytes,2,req,name=primary_key" json:"primary_key,omitempty"`
	ColumnsToGet     []string   `protobuf:"bytes,3,rep,name=columns_to_get" json:"columns_to_get,omitempty"`
	TimeRange        *TimeRange `protobuf:"bytes,4,opt,name=time_range" json:"time_range,omitempty"`
	MaxVersions      *int32     `protobuf:"varint,5,opt,name=max_versions" json:"max_versions,omitempty"`
	CacheBlocks      *bool      `protobuf:"varint,6,opt,name=cache_blocks,def=1" json:"cache_blocks,omitempty"`
	Filter           []byte     `protobuf:"bytes,7,opt,name=filter" json:"filter,omitempty"`
	StartColumn      *string    `protobuf:"bytes,8,opt,name=start_column" json:"start_column,omitempty"`
	EndColumn        *string    `protobuf:"bytes,9,opt,name=end_column" json:"end_column,omitempty"`
	Token            []byte     `protobuf:"bytes,10,opt,name=token" json:"token,omitempty"`
	TransactionId    *string    `protobuf:"bytes,11,opt,name=transaction_id" json:"transaction_id,omitempty"`
	XXX_unrecognized []byte     `json:"-"`
}

func (m *GetRowRequest) Reset()                    { *m = GetRowRequest{} }
func (m *GetRowRequest) String() string            { return proto.CompactTextString(m) }
func (*GetRowRequest) ProtoMessage()               {}
func (*GetRowRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{28} }

const Default_GetRowRequest_CacheBlocks bool = true

func (m *GetRowRequest) GetTableName() string {
	if m != nil && m.TableName != nil {
		return *m.TableName
	}
	return ""
}

func (m *GetRowRequest) GetPrimaryKey() []byte {
	if m != nil {
		return m.PrimaryKey
	}
	return nil
}

func (m *GetRowRequest) GetColumnsToGet() []string {
	if m != nil {
		return m.ColumnsToGet
	}
	return nil
}

func (m *GetRowRequest) GetTimeRange() *TimeRange {
	if m != nil {
		return m.TimeRange
	}
	return nil
}

func (m *GetRowRequest) GetMaxVersions() int32 {
	if m != nil && m.MaxVersions != nil {
		return *m.MaxVersions
	}
	return 0
}

func (m *GetRowRequest) GetCacheBlocks() bool {
	if m != nil && m.CacheBlocks != nil {
		return *m.CacheBlocks
	}
	return Default_GetRowRequest_CacheBlocks
}

func (m *GetRowRequest) GetFilter() []byte {
	if m != nil {
		return m.Filter
	}
	return nil
}

func (m *GetRowRequest) GetStartColumn() string {
	if m != nil && m.StartColumn != nil {
		return *m.StartColumn
	}
	return ""
}

func (m *GetRowRequest) GetEndColumn() string {
	if m != nil && m.EndColumn != nil {
		return *m.EndColumn
	}
	return ""
}

func (m *GetRowRequest) GetToken() []byte {
	if m != nil {
		return m.Token
	}
	return nil
}

func (m *GetRowRequest) GetTransactionId() string {
	if m != nil && m.TransactionId != nil {
		return *m.TransactionId
	}
	return ""
}

type GetRowResponse struct {
	Consumed         *ConsumedCapacity `protobuf:"bytes,1,req,name=consumed" json:"consumed,omitempty"`
	Row              []byte            `protobuf:"bytes,2,req,name=row" json:"row,omitempty"`
	NextToken        []byte            `protobuf:"bytes,3,opt,name=next_token" json:"next_token,omitempty"`
	XXX_unrecognized []byte            `json:"-"`
}

func (m *GetRowResponse) Reset()                    { *m = GetRowResponse{} }
func (m *GetRowResponse) String() string            { return proto.CompactTextString(m) }
func (*GetRowResponse) ProtoMessage()               {}
func (*GetRowResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{29} }

func (m *GetRowResponse) GetConsumed() *ConsumedCapacity {
	if m != nil {
		return m.Consumed
	}
	return nil
}

func (m *GetRowResponse) GetRow() []byte {
	if m != nil {
		return m.Row
	}
	return nil
}

func (m *GetRowResponse) GetNextToken() []byte {
	if m != nil {
		return m.NextToken
	}
	return nil
}

// #############################################  UpdateRow  #############################################
type UpdateRowRequest struct {
	TableName        *string        `protobuf:"bytes,1,req,name=table_name" json:"table_name,omitempty"`
	RowChange        []byte         `protobuf:"bytes,2,req,name=row_change" json:"row_change,omitempty"`
	Condition        *Condition     `protobuf:"bytes,3,req,name=condition" json:"condition,omitempty"`
	ReturnContent    *ReturnContent `protobuf:"bytes,4,opt,name=return_content" json:"return_content,omitempty"`
	TransactionId    *string        `protobuf:"bytes,5,opt,name=transaction_id" json:"transaction_id,omitempty"`
	XXX_unrecognized []byte         `json:"-"`
}

func (m *UpdateRowRequest) Reset()                    { *m = UpdateRowRequest{} }
func (m *UpdateRowRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateRowRequest) ProtoMessage()               {}
func (*UpdateRowRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{30} }

func (m *UpdateRowRequest) GetTableName() string {
	if m != nil && m.TableName != nil {
		return *m.TableName
	}
	return ""
}

func (m *UpdateRowRequest) GetRowChange() []byte {
	if m != nil {
		return m.RowChange
	}
	return nil
}

func (m *UpdateRowRequest) GetCondition() *Condition {
	if m != nil {
		return m.Condition
	}
	return nil
}

func (m *UpdateRowRequest) GetReturnContent() *ReturnContent {
	if m != nil {
		return m.ReturnContent
	}
	return nil
}

func (m *UpdateRowRequest) GetTransactionId() string {
	if m != nil && m.TransactionId != nil {
		return *m.TransactionId
	}
	return ""
}

type UpdateRowResponse struct {
	Consumed         *ConsumedCapacity `protobuf:"bytes,1,req,name=consumed" json:"consumed,omitempty"`
	Row              []byte            `protobuf:"bytes,2,opt,name=row" json:"row,omitempty"`
	XXX_unrecognized []byte            `json:"-"`
}

func (m *UpdateRowResponse) Reset()                    { *m = UpdateRowResponse{} }
func (m *UpdateRowResponse) String() string            { return proto.CompactTextString(m) }
func (*UpdateRowResponse) ProtoMessage()               {}
func (*UpdateRowResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{31} }

func (m *UpdateRowResponse) GetConsumed() *ConsumedCapacity {
	if m != nil {
		return m.Consumed
	}
	return nil
}

func (m *UpdateRowResponse) GetRow() []byte {
	if m != nil {
		return m.Row
	}
	return nil
}

// *
// 这里允许用户为每列单独设置timestamp，而不是强制整行统一一个timestamp。
// 原因是列都是用统一的结构，该结构本身是带timestamp的，其次强制统一timestamp增强了规范性但是丧失了灵活性，且该规范性没有明显的好处，反而带来了结构的复杂。
type PutRowRequest struct {
	TableName        *string        `protobuf:"bytes,1,req,name=table_name" json:"table_name,omitempty"`
	Row              []byte         `protobuf:"bytes,2,req,name=row" json:"row,omitempty"`
	Condition        *Condition     `protobuf:"bytes,3,req,name=condition" json:"condition,omitempty"`
	ReturnContent    *ReturnContent `protobuf:"bytes,4,opt,name=return_content" json:"return_content,omitempty"`
	TransactionId    *string        `protobuf:"bytes,5,opt,name=transaction_id" json:"transaction_id,omitempty"`
	XXX_unrecognized []byte         `json:"-"`
}

func (m *PutRowRequest) Reset()                    { *m = PutRowRequest{} }
func (m *PutRowRequest) String() string            { return proto.CompactTextString(m) }
func (*PutRowRequest) ProtoMessage()               {}
func (*PutRowRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{32} }

func (m *PutRowRequest) GetTableName() string {
	if m != nil && m.TableName != nil {
		return *m.TableName
	}
	return ""
}

func (m *PutRowRequest) GetRow() []byte {
	if m != nil {
		return m.Row
	}
	return nil
}

func (m *PutRowRequest) GetCondition() *Condition {
	if m != nil {
		return m.Condition
	}
	return nil
}

func (m *PutRowRequest) GetReturnContent() *ReturnContent {
	if m != nil {
		return m.ReturnContent
	}
	return nil
}

func (m *PutRowRequest) GetTransactionId() string {
	if m != nil && m.TransactionId != nil {
		return *m.TransactionId
	}
	return ""
}

type PutRowResponse struct {
	Consumed         *ConsumedCapacity `protobuf:"bytes,1,req,name=consumed" json:"consumed,omitempty"`
	Row              []byte            `protobuf:"bytes,2,opt,name=row" json:"row,omitempty"`
	XXX_unrecognized []byte            `json:"-"`
}

func (m *PutRowResponse) Reset()                    { *m = PutRowResponse{} }
func (m *PutRowResponse) String() string            { return proto.CompactTextString(m) }
func (*PutRowResponse) ProtoMessage()               {}
func (*PutRowResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{33} }

func (m *PutRowResponse) GetConsumed() *ConsumedCapacity {
	if m != nil {
		return m.Consumed
	}
	return nil
}

func (m *PutRowResponse) GetRow() []byte {
	if m != nil {
		return m.Row
	}
	return nil
}

// *
// OTS只支持删除该行的所有列所有版本，不支持：
//  1. 删除所有列的所有小于等于某个版本的所有版本
type DeleteRowRequest struct {
	TableName        *string        `protobuf:"bytes,1,req,name=table_name" json:"table_name,omitempty"`
	PrimaryKey       []byte         `protobuf:"bytes,2,req,name=primary_key" json:"primary_key,omitempty"`
	Condition        *Condition     `protobuf:"bytes,3,req,name=condition" json:"condition,omitempty"`
	ReturnContent    *ReturnContent `protobuf:"bytes,4,opt,name=return_content" json:"return_content,omitempty"`
	TransactionId    *string        `protobuf:"bytes,5,opt,name=transaction_id" json:"transaction_id,omitempty"`
	XXX_unrecognized []byte         `json:"-"`
}

func (m *DeleteRowRequest) Reset()                    { *m = DeleteRowRequest{} }
func (m *DeleteRowRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteRowRequest) ProtoMessage()               {}
func (*DeleteRowRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{34} }

func (m *DeleteRowRequest) GetTableName() string {
	if m != nil && m.TableName != nil {
		return *m.TableName
	}
	return ""
}

func (m *DeleteRowRequest) GetPrimaryKey() []byte {
	if m != nil {
		return m.PrimaryKey
	}
	return nil
}

func (m *DeleteRowRequest) GetCondition() *Condition {
	if m != nil {
		return m.Condition
	}
	return nil
}

func (m *DeleteRowRequest) GetReturnContent() *ReturnContent {
	if m != nil {
		return m.ReturnContent
	}
	return nil
}

func (m *DeleteRowRequest) GetTransactionId() string {
	if m != nil && m.TransactionId != nil {
		return *m.TransactionId
	}
	return ""
}

type DeleteRowResponse struct {
	Consumed         *ConsumedCapacity `protobuf:"bytes,1,req,name=consumed" json:"consumed,omitempty"`
	Row              []byte            `protobuf:"bytes,2,opt,name=row" json:"row,omitempty"`
	XXX_unrecognized []byte            `json:"-"`
}

func (m *DeleteRowResponse) Reset()                    { *m = DeleteRowResponse{} }
func (m *DeleteRowResponse) String() string            { return proto.CompactTextString(m) }
func (*DeleteRowResponse) ProtoMessage()               {}
func (*DeleteRowResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{35} }

func (m *DeleteRowResponse) GetConsumed() *ConsumedCapacity {
	if m != nil {
		return m.Consumed
	}
	return nil
}

func (m *DeleteRowResponse) GetRow() []byte {
	if m != nil {
		return m.Row
	}
	return nil
}

// *
// HBase支持Batch操作的每行都拥有不同的查询参数，OTS不支持。
type TableInBatchGetRowRequest struct {
	TableName        *string    `protobuf:"bytes,1,req,name=table_name" json:"table_name,omitempty"`
	PrimaryKey       [][]byte   `protobuf:"bytes,2,rep,name=primary_key" json:"primary_key,omitempty"`
	Token            [][]byte   `protobuf:"bytes,3,rep,name=token" json:"token,omitempty"`
	ColumnsToGet     []string   `protobuf:"bytes,4,rep,name=columns_to_get" json:"columns_to_get,omitempty"`
	TimeRange        *TimeRange `protobuf:"bytes,5,opt,name=time_range" json:"time_range,omitempty"`
	MaxVersions      *int32     `protobuf:"varint,6,opt,name=max_versions" json:"max_versions,omitempty"`
	CacheBlocks      *bool      `protobuf:"varint,7,opt,name=cache_blocks,def=1" json:"cache_blocks,omitempty"`
	Filter           []byte     `protobuf:"bytes,8,opt,name=filter" json:"filter,omitempty"`
	StartColumn      *string    `protobuf:"bytes,9,opt,name=start_column" json:"start_column,omitempty"`
	EndColumn        *string    `protobuf:"bytes,10,opt,name=end_column" json:"end_column,omitempty"`
	XXX_unrecognized []byte     `json:"-"`
}

func (m *TableInBatchGetRowRequest) Reset()                    { *m = TableInBatchGetRowRequest{} }
func (m *TableInBatchGetRowRequest) String() string            { return proto.CompactTextString(m) }
func (*TableInBatchGetRowRequest) ProtoMessage()               {}
func (*TableInBatchGetRowRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{36} }

const Default_TableInBatchGetRowRequest_CacheBlocks bool = true

func (m *TableInBatchGetRowRequest) GetTableName() string {
	if m != nil && m.TableName != nil {
		return *m.TableName
	}
	return ""
}

func (m *TableInBatchGetRowRequest) GetPrimaryKey() [][]byte {
	if m != nil {
		return m.PrimaryKey
	}
	return nil
}

func (m *TableInBatchGetRowRequest) GetToken() [][]byte {
	if m != nil {
		return m.Token
	}
	return nil
}

func (m *TableInBatchGetRowRequest) GetColumnsToGet() []string {
	if m != nil {
		return m.ColumnsToGet
	}
	return nil
}

func (m *TableInBatchGetRowRequest) GetTimeRange() *TimeRange {
	if m != nil {
		return m.TimeRange
	}
	return nil
}

func (m *TableInBatchGetRowRequest) GetMaxVersions() int32 {
	if m != nil && m.MaxVersions != nil {
		return *m.MaxVersions
	}
	return 0
}

func (m *TableInBatchGetRowRequest) GetCacheBlocks() bool {
	if m != nil && m.CacheBlocks != nil {
		return *m.CacheBlocks
	}
	return Default_TableInBatchGetRowRequest_CacheBlocks
}

func (m *TableInBatchGetRowRequest) GetFilter() []byte {
	if m != nil {
		return m.Filter
	}
	return nil
}

func (m *TableInBatchGetRowRequest) GetStartColumn() string {
	if m != nil && m.StartColumn != nil {
		return *m.StartColumn
	}
	return ""
}

func (m *TableInBatchGetRowRequest) GetEndColumn() string {
	if m != nil && m.EndColumn != nil {
		return *m.EndColumn
	}
	return ""
}

type BatchGetRowRequest struct {
	Tables           []*TableInBatchGetRowRequest `protobuf:"bytes,1,rep,name=tables" json:"tables,omitempty"`
	XXX_unrecognized []byte                       `json:"-"`
}

func (m *BatchGetRowRequest) Reset()                    { *m = BatchGetRowRequest{} }
func (m *BatchGetRowRequest) String() string            { return proto.CompactTextString(m) }
func (*BatchGetRowRequest) ProtoMessage()               {}
func (*BatchGetRowRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{37} }

func (m *BatchGetRowRequest) GetTables() []*TableInBatchGetRowRequest {
	if m != nil {
		return m.Tables
	}
	return nil
}

type RowInBatchGetRowResponse struct {
	IsOk             *bool             `protobuf:"varint,1,req,name=is_ok" json:"is_ok,omitempty"`
	Error            *Error            `protobuf:"bytes,2,opt,name=error" json:"error,omitempty"`
	Consumed         *ConsumedCapacity `protobuf:"bytes,3,opt,name=consumed" json:"consumed,omitempty"`
	Row              []byte            `protobuf:"bytes,4,opt,name=row" json:"row,omitempty"`
	NextToken        []byte            `protobuf:"bytes,5,opt,name=next_token" json:"next_token,omitempty"`
	XXX_unrecognized []byte            `json:"-"`
}

func (m *RowInBatchGetRowResponse) Reset()                    { *m = RowInBatchGetRowResponse{} }
func (m *RowInBatchGetRowResponse) String() string            { return proto.CompactTextString(m) }
func (*RowInBatchGetRowResponse) ProtoMessage()               {}
func (*RowInBatchGetRowResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{38} }

func (m *RowInBatchGetRowResponse) GetIsOk() bool {
	if m != nil && m.IsOk != nil {
		return *m.IsOk
	}
	return false
}

func (m *RowInBatchGetRowResponse) GetError() *Error {
	if m != nil {
		return m.Error
	}
	return nil
}

func (m *RowInBatchGetRowResponse) GetConsumed() *ConsumedCapacity {
	if m != nil {
		return m.Consumed
	}
	return nil
}

func (m *RowInBatchGetRowResponse) GetRow() []byte {
	if m != nil {
		return m.Row
	}
	return nil
}

func (m *RowInBatchGetRowResponse) GetNextToken() []byte {
	if m != nil {
		return m.NextToken
	}
	return nil
}

type TableInBatchGetRowResponse struct {
	TableName        *string                     `protobuf:"bytes,1,req,name=table_name" json:"table_name,omitempty"`
	Rows             []*RowInBatchGetRowResponse `protobuf:"bytes,2,rep,name=rows" json:"rows,omitempty"`
	XXX_unrecognized []byte                      `json:"-"`
}

func (m *TableInBatchGetRowResponse) Reset()                    { *m = TableInBatchGetRowResponse{} }
func (m *TableInBatchGetRowResponse) String() string            { return proto.CompactTextString(m) }
func (*TableInBatchGetRowResponse) ProtoMessage()               {}
func (*TableInBatchGetRowResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{39} }

func (m *TableInBatchGetRowResponse) GetTableName() string {
	if m != nil && m.TableName != nil {
		return *m.TableName
	}
	return ""
}

func (m *TableInBatchGetRowResponse) GetRows() []*RowInBatchGetRowResponse {
	if m != nil {
		return m.Rows
	}
	return nil
}

type BatchGetRowResponse struct {
	Tables           []*TableInBatchGetRowResponse `protobuf:"bytes,1,rep,name=tables" json:"tables,omitempty"`
	XXX_unrecognized []byte                        `json:"-"`
}

func (m *BatchGetRowResponse) Reset()                    { *m = BatchGetRowResponse{} }
func (m *BatchGetRowResponse) String() string            { return proto.CompactTextString(m) }
func (*BatchGetRowResponse) ProtoMessage()               {}
func (*BatchGetRowResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{40} }

func (m *BatchGetRowResponse) GetTables() []*TableInBatchGetRowResponse {
	if m != nil {
		return m.Tables
	}
	return nil
}

type RowInBatchWriteRowRequest struct {
	Type             *OperationType `protobuf:"varint,1,req,name=type,enum=otsprotocol.OperationType" json:"type,omitempty"`
	RowChange        []byte         `protobuf:"bytes,2,req,name=row_change" json:"row_change,omitempty"`
	Condition        *Condition     `protobuf:"bytes,3,req,name=condition" json:"condition,omitempty"`
	ReturnContent    *ReturnContent `protobuf:"bytes,4,opt,name=return_content" json:"return_content,omitempty"`
	XXX_unrecognized []byte         `json:"-"`
}

func (m *RowInBatchWriteRowRequest) Reset()                    { *m = RowInBatchWriteRowRequest{} }
func (m *RowInBatchWriteRowRequest) String() string            { return proto.CompactTextString(m) }
func (*RowInBatchWriteRowRequest) ProtoMessage()               {}
func (*RowInBatchWriteRowRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{41} }

func (m *RowInBatchWriteRowRequest) GetType() OperationType {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return OperationType_PUT
}

func (m *RowInBatchWriteRowRequest) GetRowChange() []byte {
	if m != nil {
		return m.RowChange
	}
	return nil
}

func (m *RowInBatchWriteRowRequest) GetCondition() *Condition {
	if m != nil {
		return m.Condition
	}
	return nil
}

func (m *RowInBatchWriteRowRequest) GetReturnContent() *ReturnContent {
	if m != nil {
		return m.ReturnContent
	}
	return nil
}

type TableInBatchWriteRowRequest struct {
	TableName        *string                      `protobuf:"bytes,1,req,name=table_name" json:"table_name,omitempty"`
	Rows             []*RowInBatchWriteRowRequest `protobuf:"bytes,2,rep,name=rows" json:"rows,omitempty"`
	XXX_unrecognized []byte                       `json:"-"`
}

func (m *TableInBatchWriteRowRequest) Reset()                    { *m = TableInBatchWriteRowRequest{} }
func (m *TableInBatchWriteRowRequest) String() string            { return proto.CompactTextString(m) }
func (*TableInBatchWriteRowRequest) ProtoMessage()               {}
func (*TableInBatchWriteRowRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{42} }

func (m *TableInBatchWriteRowRequest) GetTableName() string {
	if m != nil && m.TableName != nil {
		return *m.TableName
	}
	return ""
}

func (m *TableInBatchWriteRowRequest) GetRows() []*RowInBatchWriteRowRequest {
	if m != nil {
		return m.Rows
	}
	return nil
}

type BatchWriteRowRequest struct {
	Tables           []*TableInBatchWriteRowRequest `protobuf:"bytes,1,rep,name=tables" json:"tables,omitempty"`
	TransactionId    *string                        `protobuf:"bytes,2,opt,name=transaction_id" json:"transaction_id,omitempty"`
	XXX_unrecognized []byte                         `json:"-"`
}

func (m *BatchWriteRowRequest) Reset()                    { *m = BatchWriteRowRequest{} }
func (m *BatchWriteRowRequest) String() string            { return proto.CompactTextString(m) }
func (*BatchWriteRowRequest) ProtoMessage()               {}
func (*BatchWriteRowRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{43} }

func (m *BatchWriteRowRequest) GetTables() []*TableInBatchWriteRowRequest {
	if m != nil {
		return m.Tables
	}
	return nil
}

func (m *BatchWriteRowRequest) GetTransactionId() string {
	if m != nil && m.TransactionId != nil {
		return *m.TransactionId
	}
	return ""
}

type RowInBatchWriteRowResponse struct {
	IsOk             *bool             `protobuf:"varint,1,req,name=is_ok" json:"is_ok,omitempty"`
	Error            *Error            `protobuf:"bytes,2,opt,name=error" json:"error,omitempty"`
	Consumed         *ConsumedCapacity `protobuf:"bytes,3,opt,name=consumed" json:"consumed,omitempty"`
	Row              []byte            `protobuf:"bytes,4,opt,name=row" json:"row,omitempty"`
	XXX_unrecognized []byte            `json:"-"`
}

func (m *RowInBatchWriteRowResponse) Reset()                    { *m = RowInBatchWriteRowResponse{} }
func (m *RowInBatchWriteRowResponse) String() string            { return proto.CompactTextString(m) }
func (*RowInBatchWriteRowResponse) ProtoMessage()               {}
func (*RowInBatchWriteRowResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{44} }

func (m *RowInBatchWriteRowResponse) GetIsOk() bool {
	if m != nil && m.IsOk != nil {
		return *m.IsOk
	}
	return false
}

func (m *RowInBatchWriteRowResponse) GetError() *Error {
	if m != nil {
		return m.Error
	}
	return nil
}

func (m *RowInBatchWriteRowResponse) GetConsumed() *ConsumedCapacity {
	if m != nil {
		return m.Consumed
	}
	return nil
}

func (m *RowInBatchWriteRowResponse) GetRow() []byte {
	if m != nil {
		return m.Row
	}
	return nil
}

type TableInBatchWriteRowResponse struct {
	TableName        *string                       `protobuf:"bytes,1,req,name=table_name" json:"table_name,omitempty"`
	Rows             []*RowInBatchWriteRowResponse `protobuf:"bytes,2,rep,name=rows" json:"rows,omitempty"`
	XXX_unrecognized []byte                        `json:"-"`
}

func (m *TableInBatchWriteRowResponse) Reset()                    { *m = TableInBatchWriteRowResponse{} }
func (m *TableInBatchWriteRowResponse) String() string            { return proto.CompactTextString(m) }
func (*TableInBatchWriteRowResponse) ProtoMessage()               {}
func (*TableInBatchWriteRowResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{45} }

func (m *TableInBatchWriteRowResponse) GetTableName() string {
	if m != nil && m.TableName != nil {
		return *m.TableName
	}
	return ""
}

func (m *TableInBatchWriteRowResponse) GetRows() []*RowInBatchWriteRowResponse {
	if m != nil {
		return m.Rows
	}
	return nil
}

type BatchWriteRowResponse struct {
	Tables           []*TableInBatchWriteRowResponse `protobuf:"bytes,1,rep,name=tables" json:"tables,omitempty"`
	XXX_unrecognized []byte                          `json:"-"`
}

func (m *BatchWriteRowResponse) Reset()                    { *m = BatchWriteRowResponse{} }
func (m *BatchWriteRowResponse) String() string            { return proto.CompactTextString(m) }
func (*BatchWriteRowResponse) ProtoMessage()               {}
func (*BatchWriteRowResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{46} }

func (m *BatchWriteRowResponse) GetTables() []*TableInBatchWriteRowResponse {
	if m != nil {
		return m.Tables
	}
	return nil
}

// *
// HBase支持以下参数：
//     1. TimeRange或指定time
//     2. Filter（根据列值或列名来过滤）
// 我们只支持给同版本的选择条件。
type GetRangeRequest struct {
	TableName                *string    `protobuf:"bytes,1,req,name=table_name" json:"table_name,omitempty"`
	Direction                *Direction `protobuf:"varint,2,req,name=direction,enum=otsprotocol.Direction" json:"direction,omitempty"`
	ColumnsToGet             []string   `protobuf:"bytes,3,rep,name=columns_to_get" json:"columns_to_get,omitempty"`
	TimeRange                *TimeRange `protobuf:"bytes,4,opt,name=time_range" json:"time_range,omitempty"`
	MaxVersions              *int32     `protobuf:"varint,5,opt,name=max_versions" json:"max_versions,omitempty"`
	Limit                    *int32     `protobuf:"varint,6,opt,name=limit" json:"limit,omitempty"`
	InclusiveStartPrimaryKey []byte     `protobuf:"bytes,7,req,name=inclusive_start_primary_key" json:"inclusive_start_primary_key,omitempty"`
	ExclusiveEndPrimaryKey   []byte     `protobuf:"bytes,8,req,name=exclusive_end_primary_key" json:"exclusive_end_primary_key,omitempty"`
	CacheBlocks              *bool      `protobuf:"varint,9,opt,name=cache_blocks,def=1" json:"cache_blocks,omitempty"`
	Filter                   []byte     `protobuf:"bytes,10,opt,name=filter" json:"filter,omitempty"`
	StartColumn              *string    `protobuf:"bytes,11,opt,name=start_column" json:"start_column,omitempty"`
	EndColumn                *string    `protobuf:"bytes,12,opt,name=end_column" json:"end_column,omitempty"`
	Token                    []byte     `protobuf:"bytes,13,opt,name=token" json:"token,omitempty"`
	TransactionId            *string    `protobuf:"bytes,14,opt,name=transaction_id" json:"transaction_id,omitempty"`
	XXX_unrecognized         []byte     `json:"-"`
}

func (m *GetRangeRequest) Reset()                    { *m = GetRangeRequest{} }
func (m *GetRangeRequest) String() string            { return proto.CompactTextString(m) }
func (*GetRangeRequest) ProtoMessage()               {}
func (*GetRangeRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{47} }

const Default_GetRangeRequest_CacheBlocks bool = true

func (m *GetRangeRequest) GetTableName() string {
	if m != nil && m.TableName != nil {
		return *m.TableName
	}
	return ""
}

func (m *GetRangeRequest) GetDirection() Direction {
	if m != nil && m.Direction != nil {
		return *m.Direction
	}
	return Direction_FORWARD
}

func (m *GetRangeRequest) GetColumnsToGet() []string {
	if m != nil {
		return m.ColumnsToGet
	}
	return nil
}

func (m *GetRangeRequest) GetTimeRange() *TimeRange {
	if m != nil {
		return m.TimeRange
	}
	return nil
}

func (m *GetRangeRequest) GetMaxVersions() int32 {
	if m != nil && m.MaxVersions != nil {
		return *m.MaxVersions
	}
	return 0
}

func (m *GetRangeRequest) GetLimit() int32 {
	if m != nil && m.Limit != nil {
		return *m.Limit
	}
	return 0
}

func (m *GetRangeRequest) GetInclusiveStartPrimaryKey() []byte {
	if m != nil {
		return m.InclusiveStartPrimaryKey
	}
	return nil
}

func (m *GetRangeRequest) GetExclusiveEndPrimaryKey() []byte {
	if m != nil {
		return m.ExclusiveEndPrimaryKey
	}
	return nil
}

func (m *GetRangeRequest) GetCacheBlocks() bool {
	if m != nil && m.CacheBlocks != nil {
		return *m.CacheBlocks
	}
	return Default_GetRangeRequest_CacheBlocks
}

func (m *GetRangeRequest) GetFilter() []byte {
	if m != nil {
		return m.Filter
	}
	return nil
}

func (m *GetRangeRequest) GetStartColumn() string {
	if m != nil && m.StartColumn != nil {
		return *m.StartColumn
	}
	return ""
}

func (m *GetRangeRequest) GetEndColumn() string {
	if m != nil && m.EndColumn != nil {
		return *m.EndColumn
	}
	return ""
}

func (m *GetRangeRequest) GetToken() []byte {
	if m != nil {
		return m.Token
	}
	return nil
}

func (m *GetRangeRequest) GetTransactionId() string {
	if m != nil && m.TransactionId != nil {
		return *m.TransactionId
	}
	return ""
}

type GetRangeResponse struct {
	Consumed            *ConsumedCapacity `protobuf:"bytes,1,req,name=consumed" json:"consumed,omitempty"`
	Rows                []byte            `protobuf:"bytes,2,req,name=rows" json:"rows,omitempty"`
	NextStartPrimaryKey []byte            `protobuf:"bytes,3,opt,name=next_start_primary_key" json:"next_start_primary_key,omitempty"`
	NextToken           []byte            `protobuf:"bytes,4,opt,name=next_token" json:"next_token,omitempty"`
	XXX_unrecognized    []byte            `json:"-"`
}

func (m *GetRangeResponse) Reset()                    { *m = GetRangeResponse{} }
func (m *GetRangeResponse) String() string            { return proto.CompactTextString(m) }
func (*GetRangeResponse) ProtoMessage()               {}
func (*GetRangeResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{48} }

func (m *GetRangeResponse) GetConsumed() *ConsumedCapacity {
	if m != nil {
		return m.Consumed
	}
	return nil
}

func (m *GetRangeResponse) GetRows() []byte {
	if m != nil {
		return m.Rows
	}
	return nil
}

func (m *GetRangeResponse) GetNextStartPrimaryKey() []byte {
	if m != nil {
		return m.NextStartPrimaryKey
	}
	return nil
}

func (m *GetRangeResponse) GetNextToken() []byte {
	if m != nil {
		return m.NextToken
	}
	return nil
}

type ListStreamRequest struct {
	TableName        *string `protobuf:"bytes,1,opt,name=table_name" json:"table_name,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *ListStreamRequest) Reset()                    { *m = ListStreamRequest{} }
func (m *ListStreamRequest) String() string            { return proto.CompactTextString(m) }
func (*ListStreamRequest) ProtoMessage()               {}
func (*ListStreamRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{49} }

func (m *ListStreamRequest) GetTableName() string {
	if m != nil && m.TableName != nil {
		return *m.TableName
	}
	return ""
}

type Stream struct {
	StreamId         *string `protobuf:"bytes,1,req,name=stream_id" json:"stream_id,omitempty"`
	TableName        *string `protobuf:"bytes,2,req,name=table_name" json:"table_name,omitempty"`
	CreationTime     *int64  `protobuf:"varint,3,req,name=creation_time" json:"creation_time,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *Stream) Reset()                    { *m = Stream{} }
func (m *Stream) String() string            { return proto.CompactTextString(m) }
func (*Stream) ProtoMessage()               {}
func (*Stream) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{50} }

func (m *Stream) GetStreamId() string {
	if m != nil && m.StreamId != nil {
		return *m.StreamId
	}
	return ""
}

func (m *Stream) GetTableName() string {
	if m != nil && m.TableName != nil {
		return *m.TableName
	}
	return ""
}

func (m *Stream) GetCreationTime() int64 {
	if m != nil && m.CreationTime != nil {
		return *m.CreationTime
	}
	return 0
}

type ListStreamResponse struct {
	Streams          []*Stream `protobuf:"bytes,1,rep,name=streams" json:"streams,omitempty"`
	XXX_unrecognized []byte    `json:"-"`
}

func (m *ListStreamResponse) Reset()                    { *m = ListStreamResponse{} }
func (m *ListStreamResponse) String() string            { return proto.CompactTextString(m) }
func (*ListStreamResponse) ProtoMessage()               {}
func (*ListStreamResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{51} }

func (m *ListStreamResponse) GetStreams() []*Stream {
	if m != nil {
		return m.Streams
	}
	return nil
}

type StreamShard struct {
	ShardId          *string `protobuf:"bytes,1,req,name=shard_id" json:"shard_id,omitempty"`
	ParentId         *string `protobuf:"bytes,2,opt,name=parent_id" json:"parent_id,omitempty"`
	ParentSiblingId  *string `protobuf:"bytes,3,opt,name=parent_sibling_id" json:"parent_sibling_id,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *StreamShard) Reset()                    { *m = StreamShard{} }
func (m *StreamShard) String() string            { return proto.CompactTextString(m) }
func (*StreamShard) ProtoMessage()               {}
func (*StreamShard) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{52} }

func (m *StreamShard) GetShardId() string {
	if m != nil && m.ShardId != nil {
		return *m.ShardId
	}
	return ""
}

func (m *StreamShard) GetParentId() string {
	if m != nil && m.ParentId != nil {
		return *m.ParentId
	}
	return ""
}

func (m *StreamShard) GetParentSiblingId() string {
	if m != nil && m.ParentSiblingId != nil {
		return *m.ParentSiblingId
	}
	return ""
}

type DescribeStreamRequest struct {
	StreamId              *string `protobuf:"bytes,1,req,name=stream_id" json:"stream_id,omitempty"`
	InclusiveStartShardId *string `protobuf:"bytes,2,opt,name=inclusive_start_shard_id" json:"inclusive_start_shard_id,omitempty"`
	ShardLimit            *int32  `protobuf:"varint,3,opt,name=shard_limit" json:"shard_limit,omitempty"`
	XXX_unrecognized      []byte  `json:"-"`
}

func (m *DescribeStreamRequest) Reset()                    { *m = DescribeStreamRequest{} }
func (m *DescribeStreamRequest) String() string            { return proto.CompactTextString(m) }
func (*DescribeStreamRequest) ProtoMessage()               {}
func (*DescribeStreamRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{53} }

func (m *DescribeStreamRequest) GetStreamId() string {
	if m != nil && m.StreamId != nil {
		return *m.StreamId
	}
	return ""
}

func (m *DescribeStreamRequest) GetInclusiveStartShardId() string {
	if m != nil && m.InclusiveStartShardId != nil {
		return *m.InclusiveStartShardId
	}
	return ""
}

func (m *DescribeStreamRequest) GetShardLimit() int32 {
	if m != nil && m.ShardLimit != nil {
		return *m.ShardLimit
	}
	return 0
}

type DescribeStreamResponse struct {
	StreamId         *string        `protobuf:"bytes,1,req,name=stream_id" json:"stream_id,omitempty"`
	ExpirationTime   *int32         `protobuf:"varint,2,req,name=expiration_time" json:"expiration_time,omitempty"`
	TableName        *string        `protobuf:"bytes,3,req,name=table_name" json:"table_name,omitempty"`
	CreationTime     *int64         `protobuf:"varint,4,req,name=creation_time" json:"creation_time,omitempty"`
	StreamStatus     *StreamStatus  `protobuf:"varint,5,req,name=stream_status,enum=otsprotocol.StreamStatus" json:"stream_status,omitempty"`
	Shards           []*StreamShard `protobuf:"bytes,6,rep,name=shards" json:"shards,omitempty"`
	NextShardId      *string        `protobuf:"bytes,7,opt,name=next_shard_id" json:"next_shard_id,omitempty"`
	XXX_unrecognized []byte         `json:"-"`
}

func (m *DescribeStreamResponse) Reset()                    { *m = DescribeStreamResponse{} }
func (m *DescribeStreamResponse) String() string            { return proto.CompactTextString(m) }
func (*DescribeStreamResponse) ProtoMessage()               {}
func (*DescribeStreamResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{54} }

func (m *DescribeStreamResponse) GetStreamId() string {
	if m != nil && m.StreamId != nil {
		return *m.StreamId
	}
	return ""
}

func (m *DescribeStreamResponse) GetExpirationTime() int32 {
	if m != nil && m.ExpirationTime != nil {
		return *m.ExpirationTime
	}
	return 0
}

func (m *DescribeStreamResponse) GetTableName() string {
	if m != nil && m.TableName != nil {
		return *m.TableName
	}
	return ""
}

func (m *DescribeStreamResponse) GetCreationTime() int64 {
	if m != nil && m.CreationTime != nil {
		return *m.CreationTime
	}
	return 0
}

func (m *DescribeStreamResponse) GetStreamStatus() StreamStatus {
	if m != nil && m.StreamStatus != nil {
		return *m.StreamStatus
	}
	return StreamStatus_STREAM_ENABLING
}

func (m *DescribeStreamResponse) GetShards() []*StreamShard {
	if m != nil {
		return m.Shards
	}
	return nil
}

func (m *DescribeStreamResponse) GetNextShardId() string {
	if m != nil && m.NextShardId != nil {
		return *m.NextShardId
	}
	return ""
}

type GetShardIteratorRequest struct {
	StreamId         *string `protobuf:"bytes,1,req,name=stream_id" json:"stream_id,omitempty"`
	ShardId          *string `protobuf:"bytes,2,req,name=shard_id" json:"shard_id,omitempty"`
	Timestamp        *int64  `protobuf:"varint,3,opt,name=timestamp" json:"timestamp,omitempty"`
	Token            *string `protobuf:"bytes,4,opt,name=token" json:"token,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *GetShardIteratorRequest) Reset()                    { *m = GetShardIteratorRequest{} }
func (m *GetShardIteratorRequest) String() string            { return proto.CompactTextString(m) }
func (*GetShardIteratorRequest) ProtoMessage()               {}
func (*GetShardIteratorRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{55} }

func (m *GetShardIteratorRequest) GetStreamId() string {
	if m != nil && m.StreamId != nil {
		return *m.StreamId
	}
	return ""
}

func (m *GetShardIteratorRequest) GetShardId() string {
	if m != nil && m.ShardId != nil {
		return *m.ShardId
	}
	return ""
}

func (m *GetShardIteratorRequest) GetTimestamp() int64 {
	if m != nil && m.Timestamp != nil {
		return *m.Timestamp
	}
	return 0
}

func (m *GetShardIteratorRequest) GetToken() string {
	if m != nil && m.Token != nil {
		return *m.Token
	}
	return ""
}

type GetShardIteratorResponse struct {
	ShardIterator    *string `protobuf:"bytes,1,req,name=shard_iterator" json:"shard_iterator,omitempty"`
	NextToken        *string `protobuf:"bytes,2,opt,name=next_token" json:"next_token,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *GetShardIteratorResponse) Reset()                    { *m = GetShardIteratorResponse{} }
func (m *GetShardIteratorResponse) String() string            { return proto.CompactTextString(m) }
func (*GetShardIteratorResponse) ProtoMessage()               {}
func (*GetShardIteratorResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{56} }

func (m *GetShardIteratorResponse) GetShardIterator() string {
	if m != nil && m.ShardIterator != nil {
		return *m.ShardIterator
	}
	return ""
}

func (m *GetShardIteratorResponse) GetNextToken() string {
	if m != nil && m.NextToken != nil {
		return *m.NextToken
	}
	return ""
}

type GetStreamRecordRequest struct {
	ShardIterator    *string `protobuf:"bytes,1,req,name=shard_iterator" json:"shard_iterator,omitempty"`
	Limit            *int32  `protobuf:"varint,2,opt,name=limit" json:"limit,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *GetStreamRecordRequest) Reset()                    { *m = GetStreamRecordRequest{} }
func (m *GetStreamRecordRequest) String() string            { return proto.CompactTextString(m) }
func (*GetStreamRecordRequest) ProtoMessage()               {}
func (*GetStreamRecordRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{57} }

func (m *GetStreamRecordRequest) GetShardIterator() string {
	if m != nil && m.ShardIterator != nil {
		return *m.ShardIterator
	}
	return ""
}

func (m *GetStreamRecordRequest) GetLimit() int32 {
	if m != nil && m.Limit != nil {
		return *m.Limit
	}
	return 0
}

type GetStreamRecordResponse struct {
	StreamRecords     []*GetStreamRecordResponse_StreamRecord `protobuf:"bytes,1,rep,name=stream_records" json:"stream_records,omitempty"`
	NextShardIterator *string                                 `protobuf:"bytes,2,opt,name=next_shard_iterator" json:"next_shard_iterator,omitempty"`
	XXX_unrecognized  []byte                                  `json:"-"`
}

func (m *GetStreamRecordResponse) Reset()                    { *m = GetStreamRecordResponse{} }
func (m *GetStreamRecordResponse) String() string            { return proto.CompactTextString(m) }
func (*GetStreamRecordResponse) ProtoMessage()               {}
func (*GetStreamRecordResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{58} }

func (m *GetStreamRecordResponse) GetStreamRecords() []*GetStreamRecordResponse_StreamRecord {
	if m != nil {
		return m.StreamRecords
	}
	return nil
}

func (m *GetStreamRecordResponse) GetNextShardIterator() string {
	if m != nil && m.NextShardIterator != nil {
		return *m.NextShardIterator
	}
	return ""
}

type GetStreamRecordResponse_StreamRecord struct {
	ActionType       *ActionType `protobuf:"varint,1,req,name=action_type,enum=otsprotocol.ActionType" json:"action_type,omitempty"`
	Record           []byte      `protobuf:"bytes,2,req,name=record" json:"record,omitempty"`
	XXX_unrecognized []byte      `json:"-"`
}

func (m *GetStreamRecordResponse_StreamRecord) Reset()         { *m = GetStreamRecordResponse_StreamRecord{} }
func (m *GetStreamRecordResponse_StreamRecord) String() string { return proto.CompactTextString(m) }
func (*GetStreamRecordResponse_StreamRecord) ProtoMessage()    {}
func (*GetStreamRecordResponse_StreamRecord) Descriptor() ([]byte, []int) {
	return fileDescriptor2, []int{58, 0}
}

func (m *GetStreamRecordResponse_StreamRecord) GetActionType() ActionType {
	if m != nil && m.ActionType != nil {
		return *m.ActionType
	}
	return ActionType_PUT_ROW
}

func (m *GetStreamRecordResponse_StreamRecord) GetRecord() []byte {
	if m != nil {
		return m.Record
	}
	return nil
}

// +++++ ComputeSplitPointsBySize  +++++
type ComputeSplitPointsBySizeRequest struct {
	TableName        *string `protobuf:"bytes,1,req,name=table_name" json:"table_name,omitempty"`
	SplitSize        *int64  `protobuf:"varint,2,req,name=split_size" json:"split_size,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *ComputeSplitPointsBySizeRequest) Reset()         { *m = ComputeSplitPointsBySizeRequest{} }
func (m *ComputeSplitPointsBySizeRequest) String() string { return proto.CompactTextString(m) }
func (*ComputeSplitPointsBySizeRequest) ProtoMessage()    {}
func (*ComputeSplitPointsBySizeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor2, []int{59}
}

func (m *ComputeSplitPointsBySizeRequest) GetTableName() string {
	if m != nil && m.TableName != nil {
		return *m.TableName
	}
	return ""
}

func (m *ComputeSplitPointsBySizeRequest) GetSplitSize() int64 {
	if m != nil && m.SplitSize != nil {
		return *m.SplitSize
	}
	return 0
}

type ComputeSplitPointsBySizeResponse struct {
	Consumed *ConsumedCapacity   `protobuf:"bytes,1,req,name=consumed" json:"consumed,omitempty"`
	Schema   []*PrimaryKeySchema `protobuf:"bytes,2,rep,name=schema" json:"schema,omitempty"`
	// *
	// Split points between splits, in the increasing order
	//
	// A split is a consecutive range of primary keys,
	// whose data size is about split_size specified in the request.
	// The size could be hard to be precise.
	//
	// A split point is an array of primary-key column w.r.t. table schema,
	// which is never longer than that of table schema.
	// Tailing -inf will be omitted to reduce transmission payloads.
	SplitPoints      [][]byte                                          `protobuf:"bytes,3,rep,name=split_points" json:"split_points,omitempty"`
	Locations        []*ComputeSplitPointsBySizeResponse_SplitLocation `protobuf:"bytes,4,rep,name=locations" json:"locations,omitempty"`
	XXX_unrecognized []byte                                            `json:"-"`
}

func (m *ComputeSplitPointsBySizeResponse) Reset()         { *m = ComputeSplitPointsBySizeResponse{} }
func (m *ComputeSplitPointsBySizeResponse) String() string { return proto.CompactTextString(m) }
func (*ComputeSplitPointsBySizeResponse) ProtoMessage()    {}
func (*ComputeSplitPointsBySizeResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor2, []int{60}
}

func (m *ComputeSplitPointsBySizeResponse) GetConsumed() *ConsumedCapacity {
	if m != nil {
		return m.Consumed
	}
	return nil
}

func (m *ComputeSplitPointsBySizeResponse) GetSchema() []*PrimaryKeySchema {
	if m != nil {
		return m.Schema
	}
	return nil
}

func (m *ComputeSplitPointsBySizeResponse) GetSplitPoints() [][]byte {
	if m != nil {
		return m.SplitPoints
	}
	return nil
}

func (m *ComputeSplitPointsBySizeResponse) GetLocations() []*ComputeSplitPointsBySizeResponse_SplitLocation {
	if m != nil {
		return m.Locations
	}
	return nil
}

// *
// Locations where splits lies in.
//
// By the managed nature of TableStore, these locations are no more than hints.
// If a location is not suitable to be seen, an empty string will be placed.
type ComputeSplitPointsBySizeResponse_SplitLocation struct {
	Location         *string `protobuf:"bytes,1,req,name=location" json:"location,omitempty"`
	Repeat           *int64  `protobuf:"zigzag64,2,req,name=repeat" json:"repeat,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *ComputeSplitPointsBySizeResponse_SplitLocation) Reset() {
	*m = ComputeSplitPointsBySizeResponse_SplitLocation{}
}
func (m *ComputeSplitPointsBySizeResponse_SplitLocation) String() string {
	return proto.CompactTextString(m)
}
func (*ComputeSplitPointsBySizeResponse_SplitLocation) ProtoMessage() {}
func (*ComputeSplitPointsBySizeResponse_SplitLocation) Descriptor() ([]byte, []int) {
	return fileDescriptor2, []int{60, 0}
}

func (m *ComputeSplitPointsBySizeResponse_SplitLocation) GetLocation() string {
	if m != nil && m.Location != nil {
		return *m.Location
	}
	return ""
}

func (m *ComputeSplitPointsBySizeResponse_SplitLocation) GetRepeat() int64 {
	if m != nil && m.Repeat != nil {
		return *m.Repeat
	}
	return 0
}

type DefinedColumnSchema struct {
	Name             *string            `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Type             *DefinedColumnType `protobuf:"varint,2,req,name=type,enum=otsprotocol.DefinedColumnType" json:"type,omitempty"`
	XXX_unrecognized []byte             `json:"-"`
}

func (m *DefinedColumnSchema) Reset()                    { *m = DefinedColumnSchema{} }
func (m *DefinedColumnSchema) String() string            { return proto.CompactTextString(m) }
func (*DefinedColumnSchema) ProtoMessage()               {}
func (*DefinedColumnSchema) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{61} }

func (m *DefinedColumnSchema) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *DefinedColumnSchema) GetType() DefinedColumnType {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return DefinedColumnType_DCT_INTEGER
}

type IndexMeta struct {
	Name             *string          `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	PrimaryKey       []string         `protobuf:"bytes,2,rep,name=primary_key" json:"primary_key,omitempty"`
	DefinedColumn    []string         `protobuf:"bytes,3,rep,name=defined_column" json:"defined_column,omitempty"`
	IndexUpdateMode  *IndexUpdateMode `protobuf:"varint,4,req,name=index_update_mode,enum=otsprotocol.IndexUpdateMode" json:"index_update_mode,omitempty"`
	IndexType        *IndexType       `protobuf:"varint,5,req,name=index_type,enum=otsprotocol.IndexType" json:"index_type,omitempty"`
	XXX_unrecognized []byte           `json:"-"`
}

func (m *IndexMeta) Reset()                    { *m = IndexMeta{} }
func (m *IndexMeta) String() string            { return proto.CompactTextString(m) }
func (*IndexMeta) ProtoMessage()               {}
func (*IndexMeta) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{62} }

func (m *IndexMeta) GetName() string {
	if m != nil && m.Name != nil {
		return *m.Name
	}
	return ""
}

func (m *IndexMeta) GetPrimaryKey() []string {
	if m != nil {
		return m.PrimaryKey
	}
	return nil
}

func (m *IndexMeta) GetDefinedColumn() []string {
	if m != nil {
		return m.DefinedColumn
	}
	return nil
}

func (m *IndexMeta) GetIndexUpdateMode() IndexUpdateMode {
	if m != nil && m.IndexUpdateMode != nil {
		return *m.IndexUpdateMode
	}
	return IndexUpdateMode_IUM_ASYNC_INDEX
}

func (m *IndexMeta) GetIndexType() IndexType {
	if m != nil && m.IndexType != nil {
		return *m.IndexType
	}
	return IndexType_IT_GLOBAL_INDEX
}

type CreateIndexRequest struct {
	MainTableName    *string    `protobuf:"bytes,1,req,name=main_table_name" json:"main_table_name,omitempty"`
	IndexMeta        *IndexMeta `protobuf:"bytes,2,req,name=index_meta" json:"index_meta,omitempty"`
	IncludeBaseData  *bool      `protobuf:"varint,3,opt,name=include_base_data" json:"include_base_data,omitempty"`
	XXX_unrecognized []byte     `json:"-"`
}

func (m *CreateIndexRequest) Reset()                    { *m = CreateIndexRequest{} }
func (m *CreateIndexRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateIndexRequest) ProtoMessage()               {}
func (*CreateIndexRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{63} }

func (m *CreateIndexRequest) GetMainTableName() string {
	if m != nil && m.MainTableName != nil {
		return *m.MainTableName
	}
	return ""
}

func (m *CreateIndexRequest) GetIndexMeta() *IndexMeta {
	if m != nil {
		return m.IndexMeta
	}
	return nil
}

func (m *CreateIndexRequest) GetIncludeBaseData() bool {
	if m != nil && m.IncludeBaseData != nil {
		return *m.IncludeBaseData
	}
	return false
}

type CreateIndexResponse struct {
	XXX_unrecognized []byte `json:"-"`
}

func (m *CreateIndexResponse) Reset()                    { *m = CreateIndexResponse{} }
func (m *CreateIndexResponse) String() string            { return proto.CompactTextString(m) }
func (*CreateIndexResponse) ProtoMessage()               {}
func (*CreateIndexResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{64} }

type DropIndexRequest struct {
	MainTableName    *string `protobuf:"bytes,1,req,name=main_table_name" json:"main_table_name,omitempty"`
	IndexName        *string `protobuf:"bytes,2,req,name=index_name" json:"index_name,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *DropIndexRequest) Reset()                    { *m = DropIndexRequest{} }
func (m *DropIndexRequest) String() string            { return proto.CompactTextString(m) }
func (*DropIndexRequest) ProtoMessage()               {}
func (*DropIndexRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{65} }

func (m *DropIndexRequest) GetMainTableName() string {
	if m != nil && m.MainTableName != nil {
		return *m.MainTableName
	}
	return ""
}

func (m *DropIndexRequest) GetIndexName() string {
	if m != nil && m.IndexName != nil {
		return *m.IndexName
	}
	return ""
}

type DropIndexResponse struct {
	XXX_unrecognized []byte `json:"-"`
}

func (m *DropIndexResponse) Reset()                    { *m = DropIndexResponse{} }
func (m *DropIndexResponse) String() string            { return proto.CompactTextString(m) }
func (*DropIndexResponse) ProtoMessage()               {}
func (*DropIndexResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{66} }

// ###########################################  LocalTransaction  ###########################################
type StartLocalTransactionRequest struct {
	TableName        *string `protobuf:"bytes,1,req,name=table_name" json:"table_name,omitempty"`
	Key              []byte  `protobuf:"bytes,2,req,name=key" json:"key,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *StartLocalTransactionRequest) Reset()                    { *m = StartLocalTransactionRequest{} }
func (m *StartLocalTransactionRequest) String() string            { return proto.CompactTextString(m) }
func (*StartLocalTransactionRequest) ProtoMessage()               {}
func (*StartLocalTransactionRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{67} }

func (m *StartLocalTransactionRequest) GetTableName() string {
	if m != nil && m.TableName != nil {
		return *m.TableName
	}
	return ""
}

func (m *StartLocalTransactionRequest) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

type StartLocalTransactionResponse struct {
	TransactionId    *string `protobuf:"bytes,1,req,name=transaction_id" json:"transaction_id,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *StartLocalTransactionResponse) Reset()                    { *m = StartLocalTransactionResponse{} }
func (m *StartLocalTransactionResponse) String() string            { return proto.CompactTextString(m) }
func (*StartLocalTransactionResponse) ProtoMessage()               {}
func (*StartLocalTransactionResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{68} }

func (m *StartLocalTransactionResponse) GetTransactionId() string {
	if m != nil && m.TransactionId != nil {
		return *m.TransactionId
	}
	return ""
}

type CommitTransactionRequest struct {
	TransactionId    *string `protobuf:"bytes,1,req,name=transaction_id" json:"transaction_id,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *CommitTransactionRequest) Reset()                    { *m = CommitTransactionRequest{} }
func (m *CommitTransactionRequest) String() string            { return proto.CompactTextString(m) }
func (*CommitTransactionRequest) ProtoMessage()               {}
func (*CommitTransactionRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{69} }

func (m *CommitTransactionRequest) GetTransactionId() string {
	if m != nil && m.TransactionId != nil {
		return *m.TransactionId
	}
	return ""
}

type CommitTransactionResponse struct {
	XXX_unrecognized []byte `json:"-"`
}

func (m *CommitTransactionResponse) Reset()                    { *m = CommitTransactionResponse{} }
func (m *CommitTransactionResponse) String() string            { return proto.CompactTextString(m) }
func (*CommitTransactionResponse) ProtoMessage()               {}
func (*CommitTransactionResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{70} }

type AbortTransactionRequest struct {
	TransactionId    *string `protobuf:"bytes,1,req,name=transaction_id" json:"transaction_id,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *AbortTransactionRequest) Reset()                    { *m = AbortTransactionRequest{} }
func (m *AbortTransactionRequest) String() string            { return proto.CompactTextString(m) }
func (*AbortTransactionRequest) ProtoMessage()               {}
func (*AbortTransactionRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{71} }

func (m *AbortTransactionRequest) GetTransactionId() string {
	if m != nil && m.TransactionId != nil {
		return *m.TransactionId
	}
	return ""
}

type AbortTransactionResponse struct {
	XXX_unrecognized []byte `json:"-"`
}

func (m *AbortTransactionResponse) Reset()                    { *m = AbortTransactionResponse{} }
func (m *AbortTransactionResponse) String() string            { return proto.CompactTextString(m) }
func (*AbortTransactionResponse) ProtoMessage()               {}
func (*AbortTransactionResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{72} }

func init() {
	proto.RegisterType((*Error)(nil), "otsprotocol.Error")
	proto.RegisterType((*PrimaryKeySchema)(nil), "otsprotocol.PrimaryKeySchema")
	proto.RegisterType((*PartitionRange)(nil), "otsprotocol.PartitionRange")
	proto.RegisterType((*TableOptions)(nil), "otsprotocol.TableOptions")
	proto.RegisterType((*TableMeta)(nil), "otsprotocol.TableMeta")
	proto.RegisterType((*Condition)(nil), "otsprotocol.Condition")
	proto.RegisterType((*CapacityUnit)(nil), "otsprotocol.CapacityUnit")
	proto.RegisterType((*ReservedThroughputDetails)(nil), "otsprotocol.ReservedThroughputDetails")
	proto.RegisterType((*ReservedThroughput)(nil), "otsprotocol.ReservedThroughput")
	proto.RegisterType((*ConsumedCapacity)(nil), "otsprotocol.ConsumedCapacity")
	proto.RegisterType((*StreamSpecification)(nil), "otsprotocol.StreamSpecification")
	proto.RegisterType((*StreamDetails)(nil), "otsprotocol.StreamDetails")
	proto.RegisterType((*CreateTableRequest)(nil), "otsprotocol.CreateTableRequest")
	proto.RegisterType((*CreateTableResponse)(nil), "otsprotocol.CreateTableResponse")
	proto.RegisterType((*UpdateTableRequest)(nil), "otsprotocol.UpdateTableRequest")
	proto.RegisterType((*UpdateTableResponse)(nil), "otsprotocol.UpdateTableResponse")
	proto.RegisterType((*DescribeTableRequest)(nil), "otsprotocol.DescribeTableRequest")
	proto.RegisterType((*DescribeTableResponse)(nil), "otsprotocol.DescribeTableResponse")
	proto.RegisterType((*ListTableRequest)(nil), "otsprotocol.ListTableRequest")
	proto.RegisterType((*ListTableResponse)(nil), "otsprotocol.ListTableResponse")
	proto.RegisterType((*DeleteTableRequest)(nil), "otsprotocol.DeleteTableRequest")
	proto.RegisterType((*DeleteTableResponse)(nil), "otsprotocol.DeleteTableResponse")
	proto.RegisterType((*LoadTableRequest)(nil), "otsprotocol.LoadTableRequest")
	proto.RegisterType((*LoadTableResponse)(nil), "otsprotocol.LoadTableResponse")
	proto.RegisterType((*UnloadTableRequest)(nil), "otsprotocol.UnloadTableRequest")
	proto.RegisterType((*UnloadTableResponse)(nil), "otsprotocol.UnloadTableResponse")
	proto.RegisterType((*TimeRange)(nil), "otsprotocol.TimeRange")
	proto.RegisterType((*ReturnContent)(nil), "otsprotocol.ReturnContent")
	proto.RegisterType((*GetRowRequest)(nil), "otsprotocol.GetRowRequest")
	proto.RegisterType((*GetRowResponse)(nil), "otsprotocol.GetRowResponse")
	proto.RegisterType((*UpdateRowRequest)(nil), "otsprotocol.UpdateRowRequest")
	proto.RegisterType((*UpdateRowResponse)(nil), "otsprotocol.UpdateRowResponse")
	proto.RegisterType((*PutRowRequest)(nil), "otsprotocol.PutRowRequest")
	proto.RegisterType((*PutRowResponse)(nil), "otsprotocol.PutRowResponse")
	proto.RegisterType((*DeleteRowRequest)(nil), "otsprotocol.DeleteRowRequest")
	proto.RegisterType((*DeleteRowResponse)(nil), "otsprotocol.DeleteRowResponse")
	proto.RegisterType((*TableInBatchGetRowRequest)(nil), "otsprotocol.TableInBatchGetRowRequest")
	proto.RegisterType((*BatchGetRowRequest)(nil), "otsprotocol.BatchGetRowRequest")
	proto.RegisterType((*RowInBatchGetRowResponse)(nil), "otsprotocol.RowInBatchGetRowResponse")
	proto.RegisterType((*TableInBatchGetRowResponse)(nil), "otsprotocol.TableInBatchGetRowResponse")
	proto.RegisterType((*BatchGetRowResponse)(nil), "otsprotocol.BatchGetRowResponse")
	proto.RegisterType((*RowInBatchWriteRowRequest)(nil), "otsprotocol.RowInBatchWriteRowRequest")
	proto.RegisterType((*TableInBatchWriteRowRequest)(nil), "otsprotocol.TableInBatchWriteRowRequest")
	proto.RegisterType((*BatchWriteRowRequest)(nil), "otsprotocol.BatchWriteRowRequest")
	proto.RegisterType((*RowInBatchWriteRowResponse)(nil), "otsprotocol.RowInBatchWriteRowResponse")
	proto.RegisterType((*TableInBatchWriteRowResponse)(nil), "otsprotocol.TableInBatchWriteRowResponse")
	proto.RegisterType((*BatchWriteRowResponse)(nil), "otsprotocol.BatchWriteRowResponse")
	proto.RegisterType((*GetRangeRequest)(nil), "otsprotocol.GetRangeRequest")
	proto.RegisterType((*GetRangeResponse)(nil), "otsprotocol.GetRangeResponse")
	proto.RegisterType((*ListStreamRequest)(nil), "otsprotocol.ListStreamRequest")
	proto.RegisterType((*Stream)(nil), "otsprotocol.Stream")
	proto.RegisterType((*ListStreamResponse)(nil), "otsprotocol.ListStreamResponse")
	proto.RegisterType((*StreamShard)(nil), "otsprotocol.StreamShard")
	proto.RegisterType((*DescribeStreamRequest)(nil), "otsprotocol.DescribeStreamRequest")
	proto.RegisterType((*DescribeStreamResponse)(nil), "otsprotocol.DescribeStreamResponse")
	proto.RegisterType((*GetShardIteratorRequest)(nil), "otsprotocol.GetShardIteratorRequest")
	proto.RegisterType((*GetShardIteratorResponse)(nil), "otsprotocol.GetShardIteratorResponse")
	proto.RegisterType((*GetStreamRecordRequest)(nil), "otsprotocol.GetStreamRecordRequest")
	proto.RegisterType((*GetStreamRecordResponse)(nil), "otsprotocol.GetStreamRecordResponse")
	proto.RegisterType((*GetStreamRecordResponse_StreamRecord)(nil), "otsprotocol.GetStreamRecordResponse.StreamRecord")
	proto.RegisterType((*ComputeSplitPointsBySizeRequest)(nil), "otsprotocol.ComputeSplitPointsBySizeRequest")
	proto.RegisterType((*ComputeSplitPointsBySizeResponse)(nil), "otsprotocol.ComputeSplitPointsBySizeResponse")
	proto.RegisterType((*ComputeSplitPointsBySizeResponse_SplitLocation)(nil), "otsprotocol.ComputeSplitPointsBySizeResponse.SplitLocation")
	proto.RegisterType((*DefinedColumnSchema)(nil), "otsprotocol.DefinedColumnSchema")
	proto.RegisterType((*IndexMeta)(nil), "otsprotocol.IndexMeta")
	proto.RegisterType((*CreateIndexRequest)(nil), "otsprotocol.CreateIndexRequest")
	proto.RegisterType((*CreateIndexResponse)(nil), "otsprotocol.CreateIndexResponse")
	proto.RegisterType((*DropIndexRequest)(nil), "otsprotocol.DropIndexRequest")
	proto.RegisterType((*DropIndexResponse)(nil), "otsprotocol.DropIndexResponse")
	proto.RegisterType((*StartLocalTransactionRequest)(nil), "otsprotocol.StartLocalTransactionRequest")
	proto.RegisterType((*StartLocalTransactionResponse)(nil), "otsprotocol.StartLocalTransactionResponse")
	proto.RegisterType((*CommitTransactionRequest)(nil), "otsprotocol.CommitTransactionRequest")
	proto.RegisterType((*CommitTransactionResponse)(nil), "otsprotocol.CommitTransactionResponse")
	proto.RegisterType((*AbortTransactionRequest)(nil), "otsprotocol.AbortTransactionRequest")
	proto.RegisterType((*AbortTransactionResponse)(nil), "otsprotocol.AbortTransactionResponse")
	proto.RegisterEnum("otsprotocol.PrimaryKeyType", PrimaryKeyType_name, PrimaryKeyType_value)
	proto.RegisterEnum("otsprotocol.PrimaryKeyOption", PrimaryKeyOption_name, PrimaryKeyOption_value)
	proto.RegisterEnum("otsprotocol.BloomFilterType", BloomFilterType_name, BloomFilterType_value)
	proto.RegisterEnum("otsprotocol.TableStatus", TableStatus_name, TableStatus_value)
	proto.RegisterEnum("otsprotocol.RowExistenceExpectation", RowExistenceExpectation_name, RowExistenceExpectation_value)
	proto.RegisterEnum("otsprotocol.ReturnType", ReturnType_name, ReturnType_value)
	proto.RegisterEnum("otsprotocol.OperationType", OperationType_name, OperationType_value)
	proto.RegisterEnum("otsprotocol.Direction", Direction_name, Direction_value)
	proto.RegisterEnum("otsprotocol.StreamStatus", StreamStatus_name, StreamStatus_value)
	proto.RegisterEnum("otsprotocol.ActionType", ActionType_name, ActionType_value)
	proto.RegisterEnum("otsprotocol.DefinedColumnType", DefinedColumnType_name, DefinedColumnType_value)
	proto.RegisterEnum("otsprotocol.IndexUpdateMode", IndexUpdateMode_name, IndexUpdateMode_value)
	proto.RegisterEnum("otsprotocol.IndexType", IndexType_name, IndexType_value)
}

func init() { proto.RegisterFile("table_store.proto", fileDescriptor2) }

var fileDescriptor2 = []byte{
	// 2751 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0xc4, 0x59, 0x5b, 0x6f, 0xe3, 0xc6,
	0xf5, 0x0f, 0x49, 0x5d, 0xac, 0xa3, 0x8b, 0x29, 0x6a, 0x6d, 0xcb, 0xf6, 0x26, 0x71, 0xf8, 0x4f,
	0x36, 0x5a, 0x65, 0xe3, 0x24, 0xfe, 0x27, 0xd9, 0x5c, 0x0a, 0x04, 0xb2, 0x24, 0xbb, 0xc2, 0xca,
	0x92, 0x23, 0xd3, 0x4d, 0xb6, 0x2f, 0x2c, 0x4d, 0xce, 0xda, 0xc4, 0x4a, 0xa4, 0x4a, 0x8e, 0xd6,
	0xf6, 0xbe, 0x16, 0x79, 0x2b, 0xd0, 0x0f, 0x50, 0xa0, 0xaf, 0x7d, 0x28, 0x50, 0xa0, 0x7d, 0x6a,
	0x3f, 0x40, 0x81, 0xbe, 0xe5, 0x3b, 0xf4, 0xad, 0x5f, 0xa2, 0x28, 0xe6, 0x42, 0x89, 0xa4, 0x28,
	0xcb, 0xbb, 0x49, 0xba, 0x6f, 0xe4, 0xcc, 0x9c, 0xdb, 0xef, 0x9c, 0x39, 0x73, 0xe6, 0x0c, 0x94,
	0xb1, 0x71, 0x36, 0x44, 0xba, 0x8f, 0x5d, 0x0f, 0xed, 0x8e, 0x3d, 0x17, 0xbb, 0x4a, 0xde, 0xc5,
	0x3e, 0xfd, 0x32, 0xdd, 0xa1, 0x7a, 0x0f, 0xd2, 0x6d, 0xcf, 0x73, 0x3d, 0xa5, 0x00, 0x29, 0xd3,
	0xb5, 0x50, 0x55, 0xd8, 0x11, 0x6b, 0x39, 0x65, 0x15, 0xb2, 0x23, 0xe4, 0xfb, 0xc6, 0x39, 0xaa,
	0x8a, 0x3b, 0x42, 0x2d, 0xa7, 0x3e, 0x07, 0xf9, 0xd8, 0xb3, 0x47, 0x86, 0x77, 0xfd, 0x08, 0x5d,
	0x9f, 0x98, 0x17, 0x68, 0x64, 0x10, 0x12, 0xc7, 0x18, 0x05, 0x24, 0xf7, 0x21, 0x85, 0xaf, 0xc7,
	0x64, 0xbd, 0x58, 0x2b, 0xed, 0x6d, 0xef, 0x86, 0xa4, 0xec, 0xce, 0x48, 0xb5, 0xeb, 0x31, 0x52,
	0xde, 0x87, 0x8c, 0x3b, 0xc6, 0xb6, 0xeb, 0x54, 0xa5, 0x1d, 0xa1, 0x56, 0xda, 0x7b, 0x7d, 0xc1,
	0xe2, 0x3e, 0x5d, 0xa4, 0x3e, 0x80, 0xd2, 0xb1, 0xe1, 0x61, 0x9b, 0xfc, 0x0c, 0x0c, 0xe7, 0x1c,
	0x29, 0x45, 0x48, 0x9f, 0xa1, 0x73, 0xdb, 0xa1, 0xa2, 0x0b, 0x4a, 0x1e, 0x24, 0xe4, 0x58, 0x54,
	0x72, 0x41, 0xfd, 0xb3, 0x00, 0x05, 0x8d, 0x18, 0xcd, 0xa8, 0x7d, 0xe5, 0x0e, 0x14, 0xb0, 0x3d,
	0x42, 0x3a, 0x76, 0xf5, 0xa1, 0xfd, 0x8c, 0xa8, 0x2b, 0xd4, 0xd2, 0x64, 0x74, 0x64, 0x5c, 0xe9,
	0xcf, 0x90, 0xe7, 0x93, 0x55, 0xd4, 0xcc, 0xb4, 0xf2, 0x10, 0xca, 0x67, 0x43, 0xd7, 0x1d, 0xe9,
	0x4f, 0xec, 0x21, 0x46, 0x9e, 0x4e, 0x2d, 0x62, 0x4a, 0xde, 0x8d, 0x28, 0xb9, 0x4f, 0x56, 0x1d,
	0xd0, 0x45, 0xd4, 0x24, 0x05, 0xe0, 0x6c, 0xe8, 0x9a, 0x4f, 0x75, 0xdf, 0x7e, 0x8e, 0xaa, 0x29,
	0xca, 0xec, 0x1d, 0x78, 0xdd, 0x42, 0xcf, 0x6c, 0x83, 0xa8, 0xa1, 0x9b, 0x68, 0x38, 0x0c, 0xa4,
	0xe9, 0xb6, 0xa3, 0xfb, 0xc8, 0xac, 0xa6, 0x77, 0x84, 0x9a, 0xa4, 0xfe, 0x5d, 0x80, 0x1c, 0x55,
	0xf8, 0x08, 0x61, 0x83, 0x30, 0x62, 0x2e, 0x0b, 0x41, 0xbb, 0x07, 0xf9, 0x31, 0x03, 0x45, 0x7f,
	0x8a, 0xae, 0xab, 0xe2, 0x8e, 0x54, 0xcb, 0x2f, 0x04, 0x8d, 0x3b, 0xe7, 0x33, 0x28, 0x59, 0xe8,
	0x89, 0xed, 0x20, 0x4b, 0x37, 0xdd, 0xe1, 0x64, 0x44, 0xb0, 0x26, 0x64, 0x3b, 0x11, 0xb2, 0x16,
	0x5b, 0xd2, 0xa4, 0x2b, 0x38, 0x65, 0x1d, 0xc0, 0x76, 0x2c, 0x74, 0xa5, 0x8f, 0x10, 0x36, 0xaa,
	0x29, 0x4a, 0xb5, 0x1e, 0xa1, 0xea, 0x90, 0x69, 0xa2, 0xad, 0x7a, 0x06, 0xb9, 0xa6, 0xeb, 0x58,
	0xd4, 0x35, 0xca, 0x97, 0x50, 0xf4, 0xdc, 0x4b, 0x1d, 0x5d, 0xd9, 0x3e, 0x46, 0x8e, 0xc9, 0xb4,
	0x2f, 0xed, 0xbd, 0x1d, 0xa1, 0x1d, 0xb8, 0x97, 0xed, 0x60, 0x41, 0xfb, 0x6a, 0x8c, 0x4c, 0x4c,
	0xf1, 0x51, 0xaa, 0x20, 0x33, 0x3d, 0x75, 0x33, 0x60, 0x48, 0x7d, 0x52, 0x50, 0xdf, 0x83, 0x42,
	0xd3, 0x18, 0x1b, 0xa6, 0x8d, 0xaf, 0x4f, 0x1d, 0x1b, 0x93, 0xb0, 0xf3, 0x90, 0x61, 0x71, 0x3f,
	0x16, 0x21, 0x7d, 0xe9, 0xd9, 0x98, 0xc5, 0x69, 0x5a, 0xfd, 0x4e, 0x80, 0xcd, 0x01, 0xf2, 0x91,
	0xf7, 0x0c, 0x59, 0xda, 0x85, 0xe7, 0x4e, 0xce, 0x2f, 0xc6, 0x13, 0xdc, 0x42, 0xd8, 0xb0, 0x87,
	0xbe, 0xf2, 0x21, 0x14, 0x4d, 0xce, 0x4a, 0x9f, 0x38, 0x36, 0xa6, 0x1a, 0xe6, 0xf7, 0x36, 0x23,
	0x1a, 0x46, 0x84, 0x6d, 0x81, 0x32, 0x34, 0x7c, 0xac, 0xdb, 0x8e, 0xe9, 0x21, 0xc3, 0x47, 0x3a,
	0x09, 0x25, 0x1a, 0x69, 0xd2, 0x74, 0xce, 0x42, 0xe1, 0x39, 0x89, 0x3a, 0xf5, 0x00, 0x94, 0x79,
	0x35, 0x5e, 0x5c, 0xbe, 0xda, 0x02, 0xb9, 0xe9, 0x3a, 0xfe, 0x64, 0x84, 0xac, 0x60, 0xfc, 0x25,
	0xb8, 0xb4, 0xa1, 0x72, 0x82, 0x3d, 0x64, 0x8c, 0x4e, 0xc6, 0xc8, 0xb4, 0x9f, 0xd8, 0x26, 0xc3,
	0x7c, 0x0d, 0x8a, 0xc8, 0xe1, 0xf9, 0x81, 0xcc, 0x52, 0x46, 0x2b, 0xca, 0x06, 0xac, 0xa2, 0xab,
	0xb1, 0xed, 0xb1, 0xc0, 0xe5, 0x06, 0x13, 0x70, 0x87, 0x50, 0x64, 0x6c, 0x02, 0x3c, 0x17, 0x30,
	0x28, 0x43, 0x8e, 0xfd, 0xeb, 0xb6, 0xc5, 0xf2, 0x47, 0x12, 0x4f, 0x89, 0xfa, 0xaf, 0x0a, 0x32,
	0x05, 0x91, 0xf3, 0xa1, 0x33, 0x29, 0x0a, 0xe1, 0x3f, 0x44, 0x50, 0x9a, 0x1e, 0x32, 0x30, 0xa2,
	0xbb, 0x63, 0x80, 0x7e, 0x3d, 0x41, 0x3e, 0x26, 0xe1, 0xc9, 0x36, 0x08, 0x0d, 0x4f, 0x66, 0x7a,
	0x34, 0x3c, 0x67, 0x9b, 0xe9, 0x67, 0x50, 0xf1, 0xb8, 0x17, 0x74, 0x3c, 0x75, 0x03, 0x75, 0x5f,
	0x7e, 0xef, 0xcd, 0x68, 0x5c, 0x26, 0x7a, 0x8b, 0x49, 0x62, 0xc9, 0xca, 0xa7, 0x1a, 0xc7, 0x71,
	0x8e, 0xa4, 0x9a, 0x0f, 0x00, 0xc6, 0x41, 0xa6, 0xf2, 0xf9, 0xd6, 0x89, 0x65, 0xc2, 0x68, 0x22,
	0xfb, 0x04, 0xf2, 0x1c, 0x29, 0x7f, 0xcc, 0x13, 0x42, 0x7c, 0x8b, 0x26, 0x39, 0xee, 0x3d, 0xc8,
	0xcf, 0xb6, 0xa8, 0x5f, 0xcd, 0xde, 0xb8, 0x47, 0xd7, 0xa0, 0x12, 0x81, 0xd1, 0x1f, 0xbb, 0x8e,
	0x8f, 0xd4, 0xef, 0x05, 0x50, 0x4e, 0xc7, 0x56, 0x1c, 0xde, 0xa4, 0xfc, 0xb3, 0x10, 0x46, 0xe1,
	0xa7, 0x81, 0x31, 0x86, 0x4a, 0xea, 0x76, 0xa8, 0xa8, 0xff, 0x14, 0xa0, 0x12, 0xb1, 0x88, 0x59,
	0xaa, 0x3c, 0x82, 0xed, 0x04, 0xf5, 0x75, 0x8b, 0x05, 0x31, 0x0f, 0xa1, 0x7b, 0x4b, 0xcc, 0x08,
	0xa5, 0x90, 0xa8, 0x35, 0x62, 0xc2, 0xe6, 0x8b, 0x58, 0xb3, 0x07, 0x25, 0x6e, 0x4d, 0x20, 0x91,
	0x01, 0xb0, 0x95, 0x60, 0x10, 0x97, 0xa2, 0xd6, 0xe1, 0x4e, 0x0b, 0xf9, 0xa6, 0x67, 0x9f, 0x2d,
	0xf5, 0x8e, 0xfa, 0x6f, 0x11, 0xd6, 0x62, 0x8b, 0xb9, 0xe1, 0x2f, 0xb2, 0x55, 0x96, 0x80, 0x24,
	0xfe, 0x30, 0x90, 0xa4, 0x65, 0x20, 0xed, 0x42, 0x21, 0xa8, 0x54, 0x0c, 0x3c, 0x21, 0x7b, 0x87,
	0x1c, 0x1d, 0xd5, 0x79, 0x82, 0x13, 0x3a, 0x9f, 0x00, 0x6a, 0x7a, 0x19, 0xa8, 0xe4, 0xc8, 0xf7,
	0x2f, 0x0c, 0xcf, 0xd2, 0xfd, 0xf1, 0xd0, 0xc6, 0x7e, 0x35, 0xb3, 0x23, 0xd5, 0x0a, 0xf1, 0xbd,
	0xb4, 0x72, 0xe3, 0x5e, 0x52, 0x40, 0xee, 0xda, 0x3e, 0x0e, 0xfb, 0x44, 0xad, 0x41, 0x39, 0x34,
	0xc6, 0xa1, 0xaf, 0x40, 0x7e, 0xe6, 0x28, 0x12, 0x63, 0x52, 0x2d, 0xa7, 0xd6, 0x40, 0x69, 0xa1,
	0x21, 0x5a, 0xbe, 0xe3, 0xc8, 0x9e, 0x8d, 0xac, 0xe4, 0x7b, 0xf6, 0x1e, 0xc8, 0x5d, 0xd7, 0xb0,
	0x96, 0x92, 0x57, 0xa0, 0x1c, 0x5a, 0xc7, 0x89, 0x6b, 0xa0, 0x9c, 0x3a, 0xc3, 0xdb, 0x90, 0xaf,
	0x41, 0x25, 0xb2, 0x92, 0x33, 0xf8, 0x39, 0xe4, 0x34, 0x7b, 0x84, 0x58, 0xe6, 0x52, 0x00, 0x7c,
	0x6c, 0x78, 0x98, 0x65, 0x6c, 0x72, 0x16, 0x4b, 0x8a, 0x0c, 0x2b, 0xc8, 0xb1, 0x66, 0x27, 0x86,
	0x44, 0x0e, 0x08, 0x9f, 0xef, 0xd1, 0xf0, 0xe9, 0xf8, 0x4b, 0x28, 0x0e, 0x10, 0x9e, 0x78, 0x4e,
	0xd3, 0x75, 0x30, 0x72, 0xb0, 0xf2, 0x00, 0xf2, 0x1e, 0x1d, 0x60, 0x15, 0x97, 0x40, 0x2b, 0xae,
	0x8d, 0x58, 0xb4, 0x91, 0x79, 0x5a, 0x6c, 0x6d, 0x93, 0x7c, 0x44, 0x57, 0xf3, 0x92, 0x81, 0x81,
	0x2c, 0x52, 0x90, 0x7f, 0x27, 0x42, 0xf1, 0x10, 0xe1, 0x81, 0x7b, 0x79, 0x53, 0x4a, 0xab, 0xc4,
	0x4b, 0x2a, 0x52, 0x47, 0xae, 0x43, 0x89, 0x31, 0xf4, 0x49, 0xb1, 0x78, 0x8e, 0x30, 0xad, 0x99,
	0x72, 0x74, 0x1f, 0x91, 0x0a, 0xd2, 0x23, 0x96, 0xf3, 0x74, 0x14, 0xdb, 0x47, 0x53, 0x5c, 0xe2,
	0x75, 0x65, 0x9a, 0x9e, 0x72, 0x5b, 0x50, 0x30, 0x0d, 0xf3, 0x02, 0xe9, 0xb4, 0x48, 0x24, 0xa1,
	0x27, 0xd4, 0x56, 0xbe, 0x48, 0x61, 0x6f, 0x82, 0x94, 0x12, 0x64, 0x58, 0xb5, 0x59, 0xcd, 0x92,
	0x7a, 0x87, 0x86, 0x29, 0x45, 0x96, 0xd7, 0x6d, 0x2b, 0xf4, 0x00, 0x55, 0x00, 0x08, 0xb6, 0x7c,
	0x2c, 0x47, 0xc7, 0x8a, 0x90, 0xc6, 0xee, 0x53, 0xe4, 0x54, 0x81, 0x12, 0xae, 0x43, 0x09, 0x7b,
	0x86, 0xe3, 0x1b, 0x26, 0x3d, 0x64, 0x6d, 0xab, 0x9a, 0xa7, 0xb5, 0xfb, 0x19, 0x94, 0x02, 0x40,
	0x78, 0x74, 0x7e, 0x00, 0x2b, 0x26, 0xaf, 0x2a, 0x78, 0x5a, 0x88, 0x56, 0x93, 0x73, 0x25, 0x47,
	0x1e, 0x24, 0xcf, 0xbd, 0xe4, 0x30, 0x29, 0x00, 0x0e, 0xba, 0xc2, 0x3a, 0x93, 0x2d, 0xd1, 0x22,
	0xed, 0x2f, 0x02, 0xc8, 0x2c, 0xf7, 0x2e, 0x01, 0x5e, 0x01, 0x20, 0x45, 0xa2, 0x79, 0x41, 0xb1,
	0x64, 0x0c, 0xef, 0x43, 0x6e, 0x56, 0xf4, 0x49, 0x09, 0x69, 0x6a, 0x56, 0x63, 0xee, 0x41, 0x69,
	0xea, 0x7a, 0x1a, 0x3a, 0xdc, 0x1d, 0x5b, 0x09, 0xb1, 0x12, 0x04, 0xd7, 0x3c, 0x2e, 0x69, 0x8a,
	0xcb, 0xd7, 0x50, 0x0e, 0xa9, 0xfc, 0x83, 0xa1, 0x21, 0x30, 0xfc, 0x51, 0x80, 0xe2, 0xf1, 0x64,
	0x59, 0xf0, 0x45, 0xd0, 0x7c, 0x45, 0xc6, 0xf7, 0xa0, 0x14, 0x28, 0xfa, 0xa3, 0x58, 0xfe, 0x57,
	0x01, 0x64, 0x96, 0xb2, 0x5e, 0x66, 0xe7, 0xbd, 0xba, 0x08, 0x08, 0xe9, 0xfc, 0xa3, 0xe0, 0xf0,
	0x1b, 0x11, 0x36, 0x69, 0xda, 0xec, 0x38, 0xfb, 0x06, 0x36, 0x2f, 0x5e, 0x22, 0x15, 0x91, 0x53,
	0x69, 0xba, 0xb5, 0x25, 0xfa, 0x3b, 0x9f, 0x99, 0x52, 0x09, 0x99, 0x29, 0xfd, 0x42, 0x99, 0x29,
	0x93, 0x98, 0x99, 0xb2, 0x89, 0x99, 0x69, 0x25, 0x31, 0x33, 0xe5, 0x12, 0x32, 0x13, 0x50, 0x60,
	0xbb, 0xa0, 0x24, 0x58, 0xff, 0x29, 0x64, 0xa8, 0xf5, 0xec, 0x3c, 0x8c, 0x97, 0x13, 0x0b, 0x51,
	0x53, 0xff, 0x20, 0x40, 0x75, 0xe0, 0x5e, 0xc6, 0xe6, 0xb8, 0xbb, 0x8a, 0x90, 0xb6, 0x7d, 0xdd,
	0x7d, 0xca, 0xef, 0x1e, 0x6f, 0x41, 0x1a, 0x79, 0x9e, 0xeb, 0xf1, 0xea, 0x54, 0x89, 0x88, 0x60,
	0xad, 0x8e, 0xb0, 0x83, 0x59, 0x29, 0x76, 0x3b, 0x07, 0xa7, 0x28, 0x08, 0xd1, 0xec, 0x97, 0xa6,
	0x4e, 0x47, 0xb0, 0x95, 0xa4, 0x3d, 0xd7, 0x30, 0xc9, 0xe9, 0xff, 0x0f, 0x29, 0xcf, 0xbd, 0xf4,
	0xf9, 0x5d, 0xfe, 0x9d, 0xf8, 0x15, 0x39, 0x91, 0x91, 0xda, 0x83, 0x4a, 0x12, 0xff, 0x87, 0x31,
	0x58, 0xdf, 0x5d, 0x0a, 0x2b, 0xe7, 0xf7, 0x37, 0x72, 0x59, 0x9e, 0x0a, 0xfb, 0x86, 0x5c, 0xa3,
	0x43, 0xde, 0xaa, 0xf1, 0x86, 0x0e, 0xbb, 0xc5, 0x47, 0xb7, 0x57, 0x7f, 0x8c, 0xd8, 0x55, 0x2e,
	0x68, 0x7e, 0xfc, 0x8f, 0x73, 0xba, 0x7a, 0x0e, 0xdb, 0x61, 0xc3, 0xe2, 0xba, 0x27, 0x41, 0xfe,
	0x71, 0x04, 0xf2, 0x7b, 0x0b, 0x20, 0x8f, 0x71, 0x52, 0x2f, 0xe0, 0x4e, 0xa2, 0x84, 0xcf, 0x62,
	0xa0, 0xd7, 0x16, 0x82, 0x1e, 0xa7, 0x9c, 0x4f, 0x46, 0xac, 0xc5, 0xf6, 0x5b, 0x01, 0xb6, 0x92,
	0xf4, 0x78, 0x35, 0x71, 0xae, 0xda, 0x70, 0x37, 0xd9, 0x8a, 0x1b, 0xa2, 0xfa, 0x93, 0x08, 0xc4,
	0xef, 0x2e, 0x85, 0x98, 0xc7, 0xe1, 0x00, 0xd6, 0x92, 0x65, 0x7c, 0x1e, 0x03, 0xf9, 0xfe, 0x2d,
	0x40, 0xe6, 0x3c, 0xff, 0x23, 0xc2, 0x2a, 0x09, 0x77, 0x12, 0x92, 0x37, 0x45, 0xc5, 0x7d, 0xc8,
	0x59, 0xb6, 0x87, 0x4c, 0xde, 0x70, 0x22, 0xa1, 0x1e, 0x8d, 0xd3, 0x56, 0x30, 0xfb, 0x13, 0x96,
	0x87, 0x45, 0x48, 0x0f, 0xed, 0x91, 0x8d, 0x79, 0x4e, 0xfe, 0x3f, 0xd8, 0xb6, 0x1d, 0x73, 0x38,
	0xf1, 0xed, 0x67, 0xf4, 0x42, 0xe4, 0x61, 0x3d, 0x7c, 0x42, 0x64, 0xe9, 0x06, 0x7b, 0x0b, 0x36,
	0xd1, 0x55, 0xb0, 0x88, 0x24, 0xe0, 0xf0, 0x92, 0x15, 0xba, 0x24, 0x9e, 0xdb, 0x73, 0x89, 0xb9,
	0x1d, 0x12, 0x73, 0x7b, 0x3e, 0x21, 0xb7, 0x17, 0xa2, 0x55, 0x67, 0x71, 0x41, 0xd5, 0x59, 0xa2,
	0xe1, 0xfc, 0x9d, 0x00, 0xf2, 0xcc, 0x01, 0x2f, 0x7b, 0xb6, 0x16, 0xa6, 0x11, 0x45, 0x0c, 0x7a,
	0x03, 0xd6, 0x69, 0xee, 0x9d, 0xc7, 0x44, 0x4a, 0xc8, 0xcd, 0x2c, 0x8e, 0xdf, 0x65, 0xd7, 0x33,
	0x76, 0x15, 0x5c, 0x14, 0x09, 0x44, 0xe1, 0x03, 0xc8, 0xb0, 0x45, 0xd1, 0xfe, 0xd5, 0xb4, 0x6c,
	0x0d, 0x11, 0x88, 0x74, 0x6c, 0x0d, 0x8a, 0xa6, 0x87, 0x22, 0x1d, 0x2d, 0xb1, 0x26, 0xa9, 0x5f,
	0x80, 0x12, 0x16, 0xc8, 0x2d, 0x7f, 0x1b, 0xb2, 0x8c, 0x67, 0x10, 0xcb, 0x95, 0x84, 0x9b, 0xaa,
	0x7a, 0x04, 0x79, 0xde, 0xd9, 0x20, 0x17, 0x55, 0x72, 0xa1, 0x62, 0x37, 0xd6, 0xa9, 0x1e, 0x65,
	0xc8, 0x8d, 0x0d, 0x0f, 0x39, 0x78, 0xd6, 0x5a, 0xdb, 0x84, 0x32, 0x1f, 0xf2, 0xed, 0xb3, 0xa1,
	0xed, 0x9c, 0x93, 0x29, 0x89, 0x9a, 0x64, 0xcc, 0x3a, 0x03, 0x51, 0xfb, 0x13, 0x2c, 0xdc, 0x81,
	0x6a, 0x3c, 0xe8, 0xa6, 0xb2, 0x99, 0xa0, 0x0a, 0xe4, 0xd9, 0x08, 0x8b, 0x55, 0xda, 0xbf, 0x53,
	0xff, 0x25, 0xc0, 0x7a, 0x5c, 0x06, 0x37, 0x39, 0x41, 0x48, 0x62, 0x6b, 0x51, 0xac, 0xa5, 0x63,
	0xf8, 0x4a, 0xc9, 0xf8, 0xa6, 0x68, 0xdb, 0xf5, 0x43, 0x28, 0x06, 0xdd, 0x21, 0xd6, 0x2b, 0x48,
	0xd3, 0x5d, 0xbb, 0x99, 0xd4, 0x1f, 0x62, 0xcd, 0x82, 0x1a, 0x64, 0xa8, 0xe2, 0xec, 0xca, 0x9f,
	0x8f, 0xb5, 0x15, 0xc2, 0x80, 0xaf, 0x41, 0x91, 0x05, 0x58, 0x60, 0x79, 0x96, 0xe2, 0xf8, 0x2b,
	0xd8, 0x38, 0x44, 0x98, 0x2e, 0xe9, 0x60, 0x72, 0xf2, 0xb9, 0xde, 0x0d, 0x48, 0x86, 0xbd, 0x26,
	0x06, 0x5e, 0x23, 0x06, 0xf8, 0xd8, 0x18, 0x8d, 0xd9, 0x15, 0x78, 0xb6, 0x8b, 0x52, 0x3c, 0xf8,
	0xaa, 0xf3, 0x12, 0x38, 0x8e, 0xeb, 0x50, 0xe2, 0xfc, 0xf8, 0xcc, 0x2c, 0x26, 0x43, 0xd1, 0xce,
	0x0e, 0x91, 0xaf, 0x60, 0x9d, 0xf0, 0xe1, 0x8e, 0x30, 0x5d, 0xcf, 0x0a, 0x1d, 0x3b, 0x89, 0x5c,
	0xa6, 0xb9, 0x87, 0xf5, 0x78, 0xbf, 0x17, 0x98, 0xad, 0x11, 0x0e, 0x5c, 0x91, 0xce, 0xb4, 0xe9,
	0xe2, 0xd1, 0x89, 0x20, 0x94, 0x3f, 0x8a, 0xe0, 0xb9, 0x80, 0x7a, 0x37, 0x3c, 0x48, 0xae, 0xf0,
	0x61, 0xa0, 0x03, 0x95, 0xa8, 0x11, 0x5b, 0x5d, 0x28, 0x44, 0x16, 0x3f, 0x80, 0x3c, 0xcf, 0x2e,
	0xa1, 0x82, 0x24, 0xda, 0x1d, 0x68, 0x98, 0xd3, 0x6a, 0xa4, 0x04, 0x19, 0xa6, 0x1e, 0x7f, 0x10,
	0xea, 0xc0, 0x9b, 0x4d, 0x77, 0x34, 0x9e, 0x60, 0x74, 0x32, 0x1e, 0xda, 0xf8, 0xd8, 0xb5, 0x1d,
	0xec, 0xef, 0x5f, 0x9f, 0xd8, 0xcf, 0xd1, 0x92, 0x8b, 0x2a, 0xed, 0x13, 0xb1, 0x17, 0x1d, 0xda,
	0xf1, 0x57, 0x7f, 0x2f, 0xc2, 0xce, 0x62, 0x5e, 0x2f, 0x9b, 0xe3, 0xde, 0x87, 0x8c, 0x4f, 0x9f,
	0x5e, 0x6e, 0xf7, 0xb2, 0x43, 0x32, 0x35, 0x55, 0x6c, 0x4c, 0xa5, 0xf3, 0x1b, 0x42, 0x0f, 0x72,
	0x43, 0x97, 0x35, 0x42, 0x83, 0xce, 0xf3, 0x97, 0x31, 0xb1, 0x37, 0xeb, 0xbd, 0x4b, 0x67, 0xba,
	0x9c, 0xc7, 0xd6, 0x47, 0x50, 0x8c, 0x0c, 0x90, 0xa8, 0x0e, 0x04, 0x70, 0x84, 0x28, 0xd0, 0x63,
	0x64, 0xb0, 0x86, 0xba, 0xa2, 0x7e, 0x0d, 0x95, 0xa4, 0xf7, 0xa4, 0xe8, 0x33, 0xe1, 0x83, 0xc8,
	0x33, 0xe1, 0x1b, 0x8b, 0x5f, 0xa3, 0x88, 0x2f, 0xd5, 0x3f, 0x09, 0x90, 0x9b, 0x76, 0xdf, 0x62,
	0x9c, 0x12, 0xee, 0x4d, 0x39, 0x12, 0xe5, 0x09, 0xcf, 0x5e, 0x39, 0xe5, 0x21, 0x94, 0x59, 0x97,
	0x6f, 0x42, 0x6f, 0xfc, 0xfa, 0xc8, 0xb5, 0x10, 0x6f, 0x32, 0xde, 0x9d, 0xef, 0xf5, 0xb1, 0xb6,
	0xc0, 0x91, 0x6b, 0xa1, 0xd9, 0x6b, 0x18, 0xd5, 0x3a, 0x9d, 0x50, 0x20, 0x50, 0x0a, 0xaa, 0x2d,
	0x0e, 0x1e, 0x2c, 0xe8, 0x50, 0x10, 0x5c, 0x1b, 0xb0, 0x3a, 0x32, 0x6c, 0x47, 0x9f, 0x8b, 0xb0,
	0xe8, 0x43, 0x9b, 0x98, 0x50, 0x23, 0xcf, 0x4c, 0xdf, 0x24, 0xfa, 0x9b, 0xc3, 0x89, 0x85, 0xf4,
	0x33, 0xc3, 0x47, 0xba, 0x65, 0x60, 0x83, 0x66, 0x92, 0x95, 0x59, 0x7f, 0x9f, 0x4b, 0xe5, 0x05,
	0xd0, 0x57, 0x20, 0xb7, 0x3c, 0x77, 0x7c, 0x3b, 0x55, 0x94, 0x40, 0x95, 0xd9, 0xf1, 0xa6, 0x56,
	0xa0, 0x1c, 0x62, 0x30, 0xe5, 0x7a, 0xf7, 0x84, 0x9c, 0x0d, 0x24, 0x2c, 0x86, 0xda, 0xec, 0xdc,
	0x5f, 0xd2, 0xee, 0x98, 0xde, 0xf4, 0xd5, 0x87, 0xf0, 0xfa, 0x02, 0x06, 0xb3, 0x6c, 0x17, 0xab,
	0x27, 0x58, 0x53, 0x72, 0x0f, 0xaa, 0x4d, 0x77, 0x34, 0xb2, 0x71, 0x82, 0xd4, 0x45, 0x34, 0xdb,
	0xb0, 0x99, 0x40, 0xc3, 0x4d, 0xf9, 0x08, 0x36, 0x1a, 0x67, 0xae, 0xf7, 0x22, 0xfc, 0xb6, 0xa0,
	0x3a, 0x4f, 0xc2, 0xd8, 0xd5, 0x3f, 0x81, 0x52, 0xec, 0x99, 0x3b, 0x0f, 0xd9, 0x4e, 0x4f, 0x6b,
	0x1f, 0xb6, 0x07, 0xb2, 0xa0, 0x00, 0x64, 0x4e, 0xb4, 0x41, 0xa7, 0x77, 0x28, 0x8b, 0xe4, 0x7b,
	0xbf, 0xd3, 0x6b, 0x0c, 0x1e, 0xcb, 0x52, 0xfd, 0x5e, 0xf8, 0x61, 0x9d, 0x75, 0xc3, 0x15, 0x05,
	0x4a, 0x8d, 0x53, 0xad, 0xaf, 0x77, 0x7a, 0xcd, 0x41, 0xfb, 0xa8, 0xdd, 0xd3, 0x64, 0xa1, 0xbe,
	0x0b, 0xab, 0xf1, 0x37, 0xe7, 0x15, 0x48, 0xf5, 0xfa, 0xbd, 0xb6, 0x2c, 0x90, 0xaf, 0x66, 0xbb,
	0xdb, 0x95, 0x45, 0x25, 0x0b, 0xd2, 0xa0, 0xff, 0x8d, 0x2c, 0xd5, 0xbf, 0x86, 0x7c, 0xb8, 0x5f,
	0x0e, 0x90, 0x69, 0x34, 0xb5, 0xce, 0x2f, 0xc8, 0xea, 0x02, 0xac, 0x74, 0x7a, 0xfc, 0x4f, 0x24,
	0x5a, 0x76, 0xfb, 0x8d, 0x16, 0xd1, 0x8c, 0x9c, 0x4a, 0xb9, 0xd3, 0x5e, 0xf0, 0x9b, 0x22, 0x2b,
	0x4f, 0x8f, 0x5b, 0x0d, 0x8d, 0xfc, 0xa5, 0xeb, 0x47, 0xb0, 0xb1, 0xe8, 0xf5, 0x16, 0x20, 0xd3,
	0x39, 0xec, 0xf5, 0x07, 0x6d, 0xf9, 0x35, 0x45, 0x86, 0x42, 0xfb, 0xdb, 0xe3, 0x76, 0x53, 0xd3,
	0xdb, 0xdf, 0x76, 0x4e, 0x34, 0x59, 0x50, 0xee, 0x80, 0xcc, 0x47, 0x7a, 0xfd, 0x60, 0x54, 0xac,
	0x7f, 0x0e, 0x10, 0xea, 0xe9, 0xe6, 0x21, 0x3b, 0x20, 0xf3, 0x3d, 0xc2, 0x22, 0x07, 0xe9, 0x81,
	0xa6, 0x1f, 0x3f, 0x92, 0x05, 0xa5, 0x02, 0xab, 0x03, 0x4d, 0x6f, 0x1c, 0x68, 0xed, 0x81, 0x7e,
	0xd4, 0x6f, 0x75, 0x0e, 0x1e, 0xcb, 0x62, 0xfd, 0x43, 0x28, 0x46, 0x6f, 0xa0, 0x59, 0x90, 0x8e,
	0x4f, 0x35, 0x06, 0x33, 0xd5, 0xb8, 0xcd, 0x60, 0x6e, 0xb5, 0xbb, 0x6d, 0xad, 0x4d, 0x61, 0xce,
	0xcd, 0x0a, 0xf9, 0x3c, 0x64, 0x0f, 0xfa, 0x83, 0x6f, 0x1a, 0x83, 0x96, 0xfc, 0x1a, 0xb1, 0x71,
	0xbf, 0xd1, 0x7c, 0x44, 0xff, 0x84, 0xfa, 0xa7, 0xc1, 0xd1, 0xc3, 0x71, 0xab, 0xc0, 0xea, 0x89,
	0x36, 0x68, 0x37, 0x8e, 0xf4, 0x76, 0xaf, 0xb1, 0xdf, 0x25, 0x40, 0x08, 0x4a, 0x19, 0x8a, 0x7c,
	0x30, 0x40, 0x91, 0x18, 0x13, 0x3a, 0x82, 0xf2, 0x90, 0x3d, 0x3e, 0xd5, 0x74, 0xe2, 0x09, 0x41,
	0x29, 0x01, 0x30, 0x95, 0xe8, 0xbf, 0x48, 0xfe, 0x99, 0x5a, 0x3a, 0xf3, 0x94, 0x09, 0xe5, 0xb9,
	0xc4, 0xa7, 0xac, 0x42, 0xbe, 0xd5, 0xd4, 0xf4, 0x59, 0xfc, 0x10, 0xaa, 0xa6, 0xa6, 0xb7, 0xfa,
	0xa7, 0xfb, 0x5d, 0x62, 0x1c, 0x5f, 0xb0, 0xdf, 0xef, 0x77, 0xdb, 0x8d, 0x9e, 0x2c, 0x05, 0x0b,
	0x78, 0x90, 0x51, 0xdf, 0xd1, 0x05, 0xdd, 0xfe, 0xbe, 0x9c, 0xad, 0x7f, 0x01, 0xab, 0xf1, 0xcc,
	0x56, 0x81, 0xd5, 0xce, 0xe9, 0x91, 0xde, 0x38, 0x79, 0xdc, 0x6b, 0xea, 0x9d, 0x5e, 0xab, 0xfd,
	0xad, 0xfc, 0x1a, 0x09, 0x3d, 0x32, 0x18, 0x1a, 0x13, 0xea, 0x1f, 0xf3, 0x1c, 0x4c, 0x15, 0x23,
	0x54, 0x9a, 0x7e, 0xd8, 0xed, 0xef, 0x37, 0xba, 0x11, 0x2a, 0x4d, 0xef, 0xf6, 0x9b, 0xd3, 0x31,
	0xe1, 0xbf, 0x01, 0x00, 0x00, 0xff, 0xff, 0x9a, 0x12, 0x13, 0xc3, 0x7a, 0x22, 0x00, 0x00,
}
