/* AppListRow.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from AppListRow.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-2.0-or-later
 * SPDX-FileCopyrightText: 2019-2025 elementary, Inc. (https://elementary.io)
 */

#include "slingshot.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gdesktopappinfo.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SLINGSHOT_APP_LIST_ROW_0_PROPERTY,
	SLINGSHOT_APP_LIST_ROW_APP_PROPERTY,
	SLINGSHOT_APP_LIST_ROW_APP_ID_PROPERTY,
	SLINGSHOT_APP_LIST_ROW_DESKTOP_PATH_PROPERTY,
	SLINGSHOT_APP_LIST_ROW_APP_INFO_PROPERTY,
	SLINGSHOT_APP_LIST_ROW_NUM_PROPERTIES
};
static GParamSpec* slingshot_app_list_row_properties[SLINGSHOT_APP_LIST_ROW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _SlingshotAppListRowPrivate {
	SlingshotBackendApp* _app;
	gchar* _app_id;
	gchar* _desktop_path;
	GDesktopAppInfo* _app_info;
};

static gint SlingshotAppListRow_private_offset;
static gpointer slingshot_app_list_row_parent_class = NULL;

static void slingshot_app_list_row_set_app_info (SlingshotAppListRow* self,
                                          GDesktopAppInfo* value);
static GObject * slingshot_app_list_row_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
static void slingshot_app_list_row_finalize (GObject * obj);
static GType slingshot_app_list_row_get_type_once (void);
static void _vala_slingshot_app_list_row_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_slingshot_app_list_row_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);

static inline gpointer
slingshot_app_list_row_get_instance_private (SlingshotAppListRow* self)
{
	return G_STRUCT_MEMBER_P (self, SlingshotAppListRow_private_offset);
}

SlingshotAppListRow*
slingshot_app_list_row_construct (GType object_type,
                                  SlingshotBackendApp* app)
{
	SlingshotAppListRow * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_val_if_fail (app != NULL, NULL);
	_tmp0_ = slingshot_backend_app_get_desktop_id (app);
	_tmp1_ = _tmp0_;
	_tmp2_ = slingshot_backend_app_get_desktop_path (app);
	_tmp3_ = _tmp2_;
	self = (SlingshotAppListRow*) g_object_new (object_type, "app", app, "app-id", _tmp1_, "desktop-path", _tmp3_, NULL);
	return self;
}

SlingshotAppListRow*
slingshot_app_list_row_new (SlingshotBackendApp* app)
{
	return slingshot_app_list_row_construct (SLINGSHOT_TYPE_APP_LIST_ROW, app);
}

void
slingshot_app_list_row_launch (SlingshotAppListRow* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GDesktopAppInfo* _tmp0_;
		_tmp0_ = self->priv->_app_info;
		g_app_info_launch ((GAppInfo*) _tmp0_, NULL, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = _error_;
		_tmp2_ = _tmp1_->message;
		g_critical ("AppListRow.vala:56: %s", _tmp2_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

SlingshotBackendApp*
slingshot_app_list_row_get_app (SlingshotAppListRow* self)
{
	SlingshotBackendApp* result;
	SlingshotBackendApp* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_app;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
slingshot_app_list_row_set_app (SlingshotAppListRow* self,
                                SlingshotBackendApp* value)
{
	SlingshotBackendApp* old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_app_list_row_get_app (self);
	if (old_value != value) {
		SlingshotBackendApp* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_app);
		self->priv->_app = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, slingshot_app_list_row_properties[SLINGSHOT_APP_LIST_ROW_APP_PROPERTY]);
	}
}

const gchar*
slingshot_app_list_row_get_app_id (SlingshotAppListRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_app_id;
	result = _tmp0_;
	return result;
}

static void
slingshot_app_list_row_set_app_id (SlingshotAppListRow* self,
                                   const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_app_list_row_get_app_id (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_app_id);
		self->priv->_app_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, slingshot_app_list_row_properties[SLINGSHOT_APP_LIST_ROW_APP_ID_PROPERTY]);
	}
}

const gchar*
slingshot_app_list_row_get_desktop_path (SlingshotAppListRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_desktop_path;
	result = _tmp0_;
	return result;
}

static void
slingshot_app_list_row_set_desktop_path (SlingshotAppListRow* self,
                                         const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_app_list_row_get_desktop_path (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_desktop_path);
		self->priv->_desktop_path = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, slingshot_app_list_row_properties[SLINGSHOT_APP_LIST_ROW_DESKTOP_PATH_PROPERTY]);
	}
}

GDesktopAppInfo*
slingshot_app_list_row_get_app_info (SlingshotAppListRow* self)
{
	GDesktopAppInfo* result;
	GDesktopAppInfo* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_app_info;
	result = _tmp0_;
	return result;
}

static void
slingshot_app_list_row_set_app_info (SlingshotAppListRow* self,
                                     GDesktopAppInfo* value)
{
	GDesktopAppInfo* old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_app_list_row_get_app_info (self);
	if (old_value != value) {
		GDesktopAppInfo* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_app_info);
		self->priv->_app_info = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, slingshot_app_list_row_properties[SLINGSHOT_APP_LIST_ROW_APP_INFO_PROPERTY]);
	}
}

static GObject *
slingshot_app_list_row_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SlingshotAppListRow * self;
	const gchar* _tmp0_;
	GDesktopAppInfo* _tmp1_;
	GDesktopAppInfo* _tmp2_;
	GIcon* icon = NULL;
	GDesktopAppInfo* _tmp3_;
	GIcon* _tmp4_;
	GIcon* _tmp5_;
	GtkIconTheme* theme = NULL;
	GtkIconTheme* _tmp6_;
	gboolean _tmp7_ = FALSE;
	GIcon* _tmp8_;
	GtkImage* image = NULL;
	GIcon* _tmp14_;
	GIcon* _tmp15_;
	GtkImage* _tmp16_ = NULL;
	GtkLabel* name_label = NULL;
	GDesktopAppInfo* _tmp17_;
	const gchar* _tmp18_;
	GtkLabel* _tmp19_ = NULL;
	GDesktopAppInfo* _tmp20_;
	const gchar* _tmp21_;
	GtkBox* box = NULL;
	GtkBox* _tmp22_;
	GtkBox* _tmp23_;
	GtkImage* _tmp24_;
	GtkBox* _tmp25_;
	GtkLabel* _tmp26_;
	GtkBox* _tmp27_;
	parent_class = G_OBJECT_CLASS (slingshot_app_list_row_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SLINGSHOT_TYPE_APP_LIST_ROW, SlingshotAppListRow);
	_tmp0_ = self->priv->_app_id;
	_tmp1_ = g_desktop_app_info_new (_tmp0_);
	_tmp2_ = _tmp1_;
	slingshot_app_list_row_set_app_info (self, _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = self->priv->_app_info;
	_tmp4_ = g_app_info_get_icon ((GAppInfo*) _tmp3_);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	icon = _tmp5_;
	_tmp6_ = gtk_icon_theme_get_default ();
	theme = _tmp6_;
	_tmp8_ = icon;
	if (_tmp8_ == NULL) {
		_tmp7_ = TRUE;
	} else {
		GtkIconTheme* _tmp9_;
		GIcon* _tmp10_;
		GtkIconInfo* _tmp11_;
		GtkIconInfo* _tmp12_;
		_tmp9_ = theme;
		_tmp10_ = icon;
		_tmp11_ = gtk_icon_theme_lookup_by_gicon (_tmp9_, _tmp10_, 32, GTK_ICON_LOOKUP_USE_BUILTIN);
		_tmp12_ = _tmp11_;
		_tmp7_ = _tmp12_ == NULL;
		_g_object_unref0 (_tmp12_);
	}
	if (_tmp7_) {
		GThemedIcon* _tmp13_;
		_tmp13_ = (GThemedIcon*) g_themed_icon_new ("application-default-icon");
		_g_object_unref0 (icon);
		icon = (GIcon*) _tmp13_;
	}
	_tmp14_ = icon;
	_tmp15_ = _g_object_ref0 (_tmp14_);
	_tmp16_ = (GtkImage*) gtk_image_new ();
	g_object_set (_tmp16_, "gicon", _tmp15_, NULL);
	_g_object_unref0 (_tmp15_);
	gtk_image_set_pixel_size (_tmp16_, 32);
	g_object_ref_sink (_tmp16_);
	image = _tmp16_;
	_tmp17_ = self->priv->_app_info;
	_tmp18_ = g_app_info_get_display_name ((GAppInfo*) _tmp17_);
	_tmp19_ = (GtkLabel*) gtk_label_new (_tmp18_);
	gtk_label_set_ellipsize (_tmp19_, PANGO_ELLIPSIZE_END);
	gtk_label_set_xalign (_tmp19_, (gfloat) 0);
	g_object_ref_sink (_tmp19_);
	name_label = _tmp19_;
	_tmp20_ = self->priv->_app_info;
	_tmp21_ = g_app_info_get_description ((GAppInfo*) _tmp20_);
	gtk_widget_set_tooltip_text ((GtkWidget*) self, _tmp21_);
	_tmp22_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
	g_object_ref_sink (_tmp22_);
	box = _tmp22_;
	_tmp23_ = box;
	_tmp24_ = image;
	gtk_container_add ((GtkContainer*) _tmp23_, (GtkWidget*) _tmp24_);
	_tmp25_ = box;
	_tmp26_ = name_label;
	gtk_container_add ((GtkContainer*) _tmp25_, (GtkWidget*) _tmp26_);
	_tmp27_ = box;
	g_object_set ((GtkContainer*) self, "child", (GtkWidget*) _tmp27_, NULL);
	_g_object_unref0 (box);
	_g_object_unref0 (name_label);
	_g_object_unref0 (image);
	_g_object_unref0 (icon);
	return obj;
}

static void
slingshot_app_list_row_base_init (SlingshotAppListRowClass * klass)
{
	gtk_widget_class_set_css_name (GTK_WIDGET_CLASS (klass), "modelbutton");
}

static void
slingshot_app_list_row_class_init (SlingshotAppListRowClass * klass,
                                   gpointer klass_data)
{
	slingshot_app_list_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SlingshotAppListRow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_slingshot_app_list_row_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_slingshot_app_list_row_set_property;
	G_OBJECT_CLASS (klass)->constructor = slingshot_app_list_row_constructor;
	G_OBJECT_CLASS (klass)->finalize = slingshot_app_list_row_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_APP_LIST_ROW_APP_PROPERTY, slingshot_app_list_row_properties[SLINGSHOT_APP_LIST_ROW_APP_PROPERTY] = g_param_spec_object ("app", "app", "app", SLINGSHOT_BACKEND_TYPE_APP, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_APP_LIST_ROW_APP_ID_PROPERTY, slingshot_app_list_row_properties[SLINGSHOT_APP_LIST_ROW_APP_ID_PROPERTY] = g_param_spec_string ("app-id", "app-id", "app-id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_APP_LIST_ROW_DESKTOP_PATH_PROPERTY, slingshot_app_list_row_properties[SLINGSHOT_APP_LIST_ROW_DESKTOP_PATH_PROPERTY] = g_param_spec_string ("desktop-path", "desktop-path", "desktop-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_APP_LIST_ROW_APP_INFO_PROPERTY, slingshot_app_list_row_properties[SLINGSHOT_APP_LIST_ROW_APP_INFO_PROPERTY] = g_param_spec_object ("app-info", "app-info", "app-info", G_TYPE_DESKTOP_APP_INFO, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
slingshot_app_list_row_instance_init (SlingshotAppListRow * self,
                                      gpointer klass)
{
	self->priv = slingshot_app_list_row_get_instance_private (self);
}

static void
slingshot_app_list_row_finalize (GObject * obj)
{
	SlingshotAppListRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SLINGSHOT_TYPE_APP_LIST_ROW, SlingshotAppListRow);
	_g_object_unref0 (self->priv->_app);
	_g_free0 (self->priv->_app_id);
	_g_free0 (self->priv->_desktop_path);
	_g_object_unref0 (self->priv->_app_info);
	G_OBJECT_CLASS (slingshot_app_list_row_parent_class)->finalize (obj);
}

static GType
slingshot_app_list_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SlingshotAppListRowClass), (GBaseInitFunc) slingshot_app_list_row_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) slingshot_app_list_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SlingshotAppListRow), 0, (GInstanceInitFunc) slingshot_app_list_row_instance_init, NULL };
	GType slingshot_app_list_row_type_id;
	slingshot_app_list_row_type_id = g_type_register_static (gtk_list_box_row_get_type (), "SlingshotAppListRow", &g_define_type_info, 0);
	SlingshotAppListRow_private_offset = g_type_add_instance_private (slingshot_app_list_row_type_id, sizeof (SlingshotAppListRowPrivate));
	return slingshot_app_list_row_type_id;
}

GType
slingshot_app_list_row_get_type (void)
{
	static volatile gsize slingshot_app_list_row_type_id__once = 0;
	if (g_once_init_enter (&slingshot_app_list_row_type_id__once)) {
		GType slingshot_app_list_row_type_id;
		slingshot_app_list_row_type_id = slingshot_app_list_row_get_type_once ();
		g_once_init_leave (&slingshot_app_list_row_type_id__once, slingshot_app_list_row_type_id);
	}
	return slingshot_app_list_row_type_id__once;
}

static void
_vala_slingshot_app_list_row_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	SlingshotAppListRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SLINGSHOT_TYPE_APP_LIST_ROW, SlingshotAppListRow);
	switch (property_id) {
		case SLINGSHOT_APP_LIST_ROW_APP_PROPERTY:
		g_value_set_object (value, slingshot_app_list_row_get_app (self));
		break;
		case SLINGSHOT_APP_LIST_ROW_APP_ID_PROPERTY:
		g_value_set_string (value, slingshot_app_list_row_get_app_id (self));
		break;
		case SLINGSHOT_APP_LIST_ROW_DESKTOP_PATH_PROPERTY:
		g_value_set_string (value, slingshot_app_list_row_get_desktop_path (self));
		break;
		case SLINGSHOT_APP_LIST_ROW_APP_INFO_PROPERTY:
		g_value_set_object (value, slingshot_app_list_row_get_app_info (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_slingshot_app_list_row_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	SlingshotAppListRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SLINGSHOT_TYPE_APP_LIST_ROW, SlingshotAppListRow);
	switch (property_id) {
		case SLINGSHOT_APP_LIST_ROW_APP_PROPERTY:
		slingshot_app_list_row_set_app (self, g_value_get_object (value));
		break;
		case SLINGSHOT_APP_LIST_ROW_APP_ID_PROPERTY:
		slingshot_app_list_row_set_app_id (self, g_value_get_string (value));
		break;
		case SLINGSHOT_APP_LIST_ROW_DESKTOP_PATH_PROPERTY:
		slingshot_app_list_row_set_desktop_path (self, g_value_get_string (value));
		break;
		case SLINGSHOT_APP_LIST_ROW_APP_INFO_PROPERTY:
		slingshot_app_list_row_set_app_info (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

