/* AgendaEventRow.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from AgendaEventRow.vala, do not modify */

/*
 * Copyright 2011-2021 elementary, Inc. (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Maxwell Barvian
 *              Niels Avonds <niels.avonds@gmail.com>
 *              Corentin Noël <corentin@elementaryos.org>
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <libecal/libecal.h>
#include <libedataserver/libedataserver.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <libical-glib/libical-glib.h>
#include "elementary-calendar.h"
#include <granite.h>
#include <geocode-glib/geocode-glib.h>
#include <pango/pango.h>
#include <gdk/gdk.h>

#define EVENT_CSS "\n    @define-color accent_color %s;\n"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define MAYA_VIEW_TYPE_AGENDA_EVENT_ROW (maya_view_agenda_event_row_get_type ())
#define MAYA_VIEW_AGENDA_EVENT_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_VIEW_TYPE_AGENDA_EVENT_ROW, MayaViewAgendaEventRow))
#define MAYA_VIEW_AGENDA_EVENT_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_VIEW_TYPE_AGENDA_EVENT_ROW, MayaViewAgendaEventRowClass))
#define MAYA_VIEW_IS_AGENDA_EVENT_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_VIEW_TYPE_AGENDA_EVENT_ROW))
#define MAYA_VIEW_IS_AGENDA_EVENT_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_VIEW_TYPE_AGENDA_EVENT_ROW))
#define MAYA_VIEW_AGENDA_EVENT_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_VIEW_TYPE_AGENDA_EVENT_ROW, MayaViewAgendaEventRowClass))

typedef struct _MayaViewAgendaEventRow MayaViewAgendaEventRow;
typedef struct _MayaViewAgendaEventRowClass MayaViewAgendaEventRowClass;
typedef struct _MayaViewAgendaEventRowPrivate MayaViewAgendaEventRowPrivate;
typedef enum  {
	MAYA_VIEW_AGENDA_EVENT_ROW_CATEGORY_NONE,
	MAYA_VIEW_AGENDA_EVENT_ROW_CATEGORY_APPOINTMENT,
	MAYA_VIEW_AGENDA_EVENT_ROW_CATEGORY_CELEBRATION,
	MAYA_VIEW_AGENDA_EVENT_ROW_CATEGORY_CALL,
	MAYA_VIEW_AGENDA_EVENT_ROW_CATEGORY_DRINKS,
	MAYA_VIEW_AGENDA_EVENT_ROW_CATEGORY_DRIVING,
	MAYA_VIEW_AGENDA_EVENT_ROW_CATEGORY_FLIGHT,
	MAYA_VIEW_AGENDA_EVENT_ROW_CATEGORY_FOOD,
	MAYA_VIEW_AGENDA_EVENT_ROW_CATEGORY_LEGAL,
	MAYA_VIEW_AGENDA_EVENT_ROW_CATEGORY_MOVIE,
	MAYA_VIEW_AGENDA_EVENT_ROW_CATEGORY_WEDDING,
	MAYA_VIEW_AGENDA_EVENT_ROW_CATEGORY_N_CATEGORIES
} MayaViewAgendaEventRowCategory;

#define MAYA_VIEW_AGENDA_EVENT_ROW_TYPE_CATEGORY (maya_view_agenda_event_row_category_get_type ())
enum  {
	MAYA_VIEW_AGENDA_EVENT_ROW_0_PROPERTY,
	MAYA_VIEW_AGENDA_EVENT_ROW_CALEVENT_PROPERTY,
	MAYA_VIEW_AGENDA_EVENT_ROW_SOURCE_PROPERTY,
	MAYA_VIEW_AGENDA_EVENT_ROW_IS_UPCOMING_PROPERTY,
	MAYA_VIEW_AGENDA_EVENT_ROW_SUMMARY_PROPERTY,
	MAYA_VIEW_AGENDA_EVENT_ROW_IS_ALLDAY_PROPERTY,
	MAYA_VIEW_AGENDA_EVENT_ROW_IS_MULTIDAY_PROPERTY,
	MAYA_VIEW_AGENDA_EVENT_ROW_REVEALER_PROPERTY,
	MAYA_VIEW_AGENDA_EVENT_ROW_NUM_PROPERTIES
};
static GParamSpec* maya_view_agenda_event_row_properties[MAYA_VIEW_AGENDA_EVENT_ROW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define MAYA_TYPE_EVENT_MENU (maya_event_menu_get_type ())
#define MAYA_EVENT_MENU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_TYPE_EVENT_MENU, MayaEventMenu))
#define MAYA_EVENT_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_TYPE_EVENT_MENU, MayaEventMenuClass))
#define MAYA_IS_EVENT_MENU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_TYPE_EVENT_MENU))
#define MAYA_IS_EVENT_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_TYPE_EVENT_MENU))
#define MAYA_EVENT_MENU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_TYPE_EVENT_MENU, MayaEventMenuClass))

typedef struct _MayaEventMenu MayaEventMenu;
typedef struct _MayaEventMenuClass MayaEventMenuClass;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _Block29Data Block29Data;
enum  {
	MAYA_VIEW_AGENDA_EVENT_ROW_REMOVED_SIGNAL,
	MAYA_VIEW_AGENDA_EVENT_ROW_NUM_SIGNALS
};
static guint maya_view_agenda_event_row_signals[MAYA_VIEW_AGENDA_EVENT_ROW_NUM_SIGNALS] = {0};

struct _MayaViewAgendaEventRow {
	GtkListBoxRow parent_instance;
	MayaViewAgendaEventRowPrivate * priv;
};

struct _MayaViewAgendaEventRowClass {
	GtkListBoxRowClass parent_class;
};

struct _MayaViewAgendaEventRowPrivate {
	ECalComponent* _calevent;
	ESource* _source;
	gboolean _is_upcoming;
	gchar* _summary;
	gboolean _is_allday;
	gboolean _is_multiday;
	GtkRevealer* _revealer;
	GtkGestureMultiPress* click_gesture;
	GtkImage* event_image;
	GtkLabel* name_label;
	GtkLabel* datetime_label;
	GtkLabel* location_label;
	GtkStyleContext* event_image_context;
	GtkStyleContext* main_grid_context;
	GeeHashMultiMap* keyword_map;
};

struct _Block29Data {
	int _ref_count_;
	MayaViewAgendaEventRow* self;
	GtkRevealer* location_revealer;
	ESourceCalendar* cal;
};

static gint MayaViewAgendaEventRow_private_offset;
static gpointer maya_view_agenda_event_row_parent_class = NULL;

VALA_EXTERN GType maya_view_agenda_event_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaViewAgendaEventRow, g_object_unref)
static GType maya_view_agenda_event_row_category_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static const gchar* maya_view_agenda_event_row_category_get_builtin_keywords (MayaViewAgendaEventRowCategory self);
static const gchar* maya_view_agenda_event_row_category_get_icon_name (MayaViewAgendaEventRowCategory self);
VALA_EXTERN MayaViewAgendaEventRow* maya_view_agenda_event_row_new (ESource* source,
                                                        ECalComponent* calevent,
                                                        gboolean is_upcoming);
VALA_EXTERN MayaViewAgendaEventRow* maya_view_agenda_event_row_construct (GType object_type,
                                                              ESource* source,
                                                              ECalComponent* calevent,
                                                              gboolean is_upcoming);
static void maya_view_agenda_event_row_on_button_press (MayaViewAgendaEventRow* self,
                                                 gint n_press,
                                                 gdouble x,
                                                 gdouble y);
VALA_EXTERN GType maya_event_menu_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaEventMenu, g_object_unref)
VALA_EXTERN ECalComponent* maya_view_agenda_event_row_get_calevent (MayaViewAgendaEventRow* self);
VALA_EXTERN MayaEventMenu* maya_event_menu_new (ECalComponent* comp);
VALA_EXTERN MayaEventMenu* maya_event_menu_construct (GType object_type,
                                          ECalComponent* comp);
VALA_EXTERN void maya_view_agenda_event_row_update (MayaViewAgendaEventRow* self,
                                        ECalComponent* event);
static void maya_view_agenda_event_row_set_summary (MayaViewAgendaEventRow* self,
                                             const gchar* value);
VALA_EXTERN const gchar* maya_view_agenda_event_row_get_summary (MayaViewAgendaEventRow* self);
static void maya_view_agenda_event_row_find_keywords (MayaViewAgendaEventRow* self,
                                               MayaViewAgendaEventRowCategory category,
                                               const gchar* phrase,
                                               MayaViewAgendaEventRowCategory* current_category,
                                               gint* current_hits);
static void maya_view_agenda_event_row_set_is_allday (MayaViewAgendaEventRow* self,
                                               gboolean value);
static void maya_view_agenda_event_row_set_is_multiday (MayaViewAgendaEventRow* self,
                                                 gboolean value);
VALA_EXTERN gchar* maya_settings_time_format (void);
VALA_EXTERN gboolean maya_view_agenda_event_row_get_is_multiday (MayaViewAgendaEventRow* self);
VALA_EXTERN gboolean maya_view_agenda_event_row_get_is_allday (MayaViewAgendaEventRow* self);
VALA_EXTERN gboolean maya_view_agenda_event_row_get_is_upcoming (MayaViewAgendaEventRow* self);
static gboolean maya_view_agenda_event_row_location_from_component (ECalComponent* component,
                                                             gchar** description,
                                                             gchar** uri);
static void maya_view_agenda_event_row_reload_css (MayaViewAgendaEventRow* self,
                                            const gchar* background_color);
static void maya_view_agenda_event_row_split_keywords (MayaViewAgendaEventRow* self,
                                                MayaViewAgendaEventRowCategory category);
static void maya_view_agenda_event_row_set_calevent (MayaViewAgendaEventRow* self,
                                              ECalComponent* value);
VALA_EXTERN ESource* maya_view_agenda_event_row_get_source (MayaViewAgendaEventRow* self);
static void maya_view_agenda_event_row_set_source (MayaViewAgendaEventRow* self,
                                            ESource* value);
static void maya_view_agenda_event_row_set_is_upcoming (MayaViewAgendaEventRow* self,
                                                 gboolean value);
VALA_EXTERN GtkRevealer* maya_view_agenda_event_row_get_revealer (MayaViewAgendaEventRow* self);
static void maya_view_agenda_event_row_set_revealer (MayaViewAgendaEventRow* self,
                                              GtkRevealer* value);
static GObject * maya_view_agenda_event_row_constructor (GType type,
                                                  guint n_construct_properties,
                                                  GObjectConstructParam * construct_properties);
static Block29Data* block29_data_ref (Block29Data* _data29_);
static void block29_data_unref (void * _userdata_);
static void _maya_view_agenda_event_row___lambda203_ (Block29Data* _data29_);
static void __maya_view_agenda_event_row___lambda203__g_object_notify (GObject* _sender,
                                                                GParamSpec* pspec,
                                                                gpointer self);
static void _maya_view_agenda_event_row___lambda204_ (Block29Data* _data29_);
static void __maya_view_agenda_event_row___lambda204__g_object_notify (GObject* _sender,
                                                                GParamSpec* pspec,
                                                                gpointer self);
static void _maya_view_agenda_event_row___lambda205_ (MayaViewAgendaEventRow* self);
static void __maya_view_agenda_event_row___lambda205__gtk_widget_show (GtkWidget* _sender,
                                                                gpointer self);
static void _maya_view_agenda_event_row___lambda206_ (MayaViewAgendaEventRow* self);
static void __maya_view_agenda_event_row___lambda206__gtk_widget_hide (GtkWidget* _sender,
                                                                gpointer self);
static void _maya_view_agenda_event_row_on_button_press_gtk_gesture_multi_press_released (GtkGestureMultiPress* _sender,
                                                                                   gint n_press,
                                                                                   gdouble x,
                                                                                   gdouble y,
                                                                                   gpointer self);
static void maya_view_agenda_event_row_finalize (GObject * obj);
static GType maya_view_agenda_event_row_get_type_once (void);
static void _vala_maya_view_agenda_event_row_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec);
static void _vala_maya_view_agenda_event_row_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
maya_view_agenda_event_row_get_instance_private (MayaViewAgendaEventRow* self)
{
	return G_STRUCT_MEMBER_P (self, MayaViewAgendaEventRow_private_offset);
}

static const gchar*
maya_view_agenda_event_row_category_get_builtin_keywords (MayaViewAgendaEventRowCategory self)
{
	const gchar* result;
	switch (self) {
		case MAYA_VIEW_AGENDA_EVENT_ROW_CATEGORY_APPOINTMENT:
		{
			result = _ ("appointment;meeting");
			return result;
		}
		case MAYA_VIEW_AGENDA_EVENT_ROW_CATEGORY_CELEBRATION:
		{
			result = _ ("birthday;anniversary;party");
			return result;
		}
		case MAYA_VIEW_AGENDA_EVENT_ROW_CATEGORY_CALL:
		{
			result = _ ("call;phone;telephone;ring");
			return result;
		}
		case MAYA_VIEW_AGENDA_EVENT_ROW_CATEGORY_DRINKS:
		{
			result = _ ("bar;cocktails;drinks;happy hour");
			return result;
		}
		case MAYA_VIEW_AGENDA_EVENT_ROW_CATEGORY_DRIVING:
		{
			result = _ ("car;drive;driving;road trip;");
			return result;
		}
		case MAYA_VIEW_AGENDA_EVENT_ROW_CATEGORY_FLIGHT:
		{
			result = _ ("flight;airport;");
			return result;
		}
		case MAYA_VIEW_AGENDA_EVENT_ROW_CATEGORY_FOOD:
		{
			result = _ ("breakfast;brunch;dinner;lunch;supper;steakhouse;burger;meal;barbecue");
			return result;
		}
		case MAYA_VIEW_AGENDA_EVENT_ROW_CATEGORY_LEGAL:
		{
			result = _ ("court;jury;tax;attorney;lawyer;contract");
			return result;
		}
		case MAYA_VIEW_AGENDA_EVENT_ROW_CATEGORY_MOVIE:
		{
			result = _ ("movie;film");
			return result;
		}
		case MAYA_VIEW_AGENDA_EVENT_ROW_CATEGORY_WEDDING:
		{
			result = _ ("wedding");
			return result;
		}
		default:
		{
			result = "";
			return result;
		}
	}
}

static const gchar*
maya_view_agenda_event_row_category_get_icon_name (MayaViewAgendaEventRowCategory self)
{
	const gchar* result;
	switch (self) {
		case MAYA_VIEW_AGENDA_EVENT_ROW_CATEGORY_APPOINTMENT:
		{
			result = "event-appointment-symbolic";
			return result;
		}
		case MAYA_VIEW_AGENDA_EVENT_ROW_CATEGORY_CELEBRATION:
		{
			result = "event-birthday-symbolic";
			return result;
		}
		case MAYA_VIEW_AGENDA_EVENT_ROW_CATEGORY_CALL:
		{
			result = "event-call-symbolic";
			return result;
		}
		case MAYA_VIEW_AGENDA_EVENT_ROW_CATEGORY_DRINKS:
		{
			result = "event-cocktails-symbolic";
			return result;
		}
		case MAYA_VIEW_AGENDA_EVENT_ROW_CATEGORY_DRIVING:
		{
			result = "event-driving-symbolic";
			return result;
		}
		case MAYA_VIEW_AGENDA_EVENT_ROW_CATEGORY_FLIGHT:
		{
			result = "event-flight-symbolic";
			return result;
		}
		case MAYA_VIEW_AGENDA_EVENT_ROW_CATEGORY_FOOD:
		{
			result = "event-food-symbolic";
			return result;
		}
		case MAYA_VIEW_AGENDA_EVENT_ROW_CATEGORY_LEGAL:
		{
			result = "event-legal-symbolic";
			return result;
		}
		case MAYA_VIEW_AGENDA_EVENT_ROW_CATEGORY_MOVIE:
		{
			result = "event-movie-symbolic";
			return result;
		}
		case MAYA_VIEW_AGENDA_EVENT_ROW_CATEGORY_WEDDING:
		{
			result = "event-wedding-symbolic";
			return result;
		}
		default:
		{
			result = NULL;
			return result;
		}
	}
}

static GType
maya_view_agenda_event_row_category_get_type_once (void)
{
	static const GEnumValue values[] = {{MAYA_VIEW_AGENDA_EVENT_ROW_CATEGORY_NONE, "MAYA_VIEW_AGENDA_EVENT_ROW_CATEGORY_NONE", "none"}, {MAYA_VIEW_AGENDA_EVENT_ROW_CATEGORY_APPOINTMENT, "MAYA_VIEW_AGENDA_EVENT_ROW_CATEGORY_APPOINTMENT", "appointment"}, {MAYA_VIEW_AGENDA_EVENT_ROW_CATEGORY_CELEBRATION, "MAYA_VIEW_AGENDA_EVENT_ROW_CATEGORY_CELEBRATION", "celebration"}, {MAYA_VIEW_AGENDA_EVENT_ROW_CATEGORY_CALL, "MAYA_VIEW_AGENDA_EVENT_ROW_CATEGORY_CALL", "call"}, {MAYA_VIEW_AGENDA_EVENT_ROW_CATEGORY_DRINKS, "MAYA_VIEW_AGENDA_EVENT_ROW_CATEGORY_DRINKS", "drinks"}, {MAYA_VIEW_AGENDA_EVENT_ROW_CATEGORY_DRIVING, "MAYA_VIEW_AGENDA_EVENT_ROW_CATEGORY_DRIVING", "driving"}, {MAYA_VIEW_AGENDA_EVENT_ROW_CATEGORY_FLIGHT, "MAYA_VIEW_AGENDA_EVENT_ROW_CATEGORY_FLIGHT", "flight"}, {MAYA_VIEW_AGENDA_EVENT_ROW_CATEGORY_FOOD, "MAYA_VIEW_AGENDA_EVENT_ROW_CATEGORY_FOOD", "food"}, {MAYA_VIEW_AGENDA_EVENT_ROW_CATEGORY_LEGAL, "MAYA_VIEW_AGENDA_EVENT_ROW_CATEGORY_LEGAL", "legal"}, {MAYA_VIEW_AGENDA_EVENT_ROW_CATEGORY_MOVIE, "MAYA_VIEW_AGENDA_EVENT_ROW_CATEGORY_MOVIE", "movie"}, {MAYA_VIEW_AGENDA_EVENT_ROW_CATEGORY_WEDDING, "MAYA_VIEW_AGENDA_EVENT_ROW_CATEGORY_WEDDING", "wedding"}, {MAYA_VIEW_AGENDA_EVENT_ROW_CATEGORY_N_CATEGORIES, "MAYA_VIEW_AGENDA_EVENT_ROW_CATEGORY_N_CATEGORIES", "n-categories"}, {0, NULL, NULL}};
	GType maya_view_agenda_event_row_category_type_id;
	maya_view_agenda_event_row_category_type_id = g_enum_register_static ("MayaViewAgendaEventRowCategory", values);
	return maya_view_agenda_event_row_category_type_id;
}

static GType
maya_view_agenda_event_row_category_get_type (void)
{
	static volatile gsize maya_view_agenda_event_row_category_type_id__once = 0;
	if (g_once_init_enter (&maya_view_agenda_event_row_category_type_id__once)) {
		GType maya_view_agenda_event_row_category_type_id;
		maya_view_agenda_event_row_category_type_id = maya_view_agenda_event_row_category_get_type_once ();
		g_once_init_leave (&maya_view_agenda_event_row_category_type_id__once, maya_view_agenda_event_row_category_type_id);
	}
	return maya_view_agenda_event_row_category_type_id__once;
}

MayaViewAgendaEventRow*
maya_view_agenda_event_row_construct (GType object_type,
                                      ESource* source,
                                      ECalComponent* calevent,
                                      gboolean is_upcoming)
{
	MayaViewAgendaEventRow * self = NULL;
	g_return_val_if_fail (source != NULL, NULL);
	g_return_val_if_fail (calevent != NULL, NULL);
	self = (MayaViewAgendaEventRow*) g_object_new (object_type, "calevent", calevent, "is-upcoming", is_upcoming, "source", source, NULL);
	return self;
}

MayaViewAgendaEventRow*
maya_view_agenda_event_row_new (ESource* source,
                                ECalComponent* calevent,
                                gboolean is_upcoming)
{
	return maya_view_agenda_event_row_construct (MAYA_VIEW_TYPE_AGENDA_EVENT_ROW, source, calevent, is_upcoming);
}

static void
maya_view_agenda_event_row_on_button_press (MayaViewAgendaEventRow* self,
                                            gint n_press,
                                            gdouble x,
                                            gdouble y)
{
	MayaEventMenu* menu = NULL;
	ECalComponent* _tmp0_;
	MayaEventMenu* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_calevent;
	_tmp1_ = maya_event_menu_new (_tmp0_);
	g_object_ref_sink (_tmp1_);
	menu = _tmp1_;
	gtk_menu_attach_to_widget ((GtkMenu*) menu, (GtkWidget*) self, NULL);
	gtk_menu_popup_at_pointer ((GtkMenu*) menu, NULL);
	_g_object_unref0 (menu);
}

/**
     * Updates the event to match the given event.
     */
void
maya_view_agenda_event_row_update (MayaViewAgendaEventRow* self,
                                   ECalComponent* event)
{
	ICalComponent* ical_event = NULL;
	ICalComponent* _tmp0_;
	ICalComponent* _tmp1_;
	const gchar* _tmp2_;
	GtkLabel* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* event_name = NULL;
	GtkLabel* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	MayaViewAgendaEventRowCategory current_category = 0;
	gint current_hits = 0;
	gchar* icon_name_from_keywords = NULL;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	GDateTime* start_date = NULL;
	GDateTime* end_date = NULL;
	ICalComponent* _tmp19_;
	GDateTime* _tmp20_ = NULL;
	GDateTime* _tmp21_ = NULL;
	GDateTime* _tmp22_;
	GDateTime* _tmp23_;
	ICalComponent* _tmp24_;
	gchar* date_format = NULL;
	gchar* _tmp25_;
	gchar* start_date_string = NULL;
	GDateTime* _tmp26_;
	const gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* end_date_string = NULL;
	GDateTime* _tmp29_;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* start_time_string = NULL;
	GDateTime* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* end_time_string = NULL;
	GDateTime* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* datetime_string = NULL;
	gboolean is_same_time = FALSE;
	const gchar* _tmp42_;
	const gchar* _tmp43_;
	GtkLabel* _tmp44_;
	GtkLabel* _tmp45_;
	gboolean _tmp46_;
	GtkLabel* _tmp75_;
	const gchar* _tmp76_;
	gchar* location_description = NULL;
	gchar* location_uri = NULL;
	gchar* _tmp77_ = NULL;
	gchar* _tmp78_ = NULL;
	gboolean _tmp79_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	_tmp0_ = e_cal_component_get_icalcomponent (event);
	ical_event = _tmp0_;
	_tmp1_ = ical_event;
	_tmp2_ = i_cal_component_get_summary (_tmp1_);
	maya_view_agenda_event_row_set_summary (self, _tmp2_);
	_tmp3_ = self->priv->name_label;
	_tmp4_ = self->priv->_summary;
	_tmp5_ = g_markup_escape_text (_tmp4_, (gssize) -1);
	_tmp6_ = _tmp5_;
	gtk_label_set_markup (_tmp3_, _tmp6_);
	_g_free0 (_tmp6_);
	_tmp7_ = self->priv->name_label;
	_tmp8_ = gtk_label_get_label (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_utf8_strdown (_tmp9_, (gssize) -1);
	event_name = _tmp10_;
	current_category = MAYA_VIEW_AGENDA_EVENT_ROW_CATEGORY_NONE;
	current_hits = 0;
	{
		guint u = 0U;
		u = (guint) MAYA_VIEW_AGENDA_EVENT_ROW_CATEGORY_APPOINTMENT;
		{
			gboolean _tmp11_ = FALSE;
			_tmp11_ = TRUE;
			while (TRUE) {
				const gchar* _tmp13_;
				if (!_tmp11_) {
					guint _tmp12_;
					_tmp12_ = u;
					u = _tmp12_ + 1;
				}
				_tmp11_ = FALSE;
				if (!(u < ((guint) MAYA_VIEW_AGENDA_EVENT_ROW_CATEGORY_N_CATEGORIES))) {
					break;
				}
				_tmp13_ = event_name;
				maya_view_agenda_event_row_find_keywords (self, (MayaViewAgendaEventRowCategory) u, _tmp13_, &current_category, &current_hits);
			}
		}
	}
	_tmp14_ = maya_view_agenda_event_row_category_get_icon_name (current_category);
	_tmp15_ = g_strdup (_tmp14_);
	icon_name_from_keywords = _tmp15_;
	_tmp16_ = icon_name_from_keywords;
	if (_tmp16_ != NULL) {
		GtkImage* _tmp17_;
		const gchar* _tmp18_;
		_tmp17_ = self->priv->event_image;
		_tmp18_ = icon_name_from_keywords;
		g_object_set (_tmp17_, "icon-name", _tmp18_, NULL);
	}
	_tmp19_ = ical_event;
	calendar_util_icalcomponent_get_local_datetimes_for_display (_tmp19_, &_tmp20_, &_tmp21_);
	_g_date_time_unref0 (start_date);
	start_date = _tmp20_;
	_g_date_time_unref0 (end_date);
	end_date = _tmp21_;
	_tmp22_ = start_date;
	_tmp23_ = end_date;
	maya_view_agenda_event_row_set_is_allday (self, calendar_util_datetime_is_all_day (_tmp22_, _tmp23_));
	_tmp24_ = ical_event;
	maya_view_agenda_event_row_set_is_multiday (self, calendar_util_icalcomponent_is_multiday (_tmp24_));
	_tmp25_ = granite_date_time_get_default_date_format (TRUE, TRUE, FALSE);
	date_format = _tmp25_;
	_tmp26_ = start_date;
	_tmp27_ = date_format;
	_tmp28_ = g_date_time_format (_tmp26_, _tmp27_);
	start_date_string = _tmp28_;
	_tmp29_ = end_date;
	_tmp30_ = date_format;
	_tmp31_ = g_date_time_format (_tmp29_, _tmp30_);
	end_date_string = _tmp31_;
	_tmp32_ = start_date;
	_tmp33_ = maya_settings_time_format ();
	_tmp34_ = _tmp33_;
	_tmp35_ = g_date_time_format (_tmp32_, _tmp34_);
	_tmp36_ = _tmp35_;
	_g_free0 (_tmp34_);
	start_time_string = _tmp36_;
	_tmp37_ = end_date;
	_tmp38_ = maya_settings_time_format ();
	_tmp39_ = _tmp38_;
	_tmp40_ = g_date_time_format (_tmp37_, _tmp39_);
	_tmp41_ = _tmp40_;
	_g_free0 (_tmp39_);
	end_time_string = _tmp41_;
	datetime_string = NULL;
	_tmp42_ = start_time_string;
	_tmp43_ = end_time_string;
	is_same_time = g_strcmp0 (_tmp42_, _tmp43_) == 0;
	_tmp44_ = self->priv->datetime_label;
	gtk_widget_show ((GtkWidget*) _tmp44_);
	_tmp45_ = self->priv->datetime_label;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp45_, FALSE);
	_tmp46_ = self->priv->_is_multiday;
	if (_tmp46_) {
		gboolean _tmp47_;
		_tmp47_ = self->priv->_is_allday;
		if (_tmp47_) {
			const gchar* _tmp48_;
			const gchar* _tmp49_;
			gchar* _tmp50_;
			_tmp48_ = start_date_string;
			_tmp49_ = end_date_string;
			_tmp50_ = g_strdup_printf (C_ ("date-range", "%s – %s"), _tmp48_, _tmp49_);
			_g_free0 (datetime_string);
			datetime_string = _tmp50_;
		} else {
			const gchar* _tmp51_;
			const gchar* _tmp52_;
			const gchar* _tmp53_;
			const gchar* _tmp54_;
			gchar* _tmp55_;
			_tmp51_ = start_date_string;
			_tmp52_ = start_time_string;
			_tmp53_ = end_date_string;
			_tmp54_ = end_time_string;
			_tmp55_ = g_strdup_printf (_ ("%s, %s – %s, %s"), _tmp51_, _tmp52_, _tmp53_, _tmp54_);
			_g_free0 (datetime_string);
			datetime_string = _tmp55_;
		}
	} else {
		gboolean _tmp56_;
		_tmp56_ = self->priv->_is_upcoming;
		if (!_tmp56_) {
			gboolean _tmp57_;
			_tmp57_ = self->priv->_is_allday;
			if (_tmp57_) {
				GtkLabel* _tmp58_;
				GtkLabel* _tmp59_;
				_tmp58_ = self->priv->datetime_label;
				gtk_widget_hide ((GtkWidget*) _tmp58_);
				_tmp59_ = self->priv->datetime_label;
				gtk_widget_set_no_show_all ((GtkWidget*) _tmp59_, TRUE);
			} else {
				if (is_same_time) {
					const gchar* _tmp60_;
					gchar* _tmp61_;
					_tmp60_ = start_time_string;
					_tmp61_ = g_strdup (_tmp60_);
					_g_free0 (datetime_string);
					datetime_string = _tmp61_;
				} else {
					const gchar* _tmp62_;
					const gchar* _tmp63_;
					gchar* _tmp64_;
					_tmp62_ = start_time_string;
					_tmp63_ = end_time_string;
					_tmp64_ = g_strdup_printf (C_ ("time-range", "%s – %s"), _tmp62_, _tmp63_);
					_g_free0 (datetime_string);
					datetime_string = _tmp64_;
				}
			}
		} else {
			gboolean _tmp65_;
			_tmp65_ = self->priv->_is_allday;
			if (_tmp65_) {
				const gchar* _tmp66_;
				gchar* _tmp67_;
				_tmp66_ = start_date_string;
				_tmp67_ = g_strdup_printf ("%s", _tmp66_);
				_g_free0 (datetime_string);
				datetime_string = _tmp67_;
			} else {
				if (is_same_time) {
					const gchar* _tmp68_;
					const gchar* _tmp69_;
					gchar* _tmp70_;
					_tmp68_ = start_date_string;
					_tmp69_ = start_time_string;
					_tmp70_ = g_strdup_printf (_ ("%s at %s"), _tmp68_, _tmp69_);
					_g_free0 (datetime_string);
					datetime_string = _tmp70_;
				} else {
					const gchar* _tmp71_;
					const gchar* _tmp72_;
					const gchar* _tmp73_;
					gchar* _tmp74_;
					_tmp71_ = start_date_string;
					_tmp72_ = start_time_string;
					_tmp73_ = end_time_string;
					_tmp74_ = g_strdup_printf (_ ("%s, %s – %s"), _tmp71_, _tmp72_, _tmp73_);
					_g_free0 (datetime_string);
					datetime_string = _tmp74_;
				}
			}
		}
	}
	_tmp75_ = self->priv->datetime_label;
	_tmp76_ = datetime_string;
	gtk_label_set_label (_tmp75_, _tmp76_);
	_tmp79_ = maya_view_agenda_event_row_location_from_component (event, &_tmp77_, &_tmp78_);
	_g_free0 (location_description);
	location_description = _tmp77_;
	_g_free0 (location_uri);
	location_uri = _tmp78_;
	if (_tmp79_) {
		const gchar* _tmp80_;
		_tmp80_ = location_uri;
		if (g_strcmp0 (_tmp80_, "") != 0) {
			GtkLabel* _tmp81_;
			const gchar* _tmp82_;
			const gchar* _tmp83_;
			gchar* _tmp84_;
			gchar* _tmp85_;
			_tmp81_ = self->priv->location_label;
			_tmp82_ = location_uri;
			_tmp83_ = location_description;
			_tmp84_ = g_strdup_printf ("<a href=\"%s\">%s</a>", _tmp82_, _tmp83_);
			_tmp85_ = _tmp84_;
			gtk_label_set_label (_tmp81_, _tmp85_);
			_g_free0 (_tmp85_);
		} else {
			GtkLabel* _tmp86_;
			const gchar* _tmp87_;
			_tmp86_ = self->priv->location_label;
			_tmp87_ = location_description;
			gtk_label_set_label (_tmp86_, _tmp87_);
		}
	}
	_g_free0 (location_uri);
	_g_free0 (location_description);
	_g_free0 (datetime_string);
	_g_free0 (end_time_string);
	_g_free0 (start_time_string);
	_g_free0 (end_date_string);
	_g_free0 (start_date_string);
	_g_free0 (date_format);
	_g_date_time_unref0 (end_date);
	_g_date_time_unref0 (start_date);
	_g_free0 (icon_name_from_keywords);
	_g_free0 (event_name);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static void
maya_view_agenda_event_row_find_keywords (MayaViewAgendaEventRow* self,
                                          MayaViewAgendaEventRowCategory category,
                                          const gchar* phrase,
                                          MayaViewAgendaEventRowCategory* current_category,
                                          gint* current_hits)
{
	gint hits = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (phrase != NULL);
	hits = 0;
	{
		GeeIterator* _keyword_it = NULL;
		GeeHashMultiMap* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp0_ = self->priv->keyword_map;
		_tmp1_ = gee_multi_map_get ((GeeMultiMap*) _tmp0_, (gpointer) ((gintptr) category));
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_keyword_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			gchar* keyword = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			const gchar* _tmp8_;
			_tmp5_ = _keyword_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _keyword_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			keyword = (gchar*) _tmp7_;
			_tmp8_ = keyword;
			if (string_contains (phrase, _tmp8_)) {
				const gchar* _tmp9_;
				gint _tmp10_;
				gint _tmp11_;
				_tmp9_ = keyword;
				_tmp10_ = strlen (_tmp9_);
				_tmp11_ = _tmp10_;
				hits += _tmp11_;
			}
			_g_free0 (keyword);
		}
		_g_object_unref0 (_keyword_it);
	}
	if (hits > (*current_hits)) {
		*current_hits = hits;
		*current_category = category;
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static void
maya_view_agenda_event_row_reload_css (MayaViewAgendaEventRow* self,
                                       const gchar* background_color)
{
	GtkCssProvider* provider = NULL;
	GtkCssProvider* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (background_color != NULL);
	_tmp0_ = gtk_css_provider_new ();
	provider = _tmp0_;
	{
		gchar* colored_css = NULL;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		GtkStyleContext* _tmp7_;
		GtkStyleContext* _tmp8_;
		_tmp1_ = string_slice (background_color, (glong) 0, (glong) 7);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_strdup_printf (EVENT_CSS, _tmp2_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		colored_css = _tmp4_;
		_tmp5_ = strlen (colored_css);
		_tmp6_ = _tmp5_;
		gtk_css_provider_load_from_data (provider, colored_css, (gssize) _tmp6_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (colored_css);
			goto __catch0_g_error;
		}
		_tmp7_ = self->priv->event_image_context;
		gtk_style_context_add_provider (_tmp7_, (GtkStyleProvider*) provider, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
		_tmp8_ = self->priv->main_grid_context;
		gtk_style_context_add_provider (_tmp8_, (GtkStyleProvider*) provider, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
		_g_free0 (colored_css);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		g_critical ("AgendaEventRow.vala:391: %s", _tmp10_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (provider);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (provider);
}

static void
maya_view_agenda_event_row_split_keywords (MayaViewAgendaEventRow* self,
                                           MayaViewAgendaEventRowCategory category)
{
	gchar** words = NULL;
	const gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint words_length1;
	gint _words_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = maya_view_agenda_event_row_category_get_builtin_keywords (category);
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, ";", 0);
	words = _tmp2_;
	words_length1 = _vala_array_length (_tmp1_);
	_words_size_ = words_length1;
	_tmp3_ = words;
	_tmp3__length1 = words_length1;
	{
		gchar** word_collection = NULL;
		gint word_collection_length1 = 0;
		gint _word_collection_size_ = 0;
		gint word_it = 0;
		word_collection = _tmp3_;
		word_collection_length1 = _tmp3__length1;
		for (word_it = 0; word_it < word_collection_length1; word_it = word_it + 1) {
			const gchar* word = NULL;
			word = word_collection[word_it];
			{
				gboolean _tmp4_ = FALSE;
				const gchar* _tmp5_;
				_tmp5_ = word;
				if (_tmp5_ != NULL) {
					const gchar* _tmp6_;
					_tmp6_ = word;
					_tmp4_ = g_strcmp0 (_tmp6_, "") != 0;
				} else {
					_tmp4_ = FALSE;
				}
				if (_tmp4_) {
					GeeHashMultiMap* _tmp7_;
					const gchar* _tmp8_;
					_tmp7_ = self->priv->keyword_map;
					_tmp8_ = word;
					gee_multi_map_set ((GeeMultiMap*) _tmp7_, (gpointer) ((gintptr) category), _tmp8_);
				}
			}
		}
	}
	words = (_vala_array_free (words, words_length1, (GDestroyNotify) g_free), NULL);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gboolean
maya_view_agenda_event_row_location_from_component (ECalComponent* component,
                                                    gchar** description,
                                                    gchar** uri)
{
	gchar* _vala_description = NULL;
	gchar* _vala_uri = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	ICalComponent* icalcomponent = NULL;
	ICalComponent* _tmp2_;
	gboolean _tmp3_ = FALSE;
	ICalComponent* _tmp4_;
	ICalComponent* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	ICalProperty* geo_property = NULL;
	ICalComponent* _tmp11_;
	ICalProperty* _tmp12_;
	ICalProperty* _tmp13_;
	ICalProperty* apple_location_property = NULL;
	ICalComponent* _tmp22_;
	ICalProperty* _tmp23_;
	gboolean _tmp24_ = FALSE;
	ICalProperty* _tmp25_;
	gboolean result;
	g_return_val_if_fail (component != NULL, FALSE);
	_tmp0_ = g_strdup ("");
	_g_free0 (_vala_description);
	_vala_description = _tmp0_;
	_tmp1_ = g_strdup ("");
	_g_free0 (_vala_uri);
	_vala_uri = _tmp1_;
	_tmp2_ = e_cal_component_get_icalcomponent (component);
	icalcomponent = _tmp2_;
	_tmp4_ = icalcomponent;
	if (_tmp4_ == NULL) {
		_tmp3_ = TRUE;
	} else {
		ICalComponent* _tmp5_;
		const gchar* _tmp6_;
		_tmp5_ = icalcomponent;
		_tmp6_ = i_cal_component_get_location (_tmp5_);
		_tmp3_ = _tmp6_ == NULL;
	}
	if (_tmp3_) {
		result = FALSE;
		if (description) {
			*description = _vala_description;
		} else {
			_g_free0 (_vala_description);
		}
		if (uri) {
			*uri = _vala_uri;
		} else {
			_g_free0 (_vala_uri);
		}
		return result;
	}
	_tmp7_ = icalcomponent;
	_tmp8_ = i_cal_component_get_location (_tmp7_);
	_tmp9_ = g_strdup (_tmp8_);
	_g_free0 (_vala_description);
	_vala_description = _tmp9_;
	_tmp10_ = g_strdup ("");
	_g_free0 (_vala_uri);
	_vala_uri = _tmp10_;
	_tmp11_ = icalcomponent;
	_tmp12_ = i_cal_component_get_first_property (_tmp11_, I_CAL_GEO_PROPERTY);
	geo_property = _tmp12_;
	_tmp13_ = geo_property;
	if (_tmp13_ != NULL) {
		ICalGeo* geo = NULL;
		ICalProperty* _tmp14_;
		ICalGeo* _tmp15_;
		ICalGeo* _tmp16_;
		_tmp14_ = geo_property;
		_tmp15_ = i_cal_property_get_geo (_tmp14_);
		geo = _tmp15_;
		_tmp16_ = geo;
		if (_tmp16_ != NULL) {
			GeocodeLocation* location = NULL;
			ICalGeo* _tmp17_;
			ICalGeo* _tmp18_;
			GeocodeLocation* _tmp19_;
			GeocodeLocation* _tmp20_;
			gchar* _tmp21_;
			_tmp17_ = geo;
			_tmp18_ = geo;
			_tmp19_ = geocode_location_new (i_cal_geo_get_lat (_tmp17_), i_cal_geo_get_lon (_tmp18_), (gdouble) GEOCODE_LOCATION_ACCURACY_UNKNOWN);
			location = _tmp19_;
			_tmp20_ = location;
			_tmp21_ = geocode_location_to_uri (_tmp20_, GEOCODE_LOCATION_URI_SCHEME_GEO);
			_g_free0 (_vala_uri);
			_vala_uri = _tmp21_;
			_g_object_unref0 (location);
		}
		_g_object_unref0 (geo);
	}
	_tmp22_ = icalcomponent;
	_tmp23_ = e_cal_util_component_find_x_property (_tmp22_, "X-APPLE-STRUCTURED-LOCATION");
	apple_location_property = _tmp23_;
	_tmp25_ = apple_location_property;
	if (_tmp25_ != NULL) {
		ICalProperty* _tmp26_;
		ICalValue* _tmp27_;
		ICalValue* _tmp28_;
		_tmp26_ = apple_location_property;
		_tmp27_ = i_cal_property_get_value (_tmp26_);
		_tmp28_ = _tmp27_;
		_tmp24_ = _tmp28_ != NULL;
		_g_object_unref0 (_tmp28_);
	} else {
		_tmp24_ = FALSE;
	}
	if (_tmp24_) {
		gchar* address = NULL;
		gchar* title = NULL;
		ICalParameter* parameter = NULL;
		ICalProperty* _tmp29_;
		ICalParameter* _tmp30_;
		const gchar* _tmp45_;
		gboolean _tmp48_ = FALSE;
		const gchar* _tmp49_;
		gchar* location_value = NULL;
		ICalProperty* _tmp53_;
		gchar* _tmp54_;
		gboolean _tmp55_ = FALSE;
		const gchar* _tmp56_;
		address = NULL;
		title = NULL;
		_tmp29_ = apple_location_property;
		_tmp30_ = i_cal_property_get_first_parameter (_tmp29_, I_CAL_X_PARAMETER);
		parameter = _tmp30_;
		while (TRUE) {
			ICalParameter* _tmp31_;
			ICalParameter* _tmp32_;
			const gchar* _tmp33_;
			const gchar* _tmp34_;
			GQuark _tmp36_ = 0U;
			static GQuark _tmp35_label0 = 0;
			static GQuark _tmp35_label1 = 0;
			ICalProperty* _tmp43_;
			ICalParameter* _tmp44_;
			_tmp31_ = parameter;
			if (!(_tmp31_ != NULL)) {
				break;
			}
			_tmp32_ = parameter;
			_tmp33_ = i_cal_parameter_get_xname (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp36_ = (NULL == _tmp34_) ? 0 : g_quark_from_string (_tmp34_);
			if (_tmp36_ == ((0 != _tmp35_label0) ? _tmp35_label0 : (_tmp35_label0 = g_quark_from_static_string ("X-ADDRESS")))) {
				switch (0) {
					default:
					{
						ICalParameter* _tmp37_;
						const gchar* _tmp38_;
						gchar* _tmp39_;
						_tmp37_ = parameter;
						_tmp38_ = i_cal_parameter_get_xvalue (_tmp37_);
						_tmp39_ = g_strdup (_tmp38_);
						_g_free0 (address);
						address = _tmp39_;
						break;
					}
				}
			} else if (_tmp36_ == ((0 != _tmp35_label1) ? _tmp35_label1 : (_tmp35_label1 = g_quark_from_static_string ("X-TITLE")))) {
				switch (0) {
					default:
					{
						ICalParameter* _tmp40_;
						const gchar* _tmp41_;
						gchar* _tmp42_;
						_tmp40_ = parameter;
						_tmp41_ = i_cal_parameter_get_xvalue (_tmp40_);
						_tmp42_ = g_strdup (_tmp41_);
						_g_free0 (title);
						title = _tmp42_;
						break;
					}
				}
			} else {
				switch (0) {
					default:
					{
						break;
					}
				}
			}
			_tmp43_ = apple_location_property;
			_tmp44_ = i_cal_property_get_next_parameter (_tmp43_, I_CAL_X_PARAMETER);
			_g_object_unref0 (parameter);
			parameter = _tmp44_;
		}
		_tmp45_ = title;
		if (_tmp45_ != NULL) {
			const gchar* _tmp46_;
			gchar* _tmp47_;
			_tmp46_ = title;
			_tmp47_ = g_strdup (_tmp46_);
			_g_free0 (_vala_description);
			_vala_description = _tmp47_;
		}
		_tmp49_ = _vala_description;
		if (g_strcmp0 (_tmp49_, "") == 0) {
			const gchar* _tmp50_;
			_tmp50_ = address;
			_tmp48_ = _tmp50_ != NULL;
		} else {
			_tmp48_ = FALSE;
		}
		if (_tmp48_) {
			const gchar* _tmp51_;
			gchar* _tmp52_;
			_tmp51_ = address;
			_tmp52_ = g_strdup (_tmp51_);
			_g_free0 (_vala_description);
			_vala_description = _tmp52_;
		}
		_tmp53_ = apple_location_property;
		_tmp54_ = i_cal_property_get_value_as_string (_tmp53_);
		location_value = _tmp54_;
		_tmp56_ = location_value;
		if (_tmp56_ != NULL) {
			const gchar* _tmp57_;
			gchar* _tmp58_;
			gchar* _tmp59_;
			_tmp57_ = location_value;
			_tmp58_ = g_utf8_strdown (_tmp57_, (gssize) -1);
			_tmp59_ = _tmp58_;
			_tmp55_ = string_contains (_tmp59_, "geo:");
			_g_free0 (_tmp59_);
		} else {
			_tmp55_ = FALSE;
		}
		if (_tmp55_) {
			const gchar* _tmp60_;
			gchar* _tmp61_;
			gchar* _tmp62_;
			gchar* _tmp63_;
			_tmp60_ = location_value;
			_tmp61_ = g_utf8_strdown (_tmp60_, (gssize) -1);
			_tmp62_ = _tmp61_;
			_tmp63_ = string_replace (_tmp62_, "\\", "");
			_g_free0 (_vala_uri);
			_vala_uri = _tmp63_;
			_g_free0 (_tmp62_);
		}
		_g_free0 (location_value);
		_g_object_unref0 (parameter);
		_g_free0 (title);
		_g_free0 (address);
	}
	result = TRUE;
	_g_object_unref0 (apple_location_property);
	_g_object_unref0 (geo_property);
	if (description) {
		*description = _vala_description;
	} else {
		_g_free0 (_vala_description);
	}
	if (uri) {
		*uri = _vala_uri;
	} else {
		_g_free0 (_vala_uri);
	}
	return result;
}

ECalComponent*
maya_view_agenda_event_row_get_calevent (MayaViewAgendaEventRow* self)
{
	ECalComponent* result;
	ECalComponent* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_calevent;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
maya_view_agenda_event_row_set_calevent (MayaViewAgendaEventRow* self,
                                         ECalComponent* value)
{
	ECalComponent* old_value;
	g_return_if_fail (self != NULL);
	old_value = maya_view_agenda_event_row_get_calevent (self);
	if (old_value != value) {
		ECalComponent* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_calevent);
		self->priv->_calevent = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, maya_view_agenda_event_row_properties[MAYA_VIEW_AGENDA_EVENT_ROW_CALEVENT_PROPERTY]);
	}
}

ESource*
maya_view_agenda_event_row_get_source (MayaViewAgendaEventRow* self)
{
	ESource* result;
	ESource* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_source;
	result = _tmp0_;
	return result;
}

static void
maya_view_agenda_event_row_set_source (MayaViewAgendaEventRow* self,
                                       ESource* value)
{
	ESource* old_value;
	g_return_if_fail (self != NULL);
	old_value = maya_view_agenda_event_row_get_source (self);
	if (old_value != value) {
		ESource* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_source);
		self->priv->_source = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, maya_view_agenda_event_row_properties[MAYA_VIEW_AGENDA_EVENT_ROW_SOURCE_PROPERTY]);
	}
}

gboolean
maya_view_agenda_event_row_get_is_upcoming (MayaViewAgendaEventRow* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_upcoming;
	return result;
}

static void
maya_view_agenda_event_row_set_is_upcoming (MayaViewAgendaEventRow* self,
                                            gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = maya_view_agenda_event_row_get_is_upcoming (self);
	if (old_value != value) {
		self->priv->_is_upcoming = value;
		g_object_notify_by_pspec ((GObject *) self, maya_view_agenda_event_row_properties[MAYA_VIEW_AGENDA_EVENT_ROW_IS_UPCOMING_PROPERTY]);
	}
}

const gchar*
maya_view_agenda_event_row_get_summary (MayaViewAgendaEventRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_summary;
	result = _tmp0_;
	return result;
}

static void
maya_view_agenda_event_row_set_summary (MayaViewAgendaEventRow* self,
                                        const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = maya_view_agenda_event_row_get_summary (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_summary);
		self->priv->_summary = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, maya_view_agenda_event_row_properties[MAYA_VIEW_AGENDA_EVENT_ROW_SUMMARY_PROPERTY]);
	}
}

gboolean
maya_view_agenda_event_row_get_is_allday (MayaViewAgendaEventRow* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_allday;
	return result;
}

static void
maya_view_agenda_event_row_set_is_allday (MayaViewAgendaEventRow* self,
                                          gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = maya_view_agenda_event_row_get_is_allday (self);
	if (old_value != value) {
		self->priv->_is_allday = value;
		g_object_notify_by_pspec ((GObject *) self, maya_view_agenda_event_row_properties[MAYA_VIEW_AGENDA_EVENT_ROW_IS_ALLDAY_PROPERTY]);
	}
}

gboolean
maya_view_agenda_event_row_get_is_multiday (MayaViewAgendaEventRow* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_multiday;
	return result;
}

static void
maya_view_agenda_event_row_set_is_multiday (MayaViewAgendaEventRow* self,
                                            gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = maya_view_agenda_event_row_get_is_multiday (self);
	if (old_value != value) {
		self->priv->_is_multiday = value;
		g_object_notify_by_pspec ((GObject *) self, maya_view_agenda_event_row_properties[MAYA_VIEW_AGENDA_EVENT_ROW_IS_MULTIDAY_PROPERTY]);
	}
}

GtkRevealer*
maya_view_agenda_event_row_get_revealer (MayaViewAgendaEventRow* self)
{
	GtkRevealer* result;
	GtkRevealer* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_revealer;
	result = _tmp0_;
	return result;
}

static void
maya_view_agenda_event_row_set_revealer (MayaViewAgendaEventRow* self,
                                         GtkRevealer* value)
{
	GtkRevealer* old_value;
	g_return_if_fail (self != NULL);
	old_value = maya_view_agenda_event_row_get_revealer (self);
	if (old_value != value) {
		GtkRevealer* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_revealer);
		self->priv->_revealer = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, maya_view_agenda_event_row_properties[MAYA_VIEW_AGENDA_EVENT_ROW_REVEALER_PROPERTY]);
	}
}

static Block29Data*
block29_data_ref (Block29Data* _data29_)
{
	g_atomic_int_inc (&_data29_->_ref_count_);
	return _data29_;
}

static void
block29_data_unref (void * _userdata_)
{
	Block29Data* _data29_;
	_data29_ = (Block29Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data29_->_ref_count_)) {
		MayaViewAgendaEventRow* self;
		self = _data29_->self;
		_g_object_unref0 (_data29_->cal);
		_g_object_unref0 (_data29_->location_revealer);
		_g_object_unref0 (self);
		g_slice_free (Block29Data, _data29_);
	}
}

static void
_maya_view_agenda_event_row___lambda203_ (Block29Data* _data29_)
{
	MayaViewAgendaEventRow* self;
	ESourceCalendar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	self = _data29_->self;
	_tmp0_ = _data29_->cal;
	_tmp1_ = e_source_selectable_dup_color ((ESourceSelectable*) _tmp0_);
	_tmp2_ = _tmp1_;
	maya_view_agenda_event_row_reload_css (self, _tmp2_);
	_g_free0 (_tmp2_);
}

static void
__maya_view_agenda_event_row___lambda203__g_object_notify (GObject* _sender,
                                                           GParamSpec* pspec,
                                                           gpointer self)
{
	_maya_view_agenda_event_row___lambda203_ (self);
}

static void
_maya_view_agenda_event_row___lambda204_ (Block29Data* _data29_)
{
	MayaViewAgendaEventRow* self;
	gboolean _tmp0_ = FALSE;
	GtkLabel* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GtkRevealer* _tmp7_;
	self = _data29_->self;
	_tmp1_ = self->priv->location_label;
	_tmp2_ = gtk_label_get_label (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		GtkLabel* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp4_ = self->priv->location_label;
		_tmp5_ = gtk_label_get_label (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = g_strcmp0 (_tmp6_, "") != 0;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp7_ = _data29_->location_revealer;
	gtk_revealer_set_reveal_child (_tmp7_, _tmp0_);
}

static void
__maya_view_agenda_event_row___lambda204__g_object_notify (GObject* _sender,
                                                           GParamSpec* pspec,
                                                           gpointer self)
{
	_maya_view_agenda_event_row___lambda204_ (self);
}

static void
_maya_view_agenda_event_row___lambda205_ (MayaViewAgendaEventRow* self)
{
	GtkRevealer* _tmp0_;
	_tmp0_ = self->priv->_revealer;
	gtk_revealer_set_reveal_child (_tmp0_, TRUE);
}

static void
__maya_view_agenda_event_row___lambda205__gtk_widget_show (GtkWidget* _sender,
                                                           gpointer self)
{
	_maya_view_agenda_event_row___lambda205_ ((MayaViewAgendaEventRow*) self);
}

static void
_maya_view_agenda_event_row___lambda206_ (MayaViewAgendaEventRow* self)
{
	GtkRevealer* _tmp0_;
	_tmp0_ = self->priv->_revealer;
	gtk_revealer_set_reveal_child (_tmp0_, FALSE);
}

static void
__maya_view_agenda_event_row___lambda206__gtk_widget_hide (GtkWidget* _sender,
                                                           gpointer self)
{
	_maya_view_agenda_event_row___lambda206_ ((MayaViewAgendaEventRow*) self);
}

static void
_maya_view_agenda_event_row_on_button_press_gtk_gesture_multi_press_released (GtkGestureMultiPress* _sender,
                                                                              gint n_press,
                                                                              gdouble x,
                                                                              gdouble y,
                                                                              gpointer self)
{
	maya_view_agenda_event_row_on_button_press ((MayaViewAgendaEventRow*) self, n_press, x, y);
}

static GObject *
maya_view_agenda_event_row_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	MayaViewAgendaEventRow * self;
	Block29Data* _data29_;
	GeeHashMultiMap* _tmp0_;
	GtkCssProvider* css_provider = NULL;
	GtkCssProvider* _tmp3_;
	GtkCssProvider* _tmp4_;
	GtkImage* _tmp5_ = NULL;
	GtkImage* _tmp6_;
	GtkStyleContext* _tmp7_;
	GtkStyleContext* _tmp8_;
	GtkStyleContext* _tmp9_;
	GtkCssProvider* _tmp10_;
	GtkLabel* _tmp11_ = NULL;
	GtkStyleContext* name_label_context = NULL;
	GtkLabel* _tmp12_;
	GtkStyleContext* _tmp13_;
	GtkStyleContext* _tmp14_;
	GtkStyleContext* _tmp15_;
	GtkStyleContext* _tmp16_;
	GtkCssProvider* _tmp17_;
	GtkLabel* _tmp18_ = NULL;
	GtkLabel* _tmp19_;
	GtkStyleContext* _tmp20_;
	GtkLabel* _tmp21_;
	GtkStyleContext* _tmp22_;
	GtkLabel* _tmp23_ = NULL;
	GtkRevealer* _tmp24_;
	GtkRevealer* _tmp25_;
	GtkLabel* _tmp26_;
	GtkGrid* main_grid = NULL;
	GtkGrid* _tmp27_ = NULL;
	GtkGrid* _tmp28_;
	GtkImage* _tmp29_;
	GtkGrid* _tmp30_;
	GtkLabel* _tmp31_;
	GtkGrid* _tmp32_;
	GtkLabel* _tmp33_;
	GtkGrid* _tmp34_;
	GtkRevealer* _tmp35_;
	GtkGrid* _tmp36_;
	GtkStyleContext* _tmp37_;
	GtkStyleContext* _tmp38_;
	GtkStyleContext* _tmp39_;
	GtkStyleContext* _tmp40_;
	GtkCssProvider* _tmp41_;
	GtkEventBox* event_box = NULL;
	GtkGrid* _tmp42_;
	GtkWidget* _tmp43_;
	GtkEventBox* _tmp44_ = NULL;
	GtkEventBox* _tmp45_;
	GtkWidget* _tmp46_;
	GtkRevealer* _tmp47_ = NULL;
	GtkRevealer* _tmp48_;
	GtkRevealer* _tmp49_;
	ESource* _tmp50_;
	ESourceExtension* _tmp51_;
	ESourceCalendar* _tmp52_;
	ESourceCalendar* _tmp53_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	ESourceCalendar* _tmp56_;
	GtkLabel* _tmp57_;
	GtkGestureMultiPress* _tmp58_ = NULL;
	GtkGestureMultiPress* _tmp59_;
	ECalComponent* _tmp60_;
	parent_class = G_OBJECT_CLASS (maya_view_agenda_event_row_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAYA_VIEW_TYPE_AGENDA_EVENT_ROW, MayaViewAgendaEventRow);
	_data29_ = g_slice_new0 (Block29Data);
	_data29_->_ref_count_ = 1;
	_data29_->self = g_object_ref (self);
	_tmp0_ = gee_hash_multi_map_new (MAYA_VIEW_AGENDA_EVENT_ROW_TYPE_CATEGORY, NULL, NULL, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->keyword_map);
	self->priv->keyword_map = _tmp0_;
	{
		guint cat = 0U;
		cat = (guint) MAYA_VIEW_AGENDA_EVENT_ROW_CATEGORY_APPOINTMENT;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				if (!_tmp1_) {
					guint _tmp2_;
					_tmp2_ = cat;
					cat = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(cat < ((guint) MAYA_VIEW_AGENDA_EVENT_ROW_CATEGORY_N_CATEGORIES))) {
					break;
				}
				maya_view_agenda_event_row_split_keywords (self, (MayaViewAgendaEventRowCategory) cat);
			}
		}
	}
	_tmp3_ = gtk_css_provider_new ();
	css_provider = _tmp3_;
	_tmp4_ = css_provider;
	gtk_css_provider_load_from_resource (_tmp4_, "/io/elementary/calendar/AgendaEventRow.css");
	_tmp5_ = (GtkImage*) gtk_image_new_from_icon_name ("office-calendar-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	gtk_image_set_pixel_size (_tmp5_, 16);
	gtk_widget_set_valign ((GtkWidget*) _tmp5_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->event_image);
	self->priv->event_image = _tmp5_;
	_tmp6_ = self->priv->event_image;
	_tmp7_ = gtk_widget_get_style_context ((GtkWidget*) _tmp6_);
	_tmp8_ = _g_object_ref0 (_tmp7_);
	_g_object_unref0 (self->priv->event_image_context);
	self->priv->event_image_context = _tmp8_;
	_tmp9_ = self->priv->event_image_context;
	_tmp10_ = css_provider;
	gtk_style_context_add_provider (_tmp9_, (GtkStyleProvider*) _tmp10_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_tmp11_ = (GtkLabel*) gtk_label_new ("");
	gtk_label_set_selectable (_tmp11_, FALSE);
	g_object_set (_tmp11_, "wrap", TRUE, NULL);
	g_object_set (_tmp11_, "wrap-mode", PANGO_WRAP_WORD_CHAR, NULL);
	gtk_label_set_xalign (_tmp11_, (gfloat) 0);
	g_object_ref_sink (_tmp11_);
	_g_object_unref0 (self->priv->name_label);
	self->priv->name_label = _tmp11_;
	_tmp12_ = self->priv->name_label;
	_tmp13_ = gtk_widget_get_style_context ((GtkWidget*) _tmp12_);
	_tmp14_ = _g_object_ref0 (_tmp13_);
	name_label_context = _tmp14_;
	_tmp15_ = name_label_context;
	gtk_style_context_add_class (_tmp15_, "title");
	_tmp16_ = name_label_context;
	_tmp17_ = css_provider;
	gtk_style_context_add_provider (_tmp16_, (GtkStyleProvider*) _tmp17_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_tmp18_ = (GtkLabel*) gtk_label_new ("");
	gtk_label_set_ellipsize (_tmp18_, PANGO_ELLIPSIZE_END);
	gtk_widget_set_halign ((GtkWidget*) _tmp18_, GTK_ALIGN_START);
	gtk_label_set_selectable (_tmp18_, FALSE);
	gtk_label_set_use_markup (_tmp18_, TRUE);
	gtk_label_set_xalign (_tmp18_, (gfloat) 0);
	g_object_ref_sink (_tmp18_);
	_g_object_unref0 (self->priv->datetime_label);
	self->priv->datetime_label = _tmp18_;
	_tmp19_ = self->priv->datetime_label;
	_tmp20_ = gtk_widget_get_style_context ((GtkWidget*) _tmp19_);
	gtk_style_context_add_class (_tmp20_, GTK_STYLE_CLASS_DIM_LABEL);
	_tmp21_ = self->priv->datetime_label;
	_tmp22_ = gtk_widget_get_style_context ((GtkWidget*) _tmp21_);
	gtk_style_context_add_class (_tmp22_, GRANITE_STYLE_CLASS_SMALL_LABEL);
	_tmp23_ = (GtkLabel*) gtk_label_new ("");
	gtk_widget_set_margin_top ((GtkWidget*) _tmp23_, 6);
	gtk_label_set_selectable (_tmp23_, FALSE);
	gtk_label_set_use_markup (_tmp23_, TRUE);
	g_object_set (_tmp23_, "wrap", TRUE, NULL);
	g_object_set (_tmp23_, "wrap-mode", PANGO_WRAP_WORD_CHAR, NULL);
	gtk_label_set_xalign (_tmp23_, (gfloat) 0);
	g_object_ref_sink (_tmp23_);
	_g_object_unref0 (self->priv->location_label);
	self->priv->location_label = _tmp23_;
	_tmp24_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_ref_sink (_tmp24_);
	_data29_->location_revealer = _tmp24_;
	_tmp25_ = _data29_->location_revealer;
	_tmp26_ = self->priv->location_label;
	gtk_container_add ((GtkContainer*) _tmp25_, (GtkWidget*) _tmp26_);
	_tmp27_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_column_spacing (_tmp27_, 6);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp27_, 6);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp27_, 12);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp27_, 6);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp27_, 12);
	g_object_ref_sink (_tmp27_);
	main_grid = _tmp27_;
	_tmp28_ = main_grid;
	_tmp29_ = self->priv->event_image;
	gtk_grid_attach (_tmp28_, (GtkWidget*) _tmp29_, 0, 0, 1, 1);
	_tmp30_ = main_grid;
	_tmp31_ = self->priv->name_label;
	gtk_grid_attach (_tmp30_, (GtkWidget*) _tmp31_, 1, 0, 1, 1);
	_tmp32_ = main_grid;
	_tmp33_ = self->priv->datetime_label;
	gtk_grid_attach (_tmp32_, (GtkWidget*) _tmp33_, 1, 1, 1, 1);
	_tmp34_ = main_grid;
	_tmp35_ = _data29_->location_revealer;
	gtk_grid_attach (_tmp34_, (GtkWidget*) _tmp35_, 1, 2, 1, 1);
	_tmp36_ = main_grid;
	_tmp37_ = gtk_widget_get_style_context ((GtkWidget*) _tmp36_);
	_tmp38_ = _g_object_ref0 (_tmp37_);
	_g_object_unref0 (self->priv->main_grid_context);
	self->priv->main_grid_context = _tmp38_;
	_tmp39_ = self->priv->main_grid_context;
	gtk_style_context_add_class (_tmp39_, "event");
	_tmp40_ = self->priv->main_grid_context;
	_tmp41_ = css_provider;
	gtk_style_context_add_provider (_tmp40_, (GtkStyleProvider*) _tmp41_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_tmp42_ = main_grid;
	_tmp43_ = _g_object_ref0 ((GtkWidget*) _tmp42_);
	_tmp44_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_set ((GtkContainer*) _tmp44_, "child", _tmp43_, NULL);
	_g_object_unref0 (_tmp43_);
	g_object_ref_sink (_tmp44_);
	event_box = _tmp44_;
	_tmp45_ = event_box;
	_tmp46_ = _g_object_ref0 ((GtkWidget*) _tmp45_);
	_tmp47_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_set ((GtkContainer*) _tmp47_, "child", _tmp46_, NULL);
	_g_object_unref0 (_tmp46_);
	gtk_revealer_set_transition_type (_tmp47_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_DOWN);
	g_object_ref_sink (_tmp47_);
	_tmp48_ = _tmp47_;
	maya_view_agenda_event_row_set_revealer (self, _tmp48_);
	_g_object_unref0 (_tmp48_);
	_tmp49_ = self->priv->_revealer;
	g_object_set ((GtkContainer*) self, "child", (GtkWidget*) _tmp49_, NULL);
	_tmp50_ = self->priv->_source;
	_tmp51_ = e_source_get_extension (_tmp50_, E_SOURCE_EXTENSION_CALENDAR);
	_tmp52_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, e_source_calendar_get_type (), ESourceCalendar));
	_data29_->cal = _tmp52_;
	_tmp53_ = _data29_->cal;
	_tmp54_ = e_source_selectable_dup_color ((ESourceSelectable*) _tmp53_);
	_tmp55_ = _tmp54_;
	maya_view_agenda_event_row_reload_css (self, _tmp55_);
	_g_free0 (_tmp55_);
	_tmp56_ = _data29_->cal;
	g_signal_connect_data ((GObject*) _tmp56_, "notify::color", (GCallback) __maya_view_agenda_event_row___lambda203__g_object_notify, block29_data_ref (_data29_), (GClosureNotify) block29_data_unref, 0);
	_tmp57_ = self->priv->location_label;
	g_signal_connect_data ((GObject*) _tmp57_, "notify::label", (GCallback) __maya_view_agenda_event_row___lambda204__g_object_notify, block29_data_ref (_data29_), (GClosureNotify) block29_data_unref, 0);
	g_signal_connect_object ((GtkWidget*) self, "show", (GCallback) __maya_view_agenda_event_row___lambda205__gtk_widget_show, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "hide", (GCallback) __maya_view_agenda_event_row___lambda206__gtk_widget_hide, self, 0);
	_tmp58_ = (GtkGestureMultiPress*) gtk_gesture_multi_press_new ((GtkWidget*) self);
	gtk_gesture_single_set_button ((GtkGestureSingle*) _tmp58_, (guint) GDK_BUTTON_SECONDARY);
	gtk_event_controller_set_propagation_phase ((GtkEventController*) _tmp58_, GTK_PHASE_BUBBLE);
	_g_object_unref0 (self->priv->click_gesture);
	self->priv->click_gesture = _tmp58_;
	_tmp59_ = self->priv->click_gesture;
	g_signal_connect_object (_tmp59_, "released", (GCallback) _maya_view_agenda_event_row_on_button_press_gtk_gesture_multi_press_released, self, 0);
	_tmp60_ = self->priv->_calevent;
	maya_view_agenda_event_row_update (self, _tmp60_);
	_g_object_unref0 (event_box);
	_g_object_unref0 (main_grid);
	_g_object_unref0 (name_label_context);
	_g_object_unref0 (css_provider);
	block29_data_unref (_data29_);
	_data29_ = NULL;
	return obj;
}

static void
maya_view_agenda_event_row_class_init (MayaViewAgendaEventRowClass * klass,
                                       gpointer klass_data)
{
	maya_view_agenda_event_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MayaViewAgendaEventRow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_maya_view_agenda_event_row_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_maya_view_agenda_event_row_set_property;
	G_OBJECT_CLASS (klass)->constructor = maya_view_agenda_event_row_constructor;
	G_OBJECT_CLASS (klass)->finalize = maya_view_agenda_event_row_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAYA_VIEW_AGENDA_EVENT_ROW_CALEVENT_PROPERTY, maya_view_agenda_event_row_properties[MAYA_VIEW_AGENDA_EVENT_ROW_CALEVENT_PROPERTY] = g_param_spec_object ("calevent", "calevent", "calevent", e_cal_component_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAYA_VIEW_AGENDA_EVENT_ROW_SOURCE_PROPERTY, maya_view_agenda_event_row_properties[MAYA_VIEW_AGENDA_EVENT_ROW_SOURCE_PROPERTY] = g_param_spec_object ("source", "source", "source", e_source_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAYA_VIEW_AGENDA_EVENT_ROW_IS_UPCOMING_PROPERTY, maya_view_agenda_event_row_properties[MAYA_VIEW_AGENDA_EVENT_ROW_IS_UPCOMING_PROPERTY] = g_param_spec_boolean ("is-upcoming", "is-upcoming", "is-upcoming", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAYA_VIEW_AGENDA_EVENT_ROW_SUMMARY_PROPERTY, maya_view_agenda_event_row_properties[MAYA_VIEW_AGENDA_EVENT_ROW_SUMMARY_PROPERTY] = g_param_spec_string ("summary", "summary", "summary", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAYA_VIEW_AGENDA_EVENT_ROW_IS_ALLDAY_PROPERTY, maya_view_agenda_event_row_properties[MAYA_VIEW_AGENDA_EVENT_ROW_IS_ALLDAY_PROPERTY] = g_param_spec_boolean ("is-allday", "is-allday", "is-allday", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAYA_VIEW_AGENDA_EVENT_ROW_IS_MULTIDAY_PROPERTY, maya_view_agenda_event_row_properties[MAYA_VIEW_AGENDA_EVENT_ROW_IS_MULTIDAY_PROPERTY] = g_param_spec_boolean ("is-multiday", "is-multiday", "is-multiday", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAYA_VIEW_AGENDA_EVENT_ROW_REVEALER_PROPERTY, maya_view_agenda_event_row_properties[MAYA_VIEW_AGENDA_EVENT_ROW_REVEALER_PROPERTY] = g_param_spec_object ("revealer", "revealer", "revealer", gtk_revealer_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	maya_view_agenda_event_row_signals[MAYA_VIEW_AGENDA_EVENT_ROW_REMOVED_SIGNAL] = g_signal_new ("removed", MAYA_VIEW_TYPE_AGENDA_EVENT_ROW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, e_cal_component_get_type ());
}

static void
maya_view_agenda_event_row_instance_init (MayaViewAgendaEventRow * self,
                                          gpointer klass)
{
	self->priv = maya_view_agenda_event_row_get_instance_private (self);
	self->priv->_is_allday = FALSE;
	self->priv->_is_multiday = FALSE;
}

static void
maya_view_agenda_event_row_finalize (GObject * obj)
{
	MayaViewAgendaEventRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAYA_VIEW_TYPE_AGENDA_EVENT_ROW, MayaViewAgendaEventRow);
	_g_object_unref0 (self->priv->_calevent);
	_g_object_unref0 (self->priv->_source);
	_g_free0 (self->priv->_summary);
	_g_object_unref0 (self->priv->_revealer);
	_g_object_unref0 (self->priv->click_gesture);
	_g_object_unref0 (self->priv->event_image);
	_g_object_unref0 (self->priv->name_label);
	_g_object_unref0 (self->priv->datetime_label);
	_g_object_unref0 (self->priv->location_label);
	_g_object_unref0 (self->priv->event_image_context);
	_g_object_unref0 (self->priv->main_grid_context);
	_g_object_unref0 (self->priv->keyword_map);
	G_OBJECT_CLASS (maya_view_agenda_event_row_parent_class)->finalize (obj);
}

static GType
maya_view_agenda_event_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MayaViewAgendaEventRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) maya_view_agenda_event_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MayaViewAgendaEventRow), 0, (GInstanceInitFunc) maya_view_agenda_event_row_instance_init, NULL };
	GType maya_view_agenda_event_row_type_id;
	maya_view_agenda_event_row_type_id = g_type_register_static (gtk_list_box_row_get_type (), "MayaViewAgendaEventRow", &g_define_type_info, 0);
	MayaViewAgendaEventRow_private_offset = g_type_add_instance_private (maya_view_agenda_event_row_type_id, sizeof (MayaViewAgendaEventRowPrivate));
	return maya_view_agenda_event_row_type_id;
}

GType
maya_view_agenda_event_row_get_type (void)
{
	static volatile gsize maya_view_agenda_event_row_type_id__once = 0;
	if (g_once_init_enter (&maya_view_agenda_event_row_type_id__once)) {
		GType maya_view_agenda_event_row_type_id;
		maya_view_agenda_event_row_type_id = maya_view_agenda_event_row_get_type_once ();
		g_once_init_leave (&maya_view_agenda_event_row_type_id__once, maya_view_agenda_event_row_type_id);
	}
	return maya_view_agenda_event_row_type_id__once;
}

static void
_vala_maya_view_agenda_event_row_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec)
{
	MayaViewAgendaEventRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MAYA_VIEW_TYPE_AGENDA_EVENT_ROW, MayaViewAgendaEventRow);
	switch (property_id) {
		case MAYA_VIEW_AGENDA_EVENT_ROW_CALEVENT_PROPERTY:
		g_value_set_object (value, maya_view_agenda_event_row_get_calevent (self));
		break;
		case MAYA_VIEW_AGENDA_EVENT_ROW_SOURCE_PROPERTY:
		g_value_set_object (value, maya_view_agenda_event_row_get_source (self));
		break;
		case MAYA_VIEW_AGENDA_EVENT_ROW_IS_UPCOMING_PROPERTY:
		g_value_set_boolean (value, maya_view_agenda_event_row_get_is_upcoming (self));
		break;
		case MAYA_VIEW_AGENDA_EVENT_ROW_SUMMARY_PROPERTY:
		g_value_set_string (value, maya_view_agenda_event_row_get_summary (self));
		break;
		case MAYA_VIEW_AGENDA_EVENT_ROW_IS_ALLDAY_PROPERTY:
		g_value_set_boolean (value, maya_view_agenda_event_row_get_is_allday (self));
		break;
		case MAYA_VIEW_AGENDA_EVENT_ROW_IS_MULTIDAY_PROPERTY:
		g_value_set_boolean (value, maya_view_agenda_event_row_get_is_multiday (self));
		break;
		case MAYA_VIEW_AGENDA_EVENT_ROW_REVEALER_PROPERTY:
		g_value_set_object (value, maya_view_agenda_event_row_get_revealer (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_maya_view_agenda_event_row_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec)
{
	MayaViewAgendaEventRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MAYA_VIEW_TYPE_AGENDA_EVENT_ROW, MayaViewAgendaEventRow);
	switch (property_id) {
		case MAYA_VIEW_AGENDA_EVENT_ROW_CALEVENT_PROPERTY:
		maya_view_agenda_event_row_set_calevent (self, g_value_get_object (value));
		break;
		case MAYA_VIEW_AGENDA_EVENT_ROW_SOURCE_PROPERTY:
		maya_view_agenda_event_row_set_source (self, g_value_get_object (value));
		break;
		case MAYA_VIEW_AGENDA_EVENT_ROW_IS_UPCOMING_PROPERTY:
		maya_view_agenda_event_row_set_is_upcoming (self, g_value_get_boolean (value));
		break;
		case MAYA_VIEW_AGENDA_EVENT_ROW_SUMMARY_PROPERTY:
		maya_view_agenda_event_row_set_summary (self, g_value_get_string (value));
		break;
		case MAYA_VIEW_AGENDA_EVENT_ROW_IS_ALLDAY_PROPERTY:
		maya_view_agenda_event_row_set_is_allday (self, g_value_get_boolean (value));
		break;
		case MAYA_VIEW_AGENDA_EVENT_ROW_IS_MULTIDAY_PROPERTY:
		maya_view_agenda_event_row_set_is_multiday (self, g_value_get_boolean (value));
		break;
		case MAYA_VIEW_AGENDA_EVENT_ROW_REVEALER_PROPERTY:
		maya_view_agenda_event_row_set_revealer (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

