/* ExternalWindow.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from ExternalWindow.vala, do not modify */

/*-
 * Copyright 2021 elementary LLC <https://elementary.io>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor
 * Boston, MA 02110-1335 USA.
 *
 * Authored by: David Hewitt <davidmhewitt@gmail.com>
 */

#include <glib-object.h>
#include <gdk/gdk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <errno.h>
#include <gdk/gdkx.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/Xregion.h>
#include <gdk/gdkwayland.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_EXTERNAL_WINDOW (external_window_get_type ())
#define EXTERNAL_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXTERNAL_WINDOW, ExternalWindow))
#define IS_EXTERNAL_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXTERNAL_WINDOW))
#define EXTERNAL_WINDOW_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_EXTERNAL_WINDOW, ExternalWindowIface))

typedef struct _ExternalWindow ExternalWindow;
typedef struct _ExternalWindowIface ExternalWindowIface;

#define TYPE_EXTERNAL_WINDOW_X11 (external_window_x11_get_type ())
#define EXTERNAL_WINDOW_X11(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXTERNAL_WINDOW_X11, ExternalWindowX11))
#define EXTERNAL_WINDOW_X11_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXTERNAL_WINDOW_X11, ExternalWindowX11Class))
#define IS_EXTERNAL_WINDOW_X11(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXTERNAL_WINDOW_X11))
#define IS_EXTERNAL_WINDOW_X11_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXTERNAL_WINDOW_X11))
#define EXTERNAL_WINDOW_X11_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXTERNAL_WINDOW_X11, ExternalWindowX11Class))

typedef struct _ExternalWindowX11 ExternalWindowX11;
typedef struct _ExternalWindowX11Class ExternalWindowX11Class;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_EXTERNAL_WINDOW_WAYLAND (external_window_wayland_get_type ())
#define EXTERNAL_WINDOW_WAYLAND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXTERNAL_WINDOW_WAYLAND, ExternalWindowWayland))
#define EXTERNAL_WINDOW_WAYLAND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXTERNAL_WINDOW_WAYLAND, ExternalWindowWaylandClass))
#define IS_EXTERNAL_WINDOW_WAYLAND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXTERNAL_WINDOW_WAYLAND))
#define IS_EXTERNAL_WINDOW_WAYLAND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXTERNAL_WINDOW_WAYLAND))
#define EXTERNAL_WINDOW_WAYLAND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXTERNAL_WINDOW_WAYLAND, ExternalWindowWaylandClass))

typedef struct _ExternalWindowWayland ExternalWindowWayland;
typedef struct _ExternalWindowWaylandClass ExternalWindowWaylandClass;
typedef struct _ExternalWindowX11Private ExternalWindowX11Private;
enum  {
	EXTERNAL_WINDOW_X11_0_PROPERTY,
	EXTERNAL_WINDOW_X11_NUM_PROPERTIES
};
static GParamSpec* external_window_x11_properties[EXTERNAL_WINDOW_X11_NUM_PROPERTIES];
typedef struct _ExternalWindowWaylandPrivate ExternalWindowWaylandPrivate;
enum  {
	EXTERNAL_WINDOW_WAYLAND_0_PROPERTY,
	EXTERNAL_WINDOW_WAYLAND_NUM_PROPERTIES
};
static GParamSpec* external_window_wayland_properties[EXTERNAL_WINDOW_WAYLAND_NUM_PROPERTIES];

struct _ExternalWindowIface {
	GTypeInterface parent_iface;
	void (*set_parent_of) (ExternalWindow* self, GdkWindow* child_window);
};

struct _ExternalWindowX11 {
	GObject parent_instance;
	ExternalWindowX11Private * priv;
};

struct _ExternalWindowX11Class {
	GObjectClass parent_class;
};

struct _ExternalWindowX11Private {
	GdkWindow* foreign_gdk_window;
};

struct _ExternalWindowWayland {
	GObject parent_instance;
	ExternalWindowWaylandPrivate * priv;
};

struct _ExternalWindowWaylandClass {
	GObjectClass parent_class;
};

struct _ExternalWindowWaylandPrivate {
	gchar* handle;
};

static gint ExternalWindowX11_private_offset;
static gpointer external_window_x11_parent_class = NULL;
static GdkDisplay* external_window_x11_x11_display;
static GdkDisplay* external_window_x11_x11_display = NULL;
static ExternalWindowIface * external_window_x11_external_window_parent_iface = NULL;
static gint ExternalWindowWayland_private_offset;
static gpointer external_window_wayland_parent_class = NULL;
static GdkDisplay* external_window_wayland_wayland_display;
static GdkDisplay* external_window_wayland_wayland_display = NULL;
static ExternalWindowIface * external_window_wayland_external_window_parent_iface = NULL;

VALA_EXTERN GType external_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ExternalWindow, g_object_unref)
VALA_EXTERN void external_window_set_parent_of (ExternalWindow* self,
                                    GdkWindow* child_window);
VALA_EXTERN ExternalWindow* external_window_from_handle (const gchar* handle);
VALA_EXTERN GType external_window_x11_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ExternalWindowX11, g_object_unref)
VALA_EXTERN ExternalWindowX11* external_window_x11_new (const gchar* handle,
                                            GError** error);
VALA_EXTERN ExternalWindowX11* external_window_x11_construct (GType object_type,
                                                  const gchar* handle,
                                                  GError** error);
VALA_EXTERN GType external_window_wayland_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ExternalWindowWayland, g_object_unref)
VALA_EXTERN ExternalWindowWayland* external_window_wayland_new (const gchar* handle,
                                                    GError** error);
VALA_EXTERN ExternalWindowWayland* external_window_wayland_construct (GType object_type,
                                                          const gchar* handle,
                                                          GError** error);
static GType external_window_get_type_once (void);
static GdkDisplay* external_window_x11_get_x11_display (void);
static void external_window_x11_real_set_parent_of (ExternalWindow* base,
                                             GdkWindow* child_window);
static void external_window_x11_finalize (GObject * obj);
static GType external_window_x11_get_type_once (void);
static GdkDisplay* external_window_wayland_get_wayland_display (void);
static void external_window_wayland_real_set_parent_of (ExternalWindow* base,
                                                 GdkWindow* child_window);
static void external_window_wayland_finalize (GObject * obj);
static GType external_window_wayland_get_type_once (void);

void
external_window_set_parent_of (ExternalWindow* self,
                               GdkWindow* child_window)
{
	ExternalWindowIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = EXTERNAL_WINDOW_GET_INTERFACE (self);
	if (_iface_->set_parent_of) {
		_iface_->set_parent_of (self, child_window);
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

ExternalWindow*
external_window_from_handle (const gchar* handle)
{
	static const char X11_PREFIX[] = "x11:";
	static const char WAYLAND_PREFIX[] = "wayland:";
	ExternalWindow* external_window = NULL;
	GError* _inner_error0_ = NULL;
	ExternalWindow* result;
	g_return_val_if_fail (handle != NULL, NULL);
	external_window = NULL;
	if (g_str_has_prefix (handle, X11_PREFIX)) {
		{
			ExternalWindowX11* _tmp0_ = NULL;
			gint _tmp1_;
			gint _tmp2_;
			gchar* _tmp3_;
			gchar* _tmp4_;
			ExternalWindowX11* _tmp5_;
			ExternalWindowX11* _tmp6_;
			ExternalWindowX11* _tmp7_;
			_tmp1_ = strlen (X11_PREFIX);
			_tmp2_ = _tmp1_;
			_tmp3_ = string_substring (handle, (glong) _tmp2_, (glong) -1);
			_tmp4_ = _tmp3_;
			_tmp5_ = external_window_x11_new (_tmp4_, &_inner_error0_);
			_tmp6_ = _tmp5_;
			_g_free0 (_tmp4_);
			_tmp0_ = _tmp6_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp7_ = _tmp0_;
			_tmp0_ = NULL;
			_g_object_unref0 (external_window);
			external_window = (ExternalWindow*) _tmp7_;
			_g_object_unref0 (_tmp0_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp8_;
			const gchar* _tmp9_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp8_ = e;
			_tmp9_ = _tmp8_->message;
			g_warning ("ExternalWindow.vala:34: Error getting external X11 window: %s", _tmp9_);
			result = NULL;
			_g_error_free0 (e);
			_g_object_unref0 (external_window);
			return result;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (external_window);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	} else {
		if (g_str_has_prefix (handle, WAYLAND_PREFIX)) {
			{
				ExternalWindowWayland* _tmp10_ = NULL;
				gint _tmp11_;
				gint _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				ExternalWindowWayland* _tmp15_;
				ExternalWindowWayland* _tmp16_;
				ExternalWindowWayland* _tmp17_;
				_tmp11_ = strlen (WAYLAND_PREFIX);
				_tmp12_ = _tmp11_;
				_tmp13_ = string_substring (handle, (glong) _tmp12_, (glong) -1);
				_tmp14_ = _tmp13_;
				_tmp15_ = external_window_wayland_new (_tmp14_, &_inner_error0_);
				_tmp16_ = _tmp15_;
				_g_free0 (_tmp14_);
				_tmp10_ = _tmp16_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
				_tmp17_ = _tmp10_;
				_tmp10_ = NULL;
				_g_object_unref0 (external_window);
				external_window = (ExternalWindow*) _tmp17_;
				_g_object_unref0 (_tmp10_);
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* e = NULL;
				GError* _tmp18_;
				const gchar* _tmp19_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp18_ = e;
				_tmp19_ = _tmp18_->message;
				g_warning ("ExternalWindow.vala:41: Error getting external Wayland window: %s", _tmp19_);
				result = NULL;
				_g_error_free0 (e);
				_g_object_unref0 (external_window);
				return result;
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (external_window);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		} else {
			g_warning ("ExternalWindow.vala:45: Unhandled parent window type %s", handle);
		}
	}
	result = external_window;
	return result;
}

static void
external_window_default_init (ExternalWindowIface * iface,
                              gpointer iface_data)
{
}

 G_GNUC_NO_INLINE static GType
external_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ExternalWindowIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) external_window_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType external_window_type_id;
	external_window_type_id = g_type_register_static (G_TYPE_INTERFACE, "ExternalWindow", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (external_window_type_id, G_TYPE_OBJECT);
	return external_window_type_id;
}

GType
external_window_get_type (void)
{
	static volatile gsize external_window_type_id__once = 0;
	if (g_once_init_enter (&external_window_type_id__once)) {
		GType external_window_type_id;
		external_window_type_id = external_window_get_type_once ();
		g_once_init_leave (&external_window_type_id__once, external_window_type_id);
	}
	return external_window_type_id__once;
}

static inline gpointer
external_window_x11_get_instance_private (ExternalWindowX11* self)
{
	return G_STRUCT_MEMBER_P (self, ExternalWindowX11_private_offset);
}

static gboolean
int_try_parse (const gchar* str,
               gint* _result_,
               const gchar** unparsed,
               guint _base)
{
	gint _vala__result_ = 0;
	const gchar* _vala_unparsed = NULL;
	gchar* endptr = NULL;
	glong long_result = 0L;
	gchar* _tmp0_ = NULL;
	glong _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	glong _tmp6_;
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	errno = 0;
	_tmp1_ = strtol (str, &_tmp0_, (gint) _base);
	endptr = _tmp0_;
	long_result = _tmp1_;
	_tmp2_ = endptr;
	_tmp3_ = strlen (str);
	_tmp4_ = _tmp3_;
	if (_tmp2_ == (((gchar*) str) + _tmp4_)) {
		_vala_unparsed = "";
	} else {
		gchar* _tmp5_;
		_tmp5_ = endptr;
		_vala_unparsed = (const gchar*) _tmp5_;
	}
	_tmp6_ = long_result;
	if ((((glong) G_MININT) <= _tmp6_) && (_tmp6_ <= ((glong) G_MAXINT))) {
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		_vala__result_ = (gint) long_result;
		if (errno != ERANGE) {
			_tmp8_ = errno != EINVAL;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			const gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp9_ = _vala_unparsed;
			_tmp10_ = endptr;
			_tmp7_ = _tmp9_ != _tmp10_;
		} else {
			_tmp7_ = FALSE;
		}
		result = _tmp7_;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	} else {
		_vala__result_ = G_MAXINT;
		result = FALSE;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	}
}

ExternalWindowX11*
external_window_x11_construct (GType object_type,
                               const gchar* handle,
                               GError** error)
{
	ExternalWindowX11 * self = NULL;
	GdkDisplay* display = NULL;
	GdkDisplay* _tmp0_;
	GdkDisplay* _tmp1_;
	gint xid = 0;
	gint _tmp3_ = 0;
	gboolean _tmp4_;
	GdkDisplay* _tmp6_;
	GdkX11Window* _tmp7_;
	GdkWindow* _tmp8_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (handle != NULL, NULL);
	self = (ExternalWindowX11*) g_object_new (object_type, NULL);
	_tmp0_ = external_window_x11_get_x11_display ();
	display = _tmp0_;
	_tmp1_ = display;
	if (_tmp1_ == NULL) {
		GError* _tmp2_;
		_tmp2_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_FAILED, "No X display connection, ignoring X11 parent");
		_inner_error0_ = _tmp2_;
		if (_inner_error0_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (display);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_object_unref0 (display);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp4_ = int_try_parse (handle, &_tmp3_, NULL, (guint) 16);
	xid = _tmp3_;
	if (!_tmp4_) {
		GError* _tmp5_;
		_tmp5_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, "Failed to reference external X11 window, invalid XID %s", handle);
		_inner_error0_ = _tmp5_;
		if (_inner_error0_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (display);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_object_unref0 (display);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp6_ = display;
	_tmp7_ = (GdkX11Window*) gdk_x11_window_foreign_new_for_display (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gdk_x11_display_get_type (), GdkX11Display), (Window) xid);
	_g_object_unref0 (self->priv->foreign_gdk_window);
	self->priv->foreign_gdk_window = (GdkWindow*) _tmp7_;
	_tmp8_ = self->priv->foreign_gdk_window;
	if (_tmp8_ == NULL) {
		GError* _tmp9_;
		_tmp9_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, "Failed to create foreign window for XID %d", xid);
		_inner_error0_ = _tmp9_;
		if (_inner_error0_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (display);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_object_unref0 (display);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_g_object_unref0 (display);
	return self;
}

ExternalWindowX11*
external_window_x11_new (const gchar* handle,
                         GError** error)
{
	return external_window_x11_construct (TYPE_EXTERNAL_WINDOW_X11, handle, error);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GdkDisplay*
external_window_x11_get_x11_display (void)
{
	GdkDisplay* _tmp0_;
	GdkDisplay* _tmp3_;
	GdkDisplay* _tmp4_;
	GdkDisplay* _tmp5_;
	GdkDisplay* _tmp6_;
	GdkDisplay* _tmp7_;
	GdkDisplay* result;
	_tmp0_ = external_window_x11_x11_display;
	if (_tmp0_ != NULL) {
		GdkDisplay* _tmp1_;
		GdkDisplay* _tmp2_;
		_tmp1_ = external_window_x11_x11_display;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	}
	gdk_set_allowed_backends ("x11");
	_tmp3_ = gdk_display_open (NULL);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (external_window_x11_x11_display);
	external_window_x11_x11_display = _tmp4_;
	gdk_set_allowed_backends (NULL);
	_tmp5_ = external_window_x11_x11_display;
	if (_tmp5_ == NULL) {
		g_warning ("ExternalWindow.vala:84: Failed to open X11 display");
	}
	_tmp6_ = external_window_x11_x11_display;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	result = _tmp7_;
	return result;
}

static void
external_window_x11_real_set_parent_of (ExternalWindow* base,
                                        GdkWindow* child_window)
{
	ExternalWindowX11 * self;
	GdkWindow* _tmp0_;
	self = (ExternalWindowX11*) base;
	g_return_if_fail (child_window != NULL);
	_tmp0_ = self->priv->foreign_gdk_window;
	gdk_window_set_transient_for (child_window, _tmp0_);
}

static void
external_window_x11_class_init (ExternalWindowX11Class * klass,
                                gpointer klass_data)
{
	external_window_x11_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ExternalWindowX11_private_offset);
	G_OBJECT_CLASS (klass)->finalize = external_window_x11_finalize;
}

static void
external_window_x11_external_window_interface_init (ExternalWindowIface * iface,
                                                    gpointer iface_data)
{
	external_window_x11_external_window_parent_iface = g_type_interface_peek_parent (iface);
	iface->set_parent_of = (void (*) (ExternalWindow*, GdkWindow*)) external_window_x11_real_set_parent_of;
}

static void
external_window_x11_instance_init (ExternalWindowX11 * self,
                                   gpointer klass)
{
	self->priv = external_window_x11_get_instance_private (self);
}

static void
external_window_x11_finalize (GObject * obj)
{
	ExternalWindowX11 * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_EXTERNAL_WINDOW_X11, ExternalWindowX11);
	_g_object_unref0 (self->priv->foreign_gdk_window);
	G_OBJECT_CLASS (external_window_x11_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
external_window_x11_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ExternalWindowX11Class), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) external_window_x11_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ExternalWindowX11), 0, (GInstanceInitFunc) external_window_x11_instance_init, NULL };
	static const GInterfaceInfo external_window_info = { (GInterfaceInitFunc) external_window_x11_external_window_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType external_window_x11_type_id;
	external_window_x11_type_id = g_type_register_static (G_TYPE_OBJECT, "ExternalWindowX11", &g_define_type_info, 0);
	g_type_add_interface_static (external_window_x11_type_id, TYPE_EXTERNAL_WINDOW, &external_window_info);
	ExternalWindowX11_private_offset = g_type_add_instance_private (external_window_x11_type_id, sizeof (ExternalWindowX11Private));
	return external_window_x11_type_id;
}

GType
external_window_x11_get_type (void)
{
	static volatile gsize external_window_x11_type_id__once = 0;
	if (g_once_init_enter (&external_window_x11_type_id__once)) {
		GType external_window_x11_type_id;
		external_window_x11_type_id = external_window_x11_get_type_once ();
		g_once_init_leave (&external_window_x11_type_id__once, external_window_x11_type_id);
	}
	return external_window_x11_type_id__once;
}

static inline gpointer
external_window_wayland_get_instance_private (ExternalWindowWayland* self)
{
	return G_STRUCT_MEMBER_P (self, ExternalWindowWayland_private_offset);
}

ExternalWindowWayland*
external_window_wayland_construct (GType object_type,
                                   const gchar* handle,
                                   GError** error)
{
	ExternalWindowWayland * self = NULL;
	GdkDisplay* display = NULL;
	GdkDisplay* _tmp0_;
	GdkDisplay* _tmp1_;
	gchar* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (handle != NULL, NULL);
	self = (ExternalWindowWayland*) g_object_new (object_type, NULL);
	_tmp0_ = external_window_wayland_get_wayland_display ();
	display = _tmp0_;
	_tmp1_ = display;
	if (_tmp1_ == NULL) {
		GError* _tmp2_;
		_tmp2_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_FAILED, "No Wayland display connection, ignoring Wayland parent");
		_inner_error0_ = _tmp2_;
		if (_inner_error0_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (display);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_object_unref0 (display);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp3_ = g_strdup (handle);
	_g_free0 (self->priv->handle);
	self->priv->handle = _tmp3_;
	_g_object_unref0 (display);
	return self;
}

ExternalWindowWayland*
external_window_wayland_new (const gchar* handle,
                             GError** error)
{
	return external_window_wayland_construct (TYPE_EXTERNAL_WINDOW_WAYLAND, handle, error);
}

static GdkDisplay*
external_window_wayland_get_wayland_display (void)
{
	GdkDisplay* _tmp0_;
	GdkDisplay* _tmp3_;
	GdkDisplay* _tmp4_;
	GdkDisplay* _tmp5_;
	GdkDisplay* _tmp6_;
	GdkDisplay* _tmp7_;
	GdkDisplay* result;
	_tmp0_ = external_window_wayland_wayland_display;
	if (_tmp0_ != NULL) {
		GdkDisplay* _tmp1_;
		GdkDisplay* _tmp2_;
		_tmp1_ = external_window_wayland_wayland_display;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	}
	gdk_set_allowed_backends ("wayland");
	_tmp3_ = gdk_display_open (NULL);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (external_window_wayland_wayland_display);
	external_window_wayland_wayland_display = _tmp4_;
	gdk_set_allowed_backends (NULL);
	_tmp5_ = external_window_wayland_wayland_display;
	if (_tmp5_ == NULL) {
		g_warning ("ExternalWindow.vala:119: Failed to open Wayland display");
	}
	_tmp6_ = external_window_wayland_wayland_display;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	result = _tmp7_;
	return result;
}

static void
external_window_wayland_real_set_parent_of (ExternalWindow* base,
                                            GdkWindow* child_window)
{
	ExternalWindowWayland * self;
	const gchar* _tmp0_;
	self = (ExternalWindowWayland*) base;
	g_return_if_fail (child_window != NULL);
	_tmp0_ = self->priv->handle;
	if (!gdk_wayland_window_set_transient_for_exported (G_TYPE_CHECK_INSTANCE_CAST (child_window, GDK_TYPE_WAYLAND_WINDOW, GdkWaylandWindow), _tmp0_)) {
		g_warning ("ExternalWindow.vala:127: Failed to set portal window transient for ext" \
"ernal parent");
	}
}

static void
external_window_wayland_class_init (ExternalWindowWaylandClass * klass,
                                    gpointer klass_data)
{
	external_window_wayland_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ExternalWindowWayland_private_offset);
	G_OBJECT_CLASS (klass)->finalize = external_window_wayland_finalize;
}

static void
external_window_wayland_external_window_interface_init (ExternalWindowIface * iface,
                                                        gpointer iface_data)
{
	external_window_wayland_external_window_parent_iface = g_type_interface_peek_parent (iface);
	iface->set_parent_of = (void (*) (ExternalWindow*, GdkWindow*)) external_window_wayland_real_set_parent_of;
}

static void
external_window_wayland_instance_init (ExternalWindowWayland * self,
                                       gpointer klass)
{
	self->priv = external_window_wayland_get_instance_private (self);
}

static void
external_window_wayland_finalize (GObject * obj)
{
	ExternalWindowWayland * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_EXTERNAL_WINDOW_WAYLAND, ExternalWindowWayland);
	_g_free0 (self->priv->handle);
	G_OBJECT_CLASS (external_window_wayland_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
external_window_wayland_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ExternalWindowWaylandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) external_window_wayland_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ExternalWindowWayland), 0, (GInstanceInitFunc) external_window_wayland_instance_init, NULL };
	static const GInterfaceInfo external_window_info = { (GInterfaceInitFunc) external_window_wayland_external_window_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType external_window_wayland_type_id;
	external_window_wayland_type_id = g_type_register_static (G_TYPE_OBJECT, "ExternalWindowWayland", &g_define_type_info, 0);
	g_type_add_interface_static (external_window_wayland_type_id, TYPE_EXTERNAL_WINDOW, &external_window_info);
	ExternalWindowWayland_private_offset = g_type_add_instance_private (external_window_wayland_type_id, sizeof (ExternalWindowWaylandPrivate));
	return external_window_wayland_type_id;
}

GType
external_window_wayland_get_type (void)
{
	static volatile gsize external_window_wayland_type_id__once = 0;
	if (g_once_init_enter (&external_window_wayland_type_id__once)) {
		GType external_window_wayland_type_id;
		external_window_wayland_type_id = external_window_wayland_get_type_once ();
		g_once_init_leave (&external_window_wayland_type_id__once, external_window_wayland_type_id);
	}
	return external_window_wayland_type_id__once;
}

