/* MoveOperation.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from MoveOperation.vala, do not modify */

/*-
 * Copyright 2018-2019 elementary, Inc. (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: David Hewitt <davidmhewitt@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <camel/camel.h>
#include <gee.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>

#define MAIL_MOVE_OPERATION_TIMEOUT_DURATION 5
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_MOVE_ERROR (move_error_get_type ())

#define MAIL_TYPE_MOVE_OPERATION (mail_move_operation_get_type ())
#define MAIL_MOVE_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_TYPE_MOVE_OPERATION, MailMoveOperation))
#define MAIL_MOVE_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_TYPE_MOVE_OPERATION, MailMoveOperationClass))
#define MAIL_IS_MOVE_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_TYPE_MOVE_OPERATION))
#define MAIL_IS_MOVE_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_TYPE_MOVE_OPERATION))
#define MAIL_MOVE_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_TYPE_MOVE_OPERATION, MailMoveOperationClass))

typedef struct _MailMoveOperation MailMoveOperation;
typedef struct _MailMoveOperationClass MailMoveOperationClass;
typedef struct _MailMoveOperationPrivate MailMoveOperationPrivate;
typedef enum  {
	MAIL_MOVE_OPERATION_MOVE_TYPE_ARCHIVE,
	MAIL_MOVE_OPERATION_MOVE_TYPE_MOVE,
	MAIL_MOVE_OPERATION_MOVE_TYPE_TRASH,
	MAIL_MOVE_OPERATION_MOVE_TYPE_VTRASH
} MailMoveOperationMoveType;

#define MAIL_MOVE_OPERATION_TYPE_MOVE_TYPE (mail_move_operation_move_type_get_type ())
enum  {
	MAIL_MOVE_OPERATION_0_PROPERTY,
	MAIL_MOVE_OPERATION_NUM_PROPERTIES
};
static GParamSpec* mail_move_operation_properties[MAIL_MOVE_OPERATION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _MailMoveOperationNewData MailMoveOperationNewData;
#define __vala_CamelURL_free0(var) ((var == NULL) ? NULL : (var = (_vala_CamelURL_free (var), NULL)))

#define MAIL_BACKEND_TYPE_SESSION (mail_backend_session_get_type ())
#define MAIL_BACKEND_SESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_BACKEND_TYPE_SESSION, MailBackendSession))
#define MAIL_BACKEND_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_BACKEND_TYPE_SESSION, MailBackendSessionClass))
#define MAIL_BACKEND_IS_SESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_BACKEND_TYPE_SESSION))
#define MAIL_BACKEND_IS_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_BACKEND_TYPE_SESSION))
#define MAIL_BACKEND_SESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_BACKEND_TYPE_SESSION, MailBackendSessionClass))

typedef struct _MailBackendSession MailBackendSession;
typedef struct _MailBackendSessionClass MailBackendSessionClass;
typedef struct _MailMoveOperationSetDstFolderForUriData MailMoveOperationSetDstFolderForUriData;
typedef struct _MailMoveOperationCollectThreadMessagesData MailMoveOperationCollectThreadMessagesData;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _MailMoveOperationFinishData MailMoveOperationFinishData;
enum  {
	MAIL_MOVE_OPERATION_UNDONE_SIGNAL,
	MAIL_MOVE_OPERATION_NUM_SIGNALS
};
static guint mail_move_operation_signals[MAIL_MOVE_OPERATION_NUM_SIGNALS] = {0};

typedef enum  {
	MOVE_ERROR_DST_FOLDER_NOT_FOUND,
	MOVE_ERROR_FAILED
} MoveError;
#define MOVE_ERROR move_error_quark ()

struct _MailMoveOperation {
	GObject parent_instance;
	MailMoveOperationPrivate * priv;
};

struct _MailMoveOperationClass {
	GObjectClass parent_class;
};

struct _MailMoveOperationPrivate {
	CamelFolder* src_folder;
	CamelFolder* dst_folder;
	MailMoveOperationMoveType move_type;
	GeeArrayList* moved_messages;
	guint timeout_id;
};

struct _MailMoveOperationNewData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GType object_type;
	MailMoveOperation* self;
	CamelFolder* _src_folder;
	MailMoveOperationMoveType _move_type;
	GeeArrayList* threads;
	GVariant* dst_folder_full_name;
	guint n_messages_moved;
	CamelFolder* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _thread_list;
	gint _thread_size;
	GeeArrayList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _thread_index;
	gint _tmp5_;
	gint _tmp6_;
	CamelFolderThreadNode* thread;
	GeeArrayList* _tmp7_;
	gpointer _tmp8_;
	CamelFolderThreadNode* _tmp9_;
	gchar* archive_folder_uri;
	gchar* _tmp10_;
	gboolean _tmp11_;
	const gchar* _tmp12_;
	GError* _tmp13_;
	CamelStore* store;
	CamelFolder* _tmp14_;
	CamelStore* _tmp15_;
	CamelStore* _tmp16_;
	CamelStore* _tmp17_;
	CamelFolder* _tmp18_;
	CamelStore* _tmp19_;
	const gchar* _tmp20_;
	CamelFolder* _tmp21_;
	CamelFolder* _tmp22_;
	CamelStore* _vala1_store;
	CamelFolder* _tmp23_;
	CamelStore* _tmp24_;
	CamelStore* _tmp25_;
	CamelStore* _tmp26_;
	CamelStore* _tmp27_;
	CamelFolder* _tmp28_;
	CamelStore* _tmp29_;
	CamelFolder* _tmp30_;
	CamelFolder* _tmp31_;
	GError* _tmp32_;
	gboolean _tmp33_;
	CamelFolder* _tmp34_;
	GError* _tmp35_;
	CamelFolder* _tmp36_;
	CamelFolder* _tmp37_;
	GError* _tmp38_;
	MailMoveOperation* _tmp39_;
	GeeArrayList* _tmp40_;
	gint _tmp41_;
	gint _tmp42_;
	GeeArrayList* _tmp43_;
	gint _tmp44_;
	gint _tmp45_;
	GError* _inner_error0_;
};

struct _MailMoveOperationSetDstFolderForUriData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	MailMoveOperation* self;
	gchar* uri;
	gboolean result;
	CamelURL* url;
	CamelURL* _tmp0_;
	CamelURL* _tmp1_;
	CamelURL* _tmp2_;
	CamelURL* _tmp3_;
	CamelService* service;
	gchar* parsed_folder_name;
	CamelURL* _tmp4_;
	const gchar* _tmp5_;
	CamelURL* _tmp6_;
	const gchar* _tmp7_;
	gchar* uid;
	gboolean _tmp8_;
	CamelURL* _tmp9_;
	const gchar* _tmp10_;
	CamelURL* _tmp11_;
	const gchar* _tmp12_;
	CamelURL* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	CamelURL* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	CamelURL* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	MailBackendSession* _tmp23_;
	const gchar* _tmp24_;
	CamelService* _tmp25_;
	gboolean _tmp26_;
	CamelURL* _tmp27_;
	const gchar* _tmp28_;
	CamelURL* _tmp29_;
	const gchar* _tmp30_;
	CamelURL* _tmp31_;
	const gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gboolean _tmp36_;
	gboolean _tmp37_;
	CamelService* _tmp38_;
	CamelService* _tmp39_;
	const gchar* _tmp40_;
	CamelFolder* _tmp41_;
	CamelService* _tmp42_;
	const gchar* _tmp43_;
	CamelFolder* _tmp44_;
	CamelFolder* _tmp45_;
	GError* _inner_error0_;
};

struct _MailMoveOperationCollectThreadMessagesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	MailMoveOperation* self;
	CamelFolderThreadNode* thread;
	GeeArrayList* _tmp0_;
	void* _tmp1_;
	CamelFolderThreadNode* child;
	CamelFolderThreadNode* _tmp2_;
	CamelFolderThreadNode* _tmp3_;
	CamelFolderThreadNode* _tmp4_;
	CamelFolderThreadNode* _tmp5_;
	CamelFolderThreadNode* _tmp6_;
};

struct _MailMoveOperationFinishData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	MailMoveOperation* self;
	MailMoveOperation* _tmp0_;
	GeeArrayList* _message_list;
	GeeArrayList* _tmp1_;
	gint _message_size;
	GeeArrayList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _message_index;
	gint _tmp5_;
	gint _tmp6_;
	CamelMessageInfo* message;
	GeeArrayList* _tmp7_;
	gpointer _tmp8_;
	CamelMessageInfo* _tmp9_;
	GeeArrayList* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	GPtrArray* message_uids;
	GPtrArray* _tmp13_;
	GeeArrayList* _vala1__message_list;
	GeeArrayList* _tmp14_;
	gint _vala1__message_size;
	GeeArrayList* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	gint _vala1__message_index;
	gint _tmp18_;
	gint _tmp19_;
	CamelMessageInfo* _vala1_message;
	GeeArrayList* _tmp20_;
	gpointer _tmp21_;
	GPtrArray* _tmp22_;
	CamelMessageInfo* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	CamelFolder* _tmp27_;
	CamelFolder* _tmp28_;
	gboolean _tmp29_;
	CamelFolder* _tmp30_;
	GPtrArray* _tmp31_;
	CamelFolder* _tmp32_;
	GError* _tmp33_;
	CamelFolder* _tmp34_;
	CamelFolder* _tmp35_;
	GeeArrayList* _tmp36_;
	gint _tmp37_;
	gint _tmp38_;
	GError* _inner_error0_;
};

static gint MailMoveOperation_private_offset;
static gpointer mail_move_operation_parent_class = NULL;
static gint mail_move_operation_n_messages_queued;
static gint mail_move_operation_n_messages_queued = 0;
static MailMoveOperation* mail_move_operation_last_move_operation;
static MailMoveOperation* mail_move_operation_last_move_operation = NULL;
static GtkSpinner* mail_move_operation_spinner;
static GtkSpinner* mail_move_operation_spinner = NULL;

VALA_EXTERN GQuark move_error_quark (void);
VALA_EXTERN GType move_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType mail_move_operation_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailMoveOperation, g_object_unref)
VALA_EXTERN GType mail_move_operation_move_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void mail_move_operation_undo_last_move (void);
static void mail_move_operation_update_queue (gint change);
VALA_EXTERN void mail_move_operation_bind_spinner (GtkSpinner* _spinner);
static void mail_move_operation_construct_data_free (gpointer _data);
VALA_EXTERN void mail_move_operation_new (CamelFolder* _src_folder,
                              MailMoveOperationMoveType _move_type,
                              GeeArrayList* threads,
                              GVariant* dst_folder_full_name,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_);
VALA_EXTERN MailMoveOperation* mail_move_operation_new_finish (GAsyncResult* _res_,
                                                   guint* n_messages_moved,
                                                   GError** error);
VALA_EXTERN void mail_move_operation_construct (GType object_type,
                                    CamelFolder* _src_folder,
                                    MailMoveOperationMoveType _move_type,
                                    GeeArrayList* threads,
                                    GVariant* dst_folder_full_name,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
VALA_EXTERN MailMoveOperation* mail_move_operation_construct_finish (GAsyncResult* _res_,
                                                         guint* n_messages_moved,
                                                         GError** error);
static gboolean mail_move_operation_construct_co (MailMoveOperationNewData* _data_);
static void mail_move_operation_collect_thread_messages (MailMoveOperation* self,
                                                  CamelFolderThreadNode* thread,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_);
static void mail_move_operation_collect_thread_messages_finish (MailMoveOperation* self,
                                                         GAsyncResult* _res_);
static void mail_move_operation_new_ready (GObject* source_object,
                                    GAsyncResult* _res_,
                                    gpointer _user_data_);
static gchar* mail_move_operation_get_archive_folder_uri (MailMoveOperation* self);
static void mail_move_operation_set_dst_folder_for_uri (MailMoveOperation* self,
                                                 const gchar* uri,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_);
static gboolean mail_move_operation_set_dst_folder_for_uri_finish (MailMoveOperation* self,
                                                            GAsyncResult* _res_,
                                                            GError** error);
static gboolean __lambda41_ (MailMoveOperation* self);
static void mail_move_operation_finish (MailMoveOperation* self,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_);
static void mail_move_operation_finish_finish (MailMoveOperation* self,
                                        GAsyncResult* _res_,
                                        GError** error);
static void __lambda42_ (MailMoveOperation* self,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda42__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static gboolean ___lambda41__gsource_func (gpointer self);
static void mail_move_operation_set_dst_folder_for_uri_data_free (gpointer _data);
static gboolean mail_move_operation_set_dst_folder_for_uri_co (MailMoveOperationSetDstFolderForUriData* _data_);
static void _vala_CamelURL_free (CamelURL* self);
VALA_EXTERN GType mail_backend_session_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailBackendSession, g_object_unref)
VALA_EXTERN MailBackendSession* mail_backend_session_get_default (void);
static void mail_move_operation_set_dst_folder_for_uri_ready (GObject* source_object,
                                                       GAsyncResult* _res_,
                                                       gpointer _user_data_);
VALA_EXTERN gchar* mail_backend_session_get_archive_folder_uri_for_service (MailBackendSession* self,
                                                                CamelService* service);
static void mail_move_operation_collect_thread_messages_data_free (gpointer _data);
static gboolean mail_move_operation_collect_thread_messages_co (MailMoveOperationCollectThreadMessagesData* _data_);
static void mail_move_operation_collect_thread_messages_ready (GObject* source_object,
                                                        GAsyncResult* _res_,
                                                        gpointer _user_data_);
static void mail_move_operation_finish_data_free (gpointer _data);
static gboolean mail_move_operation_finish_co (MailMoveOperationFinishData* _data_);
static void _g_free0_ (gpointer var);
static void mail_move_operation_finish_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_);
static void mail_move_operation_finalize (GObject * obj);
static GType mail_move_operation_get_type_once (void);

GQuark
move_error_quark (void)
{
	return g_quark_from_static_string ("move-error-quark");
}

static GType
move_error_get_type_once (void)
{
	static const GEnumValue values[] = {{MOVE_ERROR_DST_FOLDER_NOT_FOUND, "MOVE_ERROR_DST_FOLDER_NOT_FOUND", "dst-folder-not-found"}, {MOVE_ERROR_FAILED, "MOVE_ERROR_FAILED", "failed"}, {0, NULL, NULL}};
	GType move_error_type_id;
	move_error_type_id = g_enum_register_static ("MoveError", values);
	return move_error_type_id;
}

GType
move_error_get_type (void)
{
	static volatile gsize move_error_type_id__once = 0;
	if (g_once_init_enter (&move_error_type_id__once)) {
		GType move_error_type_id;
		move_error_type_id = move_error_get_type_once ();
		g_once_init_leave (&move_error_type_id__once, move_error_type_id);
	}
	return move_error_type_id__once;
}

static inline gpointer
mail_move_operation_get_instance_private (MailMoveOperation* self)
{
	return G_STRUCT_MEMBER_P (self, MailMoveOperation_private_offset);
}

static GType
mail_move_operation_move_type_get_type_once (void)
{
	static const GEnumValue values[] = {{MAIL_MOVE_OPERATION_MOVE_TYPE_ARCHIVE, "MAIL_MOVE_OPERATION_MOVE_TYPE_ARCHIVE", "archive"}, {MAIL_MOVE_OPERATION_MOVE_TYPE_MOVE, "MAIL_MOVE_OPERATION_MOVE_TYPE_MOVE", "move"}, {MAIL_MOVE_OPERATION_MOVE_TYPE_TRASH, "MAIL_MOVE_OPERATION_MOVE_TYPE_TRASH", "trash"}, {MAIL_MOVE_OPERATION_MOVE_TYPE_VTRASH, "MAIL_MOVE_OPERATION_MOVE_TYPE_VTRASH", "vtrash"}, {0, NULL, NULL}};
	GType mail_move_operation_move_type_type_id;
	mail_move_operation_move_type_type_id = g_enum_register_static ("MailMoveOperationMoveType", values);
	return mail_move_operation_move_type_type_id;
}

GType
mail_move_operation_move_type_get_type (void)
{
	static volatile gsize mail_move_operation_move_type_type_id__once = 0;
	if (g_once_init_enter (&mail_move_operation_move_type_type_id__once)) {
		GType mail_move_operation_move_type_type_id;
		mail_move_operation_move_type_type_id = mail_move_operation_move_type_get_type_once ();
		g_once_init_leave (&mail_move_operation_move_type_type_id__once, mail_move_operation_move_type_type_id);
	}
	return mail_move_operation_move_type_type_id__once;
}

void
mail_move_operation_undo_last_move (void)
{
	MailMoveOperation* _tmp0_;
	MailMoveOperation* _tmp1_;
	MailMoveOperation* _tmp2_;
	GeeArrayList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	MailMoveOperation* _tmp6_;
	_tmp0_ = mail_move_operation_last_move_operation;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = mail_move_operation_last_move_operation;
	g_source_remove (_tmp1_->priv->timeout_id);
	_tmp2_ = mail_move_operation_last_move_operation;
	_tmp3_ = _tmp2_->priv->moved_messages;
	_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	mail_move_operation_update_queue (-_tmp5_);
	_tmp6_ = mail_move_operation_last_move_operation;
	g_signal_emit (_tmp6_, mail_move_operation_signals[MAIL_MOVE_OPERATION_UNDONE_SIGNAL], 0);
	_g_object_unref0 (mail_move_operation_last_move_operation);
	mail_move_operation_last_move_operation = NULL;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
mail_move_operation_bind_spinner (GtkSpinner* _spinner)
{
	GtkSpinner* _tmp0_;
	g_return_if_fail (_spinner != NULL);
	_tmp0_ = _g_object_ref0 (_spinner);
	_g_object_unref0 (mail_move_operation_spinner);
	mail_move_operation_spinner = _tmp0_;
}

static void
mail_move_operation_update_queue (gint change)
{
	GtkSpinner* _tmp0_;
	mail_move_operation_n_messages_queued = mail_move_operation_n_messages_queued + change;
	_tmp0_ = mail_move_operation_spinner;
	if (_tmp0_ == NULL) {
		return;
	}
	if (mail_move_operation_n_messages_queued == 0) {
		GtkSpinner* _tmp1_;
		_tmp1_ = mail_move_operation_spinner;
		gtk_widget_hide ((GtkWidget*) _tmp1_);
	} else {
		GtkSpinner* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GtkSpinner* _tmp5_;
		_tmp2_ = mail_move_operation_spinner;
		_tmp3_ = g_strdup_printf (_ ("Moving messages… (%u remaining)"), (guint) mail_move_operation_n_messages_queued);
		_tmp4_ = _tmp3_;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp2_, _tmp4_);
		_g_free0 (_tmp4_);
		_tmp5_ = mail_move_operation_spinner;
		gtk_widget_show ((GtkWidget*) _tmp5_);
	}
}

static void
mail_move_operation_construct_data_free (gpointer _data)
{
	MailMoveOperationNewData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->_src_folder);
	_g_object_unref0 (_data_->threads);
	_g_variant_unref0 (_data_->dst_folder_full_name);
	_g_object_unref0 (_data_->self);
	g_slice_free (MailMoveOperationNewData, _data_);
}

static gpointer
_g_variant_ref0 (gpointer self)
{
	return self ? g_variant_ref (self) : NULL;
}

void
mail_move_operation_construct (GType object_type,
                               CamelFolder* _src_folder,
                               MailMoveOperationMoveType _move_type,
                               GeeArrayList* threads,
                               GVariant* dst_folder_full_name,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_)
{
	MailMoveOperationNewData* _data_;
	CamelFolder* _tmp0_;
	GeeArrayList* _tmp1_;
	GVariant* _tmp2_;
	g_return_if_fail (_src_folder != NULL);
	g_return_if_fail (threads != NULL);
	_data_ = g_slice_new0 (MailMoveOperationNewData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, mail_move_operation_construct_data_free);
	_data_->object_type = object_type;
	_tmp0_ = _g_object_ref0 (_src_folder);
	_g_object_unref0 (_data_->_src_folder);
	_data_->_src_folder = _tmp0_;
	_data_->_move_type = _move_type;
	_tmp1_ = _g_object_ref0 (threads);
	_g_object_unref0 (_data_->threads);
	_data_->threads = _tmp1_;
	_tmp2_ = _g_variant_ref0 (dst_folder_full_name);
	_g_variant_unref0 (_data_->dst_folder_full_name);
	_data_->dst_folder_full_name = _tmp2_;
	mail_move_operation_construct_co (_data_);
}

MailMoveOperation*
mail_move_operation_construct_finish (GAsyncResult* _res_,
                                      guint* n_messages_moved,
                                      GError** error)
{
	MailMoveOperation* result;
	MailMoveOperationNewData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	if (n_messages_moved) {
		*n_messages_moved = _data_->n_messages_moved;
	}
	result = _data_->self;
	_data_->self = NULL;
	return result;
}

static void
mail_move_operation_new_ready (GObject* source_object,
                               GAsyncResult* _res_,
                               gpointer _user_data_)
{
	MailMoveOperationNewData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	mail_move_operation_construct_co (_data_);
}

static void
__lambda42_ (MailMoveOperation* self,
             GObject* obj,
             GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		mail_move_operation_finish_finish (self, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		g_warning ("MoveOperation.vala:138: Failed to finish move operation: %s", _tmp1_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda42__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda42_ ((MailMoveOperation*) self, source_object, res);
	g_object_unref (self);
}

static gboolean
__lambda41_ (MailMoveOperation* self)
{
	gboolean result;
	mail_move_operation_finish (self, ___lambda42__gasync_ready_callback, g_object_ref (self));
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda41__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda41_ ((MailMoveOperation*) self);
	return result;
}

static gboolean
mail_move_operation_construct_co (MailMoveOperationNewData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->self = (MailMoveOperation*) g_object_new (_data_->object_type, NULL);
	_data_->_tmp0_ = _g_object_ref0 (_data_->_src_folder);
	_g_object_unref0 (_data_->self->priv->src_folder);
	_data_->self->priv->src_folder = _data_->_tmp0_;
	_g_object_unref0 (_data_->self->priv->dst_folder);
	_data_->self->priv->dst_folder = NULL;
	_data_->self->priv->move_type = _data_->_move_type;
	_data_->_tmp1_ = gee_array_list_new (camel_message_info_get_type (), NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (_data_->self->priv->moved_messages);
	_data_->self->priv->moved_messages = _data_->_tmp1_;
	{
		_data_->_thread_list = _data_->threads;
		_data_->_tmp2_ = _data_->_thread_list;
		_data_->_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp2_);
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_thread_size = _data_->_tmp4_;
		_data_->_thread_index = -1;
		while (TRUE) {
			_data_->_thread_index = _data_->_thread_index + 1;
			_data_->_tmp5_ = _data_->_thread_index;
			_data_->_tmp6_ = _data_->_thread_size;
			if (!(_data_->_tmp5_ < _data_->_tmp6_)) {
				break;
			}
			_data_->_tmp7_ = _data_->_thread_list;
			_data_->_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp7_, _data_->_thread_index);
			_data_->thread = (CamelFolderThreadNode*) _data_->_tmp8_;
			_data_->_tmp9_ = _data_->thread;
			_data_->_state_ = 1;
			mail_move_operation_collect_thread_messages (_data_->self, _data_->_tmp9_, mail_move_operation_new_ready, _data_);
			return FALSE;
			_state_1:
			mail_move_operation_collect_thread_messages_finish (_data_->self, _data_->_res_);
		}
	}
	switch (_data_->self->priv->move_type) {
		case MAIL_MOVE_OPERATION_MOVE_TYPE_ARCHIVE:
		{
			_data_->_tmp10_ = mail_move_operation_get_archive_folder_uri (_data_->self);
			_data_->archive_folder_uri = _data_->_tmp10_;
			_data_->_tmp12_ = _data_->archive_folder_uri;
			_data_->_state_ = 2;
			mail_move_operation_set_dst_folder_for_uri (_data_->self, _data_->_tmp12_, mail_move_operation_new_ready, _data_);
			return FALSE;
			_state_2:
			_data_->_tmp11_ = mail_move_operation_set_dst_folder_for_uri_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_free0 (_data_->archive_folder_uri);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			if (!_data_->_tmp11_) {
				_data_->_tmp13_ = g_error_new_literal (MOVE_ERROR, MOVE_ERROR_DST_FOLDER_NOT_FOUND, _ ("No Archive folder is configured."));
				_data_->_inner_error0_ = _data_->_tmp13_;
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_free0 (_data_->archive_folder_uri);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_g_free0 (_data_->archive_folder_uri);
			break;
		}
		case MAIL_MOVE_OPERATION_MOVE_TYPE_MOVE:
		{
			_data_->_tmp14_ = _data_->self->priv->src_folder;
			_data_->_tmp15_ = camel_folder_get_parent_store (_data_->_tmp14_);
			_data_->_tmp16_ = _data_->_tmp15_;
			_data_->_tmp17_ = _g_object_ref0 (_data_->_tmp16_);
			_data_->store = _data_->_tmp17_;
			_data_->_tmp19_ = _data_->store;
			_data_->_tmp20_ = g_variant_get_string (_data_->dst_folder_full_name, NULL);
			_data_->_state_ = 3;
			camel_store_get_folder (_data_->_tmp19_, _data_->_tmp20_, CAMEL_STORE_FOLDER_NONE, G_PRIORITY_DEFAULT, NULL, mail_move_operation_new_ready, _data_);
			return FALSE;
			_state_3:
			_data_->_tmp21_ = camel_store_get_folder_finish (_data_->_tmp19_, _data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp18_ = _data_->_tmp21_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_object_unref0 (_data_->store);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp22_ = _data_->_tmp18_;
			_data_->_tmp18_ = NULL;
			_g_object_unref0 (_data_->self->priv->dst_folder);
			_data_->self->priv->dst_folder = _data_->_tmp22_;
			_g_object_unref0 (_data_->_tmp18_);
			_g_object_unref0 (_data_->store);
			break;
		}
		case MAIL_MOVE_OPERATION_MOVE_TYPE_TRASH:
		{
			_data_->_tmp23_ = _data_->self->priv->src_folder;
			_data_->_tmp24_ = camel_folder_get_parent_store (_data_->_tmp23_);
			_data_->_tmp25_ = _data_->_tmp24_;
			_data_->_tmp26_ = _g_object_ref0 (_data_->_tmp25_);
			_data_->_vala1_store = _data_->_tmp26_;
			_data_->_tmp27_ = _data_->_vala1_store;
			if ((((CamelStoreFlags) camel_store_get_flags (_data_->_tmp27_)) & CAMEL_STORE_VTRASH) == CAMEL_STORE_VTRASH) {
				_data_->self->priv->move_type = MAIL_MOVE_OPERATION_MOVE_TYPE_VTRASH;
			} else {
				_data_->_tmp29_ = _data_->_vala1_store;
				_data_->_state_ = 4;
				camel_store_get_trash_folder (_data_->_tmp29_, G_PRIORITY_DEFAULT, NULL, mail_move_operation_new_ready, _data_);
				return FALSE;
				_state_4:
				_data_->_tmp30_ = camel_store_get_trash_folder_finish (_data_->_tmp29_, _data_->_res_, &_data_->_inner_error0_);
				_data_->_tmp28_ = _data_->_tmp30_;
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
					_g_object_unref0 (_data_->_vala1_store);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				_data_->_tmp31_ = _data_->_tmp28_;
				_data_->_tmp28_ = NULL;
				_g_object_unref0 (_data_->self->priv->dst_folder);
				_data_->self->priv->dst_folder = _data_->_tmp31_;
				_g_object_unref0 (_data_->_tmp28_);
			}
			_g_object_unref0 (_data_->_vala1_store);
			break;
		}
		case MAIL_MOVE_OPERATION_MOVE_TYPE_VTRASH:
		{
			_data_->_tmp32_ = g_error_new_literal (G_OPTION_ERROR, G_OPTION_ERROR_BAD_VALUE, "MoveType.VTRASH: Invalid value");
			_data_->_inner_error0_ = _data_->_tmp32_;
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		default:
		break;
	}
	_data_->_tmp34_ = _data_->self->priv->dst_folder;
	if (_data_->_tmp34_ == NULL) {
		_data_->_tmp33_ = _data_->self->priv->move_type != MAIL_MOVE_OPERATION_MOVE_TYPE_VTRASH;
	} else {
		_data_->_tmp33_ = FALSE;
	}
	if (_data_->_tmp33_) {
		_data_->_tmp35_ = g_error_new_literal (MOVE_ERROR, MOVE_ERROR_DST_FOLDER_NOT_FOUND, _ ("The destination folder was not found."));
		_data_->_inner_error0_ = _data_->_tmp35_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp36_ = _data_->self->priv->src_folder;
	_data_->_tmp37_ = _data_->self->priv->dst_folder;
	if (_data_->_tmp36_ == _data_->_tmp37_) {
		_data_->_tmp38_ = g_error_new_literal (MOVE_ERROR, MOVE_ERROR_DST_FOLDER_NOT_FOUND, _ ("The source folder is the destination folder."));
		_data_->_inner_error0_ = _data_->_tmp38_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->self->priv->timeout_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) MAIL_MOVE_OPERATION_TIMEOUT_DURATION, ___lambda41__gsource_func, g_object_ref (_data_->self), g_object_unref);
	_data_->_tmp39_ = _g_object_ref0 (_data_->self);
	_g_object_unref0 (mail_move_operation_last_move_operation);
	mail_move_operation_last_move_operation = _data_->_tmp39_;
	_data_->_tmp40_ = _data_->self->priv->moved_messages;
	_data_->_tmp41_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp40_);
	_data_->_tmp42_ = _data_->_tmp41_;
	mail_move_operation_update_queue (_data_->_tmp42_);
	_data_->_tmp43_ = _data_->self->priv->moved_messages;
	_data_->_tmp44_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp43_);
	_data_->_tmp45_ = _data_->_tmp44_;
	_data_->n_messages_moved = (guint) _data_->_tmp45_;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
mail_move_operation_new (CamelFolder* _src_folder,
                         MailMoveOperationMoveType _move_type,
                         GeeArrayList* threads,
                         GVariant* dst_folder_full_name,
                         GAsyncReadyCallback _callback_,
                         gpointer _user_data_)
{
	mail_move_operation_construct (MAIL_TYPE_MOVE_OPERATION, _src_folder, _move_type, threads, dst_folder_full_name, _callback_, _user_data_);
}

MailMoveOperation*
mail_move_operation_new_finish (GAsyncResult* _res_,
                                guint* n_messages_moved,
                                GError** error)
{
	return mail_move_operation_construct_finish (_res_, n_messages_moved, error);
}

static void
mail_move_operation_set_dst_folder_for_uri_data_free (gpointer _data)
{
	MailMoveOperationSetDstFolderForUriData* _data_;
	_data_ = _data;
	_g_free0 (_data_->uri);
	_g_object_unref0 (_data_->self);
	g_slice_free (MailMoveOperationSetDstFolderForUriData, _data_);
}

static void
mail_move_operation_set_dst_folder_for_uri (MailMoveOperation* self,
                                            const gchar* uri,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	MailMoveOperationSetDstFolderForUriData* _data_;
	MailMoveOperation* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	_data_ = g_slice_new0 (MailMoveOperationSetDstFolderForUriData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, mail_move_operation_set_dst_folder_for_uri_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (uri);
	_g_free0 (_data_->uri);
	_data_->uri = _tmp1_;
	mail_move_operation_set_dst_folder_for_uri_co (_data_);
}

static gboolean
mail_move_operation_set_dst_folder_for_uri_finish (MailMoveOperation* self,
                                                   GAsyncResult* _res_,
                                                   GError** error)
{
	gboolean result;
	MailMoveOperationSetDstFolderForUriData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

static void
_vala_CamelURL_free (CamelURL* self)
{
	g_boxed_free (camel_url_get_type (), self);
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static void
mail_move_operation_set_dst_folder_for_uri_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_)
{
	MailMoveOperationSetDstFolderForUriData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	mail_move_operation_set_dst_folder_for_uri_co (_data_);
}

static gboolean
mail_move_operation_set_dst_folder_for_uri_co (MailMoveOperationSetDstFolderForUriData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->url = NULL;
	_data_->_tmp1_ = camel_url_new (_data_->uri, &_data_->_inner_error0_);
	_data_->_tmp0_ = _data_->_tmp1_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		__vala_CamelURL_free0 (_data_->url);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = _data_->_tmp0_;
	_data_->_tmp0_ = NULL;
	__vala_CamelURL_free0 (_data_->url);
	_data_->url = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->url;
	if (_data_->_tmp3_ == NULL) {
		_data_->result = FALSE;
		__vala_CamelURL_free0 (_data_->_tmp0_);
		__vala_CamelURL_free0 (_data_->url);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->service = NULL;
	_data_->parsed_folder_name = NULL;
	_data_->_tmp4_ = _data_->url;
	_data_->_tmp5_ = _data_->_tmp4_->protocol;
	if (g_strcmp0 (_data_->_tmp5_, "folder") == 0) {
		_data_->_tmp6_ = _data_->url;
		_data_->_tmp7_ = _data_->_tmp6_->host;
		if (_data_->_tmp7_ != NULL) {
			_data_->_tmp9_ = _data_->url;
			_data_->_tmp10_ = _data_->_tmp9_->user;
			if (_data_->_tmp10_ == NULL) {
				_data_->_tmp8_ = TRUE;
			} else {
				_data_->_tmp11_ = _data_->url;
				_data_->_tmp12_ = _data_->_tmp11_->user;
				_data_->_tmp8_ = g_strcmp0 (_data_->_tmp12_, "") == 0;
			}
			if (_data_->_tmp8_) {
				_data_->_tmp13_ = _data_->url;
				_data_->_tmp14_ = _data_->_tmp13_->host;
				_data_->_tmp15_ = g_strdup (_data_->_tmp14_);
				_g_free0 (_data_->uid);
				_data_->uid = _data_->_tmp15_;
			} else {
				_data_->_tmp16_ = _data_->url;
				_data_->_tmp17_ = _data_->_tmp16_->user;
				_data_->_tmp18_ = g_strconcat (_data_->_tmp17_, "@", NULL);
				_data_->_tmp19_ = _data_->_tmp18_;
				_data_->_tmp20_ = _data_->url;
				_data_->_tmp21_ = _data_->_tmp20_->host;
				_data_->_tmp22_ = g_strconcat (_data_->_tmp19_, _data_->_tmp21_, NULL);
				_g_free0 (_data_->uid);
				_data_->uid = _data_->_tmp22_;
				_g_free0 (_data_->_tmp19_);
			}
			_data_->_tmp23_ = mail_backend_session_get_default ();
			_data_->_tmp24_ = _data_->uid;
			_data_->_tmp25_ = camel_session_ref_service ((CamelSession*) _data_->_tmp23_, _data_->_tmp24_);
			_g_object_unref0 (_data_->service);
			_data_->service = _data_->_tmp25_;
			_g_free0 (_data_->uid);
		}
		_data_->_tmp27_ = _data_->url;
		_data_->_tmp28_ = _data_->_tmp27_->path;
		if (_data_->_tmp28_ != NULL) {
			_data_->_tmp29_ = _data_->url;
			_data_->_tmp30_ = _data_->_tmp29_->path;
			_data_->_tmp26_ = g_str_has_prefix (_data_->_tmp30_, "/");
		} else {
			_data_->_tmp26_ = FALSE;
		}
		if (_data_->_tmp26_) {
			_data_->_tmp31_ = _data_->url;
			_data_->_tmp32_ = _data_->_tmp31_->path;
			_data_->_tmp33_ = string_substring (_data_->_tmp32_, (glong) 1, (glong) -1);
			_data_->_tmp34_ = _data_->_tmp33_;
			_data_->_tmp35_ = camel_url_decode_path (_data_->_tmp34_);
			_g_free0 (_data_->parsed_folder_name);
			_data_->parsed_folder_name = _data_->_tmp35_;
			_g_free0 (_data_->_tmp34_);
		}
	}
	_data_->_tmp38_ = _data_->service;
	if (_data_->_tmp38_ != NULL) {
		_data_->_tmp39_ = _data_->service;
		_data_->_tmp37_ = G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp39_, camel_store_get_type ());
	} else {
		_data_->_tmp37_ = FALSE;
	}
	if (_data_->_tmp37_) {
		_data_->_tmp40_ = _data_->parsed_folder_name;
		_data_->_tmp36_ = _data_->_tmp40_ != NULL;
	} else {
		_data_->_tmp36_ = FALSE;
	}
	if (_data_->_tmp36_) {
		_data_->_tmp42_ = _data_->service;
		_data_->_tmp43_ = _data_->parsed_folder_name;
		_data_->_state_ = 1;
		camel_store_get_folder (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp42_, camel_store_get_type (), CamelStore), _data_->_tmp43_, CAMEL_STORE_FOLDER_NONE, G_PRIORITY_DEFAULT, NULL, mail_move_operation_set_dst_folder_for_uri_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp44_ = camel_store_get_folder_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp42_, camel_store_get_type (), CamelStore), _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp41_ = _data_->_tmp44_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_free0 (_data_->parsed_folder_name);
			_g_object_unref0 (_data_->service);
			__vala_CamelURL_free0 (_data_->_tmp0_);
			__vala_CamelURL_free0 (_data_->url);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp45_ = _data_->_tmp41_;
		_data_->_tmp41_ = NULL;
		_g_object_unref0 (_data_->self->priv->dst_folder);
		_data_->self->priv->dst_folder = _data_->_tmp45_;
		_data_->result = TRUE;
		_g_object_unref0 (_data_->_tmp41_);
		_g_free0 (_data_->parsed_folder_name);
		_g_object_unref0 (_data_->service);
		__vala_CamelURL_free0 (_data_->_tmp0_);
		__vala_CamelURL_free0 (_data_->url);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = FALSE;
	_g_free0 (_data_->parsed_folder_name);
	_g_object_unref0 (_data_->service);
	__vala_CamelURL_free0 (_data_->_tmp0_);
	__vala_CamelURL_free0 (_data_->url);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gchar*
mail_move_operation_get_archive_folder_uri (MailMoveOperation* self)
{
	CamelStore* store = NULL;
	CamelFolder* _tmp0_;
	CamelStore* _tmp1_;
	CamelFolder* _tmp2_;
	CamelStore* _tmp26_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->src_folder;
	_tmp1_ = camel_folder_get_parent_store (_tmp0_);
	store = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, camel_store_get_type (), CamelStore);
	_tmp2_ = self->priv->src_folder;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, camel_vee_folder_get_type ())) {
		CamelVeeFolder* vee_folder = NULL;
		CamelFolder* _tmp3_;
		CamelVeeFolder* _tmp4_;
		_tmp3_ = self->priv->src_folder;
		_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, camel_vee_folder_get_type (), CamelVeeFolder));
		vee_folder = _tmp4_;
		store = NULL;
		{
			GeeArrayList* _message_list = NULL;
			GeeArrayList* _tmp5_;
			gint _message_size = 0;
			GeeArrayList* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			gint _message_index = 0;
			_tmp5_ = self->priv->moved_messages;
			_message_list = _tmp5_;
			_tmp6_ = _message_list;
			_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
			_tmp8_ = _tmp7_;
			_message_size = _tmp8_;
			_message_index = -1;
			while (TRUE) {
				gint _tmp9_;
				gint _tmp10_;
				CamelMessageInfo* message = NULL;
				GeeArrayList* _tmp11_;
				gpointer _tmp12_;
				CamelFolder* orig_folder = NULL;
				CamelVeeFolder* _tmp13_;
				CamelMessageInfo* _tmp14_;
				const gchar* _tmp15_;
				const gchar* _tmp16_;
				CamelFolder* _tmp17_;
				CamelFolder* _tmp18_;
				_message_index = _message_index + 1;
				_tmp9_ = _message_index;
				_tmp10_ = _message_size;
				if (!(_tmp9_ < _tmp10_)) {
					break;
				}
				_tmp11_ = _message_list;
				_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _message_index);
				message = (CamelMessageInfo*) _tmp12_;
				_tmp13_ = vee_folder;
				_tmp14_ = message;
				_tmp15_ = camel_message_info_get_uid (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = camel_vee_folder_dup_vee_uid_folder (_tmp13_, _tmp16_);
				orig_folder = _tmp17_;
				_tmp18_ = orig_folder;
				if (_tmp18_ != NULL) {
					gboolean _tmp19_ = FALSE;
					CamelStore* _tmp20_;
					CamelFolder* _tmp24_;
					CamelStore* _tmp25_;
					_tmp20_ = store;
					if (_tmp20_ != NULL) {
						CamelFolder* _tmp21_;
						CamelStore* _tmp22_;
						CamelStore* _tmp23_;
						_tmp21_ = orig_folder;
						_tmp22_ = camel_folder_get_parent_store (_tmp21_);
						_tmp23_ = store;
						_tmp19_ = _tmp22_ != _tmp23_;
					} else {
						_tmp19_ = FALSE;
					}
					if (_tmp19_) {
						store = NULL;
						_g_object_unref0 (orig_folder);
						break;
					}
					_tmp24_ = orig_folder;
					_tmp25_ = camel_folder_get_parent_store (_tmp24_);
					store = G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, camel_store_get_type (), CamelStore);
				}
				_g_object_unref0 (orig_folder);
			}
		}
		_g_object_unref0 (vee_folder);
	}
	_tmp26_ = store;
	if (_tmp26_ != NULL) {
		MailBackendSession* _tmp27_;
		CamelStore* _tmp28_;
		gchar* _tmp29_;
		_tmp27_ = mail_backend_session_get_default ();
		_tmp28_ = store;
		_tmp29_ = mail_backend_session_get_archive_folder_uri_for_service (_tmp27_, (CamelService*) _tmp28_);
		result = _tmp29_;
		return result;
	}
	result = NULL;
	return result;
}

static void
mail_move_operation_collect_thread_messages_data_free (gpointer _data)
{
	MailMoveOperationCollectThreadMessagesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (MailMoveOperationCollectThreadMessagesData, _data_);
}

static void
mail_move_operation_collect_thread_messages (MailMoveOperation* self,
                                             CamelFolderThreadNode* thread,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_)
{
	MailMoveOperationCollectThreadMessagesData* _data_;
	MailMoveOperation* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (thread != NULL);
	_data_ = g_slice_new0 (MailMoveOperationCollectThreadMessagesData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, mail_move_operation_collect_thread_messages_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->thread = thread;
	mail_move_operation_collect_thread_messages_co (_data_);
}

static void
mail_move_operation_collect_thread_messages_finish (MailMoveOperation* self,
                                                    GAsyncResult* _res_)
{
	MailMoveOperationCollectThreadMessagesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
mail_move_operation_collect_thread_messages_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_)
{
	MailMoveOperationCollectThreadMessagesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	mail_move_operation_collect_thread_messages_co (_data_);
}

static gboolean
mail_move_operation_collect_thread_messages_co (MailMoveOperationCollectThreadMessagesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->moved_messages;
	_data_->_tmp1_ = camel_folder_thread_node_get_item (_data_->thread);
	gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp0_, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, camel_message_info_get_type (), CamelMessageInfo));
	_data_->_tmp2_ = camel_folder_thread_node_get_child (_data_->thread);
	_data_->child = (CamelFolderThreadNode*) _data_->_tmp2_;
	while (TRUE) {
		_data_->_tmp3_ = _data_->child;
		if (!(_data_->_tmp3_ != NULL)) {
			break;
		}
		_data_->_tmp4_ = _data_->child;
		_data_->_state_ = 1;
		mail_move_operation_collect_thread_messages (_data_->self, _data_->_tmp4_, mail_move_operation_collect_thread_messages_ready, _data_);
		return FALSE;
		_state_1:
		mail_move_operation_collect_thread_messages_finish (_data_->self, _data_->_res_);
		_data_->_tmp5_ = _data_->child;
		_data_->_tmp6_ = camel_folder_thread_node_get_next (_data_->_tmp5_);
		_data_->child = (CamelFolderThreadNode*) _data_->_tmp6_;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
mail_move_operation_finish_data_free (gpointer _data)
{
	MailMoveOperationFinishData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (MailMoveOperationFinishData, _data_);
}

static void
mail_move_operation_finish (MailMoveOperation* self,
                            GAsyncReadyCallback _callback_,
                            gpointer _user_data_)
{
	MailMoveOperationFinishData* _data_;
	MailMoveOperation* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (MailMoveOperationFinishData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, mail_move_operation_finish_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	mail_move_operation_finish_co (_data_);
}

static void
mail_move_operation_finish_finish (MailMoveOperation* self,
                                   GAsyncResult* _res_,
                                   GError** error)
{
	MailMoveOperationFinishData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
mail_move_operation_finish_ready (GObject* source_object,
                                  GAsyncResult* _res_,
                                  gpointer _user_data_)
{
	MailMoveOperationFinishData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	mail_move_operation_finish_co (_data_);
}

static gboolean
mail_move_operation_finish_co (MailMoveOperationFinishData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = mail_move_operation_last_move_operation;
	if (_data_->self == _data_->_tmp0_) {
		_g_object_unref0 (mail_move_operation_last_move_operation);
		mail_move_operation_last_move_operation = NULL;
	}
	if (_data_->self->priv->move_type == MAIL_MOVE_OPERATION_MOVE_TYPE_VTRASH) {
		{
			_data_->_tmp1_ = _data_->self->priv->moved_messages;
			_data_->_message_list = _data_->_tmp1_;
			_data_->_tmp2_ = _data_->_message_list;
			_data_->_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp2_);
			_data_->_tmp4_ = _data_->_tmp3_;
			_data_->_message_size = _data_->_tmp4_;
			_data_->_message_index = -1;
			while (TRUE) {
				_data_->_message_index = _data_->_message_index + 1;
				_data_->_tmp5_ = _data_->_message_index;
				_data_->_tmp6_ = _data_->_message_size;
				if (!(_data_->_tmp5_ < _data_->_tmp6_)) {
					break;
				}
				_data_->_tmp7_ = _data_->_message_list;
				_data_->_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp7_, _data_->_message_index);
				_data_->message = (CamelMessageInfo*) _data_->_tmp8_;
				_data_->_tmp9_ = _data_->message;
				camel_message_info_set_flags (_data_->_tmp9_, (guint32) CAMEL_MESSAGE_DELETED, (guint32) (~0));
			}
		}
		_data_->_tmp10_ = _data_->self->priv->moved_messages;
		_data_->_tmp11_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp10_);
		_data_->_tmp12_ = _data_->_tmp11_;
		mail_move_operation_update_queue (-_data_->_tmp12_);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp13_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
	_data_->message_uids = _data_->_tmp13_;
	{
		_data_->_tmp14_ = _data_->self->priv->moved_messages;
		_data_->_vala1__message_list = _data_->_tmp14_;
		_data_->_tmp15_ = _data_->_vala1__message_list;
		_data_->_tmp16_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp15_);
		_data_->_tmp17_ = _data_->_tmp16_;
		_data_->_vala1__message_size = _data_->_tmp17_;
		_data_->_vala1__message_index = -1;
		while (TRUE) {
			_data_->_vala1__message_index = _data_->_vala1__message_index + 1;
			_data_->_tmp18_ = _data_->_vala1__message_index;
			_data_->_tmp19_ = _data_->_vala1__message_size;
			if (!(_data_->_tmp18_ < _data_->_tmp19_)) {
				break;
			}
			_data_->_tmp20_ = _data_->_vala1__message_list;
			_data_->_tmp21_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp20_, _data_->_vala1__message_index);
			_data_->_vala1_message = (CamelMessageInfo*) _data_->_tmp21_;
			_data_->_tmp22_ = _data_->message_uids;
			_data_->_tmp23_ = _data_->_vala1_message;
			_data_->_tmp24_ = camel_message_info_get_uid (_data_->_tmp23_);
			_data_->_tmp25_ = _data_->_tmp24_;
			_data_->_tmp26_ = g_strdup (_data_->_tmp25_);
			g_ptr_array_add (_data_->_tmp22_, _data_->_tmp26_);
		}
	}
	_data_->_tmp27_ = _data_->self->priv->src_folder;
	camel_folder_freeze (_data_->_tmp27_);
	_data_->_tmp28_ = _data_->self->priv->dst_folder;
	camel_folder_freeze (_data_->_tmp28_);
	_data_->_tmp30_ = _data_->self->priv->src_folder;
	_data_->_tmp31_ = _data_->message_uids;
	_data_->_tmp32_ = _data_->self->priv->dst_folder;
	_data_->_state_ = 1;
	camel_folder_transfer_messages_to (_data_->_tmp30_, _data_->_tmp31_, _data_->_tmp32_, TRUE, G_PRIORITY_DEFAULT, NULL, mail_move_operation_finish_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp29_ = camel_folder_transfer_messages_to_finish (_data_->_tmp30_, _data_->_res_, NULL, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_ptr_array_unref0 (_data_->message_uids);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (!_data_->_tmp29_) {
		_data_->_tmp33_ = g_error_new_literal (MOVE_ERROR, MOVE_ERROR_FAILED, "Failed to move messages");
		_data_->_inner_error0_ = _data_->_tmp33_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_ptr_array_unref0 (_data_->message_uids);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp34_ = _data_->self->priv->src_folder;
	camel_folder_thaw (_data_->_tmp34_);
	_data_->_tmp35_ = _data_->self->priv->dst_folder;
	camel_folder_thaw (_data_->_tmp35_);
	_data_->_tmp36_ = _data_->self->priv->moved_messages;
	_data_->_tmp37_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp36_);
	_data_->_tmp38_ = _data_->_tmp37_;
	mail_move_operation_update_queue (-_data_->_tmp38_);
	_g_ptr_array_unref0 (_data_->message_uids);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
mail_move_operation_class_init (MailMoveOperationClass * klass,
                                gpointer klass_data)
{
	mail_move_operation_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MailMoveOperation_private_offset);
	G_OBJECT_CLASS (klass)->finalize = mail_move_operation_finalize;
	mail_move_operation_signals[MAIL_MOVE_OPERATION_UNDONE_SIGNAL] = g_signal_new ("undone", MAIL_TYPE_MOVE_OPERATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
mail_move_operation_instance_init (MailMoveOperation * self,
                                   gpointer klass)
{
	self->priv = mail_move_operation_get_instance_private (self);
}

static void
mail_move_operation_finalize (GObject * obj)
{
	MailMoveOperation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAIL_TYPE_MOVE_OPERATION, MailMoveOperation);
	_g_object_unref0 (self->priv->src_folder);
	_g_object_unref0 (self->priv->dst_folder);
	_g_object_unref0 (self->priv->moved_messages);
	G_OBJECT_CLASS (mail_move_operation_parent_class)->finalize (obj);
}

static GType
mail_move_operation_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MailMoveOperationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mail_move_operation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MailMoveOperation), 0, (GInstanceInitFunc) mail_move_operation_instance_init, NULL };
	GType mail_move_operation_type_id;
	mail_move_operation_type_id = g_type_register_static (G_TYPE_OBJECT, "MailMoveOperation", &g_define_type_info, 0);
	MailMoveOperation_private_offset = g_type_add_instance_private (mail_move_operation_type_id, sizeof (MailMoveOperationPrivate));
	return mail_move_operation_type_id;
}

GType
mail_move_operation_get_type (void)
{
	static volatile gsize mail_move_operation_type_id__once = 0;
	if (g_once_init_enter (&mail_move_operation_type_id__once)) {
		GType mail_move_operation_type_id;
		mail_move_operation_type_id = mail_move_operation_get_type_once ();
		g_once_init_leave (&mail_move_operation_type_id__once, mail_move_operation_type_id);
	}
	return mail_move_operation_type_id__once;
}

