/* Signature.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Signature.vala, do not modify */

/*
* Copyright (c) 2017-2023 elementary, Inc. (https://elementary.io)
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program. If not, see <http://www.gnu.org/licenses/>
*
* Authored by: Leonhard Kargl <leo.kargl@proton.me>
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <libedataserver/libedataserver.h>
#include <gio/gio.h>
#include <camel/camel.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define MAIL_TYPE_SIGNATURE (mail_signature_get_type ())
#define MAIL_SIGNATURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_TYPE_SIGNATURE, MailSignature))
#define MAIL_SIGNATURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_TYPE_SIGNATURE, MailSignatureClass))
#define MAIL_IS_SIGNATURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_TYPE_SIGNATURE))
#define MAIL_IS_SIGNATURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_TYPE_SIGNATURE))
#define MAIL_SIGNATURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_TYPE_SIGNATURE, MailSignatureClass))

typedef struct _MailSignature MailSignature;
typedef struct _MailSignatureClass MailSignatureClass;
typedef struct _MailSignaturePrivate MailSignaturePrivate;
enum  {
	MAIL_SIGNATURE_0_PROPERTY,
	MAIL_SIGNATURE_TITLE_PROPERTY,
	MAIL_SIGNATURE_CONTENT_PROPERTY,
	MAIL_SIGNATURE_UID_PROPERTY,
	MAIL_SIGNATURE_IS_DELETED_PROPERTY,
	MAIL_SIGNATURE_NUM_PROPERTIES
};
static GParamSpec* mail_signature_properties[MAIL_SIGNATURE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _MailSignatureNewData MailSignatureNewData;
typedef struct _MailSignatureSaveData MailSignatureSaveData;

#define MAIL_BACKEND_TYPE_SESSION (mail_backend_session_get_type ())
#define MAIL_BACKEND_SESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_BACKEND_TYPE_SESSION, MailBackendSession))
#define MAIL_BACKEND_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_BACKEND_TYPE_SESSION, MailBackendSessionClass))
#define MAIL_BACKEND_IS_SESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_BACKEND_TYPE_SESSION))
#define MAIL_BACKEND_IS_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_BACKEND_TYPE_SESSION))
#define MAIL_BACKEND_SESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_BACKEND_TYPE_SESSION, MailBackendSessionClass))

typedef struct _MailBackendSession MailBackendSession;
typedef struct _MailBackendSessionClass MailBackendSessionClass;
typedef struct _MailSignatureFinishDeleteSignatureData MailSignatureFinishDeleteSignatureData;

struct _MailSignature {
	GtkListBoxRow parent_instance;
	MailSignaturePrivate * priv;
};

struct _MailSignatureClass {
	GtkListBoxRowClass parent_class;
};

struct _MailSignaturePrivate {
	gchar* _title;
	gchar* _content;
	gchar* _uid;
	ESource* signature_source;
	guint timeout_id;
};

struct _MailSignatureNewData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GType object_type;
	MailSignature* self;
	ESource* signature_source;
	ESource* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* content;
	gsize length;
	gchar* _tmp5_;
	gsize _tmp6_;
	GError* e;
	const gchar* _tmp7_;
	GError* _tmp8_;
	const gchar* _tmp9_;
	GtkLabel* label;
	const gchar* _tmp10_;
	GtkLabel* _tmp11_;
	GError* _inner_error0_;
};

struct _MailSignatureSaveData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	MailSignature* self;
	ESource* _tmp0_;
	const gchar* _tmp1_;
	ESource* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	ESource* _tmp7_;
	GError* e;
	const gchar* _tmp8_;
	GError* _tmp9_;
	const gchar* _tmp10_;
	GError* _inner_error0_;
};

struct _MailSignatureFinishDeleteSignatureData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	MailSignature* self;
	MailBackendSession* _tmp0_;
	GList* _tmp1_;
	GList* identity_source_collection;
	GList* identity_source_it;
	ESource* _tmp2_;
	ESource* identity_source;
	ESourceMailIdentity* identity_extension;
	ESource* _tmp3_;
	ESourceExtension* _tmp4_;
	ESourceMailIdentity* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	ESource* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	ESourceMailIdentity* _tmp11_;
	ESource* _tmp12_;
	GError* e;
	const gchar* _tmp13_;
	ESourceMailIdentity* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	GError* _tmp17_;
	const gchar* _tmp18_;
	ESource* _tmp19_;
	GError* _vala1_e;
	const gchar* _tmp20_;
	GError* _tmp21_;
	const gchar* _tmp22_;
	GError* _inner_error0_;
};

static gint MailSignature_private_offset;
static gpointer mail_signature_parent_class = NULL;

VALA_EXTERN GType mail_signature_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailSignature, g_object_unref)
static void mail_signature_construct_data_free (gpointer _data);
VALA_EXTERN void mail_signature_new (ESource* signature_source,
                         GAsyncReadyCallback _callback_,
                         gpointer _user_data_);
VALA_EXTERN MailSignature* mail_signature_new_finish (GAsyncResult* _res_);
VALA_EXTERN void mail_signature_construct (GType object_type,
                               ESource* signature_source,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_);
VALA_EXTERN MailSignature* mail_signature_construct_finish (GAsyncResult* _res_);
static gboolean mail_signature_construct_co (MailSignatureNewData* _data_);
VALA_EXTERN void mail_signature_set_title (MailSignature* self,
                               const gchar* value);
static void mail_signature_set_uid (MailSignature* self,
                             const gchar* value);
static void mail_signature_new_ready (GObject* source_object,
                               GAsyncResult* _res_,
                               gpointer _user_data_);
VALA_EXTERN void mail_signature_set_content (MailSignature* self,
                                 const gchar* value);
VALA_EXTERN const gchar* mail_signature_get_title (MailSignature* self);
static void mail_signature_save_data_free (gpointer _data);
VALA_EXTERN void mail_signature_save (MailSignature* self,
                          GAsyncReadyCallback _callback_,
                          gpointer _user_data_);
VALA_EXTERN void mail_signature_save_finish (MailSignature* self,
                                 GAsyncResult* _res_);
static gboolean mail_signature_save_co (MailSignatureSaveData* _data_);
VALA_EXTERN const gchar* mail_signature_get_content (MailSignature* self);
static void mail_signature_save_ready (GObject* source_object,
                                GAsyncResult* _res_,
                                gpointer _user_data_);
VALA_EXTERN void mail_signature_undo_delete (MailSignature* self);
VALA_EXTERN void mail_signature_delete_signature (MailSignature* self);
static gboolean __lambda141_ (MailSignature* self);
VALA_EXTERN void mail_signature_finish_delete_signature (MailSignature* self,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
VALA_EXTERN void mail_signature_finish_delete_signature_finish (MailSignature* self,
                                                    GAsyncResult* _res_);
static gboolean ___lambda141__gsource_func (gpointer self);
static void mail_signature_finish_delete_signature_data_free (gpointer _data);
static gboolean mail_signature_finish_delete_signature_co (MailSignatureFinishDeleteSignatureData* _data_);
VALA_EXTERN GType mail_backend_session_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailBackendSession, g_object_unref)
VALA_EXTERN MailBackendSession* mail_backend_session_get_default (void);
VALA_EXTERN GList* mail_backend_session_get_all_identity_sources (MailBackendSession* self);
static void mail_signature_finish_delete_signature_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN const gchar* mail_signature_get_uid (MailSignature* self);
VALA_EXTERN gboolean mail_signature_get_is_deleted (MailSignature* self);
static void mail_signature_finalize (GObject * obj);
static GType mail_signature_get_type_once (void);
static void _vala_mail_signature_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec);
static void _vala_mail_signature_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec);

static inline gpointer
mail_signature_get_instance_private (MailSignature* self)
{
	return G_STRUCT_MEMBER_P (self, MailSignature_private_offset);
}

static void
mail_signature_construct_data_free (gpointer _data)
{
	MailSignatureNewData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->signature_source);
	_g_object_unref0 (_data_->self);
	g_slice_free (MailSignatureNewData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
mail_signature_construct (GType object_type,
                          ESource* signature_source,
                          GAsyncReadyCallback _callback_,
                          gpointer _user_data_)
{
	MailSignatureNewData* _data_;
	ESource* _tmp0_;
	g_return_if_fail (signature_source != NULL);
	_data_ = g_slice_new0 (MailSignatureNewData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, mail_signature_construct_data_free);
	_data_->object_type = object_type;
	_tmp0_ = _g_object_ref0 (signature_source);
	_g_object_unref0 (_data_->signature_source);
	_data_->signature_source = _tmp0_;
	mail_signature_construct_co (_data_);
}

MailSignature*
mail_signature_construct_finish (GAsyncResult* _res_)
{
	MailSignature* result;
	MailSignatureNewData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->self;
	_data_->self = NULL;
	return result;
}

static void
mail_signature_new_ready (GObject* source_object,
                          GAsyncResult* _res_,
                          gpointer _user_data_)
{
	MailSignatureNewData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	mail_signature_construct_co (_data_);
}

static gboolean
mail_signature_construct_co (MailSignatureNewData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->self = (MailSignature*) g_object_new (_data_->object_type, NULL);
	_data_->_tmp0_ = _g_object_ref0 (_data_->signature_source);
	_g_object_unref0 (_data_->self->priv->signature_source);
	_data_->self->priv->signature_source = _data_->_tmp0_;
	_data_->_tmp1_ = e_source_get_display_name (_data_->signature_source);
	_data_->_tmp2_ = _data_->_tmp1_;
	mail_signature_set_title (_data_->self, _data_->_tmp2_);
	_data_->_tmp3_ = e_source_get_uid (_data_->signature_source);
	_data_->_tmp4_ = _data_->_tmp3_;
	mail_signature_set_uid (_data_->self, _data_->_tmp4_);
	{
		_data_->_tmp5_ = NULL;
		_data_->_tmp6_ = 0UL;
		_data_->_state_ = 1;
		e_source_mail_signature_load (_data_->signature_source, G_PRIORITY_DEFAULT, NULL, mail_signature_new_ready, _data_);
		return FALSE;
		_state_1:
		e_source_mail_signature_load_finish (_data_->signature_source, _data_->_res_, &_data_->_tmp5_, &_data_->_tmp6_, &_data_->_inner_error0_);
		_g_free0 (_data_->content);
		_data_->content = _data_->_tmp5_;
		_data_->length = _data_->_tmp6_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_free0 (_data_->content);
			goto __catch0_g_error;
		}
		mail_signature_set_content (_data_->self, _data_->content);
		_g_free0 (_data_->content);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp7_ = _data_->self->priv->_title;
		_data_->_tmp8_ = _data_->e;
		_data_->_tmp9_ = _data_->_tmp8_->message;
		g_warning ("Signature.vala:40: Failed to load signature '%s': %s", _data_->_tmp7_, _data_->_tmp9_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp10_ = _data_->self->priv->_title;
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = (GtkLabel*) gtk_label_new (_data_->_tmp10_);
	gtk_widget_set_halign ((GtkWidget*) _data_->_tmp11_, GTK_ALIGN_START);
	g_object_ref_sink (_data_->_tmp11_);
	_data_->label = _data_->_tmp11_;
	g_object_bind_property_with_closures ((GObject*) _data_->self, "title", (GObject*) _data_->label, "label", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	gtk_container_add ((GtkContainer*) _data_->self, (GtkWidget*) _data_->label);
	gtk_widget_show_all ((GtkWidget*) _data_->self);
	_g_object_unref0 (_data_->label);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
mail_signature_new (ESource* signature_source,
                    GAsyncReadyCallback _callback_,
                    gpointer _user_data_)
{
	mail_signature_construct (MAIL_TYPE_SIGNATURE, signature_source, _callback_, _user_data_);
}

MailSignature*
mail_signature_new_finish (GAsyncResult* _res_)
{
	return mail_signature_construct_finish (_res_);
}

static void
mail_signature_save_data_free (gpointer _data)
{
	MailSignatureSaveData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (MailSignatureSaveData, _data_);
}

void
mail_signature_save (MailSignature* self,
                     GAsyncReadyCallback _callback_,
                     gpointer _user_data_)
{
	MailSignatureSaveData* _data_;
	MailSignature* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (MailSignatureSaveData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, mail_signature_save_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	mail_signature_save_co (_data_);
}

void
mail_signature_save_finish (MailSignature* self,
                            GAsyncResult* _res_)
{
	MailSignatureSaveData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
mail_signature_save_ready (GObject* source_object,
                           GAsyncResult* _res_,
                           gpointer _user_data_)
{
	MailSignatureSaveData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	mail_signature_save_co (_data_);
}

static gboolean
mail_signature_save_co (MailSignatureSaveData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->signature_source;
	_data_->_tmp1_ = _data_->self->priv->_title;
	e_source_set_display_name (_data_->_tmp0_, _data_->_tmp1_);
	{
		_data_->_tmp2_ = _data_->self->priv->signature_source;
		_data_->_tmp3_ = _data_->self->priv->_content;
		_data_->_tmp4_ = _data_->self->priv->_content;
		_data_->_tmp5_ = strlen (_data_->_tmp4_);
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_state_ = 1;
		e_source_mail_signature_replace (_data_->_tmp2_, _data_->_tmp3_, (gsize) _data_->_tmp6_, G_PRIORITY_DEFAULT, NULL, mail_signature_save_ready, _data_);
		return FALSE;
		_state_1:
		e_source_mail_signature_replace_finish (_data_->_tmp2_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp7_ = _data_->self->priv->signature_source;
		_data_->_state_ = 2;
		e_source_write (_data_->_tmp7_, NULL, mail_signature_save_ready, _data_);
		return FALSE;
		_state_2:
		e_source_write_finish (_data_->_tmp7_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp8_ = _data_->self->priv->_title;
		_data_->_tmp9_ = _data_->e;
		_data_->_tmp10_ = _data_->_tmp9_->message;
		g_warning ("Signature.vala:58: Failed to save signature '%s': %s", _data_->_tmp8_, _data_->_tmp10_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
mail_signature_undo_delete (MailSignature* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->timeout_id != ((guint) 0)) {
		g_source_remove (self->priv->timeout_id);
		self->priv->timeout_id = (guint) 0;
	}
}

static gboolean
__lambda141_ (MailSignature* self)
{
	gboolean result;
	mail_signature_finish_delete_signature (self, NULL, NULL);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda141__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda141_ ((MailSignature*) self);
	return result;
}

void
mail_signature_delete_signature (MailSignature* self)
{
	g_return_if_fail (self != NULL);
	self->priv->timeout_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, ___lambda141__gsource_func, g_object_ref (self), g_object_unref);
}

static void
mail_signature_finish_delete_signature_data_free (gpointer _data)
{
	MailSignatureFinishDeleteSignatureData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (MailSignatureFinishDeleteSignatureData, _data_);
}

void
mail_signature_finish_delete_signature (MailSignature* self,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	MailSignatureFinishDeleteSignatureData* _data_;
	MailSignature* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (MailSignatureFinishDeleteSignatureData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, mail_signature_finish_delete_signature_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	mail_signature_finish_delete_signature_co (_data_);
}

void
mail_signature_finish_delete_signature_finish (MailSignature* self,
                                               GAsyncResult* _res_)
{
	MailSignatureFinishDeleteSignatureData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
mail_signature_finish_delete_signature_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_)
{
	MailSignatureFinishDeleteSignatureData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	mail_signature_finish_delete_signature_co (_data_);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gboolean
mail_signature_finish_delete_signature_co (MailSignatureFinishDeleteSignatureData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->self->priv->timeout_id != ((guint) 0)) {
		g_source_remove (_data_->self->priv->timeout_id);
		_data_->self->priv->timeout_id = (guint) 0;
	}
	_data_->_tmp0_ = mail_backend_session_get_default ();
	_data_->_tmp1_ = mail_backend_session_get_all_identity_sources (_data_->_tmp0_);
	{
		_data_->identity_source_collection = _data_->_tmp1_;
		for (_data_->identity_source_it = _data_->identity_source_collection; _data_->identity_source_it != NULL; _data_->identity_source_it = _data_->identity_source_it->next) {
			_data_->_tmp2_ = _g_object_ref0 ((ESource*) _data_->identity_source_it->data);
			_data_->identity_source = _data_->_tmp2_;
			{
				_data_->_tmp3_ = _data_->identity_source;
				_data_->_tmp4_ = e_source_get_extension (_data_->_tmp3_, E_SOURCE_EXTENSION_MAIL_IDENTITY);
				_data_->identity_extension = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp4_, e_source_mail_identity_get_type (), ESourceMailIdentity);
				_data_->_tmp5_ = _data_->identity_extension;
				_data_->_tmp6_ = e_source_mail_identity_get_signature_uid (_data_->_tmp5_);
				_data_->_tmp7_ = _data_->_tmp6_;
				_data_->_tmp8_ = _data_->self->priv->signature_source;
				_data_->_tmp9_ = e_source_get_uid (_data_->_tmp8_);
				_data_->_tmp10_ = _data_->_tmp9_;
				if (g_strcmp0 (_data_->_tmp7_, _data_->_tmp10_) == 0) {
					_data_->_tmp11_ = _data_->identity_extension;
					e_source_mail_identity_set_signature_uid (_data_->_tmp11_, "none");
					{
						_data_->_tmp12_ = _data_->identity_source;
						_data_->_state_ = 1;
						e_source_write (_data_->_tmp12_, NULL, mail_signature_finish_delete_signature_ready, _data_);
						return FALSE;
						_state_1:
						e_source_write_finish (_data_->_tmp12_, _data_->_res_, &_data_->_inner_error0_);
						if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
							goto __catch0_g_error;
						}
					}
					goto __finally0;
					__catch0_g_error:
					{
						_data_->e = _data_->_inner_error0_;
						_data_->_inner_error0_ = NULL;
						_data_->_tmp13_ = _data_->self->priv->_title;
						_data_->_tmp14_ = _data_->identity_extension;
						_data_->_tmp15_ = e_source_mail_identity_get_address (_data_->_tmp14_);
						_data_->_tmp16_ = _data_->_tmp15_;
						_data_->_tmp17_ = _data_->e;
						_data_->_tmp18_ = _data_->_tmp17_->message;
						g_warning ("Signature.vala:89: Failed to remove signature '%s' as default for mail" \
" address '%s': %s", _data_->_tmp13_, _data_->_tmp16_, _data_->_tmp18_);
						_g_error_free0 (_data_->e);
					}
					__finally0:
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						_g_object_unref0 (_data_->identity_source);
						(_data_->identity_source_collection == NULL) ? NULL : (_data_->identity_source_collection = (_g_list_free__g_object_unref0_ (_data_->identity_source_collection), NULL));
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
						g_clear_error (&_data_->_inner_error0_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
				}
				_g_object_unref0 (_data_->identity_source);
			}
		}
		(_data_->identity_source_collection == NULL) ? NULL : (_data_->identity_source_collection = (_g_list_free__g_object_unref0_ (_data_->identity_source_collection), NULL));
	}
	{
		_data_->_tmp19_ = _data_->self->priv->signature_source;
		_data_->_state_ = 2;
		e_source_remove (_data_->_tmp19_, NULL, mail_signature_finish_delete_signature_ready, _data_);
		return FALSE;
		_state_2:
		e_source_remove_finish (_data_->_tmp19_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		gtk_widget_destroy ((GtkWidget*) _data_->self);
	}
	goto __finally1;
	__catch1_g_error:
	{
		_data_->_vala1_e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp20_ = _data_->self->priv->_title;
		_data_->_tmp21_ = _data_->_vala1_e;
		_data_->_tmp22_ = _data_->_tmp21_->message;
		g_warning ("Signature.vala:103: Failed to delete signature '%s': %s", _data_->_tmp20_, _data_->_tmp22_);
		_g_error_free0 (_data_->_vala1_e);
	}
	__finally1:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

const gchar*
mail_signature_get_title (MailSignature* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_title;
	result = _tmp0_;
	return result;
}

void
mail_signature_set_title (MailSignature* self,
                          const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = mail_signature_get_title (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_title);
		self->priv->_title = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, mail_signature_properties[MAIL_SIGNATURE_TITLE_PROPERTY]);
	}
}

const gchar*
mail_signature_get_content (MailSignature* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_content;
	result = _tmp0_;
	return result;
}

void
mail_signature_set_content (MailSignature* self,
                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = mail_signature_get_content (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_content);
		self->priv->_content = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, mail_signature_properties[MAIL_SIGNATURE_CONTENT_PROPERTY]);
	}
}

const gchar*
mail_signature_get_uid (MailSignature* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_uid;
	result = _tmp0_;
	return result;
}

static void
mail_signature_set_uid (MailSignature* self,
                        const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = mail_signature_get_uid (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_uid);
		self->priv->_uid = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, mail_signature_properties[MAIL_SIGNATURE_UID_PROPERTY]);
	}
}

gboolean
mail_signature_get_is_deleted (MailSignature* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->timeout_id != ((guint) 0);
	return result;
}

static void
mail_signature_class_init (MailSignatureClass * klass,
                           gpointer klass_data)
{
	mail_signature_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MailSignature_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_mail_signature_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_mail_signature_set_property;
	G_OBJECT_CLASS (klass)->finalize = mail_signature_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIL_SIGNATURE_TITLE_PROPERTY, mail_signature_properties[MAIL_SIGNATURE_TITLE_PROPERTY] = g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIL_SIGNATURE_CONTENT_PROPERTY, mail_signature_properties[MAIL_SIGNATURE_CONTENT_PROPERTY] = g_param_spec_string ("content", "content", "content", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIL_SIGNATURE_UID_PROPERTY, mail_signature_properties[MAIL_SIGNATURE_UID_PROPERTY] = g_param_spec_string ("uid", "uid", "uid", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIL_SIGNATURE_IS_DELETED_PROPERTY, mail_signature_properties[MAIL_SIGNATURE_IS_DELETED_PROPERTY] = g_param_spec_boolean ("is-deleted", "is-deleted", "is-deleted", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
mail_signature_instance_init (MailSignature * self,
                              gpointer klass)
{
	self->priv = mail_signature_get_instance_private (self);
	self->priv->timeout_id = (guint) 0;
}

static void
mail_signature_finalize (GObject * obj)
{
	MailSignature * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAIL_TYPE_SIGNATURE, MailSignature);
	_g_free0 (self->priv->_title);
	_g_free0 (self->priv->_content);
	_g_free0 (self->priv->_uid);
	_g_object_unref0 (self->priv->signature_source);
	G_OBJECT_CLASS (mail_signature_parent_class)->finalize (obj);
}

static GType
mail_signature_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MailSignatureClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mail_signature_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MailSignature), 0, (GInstanceInitFunc) mail_signature_instance_init, NULL };
	GType mail_signature_type_id;
	mail_signature_type_id = g_type_register_static (gtk_list_box_row_get_type (), "MailSignature", &g_define_type_info, 0);
	MailSignature_private_offset = g_type_add_instance_private (mail_signature_type_id, sizeof (MailSignaturePrivate));
	return mail_signature_type_id;
}

GType
mail_signature_get_type (void)
{
	static volatile gsize mail_signature_type_id__once = 0;
	if (g_once_init_enter (&mail_signature_type_id__once)) {
		GType mail_signature_type_id;
		mail_signature_type_id = mail_signature_get_type_once ();
		g_once_init_leave (&mail_signature_type_id__once, mail_signature_type_id);
	}
	return mail_signature_type_id__once;
}

static void
_vala_mail_signature_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec)
{
	MailSignature * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MAIL_TYPE_SIGNATURE, MailSignature);
	switch (property_id) {
		case MAIL_SIGNATURE_TITLE_PROPERTY:
		g_value_set_string (value, mail_signature_get_title (self));
		break;
		case MAIL_SIGNATURE_CONTENT_PROPERTY:
		g_value_set_string (value, mail_signature_get_content (self));
		break;
		case MAIL_SIGNATURE_UID_PROPERTY:
		g_value_set_string (value, mail_signature_get_uid (self));
		break;
		case MAIL_SIGNATURE_IS_DELETED_PROPERTY:
		g_value_set_boolean (value, mail_signature_get_is_deleted (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_mail_signature_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec)
{
	MailSignature * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MAIL_TYPE_SIGNATURE, MailSignature);
	switch (property_id) {
		case MAIL_SIGNATURE_TITLE_PROPERTY:
		mail_signature_set_title (self, g_value_get_string (value));
		break;
		case MAIL_SIGNATURE_CONTENT_PROPERTY:
		mail_signature_set_content (self, g_value_get_string (value));
		break;
		case MAIL_SIGNATURE_UID_PROPERTY:
		mail_signature_set_uid (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

