/* SearchRowContainer.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from SearchRowContainer.vala, do not modify */

/*
* Copyright (c) 2011-2013 Yorba Foundation
*               2018 elementary LLC. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <gtk/gtk.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SEARCH_ROW_CONTAINER_0_PROPERTY,
	SEARCH_ROW_CONTAINER_NUM_PROPERTIES
};
static GParamSpec* search_row_container_properties[SEARCH_ROW_CONTAINER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	SEARCH_ROW_CONTAINER_REMOVE_SIGNAL,
	SEARCH_ROW_CONTAINER_CHANGED_SIGNAL,
	SEARCH_ROW_CONTAINER_NUM_SIGNALS
};
static guint search_row_container_signals[SEARCH_ROW_CONTAINER_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SearchRowContainerPrivate {
	GtkComboBoxText* type_combo;
	GtkGrid* grid;
	GtkGrid* align;
	GtkButton* remove_button;
	SearchConditionSearchType* search_types;
	gint search_types_length1;
	gint _search_types_size_;
	GeeHashMap* search_types_index;
	SearchRow* my_row;
};

static gint SearchRowContainer_private_offset;
static gpointer search_row_container_parent_class = NULL;

static void search_row_container_setup_gui (SearchRowContainer* self);
static void search_row_container_set_type (SearchRowContainer* self,
                                    SearchConditionSearchType type);
static void search_row_container_set_type_combo_box (SearchRowContainer* self,
                                              SearchConditionSearchType st);
static void search_row_container_on_type_changed (SearchRowContainer* self);
static void _search_row_container_on_type_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                  gpointer self);
static gboolean search_row_container_on_removed (SearchRowContainer* self,
                                          GdkEventButton* event);
static gboolean _search_row_container_on_removed_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                         GdkEventButton* event,
                                                                         gpointer self);
static void search_row_container_finalize (GObject * obj);
static GType search_row_container_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
search_row_container_get_instance_private (SearchRowContainer* self)
{
	return G_STRUCT_MEMBER_P (self, SearchRowContainer_private_offset);
}

SearchRowContainer*
search_row_container_construct (GType object_type)
{
	SearchRowContainer * self = NULL;
	self = (SearchRowContainer*) g_object_new (object_type, NULL);
	search_row_container_setup_gui (self);
	search_row_container_set_type (self, SEARCH_CONDITION_SEARCH_TYPE_ANY_TEXT);
	return self;
}

SearchRowContainer*
search_row_container_new (void)
{
	return search_row_container_construct (TYPE_SEARCH_ROW_CONTAINER);
}

SearchRowContainer*
search_row_container_construct_edit_existing (GType object_type,
                                              SearchCondition* sc)
{
	SearchRowContainer * self = NULL;
	SearchConditionSearchType _tmp0_;
	SearchConditionSearchType _tmp1_;
	SearchConditionSearchType _tmp2_;
	SearchConditionSearchType _tmp3_;
	SearchRow* _tmp4_;
	g_return_val_if_fail (sc != NULL, NULL);
	self = (SearchRowContainer*) g_object_new (object_type, NULL);
	search_row_container_setup_gui (self);
	_tmp0_ = search_condition_get_search_type (sc);
	_tmp1_ = _tmp0_;
	search_row_container_set_type (self, _tmp1_);
	_tmp2_ = search_condition_get_search_type (sc);
	_tmp3_ = _tmp2_;
	search_row_container_set_type_combo_box (self, _tmp3_);
	_tmp4_ = self->priv->my_row;
	search_row_populate (_tmp4_, sc);
	return self;
}

SearchRowContainer*
search_row_container_new_edit_existing (SearchCondition* sc)
{
	return search_row_container_construct_edit_existing (TYPE_SEARCH_ROW_CONTAINER, sc);
}

static void
_search_row_container_on_type_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                             gpointer self)
{
	search_row_container_on_type_changed ((SearchRowContainer*) self);
}

static gboolean
_search_row_container_on_removed_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                GdkEventButton* event,
                                                                gpointer self)
{
	gboolean result;
	result = search_row_container_on_removed ((SearchRowContainer*) self, event);
	return result;
}

static void
search_row_container_setup_gui (SearchRowContainer* self)
{
	gint _tmp0_ = 0;
	SearchConditionSearchType* _tmp1_;
	GeeHashMap* _tmp2_;
	GtkComboBoxText* _tmp3_;
	GtkComboBoxText* _tmp13_;
	GtkButton* _tmp14_;
	GtkButton* _tmp15_;
	GtkButton* _tmp16_;
	GtkButton* _tmp17_;
	GtkButton* _tmp18_;
	GtkGrid* _tmp19_;
	GtkGrid* _tmp20_;
	GtkGrid* _tmp21_;
	GtkGrid* _tmp22_;
	GtkComboBoxText* _tmp23_;
	GtkGrid* _tmp24_;
	GtkGrid* _tmp25_;
	GtkGrid* _tmp26_;
	GtkButton* _tmp27_;
	GtkGrid* _tmp28_;
	g_return_if_fail (self != NULL);
	_tmp1_ = search_condition_search_type_as_array (&_tmp0_);
	self->priv->search_types = (g_free (self->priv->search_types), NULL);
	self->priv->search_types = _tmp1_;
	self->priv->search_types_length1 = _tmp0_;
	self->priv->_search_types_size_ = self->priv->search_types_length1;
	_tmp2_ = gee_hash_map_new (SEARCH_CONDITION_TYPE_SEARCH_TYPE, NULL, NULL, G_TYPE_INT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->search_types_index);
	self->priv->search_types_index = _tmp2_;
	search_condition_search_type_sort_array (&self->priv->search_types, (gint*) (&self->priv->search_types_length1));
	self->priv->_search_types_size_ = self->priv->search_types_length1;
	_tmp3_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->type_combo);
	self->priv->type_combo = _tmp3_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				SearchConditionSearchType* _tmp6_;
				gint _tmp6__length1;
				SearchConditionSearchType st = 0;
				SearchConditionSearchType* _tmp7_;
				gint _tmp7__length1;
				SearchConditionSearchType _tmp8_;
				GeeHashMap* _tmp9_;
				GtkComboBoxText* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = self->priv->search_types;
				_tmp6__length1 = self->priv->search_types_length1;
				if (!(i < _tmp6__length1)) {
					break;
				}
				_tmp7_ = self->priv->search_types;
				_tmp7__length1 = self->priv->search_types_length1;
				_tmp8_ = _tmp7_[i];
				st = _tmp8_;
				_tmp9_ = self->priv->search_types_index;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp9_, (gpointer) ((gintptr) st), (gpointer) ((gintptr) i));
				_tmp10_ = self->priv->type_combo;
				_tmp11_ = search_condition_search_type_display_text (st);
				_tmp12_ = _tmp11_;
				gtk_combo_box_text_append_text (_tmp10_, _tmp12_);
				_g_free0 (_tmp12_);
			}
		}
	}
	search_row_container_set_type_combo_box (self, SEARCH_CONDITION_SEARCH_TYPE_ANY_TEXT);
	_tmp13_ = self->priv->type_combo;
	g_signal_connect_object ((GtkComboBox*) _tmp13_, "changed", (GCallback) _search_row_container_on_type_changed_gtk_combo_box_changed, self, 0);
	_tmp14_ = (GtkButton*) gtk_button_new_from_icon_name ("list-remove-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp14_);
	_g_object_unref0 (self->priv->remove_button);
	self->priv->remove_button = _tmp14_;
	_tmp15_ = self->priv->remove_button;
	gtk_widget_set_halign ((GtkWidget*) _tmp15_, GTK_ALIGN_END);
	_tmp16_ = self->priv->remove_button;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp16_, TRUE);
	_tmp17_ = self->priv->remove_button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp17_, _ ("Remove rule"));
	_tmp18_ = self->priv->remove_button;
	g_signal_connect_object ((GtkWidget*) _tmp18_, "button-press-event", (GCallback) _search_row_container_on_removed_gtk_widget_button_press_event, self, 0);
	_tmp19_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp19_);
	_g_object_unref0 (self->priv->align);
	self->priv->align = _tmp19_;
	_tmp20_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp20_);
	_g_object_unref0 (self->priv->grid);
	self->priv->grid = _tmp20_;
	_tmp21_ = self->priv->grid;
	gtk_grid_set_column_spacing (_tmp21_, 6);
	_tmp22_ = self->priv->grid;
	_tmp23_ = self->priv->type_combo;
	gtk_container_add ((GtkContainer*) _tmp22_, (GtkWidget*) _tmp23_);
	_tmp24_ = self->priv->grid;
	_tmp25_ = self->priv->align;
	gtk_container_add ((GtkContainer*) _tmp24_, (GtkWidget*) _tmp25_);
	_tmp26_ = self->priv->grid;
	_tmp27_ = self->priv->remove_button;
	gtk_container_add ((GtkContainer*) _tmp26_, (GtkWidget*) _tmp27_);
	_tmp28_ = self->priv->grid;
	gtk_widget_show_all ((GtkWidget*) _tmp28_);
}

static void
search_row_container_on_type_changed (SearchRowContainer* self)
{
	g_return_if_fail (self != NULL);
	search_row_container_set_type (self, search_row_container_get_search_type (self));
	g_signal_emit (self, search_row_container_signals[SEARCH_ROW_CONTAINER_CHANGED_SIGNAL], 0, self);
}

static void
search_row_container_set_type_combo_box (SearchRowContainer* self,
                                         SearchConditionSearchType st)
{
	GtkComboBoxText* _tmp0_;
	GeeHashMap* _tmp1_;
	gpointer _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->type_combo;
	_tmp1_ = self->priv->search_types_index;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, (gpointer) ((gintptr) st));
	gtk_combo_box_set_active ((GtkComboBox*) _tmp0_, (gint) ((gintptr) _tmp2_));
}

static void
search_row_container_set_type (SearchRowContainer* self,
                               SearchConditionSearchType type)
{
	SearchRow* _tmp0_;
	GtkGrid* _tmp8_;
	SearchRow* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->my_row;
	if (_tmp0_ != NULL) {
		GtkGrid* _tmp1_;
		SearchRow* _tmp2_;
		_tmp1_ = self->priv->align;
		_tmp2_ = self->priv->my_row;
		gtk_container_remove ((GtkContainer*) _tmp1_, (GtkWidget*) _tmp2_);
	}
	switch (type) {
		case SEARCH_CONDITION_SEARCH_TYPE_ANY_TEXT:
		case SEARCH_CONDITION_SEARCH_TYPE_EVENT_NAME:
		case SEARCH_CONDITION_SEARCH_TYPE_FILE_NAME:
		case SEARCH_CONDITION_SEARCH_TYPE_TAG:
		case SEARCH_CONDITION_SEARCH_TYPE_COMMENT:
		case SEARCH_CONDITION_SEARCH_TYPE_TITLE:
		{
			SearchRowText* _tmp3_;
			_tmp3_ = search_row_text_new (self);
			g_object_ref_sink (_tmp3_);
			_g_object_unref0 (self->priv->my_row);
			self->priv->my_row = (SearchRow*) _tmp3_;
			break;
		}
		case SEARCH_CONDITION_SEARCH_TYPE_MEDIA_TYPE:
		{
			SearchRowMediaType* _tmp4_;
			_tmp4_ = search_row_media_type_new (self);
			g_object_ref_sink (_tmp4_);
			_g_object_unref0 (self->priv->my_row);
			self->priv->my_row = (SearchRow*) _tmp4_;
			break;
		}
		case SEARCH_CONDITION_SEARCH_TYPE_FLAG_STATE:
		{
			SearchRowFlagged* _tmp5_;
			_tmp5_ = search_row_flagged_new (self);
			g_object_ref_sink (_tmp5_);
			_g_object_unref0 (self->priv->my_row);
			self->priv->my_row = (SearchRow*) _tmp5_;
			break;
		}
		case SEARCH_CONDITION_SEARCH_TYPE_MODIFIED_STATE:
		{
			SearchRowModified* _tmp6_;
			_tmp6_ = search_row_modified_new (self);
			g_object_ref_sink (_tmp6_);
			_g_object_unref0 (self->priv->my_row);
			self->priv->my_row = (SearchRow*) _tmp6_;
			break;
		}
		case SEARCH_CONDITION_SEARCH_TYPE_DATE:
		{
			SearchRowDate* _tmp7_;
			_tmp7_ = search_row_date_new (self);
			g_object_ref_sink (_tmp7_);
			_g_object_unref0 (self->priv->my_row);
			self->priv->my_row = (SearchRow*) _tmp7_;
			break;
		}
		default:
		{
			_vala_assert (FALSE, "false");
			break;
		}
	}
	_tmp8_ = self->priv->align;
	_tmp9_ = self->priv->my_row;
	gtk_container_add ((GtkContainer*) _tmp8_, (GtkWidget*) _tmp9_);
}

SearchConditionSearchType
search_row_container_get_search_type (SearchRowContainer* self)
{
	SearchConditionSearchType* _tmp0_;
	gint _tmp0__length1;
	GtkComboBoxText* _tmp1_;
	SearchConditionSearchType _tmp2_;
	SearchConditionSearchType result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->search_types;
	_tmp0__length1 = self->priv->search_types_length1;
	_tmp1_ = self->priv->type_combo;
	_tmp2_ = _tmp0_[gtk_combo_box_get_active ((GtkComboBox*) _tmp1_)];
	result = _tmp2_;
	return result;
}

static gboolean
search_row_container_on_removed (SearchRowContainer* self,
                                 GdkEventButton* event)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	g_signal_emit (self, search_row_container_signals[SEARCH_ROW_CONTAINER_REMOVE_SIGNAL], 0, self);
	result = FALSE;
	return result;
}

void
search_row_container_allow_removal (SearchRowContainer* self,
                                    gboolean allow)
{
	GtkButton* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->remove_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, allow);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GtkWidget*
search_row_container_get_widget (SearchRowContainer* self)
{
	GtkGrid* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->grid;
	_tmp1_ = _g_object_ref0 ((GtkWidget*) _tmp0_);
	result = _tmp1_;
	return result;
}

SearchCondition*
search_row_container_get_search_condition (SearchRowContainer* self)
{
	SearchRow* _tmp0_;
	SearchCondition* _tmp1_;
	SearchCondition* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->my_row;
	_tmp1_ = search_row_get_search_condition (_tmp0_);
	result = _tmp1_;
	return result;
}

gboolean
search_row_container_is_complete (SearchRowContainer* self)
{
	SearchRow* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->my_row;
	result = search_row_is_complete (_tmp0_);
	return result;
}

static void
search_row_container_class_init (SearchRowContainerClass * klass,
                                 gpointer klass_data)
{
	search_row_container_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SearchRowContainer_private_offset);
	G_OBJECT_CLASS (klass)->finalize = search_row_container_finalize;
	search_row_container_signals[SEARCH_ROW_CONTAINER_REMOVE_SIGNAL] = g_signal_new ("remove", TYPE_SEARCH_ROW_CONTAINER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_SEARCH_ROW_CONTAINER);
	search_row_container_signals[SEARCH_ROW_CONTAINER_CHANGED_SIGNAL] = g_signal_new ("changed", TYPE_SEARCH_ROW_CONTAINER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_SEARCH_ROW_CONTAINER);
}

static void
search_row_container_instance_init (SearchRowContainer * self,
                                    gpointer klass)
{
	self->priv = search_row_container_get_instance_private (self);
	self->priv->my_row = NULL;
}

static void
search_row_container_finalize (GObject * obj)
{
	SearchRowContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SEARCH_ROW_CONTAINER, SearchRowContainer);
	_g_object_unref0 (self->priv->type_combo);
	_g_object_unref0 (self->priv->grid);
	_g_object_unref0 (self->priv->align);
	_g_object_unref0 (self->priv->remove_button);
	self->priv->search_types = (g_free (self->priv->search_types), NULL);
	_g_object_unref0 (self->priv->search_types_index);
	_g_object_unref0 (self->priv->my_row);
	G_OBJECT_CLASS (search_row_container_parent_class)->finalize (obj);
}

static GType
search_row_container_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SearchRowContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) search_row_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SearchRowContainer), 0, (GInstanceInitFunc) search_row_container_instance_init, NULL };
	GType search_row_container_type_id;
	search_row_container_type_id = g_type_register_static (G_TYPE_OBJECT, "SearchRowContainer", &g_define_type_info, 0);
	SearchRowContainer_private_offset = g_type_add_instance_private (search_row_container_type_id, sizeof (SearchRowContainerPrivate));
	return search_row_container_type_id;
}

GType
search_row_container_get_type (void)
{
	static volatile gsize search_row_container_type_id__once = 0;
	if (g_once_init_enter (&search_row_container_type_id__once)) {
		GType search_row_container_type_id;
		search_row_container_type_id = search_row_container_get_type_once ();
		g_once_init_leave (&search_row_container_type_id__once, search_row_container_type_id);
	}
	return search_row_container_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

