// python wrapper for vtkPVGenerateProcessIds
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkPVGenerateProcessIds.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVGenerateProcessIds(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVGenerateProcessIds_ClassNew(); }


static PyObject *
PyvtkPVGenerateProcessIds_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVGenerateProcessIds::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGenerateProcessIds_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGenerateProcessIds *op = static_cast<vtkPVGenerateProcessIds *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPVGenerateProcessIds::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGenerateProcessIds_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPVGenerateProcessIds *tempr = vtkPVGenerateProcessIds::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGenerateProcessIds_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGenerateProcessIds *op = static_cast<vtkPVGenerateProcessIds *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVGenerateProcessIds *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPVGenerateProcessIds::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGenerateProcessIds_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPVGenerateProcessIds::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGenerateProcessIds_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGenerateProcessIds *op = static_cast<vtkPVGenerateProcessIds *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPVGenerateProcessIds::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGenerateProcessIds_SetGeneratePointData(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetGeneratePointData");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGenerateProcessIds *op = static_cast<vtkPVGenerateProcessIds *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetGeneratePointData(temp0);
    }
    else
    {
      op->vtkPVGenerateProcessIds::SetGeneratePointData(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGenerateProcessIds_GetGeneratePointData(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGeneratePointData");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGenerateProcessIds *op = static_cast<vtkPVGenerateProcessIds *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetGeneratePointData() :
      op->vtkPVGenerateProcessIds::GetGeneratePointData());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGenerateProcessIds_GeneratePointDataOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GeneratePointDataOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGenerateProcessIds *op = static_cast<vtkPVGenerateProcessIds *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->GeneratePointDataOn();
    }
    else
    {
      op->vtkPVGenerateProcessIds::GeneratePointDataOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGenerateProcessIds_GeneratePointDataOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GeneratePointDataOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGenerateProcessIds *op = static_cast<vtkPVGenerateProcessIds *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->GeneratePointDataOff();
    }
    else
    {
      op->vtkPVGenerateProcessIds::GeneratePointDataOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGenerateProcessIds_SetGenerateCellData(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetGenerateCellData");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGenerateProcessIds *op = static_cast<vtkPVGenerateProcessIds *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetGenerateCellData(temp0);
    }
    else
    {
      op->vtkPVGenerateProcessIds::SetGenerateCellData(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGenerateProcessIds_GetGenerateCellData(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGenerateCellData");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGenerateProcessIds *op = static_cast<vtkPVGenerateProcessIds *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetGenerateCellData() :
      op->vtkPVGenerateProcessIds::GetGenerateCellData());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVGenerateProcessIds_GenerateCellDataOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GenerateCellDataOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGenerateProcessIds *op = static_cast<vtkPVGenerateProcessIds *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->GenerateCellDataOn();
    }
    else
    {
      op->vtkPVGenerateProcessIds::GenerateCellDataOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVGenerateProcessIds_GenerateCellDataOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GenerateCellDataOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVGenerateProcessIds *op = static_cast<vtkPVGenerateProcessIds *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->GenerateCellDataOff();
    }
    else
    {
      op->vtkPVGenerateProcessIds::GenerateCellDataOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkPVGenerateProcessIds_Methods[] = {
  {"IsTypeOf", PyvtkPVGenerateProcessIds_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPVGenerateProcessIds_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPVGenerateProcessIds_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPVGenerateProcessIds\nC++: static vtkPVGenerateProcessIds *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPVGenerateProcessIds_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPVGenerateProcessIds\nC++: vtkPVGenerateProcessIds *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPVGenerateProcessIds_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPVGenerateProcessIds_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetGeneratePointData", PyvtkPVGenerateProcessIds_SetGeneratePointData, METH_VARARGS,
   "SetGeneratePointData(self, _arg:bool) -> None\nC++: virtual void SetGeneratePointData(bool _arg)\n\nSet/Get whether to generate process ids for PointData. Default is\ntrue.\n\note: Unused if input is a vtkHyperTreeGrid instance. In that\ncase, point data is never generated.\n"},
  {"GetGeneratePointData", PyvtkPVGenerateProcessIds_GetGeneratePointData, METH_VARARGS,
   "GetGeneratePointData(self) -> bool\nC++: virtual bool GetGeneratePointData()\n\n"},
  {"GeneratePointDataOn", PyvtkPVGenerateProcessIds_GeneratePointDataOn, METH_VARARGS,
   "GeneratePointDataOn(self) -> None\nC++: virtual void GeneratePointDataOn()\n\n"},
  {"GeneratePointDataOff", PyvtkPVGenerateProcessIds_GeneratePointDataOff, METH_VARARGS,
   "GeneratePointDataOff(self) -> None\nC++: virtual void GeneratePointDataOff()\n\n"},
  {"SetGenerateCellData", PyvtkPVGenerateProcessIds_SetGenerateCellData, METH_VARARGS,
   "SetGenerateCellData(self, _arg:bool) -> None\nC++: virtual void SetGenerateCellData(bool _arg)\n\nSet/Get whether to generate process ids for CellData. Default is\nfalse.\n\note: Unused if input is a vtkHyperTreeGrid instance. In that\ncase, cell data is always generated.\n"},
  {"GetGenerateCellData", PyvtkPVGenerateProcessIds_GetGenerateCellData, METH_VARARGS,
   "GetGenerateCellData(self) -> bool\nC++: virtual bool GetGenerateCellData()\n\n"},
  {"GenerateCellDataOn", PyvtkPVGenerateProcessIds_GenerateCellDataOn, METH_VARARGS,
   "GenerateCellDataOn(self) -> None\nC++: virtual void GenerateCellDataOn()\n\n"},
  {"GenerateCellDataOff", PyvtkPVGenerateProcessIds_GenerateCellDataOff, METH_VARARGS,
   "GenerateCellDataOff(self) -> None\nC++: virtual void GenerateCellDataOff()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVGenerateProcessIds_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("generate_point_data"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGenerateProcessIds_GetGeneratePointData(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGenerateProcessIds_SetGeneratePointData(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGenerateProcessIds_SetGeneratePointData(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetGeneratePointData/SetGeneratePointData\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("generate_cell_data"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVGenerateProcessIds_GetGenerateCellData(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVGenerateProcessIds_SetGenerateCellData(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVGenerateProcessIds_SetGenerateCellData(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetGenerateCellData/SetGenerateCellData\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPVGenerateProcessIds_Doc =
  "vtkPVGenerateProcessIds - Generate process IDs of input vtkDataSet or\nvtkHyperTreeGrid.\n\n"
  "Superclass: vtkPassInputTypeAlgorithm\n\n"
  "This meta-filter add support of vtkHyperTreeGrid by forwarding\n"
  "process IDs generation to the appropriate VTK filter.\n\n"
  "@sa vtkGenerateProcessIds vtkHyperTreeGridGenerateProcessIds\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVGenerateProcessIds_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVVTKExtensionsFiltersParallel.vtkPVGenerateProcessIds", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPVGenerateProcessIds_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPVGenerateProcessIds_StaticNew()
{
  return vtkPVGenerateProcessIds::New();
}

PyObject *PyvtkPVGenerateProcessIds_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPVGenerateProcessIds_Type, PyvtkPVGenerateProcessIds_Methods,
    "vtkPVGenerateProcessIds",
 &PyvtkPVGenerateProcessIds_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkPassInputTypeAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPVGenerateProcessIds_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVGenerateProcessIds(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVGenerateProcessIds_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPVGenerateProcessIds", o) != 0)
  {
    Py_DECREF(o);
  }

}

