// python wrapper for vtkPVClientServerSynchronizedRenderers
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkPVClientServerSynchronizedRenderers.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVClientServerSynchronizedRenderers(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVClientServerSynchronizedRenderers_ClassNew(); }


static PyObject *
PyvtkPVClientServerSynchronizedRenderers_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVClientServerSynchronizedRenderers::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVClientServerSynchronizedRenderers_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVClientServerSynchronizedRenderers *op = static_cast<vtkPVClientServerSynchronizedRenderers *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPVClientServerSynchronizedRenderers::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVClientServerSynchronizedRenderers_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPVClientServerSynchronizedRenderers *tempr = vtkPVClientServerSynchronizedRenderers::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVClientServerSynchronizedRenderers_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVClientServerSynchronizedRenderers *op = static_cast<vtkPVClientServerSynchronizedRenderers *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVClientServerSynchronizedRenderers *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPVClientServerSynchronizedRenderers::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVClientServerSynchronizedRenderers_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPVClientServerSynchronizedRenderers::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVClientServerSynchronizedRenderers_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVClientServerSynchronizedRenderers *op = static_cast<vtkPVClientServerSynchronizedRenderers *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPVClientServerSynchronizedRenderers::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVClientServerSynchronizedRenderers_SetLossLessCompression(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLossLessCompression");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVClientServerSynchronizedRenderers *op = static_cast<vtkPVClientServerSynchronizedRenderers *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLossLessCompression(temp0);
    }
    else
    {
      op->vtkPVClientServerSynchronizedRenderers::SetLossLessCompression(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVClientServerSynchronizedRenderers_GetLossLessCompression(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLossLessCompression");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVClientServerSynchronizedRenderers *op = static_cast<vtkPVClientServerSynchronizedRenderers *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetLossLessCompression() :
      op->vtkPVClientServerSynchronizedRenderers::GetLossLessCompression());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVClientServerSynchronizedRenderers_SetNVPipeSupport(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNVPipeSupport");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVClientServerSynchronizedRenderers *op = static_cast<vtkPVClientServerSynchronizedRenderers *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNVPipeSupport(temp0);
    }
    else
    {
      op->vtkPVClientServerSynchronizedRenderers::SetNVPipeSupport(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVClientServerSynchronizedRenderers_GetNVPipeSupport(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNVPipeSupport");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVClientServerSynchronizedRenderers *op = static_cast<vtkPVClientServerSynchronizedRenderers *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetNVPipeSupport() :
      op->vtkPVClientServerSynchronizedRenderers::GetNVPipeSupport());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVClientServerSynchronizedRenderers_ConfigureCompressor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ConfigureCompressor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVClientServerSynchronizedRenderers *op = static_cast<vtkPVClientServerSynchronizedRenderers *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->ConfigureCompressor(temp0);
    }
    else
    {
      op->vtkPVClientServerSynchronizedRenderers::ConfigureCompressor(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkPVClientServerSynchronizedRenderers_Methods[] = {
  {"IsTypeOf", PyvtkPVClientServerSynchronizedRenderers_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPVClientServerSynchronizedRenderers_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPVClientServerSynchronizedRenderers_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase)\n    -> vtkPVClientServerSynchronizedRenderers\nC++: static vtkPVClientServerSynchronizedRenderers *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPVClientServerSynchronizedRenderers_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPVClientServerSynchronizedRenderers\nC++: vtkPVClientServerSynchronizedRenderers *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPVClientServerSynchronizedRenderers_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPVClientServerSynchronizedRenderers_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetLossLessCompression", PyvtkPVClientServerSynchronizedRenderers_SetLossLessCompression, METH_VARARGS,
   "SetLossLessCompression(self, _arg:bool) -> None\nC++: virtual void SetLossLessCompression(bool _arg)\n\nThis flag is set by the renderer during still renderers. When set\ncompressor must use loss-less compression. When unset compressor\ncan (if it's enabled) use lossy compression.\n"},
  {"GetLossLessCompression", PyvtkPVClientServerSynchronizedRenderers_GetLossLessCompression, METH_VARARGS,
   "GetLossLessCompression(self) -> bool\nC++: virtual bool GetLossLessCompression()\n\nThis flag is set by the renderer during still renderers. When set\ncompressor must use loss-less compression. When unset compressor\ncan (if it's enabled) use lossy compression.\n"},
  {"SetNVPipeSupport", PyvtkPVClientServerSynchronizedRenderers_SetNVPipeSupport, METH_VARARGS,
   "SetNVPipeSupport(self, _arg:bool) -> None\nC++: virtual void SetNVPipeSupport(bool _arg)\n\nThis flag is set when NVPipe is supported.  NVPipe may not be\navailable even when compiled in, if the system is not using an\nNVIDIA GPU, for example.\n"},
  {"GetNVPipeSupport", PyvtkPVClientServerSynchronizedRenderers_GetNVPipeSupport, METH_VARARGS,
   "GetNVPipeSupport(self) -> bool\nC++: virtual bool GetNVPipeSupport()\n\nThis flag is set when NVPipe is supported.  NVPipe may not be\navailable even when compiled in, if the system is not using an\nNVIDIA GPU, for example.\n"},
  {"ConfigureCompressor", PyvtkPVClientServerSynchronizedRenderers_ConfigureCompressor, METH_VARARGS,
   "ConfigureCompressor(self, stream:str) -> None\nC++: virtual void ConfigureCompressor(const char *stream)\n\nSet and configure a compressor from it's own configuration\nstream. This is used by ParaView to configure the compressor from\napplication wide user settings.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVClientServerSynchronizedRenderers_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("loss_less_compression"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVClientServerSynchronizedRenderers_GetLossLessCompression(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVClientServerSynchronizedRenderers_SetLossLessCompression(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVClientServerSynchronizedRenderers_SetLossLessCompression(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetLossLessCompression/SetLossLessCompression\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("nv_pipe_support"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVClientServerSynchronizedRenderers_GetNVPipeSupport(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVClientServerSynchronizedRenderers_SetNVPipeSupport(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVClientServerSynchronizedRenderers_SetNVPipeSupport(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetNVPipeSupport/SetNVPipeSupport\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPVClientServerSynchronizedRenderers_Doc =
  "vtkPVClientServerSynchronizedRenderers -\nvtkPVClientServerSynchronizedRenderers is similar to\nvtkClientServerSynchronizedRenderers except that it optionally uses\nimage compressors to compress the image before transmitting.\n\n"
  "Superclass: vtkSynchronizedRenderers\n\n"
;

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVClientServerSynchronizedRenderers_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkPVClientServerSynchronizedRenderers", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPVClientServerSynchronizedRenderers_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPVClientServerSynchronizedRenderers_StaticNew()
{
  return vtkPVClientServerSynchronizedRenderers::New();
}

PyObject *PyvtkPVClientServerSynchronizedRenderers_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPVClientServerSynchronizedRenderers_Type, PyvtkPVClientServerSynchronizedRenderers_Methods,
    "vtkPVClientServerSynchronizedRenderers",
 &PyvtkPVClientServerSynchronizedRenderers_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkSynchronizedRenderers");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPVClientServerSynchronizedRenderers_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVClientServerSynchronizedRenderers(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVClientServerSynchronizedRenderers_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPVClientServerSynchronizedRenderers", o) != 0)
  {
    Py_DECREF(o);
  }

}

