// python wrapper for vtkPVRenderView
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkSmartPointer.h"
#include "vtkPVRenderView.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVRenderView(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVRenderView_ClassNew(); }

#ifndef DECLARED_PyvtkPVView_ClassNew
extern "C" { PyObject *PyvtkPVView_ClassNew(); }
#define DECLARED_PyvtkPVView_ClassNew
#endif
#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVRenderView_InteractionModes_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkPVRenderView.InteractionModes", // tp_name
  sizeof(PyLongObject), // tp_basicsize
  0, // tp_itemsize
  nullptr, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  nullptr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  nullptr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT
#if PY_VERSION_HEX >= 0x030A0000
    | Py_TPFLAGS_DISALLOW_INSTANTIATION
#endif
  , // tp_flags
  nullptr, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  &PyLong_Type, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  nullptr, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

template<class T>
static PyObject *PyvtkPVRenderView_InteractionModes_FromEnum(T val)
{
  return PyVTKEnum_New(&PyvtkPVRenderView_InteractionModes_Type, static_cast<int>(val));
}

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVRenderView_BackgroundMode_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkPVRenderView.BackgroundMode", // tp_name
  sizeof(PyLongObject), // tp_basicsize
  0, // tp_itemsize
  nullptr, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  nullptr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  nullptr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT
#if PY_VERSION_HEX >= 0x030A0000
    | Py_TPFLAGS_DISALLOW_INSTANTIATION
#endif
  , // tp_flags
  nullptr, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  &PyLong_Type, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  nullptr, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

template<class T>
static PyObject *PyvtkPVRenderView_BackgroundMode_FromEnum(T val)
{
  return PyVTKEnum_New(&PyvtkPVRenderView_BackgroundMode_Type, static_cast<int>(val));
}

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVRenderView_GenericFilmicPresets_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkPVRenderView.GenericFilmicPresets", // tp_name
  sizeof(PyLongObject), // tp_basicsize
  0, // tp_itemsize
  nullptr, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  nullptr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  nullptr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT
#if PY_VERSION_HEX >= 0x030A0000
    | Py_TPFLAGS_DISALLOW_INSTANTIATION
#endif
  , // tp_flags
  nullptr, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  &PyLong_Type, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  nullptr, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

template<class T>
static PyObject *PyvtkPVRenderView_GenericFilmicPresets_FromEnum(T val)
{
  return PyVTKEnum_New(&PyvtkPVRenderView_GenericFilmicPresets_Type, static_cast<int>(val));
}


static PyObject *
PyvtkPVRenderView_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVRenderView::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPVRenderView::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPVRenderView *tempr = vtkPVRenderView::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVRenderView *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPVRenderView::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPVRenderView::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPVRenderView::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetInteractionMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInteractionMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetInteractionMode(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetInteractionMode(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_GetInteractionMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetInteractionMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetInteractionMode() :
      op->vtkPVRenderView::GetInteractionMode());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetSize(temp0, temp1);
    }
    else
    {
      op->vtkPVRenderView::SetSize(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetPosition(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPosition");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetPosition(temp0, temp1);
    }
    else
    {
      op->vtkPVRenderView::SetPosition(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_GetNonCompositedRenderer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNonCompositedRenderer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkRenderer *tempr = (ap.IsBound() ?
      op->GetNonCompositedRenderer() :
      op->vtkPVRenderView::GetNonCompositedRenderer());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_GetRenderer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRenderer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  int temp0 = vtkPVRenderView::DEFAULT_RENDERER;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0, 1) &&
      (ap.NoArgsLeft() || ap.GetValue(temp0)))
  {
    vtkRenderer *tempr = (ap.IsBound() ?
      op->GetRenderer(temp0) :
      op->vtkPVRenderView::GetRenderer(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_GetActiveCamera(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetActiveCamera");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkCamera *tempr = (ap.IsBound() ?
      op->GetActiveCamera() :
      op->vtkPVRenderView::GetActiveCamera());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetActiveCamera(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetActiveCamera");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  vtkCamera *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkCamera"))
  {
    if (ap.IsBound())
    {
      op->SetActiveCamera(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetActiveCamera(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_GetInteractor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetInteractor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkRenderWindowInteractor *tempr = (ap.IsBound() ?
      op->GetInteractor() :
      op->vtkPVRenderView::GetInteractor());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetupInteractor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetupInteractor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  vtkRenderWindowInteractor *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkRenderWindowInteractor"))
  {
    if (ap.IsBound())
    {
      op->SetupInteractor(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetupInteractor(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_GetInteractorStyle(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetInteractorStyle");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVInteractorStyle *tempr = (ap.IsBound() ?
      op->GetInteractorStyle() :
      op->vtkPVRenderView::GetInteractorStyle());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_ResetCamera_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ResetCamera");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ResetCamera();
    }
    else
    {
      op->vtkPVRenderView::ResetCamera();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVRenderView_ResetCamera_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ResetCamera");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  const size_t size0 = 6;
  double temp0[6];
  double save0[6];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->ResetCamera(temp0);
    }
    else
    {
      op->vtkPVRenderView::ResetCamera(temp0);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVRenderView_ResetCamera(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 0:
      return PyvtkPVRenderView_ResetCamera_s1(self, args);
    case 1:
      return PyvtkPVRenderView_ResetCamera_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "ResetCamera");
  return nullptr;
}


static PyObject *
PyvtkPVRenderView_ResetCameraScreenSpace_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ResetCameraScreenSpace");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  double temp0 = 0.9;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0, 1) &&
      (ap.NoArgsLeft() || ap.GetValue(temp0)))
  {
    if (ap.IsBound())
    {
      op->ResetCameraScreenSpace(temp0);
    }
    else
    {
      op->vtkPVRenderView::ResetCameraScreenSpace(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVRenderView_ResetCameraScreenSpace_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ResetCameraScreenSpace");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  size_t size0 = ap.GetArgSize(0);
  vtkPythonArgs::Array<double> store0(2*size0);
  double *temp0 = store0.Data();
  double *save0 = (size0 == 0 ? nullptr : temp0 + size0);
  double temp1 = 0.9;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1, 2) &&
      ap.GetArray(temp0, size0) &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->ResetCameraScreenSpace(temp0, temp1);
    }
    else
    {
      op->vtkPVRenderView::ResetCameraScreenSpace(temp0, temp1);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkPVRenderView_ResetCameraScreenSpace_Methods[] = {
  {"ResetCameraScreenSpace", PyvtkPVRenderView_ResetCameraScreenSpace_s1, METH_VARARGS,
   "@|d"},
  {"ResetCameraScreenSpace", PyvtkPVRenderView_ResetCameraScreenSpace_s2, METH_VARARGS,
   "@P|d *d"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkPVRenderView_ResetCameraScreenSpace(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkPVRenderView_ResetCameraScreenSpace_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 0:
      return PyvtkPVRenderView_ResetCameraScreenSpace_s1(self, args);
    case 2:
      return PyvtkPVRenderView_ResetCameraScreenSpace_s2(self, args);
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "ResetCameraScreenSpace");
  return nullptr;
}


static PyObject *
PyvtkPVRenderView_ComputeVisibleBounds(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ComputeVisibleBounds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  vtkPVDataRepresentation *temp0 = nullptr;
  size_t sizer = 6;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkPVDataRepresentation"))
  {
    double *tempr = (ap.IsBound() ?
      op->ComputeVisibleBounds(temp0) :
      op->vtkPVRenderView::ComputeVisibleBounds(temp0));

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_StillRender(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "StillRender");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->StillRender();
    }
    else
    {
      op->vtkPVRenderView::StillRender();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_InteractiveRender(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InteractiveRender");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->InteractiveRender();
    }
    else
    {
      op->vtkPVRenderView::InteractiveRender();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetSuppressRendering(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSuppressRendering");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSuppressRendering(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetSuppressRendering(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_GetSuppressRendering(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSuppressRendering");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetSuppressRendering() :
      op->vtkPVRenderView::GetSuppressRendering());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SuppressRenderingOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SuppressRenderingOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SuppressRenderingOn();
    }
    else
    {
      op->vtkPVRenderView::SuppressRenderingOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SuppressRenderingOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SuppressRenderingOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SuppressRenderingOff();
    }
    else
    {
      op->vtkPVRenderView::SuppressRenderingOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetStillRenderImageReductionFactor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetStillRenderImageReductionFactor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetStillRenderImageReductionFactor(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetStillRenderImageReductionFactor(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_GetStillRenderImageReductionFactorMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetStillRenderImageReductionFactorMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetStillRenderImageReductionFactorMinValue() :
      op->vtkPVRenderView::GetStillRenderImageReductionFactorMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_GetStillRenderImageReductionFactorMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetStillRenderImageReductionFactorMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetStillRenderImageReductionFactorMaxValue() :
      op->vtkPVRenderView::GetStillRenderImageReductionFactorMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_GetStillRenderImageReductionFactor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetStillRenderImageReductionFactor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetStillRenderImageReductionFactor() :
      op->vtkPVRenderView::GetStillRenderImageReductionFactor());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetInteractiveRenderImageReductionFactor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInteractiveRenderImageReductionFactor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetInteractiveRenderImageReductionFactor(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetInteractiveRenderImageReductionFactor(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_GetInteractiveRenderImageReductionFactorMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetInteractiveRenderImageReductionFactorMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetInteractiveRenderImageReductionFactorMinValue() :
      op->vtkPVRenderView::GetInteractiveRenderImageReductionFactorMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_GetInteractiveRenderImageReductionFactorMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetInteractiveRenderImageReductionFactorMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetInteractiveRenderImageReductionFactorMaxValue() :
      op->vtkPVRenderView::GetInteractiveRenderImageReductionFactorMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_GetInteractiveRenderImageReductionFactor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetInteractiveRenderImageReductionFactor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetInteractiveRenderImageReductionFactor() :
      op->vtkPVRenderView::GetInteractiveRenderImageReductionFactor());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetRemoteRenderingThreshold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRemoteRenderingThreshold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRemoteRenderingThreshold(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetRemoteRenderingThreshold(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_GetRemoteRenderingThreshold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRemoteRenderingThreshold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetRemoteRenderingThreshold() :
      op->vtkPVRenderView::GetRemoteRenderingThreshold());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetLODRenderingThreshold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLODRenderingThreshold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLODRenderingThreshold(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetLODRenderingThreshold(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_GetLODRenderingThreshold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLODRenderingThreshold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetLODRenderingThreshold() :
      op->vtkPVRenderView::GetLODRenderingThreshold());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetLODResolution(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLODResolution");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLODResolution(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetLODResolution(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_GetLODResolutionMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLODResolutionMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetLODResolutionMinValue() :
      op->vtkPVRenderView::GetLODResolutionMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_GetLODResolutionMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLODResolutionMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetLODResolutionMaxValue() :
      op->vtkPVRenderView::GetLODResolutionMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_GetLODResolution(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLODResolution");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetLODResolution() :
      op->vtkPVRenderView::GetLODResolution());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetUseOutlineForLODRendering(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseOutlineForLODRendering");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseOutlineForLODRendering(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetUseOutlineForLODRendering(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_GetUseOutlineForLODRendering(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseOutlineForLODRendering");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseOutlineForLODRendering() :
      op->vtkPVRenderView::GetUseOutlineForLODRendering());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_ConfigureCompressor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ConfigureCompressor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->ConfigureCompressor(temp0);
    }
    else
    {
      op->vtkPVRenderView::ConfigureCompressor(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_ResetCameraClippingRange(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ResetCameraClippingRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ResetCameraClippingRange();
    }
    else
    {
      op->vtkPVRenderView::ResetCameraClippingRange();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetUseLightKit(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseLightKit");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseLightKit(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetUseLightKit(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_GetUseLightKit(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseLightKit");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseLightKit() :
      op->vtkPVRenderView::GetUseLightKit());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_UseLightKitOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UseLightKitOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UseLightKitOn();
    }
    else
    {
      op->vtkPVRenderView::UseLightKitOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_UseLightKitOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UseLightKitOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UseLightKitOff();
    }
    else
    {
      op->vtkPVRenderView::UseLightKitOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_StreamingUpdate(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "StreamingUpdate");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  const size_t size0 = 24;
  double temp0[24];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->StreamingUpdate(temp0);
    }
    else
    {
      op->vtkPVRenderView::StreamingUpdate(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_DeliverStreamedPieces(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "DeliverStreamedPieces");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  unsigned int temp0;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<unsigned int> store1(2*size1);
  unsigned int *temp1 = store1.Data();
  unsigned int *save1 = (size1 == 0 ? nullptr : temp1 + size1);
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1))
  {
    vtkPythonArgs::Save(temp1, save1, size1);

    if (ap.IsBound())
    {
      op->DeliverStreamedPieces(temp0, temp1);
    }
    else
    {
      op->vtkPVRenderView::DeliverStreamedPieces(temp0, temp1);
    }

    if (vtkPythonArgs::HasChanged(temp1, save1, size1) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(1, temp1, size1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_USE_LOD(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "USE_LOD");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkInformationIntegerKey *tempr = vtkPVRenderView::USE_LOD();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_LOD_RESOLUTION(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "LOD_RESOLUTION");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkInformationDoubleKey *tempr = vtkPVRenderView::LOD_RESOLUTION();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_USE_OUTLINE_FOR_LOD(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "USE_OUTLINE_FOR_LOD");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkInformationIntegerKey *tempr = vtkPVRenderView::USE_OUTLINE_FOR_LOD();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_RENDER_EMPTY_IMAGES(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "RENDER_EMPTY_IMAGES");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkInformationIntegerKey *tempr = vtkPVRenderView::RENDER_EMPTY_IMAGES();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_NEED_ORDERED_COMPOSITING(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "NEED_ORDERED_COMPOSITING");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkInformationIntegerKey *tempr = vtkPVRenderView::NEED_ORDERED_COMPOSITING();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_VIEW_PLANES(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "VIEW_PLANES");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkInformationDoubleVectorKey *tempr = vtkPVRenderView::VIEW_PLANES();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_REQUEST_STREAMING_UPDATE(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "REQUEST_STREAMING_UPDATE");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkInformationRequestKey *tempr = vtkPVRenderView::REQUEST_STREAMING_UPDATE();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_REQUEST_PROCESS_STREAMED_PIECE(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "REQUEST_PROCESS_STREAMED_PIECE");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkInformationRequestKey *tempr = vtkPVRenderView::REQUEST_PROCESS_STREAMED_PIECE();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SelectCells_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SelectCells");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  const size_t size0 = 4;
  int temp0[4];
  int save0[4];
  const char *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1, 2) &&
      ap.GetArray(temp0, size0) &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->SelectCells(temp0, temp1);
    }
    else
    {
      op->vtkPVRenderView::SelectCells(temp0, temp1);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVRenderView_SelectCells_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SelectCells");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  int temp0;
  int temp1;
  int temp2;
  int temp3;
  const char *temp4 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4, 5) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3) &&
      (ap.NoArgsLeft() || ap.GetValue(temp4)))
  {
    if (ap.IsBound())
    {
      op->SelectCells(temp0, temp1, temp2, temp3, temp4);
    }
    else
    {
      op->vtkPVRenderView::SelectCells(temp0, temp1, temp2, temp3, temp4);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVRenderView_SelectCells(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
    case 2:
      return PyvtkPVRenderView_SelectCells_s1(self, args);
    case 4:
    case 5:
      return PyvtkPVRenderView_SelectCells_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SelectCells");
  return nullptr;
}


static PyObject *
PyvtkPVRenderView_SelectPoints_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SelectPoints");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  const size_t size0 = 4;
  int temp0[4];
  int save0[4];
  const char *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1, 2) &&
      ap.GetArray(temp0, size0) &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->SelectPoints(temp0, temp1);
    }
    else
    {
      op->vtkPVRenderView::SelectPoints(temp0, temp1);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVRenderView_SelectPoints_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SelectPoints");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  int temp0;
  int temp1;
  int temp2;
  int temp3;
  const char *temp4 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4, 5) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3) &&
      (ap.NoArgsLeft() || ap.GetValue(temp4)))
  {
    if (ap.IsBound())
    {
      op->SelectPoints(temp0, temp1, temp2, temp3, temp4);
    }
    else
    {
      op->vtkPVRenderView::SelectPoints(temp0, temp1, temp2, temp3, temp4);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVRenderView_SelectPoints(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
    case 2:
      return PyvtkPVRenderView_SelectPoints_s1(self, args);
    case 4:
    case 5:
      return PyvtkPVRenderView_SelectPoints_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SelectPoints");
  return nullptr;
}


static PyObject *
PyvtkPVRenderView_Select(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Select");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  int temp0;
  const size_t size1 = 4;
  int temp1[4];
  int save1[4];
  const char *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2, 3) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1) &&
      (ap.NoArgsLeft() || ap.GetValue(temp2)))
  {
    vtkPythonArgs::Save(temp1, save1, size1);

    if (ap.IsBound())
    {
      op->Select(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVRenderView::Select(temp0, temp1, temp2);
    }

    if (vtkPythonArgs::HasChanged(temp1, save1, size1) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(1, temp1, size1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SelectPolygonPoints(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SelectPolygonPoints");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  size_t size0 = ap.GetArgSize(0);
  vtkPythonArgs::Array<int> store0(2*size0);
  int *temp0 = store0.Data();
  int *save0 = (size0 == 0 ? nullptr : temp0 + size0);
  long long temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetArray(temp0, size0) &&
      ap.GetValue(temp1))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->SelectPolygonPoints(temp0, temp1);
    }
    else
    {
      op->vtkPVRenderView::SelectPolygonPoints(temp0, temp1);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SelectPolygonCells(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SelectPolygonCells");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  size_t size0 = ap.GetArgSize(0);
  vtkPythonArgs::Array<int> store0(2*size0);
  int *temp0 = store0.Data();
  int *save0 = (size0 == 0 ? nullptr : temp0 + size0);
  long long temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetArray(temp0, size0) &&
      ap.GetValue(temp1))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->SelectPolygonCells(temp0, temp1);
    }
    else
    {
      op->vtkPVRenderView::SelectPolygonCells(temp0, temp1);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SelectPolygon(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SelectPolygon");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  int temp0;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<int> store1(2*size1);
  int *temp1 = store1.Data();
  int *save1 = (size1 == 0 ? nullptr : temp1 + size1);
  long long temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1) &&
      ap.GetValue(temp2))
  {
    vtkPythonArgs::Save(temp1, save1, size1);

    if (ap.IsBound())
    {
      op->SelectPolygon(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVRenderView::SelectPolygon(temp0, temp1, temp2);
    }

    if (vtkPythonArgs::HasChanged(temp1, save1, size1) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(1, temp1, size1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_GetLastSelection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLastSelection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSelection *tempr = (ap.IsBound() ?
      op->GetLastSelection() :
      op->vtkPVRenderView::GetLastSelection());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetUseInteractiveRenderingForScreenshots(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseInteractiveRenderingForScreenshots");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseInteractiveRenderingForScreenshots(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetUseInteractiveRenderingForScreenshots(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_UseInteractiveRenderingForScreenshotsOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UseInteractiveRenderingForScreenshotsOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UseInteractiveRenderingForScreenshotsOn();
    }
    else
    {
      op->vtkPVRenderView::UseInteractiveRenderingForScreenshotsOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_UseInteractiveRenderingForScreenshotsOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UseInteractiveRenderingForScreenshotsOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UseInteractiveRenderingForScreenshotsOff();
    }
    else
    {
      op->vtkPVRenderView::UseInteractiveRenderingForScreenshotsOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_GetUseInteractiveRenderingForScreenshots(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseInteractiveRenderingForScreenshots");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseInteractiveRenderingForScreenshots() :
      op->vtkPVRenderView::GetUseInteractiveRenderingForScreenshots());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_GetRemoteRenderingAvailable(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRemoteRenderingAvailable");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetRemoteRenderingAvailable() :
      op->vtkPVRenderView::GetRemoteRenderingAvailable());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_RemoteRenderingAvailableOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoteRenderingAvailableOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->RemoteRenderingAvailableOff();
    }
    else
    {
      op->vtkPVRenderView::RemoteRenderingAvailableOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_NVPipeAvailableOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NVPipeAvailableOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->NVPipeAvailableOn();
    }
    else
    {
      op->vtkPVRenderView::NVPipeAvailableOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_NVPipeAvailableOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NVPipeAvailableOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->NVPipeAvailableOff();
    }
    else
    {
      op->vtkPVRenderView::NVPipeAvailableOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_GetUsedLODForLastRender(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUsedLODForLastRender");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUsedLODForLastRender() :
      op->vtkPVRenderView::GetUsedLODForLastRender());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_InvalidateCachedSelection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InvalidateCachedSelection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->InvalidateCachedSelection();
    }
    else
    {
      op->vtkPVRenderView::InvalidateCachedSelection();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_GetPieceProducer(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetPieceProducer");

  vtkInformation *temp0 = nullptr;
  vtkPVDataRepresentation *temp1 = nullptr;
  int temp2 = 0;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2, 3) &&
      ap.GetVTKObject(temp0, "vtkInformation") &&
      ap.GetVTKObject(temp1, "vtkPVDataRepresentation") &&
      (ap.NoArgsLeft() || ap.GetValue(temp2)))
  {
    vtkAlgorithmOutput *tempr = vtkPVRenderView::GetPieceProducer(temp0, temp1, temp2);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_GetPieceProducerLOD(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetPieceProducerLOD");

  vtkInformation *temp0 = nullptr;
  vtkPVDataRepresentation *temp1 = nullptr;
  int temp2 = 0;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2, 3) &&
      ap.GetVTKObject(temp0, "vtkInformation") &&
      ap.GetVTKObject(temp1, "vtkPVDataRepresentation") &&
      (ap.NoArgsLeft() || ap.GetValue(temp2)))
  {
    vtkAlgorithmOutput *tempr = vtkPVRenderView::GetPieceProducerLOD(temp0, temp1, temp2);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetRedistributionMode(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetRedistributionMode");

  vtkInformation *temp0 = nullptr;
  vtkPVDataRepresentation *temp1 = nullptr;
  int temp2;
  int temp3 = 0;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(3, 4) &&
      ap.GetVTKObject(temp0, "vtkInformation") &&
      ap.GetVTKObject(temp1, "vtkPVDataRepresentation") &&
      ap.GetValue(temp2) &&
      (ap.NoArgsLeft() || ap.GetValue(temp3)))
  {
    vtkPVRenderView::SetRedistributionMode(temp0, temp1, temp2, temp3);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetRedistributionModeToSplitBoundaryCells(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetRedistributionModeToSplitBoundaryCells");

  vtkInformation *temp0 = nullptr;
  vtkPVDataRepresentation *temp1 = nullptr;
  int temp2 = 0;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2, 3) &&
      ap.GetVTKObject(temp0, "vtkInformation") &&
      ap.GetVTKObject(temp1, "vtkPVDataRepresentation") &&
      (ap.NoArgsLeft() || ap.GetValue(temp2)))
  {
    vtkPVRenderView::SetRedistributionModeToSplitBoundaryCells(temp0, temp1, temp2);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetRedistributionModeToDuplicateBoundaryCells(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetRedistributionModeToDuplicateBoundaryCells");

  vtkInformation *temp0 = nullptr;
  vtkPVDataRepresentation *temp1 = nullptr;
  int temp2 = 0;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2, 3) &&
      ap.GetVTKObject(temp0, "vtkInformation") &&
      ap.GetVTKObject(temp1, "vtkPVDataRepresentation") &&
      (ap.NoArgsLeft() || ap.GetValue(temp2)))
  {
    vtkPVRenderView::SetRedistributionModeToDuplicateBoundaryCells(temp0, temp1, temp2);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetRedistributionModeToUniquelyAssignBoundaryCells(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetRedistributionModeToUniquelyAssignBoundaryCells");

  vtkInformation *temp0 = nullptr;
  vtkPVDataRepresentation *temp1 = nullptr;
  int temp2 = 0;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2, 3) &&
      ap.GetVTKObject(temp0, "vtkInformation") &&
      ap.GetVTKObject(temp1, "vtkPVDataRepresentation") &&
      (ap.NoArgsLeft() || ap.GetValue(temp2)))
  {
    vtkPVRenderView::SetRedistributionModeToUniquelyAssignBoundaryCells(temp0, temp1, temp2);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetGeometryBounds(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetGeometryBounds");

  vtkInformation *temp0 = nullptr;
  vtkPVDataRepresentation *temp1 = nullptr;
  const size_t size2 = 6;
  double temp2[6];
  vtkMatrix4x4 *temp3 = nullptr;
  int temp4 = 0;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(3, 5) &&
      ap.GetVTKObject(temp0, "vtkInformation") &&
      ap.GetVTKObject(temp1, "vtkPVDataRepresentation") &&
      ap.GetArray(temp2, size2) &&
      (ap.NoArgsLeft() || ap.GetVTKObject(temp3, "vtkMatrix4x4")) &&
      (ap.NoArgsLeft() || ap.GetValue(temp4)))
  {
    vtkPVRenderView::SetGeometryBounds(temp0, temp1, temp2, temp3, temp4);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetStreamable(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetStreamable");

  vtkInformation *temp0 = nullptr;
  vtkPVDataRepresentation *temp1 = nullptr;
  bool temp2 = false;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkInformation") &&
      ap.GetVTKObject(temp1, "vtkPVDataRepresentation") &&
      ap.GetValue(temp2))
  {
    vtkPVRenderView::SetStreamable(temp0, temp1, temp2);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetNextStreamedPiece(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetNextStreamedPiece");

  vtkInformation *temp0 = nullptr;
  vtkPVDataRepresentation *temp1 = nullptr;
  vtkDataObject *temp2 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkInformation") &&
      ap.GetVTKObject(temp1, "vtkPVDataRepresentation") &&
      ap.GetVTKObject(temp2, "vtkDataObject"))
  {
    vtkPVRenderView::SetNextStreamedPiece(temp0, temp1, temp2);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_GetCurrentStreamedPiece(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetCurrentStreamedPiece");

  vtkInformation *temp0 = nullptr;
  vtkPVDataRepresentation *temp1 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkInformation") &&
      ap.GetVTKObject(temp1, "vtkPVDataRepresentation"))
  {
    vtkDataObject *tempr = vtkPVRenderView::GetCurrentStreamedPiece(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetOrderedCompositingConfiguration(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetOrderedCompositingConfiguration");

  vtkInformation *temp0 = nullptr;
  vtkPVDataRepresentation *temp1 = nullptr;
  int temp2;
  size_t size3 = ap.GetArgSize(3);
  vtkPythonArgs::Array<double> store3(size3);
  double *temp3 = store3.Data();
  int temp4 = 0;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(3, 5) &&
      ap.GetVTKObject(temp0, "vtkInformation") &&
      ap.GetVTKObject(temp1, "vtkPVDataRepresentation") &&
      ap.GetValue(temp2) &&
      (ap.NoArgsLeft() || ap.GetArray(temp3, size3)) &&
      (ap.NoArgsLeft() || ap.GetValue(temp4)))
  {
    vtkPVRenderView::SetOrderedCompositingConfiguration(temp0, temp1, temp2, temp3, temp4);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetMaxClipBounds(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMaxClipBounds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  const size_t size0 = 6;
  double temp0[6];
  double save0[6];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->SetMaxClipBounds(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetMaxClipBounds(temp0);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetLockBounds(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLockBounds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLockBounds(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetLockBounds(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_GetLockBounds(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLockBounds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetLockBounds() :
      op->vtkPVRenderView::GetLockBounds());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetDeliverToAllProcesses(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetDeliverToAllProcesses");

  vtkInformation *temp0 = nullptr;
  vtkPVDataRepresentation *temp1 = nullptr;
  bool temp2 = false;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkInformation") &&
      ap.GetVTKObject(temp1, "vtkPVDataRepresentation") &&
      ap.GetValue(temp2))
  {
    vtkPVRenderView::SetDeliverToAllProcesses(temp0, temp1, temp2);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetDeliverToClientAndRenderingProcesses(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetDeliverToClientAndRenderingProcesses");

  vtkInformation *temp0 = nullptr;
  vtkPVDataRepresentation *temp1 = nullptr;
  bool temp2 = false;
  bool temp3 = false;
  int temp4 = 0;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(4, 5) &&
      ap.GetVTKObject(temp0, "vtkInformation") &&
      ap.GetVTKObject(temp1, "vtkPVDataRepresentation") &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3) &&
      (ap.NoArgsLeft() || ap.GetValue(temp4)))
  {
    vtkPVRenderView::SetDeliverToClientAndRenderingProcesses(temp0, temp1, temp2, temp3, temp4);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetRequiresDistributedRendering(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetRequiresDistributedRendering");

  vtkInformation *temp0 = nullptr;
  vtkPVDataRepresentation *temp1 = nullptr;
  bool temp2 = false;
  bool temp3 = false;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(3, 4) &&
      ap.GetVTKObject(temp0, "vtkInformation") &&
      ap.GetVTKObject(temp1, "vtkPVDataRepresentation") &&
      ap.GetValue(temp2) &&
      (ap.NoArgsLeft() || ap.GetValue(temp3)))
  {
    vtkPVRenderView::SetRequiresDistributedRendering(temp0, temp1, temp2, temp3);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetRequiresDistributedRenderingLOD(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetRequiresDistributedRenderingLOD");

  vtkInformation *temp0 = nullptr;
  vtkPVDataRepresentation *temp1 = nullptr;
  bool temp2 = false;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkInformation") &&
      ap.GetVTKObject(temp1, "vtkPVDataRepresentation") &&
      ap.GetValue(temp2))
  {
    vtkPVRenderView::SetRequiresDistributedRenderingLOD(temp0, temp1, temp2);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetForceDataDistributionMode(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetForceDataDistributionMode");

  vtkInformation *temp0 = nullptr;
  int temp1;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkInformation") &&
      ap.GetValue(temp1))
  {
    vtkPVRenderView::SetForceDataDistributionMode(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_IsForceDataDistributionModeSet(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsForceDataDistributionModeSet");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->IsForceDataDistributionModeSet() :
      op->vtkPVRenderView::IsForceDataDistributionModeSet());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_GetForceDataDistributionMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetForceDataDistributionMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetForceDataDistributionMode() :
      op->vtkPVRenderView::GetForceDataDistributionMode());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_RegisterPropForHardwareSelection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RegisterPropForHardwareSelection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  vtkPVDataRepresentation *temp0 = nullptr;
  vtkProp *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkPVDataRepresentation") &&
      ap.GetVTKObject(temp1, "vtkProp"))
  {
    int tempr = (ap.IsBound() ?
      op->RegisterPropForHardwareSelection(temp0, temp1) :
      op->vtkPVRenderView::RegisterPropForHardwareSelection(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_UnRegisterPropForHardwareSelection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UnRegisterPropForHardwareSelection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  vtkPVDataRepresentation *temp0 = nullptr;
  vtkProp *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkPVDataRepresentation") &&
      ap.GetVTKObject(temp1, "vtkProp"))
  {
    if (ap.IsBound())
    {
      op->UnRegisterPropForHardwareSelection(temp0, temp1);
    }
    else
    {
      op->vtkPVRenderView::UnRegisterPropForHardwareSelection(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetShowAnnotation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetShowAnnotation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetShowAnnotation(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetShowAnnotation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetUpdateAnnotation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUpdateAnnotation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUpdateAnnotation(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetUpdateAnnotation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetAnnotationColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAnnotationColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetAnnotationColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVRenderView::SetAnnotationColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetGridAxes3DActor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetGridAxes3DActor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  vtkPVGridAxes3DActor *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkPVGridAxes3DActor"))
  {
    if (ap.IsBound())
    {
      op->SetGridAxes3DActor(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetGridAxes3DActor(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetLegendGridActor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLegendGridActor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  vtkLegendScaleActor *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkLegendScaleActor"))
  {
    if (ap.IsBound())
    {
      op->SetLegendGridActor(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetLegendGridActor(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetPolarGridActor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPolarGridActor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  vtkPolarAxesActor2D *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkPolarAxesActor2D"))
  {
    if (ap.IsBound())
    {
      op->SetPolarGridActor(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetPolarGridActor(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetOrientationAxesInteractivity(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOrientationAxesInteractivity");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetOrientationAxesInteractivity(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetOrientationAxesInteractivity(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetOrientationAxesVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOrientationAxesVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetOrientationAxesVisibility(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetOrientationAxesVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetOrientationAxesLabelColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOrientationAxesLabelColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetOrientationAxesLabelColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVRenderView::SetOrientationAxesLabelColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetOrientationAxesOutlineColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOrientationAxesOutlineColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetOrientationAxesOutlineColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVRenderView::SetOrientationAxesOutlineColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetOrientationAxesXColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOrientationAxesXColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetOrientationAxesXColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVRenderView::SetOrientationAxesXColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetOrientationAxesYColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOrientationAxesYColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetOrientationAxesYColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVRenderView::SetOrientationAxesYColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetOrientationAxesZColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOrientationAxesZColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetOrientationAxesZColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVRenderView::SetOrientationAxesZColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetOrientationAxesXVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOrientationAxesXVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetOrientationAxesXVisibility(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetOrientationAxesXVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetOrientationAxesYVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOrientationAxesYVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetOrientationAxesYVisibility(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetOrientationAxesYVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetOrientationAxesZVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOrientationAxesZVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetOrientationAxesZVisibility(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetOrientationAxesZVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetOrientationAxesXLabelText(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOrientationAxesXLabelText");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetOrientationAxesXLabelText(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetOrientationAxesXLabelText(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetOrientationAxesYLabelText(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOrientationAxesYLabelText");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetOrientationAxesYLabelText(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetOrientationAxesYLabelText(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetOrientationAxesZLabelText(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOrientationAxesZLabelText");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetOrientationAxesZLabelText(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetOrientationAxesZLabelText(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetCameraOrientationWidgetVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCameraOrientationWidgetVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetCameraOrientationWidgetVisibility(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetCameraOrientationWidgetVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetCameraOrientationWidgetSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCameraOrientationWidgetSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetCameraOrientationWidgetSize(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetCameraOrientationWidgetSize(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetCameraOrientationWidgetPadding(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCameraOrientationWidgetPadding");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  const size_t size0 = 2;
  int temp0[2];
  int save0[2];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->SetCameraOrientationWidgetPadding(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetCameraOrientationWidgetPadding(temp0);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetCameraOrientationWidgetAnchor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCameraOrientationWidgetAnchor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetCameraOrientationWidgetAnchor(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetCameraOrientationWidgetAnchor(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetCenterAxesVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCenterAxesVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetCenterAxesVisibility(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetCenterAxesVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetCenterOfRotation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCenterOfRotation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetCenterOfRotation(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVRenderView::SetCenterOfRotation(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetRotationFactor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRotationFactor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRotationFactor(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetRotationFactor(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetKeyLightWarmth(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetKeyLightWarmth");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetKeyLightWarmth(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetKeyLightWarmth(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetKeyLightIntensity(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetKeyLightIntensity");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetKeyLightIntensity(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetKeyLightIntensity(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetKeyLightElevation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetKeyLightElevation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetKeyLightElevation(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetKeyLightElevation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetKeyLightAzimuth(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetKeyLightAzimuth");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetKeyLightAzimuth(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetKeyLightAzimuth(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetFillLightWarmth(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFillLightWarmth");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFillLightWarmth(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetFillLightWarmth(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetKeyToFillRatio(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetKeyToFillRatio");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetKeyToFillRatio(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetKeyToFillRatio(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetFillLightElevation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFillLightElevation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFillLightElevation(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetFillLightElevation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetFillLightAzimuth(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFillLightAzimuth");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFillLightAzimuth(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetFillLightAzimuth(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetBackLightWarmth(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBackLightWarmth");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBackLightWarmth(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetBackLightWarmth(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetKeyToBackRatio(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetKeyToBackRatio");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetKeyToBackRatio(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetKeyToBackRatio(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetBackLightElevation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBackLightElevation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBackLightElevation(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetBackLightElevation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetBackLightAzimuth(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBackLightAzimuth");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBackLightAzimuth(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetBackLightAzimuth(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetHeadLightWarmth(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetHeadLightWarmth");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetHeadLightWarmth(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetHeadLightWarmth(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetKeyToHeadRatio(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetKeyToHeadRatio");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetKeyToHeadRatio(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetKeyToHeadRatio(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetMaintainLuminance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMaintainLuminance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMaintainLuminance(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetMaintainLuminance(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetUseHiddenLineRemoval(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseHiddenLineRemoval");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseHiddenLineRemoval(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetUseHiddenLineRemoval(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetUseDepthPeeling(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseDepthPeeling");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseDepthPeeling(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetUseDepthPeeling(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetUseDepthPeelingForVolumes(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseDepthPeelingForVolumes");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseDepthPeelingForVolumes(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetUseDepthPeelingForVolumes(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetMaximumNumberOfPeels(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMaximumNumberOfPeels");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMaximumNumberOfPeels(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetMaximumNumberOfPeels(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetBackgroundTexture(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBackgroundTexture");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  vtkTexture *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkTexture"))
  {
    if (ap.IsBound())
    {
      op->SetBackgroundTexture(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetBackgroundTexture(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetUseRenderViewSettingsForBackground(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseRenderViewSettingsForBackground");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseRenderViewSettingsForBackground(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetUseRenderViewSettingsForBackground(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_GetUseRenderViewSettingsForBackground(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseRenderViewSettingsForBackground");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseRenderViewSettingsForBackground() :
      op->vtkPVRenderView::GetUseRenderViewSettingsForBackground());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetBackgroundColorMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBackgroundColorMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBackgroundColorMode(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetBackgroundColorMode(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_GetBackgroundColorModeMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBackgroundColorModeMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetBackgroundColorModeMinValue() :
      op->vtkPVRenderView::GetBackgroundColorModeMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_GetBackgroundColorModeMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBackgroundColorModeMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetBackgroundColorModeMaxValue() :
      op->vtkPVRenderView::GetBackgroundColorModeMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetBackground_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBackground");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetBackground(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVRenderView::SetBackground(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVRenderView_SetBackground_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBackground");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  const size_t size0 = 3;
  double temp0[3];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetBackground(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetBackground(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVRenderView_SetBackground(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkPVRenderView_SetBackground_s1(self, args);
    case 1:
      return PyvtkPVRenderView_SetBackground_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetBackground");
  return nullptr;
}


static PyObject *
PyvtkPVRenderView_GetBackground(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBackground");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  size_t sizer = 3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double *tempr = (ap.IsBound() ?
      op->GetBackground() :
      op->vtkPVRenderView::GetBackground());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetBackground2_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBackground2");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetBackground2(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVRenderView::SetBackground2(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVRenderView_SetBackground2_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBackground2");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  const size_t size0 = 3;
  double temp0[3];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetBackground2(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetBackground2(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPVRenderView_SetBackground2(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkPVRenderView_SetBackground2_s1(self, args);
    case 1:
      return PyvtkPVRenderView_SetBackground2_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetBackground2");
  return nullptr;
}


static PyObject *
PyvtkPVRenderView_GetBackground2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBackground2");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  size_t sizer = 3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double *tempr = (ap.IsBound() ?
      op->GetBackground2() :
      op->vtkPVRenderView::GetBackground2());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetUseEnvironmentLighting(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseEnvironmentLighting");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseEnvironmentLighting(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetUseEnvironmentLighting(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetEnvironmentalBG(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEnvironmentalBG");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetEnvironmentalBG(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVRenderView::SetEnvironmentalBG(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetEnvironmentalBG2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEnvironmentalBG2");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetEnvironmentalBG2(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVRenderView::SetEnvironmentalBG2(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetEnvironmentalBGTexture(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEnvironmentalBGTexture");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  vtkTexture *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkTexture"))
  {
    if (ap.IsBound())
    {
      op->SetEnvironmentalBGTexture(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetEnvironmentalBGTexture(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetGradientEnvironmentalBG(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetGradientEnvironmentalBG");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetGradientEnvironmentalBG(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetGradientEnvironmentalBG(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetTexturedEnvironmentalBG(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTexturedEnvironmentalBG");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTexturedEnvironmentalBG(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetTexturedEnvironmentalBG(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetBackgroundMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBackgroundMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBackgroundMode(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetBackgroundMode(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_AddLight(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddLight");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  vtkLight *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkLight"))
  {
    if (ap.IsBound())
    {
      op->AddLight(temp0);
    }
    else
    {
      op->vtkPVRenderView::AddLight(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_RemoveLight(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveLight");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  vtkLight *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkLight"))
  {
    if (ap.IsBound())
    {
      op->RemoveLight(temp0);
    }
    else
    {
      op->vtkPVRenderView::RemoveLight(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetStereoCapableWindow(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetStereoCapableWindow");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetStereoCapableWindow(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetStereoCapableWindow(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetStereoRender(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetStereoRender");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetStereoRender(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetStereoRender(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetStereoType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetStereoType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetStereoType(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetStereoType(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetServerStereoType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetServerStereoType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetServerStereoType(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetServerStereoType(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetMultiSamples(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMultiSamples");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMultiSamples(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetMultiSamples(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetAlphaBitPlanes(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAlphaBitPlanes");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetAlphaBitPlanes(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetAlphaBitPlanes(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetStencilCapable(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetStencilCapable");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetStencilCapable(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetStencilCapable(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetPhysicalToWorldMatrix(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPhysicalToWorldMatrix");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  const size_t size0 = 16;
  double temp0[16];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetPhysicalToWorldMatrix(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetPhysicalToWorldMatrix(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetParallelProjection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetParallelProjection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetParallelProjection(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetParallelProjection(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetCamera2DManipulators(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCamera2DManipulators");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  const size_t size0 = 9;
  int temp0[9];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetCamera2DManipulators(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetCamera2DManipulators(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetCamera3DManipulators(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCamera3DManipulators");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  const size_t size0 = 9;
  int temp0[9];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetCamera3DManipulators(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetCamera3DManipulators(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetCameraManipulators(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCameraManipulators");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  vtkPVInteractorStyle *temp0 = nullptr;
  const size_t size1 = 9;
  int temp1[9];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkPVInteractorStyle") &&
      ap.GetArray(temp1, size1))
  {
    if (ap.IsBound())
    {
      op->SetCameraManipulators(temp0, temp1);
    }
    else
    {
      op->vtkPVRenderView::SetCameraManipulators(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetReverseMouseWheelZoomDirection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetReverseMouseWheelZoomDirection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetReverseMouseWheelZoomDirection(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetReverseMouseWheelZoomDirection(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetMouseWheelZoomsToCursor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMouseWheelZoomsToCursor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMouseWheelZoomsToCursor(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetMouseWheelZoomsToCursor(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetCamera2DMouseWheelMotionFactor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCamera2DMouseWheelMotionFactor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetCamera2DMouseWheelMotionFactor(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetCamera2DMouseWheelMotionFactor(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetCamera3DMouseWheelMotionFactor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCamera3DMouseWheelMotionFactor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetCamera3DMouseWheelMotionFactor(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetCamera3DMouseWheelMotionFactor(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SynchronizeGeometryBounds(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SynchronizeGeometryBounds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SynchronizeGeometryBounds();
    }
    else
    {
      op->vtkPVRenderView::SynchronizeGeometryBounds();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_Update(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Update");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Update();
    }
    else
    {
      op->vtkPVRenderView::Update();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_UpdateLOD(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UpdateLOD");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UpdateLOD();
    }
    else
    {
      op->vtkPVRenderView::UpdateLOD();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_GetUseLODForInteractiveRender(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseLODForInteractiveRender");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseLODForInteractiveRender() :
      op->vtkPVRenderView::GetUseLODForInteractiveRender());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_GetUseDistributedRenderingForRender(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseDistributedRenderingForRender");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseDistributedRenderingForRender() :
      op->vtkPVRenderView::GetUseDistributedRenderingForRender());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_GetUseDistributedRenderingForLODRender(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseDistributedRenderingForLODRender");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseDistributedRenderingForLODRender() :
      op->vtkPVRenderView::GetUseDistributedRenderingForLODRender());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_GetStillRenderProcesses(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetStillRenderProcesses");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned int tempr = (ap.IsBound() ?
      op->GetStillRenderProcesses() :
      op->vtkPVRenderView::GetStillRenderProcesses());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_GetInteractiveRenderProcesses(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetInteractiveRenderProcesses");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned int tempr = (ap.IsBound() ?
      op->GetInteractiveRenderProcesses() :
      op->vtkPVRenderView::GetInteractiveRenderProcesses());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_GetDataDistributionMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDataDistributionMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->GetDataDistributionMode(temp0) :
      op->vtkPVRenderView::GetDataDistributionMode(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_Deliver(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Deliver");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  int temp0;
  unsigned int temp1;
  size_t size2 = ap.GetArgSize(2);
  vtkPythonArgs::Array<unsigned int> store2(2*size2);
  unsigned int *temp2 = store2.Data();
  unsigned int *save2 = (size2 == 0 ? nullptr : temp2 + size2);
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetArray(temp2, size2))
  {
    vtkPythonArgs::Save(temp2, save2, size2);

    if (ap.IsBound())
    {
      op->Deliver(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVRenderView::Deliver(temp0, temp1, temp2);
    }

    if (vtkPythonArgs::HasChanged(temp2, save2, size2) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(2, temp2, size2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_GetUseOrderedCompositing(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseOrderedCompositing");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseOrderedCompositing() :
      op->vtkPVRenderView::GetUseOrderedCompositing());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_GetRenderEmptyImages(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRenderEmptyImages");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetRenderEmptyImages() :
      op->vtkPVRenderView::GetRenderEmptyImages());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetUseFXAA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseFXAA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseFXAA(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetUseFXAA(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_GetUseFXAA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseFXAA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseFXAA() :
      op->vtkPVRenderView::GetUseFXAA());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetFXAARelativeContrastThreshold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFXAARelativeContrastThreshold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFXAARelativeContrastThreshold(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetFXAARelativeContrastThreshold(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetFXAAHardContrastThreshold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFXAAHardContrastThreshold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFXAAHardContrastThreshold(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetFXAAHardContrastThreshold(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetFXAASubpixelBlendLimit(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFXAASubpixelBlendLimit");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFXAASubpixelBlendLimit(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetFXAASubpixelBlendLimit(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetFXAASubpixelContrastThreshold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFXAASubpixelContrastThreshold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFXAASubpixelContrastThreshold(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetFXAASubpixelContrastThreshold(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetFXAAUseHighQualityEndpoints(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFXAAUseHighQualityEndpoints");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFXAAUseHighQualityEndpoints(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetFXAAUseHighQualityEndpoints(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetFXAAEndpointSearchIterations(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFXAAEndpointSearchIterations");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFXAAEndpointSearchIterations(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetFXAAEndpointSearchIterations(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetUseToneMapping(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseToneMapping");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseToneMapping(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetUseToneMapping(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_GetUseToneMapping(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseToneMapping");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseToneMapping() :
      op->vtkPVRenderView::GetUseToneMapping());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetToneMappingType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetToneMappingType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetToneMappingType(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetToneMappingType(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetExposure(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetExposure");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetExposure(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetExposure(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetContrast(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetContrast");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetContrast(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetContrast(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetShoulder(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetShoulder");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetShoulder(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetShoulder(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetMidIn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMidIn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMidIn(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetMidIn(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetMidOut(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMidOut");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMidOut(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetMidOut(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetHdrMax(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetHdrMax");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetHdrMax(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetHdrMax(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetUseACES(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseACES");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseACES(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetUseACES(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetGenericFilmicPresets(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetGenericFilmicPresets");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetGenericFilmicPresets(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetGenericFilmicPresets(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetUseSSAO(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseSSAO");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseSSAO(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetUseSSAO(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_GetUseSSAO(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseSSAO");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseSSAO() :
      op->vtkPVRenderView::GetUseSSAO());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetUseSSAODefaultPresets(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseSSAODefaultPresets");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseSSAODefaultPresets(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetUseSSAODefaultPresets(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetRadius(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRadius");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRadius(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetRadius(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetKernelSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetKernelSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetKernelSize(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetKernelSize(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetBias(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBias");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBias(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetBias(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetBlur(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBlur");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBlur(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetBlur(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_CopyViewUpdateOptions(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CopyViewUpdateOptions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  vtkPVRenderView *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkPVRenderView"))
  {
    if (ap.IsBound())
    {
      op->CopyViewUpdateOptions(temp0);
    }
    else
    {
      op->vtkPVRenderView::CopyViewUpdateOptions(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_AddPropToRenderer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddPropToRenderer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  vtkProp *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkProp"))
  {
    if (ap.IsBound())
    {
      op->AddPropToRenderer(temp0);
    }
    else
    {
      op->vtkPVRenderView::AddPropToRenderer(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_RemovePropFromRenderer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemovePropFromRenderer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  vtkProp *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkProp"))
  {
    if (ap.IsBound())
    {
      op->RemovePropFromRenderer(temp0);
    }
    else
    {
      op->vtkPVRenderView::RemovePropFromRenderer(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_BeginValuePassForRendering(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "BeginValuePassForRendering");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  int temp0;
  const char *temp1 = nullptr;
  int temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    bool tempr = (ap.IsBound() ?
      op->BeginValuePassForRendering(temp0, temp1, temp2) :
      op->vtkPVRenderView::BeginValuePassForRendering(temp0, temp1, temp2));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_EndValuePassForRendering(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "EndValuePassForRendering");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->EndValuePassForRendering();
    }
    else
    {
      op->vtkPVRenderView::EndValuePassForRendering();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_GrabValuePassResult(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GrabValuePassResult");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSmartPointer<vtkFloatArray> tempr = (ap.IsBound() ?
      op->GrabValuePassResult() :
      op->vtkPVRenderView::GrabValuePassResult());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_CaptureZBuffer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CaptureZBuffer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->CaptureZBuffer();
    }
    else
    {
      op->vtkPVRenderView::CaptureZBuffer();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_GetCapturedZBuffer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCapturedZBuffer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkFloatArray *tempr = (ap.IsBound() ?
      op->GetCapturedZBuffer() :
      op->vtkPVRenderView::GetCapturedZBuffer());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetEnableSynchronizableActors(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEnableSynchronizableActors");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEnableSynchronizableActors(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetEnableSynchronizableActors(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_GetEnableSynchronizableActors(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEnableSynchronizableActors");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetEnableSynchronizableActors() :
      op->vtkPVRenderView::GetEnableSynchronizableActors());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetEnableOSPRay(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEnableOSPRay");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEnableOSPRay(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetEnableOSPRay(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_GetEnableOSPRay(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEnableOSPRay");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetEnableOSPRay() :
      op->vtkPVRenderView::GetEnableOSPRay());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetShadows(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetShadows");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetShadows(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetShadows(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_GetShadows(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetShadows");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetShadows() :
      op->vtkPVRenderView::GetShadows());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetAmbientOcclusionSamples(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAmbientOcclusionSamples");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetAmbientOcclusionSamples(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetAmbientOcclusionSamples(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_GetAmbientOcclusionSamples(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAmbientOcclusionSamples");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetAmbientOcclusionSamples() :
      op->vtkPVRenderView::GetAmbientOcclusionSamples());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetRouletteDepth(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRouletteDepth");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRouletteDepth(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetRouletteDepth(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_GetRouletteDepth(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRouletteDepth");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetRouletteDepth() :
      op->vtkPVRenderView::GetRouletteDepth());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetSamplesPerPixel(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSamplesPerPixel");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSamplesPerPixel(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetSamplesPerPixel(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_GetSamplesPerPixel(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSamplesPerPixel");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetSamplesPerPixel() :
      op->vtkPVRenderView::GetSamplesPerPixel());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetMaxFrames(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMaxFrames");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMaxFrames(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetMaxFrames(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_GetMaxFrames(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMaxFrames");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetMaxFrames() :
      op->vtkPVRenderView::GetMaxFrames());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_GetOSPRayContinueStreaming(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetOSPRayContinueStreaming");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetOSPRayContinueStreaming() :
      op->vtkPVRenderView::GetOSPRayContinueStreaming());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetDenoise(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDenoise");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDenoise(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetDenoise(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_GetDenoise(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDenoise");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetDenoise() :
      op->vtkPVRenderView::GetDenoise());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetLightScale(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLightScale");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLightScale(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetLightScale(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_GetLightScale(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLightScale");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetLightScale() :
      op->vtkPVRenderView::GetLightScale());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetOSPRayRendererType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOSPRayRendererType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetOSPRayRendererType(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetOSPRayRendererType(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetBackgroundNorth(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBackgroundNorth");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetBackgroundNorth(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVRenderView::SetBackgroundNorth(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetBackgroundEast(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBackgroundEast");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetBackgroundEast(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVRenderView::SetBackgroundEast(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetMaterialLibrary(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMaterialLibrary");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  vtkPVMaterialLibrary *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkPVMaterialLibrary"))
  {
    if (ap.IsBound())
    {
      op->SetMaterialLibrary(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetMaterialLibrary(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetViewTime(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetViewTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetViewTime(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetViewTime(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetTimeCacheSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTimeCacheSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTimeCacheSize(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetTimeCacheSize(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_GetTimeCacheSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTimeCacheSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetTimeCacheSize() :
      op->vtkPVRenderView::GetTimeCacheSize());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_GetDiscreteCameras(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetDiscreteCameras");

  vtkInformation *temp0 = nullptr;
  vtkPVDataRepresentation *temp1 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkInformation") &&
      ap.GetVTKObject(temp1, "vtkPVDataRepresentation"))
  {
    vtkPVCameraCollection *tempr = vtkPVRenderView::GetDiscreteCameras(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetDiscreteCameras(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetDiscreteCameras");

  vtkInformation *temp0 = nullptr;
  vtkPVDataRepresentation *temp1 = nullptr;
  vtkPVCameraCollection *temp2 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkInformation") &&
      ap.GetVTKObject(temp1, "vtkPVDataRepresentation") &&
      ap.GetVTKObject(temp2, "vtkPVCameraCollection"))
  {
    vtkPVRenderView::SetDiscreteCameras(temp0, temp1, temp2);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_GetRenderView(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRenderView");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkRenderViewBase *tempr = (ap.IsBound() ?
      op->GetRenderView() :
      op->vtkPVRenderView::GetRenderView());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_ScaleRendererViewports(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ScaleRendererViewports");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  const size_t size0 = 4;
  double temp0[4];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->ScaleRendererViewports(temp0);
    }
    else
    {
      op->vtkPVRenderView::ScaleRendererViewports(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SynchronizeMaximumIds(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SynchronizeMaximumIds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  size_t size0 = ap.GetArgSize(0);
  vtkPythonArgs::Array<long long> store0(2*size0);
  long long *temp0 = store0.Data();
  long long *save0 = (size0 == 0 ? nullptr : temp0 + size0);
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<long long> store1(2*size1);
  long long *temp1 = store1.Data();
  long long *save1 = (size1 == 0 ? nullptr : temp1 + size1);
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetArray(temp0, size0) &&
      ap.GetArray(temp1, size1))
  {
    vtkPythonArgs::Save(temp0, save0, size0);
    vtkPythonArgs::Save(temp1, save1, size1);

    if (ap.IsBound())
    {
      op->SynchronizeMaximumIds(temp0, temp1);
    }
    else
    {
      op->vtkPVRenderView::SynchronizeMaximumIds(temp0, temp1);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (vtkPythonArgs::HasChanged(temp1, save1, size1) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(1, temp1, size1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderView_SetHardwareSelector(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetHardwareSelector");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderView *op = static_cast<vtkPVRenderView *>(vp);

  vtkPVHardwareSelector *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkPVHardwareSelector"))
  {
    if (ap.IsBound())
    {
      op->SetHardwareSelector(temp0);
    }
    else
    {
      op->vtkPVRenderView::SetHardwareSelector(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkPVRenderView_Methods[] = {
  {"IsTypeOf", PyvtkPVRenderView_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPVRenderView_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPVRenderView_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPVRenderView\nC++: static vtkPVRenderView *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPVRenderView_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPVRenderView\nC++: vtkPVRenderView *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPVRenderView_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPVRenderView_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetInteractionMode", PyvtkPVRenderView_SetInteractionMode, METH_VARARGS,
   "SetInteractionMode(self, mode:int) -> None\nC++: virtual void SetInteractionMode(int mode)\n\nGet/Set the interaction mode. Default is INTERACTION_MODE_3D. If\nINTERACTION_MODE_SELECTION is selected, then whenever the user\ndrags and creates a selection region, this class will fire a\nvtkCommand::SelectionChangedEvent event with the selection region\nas the argument.\n\note CallOnAllProcesses\n\note this must be called on all processes, however it will have\nany effect only the driver processes i.e. the process with the\ninteractor.\n"},
  {"GetInteractionMode", PyvtkPVRenderView_GetInteractionMode, METH_VARARGS,
   "GetInteractionMode(self) -> int\nC++: virtual int GetInteractionMode()\n\n"},
  {"SetSize", PyvtkPVRenderView_SetSize, METH_VARARGS,
   "SetSize(self, __a:int, __b:int) -> None\nC++: void SetSize(int, int) override;\n\nOverridden to call InvalidateCachedSelection() whenever the\nrender window parameters change.\n"},
  {"SetPosition", PyvtkPVRenderView_SetPosition, METH_VARARGS,
   "SetPosition(self, __a:int, __b:int) -> None\nC++: void SetPosition(int, int) override;\n\nSet the position on this view in the multiview configuration.\n\note CallOnAllProcesses\n"},
  {"GetNonCompositedRenderer", PyvtkPVRenderView_GetNonCompositedRenderer, METH_VARARGS,
   "GetNonCompositedRenderer(self) -> vtkRenderer\nC++: virtual vtkRenderer *GetNonCompositedRenderer()\n\nGets the non-composited renderer for this view. This is typically\nused for labels, 2D annotations etc.\n\note CallOnAllProcesses\n"},
  {"GetRenderer", PyvtkPVRenderView_GetRenderer, METH_VARARGS,
   "GetRenderer(self, rendererType:int=...) -> vtkRenderer\nC++: virtual vtkRenderer *GetRenderer(\n    int rendererType=DEFAULT_RENDERER)\n\nReturns the renderer given an int identifying its type.\n\\li DEFAULT_RENDERER: returns the 3D renderer.\n\\li NON_COMPOSITED_RENDERER: returns the NonCompositedRenderer.\n"},
  {"GetActiveCamera", PyvtkPVRenderView_GetActiveCamera, METH_VARARGS,
   "GetActiveCamera(self) -> vtkCamera\nC++: vtkCamera *GetActiveCamera()\n\nGet/Set the active camera. The active camera is set on both the\ncomposited and non-composited renderer.\n"},
  {"SetActiveCamera", PyvtkPVRenderView_SetActiveCamera, METH_VARARGS,
   "SetActiveCamera(self, __a:vtkCamera) -> None\nC++: virtual void SetActiveCamera(vtkCamera *)\n\n"},
  {"GetInteractor", PyvtkPVRenderView_GetInteractor, METH_VARARGS,
   "GetInteractor(self) -> vtkRenderWindowInteractor\nC++: vtkRenderWindowInteractor *GetInteractor()\n\nReturns the interactor.\n"},
  {"SetupInteractor", PyvtkPVRenderView_SetupInteractor, METH_VARARGS,
   "SetupInteractor(self, __a:vtkRenderWindowInteractor) -> None\nC++: virtual void SetupInteractor(vtkRenderWindowInteractor *)\n\nSet the interactor. Client applications must set the interactor\nto enable interactivity. Note this method will also change the\ninteractor styles set on the interactor.\n"},
  {"GetInteractorStyle", PyvtkPVRenderView_GetInteractorStyle, METH_VARARGS,
   "GetInteractorStyle(self) -> vtkPVInteractorStyle\nC++: virtual vtkPVInteractorStyle *GetInteractorStyle()\n\nReturns the interactor style.\n"},
  {"ResetCamera", PyvtkPVRenderView_ResetCamera, METH_VARARGS,
   "ResetCamera(self) -> None\nC++: void ResetCamera()\nResetCamera(self, bounds:[float, float, float, float, float,\n    float]) -> None\nC++: void ResetCamera(double bounds[6])\n\nResets the active camera using collective prop-bounds.\n\nOffsetRatio can be used to add a zoom offset.\n\note CallOnAllProcesses\n"},
  {"ResetCameraScreenSpace", PyvtkPVRenderView_ResetCameraScreenSpace, METH_VARARGS,
   "ResetCameraScreenSpace(self, offsetRatio:float=0.9) -> None\nC++: void ResetCameraScreenSpace(double offsetRatio=0.9)\nResetCameraScreenSpace(self, bounds:[float, ...],\n    offsetRatio:float=0.9) -> None\nC++: void ResetCameraScreenSpace(double *bounds,\n    double offsetRatio=0.9)\n\n"},
  {"ComputeVisibleBounds", PyvtkPVRenderView_ComputeVisibleBounds, METH_VARARGS,
   "ComputeVisibleBounds(self, pvrepr:vtkPVDataRepresentation) -> (\n    float, float, float, float, float, float)\nC++: double *ComputeVisibleBounds(vtkPVDataRepresentation *pvrepr)\n\nCompute and reduce the visible bounds of the provided\nrepresentation. Uses LastRepresentationVisibleBounds to store the\nresult until the next call.\n\note CallOnAllProcesses\n"},
  {"StillRender", PyvtkPVRenderView_StillRender, METH_VARARGS,
   "StillRender(self) -> None\nC++: void StillRender() override;\n\nTriggers a high-resolution render.\n\note Can be called on processes involved in rendering i.e those\nreturned by `this->GetStillRenderProcesses()`.\n"},
  {"InteractiveRender", PyvtkPVRenderView_InteractiveRender, METH_VARARGS,
   "InteractiveRender(self) -> None\nC++: void InteractiveRender() override;\n\nTriggers a interactive render. Based on the settings on the view,\nthis may result in a low-resolution rendering or a simplified\ngeometry rendering.\n\note Can be called on processes involved in rendering i.e those\nreturned by `this->GetInteractiveRenderProcesses()`.\n"},
  {"SetSuppressRendering", PyvtkPVRenderView_SetSuppressRendering, METH_VARARGS,
   "SetSuppressRendering(self, _arg:bool) -> None\nC++: virtual void SetSuppressRendering(bool _arg)\n\nSuppressRendering can be used to suppress the render within a\nStillRender or InteractiveRender. This is useful in cases where\nyou want the representations mappers to be setup for rendering\nand have their data ready but not actually do the render. For\nexample if you want to export the scene but not render it you\nmust turn on SuppressRendering and then call StillRender\n"},
  {"GetSuppressRendering", PyvtkPVRenderView_GetSuppressRendering, METH_VARARGS,
   "GetSuppressRendering(self) -> bool\nC++: virtual bool GetSuppressRendering()\n\n"},
  {"SuppressRenderingOn", PyvtkPVRenderView_SuppressRenderingOn, METH_VARARGS,
   "SuppressRenderingOn(self) -> None\nC++: virtual void SuppressRenderingOn()\n\n"},
  {"SuppressRenderingOff", PyvtkPVRenderView_SuppressRenderingOff, METH_VARARGS,
   "SuppressRenderingOff(self) -> None\nC++: virtual void SuppressRenderingOff()\n\n"},
  {"SetStillRenderImageReductionFactor", PyvtkPVRenderView_SetStillRenderImageReductionFactor, METH_VARARGS,
   "SetStillRenderImageReductionFactor(self, _arg:int) -> None\nC++: virtual void SetStillRenderImageReductionFactor(int _arg)\n\nGet/Set the reduction-factor to use when for StillRender(). This\nis typically set to 1, but in some cases with terrible\nconnectivity or really large displays, one may want to use a\nsub-sampled image even for StillRender(). This is set it number\nof pixels to be sub-sampled by. Note that image reduction factors\nhave no effect when in built-in mode.\n\note CallOnAllProcesses\n"},
  {"GetStillRenderImageReductionFactorMinValue", PyvtkPVRenderView_GetStillRenderImageReductionFactorMinValue, METH_VARARGS,
   "GetStillRenderImageReductionFactorMinValue(self) -> int\nC++: virtual int GetStillRenderImageReductionFactorMinValue()\n\n"},
  {"GetStillRenderImageReductionFactorMaxValue", PyvtkPVRenderView_GetStillRenderImageReductionFactorMaxValue, METH_VARARGS,
   "GetStillRenderImageReductionFactorMaxValue(self) -> int\nC++: virtual int GetStillRenderImageReductionFactorMaxValue()\n\n"},
  {"GetStillRenderImageReductionFactor", PyvtkPVRenderView_GetStillRenderImageReductionFactor, METH_VARARGS,
   "GetStillRenderImageReductionFactor(self) -> int\nC++: virtual int GetStillRenderImageReductionFactor()\n\n"},
  {"SetInteractiveRenderImageReductionFactor", PyvtkPVRenderView_SetInteractiveRenderImageReductionFactor, METH_VARARGS,
   "SetInteractiveRenderImageReductionFactor(self, _arg:int) -> None\nC++: virtual void SetInteractiveRenderImageReductionFactor(\n    int _arg)\n\nGet/Set the reduction-factor to use when for InteractiveRender().\nThis is set it number of pixels to be sub-sampled by. Note that\nimage reduction factors have no effect when in built-in mode.\n\note CallOnAllProcesses\n"},
  {"GetInteractiveRenderImageReductionFactorMinValue", PyvtkPVRenderView_GetInteractiveRenderImageReductionFactorMinValue, METH_VARARGS,
   "GetInteractiveRenderImageReductionFactorMinValue(self) -> int\nC++: virtual int GetInteractiveRenderImageReductionFactorMinValue(\n    )\n\n"},
  {"GetInteractiveRenderImageReductionFactorMaxValue", PyvtkPVRenderView_GetInteractiveRenderImageReductionFactorMaxValue, METH_VARARGS,
   "GetInteractiveRenderImageReductionFactorMaxValue(self) -> int\nC++: virtual int GetInteractiveRenderImageReductionFactorMaxValue(\n    )\n\n"},
  {"GetInteractiveRenderImageReductionFactor", PyvtkPVRenderView_GetInteractiveRenderImageReductionFactor, METH_VARARGS,
   "GetInteractiveRenderImageReductionFactor(self) -> int\nC++: virtual int GetInteractiveRenderImageReductionFactor()\n\n"},
  {"SetRemoteRenderingThreshold", PyvtkPVRenderView_SetRemoteRenderingThreshold, METH_VARARGS,
   "SetRemoteRenderingThreshold(self, _arg:float) -> None\nC++: virtual void SetRemoteRenderingThreshold(double _arg)\n\nGet/Set the data-size in megabytes above which remote-rendering\nshould be used, if possible.\n\note CallOnAllProcesses\n"},
  {"GetRemoteRenderingThreshold", PyvtkPVRenderView_GetRemoteRenderingThreshold, METH_VARARGS,
   "GetRemoteRenderingThreshold(self) -> float\nC++: virtual double GetRemoteRenderingThreshold()\n\n"},
  {"SetLODRenderingThreshold", PyvtkPVRenderView_SetLODRenderingThreshold, METH_VARARGS,
   "SetLODRenderingThreshold(self, _arg:float) -> None\nC++: virtual void SetLODRenderingThreshold(double _arg)\n\nGet/Set the data-size in megabytes above which LOD rendering\nshould be used, if possible.\n\note CallOnAllProcesses\n"},
  {"GetLODRenderingThreshold", PyvtkPVRenderView_GetLODRenderingThreshold, METH_VARARGS,
   "GetLODRenderingThreshold(self) -> float\nC++: virtual double GetLODRenderingThreshold()\n\n"},
  {"SetLODResolution", PyvtkPVRenderView_SetLODResolution, METH_VARARGS,
   "SetLODResolution(self, _arg:float) -> None\nC++: virtual void SetLODResolution(double _arg)\n\nGet/Set the LOD resolution. This affects the size of the grid\nused for quadric clustering, for example. 1.0 implies maximum\nresolution while 0 implies minimum resolution.\n\note CallOnAllProcesses\n"},
  {"GetLODResolutionMinValue", PyvtkPVRenderView_GetLODResolutionMinValue, METH_VARARGS,
   "GetLODResolutionMinValue(self) -> float\nC++: virtual double GetLODResolutionMinValue()\n\n"},
  {"GetLODResolutionMaxValue", PyvtkPVRenderView_GetLODResolutionMaxValue, METH_VARARGS,
   "GetLODResolutionMaxValue(self) -> float\nC++: virtual double GetLODResolutionMaxValue()\n\n"},
  {"GetLODResolution", PyvtkPVRenderView_GetLODResolution, METH_VARARGS,
   "GetLODResolution(self) -> float\nC++: virtual double GetLODResolution()\n\n"},
  {"SetUseOutlineForLODRendering", PyvtkPVRenderView_SetUseOutlineForLODRendering, METH_VARARGS,
   "SetUseOutlineForLODRendering(self, _arg:bool) -> None\nC++: virtual void SetUseOutlineForLODRendering(bool _arg)\n\nWhen set to true, instead of using simplified geometry for LOD\nrendering, uses outline, if possible. Note that not all\nrepresentations support this mode and hence one may still see\nnon-outline data being rendering when this flag is ON and LOD is\nbeing used.\n"},
  {"GetUseOutlineForLODRendering", PyvtkPVRenderView_GetUseOutlineForLODRendering, METH_VARARGS,
   "GetUseOutlineForLODRendering(self) -> bool\nC++: virtual bool GetUseOutlineForLODRendering()\n\n"},
  {"ConfigureCompressor", PyvtkPVRenderView_ConfigureCompressor, METH_VARARGS,
   "ConfigureCompressor(self, configuration:str) -> None\nC++: void ConfigureCompressor(const char *configuration)\n\nPasses the compressor configuration to the client-server\nsynchronizer, if any. This affects the image compression used to\nrelay images back to the client. See\nvtkPVClientServerSynchronizedRenderers::ConfigureCompressor() for\ndetails.\n\note CallOnAllProcesses\n"},
  {"ResetCameraClippingRange", PyvtkPVRenderView_ResetCameraClippingRange, METH_VARARGS,
   "ResetCameraClippingRange(self) -> None\nC++: virtual void ResetCameraClippingRange()\n\nResets the clipping range. One does not need to call this\ndirectly ever. It is called periodically by the vtkRenderer to\nreset the camera range.\n"},
  {"SetUseLightKit", PyvtkPVRenderView_SetUseLightKit, METH_VARARGS,
   "SetUseLightKit(self, enable:bool) -> None\nC++: void SetUseLightKit(bool enable)\n\nEnable/Disable light kit.\n\note CallOnAllProcesses\n"},
  {"GetUseLightKit", PyvtkPVRenderView_GetUseLightKit, METH_VARARGS,
   "GetUseLightKit(self) -> bool\nC++: virtual bool GetUseLightKit()\n\n"},
  {"UseLightKitOn", PyvtkPVRenderView_UseLightKitOn, METH_VARARGS,
   "UseLightKitOn(self) -> None\nC++: virtual void UseLightKitOn()\n\n"},
  {"UseLightKitOff", PyvtkPVRenderView_UseLightKitOff, METH_VARARGS,
   "UseLightKitOff(self) -> None\nC++: virtual void UseLightKitOff()\n\n"},
  {"StreamingUpdate", PyvtkPVRenderView_StreamingUpdate, METH_VARARGS,
   "StreamingUpdate(self, view_planes:(float, float, float, float,\n    float, float, float, float, float, float, float, float, float,\n     float, float, float, float, float, float, float, float,\n    float, float, float)) -> None\nC++: void StreamingUpdate(const double view_planes[24])\n\n"},
  {"DeliverStreamedPieces", PyvtkPVRenderView_DeliverStreamedPieces, METH_VARARGS,
   "DeliverStreamedPieces(self, size:int, representation_ids:[int,\n    ...]) -> None\nC++: void DeliverStreamedPieces(unsigned int size,\n    unsigned int *representation_ids)\n\n"},
  {"USE_LOD", PyvtkPVRenderView_USE_LOD, METH_VARARGS,
   "USE_LOD() -> vtkInformationIntegerKey\nC++: static vtkInformationIntegerKey *USE_LOD()\n\nUSE_LOD indicates if LOD is being used for the current\nrender/update.\n"},
  {"LOD_RESOLUTION", PyvtkPVRenderView_LOD_RESOLUTION, METH_VARARGS,
   "LOD_RESOLUTION() -> vtkInformationDoubleKey\nC++: static vtkInformationDoubleKey *LOD_RESOLUTION()\n\nIndicates the LOD resolution in REQUEST_UPDATE_LOD() pass.\n"},
  {"USE_OUTLINE_FOR_LOD", PyvtkPVRenderView_USE_OUTLINE_FOR_LOD, METH_VARARGS,
   "USE_OUTLINE_FOR_LOD() -> vtkInformationIntegerKey\nC++: static vtkInformationIntegerKey *USE_OUTLINE_FOR_LOD()\n\nIndicates the LOD must use outline if possible in\nREQUEST_UPDATE_LOD() pass.\n"},
  {"RENDER_EMPTY_IMAGES", PyvtkPVRenderView_RENDER_EMPTY_IMAGES, METH_VARARGS,
   "RENDER_EMPTY_IMAGES() -> vtkInformationIntegerKey\nC++: static vtkInformationIntegerKey *RENDER_EMPTY_IMAGES()\n\nRepresentation can publish this key in their\nREQUEST_INFORMATION() pass to indicate that the representation\nneeds to disable IceT's empty image optimization. This is\ntypically only needed if a painter will make use of MPI global\ncollective communications.\n"},
  {"NEED_ORDERED_COMPOSITING", PyvtkPVRenderView_NEED_ORDERED_COMPOSITING, METH_VARARGS,
   "NEED_ORDERED_COMPOSITING() -> vtkInformationIntegerKey\nC++: static vtkInformationIntegerKey *NEED_ORDERED_COMPOSITING()\n\nRepresentation can publish this key in their\nREQUEST_INFORMATION() pass to indicate that the representation\nneeds ordered compositing.\n"},
  {"VIEW_PLANES", PyvtkPVRenderView_VIEW_PLANES, METH_VARARGS,
   "VIEW_PLANES() -> vtkInformationDoubleVectorKey\nC++: static vtkInformationDoubleVectorKey *VIEW_PLANES()\n\nKey used to pass meta-data about the view frustum in\nREQUEST_STREAMING_UPDATE() pass. The value is a double vector\nwith exactly 24 values.\n"},
  {"REQUEST_STREAMING_UPDATE", PyvtkPVRenderView_REQUEST_STREAMING_UPDATE, METH_VARARGS,
   "REQUEST_STREAMING_UPDATE() -> vtkInformationRequestKey\nC++: static vtkInformationRequestKey *REQUEST_STREAMING_UPDATE()\n\nStreaming pass request.\n"},
  {"REQUEST_PROCESS_STREAMED_PIECE", PyvtkPVRenderView_REQUEST_PROCESS_STREAMED_PIECE, METH_VARARGS,
   "REQUEST_PROCESS_STREAMED_PIECE() -> vtkInformationRequestKey\nC++: static vtkInformationRequestKey *REQUEST_PROCESS_STREAMED_PIECE(\n    )\n\nPass to relay the streamed \"piece\" to the representations.\n"},
  {"SelectCells", PyvtkPVRenderView_SelectCells, METH_VARARGS,
   "SelectCells(self, region:[int, int, int, int], array:str=...)\n    -> None\nC++: void SelectCells(int region[4], const char *array=nullptr)\nSelectCells(self, region0:int, region1:int, region2:int,\n    region3:int, array:str=...) -> None\nC++: void SelectCells(int region0, int region1, int region2,\n    int region3, const char *array=nullptr)\n\nMake a selection. This will result in setting up of\nthis->LastSelection which can be accessed using\nGetLastSelection().\n\note This method is called on call rendering processes and client\n(or driver). Thus, if doing client only rendering, this shouldn't\nbe called on server nodes.\n"},
  {"SelectPoints", PyvtkPVRenderView_SelectPoints, METH_VARARGS,
   "SelectPoints(self, region:[int, int, int, int], array:str=...)\n    -> None\nC++: void SelectPoints(int region[4], const char *array=nullptr)\nSelectPoints(self, region0:int, region1:int, region2:int,\n    region3:int, array:str=...) -> None\nC++: void SelectPoints(int region0, int region1, int region2,\n    int region3, const char *array=nullptr)\n\n"},
  {"Select", PyvtkPVRenderView_Select, METH_VARARGS,
   "Select(self, field_association:int, region:[int, int, int, int],\n    array:str=...) -> None\nC++: void Select(int field_association, int region[4],\n    const char *array=nullptr)\n\n"},
  {"SelectPolygonPoints", PyvtkPVRenderView_SelectPolygonPoints, METH_VARARGS,
   "SelectPolygonPoints(self, polygon2DArray:[int, ...], arrayLen:int)\n     -> None\nC++: void SelectPolygonPoints(int *polygon2DArray,\n    vtkIdType arrayLen)\n\nMake a selection with a polygon. The polygon2DArray should\ncontain the polygon points in display units of (x, y) tuples, and\narrayLen is the total length of polygon2DArray. This will result\nin setting up of this->LastSelection which can be accessed using\nGetLastSelection().\n\note This method is called on call rendering processes and client\n(or driver). Thus, if doing client only rendering, this shouldn't\nbe called on server nodes.\n"},
  {"SelectPolygonCells", PyvtkPVRenderView_SelectPolygonCells, METH_VARARGS,
   "SelectPolygonCells(self, polygon2DArray:[int, ...], arrayLen:int)\n    -> None\nC++: void SelectPolygonCells(int *polygon2DArray,\n    vtkIdType arrayLen)\n\n"},
  {"SelectPolygon", PyvtkPVRenderView_SelectPolygon, METH_VARARGS,
   "SelectPolygon(self, field_association:int, polygon2DArray:[int,\n    ...], arrayLen:int) -> None\nC++: void SelectPolygon(int field_association,\n    int *polygon2DArray, vtkIdType arrayLen)\n\n"},
  {"GetLastSelection", PyvtkPVRenderView_GetLastSelection, METH_VARARGS,
   "GetLastSelection(self) -> vtkSelection\nC++: virtual vtkSelection *GetLastSelection()\n\nProvides access to the last selection. This is valid only on the\nclient or driver node displaying the composited result.\n"},
  {"SetUseInteractiveRenderingForScreenshots", PyvtkPVRenderView_SetUseInteractiveRenderingForScreenshots, METH_VARARGS,
   "SetUseInteractiveRenderingForScreenshots(self, _arg:bool) -> None\nC++: virtual void SetUseInteractiveRenderingForScreenshots(\n    bool _arg)\n\nSet or get whether capture should be done as StillRender or\nInteractiveRender when capturing screenshots.\n"},
  {"UseInteractiveRenderingForScreenshotsOn", PyvtkPVRenderView_UseInteractiveRenderingForScreenshotsOn, METH_VARARGS,
   "UseInteractiveRenderingForScreenshotsOn(self) -> None\nC++: virtual void UseInteractiveRenderingForScreenshotsOn()\n\n"},
  {"UseInteractiveRenderingForScreenshotsOff", PyvtkPVRenderView_UseInteractiveRenderingForScreenshotsOff, METH_VARARGS,
   "UseInteractiveRenderingForScreenshotsOff(self) -> None\nC++: virtual void UseInteractiveRenderingForScreenshotsOff()\n\n"},
  {"GetUseInteractiveRenderingForScreenshots", PyvtkPVRenderView_GetUseInteractiveRenderingForScreenshots, METH_VARARGS,
   "GetUseInteractiveRenderingForScreenshots(self) -> bool\nC++: virtual bool GetUseInteractiveRenderingForScreenshots()\n\n"},
  {"GetRemoteRenderingAvailable", PyvtkPVRenderView_GetRemoteRenderingAvailable, METH_VARARGS,
   "GetRemoteRenderingAvailable(self) -> bool\nC++: virtual bool GetRemoteRenderingAvailable()\n\nReturns if remote-rendering is possible on the current group of\nprocesses.\n"},
  {"RemoteRenderingAvailableOff", PyvtkPVRenderView_RemoteRenderingAvailableOff, METH_VARARGS,
   "RemoteRenderingAvailableOff(self) -> None\nC++: void RemoteRenderingAvailableOff()\n\n"},
  {"NVPipeAvailableOn", PyvtkPVRenderView_NVPipeAvailableOn, METH_VARARGS,
   "NVPipeAvailableOn(self) -> None\nC++: void NVPipeAvailableOn()\n\nDetermine if NVPipe is an available compressor option.\n"},
  {"NVPipeAvailableOff", PyvtkPVRenderView_NVPipeAvailableOff, METH_VARARGS,
   "NVPipeAvailableOff(self) -> None\nC++: void NVPipeAvailableOff()\n\n"},
  {"GetUsedLODForLastRender", PyvtkPVRenderView_GetUsedLODForLastRender, METH_VARARGS,
   "GetUsedLODForLastRender(self) -> bool\nC++: virtual bool GetUsedLODForLastRender()\n\nReturns true if the most recent render used LOD.\n"},
  {"InvalidateCachedSelection", PyvtkPVRenderView_InvalidateCachedSelection, METH_VARARGS,
   "InvalidateCachedSelection(self) -> None\nC++: void InvalidateCachedSelection()\n\nInvalidates cached selection. Called explicitly when view proxy\nthinks the cache may have become obsolete.\n\note CallOnAllProcesses\n"},
  {"GetPieceProducer", PyvtkPVRenderView_GetPieceProducer, METH_VARARGS,
   "GetPieceProducer(info:vtkInformation,\n    repr:vtkPVDataRepresentation, port:int=0)\n    -> vtkAlgorithmOutput\nC++: static vtkAlgorithmOutput *GetPieceProducer(\n    vtkInformation *info, vtkPVDataRepresentation *repr,\n    int port=0)\n\nConvenience methods used by representations to pass represented\ndata. If trueSize is non-zero, then that's the size used in\nmaking decisions about LOD/remote rendering etc and not the\nactual size of the dataset.\n"},
  {"GetPieceProducerLOD", PyvtkPVRenderView_GetPieceProducerLOD, METH_VARARGS,
   "GetPieceProducerLOD(info:vtkInformation,\n    repr:vtkPVDataRepresentation, port:int=0)\n    -> vtkAlgorithmOutput\nC++: static vtkAlgorithmOutput *GetPieceProducerLOD(\n    vtkInformation *info, vtkPVDataRepresentation *repr,\n    int port=0)\n\n"},
  {"SetRedistributionMode", PyvtkPVRenderView_SetRedistributionMode, METH_VARARGS,
   "SetRedistributionMode(info:vtkInformation,\n    repr:vtkPVDataRepresentation, mode:int, port:int=0) -> None\nC++: static void SetRedistributionMode(vtkInformation *info,\n    vtkPVDataRepresentation *repr, int mode, int port=0)\n\n"},
  {"SetRedistributionModeToSplitBoundaryCells", PyvtkPVRenderView_SetRedistributionModeToSplitBoundaryCells, METH_VARARGS,
   "SetRedistributionModeToSplitBoundaryCells(info:vtkInformation,\n    repr:vtkPVDataRepresentation, port:int=0) -> None\nC++: static void SetRedistributionModeToSplitBoundaryCells(\n    vtkInformation *info, vtkPVDataRepresentation *repr,\n    int port=0)\n\n"},
  {"SetRedistributionModeToDuplicateBoundaryCells", PyvtkPVRenderView_SetRedistributionModeToDuplicateBoundaryCells, METH_VARARGS,
   "SetRedistributionModeToDuplicateBoundaryCells(info:vtkInformation,\n     repr:vtkPVDataRepresentation, port:int=0) -> None\nC++: static void SetRedistributionModeToDuplicateBoundaryCells(\n    vtkInformation *info, vtkPVDataRepresentation *repr,\n    int port=0)\n\n"},
  {"SetRedistributionModeToUniquelyAssignBoundaryCells", PyvtkPVRenderView_SetRedistributionModeToUniquelyAssignBoundaryCells, METH_VARARGS,
   "SetRedistributionModeToUniquelyAssignBoundaryCells(\n    info:vtkInformation, repr:vtkPVDataRepresentation, port:int=0)\n     -> None\nC++: static void SetRedistributionModeToUniquelyAssignBoundaryCells(\n    vtkInformation *info, vtkPVDataRepresentation *repr,\n    int port=0)\n\n"},
  {"SetGeometryBounds", PyvtkPVRenderView_SetGeometryBounds, METH_VARARGS,
   "SetGeometryBounds(info:vtkInformation,\n    repr:vtkPVDataRepresentation, bounds:(float, float, float,\n    float, float, float), transform:vtkMatrix4x4=..., port:int=0)\n    -> None\nC++: static void SetGeometryBounds(vtkInformation *info,\n    vtkPVDataRepresentation *repr, const double bounds[6],\n    vtkMatrix4x4 *transform=nullptr, int port=0)\n\n"},
  {"SetStreamable", PyvtkPVRenderView_SetStreamable, METH_VARARGS,
   "SetStreamable(info:vtkInformation, repr:vtkPVDataRepresentation,\n    streamable:bool) -> None\nC++: static void SetStreamable(vtkInformation *info,\n    vtkPVDataRepresentation *repr, bool streamable)\n\n"},
  {"SetNextStreamedPiece", PyvtkPVRenderView_SetNextStreamedPiece, METH_VARARGS,
   "SetNextStreamedPiece(info:vtkInformation,\n    repr:vtkPVDataRepresentation, piece:vtkDataObject) -> None\nC++: static void SetNextStreamedPiece(vtkInformation *info,\n    vtkPVDataRepresentation *repr, vtkDataObject *piece)\n\n"},
  {"GetCurrentStreamedPiece", PyvtkPVRenderView_GetCurrentStreamedPiece, METH_VARARGS,
   "GetCurrentStreamedPiece(info:vtkInformation,\n    repr:vtkPVDataRepresentation) -> vtkDataObject\nC++: static vtkDataObject *GetCurrentStreamedPiece(\n    vtkInformation *info, vtkPVDataRepresentation *repr)\n\n"},
  {"SetOrderedCompositingConfiguration", PyvtkPVRenderView_SetOrderedCompositingConfiguration, METH_VARARGS,
   "SetOrderedCompositingConfiguration(info:vtkInformation,\n    repr:vtkPVDataRepresentation, config:int, bounds:(float, ...)\n    =..., port:int=0) -> None\nC++: static void SetOrderedCompositingConfiguration(\n    vtkInformation *info, vtkPVDataRepresentation *repr,\n    int config, const double *bounds=nullptr, int port=0)\n\n"},
  {"SetMaxClipBounds", PyvtkPVRenderView_SetMaxClipBounds, METH_VARARGS,
   "SetMaxClipBounds(self, bds:[float, float, float, float, float,\n    float]) -> None\nC++: void SetMaxClipBounds(double bds[6])\n\nUsed by Cinema to enforce a consistent depth scaling. Called with\nthe global (visible and invisible) bounds at start of export.\n"},
  {"SetLockBounds", PyvtkPVRenderView_SetLockBounds, METH_VARARGS,
   "SetLockBounds(self, nv:bool) -> None\nC++: void SetLockBounds(bool nv)\n\nUsed by Cinema to enforce a consistent viewpoint and depth\nscaling. Prevents ParaView from changing depth scaling over\ncourse of an export.\n"},
  {"GetLockBounds", PyvtkPVRenderView_GetLockBounds, METH_VARARGS,
   "GetLockBounds(self) -> bool\nC++: virtual bool GetLockBounds()\n\n"},
  {"SetDeliverToAllProcesses", PyvtkPVRenderView_SetDeliverToAllProcesses, METH_VARARGS,
   "SetDeliverToAllProcesses(info:vtkInformation,\n    repr:vtkPVDataRepresentation, clone:bool) -> None\nC++: static void SetDeliverToAllProcesses(vtkInformation *info,\n    vtkPVDataRepresentation *repr, bool clone)\n\nRequests the view to deliver the pieces produced by the repr to\nall processes after a gather to the root node to merge the\ndatasets generated by each process.\n"},
  {"SetDeliverToClientAndRenderingProcesses", PyvtkPVRenderView_SetDeliverToClientAndRenderingProcesses, METH_VARARGS,
   "SetDeliverToClientAndRenderingProcesses(info:vtkInformation,\n    repr:vtkPVDataRepresentation, deliver_to_client:bool,\n    gather_before_delivery:bool, port:int=0) -> None\nC++: static void SetDeliverToClientAndRenderingProcesses(\n    vtkInformation *info, vtkPVDataRepresentation *repr,\n    bool deliver_to_client, bool gather_before_delivery,\n    int port=0)\n\nRequests the view to deliver the data to the client always. This\nis essential for representation that render in the non-composited\nviews e.g. the text-source representation. If\nSetDeliverToAllProcesses() is true, this is redundant.\ngather_before_delivery can be used to indicate if the data on the\nserver-nodes must be gathered to the root node before shipping to\nthe client. If gather_before_delivery is false, only the data\nfrom the root node will be sent to the client without any\nparallel communication.\n"},
  {"SetRequiresDistributedRendering", PyvtkPVRenderView_SetRequiresDistributedRendering, METH_VARARGS,
   "SetRequiresDistributedRendering(info:vtkInformation,\n    repr:vtkPVDataRepresentation, value:bool, for_lod:bool=False)\n    -> None\nC++: static void SetRequiresDistributedRendering(\n    vtkInformation *info, vtkPVDataRepresentation *repr,\n    bool value, bool for_lod=false)\n\nSome representation only work when remote rendering or local\nrendering. Use this method in REQUEST_UPDATE() pass to tell the\nview if the representation requires a particular mode. Note, only\nuse this to \"require\" a remote or local render. value == true\nindicates that the representation requires distributed rendering,\nvalue == false indicates the representation can only render\nproperty on the client or root node.\n"},
  {"SetRequiresDistributedRenderingLOD", PyvtkPVRenderView_SetRequiresDistributedRenderingLOD, METH_VARARGS,
   "SetRequiresDistributedRenderingLOD(info:vtkInformation,\n    repr:vtkPVDataRepresentation, value:bool) -> None\nC++: static void SetRequiresDistributedRenderingLOD(\n    vtkInformation *info, vtkPVDataRepresentation *repr,\n    bool value)\n\n"},
  {"SetForceDataDistributionMode", PyvtkPVRenderView_SetForceDataDistributionMode, METH_VARARGS,
   "SetForceDataDistributionMode(info:vtkInformation, flag:int)\n    -> None\nC++: static void SetForceDataDistributionMode(\n    vtkInformation *info, int flag)\n\nThis is an temporary/experimental option and may be removed\nwithout notice. This is intended to be used within some\nexperimental representations that require that all data being\nmoved around uses a specific mode rather than the one\nautomatically determined based on the process type. Set flag to\n-1 to clear. The flag is cleared in every\nvtkPVRenderView::Update() call, hence a representation must set\nit in vtkPVView::REQUEST_UPDATE() pass if needed each time. Also\nnote, if the value it set to non-negative and is not equal to\nvtkMPIMoveData::PASS_THROUGH, ordered compositing will also be\ndisabled.\n"},
  {"IsForceDataDistributionModeSet", PyvtkPVRenderView_IsForceDataDistributionModeSet, METH_VARARGS,
   "IsForceDataDistributionModeSet(self) -> bool\nC++: bool IsForceDataDistributionModeSet()\n\n"},
  {"GetForceDataDistributionMode", PyvtkPVRenderView_GetForceDataDistributionMode, METH_VARARGS,
   "GetForceDataDistributionMode(self) -> int\nC++: int GetForceDataDistributionMode()\n\n"},
  {"RegisterPropForHardwareSelection", PyvtkPVRenderView_RegisterPropForHardwareSelection, METH_VARARGS,
   "RegisterPropForHardwareSelection(self,\n    repr:vtkPVDataRepresentation, prop:vtkProp) -> int\nC++: int RegisterPropForHardwareSelection(\n    vtkPVDataRepresentation *repr, vtkProp *prop)\n\nRepresentations that support hardware (render-buffer based)\nselection, should register the prop that they use for selection\nrendering. They can do that in the\nvtkPVDataRepresentation::AddToView() implementation.\n"},
  {"UnRegisterPropForHardwareSelection", PyvtkPVRenderView_UnRegisterPropForHardwareSelection, METH_VARARGS,
   "UnRegisterPropForHardwareSelection(self,\n    repr:vtkPVDataRepresentation, prop:vtkProp) -> None\nC++: void UnRegisterPropForHardwareSelection(\n    vtkPVDataRepresentation *repr, vtkProp *prop)\n\n"},
  {"SetShowAnnotation", PyvtkPVRenderView_SetShowAnnotation, METH_VARARGS,
   "SetShowAnnotation(self, val:bool) -> None\nC++: void SetShowAnnotation(bool val)\n\nEnable/disable showing of annotation for developers.\n"},
  {"SetUpdateAnnotation", PyvtkPVRenderView_SetUpdateAnnotation, METH_VARARGS,
   "SetUpdateAnnotation(self, _arg:bool) -> None\nC++: virtual void SetUpdateAnnotation(bool _arg)\n\n"},
  {"SetAnnotationColor", PyvtkPVRenderView_SetAnnotationColor, METH_VARARGS,
   "SetAnnotationColor(self, r:float, g:float, b:float) -> None\nC++: void SetAnnotationColor(double r, double g, double b)\n\nSet color of annotation text for developers\n"},
  {"SetGridAxes3DActor", PyvtkPVRenderView_SetGridAxes3DActor, METH_VARARGS,
   "SetGridAxes3DActor(self, __a:vtkPVGridAxes3DActor) -> None\nC++: virtual void SetGridAxes3DActor(vtkPVGridAxes3DActor *)\n\nSet the vtkPVGridAxes3DActor to use for the view.\n"},
  {"SetLegendGridActor", PyvtkPVRenderView_SetLegendGridActor, METH_VARARGS,
   "SetLegendGridActor(self, __a:vtkLegendScaleActor) -> None\nC++: virtual void SetLegendGridActor(vtkLegendScaleActor *)\n\nSet the vtkLegendScaleActor to use for the view.\n"},
  {"SetPolarGridActor", PyvtkPVRenderView_SetPolarGridActor, METH_VARARGS,
   "SetPolarGridActor(self, __a:vtkPolarAxesActor2D) -> None\nC++: virtual void SetPolarGridActor(vtkPolarAxesActor2D *)\n\nSet the vtkPolarAxesActor to use for the view.\n"},
  {"SetOrientationAxesInteractivity", PyvtkPVRenderView_SetOrientationAxesInteractivity, METH_VARARGS,
   "SetOrientationAxesInteractivity(self, __a:bool) -> None\nC++: virtual void SetOrientationAxesInteractivity(bool)\n\nForwarded to orientation axes widget.\n"},
  {"SetOrientationAxesVisibility", PyvtkPVRenderView_SetOrientationAxesVisibility, METH_VARARGS,
   "SetOrientationAxesVisibility(self, __a:bool) -> None\nC++: virtual void SetOrientationAxesVisibility(bool)\n\n"},
  {"SetOrientationAxesLabelColor", PyvtkPVRenderView_SetOrientationAxesLabelColor, METH_VARARGS,
   "SetOrientationAxesLabelColor(self, r:float, g:float, b:float)\n    -> None\nC++: void SetOrientationAxesLabelColor(double r, double g,\n    double b)\n\n"},
  {"SetOrientationAxesOutlineColor", PyvtkPVRenderView_SetOrientationAxesOutlineColor, METH_VARARGS,
   "SetOrientationAxesOutlineColor(self, r:float, g:float, b:float)\n    -> None\nC++: void SetOrientationAxesOutlineColor(double r, double g,\n    double b)\n\n"},
  {"SetOrientationAxesXColor", PyvtkPVRenderView_SetOrientationAxesXColor, METH_VARARGS,
   "SetOrientationAxesXColor(self, r:float, g:float, b:float) -> None\nC++: void SetOrientationAxesXColor(double r, double g, double b)\n\n"},
  {"SetOrientationAxesYColor", PyvtkPVRenderView_SetOrientationAxesYColor, METH_VARARGS,
   "SetOrientationAxesYColor(self, r:float, g:float, b:float) -> None\nC++: void SetOrientationAxesYColor(double r, double g, double b)\n\n"},
  {"SetOrientationAxesZColor", PyvtkPVRenderView_SetOrientationAxesZColor, METH_VARARGS,
   "SetOrientationAxesZColor(self, r:float, g:float, b:float) -> None\nC++: void SetOrientationAxesZColor(double r, double g, double b)\n\n"},
  {"SetOrientationAxesXVisibility", PyvtkPVRenderView_SetOrientationAxesXVisibility, METH_VARARGS,
   "SetOrientationAxesXVisibility(self, vis:bool) -> None\nC++: void SetOrientationAxesXVisibility(bool vis)\n\n"},
  {"SetOrientationAxesYVisibility", PyvtkPVRenderView_SetOrientationAxesYVisibility, METH_VARARGS,
   "SetOrientationAxesYVisibility(self, vis:bool) -> None\nC++: void SetOrientationAxesYVisibility(bool vis)\n\n"},
  {"SetOrientationAxesZVisibility", PyvtkPVRenderView_SetOrientationAxesZVisibility, METH_VARARGS,
   "SetOrientationAxesZVisibility(self, vis:bool) -> None\nC++: void SetOrientationAxesZVisibility(bool vis)\n\n"},
  {"SetOrientationAxesXLabelText", PyvtkPVRenderView_SetOrientationAxesXLabelText, METH_VARARGS,
   "SetOrientationAxesXLabelText(self, text:str) -> None\nC++: void SetOrientationAxesXLabelText(const char *text)\n\n"},
  {"SetOrientationAxesYLabelText", PyvtkPVRenderView_SetOrientationAxesYLabelText, METH_VARARGS,
   "SetOrientationAxesYLabelText(self, text:str) -> None\nC++: void SetOrientationAxesYLabelText(const char *text)\n\n"},
  {"SetOrientationAxesZLabelText", PyvtkPVRenderView_SetOrientationAxesZLabelText, METH_VARARGS,
   "SetOrientationAxesZLabelText(self, text:str) -> None\nC++: void SetOrientationAxesZLabelText(const char *text)\n\n"},
  {"SetCameraOrientationWidgetVisibility", PyvtkPVRenderView_SetCameraOrientationWidgetVisibility, METH_VARARGS,
   "SetCameraOrientationWidgetVisibility(self, visible:bool) -> None\nC++: void SetCameraOrientationWidgetVisibility(bool visible)\n\nForwarded to camera orientation widget.\n"},
  {"SetCameraOrientationWidgetSize", PyvtkPVRenderView_SetCameraOrientationWidgetSize, METH_VARARGS,
   "SetCameraOrientationWidgetSize(self, size:int) -> None\nC++: void SetCameraOrientationWidgetSize(int size)\n\n"},
  {"SetCameraOrientationWidgetPadding", PyvtkPVRenderView_SetCameraOrientationWidgetPadding, METH_VARARGS,
   "SetCameraOrientationWidgetPadding(self, padding:[int, int])\n    -> None\nC++: void SetCameraOrientationWidgetPadding(int padding[2])\n\n"},
  {"SetCameraOrientationWidgetAnchor", PyvtkPVRenderView_SetCameraOrientationWidgetAnchor, METH_VARARGS,
   "SetCameraOrientationWidgetAnchor(self, anchor:int) -> None\nC++: void SetCameraOrientationWidgetAnchor(int anchor)\n\n"},
  {"SetCenterAxesVisibility", PyvtkPVRenderView_SetCenterAxesVisibility, METH_VARARGS,
   "SetCenterAxesVisibility(self, __a:bool) -> None\nC++: virtual void SetCenterAxesVisibility(bool)\n\nForwarded to center axes.\n"},
  {"SetCenterOfRotation", PyvtkPVRenderView_SetCenterOfRotation, METH_VARARGS,
   "SetCenterOfRotation(self, x:float, y:float, z:float) -> None\nC++: virtual void SetCenterOfRotation(double x, double y,\n    double z)\n\nForward to vtkPVInteractorStyle instances.\n"},
  {"SetRotationFactor", PyvtkPVRenderView_SetRotationFactor, METH_VARARGS,
   "SetRotationFactor(self, factor:float) -> None\nC++: virtual void SetRotationFactor(double factor)\n\n"},
  {"SetKeyLightWarmth", PyvtkPVRenderView_SetKeyLightWarmth, METH_VARARGS,
   "SetKeyLightWarmth(self, val:float) -> None\nC++: void SetKeyLightWarmth(double val)\n\nForward to vtkLightKit.\n"},
  {"SetKeyLightIntensity", PyvtkPVRenderView_SetKeyLightIntensity, METH_VARARGS,
   "SetKeyLightIntensity(self, val:float) -> None\nC++: void SetKeyLightIntensity(double val)\n\n"},
  {"SetKeyLightElevation", PyvtkPVRenderView_SetKeyLightElevation, METH_VARARGS,
   "SetKeyLightElevation(self, val:float) -> None\nC++: void SetKeyLightElevation(double val)\n\n"},
  {"SetKeyLightAzimuth", PyvtkPVRenderView_SetKeyLightAzimuth, METH_VARARGS,
   "SetKeyLightAzimuth(self, val:float) -> None\nC++: void SetKeyLightAzimuth(double val)\n\n"},
  {"SetFillLightWarmth", PyvtkPVRenderView_SetFillLightWarmth, METH_VARARGS,
   "SetFillLightWarmth(self, val:float) -> None\nC++: void SetFillLightWarmth(double val)\n\n"},
  {"SetKeyToFillRatio", PyvtkPVRenderView_SetKeyToFillRatio, METH_VARARGS,
   "SetKeyToFillRatio(self, val:float) -> None\nC++: void SetKeyToFillRatio(double val)\n\n"},
  {"SetFillLightElevation", PyvtkPVRenderView_SetFillLightElevation, METH_VARARGS,
   "SetFillLightElevation(self, val:float) -> None\nC++: void SetFillLightElevation(double val)\n\n"},
  {"SetFillLightAzimuth", PyvtkPVRenderView_SetFillLightAzimuth, METH_VARARGS,
   "SetFillLightAzimuth(self, val:float) -> None\nC++: void SetFillLightAzimuth(double val)\n\n"},
  {"SetBackLightWarmth", PyvtkPVRenderView_SetBackLightWarmth, METH_VARARGS,
   "SetBackLightWarmth(self, val:float) -> None\nC++: void SetBackLightWarmth(double val)\n\n"},
  {"SetKeyToBackRatio", PyvtkPVRenderView_SetKeyToBackRatio, METH_VARARGS,
   "SetKeyToBackRatio(self, val:float) -> None\nC++: void SetKeyToBackRatio(double val)\n\n"},
  {"SetBackLightElevation", PyvtkPVRenderView_SetBackLightElevation, METH_VARARGS,
   "SetBackLightElevation(self, val:float) -> None\nC++: void SetBackLightElevation(double val)\n\n"},
  {"SetBackLightAzimuth", PyvtkPVRenderView_SetBackLightAzimuth, METH_VARARGS,
   "SetBackLightAzimuth(self, val:float) -> None\nC++: void SetBackLightAzimuth(double val)\n\n"},
  {"SetHeadLightWarmth", PyvtkPVRenderView_SetHeadLightWarmth, METH_VARARGS,
   "SetHeadLightWarmth(self, val:float) -> None\nC++: void SetHeadLightWarmth(double val)\n\n"},
  {"SetKeyToHeadRatio", PyvtkPVRenderView_SetKeyToHeadRatio, METH_VARARGS,
   "SetKeyToHeadRatio(self, val:float) -> None\nC++: void SetKeyToHeadRatio(double val)\n\n"},
  {"SetMaintainLuminance", PyvtkPVRenderView_SetMaintainLuminance, METH_VARARGS,
   "SetMaintainLuminance(self, val:int) -> None\nC++: void SetMaintainLuminance(int val)\n\n"},
  {"SetUseHiddenLineRemoval", PyvtkPVRenderView_SetUseHiddenLineRemoval, METH_VARARGS,
   "SetUseHiddenLineRemoval(self, _arg:bool) -> None\nC++: virtual void SetUseHiddenLineRemoval(bool _arg)\n\nForward to 3D renderer.\n"},
  {"SetUseDepthPeeling", PyvtkPVRenderView_SetUseDepthPeeling, METH_VARARGS,
   "SetUseDepthPeeling(self, val:int) -> None\nC++: virtual void SetUseDepthPeeling(int val)\n\n"},
  {"SetUseDepthPeelingForVolumes", PyvtkPVRenderView_SetUseDepthPeelingForVolumes, METH_VARARGS,
   "SetUseDepthPeelingForVolumes(self, val:bool) -> None\nC++: virtual void SetUseDepthPeelingForVolumes(bool val)\n\n"},
  {"SetMaximumNumberOfPeels", PyvtkPVRenderView_SetMaximumNumberOfPeels, METH_VARARGS,
   "SetMaximumNumberOfPeels(self, val:int) -> None\nC++: virtual void SetMaximumNumberOfPeels(int val)\n\n"},
  {"SetBackgroundTexture", PyvtkPVRenderView_SetBackgroundTexture, METH_VARARGS,
   "SetBackgroundTexture(self, val:vtkTexture) -> None\nC++: virtual void SetBackgroundTexture(vtkTexture *val)\n\n"},
  {"SetUseRenderViewSettingsForBackground", PyvtkPVRenderView_SetUseRenderViewSettingsForBackground, METH_VARARGS,
   "SetUseRenderViewSettingsForBackground(self, _arg:bool) -> None\nC++: virtual void SetUseRenderViewSettingsForBackground(bool _arg)\n\nWhen set, background color and mode will be obtained from\nvtkPVRenderViewSettings.\n"},
  {"GetUseRenderViewSettingsForBackground", PyvtkPVRenderView_GetUseRenderViewSettingsForBackground, METH_VARARGS,
   "GetUseRenderViewSettingsForBackground(self) -> bool\nC++: virtual bool GetUseRenderViewSettingsForBackground()\n\n"},
  {"SetBackgroundColorMode", PyvtkPVRenderView_SetBackgroundColorMode, METH_VARARGS,
   "SetBackgroundColorMode(self, _arg:int) -> None\nC++: virtual void SetBackgroundColorMode(int _arg)\n\nAPI for background color selection.\n\n@see BackgroundMode\n"},
  {"GetBackgroundColorModeMinValue", PyvtkPVRenderView_GetBackgroundColorModeMinValue, METH_VARARGS,
   "GetBackgroundColorModeMinValue(self) -> int\nC++: virtual int GetBackgroundColorModeMinValue()\n\n"},
  {"GetBackgroundColorModeMaxValue", PyvtkPVRenderView_GetBackgroundColorModeMaxValue, METH_VARARGS,
   "GetBackgroundColorModeMaxValue(self) -> int\nC++: virtual int GetBackgroundColorModeMaxValue()\n\n"},
  {"SetBackground", PyvtkPVRenderView_SetBackground, METH_VARARGS,
   "SetBackground(self, _arg1:float, _arg2:float, _arg3:float) -> None\nC++: virtual void SetBackground(double _arg1, double _arg2,\n    double _arg3)\nSetBackground(self, _arg:(float, float, float)) -> None\nC++: virtual void SetBackground(const double _arg[3])\n\n"},
  {"GetBackground", PyvtkPVRenderView_GetBackground, METH_VARARGS,
   "GetBackground(self) -> (float, float, float)\nC++: virtual double *GetBackground()\n\n"},
  {"SetBackground2", PyvtkPVRenderView_SetBackground2, METH_VARARGS,
   "SetBackground2(self, _arg1:float, _arg2:float, _arg3:float)\n    -> None\nC++: virtual void SetBackground2(double _arg1, double _arg2,\n    double _arg3)\nSetBackground2(self, _arg:(float, float, float)) -> None\nC++: virtual void SetBackground2(const double _arg[3])\n\n"},
  {"GetBackground2", PyvtkPVRenderView_GetBackground2, METH_VARARGS,
   "GetBackground2(self) -> (float, float, float)\nC++: virtual double *GetBackground2()\n\n"},
  {"SetUseEnvironmentLighting", PyvtkPVRenderView_SetUseEnvironmentLighting, METH_VARARGS,
   "SetUseEnvironmentLighting(self, _arg:bool) -> None\nC++: virtual void SetUseEnvironmentLighting(bool _arg)\n\n"},
  {"SetEnvironmentalBG", PyvtkPVRenderView_SetEnvironmentalBG, METH_VARARGS,
   "SetEnvironmentalBG(self, r:float, g:float, b:float) -> None\nC++: virtual void SetEnvironmentalBG(double r, double g, double b)\n\nEntry point for environmental backgrounds\n"},
  {"SetEnvironmentalBG2", PyvtkPVRenderView_SetEnvironmentalBG2, METH_VARARGS,
   "SetEnvironmentalBG2(self, r:float, g:float, b:float) -> None\nC++: virtual void SetEnvironmentalBG2(double r, double g,\n    double b)\n\n"},
  {"SetEnvironmentalBGTexture", PyvtkPVRenderView_SetEnvironmentalBGTexture, METH_VARARGS,
   "SetEnvironmentalBGTexture(self, val:vtkTexture) -> None\nC++: virtual void SetEnvironmentalBGTexture(vtkTexture *val)\n\n"},
  {"SetGradientEnvironmentalBG", PyvtkPVRenderView_SetGradientEnvironmentalBG, METH_VARARGS,
   "SetGradientEnvironmentalBG(self, val:int) -> None\nC++: virtual void SetGradientEnvironmentalBG(int val)\n\n"},
  {"SetTexturedEnvironmentalBG", PyvtkPVRenderView_SetTexturedEnvironmentalBG, METH_VARARGS,
   "SetTexturedEnvironmentalBG(self, val:int) -> None\nC++: virtual void SetTexturedEnvironmentalBG(int val)\n\n"},
  {"SetBackgroundMode", PyvtkPVRenderView_SetBackgroundMode, METH_VARARGS,
   "SetBackgroundMode(self, val:int) -> None\nC++: virtual void SetBackgroundMode(int val)\n\n"},
  {"AddLight", PyvtkPVRenderView_AddLight, METH_VARARGS,
   "AddLight(self, __a:vtkLight) -> None\nC++: void AddLight(vtkLight *)\n\nEntry point for dynamic lights\n"},
  {"RemoveLight", PyvtkPVRenderView_RemoveLight, METH_VARARGS,
   "RemoveLight(self, __a:vtkLight) -> None\nC++: void RemoveLight(vtkLight *)\n\n"},
  {"SetStereoCapableWindow", PyvtkPVRenderView_SetStereoCapableWindow, METH_VARARGS,
   "SetStereoCapableWindow(self, val:int) -> None\nC++: void SetStereoCapableWindow(int val)\n\nForward to vtkRenderWindow.\n"},
  {"SetStereoRender", PyvtkPVRenderView_SetStereoRender, METH_VARARGS,
   "SetStereoRender(self, val:int) -> None\nC++: void SetStereoRender(int val)\n\n"},
  {"SetStereoType", PyvtkPVRenderView_SetStereoType, METH_VARARGS,
   "SetStereoType(self, _arg:int) -> None\nC++: virtual void SetStereoType(int _arg)\n\n"},
  {"SetServerStereoType", PyvtkPVRenderView_SetServerStereoType, METH_VARARGS,
   "SetServerStereoType(self, _arg:int) -> None\nC++: virtual void SetServerStereoType(int _arg)\n\n"},
  {"SetMultiSamples", PyvtkPVRenderView_SetMultiSamples, METH_VARARGS,
   "SetMultiSamples(self, val:int) -> None\nC++: void SetMultiSamples(int val)\n\n"},
  {"SetAlphaBitPlanes", PyvtkPVRenderView_SetAlphaBitPlanes, METH_VARARGS,
   "SetAlphaBitPlanes(self, val:int) -> None\nC++: void SetAlphaBitPlanes(int val)\n\n"},
  {"SetStencilCapable", PyvtkPVRenderView_SetStencilCapable, METH_VARARGS,
   "SetStencilCapable(self, val:int) -> None\nC++: void SetStencilCapable(int val)\n\n"},
  {"SetPhysicalToWorldMatrix", PyvtkPVRenderView_SetPhysicalToWorldMatrix, METH_VARARGS,
   "SetPhysicalToWorldMatrix(self, __a:(float, float, float, float,\n    float, float, float, float, float, float, float, float, float,\n     float, float, float)) -> None\nC++: void SetPhysicalToWorldMatrix(const double[16])\n\n"},
  {"SetParallelProjection", PyvtkPVRenderView_SetParallelProjection, METH_VARARGS,
   "SetParallelProjection(self, mode:int) -> None\nC++: void SetParallelProjection(int mode)\n\nForward to vtkCamera.\n"},
  {"SetCamera2DManipulators", PyvtkPVRenderView_SetCamera2DManipulators, METH_VARARGS,
   "SetCamera2DManipulators(self, manipulators:(int, int, int, int,\n    int, int, int, int, int)) -> None\nC++: virtual void SetCamera2DManipulators(\n    const int manipulators[9])\n\nForwarded to vtkPVInteractorStyle if present on local processes.\n"},
  {"SetCamera3DManipulators", PyvtkPVRenderView_SetCamera3DManipulators, METH_VARARGS,
   "SetCamera3DManipulators(self, manipulators:(int, int, int, int,\n    int, int, int, int, int)) -> None\nC++: virtual void SetCamera3DManipulators(\n    const int manipulators[9])\n\n"},
  {"SetCameraManipulators", PyvtkPVRenderView_SetCameraManipulators, METH_VARARGS,
   "SetCameraManipulators(self, style:vtkPVInteractorStyle,\n    manipulators:(int, int, int, int, int, int, int, int, int))\n    -> None\nC++: void SetCameraManipulators(vtkPVInteractorStyle *style,\n    const int manipulators[9])\n\n"},
  {"SetReverseMouseWheelZoomDirection", PyvtkPVRenderView_SetReverseMouseWheelZoomDirection, METH_VARARGS,
   "SetReverseMouseWheelZoomDirection(self, reverse:bool) -> None\nC++: virtual void SetReverseMouseWheelZoomDirection(bool reverse)\n\n"},
  {"SetMouseWheelZoomsToCursor", PyvtkPVRenderView_SetMouseWheelZoomsToCursor, METH_VARARGS,
   "SetMouseWheelZoomsToCursor(self, value:bool) -> None\nC++: virtual void SetMouseWheelZoomsToCursor(bool value)\n\n"},
  {"SetCamera2DMouseWheelMotionFactor", PyvtkPVRenderView_SetCamera2DMouseWheelMotionFactor, METH_VARARGS,
   "SetCamera2DMouseWheelMotionFactor(self, factor:float) -> None\nC++: virtual void SetCamera2DMouseWheelMotionFactor(double factor)\n\n"},
  {"SetCamera3DMouseWheelMotionFactor", PyvtkPVRenderView_SetCamera3DMouseWheelMotionFactor, METH_VARARGS,
   "SetCamera3DMouseWheelMotionFactor(self, factor:float) -> None\nC++: virtual void SetCamera3DMouseWheelMotionFactor(double factor)\n\n"},
  {"SynchronizeGeometryBounds", PyvtkPVRenderView_SynchronizeGeometryBounds, METH_VARARGS,
   "SynchronizeGeometryBounds(self) -> None\nC++: virtual void SynchronizeGeometryBounds()\n\nSynchronizes bounds information on all nodes and reset camera\nclipping planes.\n\note CallOnAllProcesses\n"},
  {"Update", PyvtkPVRenderView_Update, METH_VARARGS,
   "Update(self) -> None\nC++: void Update() override;\n\nOverridden to synchronize information among processes whenever\ndata changes. The vtkSMViewProxy ensures that this method is\ncalled only when something has changed on the view-proxy or one\nof its representations or their inputs. Hence it's okay to do\nsome extra inter-process communication here.\n"},
  {"UpdateLOD", PyvtkPVRenderView_UpdateLOD, METH_VARARGS,
   "UpdateLOD(self) -> None\nC++: virtual void UpdateLOD()\n\nAsks representations to update their LOD geometries.\n"},
  {"GetUseLODForInteractiveRender", PyvtkPVRenderView_GetUseLODForInteractiveRender, METH_VARARGS,
   "GetUseLODForInteractiveRender(self) -> bool\nC++: virtual bool GetUseLODForInteractiveRender()\n\nReturns whether the view will use LOD rendering for the next\nInteractiveRender() call based on the geometry sizes determined\nby the most recent call to Update().\n"},
  {"GetUseDistributedRenderingForRender", PyvtkPVRenderView_GetUseDistributedRenderingForRender, METH_VARARGS,
   "GetUseDistributedRenderingForRender(self) -> bool\nC++: virtual bool GetUseDistributedRenderingForRender()\n\nReturns whether the view will use distributed rendering for the\nnext full-resolution render. This uses the full resolution\ngeometry sizes as determined by the most recent call to `Update`.\n"},
  {"GetUseDistributedRenderingForLODRender", PyvtkPVRenderView_GetUseDistributedRenderingForLODRender, METH_VARARGS,
   "GetUseDistributedRenderingForLODRender(self) -> bool\nC++: virtual bool GetUseDistributedRenderingForLODRender()\n\nReturns whether the view will use distributed rendering for the\nnext low-resolution render. This uses the low-resolution (or LOD)\ngeometry sizes as determined by the most recent call to\n`UpdateLOD`.\n"},
  {"GetStillRenderProcesses", PyvtkPVRenderView_GetStillRenderProcesses, METH_VARARGS,
   "GetStillRenderProcesses(self) -> int\nC++: virtual vtkTypeUInt32 GetStillRenderProcesses()\n\nReturns the processes (vtkPVSession::ServerFlags) that are to be\ninvolved in the next StillRender() call based on the decisions\nmade during the most recent Update().\n"},
  {"GetInteractiveRenderProcesses", PyvtkPVRenderView_GetInteractiveRenderProcesses, METH_VARARGS,
   "GetInteractiveRenderProcesses(self) -> int\nC++: virtual vtkTypeUInt32 GetInteractiveRenderProcesses()\n\nReturns the processes (vtkPVSession::ServerFlags) that are to be\ninvolved in the next InteractiveRender() call based on the\ndecisions made during the most recent Update() and UpdateLOD().\n"},
  {"GetDataDistributionMode", PyvtkPVRenderView_GetDataDistributionMode, METH_VARARGS,
   "GetDataDistributionMode(self, low_res:bool) -> int\nC++: int GetDataDistributionMode(bool low_res)\n\nReturns the data distribution mode to use.\n"},
  {"Deliver", PyvtkPVRenderView_Deliver, METH_VARARGS,
   "Deliver(self, use_lod:int, size:int, representation_ids:[int,\n    ...]) -> None\nC++: void Deliver(int use_lod, unsigned int size,\n    unsigned int *representation_ids) override;\n\nCalled on all processes to request data-delivery for the list of\nrepresentations. Note this method has to be called on all\nprocesses or it may lead to deadlock.\n"},
  {"GetUseOrderedCompositing", PyvtkPVRenderView_GetUseOrderedCompositing, METH_VARARGS,
   "GetUseOrderedCompositing(self) -> bool\nC++: bool GetUseOrderedCompositing()\n\nReturns true when ordered compositing is needed on the current\ngroup of processes. Note that unlike most other functions, this\nmay return different values on different processes e.g.\n\\li always false on client and dataserver\n\\li true on pvserver or renderserver if opacity < 1 or volume\n    present, else\nfalse\n"},
  {"GetRenderEmptyImages", PyvtkPVRenderView_GetRenderEmptyImages, METH_VARARGS,
   "GetRenderEmptyImages(self) -> bool\nC++: bool GetRenderEmptyImages()\n\nReturns true when the compositor should not use the empty images\noptimization.\n"},
  {"SetUseFXAA", PyvtkPVRenderView_SetUseFXAA, METH_VARARGS,
   "SetUseFXAA(self, _arg:bool) -> None\nC++: virtual void SetUseFXAA(bool _arg)\n\nEnable/disable FXAA antialiasing.\n"},
  {"GetUseFXAA", PyvtkPVRenderView_GetUseFXAA, METH_VARARGS,
   "GetUseFXAA(self) -> bool\nC++: virtual bool GetUseFXAA()\n\n"},
  {"SetFXAARelativeContrastThreshold", PyvtkPVRenderView_SetFXAARelativeContrastThreshold, METH_VARARGS,
   "SetFXAARelativeContrastThreshold(self, val:float) -> None\nC++: void SetFXAARelativeContrastThreshold(double val)\n\nFXAA tunable parameters. See vtkFXAAOptions for details.\n"},
  {"SetFXAAHardContrastThreshold", PyvtkPVRenderView_SetFXAAHardContrastThreshold, METH_VARARGS,
   "SetFXAAHardContrastThreshold(self, val:float) -> None\nC++: void SetFXAAHardContrastThreshold(double val)\n\n"},
  {"SetFXAASubpixelBlendLimit", PyvtkPVRenderView_SetFXAASubpixelBlendLimit, METH_VARARGS,
   "SetFXAASubpixelBlendLimit(self, val:float) -> None\nC++: void SetFXAASubpixelBlendLimit(double val)\n\n"},
  {"SetFXAASubpixelContrastThreshold", PyvtkPVRenderView_SetFXAASubpixelContrastThreshold, METH_VARARGS,
   "SetFXAASubpixelContrastThreshold(self, val:float) -> None\nC++: void SetFXAASubpixelContrastThreshold(double val)\n\n"},
  {"SetFXAAUseHighQualityEndpoints", PyvtkPVRenderView_SetFXAAUseHighQualityEndpoints, METH_VARARGS,
   "SetFXAAUseHighQualityEndpoints(self, val:bool) -> None\nC++: void SetFXAAUseHighQualityEndpoints(bool val)\n\n"},
  {"SetFXAAEndpointSearchIterations", PyvtkPVRenderView_SetFXAAEndpointSearchIterations, METH_VARARGS,
   "SetFXAAEndpointSearchIterations(self, val:int) -> None\nC++: void SetFXAAEndpointSearchIterations(int val)\n\n"},
  {"SetUseToneMapping", PyvtkPVRenderView_SetUseToneMapping, METH_VARARGS,
   "SetUseToneMapping(self, v:bool) -> None\nC++: void SetUseToneMapping(bool v)\n\nTone Mapping options.\n"},
  {"GetUseToneMapping", PyvtkPVRenderView_GetUseToneMapping, METH_VARARGS,
   "GetUseToneMapping(self) -> bool\nC++: virtual bool GetUseToneMapping()\n\n"},
  {"SetToneMappingType", PyvtkPVRenderView_SetToneMappingType, METH_VARARGS,
   "SetToneMappingType(self, __a:int) -> None\nC++: void SetToneMappingType(int)\n\n"},
  {"SetExposure", PyvtkPVRenderView_SetExposure, METH_VARARGS,
   "SetExposure(self, __a:float) -> None\nC++: void SetExposure(double)\n\n"},
  {"SetContrast", PyvtkPVRenderView_SetContrast, METH_VARARGS,
   "SetContrast(self, __a:float) -> None\nC++: void SetContrast(double)\n\n"},
  {"SetShoulder", PyvtkPVRenderView_SetShoulder, METH_VARARGS,
   "SetShoulder(self, __a:float) -> None\nC++: void SetShoulder(double)\n\n"},
  {"SetMidIn", PyvtkPVRenderView_SetMidIn, METH_VARARGS,
   "SetMidIn(self, __a:float) -> None\nC++: void SetMidIn(double)\n\n"},
  {"SetMidOut", PyvtkPVRenderView_SetMidOut, METH_VARARGS,
   "SetMidOut(self, __a:float) -> None\nC++: void SetMidOut(double)\n\n"},
  {"SetHdrMax", PyvtkPVRenderView_SetHdrMax, METH_VARARGS,
   "SetHdrMax(self, __a:float) -> None\nC++: void SetHdrMax(double)\n\n"},
  {"SetUseACES", PyvtkPVRenderView_SetUseACES, METH_VARARGS,
   "SetUseACES(self, __a:bool) -> None\nC++: void SetUseACES(bool)\n\n"},
  {"SetGenericFilmicPresets", PyvtkPVRenderView_SetGenericFilmicPresets, METH_VARARGS,
   "SetGenericFilmicPresets(self, t:int) -> None\nC++: void SetGenericFilmicPresets(int t)\n\n"},
  {"SetUseSSAO", PyvtkPVRenderView_SetUseSSAO, METH_VARARGS,
   "SetUseSSAO(self, _arg:bool) -> None\nC++: virtual void SetUseSSAO(bool _arg)\n\nSSAO options.\n"},
  {"GetUseSSAO", PyvtkPVRenderView_GetUseSSAO, METH_VARARGS,
   "GetUseSSAO(self) -> bool\nC++: virtual bool GetUseSSAO()\n\n"},
  {"SetUseSSAODefaultPresets", PyvtkPVRenderView_SetUseSSAODefaultPresets, METH_VARARGS,
   "SetUseSSAODefaultPresets(self, _arg:bool) -> None\nC++: virtual void SetUseSSAODefaultPresets(bool _arg)\n\n"},
  {"SetRadius", PyvtkPVRenderView_SetRadius, METH_VARARGS,
   "SetRadius(self, _arg:float) -> None\nC++: virtual void SetRadius(double _arg)\n\n"},
  {"SetKernelSize", PyvtkPVRenderView_SetKernelSize, METH_VARARGS,
   "SetKernelSize(self, _arg:int) -> None\nC++: virtual void SetKernelSize(int _arg)\n\n"},
  {"SetBias", PyvtkPVRenderView_SetBias, METH_VARARGS,
   "SetBias(self, _arg:float) -> None\nC++: virtual void SetBias(double _arg)\n\n"},
  {"SetBlur", PyvtkPVRenderView_SetBlur, METH_VARARGS,
   "SetBlur(self, _arg:bool) -> None\nC++: virtual void SetBlur(bool _arg)\n\n"},
  {"CopyViewUpdateOptions", PyvtkPVRenderView_CopyViewUpdateOptions, METH_VARARGS,
   "CopyViewUpdateOptions(self, otherView:vtkPVRenderView) -> None\nC++: void CopyViewUpdateOptions(vtkPVRenderView *otherView)\n\nCopy internal fields that are used for rendering decision such as\nremote/local rendering, composite and so on. This method was\nintroduced for the quad view so internal views could use the\ndecision that were made in the main view.\n"},
  {"AddPropToRenderer", PyvtkPVRenderView_AddPropToRenderer, METH_VARARGS,
   "AddPropToRenderer(self, prop:vtkProp) -> None\nC++: void AddPropToRenderer(vtkProp *prop)\n\nAdd props directly to the view.\n"},
  {"RemovePropFromRenderer", PyvtkPVRenderView_RemovePropFromRenderer, METH_VARARGS,
   "RemovePropFromRenderer(self, prop:vtkProp) -> None\nC++: void RemovePropFromRenderer(vtkProp *prop)\n\n"},
  {"BeginValuePassForRendering", PyvtkPVRenderView_BeginValuePassForRendering, METH_VARARGS,
   "BeginValuePassForRendering(self, fieldAssociation:int,\n    arrayName:str, component:int) -> bool\nC++: bool BeginValuePassForRendering(int fieldAssociation,\n    const char *arrayName, int component)\n\nExperimental API to grab re-colorable images. Between\nBeginValuePassForRendering and EndValuePassForRendering calls,\nall renders will end up using vtkValuePass for rendering instead\nof the standard rendering passes that generate results on screen.\n\nGrabValuePassResult must be called between\nBeginValuePassForRendering and EndValuePassForRendering. Returns\nthe vtkFloatArray grabbed by vtkValuePass.\n\nThis API is not intended for remote-rendering use-cases. Thus\nonly supported in client-only and pvbatch (or in situ) cases.\nThat's the reason why we are exposing this directly on the\nvtkPVRenderView rather accessing it via a proxy.\n"},
  {"EndValuePassForRendering", PyvtkPVRenderView_EndValuePassForRendering, METH_VARARGS,
   "EndValuePassForRendering(self) -> None\nC++: void EndValuePassForRendering()\n\n"},
  {"GrabValuePassResult", PyvtkPVRenderView_GrabValuePassResult, METH_VARARGS,
   "GrabValuePassResult(self) -> vtkFloatArray\nC++: vtkSmartPointer<vtkFloatArray> GrabValuePassResult()\n\n"},
  {"CaptureZBuffer", PyvtkPVRenderView_CaptureZBuffer, METH_VARARGS,
   "CaptureZBuffer(self) -> None\nC++: void CaptureZBuffer()\n\nAccess to the Z buffer.\n"},
  {"GetCapturedZBuffer", PyvtkPVRenderView_GetCapturedZBuffer, METH_VARARGS,
   "GetCapturedZBuffer(self) -> vtkFloatArray\nC++: vtkFloatArray *GetCapturedZBuffer()\n\n"},
  {"SetEnableSynchronizableActors", PyvtkPVRenderView_SetEnableSynchronizableActors, METH_VARARGS,
   "SetEnableSynchronizableActors(self, __a:bool) -> None\nC++: void SetEnableSynchronizableActors(bool)\n\nTurn on/off synchronizable actors.  This is needed for immersive\ncollaboration, (such as CAVEs) so that various types of vtkActor\ncan be synchronized to all displays.  It is off/disabled by\ndefault.\n"},
  {"GetEnableSynchronizableActors", PyvtkPVRenderView_GetEnableSynchronizableActors, METH_VARARGS,
   "GetEnableSynchronizableActors(self) -> bool\nC++: bool GetEnableSynchronizableActors()\n\n"},
  {"SetEnableOSPRay", PyvtkPVRenderView_SetEnableOSPRay, METH_VARARGS,
   "SetEnableOSPRay(self, __a:bool) -> None\nC++: void SetEnableOSPRay(bool)\n\nSwitches between rasterization and ray tracing.\n"},
  {"GetEnableOSPRay", PyvtkPVRenderView_GetEnableOSPRay, METH_VARARGS,
   "GetEnableOSPRay(self) -> bool\nC++: bool GetEnableOSPRay()\n\n"},
  {"SetShadows", PyvtkPVRenderView_SetShadows, METH_VARARGS,
   "SetShadows(self, __a:bool) -> None\nC++: void SetShadows(bool)\n\nControls whether OSPRay sends casts shadow rays or not.\n"},
  {"GetShadows", PyvtkPVRenderView_GetShadows, METH_VARARGS,
   "GetShadows(self) -> bool\nC++: bool GetShadows()\n\n"},
  {"SetAmbientOcclusionSamples", PyvtkPVRenderView_SetAmbientOcclusionSamples, METH_VARARGS,
   "SetAmbientOcclusionSamples(self, __a:int) -> None\nC++: void SetAmbientOcclusionSamples(int)\n\nSets the number of occlusion query rays that OSPRay sends at each\nintersection.\n"},
  {"GetAmbientOcclusionSamples", PyvtkPVRenderView_GetAmbientOcclusionSamples, METH_VARARGS,
   "GetAmbientOcclusionSamples(self) -> int\nC++: int GetAmbientOcclusionSamples()\n\n"},
  {"SetRouletteDepth", PyvtkPVRenderView_SetRouletteDepth, METH_VARARGS,
   "SetRouletteDepth(self, __a:int) -> None\nC++: void SetRouletteDepth(int)\n\nSets the depth of monte carlo samples on the path tracer\n"},
  {"GetRouletteDepth", PyvtkPVRenderView_GetRouletteDepth, METH_VARARGS,
   "GetRouletteDepth(self) -> int\nC++: int GetRouletteDepth()\n\n"},
  {"SetSamplesPerPixel", PyvtkPVRenderView_SetSamplesPerPixel, METH_VARARGS,
   "SetSamplesPerPixel(self, __a:int) -> None\nC++: void SetSamplesPerPixel(int)\n\nSet the number of primary rays that OSPRay shoots per pixel.\n"},
  {"GetSamplesPerPixel", PyvtkPVRenderView_GetSamplesPerPixel, METH_VARARGS,
   "GetSamplesPerPixel(self) -> int\nC++: int GetSamplesPerPixel()\n\n"},
  {"SetMaxFrames", PyvtkPVRenderView_SetMaxFrames, METH_VARARGS,
   "SetMaxFrames(self, __a:int) -> None\nC++: void SetMaxFrames(int)\n\nSet the number of render passes OSPRay takes to accumulate\nsubsampled color results.\n"},
  {"GetMaxFrames", PyvtkPVRenderView_GetMaxFrames, METH_VARARGS,
   "GetMaxFrames(self) -> int\nC++: int GetMaxFrames()\n\n"},
  {"GetOSPRayContinueStreaming", PyvtkPVRenderView_GetOSPRayContinueStreaming, METH_VARARGS,
   "GetOSPRayContinueStreaming(self) -> bool\nC++: bool GetOSPRayContinueStreaming()\n\nHas OSPRay reached the max frames?\n"},
  {"SetDenoise", PyvtkPVRenderView_SetDenoise, METH_VARARGS,
   "SetDenoise(self, __a:bool) -> None\nC++: void SetDenoise(bool)\n\nControls whether to use image denoising to improve appearance.\n"},
  {"GetDenoise", PyvtkPVRenderView_GetDenoise, METH_VARARGS,
   "GetDenoise(self) -> bool\nC++: bool GetDenoise()\n\n"},
  {"SetLightScale", PyvtkPVRenderView_SetLightScale, METH_VARARGS,
   "SetLightScale(self, __a:float) -> None\nC++: void SetLightScale(double)\n\nDimish or Amplify all lights in the scene.\n"},
  {"GetLightScale", PyvtkPVRenderView_GetLightScale, METH_VARARGS,
   "GetLightScale(self) -> float\nC++: double GetLightScale()\n\n"},
  {"SetOSPRayRendererType", PyvtkPVRenderView_SetOSPRayRendererType, METH_VARARGS,
   "SetOSPRayRendererType(self, __a:str) -> None\nC++: void SetOSPRayRendererType(std::string)\n\nSet the OSPRay renderer to use. May be either scivis (default) or\npathtracer.\n"},
  {"SetBackgroundNorth", PyvtkPVRenderView_SetBackgroundNorth, METH_VARARGS,
   "SetBackgroundNorth(self, x:float, y:float, z:float) -> None\nC++: void SetBackgroundNorth(double x, double y, double z)\n\nControl of background orientation for OSPRay.\n"},
  {"SetBackgroundEast", PyvtkPVRenderView_SetBackgroundEast, METH_VARARGS,
   "SetBackgroundEast(self, x:float, y:float, z:float) -> None\nC++: void SetBackgroundEast(double x, double y, double z)\n\n"},
  {"SetMaterialLibrary", PyvtkPVRenderView_SetMaterialLibrary, METH_VARARGS,
   "SetMaterialLibrary(self, __a:vtkPVMaterialLibrary) -> None\nC++: virtual void SetMaterialLibrary(vtkPVMaterialLibrary *)\n\nFor OSPRay, set the library of materials.\n"},
  {"SetViewTime", PyvtkPVRenderView_SetViewTime, METH_VARARGS,
   "SetViewTime(self, value:float) -> None\nC++: void SetViewTime(double value) override;\n\nGet/Set the time this view is showing.\n\note CallOnAllProcesses\n"},
  {"SetTimeCacheSize", PyvtkPVRenderView_SetTimeCacheSize, METH_VARARGS,
   "SetTimeCacheSize(self, __a:int) -> None\nC++: void SetTimeCacheSize(int)\n\nSet the size of OSPRay's temporal cache.\n"},
  {"GetTimeCacheSize", PyvtkPVRenderView_GetTimeCacheSize, METH_VARARGS,
   "GetTimeCacheSize(self) -> int\nC++: int GetTimeCacheSize()\n\n"},
  {"GetDiscreteCameras", PyvtkPVRenderView_GetDiscreteCameras, METH_VARARGS,
   "GetDiscreteCameras(info:vtkInformation,\n    repr:vtkPVDataRepresentation) -> vtkPVCameraCollection\nC++: static vtkPVCameraCollection *GetDiscreteCameras(\n    vtkInformation *info, vtkPVDataRepresentation *repr)\n\nDiscreteCameras are a collection of cameras when specified,\nforces the view to only interact *to* a camera in the collection.\n\nIn `vtkPVView::REQUEST_UPDATE()` pass, representations may\nrequest the view to use discrete cameras by providing a\nvtkPVCameraCollection to the view. Since multiple representations\nmay be visible in the view, it's up to the representations how to\nhandle multiple representations providing different styles.\n\nWhen set, on each render, vtkPVRenderView will try to update the\ncurrent camera to match a camera in the collection. During\ninteracting, however, the snapping to a camera in the collection\nis only done when the snapped to camera is different from the\nprevious. This avoids side effects on camera manipulators that\nsimply update existing camera positions during interaction.\n\note Since this is supposed to set in vtkPVView::REQUEST_UPDATE(),\nit is unset before the pass is triggered.\n\n@warning This is a new/experimental feature that was added to\n    support\nviewing of Cinema databases in ParaView. As the support for\nCinema in ParaView improve, this is likely to change.\n"},
  {"SetDiscreteCameras", PyvtkPVRenderView_SetDiscreteCameras, METH_VARARGS,
   "SetDiscreteCameras(info:vtkInformation,\n    repr:vtkPVDataRepresentation, style:vtkPVCameraCollection)\n    -> None\nC++: static void SetDiscreteCameras(vtkInformation *info,\n    vtkPVDataRepresentation *repr, vtkPVCameraCollection *style)\n\n"},
  {"GetRenderView", PyvtkPVRenderView_GetRenderView, METH_VARARGS,
   "GetRenderView(self) -> vtkRenderViewBase\nC++: virtual vtkRenderViewBase *GetRenderView()\n\n"},
  {"ScaleRendererViewports", PyvtkPVRenderView_ScaleRendererViewports, METH_VARARGS,
   "ScaleRendererViewports(self, viewport:(float, float, float, float)\n    ) -> None\nC++: void ScaleRendererViewports(const double viewport[4])\n    override;\n\nOverridden to scale the OrientationWidget appropriately.\n"},
  {"SynchronizeMaximumIds", PyvtkPVRenderView_SynchronizeMaximumIds, METH_VARARGS,
   "SynchronizeMaximumIds(self, maxPointId:[int, ...], maxCellId:[int,\n     ...]) -> None\nC++: void SynchronizeMaximumIds(vtkIdType *maxPointId,\n    vtkIdType *maxCellId)\n\nThis is used by vtkPVHardwareSelector to synchronize element ids\nbetween all ranks involved in selection.\n"},
  {"SetHardwareSelector", PyvtkPVRenderView_SetHardwareSelector, METH_VARARGS,
   "SetHardwareSelector(self, selector:vtkPVHardwareSelector) -> None\nC++: void SetHardwareSelector(vtkPVHardwareSelector *selector)\n\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVRenderView_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("interaction_mode"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRenderView_GetInteractionMode(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetInteractionMode(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetInteractionMode(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetInteractionMode/SetInteractionMode\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("size"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetSize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetSize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("position"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetPosition(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetPosition(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPosition\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("active_camera"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRenderView_GetActiveCamera(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetActiveCamera(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetActiveCamera(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetActiveCamera/SetActiveCamera\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("suppress_rendering"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRenderView_GetSuppressRendering(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetSuppressRendering(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetSuppressRendering(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSuppressRendering/SetSuppressRendering\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("still_render_image_reduction_factor"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRenderView_GetStillRenderImageReductionFactor(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetStillRenderImageReductionFactor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetStillRenderImageReductionFactor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetStillRenderImageReductionFactor/SetStillRenderImageReductionFactor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("interactive_render_image_reduction_factor"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRenderView_GetInteractiveRenderImageReductionFactor(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetInteractiveRenderImageReductionFactor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetInteractiveRenderImageReductionFactor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetInteractiveRenderImageReductionFactor/SetInteractiveRenderImageReductionFactor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("remote_rendering_threshold"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRenderView_GetRemoteRenderingThreshold(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetRemoteRenderingThreshold(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetRemoteRenderingThreshold(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetRemoteRenderingThreshold/SetRemoteRenderingThreshold\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("lod_rendering_threshold"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRenderView_GetLODRenderingThreshold(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetLODRenderingThreshold(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetLODRenderingThreshold(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetLODRenderingThreshold/SetLODRenderingThreshold\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("lod_resolution"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRenderView_GetLODResolution(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetLODResolution(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetLODResolution(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetLODResolution/SetLODResolution\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_outline_for_lod_rendering"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRenderView_GetUseOutlineForLODRendering(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetUseOutlineForLODRendering(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetUseOutlineForLODRendering(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseOutlineForLODRendering/SetUseOutlineForLODRendering\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_light_kit"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRenderView_GetUseLightKit(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetUseLightKit(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetUseLightKit(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseLightKit/SetUseLightKit\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_interactive_rendering_for_screenshots"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRenderView_GetUseInteractiveRenderingForScreenshots(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetUseInteractiveRenderingForScreenshots(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetUseInteractiveRenderingForScreenshots(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseInteractiveRenderingForScreenshots/SetUseInteractiveRenderingForScreenshots\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("max_clip_bounds"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetMaxClipBounds(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetMaxClipBounds(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetMaxClipBounds\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("lock_bounds"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRenderView_GetLockBounds(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetLockBounds(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetLockBounds(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetLockBounds/SetLockBounds\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("show_annotation"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetShowAnnotation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetShowAnnotation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetShowAnnotation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("update_annotation"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetUpdateAnnotation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetUpdateAnnotation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetUpdateAnnotation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("annotation_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetAnnotationColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetAnnotationColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetAnnotationColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("grid_axes3d_actor"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetGridAxes3DActor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetGridAxes3DActor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetGridAxes3DActor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("legend_grid_actor"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetLegendGridActor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetLegendGridActor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetLegendGridActor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("polar_grid_actor"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetPolarGridActor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetPolarGridActor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPolarGridActor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("orientation_axes_interactivity"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetOrientationAxesInteractivity(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetOrientationAxesInteractivity(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetOrientationAxesInteractivity\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("orientation_axes_visibility"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetOrientationAxesVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetOrientationAxesVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetOrientationAxesVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("orientation_axes_label_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetOrientationAxesLabelColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetOrientationAxesLabelColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetOrientationAxesLabelColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("orientation_axes_outline_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetOrientationAxesOutlineColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetOrientationAxesOutlineColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetOrientationAxesOutlineColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("orientation_axes_x_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetOrientationAxesXColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetOrientationAxesXColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetOrientationAxesXColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("orientation_axes_y_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetOrientationAxesYColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetOrientationAxesYColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetOrientationAxesYColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("orientation_axes_z_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetOrientationAxesZColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetOrientationAxesZColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetOrientationAxesZColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("orientation_axes_x_visibility"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetOrientationAxesXVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetOrientationAxesXVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetOrientationAxesXVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("orientation_axes_y_visibility"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetOrientationAxesYVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetOrientationAxesYVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetOrientationAxesYVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("orientation_axes_z_visibility"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetOrientationAxesZVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetOrientationAxesZVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetOrientationAxesZVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("orientation_axes_x_label_text"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetOrientationAxesXLabelText(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetOrientationAxesXLabelText(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetOrientationAxesXLabelText\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("orientation_axes_y_label_text"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetOrientationAxesYLabelText(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetOrientationAxesYLabelText(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetOrientationAxesYLabelText\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("orientation_axes_z_label_text"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetOrientationAxesZLabelText(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetOrientationAxesZLabelText(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetOrientationAxesZLabelText\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("camera_orientation_widget_visibility"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetCameraOrientationWidgetVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetCameraOrientationWidgetVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetCameraOrientationWidgetVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("camera_orientation_widget_size"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetCameraOrientationWidgetSize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetCameraOrientationWidgetSize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetCameraOrientationWidgetSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("camera_orientation_widget_padding"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetCameraOrientationWidgetPadding(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetCameraOrientationWidgetPadding(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetCameraOrientationWidgetPadding\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("camera_orientation_widget_anchor"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetCameraOrientationWidgetAnchor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetCameraOrientationWidgetAnchor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetCameraOrientationWidgetAnchor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("center_axes_visibility"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetCenterAxesVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetCenterAxesVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetCenterAxesVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("center_of_rotation"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetCenterOfRotation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetCenterOfRotation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetCenterOfRotation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("rotation_factor"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetRotationFactor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetRotationFactor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetRotationFactor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("key_light_warmth"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetKeyLightWarmth(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetKeyLightWarmth(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetKeyLightWarmth\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("key_light_intensity"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetKeyLightIntensity(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetKeyLightIntensity(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetKeyLightIntensity\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("key_light_elevation"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetKeyLightElevation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetKeyLightElevation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetKeyLightElevation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("key_light_azimuth"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetKeyLightAzimuth(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetKeyLightAzimuth(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetKeyLightAzimuth\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("fill_light_warmth"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetFillLightWarmth(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetFillLightWarmth(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetFillLightWarmth\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("key_to_fill_ratio"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetKeyToFillRatio(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetKeyToFillRatio(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetKeyToFillRatio\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("fill_light_elevation"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetFillLightElevation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetFillLightElevation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetFillLightElevation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("fill_light_azimuth"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetFillLightAzimuth(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetFillLightAzimuth(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetFillLightAzimuth\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("back_light_warmth"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetBackLightWarmth(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetBackLightWarmth(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetBackLightWarmth\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("key_to_back_ratio"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetKeyToBackRatio(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetKeyToBackRatio(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetKeyToBackRatio\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("back_light_elevation"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetBackLightElevation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetBackLightElevation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetBackLightElevation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("back_light_azimuth"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetBackLightAzimuth(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetBackLightAzimuth(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetBackLightAzimuth\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("head_light_warmth"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetHeadLightWarmth(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetHeadLightWarmth(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetHeadLightWarmth\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("key_to_head_ratio"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetKeyToHeadRatio(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetKeyToHeadRatio(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetKeyToHeadRatio\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("maintain_luminance"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetMaintainLuminance(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetMaintainLuminance(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetMaintainLuminance\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_hidden_line_removal"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetUseHiddenLineRemoval(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetUseHiddenLineRemoval(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetUseHiddenLineRemoval\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_depth_peeling"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetUseDepthPeeling(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetUseDepthPeeling(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetUseDepthPeeling\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_depth_peeling_for_volumes"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetUseDepthPeelingForVolumes(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetUseDepthPeelingForVolumes(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetUseDepthPeelingForVolumes\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("maximum_number_of_peels"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetMaximumNumberOfPeels(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetMaximumNumberOfPeels(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetMaximumNumberOfPeels\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("background_texture"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetBackgroundTexture(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetBackgroundTexture(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetBackgroundTexture\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_render_view_settings_for_background"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRenderView_GetUseRenderViewSettingsForBackground(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetUseRenderViewSettingsForBackground(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetUseRenderViewSettingsForBackground(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseRenderViewSettingsForBackground/SetUseRenderViewSettingsForBackground\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("background_color_mode"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetBackgroundColorMode(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetBackgroundColorMode(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetBackgroundColorMode\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("background"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRenderView_GetBackground(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetBackground(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetBackground(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetBackground/SetBackground\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("background2"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRenderView_GetBackground2(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetBackground2(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetBackground2(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetBackground2/SetBackground2\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_environment_lighting"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetUseEnvironmentLighting(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetUseEnvironmentLighting(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetUseEnvironmentLighting\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("environmental_bg"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetEnvironmentalBG(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetEnvironmentalBG(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetEnvironmentalBG\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("environmental_bg2"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetEnvironmentalBG2(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetEnvironmentalBG2(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetEnvironmentalBG2\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("environmental_bg_texture"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetEnvironmentalBGTexture(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetEnvironmentalBGTexture(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetEnvironmentalBGTexture\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("gradient_environmental_bg"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetGradientEnvironmentalBG(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetGradientEnvironmentalBG(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetGradientEnvironmentalBG\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("textured_environmental_bg"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetTexturedEnvironmentalBG(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetTexturedEnvironmentalBG(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetTexturedEnvironmentalBG\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("background_mode"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetBackgroundMode(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetBackgroundMode(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetBackgroundMode\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("stereo_capable_window"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetStereoCapableWindow(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetStereoCapableWindow(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetStereoCapableWindow\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("stereo_render"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetStereoRender(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetStereoRender(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetStereoRender\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("stereo_type"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetStereoType(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetStereoType(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetStereoType\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("server_stereo_type"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetServerStereoType(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetServerStereoType(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetServerStereoType\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("multi_samples"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetMultiSamples(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetMultiSamples(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetMultiSamples\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("alpha_bit_planes"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetAlphaBitPlanes(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetAlphaBitPlanes(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetAlphaBitPlanes\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("stencil_capable"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetStencilCapable(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetStencilCapable(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetStencilCapable\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("physical_to_world_matrix"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetPhysicalToWorldMatrix(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetPhysicalToWorldMatrix(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPhysicalToWorldMatrix\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("parallel_projection"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetParallelProjection(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetParallelProjection(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetParallelProjection\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("camera2d_manipulators"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetCamera2DManipulators(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetCamera2DManipulators(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetCamera2DManipulators\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("camera3d_manipulators"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetCamera3DManipulators(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetCamera3DManipulators(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetCamera3DManipulators\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("reverse_mouse_wheel_zoom_direction"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetReverseMouseWheelZoomDirection(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetReverseMouseWheelZoomDirection(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetReverseMouseWheelZoomDirection\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("mouse_wheel_zooms_to_cursor"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetMouseWheelZoomsToCursor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetMouseWheelZoomsToCursor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetMouseWheelZoomsToCursor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("camera2d_mouse_wheel_motion_factor"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetCamera2DMouseWheelMotionFactor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetCamera2DMouseWheelMotionFactor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetCamera2DMouseWheelMotionFactor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("camera3d_mouse_wheel_motion_factor"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetCamera3DMouseWheelMotionFactor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetCamera3DMouseWheelMotionFactor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetCamera3DMouseWheelMotionFactor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_fxaa"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRenderView_GetUseFXAA(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetUseFXAA(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetUseFXAA(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseFXAA/SetUseFXAA\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("fxaa_relative_contrast_threshold"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetFXAARelativeContrastThreshold(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetFXAARelativeContrastThreshold(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetFXAARelativeContrastThreshold\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("fxaa_hard_contrast_threshold"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetFXAAHardContrastThreshold(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetFXAAHardContrastThreshold(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetFXAAHardContrastThreshold\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("fxaa_subpixel_blend_limit"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetFXAASubpixelBlendLimit(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetFXAASubpixelBlendLimit(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetFXAASubpixelBlendLimit\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("fxaa_subpixel_contrast_threshold"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetFXAASubpixelContrastThreshold(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetFXAASubpixelContrastThreshold(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetFXAASubpixelContrastThreshold\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("fxaa_use_high_quality_endpoints"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetFXAAUseHighQualityEndpoints(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetFXAAUseHighQualityEndpoints(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetFXAAUseHighQualityEndpoints\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("fxaa_endpoint_search_iterations"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetFXAAEndpointSearchIterations(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetFXAAEndpointSearchIterations(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetFXAAEndpointSearchIterations\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_tone_mapping"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRenderView_GetUseToneMapping(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetUseToneMapping(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetUseToneMapping(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseToneMapping/SetUseToneMapping\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("tone_mapping_type"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetToneMappingType(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetToneMappingType(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetToneMappingType\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("exposure"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetExposure(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetExposure(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetExposure\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("contrast"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetContrast(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetContrast(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetContrast\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("shoulder"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetShoulder(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetShoulder(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetShoulder\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("mid_in"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetMidIn(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetMidIn(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetMidIn\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("mid_out"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetMidOut(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetMidOut(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetMidOut\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("hdr_max"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetHdrMax(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetHdrMax(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetHdrMax\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_aces"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetUseACES(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetUseACES(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetUseACES\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("generic_filmic_presets"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetGenericFilmicPresets(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetGenericFilmicPresets(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetGenericFilmicPresets\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_ssao"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRenderView_GetUseSSAO(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetUseSSAO(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetUseSSAO(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseSSAO/SetUseSSAO\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_ssao_default_presets"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetUseSSAODefaultPresets(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetUseSSAODefaultPresets(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetUseSSAODefaultPresets\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("radius"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetRadius(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetRadius(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetRadius\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("kernel_size"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetKernelSize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetKernelSize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetKernelSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("bias"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetBias(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetBias(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetBias\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("blur"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetBlur(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetBlur(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetBlur\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("enable_synchronizable_actors"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRenderView_GetEnableSynchronizableActors(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetEnableSynchronizableActors(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetEnableSynchronizableActors(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetEnableSynchronizableActors/SetEnableSynchronizableActors\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("enable_osp_ray"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRenderView_GetEnableOSPRay(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetEnableOSPRay(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetEnableOSPRay(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetEnableOSPRay/SetEnableOSPRay\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("shadows"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRenderView_GetShadows(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetShadows(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetShadows(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetShadows/SetShadows\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("ambient_occlusion_samples"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRenderView_GetAmbientOcclusionSamples(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetAmbientOcclusionSamples(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetAmbientOcclusionSamples(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetAmbientOcclusionSamples/SetAmbientOcclusionSamples\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("roulette_depth"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRenderView_GetRouletteDepth(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetRouletteDepth(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetRouletteDepth(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetRouletteDepth/SetRouletteDepth\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("samples_per_pixel"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRenderView_GetSamplesPerPixel(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetSamplesPerPixel(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetSamplesPerPixel(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSamplesPerPixel/SetSamplesPerPixel\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("max_frames"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRenderView_GetMaxFrames(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetMaxFrames(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetMaxFrames(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetMaxFrames/SetMaxFrames\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("denoise"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRenderView_GetDenoise(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetDenoise(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetDenoise(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDenoise/SetDenoise\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("light_scale"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRenderView_GetLightScale(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetLightScale(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetLightScale(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetLightScale/SetLightScale\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("osp_ray_renderer_type"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetOSPRayRendererType(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetOSPRayRendererType(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetOSPRayRendererType\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("background_north"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetBackgroundNorth(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetBackgroundNorth(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetBackgroundNorth\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("background_east"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetBackgroundEast(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetBackgroundEast(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetBackgroundEast\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("material_library"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetMaterialLibrary(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetMaterialLibrary(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetMaterialLibrary\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("view_time"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetViewTime(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetViewTime(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetViewTime\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("time_cache_size"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRenderView_GetTimeCacheSize(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetTimeCacheSize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetTimeCacheSize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTimeCacheSize/SetTimeCacheSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("hardware_selector"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVRenderView_SetHardwareSelector(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVRenderView_SetHardwareSelector(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetHardwareSelector\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("last_selection"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRenderView_GetLastSelection(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetLastSelection\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("non_composited_renderer"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRenderView_GetNonCompositedRenderer(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNonCompositedRenderer\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("interactor"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRenderView_GetInteractor(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetInteractor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("interactor_style"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRenderView_GetInteractorStyle(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetInteractorStyle\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("remote_rendering_available"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRenderView_GetRemoteRenderingAvailable(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetRemoteRenderingAvailable\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("used_lod_for_last_render"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRenderView_GetUsedLODForLastRender(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetUsedLODForLastRender\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("force_data_distribution_mode"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRenderView_GetForceDataDistributionMode(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetForceDataDistributionMode\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_lod_for_interactive_render"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRenderView_GetUseLODForInteractiveRender(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetUseLODForInteractiveRender\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_distributed_rendering_for_render"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRenderView_GetUseDistributedRenderingForRender(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetUseDistributedRenderingForRender\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_distributed_rendering_for_lod_render"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRenderView_GetUseDistributedRenderingForLODRender(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetUseDistributedRenderingForLODRender\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("still_render_processes"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRenderView_GetStillRenderProcesses(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetStillRenderProcesses\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("interactive_render_processes"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRenderView_GetInteractiveRenderProcesses(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetInteractiveRenderProcesses\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_ordered_compositing"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRenderView_GetUseOrderedCompositing(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetUseOrderedCompositing\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("render_empty_images"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRenderView_GetRenderEmptyImages(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetRenderEmptyImages\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("captured_z_buffer"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRenderView_GetCapturedZBuffer(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetCapturedZBuffer\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("osp_ray_continue_streaming"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRenderView_GetOSPRayContinueStreaming(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetOSPRayContinueStreaming\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("render_view"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRenderView_GetRenderView(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetRenderView\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPVRenderView_Doc =
  "vtkPVRenderView - Render View for ParaView.\n\n"
  "Superclass: vtkPVView\n\n"
  "vtkRenderView equivalent that is specialized for ParaView.\n"
  "vtkRenderView handles polygonal rendering for ParaView in all the\n"
  "different modes of operation. vtkPVRenderView instance must be\n"
  "created on all involved processes. vtkPVRenderView uses the\n"
  "information about what process it has been created on to decide what\n"
  "part of the \"rendering\" happens on the process.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVRenderView_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkPVRenderView", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPVRenderView_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPVRenderView_StaticNew()
{
  return vtkPVRenderView::New();
}

PyObject *PyvtkPVRenderView_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPVRenderView_Type, PyvtkPVRenderView_Methods,
    "vtkPVRenderView",
 &PyvtkPVRenderView_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkPVView_ClassNew();

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  PyType_Ready(&PyvtkPVRenderView_InteractionModes_Type);
  PyVTKEnum_Add(&PyvtkPVRenderView_InteractionModes_Type, "vtkPVRenderView.InteractionModes");

  o = (PyObject *)&PyvtkPVRenderView_InteractionModes_Type;
  if (PyDict_SetItemString(d, "InteractionModes", o) != 0)
  {
    Py_DECREF(o);
  }

  PyType_Ready(&PyvtkPVRenderView_BackgroundMode_Type);
  PyVTKEnum_Add(&PyvtkPVRenderView_BackgroundMode_Type, "vtkPVRenderView.BackgroundMode");

  o = (PyObject *)&PyvtkPVRenderView_BackgroundMode_Type;
  if (PyDict_SetItemString(d, "BackgroundMode", o) != 0)
  {
    Py_DECREF(o);
  }

  PyType_Ready(&PyvtkPVRenderView_GenericFilmicPresets_Type);
  PyVTKEnum_Add(&PyvtkPVRenderView_GenericFilmicPresets_Type, "vtkPVRenderView.GenericFilmicPresets");

  o = (PyObject *)&PyvtkPVRenderView_GenericFilmicPresets_Type;
  if (PyDict_SetItemString(d, "GenericFilmicPresets", o) != 0)
  {
    Py_DECREF(o);
  }

  for (int c = 0; c < 6; c++)
  {
    typedef vtkPVRenderView::InteractionModes cxx_enum_type;

    static const struct { const char *name; cxx_enum_type value; }
      constants[6] = {
        { "INTERACTION_MODE_UNINTIALIZED", vtkPVRenderView::INTERACTION_MODE_UNINTIALIZED },
        { "INTERACTION_MODE_3D", vtkPVRenderView::INTERACTION_MODE_3D },
        { "INTERACTION_MODE_2D", vtkPVRenderView::INTERACTION_MODE_2D },
        { "INTERACTION_MODE_SELECTION", vtkPVRenderView::INTERACTION_MODE_SELECTION },
        { "INTERACTION_MODE_ZOOM", vtkPVRenderView::INTERACTION_MODE_ZOOM },
        { "INTERACTION_MODE_POLYGON", vtkPVRenderView::INTERACTION_MODE_POLYGON },
      };

    o = PyvtkPVRenderView_InteractionModes_FromEnum(constants[c].value);
    if (o)
    {
      PyDict_SetItemString(d, constants[c].name, o);
      Py_DECREF(o);
    }
  }

  for (int c = 0; c < 5; c++)
  {
    static const struct { const char *name; int value; }
      constants[5] = {
        { "DEFAULT_RENDERER", vtkPVRenderView::DEFAULT_RENDERER },
        { "NON_COMPOSITED_RENDERER", vtkPVRenderView::NON_COMPOSITED_RENDERER },
        { "USE_BOUNDS_FOR_REDISTRIBUTION", vtkPVRenderView::USE_BOUNDS_FOR_REDISTRIBUTION },
        { "DATA_IS_REDISTRIBUTABLE", vtkPVRenderView::DATA_IS_REDISTRIBUTABLE },
        { "USE_DATA_FOR_LOAD_BALANCING", vtkPVRenderView::USE_DATA_FOR_LOAD_BALANCING },
      };

    o = PyLong_FromLong(constants[c].value);
    if (o)
    {
      PyDict_SetItemString(d, constants[c].name, o);
      Py_DECREF(o);
    }
  }

  for (int c = 0; c < 5; c++)
  {
    typedef vtkPVRenderView::BackgroundMode cxx_enum_type;

    static const struct { const char *name; cxx_enum_type value; }
      constants[5] = {
        { "DEFAULT", vtkPVRenderView::DEFAULT },
        { "GRADIENT", vtkPVRenderView::GRADIENT },
        { "IMAGE", vtkPVRenderView::IMAGE },
        { "SKYBOX", vtkPVRenderView::SKYBOX },
        { "STEREO_SKYBOX", vtkPVRenderView::STEREO_SKYBOX },
      };

    o = PyvtkPVRenderView_BackgroundMode_FromEnum(constants[c].value);
    if (o)
    {
      PyDict_SetItemString(d, constants[c].name, o);
      Py_DECREF(o);
    }
  }

  for (int c = 0; c < 3; c++)
  {
    typedef vtkPVRenderView::GenericFilmicPresets cxx_enum_type;

    static const struct { const char *name; cxx_enum_type value; }
      constants[3] = {
        { "Custom", vtkPVRenderView::Custom },
        { "Default", vtkPVRenderView::Default },
        { "Uncharted2", vtkPVRenderView::Uncharted2 },
      };

    o = PyvtkPVRenderView_GenericFilmicPresets_FromEnum(constants[c].value);
    if (o)
    {
      PyDict_SetItemString(d, constants[c].name, o);
      Py_DECREF(o);
    }
  }

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPVRenderView_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVRenderView(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVRenderView_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPVRenderView", o) != 0)
  {
    Py_DECREF(o);
  }

}

