// python wrapper for vtkSMScalarBarWidgetRepresentationProxy
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkSMScalarBarWidgetRepresentationProxy.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkSMScalarBarWidgetRepresentationProxy(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkSMScalarBarWidgetRepresentationProxy_ClassNew(); }

#ifndef DECLARED_PyvtkSMNewWidgetRepresentationProxy_ClassNew
extern "C" { PyObject *PyvtkSMNewWidgetRepresentationProxy_ClassNew(); }
#define DECLARED_PyvtkSMNewWidgetRepresentationProxy_ClassNew
#endif

static PyObject *
PyvtkSMScalarBarWidgetRepresentationProxy_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkSMScalarBarWidgetRepresentationProxy::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMScalarBarWidgetRepresentationProxy_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMScalarBarWidgetRepresentationProxy *op = static_cast<vtkSMScalarBarWidgetRepresentationProxy *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkSMScalarBarWidgetRepresentationProxy::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMScalarBarWidgetRepresentationProxy_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkSMScalarBarWidgetRepresentationProxy *tempr = vtkSMScalarBarWidgetRepresentationProxy::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMScalarBarWidgetRepresentationProxy_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMScalarBarWidgetRepresentationProxy *op = static_cast<vtkSMScalarBarWidgetRepresentationProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSMScalarBarWidgetRepresentationProxy *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkSMScalarBarWidgetRepresentationProxy::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMScalarBarWidgetRepresentationProxy_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkSMScalarBarWidgetRepresentationProxy::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMScalarBarWidgetRepresentationProxy_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMScalarBarWidgetRepresentationProxy *op = static_cast<vtkSMScalarBarWidgetRepresentationProxy *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkSMScalarBarWidgetRepresentationProxy::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMScalarBarWidgetRepresentationProxy_UpdateComponentTitle_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UpdateComponentTitle");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMScalarBarWidgetRepresentationProxy *op = static_cast<vtkSMScalarBarWidgetRepresentationProxy *>(vp);

  vtkPVArrayInformation *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkPVArrayInformation"))
  {
    bool tempr = (ap.IsBound() ?
      op->UpdateComponentTitle(temp0) :
      op->vtkSMScalarBarWidgetRepresentationProxy::UpdateComponentTitle(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMScalarBarWidgetRepresentationProxy_UpdateComponentTitle_s2(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "UpdateComponentTitle");

  vtkSMProxy *temp0 = nullptr;
  vtkPVArrayInformation *temp1 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetVTKObject(temp1, "vtkPVArrayInformation"))
  {
    bool tempr = vtkSMScalarBarWidgetRepresentationProxy::UpdateComponentTitle(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMScalarBarWidgetRepresentationProxy_UpdateComponentTitle(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(args);

  switch(nargs)
  {
    case 1:
      return PyvtkSMScalarBarWidgetRepresentationProxy_UpdateComponentTitle_s1(self, args);
    case 2:
      return PyvtkSMScalarBarWidgetRepresentationProxy_UpdateComponentTitle_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "UpdateComponentTitle");
  return nullptr;
}


static PyObject *
PyvtkSMScalarBarWidgetRepresentationProxy_PlaceInView_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "PlaceInView");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMScalarBarWidgetRepresentationProxy *op = static_cast<vtkSMScalarBarWidgetRepresentationProxy *>(vp);

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    bool tempr = (ap.IsBound() ?
      op->PlaceInView(temp0) :
      op->vtkSMScalarBarWidgetRepresentationProxy::PlaceInView(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMScalarBarWidgetRepresentationProxy_PlaceInView_s2(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "PlaceInView");

  vtkSMProxy *temp0 = nullptr;
  vtkSMProxy *temp1 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProxy") &&
      ap.GetVTKObject(temp1, "vtkSMProxy"))
  {
    bool tempr = vtkSMScalarBarWidgetRepresentationProxy::PlaceInView(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMScalarBarWidgetRepresentationProxy_PlaceInView(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(args);

  switch(nargs)
  {
    case 1:
      return PyvtkSMScalarBarWidgetRepresentationProxy_PlaceInView_s1(self, args);
    case 2:
      return PyvtkSMScalarBarWidgetRepresentationProxy_PlaceInView_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "PlaceInView");
  return nullptr;
}


static PyObject *
PyvtkSMScalarBarWidgetRepresentationProxy_AddRange(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMScalarBarWidgetRepresentationProxy *op = static_cast<vtkSMScalarBarWidgetRepresentationProxy *>(vp);

  vtkSMRepresentationProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMRepresentationProxy"))
  {
    if (ap.IsBound())
    {
      op->AddRange(temp0);
    }
    else
    {
      op->vtkSMScalarBarWidgetRepresentationProxy::AddRange(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMScalarBarWidgetRepresentationProxy_AddBlockRange(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddBlockRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMScalarBarWidgetRepresentationProxy *op = static_cast<vtkSMScalarBarWidgetRepresentationProxy *>(vp);

  vtkSMRepresentationProxy *temp0 = nullptr;
  std::string temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMRepresentationProxy") &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->AddBlockRange(temp0, temp1);
    }
    else
    {
      op->vtkSMScalarBarWidgetRepresentationProxy::AddBlockRange(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMScalarBarWidgetRepresentationProxy_RemoveRange(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMScalarBarWidgetRepresentationProxy *op = static_cast<vtkSMScalarBarWidgetRepresentationProxy *>(vp);

  vtkSMRepresentationProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMRepresentationProxy"))
  {
    if (ap.IsBound())
    {
      op->RemoveRange(temp0);
    }
    else
    {
      op->vtkSMScalarBarWidgetRepresentationProxy::RemoveRange(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMScalarBarWidgetRepresentationProxy_RemoveBlockRange(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveBlockRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMScalarBarWidgetRepresentationProxy *op = static_cast<vtkSMScalarBarWidgetRepresentationProxy *>(vp);

  vtkSMRepresentationProxy *temp0 = nullptr;
  std::string temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMRepresentationProxy") &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->RemoveBlockRange(temp0, temp1);
    }
    else
    {
      op->vtkSMScalarBarWidgetRepresentationProxy::RemoveBlockRange(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMScalarBarWidgetRepresentationProxy_GetRange_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMScalarBarWidgetRepresentationProxy *op = static_cast<vtkSMScalarBarWidgetRepresentationProxy *>(vp);

  const size_t size0 = 2;
  double temp0[2];
  double save0[2];
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetArray(temp0, size0) &&
      ap.GetValue(temp1))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GetRange(temp0, temp1);
    }
    else
    {
      op->vtkSMScalarBarWidgetRepresentationProxy::GetRange(temp0, temp1);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkSMScalarBarWidgetRepresentationProxy_GetRange_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMScalarBarWidgetRepresentationProxy *op = static_cast<vtkSMScalarBarWidgetRepresentationProxy *>(vp);

  const size_t size0 = 2;
  double temp0[2];
  double save0[2];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GetRange(temp0);
    }
    else
    {
      op->vtkSMScalarBarWidgetRepresentationProxy::GetRange(temp0);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkSMScalarBarWidgetRepresentationProxy_GetRange(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyvtkSMScalarBarWidgetRepresentationProxy_GetRange_s1(self, args);
    case 1:
      return PyvtkSMScalarBarWidgetRepresentationProxy_GetRange_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetRange");
  return nullptr;
}


static PyObject *
PyvtkSMScalarBarWidgetRepresentationProxy_ClearRange(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ClearRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMScalarBarWidgetRepresentationProxy *op = static_cast<vtkSMScalarBarWidgetRepresentationProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ClearRange();
    }
    else
    {
      op->vtkSMScalarBarWidgetRepresentationProxy::ClearRange();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkSMScalarBarWidgetRepresentationProxy_Methods[] = {
  {"IsTypeOf", PyvtkSMScalarBarWidgetRepresentationProxy_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkSMScalarBarWidgetRepresentationProxy_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkSMScalarBarWidgetRepresentationProxy_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase)\n    -> vtkSMScalarBarWidgetRepresentationProxy\nC++: static vtkSMScalarBarWidgetRepresentationProxy *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkSMScalarBarWidgetRepresentationProxy_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkSMScalarBarWidgetRepresentationProxy\nC++: vtkSMScalarBarWidgetRepresentationProxy *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkSMScalarBarWidgetRepresentationProxy_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkSMScalarBarWidgetRepresentationProxy_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"UpdateComponentTitle", PyvtkSMScalarBarWidgetRepresentationProxy_UpdateComponentTitle, METH_VARARGS,
   "UpdateComponentTitle(self, dataInfo:vtkPVArrayInformation) -> bool\nC++: virtual bool UpdateComponentTitle(\n    vtkPVArrayInformation *dataInfo)\nUpdateComponentTitle(proxy:vtkSMProxy,\n    dataInfo:vtkPVArrayInformation) -> bool\nC++: static bool UpdateComponentTitle(vtkSMProxy *proxy,\n    vtkPVArrayInformation *dataInfo)\n\nUpdates the scalar bar's component title using the data\ninformation to determine component names if possible.\n"},
  {"PlaceInView", PyvtkSMScalarBarWidgetRepresentationProxy_PlaceInView, METH_VARARGS,
   "PlaceInView(self, view:vtkSMProxy) -> bool\nC++: virtual bool PlaceInView(vtkSMProxy *view)\nPlaceInView(proxy:vtkSMProxy, view:vtkSMProxy) -> bool\nC++: static bool PlaceInView(vtkSMProxy *proxy, vtkSMProxy *view)\n\nAttempt to place the scalar bar in the view based on the\nplacement of other currently shown and visible scalar bars.\n"},
  {"AddRange", PyvtkSMScalarBarWidgetRepresentationProxy_AddRange, METH_VARARGS,
   "AddRange(self, proxy:vtkSMRepresentationProxy) -> None\nC++: void AddRange(vtkSMRepresentationProxy *proxy)\n\nAdd range to current scalar bar for a given representation proxy.\nThis allows to display the combined range of multiple data sets\nthat hold the same array.\n"},
  {"AddBlockRange", PyvtkSMScalarBarWidgetRepresentationProxy_AddBlockRange, METH_VARARGS,
   "AddBlockRange(self, proxy:vtkSMRepresentationProxy,\n    blockSelector:str) -> None\nC++: void AddBlockRange(vtkSMRepresentationProxy *proxy,\n    const std::string &blockSelector)\n\n"},
  {"RemoveRange", PyvtkSMScalarBarWidgetRepresentationProxy_RemoveRange, METH_VARARGS,
   "RemoveRange(self, proxy:vtkSMRepresentationProxy) -> None\nC++: void RemoveRange(vtkSMRepresentationProxy *proxy)\n\nRemove range to current scalar bar for a given representation\nproxy. This allows to display the combined range of multiple data\nsets that hold the same array.\n"},
  {"RemoveBlockRange", PyvtkSMScalarBarWidgetRepresentationProxy_RemoveBlockRange, METH_VARARGS,
   "RemoveBlockRange(self, proxy:vtkSMRepresentationProxy,\n    blockSelector:str) -> None\nC++: void RemoveBlockRange(vtkSMRepresentationProxy *proxy,\n    const std::string &blockSelector)\n\n"},
  {"GetRange", PyvtkSMScalarBarWidgetRepresentationProxy_GetRange, METH_VARARGS,
   "GetRange(self, range:[float, float], component:int) -> None\nC++: void GetRange(double range[2], int component)\nGetRange(self, range:[float, float]) -> None\nC++: void GetRange(double range[2])\n\nGet the current range of the scalar bar.\n"},
  {"ClearRange", PyvtkSMScalarBarWidgetRepresentationProxy_ClearRange, METH_VARARGS,
   "ClearRange(self) -> None\nC++: void ClearRange()\n\nClears all data held by the scalar bar concerning range.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkSMScalarBarWidgetRepresentationProxy_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkSMScalarBarWidgetRepresentationProxy_Doc =
  "vtkSMScalarBarWidgetRepresentationProxy - is the representation\ncorresponding to a scalar bar or color legend in a Render View.\n\n"
  "Superclass: vtkSMNewWidgetRepresentationProxy\n\n"
;

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkSMScalarBarWidgetRepresentationProxy_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkSMScalarBarWidgetRepresentationProxy", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkSMScalarBarWidgetRepresentationProxy_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkSMScalarBarWidgetRepresentationProxy_StaticNew()
{
  return vtkSMScalarBarWidgetRepresentationProxy::New();
}

PyObject *PyvtkSMScalarBarWidgetRepresentationProxy_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkSMScalarBarWidgetRepresentationProxy_Type, PyvtkSMScalarBarWidgetRepresentationProxy_Methods,
    "vtkSMScalarBarWidgetRepresentationProxy",
 &PyvtkSMScalarBarWidgetRepresentationProxy_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkSMNewWidgetRepresentationProxy_ClassNew();

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkSMScalarBarWidgetRepresentationProxy_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkSMScalarBarWidgetRepresentationProxy(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkSMScalarBarWidgetRepresentationProxy_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkSMScalarBarWidgetRepresentationProxy", o) != 0)
  {
    Py_DECREF(o);
  }

}

