#include "vtkABI.h"
#include "vtkClientServerInterpreter.h"

extern "C" { void vtkCPExodusIIElementBlock_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkCPExodusIIInSituReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkExodusIICache_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkExodusIIReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkExodusIIReaderParser_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkExodusIIWriter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkModelMetadata_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkCPExodusIINodalCoordinatesTemplate_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkCPExodusIIResultsArrayTemplate_Init(vtkClientServerInterpreter*); }

extern "C" VTK_ABI_EXPORT void vtkIOExodusCS_Initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  vtkCPExodusIIElementBlock_Init(csi);
  vtkCPExodusIIInSituReader_Init(csi);
  vtkExodusIICache_Init(csi);
  vtkExodusIIReader_Init(csi);
  vtkExodusIIReaderParser_Init(csi);
  vtkExodusIIWriter_Init(csi);
  vtkModelMetadata_Init(csi);
  vtkCPExodusIINodalCoordinatesTemplate_Init(csi);
  vtkCPExodusIIResultsArrayTemplate_Init(csi);
}
