// python wrapper for vtkPythonCalculator
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkPythonCalculator.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPythonCalculator(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPythonCalculator_ClassNew(); }


static PyObject *
PyvtkPythonCalculator_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPythonCalculator::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPythonCalculator_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPythonCalculator *op = static_cast<vtkPythonCalculator *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPythonCalculator::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPythonCalculator_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPythonCalculator *tempr = vtkPythonCalculator::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPythonCalculator_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPythonCalculator *op = static_cast<vtkPythonCalculator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPythonCalculator *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPythonCalculator::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPythonCalculator_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPythonCalculator::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPythonCalculator_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPythonCalculator *op = static_cast<vtkPythonCalculator *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPythonCalculator::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPythonCalculator_SetArrayAssociation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetArrayAssociation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPythonCalculator *op = static_cast<vtkPythonCalculator *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetArrayAssociation(temp0);
    }
    else
    {
      op->vtkPythonCalculator::SetArrayAssociation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPythonCalculator_GetArrayAssociation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetArrayAssociation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPythonCalculator *op = static_cast<vtkPythonCalculator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetArrayAssociation() :
      op->vtkPythonCalculator::GetArrayAssociation());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPythonCalculator_SetExpression(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetExpression");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPythonCalculator *op = static_cast<vtkPythonCalculator *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetExpression(temp0);
    }
    else
    {
      op->vtkPythonCalculator::SetExpression(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPythonCalculator_GetExpression(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetExpression");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPythonCalculator *op = static_cast<vtkPythonCalculator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetExpression() :
      op->vtkPythonCalculator::GetExpression());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPythonCalculator_SetMultilineExpression(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMultilineExpression");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPythonCalculator *op = static_cast<vtkPythonCalculator *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMultilineExpression(temp0);
    }
    else
    {
      op->vtkPythonCalculator::SetMultilineExpression(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPythonCalculator_GetMultilineExpression(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMultilineExpression");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPythonCalculator *op = static_cast<vtkPythonCalculator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetMultilineExpression() :
      op->vtkPythonCalculator::GetMultilineExpression());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPythonCalculator_SetArrayName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetArrayName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPythonCalculator *op = static_cast<vtkPythonCalculator *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetArrayName(temp0);
    }
    else
    {
      op->vtkPythonCalculator::SetArrayName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPythonCalculator_GetArrayName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetArrayName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPythonCalculator *op = static_cast<vtkPythonCalculator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetArrayName() :
      op->vtkPythonCalculator::GetArrayName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPythonCalculator_GetResultArrayType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetResultArrayType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPythonCalculator *op = static_cast<vtkPythonCalculator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetResultArrayType() :
      op->vtkPythonCalculator::GetResultArrayType());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPythonCalculator_SetResultArrayType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetResultArrayType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPythonCalculator *op = static_cast<vtkPythonCalculator *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetResultArrayType(temp0);
    }
    else
    {
      op->vtkPythonCalculator::SetResultArrayType(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPythonCalculator_GetUseMultilineExpression(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseMultilineExpression");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPythonCalculator *op = static_cast<vtkPythonCalculator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseMultilineExpression() :
      op->vtkPythonCalculator::GetUseMultilineExpression());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPythonCalculator_SetUseMultilineExpression(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseMultilineExpression");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPythonCalculator *op = static_cast<vtkPythonCalculator *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseMultilineExpression(temp0);
    }
    else
    {
      op->vtkPythonCalculator::SetUseMultilineExpression(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPythonCalculator_ExecuteScript(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "ExecuteScript");

  void  *temp0 = nullptr;
  Py_buffer pbuf0 = { nullptr, nullptr, 0, 0, 0, 0, nullptr, nullptr, nullptr, nullptr, nullptr };
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetBuffer(temp0, &pbuf0))
  {
    vtkPythonCalculator::ExecuteScript(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  if (pbuf0.obj != nullptr)
  {
    PyBuffer_Release(&pbuf0);
  }
  return result;
}

static PyMethodDef PyvtkPythonCalculator_Methods[] = {
  {"IsTypeOf", PyvtkPythonCalculator_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPythonCalculator_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPythonCalculator_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPythonCalculator\nC++: static vtkPythonCalculator *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPythonCalculator_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPythonCalculator\nC++: vtkPythonCalculator *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPythonCalculator_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPythonCalculator_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetArrayAssociation", PyvtkPythonCalculator_SetArrayAssociation, METH_VARARGS,
   "SetArrayAssociation(self, _arg:int) -> None\nC++: virtual void SetArrayAssociation(int _arg)\n\nWhich field data to get the arrays from. See\nvtkDataObject::FieldAssociations for choices. The default is\nFIELD_ASSOCIATION_POINTS.\n"},
  {"GetArrayAssociation", PyvtkPythonCalculator_GetArrayAssociation, METH_VARARGS,
   "GetArrayAssociation(self) -> int\nC++: virtual int GetArrayAssociation()\n\n"},
  {"SetExpression", PyvtkPythonCalculator_SetExpression, METH_VARARGS,
   "SetExpression(self, _arg:str) -> None\nC++: virtual void SetExpression(std::string _arg)\n\nSet the text of the python expression to execute. This expression\nmust return a scalar value (which is converted to an array) or a\nnumpy array.\n"},
  {"GetExpression", PyvtkPythonCalculator_GetExpression, METH_VARARGS,
   "GetExpression(self) -> str\nC++: virtual std::string GetExpression()\n\n"},
  {"SetMultilineExpression", PyvtkPythonCalculator_SetMultilineExpression, METH_VARARGS,
   "SetMultilineExpression(self, _arg:str) -> None\nC++: virtual void SetMultilineExpression(std::string _arg)\n\nSet the text of the python multiline expression. The expression\nmust use an explicit return statement for the result scalar value\nor numpy array.\n"},
  {"GetMultilineExpression", PyvtkPythonCalculator_GetMultilineExpression, METH_VARARGS,
   "GetMultilineExpression(self) -> str\nC++: virtual std::string GetMultilineExpression()\n\n"},
  {"SetArrayName", PyvtkPythonCalculator_SetArrayName, METH_VARARGS,
   "SetArrayName(self, _arg:str) -> None\nC++: virtual void SetArrayName(const char *_arg)\n\nSet the name of the output array.\n"},
  {"GetArrayName", PyvtkPythonCalculator_GetArrayName, METH_VARARGS,
   "GetArrayName(self) -> str\nC++: virtual char *GetArrayName()\n\n"},
  {"GetResultArrayType", PyvtkPythonCalculator_GetResultArrayType, METH_VARARGS,
   "GetResultArrayType(self) -> int\nC++: virtual int GetResultArrayType()\n\nType of the result array. Initial value is VTK_DOUBLE.\n"},
  {"SetResultArrayType", PyvtkPythonCalculator_SetResultArrayType, METH_VARARGS,
   "SetResultArrayType(self, _arg:int) -> None\nC++: virtual void SetResultArrayType(int _arg)\n\n"},
  {"GetUseMultilineExpression", PyvtkPythonCalculator_GetUseMultilineExpression, METH_VARARGS,
   "GetUseMultilineExpression(self) -> bool\nC++: virtual bool GetUseMultilineExpression()\n\nIf true, executes `MultilineExpression`, which is a multiline\nstring representing a Python script, ending by a return\nstatement. Otherwise, evaluates `Expression`, a python\nexpression. Initial value is false.\n"},
  {"SetUseMultilineExpression", PyvtkPythonCalculator_SetUseMultilineExpression, METH_VARARGS,
   "SetUseMultilineExpression(self, _arg:bool) -> None\nC++: virtual void SetUseMultilineExpression(bool _arg)\n\n"},
  {"ExecuteScript", PyvtkPythonCalculator_ExecuteScript, METH_VARARGS,
   "ExecuteScript(__a:Pointer) -> None\nC++: static void ExecuteScript(void *)\n\nFor internal use only.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPythonCalculator_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("array_association"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPythonCalculator_GetArrayAssociation(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPythonCalculator_SetArrayAssociation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPythonCalculator_SetArrayAssociation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetArrayAssociation/SetArrayAssociation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("expression"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPythonCalculator_GetExpression(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPythonCalculator_SetExpression(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPythonCalculator_SetExpression(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetExpression/SetExpression\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("multiline_expression"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPythonCalculator_GetMultilineExpression(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPythonCalculator_SetMultilineExpression(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPythonCalculator_SetMultilineExpression(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetMultilineExpression/SetMultilineExpression\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("array_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPythonCalculator_GetArrayName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPythonCalculator_SetArrayName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPythonCalculator_SetArrayName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetArrayName/SetArrayName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("result_array_type"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPythonCalculator_GetResultArrayType(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPythonCalculator_SetResultArrayType(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPythonCalculator_SetResultArrayType(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetResultArrayType/SetResultArrayType\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_multiline_expression"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPythonCalculator_GetUseMultilineExpression(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPythonCalculator_SetUseMultilineExpression(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPythonCalculator_SetUseMultilineExpression(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseMultilineExpression/SetUseMultilineExpression\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPythonCalculator_Doc =
  "vtkPythonCalculator - Evaluates a Python expression\nvtkPythonCalculator uses Python to calculate an expression.\n\n"
  "Superclass: vtkProgrammableFilter\n\n"
  "This filter depends heavily on the numpy and paraview.vtk modules. To\n"
  "use the parallel functions, mpi4py is also necessary. The expression\n"
  "is evaluated and the resulting scalar value or numpy array is added\n"
  "to the output as an array. See numpy and paraview.vtk documentation\n"
  "for the list of available functions.\n\n"
  "This filter tries to make it easy for the user to write expressions\n"
  "by defining certain variables. The filter tries to assign each array\n"
  "to a variable of the same name. If the name of the array is not a\n"
  "valid Python variable, it has to be accessed through a dictionary\n"
  "called arrays (i.e. arrays['array_name']). The points can be accessed\n"
  "using the points variable.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPythonCalculator_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVVTKExtensionsFiltersPython.vtkPythonCalculator", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPythonCalculator_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPythonCalculator_StaticNew()
{
  return vtkPythonCalculator::New();
}

PyObject *PyvtkPythonCalculator_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPythonCalculator_Type, PyvtkPythonCalculator_Methods,
    "vtkPythonCalculator",
 &PyvtkPythonCalculator_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkProgrammableFilter");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPythonCalculator_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPythonCalculator(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPythonCalculator_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPythonCalculator", o) != 0)
  {
    Py_DECREF(o);
  }

}

