// python wrapper for vtkRemoteWriterHelper
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkRemoteWriterHelper.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkRemoteWriterHelper(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkRemoteWriterHelper_ClassNew(); }


static PyObject *
PyvtkRemoteWriterHelper_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkRemoteWriterHelper::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemoteWriterHelper_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemoteWriterHelper *op = static_cast<vtkRemoteWriterHelper *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkRemoteWriterHelper::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemoteWriterHelper_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkRemoteWriterHelper *tempr = vtkRemoteWriterHelper::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemoteWriterHelper_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemoteWriterHelper *op = static_cast<vtkRemoteWriterHelper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkRemoteWriterHelper *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkRemoteWriterHelper::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemoteWriterHelper_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkRemoteWriterHelper::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemoteWriterHelper_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemoteWriterHelper *op = static_cast<vtkRemoteWriterHelper *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkRemoteWriterHelper::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemoteWriterHelper_SetWriter(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetWriter");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemoteWriterHelper *op = static_cast<vtkRemoteWriterHelper *>(vp);

  vtkAlgorithm *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkAlgorithm"))
  {
    if (ap.IsBound())
    {
      op->SetWriter(temp0);
    }
    else
    {
      op->vtkRemoteWriterHelper::SetWriter(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkRemoteWriterHelper_GetWriter(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetWriter");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemoteWriterHelper *op = static_cast<vtkRemoteWriterHelper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkAlgorithm *tempr = (ap.IsBound() ?
      op->GetWriter() :
      op->vtkRemoteWriterHelper::GetWriter());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemoteWriterHelper_SetOutputDestination(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOutputDestination");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemoteWriterHelper *op = static_cast<vtkRemoteWriterHelper *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetOutputDestination(temp0);
    }
    else
    {
      op->vtkRemoteWriterHelper::SetOutputDestination(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkRemoteWriterHelper_GetOutputDestination(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetOutputDestination");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemoteWriterHelper *op = static_cast<vtkRemoteWriterHelper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned int tempr = (ap.IsBound() ?
      op->GetOutputDestination() :
      op->vtkRemoteWriterHelper::GetOutputDestination());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemoteWriterHelper_SetTryWritingInBackground(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTryWritingInBackground");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemoteWriterHelper *op = static_cast<vtkRemoteWriterHelper *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTryWritingInBackground(temp0);
    }
    else
    {
      op->vtkRemoteWriterHelper::SetTryWritingInBackground(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkRemoteWriterHelper_GetTryWritingInBackground(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTryWritingInBackground");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemoteWriterHelper *op = static_cast<vtkRemoteWriterHelper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetTryWritingInBackground() :
      op->vtkRemoteWriterHelper::GetTryWritingInBackground());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemoteWriterHelper_TryWritingInBackgroundOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "TryWritingInBackgroundOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemoteWriterHelper *op = static_cast<vtkRemoteWriterHelper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->TryWritingInBackgroundOn();
    }
    else
    {
      op->vtkRemoteWriterHelper::TryWritingInBackgroundOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkRemoteWriterHelper_TryWritingInBackgroundOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "TryWritingInBackgroundOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemoteWriterHelper *op = static_cast<vtkRemoteWriterHelper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->TryWritingInBackgroundOff();
    }
    else
    {
      op->vtkRemoteWriterHelper::TryWritingInBackgroundOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkRemoteWriterHelper_SetState(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetState");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemoteWriterHelper *op = static_cast<vtkRemoteWriterHelper *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetState(temp0);
    }
    else
    {
      op->vtkRemoteWriterHelper::SetState(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkRemoteWriterHelper_GetStateMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetStateMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemoteWriterHelper *op = static_cast<vtkRemoteWriterHelper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetStateMinValue() :
      op->vtkRemoteWriterHelper::GetStateMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemoteWriterHelper_GetStateMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetStateMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemoteWriterHelper *op = static_cast<vtkRemoteWriterHelper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetStateMaxValue() :
      op->vtkRemoteWriterHelper::GetStateMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemoteWriterHelper_GetState(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetState");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemoteWriterHelper *op = static_cast<vtkRemoteWriterHelper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetState() :
      op->vtkRemoteWriterHelper::GetState());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemoteWriterHelper_SetInterpreter(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInterpreter");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemoteWriterHelper *op = static_cast<vtkRemoteWriterHelper *>(vp);

  vtkClientServerInterpreter *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkClientServerInterpreter"))
  {
    if (ap.IsBound())
    {
      op->SetInterpreter(temp0);
    }
    else
    {
      op->vtkRemoteWriterHelper::SetInterpreter(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkRemoteWriterHelper_GetInterpreter(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetInterpreter");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemoteWriterHelper *op = static_cast<vtkRemoteWriterHelper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkClientServerInterpreter *tempr = (ap.IsBound() ?
      op->GetInterpreter() :
      op->vtkRemoteWriterHelper::GetInterpreter());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRemoteWriterHelper_Wait_s1(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "Wait");

  std::string temp0;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkRemoteWriterHelper::Wait(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkRemoteWriterHelper_Wait_s2(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "Wait");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkRemoteWriterHelper::Wait();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkRemoteWriterHelper_Wait(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(args);

  switch(nargs)
  {
    case 1:
      return PyvtkRemoteWriterHelper_Wait_s1(self, args);
    case 0:
      return PyvtkRemoteWriterHelper_Wait_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "Wait");
  return nullptr;
}


static PyObject *
PyvtkRemoteWriterHelper_Write(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Write");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRemoteWriterHelper *op = static_cast<vtkRemoteWriterHelper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->Write() :
      op->vtkRemoteWriterHelper::Write());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkRemoteWriterHelper_Methods[] = {
  {"IsTypeOf", PyvtkRemoteWriterHelper_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkRemoteWriterHelper_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkRemoteWriterHelper_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkRemoteWriterHelper\nC++: static vtkRemoteWriterHelper *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkRemoteWriterHelper_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkRemoteWriterHelper\nC++: vtkRemoteWriterHelper *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkRemoteWriterHelper_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkRemoteWriterHelper_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetWriter", PyvtkRemoteWriterHelper_SetWriter, METH_VARARGS,
   "SetWriter(self, writer:vtkAlgorithm) -> None\nC++: void SetWriter(vtkAlgorithm *writer)\n\nGet/Set the Image writer\n"},
  {"GetWriter", PyvtkRemoteWriterHelper_GetWriter, METH_VARARGS,
   "GetWriter(self) -> vtkAlgorithm\nC++: virtual vtkAlgorithm *GetWriter()\n\n"},
  {"SetOutputDestination", PyvtkRemoteWriterHelper_SetOutputDestination, METH_VARARGS,
   "SetOutputDestination(self, _arg:int) -> None\nC++: virtual void SetOutputDestination(vtkTypeUInt32 _arg)\n\nGet/Set the process on which the data must be written. Currently\nsupported values are vtkPVSession::CLIENT and\nvtkPVSession::DATA_SERVER_ROOT (or vtkPVSession::DATA_SERVER).\nvtkPVSession::DATA_SERVER and vtkPVSession::DATA_SERVER_ROOT are\ntreated identically since the data is only written on the root\nnode.\n"},
  {"GetOutputDestination", PyvtkRemoteWriterHelper_GetOutputDestination, METH_VARARGS,
   "GetOutputDestination(self) -> int\nC++: virtual vtkTypeUInt32 GetOutputDestination()\n\n"},
  {"SetTryWritingInBackground", PyvtkRemoteWriterHelper_SetTryWritingInBackground, METH_VARARGS,
   "SetTryWritingInBackground(self, _arg:bool) -> None\nC++: virtual void SetTryWritingInBackground(bool _arg)\n\nIf set to true, this helper will attempt writing the file in the\nbackground in parallel. As of today, only images can go this path\n(.jpeg, .png, etc.). Otherwise, writing a file will happen\nserially in all circumstances.\n"},
  {"GetTryWritingInBackground", PyvtkRemoteWriterHelper_GetTryWritingInBackground, METH_VARARGS,
   "GetTryWritingInBackground(self) -> bool\nC++: virtual bool GetTryWritingInBackground()\n\n"},
  {"TryWritingInBackgroundOn", PyvtkRemoteWriterHelper_TryWritingInBackgroundOn, METH_VARARGS,
   "TryWritingInBackgroundOn(self) -> None\nC++: virtual void TryWritingInBackgroundOn()\n\n"},
  {"TryWritingInBackgroundOff", PyvtkRemoteWriterHelper_TryWritingInBackgroundOff, METH_VARARGS,
   "TryWritingInBackgroundOff(self) -> None\nC++: virtual void TryWritingInBackgroundOff()\n\n"},
  {"SetState", PyvtkRemoteWriterHelper_SetState, METH_VARARGS,
   "SetState(self, _arg:int) -> None\nC++: virtual void SetState(int _arg)\n\nSet the state of the writer.\n\nMake sure that the given writer has a Start and End functions if\nyou want to use START and END states.\n\nThe default is WRITE.\n"},
  {"GetStateMinValue", PyvtkRemoteWriterHelper_GetStateMinValue, METH_VARARGS,
   "GetStateMinValue(self) -> int\nC++: virtual int GetStateMinValue()\n\n"},
  {"GetStateMaxValue", PyvtkRemoteWriterHelper_GetStateMaxValue, METH_VARARGS,
   "GetStateMaxValue(self) -> int\nC++: virtual int GetStateMaxValue()\n\n"},
  {"GetState", PyvtkRemoteWriterHelper_GetState, METH_VARARGS,
   "GetState(self) -> int\nC++: virtual int GetState()\n\n"},
  {"SetInterpreter", PyvtkRemoteWriterHelper_SetInterpreter, METH_VARARGS,
   "SetInterpreter(self, interp:vtkClientServerInterpreter) -> None\nC++: void SetInterpreter(vtkClientServerInterpreter *interp)\n\nSet the interpreter to use to call methods on the writer.\nInitialized to\n`vtkClientServerInterpreterInitializer::GetGlobalInterpreter()`\nin the constructor.\n"},
  {"GetInterpreter", PyvtkRemoteWriterHelper_GetInterpreter, METH_VARARGS,
   "GetInterpreter(self) -> vtkClientServerInterpreter\nC++: virtual vtkClientServerInterpreter *GetInterpreter()\n\n"},
  {"Wait", PyvtkRemoteWriterHelper_Wait, METH_VARARGS,
   "Wait(fileName:str) -> None\nC++: static void Wait(const std::string &fileName)\nWait() -> None\nC++: static void Wait()\n\nWait until `fileName` has finished being written. If the file has\nbeen written in the background in parallel, this thread might\nhang if the file is not finished being written. Otherwise, there\nis no waiting.\n\n@param fileName File name to wait for. It can be provided with\n    its absolute or relative path\nregardless.\n"},
  {"Write", PyvtkRemoteWriterHelper_Write, METH_VARARGS,
   "Write(self) -> int\nC++: int Write()\n\nWrite the data.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkRemoteWriterHelper_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("writer"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkRemoteWriterHelper_GetWriter(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkRemoteWriterHelper_SetWriter(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkRemoteWriterHelper_SetWriter(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetWriter/SetWriter\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("output_destination"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkRemoteWriterHelper_GetOutputDestination(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkRemoteWriterHelper_SetOutputDestination(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkRemoteWriterHelper_SetOutputDestination(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetOutputDestination/SetOutputDestination\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("try_writing_in_background"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkRemoteWriterHelper_GetTryWritingInBackground(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkRemoteWriterHelper_SetTryWritingInBackground(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkRemoteWriterHelper_SetTryWritingInBackground(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTryWritingInBackground/SetTryWritingInBackground\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("state"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkRemoteWriterHelper_GetState(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkRemoteWriterHelper_SetState(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkRemoteWriterHelper_SetState(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetState/SetState\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("interpreter"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkRemoteWriterHelper_GetInterpreter(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkRemoteWriterHelper_SetInterpreter(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkRemoteWriterHelper_SetInterpreter(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetInterpreter/SetInterpreter\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkRemoteWriterHelper_Doc =
  "vtkRemoteWriterHelper - Helper to write data on client or\ndata-server-root.\n\n"
  "Superclass: vtkDataObjectAlgorithm\n\n"
  "vtkRemoteWriterHelper is designed to be used to write data that is\n"
  "being generated on the client-side either directly on the client or\n"
  "on the data-server root node. This is useful for saving data such as\n"
  "screenshots, state files, etc. that are generated on the client-side\n"
  "but sometimes needs to be saved remotely on the data-server root node\n"
  "instead.\n\n"
  "To use, simply create the (\"misc\", \"RemoteWriterHelper\") proxy. The\n"
  "proxy creates this class on client and data-server. Next, using the\n"
  "client-side object, pass the input data to the client-instance and\n"
  "then set `OutputDestination` property as needed. The actual writer to\n"
  "use must be set using the \"Writer\" property. Now, when you call\n"
  "UpdatePipeline, the vtkRemoteWriterHelper will transfer data if\n"
  "needed and then invoke the writer's Write method on the target\n"
  "process.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkRemoteWriterHelper_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingServerManager.vtkRemoteWriterHelper", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkRemoteWriterHelper_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkRemoteWriterHelper_StaticNew()
{
  return vtkRemoteWriterHelper::New();
}

PyObject *PyvtkRemoteWriterHelper_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkRemoteWriterHelper_Type, PyvtkRemoteWriterHelper_Methods,
    "vtkRemoteWriterHelper",
 &PyvtkRemoteWriterHelper_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkDataObjectAlgorithm");

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  for (int c = 0; c < 3; c++)
  {
    static const struct { const char *name; int value; }
      constants[3] = {
        { "START", vtkRemoteWriterHelper::START },
        { "WRITE", vtkRemoteWriterHelper::WRITE },
        { "END", vtkRemoteWriterHelper::END },
      };

    o = PyLong_FromLong(constants[c].value);
    if (o)
    {
      PyDict_SetItemString(d, constants[c].name, o);
      Py_DECREF(o);
    }
  }

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkRemoteWriterHelper_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkRemoteWriterHelper(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkRemoteWriterHelper_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkRemoteWriterHelper", o) != 0)
  {
    Py_DECREF(o);
  }

}

