/* Generated by wayland-scanner 1.23.1 */

#ifndef PHOSH_SERVER_PROTOCOL_H
#define PHOSH_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_phosh The phosh protocol
 * @section page_ifaces_phosh Interfaces
 * - @subpage page_iface_phosh_private - Phone shell extensions
 * - @subpage page_iface_phosh_private_keyboard_event - Interface for additional keyboard events
 * - @subpage page_iface_phosh_private_xdg_switcher - Interface to list and raise xdg surfaces
 * - @subpage page_iface_phosh_private_startup_tracker - Interface to track application startup
 * @section page_copyright_phosh Copyright
 * <pre>
 *
 * Copyright © 2019 Purism SPC
 *
 * Permission to use, copy, modify, distribute, and sell this
 * software and its documentation for any purpose is hereby granted
 * without fee, provided that the above copyright notice appear in
 * all copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the name of
 * the copyright holders not be used in advertising or publicity
 * pertaining to distribution of the software without specific,
 * written prior permission.  The copyright holders make no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.
 *
 * THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
 * THIS SOFTWARE.
 * </pre>
 */
struct phosh_private;
struct phosh_private_keyboard_event;
struct phosh_private_startup_tracker;
struct phosh_private_xdg_switcher;
struct wl_surface;
struct zwlr_foreign_toplevel_handle_v1;
struct zwlr_screencopy_frame_v1;

#ifndef PHOSH_PRIVATE_INTERFACE
#define PHOSH_PRIVATE_INTERFACE
/**
 * @page page_iface_phosh_private phosh_private
 * @section page_iface_phosh_private_desc Description
 *
 * Private protocol between phosh and the compositor.
 *
 * Instead of adding more interfaces here consider adding a separate
 * zphoc-unstable protocol instead.
 * @section page_iface_phosh_private_api API
 * See @ref iface_phosh_private.
 */
/**
 * @defgroup iface_phosh_private The phosh_private interface
 *
 * Private protocol between phosh and the compositor.
 *
 * Instead of adding more interfaces here consider adding a separate
 * zphoc-unstable protocol instead.
 */
extern const struct wl_interface phosh_private_interface;
#endif
#ifndef PHOSH_PRIVATE_KEYBOARD_EVENT_INTERFACE
#define PHOSH_PRIVATE_KEYBOARD_EVENT_INTERFACE
/**
 * @page page_iface_phosh_private_keyboard_event phosh_private_keyboard_event
 * @section page_iface_phosh_private_keyboard_event_desc Description
 *
 * The interface is meant to allow subscription and forwarding of keyboard events.
 * @section page_iface_phosh_private_keyboard_event_api API
 * See @ref iface_phosh_private_keyboard_event.
 */
/**
 * @defgroup iface_phosh_private_keyboard_event The phosh_private_keyboard_event interface
 *
 * The interface is meant to allow subscription and forwarding of keyboard events.
 */
extern const struct wl_interface phosh_private_keyboard_event_interface;
#endif
#ifndef PHOSH_PRIVATE_XDG_SWITCHER_INTERFACE
#define PHOSH_PRIVATE_XDG_SWITCHER_INTERFACE
/**
 * @page page_iface_phosh_private_xdg_switcher phosh_private_xdg_switcher
 * @section page_iface_phosh_private_xdg_switcher_desc Description
 *
 * This interface is unused, ignore. Use wlr-foreign-toplevel-management instead.
 * @section page_iface_phosh_private_xdg_switcher_api API
 * See @ref iface_phosh_private_xdg_switcher.
 */
/**
 * @defgroup iface_phosh_private_xdg_switcher The phosh_private_xdg_switcher interface
 *
 * This interface is unused, ignore. Use wlr-foreign-toplevel-management instead.
 */
extern const struct wl_interface phosh_private_xdg_switcher_interface;
#endif
#ifndef PHOSH_PRIVATE_STARTUP_TRACKER_INTERFACE
#define PHOSH_PRIVATE_STARTUP_TRACKER_INTERFACE
/**
 * @page page_iface_phosh_private_startup_tracker phosh_private_startup_tracker
 * @section page_iface_phosh_private_startup_tracker_desc Description
 *
 * Allows shells to track application startup.
 * @section page_iface_phosh_private_startup_tracker_api API
 * See @ref iface_phosh_private_startup_tracker.
 */
/**
 * @defgroup iface_phosh_private_startup_tracker The phosh_private_startup_tracker interface
 *
 * Allows shells to track application startup.
 */
extern const struct wl_interface phosh_private_startup_tracker_interface;
#endif

#ifndef PHOSH_PRIVATE_ERROR_ENUM
#define PHOSH_PRIVATE_ERROR_ENUM
enum phosh_private_error {
	/**
	 * an invalid argument was provided in a request
	 */
	PHOSH_PRIVATE_ERROR_INVALID_ARGUMENT = 0,
};
/**
 * @ingroup iface_phosh_private
 * Validate a phosh_private error value.
 *
 * @return true on success, false on error.
 * @ref phosh_private_error
 */
static inline bool
phosh_private_error_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case PHOSH_PRIVATE_ERROR_INVALID_ARGUMENT:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* PHOSH_PRIVATE_ERROR_ENUM */

#ifndef PHOSH_PRIVATE_SHELL_STATE_ENUM
#define PHOSH_PRIVATE_SHELL_STATE_ENUM
enum phosh_private_shell_state {
	/**
	 * shell state unknown
	 */
	PHOSH_PRIVATE_SHELL_STATE_UNKNOWN = 0,
	/**
	 * shell is up and running
	 */
	PHOSH_PRIVATE_SHELL_STATE_UP = 1,
};
/**
 * @ingroup iface_phosh_private
 * Validate a phosh_private shell_state value.
 *
 * @return true on success, false on error.
 * @ref phosh_private_shell_state
 */
static inline bool
phosh_private_shell_state_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case PHOSH_PRIVATE_SHELL_STATE_UNKNOWN:
		return version >= 1;
	case PHOSH_PRIVATE_SHELL_STATE_UP:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* PHOSH_PRIVATE_SHELL_STATE_ENUM */

/**
 * @ingroup iface_phosh_private
 * @struct phosh_private_interface
 */
struct phosh_private_interface {
	/**
	 * rotate output
	 *
	 * This request is unused, ignore. Use wlr-output-management
	 * instead.
	 */
	void (*rotate_display)(struct wl_client *client,
			       struct wl_resource *resource,
			       struct wl_resource *surface,
			       uint32_t degree);
	/**
	 * rotate output
	 *
	 * This request is unused, ignore. Use
	 * wlr-foreign-toplevel-management instead.
	 * @since 2
	 */
	void (*get_xdg_switcher)(struct wl_client *client,
				 struct wl_resource *resource,
				 uint32_t id);
	/**
	 * request a window thumbnail for a given toplevel
	 *
	 * Allows to retrieve a window thumbnail image for a given
	 * foreign toplevel via wlr_screencopy protocol.
	 *
	 * The thumbnail will be scaled down to the size provided by
	 * max_width and max_height arguments, preserving original aspect
	 * ratio. Pass 0 to leave it unconstrained.
	 * @since 4
	 */
	void (*get_thumbnail)(struct wl_client *client,
			      struct wl_resource *resource,
			      uint32_t id,
			      struct wl_resource *toplevel,
			      uint32_t max_width,
			      uint32_t max_height);
	/**
	 * request a keyboard event handler
	 *
	 * Allows to subscribe to specific keyboard events.
	 *
	 * The client grabs an accelerator by a string and gets an action
	 * id returned. When the accelerator is used the client will be
	 * informed via the corresponding action id.
	 * @since 5
	 */
	void (*get_keyboard_event)(struct wl_client *client,
				   struct wl_resource *resource,
				   uint32_t id);
	/**
	 * Request an application startup tracker
	 *
	 * Allows to track application startup.
	 * @since 6
	 */
	void (*get_startup_tracker)(struct wl_client *client,
				    struct wl_resource *resource,
				    uint32_t id);
	/**
	 * Report shell state
	 *
	 * This allows the shell to report it's current state. This can
	 * e.g. be used to notify the compositor that the shell is up.
	 * @param state Status
	 * @since 6
	 */
	void (*set_shell_state)(struct wl_client *client,
				struct wl_resource *resource,
				uint32_t state);
};


/**
 * @ingroup iface_phosh_private
 */
#define PHOSH_PRIVATE_ROTATE_DISPLAY_SINCE_VERSION 1
/**
 * @ingroup iface_phosh_private
 */
#define PHOSH_PRIVATE_GET_XDG_SWITCHER_SINCE_VERSION 2
/**
 * @ingroup iface_phosh_private
 */
#define PHOSH_PRIVATE_GET_THUMBNAIL_SINCE_VERSION 4
/**
 * @ingroup iface_phosh_private
 */
#define PHOSH_PRIVATE_GET_KEYBOARD_EVENT_SINCE_VERSION 5
/**
 * @ingroup iface_phosh_private
 */
#define PHOSH_PRIVATE_GET_STARTUP_TRACKER_SINCE_VERSION 6
/**
 * @ingroup iface_phosh_private
 */
#define PHOSH_PRIVATE_SET_SHELL_STATE_SINCE_VERSION 6

#ifndef PHOSH_PRIVATE_KEYBOARD_EVENT_ERROR_ENUM
#define PHOSH_PRIVATE_KEYBOARD_EVENT_ERROR_ENUM
enum phosh_private_keyboard_event_error {
	/**
	 * an invalid argument was provided in a request
	 */
	PHOSH_PRIVATE_KEYBOARD_EVENT_ERROR_INVALID_ARGUMENT = 0,
	/**
	 * keysym not subscribeable
	 */
	PHOSH_PRIVATE_KEYBOARD_EVENT_ERROR_INVALID_KEYSYM = 1,
	/**
	 * accelerator has already been subscribed to
	 */
	PHOSH_PRIVATE_KEYBOARD_EVENT_ERROR_ALREADY_SUBSCRIBED = 2,
	/**
	 * an miscellaneous error has occurred
	 */
	PHOSH_PRIVATE_KEYBOARD_EVENT_ERROR_MISC_ERROR = 3,
};
/**
 * @ingroup iface_phosh_private_keyboard_event
 * Validate a phosh_private_keyboard_event error value.
 *
 * @return true on success, false on error.
 * @ref phosh_private_keyboard_event_error
 */
static inline bool
phosh_private_keyboard_event_error_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case PHOSH_PRIVATE_KEYBOARD_EVENT_ERROR_INVALID_ARGUMENT:
		return version >= 1;
	case PHOSH_PRIVATE_KEYBOARD_EVENT_ERROR_INVALID_KEYSYM:
		return version >= 1;
	case PHOSH_PRIVATE_KEYBOARD_EVENT_ERROR_ALREADY_SUBSCRIBED:
		return version >= 1;
	case PHOSH_PRIVATE_KEYBOARD_EVENT_ERROR_MISC_ERROR:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* PHOSH_PRIVATE_KEYBOARD_EVENT_ERROR_ENUM */

/**
 * @ingroup iface_phosh_private_keyboard_event
 * @struct phosh_private_keyboard_event_interface
 */
struct phosh_private_keyboard_event_interface {
	/**
	 * Subscribe to an accelerator
	 *
	 * Client subscribes to a specific accelerator.
	 * @param accelerator The accelerator string (with modifiers)
	 * @since 5
	 */
	void (*grab_accelerator_request)(struct wl_client *client,
					 struct wl_resource *resource,
					 const char *accelerator);
	/**
	 * Unsubscribe to an accelerator
	 *
	 * Client unsubscribes a specific accelerator"
	 * @param action_id The action to unsubscribe
	 * @since 5
	 */
	void (*ungrab_accelerator_request)(struct wl_client *client,
					   struct wl_resource *resource,
					   uint32_t action_id);
	/**
	 * destroy the keyboard_event interface instance
	 *
	 * 
	 * @since 5
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};

#define PHOSH_PRIVATE_KEYBOARD_EVENT_ACCELERATOR_ACTIVATED_EVENT 0
#define PHOSH_PRIVATE_KEYBOARD_EVENT_GRAB_FAILED_EVENT 1
#define PHOSH_PRIVATE_KEYBOARD_EVENT_GRAB_SUCCESS_EVENT 2
#define PHOSH_PRIVATE_KEYBOARD_EVENT_UNGRAB_FAILED_EVENT 3
#define PHOSH_PRIVATE_KEYBOARD_EVENT_UNGRAB_SUCCESS_EVENT 4
#define PHOSH_PRIVATE_KEYBOARD_EVENT_ACCELERATOR_RELEASED_EVENT 5

/**
 * @ingroup iface_phosh_private_keyboard_event
 */
#define PHOSH_PRIVATE_KEYBOARD_EVENT_ACCELERATOR_ACTIVATED_EVENT_SINCE_VERSION 5
/**
 * @ingroup iface_phosh_private_keyboard_event
 */
#define PHOSH_PRIVATE_KEYBOARD_EVENT_GRAB_FAILED_EVENT_SINCE_VERSION 5
/**
 * @ingroup iface_phosh_private_keyboard_event
 */
#define PHOSH_PRIVATE_KEYBOARD_EVENT_GRAB_SUCCESS_EVENT_SINCE_VERSION 5
/**
 * @ingroup iface_phosh_private_keyboard_event
 */
#define PHOSH_PRIVATE_KEYBOARD_EVENT_UNGRAB_FAILED_EVENT_SINCE_VERSION 5
/**
 * @ingroup iface_phosh_private_keyboard_event
 */
#define PHOSH_PRIVATE_KEYBOARD_EVENT_UNGRAB_SUCCESS_EVENT_SINCE_VERSION 5
/**
 * @ingroup iface_phosh_private_keyboard_event
 */
#define PHOSH_PRIVATE_KEYBOARD_EVENT_ACCELERATOR_RELEASED_EVENT_SINCE_VERSION 7

/**
 * @ingroup iface_phosh_private_keyboard_event
 */
#define PHOSH_PRIVATE_KEYBOARD_EVENT_GRAB_ACCELERATOR_REQUEST_SINCE_VERSION 5
/**
 * @ingroup iface_phosh_private_keyboard_event
 */
#define PHOSH_PRIVATE_KEYBOARD_EVENT_UNGRAB_ACCELERATOR_REQUEST_SINCE_VERSION 5
/**
 * @ingroup iface_phosh_private_keyboard_event
 */
#define PHOSH_PRIVATE_KEYBOARD_EVENT_DESTROY_SINCE_VERSION 5

/**
 * @ingroup iface_phosh_private_keyboard_event
 * Sends an accelerator_activated_event event to the client owning the resource.
 * @param resource_ The client's resource
 * @param action_id The previously assigned action_id
 * @param timestamp The timestamp when the key has been pressed
 */
static inline void
phosh_private_keyboard_event_send_accelerator_activated_event(struct wl_resource *resource_, uint32_t action_id, uint32_t timestamp)
{
	wl_resource_post_event(resource_, PHOSH_PRIVATE_KEYBOARD_EVENT_ACCELERATOR_ACTIVATED_EVENT, action_id, timestamp);
}

/**
 * @ingroup iface_phosh_private_keyboard_event
 * Sends an grab_failed_event event to the client owning the resource.
 * @param resource_ The client's resource
 * @param accelerator The failed accelerator
 * @param error The error code
 */
static inline void
phosh_private_keyboard_event_send_grab_failed_event(struct wl_resource *resource_, const char *accelerator, uint32_t error)
{
	wl_resource_post_event(resource_, PHOSH_PRIVATE_KEYBOARD_EVENT_GRAB_FAILED_EVENT, accelerator, error);
}

/**
 * @ingroup iface_phosh_private_keyboard_event
 * Sends an grab_success_event event to the client owning the resource.
 * @param resource_ The client's resource
 * @param accelerator The subscribed accelerator
 * @param action_id The id that has been assigned to the accelerator
 */
static inline void
phosh_private_keyboard_event_send_grab_success_event(struct wl_resource *resource_, const char *accelerator, uint32_t action_id)
{
	wl_resource_post_event(resource_, PHOSH_PRIVATE_KEYBOARD_EVENT_GRAB_SUCCESS_EVENT, accelerator, action_id);
}

/**
 * @ingroup iface_phosh_private_keyboard_event
 * Sends an ungrab_failed_event event to the client owning the resource.
 * @param resource_ The client's resource
 * @param action_id The failed action
 * @param error The error code
 */
static inline void
phosh_private_keyboard_event_send_ungrab_failed_event(struct wl_resource *resource_, uint32_t action_id, uint32_t error)
{
	wl_resource_post_event(resource_, PHOSH_PRIVATE_KEYBOARD_EVENT_UNGRAB_FAILED_EVENT, action_id, error);
}

/**
 * @ingroup iface_phosh_private_keyboard_event
 * Sends an ungrab_success_event event to the client owning the resource.
 * @param resource_ The client's resource
 * @param action The unsubscribed action
 */
static inline void
phosh_private_keyboard_event_send_ungrab_success_event(struct wl_resource *resource_, uint32_t action)
{
	wl_resource_post_event(resource_, PHOSH_PRIVATE_KEYBOARD_EVENT_UNGRAB_SUCCESS_EVENT, action);
}

/**
 * @ingroup iface_phosh_private_keyboard_event
 * Sends an accelerator_released_event event to the client owning the resource.
 * @param resource_ The client's resource
 * @param action_id The previously assigned action_id
 * @param timestamp The timestamp when the key has been released
 */
static inline void
phosh_private_keyboard_event_send_accelerator_released_event(struct wl_resource *resource_, uint32_t action_id, uint32_t timestamp)
{
	wl_resource_post_event(resource_, PHOSH_PRIVATE_KEYBOARD_EVENT_ACCELERATOR_RELEASED_EVENT, action_id, timestamp);
}

#ifndef PHOSH_PRIVATE_XDG_SWITCHER_ERROR_ENUM
#define PHOSH_PRIVATE_XDG_SWITCHER_ERROR_ENUM
enum phosh_private_xdg_switcher_error {
	/**
	 * an invalid argument was provided in a request
	 */
	PHOSH_PRIVATE_XDG_SWITCHER_ERROR_INVALID_ARGUMENT = 0,
};
/**
 * @ingroup iface_phosh_private_xdg_switcher
 * Validate a phosh_private_xdg_switcher error value.
 *
 * @return true on success, false on error.
 * @ref phosh_private_xdg_switcher_error
 */
static inline bool
phosh_private_xdg_switcher_error_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case PHOSH_PRIVATE_XDG_SWITCHER_ERROR_INVALID_ARGUMENT:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* PHOSH_PRIVATE_XDG_SWITCHER_ERROR_ENUM */

/**
 * @ingroup iface_phosh_private_xdg_switcher
 * @struct phosh_private_xdg_switcher_interface
 */
struct phosh_private_xdg_switcher_interface {
	/**
	 * Get current xdg surfaces
	 *
	 * 
	 * @since 2
	 */
	void (*list_xdg_surfaces)(struct wl_client *client,
				  struct wl_resource *resource);
	/**
	 * destroy the xdg_switcher interface instance
	 *
	 * 
	 * @since 2
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * raise the given xdg surface to the top of the stack
	 *
	 * 
	 * @param app_id The app_id of the xdg surface
	 * @param title The title of the xdg surface
	 * @since 2
	 */
	void (*raise_xdg_surface)(struct wl_client *client,
				  struct wl_resource *resource,
				  const char *app_id,
				  const char *title);
	/**
	 * close the given xdg surface
	 *
	 * 
	 * @param app_id The app_id of the xdg surface
	 * @param title The title of the xdg surface
	 * @since 3
	 */
	void (*close_xdg_surface)(struct wl_client *client,
				  struct wl_resource *resource,
				  const char *app_id,
				  const char *title);
};

#define PHOSH_PRIVATE_XDG_SWITCHER_XDG_SURFACE 0
#define PHOSH_PRIVATE_XDG_SWITCHER_LIST_XDG_SURFACES_DONE 1

/**
 * @ingroup iface_phosh_private_xdg_switcher
 */
#define PHOSH_PRIVATE_XDG_SWITCHER_XDG_SURFACE_SINCE_VERSION 2
/**
 * @ingroup iface_phosh_private_xdg_switcher
 */
#define PHOSH_PRIVATE_XDG_SWITCHER_LIST_XDG_SURFACES_DONE_SINCE_VERSION 2

/**
 * @ingroup iface_phosh_private_xdg_switcher
 */
#define PHOSH_PRIVATE_XDG_SWITCHER_LIST_XDG_SURFACES_SINCE_VERSION 2
/**
 * @ingroup iface_phosh_private_xdg_switcher
 */
#define PHOSH_PRIVATE_XDG_SWITCHER_DESTROY_SINCE_VERSION 2
/**
 * @ingroup iface_phosh_private_xdg_switcher
 */
#define PHOSH_PRIVATE_XDG_SWITCHER_RAISE_XDG_SURFACE_SINCE_VERSION 2
/**
 * @ingroup iface_phosh_private_xdg_switcher
 */
#define PHOSH_PRIVATE_XDG_SWITCHER_CLOSE_XDG_SURFACE_SINCE_VERSION 3

/**
 * @ingroup iface_phosh_private_xdg_switcher
 * Sends an xdg_surface event to the client owning the resource.
 * @param resource_ The client's resource
 * @param app_id the app_id of the xdg surface
 * @param title the title of the xdg surface
 */
static inline void
phosh_private_xdg_switcher_send_xdg_surface(struct wl_resource *resource_, const char *app_id, const char *title)
{
	wl_resource_post_event(resource_, PHOSH_PRIVATE_XDG_SWITCHER_XDG_SURFACE, app_id, title);
}

/**
 * @ingroup iface_phosh_private_xdg_switcher
 * Sends an list_xdg_surfaces_done event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
phosh_private_xdg_switcher_send_list_xdg_surfaces_done(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, PHOSH_PRIVATE_XDG_SWITCHER_LIST_XDG_SURFACES_DONE);
}

#ifndef PHOSH_PRIVATE_STARTUP_TRACKER_FLAG_ENUM
#define PHOSH_PRIVATE_STARTUP_TRACKER_FLAG_ENUM
enum phosh_private_startup_tracker_flag {
	/**
	 * no flags
	 */
	PHOSH_PRIVATE_STARTUP_TRACKER_FLAG_NONE = 0,
};
/**
 * @ingroup iface_phosh_private_startup_tracker
 * Validate a phosh_private_startup_tracker flag value.
 *
 * @return true on success, false on error.
 * @ref phosh_private_startup_tracker_flag
 */
static inline bool
phosh_private_startup_tracker_flag_is_valid(uint32_t value, uint32_t version) {
	uint32_t valid = 0;
	if (version >= 1)
		valid |= PHOSH_PRIVATE_STARTUP_TRACKER_FLAG_NONE;
	return (value & ~valid) == 0;
}
#endif /* PHOSH_PRIVATE_STARTUP_TRACKER_FLAG_ENUM */

#ifndef PHOSH_PRIVATE_STARTUP_TRACKER_PROTOCOL_ENUM
#define PHOSH_PRIVATE_STARTUP_TRACKER_PROTOCOL_ENUM
enum phosh_private_startup_tracker_protocol {
	/**
	 * unknown protocol
	 */
	PHOSH_PRIVATE_STARTUP_TRACKER_PROTOCOL_UNKNOWN = 0,
	/**
	 * x11 startup notification protocol
	 */
	PHOSH_PRIVATE_STARTUP_TRACKER_PROTOCOL_X11 = 1,
	/**
	 * gtk_shell protocol
	 */
	PHOSH_PRIVATE_STARTUP_TRACKER_PROTOCOL_GTK_SHELL = 2,
	/**
	 * xdg_activation protocol
	 */
	PHOSH_PRIVATE_STARTUP_TRACKER_PROTOCOL_XDG_ACTIVATION = 3,
};
/**
 * @ingroup iface_phosh_private_startup_tracker
 * Validate a phosh_private_startup_tracker protocol value.
 *
 * @return true on success, false on error.
 * @ref phosh_private_startup_tracker_protocol
 */
static inline bool
phosh_private_startup_tracker_protocol_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case PHOSH_PRIVATE_STARTUP_TRACKER_PROTOCOL_UNKNOWN:
		return version >= 1;
	case PHOSH_PRIVATE_STARTUP_TRACKER_PROTOCOL_X11:
		return version >= 1;
	case PHOSH_PRIVATE_STARTUP_TRACKER_PROTOCOL_GTK_SHELL:
		return version >= 1;
	case PHOSH_PRIVATE_STARTUP_TRACKER_PROTOCOL_XDG_ACTIVATION:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* PHOSH_PRIVATE_STARTUP_TRACKER_PROTOCOL_ENUM */

/**
 * @ingroup iface_phosh_private_startup_tracker
 * @struct phosh_private_startup_tracker_interface
 */
struct phosh_private_startup_tracker_interface {
	/**
	 * destroy the startup_tracker interface instance
	 *
	 * The Client should invoke this when done using the interface.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};

#define PHOSH_PRIVATE_STARTUP_TRACKER_STARTUP_ID 0
#define PHOSH_PRIVATE_STARTUP_TRACKER_LAUNCHED 1

/**
 * @ingroup iface_phosh_private_startup_tracker
 */
#define PHOSH_PRIVATE_STARTUP_TRACKER_STARTUP_ID_SINCE_VERSION 1
/**
 * @ingroup iface_phosh_private_startup_tracker
 */
#define PHOSH_PRIVATE_STARTUP_TRACKER_LAUNCHED_SINCE_VERSION 1

/**
 * @ingroup iface_phosh_private_startup_tracker
 */
#define PHOSH_PRIVATE_STARTUP_TRACKER_DESTROY_SINCE_VERSION 1

/**
 * @ingroup iface_phosh_private_startup_tracker
 * Sends an startup_id event to the client owning the resource.
 * @param resource_ The client's resource
 * @param startup_id The startup_id
 * @param protocol The protocol
 * @param flags flags
 */
static inline void
phosh_private_startup_tracker_send_startup_id(struct wl_resource *resource_, const char *startup_id, uint32_t protocol, uint32_t flags)
{
	wl_resource_post_event(resource_, PHOSH_PRIVATE_STARTUP_TRACKER_STARTUP_ID, startup_id, protocol, flags);
}

/**
 * @ingroup iface_phosh_private_startup_tracker
 * Sends an launched event to the client owning the resource.
 * @param resource_ The client's resource
 * @param startup_id The startup_id
 * @param protocol The protocol
 * @param flags flags
 */
static inline void
phosh_private_startup_tracker_send_launched(struct wl_resource *resource_, const char *startup_id, uint32_t protocol, uint32_t flags)
{
	wl_resource_post_event(resource_, PHOSH_PRIVATE_STARTUP_TRACKER_LAUNCHED, startup_id, protocol, flags);
}

#ifdef  __cplusplus
}
#endif

#endif
