/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "phosh-screenshot-dbus.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOOLEAN_BOOLEAN_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectBooleanBooleanStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        gboolean arg_include_cursor,
        gboolean arg_flash,
        const gchar *arg_filename,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectBooleanBooleanStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 5);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectBooleanBooleanStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_boolean (param_values + 2),
              g_marshal_value_peek_boolean (param_values + 3),
              g_marshal_value_peek_string (param_values + 4),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOOLEAN_BOOLEAN_BOOLEAN_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectBooleanBooleanBooleanStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        gboolean arg_include_frame,
        gboolean arg_include_cursor,
        gboolean arg_flash,
        const gchar *arg_filename,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectBooleanBooleanBooleanStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 6);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectBooleanBooleanBooleanStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_boolean (param_values + 2),
              g_marshal_value_peek_boolean (param_values + 3),
              g_marshal_value_peek_boolean (param_values + 4),
              g_marshal_value_peek_string (param_values + 5),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_INT_INT_INT_INT_BOOLEAN_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectIntIntIntIntBooleanStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        gint arg_x,
        gint arg_y,
        gint arg_width,
        gint arg_height,
        gboolean arg_flash,
        const gchar *arg_filename,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectIntIntIntIntBooleanStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 8);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectIntIntIntIntBooleanStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_int (param_values + 2),
              g_marshal_value_peek_int (param_values + 3),
              g_marshal_value_peek_int (param_values + 4),
              g_marshal_value_peek_int (param_values + 5),
              g_marshal_value_peek_boolean (param_values + 6),
              g_marshal_value_peek_string (param_values + 7),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 2);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_INT_INT_INT_INT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectIntIntIntIntFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        gint arg_x,
        gint arg_y,
        gint arg_width,
        gint arg_height,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectIntIntIntIntFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 6);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectIntIntIntIntFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_int (param_values + 2),
              g_marshal_value_peek_int (param_values + 3),
              g_marshal_value_peek_int (param_values + 4),
              g_marshal_value_peek_int (param_values + 5),
              data2);

  g_value_set_boolean (return_value, v_return);
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.Shell.Screenshot
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:PhoshDBusScreenshot
 * @title: PhoshDBusScreenshot
 * @short_description: Generated C code for the org.gnome.Shell.Screenshot D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-Shell-Screenshot.top_of_page">org.gnome.Shell.Screenshot</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.gnome.Shell.Screenshot ---- */

static const _ExtendedGDBusArgInfo _phosh_dbus_screenshot_method_info_screenshot_IN_ARG_include_cursor =
{
  {
    -1,
    (gchar *) "include_cursor",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _phosh_dbus_screenshot_method_info_screenshot_IN_ARG_flash =
{
  {
    -1,
    (gchar *) "flash",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _phosh_dbus_screenshot_method_info_screenshot_IN_ARG_filename =
{
  {
    -1,
    (gchar *) "filename",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _phosh_dbus_screenshot_method_info_screenshot_IN_ARG_pointers[] =
{
  &_phosh_dbus_screenshot_method_info_screenshot_IN_ARG_include_cursor.parent_struct,
  &_phosh_dbus_screenshot_method_info_screenshot_IN_ARG_flash.parent_struct,
  &_phosh_dbus_screenshot_method_info_screenshot_IN_ARG_filename.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _phosh_dbus_screenshot_method_info_screenshot_OUT_ARG_success =
{
  {
    -1,
    (gchar *) "success",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _phosh_dbus_screenshot_method_info_screenshot_OUT_ARG_filename_used =
{
  {
    -1,
    (gchar *) "filename_used",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _phosh_dbus_screenshot_method_info_screenshot_OUT_ARG_pointers[] =
{
  &_phosh_dbus_screenshot_method_info_screenshot_OUT_ARG_success.parent_struct,
  &_phosh_dbus_screenshot_method_info_screenshot_OUT_ARG_filename_used.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _phosh_dbus_screenshot_method_info_screenshot =
{
  {
    -1,
    (gchar *) "Screenshot",
    (GDBusArgInfo **) &_phosh_dbus_screenshot_method_info_screenshot_IN_ARG_pointers,
    (GDBusArgInfo **) &_phosh_dbus_screenshot_method_info_screenshot_OUT_ARG_pointers,
    NULL
  },
  "handle-screenshot",
  FALSE
};

static const _ExtendedGDBusArgInfo _phosh_dbus_screenshot_method_info_screenshot_window_IN_ARG_include_frame =
{
  {
    -1,
    (gchar *) "include_frame",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _phosh_dbus_screenshot_method_info_screenshot_window_IN_ARG_include_cursor =
{
  {
    -1,
    (gchar *) "include_cursor",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _phosh_dbus_screenshot_method_info_screenshot_window_IN_ARG_flash =
{
  {
    -1,
    (gchar *) "flash",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _phosh_dbus_screenshot_method_info_screenshot_window_IN_ARG_filename =
{
  {
    -1,
    (gchar *) "filename",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _phosh_dbus_screenshot_method_info_screenshot_window_IN_ARG_pointers[] =
{
  &_phosh_dbus_screenshot_method_info_screenshot_window_IN_ARG_include_frame.parent_struct,
  &_phosh_dbus_screenshot_method_info_screenshot_window_IN_ARG_include_cursor.parent_struct,
  &_phosh_dbus_screenshot_method_info_screenshot_window_IN_ARG_flash.parent_struct,
  &_phosh_dbus_screenshot_method_info_screenshot_window_IN_ARG_filename.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _phosh_dbus_screenshot_method_info_screenshot_window_OUT_ARG_success =
{
  {
    -1,
    (gchar *) "success",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _phosh_dbus_screenshot_method_info_screenshot_window_OUT_ARG_filename_used =
{
  {
    -1,
    (gchar *) "filename_used",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _phosh_dbus_screenshot_method_info_screenshot_window_OUT_ARG_pointers[] =
{
  &_phosh_dbus_screenshot_method_info_screenshot_window_OUT_ARG_success.parent_struct,
  &_phosh_dbus_screenshot_method_info_screenshot_window_OUT_ARG_filename_used.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _phosh_dbus_screenshot_method_info_screenshot_window =
{
  {
    -1,
    (gchar *) "ScreenshotWindow",
    (GDBusArgInfo **) &_phosh_dbus_screenshot_method_info_screenshot_window_IN_ARG_pointers,
    (GDBusArgInfo **) &_phosh_dbus_screenshot_method_info_screenshot_window_OUT_ARG_pointers,
    NULL
  },
  "handle-screenshot-window",
  FALSE
};

static const _ExtendedGDBusArgInfo _phosh_dbus_screenshot_method_info_screenshot_area_IN_ARG_x =
{
  {
    -1,
    (gchar *) "x",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _phosh_dbus_screenshot_method_info_screenshot_area_IN_ARG_y =
{
  {
    -1,
    (gchar *) "y",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _phosh_dbus_screenshot_method_info_screenshot_area_IN_ARG_width =
{
  {
    -1,
    (gchar *) "width",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _phosh_dbus_screenshot_method_info_screenshot_area_IN_ARG_height =
{
  {
    -1,
    (gchar *) "height",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _phosh_dbus_screenshot_method_info_screenshot_area_IN_ARG_flash =
{
  {
    -1,
    (gchar *) "flash",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _phosh_dbus_screenshot_method_info_screenshot_area_IN_ARG_filename =
{
  {
    -1,
    (gchar *) "filename",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _phosh_dbus_screenshot_method_info_screenshot_area_IN_ARG_pointers[] =
{
  &_phosh_dbus_screenshot_method_info_screenshot_area_IN_ARG_x.parent_struct,
  &_phosh_dbus_screenshot_method_info_screenshot_area_IN_ARG_y.parent_struct,
  &_phosh_dbus_screenshot_method_info_screenshot_area_IN_ARG_width.parent_struct,
  &_phosh_dbus_screenshot_method_info_screenshot_area_IN_ARG_height.parent_struct,
  &_phosh_dbus_screenshot_method_info_screenshot_area_IN_ARG_flash.parent_struct,
  &_phosh_dbus_screenshot_method_info_screenshot_area_IN_ARG_filename.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _phosh_dbus_screenshot_method_info_screenshot_area_OUT_ARG_success =
{
  {
    -1,
    (gchar *) "success",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _phosh_dbus_screenshot_method_info_screenshot_area_OUT_ARG_filename_used =
{
  {
    -1,
    (gchar *) "filename_used",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _phosh_dbus_screenshot_method_info_screenshot_area_OUT_ARG_pointers[] =
{
  &_phosh_dbus_screenshot_method_info_screenshot_area_OUT_ARG_success.parent_struct,
  &_phosh_dbus_screenshot_method_info_screenshot_area_OUT_ARG_filename_used.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _phosh_dbus_screenshot_method_info_screenshot_area =
{
  {
    -1,
    (gchar *) "ScreenshotArea",
    (GDBusArgInfo **) &_phosh_dbus_screenshot_method_info_screenshot_area_IN_ARG_pointers,
    (GDBusArgInfo **) &_phosh_dbus_screenshot_method_info_screenshot_area_OUT_ARG_pointers,
    NULL
  },
  "handle-screenshot-area",
  FALSE
};

static const _ExtendedGDBusArgInfo _phosh_dbus_screenshot_method_info_pick_color_OUT_ARG_result =
{
  {
    -1,
    (gchar *) "result",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _phosh_dbus_screenshot_method_info_pick_color_OUT_ARG_pointers[] =
{
  &_phosh_dbus_screenshot_method_info_pick_color_OUT_ARG_result.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _phosh_dbus_screenshot_method_info_pick_color =
{
  {
    -1,
    (gchar *) "PickColor",
    NULL,
    (GDBusArgInfo **) &_phosh_dbus_screenshot_method_info_pick_color_OUT_ARG_pointers,
    NULL
  },
  "handle-pick-color",
  FALSE
};

static const _ExtendedGDBusArgInfo _phosh_dbus_screenshot_method_info_flash_area_IN_ARG_x =
{
  {
    -1,
    (gchar *) "x",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _phosh_dbus_screenshot_method_info_flash_area_IN_ARG_y =
{
  {
    -1,
    (gchar *) "y",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _phosh_dbus_screenshot_method_info_flash_area_IN_ARG_width =
{
  {
    -1,
    (gchar *) "width",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _phosh_dbus_screenshot_method_info_flash_area_IN_ARG_height =
{
  {
    -1,
    (gchar *) "height",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _phosh_dbus_screenshot_method_info_flash_area_IN_ARG_pointers[] =
{
  &_phosh_dbus_screenshot_method_info_flash_area_IN_ARG_x.parent_struct,
  &_phosh_dbus_screenshot_method_info_flash_area_IN_ARG_y.parent_struct,
  &_phosh_dbus_screenshot_method_info_flash_area_IN_ARG_width.parent_struct,
  &_phosh_dbus_screenshot_method_info_flash_area_IN_ARG_height.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _phosh_dbus_screenshot_method_info_flash_area =
{
  {
    -1,
    (gchar *) "FlashArea",
    (GDBusArgInfo **) &_phosh_dbus_screenshot_method_info_flash_area_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-flash-area",
  FALSE
};

static const _ExtendedGDBusArgInfo _phosh_dbus_screenshot_method_info_select_area_OUT_ARG_x =
{
  {
    -1,
    (gchar *) "x",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _phosh_dbus_screenshot_method_info_select_area_OUT_ARG_y =
{
  {
    -1,
    (gchar *) "y",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _phosh_dbus_screenshot_method_info_select_area_OUT_ARG_width =
{
  {
    -1,
    (gchar *) "width",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _phosh_dbus_screenshot_method_info_select_area_OUT_ARG_height =
{
  {
    -1,
    (gchar *) "height",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _phosh_dbus_screenshot_method_info_select_area_OUT_ARG_pointers[] =
{
  &_phosh_dbus_screenshot_method_info_select_area_OUT_ARG_x.parent_struct,
  &_phosh_dbus_screenshot_method_info_select_area_OUT_ARG_y.parent_struct,
  &_phosh_dbus_screenshot_method_info_select_area_OUT_ARG_width.parent_struct,
  &_phosh_dbus_screenshot_method_info_select_area_OUT_ARG_height.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _phosh_dbus_screenshot_method_info_select_area =
{
  {
    -1,
    (gchar *) "SelectArea",
    NULL,
    (GDBusArgInfo **) &_phosh_dbus_screenshot_method_info_select_area_OUT_ARG_pointers,
    NULL
  },
  "handle-select-area",
  FALSE
};

static const GDBusMethodInfo * const _phosh_dbus_screenshot_method_info_pointers[] =
{
  &_phosh_dbus_screenshot_method_info_screenshot.parent_struct,
  &_phosh_dbus_screenshot_method_info_screenshot_window.parent_struct,
  &_phosh_dbus_screenshot_method_info_screenshot_area.parent_struct,
  &_phosh_dbus_screenshot_method_info_pick_color.parent_struct,
  &_phosh_dbus_screenshot_method_info_flash_area.parent_struct,
  &_phosh_dbus_screenshot_method_info_select_area.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _phosh_dbus_screenshot_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.Shell.Screenshot",
    (GDBusMethodInfo **) &_phosh_dbus_screenshot_method_info_pointers,
    NULL,
    NULL,
    NULL
  },
  "screenshot",
};


/**
 * phosh_dbus_screenshot_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-Shell-Screenshot.top_of_page">org.gnome.Shell.Screenshot</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
phosh_dbus_screenshot_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_phosh_dbus_screenshot_interface_info.parent_struct;
}

/**
 * phosh_dbus_screenshot_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #PhoshDBusScreenshot interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
phosh_dbus_screenshot_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
phosh_dbus_screenshot_method_marshal_screenshot (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOOLEAN_BOOLEAN_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
phosh_dbus_screenshot_method_marshal_screenshot_window (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOOLEAN_BOOLEAN_BOOLEAN_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
phosh_dbus_screenshot_method_marshal_screenshot_area (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_INT_INT_INT_INT_BOOLEAN_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
phosh_dbus_screenshot_method_marshal_pick_color (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
phosh_dbus_screenshot_method_marshal_flash_area (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_INT_INT_INT_INT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
phosh_dbus_screenshot_method_marshal_select_area (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * PhoshDBusScreenshot:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Shell-Screenshot.top_of_page">org.gnome.Shell.Screenshot</link>.
 */

/**
 * PhoshDBusScreenshotIface:
 * @parent_iface: The parent interface.
 * @handle_flash_area: Handler for the #PhoshDBusScreenshot::handle-flash-area signal.
 * @handle_pick_color: Handler for the #PhoshDBusScreenshot::handle-pick-color signal.
 * @handle_screenshot: Handler for the #PhoshDBusScreenshot::handle-screenshot signal.
 * @handle_screenshot_area: Handler for the #PhoshDBusScreenshot::handle-screenshot-area signal.
 * @handle_screenshot_window: Handler for the #PhoshDBusScreenshot::handle-screenshot-window signal.
 * @handle_select_area: Handler for the #PhoshDBusScreenshot::handle-select-area signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Shell-Screenshot.top_of_page">org.gnome.Shell.Screenshot</link>.
 */

typedef PhoshDBusScreenshotIface PhoshDBusScreenshotInterface;
G_DEFINE_INTERFACE (PhoshDBusScreenshot, phosh_dbus_screenshot, G_TYPE_OBJECT)

static void
phosh_dbus_screenshot_default_init (PhoshDBusScreenshotIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * PhoshDBusScreenshot::handle-screenshot:
   * @object: A #PhoshDBusScreenshot.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_include_cursor: Argument passed by remote caller.
   * @arg_flash: Argument passed by remote caller.
   * @arg_filename: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.Screenshot">Screenshot()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call phosh_dbus_screenshot_complete_screenshot() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-screenshot",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (PhoshDBusScreenshotIface, handle_screenshot),
    g_signal_accumulator_true_handled,
    NULL,
      phosh_dbus_screenshot_method_marshal_screenshot,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_BOOLEAN, G_TYPE_BOOLEAN, G_TYPE_STRING);

  /**
   * PhoshDBusScreenshot::handle-screenshot-window:
   * @object: A #PhoshDBusScreenshot.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_include_frame: Argument passed by remote caller.
   * @arg_include_cursor: Argument passed by remote caller.
   * @arg_flash: Argument passed by remote caller.
   * @arg_filename: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.ScreenshotWindow">ScreenshotWindow()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call phosh_dbus_screenshot_complete_screenshot_window() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-screenshot-window",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (PhoshDBusScreenshotIface, handle_screenshot_window),
    g_signal_accumulator_true_handled,
    NULL,
      phosh_dbus_screenshot_method_marshal_screenshot_window,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_BOOLEAN, G_TYPE_BOOLEAN, G_TYPE_BOOLEAN, G_TYPE_STRING);

  /**
   * PhoshDBusScreenshot::handle-screenshot-area:
   * @object: A #PhoshDBusScreenshot.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_x: Argument passed by remote caller.
   * @arg_y: Argument passed by remote caller.
   * @arg_width: Argument passed by remote caller.
   * @arg_height: Argument passed by remote caller.
   * @arg_flash: Argument passed by remote caller.
   * @arg_filename: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.ScreenshotArea">ScreenshotArea()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call phosh_dbus_screenshot_complete_screenshot_area() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-screenshot-area",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (PhoshDBusScreenshotIface, handle_screenshot_area),
    g_signal_accumulator_true_handled,
    NULL,
      phosh_dbus_screenshot_method_marshal_screenshot_area,
    G_TYPE_BOOLEAN,
    7,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT, G_TYPE_BOOLEAN, G_TYPE_STRING);

  /**
   * PhoshDBusScreenshot::handle-pick-color:
   * @object: A #PhoshDBusScreenshot.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.PickColor">PickColor()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call phosh_dbus_screenshot_complete_pick_color() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-pick-color",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (PhoshDBusScreenshotIface, handle_pick_color),
    g_signal_accumulator_true_handled,
    NULL,
      phosh_dbus_screenshot_method_marshal_pick_color,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * PhoshDBusScreenshot::handle-flash-area:
   * @object: A #PhoshDBusScreenshot.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_x: Argument passed by remote caller.
   * @arg_y: Argument passed by remote caller.
   * @arg_width: Argument passed by remote caller.
   * @arg_height: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.FlashArea">FlashArea()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call phosh_dbus_screenshot_complete_flash_area() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-flash-area",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (PhoshDBusScreenshotIface, handle_flash_area),
    g_signal_accumulator_true_handled,
    NULL,
      phosh_dbus_screenshot_method_marshal_flash_area,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT);

  /**
   * PhoshDBusScreenshot::handle-select-area:
   * @object: A #PhoshDBusScreenshot.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.SelectArea">SelectArea()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call phosh_dbus_screenshot_complete_select_area() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-select-area",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (PhoshDBusScreenshotIface, handle_select_area),
    g_signal_accumulator_true_handled,
    NULL,
      phosh_dbus_screenshot_method_marshal_select_area,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

}

/**
 * phosh_dbus_screenshot_call_screenshot:
 * @proxy: A #PhoshDBusScreenshotProxy.
 * @arg_include_cursor: Argument to pass with the method invocation.
 * @arg_flash: Argument to pass with the method invocation.
 * @arg_filename: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.Screenshot">Screenshot()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call phosh_dbus_screenshot_call_screenshot_finish() to get the result of the operation.
 *
 * See phosh_dbus_screenshot_call_screenshot_sync() for the synchronous, blocking version of this method.
 */
void
phosh_dbus_screenshot_call_screenshot (
    PhoshDBusScreenshot *proxy,
    gboolean arg_include_cursor,
    gboolean arg_flash,
    const gchar *arg_filename,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Screenshot",
    g_variant_new ("(bbs)",
                   arg_include_cursor,
                   arg_flash,
                   arg_filename),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * phosh_dbus_screenshot_call_screenshot_finish:
 * @proxy: A #PhoshDBusScreenshotProxy.
 * @out_success: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_filename_used: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to phosh_dbus_screenshot_call_screenshot().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with phosh_dbus_screenshot_call_screenshot().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
phosh_dbus_screenshot_call_screenshot_finish (
    PhoshDBusScreenshot *proxy,
    gboolean *out_success,
    gchar **out_filename_used,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(bs)",
                 out_success,
                 out_filename_used);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * phosh_dbus_screenshot_call_screenshot_sync:
 * @proxy: A #PhoshDBusScreenshotProxy.
 * @arg_include_cursor: Argument to pass with the method invocation.
 * @arg_flash: Argument to pass with the method invocation.
 * @arg_filename: Argument to pass with the method invocation.
 * @out_success: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_filename_used: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.Screenshot">Screenshot()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See phosh_dbus_screenshot_call_screenshot() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
phosh_dbus_screenshot_call_screenshot_sync (
    PhoshDBusScreenshot *proxy,
    gboolean arg_include_cursor,
    gboolean arg_flash,
    const gchar *arg_filename,
    gboolean *out_success,
    gchar **out_filename_used,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Screenshot",
    g_variant_new ("(bbs)",
                   arg_include_cursor,
                   arg_flash,
                   arg_filename),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(bs)",
                 out_success,
                 out_filename_used);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * phosh_dbus_screenshot_call_screenshot_window:
 * @proxy: A #PhoshDBusScreenshotProxy.
 * @arg_include_frame: Argument to pass with the method invocation.
 * @arg_include_cursor: Argument to pass with the method invocation.
 * @arg_flash: Argument to pass with the method invocation.
 * @arg_filename: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.ScreenshotWindow">ScreenshotWindow()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call phosh_dbus_screenshot_call_screenshot_window_finish() to get the result of the operation.
 *
 * See phosh_dbus_screenshot_call_screenshot_window_sync() for the synchronous, blocking version of this method.
 */
void
phosh_dbus_screenshot_call_screenshot_window (
    PhoshDBusScreenshot *proxy,
    gboolean arg_include_frame,
    gboolean arg_include_cursor,
    gboolean arg_flash,
    const gchar *arg_filename,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ScreenshotWindow",
    g_variant_new ("(bbbs)",
                   arg_include_frame,
                   arg_include_cursor,
                   arg_flash,
                   arg_filename),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * phosh_dbus_screenshot_call_screenshot_window_finish:
 * @proxy: A #PhoshDBusScreenshotProxy.
 * @out_success: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_filename_used: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to phosh_dbus_screenshot_call_screenshot_window().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with phosh_dbus_screenshot_call_screenshot_window().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
phosh_dbus_screenshot_call_screenshot_window_finish (
    PhoshDBusScreenshot *proxy,
    gboolean *out_success,
    gchar **out_filename_used,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(bs)",
                 out_success,
                 out_filename_used);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * phosh_dbus_screenshot_call_screenshot_window_sync:
 * @proxy: A #PhoshDBusScreenshotProxy.
 * @arg_include_frame: Argument to pass with the method invocation.
 * @arg_include_cursor: Argument to pass with the method invocation.
 * @arg_flash: Argument to pass with the method invocation.
 * @arg_filename: Argument to pass with the method invocation.
 * @out_success: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_filename_used: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.ScreenshotWindow">ScreenshotWindow()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See phosh_dbus_screenshot_call_screenshot_window() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
phosh_dbus_screenshot_call_screenshot_window_sync (
    PhoshDBusScreenshot *proxy,
    gboolean arg_include_frame,
    gboolean arg_include_cursor,
    gboolean arg_flash,
    const gchar *arg_filename,
    gboolean *out_success,
    gchar **out_filename_used,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ScreenshotWindow",
    g_variant_new ("(bbbs)",
                   arg_include_frame,
                   arg_include_cursor,
                   arg_flash,
                   arg_filename),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(bs)",
                 out_success,
                 out_filename_used);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * phosh_dbus_screenshot_call_screenshot_area:
 * @proxy: A #PhoshDBusScreenshotProxy.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @arg_width: Argument to pass with the method invocation.
 * @arg_height: Argument to pass with the method invocation.
 * @arg_flash: Argument to pass with the method invocation.
 * @arg_filename: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.ScreenshotArea">ScreenshotArea()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call phosh_dbus_screenshot_call_screenshot_area_finish() to get the result of the operation.
 *
 * See phosh_dbus_screenshot_call_screenshot_area_sync() for the synchronous, blocking version of this method.
 */
void
phosh_dbus_screenshot_call_screenshot_area (
    PhoshDBusScreenshot *proxy,
    gint arg_x,
    gint arg_y,
    gint arg_width,
    gint arg_height,
    gboolean arg_flash,
    const gchar *arg_filename,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ScreenshotArea",
    g_variant_new ("(iiiibs)",
                   arg_x,
                   arg_y,
                   arg_width,
                   arg_height,
                   arg_flash,
                   arg_filename),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * phosh_dbus_screenshot_call_screenshot_area_finish:
 * @proxy: A #PhoshDBusScreenshotProxy.
 * @out_success: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_filename_used: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to phosh_dbus_screenshot_call_screenshot_area().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with phosh_dbus_screenshot_call_screenshot_area().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
phosh_dbus_screenshot_call_screenshot_area_finish (
    PhoshDBusScreenshot *proxy,
    gboolean *out_success,
    gchar **out_filename_used,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(bs)",
                 out_success,
                 out_filename_used);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * phosh_dbus_screenshot_call_screenshot_area_sync:
 * @proxy: A #PhoshDBusScreenshotProxy.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @arg_width: Argument to pass with the method invocation.
 * @arg_height: Argument to pass with the method invocation.
 * @arg_flash: Argument to pass with the method invocation.
 * @arg_filename: Argument to pass with the method invocation.
 * @out_success: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_filename_used: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.ScreenshotArea">ScreenshotArea()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See phosh_dbus_screenshot_call_screenshot_area() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
phosh_dbus_screenshot_call_screenshot_area_sync (
    PhoshDBusScreenshot *proxy,
    gint arg_x,
    gint arg_y,
    gint arg_width,
    gint arg_height,
    gboolean arg_flash,
    const gchar *arg_filename,
    gboolean *out_success,
    gchar **out_filename_used,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ScreenshotArea",
    g_variant_new ("(iiiibs)",
                   arg_x,
                   arg_y,
                   arg_width,
                   arg_height,
                   arg_flash,
                   arg_filename),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(bs)",
                 out_success,
                 out_filename_used);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * phosh_dbus_screenshot_call_pick_color:
 * @proxy: A #PhoshDBusScreenshotProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.PickColor">PickColor()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call phosh_dbus_screenshot_call_pick_color_finish() to get the result of the operation.
 *
 * See phosh_dbus_screenshot_call_pick_color_sync() for the synchronous, blocking version of this method.
 */
void
phosh_dbus_screenshot_call_pick_color (
    PhoshDBusScreenshot *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "PickColor",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * phosh_dbus_screenshot_call_pick_color_finish:
 * @proxy: A #PhoshDBusScreenshotProxy.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to phosh_dbus_screenshot_call_pick_color().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with phosh_dbus_screenshot_call_pick_color().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
phosh_dbus_screenshot_call_pick_color_finish (
    PhoshDBusScreenshot *proxy,
    GVariant **out_result,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sv})",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * phosh_dbus_screenshot_call_pick_color_sync:
 * @proxy: A #PhoshDBusScreenshotProxy.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.PickColor">PickColor()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See phosh_dbus_screenshot_call_pick_color() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
phosh_dbus_screenshot_call_pick_color_sync (
    PhoshDBusScreenshot *proxy,
    GVariant **out_result,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "PickColor",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sv})",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * phosh_dbus_screenshot_call_flash_area:
 * @proxy: A #PhoshDBusScreenshotProxy.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @arg_width: Argument to pass with the method invocation.
 * @arg_height: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.FlashArea">FlashArea()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call phosh_dbus_screenshot_call_flash_area_finish() to get the result of the operation.
 *
 * See phosh_dbus_screenshot_call_flash_area_sync() for the synchronous, blocking version of this method.
 */
void
phosh_dbus_screenshot_call_flash_area (
    PhoshDBusScreenshot *proxy,
    gint arg_x,
    gint arg_y,
    gint arg_width,
    gint arg_height,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "FlashArea",
    g_variant_new ("(iiii)",
                   arg_x,
                   arg_y,
                   arg_width,
                   arg_height),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * phosh_dbus_screenshot_call_flash_area_finish:
 * @proxy: A #PhoshDBusScreenshotProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to phosh_dbus_screenshot_call_flash_area().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with phosh_dbus_screenshot_call_flash_area().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
phosh_dbus_screenshot_call_flash_area_finish (
    PhoshDBusScreenshot *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * phosh_dbus_screenshot_call_flash_area_sync:
 * @proxy: A #PhoshDBusScreenshotProxy.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @arg_width: Argument to pass with the method invocation.
 * @arg_height: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.FlashArea">FlashArea()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See phosh_dbus_screenshot_call_flash_area() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
phosh_dbus_screenshot_call_flash_area_sync (
    PhoshDBusScreenshot *proxy,
    gint arg_x,
    gint arg_y,
    gint arg_width,
    gint arg_height,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "FlashArea",
    g_variant_new ("(iiii)",
                   arg_x,
                   arg_y,
                   arg_width,
                   arg_height),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * phosh_dbus_screenshot_call_select_area:
 * @proxy: A #PhoshDBusScreenshotProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.SelectArea">SelectArea()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call phosh_dbus_screenshot_call_select_area_finish() to get the result of the operation.
 *
 * See phosh_dbus_screenshot_call_select_area_sync() for the synchronous, blocking version of this method.
 */
void
phosh_dbus_screenshot_call_select_area (
    PhoshDBusScreenshot *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SelectArea",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * phosh_dbus_screenshot_call_select_area_finish:
 * @proxy: A #PhoshDBusScreenshotProxy.
 * @out_x: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_y: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_width: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_height: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to phosh_dbus_screenshot_call_select_area().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with phosh_dbus_screenshot_call_select_area().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
phosh_dbus_screenshot_call_select_area_finish (
    PhoshDBusScreenshot *proxy,
    gint *out_x,
    gint *out_y,
    gint *out_width,
    gint *out_height,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(iiii)",
                 out_x,
                 out_y,
                 out_width,
                 out_height);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * phosh_dbus_screenshot_call_select_area_sync:
 * @proxy: A #PhoshDBusScreenshotProxy.
 * @out_x: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_y: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_width: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_height: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.SelectArea">SelectArea()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See phosh_dbus_screenshot_call_select_area() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
phosh_dbus_screenshot_call_select_area_sync (
    PhoshDBusScreenshot *proxy,
    gint *out_x,
    gint *out_y,
    gint *out_width,
    gint *out_height,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SelectArea",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(iiii)",
                 out_x,
                 out_y,
                 out_width,
                 out_height);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * phosh_dbus_screenshot_complete_screenshot:
 * @object: A #PhoshDBusScreenshot.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @success: Parameter to return.
 * @filename_used: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.Screenshot">Screenshot()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
phosh_dbus_screenshot_complete_screenshot (
    PhoshDBusScreenshot *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean success,
    const gchar *filename_used)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(bs)",
                   success,
                   filename_used));
}

/**
 * phosh_dbus_screenshot_complete_screenshot_window:
 * @object: A #PhoshDBusScreenshot.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @success: Parameter to return.
 * @filename_used: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.ScreenshotWindow">ScreenshotWindow()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
phosh_dbus_screenshot_complete_screenshot_window (
    PhoshDBusScreenshot *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean success,
    const gchar *filename_used)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(bs)",
                   success,
                   filename_used));
}

/**
 * phosh_dbus_screenshot_complete_screenshot_area:
 * @object: A #PhoshDBusScreenshot.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @success: Parameter to return.
 * @filename_used: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.ScreenshotArea">ScreenshotArea()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
phosh_dbus_screenshot_complete_screenshot_area (
    PhoshDBusScreenshot *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean success,
    const gchar *filename_used)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(bs)",
                   success,
                   filename_used));
}

/**
 * phosh_dbus_screenshot_complete_pick_color:
 * @object: A #PhoshDBusScreenshot.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @result: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.PickColor">PickColor()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
phosh_dbus_screenshot_complete_pick_color (
    PhoshDBusScreenshot *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *result)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a{sv})",
                   result));
}

/**
 * phosh_dbus_screenshot_complete_flash_area:
 * @object: A #PhoshDBusScreenshot.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.FlashArea">FlashArea()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
phosh_dbus_screenshot_complete_flash_area (
    PhoshDBusScreenshot *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * phosh_dbus_screenshot_complete_select_area:
 * @object: A #PhoshDBusScreenshot.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @x: Parameter to return.
 * @y: Parameter to return.
 * @width: Parameter to return.
 * @height: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Shell-Screenshot.SelectArea">SelectArea()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
phosh_dbus_screenshot_complete_select_area (
    PhoshDBusScreenshot *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gint x,
    gint y,
    gint width,
    gint height)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(iiii)",
                   x,
                   y,
                   width,
                   height));
}

/* ------------------------------------------------------------------------ */

/**
 * PhoshDBusScreenshotProxy:
 *
 * The #PhoshDBusScreenshotProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * PhoshDBusScreenshotProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #PhoshDBusScreenshotProxy.
 */

struct _PhoshDBusScreenshotProxyPrivate
{
  GData *qdata;
};

static void phosh_dbus_screenshot_proxy_iface_init (PhoshDBusScreenshotIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (PhoshDBusScreenshotProxy, phosh_dbus_screenshot_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (PhoshDBusScreenshotProxy)
                         G_IMPLEMENT_INTERFACE (PHOSH_DBUS_TYPE_SCREENSHOT, phosh_dbus_screenshot_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (PhoshDBusScreenshotProxy, phosh_dbus_screenshot_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (PHOSH_DBUS_TYPE_SCREENSHOT, phosh_dbus_screenshot_proxy_iface_init))

#endif
static void
phosh_dbus_screenshot_proxy_finalize (GObject *object)
{
  PhoshDBusScreenshotProxy *proxy = PHOSH_DBUS_SCREENSHOT_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (phosh_dbus_screenshot_proxy_parent_class)->finalize (object);
}

static void
phosh_dbus_screenshot_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
phosh_dbus_screenshot_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
phosh_dbus_screenshot_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_phosh_dbus_screenshot_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], PHOSH_DBUS_TYPE_SCREENSHOT);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, PHOSH_DBUS_TYPE_SCREENSHOT);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
phosh_dbus_screenshot_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  PhoshDBusScreenshotProxy *proxy = PHOSH_DBUS_SCREENSHOT_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_phosh_dbus_screenshot_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_phosh_dbus_screenshot_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
phosh_dbus_screenshot_proxy_init (PhoshDBusScreenshotProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = phosh_dbus_screenshot_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, PHOSH_DBUS_TYPE_SCREENSHOT_PROXY, PhoshDBusScreenshotProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), phosh_dbus_screenshot_interface_info ());
}

static void
phosh_dbus_screenshot_proxy_class_init (PhoshDBusScreenshotProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = phosh_dbus_screenshot_proxy_finalize;
  gobject_class->get_property = phosh_dbus_screenshot_proxy_get_property;
  gobject_class->set_property = phosh_dbus_screenshot_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = phosh_dbus_screenshot_proxy_g_signal;
  proxy_class->g_properties_changed = phosh_dbus_screenshot_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (PhoshDBusScreenshotProxyPrivate));
#endif
}

static void
phosh_dbus_screenshot_proxy_iface_init (PhoshDBusScreenshotIface *iface G_GNUC_UNUSED)
{
}

/**
 * phosh_dbus_screenshot_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Shell-Screenshot.top_of_page">org.gnome.Shell.Screenshot</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call phosh_dbus_screenshot_proxy_new_finish() to get the result of the operation.
 *
 * See phosh_dbus_screenshot_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
phosh_dbus_screenshot_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (PHOSH_DBUS_TYPE_SCREENSHOT_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Shell.Screenshot", NULL);
}

/**
 * phosh_dbus_screenshot_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to phosh_dbus_screenshot_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with phosh_dbus_screenshot_proxy_new().
 *
 * Returns: (transfer full) (type PhoshDBusScreenshotProxy): The constructed proxy object or %NULL if @error is set.
 */
PhoshDBusScreenshot *
phosh_dbus_screenshot_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return PHOSH_DBUS_SCREENSHOT (ret);
  else
    return NULL;
}

/**
 * phosh_dbus_screenshot_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Shell-Screenshot.top_of_page">org.gnome.Shell.Screenshot</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See phosh_dbus_screenshot_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type PhoshDBusScreenshotProxy): The constructed proxy object or %NULL if @error is set.
 */
PhoshDBusScreenshot *
phosh_dbus_screenshot_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (PHOSH_DBUS_TYPE_SCREENSHOT_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Shell.Screenshot", NULL);
  if (ret != NULL)
    return PHOSH_DBUS_SCREENSHOT (ret);
  else
    return NULL;
}


/**
 * phosh_dbus_screenshot_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like phosh_dbus_screenshot_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call phosh_dbus_screenshot_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See phosh_dbus_screenshot_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
phosh_dbus_screenshot_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (PHOSH_DBUS_TYPE_SCREENSHOT_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Shell.Screenshot", NULL);
}

/**
 * phosh_dbus_screenshot_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to phosh_dbus_screenshot_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with phosh_dbus_screenshot_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type PhoshDBusScreenshotProxy): The constructed proxy object or %NULL if @error is set.
 */
PhoshDBusScreenshot *
phosh_dbus_screenshot_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return PHOSH_DBUS_SCREENSHOT (ret);
  else
    return NULL;
}

/**
 * phosh_dbus_screenshot_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like phosh_dbus_screenshot_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See phosh_dbus_screenshot_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type PhoshDBusScreenshotProxy): The constructed proxy object or %NULL if @error is set.
 */
PhoshDBusScreenshot *
phosh_dbus_screenshot_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (PHOSH_DBUS_TYPE_SCREENSHOT_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Shell.Screenshot", NULL);
  if (ret != NULL)
    return PHOSH_DBUS_SCREENSHOT (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * PhoshDBusScreenshotSkeleton:
 *
 * The #PhoshDBusScreenshotSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * PhoshDBusScreenshotSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #PhoshDBusScreenshotSkeleton.
 */

struct _PhoshDBusScreenshotSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_phosh_dbus_screenshot_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  PhoshDBusScreenshotSkeleton *skeleton = PHOSH_DBUS_SCREENSHOT_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], PHOSH_DBUS_TYPE_SCREENSHOT);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, PHOSH_DBUS_TYPE_SCREENSHOT);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_phosh_dbus_screenshot_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  PhoshDBusScreenshotSkeleton *skeleton = PHOSH_DBUS_SCREENSHOT_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_phosh_dbus_screenshot_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_phosh_dbus_screenshot_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  PhoshDBusScreenshotSkeleton *skeleton = PHOSH_DBUS_SCREENSHOT_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_phosh_dbus_screenshot_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _phosh_dbus_screenshot_skeleton_vtable =
{
  _phosh_dbus_screenshot_skeleton_handle_method_call,
  _phosh_dbus_screenshot_skeleton_handle_get_property,
  _phosh_dbus_screenshot_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
phosh_dbus_screenshot_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return phosh_dbus_screenshot_interface_info ();
}

static GDBusInterfaceVTable *
phosh_dbus_screenshot_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_phosh_dbus_screenshot_skeleton_vtable;
}

static GVariant *
phosh_dbus_screenshot_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  PhoshDBusScreenshotSkeleton *skeleton = PHOSH_DBUS_SCREENSHOT_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_phosh_dbus_screenshot_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _phosh_dbus_screenshot_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _phosh_dbus_screenshot_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _phosh_dbus_screenshot_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Shell.Screenshot", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
phosh_dbus_screenshot_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void phosh_dbus_screenshot_skeleton_iface_init (PhoshDBusScreenshotIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (PhoshDBusScreenshotSkeleton, phosh_dbus_screenshot_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (PhoshDBusScreenshotSkeleton)
                         G_IMPLEMENT_INTERFACE (PHOSH_DBUS_TYPE_SCREENSHOT, phosh_dbus_screenshot_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (PhoshDBusScreenshotSkeleton, phosh_dbus_screenshot_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (PHOSH_DBUS_TYPE_SCREENSHOT, phosh_dbus_screenshot_skeleton_iface_init))

#endif
static void
phosh_dbus_screenshot_skeleton_finalize (GObject *object)
{
  PhoshDBusScreenshotSkeleton *skeleton = PHOSH_DBUS_SCREENSHOT_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (phosh_dbus_screenshot_skeleton_parent_class)->finalize (object);
}

static void
phosh_dbus_screenshot_skeleton_init (PhoshDBusScreenshotSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = phosh_dbus_screenshot_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, PHOSH_DBUS_TYPE_SCREENSHOT_SKELETON, PhoshDBusScreenshotSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
phosh_dbus_screenshot_skeleton_class_init (PhoshDBusScreenshotSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = phosh_dbus_screenshot_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = phosh_dbus_screenshot_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = phosh_dbus_screenshot_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = phosh_dbus_screenshot_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = phosh_dbus_screenshot_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (PhoshDBusScreenshotSkeletonPrivate));
#endif
}

static void
phosh_dbus_screenshot_skeleton_iface_init (PhoshDBusScreenshotIface *iface G_GNUC_UNUSED)
{
}

/**
 * phosh_dbus_screenshot_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Shell-Screenshot.top_of_page">org.gnome.Shell.Screenshot</link>.
 *
 * Returns: (transfer full) (type PhoshDBusScreenshotSkeleton): The skeleton object.
 */
PhoshDBusScreenshot *
phosh_dbus_screenshot_skeleton_new (void)
{
  return PHOSH_DBUS_SCREENSHOT (g_object_new (PHOSH_DBUS_TYPE_SCREENSHOT_SKELETON, NULL));
}

