/* DragManager.c generated by valac 0.56.17, the Vala compiler
 * generated from DragManager.vala, do not modify */

/**/
/*  Copyright (C) 2011-2012 Robert Dyer, Rico Tzschichholz*/
/**/
/*  This file is part of Plank.*/
/**/
/*  Plank is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  Plank is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include "plank.h"
#include <glib.h>
#include <gdk/gdk.h>
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <float.h>
#include <math.h>
#include <cairo-gobject.h>
#include "plank-internal.h"
#include <gio/gio.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PLANK_DRAG_MANAGER_0_PROPERTY,
	PLANK_DRAG_MANAGER_CONTROLLER_PROPERTY,
	PLANK_DRAG_MANAGER_INTERNAL_DRAG_ACTIVE_PROPERTY,
	PLANK_DRAG_MANAGER_DRAG_ITEM_PROPERTY,
	PLANK_DRAG_MANAGER_DRAG_NEEDS_CHECK_PROPERTY,
	PLANK_DRAG_MANAGER_EXTERNAL_DRAG_ACTIVE_PROPERTY,
	PLANK_DRAG_MANAGER_REPOSITION_MODE_PROPERTY,
	PLANK_DRAG_MANAGER_NUM_PROPERTIES
};
static GParamSpec* plank_drag_manager_properties[PLANK_DRAG_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block3Data Block3Data;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _PlankDragManagerPrivate {
	PlankDockController* _controller;
	gboolean _InternalDragActive;
	PlankDockItem* _DragItem;
	gboolean _DragNeedsCheck;
	gboolean external_drag_active;
	gboolean reposition_mode;
	GdkWindow* proxy_window;
	gboolean drag_canceled;
	gboolean drag_known;
	gboolean drag_data_requested;
	guint marker;
	guint drag_hover_timer_id;
	GeeArrayList* drag_data;
	gint window_scale_factor;
	gulong drag_item_redraw_handler_id;
};

struct _Block3Data {
	int _ref_count_;
	PlankDragManager* self;
	GdkDragContext* context;
};

static gint PlankDragManager_private_offset;
static gpointer plank_drag_manager_parent_class = NULL;

static PlankDockController* plank_drag_manager_get_controller (PlankDragManager* self);
static gboolean plank_drag_manager_drag_motion (GtkWidget* w,
                                         GdkDragContext* context,
                                         gint x,
                                         gint y,
                                         guint time_,
                                         PlankDragManager* self);
static gboolean _plank_drag_manager_drag_motion_gtk_widget_drag_motion (GtkWidget* _sender,
                                                                 GdkDragContext* context,
                                                                 gint x,
                                                                 gint y,
                                                                 guint time_,
                                                                 gpointer self);
static void plank_drag_manager_drag_begin (GtkWidget* w,
                                    GdkDragContext* context,
                                    PlankDragManager* self);
static void _plank_drag_manager_drag_begin_gtk_widget_drag_begin (GtkWidget* _sender,
                                                           GdkDragContext* context,
                                                           gpointer self);
static void plank_drag_manager_drag_data_received (GtkWidget* w,
                                            GdkDragContext* context,
                                            gint x,
                                            gint y,
                                            GtkSelectionData* selection_data,
                                            guint info,
                                            guint time_,
                                            PlankDragManager* self);
static void _plank_drag_manager_drag_data_received_gtk_widget_drag_data_received (GtkWidget* _sender,
                                                                           GdkDragContext* context,
                                                                           gint x,
                                                                           gint y,
                                                                           GtkSelectionData* selection_data,
                                                                           guint info,
                                                                           guint time_,
                                                                           gpointer self);
static void plank_drag_manager_drag_data_get (GtkWidget* w,
                                       GdkDragContext* context,
                                       GtkSelectionData* selection_data,
                                       guint info,
                                       guint time_,
                                       PlankDragManager* self);
static void _plank_drag_manager_drag_data_get_gtk_widget_drag_data_get (GtkWidget* _sender,
                                                                 GdkDragContext* context,
                                                                 GtkSelectionData* selection_data,
                                                                 guint info,
                                                                 guint time_,
                                                                 gpointer self);
static gboolean plank_drag_manager_drag_drop (GtkWidget* w,
                                       GdkDragContext* context,
                                       gint x,
                                       gint y,
                                       guint time_,
                                       PlankDragManager* self);
static gboolean _plank_drag_manager_drag_drop_gtk_widget_drag_drop (GtkWidget* _sender,
                                                             GdkDragContext* context,
                                                             gint x,
                                                             gint y,
                                                             guint time_,
                                                             gpointer self);
static void plank_drag_manager_drag_end (GtkWidget* w,
                                  GdkDragContext* context,
                                  PlankDragManager* self);
static void _plank_drag_manager_drag_end_gtk_widget_drag_end (GtkWidget* _sender,
                                                       GdkDragContext* context,
                                                       gpointer self);
static void plank_drag_manager_drag_leave (GtkWidget* w,
                                    GdkDragContext* context,
                                    guint time_,
                                    PlankDragManager* self);
static void _plank_drag_manager_drag_leave_gtk_widget_drag_leave (GtkWidget* _sender,
                                                           GdkDragContext* context,
                                                           guint time_,
                                                           gpointer self);
static gboolean plank_drag_manager_drag_failed (GtkWidget* w,
                                         GdkDragContext* context,
                                         GtkDragResult _result_,
                                         PlankDragManager* self);
static gboolean _plank_drag_manager_drag_failed_gtk_widget_drag_failed (GtkWidget* _sender,
                                                                 GdkDragContext* context,
                                                                 GtkDragResult _result_,
                                                                 gpointer self);
static void plank_drag_manager_lock_items_changed (PlankDragManager* self);
static void _plank_drag_manager_lock_items_changed_g_object_notify (GObject* _sender,
                                                             GParamSpec* pspec,
                                                             gpointer self);
static void plank_drag_manager_disable_drag_to (PlankDragManager* self,
                                         PlankDockWindow* window);
static void plank_drag_manager_disable_drag_from (PlankDragManager* self,
                                           PlankDockWindow* window);
static void plank_drag_manager_enable_drag_to (PlankDragManager* self,
                                        PlankDockWindow* window);
static void plank_drag_manager_enable_drag_from (PlankDragManager* self,
                                          PlankDockWindow* window);
static void plank_drag_manager_set_drag_icon (PlankDragManager* self,
                                       GdkDragContext* context,
                                       PlankDockItem* item,
                                       gdouble opacity);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void plank_drag_manager_hovered_item_changed (PlankDragManager* self);
static void _plank_drag_manager_hovered_item_changed_g_object_notify (GObject* _sender,
                                                               GParamSpec* pspec,
                                                               gpointer self);
static void plank_drag_manager_set_InternalDragActive (PlankDragManager* self,
                                                gboolean value);
static void plank_drag_manager_set_DragItem (PlankDragManager* self,
                                      PlankDockItem* value);
static void __lambda58_ (Block3Data* _data3_);
static void ___lambda58__plank_dock_element_needs_redraw (PlankDockElement* _sender,
                                                   gpointer self);
static void plank_drag_manager_set_DragNeedsCheck (PlankDragManager* self,
                                            gboolean value);
static void plank_drag_manager_set_ExternalDragActive (PlankDragManager* self,
                                                gboolean value);
static gboolean ___lambda60_ (PlankDragManager* self);
static gboolean ____lambda60__gsource_func (gpointer self);
static gboolean ___lambda57_ (PlankDragManager* self);
static gboolean ____lambda57__gsource_func (gpointer self);
static GdkWindow* plank_drag_manager_best_proxy_window (PlankDragManager* self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void plank_drag_manager_set_RepositionMode (PlankDragManager* self,
                                            gboolean value);
static void plank_drag_manager_finalize (GObject * obj);
static GType plank_drag_manager_get_type_once (void);
static void _vala_plank_drag_manager_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_plank_drag_manager_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
plank_drag_manager_get_instance_private (PlankDragManager* self)
{
	return G_STRUCT_MEMBER_P (self, PlankDragManager_private_offset);
}

static gboolean
_plank_drag_manager_drag_motion_gtk_widget_drag_motion (GtkWidget* _sender,
                                                        GdkDragContext* context,
                                                        gint x,
                                                        gint y,
                                                        guint time_,
                                                        gpointer self)
{
	gboolean result;
	result = plank_drag_manager_drag_motion (_sender, context, x, y, time_, (PlankDragManager*) self);
	return result;
}

static void
_plank_drag_manager_drag_begin_gtk_widget_drag_begin (GtkWidget* _sender,
                                                      GdkDragContext* context,
                                                      gpointer self)
{
	plank_drag_manager_drag_begin (_sender, context, (PlankDragManager*) self);
}

static void
_plank_drag_manager_drag_data_received_gtk_widget_drag_data_received (GtkWidget* _sender,
                                                                      GdkDragContext* context,
                                                                      gint x,
                                                                      gint y,
                                                                      GtkSelectionData* selection_data,
                                                                      guint info,
                                                                      guint time_,
                                                                      gpointer self)
{
	plank_drag_manager_drag_data_received (_sender, context, x, y, selection_data, info, time_, (PlankDragManager*) self);
}

static void
_plank_drag_manager_drag_data_get_gtk_widget_drag_data_get (GtkWidget* _sender,
                                                            GdkDragContext* context,
                                                            GtkSelectionData* selection_data,
                                                            guint info,
                                                            guint time_,
                                                            gpointer self)
{
	plank_drag_manager_drag_data_get (_sender, context, selection_data, info, time_, (PlankDragManager*) self);
}

static gboolean
_plank_drag_manager_drag_drop_gtk_widget_drag_drop (GtkWidget* _sender,
                                                    GdkDragContext* context,
                                                    gint x,
                                                    gint y,
                                                    guint time_,
                                                    gpointer self)
{
	gboolean result;
	result = plank_drag_manager_drag_drop (_sender, context, x, y, time_, (PlankDragManager*) self);
	return result;
}

static void
_plank_drag_manager_drag_end_gtk_widget_drag_end (GtkWidget* _sender,
                                                  GdkDragContext* context,
                                                  gpointer self)
{
	plank_drag_manager_drag_end (_sender, context, (PlankDragManager*) self);
}

static void
_plank_drag_manager_drag_leave_gtk_widget_drag_leave (GtkWidget* _sender,
                                                      GdkDragContext* context,
                                                      guint time_,
                                                      gpointer self)
{
	plank_drag_manager_drag_leave (_sender, context, time_, (PlankDragManager*) self);
}

static gboolean
_plank_drag_manager_drag_failed_gtk_widget_drag_failed (GtkWidget* _sender,
                                                        GdkDragContext* context,
                                                        GtkDragResult _result_,
                                                        gpointer self)
{
	gboolean result;
	result = plank_drag_manager_drag_failed (_sender, context, _result_, (PlankDragManager*) self);
	return result;
}

static void
_plank_drag_manager_lock_items_changed_g_object_notify (GObject* _sender,
                                                        GParamSpec* pspec,
                                                        gpointer self)
{
	plank_drag_manager_lock_items_changed ((PlankDragManager*) self);
}

/**
 * Creates a new instance of a DragManager, which handles
 * drag'n'drop interactions of a dock.
 *
 * @param controller the {@link DockController} to manage drag'n'drop for
 */
PlankDragManager*
plank_drag_manager_construct (GType object_type,
                              PlankDockController* controller)
{
	PlankDragManager * self = NULL;
	g_return_val_if_fail (controller != NULL, NULL);
	self = (PlankDragManager*) g_object_new (object_type, "controller", controller, NULL);
	return self;
}

PlankDragManager*
plank_drag_manager_new (PlankDockController* controller)
{
	return plank_drag_manager_construct (PLANK_TYPE_DRAG_MANAGER, controller);
}

/**
 * Initializes the drag-manager.  Call after the DockWindow is constructed.
 */
void
plank_drag_manager_initialize (PlankDragManager* self)
{
	PlankDockController* _tmp0_;
	PlankDockWindow* _tmp1_;
	PlankDockWindow* _tmp2_;
	PlankDockWindow* window = NULL;
	PlankDockController* _tmp3_;
	PlankDockWindow* _tmp4_;
	PlankDockWindow* _tmp5_;
	PlankDockPreferences* prefs = NULL;
	PlankDockController* _tmp6_;
	PlankDockPreferences* _tmp7_;
	PlankDockPreferences* _tmp8_;
	PlankDockWindow* _tmp9_;
	PlankDockWindow* _tmp10_;
	PlankDockWindow* _tmp11_;
	PlankDockWindow* _tmp12_;
	PlankDockWindow* _tmp13_;
	PlankDockWindow* _tmp14_;
	PlankDockWindow* _tmp15_;
	PlankDockWindow* _tmp16_;
	PlankDockPreferences* _tmp17_;
	PlankDockWindow* _tmp18_;
	PlankDockPreferences* _tmp19_;
	gboolean _tmp20_;
	gboolean _tmp21_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_controller;
	_tmp1_ = plank_dock_controller_get_window (_tmp0_);
	_tmp2_ = _tmp1_;
	_vala_return_if_fail (_tmp2_ != NULL, "controller.window != null");
	_tmp3_ = self->priv->_controller;
	_tmp4_ = plank_dock_controller_get_window (_tmp3_);
	_tmp5_ = _tmp4_;
	window = _tmp5_;
	_tmp6_ = self->priv->_controller;
	_tmp7_ = plank_dock_controller_get_prefs (_tmp6_);
	_tmp8_ = _tmp7_;
	prefs = _tmp8_;
	_tmp9_ = window;
	g_signal_connect_object ((GtkWidget*) _tmp9_, "drag-motion", (GCallback) _plank_drag_manager_drag_motion_gtk_widget_drag_motion, self, 0);
	_tmp10_ = window;
	g_signal_connect_object ((GtkWidget*) _tmp10_, "drag-begin", (GCallback) _plank_drag_manager_drag_begin_gtk_widget_drag_begin, self, 0);
	_tmp11_ = window;
	g_signal_connect_object ((GtkWidget*) _tmp11_, "drag-data-received", (GCallback) _plank_drag_manager_drag_data_received_gtk_widget_drag_data_received, self, 0);
	_tmp12_ = window;
	g_signal_connect_object ((GtkWidget*) _tmp12_, "drag-data-get", (GCallback) _plank_drag_manager_drag_data_get_gtk_widget_drag_data_get, self, 0);
	_tmp13_ = window;
	g_signal_connect_object ((GtkWidget*) _tmp13_, "drag-drop", (GCallback) _plank_drag_manager_drag_drop_gtk_widget_drag_drop, self, 0);
	_tmp14_ = window;
	g_signal_connect_object ((GtkWidget*) _tmp14_, "drag-end", (GCallback) _plank_drag_manager_drag_end_gtk_widget_drag_end, self, 0);
	_tmp15_ = window;
	g_signal_connect_object ((GtkWidget*) _tmp15_, "drag-leave", (GCallback) _plank_drag_manager_drag_leave_gtk_widget_drag_leave, self, 0);
	_tmp16_ = window;
	g_signal_connect_object ((GtkWidget*) _tmp16_, "drag-failed", (GCallback) _plank_drag_manager_drag_failed_gtk_widget_drag_failed, self, 0);
	_tmp17_ = prefs;
	g_signal_connect_object ((GObject*) _tmp17_, "notify::LockItems", (GCallback) _plank_drag_manager_lock_items_changed_g_object_notify, self, 0);
	_tmp18_ = window;
	plank_drag_manager_enable_drag_to (self, _tmp18_);
	_tmp19_ = prefs;
	_tmp20_ = plank_dock_preferences_get_LockItems (_tmp19_);
	_tmp21_ = _tmp20_;
	if (!_tmp21_) {
		PlankDockWindow* _tmp22_;
		_tmp22_ = window;
		plank_drag_manager_enable_drag_from (self, _tmp22_);
	}
}

static void
plank_drag_manager_lock_items_changed (PlankDragManager* self)
{
	PlankDockWindow* window = NULL;
	PlankDockController* _tmp0_;
	PlankDockWindow* _tmp1_;
	PlankDockWindow* _tmp2_;
	PlankDockController* _tmp3_;
	PlankDockPreferences* _tmp4_;
	PlankDockPreferences* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_controller;
	_tmp1_ = plank_dock_controller_get_window (_tmp0_);
	_tmp2_ = _tmp1_;
	window = _tmp2_;
	_tmp3_ = self->priv->_controller;
	_tmp4_ = plank_dock_controller_get_prefs (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = plank_dock_preferences_get_LockItems (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_) {
		PlankDockWindow* _tmp8_;
		_tmp8_ = window;
		plank_drag_manager_disable_drag_from (self, _tmp8_);
	} else {
		PlankDockWindow* _tmp9_;
		_tmp9_ = window;
		plank_drag_manager_enable_drag_from (self, _tmp9_);
	}
}

static gchar*
string_to_utf8 (const gchar* self,
                gint* result_length1)
{
	gint string_length = 0;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _result_ = NULL;
	gchar* _tmp2_;
	gint _result__length1;
	gint __result__size_;
	gint _tmp3_;
	gchar* _tmp4_;
	gint _tmp4__length1;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = _tmp1_;
	_tmp2_ = g_new0 (gchar, string_length + 1);
	_result_ = _tmp2_;
	_result__length1 = string_length + 1;
	__result__size_ = _result__length1;
	_tmp3_ = _result__length1;
	_result__length1 = _tmp3_ - 1;
	memcpy (_result_, self, (gsize) string_length);
	_tmp4_ = _result_;
	_tmp4__length1 = _result__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}

static void
plank_drag_manager_drag_data_get (GtkWidget* w,
                                  GdkDragContext* context,
                                  GtkSelectionData* selection_data,
                                  guint info,
                                  guint time_,
                                  PlankDragManager* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (w != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (selection_data != NULL);
	_tmp1_ = self->priv->_InternalDragActive;
	if (_tmp1_) {
		PlankDockItem* _tmp2_;
		_tmp2_ = self->priv->_DragItem;
		_tmp0_ = _tmp2_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* uri = NULL;
		PlankDockItem* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		const gchar* _tmp8_;
		gint _tmp9_ = 0;
		gchar* _tmp10_;
		guchar* _tmp11_;
		gint _tmp11__length1;
		_tmp3_ = self->priv->_DragItem;
		_tmp4_ = plank_dock_element_as_uri ((PlankDockElement*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strdup_printf ("%s\r\n", _tmp5_);
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp5_);
		uri = _tmp7_;
		_tmp8_ = uri;
		_tmp10_ = string_to_utf8 (_tmp8_, &_tmp9_);
		_tmp11_ = (guchar*) _tmp10_;
		_tmp11__length1 = (_tmp9_ * sizeof (gchar)) / sizeof (guchar);
		gtk_selection_data_set (selection_data, gtk_selection_data_get_target (selection_data), 8, _tmp11_, (gint) ((_tmp9_ * sizeof (gchar)) / sizeof (guchar)));
		_tmp11_ = (g_free (_tmp11_), NULL);
		_g_free0 (uri);
	}
}

/**
 * Whether the current dragged-data is accepted by the given dock-item
 *
 * @param item the dock-item
 */
gboolean
plank_drag_manager_drop_is_accepted_by (PlankDragManager* self,
                                        PlankDockItem* item)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (item != NULL, FALSE);
	_tmp0_ = self->priv->drag_data;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->priv->drag_data;
	result = plank_dock_element_can_accept_drop ((PlankDockElement*) item, _tmp1_);
	return result;
}

static void
plank_drag_manager_set_drag_icon (PlankDragManager* self,
                                  GdkDragContext* context,
                                  PlankDockItem* item,
                                  gdouble opacity)
{
	PlankDockController* _tmp0_;
	PlankDockWindow* _tmp1_;
	PlankDockWindow* _tmp2_;
	GdkWindow* _tmp3_;
	gint drag_icon_size = 0;
	PlankDockController* _tmp4_;
	PlankPositionManager* _tmp5_;
	PlankPositionManager* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	PlankSurface* drag_surface = NULL;
	PlankSurface* _tmp10_;
	PlankSurface* _tmp11_;
	cairo_surface_t* _tmp12_;
	cairo_surface_t* _tmp13_;
	PlankSurface* item_surface = NULL;
	PlankSurface* _tmp14_;
	PlankSurface* _tmp15_;
	cairo_t* cr = NULL;
	PlankSurface* _tmp16_;
	cairo_t* _tmp17_;
	cairo_t* _tmp18_;
	cairo_t* _tmp21_;
	cairo_t* _tmp22_;
	PlankSurface* _tmp23_;
	cairo_surface_t* _tmp24_;
	cairo_surface_t* _tmp25_;
	cairo_t* _tmp26_;
	cairo_surface_t* surface = NULL;
	PlankSurface* _tmp28_;
	cairo_surface_t* _tmp29_;
	cairo_surface_t* _tmp30_;
	cairo_surface_t* _tmp31_;
	cairo_surface_t* _tmp32_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	if (item == NULL) {
		gtk_drag_set_icon_default (context);
		return;
	}
	_tmp0_ = self->priv->_controller;
	_tmp1_ = plank_dock_controller_get_window (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gtk_widget_get_window ((GtkWidget*) _tmp2_);
	self->priv->window_scale_factor = gdk_window_get_scale_factor (_tmp3_);
	_tmp4_ = self->priv->_controller;
	_tmp5_ = plank_dock_controller_get_position_manager (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = plank_position_manager_get_ZoomIconSize (_tmp6_);
	_tmp8_ = _tmp7_;
	drag_icon_size = (gint) (1.2 * _tmp8_);
	if ((drag_icon_size % 2) == 1) {
		gint _tmp9_;
		_tmp9_ = drag_icon_size;
		drag_icon_size = _tmp9_ + 1;
	}
	drag_icon_size *= self->priv->window_scale_factor;
	_tmp10_ = plank_surface_new (drag_icon_size, drag_icon_size);
	drag_surface = _tmp10_;
	_tmp11_ = drag_surface;
	_tmp12_ = plank_surface_get_Internal (_tmp11_);
	_tmp13_ = _tmp12_;
	cairo_surface_set_device_scale (_tmp13_, (gdouble) self->priv->window_scale_factor, (gdouble) self->priv->window_scale_factor);
	_tmp14_ = drag_surface;
	_tmp15_ = plank_dock_item_get_surface_copy (item, drag_icon_size, drag_icon_size, _tmp14_);
	item_surface = _tmp15_;
	_tmp16_ = drag_surface;
	_tmp17_ = plank_surface_get_Context (_tmp16_);
	_tmp18_ = _tmp17_;
	cr = _tmp18_;
	if (self->priv->window_scale_factor > 1) {
		cairo_t* _tmp19_;
		cairo_t* _tmp20_;
		_tmp19_ = cr;
		cairo_save (_tmp19_);
		_tmp20_ = cr;
		cairo_scale (_tmp20_, 1.0 / self->priv->window_scale_factor, 1.0 / self->priv->window_scale_factor);
	}
	_tmp21_ = cr;
	cairo_set_operator (_tmp21_, CAIRO_OPERATOR_OVER);
	_tmp22_ = cr;
	_tmp23_ = item_surface;
	_tmp24_ = plank_surface_get_Internal (_tmp23_);
	_tmp25_ = _tmp24_;
	cairo_set_source_surface (_tmp22_, _tmp25_, (gdouble) 0, (gdouble) 0);
	_tmp26_ = cr;
	cairo_paint_with_alpha (_tmp26_, opacity);
	if (self->priv->window_scale_factor > 1) {
		cairo_t* _tmp27_;
		_tmp27_ = cr;
		cairo_restore (_tmp27_);
	}
	_tmp28_ = drag_surface;
	_tmp29_ = plank_surface_get_Internal (_tmp28_);
	_tmp30_ = _tmp29_;
	surface = _tmp30_;
	_tmp31_ = surface;
	cairo_surface_set_device_offset (_tmp31_, (-drag_icon_size) / 2.0, (-drag_icon_size) / 2.0);
	_tmp32_ = surface;
	gtk_drag_set_icon_surface (context, _tmp32_);
	_g_object_unref0 (item_surface);
	_g_object_unref0 (drag_surface);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		PlankDragManager* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->context);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static void
_plank_drag_manager_hovered_item_changed_g_object_notify (GObject* _sender,
                                                          GParamSpec* pspec,
                                                          gpointer self)
{
	plank_drag_manager_hovered_item_changed ((PlankDragManager*) self);
}

static void
__lambda58_ (Block3Data* _data3_)
{
	PlankDragManager* self;
	PlankDockItem* _tmp0_;
	self = _data3_->self;
	_tmp0_ = self->priv->_DragItem;
	plank_drag_manager_set_drag_icon (self, _data3_->context, _tmp0_, 0.8);
}

static void
___lambda58__plank_dock_element_needs_redraw (PlankDockElement* _sender,
                                              gpointer self)
{
	__lambda58_ (self);
}

static void
plank_drag_manager_drag_begin (GtkWidget* w,
                               GdkDragContext* context,
                               PlankDragManager* self)
{
	Block3Data* _data3_;
	GdkDragContext* _tmp0_;
	PlankDockWindow* window = NULL;
	PlankDockController* _tmp1_;
	PlankDockWindow* _tmp2_;
	PlankDockWindow* _tmp3_;
	PlankDockWindow* _tmp4_;
	GdkWindow* _tmp5_;
	PlankDockWindow* _tmp7_;
	PlankDockItem* _tmp8_;
	PlankDockItem* _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	PlankDockItem* _tmp12_;
	PlankDockItem* _tmp13_;
	PlankDockItem* _tmp14_;
	gulong _tmp15_;
	GdkDevice* _tmp16_;
	PlankDockWindow* _tmp17_;
	GdkWindow* _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (w != NULL);
	g_return_if_fail (context != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (context);
	_g_object_unref0 (_data3_->context);
	_data3_->context = _tmp0_;
	_tmp1_ = self->priv->_controller;
	_tmp2_ = plank_dock_controller_get_window (_tmp1_);
	_tmp3_ = _tmp2_;
	window = _tmp3_;
	_tmp4_ = window;
	g_signal_connect_object ((GObject*) _tmp4_, "notify::HoveredItem", (GCallback) _plank_drag_manager_hovered_item_changed_g_object_notify, self, 0);
	plank_drag_manager_set_InternalDragActive (self, TRUE);
	self->priv->drag_canceled = FALSE;
	_tmp5_ = self->priv->proxy_window;
	if (_tmp5_ != NULL) {
		PlankDockWindow* _tmp6_;
		_tmp6_ = window;
		plank_drag_manager_enable_drag_to (self, _tmp6_);
		_g_object_unref0 (self->priv->proxy_window);
		self->priv->proxy_window = NULL;
	}
	_tmp7_ = window;
	_tmp8_ = plank_dock_window_get_HoveredItem (_tmp7_);
	_tmp9_ = _tmp8_;
	plank_drag_manager_set_DragItem (self, _tmp9_);
	_tmp10_ = plank_drag_manager_get_RepositionMode (self);
	_tmp11_ = _tmp10_;
	if (_tmp11_) {
		plank_drag_manager_set_DragItem (self, NULL);
	}
	_tmp12_ = self->priv->_DragItem;
	if (_tmp12_ == NULL) {
		gdk_drag_abort (_data3_->context, gtk_get_current_event_time ());
		block3_data_unref (_data3_);
		_data3_ = NULL;
		return;
	}
	_tmp13_ = self->priv->_DragItem;
	plank_drag_manager_set_drag_icon (self, _data3_->context, _tmp13_, 0.8);
	_tmp14_ = self->priv->_DragItem;
	_tmp15_ = g_signal_connect_data ((PlankDockElement*) _tmp14_, "needs-redraw", (GCallback) ___lambda58__plank_dock_element_needs_redraw, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	self->priv->drag_item_redraw_handler_id = _tmp15_;
	_tmp16_ = gdk_drag_context_get_device (_data3_->context);
	_tmp17_ = window;
	_tmp18_ = gtk_widget_get_window ((GtkWidget*) _tmp17_);
	gdk_device_grab (_tmp16_, _tmp18_, GDK_OWNERSHIP_APPLICATION, TRUE, GDK_ALL_EVENTS_MASK, NULL, gtk_get_current_event_time ());
	block3_data_unref (_data3_);
	_data3_ = NULL;
}

static void
plank_drag_manager_drag_data_received (GtkWidget* w,
                                       GdkDragContext* context,
                                       gint x,
                                       gint y,
                                       GtkSelectionData* selection_data,
                                       guint info,
                                       guint time_,
                                       PlankDragManager* self)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (w != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (selection_data != NULL);
	if (self->priv->drag_data_requested) {
		const gchar* data = NULL;
		guint8* _tmp0_;
		const gchar* _tmp1_;
		gchar** uris = NULL;
		const gchar* _tmp2_;
		gchar** _tmp3_;
		gchar** _tmp4_;
		gint uris_length1;
		gint _uris_size_;
		GeeArrayList* _tmp5_;
		gchar** _tmp6_;
		gint _tmp6__length1;
		GeeArrayList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		PlankDockController* _tmp26_;
		PlankDockRenderer* _tmp27_;
		PlankDockRenderer* _tmp28_;
		_tmp0_ = gtk_selection_data_get_data (selection_data);
		data = (const gchar*) _tmp0_;
		_tmp1_ = data;
		if (_tmp1_ == NULL) {
			self->priv->drag_data_requested = FALSE;
			gdk_drag_status (context, GDK_ACTION_COPY, (guint32) time_);
			return;
		}
		_tmp2_ = data;
		_tmp4_ = _tmp3_ = g_uri_list_extract_uris (_tmp2_);
		uris = _tmp4_;
		uris_length1 = _vala_array_length (_tmp3_);
		_uris_size_ = uris_length1;
		_tmp5_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
		_g_object_unref0 (self->priv->drag_data);
		self->priv->drag_data = _tmp5_;
		_tmp6_ = uris;
		_tmp6__length1 = uris_length1;
		{
			gchar** s_collection = NULL;
			gint s_collection_length1 = 0;
			gint _s_collection_size_ = 0;
			gint s_it = 0;
			s_collection = _tmp6_;
			s_collection_length1 = _tmp6__length1;
			for (s_it = 0; s_it < s_collection_length1; s_it = s_it + 1) {
				const gchar* s = NULL;
				s = s_collection[s_it];
				{
					const gchar* _tmp7_;
					gchar* uri = NULL;
					const gchar* _tmp10_;
					GFile* _tmp11_;
					GFile* _tmp12_;
					gchar* _tmp13_;
					gchar* _tmp14_;
					const gchar* _tmp15_;
					_tmp7_ = s;
					if (g_str_has_prefix (_tmp7_, PLANK_DOCKLET_URI_PREFIX)) {
						GeeArrayList* _tmp8_;
						const gchar* _tmp9_;
						_tmp8_ = self->priv->drag_data;
						_tmp9_ = s;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp8_, _tmp9_);
						continue;
					}
					_tmp10_ = s;
					_tmp11_ = g_file_new_for_uri (_tmp10_);
					_tmp12_ = _tmp11_;
					_tmp13_ = g_file_get_uri (_tmp12_);
					_tmp14_ = _tmp13_;
					_g_object_unref0 (_tmp12_);
					uri = _tmp14_;
					_tmp15_ = uri;
					if (_tmp15_ != NULL) {
						GeeArrayList* _tmp16_;
						const gchar* _tmp17_;
						_tmp16_ = self->priv->drag_data;
						_tmp17_ = uri;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp16_, _tmp17_);
					}
					_g_free0 (uri);
				}
			}
		}
		self->priv->drag_data_requested = FALSE;
		_tmp18_ = self->priv->drag_data;
		_tmp19_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp18_);
		_tmp20_ = _tmp19_;
		if (_tmp20_ == 1) {
			gchar* uri = NULL;
			GeeArrayList* _tmp21_;
			gpointer _tmp22_;
			gboolean _tmp23_ = FALSE;
			const gchar* _tmp24_;
			_tmp21_ = self->priv->drag_data;
			_tmp22_ = gee_abstract_list_get ((GeeAbstractList*) _tmp21_, 0);
			uri = (gchar*) _tmp22_;
			_tmp24_ = uri;
			if (g_str_has_prefix (_tmp24_, PLANK_DOCKLET_URI_PREFIX)) {
				_tmp23_ = TRUE;
			} else {
				const gchar* _tmp25_;
				_tmp25_ = uri;
				_tmp23_ = g_str_has_suffix (_tmp25_, ".desktop");
			}
			plank_drag_manager_set_DragNeedsCheck (self, !_tmp23_);
			_g_free0 (uri);
		} else {
			plank_drag_manager_set_DragNeedsCheck (self, TRUE);
		}
		_tmp26_ = self->priv->_controller;
		_tmp27_ = plank_dock_controller_get_renderer (_tmp26_);
		_tmp28_ = _tmp27_;
		plank_renderer_animated_draw ((PlankRenderer*) _tmp28_);
		plank_drag_manager_hovered_item_changed (self);
		uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_free), NULL);
	}
	gdk_drag_status (context, GDK_ACTION_COPY, (guint32) time_);
}

static gboolean
plank_drag_manager_drag_drop (GtkWidget* w,
                              GdkDragContext* context,
                              gint x,
                              gint y,
                              guint time_,
                              PlankDragManager* self)
{
	GeeArrayList* _tmp0_;
	PlankDockWindow* window = NULL;
	PlankDockController* _tmp1_;
	PlankDockWindow* _tmp2_;
	PlankDockWindow* _tmp3_;
	PlankDockItem* item = NULL;
	PlankDockWindow* _tmp4_;
	PlankDockItem* _tmp5_;
	PlankDockItem* _tmp6_;
	PlankDockItemProvider* provider = NULL;
	PlankDockWindow* _tmp7_;
	PlankDockItemProvider* _tmp8_;
	PlankDockItemProvider* _tmp9_;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	gtk_drag_finish (context, TRUE, FALSE, (guint32) time_);
	if (self->priv->drag_hover_timer_id > 0U) {
		g_source_remove (self->priv->drag_hover_timer_id);
		self->priv->drag_hover_timer_id = 0U;
	}
	_tmp0_ = self->priv->drag_data;
	if (_tmp0_ == NULL) {
		result = TRUE;
		return result;
	}
	_tmp1_ = self->priv->_controller;
	_tmp2_ = plank_dock_controller_get_window (_tmp1_);
	_tmp3_ = _tmp2_;
	window = _tmp3_;
	_tmp4_ = window;
	_tmp5_ = plank_dock_window_get_HoveredItem (_tmp4_);
	_tmp6_ = _tmp5_;
	item = _tmp6_;
	_tmp7_ = window;
	_tmp8_ = plank_dock_window_get_HoveredItemProvider (_tmp7_);
	_tmp9_ = _tmp8_;
	provider = _tmp9_;
	_tmp12_ = self->priv->_DragNeedsCheck;
	if (_tmp12_) {
		PlankDockItem* _tmp13_;
		_tmp13_ = item;
		_tmp11_ = _tmp13_ != NULL;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		PlankDockItem* _tmp14_;
		GeeArrayList* _tmp15_;
		_tmp14_ = item;
		_tmp15_ = self->priv->drag_data;
		_tmp10_ = plank_dock_element_can_accept_drop ((PlankDockElement*) _tmp14_, _tmp15_);
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		PlankDockItem* _tmp16_;
		GeeArrayList* _tmp17_;
		_tmp16_ = item;
		_tmp17_ = self->priv->drag_data;
		plank_dock_element_accept_drop ((PlankDockElement*) _tmp16_, _tmp17_);
	} else {
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
		PlankDockController* _tmp20_;
		PlankDockPreferences* _tmp21_;
		PlankDockPreferences* _tmp22_;
		gboolean _tmp23_;
		gboolean _tmp24_;
		_tmp20_ = self->priv->_controller;
		_tmp21_ = plank_dock_controller_get_prefs (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = plank_dock_preferences_get_LockItems (_tmp22_);
		_tmp24_ = _tmp23_;
		if (!_tmp24_) {
			PlankDockItemProvider* _tmp25_;
			_tmp25_ = provider;
			_tmp19_ = _tmp25_ != NULL;
		} else {
			_tmp19_ = FALSE;
		}
		if (_tmp19_) {
			PlankDockItemProvider* _tmp26_;
			GeeArrayList* _tmp27_;
			_tmp26_ = provider;
			_tmp27_ = self->priv->drag_data;
			_tmp18_ = plank_dock_element_can_accept_drop ((PlankDockElement*) _tmp26_, _tmp27_);
		} else {
			_tmp18_ = FALSE;
		}
		if (_tmp18_) {
			PlankDockItemProvider* _tmp28_;
			GeeArrayList* _tmp29_;
			_tmp28_ = provider;
			_tmp29_ = self->priv->drag_data;
			plank_dock_element_accept_drop ((PlankDockElement*) _tmp28_, _tmp29_);
		}
	}
	plank_drag_manager_set_ExternalDragActive (self, FALSE);
	result = TRUE;
	return result;
}

static void
plank_drag_manager_drag_end (GtkWidget* w,
                             GdkDragContext* context,
                             PlankDragManager* self)
{
	PlankHideManager* hide_manager = NULL;
	PlankDockController* _tmp0_;
	PlankHideManager* _tmp1_;
	PlankHideManager* _tmp2_;
	gboolean _tmp5_ = FALSE;
	GdkDevice* _tmp46_;
	PlankDockController* _tmp47_;
	PlankDockWindow* _tmp48_;
	PlankDockWindow* _tmp49_;
	guint _tmp50_;
	GQuark _tmp51_;
	PlankDockController* _tmp52_;
	PlankHoverWindow* _tmp53_;
	PlankHoverWindow* _tmp54_;
	PlankDockController* _tmp55_;
	PlankDockRenderer* _tmp56_;
	PlankDockRenderer* _tmp57_;
	PlankHideManager* _tmp58_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (w != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = self->priv->_controller;
	_tmp1_ = plank_dock_controller_get_hide_manager (_tmp0_);
	_tmp2_ = _tmp1_;
	hide_manager = _tmp2_;
	if (self->priv->drag_item_redraw_handler_id > 0UL) {
		PlankDockItem* _tmp3_;
		_tmp3_ = self->priv->_DragItem;
		if (_tmp3_ != NULL) {
			PlankDockItem* _tmp4_;
			_tmp4_ = self->priv->_DragItem;
			g_signal_handler_disconnect (_tmp4_, self->priv->drag_item_redraw_handler_id);
		}
		self->priv->drag_item_redraw_handler_id = 0UL;
	}
	if (!self->priv->drag_canceled) {
		PlankDockItem* _tmp6_;
		_tmp6_ = self->priv->_DragItem;
		_tmp5_ = _tmp6_ != NULL;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		PlankHideManager* _tmp7_;
		PlankHideManager* _tmp8_;
		gboolean _tmp9_;
		gboolean _tmp10_;
		_tmp7_ = hide_manager;
		plank_hide_manager_update_hovered (_tmp7_);
		_tmp8_ = hide_manager;
		_tmp9_ = plank_hide_manager_get_Hovered (_tmp8_);
		_tmp10_ = _tmp9_;
		if (!_tmp10_) {
			PlankDockItem* _tmp11_;
			_tmp11_ = self->priv->_DragItem;
			if (plank_dock_element_can_be_removed ((PlankDockElement*) _tmp11_)) {
				PlankApplicationDockItem* app_item = NULL;
				PlankDockItem* _tmp12_;
				gboolean _tmp13_ = FALSE;
				PlankApplicationDockItem* _tmp14_;
				PlankDockItem* _tmp23_;
				gint x = 0;
				gint y = 0;
				GdkDevice* _tmp24_;
				gint _tmp25_ = 0;
				gint _tmp26_ = 0;
				PlankPoofWindow* _tmp27_;
				_tmp12_ = self->priv->_DragItem;
				app_item = PLANK_IS_APPLICATION_DOCK_ITEM (_tmp12_) ? ((PlankApplicationDockItem*) _tmp12_) : NULL;
				_tmp14_ = app_item;
				if (_tmp14_ == NULL) {
					_tmp13_ = TRUE;
				} else {
					gboolean _tmp15_ = FALSE;
					PlankApplicationDockItem* _tmp16_;
					_tmp16_ = app_item;
					if (plank_application_dock_item_is_running (_tmp16_)) {
						_tmp15_ = TRUE;
					} else {
						PlankApplicationDockItem* _tmp17_;
						_tmp17_ = app_item;
						_tmp15_ = plank_application_dock_item_has_unity_info (_tmp17_);
					}
					_tmp13_ = !_tmp15_;
				}
				if (_tmp13_) {
					PlankDockItem* _tmp18_;
					PlankDockItem* _tmp19_;
					PlankDockContainer* _tmp20_;
					PlankDockContainer* _tmp21_;
					PlankDockItem* _tmp22_;
					_tmp18_ = self->priv->_DragItem;
					plank_dock_element_set_IsVisible ((PlankDockElement*) _tmp18_, FALSE);
					_tmp19_ = self->priv->_DragItem;
					_tmp20_ = plank_dock_element_get_Container ((PlankDockElement*) _tmp19_);
					_tmp21_ = _tmp20_;
					_tmp22_ = self->priv->_DragItem;
					plank_dock_container_remove (_tmp21_, (PlankDockElement*) _tmp22_);
				}
				_tmp23_ = self->priv->_DragItem;
				plank_dock_item_delete (_tmp23_);
				_tmp24_ = gdk_drag_context_get_device (context);
				gdk_device_get_position (_tmp24_, NULL, &_tmp25_, &_tmp26_);
				x = _tmp25_;
				y = _tmp26_;
				_tmp27_ = plank_poof_window_get_default ();
				plank_poof_window_show_at (_tmp27_, x, y);
			}
		} else {
			PlankDockController* _tmp28_;
			PlankDockWindow* _tmp29_;
			PlankDockWindow* _tmp30_;
			PlankDockItem* _tmp31_;
			PlankDockItem* _tmp32_;
			_tmp28_ = self->priv->_controller;
			_tmp29_ = plank_dock_controller_get_window (_tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = plank_dock_window_get_HoveredItem (_tmp30_);
			_tmp32_ = _tmp31_;
			if (_tmp32_ == NULL) {
				gboolean _tmp33_ = FALSE;
				PlankDockController* _tmp34_;
				PlankDockPreferences* _tmp35_;
				PlankDockPreferences* _tmp36_;
				gboolean _tmp37_;
				gboolean _tmp38_;
				_tmp34_ = self->priv->_controller;
				_tmp35_ = plank_dock_controller_get_prefs (_tmp34_);
				_tmp36_ = _tmp35_;
				_tmp37_ = plank_dock_preferences_get_AutoPinning (_tmp36_);
				_tmp38_ = _tmp37_;
				if (_tmp38_) {
					PlankDockItem* _tmp39_;
					_tmp39_ = self->priv->_DragItem;
					_tmp33_ = PLANK_IS_TRANSIENT_DOCK_ITEM (_tmp39_);
				} else {
					_tmp33_ = FALSE;
				}
				if (_tmp33_) {
					PlankDefaultApplicationDockItemProvider* provider = NULL;
					PlankDockItem* _tmp40_;
					PlankDockContainer* _tmp41_;
					PlankDockContainer* _tmp42_;
					PlankDefaultApplicationDockItemProvider* _tmp43_;
					_tmp40_ = self->priv->_DragItem;
					_tmp41_ = plank_dock_element_get_Container ((PlankDockElement*) _tmp40_);
					_tmp42_ = _tmp41_;
					provider = PLANK_IS_DEFAULT_APPLICATION_DOCK_ITEM_PROVIDER (_tmp42_) ? ((PlankDefaultApplicationDockItemProvider*) _tmp42_) : NULL;
					_tmp43_ = provider;
					if (_tmp43_ != NULL) {
						PlankDefaultApplicationDockItemProvider* _tmp44_;
						PlankDockItem* _tmp45_;
						_tmp44_ = provider;
						_tmp45_ = self->priv->_DragItem;
						plank_default_application_dock_item_provider_pin_item (_tmp44_, _tmp45_);
					}
				}
			} else {
			}
		}
	}
	plank_drag_manager_set_InternalDragActive (self, FALSE);
	plank_drag_manager_set_DragItem (self, NULL);
	_tmp46_ = gdk_drag_context_get_device (context);
	gdk_device_ungrab (_tmp46_, gtk_get_current_event_time ());
	_tmp47_ = self->priv->_controller;
	_tmp48_ = plank_dock_controller_get_window (_tmp47_);
	_tmp49_ = _tmp48_;
	g_signal_parse_name ("notify::HoveredItem", G_TYPE_OBJECT, &_tmp50_, &_tmp51_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp49_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp50_, _tmp51_, NULL, (GCallback) _plank_drag_manager_hovered_item_changed_g_object_notify, self);
	_tmp52_ = self->priv->_controller;
	_tmp53_ = plank_dock_controller_get_hover (_tmp52_);
	_tmp54_ = _tmp53_;
	gtk_widget_hide ((GtkWidget*) _tmp54_);
	_tmp55_ = self->priv->_controller;
	_tmp56_ = plank_dock_controller_get_renderer (_tmp55_);
	_tmp57_ = _tmp56_;
	plank_renderer_animated_draw ((PlankRenderer*) _tmp57_);
	_tmp58_ = hide_manager;
	plank_hide_manager_update_hovered (_tmp58_);
}

static gboolean
___lambda60_ (PlankDragManager* self)
{
	PlankDockController* _tmp0_;
	PlankHoverWindow* _tmp1_;
	PlankHoverWindow* _tmp2_;
	PlankDockController* _tmp3_;
	PlankDockWindow* _tmp4_;
	PlankDockWindow* _tmp5_;
	PlankDockController* _tmp6_;
	PlankDockRenderer* _tmp7_;
	PlankDockRenderer* _tmp8_;
	PlankDockController* _tmp9_;
	PlankHideManager* _tmp10_;
	PlankHideManager* _tmp11_;
	gboolean result;
	plank_drag_manager_set_ExternalDragActive (self, FALSE);
	_tmp0_ = self->priv->_controller;
	_tmp1_ = plank_dock_controller_get_hover (_tmp0_);
	_tmp2_ = _tmp1_;
	gtk_widget_hide ((GtkWidget*) _tmp2_);
	_tmp3_ = self->priv->_controller;
	_tmp4_ = plank_dock_controller_get_window (_tmp3_);
	_tmp5_ = _tmp4_;
	plank_dock_window_update_hovered (_tmp5_, -1, -1);
	_tmp6_ = self->priv->_controller;
	_tmp7_ = plank_dock_controller_get_renderer (_tmp6_);
	_tmp8_ = _tmp7_;
	plank_renderer_animated_draw ((PlankRenderer*) _tmp8_);
	_tmp9_ = self->priv->_controller;
	_tmp10_ = plank_dock_controller_get_hide_manager (_tmp9_);
	_tmp11_ = _tmp10_;
	plank_hide_manager_update_hovered (_tmp11_);
	result = FALSE;
	return result;
}

static gboolean
____lambda60__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda60_ ((PlankDragManager*) self);
	return result;
}

static void
plank_drag_manager_drag_leave (GtkWidget* w,
                               GdkDragContext* context,
                               guint time_,
                               PlankDragManager* self)
{
	PlankDockController* _tmp0_;
	PlankHideManager* _tmp1_;
	PlankHideManager* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	PlankDockItem* _tmp10_;
	PlankDockController* _tmp11_;
	PlankHideManager* _tmp12_;
	PlankHideManager* _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (w != NULL);
	g_return_if_fail (context != NULL);
	if (self->priv->drag_hover_timer_id > 0U) {
		g_source_remove (self->priv->drag_hover_timer_id);
		self->priv->drag_hover_timer_id = 0U;
	}
	_tmp0_ = self->priv->_controller;
	_tmp1_ = plank_dock_controller_get_hide_manager (_tmp0_);
	_tmp2_ = _tmp1_;
	plank_hide_manager_update_hovered (_tmp2_);
	self->priv->drag_known = FALSE;
	_tmp3_ = plank_drag_manager_get_ExternalDragActive (self);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		PlankDockController* _tmp5_;
		PlankDockWindow* _tmp6_;
		PlankDockWindow* _tmp7_;
		guint _tmp8_;
		GQuark _tmp9_;
		_tmp5_ = self->priv->_controller;
		_tmp6_ = plank_dock_controller_get_window (_tmp5_);
		_tmp7_ = _tmp6_;
		g_signal_parse_name ("notify::HoveredItem", G_TYPE_OBJECT, &_tmp8_, &_tmp9_, TRUE);
		g_signal_handlers_disconnect_matched ((GObject*) _tmp7_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, _tmp9_, NULL, (GCallback) _plank_drag_manager_hovered_item_changed_g_object_notify, self);
		gdk_threads_add_idle (____lambda60__gsource_func, self);
	}
	_tmp10_ = self->priv->_DragItem;
	if (_tmp10_ == NULL) {
		return;
	}
	_tmp11_ = self->priv->_controller;
	_tmp12_ = plank_dock_controller_get_hide_manager (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = plank_hide_manager_get_Hovered (_tmp13_);
	_tmp15_ = _tmp14_;
	if (!_tmp15_) {
		PlankDockController* _tmp16_;
		PlankDockWindow* _tmp17_;
		PlankDockWindow* _tmp18_;
		PlankDockController* _tmp19_;
		PlankDockRenderer* _tmp20_;
		PlankDockRenderer* _tmp21_;
		_tmp16_ = self->priv->_controller;
		_tmp17_ = plank_dock_controller_get_window (_tmp16_);
		_tmp18_ = _tmp17_;
		plank_dock_window_update_hovered (_tmp18_, -1, -1);
		_tmp19_ = self->priv->_controller;
		_tmp20_ = plank_dock_controller_get_renderer (_tmp19_);
		_tmp21_ = _tmp20_;
		plank_renderer_animated_draw ((PlankRenderer*) _tmp21_);
	}
}

static gboolean
plank_drag_manager_drag_failed (GtkWidget* w,
                                GdkDragContext* context,
                                GtkDragResult _result_,
                                PlankDragManager* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	self->priv->drag_canceled = _result_ == GTK_DRAG_RESULT_USER_CANCELLED;
	result = !self->priv->drag_canceled;
	return result;
}

static gboolean
plank_drag_manager_drag_motion (GtkWidget* w,
                                GdkDragContext* context,
                                gint x,
                                gint y,
                                guint time_,
                                PlankDragManager* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GHashFunc _tmp6_;
	PlankDockWindow* window = NULL;
	PlankDockController* _tmp8_;
	PlankDockWindow* _tmp9_;
	PlankDockWindow* _tmp10_;
	PlankHideManager* hide_manager = NULL;
	PlankDockController* _tmp11_;
	PlankHideManager* _tmp12_;
	PlankHideManager* _tmp13_;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_;
	gboolean _tmp16_;
	gboolean _tmp27_;
	gboolean _tmp28_;
	PlankDockController* _tmp72_;
	PlankDockRenderer* _tmp73_;
	PlankDockRenderer* _tmp74_;
	PlankHideManager* _tmp75_;
	PlankDockWindow* _tmp76_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = plank_drag_manager_get_RepositionMode (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		result = TRUE;
		return result;
	}
	_tmp2_ = plank_drag_manager_get_ExternalDragActive (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->_InternalDragActive;
	if (_tmp3_ == _tmp4_) {
		gboolean _tmp5_;
		_tmp5_ = self->priv->_InternalDragActive;
		plank_drag_manager_set_ExternalDragActive (self, !_tmp5_);
	}
	_tmp6_ = g_direct_hash;
	if (self->priv->marker != _tmp6_ (context)) {
		GHashFunc _tmp7_;
		_tmp7_ = g_direct_hash;
		self->priv->marker = _tmp7_ (context);
		self->priv->drag_known = FALSE;
	}
	_tmp8_ = self->priv->_controller;
	_tmp9_ = plank_dock_controller_get_window (_tmp8_);
	_tmp10_ = _tmp9_;
	window = _tmp10_;
	_tmp11_ = self->priv->_controller;
	_tmp12_ = plank_dock_controller_get_hide_manager (_tmp11_);
	_tmp13_ = _tmp12_;
	hide_manager = _tmp13_;
	_tmp15_ = plank_drag_manager_get_ExternalDragActive (self);
	_tmp16_ = _tmp15_;
	if (_tmp16_) {
		_tmp14_ = !self->priv->drag_known;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		PlankDockWindow* _tmp17_;
		GdkAtom atom = (GdkAtom) 0U;
		PlankDockWindow* _tmp18_;
		PlankDockWindow* _tmp19_;
		GtkTargetList* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gboolean _tmp25_;
		self->priv->drag_known = TRUE;
		_tmp17_ = window;
		g_signal_connect_object ((GObject*) _tmp17_, "notify::HoveredItem", (GCallback) _plank_drag_manager_hovered_item_changed_g_object_notify, self, 0);
		_tmp18_ = window;
		_tmp19_ = window;
		_tmp20_ = gtk_drag_dest_get_target_list ((GtkWidget*) _tmp19_);
		atom = gtk_drag_dest_find_target ((GtkWidget*) _tmp18_, context, _tmp20_);
		_tmp21_ = gdk_atom_name (atom);
		_tmp22_ = _tmp21_;
		_tmp23_ = gdk_atom_name (GDK_NONE);
		_tmp24_ = _tmp23_;
		_tmp25_ = g_strcmp0 (_tmp22_, _tmp24_) != 0;
		_g_free0 (_tmp24_);
		_g_free0 (_tmp22_);
		if (_tmp25_) {
			PlankDockWindow* _tmp26_;
			self->priv->drag_data_requested = TRUE;
			_tmp26_ = window;
			gtk_drag_get_data ((GtkWidget*) _tmp26_, context, atom, (guint32) time_);
		} else {
			gdk_drag_status (context, GDK_ACTION_PRIVATE, (guint32) time_);
		}
	} else {
		gdk_drag_status (context, GDK_ACTION_COPY, (guint32) time_);
	}
	_tmp27_ = plank_drag_manager_get_ExternalDragActive (self);
	_tmp28_ = _tmp27_;
	if (_tmp28_) {
		PlankPositionManager* position_manager = NULL;
		PlankDockController* _tmp29_;
		PlankPositionManager* _tmp30_;
		PlankPositionManager* _tmp31_;
		PlankDockItem* hovered_item = NULL;
		PlankDockWindow* _tmp32_;
		PlankDockItem* _tmp33_;
		PlankDockItem* _tmp34_;
		PlankHoverWindow* hover = NULL;
		PlankDockController* _tmp35_;
		PlankHoverWindow* _tmp36_;
		PlankHoverWindow* _tmp37_;
		gboolean _tmp38_ = FALSE;
		gboolean _tmp39_ = FALSE;
		gboolean _tmp40_;
		_tmp29_ = self->priv->_controller;
		_tmp30_ = plank_dock_controller_get_position_manager (_tmp29_);
		_tmp31_ = _tmp30_;
		position_manager = _tmp31_;
		_tmp32_ = window;
		_tmp33_ = plank_dock_window_get_HoveredItem (_tmp32_);
		_tmp34_ = _tmp33_;
		hovered_item = _tmp34_;
		_tmp35_ = self->priv->_controller;
		_tmp36_ = plank_dock_controller_get_hover (_tmp35_);
		_tmp37_ = _tmp36_;
		hover = _tmp37_;
		_tmp40_ = self->priv->_DragNeedsCheck;
		if (_tmp40_) {
			PlankDockItem* _tmp41_;
			_tmp41_ = hovered_item;
			_tmp39_ = _tmp41_ != NULL;
		} else {
			_tmp39_ = FALSE;
		}
		if (_tmp39_) {
			PlankDockItem* _tmp42_;
			GeeArrayList* _tmp43_;
			_tmp42_ = hovered_item;
			_tmp43_ = self->priv->drag_data;
			_tmp38_ = plank_dock_element_can_accept_drop ((PlankDockElement*) _tmp42_, _tmp43_);
		} else {
			_tmp38_ = FALSE;
		}
		if (_tmp38_) {
			gint hx = 0;
			gint hy = 0;
			PlankPositionManager* _tmp44_;
			PlankDockItem* _tmp45_;
			gint _tmp46_ = 0;
			gint _tmp47_ = 0;
			PlankHoverWindow* _tmp48_;
			PlankDockItem* _tmp49_;
			gchar* _tmp50_;
			gchar* _tmp51_;
			PlankHoverWindow* _tmp52_;
			PlankPositionManager* _tmp53_;
			GtkPositionType _tmp54_;
			GtkPositionType _tmp55_;
			_tmp44_ = position_manager;
			_tmp45_ = hovered_item;
			plank_position_manager_get_hover_position (_tmp44_, _tmp45_, &_tmp46_, &_tmp47_);
			hx = _tmp46_;
			hy = _tmp47_;
			_tmp48_ = hover;
			_tmp49_ = hovered_item;
			_tmp50_ = plank_dock_element_get_drop_text ((PlankDockElement*) _tmp49_);
			_tmp51_ = _tmp50_;
			plank_hover_window_set_text (_tmp48_, _tmp51_);
			_g_free0 (_tmp51_);
			_tmp52_ = hover;
			_tmp53_ = position_manager;
			_tmp54_ = plank_position_manager_get_Position (_tmp53_);
			_tmp55_ = _tmp54_;
			plank_hover_window_show_at (_tmp52_, hx, hy, _tmp55_);
		} else {
			gboolean _tmp56_ = FALSE;
			PlankHideManager* _tmp57_;
			gboolean _tmp58_;
			gboolean _tmp59_;
			_tmp57_ = hide_manager;
			_tmp58_ = plank_hide_manager_get_Hovered (_tmp57_);
			_tmp59_ = _tmp58_;
			if (_tmp59_) {
				PlankDockController* _tmp60_;
				PlankDockPreferences* _tmp61_;
				PlankDockPreferences* _tmp62_;
				gboolean _tmp63_;
				gboolean _tmp64_;
				_tmp60_ = self->priv->_controller;
				_tmp61_ = plank_dock_controller_get_prefs (_tmp60_);
				_tmp62_ = _tmp61_;
				_tmp63_ = plank_dock_preferences_get_LockItems (_tmp62_);
				_tmp64_ = _tmp63_;
				_tmp56_ = !_tmp64_;
			} else {
				_tmp56_ = FALSE;
			}
			if (_tmp56_) {
				gint hx = 0;
				gint hy = 0;
				PlankPositionManager* _tmp65_;
				PlankHoverWindow* _tmp66_;
				PlankHoverWindow* _tmp67_;
				PlankPositionManager* _tmp68_;
				GtkPositionType _tmp69_;
				GtkPositionType _tmp70_;
				hx = x;
				hy = y;
				_tmp65_ = position_manager;
				plank_position_manager_get_hover_position_at (_tmp65_, &hx, &hy);
				_tmp66_ = hover;
				plank_hover_window_set_text (_tmp66_, _ ("Drop to add to dock"));
				_tmp67_ = hover;
				_tmp68_ = position_manager;
				_tmp69_ = plank_position_manager_get_Position (_tmp68_);
				_tmp70_ = _tmp69_;
				plank_hover_window_show_at (_tmp67_, hx, hy, _tmp70_);
			} else {
				PlankHoverWindow* _tmp71_;
				_tmp71_ = hover;
				gtk_widget_hide ((GtkWidget*) _tmp71_);
			}
		}
	}
	_tmp72_ = self->priv->_controller;
	_tmp73_ = plank_dock_controller_get_renderer (_tmp72_);
	_tmp74_ = _tmp73_;
	plank_dock_renderer_update_local_cursor (_tmp74_, x, y);
	_tmp75_ = hide_manager;
	plank_hide_manager_update_hovered_with_coords (_tmp75_, x, y);
	_tmp76_ = window;
	plank_dock_window_update_hovered (_tmp76_, x, y);
	result = TRUE;
	return result;
}

static gboolean
___lambda57_ (PlankDragManager* self)
{
	PlankDockItem* item = NULL;
	PlankDockController* _tmp0_;
	PlankDockWindow* _tmp1_;
	PlankDockWindow* _tmp2_;
	PlankDockItem* _tmp3_;
	PlankDockItem* _tmp4_;
	PlankDockItem* _tmp5_;
	PlankDockItem* _tmp7_;
	gboolean result;
	_tmp0_ = self->priv->_controller;
	_tmp1_ = plank_dock_controller_get_window (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = plank_dock_window_get_HoveredItem (_tmp2_);
	_tmp4_ = _tmp3_;
	item = _tmp4_;
	_tmp5_ = item;
	if (_tmp5_ != NULL) {
		PlankDockItem* _tmp6_;
		_tmp6_ = item;
		plank_dock_element_scrolled ((PlankDockElement*) _tmp6_, GDK_SCROLL_DOWN, 0, gtk_get_current_event_time ());
	} else {
		self->priv->drag_hover_timer_id = 0U;
	}
	_tmp7_ = item;
	result = _tmp7_ != NULL;
	return result;
}

static gboolean
____lambda57__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda57_ ((PlankDragManager*) self);
	return result;
}

static void
plank_drag_manager_hovered_item_changed (PlankDragManager* self)
{
	PlankDockItem* hovered_item = NULL;
	PlankDockController* _tmp0_;
	PlankDockWindow* _tmp1_;
	PlankDockWindow* _tmp2_;
	PlankDockItem* _tmp3_;
	PlankDockItem* _tmp4_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp26_;
	gboolean _tmp27_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_controller;
	_tmp1_ = plank_dock_controller_get_window (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = plank_dock_window_get_HoveredItem (_tmp2_);
	_tmp4_ = _tmp3_;
	hovered_item = _tmp4_;
	_tmp9_ = self->priv->_InternalDragActive;
	if (_tmp9_) {
		PlankDockItem* _tmp10_;
		_tmp10_ = self->priv->_DragItem;
		_tmp8_ = _tmp10_ != NULL;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		PlankDockItem* _tmp11_;
		_tmp11_ = hovered_item;
		_tmp7_ = _tmp11_ != NULL;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		PlankDockItem* _tmp12_;
		PlankDockItem* _tmp13_;
		_tmp12_ = self->priv->_DragItem;
		_tmp13_ = hovered_item;
		_tmp6_ = _tmp12_ != _tmp13_;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		PlankDockItem* _tmp14_;
		PlankDockContainer* _tmp15_;
		PlankDockContainer* _tmp16_;
		PlankDockItem* _tmp17_;
		PlankDockContainer* _tmp18_;
		PlankDockContainer* _tmp19_;
		_tmp14_ = self->priv->_DragItem;
		_tmp15_ = plank_dock_element_get_Container ((PlankDockElement*) _tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = hovered_item;
		_tmp18_ = plank_dock_element_get_Container ((PlankDockElement*) _tmp17_);
		_tmp19_ = _tmp18_;
		_tmp5_ = _tmp16_ == _tmp19_;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		PlankDockItem* _tmp20_;
		PlankDockContainer* _tmp21_;
		PlankDockContainer* _tmp22_;
		PlankDockItem* _tmp23_;
		PlankDockItem* _tmp24_;
		_tmp20_ = self->priv->_DragItem;
		_tmp21_ = plank_dock_element_get_Container ((PlankDockElement*) _tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = self->priv->_DragItem;
		_tmp24_ = hovered_item;
		plank_dock_container_move_to (_tmp22_, (PlankDockElement*) _tmp23_, (PlankDockElement*) _tmp24_);
	}
	if (self->priv->drag_hover_timer_id > 0U) {
		g_source_remove (self->priv->drag_hover_timer_id);
		self->priv->drag_hover_timer_id = 0U;
	}
	_tmp26_ = plank_drag_manager_get_ExternalDragActive (self);
	_tmp27_ = _tmp26_;
	if (_tmp27_) {
		GeeArrayList* _tmp28_;
		_tmp28_ = self->priv->drag_data;
		_tmp25_ = _tmp28_ != NULL;
	} else {
		_tmp25_ = FALSE;
	}
	if (_tmp25_) {
		self->priv->drag_hover_timer_id = gdk_threads_add_timeout ((guint) 1500, ____lambda57__gsource_func, self);
	}
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static GdkWindow*
plank_drag_manager_best_proxy_window (PlankDragManager* self)
{
	GList* window_stack = NULL;
	PlankDockController* _tmp0_;
	PlankDockWindow* _tmp1_;
	PlankDockWindow* _tmp2_;
	GdkScreen* _tmp3_;
	GList* _tmp4_;
	GList* _tmp5_;
	GdkWindow* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_controller;
	_tmp1_ = plank_dock_controller_get_window (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gtk_window_get_screen ((GtkWindow*) _tmp2_);
	_tmp4_ = gdk_screen_get_window_stack (_tmp3_);
	window_stack = _tmp4_;
	window_stack = g_list_reverse (window_stack);
	_tmp5_ = window_stack;
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp5_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			GdkWindow* _tmp6_;
			GdkWindow* window = NULL;
			_tmp6_ = _g_object_ref0 ((GdkWindow*) window_it->data);
			window = _tmp6_;
			{
				gint w_x = 0;
				gint w_y = 0;
				gint w_width = 0;
				gint w_height = 0;
				GdkWindow* _tmp7_;
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
				GdkWindow* _tmp10_;
				GdkWindow* _tmp11_;
				GdkRectangle w_geo = {0};
				GdkRectangle _tmp12_ = {0};
				gint x = 0;
				gint y = 0;
				PlankDockController* _tmp13_;
				PlankDockWindow* _tmp14_;
				PlankDockWindow* _tmp15_;
				GdkDisplay* _tmp16_;
				GdkDeviceManager* _tmp17_;
				GdkDevice* _tmp18_;
				gint _tmp19_ = 0;
				gint _tmp20_ = 0;
				gboolean _tmp21_ = FALSE;
				GdkWindow* _tmp22_;
				_tmp7_ = window;
				gdk_window_get_position (_tmp7_, &_tmp8_, &_tmp9_);
				w_x = _tmp8_;
				w_y = _tmp9_;
				_tmp10_ = window;
				w_width = gdk_window_get_width (_tmp10_);
				_tmp11_ = window;
				w_height = gdk_window_get_height (_tmp11_);
				_tmp12_.x = w_x;
				_tmp12_.y = w_y;
				_tmp12_.width = w_width;
				_tmp12_.height = w_height;
				w_geo = _tmp12_;
				_tmp13_ = self->priv->_controller;
				_tmp14_ = plank_dock_controller_get_window (_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp16_ = gtk_widget_get_display ((GtkWidget*) _tmp15_);
				_tmp17_ = gdk_display_get_device_manager (_tmp16_);
				_tmp18_ = gdk_device_manager_get_client_pointer (_tmp17_);
				gdk_device_get_position (_tmp18_, NULL, &_tmp19_, &_tmp20_);
				x = _tmp19_;
				y = _tmp20_;
				_tmp22_ = window;
				if (gdk_window_is_visible (_tmp22_)) {
					GdkRectangle _tmp23_ = {0};
					_tmp23_.x = x;
					_tmp23_.y = y;
					_tmp23_.width = 0;
					_tmp23_.height = 0;
					_tmp21_ = gdk_rectangle_intersect (&w_geo, &_tmp23_, NULL);
				} else {
					_tmp21_ = FALSE;
				}
				if (_tmp21_) {
					result = window;
					(window_stack == NULL) ? NULL : (window_stack = (_g_list_free__g_object_unref0_ (window_stack), NULL));
					return result;
				}
				_g_object_unref0 (window);
			}
		}
	}
	result = NULL;
	(window_stack == NULL) ? NULL : (window_stack = (_g_list_free__g_object_unref0_ (window_stack), NULL));
	return result;
}

void
plank_drag_manager_ensure_proxy (PlankDragManager* self)
{
	gboolean _tmp0_;
	PlankDockController* _tmp1_;
	PlankHideManager* _tmp2_;
	PlankHideManager* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	GdkModifierType mod = 0U;
	gdouble* axes = NULL;
	gdouble* _tmp10_;
	gint axes_length1;
	gint _axes_size_;
	PlankDockController* _tmp11_;
	PlankDockWindow* _tmp12_;
	PlankDockWindow* _tmp13_;
	GdkDisplay* _tmp14_;
	GdkDeviceManager* _tmp15_;
	GdkDevice* _tmp16_;
	PlankDockController* _tmp17_;
	PlankDockWindow* _tmp18_;
	PlankDockWindow* _tmp19_;
	GdkWindow* _tmp20_;
	gdouble* _tmp21_;
	gint _tmp21__length1;
	GdkModifierType _tmp22_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_InternalDragActive;
	if (_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->_controller;
	_tmp2_ = plank_dock_controller_get_hide_manager (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = plank_hide_manager_get_Hovered (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		GdkWindow* _tmp6_;
		PlankDockController* _tmp7_;
		PlankDockWindow* _tmp8_;
		PlankDockWindow* _tmp9_;
		_tmp6_ = self->priv->proxy_window;
		if (_tmp6_ == NULL) {
			return;
		}
		_g_object_unref0 (self->priv->proxy_window);
		self->priv->proxy_window = NULL;
		_tmp7_ = self->priv->_controller;
		_tmp8_ = plank_dock_controller_get_window (_tmp7_);
		_tmp9_ = _tmp8_;
		plank_drag_manager_enable_drag_to (self, _tmp9_);
		return;
	}
	_tmp10_ = g_new0 (gdouble, 0);
	axes = _tmp10_;
	axes_length1 = 0;
	_axes_size_ = axes_length1;
	_tmp11_ = self->priv->_controller;
	_tmp12_ = plank_dock_controller_get_window (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = gtk_widget_get_display ((GtkWidget*) _tmp13_);
	_tmp15_ = gdk_display_get_device_manager (_tmp14_);
	_tmp16_ = gdk_device_manager_get_client_pointer (_tmp15_);
	_tmp17_ = self->priv->_controller;
	_tmp18_ = plank_dock_controller_get_window (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = gtk_widget_get_window ((GtkWidget*) _tmp19_);
	_tmp21_ = axes;
	_tmp21__length1 = axes_length1;
	gdk_device_get_state (_tmp16_, _tmp20_, _tmp21_, &_tmp22_);
	mod = _tmp22_;
	if ((mod & GDK_BUTTON1_MASK) == GDK_BUTTON1_MASK) {
		GdkWindow* bestProxy = NULL;
		GdkWindow* _tmp23_;
		gboolean _tmp24_ = FALSE;
		GdkWindow* _tmp25_;
		_tmp23_ = plank_drag_manager_best_proxy_window (self);
		bestProxy = _tmp23_;
		_tmp25_ = bestProxy;
		if (_tmp25_ != NULL) {
			GdkWindow* _tmp26_;
			GdkWindow* _tmp27_;
			_tmp26_ = self->priv->proxy_window;
			_tmp27_ = bestProxy;
			_tmp24_ = _tmp26_ != _tmp27_;
		} else {
			_tmp24_ = FALSE;
		}
		if (_tmp24_) {
			GdkWindow* _tmp28_;
			GdkWindow* _tmp29_;
			PlankDockController* _tmp30_;
			PlankDockWindow* _tmp31_;
			PlankDockWindow* _tmp32_;
			GdkWindow* _tmp33_;
			_tmp28_ = bestProxy;
			_tmp29_ = _g_object_ref0 (_tmp28_);
			_g_object_unref0 (self->priv->proxy_window);
			self->priv->proxy_window = _tmp29_;
			_tmp30_ = self->priv->_controller;
			_tmp31_ = plank_dock_controller_get_window (_tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = self->priv->proxy_window;
			gtk_drag_dest_set_proxy ((GtkWidget*) _tmp32_, _tmp33_, GDK_DRAG_PROTO_XDND, TRUE);
		}
		_g_object_unref0 (bestProxy);
	}
	axes = (g_free (axes), NULL);
}

static void
plank_drag_manager_enable_drag_to (PlankDragManager* self,
                                   PlankDockWindow* window)
{
	GtkTargetEntry te1 = {0};
	GtkTargetEntry _tmp0_ = {0};
	GtkTargetEntry te2 = {0};
	GtkTargetEntry _tmp1_ = {0};
	GtkTargetEntry _tmp2_;
	GtkTargetEntry _tmp3_;
	GtkTargetEntry* _tmp4_;
	GtkTargetEntry* _tmp5_;
	gint _tmp5__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_.target = "text/uri-list";
	_tmp0_.flags = (guint) 0;
	_tmp0_.info = (guint) 0;
	te1 = _tmp0_;
	_tmp1_.target = "text/plank-uri-list";
	_tmp1_.flags = (guint) 0;
	_tmp1_.info = (guint) 0;
	te2 = _tmp1_;
	_tmp2_ = te1;
	_tmp3_ = te2;
	_tmp4_ = g_new0 (GtkTargetEntry, 2);
	_tmp4_[0] = _tmp2_;
	_tmp4_[1] = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp5__length1 = 2;
	gtk_drag_dest_set ((GtkWidget*) window, 0, _tmp5_, (gint) 2, GDK_ACTION_COPY);
	_tmp5_ = (g_free (_tmp5_), NULL);
}

static void
plank_drag_manager_disable_drag_to (PlankDragManager* self,
                                    PlankDockWindow* window)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	gtk_drag_dest_unset ((GtkWidget*) window);
}

static void
plank_drag_manager_enable_drag_from (PlankDragManager* self,
                                     PlankDockWindow* window)
{
	GtkTargetEntry te = {0};
	GtkTargetEntry _tmp0_ = {0};
	GtkTargetEntry _tmp1_;
	GtkTargetEntry* _tmp2_;
	GtkTargetEntry* _tmp3_;
	gint _tmp3__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_.target = "text/plank-uri-list";
	_tmp0_.flags = (guint) GTK_TARGET_SAME_APP;
	_tmp0_.info = (guint) 0;
	te = _tmp0_;
	_tmp1_ = te;
	_tmp2_ = g_new0 (GtkTargetEntry, 1);
	_tmp2_[0] = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp3__length1 = 1;
	gtk_drag_source_set ((GtkWidget*) window, GDK_BUTTON1_MASK, _tmp3_, (gint) 1, GDK_ACTION_PRIVATE);
	_tmp3_ = (g_free (_tmp3_), NULL);
}

static void
plank_drag_manager_disable_drag_from (PlankDragManager* self,
                                      PlankDockWindow* window)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	gtk_drag_source_unset ((GtkWidget*) window);
}

static PlankDockController*
plank_drag_manager_get_controller (PlankDragManager* self)
{
	PlankDockController* result;
	PlankDockController* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_controller;
	result = _tmp0_;
	return result;
}

static void
plank_drag_manager_set_controller (PlankDragManager* self,
                                   PlankDockController* value)
{
	PlankDockController* old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_drag_manager_get_controller (self);
	if (old_value != value) {
		PlankDockController* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_controller);
		self->priv->_controller = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plank_drag_manager_properties[PLANK_DRAG_MANAGER_CONTROLLER_PROPERTY]);
	}
}

gboolean
plank_drag_manager_get_InternalDragActive (PlankDragManager* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_InternalDragActive;
	return result;
}

static void
plank_drag_manager_set_InternalDragActive (PlankDragManager* self,
                                           gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_drag_manager_get_InternalDragActive (self);
	if (old_value != value) {
		self->priv->_InternalDragActive = value;
		g_object_notify_by_pspec ((GObject *) self, plank_drag_manager_properties[PLANK_DRAG_MANAGER_INTERNAL_DRAG_ACTIVE_PROPERTY]);
	}
}

PlankDockItem*
plank_drag_manager_get_DragItem (PlankDragManager* self)
{
	PlankDockItem* result;
	PlankDockItem* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_DragItem;
	result = _tmp0_;
	return result;
}

static void
plank_drag_manager_set_DragItem (PlankDragManager* self,
                                 PlankDockItem* value)
{
	PlankDockItem* old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_drag_manager_get_DragItem (self);
	if (old_value != value) {
		PlankDockItem* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_DragItem);
		self->priv->_DragItem = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plank_drag_manager_properties[PLANK_DRAG_MANAGER_DRAG_ITEM_PROPERTY]);
	}
}

gboolean
plank_drag_manager_get_DragNeedsCheck (PlankDragManager* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_DragNeedsCheck;
	return result;
}

static void
plank_drag_manager_set_DragNeedsCheck (PlankDragManager* self,
                                       gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_drag_manager_get_DragNeedsCheck (self);
	if (old_value != value) {
		self->priv->_DragNeedsCheck = value;
		g_object_notify_by_pspec ((GObject *) self, plank_drag_manager_properties[PLANK_DRAG_MANAGER_DRAG_NEEDS_CHECK_PROPERTY]);
	}
}

gboolean
plank_drag_manager_get_ExternalDragActive (PlankDragManager* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->external_drag_active;
	return result;
}

static void
plank_drag_manager_set_ExternalDragActive (PlankDragManager* self,
                                           gboolean value)
{
	g_return_if_fail (self != NULL);
	if (self->priv->external_drag_active == value) {
		return;
	}
	self->priv->external_drag_active = value;
	if (!value) {
		self->priv->drag_known = FALSE;
		_g_object_unref0 (self->priv->drag_data);
		self->priv->drag_data = NULL;
		self->priv->drag_data_requested = FALSE;
		plank_drag_manager_set_DragNeedsCheck (self, TRUE);
	}
	g_object_notify_by_pspec ((GObject *) self, plank_drag_manager_properties[PLANK_DRAG_MANAGER_EXTERNAL_DRAG_ACTIVE_PROPERTY]);
}

gboolean
plank_drag_manager_get_RepositionMode (PlankDragManager* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->reposition_mode;
	return result;
}

static void
plank_drag_manager_set_RepositionMode (PlankDragManager* self,
                                       gboolean value)
{
	g_return_if_fail (self != NULL);
	if (self->priv->reposition_mode == value) {
		return;
	}
	self->priv->reposition_mode = value;
	if (self->priv->reposition_mode) {
		PlankDockController* _tmp0_;
		PlankDockWindow* _tmp1_;
		PlankDockWindow* _tmp2_;
		_tmp0_ = self->priv->_controller;
		_tmp1_ = plank_dock_controller_get_window (_tmp0_);
		_tmp2_ = _tmp1_;
		plank_drag_manager_disable_drag_to (self, _tmp2_);
	} else {
		PlankDockController* _tmp3_;
		PlankDockWindow* _tmp4_;
		PlankDockWindow* _tmp5_;
		_tmp3_ = self->priv->_controller;
		_tmp4_ = plank_dock_controller_get_window (_tmp3_);
		_tmp5_ = _tmp4_;
		plank_drag_manager_enable_drag_to (self, _tmp5_);
	}
	g_object_notify_by_pspec ((GObject *) self, plank_drag_manager_properties[PLANK_DRAG_MANAGER_REPOSITION_MODE_PROPERTY]);
}

static void
plank_drag_manager_class_init (PlankDragManagerClass * klass,
                               gpointer klass_data)
{
	plank_drag_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PlankDragManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_plank_drag_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_plank_drag_manager_set_property;
	G_OBJECT_CLASS (klass)->finalize = plank_drag_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DRAG_MANAGER_CONTROLLER_PROPERTY, plank_drag_manager_properties[PLANK_DRAG_MANAGER_CONTROLLER_PROPERTY] = g_param_spec_object ("controller", "controller", "controller", PLANK_TYPE_DOCK_CONTROLLER, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DRAG_MANAGER_INTERNAL_DRAG_ACTIVE_PROPERTY, plank_drag_manager_properties[PLANK_DRAG_MANAGER_INTERNAL_DRAG_ACTIVE_PROPERTY] = g_param_spec_boolean ("InternalDragActive", "InternalDragActive", "InternalDragActive", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DRAG_MANAGER_DRAG_ITEM_PROPERTY, plank_drag_manager_properties[PLANK_DRAG_MANAGER_DRAG_ITEM_PROPERTY] = g_param_spec_object ("DragItem", "DragItem", "DragItem", PLANK_TYPE_DOCK_ITEM, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DRAG_MANAGER_DRAG_NEEDS_CHECK_PROPERTY, plank_drag_manager_properties[PLANK_DRAG_MANAGER_DRAG_NEEDS_CHECK_PROPERTY] = g_param_spec_boolean ("DragNeedsCheck", "DragNeedsCheck", "DragNeedsCheck", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DRAG_MANAGER_EXTERNAL_DRAG_ACTIVE_PROPERTY, plank_drag_manager_properties[PLANK_DRAG_MANAGER_EXTERNAL_DRAG_ACTIVE_PROPERTY] = g_param_spec_boolean ("ExternalDragActive", "ExternalDragActive", "ExternalDragActive", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DRAG_MANAGER_REPOSITION_MODE_PROPERTY, plank_drag_manager_properties[PLANK_DRAG_MANAGER_REPOSITION_MODE_PROPERTY] = g_param_spec_boolean ("RepositionMode", "RepositionMode", "RepositionMode", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
plank_drag_manager_instance_init (PlankDragManager * self,
                                  gpointer klass)
{
	self->priv = plank_drag_manager_get_instance_private (self);
	self->priv->_InternalDragActive = FALSE;
	self->priv->_DragItem = NULL;
	self->priv->_DragNeedsCheck = TRUE;
	self->priv->external_drag_active = FALSE;
	self->priv->reposition_mode = FALSE;
	self->priv->proxy_window = NULL;
	self->priv->drag_canceled = FALSE;
	self->priv->drag_known = FALSE;
	self->priv->drag_data_requested = FALSE;
	self->priv->marker = 0U;
	self->priv->drag_hover_timer_id = 0U;
	self->priv->drag_data = NULL;
	self->priv->window_scale_factor = 1;
	self->priv->drag_item_redraw_handler_id = 0UL;
}

static void
plank_drag_manager_finalize (GObject * obj)
{
	PlankDragManager * self;
	PlankDockWindow* window = NULL;
	PlankDockController* _tmp0_;
	PlankDockWindow* _tmp1_;
	PlankDockWindow* _tmp2_;
	PlankDockWindow* _tmp3_;
	guint _tmp4_;
	PlankDockWindow* _tmp5_;
	guint _tmp6_;
	PlankDockWindow* _tmp7_;
	guint _tmp8_;
	PlankDockWindow* _tmp9_;
	guint _tmp10_;
	PlankDockWindow* _tmp11_;
	guint _tmp12_;
	PlankDockWindow* _tmp13_;
	guint _tmp14_;
	PlankDockWindow* _tmp15_;
	guint _tmp16_;
	PlankDockWindow* _tmp17_;
	guint _tmp18_;
	PlankDockController* _tmp19_;
	PlankDockPreferences* _tmp20_;
	PlankDockPreferences* _tmp21_;
	guint _tmp22_;
	GQuark _tmp23_;
	PlankDockWindow* _tmp24_;
	PlankDockWindow* _tmp25_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_DRAG_MANAGER, PlankDragManager);
	_tmp0_ = self->priv->_controller;
	_tmp1_ = plank_dock_controller_get_window (_tmp0_);
	_tmp2_ = _tmp1_;
	window = _tmp2_;
	_tmp3_ = window;
	g_signal_parse_name ("drag-motion", gtk_widget_get_type (), &_tmp4_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkWidget*) _tmp3_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _plank_drag_manager_drag_motion_gtk_widget_drag_motion, self);
	_tmp5_ = window;
	g_signal_parse_name ("drag-begin", gtk_widget_get_type (), &_tmp6_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkWidget*) _tmp5_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _plank_drag_manager_drag_begin_gtk_widget_drag_begin, self);
	_tmp7_ = window;
	g_signal_parse_name ("drag-data-received", gtk_widget_get_type (), &_tmp8_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkWidget*) _tmp7_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, 0, NULL, (GCallback) _plank_drag_manager_drag_data_received_gtk_widget_drag_data_received, self);
	_tmp9_ = window;
	g_signal_parse_name ("drag-data-get", gtk_widget_get_type (), &_tmp10_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkWidget*) _tmp9_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp10_, 0, NULL, (GCallback) _plank_drag_manager_drag_data_get_gtk_widget_drag_data_get, self);
	_tmp11_ = window;
	g_signal_parse_name ("drag-drop", gtk_widget_get_type (), &_tmp12_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkWidget*) _tmp11_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp12_, 0, NULL, (GCallback) _plank_drag_manager_drag_drop_gtk_widget_drag_drop, self);
	_tmp13_ = window;
	g_signal_parse_name ("drag-end", gtk_widget_get_type (), &_tmp14_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkWidget*) _tmp13_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp14_, 0, NULL, (GCallback) _plank_drag_manager_drag_end_gtk_widget_drag_end, self);
	_tmp15_ = window;
	g_signal_parse_name ("drag-leave", gtk_widget_get_type (), &_tmp16_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkWidget*) _tmp15_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp16_, 0, NULL, (GCallback) _plank_drag_manager_drag_leave_gtk_widget_drag_leave, self);
	_tmp17_ = window;
	g_signal_parse_name ("drag-failed", gtk_widget_get_type (), &_tmp18_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkWidget*) _tmp17_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp18_, 0, NULL, (GCallback) _plank_drag_manager_drag_failed_gtk_widget_drag_failed, self);
	_tmp19_ = self->priv->_controller;
	_tmp20_ = plank_dock_controller_get_prefs (_tmp19_);
	_tmp21_ = _tmp20_;
	g_signal_parse_name ("notify::LockItems", G_TYPE_OBJECT, &_tmp22_, &_tmp23_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp21_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp22_, _tmp23_, NULL, (GCallback) _plank_drag_manager_lock_items_changed_g_object_notify, self);
	_tmp24_ = window;
	plank_drag_manager_disable_drag_to (self, _tmp24_);
	_tmp25_ = window;
	plank_drag_manager_disable_drag_from (self, _tmp25_);
	_g_object_unref0 (self->priv->_controller);
	_g_object_unref0 (self->priv->_DragItem);
	_g_object_unref0 (self->priv->proxy_window);
	_g_object_unref0 (self->priv->drag_data);
	G_OBJECT_CLASS (plank_drag_manager_parent_class)->finalize (obj);
}

/**
 * Handles all of the drag'n'drop events for a dock.
 */
static GType
plank_drag_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PlankDragManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plank_drag_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PlankDragManager), 0, (GInstanceInitFunc) plank_drag_manager_instance_init, NULL };
	GType plank_drag_manager_type_id;
	plank_drag_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "PlankDragManager", &g_define_type_info, 0);
	PlankDragManager_private_offset = g_type_add_instance_private (plank_drag_manager_type_id, sizeof (PlankDragManagerPrivate));
	return plank_drag_manager_type_id;
}

GType
plank_drag_manager_get_type (void)
{
	static volatile gsize plank_drag_manager_type_id__once = 0;
	if (g_once_init_enter (&plank_drag_manager_type_id__once)) {
		GType plank_drag_manager_type_id;
		plank_drag_manager_type_id = plank_drag_manager_get_type_once ();
		g_once_init_leave (&plank_drag_manager_type_id__once, plank_drag_manager_type_id);
	}
	return plank_drag_manager_type_id__once;
}

static void
_vala_plank_drag_manager_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	PlankDragManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLANK_TYPE_DRAG_MANAGER, PlankDragManager);
	switch (property_id) {
		case PLANK_DRAG_MANAGER_CONTROLLER_PROPERTY:
		g_value_set_object (value, plank_drag_manager_get_controller (self));
		break;
		case PLANK_DRAG_MANAGER_INTERNAL_DRAG_ACTIVE_PROPERTY:
		g_value_set_boolean (value, plank_drag_manager_get_InternalDragActive (self));
		break;
		case PLANK_DRAG_MANAGER_DRAG_ITEM_PROPERTY:
		g_value_set_object (value, plank_drag_manager_get_DragItem (self));
		break;
		case PLANK_DRAG_MANAGER_DRAG_NEEDS_CHECK_PROPERTY:
		g_value_set_boolean (value, plank_drag_manager_get_DragNeedsCheck (self));
		break;
		case PLANK_DRAG_MANAGER_EXTERNAL_DRAG_ACTIVE_PROPERTY:
		g_value_set_boolean (value, plank_drag_manager_get_ExternalDragActive (self));
		break;
		case PLANK_DRAG_MANAGER_REPOSITION_MODE_PROPERTY:
		g_value_set_boolean (value, plank_drag_manager_get_RepositionMode (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_plank_drag_manager_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	PlankDragManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLANK_TYPE_DRAG_MANAGER, PlankDragManager);
	switch (property_id) {
		case PLANK_DRAG_MANAGER_CONTROLLER_PROPERTY:
		plank_drag_manager_set_controller (self, g_value_get_object (value));
		break;
		case PLANK_DRAG_MANAGER_INTERNAL_DRAG_ACTIVE_PROPERTY:
		plank_drag_manager_set_InternalDragActive (self, g_value_get_boolean (value));
		break;
		case PLANK_DRAG_MANAGER_DRAG_ITEM_PROPERTY:
		plank_drag_manager_set_DragItem (self, g_value_get_object (value));
		break;
		case PLANK_DRAG_MANAGER_DRAG_NEEDS_CHECK_PROPERTY:
		plank_drag_manager_set_DragNeedsCheck (self, g_value_get_boolean (value));
		break;
		case PLANK_DRAG_MANAGER_EXTERNAL_DRAG_ACTIVE_PROPERTY:
		plank_drag_manager_set_ExternalDragActive (self, g_value_get_boolean (value));
		break;
		case PLANK_DRAG_MANAGER_REPOSITION_MODE_PROPERTY:
		plank_drag_manager_set_RepositionMode (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

