/* HoverWindow.c generated by valac 0.56.17, the Vala compiler
 * generated from HoverWindow.vala, do not modify */

/**/
/*  Copyright (C) 2011-2012 Robert Dyer, Rico Tzschichholz*/
/**/
/*  This file is part of Plank.*/
/**/
/*  Plank is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  Plank is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include "plank.h"
#include <gtk/gtk.h>
#include <cairo-gobject.h>
#include <glib.h>
#include <glib-object.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <atk/atk.h>
#include "gtk-compat.h"

#define PLANK_HOVER_WINDOW_PADDING 10
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PLANK_HOVER_WINDOW_0_PROPERTY,
	PLANK_HOVER_WINDOW_NUM_PROPERTIES
};
static GParamSpec* plank_hover_window_properties[PLANK_HOVER_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_region_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_region_destroy (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_type_class_unref0(var) ((var == NULL) ? NULL : (var = (g_type_class_unref (var), NULL)))

struct _PlankHoverWindowPrivate {
	GtkBox* box;
	GtkLabel* label;
};

static gint PlankHoverWindow_private_offset;
static gpointer plank_hover_window_parent_class = NULL;

static gboolean plank_hover_window_real_draw (GtkWidget* base,
                                       cairo_t* cr);
static GObject * plank_hover_window_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties);
static void plank_hover_window_finalize (GObject * obj);
static GType plank_hover_window_get_type_once (void);

static inline gpointer
plank_hover_window_get_instance_private (PlankHoverWindow* self)
{
	return G_STRUCT_MEMBER_P (self, PlankHoverWindow_private_offset);
}

PlankHoverWindow*
plank_hover_window_construct (GType object_type)
{
	PlankHoverWindow * self = NULL;
	self = (PlankHoverWindow*) g_object_new (object_type, "type", GTK_WINDOW_POPUP, "type-hint", GDK_WINDOW_TYPE_HINT_TOOLTIP, NULL);
	return self;
}

PlankHoverWindow*
plank_hover_window_new (void)
{
	return plank_hover_window_construct (PLANK_TYPE_HOVER_WINDOW);
}

/**
 * Shows and centers the window according to the x/y location specified
 * while accounting the dock's position.
 *
 * @param x the x location
 * @param y the y location
 * @param position the dock's position
 */
void
plank_hover_window_show_at (PlankHoverWindow* self,
                            gint x,
                            gint y,
                            GtkPositionType position)
{
	GdkScreen* screen = NULL;
	GdkScreen* _tmp0_;
	GdkRectangle monitor = {0};
	GdkScreen* _tmp1_;
	GdkScreen* _tmp2_;
	GdkRectangle _tmp3_ = {0};
	gint width = 0;
	gint height = 0;
	GdkRectangle _tmp4_;
	GdkRectangle _tmp5_;
	GdkRectangle _tmp6_;
	GdkRectangle _tmp7_;
	GdkRectangle _tmp8_;
	GdkRectangle _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_window_get_screen ((GtkWindow*) self);
	screen = _tmp0_;
	_tmp1_ = screen;
	_tmp2_ = screen;
	gdk_screen_get_monitor_geometry (_tmp1_, gdk_screen_get_monitor_at_point (_tmp2_, x, y), &_tmp3_);
	monitor = _tmp3_;
	gtk_widget_show ((GtkWidget*) self);
	width = gtk_widget_get_allocated_width ((GtkWidget*) self);
	height = gtk_widget_get_allocated_height ((GtkWidget*) self);
	switch (position) {
		case GTK_POS_BOTTOM:
		{
			x = x - (width / 2);
			y = (y - height) - PLANK_HOVER_WINDOW_PADDING;
			break;
		}
		case GTK_POS_TOP:
		{
			x = x - (width / 2);
			y = y + PLANK_HOVER_WINDOW_PADDING;
			break;
		}
		case GTK_POS_LEFT:
		{
			x = x + PLANK_HOVER_WINDOW_PADDING;
			y = y - (height / 2);
			break;
		}
		case GTK_POS_RIGHT:
		{
			x = (x - width) - PLANK_HOVER_WINDOW_PADDING;
			y = y - (height / 2);
			break;
		}
		default:
		break;
	}
	_tmp4_ = monitor;
	_tmp5_ = monitor;
	_tmp6_ = monitor;
	x = CLAMP (x, _tmp4_.x, (_tmp5_.x + _tmp6_.width) - width);
	_tmp7_ = monitor;
	_tmp8_ = monitor;
	_tmp9_ = monitor;
	y = CLAMP (y, _tmp7_.y, (_tmp8_.y + _tmp9_.height) - height);
	gtk_window_move ((GtkWindow*) self, x, y);
}

/**
 * Set the tooltip-text to show
 *
 * @param text the text to show
 */
void
plank_hover_window_set_text (PlankHoverWindow* self,
                             const gchar* text)
{
	GtkLabel* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = self->priv->label;
	gtk_label_set_text (_tmp0_, text);
	if (text != NULL) {
		GtkLabel* _tmp1_;
		_tmp1_ = self->priv->label;
		gtk_widget_show ((GtkWidget*) _tmp1_);
	} else {
		GtkLabel* _tmp2_;
		_tmp2_ = self->priv->label;
		gtk_widget_hide ((GtkWidget*) _tmp2_);
	}
}

/**
 * {@inheritDoc}
 */
static gboolean
plank_hover_window_real_draw (GtkWidget* base,
                              cairo_t* cr)
{
	PlankHoverWindow * self;
	gint width = 0;
	gint height = 0;
	GtkStyleContext* context = NULL;
	GtkStyleContext* _tmp0_;
	gboolean result;
	self = (PlankHoverWindow*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	width = gtk_widget_get_allocated_width ((GtkWidget*) self);
	height = gtk_widget_get_allocated_height ((GtkWidget*) self);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	context = _tmp0_;
	if (gtk_widget_is_composited ((GtkWidget*) self)) {
		GtkStyleContext* _tmp1_;
		GtkStyleContext* _tmp2_;
		cairo_save (cr);
		cairo_set_operator (cr, CAIRO_OPERATOR_CLEAR);
		cairo_paint (cr);
		cairo_restore (cr);
		gtk_widget_shape_combine_region ((GtkWidget*) self, NULL);
		_tmp1_ = context;
		gtk_render_background (_tmp1_, cr, (gdouble) 0, (gdouble) 0, (gdouble) width, (gdouble) height);
		_tmp2_ = context;
		gtk_render_frame (_tmp2_, cr, (gdouble) 0, (gdouble) 0, (gdouble) width, (gdouble) height);
	} else {
		cairo_surface_t* surface = NULL;
		GdkWindow* _tmp3_;
		cairo_surface_t* _tmp4_;
		cairo_t* compat_cr = NULL;
		cairo_surface_t* _tmp5_;
		cairo_t* _tmp6_;
		GtkStyleContext* _tmp7_;
		cairo_t* _tmp8_;
		GtkStyleContext* _tmp9_;
		cairo_t* _tmp10_;
		cairo_region_t* region = NULL;
		cairo_surface_t* _tmp11_;
		cairo_region_t* _tmp12_;
		cairo_region_t* _tmp13_;
		_tmp3_ = gtk_widget_get_window ((GtkWidget*) self);
		_tmp4_ = gdk_window_create_similar_surface (_tmp3_, CAIRO_CONTENT_COLOR_ALPHA, width, height);
		surface = _tmp4_;
		_tmp5_ = surface;
		_tmp6_ = cairo_create (_tmp5_);
		compat_cr = _tmp6_;
		_tmp7_ = context;
		_tmp8_ = compat_cr;
		gtk_render_background (_tmp7_, _tmp8_, (gdouble) 0, (gdouble) 0, (gdouble) width, (gdouble) height);
		_tmp9_ = context;
		_tmp10_ = compat_cr;
		gtk_render_frame (_tmp9_, _tmp10_, (gdouble) 0, (gdouble) 0, (gdouble) width, (gdouble) height);
		_tmp11_ = surface;
		_tmp12_ = gdk_cairo_region_create_from_surface (_tmp11_);
		region = _tmp12_;
		_tmp13_ = region;
		gtk_widget_shape_combine_region ((GtkWidget*) self, _tmp13_);
		_cairo_region_destroy0 (region);
		_cairo_destroy0 (compat_cr);
		_cairo_surface_destroy0 (surface);
	}
	result = GTK_WIDGET_CLASS (plank_hover_window_parent_class)->draw ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), cr);
	return result;
}

static GObject *
plank_hover_window_constructor (GType type,
                                guint n_construct_properties,
                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PlankHoverWindow * self;
	GdkScreen* screen = NULL;
	GdkScreen* _tmp0_;
	GdkVisual* _tmp1_ = NULL;
	GdkScreen* _tmp2_;
	GdkVisual* _tmp3_;
	GtkStyleContext* _tmp6_;
	GtkBox* _tmp7_;
	GtkBox* _tmp8_;
	GtkBox* _tmp9_;
	GtkBox* _tmp10_;
	GtkBox* _tmp11_;
	GtkBox* _tmp12_;
	GtkBox* _tmp13_;
	GtkLabel* _tmp14_;
	GtkLabel* _tmp15_;
	GtkBox* _tmp16_;
	GtkLabel* _tmp17_;
	parent_class = G_OBJECT_CLASS (plank_hover_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_HOVER_WINDOW, PlankHoverWindow);
	gtk_widget_set_app_paintable ((GtkWidget*) self, TRUE);
	gtk_window_set_resizable ((GtkWindow*) self, FALSE);
	_tmp0_ = gtk_window_get_screen ((GtkWindow*) self);
	screen = _tmp0_;
	_tmp2_ = screen;
	_tmp3_ = gdk_screen_get_rgba_visual (_tmp2_);
	_tmp1_ = _tmp3_;
	if (_tmp1_ == NULL) {
		GdkScreen* _tmp4_;
		GdkVisual* _tmp5_;
		_tmp4_ = screen;
		_tmp5_ = gdk_screen_get_system_visual (_tmp4_);
		_tmp1_ = _tmp5_;
	}
	gtk_widget_set_visual ((GtkWidget*) self, _tmp1_);
	_tmp6_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp6_, GTK_STYLE_CLASS_TOOLTIP);
	_tmp7_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->box);
	self->priv->box = _tmp7_;
	_tmp8_ = self->priv->box;
	gtk_widget_set_margin_left ((GtkWidget*) _tmp8_, 6);
	_tmp9_ = self->priv->box;
	gtk_widget_set_margin_right ((GtkWidget*) _tmp9_, 6);
	_tmp10_ = self->priv->box;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp10_, 6);
	_tmp11_ = self->priv->box;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp11_, 6);
	_tmp12_ = self->priv->box;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp12_);
	_tmp13_ = self->priv->box;
	gtk_widget_show ((GtkWidget*) _tmp13_);
	_tmp14_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp14_);
	_g_object_unref0 (self->priv->label);
	self->priv->label = _tmp14_;
	_tmp15_ = self->priv->label;
	gtk_label_set_line_wrap (_tmp15_, TRUE);
	_tmp16_ = self->priv->box;
	_tmp17_ = self->priv->label;
	gtk_box_pack_start (_tmp16_, (GtkWidget*) _tmp17_, FALSE, FALSE, (guint) 0);
	return obj;
}

static void
plank_hover_window_class_init (PlankHoverWindowClass * klass,
                               gpointer klass_data)
{
	GTypeClass* _tmp0_;
	GObjectClass* _tmp1_;
	plank_hover_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PlankHoverWindow_private_offset);
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget*, cairo_t*)) plank_hover_window_real_draw;
	G_OBJECT_CLASS (klass)->constructor = plank_hover_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = plank_hover_window_finalize;
	gtk_widget_class_set_accessible_role (GTK_WIDGET_CLASS (klass), ATK_ROLE_TOOL_TIP);
	_tmp0_ = g_type_class_ref (PLANK_TYPE_HOVER_WINDOW);
	_tmp1_ = (GObjectClass*) _tmp0_;
	plank_compat_gtk_widget_class_set_css_name (_tmp1_, "tooltip");
	_g_type_class_unref0 (_tmp1_);
}

static void
plank_hover_window_instance_init (PlankHoverWindow * self,
                                  gpointer klass)
{
	self->priv = plank_hover_window_get_instance_private (self);
}

static void
plank_hover_window_finalize (GObject * obj)
{
	PlankHoverWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_HOVER_WINDOW, PlankHoverWindow);
	_g_object_unref0 (self->priv->box);
	_g_object_unref0 (self->priv->label);
	G_OBJECT_CLASS (plank_hover_window_parent_class)->finalize (obj);
}

/**
 * A hover window that shows labels for dock items.
 * This window floats outside (but near) the dock.
 */
static GType
plank_hover_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PlankHoverWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plank_hover_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PlankHoverWindow), 0, (GInstanceInitFunc) plank_hover_window_instance_init, NULL };
	GType plank_hover_window_type_id;
	plank_hover_window_type_id = g_type_register_static (gtk_window_get_type (), "PlankHoverWindow", &g_define_type_info, 0);
	PlankHoverWindow_private_offset = g_type_add_instance_private (plank_hover_window_type_id, sizeof (PlankHoverWindowPrivate));
	return plank_hover_window_type_id;
}

GType
plank_hover_window_get_type (void)
{
	static volatile gsize plank_hover_window_type_id__once = 0;
	if (g_once_init_enter (&plank_hover_window_type_id__once)) {
		GType plank_hover_window_type_id;
		plank_hover_window_type_id = plank_hover_window_get_type_once ();
		g_once_init_leave (&plank_hover_window_type_id__once, plank_hover_window_type_id);
	}
	return plank_hover_window_type_id__once;
}

