// Copyright © 2023-2025 Advanced Micro Devices, Inc.
// SPDX-License-Identifier: MIT

#include "../shim.attn_fwd.h"
#include <aotriton/_internal/triton_kernel.h>
#include <aotriton/_internal/kernel_cluster.h>
#include <aotriton/cpp_tune.h>
#include <string_view>
#ifndef NDEBUG
#include <iostream>
#endif

#define CURRENT_ENTRY_PUBLIC Autotune_attn_fwd__A1__F429

#define ARRAY_SIZE(array)  (sizeof(array) / sizeof(array[0]))

namespace { // Anonymous namespace

using namespace std::literals::string_view_literals;

#if AOTRITON_BUILD_FOR_TUNING
// PSels and Copts in JSON String
static const char* kernel_psels[] = {
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw"
};
static const char* kernel_copts[] = {
  R"xyzw({"waves_per_eu": 1, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 4, "num_stages": 1})xyzw"
};
#endif

struct PerfFields {
  int16_t BLOCK_M;
    int16_t BLOCK_N;
    int8_t  PERSISTENT_TYPE;
    int8_t  GRID_CU_MULTIP;
    bool    PRE_LOAD_V;
};

static PerfFields image_perf_list [] = {
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true }
};

// u8R generates char8_t which is poorly supported almost everywhere.
constexpr pstring_view PACKAGE_PATH
#if defined(_WIN32)
{ LR"xyzw(amd-gfx11xx/flash/attn_fwd/FONLY__＊fp32@16_48_T_T_0_1___gfx11xx)xyzw" };
#else
{ R"xyzw(amd-gfx11xx/flash/attn_fwd/FONLY__＊fp32@16_48_T_T_0_1___gfx11xx)xyzw" };
#endif
constexpr std::string_view FUNC_NAME { R"xyzw(＊fp32@16_48_T_T_0_1)xyzw" };
constexpr std::string_view ARCH_NAME { R"xyzw(gfx1100)xyzw" };

// Checksum can be confirmed with `echo -n '<string>' | b2sum -l 64`
// For example:
//   $ echo -n 'amd-gfx110x/flash/attn_fwd/FONLY__^bf16@16,128,False,False,0,0___gfx1100__P__32_32_0_2_False__CO__wave3_warp2_stg1-Gpu-gfx1100' | b2sum -l 64
//   c4b51ee645d79580  -
static AOTRITON_NS::TritonKernelCompactMeta meta_list[] = {
    { 0xa7c4c381u, 0x77886456u, 302, 83 }, // a7c4c38177886456 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp32@16_48_T_T_0_1___gfx11xx__P__0_2_16_16_False__CO__wave1_warp2_stg1--Arch_gfx1100
    { 0xf52fec39u, 0xe898d8c3u, 302, 202 }, // f52fec39e898d8c3 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp32@16_48_T_T_0_1___gfx11xx__P__0_2_16_16_False__CO__wave1_warp4_stg1--Arch_gfx1100
    { 0x0ed3e1d1u, 0x155c0f2fu, 302, 16 }, // 0ed3e1d1155c0f2f = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp32@16_48_T_T_0_1___gfx11xx__P__0_2_16_16_False__CO__wave2_warp2_stg1--Arch_gfx1100
    { 0xfe3254b4u, 0x2c7f992au, 302, 116 }, // fe3254b42c7f992a = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp32@16_48_T_T_0_1___gfx11xx__P__0_2_16_16_False__CO__wave2_warp4_stg1--Arch_gfx1100
    { 0xd5b55b00u, 0x47b570cau, 302, 33 }, // d5b55b0047b570ca = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp32@16_48_T_T_0_1___gfx11xx__P__0_2_16_16_False__CO__wave3_warp2_stg1--Arch_gfx1100
    { 0xa6be0840u, 0xfc77f156u, 302, 167 }, // a6be0840fc77f156 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp32@16_48_T_T_0_1___gfx11xx__P__0_2_16_16_False__CO__wave3_warp4_stg1--Arch_gfx1100
    { 0xf5ff3452u, 0xd6e953fcu, 302, 50 }, // f5ff3452d6e953fc = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp32@16_48_T_T_0_1___gfx11xx__P__0_2_16_16_False__CO__wave4_warp2_stg1--Arch_gfx1100
    { 0x6b6196ceu, 0x91189353u, 456, 83 }, // 6b6196ce91189353 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp32@16_48_T_T_0_1___gfx11xx__P__0_2_16_16_True__CO__wave1_warp2_stg1--Arch_gfx1100
    { 0x78988b24u, 0xd042f481u, 456, 202 }, // 78988b24d042f481 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp32@16_48_T_T_0_1___gfx11xx__P__0_2_16_16_True__CO__wave1_warp4_stg1--Arch_gfx1100
    { 0x467db51eu, 0x64d0851fu, 456, 16 }, // 467db51e64d0851f = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp32@16_48_T_T_0_1___gfx11xx__P__0_2_16_16_True__CO__wave2_warp2_stg1--Arch_gfx1100
    { 0xc900e1ebu, 0x3c0853bbu, 456, 116 }, // c900e1eb3c0853bb = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp32@16_48_T_T_0_1___gfx11xx__P__0_2_16_16_True__CO__wave2_warp4_stg1--Arch_gfx1100
    { 0x779b7949u, 0x80c292fau, 456, 33 }, // 779b794980c292fa = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp32@16_48_T_T_0_1___gfx11xx__P__0_2_16_16_True__CO__wave3_warp2_stg1--Arch_gfx1100
    { 0xad15b795u, 0x6c722b99u, 456, 167 }, // ad15b7956c722b99 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp32@16_48_T_T_0_1___gfx11xx__P__0_2_16_16_True__CO__wave3_warp4_stg1--Arch_gfx1100
    { 0x82856858u, 0x63b727dbu, 456, 50 }, // 8285685863b727db = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp32@16_48_T_T_0_1___gfx11xx__P__0_2_16_16_True__CO__wave4_warp2_stg1--Arch_gfx1100
    { 0x7f1b5af3u, 0x3db06ccbu, 456, 133 }, // 7f1b5af33db06ccb = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp32@16_48_T_T_0_1___gfx11xx__P__0_2_16_16_True__CO__wave4_warp4_stg1--Arch_gfx1100
    { 0x55cb2308u, 0xd1cd33ceu, 318, 83 }, // 55cb2308d1cd33ce = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp32@16_48_T_T_0_1___gfx11xx__P__0_2_32_32_False__CO__wave1_warp2_stg1--Arch_gfx1100
    { 0xcd0bbfd0u, 0x001166a2u, 318, 16 }, // cd0bbfd0001166a2 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp32@16_48_T_T_0_1___gfx11xx__P__0_2_32_32_False__CO__wave2_warp2_stg1--Arch_gfx1100
    { 0x3037486au, 0x5d0aa598u, 318, 33 }, // 3037486a5d0aa598 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp32@16_48_T_T_0_1___gfx11xx__P__0_2_32_32_False__CO__wave3_warp2_stg1--Arch_gfx1100
    { 0xa594017du, 0xaee89e0eu, 318, 50 }, // a594017daee89e0e = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp32@16_48_T_T_0_1___gfx11xx__P__0_2_32_32_False__CO__wave4_warp2_stg1--Arch_gfx1100
    { 0x816cce69u, 0x14d6ab63u, 318, 133 }, // 816cce6914d6ab63 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp32@16_48_T_T_0_1___gfx11xx__P__0_2_32_32_False__CO__wave4_warp4_stg1--Arch_gfx1100
    { 0x0580aa4cu, 0x5515d9a0u, 381, 167 }, // 0580aa4c5515d9a0 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp32@16_48_T_T_0_1___gfx11xx__P__0_2_32_32_True__CO__wave3_warp4_stg1--Arch_gfx1100
    { 0x46710fd6u, 0xece0911fu, 381, 133 }, // 46710fd6ece0911f = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp32@16_48_T_T_0_1___gfx11xx__P__0_2_32_32_True__CO__wave4_warp4_stg1--Arch_gfx1100
};

static constexpr int kTotalNumKernels = ARRAY_SIZE(meta_list);

using AOTRITON_NS::v3::flash::autotune::attn_fwd_packed_string;

static AOTRITON_NS::TritonKernelCluster<kTotalNumKernels>
kernel_cluster(meta_list,
               attn_fwd_packed_string);

static int8_t lut[1][10][10] =
{
// GPU gfx1100_mod0
{{ 3, 5, 1,10, 8,10,12,10, 8,10},
 { 2, 4, 0, 6, 7,13, 9, 7,13, 0},
 { 8, 2, 4,14, 8,10,12, 8,20,20},
 { 0, 4, 2, 8,10, 8, 8,21,20,20},
 { 2, 2, 0,11, 7, 7,20,20,21,20},
 { 0, 2, 0, 0, 0, 7,20,17,21, 8},
 {15, 0, 0, 0, 0, 7,16,21, 9,20},
 {15, 0, 0, 0,18,16,20,14,17,20},
 { 0, 0, 0, 0, 0,17,13,20,20,19},
 { 0, 0, 0, 0, 7, 7, 7,20,20,16}}
// End of GPU gfx1100_mod0
}
;

}; // End of anonymous namespace

namespace AOTRITON_NS::v3::flash::autotune {

// using AOTRITON_NS::v2::flash::AttnFwdContext;

void CURRENT_ENTRY_PUBLIC(AttnFwdContext& context, int mod_number) {
#if AOTRITON_BUILD_FOR_TUNING
    int preferred_index = context._has_preferred_kernel;
    context._total_number_of_kernels = kTotalNumKernels;
#ifndef NDEBUG
    std::cerr << "Autotune_attn_fwd__A1__F429 "
              << "kTotalNumKernels = " << kTotalNumKernels << " "
              << "_has_preferred_kernel = " << preferred_index << " "
              << std::endl;
#endif
    if (preferred_index != -1) {
        if (preferred_index >= kTotalNumKernels)
            return ;
        context.kernel_on_device = kernel_cluster.get(preferred_index);
        context.pp_args_index = 10;
        context.package_path = PACKAGE_PATH;
        context.func_name = FUNC_NAME;
        context.arch_name = ARCH_NAME;
        context._preferred_kernel_psels = kernel_psels[preferred_index];
        context._preferred_kernel_copts = kernel_copts[preferred_index];
        const auto& perf = image_perf_list[preferred_index];
        context.PERSISTENT_TYPE = perf.PERSISTENT_TYPE;
    context.GRID_CU_MULTIP = perf.GRID_CU_MULTIP;
    context.BLOCK_M = perf.BLOCK_M;
    context.BLOCK_N = perf.BLOCK_N;
    context.PRE_LOAD_V = perf.PRE_LOAD_V;
        return ;
    }
#endif
    auto kernel_index = attn_fwd__lut_lambda__0(*context.params, mod_number, lut);
    if (kernel_index < 0) {
      return ;
    }
    context.kernel_on_device = kernel_cluster.get(kernel_index);
    context.pp_args_index = 10;
    context.package_path = PACKAGE_PATH;
    context.func_name = FUNC_NAME;
    context.arch_name = ARCH_NAME;
#ifndef NDEBUG
    std::cerr << __FILE__ << " kernel_index = " << int(kernel_index) << std::endl;
#endif
    const auto& perf = image_perf_list[kernel_index];
    context.PERSISTENT_TYPE = perf.PERSISTENT_TYPE;
    context.GRID_CU_MULTIP = perf.GRID_CU_MULTIP;
    context.BLOCK_M = perf.BLOCK_M;
    context.BLOCK_N = perf.BLOCK_N;
    context.PRE_LOAD_V = perf.PRE_LOAD_V;
}

#undef CURRENT_ENTRY_PUBLIC
}

// Human-readable Signature 
// Q = "*fp32:16"
// B = "*fp32:16"
// A = 0
// Sm_scale = "fp32"
// L = "*fp32:16"
// Q_descale = 0
// stride_az = 0
// Num_head_q = "i32"
// cu_seqlens_q = "*i32:16"
// BLOCK_DMODEL = 48
// Head_dim = "i32"
// PADDED_HEAD = True
// ENABLE_DROPOUT = True
// dropout_p = "fp32"
// philox_seed_ptr = "*u64"
// philox_offset1 = "*u64"
// philox_offset2 = "u64"
// RETURN_ENCODED_SOFTMAX = False
// encoded_softmax = 0
// CAUSAL_TYPE = 0
// Window_left = 0
// BIAS_TYPE = 1
// USE_ALIBI = False
// INT8 = False
// persistent_atomic_counter = 0
// Num_CU = "i32"

// SELECT * FROM FLASH$attn_fwd WHERE gpu IN ('gfx1100_mod0') AND inputs$Q_dtype = 'torch.float32' AND inputs$BLOCK_DMODEL = 48 AND inputs$PADDED_HEAD = False AND inputs$ENABLE_DROPOUT = True AND inputs$CAUSAL_TYPE = 0 AND inputs$BIAS_TYPE = 1

// vim: set fileencoding=utf-8

