/* localsearch-category-all-container.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from localsearch-category-all-container.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2008-2012 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-localsearch.h"
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <tinysparql.h>
#include "rygel-server.h"
#include <glib/gi18n-lib.h>
#include <gio/gio.h>

#define RYGEL_LOCAL_SEARCH_CATEGORY_ALL_CONTAINER_RESOURCES_PATH "/org/freedesktop/Tracker3/Endpoint"
#define RYGEL_LOCAL_SEARCH_CATEGORY_ALL_CONTAINER_TRACKER_INTERFACE "org.freedesktop.Tracker3.Endpoint"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	RYGEL_LOCAL_SEARCH_CATEGORY_ALL_CONTAINER_0_PROPERTY,
	RYGEL_LOCAL_SEARCH_CATEGORY_ALL_CONTAINER_CREATE_CLASSES_PROPERTY,
	RYGEL_LOCAL_SEARCH_CATEGORY_ALL_CONTAINER_SEARCH_CLASSES_PROPERTY,
	RYGEL_LOCAL_SEARCH_CATEGORY_ALL_CONTAINER_NUM_PROPERTIES
};
static GParamSpec* rygel_local_search_category_all_container_properties[RYGEL_LOCAL_SEARCH_CATEGORY_ALL_CONTAINER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
#define _rygel_local_search_query_unref0(var) ((var == NULL) ? NULL : (var = (rygel_local_search_query_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelLocalSearchCategoryAllContainerAddItemData RygelLocalSearchCategoryAllContainerAddItemData;
typedef struct _RygelLocalSearchCategoryAllContainerAddContainerData RygelLocalSearchCategoryAllContainerAddContainerData;
typedef struct _RygelLocalSearchCategoryAllContainerRemoveItemData RygelLocalSearchCategoryAllContainerRemoveItemData;
typedef struct _RygelLocalSearchCategoryAllContainerRemoveContainerData RygelLocalSearchCategoryAllContainerRemoveContainerData;
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
typedef struct _RygelLocalSearchCategoryAllContainerSearchData RygelLocalSearchCategoryAllContainerSearchData;
typedef struct _RygelLocalSearchCategoryAllContainerCreateEntryInStoreData RygelLocalSearchCategoryAllContainerCreateEntryInStoreData;
typedef struct _RygelLocalSearchCategoryAllContainerRemoveEntryFromStoreData RygelLocalSearchCategoryAllContainerRemoveEntryFromStoreData;

struct _RygelLocalSearchCategoryAllContainerPrivate {
	GeeArrayList* _create_classes;
	GeeArrayList* _search_classes;
	TrackerNotifier* notifier;
};

struct _Block2Data {
	int _ref_count_;
	RygelLocalSearchCategoryAllContainer* self;
	RygelLocalSearchCleanupQuery* cleanup_query;
};

struct _RygelLocalSearchCategoryAllContainerAddItemData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelLocalSearchCategoryAllContainer* self;
	RygelMediaFileItem* item;
	GCancellable* cancellable;
	gchar* urn;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GError* _inner_error0_;
};

struct _RygelLocalSearchCategoryAllContainerAddContainerData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelLocalSearchCategoryAllContainer* self;
	RygelMediaContainer* container;
	GCancellable* cancellable;
	GError* _tmp0_;
	GError* _inner_error0_;
};

struct _RygelLocalSearchCategoryAllContainerRemoveItemData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelLocalSearchCategoryAllContainer* self;
	gchar* id;
	GCancellable* cancellable;
	gchar* parent_id;
	gchar* urn;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GError* _inner_error0_;
};

struct _RygelLocalSearchCategoryAllContainerRemoveContainerData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelLocalSearchCategoryAllContainer* self;
	gchar* id;
	GCancellable* cancellable;
	GError* _tmp0_;
	GError* _inner_error0_;
};

struct _RygelLocalSearchCategoryAllContainerSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelLocalSearchCategoryAllContainer* self;
	RygelSearchExpression* expression;
	guint offset;
	guint max_count;
	gchar* sort_criteria;
	GCancellable* cancellable;
	guint total_matches;
	RygelMediaObjects* result;
	RygelMediaObjects* _tmp0_;
	guint _tmp1_;
	RygelMediaObjects* _tmp2_;
	RygelMediaObjects* _tmp3_;
	GError* _inner_error0_;
};

struct _RygelLocalSearchCategoryAllContainerCreateEntryInStoreData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelLocalSearchCategoryAllContainer* self;
	RygelMediaFileItem* item;
	gchar* result;
	gchar* category;
	RygelLocalSearchItemFactory* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* graph;
	RygelLocalSearchItemFactory* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	RygelLocalSearchInsertionQuery* query;
	RygelLocalSearchInsertionQuery* _tmp6_;
	TrackerSparqlConnection* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	GError* _inner_error0_;
};

struct _RygelLocalSearchCategoryAllContainerRemoveEntryFromStoreData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelLocalSearchCategoryAllContainer* self;
	gchar* id;
	RygelLocalSearchDeletionQuery* query;
	RygelLocalSearchDeletionQuery* _tmp0_;
	TrackerSparqlConnection* _tmp1_;
	GError* _inner_error0_;
};

static gint RygelLocalSearchCategoryAllContainer_private_offset;
static gpointer rygel_local_search_category_all_container_parent_class = NULL;
static RygelWritableContainerIface * rygel_local_search_category_all_container_rygel_writable_container_parent_iface = NULL;
static RygelSearchableContainerIface * rygel_local_search_category_all_container_rygel_searchable_container_parent_iface = NULL;

static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void rygel_local_search_category_all_container_on_notifier_event (RygelLocalSearchCategoryAllContainer* self,
                                                                  TrackerNotifier* notifier,
                                                                  const gchar* service,
                                                                  const gchar* graph,
                                                                  GPtrArray* events);
static void _rygel_local_search_category_all_container_on_notifier_event_tracker_notifier_events (TrackerNotifier* _sender,
                                                                                           const gchar* service,
                                                                                           const gchar* graph,
                                                                                           GPtrArray* events,
                                                                                           gpointer self);
static void __lambda5_ (Block2Data* _data2_,
                 GObject* obj,
                 GAsyncResult* res);
static void ___lambda5__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static void rygel_local_search_category_all_container_real_add_item_data_free (gpointer _data);
static void rygel_local_search_category_all_container_real_add_item (RygelWritableContainer* base,
                                                              RygelMediaFileItem* item,
                                                              GCancellable* cancellable,
                                                              GAsyncReadyCallback _callback_,
                                                              gpointer _user_data_);
static gboolean rygel_local_search_category_all_container_real_add_item_co (RygelLocalSearchCategoryAllContainerAddItemData* _data_);
static void rygel_local_search_category_all_container_create_entry_in_store (RygelLocalSearchCategoryAllContainer* self,
                                                                      RygelMediaFileItem* item,
                                                                      GAsyncReadyCallback _callback_,
                                                                      gpointer _user_data_);
static gchar* rygel_local_search_category_all_container_create_entry_in_store_finish (RygelLocalSearchCategoryAllContainer* self,
                                                                               GAsyncResult* _res_,
                                                                               GError** error);
static void rygel_local_search_category_all_container_add_item_ready (GObject* source_object,
                                                               GAsyncResult* _res_,
                                                               gpointer _user_data_);
static void rygel_local_search_category_all_container_real_add_container_data_free (gpointer _data);
static void rygel_local_search_category_all_container_real_add_container (RygelWritableContainer* base,
                                                                   RygelMediaContainer* container,
                                                                   GCancellable* cancellable,
                                                                   GAsyncReadyCallback _callback_,
                                                                   gpointer _user_data_);
static gboolean rygel_local_search_category_all_container_real_add_container_co (RygelLocalSearchCategoryAllContainerAddContainerData* _data_);
static void rygel_local_search_category_all_container_real_remove_item_data_free (gpointer _data);
static void rygel_local_search_category_all_container_real_remove_item (RygelWritableContainer* base,
                                                                 const gchar* id,
                                                                 GCancellable* cancellable,
                                                                 GAsyncReadyCallback _callback_,
                                                                 gpointer _user_data_);
static gboolean rygel_local_search_category_all_container_real_remove_item_co (RygelLocalSearchCategoryAllContainerRemoveItemData* _data_);
static void rygel_local_search_category_all_container_remove_entry_from_store (RygelLocalSearchCategoryAllContainer* self,
                                                                        const gchar* id,
                                                                        GAsyncReadyCallback _callback_,
                                                                        gpointer _user_data_);
static void rygel_local_search_category_all_container_remove_entry_from_store_finish (RygelLocalSearchCategoryAllContainer* self,
                                                                               GAsyncResult* _res_,
                                                                               GError** error);
static void rygel_local_search_category_all_container_remove_item_ready (GObject* source_object,
                                                                  GAsyncResult* _res_,
                                                                  gpointer _user_data_);
static void rygel_local_search_category_all_container_real_remove_container_data_free (gpointer _data);
static void rygel_local_search_category_all_container_real_remove_container (RygelWritableContainer* base,
                                                                      const gchar* id,
                                                                      GCancellable* cancellable,
                                                                      GAsyncReadyCallback _callback_,
                                                                      gpointer _user_data_);
static gboolean rygel_local_search_category_all_container_real_remove_container_co (RygelLocalSearchCategoryAllContainerRemoveContainerData* _data_);
static void rygel_local_search_category_all_container_real_search_data_free (gpointer _data);
static void rygel_local_search_category_all_container_real_search (RygelSearchableContainer* base,
                                                            RygelSearchExpression* expression,
                                                            guint offset,
                                                            guint max_count,
                                                            const gchar* sort_criteria,
                                                            GCancellable* cancellable,
                                                            GAsyncReadyCallback _callback_,
                                                            gpointer _user_data_);
static gboolean rygel_local_search_category_all_container_real_search_co (RygelLocalSearchCategoryAllContainerSearchData* _data_);
static void rygel_local_search_category_all_container_search_ready (GObject* source_object,
                                                             GAsyncResult* _res_,
                                                             gpointer _user_data_);
VALA_EXTERN void rygel_local_search_search_container_get_children_count (RygelLocalSearchSearchContainer* self,
                                                             GAsyncReadyCallback _callback_,
                                                             gpointer _user_data_);
VALA_EXTERN void rygel_local_search_search_container_get_children_count_finish (RygelLocalSearchSearchContainer* self,
                                                                    GAsyncResult* _res_);
static void rygel_local_search_category_all_container_create_entry_in_store_data_free (gpointer _data);
static gboolean rygel_local_search_category_all_container_create_entry_in_store_co (RygelLocalSearchCategoryAllContainerCreateEntryInStoreData* _data_);
static void rygel_local_search_category_all_container_create_entry_in_store_ready (GObject* source_object,
                                                                            GAsyncResult* _res_,
                                                                            gpointer _user_data_);
static void rygel_local_search_category_all_container_remove_entry_from_store_data_free (gpointer _data);
static gboolean rygel_local_search_category_all_container_remove_entry_from_store_co (RygelLocalSearchCategoryAllContainerRemoveEntryFromStoreData* _data_);
static void rygel_local_search_category_all_container_remove_entry_from_store_ready (GObject* source_object,
                                                                              GAsyncResult* _res_,
                                                                              gpointer _user_data_);
static void rygel_local_search_category_all_container_finalize (GObject * obj);
static GType rygel_local_search_category_all_container_get_type_once (void);
static void _vala_rygel_local_search_category_all_container_get_property (GObject * object,
                                                                   guint property_id,
                                                                   GValue * value,
                                                                   GParamSpec * pspec);
static void _vala_rygel_local_search_category_all_container_set_property (GObject * object,
                                                                   guint property_id,
                                                                   const GValue * value,
                                                                   GParamSpec * pspec);

static inline gpointer
rygel_local_search_category_all_container_get_instance_private (RygelLocalSearchCategoryAllContainer* self)
{
	return G_STRUCT_MEMBER_P (self, RygelLocalSearchCategoryAllContainer_private_offset);
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		RygelLocalSearchCategoryAllContainer* self;
		self = _data2_->self;
		_rygel_local_search_query_unref0 (_data2_->cleanup_query);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
_rygel_local_search_category_all_container_on_notifier_event_tracker_notifier_events (TrackerNotifier* _sender,
                                                                                      const gchar* service,
                                                                                      const gchar* graph,
                                                                                      GPtrArray* events,
                                                                                      gpointer self)
{
	rygel_local_search_category_all_container_on_notifier_event ((RygelLocalSearchCategoryAllContainer*) self, _sender, service, graph, events);
}

static void
__lambda5_ (Block2Data* _data2_,
            GObject* obj,
            GAsyncResult* res)
{
	RygelLocalSearchCategoryAllContainer* self;
	GError* _inner_error0_ = NULL;
	self = _data2_->self;
	g_return_if_fail (res != NULL);
	{
		rygel_local_search_query_execute_finish ((RygelLocalSearchQuery*) _data2_->cleanup_query, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = err;
		_tmp1_ = _tmp0_->message;
		g_warning ("localsearch-category-all-container.vala:77: Failed to run cleanup quer" \
"y: %s", _tmp1_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda5__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
	__lambda5_ (self, source_object, res);
	block2_data_unref (self);
}

RygelLocalSearchCategoryAllContainer*
rygel_local_search_category_all_container_construct (GType object_type,
                                                     RygelLocalSearchCategoryContainer* parent)
{
	RygelLocalSearchCategoryAllContainer * self = NULL;
	Block2Data* _data2_;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	RygelLocalSearchItemFactory* _tmp4_;
	GeeArrayList* _tmp5_;
	GeeArrayList* _tmp6_;
	GeeArrayList* _tmp7_;
	GeeArrayList* _tmp8_;
	RygelLocalSearchItemFactory* _tmp9_;
	const gchar* _tmp10_;
	GeeArrayList* _tmp11_;
	GeeArrayList* _tmp12_;
	RygelLocalSearchItemFactory* _tmp13_;
	const gchar* _tmp14_;
	RygelLocalSearchItemFactory* _tmp34_;
	const gchar* _tmp35_;
	RygelLocalSearchItemFactory* _tmp36_;
	const gchar* _tmp37_;
	RygelLocalSearchItemFactory* _tmp38_;
	const gchar* _tmp39_;
	RygelLocalSearchCleanupQuery* _tmp40_;
	TrackerSparqlConnection* _tmp41_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (parent != NULL, NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_tmp0_ = rygel_media_object_get_id ((RygelMediaObject*) parent);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat ("All", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = parent->item_factory;
	self = (RygelLocalSearchCategoryAllContainer*) rygel_local_search_search_container_construct (object_type, _tmp3_, (RygelMediaContainer*) parent, "All", _tmp4_, NULL, NULL);
	_data2_->self = g_object_ref (self);
	_g_free0 (_tmp3_);
	_tmp5_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_tmp6_ = _tmp5_;
	rygel_writable_container_set_create_classes ((RygelWritableContainer*) self, _tmp6_);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = rygel_writable_container_get_create_classes ((RygelWritableContainer*) self);
	_tmp8_ = _tmp7_;
	_tmp9_ = ((RygelLocalSearchSearchContainer*) self)->item_factory;
	_tmp10_ = _tmp9_->upnp_class;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp8_, _tmp10_);
	_tmp11_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_tmp12_ = _tmp11_;
	rygel_searchable_container_set_search_classes ((RygelSearchableContainer*) self, _tmp12_);
	_g_object_unref0 (_tmp12_);
	_tmp13_ = ((RygelLocalSearchSearchContainer*) self)->item_factory;
	_tmp14_ = _tmp13_->upload_dir;
	if (_tmp14_ != NULL) {
		{
			gchar* uri = NULL;
			RygelLocalSearchItemFactory* _tmp15_;
			const gchar* _tmp16_;
			gchar* _tmp17_;
			const gchar* _tmp18_;
			_tmp15_ = ((RygelLocalSearchSearchContainer*) self)->item_factory;
			_tmp16_ = _tmp15_->upload_dir;
			_tmp17_ = g_filename_to_uri (_tmp16_, NULL, &_inner_error0_);
			uri = _tmp17_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_CONVERT_ERROR) {
					goto __catch0_g_convert_error;
				}
				block2_data_unref (_data2_);
				_data2_ = NULL;
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_tmp18_ = uri;
			rygel_media_object_add_uri ((RygelMediaObject*) self, _tmp18_);
			_g_free0 (uri);
		}
		goto __finally0;
		__catch0_g_convert_error:
		{
			GError* _error_ = NULL;
			RygelLocalSearchItemFactory* _tmp19_;
			const gchar* _tmp20_;
			GError* _tmp21_;
			const gchar* _tmp22_;
			_error_ = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp19_ = ((RygelLocalSearchSearchContainer*) self)->item_factory;
			_tmp20_ = _tmp19_->upload_dir;
			_tmp21_ = _error_;
			_tmp22_ = _tmp21_->message;
			g_warning (_ ("Failed to construct URI for folder “%s”: %s"), _tmp20_, _tmp22_);
			_g_error_free0 (_error_);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			block2_data_unref (_data2_);
			_data2_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	{
		TrackerSparqlConnection* _tmp23_;
		TrackerNotifier* _tmp24_;
		GDBusConnection* _tmp25_ = NULL;
		GDBusConnection* _tmp26_;
		TrackerNotifier* _tmp27_;
		const gchar* _tmp28_;
		RygelLocalSearchItemFactory* _tmp29_;
		const gchar* _tmp30_;
		TrackerNotifier* _tmp31_;
		_tmp23_ = rygel_local_search_root_container_connection;
		_tmp24_ = tracker_sparql_connection_create_notifier (_tmp23_);
		_g_object_unref0 (self->priv->notifier);
		self->priv->notifier = _tmp24_;
		_tmp26_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error0_);
		_tmp25_ = _tmp26_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp27_ = self->priv->notifier;
		_tmp28_ = rygel_local_search_root_container_connected_service;
		_tmp29_ = ((RygelLocalSearchSearchContainer*) self)->item_factory;
		_tmp30_ = _tmp29_->graph_iri;
		tracker_notifier_signal_subscribe (_tmp27_, _tmp25_, _tmp28_, NULL, _tmp30_);
		_tmp31_ = self->priv->notifier;
		g_signal_connect_object (_tmp31_, "events", (GCallback) _rygel_local_search_category_all_container_on_notifier_event_tracker_notifier_events, self, 0);
		_g_object_unref0 (_tmp25_);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp32_;
		const gchar* _tmp33_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp32_ = _error_;
		_tmp33_ = _tmp32_->message;
		g_critical (_ ("Could not subscribe to LocalSearch signals: %s"), _tmp33_);
		_g_error_free0 (_error_);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		block2_data_unref (_data2_);
		_data2_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp34_ = ((RygelLocalSearchSearchContainer*) self)->item_factory;
	_tmp35_ = _tmp34_->category;
	g_message ("localsearch-category-all-container.vala:71: Running cleanup query for " \
"%s", _tmp35_);
	_tmp36_ = ((RygelLocalSearchSearchContainer*) self)->item_factory;
	_tmp37_ = _tmp36_->category;
	_tmp38_ = ((RygelLocalSearchSearchContainer*) self)->item_factory;
	_tmp39_ = _tmp38_->graph;
	_tmp40_ = rygel_local_search_cleanup_query_new (_tmp37_, _tmp39_);
	_data2_->cleanup_query = _tmp40_;
	_tmp41_ = rygel_local_search_root_container_connection;
	rygel_local_search_query_execute ((RygelLocalSearchQuery*) _data2_->cleanup_query, _tmp41_, ___lambda5__gasync_ready_callback, block2_data_ref (_data2_));
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return self;
}

RygelLocalSearchCategoryAllContainer*
rygel_local_search_category_all_container_new (RygelLocalSearchCategoryContainer* parent)
{
	return rygel_local_search_category_all_container_construct (RYGEL_LOCAL_SEARCH_TYPE_CATEGORY_ALL_CONTAINER, parent);
}

static void
rygel_local_search_category_all_container_real_add_item_data_free (gpointer _data)
{
	RygelLocalSearchCategoryAllContainerAddItemData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->item);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelLocalSearchCategoryAllContainerAddItemData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
rygel_local_search_category_all_container_real_add_item (RygelWritableContainer* base,
                                                         RygelMediaFileItem* item,
                                                         GCancellable* cancellable,
                                                         GAsyncReadyCallback _callback_,
                                                         gpointer _user_data_)
{
	RygelLocalSearchCategoryAllContainer * self;
	RygelLocalSearchCategoryAllContainerAddItemData* _data_;
	RygelLocalSearchCategoryAllContainer* _tmp0_;
	RygelMediaFileItem* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (item != NULL);
	self = (RygelLocalSearchCategoryAllContainer*) base;
	_data_ = g_slice_new0 (RygelLocalSearchCategoryAllContainerAddItemData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_local_search_category_all_container_real_add_item_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (item);
	_g_object_unref0 (_data_->item);
	_data_->item = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	rygel_local_search_category_all_container_real_add_item_co (_data_);
}

static void
rygel_local_search_category_all_container_add_item_finish (RygelWritableContainer* base,
                                                           GAsyncResult* _res_,
                                                           GError** error)
{
	RygelLocalSearchCategoryAllContainerAddItemData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
rygel_local_search_category_all_container_add_item_ready (GObject* source_object,
                                                          GAsyncResult* _res_,
                                                          gpointer _user_data_)
{
	RygelLocalSearchCategoryAllContainerAddItemData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_local_search_category_all_container_real_add_item_co (_data_);
}

static gboolean
rygel_local_search_category_all_container_real_add_item_co (RygelLocalSearchCategoryAllContainerAddItemData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	rygel_local_search_category_all_container_create_entry_in_store (_data_->self, _data_->item, rygel_local_search_category_all_container_add_item_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp0_ = rygel_local_search_category_all_container_create_entry_in_store_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	_data_->urn = _data_->_tmp0_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = rygel_local_search_search_container_create_child_id_for_urn ((RygelLocalSearchSearchContainer*) _data_->self, _data_->urn);
	_data_->_tmp2_ = _data_->_tmp1_;
	rygel_media_object_set_id ((RygelMediaObject*) _data_->item, _data_->_tmp2_);
	_g_free0 (_data_->_tmp2_);
	rygel_media_object_set_parent ((RygelMediaObject*) _data_->item, (RygelMediaContainer*) _data_->self);
	_g_free0 (_data_->urn);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rygel_local_search_category_all_container_real_add_container_data_free (gpointer _data)
{
	RygelLocalSearchCategoryAllContainerAddContainerData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->container);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelLocalSearchCategoryAllContainerAddContainerData, _data_);
}

static void
rygel_local_search_category_all_container_real_add_container (RygelWritableContainer* base,
                                                              RygelMediaContainer* container,
                                                              GCancellable* cancellable,
                                                              GAsyncReadyCallback _callback_,
                                                              gpointer _user_data_)
{
	RygelLocalSearchCategoryAllContainer * self;
	RygelLocalSearchCategoryAllContainerAddContainerData* _data_;
	RygelLocalSearchCategoryAllContainer* _tmp0_;
	RygelMediaContainer* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (container != NULL);
	self = (RygelLocalSearchCategoryAllContainer*) base;
	_data_ = g_slice_new0 (RygelLocalSearchCategoryAllContainerAddContainerData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_local_search_category_all_container_real_add_container_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (container);
	_g_object_unref0 (_data_->container);
	_data_->container = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	rygel_local_search_category_all_container_real_add_container_co (_data_);
}

static void
rygel_local_search_category_all_container_add_container_finish (RygelWritableContainer* base,
                                                                GAsyncResult* _res_,
                                                                GError** error)
{
	RygelLocalSearchCategoryAllContainerAddContainerData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static gboolean
rygel_local_search_category_all_container_real_add_container_co (RygelLocalSearchCategoryAllContainerAddContainerData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_error_new_literal (RYGEL_WRITABLE_CONTAINER_ERROR, RYGEL_WRITABLE_CONTAINER_ERROR_NOT_IMPLEMENTED, _ ("Not supported"));
	_data_->_inner_error0_ = _data_->_tmp0_;
	g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
	g_object_unref (_data_->_async_result);
	return FALSE;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rygel_local_search_category_all_container_real_remove_item_data_free (gpointer _data)
{
	RygelLocalSearchCategoryAllContainerRemoveItemData* _data_;
	_data_ = _data;
	_g_free0 (_data_->id);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelLocalSearchCategoryAllContainerRemoveItemData, _data_);
}

static void
rygel_local_search_category_all_container_real_remove_item (RygelWritableContainer* base,
                                                            const gchar* id,
                                                            GCancellable* cancellable,
                                                            GAsyncReadyCallback _callback_,
                                                            gpointer _user_data_)
{
	RygelLocalSearchCategoryAllContainer * self;
	RygelLocalSearchCategoryAllContainerRemoveItemData* _data_;
	RygelLocalSearchCategoryAllContainer* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (id != NULL);
	self = (RygelLocalSearchCategoryAllContainer*) base;
	_data_ = g_slice_new0 (RygelLocalSearchCategoryAllContainerRemoveItemData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_local_search_category_all_container_real_remove_item_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (id);
	_g_free0 (_data_->id);
	_data_->id = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	rygel_local_search_category_all_container_real_remove_item_co (_data_);
}

static void
rygel_local_search_category_all_container_remove_item_finish (RygelWritableContainer* base,
                                                              GAsyncResult* _res_,
                                                              GError** error)
{
	RygelLocalSearchCategoryAllContainerRemoveItemData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
rygel_local_search_category_all_container_remove_item_ready (GObject* source_object,
                                                             GAsyncResult* _res_,
                                                             gpointer _user_data_)
{
	RygelLocalSearchCategoryAllContainerRemoveItemData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_local_search_category_all_container_real_remove_item_co (_data_);
}

static gboolean
rygel_local_search_category_all_container_real_remove_item_co (RygelLocalSearchCategoryAllContainerRemoveItemData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp1_ = rygel_local_search_search_container_get_item_info ((RygelLocalSearchSearchContainer*) _data_->self, _data_->id, &_data_->_tmp0_);
	_g_free0 (_data_->parent_id);
	_data_->parent_id = _data_->_tmp0_;
	_data_->urn = _data_->_tmp1_;
	_data_->_state_ = 1;
	rygel_local_search_category_all_container_remove_entry_from_store (_data_->self, _data_->urn, rygel_local_search_category_all_container_remove_item_ready, _data_);
	return FALSE;
	_state_1:
	rygel_local_search_category_all_container_remove_entry_from_store_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_free0 (_data_->urn);
		_g_free0 (_data_->parent_id);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_free0 (_data_->urn);
	_g_free0 (_data_->parent_id);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rygel_local_search_category_all_container_real_remove_container_data_free (gpointer _data)
{
	RygelLocalSearchCategoryAllContainerRemoveContainerData* _data_;
	_data_ = _data;
	_g_free0 (_data_->id);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelLocalSearchCategoryAllContainerRemoveContainerData, _data_);
}

static void
rygel_local_search_category_all_container_real_remove_container (RygelWritableContainer* base,
                                                                 const gchar* id,
                                                                 GCancellable* cancellable,
                                                                 GAsyncReadyCallback _callback_,
                                                                 gpointer _user_data_)
{
	RygelLocalSearchCategoryAllContainer * self;
	RygelLocalSearchCategoryAllContainerRemoveContainerData* _data_;
	RygelLocalSearchCategoryAllContainer* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (id != NULL);
	self = (RygelLocalSearchCategoryAllContainer*) base;
	_data_ = g_slice_new0 (RygelLocalSearchCategoryAllContainerRemoveContainerData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_local_search_category_all_container_real_remove_container_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (id);
	_g_free0 (_data_->id);
	_data_->id = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	rygel_local_search_category_all_container_real_remove_container_co (_data_);
}

static void
rygel_local_search_category_all_container_remove_container_finish (RygelWritableContainer* base,
                                                                   GAsyncResult* _res_,
                                                                   GError** error)
{
	RygelLocalSearchCategoryAllContainerRemoveContainerData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static gboolean
rygel_local_search_category_all_container_real_remove_container_co (RygelLocalSearchCategoryAllContainerRemoveContainerData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_error_new_literal (RYGEL_WRITABLE_CONTAINER_ERROR, RYGEL_WRITABLE_CONTAINER_ERROR_NOT_IMPLEMENTED, "Not supported");
	_data_->_inner_error0_ = _data_->_tmp0_;
	g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
	g_object_unref (_data_->_async_result);
	return FALSE;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rygel_local_search_category_all_container_real_search_data_free (gpointer _data)
{
	RygelLocalSearchCategoryAllContainerSearchData* _data_;
	_data_ = _data;
	_rygel_search_expression_unref0 (_data_->expression);
	_g_free0 (_data_->sort_criteria);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelLocalSearchCategoryAllContainerSearchData, _data_);
}

static gpointer
_rygel_search_expression_ref0 (gpointer self)
{
	return self ? rygel_search_expression_ref (self) : NULL;
}

static void
rygel_local_search_category_all_container_real_search (RygelSearchableContainer* base,
                                                       RygelSearchExpression* expression,
                                                       guint offset,
                                                       guint max_count,
                                                       const gchar* sort_criteria,
                                                       GCancellable* cancellable,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_)
{
	RygelLocalSearchCategoryAllContainer * self;
	RygelLocalSearchCategoryAllContainerSearchData* _data_;
	RygelLocalSearchCategoryAllContainer* _tmp0_;
	RygelSearchExpression* _tmp1_;
	gchar* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (sort_criteria != NULL);
	self = (RygelLocalSearchCategoryAllContainer*) base;
	_data_ = g_slice_new0 (RygelLocalSearchCategoryAllContainerSearchData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_local_search_category_all_container_real_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _rygel_search_expression_ref0 (expression);
	_rygel_search_expression_unref0 (_data_->expression);
	_data_->expression = _tmp1_;
	_data_->offset = offset;
	_data_->max_count = max_count;
	_tmp2_ = g_strdup (sort_criteria);
	_g_free0 (_data_->sort_criteria);
	_data_->sort_criteria = _tmp2_;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	rygel_local_search_category_all_container_real_search_co (_data_);
}

static RygelMediaObjects*
rygel_local_search_category_all_container_search_finish (RygelSearchableContainer* base,
                                                         GAsyncResult* _res_,
                                                         guint* total_matches,
                                                         GError** error)
{
	RygelMediaObjects* result;
	RygelLocalSearchCategoryAllContainerSearchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	if (total_matches) {
		*total_matches = _data_->total_matches;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
rygel_local_search_category_all_container_search_ready (GObject* source_object,
                                                        GAsyncResult* _res_,
                                                        gpointer _user_data_)
{
	RygelLocalSearchCategoryAllContainerSearchData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_local_search_category_all_container_real_search_co (_data_);
}

static gboolean
rygel_local_search_category_all_container_real_search_co (RygelLocalSearchCategoryAllContainerSearchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = 0U;
	_data_->_state_ = 1;
	rygel_searchable_container_simple_search ((RygelSearchableContainer*) _data_->self, _data_->expression, _data_->offset, _data_->max_count, _data_->sort_criteria, _data_->cancellable, rygel_local_search_category_all_container_search_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp2_ = rygel_searchable_container_simple_search_finish ((RygelSearchableContainer*) _data_->self, _data_->_res_, &_data_->_tmp1_, &_data_->_inner_error0_);
	_data_->total_matches = _data_->_tmp1_;
	_data_->_tmp0_ = _data_->_tmp2_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = _data_->_tmp0_;
	_data_->_tmp0_ = NULL;
	_data_->result = _data_->_tmp3_;
	_g_object_unref0 (_data_->_tmp0_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rygel_local_search_category_all_container_on_notifier_event (RygelLocalSearchCategoryAllContainer* self,
                                                             TrackerNotifier* notifier,
                                                             const gchar* service,
                                                             const gchar* graph,
                                                             GPtrArray* events)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (notifier != NULL);
	g_return_if_fail (events != NULL);
	if (graph != NULL) {
		RygelLocalSearchItemFactory* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = ((RygelLocalSearchSearchContainer*) self)->item_factory;
		_tmp2_ = _tmp1_->graph_iri;
		_tmp0_ = g_strcmp0 (graph, _tmp2_) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		rygel_local_search_search_container_get_children_count ((RygelLocalSearchSearchContainer*) self, NULL, NULL);
	}
}

static void
rygel_local_search_category_all_container_create_entry_in_store_data_free (gpointer _data)
{
	RygelLocalSearchCategoryAllContainerCreateEntryInStoreData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->item);
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelLocalSearchCategoryAllContainerCreateEntryInStoreData, _data_);
}

static void
rygel_local_search_category_all_container_create_entry_in_store (RygelLocalSearchCategoryAllContainer* self,
                                                                 RygelMediaFileItem* item,
                                                                 GAsyncReadyCallback _callback_,
                                                                 gpointer _user_data_)
{
	RygelLocalSearchCategoryAllContainerCreateEntryInStoreData* _data_;
	RygelLocalSearchCategoryAllContainer* _tmp0_;
	RygelMediaFileItem* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_data_ = g_slice_new0 (RygelLocalSearchCategoryAllContainerCreateEntryInStoreData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_local_search_category_all_container_create_entry_in_store_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (item);
	_g_object_unref0 (_data_->item);
	_data_->item = _tmp1_;
	rygel_local_search_category_all_container_create_entry_in_store_co (_data_);
}

static gchar*
rygel_local_search_category_all_container_create_entry_in_store_finish (RygelLocalSearchCategoryAllContainer* self,
                                                                        GAsyncResult* _res_,
                                                                        GError** error)
{
	gchar* result;
	RygelLocalSearchCategoryAllContainerCreateEntryInStoreData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
rygel_local_search_category_all_container_create_entry_in_store_ready (GObject* source_object,
                                                                       GAsyncResult* _res_,
                                                                       gpointer _user_data_)
{
	RygelLocalSearchCategoryAllContainerCreateEntryInStoreData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_local_search_category_all_container_create_entry_in_store_co (_data_);
}

static gboolean
rygel_local_search_category_all_container_create_entry_in_store_co (RygelLocalSearchCategoryAllContainerCreateEntryInStoreData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = ((RygelLocalSearchSearchContainer*) _data_->self)->item_factory;
	_data_->_tmp1_ = _data_->_tmp0_->category;
	_data_->_tmp2_ = g_strdup (_data_->_tmp1_);
	_data_->category = _data_->_tmp2_;
	_data_->_tmp3_ = ((RygelLocalSearchSearchContainer*) _data_->self)->item_factory;
	_data_->_tmp4_ = _data_->_tmp3_->graph;
	_data_->_tmp5_ = g_strdup (_data_->_tmp4_);
	_data_->graph = _data_->_tmp5_;
	_data_->_tmp6_ = rygel_local_search_insertion_query_new (_data_->item, _data_->category, _data_->graph);
	_data_->query = _data_->_tmp6_;
	_data_->_tmp7_ = rygel_local_search_root_container_connection;
	_data_->_state_ = 1;
	rygel_local_search_query_execute ((RygelLocalSearchQuery*) _data_->query, _data_->_tmp7_, rygel_local_search_category_all_container_create_entry_in_store_ready, _data_);
	return FALSE;
	_state_1:
	rygel_local_search_query_execute_finish ((RygelLocalSearchQuery*) _data_->query, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_rygel_local_search_query_unref0 (_data_->query);
		_g_free0 (_data_->graph);
		_g_free0 (_data_->category);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp8_ = _data_->query->id;
	_data_->_tmp9_ = g_strdup (_data_->_tmp8_);
	_data_->result = _data_->_tmp9_;
	_rygel_local_search_query_unref0 (_data_->query);
	_g_free0 (_data_->graph);
	_g_free0 (_data_->category);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rygel_local_search_category_all_container_remove_entry_from_store_data_free (gpointer _data)
{
	RygelLocalSearchCategoryAllContainerRemoveEntryFromStoreData* _data_;
	_data_ = _data;
	_g_free0 (_data_->id);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelLocalSearchCategoryAllContainerRemoveEntryFromStoreData, _data_);
}

static void
rygel_local_search_category_all_container_remove_entry_from_store (RygelLocalSearchCategoryAllContainer* self,
                                                                   const gchar* id,
                                                                   GAsyncReadyCallback _callback_,
                                                                   gpointer _user_data_)
{
	RygelLocalSearchCategoryAllContainerRemoveEntryFromStoreData* _data_;
	RygelLocalSearchCategoryAllContainer* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	_data_ = g_slice_new0 (RygelLocalSearchCategoryAllContainerRemoveEntryFromStoreData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_local_search_category_all_container_remove_entry_from_store_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (id);
	_g_free0 (_data_->id);
	_data_->id = _tmp1_;
	rygel_local_search_category_all_container_remove_entry_from_store_co (_data_);
}

static void
rygel_local_search_category_all_container_remove_entry_from_store_finish (RygelLocalSearchCategoryAllContainer* self,
                                                                          GAsyncResult* _res_,
                                                                          GError** error)
{
	RygelLocalSearchCategoryAllContainerRemoveEntryFromStoreData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
rygel_local_search_category_all_container_remove_entry_from_store_ready (GObject* source_object,
                                                                         GAsyncResult* _res_,
                                                                         gpointer _user_data_)
{
	RygelLocalSearchCategoryAllContainerRemoveEntryFromStoreData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_local_search_category_all_container_remove_entry_from_store_co (_data_);
}

static gboolean
rygel_local_search_category_all_container_remove_entry_from_store_co (RygelLocalSearchCategoryAllContainerRemoveEntryFromStoreData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = rygel_local_search_deletion_query_new (_data_->id);
	_data_->query = _data_->_tmp0_;
	_data_->_tmp1_ = rygel_local_search_root_container_connection;
	_data_->_state_ = 1;
	rygel_local_search_query_execute ((RygelLocalSearchQuery*) _data_->query, _data_->_tmp1_, rygel_local_search_category_all_container_remove_entry_from_store_ready, _data_);
	return FALSE;
	_state_1:
	rygel_local_search_query_execute_finish ((RygelLocalSearchQuery*) _data_->query, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_rygel_local_search_query_unref0 (_data_->query);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_rygel_local_search_query_unref0 (_data_->query);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static GeeArrayList*
rygel_local_search_category_all_container_real_get_create_classes (RygelWritableContainer* base)
{
	GeeArrayList* result;
	RygelLocalSearchCategoryAllContainer* self;
	GeeArrayList* _tmp0_;
	self = (RygelLocalSearchCategoryAllContainer*) base;
	_tmp0_ = self->priv->_create_classes;
	result = _tmp0_;
	return result;
}

static void
rygel_local_search_category_all_container_real_set_create_classes (RygelWritableContainer* base,
                                                                   GeeArrayList* value)
{
	RygelLocalSearchCategoryAllContainer* self;
	GeeArrayList* old_value;
	self = (RygelLocalSearchCategoryAllContainer*) base;
	old_value = rygel_local_search_category_all_container_real_get_create_classes (base);
	if (old_value != value) {
		GeeArrayList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_create_classes);
		self->priv->_create_classes = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_local_search_category_all_container_properties[RYGEL_LOCAL_SEARCH_CATEGORY_ALL_CONTAINER_CREATE_CLASSES_PROPERTY]);
	}
}

static GeeArrayList*
rygel_local_search_category_all_container_real_get_search_classes (RygelSearchableContainer* base)
{
	GeeArrayList* result;
	RygelLocalSearchCategoryAllContainer* self;
	GeeArrayList* _tmp0_;
	self = (RygelLocalSearchCategoryAllContainer*) base;
	_tmp0_ = self->priv->_search_classes;
	result = _tmp0_;
	return result;
}

static void
rygel_local_search_category_all_container_real_set_search_classes (RygelSearchableContainer* base,
                                                                   GeeArrayList* value)
{
	RygelLocalSearchCategoryAllContainer* self;
	GeeArrayList* old_value;
	self = (RygelLocalSearchCategoryAllContainer*) base;
	old_value = rygel_local_search_category_all_container_real_get_search_classes (base);
	if (old_value != value) {
		GeeArrayList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_search_classes);
		self->priv->_search_classes = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_local_search_category_all_container_properties[RYGEL_LOCAL_SEARCH_CATEGORY_ALL_CONTAINER_SEARCH_CLASSES_PROPERTY]);
	}
}

static void
rygel_local_search_category_all_container_class_init (RygelLocalSearchCategoryAllContainerClass * klass,
                                                      gpointer klass_data)
{
	rygel_local_search_category_all_container_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelLocalSearchCategoryAllContainer_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_local_search_category_all_container_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_local_search_category_all_container_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_local_search_category_all_container_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_LOCAL_SEARCH_CATEGORY_ALL_CONTAINER_CREATE_CLASSES_PROPERTY, rygel_local_search_category_all_container_properties[RYGEL_LOCAL_SEARCH_CATEGORY_ALL_CONTAINER_CREATE_CLASSES_PROPERTY] = g_param_spec_object ("create-classes", "create-classes", "create-classes", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_LOCAL_SEARCH_CATEGORY_ALL_CONTAINER_SEARCH_CLASSES_PROPERTY, rygel_local_search_category_all_container_properties[RYGEL_LOCAL_SEARCH_CATEGORY_ALL_CONTAINER_SEARCH_CLASSES_PROPERTY] = g_param_spec_object ("search-classes", "search-classes", "search-classes", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
rygel_local_search_category_all_container_rygel_writable_container_interface_init (RygelWritableContainerIface * iface,
                                                                                   gpointer iface_data)
{
	rygel_local_search_category_all_container_rygel_writable_container_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_item = (void (*) (RygelWritableContainer*, RygelMediaFileItem*, GCancellable*, GAsyncReadyCallback, gpointer)) rygel_local_search_category_all_container_real_add_item;
	iface->add_item_finish = (void (*) (RygelWritableContainer*, GAsyncResult*, GError**)) rygel_local_search_category_all_container_add_item_finish;
	iface->add_container = (void (*) (RygelWritableContainer*, RygelMediaContainer*, GCancellable*, GAsyncReadyCallback, gpointer)) rygel_local_search_category_all_container_real_add_container;
	iface->add_container_finish = (void (*) (RygelWritableContainer*, GAsyncResult*, GError**)) rygel_local_search_category_all_container_add_container_finish;
	iface->remove_item = (void (*) (RygelWritableContainer*, const gchar*, GCancellable*, GAsyncReadyCallback, gpointer)) rygel_local_search_category_all_container_real_remove_item;
	iface->remove_item_finish = (void (*) (RygelWritableContainer*, GAsyncResult*, GError**)) rygel_local_search_category_all_container_remove_item_finish;
	iface->remove_container = (void (*) (RygelWritableContainer*, const gchar*, GCancellable*, GAsyncReadyCallback, gpointer)) rygel_local_search_category_all_container_real_remove_container;
	iface->remove_container_finish = (void (*) (RygelWritableContainer*, GAsyncResult*, GError**)) rygel_local_search_category_all_container_remove_container_finish;
	iface->get_create_classes = rygel_local_search_category_all_container_real_get_create_classes;
	iface->set_create_classes = rygel_local_search_category_all_container_real_set_create_classes;
}

static void
rygel_local_search_category_all_container_rygel_searchable_container_interface_init (RygelSearchableContainerIface * iface,
                                                                                     gpointer iface_data)
{
	rygel_local_search_category_all_container_rygel_searchable_container_parent_iface = g_type_interface_peek_parent (iface);
	iface->search = (void (*) (RygelSearchableContainer*, RygelSearchExpression*, guint, guint, const gchar*, GCancellable*, GAsyncReadyCallback, gpointer)) rygel_local_search_category_all_container_real_search;
	iface->search_finish = (RygelMediaObjects* (*) (RygelSearchableContainer*, GAsyncResult*, guint*, GError**)) rygel_local_search_category_all_container_search_finish;
	iface->get_search_classes = rygel_local_search_category_all_container_real_get_search_classes;
	iface->set_search_classes = rygel_local_search_category_all_container_real_set_search_classes;
}

static void
rygel_local_search_category_all_container_instance_init (RygelLocalSearchCategoryAllContainer * self,
                                                         gpointer klass)
{
	self->priv = rygel_local_search_category_all_container_get_instance_private (self);
}

static void
rygel_local_search_category_all_container_finalize (GObject * obj)
{
	RygelLocalSearchCategoryAllContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_LOCAL_SEARCH_TYPE_CATEGORY_ALL_CONTAINER, RygelLocalSearchCategoryAllContainer);
	_g_object_unref0 (self->priv->_create_classes);
	_g_object_unref0 (self->priv->_search_classes);
	_g_object_unref0 (self->priv->notifier);
	G_OBJECT_CLASS (rygel_local_search_category_all_container_parent_class)->finalize (obj);
}

/**
 * A search container that contains all the items in a category.
 */
 G_GNUC_NO_INLINE static GType
rygel_local_search_category_all_container_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelLocalSearchCategoryAllContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_local_search_category_all_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelLocalSearchCategoryAllContainer), 0, (GInstanceInitFunc) rygel_local_search_category_all_container_instance_init, NULL };
	static const GInterfaceInfo rygel_writable_container_info = { (GInterfaceInitFunc) rygel_local_search_category_all_container_rygel_writable_container_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo rygel_searchable_container_info = { (GInterfaceInitFunc) rygel_local_search_category_all_container_rygel_searchable_container_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType rygel_local_search_category_all_container_type_id;
	rygel_local_search_category_all_container_type_id = g_type_register_static (RYGEL_LOCAL_SEARCH_TYPE_SEARCH_CONTAINER, "RygelLocalSearchCategoryAllContainer", &g_define_type_info, 0);
	g_type_add_interface_static (rygel_local_search_category_all_container_type_id, RYGEL_TYPE_WRITABLE_CONTAINER, &rygel_writable_container_info);
	g_type_add_interface_static (rygel_local_search_category_all_container_type_id, RYGEL_TYPE_SEARCHABLE_CONTAINER, &rygel_searchable_container_info);
	RygelLocalSearchCategoryAllContainer_private_offset = g_type_add_instance_private (rygel_local_search_category_all_container_type_id, sizeof (RygelLocalSearchCategoryAllContainerPrivate));
	return rygel_local_search_category_all_container_type_id;
}

GType
rygel_local_search_category_all_container_get_type (void)
{
	static volatile gsize rygel_local_search_category_all_container_type_id__once = 0;
	if (g_once_init_enter (&rygel_local_search_category_all_container_type_id__once)) {
		GType rygel_local_search_category_all_container_type_id;
		rygel_local_search_category_all_container_type_id = rygel_local_search_category_all_container_get_type_once ();
		g_once_init_leave (&rygel_local_search_category_all_container_type_id__once, rygel_local_search_category_all_container_type_id);
	}
	return rygel_local_search_category_all_container_type_id__once;
}

static void
_vala_rygel_local_search_category_all_container_get_property (GObject * object,
                                                              guint property_id,
                                                              GValue * value,
                                                              GParamSpec * pspec)
{
	RygelLocalSearchCategoryAllContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_LOCAL_SEARCH_TYPE_CATEGORY_ALL_CONTAINER, RygelLocalSearchCategoryAllContainer);
	switch (property_id) {
		case RYGEL_LOCAL_SEARCH_CATEGORY_ALL_CONTAINER_CREATE_CLASSES_PROPERTY:
		g_value_set_object (value, rygel_writable_container_get_create_classes ((RygelWritableContainer*) self));
		break;
		case RYGEL_LOCAL_SEARCH_CATEGORY_ALL_CONTAINER_SEARCH_CLASSES_PROPERTY:
		g_value_set_object (value, rygel_searchable_container_get_search_classes ((RygelSearchableContainer*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rygel_local_search_category_all_container_set_property (GObject * object,
                                                              guint property_id,
                                                              const GValue * value,
                                                              GParamSpec * pspec)
{
	RygelLocalSearchCategoryAllContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_LOCAL_SEARCH_TYPE_CATEGORY_ALL_CONTAINER, RygelLocalSearchCategoryAllContainer);
	switch (property_id) {
		case RYGEL_LOCAL_SEARCH_CATEGORY_ALL_CONTAINER_CREATE_CLASSES_PROPERTY:
		rygel_writable_container_set_create_classes ((RygelWritableContainer*) self, g_value_get_object (value));
		break;
		case RYGEL_LOCAL_SEARCH_CATEGORY_ALL_CONTAINER_SEARCH_CLASSES_PROPERTY:
		rygel_searchable_container_set_search_classes ((RygelSearchableContainer*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

