/* s3 compat server functions auto-generated by pidl */
#include "bin/default/librpc/gen_ndr/ndr_spoolss.h"
#include "bin/default/librpc/gen_ndr/ndr_spoolss_scompat.h"
#include <librpc/rpc/dcesrv_core.h>
#include <rpc_server/rpc_config.h>
#include <rpc_server/rpc_server.h>
#include <util/debug.h>

enum s3compat_rpc_dispatch {
	S3COMPAT_RPC_DISPATCH_EXTERNAL = 0x00000001,
	S3COMPAT_RPC_DISPATCH_INTERNAL = 0x00000002,
};

/* spoolss - dcerpc server boilerplate generated by pidl */
static NTSTATUS spoolss__op_bind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_SPOOLSS_BIND
	return DCESRV_INTERFACE_SPOOLSS_BIND(context,iface);
#else
	return NT_STATUS_OK;
#endif
}

static void spoolss__op_unbind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_SPOOLSS_UNBIND
	DCESRV_INTERFACE_SPOOLSS_UNBIND(context, iface);
#else
	return;
#endif
}

NTSTATUS spoolss__op_ndr_pull(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_pull *pull, void **r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	dce_call->fault_code = 0;

	if (opnum >= ndr_table_spoolss.num_calls) {
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	*r = talloc_named(mem_ctx, ndr_table_spoolss.calls[opnum].struct_size, "struct %s", ndr_table_spoolss.calls[opnum].name);
	NT_STATUS_HAVE_NO_MEMORY(*r);

	/* unravel the NDR for the packet */
	ndr_err = ndr_table_spoolss.calls[opnum].ndr_pull(pull, NDR_IN, *r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS spoolss__op_dispatch_internal(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r, enum s3compat_rpc_dispatch dispatch)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;
	struct pipes_struct *p = NULL;
	NTSTATUS status = NT_STATUS_OK;
	bool impersonated = false;

	/* Retrieve pipes struct */
	p = dcesrv_get_pipes_struct(dce_call->conn);
	p->dce_call = dce_call;
	p->mem_ctx = mem_ctx;
	/* Reset pipes struct fault state */
	p->fault_state = 0;

	/* Impersonate */
	if (dispatch == S3COMPAT_RPC_DISPATCH_EXTERNAL) {
		impersonated = become_authenticated_pipe_user(dce_call->auth_state->session_info);
		if (!impersonated) {
			dce_call->fault_code = DCERPC_FAULT_ACCESS_DENIED;
			status = NT_STATUS_NET_WRITE_FAULT;
			goto fail;
		}
	}

	switch (opnum) {
	case 0: { /* spoolss_EnumPrinters */
		struct spoolss_EnumPrinters *r2 = (struct spoolss_EnumPrinters *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_EnumPrinters, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.count = talloc_zero(r2, uint32_t);
		if (r2->out.count == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.info = talloc_zero(r2, union spoolss_PrinterInfo *);
		if (r2->out.info == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.needed = talloc_zero(r2, uint32_t);
		if (r2->out.needed == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _spoolss_EnumPrinters(p, r2);
		break;
	}
	case 1: { /* spoolss_OpenPrinter */
		struct spoolss_OpenPrinter *r2 = (struct spoolss_OpenPrinter *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_OpenPrinter, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.handle = talloc_zero(r2, struct policy_handle);
		if (r2->out.handle == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _spoolss_OpenPrinter(p, r2);
		break;
	}
	case 2: { /* spoolss_SetJob */
		struct spoolss_SetJob *r2 = (struct spoolss_SetJob *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_SetJob, NDR_IN, r2);
		}
		r2->out.result = _spoolss_SetJob(p, r2);
		break;
	}
	case 3: { /* spoolss_GetJob */
		struct spoolss_GetJob *r2 = (struct spoolss_GetJob *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_GetJob, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.info = talloc_zero(r2, union spoolss_JobInfo);
		if (r2->out.info == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.needed = talloc_zero(r2, uint32_t);
		if (r2->out.needed == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _spoolss_GetJob(p, r2);
		break;
	}
	case 4: { /* spoolss_EnumJobs */
		struct spoolss_EnumJobs *r2 = (struct spoolss_EnumJobs *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_EnumJobs, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.count = talloc_zero(r2, uint32_t);
		if (r2->out.count == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.info = talloc_zero(r2, union spoolss_JobInfo *);
		if (r2->out.info == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.needed = talloc_zero(r2, uint32_t);
		if (r2->out.needed == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _spoolss_EnumJobs(p, r2);
		break;
	}
	case 5: { /* spoolss_AddPrinter */
		struct spoolss_AddPrinter *r2 = (struct spoolss_AddPrinter *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_AddPrinter, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.handle = talloc_zero(r2, struct policy_handle);
		if (r2->out.handle == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _spoolss_AddPrinter(p, r2);
		break;
	}
	case 6: { /* spoolss_DeletePrinter */
		struct spoolss_DeletePrinter *r2 = (struct spoolss_DeletePrinter *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_DeletePrinter, NDR_IN, r2);
		}
		r2->out.result = _spoolss_DeletePrinter(p, r2);
		break;
	}
	case 7: { /* spoolss_SetPrinter */
		struct spoolss_SetPrinter *r2 = (struct spoolss_SetPrinter *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_SetPrinter, NDR_IN, r2);
		}
		r2->out.result = _spoolss_SetPrinter(p, r2);
		break;
	}
	case 8: { /* spoolss_GetPrinter */
		struct spoolss_GetPrinter *r2 = (struct spoolss_GetPrinter *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_GetPrinter, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.info = talloc_zero(r2, union spoolss_PrinterInfo);
		if (r2->out.info == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.needed = talloc_zero(r2, uint32_t);
		if (r2->out.needed == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _spoolss_GetPrinter(p, r2);
		break;
	}
	case 9: { /* spoolss_AddPrinterDriver */
		struct spoolss_AddPrinterDriver *r2 = (struct spoolss_AddPrinterDriver *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_AddPrinterDriver, NDR_IN, r2);
		}
		r2->out.result = _spoolss_AddPrinterDriver(p, r2);
		break;
	}
	case 10: { /* spoolss_EnumPrinterDrivers */
		struct spoolss_EnumPrinterDrivers *r2 = (struct spoolss_EnumPrinterDrivers *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_EnumPrinterDrivers, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.count = talloc_zero(r2, uint32_t);
		if (r2->out.count == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.info = talloc_zero(r2, union spoolss_DriverInfo *);
		if (r2->out.info == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.needed = talloc_zero(r2, uint32_t);
		if (r2->out.needed == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _spoolss_EnumPrinterDrivers(p, r2);
		break;
	}
	case 11: { /* spoolss_GetPrinterDriver */
		struct spoolss_GetPrinterDriver *r2 = (struct spoolss_GetPrinterDriver *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_GetPrinterDriver, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.info = talloc_zero(r2, union spoolss_DriverInfo);
		if (r2->out.info == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.needed = talloc_zero(r2, uint32_t);
		if (r2->out.needed == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _spoolss_GetPrinterDriver(p, r2);
		break;
	}
	case 12: { /* spoolss_GetPrinterDriverDirectory */
		struct spoolss_GetPrinterDriverDirectory *r2 = (struct spoolss_GetPrinterDriverDirectory *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_GetPrinterDriverDirectory, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.info = talloc_zero(r2, union spoolss_DriverDirectoryInfo);
		if (r2->out.info == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.needed = talloc_zero(r2, uint32_t);
		if (r2->out.needed == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _spoolss_GetPrinterDriverDirectory(p, r2);
		break;
	}
	case 13: { /* spoolss_DeletePrinterDriver */
		struct spoolss_DeletePrinterDriver *r2 = (struct spoolss_DeletePrinterDriver *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_DeletePrinterDriver, NDR_IN, r2);
		}
		r2->out.result = _spoolss_DeletePrinterDriver(p, r2);
		break;
	}
	case 14: { /* spoolss_AddPrintProcessor */
		struct spoolss_AddPrintProcessor *r2 = (struct spoolss_AddPrintProcessor *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_AddPrintProcessor, NDR_IN, r2);
		}
		r2->out.result = _spoolss_AddPrintProcessor(p, r2);
		break;
	}
	case 15: { /* spoolss_EnumPrintProcessors */
		struct spoolss_EnumPrintProcessors *r2 = (struct spoolss_EnumPrintProcessors *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_EnumPrintProcessors, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.count = talloc_zero(r2, uint32_t);
		if (r2->out.count == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.info = talloc_zero(r2, union spoolss_PrintProcessorInfo *);
		if (r2->out.info == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.needed = talloc_zero(r2, uint32_t);
		if (r2->out.needed == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _spoolss_EnumPrintProcessors(p, r2);
		break;
	}
	case 16: { /* spoolss_GetPrintProcessorDirectory */
		struct spoolss_GetPrintProcessorDirectory *r2 = (struct spoolss_GetPrintProcessorDirectory *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_GetPrintProcessorDirectory, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.info = talloc_zero(r2, union spoolss_PrintProcessorDirectoryInfo);
		if (r2->out.info == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.needed = talloc_zero(r2, uint32_t);
		if (r2->out.needed == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _spoolss_GetPrintProcessorDirectory(p, r2);
		break;
	}
	case 17: { /* spoolss_StartDocPrinter */
		struct spoolss_StartDocPrinter *r2 = (struct spoolss_StartDocPrinter *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_StartDocPrinter, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.job_id = talloc_zero(r2, uint32_t);
		if (r2->out.job_id == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _spoolss_StartDocPrinter(p, r2);
		break;
	}
	case 18: { /* spoolss_StartPagePrinter */
		struct spoolss_StartPagePrinter *r2 = (struct spoolss_StartPagePrinter *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_StartPagePrinter, NDR_IN, r2);
		}
		r2->out.result = _spoolss_StartPagePrinter(p, r2);
		break;
	}
	case 19: { /* spoolss_WritePrinter */
		struct spoolss_WritePrinter *r2 = (struct spoolss_WritePrinter *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_WritePrinter, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.num_written = talloc_zero(r2, uint32_t);
		if (r2->out.num_written == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _spoolss_WritePrinter(p, r2);
		break;
	}
	case 20: { /* spoolss_EndPagePrinter */
		struct spoolss_EndPagePrinter *r2 = (struct spoolss_EndPagePrinter *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_EndPagePrinter, NDR_IN, r2);
		}
		r2->out.result = _spoolss_EndPagePrinter(p, r2);
		break;
	}
	case 21: { /* spoolss_AbortPrinter */
		struct spoolss_AbortPrinter *r2 = (struct spoolss_AbortPrinter *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_AbortPrinter, NDR_IN, r2);
		}
		r2->out.result = _spoolss_AbortPrinter(p, r2);
		break;
	}
	case 22: { /* spoolss_ReadPrinter */
		struct spoolss_ReadPrinter *r2 = (struct spoolss_ReadPrinter *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_ReadPrinter, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.data = talloc_zero_array(r2, uint8_t, r2->in.data_size);
		if (r2->out.data == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out._data_size = talloc_zero(r2, uint32_t);
		if (r2->out._data_size == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _spoolss_ReadPrinter(p, r2);
		break;
	}
	case 23: { /* spoolss_EndDocPrinter */
		struct spoolss_EndDocPrinter *r2 = (struct spoolss_EndDocPrinter *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_EndDocPrinter, NDR_IN, r2);
		}
		r2->out.result = _spoolss_EndDocPrinter(p, r2);
		break;
	}
	case 24: { /* spoolss_AddJob */
		struct spoolss_AddJob *r2 = (struct spoolss_AddJob *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_AddJob, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.buffer = r2->in.buffer;
		r2->out.needed = talloc_zero(r2, uint32_t);
		if (r2->out.needed == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _spoolss_AddJob(p, r2);
		break;
	}
	case 25: { /* spoolss_ScheduleJob */
		struct spoolss_ScheduleJob *r2 = (struct spoolss_ScheduleJob *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_ScheduleJob, NDR_IN, r2);
		}
		r2->out.result = _spoolss_ScheduleJob(p, r2);
		break;
	}
	case 26: { /* spoolss_GetPrinterData */
		struct spoolss_GetPrinterData *r2 = (struct spoolss_GetPrinterData *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_GetPrinterData, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.type = talloc_zero(r2, enum winreg_Type);
		if (r2->out.type == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.data = talloc_zero_array(r2, uint8_t, r2->in.offered);
		if (r2->out.data == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.needed = talloc_zero(r2, uint32_t);
		if (r2->out.needed == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _spoolss_GetPrinterData(p, r2);
		break;
	}
	case 27: { /* spoolss_SetPrinterData */
		struct spoolss_SetPrinterData *r2 = (struct spoolss_SetPrinterData *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_SetPrinterData, NDR_IN, r2);
		}
		r2->out.result = _spoolss_SetPrinterData(p, r2);
		break;
	}
	case 28: { /* spoolss_WaitForPrinterChange */
		struct spoolss_WaitForPrinterChange *r2 = (struct spoolss_WaitForPrinterChange *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_WaitForPrinterChange, NDR_IN, r2);
		}
		r2->out.result = _spoolss_WaitForPrinterChange(p, r2);
		break;
	}
	case 29: { /* spoolss_ClosePrinter */
		struct spoolss_ClosePrinter *r2 = (struct spoolss_ClosePrinter *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_ClosePrinter, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.handle = r2->in.handle;
		r2->out.result = _spoolss_ClosePrinter(p, r2);
		break;
	}
	case 30: { /* spoolss_AddForm */
		struct spoolss_AddForm *r2 = (struct spoolss_AddForm *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_AddForm, NDR_IN, r2);
		}
		r2->out.result = _spoolss_AddForm(p, r2);
		break;
	}
	case 31: { /* spoolss_DeleteForm */
		struct spoolss_DeleteForm *r2 = (struct spoolss_DeleteForm *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_DeleteForm, NDR_IN, r2);
		}
		r2->out.result = _spoolss_DeleteForm(p, r2);
		break;
	}
	case 32: { /* spoolss_GetForm */
		struct spoolss_GetForm *r2 = (struct spoolss_GetForm *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_GetForm, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.info = talloc_zero(r2, union spoolss_FormInfo);
		if (r2->out.info == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.needed = talloc_zero(r2, uint32_t);
		if (r2->out.needed == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _spoolss_GetForm(p, r2);
		break;
	}
	case 33: { /* spoolss_SetForm */
		struct spoolss_SetForm *r2 = (struct spoolss_SetForm *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_SetForm, NDR_IN, r2);
		}
		r2->out.result = _spoolss_SetForm(p, r2);
		break;
	}
	case 34: { /* spoolss_EnumForms */
		struct spoolss_EnumForms *r2 = (struct spoolss_EnumForms *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_EnumForms, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.count = talloc_zero(r2, uint32_t);
		if (r2->out.count == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.info = talloc_zero(r2, union spoolss_FormInfo *);
		if (r2->out.info == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.needed = talloc_zero(r2, uint32_t);
		if (r2->out.needed == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _spoolss_EnumForms(p, r2);
		break;
	}
	case 35: { /* spoolss_EnumPorts */
		struct spoolss_EnumPorts *r2 = (struct spoolss_EnumPorts *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_EnumPorts, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.count = talloc_zero(r2, uint32_t);
		if (r2->out.count == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.info = talloc_zero(r2, union spoolss_PortInfo *);
		if (r2->out.info == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.needed = talloc_zero(r2, uint32_t);
		if (r2->out.needed == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _spoolss_EnumPorts(p, r2);
		break;
	}
	case 36: { /* spoolss_EnumMonitors */
		struct spoolss_EnumMonitors *r2 = (struct spoolss_EnumMonitors *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_EnumMonitors, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.count = talloc_zero(r2, uint32_t);
		if (r2->out.count == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.info = talloc_zero(r2, union spoolss_MonitorInfo *);
		if (r2->out.info == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.needed = talloc_zero(r2, uint32_t);
		if (r2->out.needed == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _spoolss_EnumMonitors(p, r2);
		break;
	}
	case 37: { /* spoolss_AddPort */
		struct spoolss_AddPort *r2 = (struct spoolss_AddPort *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_AddPort, NDR_IN, r2);
		}
		r2->out.result = _spoolss_AddPort(p, r2);
		break;
	}
	case 38: { /* spoolss_ConfigurePort */
		struct spoolss_ConfigurePort *r2 = (struct spoolss_ConfigurePort *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_ConfigurePort, NDR_IN, r2);
		}
		r2->out.result = _spoolss_ConfigurePort(p, r2);
		break;
	}
	case 39: { /* spoolss_DeletePort */
		struct spoolss_DeletePort *r2 = (struct spoolss_DeletePort *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_DeletePort, NDR_IN, r2);
		}
		r2->out.result = _spoolss_DeletePort(p, r2);
		break;
	}
	case 40: { /* spoolss_CreatePrinterIC */
		struct spoolss_CreatePrinterIC *r2 = (struct spoolss_CreatePrinterIC *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_CreatePrinterIC, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.gdi_handle = talloc_zero(r2, struct policy_handle);
		if (r2->out.gdi_handle == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _spoolss_CreatePrinterIC(p, r2);
		break;
	}
	case 41: { /* spoolss_PlayGDIScriptOnPrinterIC */
		struct spoolss_PlayGDIScriptOnPrinterIC *r2 = (struct spoolss_PlayGDIScriptOnPrinterIC *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_PlayGDIScriptOnPrinterIC, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.pOut = talloc_zero_array(r2, uint8_t, r2->in.cOut);
		if (r2->out.pOut == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _spoolss_PlayGDIScriptOnPrinterIC(p, r2);
		break;
	}
	case 42: { /* spoolss_DeletePrinterIC */
		struct spoolss_DeletePrinterIC *r2 = (struct spoolss_DeletePrinterIC *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_DeletePrinterIC, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.gdi_handle = r2->in.gdi_handle;
		r2->out.result = _spoolss_DeletePrinterIC(p, r2);
		break;
	}
	case 43: { /* spoolss_AddPrinterConnection */
		struct spoolss_AddPrinterConnection *r2 = (struct spoolss_AddPrinterConnection *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_AddPrinterConnection, NDR_IN, r2);
		}
		r2->out.result = _spoolss_AddPrinterConnection(p, r2);
		break;
	}
	case 44: { /* spoolss_DeletePrinterConnection */
		struct spoolss_DeletePrinterConnection *r2 = (struct spoolss_DeletePrinterConnection *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_DeletePrinterConnection, NDR_IN, r2);
		}
		r2->out.result = _spoolss_DeletePrinterConnection(p, r2);
		break;
	}
	case 45: { /* spoolss_PrinterMessageBox */
		struct spoolss_PrinterMessageBox *r2 = (struct spoolss_PrinterMessageBox *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_PrinterMessageBox, NDR_IN, r2);
		}
		r2->out.result = _spoolss_PrinterMessageBox(p, r2);
		break;
	}
	case 46: { /* spoolss_AddMonitor */
		struct spoolss_AddMonitor *r2 = (struct spoolss_AddMonitor *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_AddMonitor, NDR_IN, r2);
		}
		r2->out.result = _spoolss_AddMonitor(p, r2);
		break;
	}
	case 47: { /* spoolss_DeleteMonitor */
		struct spoolss_DeleteMonitor *r2 = (struct spoolss_DeleteMonitor *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_DeleteMonitor, NDR_IN, r2);
		}
		r2->out.result = _spoolss_DeleteMonitor(p, r2);
		break;
	}
	case 48: { /* spoolss_DeletePrintProcessor */
		struct spoolss_DeletePrintProcessor *r2 = (struct spoolss_DeletePrintProcessor *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_DeletePrintProcessor, NDR_IN, r2);
		}
		r2->out.result = _spoolss_DeletePrintProcessor(p, r2);
		break;
	}
	case 49: { /* spoolss_AddPrintProvidor */
		struct spoolss_AddPrintProvidor *r2 = (struct spoolss_AddPrintProvidor *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_AddPrintProvidor, NDR_IN, r2);
		}
		r2->out.result = _spoolss_AddPrintProvidor(p, r2);
		break;
	}
	case 50: { /* spoolss_DeletePrintProvidor */
		struct spoolss_DeletePrintProvidor *r2 = (struct spoolss_DeletePrintProvidor *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_DeletePrintProvidor, NDR_IN, r2);
		}
		r2->out.result = _spoolss_DeletePrintProvidor(p, r2);
		break;
	}
	case 51: { /* spoolss_EnumPrintProcessorDataTypes */
		struct spoolss_EnumPrintProcessorDataTypes *r2 = (struct spoolss_EnumPrintProcessorDataTypes *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_EnumPrintProcessorDataTypes, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.count = talloc_zero(r2, uint32_t);
		if (r2->out.count == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.info = talloc_zero(r2, union spoolss_PrintProcDataTypesInfo *);
		if (r2->out.info == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.needed = talloc_zero(r2, uint32_t);
		if (r2->out.needed == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _spoolss_EnumPrintProcessorDataTypes(p, r2);
		break;
	}
	case 52: { /* spoolss_ResetPrinter */
		struct spoolss_ResetPrinter *r2 = (struct spoolss_ResetPrinter *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_ResetPrinter, NDR_IN, r2);
		}
		r2->out.result = _spoolss_ResetPrinter(p, r2);
		break;
	}
	case 53: { /* spoolss_GetPrinterDriver2 */
		struct spoolss_GetPrinterDriver2 *r2 = (struct spoolss_GetPrinterDriver2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_GetPrinterDriver2, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.info = talloc_zero(r2, union spoolss_DriverInfo);
		if (r2->out.info == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.needed = talloc_zero(r2, uint32_t);
		if (r2->out.needed == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.server_major_version = talloc_zero(r2, uint32_t);
		if (r2->out.server_major_version == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.server_minor_version = talloc_zero(r2, uint32_t);
		if (r2->out.server_minor_version == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _spoolss_GetPrinterDriver2(p, r2);
		break;
	}
	case 54: { /* spoolss_FindFirstPrinterChangeNotification */
		struct spoolss_FindFirstPrinterChangeNotification *r2 = (struct spoolss_FindFirstPrinterChangeNotification *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_FindFirstPrinterChangeNotification, NDR_IN, r2);
		}
		r2->out.result = _spoolss_FindFirstPrinterChangeNotification(p, r2);
		break;
	}
	case 55: { /* spoolss_FindNextPrinterChangeNotification */
		struct spoolss_FindNextPrinterChangeNotification *r2 = (struct spoolss_FindNextPrinterChangeNotification *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_FindNextPrinterChangeNotification, NDR_IN, r2);
		}
		r2->out.result = _spoolss_FindNextPrinterChangeNotification(p, r2);
		break;
	}
	case 56: { /* spoolss_FindClosePrinterNotify */
		struct spoolss_FindClosePrinterNotify *r2 = (struct spoolss_FindClosePrinterNotify *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_FindClosePrinterNotify, NDR_IN, r2);
		}
		r2->out.result = _spoolss_FindClosePrinterNotify(p, r2);
		break;
	}
	case 57: { /* spoolss_RouterFindFirstPrinterChangeNotificationOld */
		struct spoolss_RouterFindFirstPrinterChangeNotificationOld *r2 = (struct spoolss_RouterFindFirstPrinterChangeNotificationOld *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_RouterFindFirstPrinterChangeNotificationOld, NDR_IN, r2);
		}
		r2->out.result = _spoolss_RouterFindFirstPrinterChangeNotificationOld(p, r2);
		break;
	}
	case 58: { /* spoolss_ReplyOpenPrinter */
		struct spoolss_ReplyOpenPrinter *r2 = (struct spoolss_ReplyOpenPrinter *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_ReplyOpenPrinter, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.handle = talloc_zero(r2, struct policy_handle);
		if (r2->out.handle == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _spoolss_ReplyOpenPrinter(p, r2);
		break;
	}
	case 59: { /* spoolss_RouterReplyPrinter */
		struct spoolss_RouterReplyPrinter *r2 = (struct spoolss_RouterReplyPrinter *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_RouterReplyPrinter, NDR_IN, r2);
		}
		r2->out.result = _spoolss_RouterReplyPrinter(p, r2);
		break;
	}
	case 60: { /* spoolss_ReplyClosePrinter */
		struct spoolss_ReplyClosePrinter *r2 = (struct spoolss_ReplyClosePrinter *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_ReplyClosePrinter, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.handle = r2->in.handle;
		r2->out.result = _spoolss_ReplyClosePrinter(p, r2);
		break;
	}
	case 61: { /* spoolss_AddPortEx */
		struct spoolss_AddPortEx *r2 = (struct spoolss_AddPortEx *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_AddPortEx, NDR_IN, r2);
		}
		r2->out.result = _spoolss_AddPortEx(p, r2);
		break;
	}
	case 62: { /* spoolss_RouterFindFirstPrinterChangeNotification */
		struct spoolss_RouterFindFirstPrinterChangeNotification *r2 = (struct spoolss_RouterFindFirstPrinterChangeNotification *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_RouterFindFirstPrinterChangeNotification, NDR_IN, r2);
		}
		r2->out.result = _spoolss_RouterFindFirstPrinterChangeNotification(p, r2);
		break;
	}
	case 63: { /* spoolss_SpoolerInit */
		struct spoolss_SpoolerInit *r2 = (struct spoolss_SpoolerInit *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_SpoolerInit, NDR_IN, r2);
		}
		r2->out.result = _spoolss_SpoolerInit(p, r2);
		break;
	}
	case 64: { /* spoolss_ResetPrinterEx */
		struct spoolss_ResetPrinterEx *r2 = (struct spoolss_ResetPrinterEx *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_ResetPrinterEx, NDR_IN, r2);
		}
		r2->out.result = _spoolss_ResetPrinterEx(p, r2);
		break;
	}
	case 65: { /* spoolss_RemoteFindFirstPrinterChangeNotifyEx */
		struct spoolss_RemoteFindFirstPrinterChangeNotifyEx *r2 = (struct spoolss_RemoteFindFirstPrinterChangeNotifyEx *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_RemoteFindFirstPrinterChangeNotifyEx, NDR_IN, r2);
		}
		r2->out.result = _spoolss_RemoteFindFirstPrinterChangeNotifyEx(p, r2);
		break;
	}
	case 66: { /* spoolss_RouterReplyPrinterEx */
		struct spoolss_RouterReplyPrinterEx *r2 = (struct spoolss_RouterReplyPrinterEx *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_RouterReplyPrinterEx, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.reply_result = talloc_zero(r2, uint32_t);
		if (r2->out.reply_result == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _spoolss_RouterReplyPrinterEx(p, r2);
		break;
	}
	case 67: { /* spoolss_RouterRefreshPrinterChangeNotify */
		struct spoolss_RouterRefreshPrinterChangeNotify *r2 = (struct spoolss_RouterRefreshPrinterChangeNotify *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_RouterRefreshPrinterChangeNotify, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.info = talloc_zero(r2, struct spoolss_NotifyInfo *);
		if (r2->out.info == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _spoolss_RouterRefreshPrinterChangeNotify(p, r2);
		break;
	}
	case 68: { /* spoolss_44 */
		struct spoolss_44 *r2 = (struct spoolss_44 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_44, NDR_IN, r2);
		}
		r2->out.result = _spoolss_44(p, r2);
		break;
	}
	case 69: { /* spoolss_OpenPrinterEx */
		struct spoolss_OpenPrinterEx *r2 = (struct spoolss_OpenPrinterEx *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_OpenPrinterEx, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.handle = talloc_zero(r2, struct policy_handle);
		if (r2->out.handle == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _spoolss_OpenPrinterEx(p, r2);
		break;
	}
	case 70: { /* spoolss_AddPrinterEx */
		struct spoolss_AddPrinterEx *r2 = (struct spoolss_AddPrinterEx *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_AddPrinterEx, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.handle = talloc_zero(r2, struct policy_handle);
		if (r2->out.handle == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _spoolss_AddPrinterEx(p, r2);
		break;
	}
	case 71: { /* spoolss_SetPort */
		struct spoolss_SetPort *r2 = (struct spoolss_SetPort *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_SetPort, NDR_IN, r2);
		}
		r2->out.result = _spoolss_SetPort(p, r2);
		break;
	}
	case 72: { /* spoolss_EnumPrinterData */
		struct spoolss_EnumPrinterData *r2 = (struct spoolss_EnumPrinterData *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_EnumPrinterData, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.value_name = talloc_zero_array(r2, const char, r2->in.value_offered / 2);
		if (r2->out.value_name == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.value_needed = talloc_zero(r2, uint32_t);
		if (r2->out.value_needed == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.type = talloc_zero(r2, enum winreg_Type);
		if (r2->out.type == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.data = talloc_zero_array(r2, uint8_t, r2->in.data_offered);
		if (r2->out.data == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.data_needed = talloc_zero(r2, uint32_t);
		if (r2->out.data_needed == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _spoolss_EnumPrinterData(p, r2);
		break;
	}
	case 73: { /* spoolss_DeletePrinterData */
		struct spoolss_DeletePrinterData *r2 = (struct spoolss_DeletePrinterData *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_DeletePrinterData, NDR_IN, r2);
		}
		r2->out.result = _spoolss_DeletePrinterData(p, r2);
		break;
	}
	case 74: { /* spoolss_4a */
		struct spoolss_4a *r2 = (struct spoolss_4a *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_4a, NDR_IN, r2);
		}
		r2->out.result = _spoolss_4a(p, r2);
		break;
	}
	case 75: { /* spoolss_4b */
		struct spoolss_4b *r2 = (struct spoolss_4b *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_4b, NDR_IN, r2);
		}
		r2->out.result = _spoolss_4b(p, r2);
		break;
	}
	case 76: { /* spoolss_4c */
		struct spoolss_4c *r2 = (struct spoolss_4c *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_4c, NDR_IN, r2);
		}
		r2->out.result = _spoolss_4c(p, r2);
		break;
	}
	case 77: { /* spoolss_SetPrinterDataEx */
		struct spoolss_SetPrinterDataEx *r2 = (struct spoolss_SetPrinterDataEx *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_SetPrinterDataEx, NDR_IN, r2);
		}
		r2->out.result = _spoolss_SetPrinterDataEx(p, r2);
		break;
	}
	case 78: { /* spoolss_GetPrinterDataEx */
		struct spoolss_GetPrinterDataEx *r2 = (struct spoolss_GetPrinterDataEx *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_GetPrinterDataEx, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.type = talloc_zero(r2, enum winreg_Type);
		if (r2->out.type == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.data = talloc_zero_array(r2, uint8_t, r2->in.offered);
		if (r2->out.data == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.needed = talloc_zero(r2, uint32_t);
		if (r2->out.needed == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _spoolss_GetPrinterDataEx(p, r2);
		break;
	}
	case 79: { /* spoolss_EnumPrinterDataEx */
		struct spoolss_EnumPrinterDataEx *r2 = (struct spoolss_EnumPrinterDataEx *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_EnumPrinterDataEx, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.count = talloc_zero(r2, uint32_t);
		if (r2->out.count == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.info = talloc_zero(r2, struct spoolss_PrinterEnumValues *);
		if (r2->out.info == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.needed = talloc_zero(r2, uint32_t);
		if (r2->out.needed == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _spoolss_EnumPrinterDataEx(p, r2);
		break;
	}
	case 80: { /* spoolss_EnumPrinterKey */
		struct spoolss_EnumPrinterKey *r2 = (struct spoolss_EnumPrinterKey *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_EnumPrinterKey, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out._ndr_size = talloc_zero(r2, uint32_t);
		if (r2->out._ndr_size == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.key_buffer = talloc_zero(r2, union spoolss_KeyNames);
		if (r2->out.key_buffer == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.needed = talloc_zero(r2, uint32_t);
		if (r2->out.needed == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _spoolss_EnumPrinterKey(p, r2);
		break;
	}
	case 81: { /* spoolss_DeletePrinterDataEx */
		struct spoolss_DeletePrinterDataEx *r2 = (struct spoolss_DeletePrinterDataEx *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_DeletePrinterDataEx, NDR_IN, r2);
		}
		r2->out.result = _spoolss_DeletePrinterDataEx(p, r2);
		break;
	}
	case 82: { /* spoolss_DeletePrinterKey */
		struct spoolss_DeletePrinterKey *r2 = (struct spoolss_DeletePrinterKey *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_DeletePrinterKey, NDR_IN, r2);
		}
		r2->out.result = _spoolss_DeletePrinterKey(p, r2);
		break;
	}
	case 83: { /* spoolss_53 */
		struct spoolss_53 *r2 = (struct spoolss_53 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_53, NDR_IN, r2);
		}
		r2->out.result = _spoolss_53(p, r2);
		break;
	}
	case 84: { /* spoolss_DeletePrinterDriverEx */
		struct spoolss_DeletePrinterDriverEx *r2 = (struct spoolss_DeletePrinterDriverEx *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_DeletePrinterDriverEx, NDR_IN, r2);
		}
		r2->out.result = _spoolss_DeletePrinterDriverEx(p, r2);
		break;
	}
	case 85: { /* spoolss_AddPerMachineConnection */
		struct spoolss_AddPerMachineConnection *r2 = (struct spoolss_AddPerMachineConnection *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_AddPerMachineConnection, NDR_IN, r2);
		}
		r2->out.result = _spoolss_AddPerMachineConnection(p, r2);
		break;
	}
	case 86: { /* spoolss_DeletePerMachineConnection */
		struct spoolss_DeletePerMachineConnection *r2 = (struct spoolss_DeletePerMachineConnection *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_DeletePerMachineConnection, NDR_IN, r2);
		}
		r2->out.result = _spoolss_DeletePerMachineConnection(p, r2);
		break;
	}
	case 87: { /* spoolss_EnumPerMachineConnections */
		struct spoolss_EnumPerMachineConnections *r2 = (struct spoolss_EnumPerMachineConnections *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_EnumPerMachineConnections, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.count = talloc_zero(r2, uint32_t);
		if (r2->out.count == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.info = talloc_zero(r2, struct spoolss_PrinterInfo4 *);
		if (r2->out.info == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.needed = talloc_zero(r2, uint32_t);
		if (r2->out.needed == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _spoolss_EnumPerMachineConnections(p, r2);
		break;
	}
	case 88: { /* spoolss_XcvData */
		struct spoolss_XcvData *r2 = (struct spoolss_XcvData *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_XcvData, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.status_code = r2->in.status_code;
		r2->out.out_data = talloc_zero_array(r2, uint8_t, r2->in.out_data_size);
		if (r2->out.out_data == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.needed = talloc_zero(r2, uint32_t);
		if (r2->out.needed == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _spoolss_XcvData(p, r2);
		break;
	}
	case 89: { /* spoolss_AddPrinterDriverEx */
		struct spoolss_AddPrinterDriverEx *r2 = (struct spoolss_AddPrinterDriverEx *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_AddPrinterDriverEx, NDR_IN, r2);
		}
		r2->out.result = _spoolss_AddPrinterDriverEx(p, r2);
		break;
	}
	case 90: { /* spoolss_5a */
		struct spoolss_5a *r2 = (struct spoolss_5a *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_5a, NDR_IN, r2);
		}
		r2->out.result = _spoolss_5a(p, r2);
		break;
	}
	case 91: { /* spoolss_5b */
		struct spoolss_5b *r2 = (struct spoolss_5b *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_5b, NDR_IN, r2);
		}
		r2->out.result = _spoolss_5b(p, r2);
		break;
	}
	case 92: { /* spoolss_5c */
		struct spoolss_5c *r2 = (struct spoolss_5c *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_5c, NDR_IN, r2);
		}
		r2->out.result = _spoolss_5c(p, r2);
		break;
	}
	case 93: { /* spoolss_5d */
		struct spoolss_5d *r2 = (struct spoolss_5d *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_5d, NDR_IN, r2);
		}
		r2->out.result = _spoolss_5d(p, r2);
		break;
	}
	case 94: { /* spoolss_5e */
		struct spoolss_5e *r2 = (struct spoolss_5e *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_5e, NDR_IN, r2);
		}
		r2->out.result = _spoolss_5e(p, r2);
		break;
	}
	case 95: { /* spoolss_5f */
		struct spoolss_5f *r2 = (struct spoolss_5f *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_5f, NDR_IN, r2);
		}
		r2->out.result = _spoolss_5f(p, r2);
		break;
	}
	case 96: { /* spoolss_60 */
		struct spoolss_60 *r2 = (struct spoolss_60 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_60, NDR_IN, r2);
		}
		r2->out.result = _spoolss_60(p, r2);
		break;
	}
	case 97: { /* spoolss_SendRecvBidiData */
		struct spoolss_SendRecvBidiData *r2 = (struct spoolss_SendRecvBidiData *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_SendRecvBidiData, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.ppRespData = talloc_zero(r2, struct RPC_BIDI_RESPONSE_CONTAINER *);
		if (r2->out.ppRespData == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _spoolss_SendRecvBidiData(p, r2);
		break;
	}
	case 98: { /* spoolss_62 */
		struct spoolss_62 *r2 = (struct spoolss_62 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_62, NDR_IN, r2);
		}
		r2->out.result = _spoolss_62(p, r2);
		break;
	}
	case 99: { /* spoolss_63 */
		struct spoolss_63 *r2 = (struct spoolss_63 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_63, NDR_IN, r2);
		}
		r2->out.result = _spoolss_63(p, r2);
		break;
	}
	case 100: { /* spoolss_64 */
		struct spoolss_64 *r2 = (struct spoolss_64 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_64, NDR_IN, r2);
		}
		r2->out.result = _spoolss_64(p, r2);
		break;
	}
	case 101: { /* spoolss_65 */
		struct spoolss_65 *r2 = (struct spoolss_65 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_65, NDR_IN, r2);
		}
		r2->out.result = _spoolss_65(p, r2);
		break;
	}
	case 102: { /* spoolss_GetCorePrinterDrivers */
		struct spoolss_GetCorePrinterDrivers *r2 = (struct spoolss_GetCorePrinterDrivers *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_GetCorePrinterDrivers, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.core_printer_drivers = talloc_zero_array(r2, struct spoolss_CorePrinterDriver, r2->in.core_printer_driver_count);
		if (r2->out.core_printer_drivers == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _spoolss_GetCorePrinterDrivers(p, r2);
		break;
	}
	case 103: { /* spoolss_67 */
		struct spoolss_67 *r2 = (struct spoolss_67 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_67, NDR_IN, r2);
		}
		r2->out.result = _spoolss_67(p, r2);
		break;
	}
	case 104: { /* spoolss_GetPrinterDriverPackagePath */
		struct spoolss_GetPrinterDriverPackagePath *r2 = (struct spoolss_GetPrinterDriverPackagePath *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_GetPrinterDriverPackagePath, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.driver_package_cab = r2->in.driver_package_cab;
		r2->out.required = talloc_zero(r2, uint32_t);
		if (r2->out.required == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _spoolss_GetPrinterDriverPackagePath(p, r2);
		break;
	}
	case 105: { /* spoolss_69 */
		struct spoolss_69 *r2 = (struct spoolss_69 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_69, NDR_IN, r2);
		}
		r2->out.result = _spoolss_69(p, r2);
		break;
	}
	case 106: { /* spoolss_6a */
		struct spoolss_6a *r2 = (struct spoolss_6a *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_6a, NDR_IN, r2);
		}
		r2->out.result = _spoolss_6a(p, r2);
		break;
	}
	case 107: { /* spoolss_6b */
		struct spoolss_6b *r2 = (struct spoolss_6b *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_6b, NDR_IN, r2);
		}
		r2->out.result = _spoolss_6b(p, r2);
		break;
	}
	case 108: { /* spoolss_6c */
		struct spoolss_6c *r2 = (struct spoolss_6c *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_6c, NDR_IN, r2);
		}
		r2->out.result = _spoolss_6c(p, r2);
		break;
	}
	case 109: { /* spoolss_6d */
		struct spoolss_6d *r2 = (struct spoolss_6d *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_6d, NDR_IN, r2);
		}
		r2->out.result = _spoolss_6d(p, r2);
		break;
	}
	case 110: { /* spoolss_GetJobNamedPropertyValue */
		struct spoolss_GetJobNamedPropertyValue *r2 = (struct spoolss_GetJobNamedPropertyValue *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_GetJobNamedPropertyValue, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.pValue = talloc_zero(r2, struct spoolss_PrintPropertyValue);
		if (r2->out.pValue == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _spoolss_GetJobNamedPropertyValue(p, r2);
		break;
	}
	case 111: { /* spoolss_SetJobNamedProperty */
		struct spoolss_SetJobNamedProperty *r2 = (struct spoolss_SetJobNamedProperty *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_SetJobNamedProperty, NDR_IN, r2);
		}
		r2->out.result = _spoolss_SetJobNamedProperty(p, r2);
		break;
	}
	case 112: { /* spoolss_DeleteJobNamedProperty */
		struct spoolss_DeleteJobNamedProperty *r2 = (struct spoolss_DeleteJobNamedProperty *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_DeleteJobNamedProperty, NDR_IN, r2);
		}
		r2->out.result = _spoolss_DeleteJobNamedProperty(p, r2);
		break;
	}
	case 113: { /* spoolss_EnumJobNamedProperties */
		struct spoolss_EnumJobNamedProperties *r2 = (struct spoolss_EnumJobNamedProperties *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_EnumJobNamedProperties, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.pcProperties = talloc_zero(r2, uint32_t);
		if (r2->out.pcProperties == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.ppProperties = talloc_zero(r2, struct spoolss_PrintNamedProperty *);
		if (r2->out.ppProperties == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _spoolss_EnumJobNamedProperties(p, r2);
		break;
	}
	case 114: { /* spoolss_72 */
		struct spoolss_72 *r2 = (struct spoolss_72 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_72, NDR_IN, r2);
		}
		r2->out.result = _spoolss_72(p, r2);
		break;
	}
	case 115: { /* spoolss_73 */
		struct spoolss_73 *r2 = (struct spoolss_73 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_73, NDR_IN, r2);
		}
		r2->out.result = _spoolss_73(p, r2);
		break;
	}
	case 116: { /* spoolss_LogJobInfoForBranchOffice */
		struct spoolss_LogJobInfoForBranchOffice *r2 = (struct spoolss_LogJobInfoForBranchOffice *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_LogJobInfoForBranchOffice, NDR_IN, r2);
		}
		r2->out.result = _spoolss_LogJobInfoForBranchOffice(p, r2);
		break;
	}
	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

fail:
	/* Unimpersonate */
	if (impersonated) {
		unbecome_authenticated_pipe_user();
	}

	p->dce_call = NULL;
	p->mem_ctx = NULL;
	/* Check pipes struct fault state */
	if (p->fault_state != 0) {
		dce_call->fault_code = p->fault_state;
	}
	if (dce_call->fault_code != 0) {
		status = NT_STATUS_NET_WRITE_FAULT;
	}

	return status;
}

NTSTATUS spoolss__op_dispatch(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	return spoolss__op_dispatch_internal(dce_call, mem_ctx, r, S3COMPAT_RPC_DISPATCH_EXTERNAL);
}

NTSTATUS spoolss__op_reply(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: { /* spoolss_EnumPrinters */
		struct spoolss_EnumPrinters *r2 = (struct spoolss_EnumPrinters *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_EnumPrinters replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_EnumPrinters, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_EnumPrinters\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 1: { /* spoolss_OpenPrinter */
		struct spoolss_OpenPrinter *r2 = (struct spoolss_OpenPrinter *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_OpenPrinter replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_OpenPrinter, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_OpenPrinter\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 2: { /* spoolss_SetJob */
		struct spoolss_SetJob *r2 = (struct spoolss_SetJob *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_SetJob replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_SetJob, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_SetJob\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 3: { /* spoolss_GetJob */
		struct spoolss_GetJob *r2 = (struct spoolss_GetJob *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_GetJob replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_GetJob, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_GetJob\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 4: { /* spoolss_EnumJobs */
		struct spoolss_EnumJobs *r2 = (struct spoolss_EnumJobs *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_EnumJobs replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_EnumJobs, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_EnumJobs\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 5: { /* spoolss_AddPrinter */
		struct spoolss_AddPrinter *r2 = (struct spoolss_AddPrinter *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_AddPrinter replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_AddPrinter, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_AddPrinter\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 6: { /* spoolss_DeletePrinter */
		struct spoolss_DeletePrinter *r2 = (struct spoolss_DeletePrinter *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_DeletePrinter replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_DeletePrinter, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_DeletePrinter\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 7: { /* spoolss_SetPrinter */
		struct spoolss_SetPrinter *r2 = (struct spoolss_SetPrinter *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_SetPrinter replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_SetPrinter, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_SetPrinter\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 8: { /* spoolss_GetPrinter */
		struct spoolss_GetPrinter *r2 = (struct spoolss_GetPrinter *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_GetPrinter replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_GetPrinter, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_GetPrinter\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 9: { /* spoolss_AddPrinterDriver */
		struct spoolss_AddPrinterDriver *r2 = (struct spoolss_AddPrinterDriver *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_AddPrinterDriver replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_AddPrinterDriver, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_AddPrinterDriver\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 10: { /* spoolss_EnumPrinterDrivers */
		struct spoolss_EnumPrinterDrivers *r2 = (struct spoolss_EnumPrinterDrivers *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_EnumPrinterDrivers replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_EnumPrinterDrivers, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_EnumPrinterDrivers\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 11: { /* spoolss_GetPrinterDriver */
		struct spoolss_GetPrinterDriver *r2 = (struct spoolss_GetPrinterDriver *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_GetPrinterDriver replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_GetPrinterDriver, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_GetPrinterDriver\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 12: { /* spoolss_GetPrinterDriverDirectory */
		struct spoolss_GetPrinterDriverDirectory *r2 = (struct spoolss_GetPrinterDriverDirectory *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_GetPrinterDriverDirectory replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_GetPrinterDriverDirectory, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_GetPrinterDriverDirectory\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 13: { /* spoolss_DeletePrinterDriver */
		struct spoolss_DeletePrinterDriver *r2 = (struct spoolss_DeletePrinterDriver *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_DeletePrinterDriver replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_DeletePrinterDriver, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_DeletePrinterDriver\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 14: { /* spoolss_AddPrintProcessor */
		struct spoolss_AddPrintProcessor *r2 = (struct spoolss_AddPrintProcessor *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_AddPrintProcessor replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_AddPrintProcessor, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_AddPrintProcessor\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 15: { /* spoolss_EnumPrintProcessors */
		struct spoolss_EnumPrintProcessors *r2 = (struct spoolss_EnumPrintProcessors *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_EnumPrintProcessors replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_EnumPrintProcessors, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_EnumPrintProcessors\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 16: { /* spoolss_GetPrintProcessorDirectory */
		struct spoolss_GetPrintProcessorDirectory *r2 = (struct spoolss_GetPrintProcessorDirectory *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_GetPrintProcessorDirectory replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_GetPrintProcessorDirectory, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_GetPrintProcessorDirectory\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 17: { /* spoolss_StartDocPrinter */
		struct spoolss_StartDocPrinter *r2 = (struct spoolss_StartDocPrinter *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_StartDocPrinter replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_StartDocPrinter, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_StartDocPrinter\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 18: { /* spoolss_StartPagePrinter */
		struct spoolss_StartPagePrinter *r2 = (struct spoolss_StartPagePrinter *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_StartPagePrinter replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_StartPagePrinter, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_StartPagePrinter\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 19: { /* spoolss_WritePrinter */
		struct spoolss_WritePrinter *r2 = (struct spoolss_WritePrinter *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_WritePrinter replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_WritePrinter, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_WritePrinter\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 20: { /* spoolss_EndPagePrinter */
		struct spoolss_EndPagePrinter *r2 = (struct spoolss_EndPagePrinter *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_EndPagePrinter replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_EndPagePrinter, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_EndPagePrinter\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 21: { /* spoolss_AbortPrinter */
		struct spoolss_AbortPrinter *r2 = (struct spoolss_AbortPrinter *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_AbortPrinter replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_AbortPrinter, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_AbortPrinter\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 22: { /* spoolss_ReadPrinter */
		struct spoolss_ReadPrinter *r2 = (struct spoolss_ReadPrinter *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_ReadPrinter replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_ReadPrinter, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_ReadPrinter\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 23: { /* spoolss_EndDocPrinter */
		struct spoolss_EndDocPrinter *r2 = (struct spoolss_EndDocPrinter *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_EndDocPrinter replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_EndDocPrinter, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_EndDocPrinter\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 24: { /* spoolss_AddJob */
		struct spoolss_AddJob *r2 = (struct spoolss_AddJob *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_AddJob replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_AddJob, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_AddJob\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 25: { /* spoolss_ScheduleJob */
		struct spoolss_ScheduleJob *r2 = (struct spoolss_ScheduleJob *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_ScheduleJob replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_ScheduleJob, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_ScheduleJob\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 26: { /* spoolss_GetPrinterData */
		struct spoolss_GetPrinterData *r2 = (struct spoolss_GetPrinterData *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_GetPrinterData replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_GetPrinterData, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_GetPrinterData\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 27: { /* spoolss_SetPrinterData */
		struct spoolss_SetPrinterData *r2 = (struct spoolss_SetPrinterData *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_SetPrinterData replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_SetPrinterData, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_SetPrinterData\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 28: { /* spoolss_WaitForPrinterChange */
		struct spoolss_WaitForPrinterChange *r2 = (struct spoolss_WaitForPrinterChange *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_WaitForPrinterChange replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_WaitForPrinterChange, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_WaitForPrinterChange\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 29: { /* spoolss_ClosePrinter */
		struct spoolss_ClosePrinter *r2 = (struct spoolss_ClosePrinter *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_ClosePrinter replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_ClosePrinter, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_ClosePrinter\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 30: { /* spoolss_AddForm */
		struct spoolss_AddForm *r2 = (struct spoolss_AddForm *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_AddForm replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_AddForm, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_AddForm\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 31: { /* spoolss_DeleteForm */
		struct spoolss_DeleteForm *r2 = (struct spoolss_DeleteForm *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_DeleteForm replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_DeleteForm, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_DeleteForm\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 32: { /* spoolss_GetForm */
		struct spoolss_GetForm *r2 = (struct spoolss_GetForm *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_GetForm replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_GetForm, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_GetForm\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 33: { /* spoolss_SetForm */
		struct spoolss_SetForm *r2 = (struct spoolss_SetForm *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_SetForm replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_SetForm, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_SetForm\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 34: { /* spoolss_EnumForms */
		struct spoolss_EnumForms *r2 = (struct spoolss_EnumForms *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_EnumForms replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_EnumForms, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_EnumForms\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 35: { /* spoolss_EnumPorts */
		struct spoolss_EnumPorts *r2 = (struct spoolss_EnumPorts *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_EnumPorts replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_EnumPorts, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_EnumPorts\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 36: { /* spoolss_EnumMonitors */
		struct spoolss_EnumMonitors *r2 = (struct spoolss_EnumMonitors *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_EnumMonitors replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_EnumMonitors, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_EnumMonitors\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 37: { /* spoolss_AddPort */
		struct spoolss_AddPort *r2 = (struct spoolss_AddPort *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_AddPort replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_AddPort, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_AddPort\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 38: { /* spoolss_ConfigurePort */
		struct spoolss_ConfigurePort *r2 = (struct spoolss_ConfigurePort *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_ConfigurePort replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_ConfigurePort, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_ConfigurePort\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 39: { /* spoolss_DeletePort */
		struct spoolss_DeletePort *r2 = (struct spoolss_DeletePort *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_DeletePort replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_DeletePort, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_DeletePort\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 40: { /* spoolss_CreatePrinterIC */
		struct spoolss_CreatePrinterIC *r2 = (struct spoolss_CreatePrinterIC *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_CreatePrinterIC replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_CreatePrinterIC, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_CreatePrinterIC\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 41: { /* spoolss_PlayGDIScriptOnPrinterIC */
		struct spoolss_PlayGDIScriptOnPrinterIC *r2 = (struct spoolss_PlayGDIScriptOnPrinterIC *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_PlayGDIScriptOnPrinterIC replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_PlayGDIScriptOnPrinterIC, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_PlayGDIScriptOnPrinterIC\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 42: { /* spoolss_DeletePrinterIC */
		struct spoolss_DeletePrinterIC *r2 = (struct spoolss_DeletePrinterIC *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_DeletePrinterIC replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_DeletePrinterIC, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_DeletePrinterIC\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 43: { /* spoolss_AddPrinterConnection */
		struct spoolss_AddPrinterConnection *r2 = (struct spoolss_AddPrinterConnection *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_AddPrinterConnection replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_AddPrinterConnection, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_AddPrinterConnection\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 44: { /* spoolss_DeletePrinterConnection */
		struct spoolss_DeletePrinterConnection *r2 = (struct spoolss_DeletePrinterConnection *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_DeletePrinterConnection replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_DeletePrinterConnection, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_DeletePrinterConnection\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 45: { /* spoolss_PrinterMessageBox */
		struct spoolss_PrinterMessageBox *r2 = (struct spoolss_PrinterMessageBox *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_PrinterMessageBox replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_PrinterMessageBox, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_PrinterMessageBox\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 46: { /* spoolss_AddMonitor */
		struct spoolss_AddMonitor *r2 = (struct spoolss_AddMonitor *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_AddMonitor replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_AddMonitor, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_AddMonitor\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 47: { /* spoolss_DeleteMonitor */
		struct spoolss_DeleteMonitor *r2 = (struct spoolss_DeleteMonitor *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_DeleteMonitor replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_DeleteMonitor, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_DeleteMonitor\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 48: { /* spoolss_DeletePrintProcessor */
		struct spoolss_DeletePrintProcessor *r2 = (struct spoolss_DeletePrintProcessor *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_DeletePrintProcessor replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_DeletePrintProcessor, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_DeletePrintProcessor\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 49: { /* spoolss_AddPrintProvidor */
		struct spoolss_AddPrintProvidor *r2 = (struct spoolss_AddPrintProvidor *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_AddPrintProvidor replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_AddPrintProvidor, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_AddPrintProvidor\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 50: { /* spoolss_DeletePrintProvidor */
		struct spoolss_DeletePrintProvidor *r2 = (struct spoolss_DeletePrintProvidor *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_DeletePrintProvidor replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_DeletePrintProvidor, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_DeletePrintProvidor\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 51: { /* spoolss_EnumPrintProcessorDataTypes */
		struct spoolss_EnumPrintProcessorDataTypes *r2 = (struct spoolss_EnumPrintProcessorDataTypes *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_EnumPrintProcessorDataTypes replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_EnumPrintProcessorDataTypes, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_EnumPrintProcessorDataTypes\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 52: { /* spoolss_ResetPrinter */
		struct spoolss_ResetPrinter *r2 = (struct spoolss_ResetPrinter *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_ResetPrinter replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_ResetPrinter, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_ResetPrinter\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 53: { /* spoolss_GetPrinterDriver2 */
		struct spoolss_GetPrinterDriver2 *r2 = (struct spoolss_GetPrinterDriver2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_GetPrinterDriver2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_GetPrinterDriver2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_GetPrinterDriver2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 54: { /* spoolss_FindFirstPrinterChangeNotification */
		struct spoolss_FindFirstPrinterChangeNotification *r2 = (struct spoolss_FindFirstPrinterChangeNotification *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_FindFirstPrinterChangeNotification replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_FindFirstPrinterChangeNotification, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_FindFirstPrinterChangeNotification\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 55: { /* spoolss_FindNextPrinterChangeNotification */
		struct spoolss_FindNextPrinterChangeNotification *r2 = (struct spoolss_FindNextPrinterChangeNotification *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_FindNextPrinterChangeNotification replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_FindNextPrinterChangeNotification, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_FindNextPrinterChangeNotification\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 56: { /* spoolss_FindClosePrinterNotify */
		struct spoolss_FindClosePrinterNotify *r2 = (struct spoolss_FindClosePrinterNotify *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_FindClosePrinterNotify replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_FindClosePrinterNotify, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_FindClosePrinterNotify\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 57: { /* spoolss_RouterFindFirstPrinterChangeNotificationOld */
		struct spoolss_RouterFindFirstPrinterChangeNotificationOld *r2 = (struct spoolss_RouterFindFirstPrinterChangeNotificationOld *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_RouterFindFirstPrinterChangeNotificationOld replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_RouterFindFirstPrinterChangeNotificationOld, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_RouterFindFirstPrinterChangeNotificationOld\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 58: { /* spoolss_ReplyOpenPrinter */
		struct spoolss_ReplyOpenPrinter *r2 = (struct spoolss_ReplyOpenPrinter *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_ReplyOpenPrinter replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_ReplyOpenPrinter, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_ReplyOpenPrinter\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 59: { /* spoolss_RouterReplyPrinter */
		struct spoolss_RouterReplyPrinter *r2 = (struct spoolss_RouterReplyPrinter *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_RouterReplyPrinter replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_RouterReplyPrinter, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_RouterReplyPrinter\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 60: { /* spoolss_ReplyClosePrinter */
		struct spoolss_ReplyClosePrinter *r2 = (struct spoolss_ReplyClosePrinter *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_ReplyClosePrinter replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_ReplyClosePrinter, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_ReplyClosePrinter\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 61: { /* spoolss_AddPortEx */
		struct spoolss_AddPortEx *r2 = (struct spoolss_AddPortEx *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_AddPortEx replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_AddPortEx, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_AddPortEx\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 62: { /* spoolss_RouterFindFirstPrinterChangeNotification */
		struct spoolss_RouterFindFirstPrinterChangeNotification *r2 = (struct spoolss_RouterFindFirstPrinterChangeNotification *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_RouterFindFirstPrinterChangeNotification replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_RouterFindFirstPrinterChangeNotification, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_RouterFindFirstPrinterChangeNotification\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 63: { /* spoolss_SpoolerInit */
		struct spoolss_SpoolerInit *r2 = (struct spoolss_SpoolerInit *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_SpoolerInit replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_SpoolerInit, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_SpoolerInit\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 64: { /* spoolss_ResetPrinterEx */
		struct spoolss_ResetPrinterEx *r2 = (struct spoolss_ResetPrinterEx *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_ResetPrinterEx replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_ResetPrinterEx, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_ResetPrinterEx\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 65: { /* spoolss_RemoteFindFirstPrinterChangeNotifyEx */
		struct spoolss_RemoteFindFirstPrinterChangeNotifyEx *r2 = (struct spoolss_RemoteFindFirstPrinterChangeNotifyEx *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_RemoteFindFirstPrinterChangeNotifyEx replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_RemoteFindFirstPrinterChangeNotifyEx, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_RemoteFindFirstPrinterChangeNotifyEx\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 66: { /* spoolss_RouterReplyPrinterEx */
		struct spoolss_RouterReplyPrinterEx *r2 = (struct spoolss_RouterReplyPrinterEx *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_RouterReplyPrinterEx replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_RouterReplyPrinterEx, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_RouterReplyPrinterEx\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 67: { /* spoolss_RouterRefreshPrinterChangeNotify */
		struct spoolss_RouterRefreshPrinterChangeNotify *r2 = (struct spoolss_RouterRefreshPrinterChangeNotify *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_RouterRefreshPrinterChangeNotify replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_RouterRefreshPrinterChangeNotify, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_RouterRefreshPrinterChangeNotify\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 68: { /* spoolss_44 */
		struct spoolss_44 *r2 = (struct spoolss_44 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_44 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_44, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_44\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 69: { /* spoolss_OpenPrinterEx */
		struct spoolss_OpenPrinterEx *r2 = (struct spoolss_OpenPrinterEx *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_OpenPrinterEx replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_OpenPrinterEx, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_OpenPrinterEx\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 70: { /* spoolss_AddPrinterEx */
		struct spoolss_AddPrinterEx *r2 = (struct spoolss_AddPrinterEx *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_AddPrinterEx replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_AddPrinterEx, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_AddPrinterEx\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 71: { /* spoolss_SetPort */
		struct spoolss_SetPort *r2 = (struct spoolss_SetPort *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_SetPort replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_SetPort, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_SetPort\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 72: { /* spoolss_EnumPrinterData */
		struct spoolss_EnumPrinterData *r2 = (struct spoolss_EnumPrinterData *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_EnumPrinterData replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_EnumPrinterData, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_EnumPrinterData\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 73: { /* spoolss_DeletePrinterData */
		struct spoolss_DeletePrinterData *r2 = (struct spoolss_DeletePrinterData *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_DeletePrinterData replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_DeletePrinterData, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_DeletePrinterData\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 74: { /* spoolss_4a */
		struct spoolss_4a *r2 = (struct spoolss_4a *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_4a replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_4a, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_4a\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 75: { /* spoolss_4b */
		struct spoolss_4b *r2 = (struct spoolss_4b *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_4b replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_4b, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_4b\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 76: { /* spoolss_4c */
		struct spoolss_4c *r2 = (struct spoolss_4c *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_4c replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_4c, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_4c\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 77: { /* spoolss_SetPrinterDataEx */
		struct spoolss_SetPrinterDataEx *r2 = (struct spoolss_SetPrinterDataEx *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_SetPrinterDataEx replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_SetPrinterDataEx, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_SetPrinterDataEx\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 78: { /* spoolss_GetPrinterDataEx */
		struct spoolss_GetPrinterDataEx *r2 = (struct spoolss_GetPrinterDataEx *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_GetPrinterDataEx replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_GetPrinterDataEx, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_GetPrinterDataEx\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 79: { /* spoolss_EnumPrinterDataEx */
		struct spoolss_EnumPrinterDataEx *r2 = (struct spoolss_EnumPrinterDataEx *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_EnumPrinterDataEx replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_EnumPrinterDataEx, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_EnumPrinterDataEx\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 80: { /* spoolss_EnumPrinterKey */
		struct spoolss_EnumPrinterKey *r2 = (struct spoolss_EnumPrinterKey *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_EnumPrinterKey replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_EnumPrinterKey, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_EnumPrinterKey\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 81: { /* spoolss_DeletePrinterDataEx */
		struct spoolss_DeletePrinterDataEx *r2 = (struct spoolss_DeletePrinterDataEx *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_DeletePrinterDataEx replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_DeletePrinterDataEx, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_DeletePrinterDataEx\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 82: { /* spoolss_DeletePrinterKey */
		struct spoolss_DeletePrinterKey *r2 = (struct spoolss_DeletePrinterKey *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_DeletePrinterKey replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_DeletePrinterKey, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_DeletePrinterKey\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 83: { /* spoolss_53 */
		struct spoolss_53 *r2 = (struct spoolss_53 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_53 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_53, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_53\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 84: { /* spoolss_DeletePrinterDriverEx */
		struct spoolss_DeletePrinterDriverEx *r2 = (struct spoolss_DeletePrinterDriverEx *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_DeletePrinterDriverEx replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_DeletePrinterDriverEx, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_DeletePrinterDriverEx\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 85: { /* spoolss_AddPerMachineConnection */
		struct spoolss_AddPerMachineConnection *r2 = (struct spoolss_AddPerMachineConnection *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_AddPerMachineConnection replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_AddPerMachineConnection, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_AddPerMachineConnection\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 86: { /* spoolss_DeletePerMachineConnection */
		struct spoolss_DeletePerMachineConnection *r2 = (struct spoolss_DeletePerMachineConnection *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_DeletePerMachineConnection replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_DeletePerMachineConnection, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_DeletePerMachineConnection\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 87: { /* spoolss_EnumPerMachineConnections */
		struct spoolss_EnumPerMachineConnections *r2 = (struct spoolss_EnumPerMachineConnections *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_EnumPerMachineConnections replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_EnumPerMachineConnections, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_EnumPerMachineConnections\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 88: { /* spoolss_XcvData */
		struct spoolss_XcvData *r2 = (struct spoolss_XcvData *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_XcvData replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_XcvData, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_XcvData\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 89: { /* spoolss_AddPrinterDriverEx */
		struct spoolss_AddPrinterDriverEx *r2 = (struct spoolss_AddPrinterDriverEx *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_AddPrinterDriverEx replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_AddPrinterDriverEx, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_AddPrinterDriverEx\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 90: { /* spoolss_5a */
		struct spoolss_5a *r2 = (struct spoolss_5a *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_5a replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_5a, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_5a\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 91: { /* spoolss_5b */
		struct spoolss_5b *r2 = (struct spoolss_5b *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_5b replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_5b, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_5b\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 92: { /* spoolss_5c */
		struct spoolss_5c *r2 = (struct spoolss_5c *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_5c replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_5c, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_5c\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 93: { /* spoolss_5d */
		struct spoolss_5d *r2 = (struct spoolss_5d *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_5d replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_5d, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_5d\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 94: { /* spoolss_5e */
		struct spoolss_5e *r2 = (struct spoolss_5e *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_5e replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_5e, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_5e\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 95: { /* spoolss_5f */
		struct spoolss_5f *r2 = (struct spoolss_5f *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_5f replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_5f, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_5f\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 96: { /* spoolss_60 */
		struct spoolss_60 *r2 = (struct spoolss_60 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_60 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_60, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_60\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 97: { /* spoolss_SendRecvBidiData */
		struct spoolss_SendRecvBidiData *r2 = (struct spoolss_SendRecvBidiData *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_SendRecvBidiData replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_SendRecvBidiData, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_SendRecvBidiData\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 98: { /* spoolss_62 */
		struct spoolss_62 *r2 = (struct spoolss_62 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_62 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_62, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_62\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 99: { /* spoolss_63 */
		struct spoolss_63 *r2 = (struct spoolss_63 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_63 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_63, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_63\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 100: { /* spoolss_64 */
		struct spoolss_64 *r2 = (struct spoolss_64 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_64 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_64, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_64\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 101: { /* spoolss_65 */
		struct spoolss_65 *r2 = (struct spoolss_65 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_65 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_65, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_65\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 102: { /* spoolss_GetCorePrinterDrivers */
		struct spoolss_GetCorePrinterDrivers *r2 = (struct spoolss_GetCorePrinterDrivers *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_GetCorePrinterDrivers replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_GetCorePrinterDrivers, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_GetCorePrinterDrivers\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 103: { /* spoolss_67 */
		struct spoolss_67 *r2 = (struct spoolss_67 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_67 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_67, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_67\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 104: { /* spoolss_GetPrinterDriverPackagePath */
		struct spoolss_GetPrinterDriverPackagePath *r2 = (struct spoolss_GetPrinterDriverPackagePath *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_GetPrinterDriverPackagePath replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_GetPrinterDriverPackagePath, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_GetPrinterDriverPackagePath\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 105: { /* spoolss_69 */
		struct spoolss_69 *r2 = (struct spoolss_69 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_69 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_69, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_69\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 106: { /* spoolss_6a */
		struct spoolss_6a *r2 = (struct spoolss_6a *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_6a replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_6a, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_6a\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 107: { /* spoolss_6b */
		struct spoolss_6b *r2 = (struct spoolss_6b *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_6b replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_6b, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_6b\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 108: { /* spoolss_6c */
		struct spoolss_6c *r2 = (struct spoolss_6c *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_6c replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_6c, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_6c\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 109: { /* spoolss_6d */
		struct spoolss_6d *r2 = (struct spoolss_6d *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_6d replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_6d, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_6d\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 110: { /* spoolss_GetJobNamedPropertyValue */
		struct spoolss_GetJobNamedPropertyValue *r2 = (struct spoolss_GetJobNamedPropertyValue *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_GetJobNamedPropertyValue replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_GetJobNamedPropertyValue, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_GetJobNamedPropertyValue\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 111: { /* spoolss_SetJobNamedProperty */
		struct spoolss_SetJobNamedProperty *r2 = (struct spoolss_SetJobNamedProperty *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_SetJobNamedProperty replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_SetJobNamedProperty, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_SetJobNamedProperty\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 112: { /* spoolss_DeleteJobNamedProperty */
		struct spoolss_DeleteJobNamedProperty *r2 = (struct spoolss_DeleteJobNamedProperty *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_DeleteJobNamedProperty replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_DeleteJobNamedProperty, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_DeleteJobNamedProperty\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 113: { /* spoolss_EnumJobNamedProperties */
		struct spoolss_EnumJobNamedProperties *r2 = (struct spoolss_EnumJobNamedProperties *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_EnumJobNamedProperties replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_EnumJobNamedProperties, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_EnumJobNamedProperties\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 114: { /* spoolss_72 */
		struct spoolss_72 *r2 = (struct spoolss_72 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_72 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_72, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_72\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 115: { /* spoolss_73 */
		struct spoolss_73 *r2 = (struct spoolss_73 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_73 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_73, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_73\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 116: { /* spoolss_LogJobInfoForBranchOffice */
		struct spoolss_LogJobInfoForBranchOffice *r2 = (struct spoolss_LogJobInfoForBranchOffice *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function spoolss_LogJobInfoForBranchOffice replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(spoolss_LogJobInfoForBranchOffice, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in spoolss_LogJobInfoForBranchOffice\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

NTSTATUS spoolss__op_ndr_push(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_push *push, const void *r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	ndr_err = ndr_table_spoolss.calls[opnum].ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

NTSTATUS spoolss__op_local(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	return spoolss__op_dispatch_internal(dce_call, mem_ctx, r, S3COMPAT_RPC_DISPATCH_INTERNAL);
}

static const struct dcesrv_interface dcesrv_spoolss_interface = {
	.name      = "spoolss",
	.syntax_id = {{0x12345678,0x1234,0xabcd,{0xef,0x00},{0x01,0x23,0x45,0x67,0x89,0xab}},1.0},
	.bind      = spoolss__op_bind,
	.unbind    = spoolss__op_unbind,
	.ndr_pull  = spoolss__op_ndr_pull,
	.dispatch  = spoolss__op_dispatch,
	.reply     = spoolss__op_reply,
	.ndr_push  = spoolss__op_ndr_push,
	.local     = spoolss__op_local,
#ifdef DCESRV_INTERFACE_SPOOLSS_FLAGS
	.flags     = DCESRV_INTERFACE_SPOOLSS_FLAGS
#else
	.flags     = 0
#endif
};

static NTSTATUS spoolss__op_init_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	uint32_t i;
	NTSTATUS ret;

#ifdef DCESRV_INTERFACE_SPOOLSS_NCACN_NP_SECONDARY_ENDPOINT
	const char *ncacn_np_secondary_endpoint = DCESRV_INTERFACE_SPOOLSS_NCACN_NP_SECONDARY_ENDPOINT;
#else
	const char *ncacn_np_secondary_endpoint = NULL;
#endif

	for (i=0;i<ndr_table_spoolss.endpoints->count;i++) {
		const char *name = ndr_table_spoolss.endpoints->names[i];

		ret = dcesrv_interface_register(dce_ctx, name, ncacn_np_secondary_endpoint, &dcesrv_spoolss_interface, NULL);
		if (!NT_STATUS_IS_OK(ret)) {
			DBG_ERR("Failed to register endpoint '%s'\n",name);
			return ret;
		}
	}

	return NT_STATUS_OK;
}

static NTSTATUS spoolss__op_shutdown_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	return NT_STATUS_OK;
}

static bool spoolss__op_interface_by_uuid(struct dcesrv_interface *iface, const struct GUID *uuid, uint32_t if_version)
{
	if (dcesrv_spoolss_interface.syntax_id.if_version == if_version && GUID_equal(&dcesrv_spoolss_interface.syntax_id.uuid, uuid)) {
		memcpy(iface,&dcesrv_spoolss_interface, sizeof(*iface));
		return true;
	}

	return false;
}

static bool spoolss__op_interface_by_name(struct dcesrv_interface *iface, const char *name)
{
	if (strcmp(dcesrv_spoolss_interface.name, name)==0) {
		memcpy(iface, &dcesrv_spoolss_interface, sizeof(*iface));
		return true;
	}

	return false;
}

static const struct dcesrv_endpoint_server spoolss_ep_server = {
	/* fill in our name */
	.name = "spoolss",

	/* Initialization flag */
	.initialized = false,

	/* fill in all the operations */
#ifdef DCESRV_INTERFACE_SPOOLSS_INIT_SERVER
	.init_server = DCESRV_INTERFACE_SPOOLSS_INIT_SERVER,
#else
	.init_server = spoolss__op_init_server,
#endif
#ifdef DCESRV_INTERFACE_SPOOLSS_SHUTDOWN_SERVER
	.shutdown_server = DCESRV_INTERFACE_SPOOLSS_SHUTDOWN_SERVER,
#else
	.shutdown_server = spoolss__op_shutdown_server,
#endif
	.interface_by_uuid = spoolss__op_interface_by_uuid,
	.interface_by_name = spoolss__op_interface_by_name
};

const struct dcesrv_endpoint_server *spoolss_get_ep_server(void)
{
	return &spoolss_ep_server;
}
