/*
 * Copyright (C) 2005-2009 Alex Murray <murray.alex@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include "config.h"

#include "config.h"

#include <glib/gi18n-lib.h>
#include <libgnome-panel/gp-module.h>

#include "sensors-applet.h"

static GpAppletInfo *
get_applet_info (const gchar *id)
{
  return gp_applet_info_new (sensors_applet_get_type,
                             _("Hardware Sensors Monitor"),
                             _("Displays temperature, fan speed and voltage sensor readings"),
                             "sensors-applet");
}

static const gchar *
get_applet_id_from_iid (const gchar *iid)
{
  if (g_strcmp0 (iid, "SensorsAppletFactory::SensorsApplet") == 0)
    return "sensorsapplet";

  return NULL;
}

void
gp_module_load (GpModule *module)
{
  bindtextdomain (GETTEXT_PACKAGE, GNOMELOCALEDIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  gp_module_set_gettext_domain (module, GETTEXT_PACKAGE);

  gp_module_set_abi_version (module, GP_MODULE_ABI_VERSION);

  gp_module_set_id (module, "net.sourceforge.sensors-applet");
  gp_module_set_version (module, PACKAGE_VERSION);

  gp_module_set_applet_ids (module, "sensorsapplet", NULL);

  gp_module_set_get_applet_info (module, get_applet_info);
  gp_module_set_compatibility (module, get_applet_id_from_iid);
}
