/* ExportDialog.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from ExportDialog.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 * Copyright 2017 Jens Georg <mail@jensge.org>
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>

#define EXPORT_DIALOG_DEFAULT_SCALE 1200
#define EXPORT_DIALOG_NUM_SPECIAL_FORMATS 2
#define EXPORT_DIALOG_UNMODIFIED_FORMAT_LABEL _ ("Unmodified")
#define EXPORT_DIALOG_CURRENT_FORMAT_LABEL _ ("Current")
#define RESOURCES_CANCEL_LABEL _ ("_Cancel")
#define RESOURCES_OK_LABEL _ ("_OK")
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_EXPORT_DIALOG (export_dialog_get_type ())
#define EXPORT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPORT_DIALOG, ExportDialog))
#define EXPORT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPORT_DIALOG, ExportDialogClass))
#define IS_EXPORT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPORT_DIALOG))
#define IS_EXPORT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPORT_DIALOG))
#define EXPORT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPORT_DIALOG, ExportDialogClass))

typedef struct _ExportDialog ExportDialog;
typedef struct _ExportDialogClass ExportDialogClass;
typedef struct _ExportDialogPrivate ExportDialogPrivate;
enum  {
	EXPORT_DIALOG_0_PROPERTY,
	EXPORT_DIALOG_NUM_PROPERTIES
};
static GParamSpec* export_dialog_properties[EXPORT_DIALOG_NUM_PROPERTIES];
typedef enum  {
	SCALE_CONSTRAINT_ORIGINAL,
	SCALE_CONSTRAINT_DIMENSIONS,
	SCALE_CONSTRAINT_WIDTH,
	SCALE_CONSTRAINT_HEIGHT,
	SCALE_CONSTRAINT_FILL_VIEWPORT
} ScaleConstraint;

#define TYPE_SCALE_CONSTRAINT (scale_constraint_get_type ())
typedef enum  {
	JPEG_QUALITY_LOW = 50,
	JPEG_QUALITY_MEDIUM = 75,
	JPEG_QUALITY_HIGH = 90,
	JPEG_QUALITY_MAXIMUM = 100
} JpegQuality;

#define JPEG_TYPE_QUALITY (jpeg_quality_get_type ())

#define TYPE_EXPORT_FORMAT_PARAMETERS (export_format_parameters_get_type ())
typedef struct _ExportFormatParameters ExportFormatParameters;
typedef enum  {
	EXPORT_FORMAT_MODE_UNMODIFIED,
	EXPORT_FORMAT_MODE_CURRENT,
	EXPORT_FORMAT_MODE_SPECIFIED,
	EXPORT_FORMAT_MODE_LAST
} ExportFormatMode;

#define TYPE_EXPORT_FORMAT_MODE (export_format_mode_get_type ())
typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_GIF,
	PHOTO_FILE_FORMAT_WEBP,
	PHOTO_FILE_FORMAT_AVIF,
	PHOTO_FILE_FORMAT_HEIF,
	PHOTO_FILE_FORMAT_JPEGXL,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_CONFIGURATION_FACADE (configuration_facade_get_type ())
#define CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacade))
#define CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))
#define IS_CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIGURATION_FACADE))
#define IS_CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONFIGURATION_FACADE))
#define CONFIGURATION_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))

typedef struct _ConfigurationFacade ConfigurationFacade;
typedef struct _ConfigurationFacadeClass ConfigurationFacadeClass;

#define CONFIG_TYPE_FACADE (config_facade_get_type ())
#define CONFIG_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONFIG_TYPE_FACADE, ConfigFacade))
#define CONFIG_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONFIG_TYPE_FACADE, ConfigFacadeClass))
#define CONFIG_IS_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONFIG_TYPE_FACADE))
#define CONFIG_IS_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONFIG_TYPE_FACADE))
#define CONFIG_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONFIG_TYPE_FACADE, ConfigFacadeClass))

typedef struct _ConfigFacade ConfigFacade;
typedef struct _ConfigFacadeClass ConfigFacadeClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_PHOTO_FILE_FORMAT_PROPERTIES (photo_file_format_properties_get_type ())
#define PHOTO_FILE_FORMAT_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_FORMAT_PROPERTIES, PhotoFileFormatProperties))
#define PHOTO_FILE_FORMAT_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_FORMAT_PROPERTIES, PhotoFileFormatPropertiesClass))
#define IS_PHOTO_FILE_FORMAT_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_FORMAT_PROPERTIES))
#define IS_PHOTO_FILE_FORMAT_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_FORMAT_PROPERTIES))
#define PHOTO_FILE_FORMAT_PROPERTIES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_FORMAT_PROPERTIES, PhotoFileFormatPropertiesClass))

typedef struct _PhotoFileFormatProperties PhotoFileFormatProperties;
typedef struct _PhotoFileFormatPropertiesClass PhotoFileFormatPropertiesClass;
#define _photo_file_format_properties_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_format_properties_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ExportDialog {
	GtkDialog parent_instance;
	ExportDialogPrivate * priv;
};

struct _ExportDialogClass {
	GtkDialogClass parent_class;
};

struct _ExportDialogPrivate {
	GtkGrid* table;
	GtkComboBoxText* quality_combo;
	GtkComboBoxText* constraint_combo;
	GtkComboBoxText* format_combo;
	GtkSwitch* export_metadata;
	GeeArrayList* format_options;
	GtkEntry* pixels_entry;
	GtkWidget* ok_button;
	gboolean in_insert;
};

struct _ExportFormatParameters {
	ExportFormatMode mode;
	PhotoFileFormat specified_format;
	JpegQuality quality;
	gboolean export_metadata;
};

static gint ExportDialog_private_offset;
static gpointer export_dialog_parent_class = NULL;
static ScaleConstraint export_dialog_current_constraint;
static ScaleConstraint export_dialog_current_constraint = SCALE_CONSTRAINT_ORIGINAL;
static ExportFormatParameters export_dialog_current_parameters;
static ExportFormatParameters export_dialog_current_parameters = {0};
static gint export_dialog_current_scale;
static gint export_dialog_current_scale = EXPORT_DIALOG_DEFAULT_SCALE;

VALA_EXTERN GType export_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ExportDialog, g_object_unref)
VALA_EXTERN GType scale_constraint_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType jpeg_quality_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType export_format_parameters_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType export_format_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType photo_file_format_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ExportFormatParameters* export_format_parameters_dup (const ExportFormatParameters* self);
VALA_EXTERN void export_format_parameters_free (ExportFormatParameters* self);
VALA_EXTERN void export_format_parameters_current (ExportFormatParameters* result);
VALA_EXTERN ExportDialog* export_dialog_new (const gchar* title);
VALA_EXTERN ExportDialog* export_dialog_construct (GType object_type,
                                       const gchar* title);
VALA_EXTERN gint resources_use_header_bar (void);
VALA_EXTERN GType configuration_facade_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConfigurationFacade, g_object_unref)
VALA_EXTERN GType config_facade_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConfigFacade, g_object_unref)
VALA_EXTERN ConfigFacade* config_facade_get_instance (void);
VALA_EXTERN ExportFormatMode configuration_facade_get_export_export_format_mode (ConfigurationFacade* self);
VALA_EXTERN PhotoFileFormat configuration_facade_get_export_photo_file_format (ConfigurationFacade* self);
VALA_EXTERN JpegQuality configuration_facade_get_export_quality (ConfigurationFacade* self);
VALA_EXTERN gboolean configuration_facade_get_export_export_metadata (ConfigurationFacade* self);
VALA_EXTERN ScaleConstraint configuration_facade_get_export_constraint (ConfigurationFacade* self);
VALA_EXTERN gint configuration_facade_get_export_scale (ConfigurationFacade* self);
VALA_EXTERN gchar* jpeg_quality_to_string (JpegQuality self);
VALA_EXTERN gchar* scale_constraint_to_string (ScaleConstraint self);
static void export_dialog_format_add_option (ExportDialog* self,
                                      const gchar* format_name);
VALA_EXTERN PhotoFileFormat* photo_file_format_get_image_writeable (gint* result_length1);
VALA_EXTERN gpointer photo_file_format_properties_ref (gpointer instance);
VALA_EXTERN void photo_file_format_properties_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_photo_file_format_properties (const gchar* name,
                                                     const gchar* nick,
                                                     const gchar* blurb,
                                                     GType object_type,
                                                     GParamFlags flags);
VALA_EXTERN void value_set_photo_file_format_properties (GValue* value,
                                             gpointer v_object);
VALA_EXTERN void value_take_photo_file_format_properties (GValue* value,
                                              gpointer v_object);
VALA_EXTERN gpointer value_get_photo_file_format_properties (const GValue* value);
VALA_EXTERN GType photo_file_format_properties_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoFileFormatProperties, photo_file_format_properties_unref)
VALA_EXTERN PhotoFileFormatProperties* photo_file_format_get_properties (PhotoFileFormat self);
VALA_EXTERN gchar* photo_file_format_properties_get_user_visible_name (PhotoFileFormatProperties* self);
static void export_dialog_on_constraint_changed (ExportDialog* self);
static void _export_dialog_on_constraint_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                 gpointer self);
static void export_dialog_on_format_changed (ExportDialog* self);
static void _export_dialog_on_format_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                             gpointer self);
static void export_dialog_on_pixels_changed (ExportDialog* self);
static void _export_dialog_on_pixels_changed_gtk_editable_changed (GtkEditable* _sender,
                                                            gpointer self);
static void export_dialog_on_pixels_insert_text (ExportDialog* self,
                                          const gchar* text,
                                          gint length,
                                          gint* position);
static void _export_dialog_on_pixels_insert_text_gtk_editable_insert_text (GtkEditable* _sender,
                                                                    const gchar* new_text,
                                                                    gint new_text_length,
                                                                    gint* position,
                                                                    gpointer self);
static void export_dialog_on_activate (ExportDialog* self);
static void _export_dialog_on_activate_gtk_entry_activate (GtkEntry* _sender,
                                                    gpointer self);
static void export_dialog_add_label (ExportDialog* self,
                              const gchar* text,
                              gint x,
                              gint y,
                              GtkWidget* widget);
static void export_dialog_add_control (ExportDialog* self,
                                GtkWidget* widget,
                                gint x,
                                gint y);
static void export_dialog_format_set_active_text (ExportDialog* self,
                                           const gchar* text);
static PhotoFileFormat export_dialog_get_specified_format (ExportDialog* self);
static gchar* export_dialog_get_label_for_parameters (ExportDialog* self,
                                               ExportFormatParameters* params);
VALA_EXTERN gboolean export_dialog_execute (ExportDialog* self,
                                gint* scale,
                                ScaleConstraint* constraint,
                                ExportFormatParameters* parameters);
VALA_EXTERN gboolean photo_file_format_can_write (PhotoFileFormat self);
VALA_EXTERN PhotoFileFormat photo_file_format_get_system_default_format (void);
VALA_EXTERN void configuration_facade_set_export_export_format_mode (ConfigurationFacade* self,
                                                         ExportFormatMode export_format_mode);
VALA_EXTERN void configuration_facade_set_export_photo_file_format (ConfigurationFacade* self,
                                                        PhotoFileFormat photo_file_format);
VALA_EXTERN void configuration_facade_set_export_quality (ConfigurationFacade* self,
                                              JpegQuality quality);
VALA_EXTERN void configuration_facade_set_export_export_metadata (ConfigurationFacade* self,
                                                      gboolean export_metadata);
VALA_EXTERN void configuration_facade_set_export_constraint (ConfigurationFacade* self,
                                                 ScaleConstraint constraint);
VALA_EXTERN void configuration_facade_set_export_scale (ConfigurationFacade* self,
                                            gint scale);
VALA_EXTERN gboolean photo_file_format_can_write_metadata (PhotoFileFormat self);
static void export_dialog_finalize (GObject * obj);
static GType export_dialog_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

const ScaleConstraint EXPORT_DIALOG_CONSTRAINT_ARRAY[4] = {SCALE_CONSTRAINT_ORIGINAL, SCALE_CONSTRAINT_DIMENSIONS, SCALE_CONSTRAINT_WIDTH, SCALE_CONSTRAINT_HEIGHT};
const JpegQuality EXPORT_DIALOG_QUALITY_ARRAY[4] = {JPEG_QUALITY_LOW, JPEG_QUALITY_MEDIUM, JPEG_QUALITY_HIGH, JPEG_QUALITY_MAXIMUM};

static inline gpointer
export_dialog_get_instance_private (ExportDialog* self)
{
	return G_STRUCT_MEMBER_P (self, ExportDialog_private_offset);
}

static void
_export_dialog_on_constraint_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                            gpointer self)
{
	export_dialog_on_constraint_changed ((ExportDialog*) self);
}

static void
_export_dialog_on_format_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                        gpointer self)
{
	export_dialog_on_format_changed ((ExportDialog*) self);
}

static void
_export_dialog_on_pixels_changed_gtk_editable_changed (GtkEditable* _sender,
                                                       gpointer self)
{
	export_dialog_on_pixels_changed ((ExportDialog*) self);
}

static void
_export_dialog_on_pixels_insert_text_gtk_editable_insert_text (GtkEditable* _sender,
                                                               const gchar* new_text,
                                                               gint new_text_length,
                                                               gint* position,
                                                               gpointer self)
{
	export_dialog_on_pixels_insert_text ((ExportDialog*) self, new_text, new_text_length, position);
}

static void
_export_dialog_on_activate_gtk_entry_activate (GtkEntry* _sender,
                                               gpointer self)
{
	export_dialog_on_activate ((ExportDialog*) self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

ExportDialog*
export_dialog_construct (GType object_type,
                         const gchar* title)
{
	ExportDialog * self = NULL;
	ConfigFacade* config = NULL;
	ConfigFacade* _tmp0_;
	ConfigFacade* _tmp1_;
	ConfigFacade* _tmp2_;
	ConfigFacade* _tmp3_;
	ConfigFacade* _tmp4_;
	ConfigFacade* _tmp5_;
	ConfigFacade* _tmp6_;
	GtkComboBoxText* _tmp7_;
	gint ctr = 0;
	GtkComboBoxText* _tmp14_;
	GtkComboBoxText* _tmp20_;
	gint _tmp21_ = 0;
	PhotoFileFormat* _tmp22_;
	GtkEntry* _tmp27_;
	GtkEntry* _tmp28_;
	GtkEntry* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	GtkComboBoxText* _tmp32_;
	GtkComboBoxText* _tmp33_;
	GtkEntry* _tmp34_;
	GtkEntry* _tmp35_;
	GtkEntry* _tmp36_;
	GtkComboBoxText* _tmp37_;
	GtkComboBoxText* _tmp38_;
	GtkComboBoxText* _tmp39_;
	GtkComboBoxText* _tmp40_;
	GtkComboBoxText* _tmp41_;
	GtkComboBoxText* _tmp42_;
	GtkEntry* _tmp43_;
	GtkEntry* _tmp44_;
	GtkSwitch* _tmp45_;
	GtkSwitch* _tmp46_;
	GtkSwitch* _tmp47_;
	GtkSwitch* _tmp48_;
	GtkSwitch* _tmp49_;
	GtkGrid* _tmp50_;
	GtkGrid* _tmp51_;
	GtkGrid* _tmp52_;
	GtkBox* _tmp53_;
	GtkGrid* _tmp54_;
	GtkWidget* _tmp55_;
	GtkWidget* _tmp56_;
	GtkWidget* _tmp57_;
	GtkWidget* _tmp58_;
	GtkWidget* _tmp59_;
	GtkWidget* _tmp62_;
	g_return_val_if_fail (title != NULL, NULL);
	self = (ExportDialog*) g_object_new (object_type, "use-header-bar", resources_use_header_bar (), NULL);
	gtk_window_set_title (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), title);
	gtk_window_set_resizable (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), FALSE);
	_tmp0_ = config_facade_get_instance ();
	config = _tmp0_;
	_tmp1_ = config;
	export_dialog_current_parameters.mode = configuration_facade_get_export_export_format_mode (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
	_tmp2_ = config;
	export_dialog_current_parameters.specified_format = configuration_facade_get_export_photo_file_format (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
	_tmp3_ = config;
	export_dialog_current_parameters.quality = configuration_facade_get_export_quality (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
	_tmp4_ = config;
	export_dialog_current_parameters.export_metadata = configuration_facade_get_export_export_metadata (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
	_tmp5_ = config;
	export_dialog_current_constraint = configuration_facade_get_export_constraint (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
	_tmp6_ = config;
	export_dialog_current_scale = configuration_facade_get_export_scale (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
	_tmp7_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->quality_combo);
	self->priv->quality_combo = _tmp7_;
	ctr = 0;
	{
		JpegQuality* quality_collection = NULL;
		gint quality_collection_length1 = 0;
		gint _quality_collection_size_ = 0;
		gint quality_it = 0;
		quality_collection = EXPORT_DIALOG_QUALITY_ARRAY;
		quality_collection_length1 = G_N_ELEMENTS (EXPORT_DIALOG_QUALITY_ARRAY);
		for (quality_it = 0; quality_it < quality_collection_length1; quality_it = quality_it + 1) {
			JpegQuality quality = 0;
			quality = quality_collection[quality_it];
			{
				GtkComboBoxText* _tmp8_;
				gchar* _tmp9_;
				gchar* _tmp10_;
				ExportFormatParameters _tmp11_;
				gint _tmp13_;
				_tmp8_ = self->priv->quality_combo;
				_tmp9_ = jpeg_quality_to_string (quality);
				_tmp10_ = _tmp9_;
				gtk_combo_box_text_append_text (_tmp8_, _tmp10_);
				_g_free0 (_tmp10_);
				_tmp11_ = export_dialog_current_parameters;
				if (quality == _tmp11_.quality) {
					GtkComboBoxText* _tmp12_;
					_tmp12_ = self->priv->quality_combo;
					gtk_combo_box_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_combo_box_get_type (), GtkComboBox), ctr);
				}
				_tmp13_ = ctr;
				ctr = _tmp13_ + 1;
			}
		}
	}
	_tmp14_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
	g_object_ref_sink (_tmp14_);
	_g_object_unref0 (self->priv->constraint_combo);
	self->priv->constraint_combo = _tmp14_;
	ctr = 0;
	{
		ScaleConstraint* constraint_collection = NULL;
		gint constraint_collection_length1 = 0;
		gint _constraint_collection_size_ = 0;
		gint constraint_it = 0;
		constraint_collection = EXPORT_DIALOG_CONSTRAINT_ARRAY;
		constraint_collection_length1 = G_N_ELEMENTS (EXPORT_DIALOG_CONSTRAINT_ARRAY);
		for (constraint_it = 0; constraint_it < constraint_collection_length1; constraint_it = constraint_it + 1) {
			ScaleConstraint constraint = 0;
			constraint = constraint_collection[constraint_it];
			{
				GtkComboBoxText* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gint _tmp19_;
				_tmp15_ = self->priv->constraint_combo;
				_tmp16_ = scale_constraint_to_string (constraint);
				_tmp17_ = _tmp16_;
				gtk_combo_box_text_append_text (_tmp15_, _tmp17_);
				_g_free0 (_tmp17_);
				if (constraint == export_dialog_current_constraint) {
					GtkComboBoxText* _tmp18_;
					_tmp18_ = self->priv->constraint_combo;
					gtk_combo_box_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_combo_box_get_type (), GtkComboBox), ctr);
				}
				_tmp19_ = ctr;
				ctr = _tmp19_ + 1;
			}
		}
	}
	_tmp20_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
	g_object_ref_sink (_tmp20_);
	_g_object_unref0 (self->priv->format_combo);
	self->priv->format_combo = _tmp20_;
	export_dialog_format_add_option (self, EXPORT_DIALOG_UNMODIFIED_FORMAT_LABEL);
	export_dialog_format_add_option (self, EXPORT_DIALOG_CURRENT_FORMAT_LABEL);
	_tmp22_ = photo_file_format_get_image_writeable (&_tmp21_);
	{
		PhotoFileFormat* format_collection = NULL;
		gint format_collection_length1 = 0;
		gint _format_collection_size_ = 0;
		gint format_it = 0;
		format_collection = _tmp22_;
		format_collection_length1 = _tmp21_;
		for (format_it = 0; format_it < format_collection_length1; format_it = format_it + 1) {
			PhotoFileFormat format = 0;
			format = format_collection[format_it];
			{
				PhotoFileFormatProperties* _tmp23_;
				PhotoFileFormatProperties* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				_tmp23_ = photo_file_format_get_properties (format);
				_tmp24_ = _tmp23_;
				_tmp25_ = photo_file_format_properties_get_user_visible_name (_tmp24_);
				_tmp26_ = _tmp25_;
				export_dialog_format_add_option (self, _tmp26_);
				_g_free0 (_tmp26_);
				_photo_file_format_properties_unref0 (_tmp24_);
			}
		}
		format_collection = (g_free (format_collection), NULL);
	}
	_tmp27_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp27_);
	_g_object_unref0 (self->priv->pixels_entry);
	self->priv->pixels_entry = _tmp27_;
	_tmp28_ = self->priv->pixels_entry;
	gtk_entry_set_max_length (_tmp28_, 6);
	_tmp29_ = self->priv->pixels_entry;
	_tmp30_ = g_strdup_printf ("%d", export_dialog_current_scale);
	_tmp31_ = _tmp30_;
	gtk_entry_set_text (_tmp29_, _tmp31_);
	_g_free0 (_tmp31_);
	_tmp32_ = self->priv->constraint_combo;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, gtk_combo_box_get_type (), GtkComboBox), "changed", (GCallback) _export_dialog_on_constraint_changed_gtk_combo_box_changed, self, 0);
	_tmp33_ = self->priv->format_combo;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, gtk_combo_box_get_type (), GtkComboBox), "changed", (GCallback) _export_dialog_on_format_changed_gtk_combo_box_changed, self, 0);
	_tmp34_ = self->priv->pixels_entry;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, gtk_editable_get_type (), GtkEditable), "changed", (GCallback) _export_dialog_on_pixels_changed_gtk_editable_changed, self, 0);
	_tmp35_ = self->priv->pixels_entry;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, gtk_editable_get_type (), GtkEditable), "insert-text", (GCallback) _export_dialog_on_pixels_insert_text_gtk_editable_insert_text, self, 0);
	_tmp36_ = self->priv->pixels_entry;
	g_signal_connect_object (_tmp36_, "activate", (GCallback) _export_dialog_on_activate_gtk_entry_activate, self, 0);
	_tmp37_ = self->priv->format_combo;
	export_dialog_add_label (self, _ ("_Format:"), 0, 0, G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, gtk_widget_get_type (), GtkWidget));
	_tmp38_ = self->priv->format_combo;
	export_dialog_add_control (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, gtk_widget_get_type (), GtkWidget), 1, 0);
	_tmp39_ = self->priv->quality_combo;
	export_dialog_add_label (self, _ ("_Quality:"), 0, 1, G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, gtk_widget_get_type (), GtkWidget));
	_tmp40_ = self->priv->quality_combo;
	export_dialog_add_control (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, gtk_widget_get_type (), GtkWidget), 1, 1);
	_tmp41_ = self->priv->constraint_combo;
	export_dialog_add_label (self, _ ("_Scaling constraint:"), 0, 2, G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, gtk_widget_get_type (), GtkWidget));
	_tmp42_ = self->priv->constraint_combo;
	export_dialog_add_control (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, gtk_widget_get_type (), GtkWidget), 1, 2);
	_tmp43_ = self->priv->pixels_entry;
	export_dialog_add_label (self, _ ("_Pixels:"), 0, 3, G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, gtk_widget_get_type (), GtkWidget));
	_tmp44_ = self->priv->pixels_entry;
	export_dialog_add_control (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, gtk_widget_get_type (), GtkWidget), 1, 3);
	_tmp45_ = (GtkSwitch*) gtk_switch_new ();
	g_object_ref_sink (_tmp45_);
	_g_object_unref0 (self->priv->export_metadata);
	self->priv->export_metadata = _tmp45_;
	_tmp46_ = self->priv->export_metadata;
	export_dialog_add_label (self, _ ("Export _metadata:"), 0, 4, G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, gtk_widget_get_type (), GtkWidget));
	_tmp47_ = self->priv->export_metadata;
	export_dialog_add_control (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, gtk_widget_get_type (), GtkWidget), 1, 4);
	_tmp48_ = self->priv->export_metadata;
	gtk_switch_set_active (_tmp48_, TRUE);
	_tmp49_ = self->priv->export_metadata;
	gtk_widget_set_halign (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_START);
	_tmp50_ = self->priv->table;
	gtk_grid_set_row_spacing (_tmp50_, (guint) 6);
	_tmp51_ = self->priv->table;
	gtk_grid_set_column_spacing (_tmp51_, (guint) 12);
	_tmp52_ = self->priv->table;
	gtk_container_set_border_width (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, gtk_container_get_type (), GtkContainer), (guint) 18);
	_tmp53_ = gtk_dialog_get_content_area (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_dialog_get_type (), GtkDialog));
	_tmp54_ = self->priv->table;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, gtk_box_get_type (), GtkBox), gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp54_, gtk_widget_get_type (), GtkWidget));
	gtk_dialog_add_button (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_dialog_get_type (), GtkDialog), RESOURCES_CANCEL_LABEL, (gint) GTK_RESPONSE_CANCEL);
	_tmp55_ = gtk_dialog_add_button (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_dialog_get_type (), GtkDialog), RESOURCES_OK_LABEL, (gint) GTK_RESPONSE_OK);
	_tmp56_ = _g_object_ref0 (_tmp55_);
	_g_object_unref0 (self->priv->ok_button);
	self->priv->ok_button = _tmp56_;
	gtk_dialog_set_default_response (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_dialog_get_type (), GtkDialog), (gint) GTK_RESPONSE_OK);
	_tmp57_ = self->priv->ok_button;
	gtk_widget_set_can_default (_tmp57_, TRUE);
	_tmp58_ = self->priv->ok_button;
	g_object_set (_tmp58_, "has-default", TRUE, NULL);
	_tmp59_ = self->priv->ok_button;
	gtk_window_set_default (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), _tmp59_);
	if (export_dialog_current_constraint == SCALE_CONSTRAINT_ORIGINAL) {
		GtkEntry* _tmp60_;
		GtkComboBoxText* _tmp61_;
		_tmp60_ = self->priv->pixels_entry;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp60_, gtk_widget_get_type (), GtkWidget), FALSE);
		_tmp61_ = self->priv->quality_combo;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, gtk_widget_get_type (), GtkWidget), FALSE);
	}
	_tmp62_ = self->priv->ok_button;
	gtk_widget_grab_focus (_tmp62_);
	_g_object_unref0 (config);
	return self;
}

ExportDialog*
export_dialog_new (const gchar* title)
{
	return export_dialog_construct (TYPE_EXPORT_DIALOG, title);
}

static void
export_dialog_format_add_option (ExportDialog* self,
                                 const gchar* format_name)
{
	GeeArrayList* _tmp0_;
	GtkComboBoxText* _tmp1_;
	g_return_if_fail (IS_EXPORT_DIALOG (self));
	g_return_if_fail (format_name != NULL);
	_tmp0_ = self->priv->format_options;
	gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), format_name);
	_tmp1_ = self->priv->format_combo;
	gtk_combo_box_text_append_text (_tmp1_, format_name);
}

static void
export_dialog_format_set_active_text (ExportDialog* self,
                                      const gchar* text)
{
	gint selection_ticker = 0;
	g_return_if_fail (IS_EXPORT_DIALOG (self));
	g_return_if_fail (text != NULL);
	selection_ticker = 0;
	{
		GeeArrayList* _current_text_list = NULL;
		GeeArrayList* _tmp0_;
		gint _current_text_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _current_text_index = 0;
		_tmp0_ = self->priv->format_options;
		_current_text_list = _tmp0_;
		_tmp1_ = _current_text_list;
		_tmp2_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
		_tmp3_ = _tmp2_;
		_current_text_size = _tmp3_;
		_current_text_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			gchar* current_text = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			const gchar* _tmp8_;
			gint _tmp10_;
			_current_text_index = _current_text_index + 1;
			_tmp4_ = _current_text_index;
			_tmp5_ = _current_text_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _current_text_list;
			_tmp7_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _current_text_index);
			current_text = (gchar*) _tmp7_;
			_tmp8_ = current_text;
			if (g_strcmp0 (_tmp8_, text) == 0) {
				GtkComboBoxText* _tmp9_;
				_tmp9_ = self->priv->format_combo;
				gtk_combo_box_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_combo_box_get_type (), GtkComboBox), selection_ticker);
				_g_free0 (current_text);
				return;
			}
			_tmp10_ = selection_ticker;
			selection_ticker = _tmp10_ + 1;
			_g_free0 (current_text);
		}
	}
	g_critical ("ExportDialog.vala:147: format_set_active_text: text '%s' isn't in comb" \
"o box", text);
}

static PhotoFileFormat
export_dialog_get_specified_format (ExportDialog* self)
{
	gint index = 0;
	GtkComboBoxText* _tmp0_;
	PhotoFileFormat* writeable_formats = NULL;
	gint _tmp1_ = 0;
	PhotoFileFormat* _tmp2_;
	gint writeable_formats_length1;
	gint _writeable_formats_size_;
	PhotoFileFormat _tmp3_;
	PhotoFileFormat result;
	g_return_val_if_fail (IS_EXPORT_DIALOG (self), 0);
	_tmp0_ = self->priv->format_combo;
	index = gtk_combo_box_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_combo_box_get_type (), GtkComboBox));
	if (index < EXPORT_DIALOG_NUM_SPECIAL_FORMATS) {
		index = EXPORT_DIALOG_NUM_SPECIAL_FORMATS;
	}
	index -= EXPORT_DIALOG_NUM_SPECIAL_FORMATS;
	_tmp2_ = photo_file_format_get_image_writeable (&_tmp1_);
	writeable_formats = _tmp2_;
	writeable_formats_length1 = _tmp1_;
	_writeable_formats_size_ = writeable_formats_length1;
	_tmp3_ = writeable_formats[index];
	result = _tmp3_;
	writeable_formats = (g_free (writeable_formats), NULL);
	return result;
}

static gchar*
export_dialog_get_label_for_parameters (ExportDialog* self,
                                        ExportFormatParameters* params)
{
	ExportFormatParameters _tmp0_;
	gchar* result;
	g_return_val_if_fail (IS_EXPORT_DIALOG (self), NULL);
	g_return_val_if_fail (params != NULL, NULL);
	_tmp0_ = *params;
	switch (_tmp0_.mode) {
		case EXPORT_FORMAT_MODE_UNMODIFIED:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup (EXPORT_DIALOG_UNMODIFIED_FORMAT_LABEL);
			result = _tmp1_;
			return result;
		}
		case EXPORT_FORMAT_MODE_CURRENT:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup (EXPORT_DIALOG_CURRENT_FORMAT_LABEL);
			result = _tmp2_;
			return result;
		}
		case EXPORT_FORMAT_MODE_SPECIFIED:
		{
			ExportFormatParameters _tmp3_;
			PhotoFileFormatProperties* _tmp4_;
			PhotoFileFormatProperties* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp3_ = *params;
			_tmp4_ = photo_file_format_get_properties (_tmp3_.specified_format);
			_tmp5_ = _tmp4_;
			_tmp6_ = photo_file_format_properties_get_user_visible_name (_tmp5_);
			_tmp7_ = _tmp6_;
			_photo_file_format_properties_unref0 (_tmp5_);
			result = _tmp7_;
			return result;
		}
		default:
		{
			g_error ("ExportDialog.vala:172: get_label_for_parameters: unrecognized export f" \
"ormat mode");
		}
	}
}

gboolean
export_dialog_execute (ExportDialog* self,
                       gint* scale,
                       ScaleConstraint* constraint,
                       ExportFormatParameters* parameters)
{
	gint _vala_scale = 0;
	ScaleConstraint _vala_constraint = 0;
	ExportFormatParameters _tmp0_;
	ExportFormatParameters _tmp2_;
	ExportFormatParameters _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gboolean ok = FALSE;
	gboolean result;
	g_return_val_if_fail (IS_EXPORT_DIALOG (self), FALSE);
	g_return_val_if_fail (parameters != NULL, FALSE);
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp0_ = *parameters;
	if (_tmp0_.mode != EXPORT_FORMAT_MODE_LAST) {
		GtkComboBoxText* _tmp1_;
		_vala_constraint = SCALE_CONSTRAINT_ORIGINAL;
		export_dialog_current_constraint = _vala_constraint;
		_tmp1_ = self->priv->constraint_combo;
		gtk_combo_box_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_combo_box_get_type (), GtkComboBox), 0);
	}
	_tmp2_ = *parameters;
	if (_tmp2_.mode == EXPORT_FORMAT_MODE_LAST) {
		ExportFormatParameters _tmp3_;
		_tmp3_ = export_dialog_current_parameters;
		*parameters = _tmp3_;
	} else {
		gboolean _tmp4_ = FALSE;
		ExportFormatParameters _tmp5_;
		_tmp5_ = *parameters;
		if (_tmp5_.mode == EXPORT_FORMAT_MODE_SPECIFIED) {
			ExportFormatParameters _tmp6_;
			_tmp6_ = *parameters;
			_tmp4_ = !photo_file_format_can_write (_tmp6_.specified_format);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			(*parameters).specified_format = photo_file_format_get_system_default_format ();
		}
	}
	_tmp7_ = *parameters;
	_tmp8_ = export_dialog_get_label_for_parameters (self, &_tmp7_);
	_tmp9_ = _tmp8_;
	export_dialog_format_set_active_text (self, _tmp9_);
	_g_free0 (_tmp9_);
	export_dialog_on_format_changed (self);
	ok = gtk_dialog_run (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_dialog_get_type (), GtkDialog)) == ((gint) GTK_RESPONSE_OK);
	if (ok) {
		gint index = 0;
		GtkComboBoxText* _tmp10_;
		ScaleConstraint _tmp11_;
		GtkEntry* _tmp12_;
		const gchar* _tmp13_;
		gboolean _tmp14_ = FALSE;
		GtkSwitch* _tmp15_;
		gboolean _tmp16_;
		gboolean _tmp17_;
		GtkComboBoxText* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gboolean _tmp24_;
		ConfigFacade* config = NULL;
		ConfigFacade* _tmp32_;
		ConfigFacade* _tmp33_;
		ExportFormatParameters _tmp34_;
		ConfigFacade* _tmp35_;
		ExportFormatParameters _tmp36_;
		ConfigFacade* _tmp37_;
		ExportFormatParameters _tmp38_;
		ConfigFacade* _tmp39_;
		ExportFormatParameters _tmp40_;
		ConfigFacade* _tmp41_;
		ConfigFacade* _tmp42_;
		_tmp10_ = self->priv->constraint_combo;
		index = gtk_combo_box_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_combo_box_get_type (), GtkComboBox));
		_vala_assert (index >= 0, "index >= 0");
		_tmp11_ = EXPORT_DIALOG_CONSTRAINT_ARRAY[index];
		_vala_constraint = _tmp11_;
		export_dialog_current_constraint = _vala_constraint;
		_tmp12_ = self->priv->pixels_entry;
		_tmp13_ = gtk_entry_get_text (_tmp12_);
		_vala_scale = atoi (_tmp13_);
		if (_vala_constraint != SCALE_CONSTRAINT_ORIGINAL) {
			_vala_assert (_vala_scale > 0, "scale > 0");
		}
		export_dialog_current_scale = _vala_scale;
		_tmp15_ = self->priv->export_metadata;
		_tmp16_ = gtk_widget_get_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_widget_get_type (), GtkWidget));
		_tmp17_ = _tmp16_;
		if (_tmp17_) {
			GtkSwitch* _tmp18_;
			gboolean _tmp19_;
			gboolean _tmp20_;
			_tmp18_ = self->priv->export_metadata;
			_tmp19_ = gtk_switch_get_active (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp14_ = _tmp20_;
		} else {
			_tmp14_ = FALSE;
		}
		(*parameters).export_metadata = _tmp14_;
		_tmp21_ = self->priv->format_combo;
		_tmp22_ = gtk_combo_box_text_get_active_text (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = g_strcmp0 (_tmp23_, EXPORT_DIALOG_UNMODIFIED_FORMAT_LABEL) == 0;
		_g_free0 (_tmp23_);
		if (_tmp24_) {
			export_dialog_current_parameters.mode = EXPORT_FORMAT_MODE_UNMODIFIED;
			(*parameters).mode = export_dialog_current_parameters.mode;
		} else {
			GtkComboBoxText* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			gboolean _tmp28_;
			_tmp25_ = self->priv->format_combo;
			_tmp26_ = gtk_combo_box_text_get_active_text (_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = g_strcmp0 (_tmp27_, EXPORT_DIALOG_CURRENT_FORMAT_LABEL) == 0;
			_g_free0 (_tmp27_);
			if (_tmp28_) {
				export_dialog_current_parameters.mode = EXPORT_FORMAT_MODE_CURRENT;
				(*parameters).mode = export_dialog_current_parameters.mode;
			} else {
				ExportFormatParameters _tmp29_;
				export_dialog_current_parameters.mode = EXPORT_FORMAT_MODE_SPECIFIED;
				(*parameters).mode = export_dialog_current_parameters.mode;
				export_dialog_current_parameters.specified_format = export_dialog_get_specified_format (self);
				(*parameters).specified_format = export_dialog_current_parameters.specified_format;
				_tmp29_ = export_dialog_current_parameters;
				if (_tmp29_.specified_format == PHOTO_FILE_FORMAT_JFIF) {
					GtkComboBoxText* _tmp30_;
					JpegQuality _tmp31_;
					_tmp30_ = self->priv->quality_combo;
					_tmp31_ = EXPORT_DIALOG_QUALITY_ARRAY[gtk_combo_box_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, gtk_combo_box_get_type (), GtkComboBox))];
					export_dialog_current_parameters.quality = _tmp31_;
					(*parameters).quality = export_dialog_current_parameters.quality;
				}
			}
		}
		_tmp32_ = config_facade_get_instance ();
		config = _tmp32_;
		_tmp33_ = config;
		_tmp34_ = export_dialog_current_parameters;
		configuration_facade_set_export_export_format_mode (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp34_.mode);
		_tmp35_ = config;
		_tmp36_ = export_dialog_current_parameters;
		configuration_facade_set_export_photo_file_format (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp36_.specified_format);
		_tmp37_ = config;
		_tmp38_ = export_dialog_current_parameters;
		configuration_facade_set_export_quality (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp38_.quality);
		_tmp39_ = config;
		_tmp40_ = export_dialog_current_parameters;
		configuration_facade_set_export_export_metadata (G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp40_.export_metadata);
		_tmp41_ = config;
		configuration_facade_set_export_constraint (G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), export_dialog_current_constraint);
		_tmp42_ = config;
		configuration_facade_set_export_scale (G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), export_dialog_current_scale);
		_g_object_unref0 (config);
	} else {
		_vala_scale = 0;
		_vala_constraint = SCALE_CONSTRAINT_ORIGINAL;
	}
	gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	result = ok;
	if (scale) {
		*scale = _vala_scale;
	}
	if (constraint) {
		*constraint = _vala_constraint;
	}
	return result;
}

static void
export_dialog_add_label (ExportDialog* self,
                         const gchar* text,
                         gint x,
                         gint y,
                         GtkWidget* widget)
{
	GtkLabel* new_label = NULL;
	GtkLabel* _tmp0_;
	GtkLabel* _tmp1_;
	GtkLabel* _tmp2_;
	GtkLabel* _tmp3_;
	GtkGrid* _tmp5_;
	GtkLabel* _tmp6_;
	g_return_if_fail (IS_EXPORT_DIALOG (self));
	g_return_if_fail (text != NULL);
	g_return_if_fail ((widget == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (widget, gtk_widget_get_type ()));
	_tmp0_ = (GtkLabel*) gtk_label_new_with_mnemonic (text);
	g_object_ref_sink (_tmp0_);
	new_label = _tmp0_;
	_tmp1_ = new_label;
	gtk_widget_set_halign (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_END);
	_tmp2_ = new_label;
	gtk_widget_set_valign (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_CENTER);
	_tmp3_ = new_label;
	gtk_label_set_use_underline (_tmp3_, TRUE);
	if (widget != NULL) {
		GtkLabel* _tmp4_;
		_tmp4_ = new_label;
		gtk_label_set_mnemonic_widget (_tmp4_, widget);
	}
	_tmp5_ = self->priv->table;
	_tmp6_ = new_label;
	gtk_grid_attach (_tmp5_, G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget), x, y, 1, 1);
	_g_object_unref0 (new_label);
}

static void
export_dialog_add_control (ExportDialog* self,
                           GtkWidget* widget,
                           gint x,
                           gint y)
{
	GtkGrid* _tmp0_;
	g_return_if_fail (IS_EXPORT_DIALOG (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (widget, gtk_widget_get_type ()));
	gtk_widget_set_halign (widget, GTK_ALIGN_FILL);
	gtk_widget_set_valign (widget, GTK_ALIGN_CENTER);
	gtk_widget_set_hexpand (widget, TRUE);
	gtk_widget_set_vexpand (widget, TRUE);
	_tmp0_ = self->priv->table;
	gtk_grid_attach (_tmp0_, widget, x, y, 1, 1);
}

static void
export_dialog_on_constraint_changed (ExportDialog* self)
{
	gboolean original = FALSE;
	GtkComboBoxText* _tmp0_;
	ScaleConstraint _tmp1_;
	gboolean jpeg = FALSE;
	GtkComboBoxText* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	PhotoFileFormatProperties* _tmp5_;
	PhotoFileFormatProperties* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gboolean _tmp9_;
	GtkEntry* _tmp10_;
	gboolean _tmp11_ = FALSE;
	GtkComboBoxText* _tmp12_;
	g_return_if_fail (IS_EXPORT_DIALOG (self));
	_tmp0_ = self->priv->constraint_combo;
	_tmp1_ = EXPORT_DIALOG_CONSTRAINT_ARRAY[gtk_combo_box_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_combo_box_get_type (), GtkComboBox))];
	original = _tmp1_ == SCALE_CONSTRAINT_ORIGINAL;
	_tmp2_ = self->priv->format_combo;
	_tmp3_ = gtk_combo_box_text_get_active_text (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = photo_file_format_get_properties (PHOTO_FILE_FORMAT_JFIF);
	_tmp6_ = _tmp5_;
	_tmp7_ = photo_file_format_properties_get_user_visible_name (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strcmp0 (_tmp4_, _tmp8_) == 0;
	_g_free0 (_tmp8_);
	_photo_file_format_properties_unref0 (_tmp6_);
	_g_free0 (_tmp4_);
	jpeg = _tmp9_;
	_tmp10_ = self->priv->pixels_entry;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget), !original);
	if (!original) {
		_tmp11_ = jpeg;
	} else {
		_tmp11_ = FALSE;
	}
	_tmp12_ = self->priv->quality_combo;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_widget_get_type (), GtkWidget), _tmp11_);
	if (original) {
		GtkWidget* _tmp13_;
		_tmp13_ = self->priv->ok_button;
		gtk_widget_set_sensitive (_tmp13_, TRUE);
	} else {
		export_dialog_on_pixels_changed (self);
	}
}

static void
export_dialog_on_format_changed (ExportDialog* self)
{
	gboolean original = FALSE;
	GtkComboBoxText* _tmp0_;
	ScaleConstraint _tmp1_;
	GtkComboBoxText* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	g_return_if_fail (IS_EXPORT_DIALOG (self));
	_tmp0_ = self->priv->constraint_combo;
	_tmp1_ = EXPORT_DIALOG_CONSTRAINT_ARRAY[gtk_combo_box_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_combo_box_get_type (), GtkComboBox))];
	original = _tmp1_ == SCALE_CONSTRAINT_ORIGINAL;
	_tmp2_ = self->priv->format_combo;
	_tmp3_ = gtk_combo_box_text_get_active_text (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strcmp0 (_tmp4_, EXPORT_DIALOG_UNMODIFIED_FORMAT_LABEL) == 0;
	_g_free0 (_tmp4_);
	if (_tmp5_) {
		GtkComboBoxText* _tmp6_;
		GtkComboBoxText* _tmp7_;
		GtkComboBoxText* _tmp8_;
		GtkEntry* _tmp9_;
		GtkSwitch* _tmp10_;
		GtkSwitch* _tmp11_;
		_tmp6_ = self->priv->constraint_combo;
		gtk_combo_box_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_combo_box_get_type (), GtkComboBox), 0);
		_tmp7_ = self->priv->constraint_combo;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget), FALSE);
		_tmp8_ = self->priv->quality_combo;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget), FALSE);
		_tmp9_ = self->priv->pixels_entry;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget), FALSE);
		_tmp10_ = self->priv->export_metadata;
		gtk_switch_set_active (_tmp10_, FALSE);
		_tmp11_ = self->priv->export_metadata;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_widget_get_type (), GtkWidget), FALSE);
	} else {
		GtkComboBoxText* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gboolean _tmp15_;
		_tmp12_ = self->priv->format_combo;
		_tmp13_ = gtk_combo_box_text_get_active_text (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strcmp0 (_tmp14_, EXPORT_DIALOG_CURRENT_FORMAT_LABEL) == 0;
		_g_free0 (_tmp14_);
		if (_tmp15_) {
			GtkComboBoxText* _tmp16_;
			GtkComboBoxText* _tmp17_;
			GtkEntry* _tmp18_;
			GtkSwitch* _tmp19_;
			_tmp16_ = self->priv->constraint_combo;
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_widget_get_type (), GtkWidget), TRUE);
			_tmp17_ = self->priv->quality_combo;
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_widget_get_type (), GtkWidget), FALSE);
			_tmp18_ = self->priv->pixels_entry;
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_widget_get_type (), GtkWidget), !original);
			_tmp19_ = self->priv->export_metadata;
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_widget_get_type (), GtkWidget), TRUE);
		} else {
			GtkComboBoxText* _tmp20_;
			gboolean jpeg = FALSE;
			gboolean _tmp21_ = FALSE;
			GtkComboBoxText* _tmp22_;
			GtkSwitch* _tmp23_;
			GtkSwitch* _tmp24_;
			_tmp20_ = self->priv->constraint_combo;
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_widget_get_type (), GtkWidget), TRUE);
			jpeg = export_dialog_get_specified_format (self) == PHOTO_FILE_FORMAT_JFIF;
			if (!original) {
				_tmp21_ = jpeg;
			} else {
				_tmp21_ = FALSE;
			}
			_tmp22_ = self->priv->quality_combo;
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, gtk_widget_get_type (), GtkWidget), _tmp21_);
			_tmp23_ = self->priv->export_metadata;
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, gtk_widget_get_type (), GtkWidget), photo_file_format_can_write_metadata (export_dialog_get_specified_format (self)));
			_tmp24_ = self->priv->export_metadata;
			gtk_switch_set_active (_tmp24_, photo_file_format_can_write_metadata (export_dialog_get_specified_format (self)));
		}
	}
}

static void
export_dialog_on_activate (ExportDialog* self)
{
	g_return_if_fail (IS_EXPORT_DIALOG (self));
	gtk_dialog_response (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_dialog_get_type (), GtkDialog), (gint) GTK_RESPONSE_OK);
}

static void
export_dialog_on_pixels_changed (ExportDialog* self)
{
	gboolean _tmp0_ = FALSE;
	GtkEntry* _tmp1_;
	GtkWidget* _tmp4_;
	g_return_if_fail (IS_EXPORT_DIALOG (self));
	_tmp1_ = self->priv->pixels_entry;
	if (((gint) gtk_entry_get_text_length (_tmp1_)) > 0) {
		GtkEntry* _tmp2_;
		const gchar* _tmp3_;
		_tmp2_ = self->priv->pixels_entry;
		_tmp3_ = gtk_entry_get_text (_tmp2_);
		_tmp0_ = atoi (_tmp3_) > 0;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp4_ = self->priv->ok_button;
	gtk_widget_set_sensitive (_tmp4_, _tmp0_);
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static void
export_dialog_on_pixels_insert_text (ExportDialog* self,
                                     const gchar* text,
                                     gint length,
                                     gint* position)
{
	gchar* new_text = NULL;
	gchar* _tmp2_;
	const gchar* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	GtkEntry* _tmp17_;
	g_return_if_fail (IS_EXPORT_DIALOG (self));
	g_return_if_fail (text != NULL);
	if (self->priv->in_insert) {
		return;
	}
	self->priv->in_insert = TRUE;
	if (length == -1) {
		gint _tmp0_;
		gint _tmp1_;
		_tmp0_ = strlen (text);
		_tmp1_ = _tmp0_;
		length = (gint) _tmp1_;
	}
	_tmp2_ = g_strdup ("");
	new_text = _tmp2_;
	{
		gint ctr = 0;
		ctr = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = ctr;
					ctr = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				if (!(ctr < length)) {
					break;
				}
				if (g_ascii_isdigit (string_get (text, (glong) ctr))) {
					const gchar* _tmp5_;
					gchar* _tmp6_;
					gchar* _tmp7_;
					gchar* _tmp8_;
					_tmp5_ = new_text;
					_tmp6_ = g_strdup_printf ("%c", (gchar) string_get (text, (glong) ctr));
					_tmp7_ = _tmp6_;
					_tmp8_ = g_strconcat (_tmp5_, _tmp7_, NULL);
					_g_free0 (new_text);
					new_text = _tmp8_;
					_g_free0 (_tmp7_);
				}
			}
		}
	}
	_tmp9_ = new_text;
	_tmp10_ = strlen (_tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp11_ > 0) {
		GtkEntry* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		_tmp12_ = self->priv->pixels_entry;
		_tmp13_ = new_text;
		_tmp14_ = new_text;
		_tmp15_ = strlen (_tmp14_);
		_tmp16_ = _tmp15_;
		g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_editable_get_type (), GtkEditable), "insert-text", _tmp13_, (gint) _tmp16_, position);
	}
	_tmp17_ = self->priv->pixels_entry;
	g_signal_stop_emission_by_name (_tmp17_, "insert-text");
	self->priv->in_insert = FALSE;
	_g_free0 (new_text);
}

static void
export_dialog_class_init (ExportDialogClass * klass,
                          gpointer klass_data)
{
	ExportFormatParameters _tmp0_ = {0};
	export_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ExportDialog_private_offset);
	G_OBJECT_CLASS (klass)->finalize = export_dialog_finalize;
	export_format_parameters_current (&_tmp0_);
	export_dialog_current_parameters = _tmp0_;
}

static void
export_dialog_instance_init (ExportDialog * self,
                             gpointer klass)
{
	GtkGrid* _tmp0_;
	GeeArrayList* _tmp1_;
	self->priv = export_dialog_get_instance_private (self);
	_tmp0_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp0_);
	self->priv->table = _tmp0_;
	_tmp1_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	self->priv->format_options = _tmp1_;
	self->priv->in_insert = FALSE;
}

static void
export_dialog_finalize (GObject * obj)
{
	ExportDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_EXPORT_DIALOG, ExportDialog);
	_g_object_unref0 (self->priv->table);
	_g_object_unref0 (self->priv->quality_combo);
	_g_object_unref0 (self->priv->constraint_combo);
	_g_object_unref0 (self->priv->format_combo);
	_g_object_unref0 (self->priv->export_metadata);
	_g_object_unref0 (self->priv->format_options);
	_g_object_unref0 (self->priv->pixels_entry);
	_g_object_unref0 (self->priv->ok_button);
	G_OBJECT_CLASS (export_dialog_parent_class)->finalize (obj);
}

static GType
export_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ExportDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) export_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ExportDialog), 0, (GInstanceInitFunc) export_dialog_instance_init, NULL };
	GType export_dialog_type_id;
	export_dialog_type_id = g_type_register_static (gtk_dialog_get_type (), "ExportDialog", &g_define_type_info, 0);
	ExportDialog_private_offset = g_type_add_instance_private (export_dialog_type_id, sizeof (ExportDialogPrivate));
	return export_dialog_type_id;
}

GType
export_dialog_get_type (void)
{
	static volatile gsize export_dialog_type_id__once = 0;
	if (g_once_init_enter (&export_dialog_type_id__once)) {
		GType export_dialog_type_id;
		export_dialog_type_id = export_dialog_get_type_once ();
		g_once_init_leave (&export_dialog_type_id__once, export_dialog_type_id);
	}
	return export_dialog_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

