/* file.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from file.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */
/* Returns true if the file is claimed, false if it exists, and throws an Error otherwise.  The file*/
/* will be created when the function exits and should be overwritten.  Note that the file is not*/
/* held open; claiming a file is merely based on its existence.*/
/**/
/* This function is thread-safe.*/

#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef gboolean (*ProgressMonitor) (guint64 current, guint64 total, gboolean do_event_loop, gpointer user_data);
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

VALA_EXTERN gboolean claim_file (GFile* file,
                     GError** error);
VALA_EXTERN GFile* generate_unique_file (GFile* dir,
                             const gchar* basename,
                             gboolean* collision,
                             GeeCollection* used,
                             GError** error);
VALA_EXTERN void disassemble_filename (const gchar* basename,
                           gchar** name,
                           gchar** ext);
VALA_EXTERN glong find_last_offset (const gchar* str,
                        gchar c);
VALA_EXTERN guint64 query_total_file_size (GFile* file_or_dir,
                               GCancellable* cancellable,
                               GError** error);
VALA_EXTERN void delete_all_files (GFile* dir,
                       GeeSet* exceptions,
                       ProgressMonitor monitor,
                       gpointer monitor_target,
                       guint64 file_count,
                       GCancellable* cancellable,
                       GError** error);
VALA_EXTERN GDateTime* query_file_modified (GFile* file,
                                GError** error);
VALA_EXTERN GDateTime* coarsify_date_time (GDateTime* dt);
VALA_EXTERN gboolean query_is_directory (GFile* file);
VALA_EXTERN gboolean query_is_directory_empty (GFile* dir,
                                   GError** error);
VALA_EXTERN gchar* get_display_pathname (GFile* file);
VALA_EXTERN gchar* strip_pretty_path (const gchar* path);
VALA_EXTERN gchar* get_file_info_id (GFileInfo* info);
VALA_EXTERN guint64 count_files_in_directory (GFile* dir,
                                  GError** error);
VALA_EXTERN gboolean file_equal (GFile* a,
                     GFile* b);
VALA_EXTERN guint file_hash (GFile* file);

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

gboolean
claim_file (GFile* file,
            GError** error)
{
	gboolean _tmp9_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), FALSE);
	{
		GFileOutputStream* _tmp0_;
		GFileOutputStream* _tmp1_;
		_tmp0_ = g_file_create (file, G_FILE_CREATE_NONE, NULL, &_inner_error0_);
		_tmp1_ = _tmp0_;
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		result = TRUE;
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		if (!g_error_matches (_tmp2_, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
			gchar* _tmp3_;
			gchar* _tmp4_;
			GError* _tmp5_;
			const gchar* _tmp6_;
			GError* _tmp7_;
			GError* _tmp8_;
			_tmp3_ = g_file_get_path (file);
			_tmp4_ = _tmp3_;
			_tmp5_ = err;
			_tmp6_ = _tmp5_->message;
			g_warning ("file.vala:21: claim_file %s: %s", _tmp4_, _tmp6_);
			_g_free0 (_tmp4_);
			_tmp7_ = err;
			_tmp8_ = _g_error_copy0 (_tmp7_);
			_inner_error0_ = _tmp8_;
			_g_error_free0 (err);
			goto __finally0;
		}
		result = FALSE;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_propagate_error (error, _inner_error0_);
	return _tmp9_;
}

GFile*
generate_unique_file (GFile* dir,
                      const gchar* basename,
                      gboolean* collision,
                      GeeCollection* used,
                      GError** error)
{
	gboolean _vala_collision = FALSE;
	GFile* file = NULL;
	GFile* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GFile* _tmp2_;
	gchar* name = NULL;
	gchar* ext = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp21_;
	gchar* _tmp22_;
	GError* _inner_error0_ = NULL;
	GFile* result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (dir, g_file_get_type ()), NULL);
	g_return_val_if_fail (basename != NULL, NULL);
	g_return_val_if_fail ((used == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (used, GEE_TYPE_COLLECTION), NULL);
	_tmp0_ = g_file_get_child (dir, basename);
	file = _tmp0_;
	_tmp2_ = file;
	_tmp1_ = claim_file (_tmp2_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (file);
		return NULL;
	}
	if (_tmp1_) {
		_vala_collision = FALSE;
		result = file;
		if (collision) {
			*collision = _vala_collision;
		}
		return result;
	}
	_vala_collision = TRUE;
	disassemble_filename (basename, &_tmp3_, &_tmp4_);
	_g_free0 (name);
	name = _tmp3_;
	_g_free0 (ext);
	ext = _tmp4_;
	{
		gint ctr = 0;
		ctr = 1;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				gchar* _tmp7_ = NULL;
				const gchar* _tmp8_;
				gchar* new_name = NULL;
				gchar* _tmp14_;
				gboolean _tmp15_ = FALSE;
				const gchar* _tmp17_;
				GFile* _tmp18_;
				gboolean _tmp19_ = FALSE;
				GFile* _tmp20_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = ctr;
					ctr = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				if (!(ctr < G_MAXINT)) {
					break;
				}
				_tmp8_ = ext;
				if (_tmp8_ != NULL) {
					const gchar* _tmp9_;
					const gchar* _tmp10_;
					gchar* _tmp11_;
					_tmp9_ = name;
					_tmp10_ = ext;
					_tmp11_ = g_strdup_printf ("%s_%d.%s", _tmp9_, ctr, _tmp10_);
					_g_free0 (_tmp7_);
					_tmp7_ = _tmp11_;
				} else {
					const gchar* _tmp12_;
					gchar* _tmp13_;
					_tmp12_ = name;
					_tmp13_ = g_strdup_printf ("%s_%d", _tmp12_, ctr);
					_g_free0 (_tmp7_);
					_tmp7_ = _tmp13_;
				}
				_tmp14_ = g_strdup (_tmp7_);
				new_name = _tmp14_;
				if (used != NULL) {
					const gchar* _tmp16_;
					_tmp16_ = new_name;
					_tmp15_ = gee_collection_contains (used, _tmp16_);
				} else {
					_tmp15_ = FALSE;
				}
				if (_tmp15_) {
					_g_free0 (new_name);
					_g_free0 (_tmp7_);
					continue;
				}
				_tmp17_ = new_name;
				_tmp18_ = g_file_get_child (dir, _tmp17_);
				_g_object_unref0 (file);
				file = _tmp18_;
				_tmp20_ = file;
				_tmp19_ = claim_file (_tmp20_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_free0 (new_name);
					_g_free0 (_tmp7_);
					_g_free0 (ext);
					_g_free0 (name);
					_g_object_unref0 (file);
					return NULL;
				}
				if (_tmp19_) {
					result = file;
					_g_free0 (new_name);
					_g_free0 (_tmp7_);
					_g_free0 (ext);
					_g_free0 (name);
					if (collision) {
						*collision = _vala_collision;
					}
					return result;
				}
				_g_free0 (new_name);
				_g_free0 (_tmp7_);
			}
		}
	}
	_tmp21_ = g_file_get_path (dir);
	_tmp22_ = _tmp21_;
	g_warning ("file.vala:64: generate_unique_filename %s for %s: unable to claim file", _tmp22_, basename);
	_g_free0 (_tmp22_);
	result = NULL;
	_g_free0 (ext);
	_g_free0 (name);
	_g_object_unref0 (file);
	if (collision) {
		*collision = _vala_collision;
	}
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

void
disassemble_filename (const gchar* basename,
                      gchar** name,
                      gchar** ext)
{
	gchar* _vala_name = NULL;
	gchar* _vala_ext = NULL;
	glong offset = 0L;
	g_return_if_fail (basename != NULL);
	offset = find_last_offset (basename, '.');
	if (offset <= ((glong) 0)) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (basename);
		_g_free0 (_vala_name);
		_vala_name = _tmp0_;
		_g_free0 (_vala_ext);
		_vala_ext = NULL;
	} else {
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = string_substring (basename, (glong) 0, offset);
		_g_free0 (_vala_name);
		_vala_name = _tmp1_;
		_tmp2_ = string_substring (basename, offset + 1, (glong) -1);
		_g_free0 (_vala_ext);
		_vala_ext = _tmp2_;
	}
	if (name) {
		*name = _vala_name;
	} else {
		_g_free0 (_vala_name);
	}
	if (ext) {
		*ext = _vala_ext;
	} else {
		_g_free0 (_vala_ext);
	}
}

guint64
query_total_file_size (GFile* file_or_dir,
                       GCancellable* cancellable,
                       GError** error)
{
	GFileType type = 0;
	GFileEnumerator* enumerator = NULL;
	guint64 total_bytes = 0ULL;
	GFileInfo* info = NULL;
	GError* _inner_error0_ = NULL;
	guint64 result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file_or_dir, g_file_get_type ()), 0ULL);
	g_return_val_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()), 0ULL);
	type = g_file_query_file_type (file_or_dir, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL);
	if (type == G_FILE_TYPE_REGULAR) {
		GFileInfo* info = NULL;
		GFileInfo* _tmp11_;
		info = NULL;
		{
			GFileInfo* _tmp0_ = NULL;
			GFileInfo* _tmp1_;
			GFileInfo* _tmp2_;
			_tmp1_ = g_file_query_info (file_or_dir, G_FILE_ATTRIBUTE_STANDARD_SIZE, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, cancellable, &_inner_error0_);
			_tmp0_ = _tmp1_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp2_ = _tmp0_;
			_tmp0_ = NULL;
			_g_object_unref0 (info);
			info = _tmp2_;
			_g_object_unref0 (_tmp0_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* err = NULL;
			GError* _tmp3_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			GError* _tmp8_;
			const gchar* _tmp9_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp3_ = err;
			if (g_error_matches (_tmp3_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
				GError* _tmp4_;
				GError* _tmp5_;
				_tmp4_ = err;
				_tmp5_ = _g_error_copy0 (_tmp4_);
				_inner_error0_ = _tmp5_;
				_g_error_free0 (err);
				goto __finally0;
			}
			_tmp6_ = g_file_get_path (file_or_dir);
			_tmp7_ = _tmp6_;
			_tmp8_ = err;
			_tmp9_ = _tmp8_->message;
			g_debug ("file.vala:92: Unable to query filesize for %s: %s", _tmp7_, _tmp9_);
			_g_free0 (_tmp7_);
			result = (guint64) 0;
			_g_error_free0 (err);
			_g_object_unref0 (info);
			return result;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			guint64 _tmp10_ = 0ULL;
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (info);
			return _tmp10_;
		}
		_tmp11_ = info;
		result = (guint64) g_file_info_get_size (_tmp11_);
		_g_object_unref0 (info);
		return result;
	} else {
		if (type != G_FILE_TYPE_DIRECTORY) {
			result = (guint64) 0;
			return result;
		}
	}
	{
		GFileEnumerator* _tmp12_ = NULL;
		GFileEnumerator* _tmp13_;
		GFileEnumerator* _tmp14_;
		GFileEnumerator* _tmp15_;
		_tmp13_ = g_file_enumerate_children (file_or_dir, G_FILE_ATTRIBUTE_STANDARD_NAME, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, cancellable, &_inner_error0_);
		_tmp12_ = _tmp13_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp14_ = _tmp12_;
		_tmp12_ = NULL;
		_g_object_unref0 (enumerator);
		enumerator = _tmp14_;
		_tmp15_ = enumerator;
		if (_tmp15_ == NULL) {
			result = (guint64) 0;
			_g_object_unref0 (_tmp12_);
			_g_object_unref0 (enumerator);
			return result;
		}
		_g_object_unref0 (_tmp12_);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* err = NULL;
		gboolean _tmp16_ = FALSE;
		GError* _tmp17_;
		GError* _tmp19_;
		GError* _tmp20_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp17_ = err;
		if (g_error_matches (_tmp17_, G_FILE_ERROR, G_FILE_ERROR_PERM)) {
			_tmp16_ = TRUE;
		} else {
			GError* _tmp18_;
			_tmp18_ = err;
			_tmp16_ = g_error_matches (_tmp18_, G_IO_ERROR, G_IO_ERROR_PERMISSION_DENIED);
		}
		if (_tmp16_) {
			result = (guint64) 0;
			_g_error_free0 (err);
			_g_object_unref0 (enumerator);
			return result;
		}
		_tmp19_ = err;
		_tmp20_ = _g_error_copy0 (_tmp19_);
		_inner_error0_ = _tmp20_;
		_g_error_free0 (err);
		goto __finally1;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		guint64 _tmp21_ = 0ULL;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (enumerator);
		return _tmp21_;
	}
	total_bytes = (guint64) 0;
	info = NULL;
	while (TRUE) {
		GFileInfo* _tmp22_ = NULL;
		GFileEnumerator* _tmp23_;
		GFileInfo* _tmp24_;
		GFileInfo* _tmp26_;
		GFileInfo* _tmp27_;
		guint64 _tmp28_ = 0ULL;
		GFileInfo* _tmp29_;
		const gchar* _tmp30_;
		GFile* _tmp31_;
		GFile* _tmp32_;
		guint64 _tmp33_;
		_tmp23_ = enumerator;
		_tmp24_ = g_file_enumerator_next_file (_tmp23_, cancellable, &_inner_error0_);
		_tmp22_ = _tmp24_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			guint64 _tmp25_ = 0ULL;
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (info);
			_g_object_unref0 (enumerator);
			return _tmp25_;
		}
		_tmp26_ = _tmp22_;
		_tmp22_ = NULL;
		_g_object_unref0 (info);
		info = _tmp26_;
		_tmp27_ = info;
		if (!(_tmp27_ != NULL)) {
			_g_object_unref0 (_tmp22_);
			break;
		}
		_tmp29_ = info;
		_tmp30_ = g_file_info_get_name (_tmp29_);
		_tmp31_ = g_file_get_child (file_or_dir, _tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = query_total_file_size (_tmp32_, cancellable, &_inner_error0_);
		_g_object_unref0 (_tmp32_);
		_tmp28_ = _tmp33_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			guint64 _tmp34_ = 0ULL;
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp22_);
			_g_object_unref0 (info);
			_g_object_unref0 (enumerator);
			return _tmp34_;
		}
		total_bytes += _tmp28_;
		_g_object_unref0 (_tmp22_);
	}
	result = total_bytes;
	_g_object_unref0 (info);
	_g_object_unref0 (enumerator);
	return result;
}

void
delete_all_files (GFile* dir,
                  GeeSet* exceptions,
                  ProgressMonitor monitor,
                  gpointer monitor_target,
                  guint64 file_count,
                  GCancellable* cancellable,
                  GError** error)
{
	GFileType type = 0;
	GFileEnumerator* enumerator = NULL;
	GFileEnumerator* _tmp6_;
	GFileInfo* info = NULL;
	guint64 i = 0ULL;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (dir, g_file_get_type ()));
	g_return_if_fail ((exceptions == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (exceptions, GEE_TYPE_SET));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	type = g_file_query_file_type (dir, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL);
	if (type != G_FILE_TYPE_DIRECTORY) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		GError* _tmp4_;
		GError* _tmp5_;
		_tmp0_ = g_file_get_path (dir);
		_tmp1_ = _tmp0_;
		_tmp2_ = g_strdup_printf ("%s is not a directory", _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_NOT_DIRECTORY, _tmp3_);
		_tmp5_ = _tmp4_;
		_g_free0 (_tmp3_);
		_g_free0 (_tmp1_);
		_inner_error0_ = _tmp5_;
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp6_ = g_file_enumerate_children (dir, "standard::name,standard::type", G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, cancellable, &_inner_error0_);
	enumerator = _tmp6_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	info = NULL;
	i = (guint64) 0;
	while (TRUE) {
		GFileInfo* _tmp7_ = NULL;
		GFileEnumerator* _tmp8_;
		GFileInfo* _tmp9_;
		GFileInfo* _tmp10_;
		GFileInfo* _tmp11_;
		GFileInfo* _tmp12_;
		gboolean _tmp13_ = FALSE;
		GFile* file = NULL;
		GFileInfo* _tmp16_;
		const gchar* _tmp17_;
		GFile* _tmp18_;
		gboolean _tmp25_ = FALSE;
		_tmp8_ = enumerator;
		_tmp9_ = g_file_enumerator_next_file (_tmp8_, cancellable, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (info);
			_g_object_unref0 (enumerator);
			return;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		_g_object_unref0 (info);
		info = _tmp10_;
		_tmp11_ = info;
		if (!(_tmp11_ != NULL)) {
			_g_object_unref0 (_tmp7_);
			break;
		}
		_tmp12_ = info;
		if (g_file_info_get_file_type (_tmp12_) != G_FILE_TYPE_REGULAR) {
			_g_object_unref0 (_tmp7_);
			continue;
		}
		if (exceptions != NULL) {
			GFileInfo* _tmp14_;
			const gchar* _tmp15_;
			_tmp14_ = info;
			_tmp15_ = g_file_info_get_name (_tmp14_);
			_tmp13_ = gee_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (exceptions, GEE_TYPE_COLLECTION, GeeCollection), _tmp15_);
		} else {
			_tmp13_ = FALSE;
		}
		if (_tmp13_) {
			_g_object_unref0 (_tmp7_);
			continue;
		}
		_tmp16_ = info;
		_tmp17_ = g_file_info_get_name (_tmp16_);
		_tmp18_ = g_file_get_child (dir, _tmp17_);
		file = _tmp18_;
		{
			GFile* _tmp19_;
			_tmp19_ = file;
			g_file_delete (_tmp19_, cancellable, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* err = NULL;
			GFile* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			GError* _tmp23_;
			const gchar* _tmp24_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp20_ = file;
			_tmp21_ = g_file_get_path (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = err;
			_tmp24_ = _tmp23_->message;
			g_warning ("file.vala:150: Unable to delete file %s: %s", _tmp22_, _tmp24_);
			_g_free0 (_tmp22_);
			_g_error_free0 (err);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (file);
			_g_object_unref0 (_tmp7_);
			_g_object_unref0 (info);
			_g_object_unref0 (enumerator);
			return;
		}
		if (monitor != NULL) {
			_tmp25_ = file_count > ((guint64) 0);
		} else {
			_tmp25_ = FALSE;
		}
		if (_tmp25_) {
			ProgressMonitor _tmp26_;
			gpointer _tmp26__target;
			guint64 _tmp27_;
			guint64 _tmp28_;
			_tmp26_ = monitor;
			_tmp26__target = monitor_target;
			_tmp27_ = file_count;
			i = i + 1;
			_tmp28_ = i;
			_tmp26_ (_tmp27_, _tmp28_, TRUE, _tmp26__target);
		}
		_g_object_unref0 (file);
		_g_object_unref0 (_tmp7_);
	}
	_g_object_unref0 (info);
	_g_object_unref0 (enumerator);
}

GDateTime*
query_file_modified (GFile* file,
                     GError** error)
{
	GFileInfo* info = NULL;
	GFileInfo* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	GError* _inner_error0_ = NULL;
	GDateTime* result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), NULL);
	_tmp0_ = g_file_query_info (file, G_FILE_ATTRIBUTE_TIME_MODIFIED, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error0_);
	info = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp1_ = g_file_info_get_modification_date_time (info);
	_tmp2_ = _tmp1_;
	_tmp3_ = coarsify_date_time (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_date_time_unref0 (_tmp2_);
	result = _tmp4_;
	_g_object_unref0 (info);
	return result;
}

gboolean
query_is_directory (GFile* file)
{
	gboolean result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), FALSE);
	result = g_file_query_file_type (file, G_FILE_QUERY_INFO_NONE, NULL) == G_FILE_TYPE_DIRECTORY;
	return result;
}

gboolean
query_is_directory_empty (GFile* dir,
                          GError** error)
{
	GFileEnumerator* enumerator = NULL;
	GFileEnumerator* _tmp0_;
	GFileEnumerator* _tmp2_;
	GFileInfo* _tmp3_ = NULL;
	GFileEnumerator* _tmp4_;
	GFileInfo* _tmp5_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (dir, g_file_get_type ()), FALSE);
	if (g_file_query_file_type (dir, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL) != G_FILE_TYPE_DIRECTORY) {
		result = FALSE;
		return result;
	}
	_tmp0_ = g_file_enumerate_children (dir, "standard::name", G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error0_);
	enumerator = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp1_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp1_;
	}
	_tmp2_ = enumerator;
	if (_tmp2_ == NULL) {
		result = FALSE;
		_g_object_unref0 (enumerator);
		return result;
	}
	_tmp4_ = enumerator;
	_tmp5_ = g_file_enumerator_next_file (_tmp4_, NULL, &_inner_error0_);
	_tmp3_ = _tmp5_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp6_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (enumerator);
		return _tmp6_;
	}
	result = _tmp3_ == NULL;
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (enumerator);
	return result;
}

gchar*
get_display_pathname (GFile* file)
{
	gchar* path = NULL;
	gchar* _tmp0_;
	gchar* home = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), NULL);
	_tmp0_ = g_file_get_parse_name (file);
	path = _tmp0_;
	_tmp1_ = g_get_home_dir ();
	_tmp2_ = g_strdup (_tmp1_);
	home = _tmp2_;
	_tmp3_ = path;
	_tmp4_ = home;
	if (g_strcmp0 (_tmp3_, _tmp4_) == 0) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("~");
		result = _tmp5_;
		_g_free0 (home);
		_g_free0 (path);
		return result;
	}
	_tmp6_ = path;
	_tmp7_ = home;
	if (g_str_has_prefix (_tmp6_, _tmp7_)) {
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp8_ = path;
		_tmp9_ = home;
		_tmp10_ = strlen (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = string_substring (_tmp8_, (glong) _tmp11_, (glong) -1);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strdup_printf ("~%s", _tmp13_);
		_tmp15_ = _tmp14_;
		_g_free0 (_tmp13_);
		result = _tmp15_;
		_g_free0 (home);
		_g_free0 (path);
		return result;
	}
	result = path;
	_g_free0 (home);
	return result;
}

gchar*
strip_pretty_path (const gchar* path)
{
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* result;
	g_return_val_if_fail (path != NULL, NULL);
	if (!g_str_has_prefix (path, "~")) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (path);
		result = _tmp0_;
		return result;
	}
	_tmp1_ = g_get_home_dir ();
	_tmp2_ = string_substring (path, (glong) 1, (glong) -1);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp1_, _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	result = _tmp5_;
	return result;
}

gchar*
get_file_info_id (GFileInfo* info)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (info, g_file_info_get_type ()), NULL);
	_tmp0_ = g_file_info_get_attribute_string (info, G_FILE_ATTRIBUTE_ID_FILE);
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

guint64
count_files_in_directory (GFile* dir,
                          GError** error)
{
	guint64 count = 0ULL;
	GFileEnumerator* enumerator = NULL;
	GFileEnumerator* _tmp0_;
	GFileInfo* info = NULL;
	GError* _inner_error0_ = NULL;
	guint64 result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (dir, g_file_get_type ()), 0ULL);
	if (!query_is_directory (dir)) {
		result = (guint64) 0;
		return result;
	}
	count = (guint64) 0;
	_tmp0_ = g_file_enumerate_children (dir, "standard::*", G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error0_);
	enumerator = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		guint64 _tmp1_ = 0ULL;
		g_propagate_error (error, _inner_error0_);
		return _tmp1_;
	}
	info = NULL;
	while (TRUE) {
		GFileInfo* _tmp2_ = NULL;
		GFileEnumerator* _tmp3_;
		GFileInfo* _tmp4_;
		GFileInfo* _tmp6_;
		GFileInfo* _tmp7_;
		guint64 _tmp8_;
		_tmp3_ = enumerator;
		_tmp4_ = g_file_enumerator_next_file (_tmp3_, NULL, &_inner_error0_);
		_tmp2_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			guint64 _tmp5_ = 0ULL;
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (info);
			_g_object_unref0 (enumerator);
			return _tmp5_;
		}
		_tmp6_ = _tmp2_;
		_tmp2_ = NULL;
		_g_object_unref0 (info);
		info = _tmp6_;
		_tmp7_ = info;
		if (!(_tmp7_ != NULL)) {
			_g_object_unref0 (_tmp2_);
			break;
		}
		_tmp8_ = count;
		count = _tmp8_ + 1;
		_g_object_unref0 (_tmp2_);
	}
	result = count;
	_g_object_unref0 (info);
	_g_object_unref0 (enumerator);
	return result;
}

gboolean
file_equal (GFile* a,
            GFile* b)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean result;
	g_return_val_if_fail ((a == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (a, g_file_get_type ()), FALSE);
	g_return_val_if_fail ((b == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (b, g_file_get_type ()), FALSE);
	if (a != NULL) {
		_tmp1_ = b != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = g_file_equal (a, b);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

guint
file_hash (GFile* file)
{
	guint _tmp0_ = 0U;
	guint result;
	g_return_val_if_fail ((file == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), 0U);
	if (file != NULL) {
		_tmp0_ = g_file_hash (file);
	} else {
		_tmp0_ = (guint) 0;
	}
	result = _tmp0_;
	return result;
}

