/* VideoReader.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from VideoReader.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include "metadata.h"
#include <locale.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>

#define VIDEO_READER_UNKNOWN_CLIP_DURATION (-1.0)
#define VIDEO_READER_THUMBNAILER_TIMEOUT ((guint) 10000)
#define UTIL_FILE_ATTRIBUTES "standard::*,time::*,id::file,id::filesystem,etag::value"
#define DIRECTORY_MONITOR_SUPPLIED_ATTRIBUTES UTIL_FILE_ATTRIBUTES
#define VIDEO_ID_INVALID ((gint64) -1)
#define EVENT_ID_INVALID ((gint64) -1)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_VIDEO_ERROR (video_error_get_type ())

#define TYPE_VIDEO_READER (video_reader_get_type ())
#define VIDEO_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_READER, VideoReader))
#define VIDEO_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_READER, VideoReaderClass))
#define IS_VIDEO_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_READER))
#define IS_VIDEO_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_READER))
#define VIDEO_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_READER, VideoReaderClass))

typedef struct _VideoReader VideoReader;
typedef struct _VideoReaderClass VideoReaderClass;
typedef struct _VideoReaderPrivate VideoReaderPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_VIDEO_IMPORT_PARAMS (video_import_params_get_type ())
#define VIDEO_IMPORT_PARAMS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_IMPORT_PARAMS, VideoImportParams))
#define VIDEO_IMPORT_PARAMS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_IMPORT_PARAMS, VideoImportParamsClass))
#define IS_VIDEO_IMPORT_PARAMS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_IMPORT_PARAMS))
#define IS_VIDEO_IMPORT_PARAMS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_IMPORT_PARAMS))
#define VIDEO_IMPORT_PARAMS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_IMPORT_PARAMS, VideoImportParamsClass))

typedef struct _VideoImportParams VideoImportParams;
typedef struct _VideoImportParamsClass VideoImportParamsClass;
typedef enum  {
	IMPORT_RESULT_SUCCESS,
	IMPORT_RESULT_FILE_ERROR,
	IMPORT_RESULT_DECODE_ERROR,
	IMPORT_RESULT_DATABASE_ERROR,
	IMPORT_RESULT_USER_ABORT,
	IMPORT_RESULT_NOT_A_FILE,
	IMPORT_RESULT_PHOTO_EXISTS,
	IMPORT_RESULT_UNSUPPORTED_FORMAT,
	IMPORT_RESULT_NOT_AN_IMAGE,
	IMPORT_RESULT_DISK_FAILURE,
	IMPORT_RESULT_DISK_FULL,
	IMPORT_RESULT_CAMERA_ERROR,
	IMPORT_RESULT_FILE_WRITE_ERROR,
	IMPORT_RESULT_PIXBUF_CORRUPT_IMAGE
} ImportResult;

#define TYPE_IMPORT_RESULT (import_result_get_type ())
typedef struct _VideoImportParamsPrivate VideoImportParamsPrivate;

#define TYPE_IMPORT_ID (import_id_get_type ())
typedef struct _ImportID ImportID;

#define TYPE_THUMBNAILS (thumbnails_get_type ())
#define THUMBNAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAILS, Thumbnails))
#define THUMBNAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAILS, ThumbnailsClass))
#define IS_THUMBNAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAILS))
#define IS_THUMBNAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAILS))
#define THUMBNAILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAILS, ThumbnailsClass))

typedef struct _Thumbnails Thumbnails;
typedef struct _ThumbnailsClass ThumbnailsClass;

#define TYPE_VIDEO_ROW (video_row_get_type ())
#define VIDEO_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_ROW, VideoRow))
#define VIDEO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_ROW, VideoRowClass))
#define IS_VIDEO_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_ROW))
#define IS_VIDEO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_ROW))
#define VIDEO_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_ROW, VideoRowClass))

typedef struct _VideoRow VideoRow;
typedef struct _VideoRowClass VideoRowClass;
#define _video_reader_unref0(var) ((var == NULL) ? NULL : (var = (video_reader_unref (var), NULL)))

#define TYPE_VIDEO_METADATA (video_metadata_get_type ())
#define VIDEO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_METADATA, VideoMetadata))
#define VIDEO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_METADATA, VideoMetadataClass))
#define IS_VIDEO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_METADATA))
#define IS_VIDEO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_METADATA))
#define VIDEO_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_METADATA, VideoMetadataClass))

typedef struct _VideoMetadata VideoMetadata;
typedef struct _VideoMetadataClass VideoMetadataClass;
#define _metadata_date_time_unref0(var) ((var == NULL) ? NULL : (var = (metadata_date_time_unref (var), NULL)))
#define _media_metadata_unref0(var) ((var == NULL) ? NULL : (var = (media_metadata_unref (var), NULL)))
typedef struct _VideoRowPrivate VideoRowPrivate;

#define TYPE_VIDEO_ID (video_id_get_type ())
typedef struct _VideoID VideoID;

#define TYPE_EVENT_ID (event_id_get_type ())
typedef struct _EventID EventID;
typedef enum  {
	RATING_REJECTED = -1,
	RATING_UNRATED = 0,
	RATING_ONE = 1,
	RATING_TWO = 2,
	RATING_THREE = 3,
	RATING_FOUR = 4,
	RATING_FIVE = 5
} Rating;

#define TYPE_RATING (rating_get_type ())
#define _thumbnails_unref0(var) ((var == NULL) ? NULL : (var = (thumbnails_unref (var), NULL)))
typedef struct _Block16Data Block16Data;
typedef struct _Block17Data Block17Data;
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
typedef struct _ParamSpecVideoReader ParamSpecVideoReader;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	VIDEO_ERROR_FILE,
	VIDEO_ERROR_CONTENTS
} VideoError;
#define VIDEO_ERROR video_error_quark ()

struct _VideoReader {
	GTypeInstance parent_instance;
	volatile int ref_count;
	VideoReaderPrivate * priv;
};

struct _VideoReaderClass {
	GTypeClass parent_class;
	void (*finalize) (VideoReader *self);
};

struct _VideoReaderPrivate {
	gdouble clip_duration;
	GdkPixbuf* preview_frame;
	GFile* file;
	GSubprocess* thumbnailer_process;
	GDateTime* _timestamp;
};

struct _ImportID {
	gint64 id;
};

struct _VideoImportParams {
	GTypeInstance parent_instance;
	volatile int ref_count;
	VideoImportParamsPrivate * priv;
	GFile* file;
	ImportID import_id;
	gchar* md5;
	GDateTime* exposure_time_override;
	Thumbnails* thumbnails;
	VideoRow* row;
};

struct _VideoImportParamsClass {
	GTypeClass parent_class;
	void (*finalize) (VideoImportParams *self);
};

struct _VideoID {
	gint64 id;
};

struct _EventID {
	gint64 id;
};

struct _VideoRow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	VideoRowPrivate * priv;
	VideoID video_id;
	gchar* filepath;
	gint64 filesize;
	GDateTime* timestamp;
	gint width;
	gint height;
	gdouble clip_duration;
	gboolean is_interpretable;
	GDateTime* exposure_time;
	ImportID import_id;
	EventID event_id;
	gchar* md5;
	gint64 time_created;
	Rating rating;
	gchar* title;
	gchar* backlinks;
	gint64 time_reimported;
	guint64 flags;
	gchar* comment;
};

struct _VideoRowClass {
	GTypeClass parent_class;
	void (*finalize) (VideoRow *self);
};

struct _Block16Data {
	int _ref_count_;
	VideoReader* self;
	guint id;
};

struct _Block17Data {
	int _ref_count_;
	Block16Data * _data16_;
	GCancellable* cancellable;
};

struct _ParamSpecVideoReader {
	GParamSpec parent_instance;
};

static gint VideoReader_private_offset;
static gpointer video_reader_parent_class = NULL;

VALA_EXTERN GQuark video_error_quark (void);
VALA_EXTERN GType video_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gpointer video_reader_ref (gpointer instance);
VALA_EXTERN void video_reader_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_video_reader (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags);
VALA_EXTERN void value_set_video_reader (GValue* value,
                             gpointer v_object);
VALA_EXTERN void value_take_video_reader (GValue* value,
                              gpointer v_object);
VALA_EXTERN gpointer value_get_video_reader (const GValue* value);
VALA_EXTERN GType video_reader_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VideoReader, video_reader_unref)
VALA_EXTERN VideoReader* video_reader_new (GFile* file);
VALA_EXTERN VideoReader* video_reader_construct (GType object_type,
                                     GFile* file);
VALA_EXTERN gboolean video_reader_is_supported_video_file (GFile* file);
VALA_EXTERN gboolean video_reader_is_supported_video_filename (const gchar* filename);
VALA_EXTERN void disassemble_filename (const gchar* basename,
                           gchar** name,
                           gchar** ext);
VALA_EXTERN gint utf8_ci_compare (const gchar* a,
                      const gchar* b);
VALA_EXTERN gpointer video_import_params_ref (gpointer instance);
VALA_EXTERN void video_import_params_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_video_import_params (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags);
VALA_EXTERN void value_set_video_import_params (GValue* value,
                                    gpointer v_object);
VALA_EXTERN void value_take_video_import_params (GValue* value,
                                     gpointer v_object);
VALA_EXTERN gpointer value_get_video_import_params (const GValue* value);
VALA_EXTERN GType video_import_params_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VideoImportParams, video_import_params_unref)
VALA_EXTERN GType import_result_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ImportResult video_reader_prepare_for_import (VideoImportParams* params);
VALA_EXTERN GType import_id_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ImportID* import_id_dup (const ImportID* self);
VALA_EXTERN void import_id_free (ImportID* self);
VALA_EXTERN gpointer thumbnails_ref (gpointer instance);
VALA_EXTERN void thumbnails_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_thumbnails (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
VALA_EXTERN void value_set_thumbnails (GValue* value,
                           gpointer v_object);
VALA_EXTERN void value_take_thumbnails (GValue* value,
                            gpointer v_object);
VALA_EXTERN gpointer value_get_thumbnails (const GValue* value);
VALA_EXTERN GType thumbnails_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Thumbnails, thumbnails_unref)
VALA_EXTERN gpointer video_row_ref (gpointer instance);
VALA_EXTERN void video_row_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_video_row (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
VALA_EXTERN void value_set_video_row (GValue* value,
                          gpointer v_object);
VALA_EXTERN void value_take_video_row (GValue* value,
                           gpointer v_object);
VALA_EXTERN gpointer value_get_video_row (const GValue* value);
VALA_EXTERN GType video_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VideoRow, video_row_unref)
VALA_EXTERN GDateTime* coarsify_date_time (GDateTime* dt);
VALA_EXTERN GdkPixbuf* video_reader_read_preview_frame (VideoReader* self);
VALA_EXTERN gdouble video_reader_read_clip_duration (VideoReader* self,
                                         GError** error);
VALA_EXTERN GType video_metadata_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VideoMetadata, media_metadata_unref)
VALA_EXTERN VideoMetadata* video_reader_read_metadata (VideoReader* self,
                                           GError** error);
VALA_EXTERN GDateTime* video_reader_get_timestamp (VideoReader* self);
VALA_EXTERN GType video_id_get_type (void) G_GNUC_CONST ;
VALA_EXTERN VideoID* video_id_dup (const VideoID* self);
VALA_EXTERN void video_id_free (VideoID* self);
VALA_EXTERN GType event_id_get_type (void) G_GNUC_CONST ;
VALA_EXTERN EventID* event_id_dup (const EventID* self);
VALA_EXTERN void event_id_free (EventID* self);
VALA_EXTERN GType rating_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void video_id_init (VideoID *self,
                    gint64 id);
VALA_EXTERN void event_id_init (EventID *self,
                    gint64 id);
VALA_EXTERN Thumbnails* thumbnails_new (void);
VALA_EXTERN Thumbnails* thumbnails_construct (GType object_type);
VALA_EXTERN void thumbnail_cache_generate_for_video_frame (Thumbnails* thumbnails,
                                               GdkPixbuf* preview_frame);
static void video_reader_read_internal (VideoReader* self,
                                 GError** error);
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (void * _userdata_);
static gboolean video_reader_does_file_exist (VideoReader* self);
static Block17Data* block17_data_ref (Block17Data* _data17_);
static void block17_data_unref (void * _userdata_);
static gboolean ___lambda11_ (Block17Data* _data17_);
static gboolean ____lambda11__gsource_func (gpointer self);
VALA_EXTERN GFile* app_dirs_get_metadata_helper (void);
static void video_reader_set_timestamp (VideoReader* self,
                                 GDateTime* value);
static gboolean video_reader_on_thumbnailer_timer (VideoReader* self);
static GdkPixbuf* video_reader_thumbnailer (VideoReader* self,
                                     const gchar* video_file);
VALA_EXTERN GFile* app_dirs_get_thumbnailer_bin (void);
static gboolean _video_reader_on_thumbnailer_timer_gsource_func (gpointer self);
VALA_EXTERN GdkPixbuf* resources_get_noninterpretable_badge_pixbuf (void);
VALA_EXTERN VideoMetadata* video_metadata_new (void);
VALA_EXTERN VideoMetadata* video_metadata_construct (GType object_type);
static void video_reader_finalize (VideoReader * obj);
static GType video_reader_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static const gchar* VIDEO_READER_METADATA_ONLY_FILE_EXTENSIONS[4] = {"bdm", "bdmv", "cpi", "mpl"};

GQuark
video_error_quark (void)
{
	return g_quark_from_static_string ("video-error-quark");
}

static GType
video_error_get_type_once (void)
{
	static const GEnumValue values[] = {{VIDEO_ERROR_FILE, "VIDEO_ERROR_FILE", "file"}, {VIDEO_ERROR_CONTENTS, "VIDEO_ERROR_CONTENTS", "contents"}, {0, NULL, NULL}};
	GType video_error_type_id;
	video_error_type_id = g_enum_register_static ("VideoError", values);
	return video_error_type_id;
}

GType
video_error_get_type (void)
{
	static volatile gsize video_error_type_id__once = 0;
	if (g_once_init_enter (&video_error_type_id__once)) {
		GType video_error_type_id;
		video_error_type_id = video_error_get_type_once ();
		g_once_init_leave (&video_error_type_id__once, video_error_type_id);
	}
	return video_error_type_id__once;
}

static inline gpointer
video_reader_get_instance_private (VideoReader* self)
{
	return G_STRUCT_MEMBER_P (self, VideoReader_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

VideoReader*
video_reader_construct (GType object_type,
                        GFile* file)
{
	VideoReader* self = NULL;
	GFile* _tmp0_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), NULL);
	self = (VideoReader*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (file);
	_g_object_unref0 (self->priv->file);
	self->priv->file = _tmp0_;
	return self;
}

VideoReader*
video_reader_new (GFile* file)
{
	return video_reader_construct (TYPE_VIDEO_READER, file);
}

gboolean
video_reader_is_supported_video_file (GFile* file)
{
	gchar* mime_type = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	guchar* _tmp2_;
	guchar* _tmp3_;
	gint _tmp3__length1;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gboolean _tmp20_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), FALSE);
	_tmp0_ = g_file_get_basename (file);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_new0 (guchar, 0);
	_tmp3_ = _tmp2_;
	_tmp3__length1 = 0;
	_tmp4_ = g_content_type_guess (_tmp1_, _tmp3_, (gsize) 0, NULL);
	_tmp5_ = _tmp4_;
	_tmp3_ = (g_free (_tmp3_), NULL);
	_g_free0 (_tmp1_);
	mime_type = _tmp5_;
	_tmp7_ = mime_type;
	if (g_strcmp0 (_tmp7_, "audio/ogg") == 0) {
		_tmp6_ = g_file_has_uri_scheme (file, "file");
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		{
			GFileInfo* info = NULL;
			GFileInfo* _tmp8_;
			gchar* content_type = NULL;
			GFileInfo* _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			gboolean _tmp12_ = FALSE;
			const gchar* _tmp13_;
			_tmp8_ = g_file_query_info (file, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
			info = _tmp8_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp9_ = info;
			_tmp10_ = g_file_info_get_content_type (_tmp9_);
			_tmp11_ = g_strdup (_tmp10_);
			content_type = _tmp11_;
			_tmp13_ = content_type;
			if (_tmp13_ != NULL) {
				const gchar* _tmp14_;
				_tmp14_ = content_type;
				_tmp12_ = g_str_has_prefix (_tmp14_, "video/");
			} else {
				_tmp12_ = FALSE;
			}
			if (_tmp12_) {
				result = TRUE;
				_g_free0 (content_type);
				_g_object_unref0 (info);
				_g_free0 (mime_type);
				return result;
			}
			_g_free0 (content_type);
			_g_object_unref0 (info);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* _error_ = NULL;
			GError* _tmp15_;
			const gchar* _tmp16_;
			_error_ = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp15_ = _error_;
			_tmp16_ = _tmp15_->message;
			g_debug ("VideoReader.vala:44: Failed to query content type: %s", _tmp16_);
			_g_error_free0 (_error_);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp17_ = FALSE;
			_g_free0 (mime_type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp17_;
		}
	}
	_tmp18_ = g_file_get_basename (file);
	_tmp19_ = _tmp18_;
	_tmp20_ = video_reader_is_supported_video_filename (_tmp19_);
	_g_free0 (_tmp19_);
	result = _tmp20_;
	_g_free0 (mime_type);
	return result;
}

gboolean
video_reader_is_supported_video_filename (const gchar* filename)
{
	gchar* mime_type = NULL;
	guchar* _tmp0_;
	guchar* _tmp1_;
	gint _tmp1__length1;
	gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	gboolean result;
	g_return_val_if_fail (filename != NULL, FALSE);
	_tmp0_ = g_new0 (guchar, 0);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = 0;
	_tmp2_ = g_content_type_guess (filename, _tmp1_, (gsize) 0, NULL);
	_g_free0 (mime_type);
	mime_type = _tmp2_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	_tmp5_ = mime_type;
	if (g_str_has_prefix (_tmp5_, "video/")) {
		_tmp4_ = TRUE;
	} else {
		const gchar* _tmp6_;
		_tmp6_ = mime_type;
		_tmp4_ = g_str_has_suffix (_tmp6_, "mp4");
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		const gchar* _tmp7_;
		_tmp7_ = mime_type;
		_tmp3_ = g_str_has_suffix (_tmp7_, "mxf");
	}
	if (_tmp3_) {
		gchar* extension = NULL;
		gchar* name = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		const gchar* _tmp10_;
		extension = NULL;
		name = NULL;
		disassemble_filename (filename, &_tmp8_, &_tmp9_);
		_g_free0 (name);
		name = _tmp8_;
		_g_free0 (extension);
		extension = _tmp9_;
		_tmp10_ = extension;
		if (_tmp10_ == NULL) {
			result = TRUE;
			_g_free0 (name);
			_g_free0 (extension);
			_g_free0 (mime_type);
			return result;
		}
		{
			const gchar** s_collection = NULL;
			gint s_collection_length1 = 0;
			gint _s_collection_size_ = 0;
			gint s_it = 0;
			s_collection = VIDEO_READER_METADATA_ONLY_FILE_EXTENSIONS;
			s_collection_length1 = G_N_ELEMENTS (VIDEO_READER_METADATA_ONLY_FILE_EXTENSIONS);
			for (s_it = 0; s_it < s_collection_length1; s_it = s_it + 1) {
				gchar* _tmp11_;
				gchar* s = NULL;
				_tmp11_ = g_strdup (s_collection[s_it]);
				s = _tmp11_;
				{
					const gchar* _tmp12_;
					const gchar* _tmp13_;
					_tmp12_ = s;
					_tmp13_ = extension;
					if (utf8_ci_compare (_tmp12_, _tmp13_) == 0) {
						result = FALSE;
						_g_free0 (s);
						_g_free0 (name);
						_g_free0 (extension);
						_g_free0 (mime_type);
						return result;
					}
					_g_free0 (s);
				}
			}
		}
		result = TRUE;
		_g_free0 (name);
		_g_free0 (extension);
		_g_free0 (mime_type);
		return result;
	} else {
		const gchar* _tmp14_;
		_tmp14_ = mime_type;
		g_debug ("VideoReader.vala:72: Skipping %s, unsupported mime type %s", filename, _tmp14_);
		result = FALSE;
		_g_free0 (mime_type);
		return result;
	}
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

ImportResult
video_reader_prepare_for_import (VideoImportParams* params)
{
	GFile* file = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFileInfo* info = NULL;
	GFileInfo* _tmp6_;
	GFile* _tmp7_;
	GDateTime* timestamp = NULL;
	GFileInfo* _tmp11_;
	GDateTime* _tmp12_;
	GDateTime* _tmp13_;
	GDateTime* _tmp14_;
	GDateTime* _tmp15_;
	const gchar* _tmp16_;
	GDateTime* exposure_time = NULL;
	GDateTime* _tmp17_;
	GDateTime* _tmp18_;
	gchar* title = NULL;
	gchar* _tmp19_;
	gchar* comment = NULL;
	gchar* _tmp20_;
	VideoReader* reader = NULL;
	GFile* _tmp21_;
	VideoReader* _tmp22_;
	gboolean is_interpretable = FALSE;
	gdouble clip_duration = 0.0;
	GdkPixbuf* preview_frame = NULL;
	VideoReader* _tmp23_;
	GdkPixbuf* _tmp24_;
	GDateTime* _tmp52_;
	VideoRow* _tmp56_;
	VideoRow* _tmp57_;
	GFile* _tmp58_;
	gchar* _tmp59_;
	VideoRow* _tmp60_;
	GFileInfo* _tmp61_;
	VideoRow* _tmp62_;
	GDateTime* _tmp63_;
	GDateTime* _tmp64_;
	VideoRow* _tmp65_;
	GdkPixbuf* _tmp66_;
	gint _tmp67_;
	gint _tmp68_;
	VideoRow* _tmp69_;
	GdkPixbuf* _tmp70_;
	gint _tmp71_;
	gint _tmp72_;
	VideoRow* _tmp73_;
	VideoRow* _tmp74_;
	VideoRow* _tmp75_;
	GDateTime* _tmp76_;
	GDateTime* _tmp77_;
	VideoRow* _tmp78_;
	ImportID _tmp79_;
	VideoRow* _tmp80_;
	VideoRow* _tmp81_;
	const gchar* _tmp82_;
	gchar* _tmp83_;
	VideoRow* _tmp84_;
	VideoRow* _tmp85_;
	const gchar* _tmp86_;
	gchar* _tmp87_;
	VideoRow* _tmp88_;
	const gchar* _tmp89_;
	gchar* _tmp90_;
	VideoRow* _tmp91_;
	gchar* _tmp92_;
	VideoRow* _tmp93_;
	VideoRow* _tmp94_;
	Thumbnails* _tmp95_;
	GError* _inner_error0_ = NULL;
	ImportResult result;
	g_return_val_if_fail (IS_VIDEO_IMPORT_PARAMS (params), 0);
	_tmp0_ = params->file;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	file = _tmp1_;
	info = NULL;
	{
		GFileInfo* _tmp2_ = NULL;
		GFile* _tmp3_;
		GFileInfo* _tmp4_;
		GFileInfo* _tmp5_;
		_tmp3_ = file;
		_tmp4_ = g_file_query_info (_tmp3_, DIRECTORY_MONITOR_SUPPLIED_ATTRIBUTES, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error0_);
		_tmp2_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = _tmp2_;
		_tmp2_ = NULL;
		_g_object_unref0 (info);
		info = _tmp5_;
		_g_object_unref0 (_tmp2_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		result = IMPORT_RESULT_FILE_ERROR;
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return 0;
	}
	_tmp6_ = info;
	if (g_file_info_get_file_type (_tmp6_) != G_FILE_TYPE_REGULAR) {
		result = IMPORT_RESULT_NOT_A_FILE;
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		return result;
	}
	_tmp7_ = file;
	if (!video_reader_is_supported_video_file (_tmp7_)) {
		GFile* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp8_ = file;
		_tmp9_ = g_file_get_path (_tmp8_);
		_tmp10_ = _tmp9_;
		g_message ("Not importing %s: file is marked as a video file but doesn't have a" "supported extension", _tmp10_);
		_g_free0 (_tmp10_);
		result = IMPORT_RESULT_UNSUPPORTED_FORMAT;
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		return result;
	}
	_tmp11_ = info;
	_tmp12_ = g_file_info_get_modification_date_time (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = coarsify_date_time (_tmp13_);
	_tmp15_ = _tmp14_;
	_g_date_time_unref0 (_tmp13_);
	timestamp = _tmp15_;
	_tmp16_ = params->md5;
	_vala_assert (_tmp16_ != NULL, "params.md5 != null");
	_tmp17_ = params->exposure_time_override;
	_tmp18_ = _g_date_time_ref0 (_tmp17_);
	exposure_time = _tmp18_;
	_tmp19_ = g_strdup ("");
	title = _tmp19_;
	_tmp20_ = g_strdup ("");
	comment = _tmp20_;
	_tmp21_ = file;
	_tmp22_ = video_reader_new (_tmp21_);
	reader = _tmp22_;
	is_interpretable = TRUE;
	clip_duration = 0.0;
	_tmp23_ = reader;
	_tmp24_ = video_reader_read_preview_frame (_tmp23_);
	preview_frame = _tmp24_;
	{
		gdouble _tmp25_ = 0.0;
		VideoReader* _tmp26_;
		_tmp26_ = reader;
		_tmp25_ = video_reader_read_clip_duration (_tmp26_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VIDEO_ERROR) {
				goto __catch1_video_error;
			}
			_g_object_unref0 (preview_frame);
			_video_reader_unref0 (reader);
			_g_free0 (comment);
			_g_free0 (title);
			_g_date_time_unref0 (exposure_time);
			_g_date_time_unref0 (timestamp);
			_g_object_unref0 (info);
			_g_object_unref0 (file);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return 0;
		}
		clip_duration = _tmp25_;
	}
	goto __finally1;
	__catch1_video_error:
	{
		GError* err = NULL;
		GError* _tmp27_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp27_ = err;
		if (g_error_matches (_tmp27_, VIDEO_ERROR, VIDEO_ERROR_FILE)) {
			result = IMPORT_RESULT_FILE_ERROR;
			_g_error_free0 (err);
			_g_object_unref0 (preview_frame);
			_video_reader_unref0 (reader);
			_g_free0 (comment);
			_g_free0 (title);
			_g_date_time_unref0 (exposure_time);
			_g_date_time_unref0 (timestamp);
			_g_object_unref0 (info);
			_g_object_unref0 (file);
			return result;
		} else {
			GError* _tmp28_;
			_tmp28_ = err;
			if (g_error_matches (_tmp28_, VIDEO_ERROR, VIDEO_ERROR_CONTENTS)) {
				is_interpretable = FALSE;
				clip_duration = 0.0;
			} else {
				g_error ("VideoReader.vala:123: can't prepare video for import: an unknown kind " \
"of video error occurred");
			}
		}
		_g_error_free0 (err);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (preview_frame);
		_video_reader_unref0 (reader);
		_g_free0 (comment);
		_g_free0 (title);
		_g_date_time_unref0 (exposure_time);
		_g_date_time_unref0 (timestamp);
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return 0;
	}
	{
		VideoMetadata* metadata = NULL;
		VideoReader* _tmp29_;
		VideoMetadata* _tmp30_;
		MetadataDateTime* creation_date_time = NULL;
		VideoMetadata* _tmp31_;
		MetadataDateTime* _tmp32_;
		gboolean _tmp33_ = FALSE;
		MetadataDateTime* _tmp34_;
		gchar* video_title = NULL;
		VideoMetadata* _tmp40_;
		gchar* _tmp41_;
		gchar* video_comment = NULL;
		VideoMetadata* _tmp42_;
		gchar* _tmp43_;
		const gchar* _tmp44_;
		const gchar* _tmp47_;
		_tmp29_ = reader;
		_tmp30_ = video_reader_read_metadata (_tmp29_, &_inner_error0_);
		metadata = _tmp30_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch2_g_error;
		}
		_tmp31_ = metadata;
		_tmp32_ = media_metadata_get_creation_date_time (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, TYPE_MEDIA_METADATA, MediaMetadata));
		creation_date_time = _tmp32_;
		_tmp34_ = creation_date_time;
		if (_tmp34_ != NULL) {
			MetadataDateTime* _tmp35_;
			GDateTime* _tmp36_;
			GDateTime* _tmp37_;
			_tmp35_ = creation_date_time;
			_tmp36_ = metadata_date_time_get_timestamp (_tmp35_);
			_tmp37_ = _tmp36_;
			_tmp33_ = _tmp37_ != NULL;
			_g_date_time_unref0 (_tmp37_);
		} else {
			_tmp33_ = FALSE;
		}
		if (_tmp33_) {
			MetadataDateTime* _tmp38_;
			GDateTime* _tmp39_;
			_tmp38_ = creation_date_time;
			_tmp39_ = metadata_date_time_get_timestamp (_tmp38_);
			_g_date_time_unref0 (exposure_time);
			exposure_time = _tmp39_;
		}
		_tmp40_ = metadata;
		_tmp41_ = media_metadata_get_title (G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, TYPE_MEDIA_METADATA, MediaMetadata));
		video_title = _tmp41_;
		_tmp42_ = metadata;
		_tmp43_ = media_metadata_get_comment (G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, TYPE_MEDIA_METADATA, MediaMetadata));
		video_comment = _tmp43_;
		_tmp44_ = video_title;
		if (_tmp44_ != NULL) {
			const gchar* _tmp45_;
			gchar* _tmp46_;
			_tmp45_ = video_title;
			_tmp46_ = g_strdup (_tmp45_);
			_g_free0 (title);
			title = _tmp46_;
		}
		_tmp47_ = video_comment;
		if (_tmp47_ != NULL) {
			const gchar* _tmp48_;
			gchar* _tmp49_;
			_tmp48_ = video_comment;
			_tmp49_ = g_strdup (_tmp48_);
			_g_free0 (comment);
			comment = _tmp49_;
		}
		_g_free0 (video_comment);
		_g_free0 (video_title);
		_metadata_date_time_unref0 (creation_date_time);
		_media_metadata_unref0 (metadata);
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* err = NULL;
		GError* _tmp50_;
		const gchar* _tmp51_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp50_ = err;
		_tmp51_ = _tmp50_->message;
		g_warning ("VideoReader.vala:141: Unable to read video metadata: %s", _tmp51_);
		_g_error_free0 (err);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (preview_frame);
		_video_reader_unref0 (reader);
		_g_free0 (comment);
		_g_free0 (title);
		_g_date_time_unref0 (exposure_time);
		_g_date_time_unref0 (timestamp);
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return 0;
	}
	_tmp52_ = exposure_time;
	if (_tmp52_ == NULL) {
		VideoReader* _tmp53_;
		GDateTime* _tmp54_;
		GDateTime* _tmp55_;
		_tmp53_ = reader;
		_tmp54_ = _tmp53_->priv->_timestamp;
		_tmp55_ = _g_date_time_ref0 (_tmp54_);
		_g_date_time_unref0 (exposure_time);
		exposure_time = _tmp55_;
	}
	_tmp56_ = params->row;
	video_id_init (&_tmp56_->video_id, VIDEO_ID_INVALID);
	_tmp57_ = params->row;
	_tmp58_ = file;
	_tmp59_ = g_file_get_path (_tmp58_);
	_g_free0 (_tmp57_->filepath);
	_tmp57_->filepath = _tmp59_;
	_tmp60_ = params->row;
	_tmp61_ = info;
	_tmp60_->filesize = g_file_info_get_size (_tmp61_);
	_tmp62_ = params->row;
	_tmp63_ = timestamp;
	_tmp64_ = _g_date_time_ref0 (_tmp63_);
	_g_date_time_unref0 (_tmp62_->timestamp);
	_tmp62_->timestamp = _tmp64_;
	_tmp65_ = params->row;
	_tmp66_ = preview_frame;
	_tmp67_ = gdk_pixbuf_get_width (_tmp66_);
	_tmp68_ = _tmp67_;
	_tmp65_->width = _tmp68_;
	_tmp69_ = params->row;
	_tmp70_ = preview_frame;
	_tmp71_ = gdk_pixbuf_get_height (_tmp70_);
	_tmp72_ = _tmp71_;
	_tmp69_->height = _tmp72_;
	_tmp73_ = params->row;
	_tmp73_->clip_duration = clip_duration;
	_tmp74_ = params->row;
	_tmp74_->is_interpretable = is_interpretable;
	_tmp75_ = params->row;
	_tmp76_ = exposure_time;
	_tmp77_ = _g_date_time_ref0 (_tmp76_);
	_g_date_time_unref0 (_tmp75_->exposure_time);
	_tmp75_->exposure_time = _tmp77_;
	_tmp78_ = params->row;
	_tmp79_ = params->import_id;
	_tmp78_->import_id = _tmp79_;
	_tmp80_ = params->row;
	event_id_init (&_tmp80_->event_id, EVENT_ID_INVALID);
	_tmp81_ = params->row;
	_tmp82_ = params->md5;
	_tmp83_ = g_strdup (_tmp82_);
	_g_free0 (_tmp81_->md5);
	_tmp81_->md5 = _tmp83_;
	_tmp84_ = params->row;
	_tmp84_->time_created = (gint64) 0;
	_tmp85_ = params->row;
	_tmp86_ = title;
	_tmp87_ = g_strdup (_tmp86_);
	_g_free0 (_tmp85_->title);
	_tmp85_->title = _tmp87_;
	_tmp88_ = params->row;
	_tmp89_ = comment;
	_tmp90_ = g_strdup (_tmp89_);
	_g_free0 (_tmp88_->comment);
	_tmp88_->comment = _tmp90_;
	_tmp91_ = params->row;
	_tmp92_ = g_strdup ("");
	_g_free0 (_tmp91_->backlinks);
	_tmp91_->backlinks = _tmp92_;
	_tmp93_ = params->row;
	_tmp93_->time_reimported = (gint64) 0;
	_tmp94_ = params->row;
	_tmp94_->flags = (guint64) 0;
	_tmp95_ = params->thumbnails;
	if (_tmp95_ != NULL) {
		Thumbnails* _tmp96_;
		Thumbnails* _tmp97_;
		GdkPixbuf* _tmp98_;
		_tmp96_ = thumbnails_new ();
		_thumbnails_unref0 (params->thumbnails);
		params->thumbnails = _tmp96_;
		_tmp97_ = params->thumbnails;
		_tmp98_ = preview_frame;
		thumbnail_cache_generate_for_video_frame (_tmp97_, _tmp98_);
	}
	result = IMPORT_RESULT_SUCCESS;
	_g_object_unref0 (preview_frame);
	_video_reader_unref0 (reader);
	_g_free0 (comment);
	_g_free0 (title);
	_g_date_time_unref0 (exposure_time);
	_g_date_time_unref0 (timestamp);
	_g_object_unref0 (info);
	_g_object_unref0 (file);
	return result;
}

static Block16Data*
block16_data_ref (Block16Data* _data16_)
{
	g_atomic_int_inc (&_data16_->_ref_count_);
	return _data16_;
}

static void
block16_data_unref (void * _userdata_)
{
	Block16Data* _data16_;
	_data16_ = (Block16Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
		VideoReader* self;
		self = _data16_->self;
		_video_reader_unref0 (self);
		g_slice_free (Block16Data, _data16_);
	}
}

static Block17Data*
block17_data_ref (Block17Data* _data17_)
{
	g_atomic_int_inc (&_data17_->_ref_count_);
	return _data17_;
}

static void
block17_data_unref (void * _userdata_)
{
	Block17Data* _data17_;
	_data17_ = (Block17Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data17_->_ref_count_)) {
		VideoReader* self;
		self = _data17_->_data16_->self;
		_g_object_unref0 (_data17_->cancellable);
		block16_data_unref (_data17_->_data16_);
		_data17_->_data16_ = NULL;
		g_slice_free (Block17Data, _data17_);
	}
}

static gboolean
___lambda11_ (Block17Data* _data17_)
{
	Block16Data* _data16_;
	VideoReader* self;
	GCancellable* _tmp0_;
	gboolean result;
	_data16_ = _data17_->_data16_;
	self = _data16_->self;
	_tmp0_ = _data17_->cancellable;
	g_cancellable_cancel (_tmp0_);
	_data16_->id = (guint) 0;
	result = FALSE;
	return result;
}

static gboolean
____lambda11__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda11_ (self);
	return result;
}

static gdouble
double_parse (const gchar* str)
{
	gdouble result;
	g_return_val_if_fail (str != NULL, 0.0);
	result = g_ascii_strtod (str, NULL);
	return result;
}

static void
video_reader_read_internal (VideoReader* self,
                            GError** error)
{
	Block16Data* _data16_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_VIDEO_READER (self));
	_data16_ = g_slice_new0 (Block16Data);
	_data16_->_ref_count_ = 1;
	_data16_->self = video_reader_ref (self);
	if (!video_reader_does_file_exist (self)) {
		GFile* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GError* _tmp5_;
		GError* _tmp6_;
		_tmp0_ = self->priv->file;
		_tmp1_ = g_file_get_path (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_strdup_printf ("video file '%s' does not exist or is inaccessible", _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_error_new_literal (VIDEO_ERROR, VIDEO_ERROR_FILE, _tmp4_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		_g_free0 (_tmp2_);
		_inner_error0_ = _tmp6_;
		if (_inner_error0_->domain == VIDEO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			block16_data_unref (_data16_);
			_data16_ = NULL;
			return;
		} else {
			block16_data_unref (_data16_);
			_data16_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_data16_->id = (guint) 0;
	{
		Block17Data* _data17_;
		GCancellable* _tmp7_;
		GBytes* stdout_buf = NULL;
		GBytes* stderr_buf = NULL;
		GSubprocess* process = NULL;
		GFile* _tmp8_;
		GFile* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		GFile* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		GSubprocess* _tmp15_;
		GSubprocess* _tmp16_;
		gboolean _result_ = FALSE;
		GSubprocess* _tmp17_;
		GCancellable* _tmp18_;
		GBytes* _tmp19_ = NULL;
		GBytes* _tmp20_ = NULL;
		gboolean _tmp21_;
		gboolean _tmp22_ = FALSE;
		gboolean _tmp23_ = FALSE;
		gboolean _tmp24_ = FALSE;
		gboolean _tmp25_ = FALSE;
		_data17_ = g_slice_new0 (Block17Data);
		_data17_->_ref_count_ = 1;
		_data17_->_data16_ = block16_data_ref (_data16_);
		_tmp7_ = g_cancellable_new ();
		_data17_->cancellable = _tmp7_;
		_data16_->id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 10, ____lambda11__gsource_func, block17_data_ref (_data17_), block17_data_unref);
		stdout_buf = NULL;
		stderr_buf = NULL;
		_tmp8_ = app_dirs_get_metadata_helper ();
		_tmp9_ = _tmp8_;
		_tmp10_ = g_file_get_path (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = self->priv->file;
		_tmp13_ = g_file_get_uri (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_subprocess_new (G_SUBPROCESS_FLAGS_STDOUT_PIPE, &_inner_error0_, _tmp11_, _tmp14_, NULL);
		_tmp16_ = _tmp15_;
		_g_free0 (_tmp14_);
		_g_free0 (_tmp11_);
		_g_object_unref0 (_tmp9_);
		process = _tmp16_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_bytes_unref0 (stderr_buf);
			_g_bytes_unref0 (stdout_buf);
			block17_data_unref (_data17_);
			_data17_ = NULL;
			goto __catch0_g_error;
		}
		_tmp17_ = process;
		_tmp18_ = _data17_->cancellable;
		_tmp21_ = g_subprocess_communicate (_tmp17_, NULL, _tmp18_, &_tmp19_, &_tmp20_, &_inner_error0_);
		_g_bytes_unref0 (stdout_buf);
		stdout_buf = _tmp19_;
		_g_bytes_unref0 (stderr_buf);
		stderr_buf = _tmp20_;
		_result_ = _tmp21_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (process);
			_g_bytes_unref0 (stderr_buf);
			_g_bytes_unref0 (stdout_buf);
			block17_data_unref (_data17_);
			_data17_ = NULL;
			goto __catch0_g_error;
		}
		if (_result_) {
			GSubprocess* _tmp26_;
			_tmp26_ = process;
			_tmp25_ = g_subprocess_get_if_exited (_tmp26_);
		} else {
			_tmp25_ = FALSE;
		}
		if (_tmp25_) {
			GSubprocess* _tmp27_;
			_tmp27_ = process;
			_tmp24_ = g_subprocess_get_exit_status (_tmp27_) == 0;
		} else {
			_tmp24_ = FALSE;
		}
		if (_tmp24_) {
			GBytes* _tmp28_;
			_tmp28_ = stdout_buf;
			_tmp23_ = _tmp28_ != NULL;
		} else {
			_tmp23_ = FALSE;
		}
		if (_tmp23_) {
			GBytes* _tmp29_;
			_tmp29_ = stdout_buf;
			_tmp22_ = g_bytes_get_size (_tmp29_) > ((gsize) 0);
		} else {
			_tmp22_ = FALSE;
		}
		if (_tmp22_) {
			gchar** lines = NULL;
			GBytes* _tmp30_;
			gsize _tmp31_ = 0;
			guint8* _tmp32_;
			gchar** _tmp33_;
			gchar** _tmp34_;
			gint lines_length1;
			gint _lines_size_;
			gchar* old = NULL;
			const gchar* _tmp35_;
			gchar* _tmp36_;
			gchar** _tmp37_;
			gint _tmp37__length1;
			const gchar* _tmp38_;
			const gchar* _tmp39_;
			gchar** _tmp40_;
			gint _tmp40__length1;
			const gchar* _tmp41_;
			_tmp30_ = stdout_buf;
			_tmp32_ = g_bytes_get_data (_tmp30_, &_tmp31_);
			_tmp34_ = _tmp33_ = g_strsplit ((const gchar*) _tmp32_, "\n", 0);
			lines = _tmp34_;
			lines_length1 = _vala_array_length (_tmp33_);
			_lines_size_ = lines_length1;
			_tmp35_ = setlocale (LC_NUMERIC, "C");
			_tmp36_ = g_strdup (_tmp35_);
			old = _tmp36_;
			_tmp37_ = lines;
			_tmp37__length1 = lines_length1;
			_tmp38_ = _tmp37_[0];
			self->priv->clip_duration = double_parse (_tmp38_);
			_tmp39_ = old;
			setlocale (LC_NUMERIC, _tmp39_);
			_tmp40_ = lines;
			_tmp40__length1 = lines_length1;
			_tmp41_ = _tmp40_[1];
			if (g_strcmp0 (_tmp41_, "none") != 0) {
				gchar** _tmp42_;
				gint _tmp42__length1;
				const gchar* _tmp43_;
				GDateTime* _tmp44_;
				GDateTime* _tmp45_;
				_tmp42_ = lines;
				_tmp42__length1 = lines_length1;
				_tmp43_ = _tmp42_[1];
				_tmp44_ = g_date_time_new_from_iso8601 (_tmp43_, NULL);
				_tmp45_ = _tmp44_;
				video_reader_set_timestamp (self, _tmp45_);
				_g_date_time_unref0 (_tmp45_);
			}
			_g_free0 (old);
			lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
		} else {
			gchar* message = NULL;
			gchar* _tmp46_;
			gboolean _tmp47_ = FALSE;
			GBytes* _tmp48_;
			_tmp46_ = g_strdup ("");
			message = _tmp46_;
			_tmp48_ = stderr_buf;
			if (_tmp48_ != NULL) {
				GBytes* _tmp49_;
				_tmp49_ = stderr_buf;
				_tmp47_ = g_bytes_get_size (_tmp49_) > ((gsize) 0);
			} else {
				_tmp47_ = FALSE;
			}
			if (_tmp47_) {
				GBytes* _tmp50_;
				gsize _tmp51_ = 0;
				guint8* _tmp52_;
				gchar* _tmp53_;
				_tmp50_ = stderr_buf;
				_tmp52_ = g_bytes_get_data (_tmp50_, &_tmp51_);
				_tmp53_ = g_strdup ((const gchar*) _tmp52_);
				_g_free0 (message);
				message = _tmp53_;
			}
			g_warning ("VideoReader.vala:213: External Metadata helper failed");
			_g_free0 (message);
		}
		_g_object_unref0 (process);
		_g_bytes_unref0 (stderr_buf);
		_g_bytes_unref0 (stdout_buf);
		block17_data_unref (_data17_);
		_data17_ = NULL;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp54_;
		const gchar* _tmp55_;
		GError* _tmp56_;
		const gchar* _tmp57_;
		gchar* _tmp58_;
		gchar* _tmp59_;
		GError* _tmp60_;
		GError* _tmp61_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp54_ = e;
		_tmp55_ = _tmp54_->message;
		g_debug ("VideoReader.vala:216: Video read error: %s", _tmp55_);
		_tmp56_ = e;
		_tmp57_ = _tmp56_->message;
		_tmp58_ = g_strdup_printf ("GStreamer couldn't extract clip information: %s", _tmp57_);
		_tmp59_ = _tmp58_;
		_tmp60_ = g_error_new_literal (VIDEO_ERROR, VIDEO_ERROR_CONTENTS, _tmp59_);
		_tmp61_ = _tmp60_;
		_g_free0 (_tmp59_);
		_inner_error0_ = _tmp61_;
		_g_error_free0 (e);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VIDEO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			block16_data_unref (_data16_);
			_data16_ = NULL;
			return;
		} else {
			block16_data_unref (_data16_);
			_data16_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	if (_data16_->id != ((guint) 0)) {
		g_source_remove (_data16_->id);
	}
	block16_data_unref (_data16_);
	_data16_ = NULL;
}

static gboolean
video_reader_on_thumbnailer_timer (VideoReader* self)
{
	GSubprocess* _tmp0_;
	gboolean result;
	g_return_val_if_fail (IS_VIDEO_READER (self), FALSE);
	g_debug ("VideoReader.vala:228: Thumbnailer timer called");
	_tmp0_ = self->priv->thumbnailer_process;
	if (_tmp0_ != NULL) {
		GSubprocess* _tmp1_;
		_tmp1_ = self->priv->thumbnailer_process;
		g_subprocess_force_exit (_tmp1_);
	}
	result = FALSE;
	return result;
}

static gboolean
_video_reader_on_thumbnailer_timer_gsource_func (gpointer self)
{
	gboolean result;
	result = video_reader_on_thumbnailer_timer ((VideoReader*) self);
	return result;
}

static GdkPixbuf*
video_reader_thumbnailer (VideoReader* self,
                          const gchar* video_file)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GFileIOStream* stream = NULL;
	GFile* output_file = NULL;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	g_return_val_if_fail (IS_VIDEO_READER (self), NULL);
	g_return_val_if_fail (video_file != NULL, NULL);
	_tmp0_ = app_dirs_get_thumbnailer_bin ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_get_path (_tmp1_);
	_tmp3_ = _tmp2_;
	g_debug ("VideoReader.vala:239: Launching thumbnailer process: %s", _tmp3_);
	_g_free0 (_tmp3_);
	_g_object_unref0 (_tmp1_);
	{
		GFile* _tmp4_ = NULL;
		GFileIOStream* _tmp5_ = NULL;
		GFile* _tmp6_;
		GFile* _tmp7_;
		_tmp6_ = g_file_new_tmp (NULL, &_tmp5_, &_inner_error0_);
		_g_object_unref0 (stream);
		stream = _tmp5_;
		_tmp4_ = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp7_ = _tmp4_;
		_tmp4_ = NULL;
		_g_object_unref0 (output_file);
		output_file = _tmp7_;
		_g_object_unref0 (_tmp4_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_debug ("VideoReader.vala:245: Failed to create temporary file: %s", _tmp9_);
		result = NULL;
		_g_error_free0 (e);
		_g_object_unref0 (output_file);
		_g_object_unref0 (stream);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (output_file);
		_g_object_unref0 (stream);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	{
		GSubprocess* _tmp10_ = NULL;
		GFile* _tmp11_;
		GFile* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		GFile* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		GSubprocess* _tmp18_;
		GSubprocess* _tmp19_;
		GSubprocess* _tmp20_;
		_tmp11_ = app_dirs_get_thumbnailer_bin ();
		_tmp12_ = _tmp11_;
		_tmp13_ = g_file_get_path (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = output_file;
		_tmp16_ = g_file_get_path (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = g_subprocess_new (G_SUBPROCESS_FLAGS_NONE, &_inner_error0_, _tmp14_, video_file, _tmp17_, NULL);
		_tmp19_ = _tmp18_;
		_g_free0 (_tmp17_);
		_g_free0 (_tmp14_);
		_g_object_unref0 (_tmp12_);
		_tmp10_ = _tmp19_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp20_ = _tmp10_;
		_tmp10_ = NULL;
		_g_object_unref0 (self->priv->thumbnailer_process);
		self->priv->thumbnailer_process = _tmp20_;
		_g_object_unref0 (_tmp10_);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp21_;
		const gchar* _tmp22_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp21_ = e;
		_tmp22_ = _tmp21_->message;
		g_debug ("VideoReader.vala:253: Error spawning process: %s", _tmp22_);
		result = NULL;
		_g_error_free0 (e);
		_g_object_unref0 (output_file);
		_g_object_unref0 (stream);
		return result;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (output_file);
		_g_object_unref0 (stream);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	g_timeout_add_full (G_PRIORITY_DEFAULT, VIDEO_READER_THUMBNAILER_TIMEOUT, _video_reader_on_thumbnailer_timer_gsource_func, video_reader_ref (self), video_reader_unref);
	{
		GSubprocess* _tmp23_;
		GdkPixbuf* buf = NULL;
		_tmp23_ = self->priv->thumbnailer_process;
		g_subprocess_wait_check (_tmp23_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch2_g_error;
		}
		buf = NULL;
		{
			GdkPixbuf* _tmp24_ = NULL;
			GFileIOStream* _tmp25_;
			GInputStream* _tmp26_;
			GdkPixbuf* _tmp27_;
			GdkPixbuf* _tmp28_;
			_tmp25_ = stream;
			_tmp26_ = g_io_stream_get_input_stream (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, g_io_stream_get_type (), GIOStream));
			_tmp27_ = gdk_pixbuf_new_from_stream (_tmp26_, NULL, &_inner_error0_);
			_tmp24_ = _tmp27_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch3_g_error;
			}
			_tmp28_ = _tmp24_;
			_tmp24_ = NULL;
			_g_object_unref0 (buf);
			buf = _tmp28_;
			result = buf;
			_g_object_unref0 (_tmp24_);
			_g_object_unref0 (output_file);
			_g_object_unref0 (stream);
			return result;
		}
		goto __finally3;
		__catch3_g_error:
		{
			GError* e = NULL;
			GError* _tmp29_;
			const gchar* _tmp30_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp29_ = e;
			_tmp30_ = _tmp29_->message;
			g_debug ("VideoReader.vala:270: Error creating pixbuf: %s", _tmp30_);
			_g_error_free0 (e);
		}
		__finally3:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (buf);
			goto __catch2_g_error;
		}
		_g_object_unref0 (buf);
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* err = NULL;
		GError* _tmp31_;
		const gchar* _tmp32_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp31_ = err;
		_tmp32_ = _tmp31_->message;
		g_debug ("VideoReader.vala:273: Thumbnailer process exited with error: %s", _tmp32_);
		_g_error_free0 (err);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (output_file);
		_g_object_unref0 (stream);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	{
		GFile* _tmp33_;
		_tmp33_ = output_file;
		g_file_delete (_tmp33_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch4_g_error;
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* err = NULL;
		GError* _tmp34_;
		const gchar* _tmp35_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp34_ = err;
		_tmp35_ = _tmp34_->message;
		g_debug ("VideoReader.vala:279: Failed to remove temporary file: %s", _tmp35_);
		_g_error_free0 (err);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (output_file);
		_g_object_unref0 (stream);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = NULL;
	_g_object_unref0 (output_file);
	_g_object_unref0 (stream);
	return result;
}

static gboolean
video_reader_does_file_exist (VideoReader* self)
{
	GFile* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	gboolean result;
	g_return_val_if_fail (IS_VIDEO_READER (self), FALSE);
	_tmp0_ = self->priv->file;
	_tmp1_ = g_file_get_path (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_file_test (_tmp2_, G_FILE_TEST_EXISTS | G_FILE_TEST_IS_REGULAR);
	_g_free0 (_tmp2_);
	result = _tmp3_;
	return result;
}

GdkPixbuf*
video_reader_read_preview_frame (VideoReader* self)
{
	GdkPixbuf* _tmp0_;
	GFile* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GdkPixbuf* _tmp6_;
	GdkPixbuf* _tmp7_;
	GdkPixbuf* _tmp9_;
	GdkPixbuf* _tmp10_;
	GdkPixbuf* result;
	g_return_val_if_fail (IS_VIDEO_READER (self), NULL);
	_tmp0_ = self->priv->preview_frame;
	if (_tmp0_ != NULL) {
		GdkPixbuf* _tmp1_;
		GdkPixbuf* _tmp2_;
		_tmp1_ = self->priv->preview_frame;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	}
	if (!video_reader_does_file_exist (self)) {
		result = NULL;
		return result;
	}
	_tmp3_ = self->priv->file;
	_tmp4_ = g_file_get_path (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = video_reader_thumbnailer (self, _tmp5_);
	_g_object_unref0 (self->priv->preview_frame);
	self->priv->preview_frame = _tmp6_;
	_g_free0 (_tmp5_);
	_tmp7_ = self->priv->preview_frame;
	if (NULL == _tmp7_) {
		GdkPixbuf* _tmp8_;
		_tmp8_ = resources_get_noninterpretable_badge_pixbuf ();
		_g_object_unref0 (self->priv->preview_frame);
		self->priv->preview_frame = _tmp8_;
	}
	_tmp9_ = self->priv->preview_frame;
	_tmp10_ = _g_object_ref0 (_tmp9_);
	result = _tmp10_;
	return result;
}

gdouble
video_reader_read_clip_duration (VideoReader* self,
                                 GError** error)
{
	GError* _inner_error0_ = NULL;
	gdouble result;
	g_return_val_if_fail (IS_VIDEO_READER (self), 0.0);
	if (self->priv->clip_duration == VIDEO_READER_UNKNOWN_CLIP_DURATION) {
		video_reader_read_internal (self, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VIDEO_ERROR) {
				gdouble _tmp0_ = -1.0;
				g_propagate_error (error, _inner_error0_);
				return _tmp0_;
			} else {
				gdouble _tmp1_ = -1.0;
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp1_;
			}
		}
	}
	result = self->priv->clip_duration;
	return result;
}

VideoMetadata*
video_reader_read_metadata (VideoReader* self,
                            GError** error)
{
	VideoMetadata* metadata = NULL;
	VideoMetadata* _tmp0_;
	GFile* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GError* _inner_error0_ = NULL;
	VideoMetadata* result;
	g_return_val_if_fail (IS_VIDEO_READER (self), NULL);
	_tmp0_ = video_metadata_new ();
	metadata = _tmp0_;
	_tmp1_ = self->priv->file;
	_tmp2_ = g_file_get_path (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_file_new_for_path (_tmp3_);
	_tmp5_ = _tmp4_;
	media_metadata_read_from_file (G_TYPE_CHECK_INSTANCE_CAST (metadata, TYPE_MEDIA_METADATA, MediaMetadata), _tmp5_, &_inner_error0_);
	_g_object_unref0 (_tmp5_);
	_g_free0 (_tmp3_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_media_metadata_unref0 (metadata);
		return NULL;
	}
	result = metadata;
	return result;
}

GDateTime*
video_reader_get_timestamp (VideoReader* self)
{
	GDateTime* result;
	GDateTime* _tmp0_;
	g_return_val_if_fail (IS_VIDEO_READER (self), NULL);
	_tmp0_ = self->priv->_timestamp;
	result = _tmp0_;
	return result;
}

static void
video_reader_set_timestamp (VideoReader* self,
                            GDateTime* value)
{
	GDateTime* _tmp0_;
	g_return_if_fail (IS_VIDEO_READER (self));
	_tmp0_ = _g_date_time_ref0 (value);
	_g_date_time_unref0 (self->priv->_timestamp);
	self->priv->_timestamp = _tmp0_;
}

static void
value_video_reader_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_video_reader_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		video_reader_unref (value->data[0].v_pointer);
	}
}

static void
value_video_reader_copy_value (const GValue* src_value,
                               GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = video_reader_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_video_reader_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_video_reader_collect_value (GValue* value,
                                  guint n_collect_values,
                                  GTypeCValue* collect_values,
                                  guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		VideoReader * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = video_reader_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_video_reader_lcopy_value (const GValue* value,
                                guint n_collect_values,
                                GTypeCValue* collect_values,
                                guint collect_flags)
{
	VideoReader ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = video_reader_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_video_reader (const gchar* name,
                         const gchar* nick,
                         const gchar* blurb,
                         GType object_type,
                         GParamFlags flags)
{
	ParamSpecVideoReader* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_VIDEO_READER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_video_reader (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_VIDEO_READER), NULL);
	return value->data[0].v_pointer;
}

void
value_set_video_reader (GValue* value,
                        gpointer v_object)
{
	VideoReader * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_VIDEO_READER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_VIDEO_READER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		video_reader_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		video_reader_unref (old);
	}
}

void
value_take_video_reader (GValue* value,
                         gpointer v_object)
{
	VideoReader * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_VIDEO_READER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_VIDEO_READER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		video_reader_unref (old);
	}
}

static void
video_reader_class_init (VideoReaderClass * klass,
                         gpointer klass_data)
{
	video_reader_parent_class = g_type_class_peek_parent (klass);
	((VideoReaderClass *) klass)->finalize = video_reader_finalize;
	g_type_class_adjust_private_offset (klass, &VideoReader_private_offset);
}

static void
video_reader_instance_init (VideoReader * self,
                            gpointer klass)
{
	self->priv = video_reader_get_instance_private (self);
	self->priv->clip_duration = VIDEO_READER_UNKNOWN_CLIP_DURATION;
	self->priv->preview_frame = NULL;
	self->priv->file = NULL;
	self->priv->thumbnailer_process = NULL;
	self->priv->_timestamp = NULL;
	self->ref_count = 1;
}

static void
video_reader_finalize (VideoReader * obj)
{
	VideoReader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VIDEO_READER, VideoReader);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->preview_frame);
	_g_object_unref0 (self->priv->file);
	_g_object_unref0 (self->priv->thumbnailer_process);
	_g_date_time_unref0 (self->priv->_timestamp);
}

static GType
video_reader_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_video_reader_init, value_video_reader_free_value, value_video_reader_copy_value, value_video_reader_peek_pointer, "p", value_video_reader_collect_value, "p", value_video_reader_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (VideoReaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) video_reader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VideoReader), 0, (GInstanceInitFunc) video_reader_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType video_reader_type_id;
	video_reader_type_id = g_type_register_fundamental (g_type_fundamental_next (), "VideoReader", &g_define_type_info, &g_define_type_fundamental_info, 0);
	VideoReader_private_offset = g_type_add_instance_private (video_reader_type_id, sizeof (VideoReaderPrivate));
	return video_reader_type_id;
}

GType
video_reader_get_type (void)
{
	static volatile gsize video_reader_type_id__once = 0;
	if (g_once_init_enter (&video_reader_type_id__once)) {
		GType video_reader_type_id;
		video_reader_type_id = video_reader_get_type_once ();
		g_once_init_leave (&video_reader_type_id__once, video_reader_type_id);
	}
	return video_reader_type_id__once;
}

gpointer
video_reader_ref (gpointer instance)
{
	VideoReader * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
video_reader_unref (gpointer instance)
{
	VideoReader * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VIDEO_READER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

