/* DevicesBox.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from DevicesBox.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-2.0-or-later
 * SPDX-FileCopyrightText: 2024 elementary, Inc. (https://elementary.io)
 */

#include "power.h"
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <granite-7.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	POWER_DEVICES_BOX_0_PROPERTY,
	POWER_DEVICES_BOX_NUM_PROPERTIES
};
static GParamSpec* power_devices_box_properties[POWER_DEVICES_BOX_NUM_PROPERTIES];

#define POWER_DEVICES_BOX_TYPE_DEVICE_ROW (power_devices_box_device_row_get_type ())
#define POWER_DEVICES_BOX_DEVICE_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), POWER_DEVICES_BOX_TYPE_DEVICE_ROW, PowerDevicesBoxDeviceRow))
#define POWER_DEVICES_BOX_DEVICE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), POWER_DEVICES_BOX_TYPE_DEVICE_ROW, PowerDevicesBoxDeviceRowClass))
#define POWER_DEVICES_BOX_IS_DEVICE_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), POWER_DEVICES_BOX_TYPE_DEVICE_ROW))
#define POWER_DEVICES_BOX_IS_DEVICE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), POWER_DEVICES_BOX_TYPE_DEVICE_ROW))
#define POWER_DEVICES_BOX_DEVICE_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), POWER_DEVICES_BOX_TYPE_DEVICE_ROW, PowerDevicesBoxDeviceRowClass))

typedef struct _PowerDevicesBoxDeviceRow PowerDevicesBoxDeviceRow;
typedef struct _PowerDevicesBoxDeviceRowClass PowerDevicesBoxDeviceRowClass;
typedef struct _PowerDevicesBoxDeviceRowPrivate PowerDevicesBoxDeviceRowPrivate;
enum  {
	POWER_DEVICES_BOX_DEVICE_ROW_0_PROPERTY,
	POWER_DEVICES_BOX_DEVICE_ROW_DEVICE_PROPERTY,
	POWER_DEVICES_BOX_DEVICE_ROW_NUM_PROPERTIES
};
static GParamSpec* power_devices_box_device_row_properties[POWER_DEVICES_BOX_DEVICE_ROW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _PowerDevicesBoxDeviceRow {
	GtkGrid parent_instance;
	PowerDevicesBoxDeviceRowPrivate * priv;
};

struct _PowerDevicesBoxDeviceRowClass {
	GtkGridClass parent_class;
};

struct _PowerDevicesBoxDeviceRowPrivate {
	PowerDevice* _device;
	GtkLevelBar* charge_levelbar;
};

struct _Block2Data {
	int _ref_count_;
	PowerDevicesBoxDeviceRow* self;
	GtkImage* charge_image;
	GtkRevealer* charge_revealer;
};

static gpointer power_devices_box_parent_class = NULL;
static gint PowerDevicesBoxDeviceRow_private_offset;
static gpointer power_devices_box_device_row_parent_class = NULL;
static GtkSizeGroup* power_devices_box_device_row_size_group;
static GtkSizeGroup* power_devices_box_device_row_size_group = NULL;

static GtkWidget* power_devices_box_create_widget_func (PowerDevicesBox* self,
                                                 GObject* object);
static PowerDevicesBoxDeviceRow* power_devices_box_device_row_new (PowerDevice* device);
static PowerDevicesBoxDeviceRow* power_devices_box_device_row_construct (GType object_type,
                                                                  PowerDevice* device);
static GType power_devices_box_device_row_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void power_devices_box_device_row_update_levelbar_offsets (PowerDevicesBoxDeviceRow* self);
static PowerDevice* power_devices_box_device_row_get_device (PowerDevicesBoxDeviceRow* self);
static void power_devices_box_device_row_set_device (PowerDevicesBoxDeviceRow* self,
                                              PowerDevice* value);
static GObject * power_devices_box_device_row_constructor (GType type,
                                                    guint n_construct_properties,
                                                    GObjectConstructParam * construct_properties);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gboolean _power_devices_box_device_row____lambda7_ (PowerDevicesBoxDeviceRow* self,
                                                    GBinding* binding,
                                                    GValue* srcval,
                                                    GValue* targetval);
static gboolean __power_devices_box_device_row____lambda7__gbinding_transform_func (GBinding* binding,
                                                                             GValue* from_value,
                                                                             GValue* to_value,
                                                                             gpointer self);
static void _power_devices_box_device_row_update_levelbar_offsets_g_object_notify (GObject* _sender,
                                                                            GParamSpec* pspec,
                                                                            gpointer self);
static void _power_devices_box_device_row___lambda8_ (Block2Data* _data2_);
static void __power_devices_box_device_row___lambda8__g_object_notify (GObject* _sender,
                                                                GParamSpec* pspec,
                                                                gpointer self);
static void power_devices_box_device_row_finalize (GObject * obj);
static GType power_devices_box_device_row_get_type_once (void);
static void _vala_power_devices_box_device_row_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec);
static void _vala_power_devices_box_device_row_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec);
static GObject * power_devices_box_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
static GtkWidget* _power_devices_box_create_widget_func_gtk_list_box_create_widget_func (GObject* item,
                                                                                  gpointer self);
static GType power_devices_box_get_type_once (void);

static GtkWidget*
power_devices_box_create_widget_func (PowerDevicesBox* self,
                                      GObject* object)
{
	PowerDevicesBoxDeviceRow* _tmp0_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (object != NULL, NULL);
	_tmp0_ = power_devices_box_device_row_new (G_TYPE_CHECK_INSTANCE_CAST (object, POWER_TYPE_DEVICE, PowerDevice));
	g_object_ref_sink (_tmp0_);
	result = (GtkWidget*) _tmp0_;
	return result;
}

PowerDevicesBox*
power_devices_box_construct (GType object_type)
{
	PowerDevicesBox * self = NULL;
	self = (PowerDevicesBox*) g_object_new (object_type, NULL);
	return self;
}

PowerDevicesBox*
power_devices_box_new (void)
{
	return power_devices_box_construct (POWER_TYPE_DEVICES_BOX);
}

static inline gpointer
power_devices_box_device_row_get_instance_private (PowerDevicesBoxDeviceRow* self)
{
	return G_STRUCT_MEMBER_P (self, PowerDevicesBoxDeviceRow_private_offset);
}

static PowerDevicesBoxDeviceRow*
power_devices_box_device_row_construct (GType object_type,
                                        PowerDevice* device)
{
	PowerDevicesBoxDeviceRow * self = NULL;
	g_return_val_if_fail (device != NULL, NULL);
	self = (PowerDevicesBoxDeviceRow*) g_object_new (object_type, "device", device, NULL);
	return self;
}

static PowerDevicesBoxDeviceRow*
power_devices_box_device_row_new (PowerDevice* device)
{
	return power_devices_box_device_row_construct (POWER_DEVICES_BOX_TYPE_DEVICE_ROW, device);
}

static void
power_devices_box_device_row_update_levelbar_offsets (PowerDevicesBoxDeviceRow* self)
{
	gboolean _tmp0_ = FALSE;
	PowerDevice* _tmp1_;
	PowerDeviceState _tmp2_;
	PowerDeviceState _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_device;
	_tmp2_ = power_device_get_state (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == POWER_DEVICE_STATE_CHARGING) {
		_tmp0_ = TRUE;
	} else {
		PowerDevice* _tmp4_;
		PowerDeviceState _tmp5_;
		PowerDeviceState _tmp6_;
		_tmp4_ = self->priv->_device;
		_tmp5_ = power_device_get_state (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_ == POWER_DEVICE_STATE_FULLY_CHARGED;
	}
	if (_tmp0_) {
		GtkLevelBar* _tmp7_;
		GtkLevelBar* _tmp8_;
		GtkLevelBar* _tmp9_;
		_tmp7_ = self->priv->charge_levelbar;
		gtk_level_bar_remove_offset_value (_tmp7_, "high");
		_tmp8_ = self->priv->charge_levelbar;
		gtk_level_bar_remove_offset_value (_tmp8_, "middle");
		_tmp9_ = self->priv->charge_levelbar;
		gtk_level_bar_remove_offset_value (_tmp9_, "low");
	} else {
		GtkLevelBar* _tmp10_;
		GtkLevelBarMode _tmp11_;
		GtkLevelBarMode _tmp12_;
		_tmp10_ = self->priv->charge_levelbar;
		_tmp11_ = gtk_level_bar_get_mode (_tmp10_);
		_tmp12_ = _tmp11_;
		if (_tmp12_ == GTK_LEVEL_BAR_MODE_CONTINUOUS) {
			GtkLevelBar* _tmp13_;
			GtkLevelBar* _tmp14_;
			GtkLevelBar* _tmp15_;
			_tmp13_ = self->priv->charge_levelbar;
			gtk_level_bar_add_offset_value (_tmp13_, "high", (gdouble) 99);
			_tmp14_ = self->priv->charge_levelbar;
			gtk_level_bar_add_offset_value (_tmp14_, "middle", (gdouble) 20);
			_tmp15_ = self->priv->charge_levelbar;
			gtk_level_bar_add_offset_value (_tmp15_, "low", (gdouble) 10);
		} else {
			GtkLevelBar* _tmp16_;
			GtkLevelBar* _tmp17_;
			GtkLevelBar* _tmp18_;
			_tmp16_ = self->priv->charge_levelbar;
			gtk_level_bar_add_offset_value (_tmp16_, "high", (gdouble) 3);
			_tmp17_ = self->priv->charge_levelbar;
			gtk_level_bar_add_offset_value (_tmp17_, "middle", (gdouble) 2);
			_tmp18_ = self->priv->charge_levelbar;
			gtk_level_bar_add_offset_value (_tmp18_, "low", (gdouble) 1);
		}
	}
}

static PowerDevice*
power_devices_box_device_row_get_device (PowerDevicesBoxDeviceRow* self)
{
	PowerDevice* result;
	PowerDevice* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_device;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
power_devices_box_device_row_set_device (PowerDevicesBoxDeviceRow* self,
                                         PowerDevice* value)
{
	PowerDevice* old_value;
	g_return_if_fail (self != NULL);
	old_value = power_devices_box_device_row_get_device (self);
	if (old_value != value) {
		PowerDevice* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_device);
		self->priv->_device = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, power_devices_box_device_row_properties[POWER_DEVICES_BOX_DEVICE_ROW_DEVICE_PROPERTY]);
	}
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		PowerDevicesBoxDeviceRow* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->charge_revealer);
		_g_object_unref0 (_data2_->charge_image);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static gboolean
_power_devices_box_device_row____lambda7_ (PowerDevicesBoxDeviceRow* self,
                                           GBinding* binding,
                                           GValue* srcval,
                                           GValue* targetval)
{
	GValue _tmp0_;
	gboolean result;
	g_return_val_if_fail (binding != NULL, FALSE);
	g_return_val_if_fail (srcval != NULL, FALSE);
	g_return_val_if_fail (targetval != NULL, FALSE);
	_tmp0_ = *srcval;
	g_value_set_double (targetval, g_value_get_double (&_tmp0_) / 20);
	result = TRUE;
	return result;
}

static gboolean
__power_devices_box_device_row____lambda7__gbinding_transform_func (GBinding* binding,
                                                                    GValue* from_value,
                                                                    GValue* to_value,
                                                                    gpointer self)
{
	gboolean result;
	result = _power_devices_box_device_row____lambda7_ ((PowerDevicesBoxDeviceRow*) self, binding, from_value, to_value);
	return result;
}

static void
_power_devices_box_device_row_update_levelbar_offsets_g_object_notify (GObject* _sender,
                                                                       GParamSpec* pspec,
                                                                       gpointer self)
{
	power_devices_box_device_row_update_levelbar_offsets ((PowerDevicesBoxDeviceRow*) self);
}

static void
_power_devices_box_device_row___lambda8_ (Block2Data* _data2_)
{
	PowerDevicesBoxDeviceRow* self;
	GtkImage* _tmp0_;
	PowerDevice* _tmp1_;
	PowerDeviceState _tmp2_;
	PowerDeviceState _tmp3_;
	GIcon* _tmp4_;
	GIcon* _tmp5_;
	GtkImage* _tmp6_;
	PowerDevice* _tmp7_;
	PowerDeviceState _tmp8_;
	PowerDeviceState _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GtkRevealer* _tmp12_;
	PowerDevice* _tmp13_;
	PowerDeviceState _tmp14_;
	PowerDeviceState _tmp15_;
	GIcon* _tmp16_;
	GIcon* _tmp17_;
	self = _data2_->self;
	_tmp0_ = _data2_->charge_image;
	_tmp1_ = self->priv->_device;
	_tmp2_ = power_device_get_state (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = power_device_state_to_icon (_tmp3_);
	_tmp5_ = _tmp4_;
	g_object_set (_tmp0_, "gicon", _tmp5_, NULL);
	_g_object_unref0 (_tmp5_);
	_tmp6_ = _data2_->charge_image;
	_tmp7_ = self->priv->_device;
	_tmp8_ = power_device_get_state (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = power_device_state_to_string (_tmp9_);
	_tmp11_ = _tmp10_;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp6_, _tmp11_);
	_g_free0 (_tmp11_);
	_tmp12_ = _data2_->charge_revealer;
	_tmp13_ = self->priv->_device;
	_tmp14_ = power_device_get_state (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = power_device_state_to_icon (_tmp15_);
	_tmp17_ = _tmp16_;
	gtk_revealer_set_reveal_child (_tmp12_, _tmp17_ != NULL);
	_g_object_unref0 (_tmp17_);
}

static void
__power_devices_box_device_row___lambda8__g_object_notify (GObject* _sender,
                                                           GParamSpec* pspec,
                                                           gpointer self)
{
	_power_devices_box_device_row___lambda8_ (self);
}

static GObject *
power_devices_box_device_row_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PowerDevicesBoxDeviceRow * self;
	Block2Data* _data2_;
	GtkImage* image = NULL;
	PowerDevice* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GtkImage* _tmp3_ = NULL;
	GtkLabel* name_label = NULL;
	GtkLabel* _tmp4_ = NULL;
	GtkLabel* charge_label = NULL;
	GtkLabel* _tmp5_ = NULL;
	GtkLabel* _tmp6_;
	GtkLabel* _tmp7_;
	PowerDevice* _tmp8_;
	PowerDeviceState _tmp9_;
	PowerDeviceState _tmp10_;
	GIcon* _tmp11_;
	GIcon* _tmp12_;
	PowerDevice* _tmp13_;
	PowerDeviceState _tmp14_;
	PowerDeviceState _tmp15_;
	gchar* _tmp16_;
	GtkImage* _tmp17_ = NULL;
	GtkImage* _tmp18_;
	GtkImage* _tmp19_;
	GtkWidget* _tmp20_;
	PowerDevice* _tmp21_;
	PowerDeviceState _tmp22_;
	PowerDeviceState _tmp23_;
	GIcon* _tmp24_;
	GIcon* _tmp25_;
	GtkRevealer* _tmp26_ = NULL;
	GtkRevealer* _tmp27_;
	GtkLevelBar* _tmp28_ = NULL;
	PowerDevice* _tmp29_;
	gboolean _tmp30_;
	gboolean _tmp31_;
	GtkImage* _tmp40_;
	GtkLabel* _tmp41_;
	GtkLabel* _tmp42_;
	GtkRevealer* _tmp43_;
	GtkLevelBar* _tmp44_;
	GtkSizeGroup* _tmp45_;
	GtkLabel* _tmp46_;
	GtkSizeGroup* _tmp47_;
	GtkLabel* _tmp48_;
	PowerDevice* _tmp49_;
	GtkLabel* _tmp50_;
	PowerDevice* _tmp51_;
	GtkLabel* _tmp52_;
	PowerDevice* _tmp53_;
	PowerDevice* _tmp54_;
	parent_class = G_OBJECT_CLASS (power_devices_box_device_row_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, POWER_DEVICES_BOX_TYPE_DEVICE_ROW, PowerDevicesBoxDeviceRow);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = self->priv->_device;
	_tmp1_ = power_device_get_icon_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = (GtkImage*) gtk_image_new_from_icon_name (_tmp2_);
	gtk_image_set_icon_size (_tmp3_, GTK_ICON_SIZE_LARGE);
	g_object_set (_tmp3_, "use-fallback", TRUE, NULL);
	g_object_ref_sink (_tmp3_);
	image = _tmp3_;
	_tmp4_ = (GtkLabel*) gtk_label_new ("");
	gtk_widget_set_margin_end ((GtkWidget*) _tmp4_, 12);
	gtk_label_set_xalign (_tmp4_, (gfloat) 0);
	g_object_ref_sink (_tmp4_);
	name_label = _tmp4_;
	_tmp5_ = (GtkLabel*) gtk_label_new ("");
	gtk_label_set_xalign (_tmp5_, (gfloat) 0);
	g_object_ref_sink (_tmp5_);
	charge_label = _tmp5_;
	_tmp6_ = charge_label;
	gtk_widget_add_css_class ((GtkWidget*) _tmp6_, GRANITE_STYLE_CLASS_DIM_LABEL);
	_tmp7_ = charge_label;
	gtk_widget_add_css_class ((GtkWidget*) _tmp7_, GRANITE_STYLE_CLASS_SMALL_LABEL);
	_tmp8_ = self->priv->_device;
	_tmp9_ = power_device_get_state (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = power_device_state_to_icon (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = self->priv->_device;
	_tmp14_ = power_device_get_state (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = power_device_state_to_string (_tmp15_);
	_tmp17_ = (GtkImage*) gtk_image_new_from_gicon (_tmp12_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp17_, _tmp16_);
	_g_free0 (_tmp16_);
	g_object_ref_sink (_tmp17_);
	_tmp18_ = _tmp17_;
	_g_object_unref0 (_tmp12_);
	_data2_->charge_image = _tmp18_;
	_tmp19_ = _data2_->charge_image;
	_tmp20_ = _g_object_ref0 ((GtkWidget*) _tmp19_);
	_tmp21_ = self->priv->_device;
	_tmp22_ = power_device_get_state (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = power_device_state_to_icon (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = (GtkRevealer*) gtk_revealer_new ();
	gtk_revealer_set_child (_tmp26_, _tmp20_);
	_g_object_unref0 (_tmp20_);
	gtk_revealer_set_transition_type (_tmp26_, GTK_REVEALER_TRANSITION_TYPE_CROSSFADE);
	gtk_revealer_set_reveal_child (_tmp26_, _tmp25_ != NULL);
	g_object_ref_sink (_tmp26_);
	_tmp27_ = _tmp26_;
	_g_object_unref0 (_tmp25_);
	_data2_->charge_revealer = _tmp27_;
	_tmp28_ = (GtkLevelBar*) gtk_level_bar_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp28_, TRUE);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp28_, 6);
	gtk_level_bar_set_min_value (_tmp28_, (gdouble) 0);
	gtk_widget_set_valign ((GtkWidget*) _tmp28_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp28_);
	_g_object_unref0 (self->priv->charge_levelbar);
	self->priv->charge_levelbar = _tmp28_;
	_tmp29_ = self->priv->_device;
	_tmp30_ = power_device_get_coarse_battery_level (_tmp29_);
	_tmp31_ = _tmp30_;
	if (!_tmp31_) {
		GtkLevelBar* _tmp32_;
		GtkLevelBar* _tmp33_;
		PowerDevice* _tmp34_;
		GtkLevelBar* _tmp35_;
		_tmp32_ = self->priv->charge_levelbar;
		gtk_level_bar_set_max_value (_tmp32_, (gdouble) 100);
		_tmp33_ = self->priv->charge_levelbar;
		gtk_level_bar_add_offset_value (_tmp33_, "full", (gdouble) 100);
		_tmp34_ = self->priv->_device;
		_tmp35_ = self->priv->charge_levelbar;
		g_object_bind_property_with_closures ((GObject*) _tmp34_, "percentage", (GObject*) _tmp35_, "value", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	} else {
		GtkLevelBar* _tmp36_;
		GtkLevelBar* _tmp37_;
		PowerDevice* _tmp38_;
		GtkLevelBar* _tmp39_;
		_tmp36_ = self->priv->charge_levelbar;
		gtk_level_bar_set_max_value (_tmp36_, (gdouble) 5);
		_tmp37_ = self->priv->charge_levelbar;
		gtk_level_bar_set_mode (_tmp37_, GTK_LEVEL_BAR_MODE_DISCRETE);
		_tmp38_ = self->priv->_device;
		_tmp39_ = self->priv->charge_levelbar;
		g_object_bind_property_with_closures ((GObject*) _tmp38_, "percentage", (GObject*) _tmp39_, "value", G_BINDING_SYNC_CREATE, (GClosure*) ((__power_devices_box_device_row____lambda7__gbinding_transform_func == NULL) ? NULL : g_cclosure_new ((GCallback) __power_devices_box_device_row____lambda7__gbinding_transform_func, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	}
	gtk_grid_set_column_spacing ((GtkGrid*) self, 6);
	_tmp40_ = image;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp40_, 0, 0, 1, 2);
	_tmp41_ = name_label;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp41_, 1, 0, 1, 1);
	_tmp42_ = charge_label;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp42_, 1, 1, 1, 1);
	_tmp43_ = _data2_->charge_revealer;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp43_, 2, 0, 1, 2);
	_tmp44_ = self->priv->charge_levelbar;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp44_, 3, 0, 1, 2);
	_tmp45_ = power_devices_box_device_row_size_group;
	_tmp46_ = name_label;
	gtk_size_group_add_widget (_tmp45_, (GtkWidget*) _tmp46_);
	_tmp47_ = power_devices_box_device_row_size_group;
	_tmp48_ = charge_label;
	gtk_size_group_add_widget (_tmp47_, (GtkWidget*) _tmp48_);
	_tmp49_ = self->priv->_device;
	_tmp50_ = name_label;
	g_object_bind_property_with_closures ((GObject*) _tmp49_, "model", (GObject*) _tmp50_, "label", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp51_ = self->priv->_device;
	_tmp52_ = charge_label;
	g_object_bind_property_with_closures ((GObject*) _tmp51_, "description", (GObject*) _tmp52_, "label", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	power_devices_box_device_row_update_levelbar_offsets (self);
	_tmp53_ = self->priv->_device;
	g_signal_connect_object ((GObject*) _tmp53_, "notify::state", (GCallback) _power_devices_box_device_row_update_levelbar_offsets_g_object_notify, self, 0);
	_tmp54_ = self->priv->_device;
	g_signal_connect_data ((GObject*) _tmp54_, "notify::state", (GCallback) __power_devices_box_device_row___lambda8__g_object_notify, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_g_object_unref0 (charge_label);
	_g_object_unref0 (name_label);
	_g_object_unref0 (image);
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return obj;
}

static void
power_devices_box_device_row_class_init (PowerDevicesBoxDeviceRowClass * klass,
                                         gpointer klass_data)
{
	GtkSizeGroup* _tmp0_;
	power_devices_box_device_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PowerDevicesBoxDeviceRow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_power_devices_box_device_row_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_power_devices_box_device_row_set_property;
	G_OBJECT_CLASS (klass)->constructor = power_devices_box_device_row_constructor;
	G_OBJECT_CLASS (klass)->finalize = power_devices_box_device_row_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_DEVICES_BOX_DEVICE_ROW_DEVICE_PROPERTY, power_devices_box_device_row_properties[POWER_DEVICES_BOX_DEVICE_ROW_DEVICE_PROPERTY] = g_param_spec_object ("device", "device", "device", POWER_TYPE_DEVICE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	_tmp0_ = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
	_g_object_unref0 (power_devices_box_device_row_size_group);
	power_devices_box_device_row_size_group = _tmp0_;
}

static void
power_devices_box_device_row_instance_init (PowerDevicesBoxDeviceRow * self,
                                            gpointer klass)
{
	self->priv = power_devices_box_device_row_get_instance_private (self);
}

static void
power_devices_box_device_row_finalize (GObject * obj)
{
	PowerDevicesBoxDeviceRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, POWER_DEVICES_BOX_TYPE_DEVICE_ROW, PowerDevicesBoxDeviceRow);
	_g_object_unref0 (self->priv->_device);
	_g_object_unref0 (self->priv->charge_levelbar);
	G_OBJECT_CLASS (power_devices_box_device_row_parent_class)->finalize (obj);
}

static GType
power_devices_box_device_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PowerDevicesBoxDeviceRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) power_devices_box_device_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PowerDevicesBoxDeviceRow), 0, (GInstanceInitFunc) power_devices_box_device_row_instance_init, NULL };
	GType power_devices_box_device_row_type_id;
	power_devices_box_device_row_type_id = g_type_register_static (gtk_grid_get_type (), "PowerDevicesBoxDeviceRow", &g_define_type_info, 0);
	PowerDevicesBoxDeviceRow_private_offset = g_type_add_instance_private (power_devices_box_device_row_type_id, sizeof (PowerDevicesBoxDeviceRowPrivate));
	return power_devices_box_device_row_type_id;
}

static GType
power_devices_box_device_row_get_type (void)
{
	static volatile gsize power_devices_box_device_row_type_id__once = 0;
	if (g_once_init_enter (&power_devices_box_device_row_type_id__once)) {
		GType power_devices_box_device_row_type_id;
		power_devices_box_device_row_type_id = power_devices_box_device_row_get_type_once ();
		g_once_init_leave (&power_devices_box_device_row_type_id__once, power_devices_box_device_row_type_id);
	}
	return power_devices_box_device_row_type_id__once;
}

static void
_vala_power_devices_box_device_row_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec)
{
	PowerDevicesBoxDeviceRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, POWER_DEVICES_BOX_TYPE_DEVICE_ROW, PowerDevicesBoxDeviceRow);
	switch (property_id) {
		case POWER_DEVICES_BOX_DEVICE_ROW_DEVICE_PROPERTY:
		g_value_set_object (value, power_devices_box_device_row_get_device (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_power_devices_box_device_row_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec)
{
	PowerDevicesBoxDeviceRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, POWER_DEVICES_BOX_TYPE_DEVICE_ROW, PowerDevicesBoxDeviceRow);
	switch (property_id) {
		case POWER_DEVICES_BOX_DEVICE_ROW_DEVICE_PROPERTY:
		power_devices_box_device_row_set_device (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static GtkWidget*
_power_devices_box_create_widget_func_gtk_list_box_create_widget_func (GObject* item,
                                                                       gpointer self)
{
	GtkWidget* result;
	result = power_devices_box_create_widget_func ((PowerDevicesBox*) self, item);
	return result;
}

static GObject *
power_devices_box_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PowerDevicesBox * self;
	GtkLabel* placeholder = NULL;
	GtkLabel* _tmp0_ = NULL;
	GtkLabel* _tmp1_;
	GtkListBox* devices_box = NULL;
	GtkListBox* _tmp2_ = NULL;
	GtkListBox* _tmp3_;
	PowerPowerManager* _tmp4_;
	GListStore* _tmp5_;
	GListStore* _tmp6_;
	GtkListBox* _tmp7_;
	GtkLabel* _tmp8_;
	GtkListBox* _tmp9_;
	GtkListBox* _tmp10_;
	GraniteHeaderLabel* header = NULL;
	GtkListBox* _tmp11_;
	GtkWidget* _tmp12_;
	GraniteHeaderLabel* _tmp13_ = NULL;
	GraniteHeaderLabel* _tmp14_;
	GtkListBox* _tmp15_;
	parent_class = G_OBJECT_CLASS (power_devices_box_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, POWER_TYPE_DEVICES_BOX, PowerDevicesBox);
	_tmp0_ = (GtkLabel*) gtk_label_new (_ ("Devices that report battery information when plugged in or connected w" \
"irelessly will appear here"));
	gtk_label_set_wrap (_tmp0_, TRUE);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp0_, 12);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp0_, 12);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp0_, 12);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp0_, 12);
	g_object_ref_sink (_tmp0_);
	placeholder = _tmp0_;
	_tmp1_ = placeholder;
	gtk_widget_add_css_class ((GtkWidget*) _tmp1_, GRANITE_STYLE_CLASS_DIM_LABEL);
	_tmp2_ = (GtkListBox*) gtk_list_box_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp2_, TRUE);
	g_object_ref_sink (_tmp2_);
	devices_box = _tmp2_;
	_tmp3_ = devices_box;
	_tmp4_ = power_power_manager_get_default ();
	_tmp5_ = power_power_manager_get_devices (_tmp4_);
	_tmp6_ = _tmp5_;
	gtk_list_box_bind_model (_tmp3_, (GListModel*) _tmp6_, _power_devices_box_create_widget_func_gtk_list_box_create_widget_func, g_object_ref (self), g_object_unref);
	_tmp7_ = devices_box;
	_tmp8_ = placeholder;
	gtk_list_box_set_placeholder (_tmp7_, (GtkWidget*) _tmp8_);
	_tmp9_ = devices_box;
	gtk_widget_add_css_class ((GtkWidget*) _tmp9_, GRANITE_STYLE_CLASS_RICH_LIST);
	_tmp10_ = devices_box;
	gtk_widget_add_css_class ((GtkWidget*) _tmp10_, GRANITE_STYLE_CLASS_FRAME);
	_tmp11_ = devices_box;
	_tmp12_ = _g_object_ref0 ((GtkWidget*) _tmp11_);
	_tmp13_ = granite_header_label_new (_ ("Connected Devices"));
	granite_header_label_set_mnemonic_widget (_tmp13_, _tmp12_);
	_g_object_unref0 (_tmp12_);
	g_object_ref_sink (_tmp13_);
	header = _tmp13_;
	gtk_grid_set_column_spacing ((GtkGrid*) self, 12);
	gtk_grid_set_row_spacing ((GtkGrid*) self, 6);
	_tmp14_ = header;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp14_, 0, 0, 2, 1);
	_tmp15_ = devices_box;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp15_, 0, 1, 2, 1);
	_g_object_unref0 (header);
	_g_object_unref0 (devices_box);
	_g_object_unref0 (placeholder);
	return obj;
}

static void
power_devices_box_class_init (PowerDevicesBoxClass * klass,
                              gpointer klass_data)
{
	power_devices_box_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->constructor = power_devices_box_constructor;
}

static void
power_devices_box_instance_init (PowerDevicesBox * self,
                                 gpointer klass)
{
}

static GType
power_devices_box_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PowerDevicesBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) power_devices_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PowerDevicesBox), 0, (GInstanceInitFunc) power_devices_box_instance_init, NULL };
	GType power_devices_box_type_id;
	power_devices_box_type_id = g_type_register_static (gtk_grid_get_type (), "PowerDevicesBox", &g_define_type_info, 0);
	return power_devices_box_type_id;
}

GType
power_devices_box_get_type (void)
{
	static volatile gsize power_devices_box_type_id__once = 0;
	if (g_once_init_enter (&power_devices_box_type_id__once)) {
		GType power_devices_box_type_id;
		power_devices_box_type_id = power_devices_box_get_type_once ();
		g_once_init_leave (&power_devices_box_type_id__once, power_devices_box_type_id);
	}
	return power_devices_box_type_id__once;
}

