// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.

// Code generated by "deep-copy -type EventSinkV1Alpha1 -type EnvironmentV1Alpha1 -type KmsgLogV1Alpha1 -type OOMV1Alpha1 -type WatchdogTimerV1Alpha1 -pointer-receiver -header-file ../../../../../hack/boilerplate.txt -o deep_copy.generated.go ."; DO NOT EDIT.

package runtime

import (
	"net/url"
)

// DeepCopy generates a deep copy of *EventSinkV1Alpha1.
func (o *EventSinkV1Alpha1) DeepCopy() *EventSinkV1Alpha1 {
	var cp EventSinkV1Alpha1 = *o
	return &cp
}

// DeepCopy generates a deep copy of *EnvironmentV1Alpha1.
func (o *EnvironmentV1Alpha1) DeepCopy() *EnvironmentV1Alpha1 {
	var cp EnvironmentV1Alpha1 = *o
	if o.EnvironmentVariables != nil {
		cp.EnvironmentVariables = make(map[string]string, len(o.EnvironmentVariables))
		for k2, v2 := range o.EnvironmentVariables {
			cp.EnvironmentVariables[k2] = v2
		}
	}
	return &cp
}

// DeepCopy generates a deep copy of *KmsgLogV1Alpha1.
func (o *KmsgLogV1Alpha1) DeepCopy() *KmsgLogV1Alpha1 {
	var cp KmsgLogV1Alpha1 = *o
	if o.KmsgLogURL.URL != nil {
		cp.KmsgLogURL.URL = new(url.URL)
		*cp.KmsgLogURL.URL = *o.KmsgLogURL.URL
		if o.KmsgLogURL.URL.User != nil {
			cp.KmsgLogURL.URL.User = new(url.Userinfo)
			*cp.KmsgLogURL.URL.User = *o.KmsgLogURL.URL.User
		}
	}
	return &cp
}

// DeepCopy generates a deep copy of *OOMV1Alpha1.
func (o *OOMV1Alpha1) DeepCopy() *OOMV1Alpha1 {
	var cp OOMV1Alpha1 = *o
	return &cp
}

// DeepCopy generates a deep copy of *WatchdogTimerV1Alpha1.
func (o *WatchdogTimerV1Alpha1) DeepCopy() *WatchdogTimerV1Alpha1 {
	var cp WatchdogTimerV1Alpha1 = *o
	return &cp
}
