/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1beta1

import (
	certificatesv1beta1 "k8s.io/api/certificates/v1beta1"
)

// CertificateSigningRequestSpecApplyConfiguration represents a declarative configuration of the CertificateSigningRequestSpec type for use
// with apply.
//
// CertificateSigningRequestSpec contains the certificate request.
type CertificateSigningRequestSpecApplyConfiguration struct {
	// Base64-encoded PKCS#10 CSR data
	Request []byte `json:"request,omitempty"`
	// Requested signer for the request. It is a qualified name in the form:
	// `scope-hostname.io/name`.
	// If empty, it will be defaulted:
	// 1. If it's a kubelet client certificate, it is assigned
	// "kubernetes.io/kube-apiserver-client-kubelet".
	// 2. If it's a kubelet serving certificate, it is assigned
	// "kubernetes.io/kubelet-serving".
	// 3. Otherwise, it is assigned "kubernetes.io/legacy-unknown".
	// Distribution of trust for signers happens out of band.
	// You can select on this field using `spec.signerName`.
	SignerName *string `json:"signerName,omitempty"`
	// expirationSeconds is the requested duration of validity of the issued
	// certificate. The certificate signer may issue a certificate with a different
	// validity duration so a client must check the delta between the notBefore and
	// and notAfter fields in the issued certificate to determine the actual duration.
	//
	// The v1.22+ in-tree implementations of the well-known Kubernetes signers will
	// honor this field as long as the requested duration is not greater than the
	// maximum duration they will honor per the --cluster-signing-duration CLI
	// flag to the Kubernetes controller manager.
	//
	// Certificate signers may not honor this field for various reasons:
	//
	// 1. Old signer that is unaware of the field (such as the in-tree
	// implementations prior to v1.22)
	// 2. Signer whose configured maximum is shorter than the requested duration
	// 3. Signer whose configured minimum is longer than the requested duration
	//
	// The minimum valid value for expirationSeconds is 600, i.e. 10 minutes.
	ExpirationSeconds *int32 `json:"expirationSeconds,omitempty"`
	// allowedUsages specifies a set of usage contexts the key will be
	// valid for.
	// See:
	// https://tools.ietf.org/html/rfc5280#section-4.2.1.3
	// https://tools.ietf.org/html/rfc5280#section-4.2.1.12
	//
	// Valid values are:
	// "signing",
	// "digital signature",
	// "content commitment",
	// "key encipherment",
	// "key agreement",
	// "data encipherment",
	// "cert sign",
	// "crl sign",
	// "encipher only",
	// "decipher only",
	// "any",
	// "server auth",
	// "client auth",
	// "code signing",
	// "email protection",
	// "s/mime",
	// "ipsec end system",
	// "ipsec tunnel",
	// "ipsec user",
	// "timestamping",
	// "ocsp signing",
	// "microsoft sgc",
	// "netscape sgc"
	Usages []certificatesv1beta1.KeyUsage `json:"usages,omitempty"`
	// Information about the requesting user.
	// See user.Info interface for details.
	Username *string `json:"username,omitempty"`
	// UID information about the requesting user.
	// See user.Info interface for details.
	UID *string `json:"uid,omitempty"`
	// Group information about the requesting user.
	// See user.Info interface for details.
	Groups []string `json:"groups,omitempty"`
	// Extra information about the requesting user.
	// See user.Info interface for details.
	Extra map[string]certificatesv1beta1.ExtraValue `json:"extra,omitempty"`
}

// CertificateSigningRequestSpecApplyConfiguration constructs a declarative configuration of the CertificateSigningRequestSpec type for use with
// apply.
func CertificateSigningRequestSpec() *CertificateSigningRequestSpecApplyConfiguration {
	return &CertificateSigningRequestSpecApplyConfiguration{}
}

// WithRequest adds the given value to the Request field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Request field.
func (b *CertificateSigningRequestSpecApplyConfiguration) WithRequest(values ...byte) *CertificateSigningRequestSpecApplyConfiguration {
	for i := range values {
		b.Request = append(b.Request, values[i])
	}
	return b
}

// WithSignerName sets the SignerName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the SignerName field is set to the value of the last call.
func (b *CertificateSigningRequestSpecApplyConfiguration) WithSignerName(value string) *CertificateSigningRequestSpecApplyConfiguration {
	b.SignerName = &value
	return b
}

// WithExpirationSeconds sets the ExpirationSeconds field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ExpirationSeconds field is set to the value of the last call.
func (b *CertificateSigningRequestSpecApplyConfiguration) WithExpirationSeconds(value int32) *CertificateSigningRequestSpecApplyConfiguration {
	b.ExpirationSeconds = &value
	return b
}

// WithUsages adds the given value to the Usages field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Usages field.
func (b *CertificateSigningRequestSpecApplyConfiguration) WithUsages(values ...certificatesv1beta1.KeyUsage) *CertificateSigningRequestSpecApplyConfiguration {
	for i := range values {
		b.Usages = append(b.Usages, values[i])
	}
	return b
}

// WithUsername sets the Username field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Username field is set to the value of the last call.
func (b *CertificateSigningRequestSpecApplyConfiguration) WithUsername(value string) *CertificateSigningRequestSpecApplyConfiguration {
	b.Username = &value
	return b
}

// WithUID sets the UID field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the UID field is set to the value of the last call.
func (b *CertificateSigningRequestSpecApplyConfiguration) WithUID(value string) *CertificateSigningRequestSpecApplyConfiguration {
	b.UID = &value
	return b
}

// WithGroups adds the given value to the Groups field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Groups field.
func (b *CertificateSigningRequestSpecApplyConfiguration) WithGroups(values ...string) *CertificateSigningRequestSpecApplyConfiguration {
	for i := range values {
		b.Groups = append(b.Groups, values[i])
	}
	return b
}

// WithExtra puts the entries into the Extra field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the Extra field,
// overwriting an existing map entries in Extra field with the same key.
func (b *CertificateSigningRequestSpecApplyConfiguration) WithExtra(entries map[string]certificatesv1beta1.ExtraValue) *CertificateSigningRequestSpecApplyConfiguration {
	if b.Extra == nil && len(entries) > 0 {
		b.Extra = make(map[string]certificatesv1beta1.ExtraValue, len(entries))
	}
	for k, v := range entries {
		b.Extra[k] = v
	}
	return b
}
