const char dojitcmd_lua[] =
"local M = {}\n"
"\n"
"local function runcmdopt(func, opt)\n"
"    -- Check if there are any args to\n"
"    -- command and prepare them, if present.\n"
"    if opt ~= nil and string.sub(opt, 1, 1) ~= \"\" then\n"
"        local args = opt:split(',')\n"
"        return pcall(func, unpack(args))\n"
"    end\n"
"    return pcall(func)\n"
"end\n"
"\n"
"local function loadjitmodule(module_name)\n"
"    local full_name = 'jit.' .. module_name\n"
"    local st, module = pcall(require, full_name)\n"
"    if not st then module = {} end\n"
"\n"
"    local entry_point = module['start']\n"
"    if entry_point == nil then\n"
"        local err = 'unknown luaJIT command or jit.* modules not installed\\n'\n"
"        io.stderr:write(err)\n"
"    end\n"
"    return entry_point\n"
"end\n"
"\n"
"M.dojitcmd = function(cmd)\n"
"    local cmd, opt = unpack(cmd:split('=', 1))\n"
"    local func = jit[cmd]\n"
"    if type(func) ~= 'function' then\n"
"        func = loadjitmodule(cmd)\n"
"        if func == nil then\n"
"            os.exit(1)\n"
"        end\n"
"    end\n"
"    return runcmdopt(func, opt)\n"
"end\n"
"\n"
"return M\n"
""
;
