const char memprof_process_lua[] =
"-- LuaJIT's memory profile post-processing module.\n"
"\n"
"local M = {}\n"
"\n"
"function M.form_heap_delta(events)\n"
"  -- Auto resurrects source event lines for counting/reporting.\n"
"  local dheap = setmetatable({}, {__index = function(t, line)\n"
"    rawset(t, line, {\n"
"      dbytes = 0,\n"
"      nalloc = 0,\n"
"      nfree = 0,\n"
"    })\n"
"    return t[line]\n"
"  end})\n"
"\n"
"  for _, event in pairs(events.alloc) do\n"
"    if event.loc then\n"
"      local ev_line = event.loc\n"
"\n"
"      if (event.alloc > 0) then\n"
"        dheap[ev_line].dbytes = dheap[ev_line].dbytes + event.alloc\n"
"        dheap[ev_line].nalloc = dheap[ev_line].nalloc + event.num\n"
"      end\n"
"    end\n"
"  end\n"
"\n"
"  -- Realloc and free events are pretty the same.\n"
"  -- We aren't interested in aggregated alloc/free sizes for\n"
"  -- the event, but only for new and old size values inside\n"
"  -- alloc-realloc-free chain. Assuming that we have\n"
"  -- no collisions between different object addresses.\n"
"  local function process_non_alloc_events(events_by_type)\n"
"    for _, event in pairs(events_by_type) do\n"
"      -- Realloc and free events always have key named \"primary\"\n"
"      -- that references the table with memory changed\n"
"      -- (may be empty).\n"
"      for _, heap_chunk in pairs(event.primary) do\n"
"        local ev_line = heap_chunk.loc\n"
"\n"
"        if (heap_chunk.allocated > 0) then\n"
"          dheap[ev_line].dbytes = dheap[ev_line].dbytes + heap_chunk.allocated\n"
"          dheap[ev_line].nalloc = dheap[ev_line].nalloc + heap_chunk.count\n"
"        end\n"
"\n"
"        if (heap_chunk.freed > 0) then\n"
"          dheap[ev_line].dbytes = dheap[ev_line].dbytes - heap_chunk.freed\n"
"          dheap[ev_line].nfree = dheap[ev_line].nfree + heap_chunk.count\n"
"        end\n"
"      end\n"
"    end\n"
"  end\n"
"  process_non_alloc_events(events.realloc)\n"
"  process_non_alloc_events(events.free)\n"
"  return dheap\n"
"end\n"
"\n"
"return M\n"
""
;
