// python wrapper for ttkDimensionReduction
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "ttkDimensionReduction.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_ttkDimensionReduction(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyttkDimensionReduction_ClassNew(); }


static PyObject *
PyttkDimensionReduction_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = ttkDimensionReduction::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->ttkDimensionReduction::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    ttkDimensionReduction *tempr = ttkDimensionReduction::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    ttkDimensionReduction *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->ttkDimensionReduction::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = ttkDimensionReduction::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->ttkDimensionReduction::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_SetScalarFields(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetScalarFields");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetScalarFields(temp0);
    }
    else
    {
      op->ttkDimensionReduction::SetScalarFields(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_ClearScalarFields(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ClearScalarFields");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ClearScalarFields();
    }
    else
    {
      op->ttkDimensionReduction::ClearScalarFields();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_SetSelectFieldsWithRegexp(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSelectFieldsWithRegexp");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSelectFieldsWithRegexp(temp0);
    }
    else
    {
      op->ttkDimensionReduction::SetSelectFieldsWithRegexp(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_GetSelectFieldsWithRegexp(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSelectFieldsWithRegexp");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetSelectFieldsWithRegexp() :
      op->ttkDimensionReduction::GetSelectFieldsWithRegexp());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_SetRegexpString(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRegexpString");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRegexpString(temp0);
    }
    else
    {
      op->ttkDimensionReduction::SetRegexpString(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_GetRegexpString(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRegexpString");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetRegexpString() :
      op->ttkDimensionReduction::GetRegexpString());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_SetNumberOfComponents(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumberOfComponents");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNumberOfComponents(temp0);
    }
    else
    {
      op->ttkDimensionReduction::SetNumberOfComponents(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_GetNumberOfComponents(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfComponents");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfComponents() :
      op->ttkDimensionReduction::GetNumberOfComponents());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_SetNumberOfNeighbors(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumberOfNeighbors");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNumberOfNeighbors(temp0);
    }
    else
    {
      op->ttkDimensionReduction::SetNumberOfNeighbors(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_GetNumberOfNeighbors(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfNeighbors");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfNeighbors() :
      op->ttkDimensionReduction::GetNumberOfNeighbors());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_SetIsDeterministic(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetIsDeterministic");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetIsDeterministic(temp0);
    }
    else
    {
      op->ttkDimensionReduction::SetIsDeterministic(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_GetIsDeterministic(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetIsDeterministic");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetIsDeterministic() :
      op->ttkDimensionReduction::GetIsDeterministic());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_SetMethod(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMethod");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMethod(temp0);
    }
    else
    {
      op->ttkDimensionReduction::SetMethod(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_SetKeepAllDataArrays(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetKeepAllDataArrays");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetKeepAllDataArrays(temp0);
    }
    else
    {
      op->ttkDimensionReduction::SetKeepAllDataArrays(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_GetKeepAllDataArrays(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetKeepAllDataArrays");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetKeepAllDataArrays() :
      op->ttkDimensionReduction::GetKeepAllDataArrays());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_SetInputIsADistanceMatrix(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInputIsADistanceMatrix");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetInputIsADistanceMatrix(temp0);
    }
    else
    {
      op->ttkDimensionReduction::SetInputIsADistanceMatrix(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_GetInputIsADistanceMatrix(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetInputIsADistanceMatrix");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetInputIsADistanceMatrix() :
      op->ttkDimensionReduction::GetInputIsADistanceMatrix());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Setse_Affinity(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Setse_Affinity");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->Setse_Affinity(temp0);
    }
    else
    {
      op->ttkDimensionReduction::Setse_Affinity(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Getse_Affinity(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Getse_Affinity");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->Getse_Affinity() :
      op->ttkDimensionReduction::Getse_Affinity());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Setse_Gamma(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Setse_Gamma");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  float temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->Setse_Gamma(temp0);
    }
    else
    {
      op->ttkDimensionReduction::Setse_Gamma(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Getse_Gamma(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Getse_Gamma");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    float tempr = (ap.IsBound() ?
      op->Getse_Gamma() :
      op->ttkDimensionReduction::Getse_Gamma());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Setse_EigenSolver(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Setse_EigenSolver");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->Setse_EigenSolver(temp0);
    }
    else
    {
      op->ttkDimensionReduction::Setse_EigenSolver(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Getse_EigenSolver(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Getse_EigenSolver");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->Getse_EigenSolver() :
      op->ttkDimensionReduction::Getse_EigenSolver());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Setlle_Regularization(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Setlle_Regularization");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  float temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->Setlle_Regularization(temp0);
    }
    else
    {
      op->ttkDimensionReduction::Setlle_Regularization(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Getlle_Regularization(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Getlle_Regularization");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    float tempr = (ap.IsBound() ?
      op->Getlle_Regularization() :
      op->ttkDimensionReduction::Getlle_Regularization());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Setlle_EigenSolver(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Setlle_EigenSolver");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->Setlle_EigenSolver(temp0);
    }
    else
    {
      op->ttkDimensionReduction::Setlle_EigenSolver(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Getlle_EigenSolver(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Getlle_EigenSolver");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->Getlle_EigenSolver() :
      op->ttkDimensionReduction::Getlle_EigenSolver());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Setlle_Tolerance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Setlle_Tolerance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  float temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->Setlle_Tolerance(temp0);
    }
    else
    {
      op->ttkDimensionReduction::Setlle_Tolerance(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Getlle_Tolerance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Getlle_Tolerance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    float tempr = (ap.IsBound() ?
      op->Getlle_Tolerance() :
      op->ttkDimensionReduction::Getlle_Tolerance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Setlle_MaxIteration(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Setlle_MaxIteration");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->Setlle_MaxIteration(temp0);
    }
    else
    {
      op->ttkDimensionReduction::Setlle_MaxIteration(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Getlle_MaxIteration(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Getlle_MaxIteration");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->Getlle_MaxIteration() :
      op->ttkDimensionReduction::Getlle_MaxIteration());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Setlle_Method(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Setlle_Method");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->Setlle_Method(temp0);
    }
    else
    {
      op->ttkDimensionReduction::Setlle_Method(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Getlle_Method(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Getlle_Method");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->Getlle_Method() :
      op->ttkDimensionReduction::Getlle_Method());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Setlle_HessianTolerance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Setlle_HessianTolerance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  float temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->Setlle_HessianTolerance(temp0);
    }
    else
    {
      op->ttkDimensionReduction::Setlle_HessianTolerance(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Getlle_HessianTolerance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Getlle_HessianTolerance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    float tempr = (ap.IsBound() ?
      op->Getlle_HessianTolerance() :
      op->ttkDimensionReduction::Getlle_HessianTolerance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Setlle_ModifiedTolerance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Setlle_ModifiedTolerance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  float temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->Setlle_ModifiedTolerance(temp0);
    }
    else
    {
      op->ttkDimensionReduction::Setlle_ModifiedTolerance(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Getlle_ModifiedTolerance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Getlle_ModifiedTolerance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    float tempr = (ap.IsBound() ?
      op->Getlle_ModifiedTolerance() :
      op->ttkDimensionReduction::Getlle_ModifiedTolerance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Setlle_NeighborsAlgorithm(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Setlle_NeighborsAlgorithm");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->Setlle_NeighborsAlgorithm(temp0);
    }
    else
    {
      op->ttkDimensionReduction::Setlle_NeighborsAlgorithm(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Getlle_NeighborsAlgorithm(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Getlle_NeighborsAlgorithm");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->Getlle_NeighborsAlgorithm() :
      op->ttkDimensionReduction::Getlle_NeighborsAlgorithm());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Setmds_Metric(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Setmds_Metric");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->Setmds_Metric(temp0);
    }
    else
    {
      op->ttkDimensionReduction::Setmds_Metric(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Getmds_Metric(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Getmds_Metric");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->Getmds_Metric() :
      op->ttkDimensionReduction::Getmds_Metric());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Setmds_Init(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Setmds_Init");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->Setmds_Init(temp0);
    }
    else
    {
      op->ttkDimensionReduction::Setmds_Init(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Getmds_Init(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Getmds_Init");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->Getmds_Init() :
      op->ttkDimensionReduction::Getmds_Init());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Setmds_MaxIteration(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Setmds_MaxIteration");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->Setmds_MaxIteration(temp0);
    }
    else
    {
      op->ttkDimensionReduction::Setmds_MaxIteration(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Getmds_MaxIteration(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Getmds_MaxIteration");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->Getmds_MaxIteration() :
      op->ttkDimensionReduction::Getmds_MaxIteration());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Setmds_Verbose(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Setmds_Verbose");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->Setmds_Verbose(temp0);
    }
    else
    {
      op->ttkDimensionReduction::Setmds_Verbose(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Getmds_Verbose(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Getmds_Verbose");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->Getmds_Verbose() :
      op->ttkDimensionReduction::Getmds_Verbose());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Setmds_Epsilon(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Setmds_Epsilon");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  float temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->Setmds_Epsilon(temp0);
    }
    else
    {
      op->ttkDimensionReduction::Setmds_Epsilon(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Getmds_Epsilon(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Getmds_Epsilon");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    float tempr = (ap.IsBound() ?
      op->Getmds_Epsilon() :
      op->ttkDimensionReduction::Getmds_Epsilon());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Settsne_Perplexity(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Settsne_Perplexity");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  float temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->Settsne_Perplexity(temp0);
    }
    else
    {
      op->ttkDimensionReduction::Settsne_Perplexity(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Gettsne_Perplexity(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Gettsne_Perplexity");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    float tempr = (ap.IsBound() ?
      op->Gettsne_Perplexity() :
      op->ttkDimensionReduction::Gettsne_Perplexity());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Settsne_Exaggeration(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Settsne_Exaggeration");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  float temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->Settsne_Exaggeration(temp0);
    }
    else
    {
      op->ttkDimensionReduction::Settsne_Exaggeration(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Gettsne_Exaggeration(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Gettsne_Exaggeration");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    float tempr = (ap.IsBound() ?
      op->Gettsne_Exaggeration() :
      op->ttkDimensionReduction::Gettsne_Exaggeration());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Settsne_LearningRate(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Settsne_LearningRate");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  float temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->Settsne_LearningRate(temp0);
    }
    else
    {
      op->ttkDimensionReduction::Settsne_LearningRate(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Gettsne_LearningRate(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Gettsne_LearningRate");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    float tempr = (ap.IsBound() ?
      op->Gettsne_LearningRate() :
      op->ttkDimensionReduction::Gettsne_LearningRate());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Settsne_MaxIteration(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Settsne_MaxIteration");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->Settsne_MaxIteration(temp0);
    }
    else
    {
      op->ttkDimensionReduction::Settsne_MaxIteration(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Gettsne_MaxIteration(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Gettsne_MaxIteration");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->Gettsne_MaxIteration() :
      op->ttkDimensionReduction::Gettsne_MaxIteration());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Settsne_MaxIterationProgress(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Settsne_MaxIterationProgress");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->Settsne_MaxIterationProgress(temp0);
    }
    else
    {
      op->ttkDimensionReduction::Settsne_MaxIterationProgress(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Gettsne_MaxIterationProgress(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Gettsne_MaxIterationProgress");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->Gettsne_MaxIterationProgress() :
      op->ttkDimensionReduction::Gettsne_MaxIterationProgress());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Settsne_GradientThreshold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Settsne_GradientThreshold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  float temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->Settsne_GradientThreshold(temp0);
    }
    else
    {
      op->ttkDimensionReduction::Settsne_GradientThreshold(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Gettsne_GradientThreshold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Gettsne_GradientThreshold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    float tempr = (ap.IsBound() ?
      op->Gettsne_GradientThreshold() :
      op->ttkDimensionReduction::Gettsne_GradientThreshold());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Settsne_Metric(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Settsne_Metric");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->Settsne_Metric(temp0);
    }
    else
    {
      op->ttkDimensionReduction::Settsne_Metric(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Gettsne_Metric(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Gettsne_Metric");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->Gettsne_Metric() :
      op->ttkDimensionReduction::Gettsne_Metric());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Settsne_Init(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Settsne_Init");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->Settsne_Init(temp0);
    }
    else
    {
      op->ttkDimensionReduction::Settsne_Init(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Gettsne_Init(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Gettsne_Init");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->Gettsne_Init() :
      op->ttkDimensionReduction::Gettsne_Init());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Settsne_Verbose(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Settsne_Verbose");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->Settsne_Verbose(temp0);
    }
    else
    {
      op->ttkDimensionReduction::Settsne_Verbose(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Gettsne_Verbose(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Gettsne_Verbose");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->Gettsne_Verbose() :
      op->ttkDimensionReduction::Gettsne_Verbose());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Settsne_Method(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Settsne_Method");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->Settsne_Method(temp0);
    }
    else
    {
      op->ttkDimensionReduction::Settsne_Method(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Gettsne_Method(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Gettsne_Method");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->Gettsne_Method() :
      op->ttkDimensionReduction::Gettsne_Method());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Settsne_Angle(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Settsne_Angle");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  float temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->Settsne_Angle(temp0);
    }
    else
    {
      op->ttkDimensionReduction::Settsne_Angle(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Gettsne_Angle(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Gettsne_Angle");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    float tempr = (ap.IsBound() ?
      op->Gettsne_Angle() :
      op->ttkDimensionReduction::Gettsne_Angle());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Setiso_EigenSolver(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Setiso_EigenSolver");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->Setiso_EigenSolver(temp0);
    }
    else
    {
      op->ttkDimensionReduction::Setiso_EigenSolver(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Getiso_EigenSolver(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Getiso_EigenSolver");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->Getiso_EigenSolver() :
      op->ttkDimensionReduction::Getiso_EigenSolver());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Setiso_Tolerance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Setiso_Tolerance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  float temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->Setiso_Tolerance(temp0);
    }
    else
    {
      op->ttkDimensionReduction::Setiso_Tolerance(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Getiso_Tolerance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Getiso_Tolerance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    float tempr = (ap.IsBound() ?
      op->Getiso_Tolerance() :
      op->ttkDimensionReduction::Getiso_Tolerance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Setiso_MaxIteration(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Setiso_MaxIteration");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->Setiso_MaxIteration(temp0);
    }
    else
    {
      op->ttkDimensionReduction::Setiso_MaxIteration(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Getiso_MaxIteration(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Getiso_MaxIteration");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->Getiso_MaxIteration() :
      op->ttkDimensionReduction::Getiso_MaxIteration());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Setiso_PathMethod(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Setiso_PathMethod");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->Setiso_PathMethod(temp0);
    }
    else
    {
      op->ttkDimensionReduction::Setiso_PathMethod(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Getiso_PathMethod(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Getiso_PathMethod");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->Getiso_PathMethod() :
      op->ttkDimensionReduction::Getiso_PathMethod());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Setiso_NeighborsAlgorithm(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Setiso_NeighborsAlgorithm");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->Setiso_NeighborsAlgorithm(temp0);
    }
    else
    {
      op->ttkDimensionReduction::Setiso_NeighborsAlgorithm(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Getiso_NeighborsAlgorithm(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Getiso_NeighborsAlgorithm");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->Getiso_NeighborsAlgorithm() :
      op->ttkDimensionReduction::Getiso_NeighborsAlgorithm());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Setiso_Metric(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Setiso_Metric");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->Setiso_Metric(temp0);
    }
    else
    {
      op->ttkDimensionReduction::Setiso_Metric(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Getiso_Metric(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Getiso_Metric");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->Getiso_Metric() :
      op->ttkDimensionReduction::Getiso_Metric());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Setpca_Copy(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Setpca_Copy");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->Setpca_Copy(temp0);
    }
    else
    {
      op->ttkDimensionReduction::Setpca_Copy(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Getpca_Copy(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Getpca_Copy");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->Getpca_Copy() :
      op->ttkDimensionReduction::Getpca_Copy());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Setpca_Whiten(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Setpca_Whiten");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->Setpca_Whiten(temp0);
    }
    else
    {
      op->ttkDimensionReduction::Setpca_Whiten(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Getpca_Whiten(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Getpca_Whiten");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->Getpca_Whiten() :
      op->ttkDimensionReduction::Getpca_Whiten());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Setpca_SVDSolver(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Setpca_SVDSolver");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->Setpca_SVDSolver(temp0);
    }
    else
    {
      op->ttkDimensionReduction::Setpca_SVDSolver(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Getpca_SVDSolver(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Getpca_SVDSolver");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->Getpca_SVDSolver() :
      op->ttkDimensionReduction::Getpca_SVDSolver());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Setpca_Tolerance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Setpca_Tolerance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  float temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->Setpca_Tolerance(temp0);
    }
    else
    {
      op->ttkDimensionReduction::Setpca_Tolerance(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Getpca_Tolerance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Getpca_Tolerance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    float tempr = (ap.IsBound() ?
      op->Getpca_Tolerance() :
      op->ttkDimensionReduction::Getpca_Tolerance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Setpca_MaxIteration(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Setpca_MaxIteration");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->Setpca_MaxIteration(temp0);
    }
    else
    {
      op->ttkDimensionReduction::Setpca_MaxIteration(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Getpca_MaxIteration(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Getpca_MaxIteration");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->Getpca_MaxIteration() :
      op->ttkDimensionReduction::Getpca_MaxIteration());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Settopomap_AngularSampleNb(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Settopomap_AngularSampleNb");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  unsigned long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->Settopomap_AngularSampleNb(temp0);
    }
    else
    {
      op->ttkDimensionReduction::Settopomap_AngularSampleNb(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Gettopomap_AngularSampleNb(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Gettopomap_AngularSampleNb");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned long tempr = (ap.IsBound() ?
      op->Gettopomap_AngularSampleNb() :
      op->ttkDimensionReduction::Gettopomap_AngularSampleNb());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Settopomap_CheckMST(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Settopomap_CheckMST");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->Settopomap_CheckMST(temp0);
    }
    else
    {
      op->ttkDimensionReduction::Settopomap_CheckMST(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Gettopomap_CheckMST(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Gettopomap_CheckMST");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->Gettopomap_CheckMST() :
      op->ttkDimensionReduction::Gettopomap_CheckMST());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_Settopomap_Strategy(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Settopomap_Strategy");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->Settopomap_Strategy(temp0);
    }
    else
    {
      op->ttkDimensionReduction::Settopomap_Strategy(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_SetModulePath(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetModulePath");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetModulePath(temp0);
    }
    else
    {
      op->ttkDimensionReduction::SetModulePath(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_GetModulePath(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetModulePath");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetModulePath() :
      op->ttkDimensionReduction::GetModulePath());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_SetModuleName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetModuleName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetModuleName(temp0);
    }
    else
    {
      op->ttkDimensionReduction::SetModuleName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_GetModuleName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetModuleName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetModuleName() :
      op->ttkDimensionReduction::GetModuleName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_SetFunctionName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFunctionName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFunctionName(temp0);
    }
    else
    {
      op->ttkDimensionReduction::SetFunctionName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkDimensionReduction_GetFunctionName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFunctionName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDimensionReduction *op = static_cast<ttkDimensionReduction *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetFunctionName() :
      op->ttkDimensionReduction::GetFunctionName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyttkDimensionReduction_Methods[] = {
  {"IsTypeOf", PyttkDimensionReduction_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyttkDimensionReduction_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyttkDimensionReduction_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> ttkDimensionReduction\nC++: static ttkDimensionReduction *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyttkDimensionReduction_NewInstance, METH_VARARGS,
   "NewInstance(self) -> ttkDimensionReduction\nC++: ttkDimensionReduction *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyttkDimensionReduction_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyttkDimensionReduction_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetScalarFields", PyttkDimensionReduction_SetScalarFields, METH_VARARGS,
   "SetScalarFields(self, s:str) -> None\nC++: void SetScalarFields(const std::string &s)\n\n"},
  {"ClearScalarFields", PyttkDimensionReduction_ClearScalarFields, METH_VARARGS,
   "ClearScalarFields(self) -> None\nC++: void ClearScalarFields()\n\n"},
  {"SetSelectFieldsWithRegexp", PyttkDimensionReduction_SetSelectFieldsWithRegexp, METH_VARARGS,
   "SetSelectFieldsWithRegexp(self, _arg:bool) -> None\nC++: virtual void SetSelectFieldsWithRegexp(bool _arg)\n\n"},
  {"GetSelectFieldsWithRegexp", PyttkDimensionReduction_GetSelectFieldsWithRegexp, METH_VARARGS,
   "GetSelectFieldsWithRegexp(self) -> bool\nC++: virtual bool GetSelectFieldsWithRegexp()\n\n"},
  {"SetRegexpString", PyttkDimensionReduction_SetRegexpString, METH_VARARGS,
   "SetRegexpString(self, _arg:str) -> None\nC++: virtual void SetRegexpString(const std::string &_arg)\n\n"},
  {"GetRegexpString", PyttkDimensionReduction_GetRegexpString, METH_VARARGS,
   "GetRegexpString(self) -> str\nC++: virtual std::string GetRegexpString()\n\n"},
  {"SetNumberOfComponents", PyttkDimensionReduction_SetNumberOfComponents, METH_VARARGS,
   "SetNumberOfComponents(self, _arg:int) -> None\nC++: virtual void SetNumberOfComponents(int _arg)\n\n"},
  {"GetNumberOfComponents", PyttkDimensionReduction_GetNumberOfComponents, METH_VARARGS,
   "GetNumberOfComponents(self) -> int\nC++: virtual int GetNumberOfComponents()\n\n"},
  {"SetNumberOfNeighbors", PyttkDimensionReduction_SetNumberOfNeighbors, METH_VARARGS,
   "SetNumberOfNeighbors(self, _arg:int) -> None\nC++: virtual void SetNumberOfNeighbors(int _arg)\n\n"},
  {"GetNumberOfNeighbors", PyttkDimensionReduction_GetNumberOfNeighbors, METH_VARARGS,
   "GetNumberOfNeighbors(self) -> int\nC++: virtual int GetNumberOfNeighbors()\n\n"},
  {"SetIsDeterministic", PyttkDimensionReduction_SetIsDeterministic, METH_VARARGS,
   "SetIsDeterministic(self, _arg:int) -> None\nC++: virtual void SetIsDeterministic(int _arg)\n\n"},
  {"GetIsDeterministic", PyttkDimensionReduction_GetIsDeterministic, METH_VARARGS,
   "GetIsDeterministic(self) -> int\nC++: virtual int GetIsDeterministic()\n\n"},
  {"SetMethod", PyttkDimensionReduction_SetMethod, METH_VARARGS,
   "SetMethod(self, _arg:int) -> None\nC++: virtual void SetMethod(int _arg)\n\n"},
  {"SetKeepAllDataArrays", PyttkDimensionReduction_SetKeepAllDataArrays, METH_VARARGS,
   "SetKeepAllDataArrays(self, _arg:bool) -> None\nC++: virtual void SetKeepAllDataArrays(bool _arg)\n\n"},
  {"GetKeepAllDataArrays", PyttkDimensionReduction_GetKeepAllDataArrays, METH_VARARGS,
   "GetKeepAllDataArrays(self) -> bool\nC++: virtual bool GetKeepAllDataArrays()\n\n"},
  {"SetInputIsADistanceMatrix", PyttkDimensionReduction_SetInputIsADistanceMatrix, METH_VARARGS,
   "SetInputIsADistanceMatrix(self, b:bool) -> None\nC++: void SetInputIsADistanceMatrix(const bool b)\n\n"},
  {"GetInputIsADistanceMatrix", PyttkDimensionReduction_GetInputIsADistanceMatrix, METH_VARARGS,
   "GetInputIsADistanceMatrix(self) -> bool\nC++: virtual bool GetInputIsADistanceMatrix()\n\n"},
  {"Setse_Affinity", PyttkDimensionReduction_Setse_Affinity, METH_VARARGS,
   "Setse_Affinity(self, _arg:str) -> None\nC++: virtual void Setse_Affinity(const std::string &_arg)\n\n"},
  {"Getse_Affinity", PyttkDimensionReduction_Getse_Affinity, METH_VARARGS,
   "Getse_Affinity(self) -> str\nC++: virtual std::string Getse_Affinity()\n\n"},
  {"Setse_Gamma", PyttkDimensionReduction_Setse_Gamma, METH_VARARGS,
   "Setse_Gamma(self, _arg:float) -> None\nC++: virtual void Setse_Gamma(float _arg)\n\n"},
  {"Getse_Gamma", PyttkDimensionReduction_Getse_Gamma, METH_VARARGS,
   "Getse_Gamma(self) -> float\nC++: virtual float Getse_Gamma()\n\n"},
  {"Setse_EigenSolver", PyttkDimensionReduction_Setse_EigenSolver, METH_VARARGS,
   "Setse_EigenSolver(self, _arg:str) -> None\nC++: virtual void Setse_EigenSolver(const std::string &_arg)\n\n"},
  {"Getse_EigenSolver", PyttkDimensionReduction_Getse_EigenSolver, METH_VARARGS,
   "Getse_EigenSolver(self) -> str\nC++: virtual std::string Getse_EigenSolver()\n\n"},
  {"Setlle_Regularization", PyttkDimensionReduction_Setlle_Regularization, METH_VARARGS,
   "Setlle_Regularization(self, _arg:float) -> None\nC++: virtual void Setlle_Regularization(float _arg)\n\n"},
  {"Getlle_Regularization", PyttkDimensionReduction_Getlle_Regularization, METH_VARARGS,
   "Getlle_Regularization(self) -> float\nC++: virtual float Getlle_Regularization()\n\n"},
  {"Setlle_EigenSolver", PyttkDimensionReduction_Setlle_EigenSolver, METH_VARARGS,
   "Setlle_EigenSolver(self, _arg:str) -> None\nC++: virtual void Setlle_EigenSolver(const std::string &_arg)\n\n"},
  {"Getlle_EigenSolver", PyttkDimensionReduction_Getlle_EigenSolver, METH_VARARGS,
   "Getlle_EigenSolver(self) -> str\nC++: virtual std::string Getlle_EigenSolver()\n\n"},
  {"Setlle_Tolerance", PyttkDimensionReduction_Setlle_Tolerance, METH_VARARGS,
   "Setlle_Tolerance(self, _arg:float) -> None\nC++: virtual void Setlle_Tolerance(float _arg)\n\n"},
  {"Getlle_Tolerance", PyttkDimensionReduction_Getlle_Tolerance, METH_VARARGS,
   "Getlle_Tolerance(self) -> float\nC++: virtual float Getlle_Tolerance()\n\n"},
  {"Setlle_MaxIteration", PyttkDimensionReduction_Setlle_MaxIteration, METH_VARARGS,
   "Setlle_MaxIteration(self, _arg:int) -> None\nC++: virtual void Setlle_MaxIteration(int _arg)\n\n"},
  {"Getlle_MaxIteration", PyttkDimensionReduction_Getlle_MaxIteration, METH_VARARGS,
   "Getlle_MaxIteration(self) -> int\nC++: virtual int Getlle_MaxIteration()\n\n"},
  {"Setlle_Method", PyttkDimensionReduction_Setlle_Method, METH_VARARGS,
   "Setlle_Method(self, _arg:str) -> None\nC++: virtual void Setlle_Method(const std::string &_arg)\n\n"},
  {"Getlle_Method", PyttkDimensionReduction_Getlle_Method, METH_VARARGS,
   "Getlle_Method(self) -> str\nC++: virtual std::string Getlle_Method()\n\n"},
  {"Setlle_HessianTolerance", PyttkDimensionReduction_Setlle_HessianTolerance, METH_VARARGS,
   "Setlle_HessianTolerance(self, _arg:float) -> None\nC++: virtual void Setlle_HessianTolerance(float _arg)\n\n"},
  {"Getlle_HessianTolerance", PyttkDimensionReduction_Getlle_HessianTolerance, METH_VARARGS,
   "Getlle_HessianTolerance(self) -> float\nC++: virtual float Getlle_HessianTolerance()\n\n"},
  {"Setlle_ModifiedTolerance", PyttkDimensionReduction_Setlle_ModifiedTolerance, METH_VARARGS,
   "Setlle_ModifiedTolerance(self, _arg:float) -> None\nC++: virtual void Setlle_ModifiedTolerance(float _arg)\n\n"},
  {"Getlle_ModifiedTolerance", PyttkDimensionReduction_Getlle_ModifiedTolerance, METH_VARARGS,
   "Getlle_ModifiedTolerance(self) -> float\nC++: virtual float Getlle_ModifiedTolerance()\n\n"},
  {"Setlle_NeighborsAlgorithm", PyttkDimensionReduction_Setlle_NeighborsAlgorithm, METH_VARARGS,
   "Setlle_NeighborsAlgorithm(self, _arg:str) -> None\nC++: virtual void Setlle_NeighborsAlgorithm(\n    const std::string &_arg)\n\n"},
  {"Getlle_NeighborsAlgorithm", PyttkDimensionReduction_Getlle_NeighborsAlgorithm, METH_VARARGS,
   "Getlle_NeighborsAlgorithm(self) -> str\nC++: virtual std::string Getlle_NeighborsAlgorithm()\n\n"},
  {"Setmds_Metric", PyttkDimensionReduction_Setmds_Metric, METH_VARARGS,
   "Setmds_Metric(self, _arg:bool) -> None\nC++: virtual void Setmds_Metric(bool _arg)\n\n"},
  {"Getmds_Metric", PyttkDimensionReduction_Getmds_Metric, METH_VARARGS,
   "Getmds_Metric(self) -> bool\nC++: virtual bool Getmds_Metric()\n\n"},
  {"Setmds_Init", PyttkDimensionReduction_Setmds_Init, METH_VARARGS,
   "Setmds_Init(self, _arg:int) -> None\nC++: virtual void Setmds_Init(int _arg)\n\n"},
  {"Getmds_Init", PyttkDimensionReduction_Getmds_Init, METH_VARARGS,
   "Getmds_Init(self) -> int\nC++: virtual int Getmds_Init()\n\n"},
  {"Setmds_MaxIteration", PyttkDimensionReduction_Setmds_MaxIteration, METH_VARARGS,
   "Setmds_MaxIteration(self, _arg:int) -> None\nC++: virtual void Setmds_MaxIteration(int _arg)\n\n"},
  {"Getmds_MaxIteration", PyttkDimensionReduction_Getmds_MaxIteration, METH_VARARGS,
   "Getmds_MaxIteration(self) -> int\nC++: virtual int Getmds_MaxIteration()\n\n"},
  {"Setmds_Verbose", PyttkDimensionReduction_Setmds_Verbose, METH_VARARGS,
   "Setmds_Verbose(self, _arg:int) -> None\nC++: virtual void Setmds_Verbose(int _arg)\n\n"},
  {"Getmds_Verbose", PyttkDimensionReduction_Getmds_Verbose, METH_VARARGS,
   "Getmds_Verbose(self) -> int\nC++: virtual int Getmds_Verbose()\n\n"},
  {"Setmds_Epsilon", PyttkDimensionReduction_Setmds_Epsilon, METH_VARARGS,
   "Setmds_Epsilon(self, _arg:float) -> None\nC++: virtual void Setmds_Epsilon(float _arg)\n\n"},
  {"Getmds_Epsilon", PyttkDimensionReduction_Getmds_Epsilon, METH_VARARGS,
   "Getmds_Epsilon(self) -> float\nC++: virtual float Getmds_Epsilon()\n\n"},
  {"Settsne_Perplexity", PyttkDimensionReduction_Settsne_Perplexity, METH_VARARGS,
   "Settsne_Perplexity(self, _arg:float) -> None\nC++: virtual void Settsne_Perplexity(float _arg)\n\n"},
  {"Gettsne_Perplexity", PyttkDimensionReduction_Gettsne_Perplexity, METH_VARARGS,
   "Gettsne_Perplexity(self) -> float\nC++: virtual float Gettsne_Perplexity()\n\n"},
  {"Settsne_Exaggeration", PyttkDimensionReduction_Settsne_Exaggeration, METH_VARARGS,
   "Settsne_Exaggeration(self, _arg:float) -> None\nC++: virtual void Settsne_Exaggeration(float _arg)\n\n"},
  {"Gettsne_Exaggeration", PyttkDimensionReduction_Gettsne_Exaggeration, METH_VARARGS,
   "Gettsne_Exaggeration(self) -> float\nC++: virtual float Gettsne_Exaggeration()\n\n"},
  {"Settsne_LearningRate", PyttkDimensionReduction_Settsne_LearningRate, METH_VARARGS,
   "Settsne_LearningRate(self, _arg:float) -> None\nC++: virtual void Settsne_LearningRate(float _arg)\n\n"},
  {"Gettsne_LearningRate", PyttkDimensionReduction_Gettsne_LearningRate, METH_VARARGS,
   "Gettsne_LearningRate(self) -> float\nC++: virtual float Gettsne_LearningRate()\n\n"},
  {"Settsne_MaxIteration", PyttkDimensionReduction_Settsne_MaxIteration, METH_VARARGS,
   "Settsne_MaxIteration(self, _arg:int) -> None\nC++: virtual void Settsne_MaxIteration(int _arg)\n\n"},
  {"Gettsne_MaxIteration", PyttkDimensionReduction_Gettsne_MaxIteration, METH_VARARGS,
   "Gettsne_MaxIteration(self) -> int\nC++: virtual int Gettsne_MaxIteration()\n\n"},
  {"Settsne_MaxIterationProgress", PyttkDimensionReduction_Settsne_MaxIterationProgress, METH_VARARGS,
   "Settsne_MaxIterationProgress(self, _arg:int) -> None\nC++: virtual void Settsne_MaxIterationProgress(int _arg)\n\n"},
  {"Gettsne_MaxIterationProgress", PyttkDimensionReduction_Gettsne_MaxIterationProgress, METH_VARARGS,
   "Gettsne_MaxIterationProgress(self) -> int\nC++: virtual int Gettsne_MaxIterationProgress()\n\n"},
  {"Settsne_GradientThreshold", PyttkDimensionReduction_Settsne_GradientThreshold, METH_VARARGS,
   "Settsne_GradientThreshold(self, _arg:float) -> None\nC++: virtual void Settsne_GradientThreshold(float _arg)\n\n"},
  {"Gettsne_GradientThreshold", PyttkDimensionReduction_Gettsne_GradientThreshold, METH_VARARGS,
   "Gettsne_GradientThreshold(self) -> float\nC++: virtual float Gettsne_GradientThreshold()\n\n"},
  {"Settsne_Metric", PyttkDimensionReduction_Settsne_Metric, METH_VARARGS,
   "Settsne_Metric(self, _arg:str) -> None\nC++: virtual void Settsne_Metric(const std::string &_arg)\n\n"},
  {"Gettsne_Metric", PyttkDimensionReduction_Gettsne_Metric, METH_VARARGS,
   "Gettsne_Metric(self) -> str\nC++: virtual std::string Gettsne_Metric()\n\n"},
  {"Settsne_Init", PyttkDimensionReduction_Settsne_Init, METH_VARARGS,
   "Settsne_Init(self, _arg:str) -> None\nC++: virtual void Settsne_Init(const std::string &_arg)\n\n"},
  {"Gettsne_Init", PyttkDimensionReduction_Gettsne_Init, METH_VARARGS,
   "Gettsne_Init(self) -> str\nC++: virtual std::string Gettsne_Init()\n\n"},
  {"Settsne_Verbose", PyttkDimensionReduction_Settsne_Verbose, METH_VARARGS,
   "Settsne_Verbose(self, _arg:int) -> None\nC++: virtual void Settsne_Verbose(int _arg)\n\n"},
  {"Gettsne_Verbose", PyttkDimensionReduction_Gettsne_Verbose, METH_VARARGS,
   "Gettsne_Verbose(self) -> int\nC++: virtual int Gettsne_Verbose()\n\n"},
  {"Settsne_Method", PyttkDimensionReduction_Settsne_Method, METH_VARARGS,
   "Settsne_Method(self, _arg:str) -> None\nC++: virtual void Settsne_Method(const std::string &_arg)\n\n"},
  {"Gettsne_Method", PyttkDimensionReduction_Gettsne_Method, METH_VARARGS,
   "Gettsne_Method(self) -> str\nC++: virtual std::string Gettsne_Method()\n\n"},
  {"Settsne_Angle", PyttkDimensionReduction_Settsne_Angle, METH_VARARGS,
   "Settsne_Angle(self, _arg:float) -> None\nC++: virtual void Settsne_Angle(float _arg)\n\n"},
  {"Gettsne_Angle", PyttkDimensionReduction_Gettsne_Angle, METH_VARARGS,
   "Gettsne_Angle(self) -> float\nC++: virtual float Gettsne_Angle()\n\n"},
  {"Setiso_EigenSolver", PyttkDimensionReduction_Setiso_EigenSolver, METH_VARARGS,
   "Setiso_EigenSolver(self, _arg:str) -> None\nC++: virtual void Setiso_EigenSolver(const std::string &_arg)\n\n"},
  {"Getiso_EigenSolver", PyttkDimensionReduction_Getiso_EigenSolver, METH_VARARGS,
   "Getiso_EigenSolver(self) -> str\nC++: virtual std::string Getiso_EigenSolver()\n\n"},
  {"Setiso_Tolerance", PyttkDimensionReduction_Setiso_Tolerance, METH_VARARGS,
   "Setiso_Tolerance(self, _arg:float) -> None\nC++: virtual void Setiso_Tolerance(float _arg)\n\n"},
  {"Getiso_Tolerance", PyttkDimensionReduction_Getiso_Tolerance, METH_VARARGS,
   "Getiso_Tolerance(self) -> float\nC++: virtual float Getiso_Tolerance()\n\n"},
  {"Setiso_MaxIteration", PyttkDimensionReduction_Setiso_MaxIteration, METH_VARARGS,
   "Setiso_MaxIteration(self, _arg:int) -> None\nC++: virtual void Setiso_MaxIteration(int _arg)\n\n"},
  {"Getiso_MaxIteration", PyttkDimensionReduction_Getiso_MaxIteration, METH_VARARGS,
   "Getiso_MaxIteration(self) -> int\nC++: virtual int Getiso_MaxIteration()\n\n"},
  {"Setiso_PathMethod", PyttkDimensionReduction_Setiso_PathMethod, METH_VARARGS,
   "Setiso_PathMethod(self, _arg:str) -> None\nC++: virtual void Setiso_PathMethod(const std::string &_arg)\n\n"},
  {"Getiso_PathMethod", PyttkDimensionReduction_Getiso_PathMethod, METH_VARARGS,
   "Getiso_PathMethod(self) -> str\nC++: virtual std::string Getiso_PathMethod()\n\n"},
  {"Setiso_NeighborsAlgorithm", PyttkDimensionReduction_Setiso_NeighborsAlgorithm, METH_VARARGS,
   "Setiso_NeighborsAlgorithm(self, _arg:str) -> None\nC++: virtual void Setiso_NeighborsAlgorithm(\n    const std::string &_arg)\n\n"},
  {"Getiso_NeighborsAlgorithm", PyttkDimensionReduction_Getiso_NeighborsAlgorithm, METH_VARARGS,
   "Getiso_NeighborsAlgorithm(self) -> str\nC++: virtual std::string Getiso_NeighborsAlgorithm()\n\n"},
  {"Setiso_Metric", PyttkDimensionReduction_Setiso_Metric, METH_VARARGS,
   "Setiso_Metric(self, _arg:str) -> None\nC++: virtual void Setiso_Metric(const std::string &_arg)\n\n"},
  {"Getiso_Metric", PyttkDimensionReduction_Getiso_Metric, METH_VARARGS,
   "Getiso_Metric(self) -> str\nC++: virtual std::string Getiso_Metric()\n\n"},
  {"Setpca_Copy", PyttkDimensionReduction_Setpca_Copy, METH_VARARGS,
   "Setpca_Copy(self, _arg:bool) -> None\nC++: virtual void Setpca_Copy(bool _arg)\n\n"},
  {"Getpca_Copy", PyttkDimensionReduction_Getpca_Copy, METH_VARARGS,
   "Getpca_Copy(self) -> bool\nC++: virtual bool Getpca_Copy()\n\n"},
  {"Setpca_Whiten", PyttkDimensionReduction_Setpca_Whiten, METH_VARARGS,
   "Setpca_Whiten(self, _arg:bool) -> None\nC++: virtual void Setpca_Whiten(bool _arg)\n\n"},
  {"Getpca_Whiten", PyttkDimensionReduction_Getpca_Whiten, METH_VARARGS,
   "Getpca_Whiten(self) -> bool\nC++: virtual bool Getpca_Whiten()\n\n"},
  {"Setpca_SVDSolver", PyttkDimensionReduction_Setpca_SVDSolver, METH_VARARGS,
   "Setpca_SVDSolver(self, _arg:str) -> None\nC++: virtual void Setpca_SVDSolver(const std::string &_arg)\n\n"},
  {"Getpca_SVDSolver", PyttkDimensionReduction_Getpca_SVDSolver, METH_VARARGS,
   "Getpca_SVDSolver(self) -> str\nC++: virtual std::string Getpca_SVDSolver()\n\n"},
  {"Setpca_Tolerance", PyttkDimensionReduction_Setpca_Tolerance, METH_VARARGS,
   "Setpca_Tolerance(self, _arg:float) -> None\nC++: virtual void Setpca_Tolerance(float _arg)\n\n"},
  {"Getpca_Tolerance", PyttkDimensionReduction_Getpca_Tolerance, METH_VARARGS,
   "Getpca_Tolerance(self) -> float\nC++: virtual float Getpca_Tolerance()\n\n"},
  {"Setpca_MaxIteration", PyttkDimensionReduction_Setpca_MaxIteration, METH_VARARGS,
   "Setpca_MaxIteration(self, _arg:str) -> None\nC++: virtual void Setpca_MaxIteration(const std::string &_arg)\n\n"},
  {"Getpca_MaxIteration", PyttkDimensionReduction_Getpca_MaxIteration, METH_VARARGS,
   "Getpca_MaxIteration(self) -> str\nC++: virtual std::string Getpca_MaxIteration()\n\n"},
  {"Settopomap_AngularSampleNb", PyttkDimensionReduction_Settopomap_AngularSampleNb, METH_VARARGS,
   "Settopomap_AngularSampleNb(self, _arg:int) -> None\nC++: virtual void Settopomap_AngularSampleNb(\n    unsigned long int _arg)\n\n"},
  {"Gettopomap_AngularSampleNb", PyttkDimensionReduction_Gettopomap_AngularSampleNb, METH_VARARGS,
   "Gettopomap_AngularSampleNb(self) -> int\nC++: virtual unsigned long int Gettopomap_AngularSampleNb()\n\n"},
  {"Settopomap_CheckMST", PyttkDimensionReduction_Settopomap_CheckMST, METH_VARARGS,
   "Settopomap_CheckMST(self, _arg:bool) -> None\nC++: virtual void Settopomap_CheckMST(bool _arg)\n\n"},
  {"Gettopomap_CheckMST", PyttkDimensionReduction_Gettopomap_CheckMST, METH_VARARGS,
   "Gettopomap_CheckMST(self) -> bool\nC++: virtual bool Gettopomap_CheckMST()\n\n"},
  {"Settopomap_Strategy", PyttkDimensionReduction_Settopomap_Strategy, METH_VARARGS,
   "Settopomap_Strategy(self, _arg:int) -> None\nC++: virtual void Settopomap_Strategy(int _arg)\n\n"},
  {"SetModulePath", PyttkDimensionReduction_SetModulePath, METH_VARARGS,
   "SetModulePath(self, _arg:str) -> None\nC++: virtual void SetModulePath(const std::string &_arg)\n\n"},
  {"GetModulePath", PyttkDimensionReduction_GetModulePath, METH_VARARGS,
   "GetModulePath(self) -> str\nC++: virtual std::string GetModulePath()\n\n"},
  {"SetModuleName", PyttkDimensionReduction_SetModuleName, METH_VARARGS,
   "SetModuleName(self, _arg:str) -> None\nC++: virtual void SetModuleName(const std::string &_arg)\n\n"},
  {"GetModuleName", PyttkDimensionReduction_GetModuleName, METH_VARARGS,
   "GetModuleName(self) -> str\nC++: virtual std::string GetModuleName()\n\n"},
  {"SetFunctionName", PyttkDimensionReduction_SetFunctionName, METH_VARARGS,
   "SetFunctionName(self, _arg:str) -> None\nC++: virtual void SetFunctionName(const std::string &_arg)\n\n"},
  {"GetFunctionName", PyttkDimensionReduction_GetFunctionName, METH_VARARGS,
   "GetFunctionName(self) -> str\nC++: virtual std::string GetFunctionName()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyttkDimensionReduction_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("scalar_fields"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkDimensionReduction_SetScalarFields(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkDimensionReduction_SetScalarFields(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetScalarFields\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("select_fields_with_regexp"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkDimensionReduction_GetSelectFieldsWithRegexp(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkDimensionReduction_SetSelectFieldsWithRegexp(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkDimensionReduction_SetSelectFieldsWithRegexp(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSelectFieldsWithRegexp/SetSelectFieldsWithRegexp\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("regexp_string"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkDimensionReduction_GetRegexpString(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkDimensionReduction_SetRegexpString(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkDimensionReduction_SetRegexpString(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetRegexpString/SetRegexpString\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("is_deterministic"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkDimensionReduction_GetIsDeterministic(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkDimensionReduction_SetIsDeterministic(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkDimensionReduction_SetIsDeterministic(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetIsDeterministic/SetIsDeterministic\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("method"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkDimensionReduction_SetMethod(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkDimensionReduction_SetMethod(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetMethod\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("keep_all_data_arrays"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkDimensionReduction_GetKeepAllDataArrays(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkDimensionReduction_SetKeepAllDataArrays(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkDimensionReduction_SetKeepAllDataArrays(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetKeepAllDataArrays/SetKeepAllDataArrays\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("input_is_a_distance_matrix"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkDimensionReduction_GetInputIsADistanceMatrix(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkDimensionReduction_SetInputIsADistanceMatrix(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkDimensionReduction_SetInputIsADistanceMatrix(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetInputIsADistanceMatrix/SetInputIsADistanceMatrix\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("module_path"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkDimensionReduction_GetModulePath(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkDimensionReduction_SetModulePath(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkDimensionReduction_SetModulePath(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetModulePath/SetModulePath\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("module_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkDimensionReduction_GetModuleName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkDimensionReduction_SetModuleName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkDimensionReduction_SetModuleName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetModuleName/SetModuleName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("function_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkDimensionReduction_GetFunctionName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkDimensionReduction_SetFunctionName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkDimensionReduction_SetFunctionName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetFunctionName/SetFunctionName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_components"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkDimensionReduction_GetNumberOfComponents(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkDimensionReduction_SetNumberOfComponents(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkDimensionReduction_SetNumberOfComponents(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetNumberOfComponents/SetNumberOfComponents\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_neighbors"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkDimensionReduction_GetNumberOfNeighbors(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkDimensionReduction_SetNumberOfNeighbors(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkDimensionReduction_SetNumberOfNeighbors(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetNumberOfNeighbors/SetNumberOfNeighbors\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyttkDimensionReduction_Doc =
  "ttkDimensionReduction - \\ingroup vtk\n\n"
  "Superclass: ttkAlgorithm\n\n"
  "\\author GuillaumeFavelier <guillaume.favelier@gmail.com>\\date\n"
  "September 2018.\n\n"
  "TTK VTK-filter that wraps the ttk::DimensionReduction\n"
  "processing package.\n\n"
  "VTK wrapping code for the ttk::DimensionReduction package.\n\n"
  "\\param Input Input scalar field (vtkDataSet)\n"
  "\\param Output Output scalar field (vtkDataSet)\n\n"
  "This filter can be used as any other VTK filter (for instance, by\n"
  "using the sequence of calls SetInputData(), Update(), GetOutput()).\n\n"
  "See the related ParaView example state files for usage examples\n"
  "within a VTK pipeline.\n\n"
  "\\sa ttk::DimensionReduction\n\n"
  "Online examples:\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/1manifoldLearning/\"\n"
  "  >1-Manifold Learning example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/clusteringKelvinHelmholtzInstabilities/\"\n"
  "  > Clustering Kelvin Helmholtz Instabilities example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/karhunenLoveDigits64Dimensions/\"\n"
  "  >Karhunen-Love Digits 64-Dimensions example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/mergeTreeClustering/\"\n"
  "  >Merge Tree Clustering example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/mergeTreePGA/\">Me\n"
  "  rge Tree Principal Geodesic Analysis example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/persistenceDiagramPGA/\"\n"
  "  >Persistence Diagram Principal Geodesic Analysis example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/persistentGenerators_householdAnalysis/\"\n"
  "  >Persistent Generators Household Analysis example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/persistentGenerators_periodicPicture/\"\n"
  "  >Persistent Generators Periodic Picture example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/topoMapTeaser/\">T\n"
  "  opoMap Teaser example\\n\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkDimensionReduction_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkDimensionReduction.ttkDimensionReduction", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyttkDimensionReduction_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyttkDimensionReduction_StaticNew()
{
  return ttkDimensionReduction::New();
}

PyObject *PyttkDimensionReduction_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyttkDimensionReduction_Type, PyttkDimensionReduction_Methods,
    "ttkDimensionReduction",
 &PyttkDimensionReduction_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("ttkAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyttkDimensionReduction_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_ttkDimensionReduction(
  PyObject *dict)
{
  PyObject *o;
  o = PyttkDimensionReduction_ClassNew();

  if (o && PyDict_SetItemString(dict, "ttkDimensionReduction", o) != 0)
  {
    Py_DECREF(o);
  }

}

