/*
The MIT License (MIT)

Copyright (c) 2016-2020 Containous SAS; 2020-2026 Traefik Labs

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1alpha1

// TLSOptionSpecApplyConfiguration represents a declarative configuration of the TLSOptionSpec type for use
// with apply.
type TLSOptionSpecApplyConfiguration struct {
	MinVersion               *string                       `json:"minVersion,omitempty"`
	MaxVersion               *string                       `json:"maxVersion,omitempty"`
	CipherSuites             []string                      `json:"cipherSuites,omitempty"`
	CurvePreferences         []string                      `json:"curvePreferences,omitempty"`
	ClientAuth               *ClientAuthApplyConfiguration `json:"clientAuth,omitempty"`
	SniStrict                *bool                         `json:"sniStrict,omitempty"`
	ALPNProtocols            []string                      `json:"alpnProtocols,omitempty"`
	DisableSessionTickets    *bool                         `json:"disableSessionTickets,omitempty"`
	PreferServerCipherSuites *bool                         `json:"preferServerCipherSuites,omitempty"`
}

// TLSOptionSpecApplyConfiguration constructs a declarative configuration of the TLSOptionSpec type for use with
// apply.
func TLSOptionSpec() *TLSOptionSpecApplyConfiguration {
	return &TLSOptionSpecApplyConfiguration{}
}

// WithMinVersion sets the MinVersion field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the MinVersion field is set to the value of the last call.
func (b *TLSOptionSpecApplyConfiguration) WithMinVersion(value string) *TLSOptionSpecApplyConfiguration {
	b.MinVersion = &value
	return b
}

// WithMaxVersion sets the MaxVersion field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the MaxVersion field is set to the value of the last call.
func (b *TLSOptionSpecApplyConfiguration) WithMaxVersion(value string) *TLSOptionSpecApplyConfiguration {
	b.MaxVersion = &value
	return b
}

// WithCipherSuites adds the given value to the CipherSuites field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the CipherSuites field.
func (b *TLSOptionSpecApplyConfiguration) WithCipherSuites(values ...string) *TLSOptionSpecApplyConfiguration {
	for i := range values {
		b.CipherSuites = append(b.CipherSuites, values[i])
	}
	return b
}

// WithCurvePreferences adds the given value to the CurvePreferences field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the CurvePreferences field.
func (b *TLSOptionSpecApplyConfiguration) WithCurvePreferences(values ...string) *TLSOptionSpecApplyConfiguration {
	for i := range values {
		b.CurvePreferences = append(b.CurvePreferences, values[i])
	}
	return b
}

// WithClientAuth sets the ClientAuth field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ClientAuth field is set to the value of the last call.
func (b *TLSOptionSpecApplyConfiguration) WithClientAuth(value *ClientAuthApplyConfiguration) *TLSOptionSpecApplyConfiguration {
	b.ClientAuth = value
	return b
}

// WithSniStrict sets the SniStrict field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the SniStrict field is set to the value of the last call.
func (b *TLSOptionSpecApplyConfiguration) WithSniStrict(value bool) *TLSOptionSpecApplyConfiguration {
	b.SniStrict = &value
	return b
}

// WithALPNProtocols adds the given value to the ALPNProtocols field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the ALPNProtocols field.
func (b *TLSOptionSpecApplyConfiguration) WithALPNProtocols(values ...string) *TLSOptionSpecApplyConfiguration {
	for i := range values {
		b.ALPNProtocols = append(b.ALPNProtocols, values[i])
	}
	return b
}

// WithDisableSessionTickets sets the DisableSessionTickets field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the DisableSessionTickets field is set to the value of the last call.
func (b *TLSOptionSpecApplyConfiguration) WithDisableSessionTickets(value bool) *TLSOptionSpecApplyConfiguration {
	b.DisableSessionTickets = &value
	return b
}

// WithPreferServerCipherSuites sets the PreferServerCipherSuites field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the PreferServerCipherSuites field is set to the value of the last call.
func (b *TLSOptionSpecApplyConfiguration) WithPreferServerCipherSuites(value bool) *TLSOptionSpecApplyConfiguration {
	b.PreferServerCipherSuites = &value
	return b
}
