// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// HashicorpCloudVault20201125NetworkConfig hashicorp cloud vault 20201125 network config
//
// swagger:model hashicorp.cloud.vault_20201125.NetworkConfig
type HashicorpCloudVault20201125NetworkConfig struct {

	// cors config
	CorsConfig *HashicorpCloudVault20201125CORSConfig `json:"cors_config,omitempty"`

	// http_proxy_option specifies whether HTTP Proxy should be enabled or disabled.
	HTTPProxyOption *HashicorpCloudVault20201125HTTPProxyOption `json:"http_proxy_option,omitempty"`

	// A list of IP addresses used to restrict access to a cluster.
	IPAllowlist []*HashicorpCloudVault20201125CidrRange `json:"ip_allowlist"`

	// network_id is the ID of the network the Vault cluster belongs to.
	NetworkID string `json:"network_id,omitempty"`

	// public_ips_enabled indicates if public IP's are enabled.
	PublicIpsEnabled bool `json:"public_ips_enabled,omitempty"`
}

// Validate validates this hashicorp cloud vault 20201125 network config
func (m *HashicorpCloudVault20201125NetworkConfig) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCorsConfig(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHTTPProxyOption(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIPAllowlist(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudVault20201125NetworkConfig) validateCorsConfig(formats strfmt.Registry) error {
	if swag.IsZero(m.CorsConfig) { // not required
		return nil
	}

	if m.CorsConfig != nil {
		if err := m.CorsConfig.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cors_config")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("cors_config")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudVault20201125NetworkConfig) validateHTTPProxyOption(formats strfmt.Registry) error {
	if swag.IsZero(m.HTTPProxyOption) { // not required
		return nil
	}

	if m.HTTPProxyOption != nil {
		if err := m.HTTPProxyOption.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("http_proxy_option")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("http_proxy_option")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudVault20201125NetworkConfig) validateIPAllowlist(formats strfmt.Registry) error {
	if swag.IsZero(m.IPAllowlist) { // not required
		return nil
	}

	for i := 0; i < len(m.IPAllowlist); i++ {
		if swag.IsZero(m.IPAllowlist[i]) { // not required
			continue
		}

		if m.IPAllowlist[i] != nil {
			if err := m.IPAllowlist[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("ip_allowlist" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("ip_allowlist" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this hashicorp cloud vault 20201125 network config based on the context it is used
func (m *HashicorpCloudVault20201125NetworkConfig) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCorsConfig(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHTTPProxyOption(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIPAllowlist(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudVault20201125NetworkConfig) contextValidateCorsConfig(ctx context.Context, formats strfmt.Registry) error {

	if m.CorsConfig != nil {

		if swag.IsZero(m.CorsConfig) { // not required
			return nil
		}

		if err := m.CorsConfig.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cors_config")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("cors_config")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudVault20201125NetworkConfig) contextValidateHTTPProxyOption(ctx context.Context, formats strfmt.Registry) error {

	if m.HTTPProxyOption != nil {

		if swag.IsZero(m.HTTPProxyOption) { // not required
			return nil
		}

		if err := m.HTTPProxyOption.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("http_proxy_option")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("http_proxy_option")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudVault20201125NetworkConfig) contextValidateIPAllowlist(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.IPAllowlist); i++ {

		if m.IPAllowlist[i] != nil {

			if swag.IsZero(m.IPAllowlist[i]) { // not required
				return nil
			}

			if err := m.IPAllowlist[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("ip_allowlist" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("ip_allowlist" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudVault20201125NetworkConfig) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudVault20201125NetworkConfig) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudVault20201125NetworkConfig
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
