// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: MPL-2.0

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.5.1
// - protoc             (unknown)
// source: sdk/plugin/pb/backend.proto

package pb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	Backend_HandleRequest_FullMethodName        = "/pb.Backend/HandleRequest"
	Backend_SpecialPaths_FullMethodName         = "/pb.Backend/SpecialPaths"
	Backend_HandleExistenceCheck_FullMethodName = "/pb.Backend/HandleExistenceCheck"
	Backend_Cleanup_FullMethodName              = "/pb.Backend/Cleanup"
	Backend_InvalidateKey_FullMethodName        = "/pb.Backend/InvalidateKey"
	Backend_Setup_FullMethodName                = "/pb.Backend/Setup"
	Backend_Initialize_FullMethodName           = "/pb.Backend/Initialize"
	Backend_Type_FullMethodName                 = "/pb.Backend/Type"
)

// BackendClient is the client API for Backend service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// Backend is the interface that plugins must satisfy. The plugin should
// implement the server for this service. Requests will first run the
// HandleExistenceCheck rpc then run the HandleRequests rpc.
type BackendClient interface {
	// HandleRequest is used to handle a request and generate a response.
	// The plugins must check the operation type and handle appropriately.
	HandleRequest(ctx context.Context, in *HandleRequestArgs, opts ...grpc.CallOption) (*HandleRequestReply, error)
	// SpecialPaths is a list of paths that are special in some way.
	// See PathType for the types of special paths. The key is the type
	// of the special path, and the value is a list of paths for this type.
	// This is not a regular expression but is an exact match. If the path
	// ends in '*' then it is a prefix-based match. The '*' can only appear
	// at the end.
	SpecialPaths(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*SpecialPathsReply, error)
	// HandleExistenceCheck is used to handle a request and generate a response
	// indicating whether the given path exists or not; this is used to
	// understand whether the request must have a Create or Update capability
	// ACL applied. The first bool indicates whether an existence check
	// function was found for the backend; the second indicates whether, if an
	// existence check function was found, the item exists or not.
	HandleExistenceCheck(ctx context.Context, in *HandleExistenceCheckArgs, opts ...grpc.CallOption) (*HandleExistenceCheckReply, error)
	// Cleanup is invoked during an unmount of a backend to allow it to
	// handle any cleanup like connection closing or releasing of file handles.
	// Cleanup is called right before Vault closes the plugin process.
	Cleanup(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*Empty, error)
	// InvalidateKey may be invoked when an object is modified that belongs
	// to the backend. The backend can use this to clear any caches or reset
	// internal state as needed.
	InvalidateKey(ctx context.Context, in *InvalidateKeyArgs, opts ...grpc.CallOption) (*Empty, error)
	// Setup is used to set up the backend based on the provided backend
	// configuration. The plugin's setup implementation should use the provided
	// broker_id to create a connection back to Vault for use with the Storage
	// and SystemView clients.
	Setup(ctx context.Context, in *SetupArgs, opts ...grpc.CallOption) (*SetupReply, error)
	// Initialize is invoked just after mounting a backend to allow it to
	// handle any initialization tasks that need to be performed.
	Initialize(ctx context.Context, in *InitializeArgs, opts ...grpc.CallOption) (*InitializeReply, error)
	// Type returns the BackendType for the particular backend
	Type(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*TypeReply, error)
}

type backendClient struct {
	cc grpc.ClientConnInterface
}

func NewBackendClient(cc grpc.ClientConnInterface) BackendClient {
	return &backendClient{cc}
}

func (c *backendClient) HandleRequest(ctx context.Context, in *HandleRequestArgs, opts ...grpc.CallOption) (*HandleRequestReply, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(HandleRequestReply)
	err := c.cc.Invoke(ctx, Backend_HandleRequest_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backendClient) SpecialPaths(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*SpecialPathsReply, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(SpecialPathsReply)
	err := c.cc.Invoke(ctx, Backend_SpecialPaths_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backendClient) HandleExistenceCheck(ctx context.Context, in *HandleExistenceCheckArgs, opts ...grpc.CallOption) (*HandleExistenceCheckReply, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(HandleExistenceCheckReply)
	err := c.cc.Invoke(ctx, Backend_HandleExistenceCheck_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backendClient) Cleanup(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Empty)
	err := c.cc.Invoke(ctx, Backend_Cleanup_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backendClient) InvalidateKey(ctx context.Context, in *InvalidateKeyArgs, opts ...grpc.CallOption) (*Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Empty)
	err := c.cc.Invoke(ctx, Backend_InvalidateKey_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backendClient) Setup(ctx context.Context, in *SetupArgs, opts ...grpc.CallOption) (*SetupReply, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(SetupReply)
	err := c.cc.Invoke(ctx, Backend_Setup_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backendClient) Initialize(ctx context.Context, in *InitializeArgs, opts ...grpc.CallOption) (*InitializeReply, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(InitializeReply)
	err := c.cc.Invoke(ctx, Backend_Initialize_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backendClient) Type(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*TypeReply, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(TypeReply)
	err := c.cc.Invoke(ctx, Backend_Type_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// BackendServer is the server API for Backend service.
// All implementations must embed UnimplementedBackendServer
// for forward compatibility.
//
// Backend is the interface that plugins must satisfy. The plugin should
// implement the server for this service. Requests will first run the
// HandleExistenceCheck rpc then run the HandleRequests rpc.
type BackendServer interface {
	// HandleRequest is used to handle a request and generate a response.
	// The plugins must check the operation type and handle appropriately.
	HandleRequest(context.Context, *HandleRequestArgs) (*HandleRequestReply, error)
	// SpecialPaths is a list of paths that are special in some way.
	// See PathType for the types of special paths. The key is the type
	// of the special path, and the value is a list of paths for this type.
	// This is not a regular expression but is an exact match. If the path
	// ends in '*' then it is a prefix-based match. The '*' can only appear
	// at the end.
	SpecialPaths(context.Context, *Empty) (*SpecialPathsReply, error)
	// HandleExistenceCheck is used to handle a request and generate a response
	// indicating whether the given path exists or not; this is used to
	// understand whether the request must have a Create or Update capability
	// ACL applied. The first bool indicates whether an existence check
	// function was found for the backend; the second indicates whether, if an
	// existence check function was found, the item exists or not.
	HandleExistenceCheck(context.Context, *HandleExistenceCheckArgs) (*HandleExistenceCheckReply, error)
	// Cleanup is invoked during an unmount of a backend to allow it to
	// handle any cleanup like connection closing or releasing of file handles.
	// Cleanup is called right before Vault closes the plugin process.
	Cleanup(context.Context, *Empty) (*Empty, error)
	// InvalidateKey may be invoked when an object is modified that belongs
	// to the backend. The backend can use this to clear any caches or reset
	// internal state as needed.
	InvalidateKey(context.Context, *InvalidateKeyArgs) (*Empty, error)
	// Setup is used to set up the backend based on the provided backend
	// configuration. The plugin's setup implementation should use the provided
	// broker_id to create a connection back to Vault for use with the Storage
	// and SystemView clients.
	Setup(context.Context, *SetupArgs) (*SetupReply, error)
	// Initialize is invoked just after mounting a backend to allow it to
	// handle any initialization tasks that need to be performed.
	Initialize(context.Context, *InitializeArgs) (*InitializeReply, error)
	// Type returns the BackendType for the particular backend
	Type(context.Context, *Empty) (*TypeReply, error)
	mustEmbedUnimplementedBackendServer()
}

// UnimplementedBackendServer must be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedBackendServer struct{}

func (UnimplementedBackendServer) HandleRequest(context.Context, *HandleRequestArgs) (*HandleRequestReply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method HandleRequest not implemented")
}
func (UnimplementedBackendServer) SpecialPaths(context.Context, *Empty) (*SpecialPathsReply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SpecialPaths not implemented")
}
func (UnimplementedBackendServer) HandleExistenceCheck(context.Context, *HandleExistenceCheckArgs) (*HandleExistenceCheckReply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method HandleExistenceCheck not implemented")
}
func (UnimplementedBackendServer) Cleanup(context.Context, *Empty) (*Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Cleanup not implemented")
}
func (UnimplementedBackendServer) InvalidateKey(context.Context, *InvalidateKeyArgs) (*Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method InvalidateKey not implemented")
}
func (UnimplementedBackendServer) Setup(context.Context, *SetupArgs) (*SetupReply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Setup not implemented")
}
func (UnimplementedBackendServer) Initialize(context.Context, *InitializeArgs) (*InitializeReply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Initialize not implemented")
}
func (UnimplementedBackendServer) Type(context.Context, *Empty) (*TypeReply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Type not implemented")
}
func (UnimplementedBackendServer) mustEmbedUnimplementedBackendServer() {}
func (UnimplementedBackendServer) testEmbeddedByValue()                 {}

// UnsafeBackendServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to BackendServer will
// result in compilation errors.
type UnsafeBackendServer interface {
	mustEmbedUnimplementedBackendServer()
}

func RegisterBackendServer(s grpc.ServiceRegistrar, srv BackendServer) {
	// If the following call pancis, it indicates UnimplementedBackendServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&Backend_ServiceDesc, srv)
}

func _Backend_HandleRequest_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(HandleRequestArgs)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackendServer).HandleRequest(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Backend_HandleRequest_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackendServer).HandleRequest(ctx, req.(*HandleRequestArgs))
	}
	return interceptor(ctx, in, info, handler)
}

func _Backend_SpecialPaths_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackendServer).SpecialPaths(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Backend_SpecialPaths_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackendServer).SpecialPaths(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Backend_HandleExistenceCheck_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(HandleExistenceCheckArgs)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackendServer).HandleExistenceCheck(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Backend_HandleExistenceCheck_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackendServer).HandleExistenceCheck(ctx, req.(*HandleExistenceCheckArgs))
	}
	return interceptor(ctx, in, info, handler)
}

func _Backend_Cleanup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackendServer).Cleanup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Backend_Cleanup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackendServer).Cleanup(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _Backend_InvalidateKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InvalidateKeyArgs)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackendServer).InvalidateKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Backend_InvalidateKey_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackendServer).InvalidateKey(ctx, req.(*InvalidateKeyArgs))
	}
	return interceptor(ctx, in, info, handler)
}

func _Backend_Setup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetupArgs)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackendServer).Setup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Backend_Setup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackendServer).Setup(ctx, req.(*SetupArgs))
	}
	return interceptor(ctx, in, info, handler)
}

func _Backend_Initialize_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InitializeArgs)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackendServer).Initialize(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Backend_Initialize_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackendServer).Initialize(ctx, req.(*InitializeArgs))
	}
	return interceptor(ctx, in, info, handler)
}

func _Backend_Type_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackendServer).Type(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Backend_Type_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackendServer).Type(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

// Backend_ServiceDesc is the grpc.ServiceDesc for Backend service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Backend_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "pb.Backend",
	HandlerType: (*BackendServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "HandleRequest",
			Handler:    _Backend_HandleRequest_Handler,
		},
		{
			MethodName: "SpecialPaths",
			Handler:    _Backend_SpecialPaths_Handler,
		},
		{
			MethodName: "HandleExistenceCheck",
			Handler:    _Backend_HandleExistenceCheck_Handler,
		},
		{
			MethodName: "Cleanup",
			Handler:    _Backend_Cleanup_Handler,
		},
		{
			MethodName: "InvalidateKey",
			Handler:    _Backend_InvalidateKey_Handler,
		},
		{
			MethodName: "Setup",
			Handler:    _Backend_Setup_Handler,
		},
		{
			MethodName: "Initialize",
			Handler:    _Backend_Initialize_Handler,
		},
		{
			MethodName: "Type",
			Handler:    _Backend_Type_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "sdk/plugin/pb/backend.proto",
}

const (
	Storage_List_FullMethodName   = "/pb.Storage/List"
	Storage_Get_FullMethodName    = "/pb.Storage/Get"
	Storage_Put_FullMethodName    = "/pb.Storage/Put"
	Storage_Delete_FullMethodName = "/pb.Storage/Delete"
)

// StorageClient is the client API for Storage service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// Storage is the way that plugins are able read/write data. Plugins should
// implement the client for this service.
type StorageClient interface {
	List(ctx context.Context, in *StorageListArgs, opts ...grpc.CallOption) (*StorageListReply, error)
	Get(ctx context.Context, in *StorageGetArgs, opts ...grpc.CallOption) (*StorageGetReply, error)
	Put(ctx context.Context, in *StoragePutArgs, opts ...grpc.CallOption) (*StoragePutReply, error)
	Delete(ctx context.Context, in *StorageDeleteArgs, opts ...grpc.CallOption) (*StorageDeleteReply, error)
}

type storageClient struct {
	cc grpc.ClientConnInterface
}

func NewStorageClient(cc grpc.ClientConnInterface) StorageClient {
	return &storageClient{cc}
}

func (c *storageClient) List(ctx context.Context, in *StorageListArgs, opts ...grpc.CallOption) (*StorageListReply, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(StorageListReply)
	err := c.cc.Invoke(ctx, Storage_List_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) Get(ctx context.Context, in *StorageGetArgs, opts ...grpc.CallOption) (*StorageGetReply, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(StorageGetReply)
	err := c.cc.Invoke(ctx, Storage_Get_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) Put(ctx context.Context, in *StoragePutArgs, opts ...grpc.CallOption) (*StoragePutReply, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(StoragePutReply)
	err := c.cc.Invoke(ctx, Storage_Put_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) Delete(ctx context.Context, in *StorageDeleteArgs, opts ...grpc.CallOption) (*StorageDeleteReply, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(StorageDeleteReply)
	err := c.cc.Invoke(ctx, Storage_Delete_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// StorageServer is the server API for Storage service.
// All implementations must embed UnimplementedStorageServer
// for forward compatibility.
//
// Storage is the way that plugins are able read/write data. Plugins should
// implement the client for this service.
type StorageServer interface {
	List(context.Context, *StorageListArgs) (*StorageListReply, error)
	Get(context.Context, *StorageGetArgs) (*StorageGetReply, error)
	Put(context.Context, *StoragePutArgs) (*StoragePutReply, error)
	Delete(context.Context, *StorageDeleteArgs) (*StorageDeleteReply, error)
	mustEmbedUnimplementedStorageServer()
}

// UnimplementedStorageServer must be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedStorageServer struct{}

func (UnimplementedStorageServer) List(context.Context, *StorageListArgs) (*StorageListReply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedStorageServer) Get(context.Context, *StorageGetArgs) (*StorageGetReply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedStorageServer) Put(context.Context, *StoragePutArgs) (*StoragePutReply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Put not implemented")
}
func (UnimplementedStorageServer) Delete(context.Context, *StorageDeleteArgs) (*StorageDeleteReply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedStorageServer) mustEmbedUnimplementedStorageServer() {}
func (UnimplementedStorageServer) testEmbeddedByValue()                 {}

// UnsafeStorageServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to StorageServer will
// result in compilation errors.
type UnsafeStorageServer interface {
	mustEmbedUnimplementedStorageServer()
}

func RegisterStorageServer(s grpc.ServiceRegistrar, srv StorageServer) {
	// If the following call pancis, it indicates UnimplementedStorageServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&Storage_ServiceDesc, srv)
}

func _Storage_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StorageListArgs)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Storage_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).List(ctx, req.(*StorageListArgs))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StorageGetArgs)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Storage_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).Get(ctx, req.(*StorageGetArgs))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_Put_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StoragePutArgs)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).Put(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Storage_Put_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).Put(ctx, req.(*StoragePutArgs))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StorageDeleteArgs)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Storage_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).Delete(ctx, req.(*StorageDeleteArgs))
	}
	return interceptor(ctx, in, info, handler)
}

// Storage_ServiceDesc is the grpc.ServiceDesc for Storage service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Storage_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "pb.Storage",
	HandlerType: (*StorageServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "List",
			Handler:    _Storage_List_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _Storage_Get_Handler,
		},
		{
			MethodName: "Put",
			Handler:    _Storage_Put_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _Storage_Delete_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "sdk/plugin/pb/backend.proto",
}

const (
	SystemView_DefaultLeaseTTL_FullMethodName            = "/pb.SystemView/DefaultLeaseTTL"
	SystemView_MaxLeaseTTL_FullMethodName                = "/pb.SystemView/MaxLeaseTTL"
	SystemView_Tainted_FullMethodName                    = "/pb.SystemView/Tainted"
	SystemView_CachingDisabled_FullMethodName            = "/pb.SystemView/CachingDisabled"
	SystemView_ReplicationState_FullMethodName           = "/pb.SystemView/ReplicationState"
	SystemView_ResponseWrapData_FullMethodName           = "/pb.SystemView/ResponseWrapData"
	SystemView_MlockEnabled_FullMethodName               = "/pb.SystemView/MlockEnabled"
	SystemView_LocalMount_FullMethodName                 = "/pb.SystemView/LocalMount"
	SystemView_EntityInfo_FullMethodName                 = "/pb.SystemView/EntityInfo"
	SystemView_PluginEnv_FullMethodName                  = "/pb.SystemView/PluginEnv"
	SystemView_GroupsForEntity_FullMethodName            = "/pb.SystemView/GroupsForEntity"
	SystemView_GeneratePasswordFromPolicy_FullMethodName = "/pb.SystemView/GeneratePasswordFromPolicy"
	SystemView_ClusterInfo_FullMethodName                = "/pb.SystemView/ClusterInfo"
	SystemView_GenerateIdentityToken_FullMethodName      = "/pb.SystemView/GenerateIdentityToken"
	SystemView_RegisterRotationJob_FullMethodName        = "/pb.SystemView/RegisterRotationJob"
	SystemView_DeregisterRotationJob_FullMethodName      = "/pb.SystemView/DeregisterRotationJob"
)

// SystemViewClient is the client API for SystemView service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// SystemView exposes system configuration information in a safe way for plugins
// to consume. Plugins should implement the client for this service.
type SystemViewClient interface {
	// DefaultLeaseTTL returns the default lease TTL set in Vault configuration
	DefaultLeaseTTL(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*TTLReply, error)
	// MaxLeaseTTL returns the max lease TTL set in Vault configuration; backend
	// authors should take care not to issue credentials that last longer than
	// this value, as Vault will revoke them
	MaxLeaseTTL(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*TTLReply, error)
	// Tainted, returns true if the mount is tainted. A mount is tainted if it is in the
	// process of being unmounted. This should only be used in special
	// circumstances; a primary use-case is as a guard in revocation functions.
	// If revocation of a backend's leases fails it can keep the unmounting
	// process from being successful. If the reason for this failure is not
	// relevant when the mount is tainted (for instance, saving a CRL to disk
	// when the stored CRL will be removed during the unmounting process
	// anyways), we can ignore the errors to allow unmounting to complete.
	Tainted(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*TaintedReply, error)
	// CachingDisabled returns true if caching is disabled. If true, no caches
	// should be used, despite known slowdowns.
	CachingDisabled(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*CachingDisabledReply, error)
	// ReplicationState indicates the state of cluster replication
	ReplicationState(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*ReplicationStateReply, error)
	// ResponseWrapData wraps the given data in a cubbyhole and returns the
	// token used to unwrap.
	ResponseWrapData(ctx context.Context, in *ResponseWrapDataArgs, opts ...grpc.CallOption) (*ResponseWrapDataReply, error)
	// MlockEnabled returns the configuration setting for enabling mlock on
	// plugins.
	MlockEnabled(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*MlockEnabledReply, error)
	// LocalMount, when run from a system view attached to a request, indicates
	// whether the request is affecting a local mount or not
	LocalMount(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*LocalMountReply, error)
	// EntityInfo returns the basic entity information for the given entity id
	EntityInfo(ctx context.Context, in *EntityInfoArgs, opts ...grpc.CallOption) (*EntityInfoReply, error)
	// PluginEnv returns Vault environment information used by plugins
	PluginEnv(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*PluginEnvReply, error)
	// GroupsForEntity returns the group membership information for the given
	// entity id
	GroupsForEntity(ctx context.Context, in *EntityInfoArgs, opts ...grpc.CallOption) (*GroupsForEntityReply, error)
	// GeneratePasswordFromPolicy generates a password from an existing password policy
	GeneratePasswordFromPolicy(ctx context.Context, in *GeneratePasswordFromPolicyRequest, opts ...grpc.CallOption) (*GeneratePasswordFromPolicyReply, error)
	// ClusterInfo returns the ClusterID information; may be reused if ClusterName is also exposed.
	ClusterInfo(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*ClusterInfoReply, error)
	// GenerateIdentityToken returns an identity token for the requesting plugin.
	GenerateIdentityToken(ctx context.Context, in *GenerateIdentityTokenRequest, opts ...grpc.CallOption) (*GenerateIdentityTokenResponse, error)
	// RegisterRotationJob returns a rotation ID for the requested plugin credential.
	RegisterRotationJob(ctx context.Context, in *RegisterRotationJobRequest, opts ...grpc.CallOption) (*RegisterRotationJobResponse, error)
	// DeregisterRotationJob returns any errors in de-registering a credential from the Rotation Manager.
	DeregisterRotationJob(ctx context.Context, in *DeregisterRotationJobRequest, opts ...grpc.CallOption) (*Empty, error)
}

type systemViewClient struct {
	cc grpc.ClientConnInterface
}

func NewSystemViewClient(cc grpc.ClientConnInterface) SystemViewClient {
	return &systemViewClient{cc}
}

func (c *systemViewClient) DefaultLeaseTTL(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*TTLReply, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(TTLReply)
	err := c.cc.Invoke(ctx, SystemView_DefaultLeaseTTL_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *systemViewClient) MaxLeaseTTL(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*TTLReply, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(TTLReply)
	err := c.cc.Invoke(ctx, SystemView_MaxLeaseTTL_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *systemViewClient) Tainted(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*TaintedReply, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(TaintedReply)
	err := c.cc.Invoke(ctx, SystemView_Tainted_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *systemViewClient) CachingDisabled(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*CachingDisabledReply, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(CachingDisabledReply)
	err := c.cc.Invoke(ctx, SystemView_CachingDisabled_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *systemViewClient) ReplicationState(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*ReplicationStateReply, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ReplicationStateReply)
	err := c.cc.Invoke(ctx, SystemView_ReplicationState_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *systemViewClient) ResponseWrapData(ctx context.Context, in *ResponseWrapDataArgs, opts ...grpc.CallOption) (*ResponseWrapDataReply, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ResponseWrapDataReply)
	err := c.cc.Invoke(ctx, SystemView_ResponseWrapData_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *systemViewClient) MlockEnabled(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*MlockEnabledReply, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(MlockEnabledReply)
	err := c.cc.Invoke(ctx, SystemView_MlockEnabled_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *systemViewClient) LocalMount(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*LocalMountReply, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(LocalMountReply)
	err := c.cc.Invoke(ctx, SystemView_LocalMount_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *systemViewClient) EntityInfo(ctx context.Context, in *EntityInfoArgs, opts ...grpc.CallOption) (*EntityInfoReply, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(EntityInfoReply)
	err := c.cc.Invoke(ctx, SystemView_EntityInfo_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *systemViewClient) PluginEnv(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*PluginEnvReply, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(PluginEnvReply)
	err := c.cc.Invoke(ctx, SystemView_PluginEnv_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *systemViewClient) GroupsForEntity(ctx context.Context, in *EntityInfoArgs, opts ...grpc.CallOption) (*GroupsForEntityReply, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GroupsForEntityReply)
	err := c.cc.Invoke(ctx, SystemView_GroupsForEntity_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *systemViewClient) GeneratePasswordFromPolicy(ctx context.Context, in *GeneratePasswordFromPolicyRequest, opts ...grpc.CallOption) (*GeneratePasswordFromPolicyReply, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GeneratePasswordFromPolicyReply)
	err := c.cc.Invoke(ctx, SystemView_GeneratePasswordFromPolicy_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *systemViewClient) ClusterInfo(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*ClusterInfoReply, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ClusterInfoReply)
	err := c.cc.Invoke(ctx, SystemView_ClusterInfo_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *systemViewClient) GenerateIdentityToken(ctx context.Context, in *GenerateIdentityTokenRequest, opts ...grpc.CallOption) (*GenerateIdentityTokenResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GenerateIdentityTokenResponse)
	err := c.cc.Invoke(ctx, SystemView_GenerateIdentityToken_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *systemViewClient) RegisterRotationJob(ctx context.Context, in *RegisterRotationJobRequest, opts ...grpc.CallOption) (*RegisterRotationJobResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(RegisterRotationJobResponse)
	err := c.cc.Invoke(ctx, SystemView_RegisterRotationJob_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *systemViewClient) DeregisterRotationJob(ctx context.Context, in *DeregisterRotationJobRequest, opts ...grpc.CallOption) (*Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Empty)
	err := c.cc.Invoke(ctx, SystemView_DeregisterRotationJob_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SystemViewServer is the server API for SystemView service.
// All implementations must embed UnimplementedSystemViewServer
// for forward compatibility.
//
// SystemView exposes system configuration information in a safe way for plugins
// to consume. Plugins should implement the client for this service.
type SystemViewServer interface {
	// DefaultLeaseTTL returns the default lease TTL set in Vault configuration
	DefaultLeaseTTL(context.Context, *Empty) (*TTLReply, error)
	// MaxLeaseTTL returns the max lease TTL set in Vault configuration; backend
	// authors should take care not to issue credentials that last longer than
	// this value, as Vault will revoke them
	MaxLeaseTTL(context.Context, *Empty) (*TTLReply, error)
	// Tainted, returns true if the mount is tainted. A mount is tainted if it is in the
	// process of being unmounted. This should only be used in special
	// circumstances; a primary use-case is as a guard in revocation functions.
	// If revocation of a backend's leases fails it can keep the unmounting
	// process from being successful. If the reason for this failure is not
	// relevant when the mount is tainted (for instance, saving a CRL to disk
	// when the stored CRL will be removed during the unmounting process
	// anyways), we can ignore the errors to allow unmounting to complete.
	Tainted(context.Context, *Empty) (*TaintedReply, error)
	// CachingDisabled returns true if caching is disabled. If true, no caches
	// should be used, despite known slowdowns.
	CachingDisabled(context.Context, *Empty) (*CachingDisabledReply, error)
	// ReplicationState indicates the state of cluster replication
	ReplicationState(context.Context, *Empty) (*ReplicationStateReply, error)
	// ResponseWrapData wraps the given data in a cubbyhole and returns the
	// token used to unwrap.
	ResponseWrapData(context.Context, *ResponseWrapDataArgs) (*ResponseWrapDataReply, error)
	// MlockEnabled returns the configuration setting for enabling mlock on
	// plugins.
	MlockEnabled(context.Context, *Empty) (*MlockEnabledReply, error)
	// LocalMount, when run from a system view attached to a request, indicates
	// whether the request is affecting a local mount or not
	LocalMount(context.Context, *Empty) (*LocalMountReply, error)
	// EntityInfo returns the basic entity information for the given entity id
	EntityInfo(context.Context, *EntityInfoArgs) (*EntityInfoReply, error)
	// PluginEnv returns Vault environment information used by plugins
	PluginEnv(context.Context, *Empty) (*PluginEnvReply, error)
	// GroupsForEntity returns the group membership information for the given
	// entity id
	GroupsForEntity(context.Context, *EntityInfoArgs) (*GroupsForEntityReply, error)
	// GeneratePasswordFromPolicy generates a password from an existing password policy
	GeneratePasswordFromPolicy(context.Context, *GeneratePasswordFromPolicyRequest) (*GeneratePasswordFromPolicyReply, error)
	// ClusterInfo returns the ClusterID information; may be reused if ClusterName is also exposed.
	ClusterInfo(context.Context, *Empty) (*ClusterInfoReply, error)
	// GenerateIdentityToken returns an identity token for the requesting plugin.
	GenerateIdentityToken(context.Context, *GenerateIdentityTokenRequest) (*GenerateIdentityTokenResponse, error)
	// RegisterRotationJob returns a rotation ID for the requested plugin credential.
	RegisterRotationJob(context.Context, *RegisterRotationJobRequest) (*RegisterRotationJobResponse, error)
	// DeregisterRotationJob returns any errors in de-registering a credential from the Rotation Manager.
	DeregisterRotationJob(context.Context, *DeregisterRotationJobRequest) (*Empty, error)
	mustEmbedUnimplementedSystemViewServer()
}

// UnimplementedSystemViewServer must be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedSystemViewServer struct{}

func (UnimplementedSystemViewServer) DefaultLeaseTTL(context.Context, *Empty) (*TTLReply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DefaultLeaseTTL not implemented")
}
func (UnimplementedSystemViewServer) MaxLeaseTTL(context.Context, *Empty) (*TTLReply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MaxLeaseTTL not implemented")
}
func (UnimplementedSystemViewServer) Tainted(context.Context, *Empty) (*TaintedReply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Tainted not implemented")
}
func (UnimplementedSystemViewServer) CachingDisabled(context.Context, *Empty) (*CachingDisabledReply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CachingDisabled not implemented")
}
func (UnimplementedSystemViewServer) ReplicationState(context.Context, *Empty) (*ReplicationStateReply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReplicationState not implemented")
}
func (UnimplementedSystemViewServer) ResponseWrapData(context.Context, *ResponseWrapDataArgs) (*ResponseWrapDataReply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResponseWrapData not implemented")
}
func (UnimplementedSystemViewServer) MlockEnabled(context.Context, *Empty) (*MlockEnabledReply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MlockEnabled not implemented")
}
func (UnimplementedSystemViewServer) LocalMount(context.Context, *Empty) (*LocalMountReply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LocalMount not implemented")
}
func (UnimplementedSystemViewServer) EntityInfo(context.Context, *EntityInfoArgs) (*EntityInfoReply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method EntityInfo not implemented")
}
func (UnimplementedSystemViewServer) PluginEnv(context.Context, *Empty) (*PluginEnvReply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PluginEnv not implemented")
}
func (UnimplementedSystemViewServer) GroupsForEntity(context.Context, *EntityInfoArgs) (*GroupsForEntityReply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GroupsForEntity not implemented")
}
func (UnimplementedSystemViewServer) GeneratePasswordFromPolicy(context.Context, *GeneratePasswordFromPolicyRequest) (*GeneratePasswordFromPolicyReply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GeneratePasswordFromPolicy not implemented")
}
func (UnimplementedSystemViewServer) ClusterInfo(context.Context, *Empty) (*ClusterInfoReply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ClusterInfo not implemented")
}
func (UnimplementedSystemViewServer) GenerateIdentityToken(context.Context, *GenerateIdentityTokenRequest) (*GenerateIdentityTokenResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateIdentityToken not implemented")
}
func (UnimplementedSystemViewServer) RegisterRotationJob(context.Context, *RegisterRotationJobRequest) (*RegisterRotationJobResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RegisterRotationJob not implemented")
}
func (UnimplementedSystemViewServer) DeregisterRotationJob(context.Context, *DeregisterRotationJobRequest) (*Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeregisterRotationJob not implemented")
}
func (UnimplementedSystemViewServer) mustEmbedUnimplementedSystemViewServer() {}
func (UnimplementedSystemViewServer) testEmbeddedByValue()                    {}

// UnsafeSystemViewServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to SystemViewServer will
// result in compilation errors.
type UnsafeSystemViewServer interface {
	mustEmbedUnimplementedSystemViewServer()
}

func RegisterSystemViewServer(s grpc.ServiceRegistrar, srv SystemViewServer) {
	// If the following call pancis, it indicates UnimplementedSystemViewServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&SystemView_ServiceDesc, srv)
}

func _SystemView_DefaultLeaseTTL_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SystemViewServer).DefaultLeaseTTL(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SystemView_DefaultLeaseTTL_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SystemViewServer).DefaultLeaseTTL(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _SystemView_MaxLeaseTTL_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SystemViewServer).MaxLeaseTTL(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SystemView_MaxLeaseTTL_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SystemViewServer).MaxLeaseTTL(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _SystemView_Tainted_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SystemViewServer).Tainted(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SystemView_Tainted_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SystemViewServer).Tainted(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _SystemView_CachingDisabled_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SystemViewServer).CachingDisabled(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SystemView_CachingDisabled_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SystemViewServer).CachingDisabled(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _SystemView_ReplicationState_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SystemViewServer).ReplicationState(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SystemView_ReplicationState_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SystemViewServer).ReplicationState(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _SystemView_ResponseWrapData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResponseWrapDataArgs)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SystemViewServer).ResponseWrapData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SystemView_ResponseWrapData_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SystemViewServer).ResponseWrapData(ctx, req.(*ResponseWrapDataArgs))
	}
	return interceptor(ctx, in, info, handler)
}

func _SystemView_MlockEnabled_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SystemViewServer).MlockEnabled(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SystemView_MlockEnabled_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SystemViewServer).MlockEnabled(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _SystemView_LocalMount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SystemViewServer).LocalMount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SystemView_LocalMount_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SystemViewServer).LocalMount(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _SystemView_EntityInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EntityInfoArgs)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SystemViewServer).EntityInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SystemView_EntityInfo_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SystemViewServer).EntityInfo(ctx, req.(*EntityInfoArgs))
	}
	return interceptor(ctx, in, info, handler)
}

func _SystemView_PluginEnv_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SystemViewServer).PluginEnv(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SystemView_PluginEnv_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SystemViewServer).PluginEnv(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _SystemView_GroupsForEntity_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EntityInfoArgs)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SystemViewServer).GroupsForEntity(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SystemView_GroupsForEntity_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SystemViewServer).GroupsForEntity(ctx, req.(*EntityInfoArgs))
	}
	return interceptor(ctx, in, info, handler)
}

func _SystemView_GeneratePasswordFromPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GeneratePasswordFromPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SystemViewServer).GeneratePasswordFromPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SystemView_GeneratePasswordFromPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SystemViewServer).GeneratePasswordFromPolicy(ctx, req.(*GeneratePasswordFromPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SystemView_ClusterInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SystemViewServer).ClusterInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SystemView_ClusterInfo_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SystemViewServer).ClusterInfo(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _SystemView_GenerateIdentityToken_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateIdentityTokenRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SystemViewServer).GenerateIdentityToken(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SystemView_GenerateIdentityToken_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SystemViewServer).GenerateIdentityToken(ctx, req.(*GenerateIdentityTokenRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SystemView_RegisterRotationJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RegisterRotationJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SystemViewServer).RegisterRotationJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SystemView_RegisterRotationJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SystemViewServer).RegisterRotationJob(ctx, req.(*RegisterRotationJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SystemView_DeregisterRotationJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeregisterRotationJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SystemViewServer).DeregisterRotationJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SystemView_DeregisterRotationJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SystemViewServer).DeregisterRotationJob(ctx, req.(*DeregisterRotationJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// SystemView_ServiceDesc is the grpc.ServiceDesc for SystemView service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var SystemView_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "pb.SystemView",
	HandlerType: (*SystemViewServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "DefaultLeaseTTL",
			Handler:    _SystemView_DefaultLeaseTTL_Handler,
		},
		{
			MethodName: "MaxLeaseTTL",
			Handler:    _SystemView_MaxLeaseTTL_Handler,
		},
		{
			MethodName: "Tainted",
			Handler:    _SystemView_Tainted_Handler,
		},
		{
			MethodName: "CachingDisabled",
			Handler:    _SystemView_CachingDisabled_Handler,
		},
		{
			MethodName: "ReplicationState",
			Handler:    _SystemView_ReplicationState_Handler,
		},
		{
			MethodName: "ResponseWrapData",
			Handler:    _SystemView_ResponseWrapData_Handler,
		},
		{
			MethodName: "MlockEnabled",
			Handler:    _SystemView_MlockEnabled_Handler,
		},
		{
			MethodName: "LocalMount",
			Handler:    _SystemView_LocalMount_Handler,
		},
		{
			MethodName: "EntityInfo",
			Handler:    _SystemView_EntityInfo_Handler,
		},
		{
			MethodName: "PluginEnv",
			Handler:    _SystemView_PluginEnv_Handler,
		},
		{
			MethodName: "GroupsForEntity",
			Handler:    _SystemView_GroupsForEntity_Handler,
		},
		{
			MethodName: "GeneratePasswordFromPolicy",
			Handler:    _SystemView_GeneratePasswordFromPolicy_Handler,
		},
		{
			MethodName: "ClusterInfo",
			Handler:    _SystemView_ClusterInfo_Handler,
		},
		{
			MethodName: "GenerateIdentityToken",
			Handler:    _SystemView_GenerateIdentityToken_Handler,
		},
		{
			MethodName: "RegisterRotationJob",
			Handler:    _SystemView_RegisterRotationJob_Handler,
		},
		{
			MethodName: "DeregisterRotationJob",
			Handler:    _SystemView_DeregisterRotationJob_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "sdk/plugin/pb/backend.proto",
}

const (
	Events_SendEvent_FullMethodName = "/pb.Events/SendEvent"
)

// EventsClient is the client API for Events service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type EventsClient interface {
	SendEvent(ctx context.Context, in *SendEventRequest, opts ...grpc.CallOption) (*Empty, error)
}

type eventsClient struct {
	cc grpc.ClientConnInterface
}

func NewEventsClient(cc grpc.ClientConnInterface) EventsClient {
	return &eventsClient{cc}
}

func (c *eventsClient) SendEvent(ctx context.Context, in *SendEventRequest, opts ...grpc.CallOption) (*Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Empty)
	err := c.cc.Invoke(ctx, Events_SendEvent_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// EventsServer is the server API for Events service.
// All implementations must embed UnimplementedEventsServer
// for forward compatibility.
type EventsServer interface {
	SendEvent(context.Context, *SendEventRequest) (*Empty, error)
	mustEmbedUnimplementedEventsServer()
}

// UnimplementedEventsServer must be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedEventsServer struct{}

func (UnimplementedEventsServer) SendEvent(context.Context, *SendEventRequest) (*Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SendEvent not implemented")
}
func (UnimplementedEventsServer) mustEmbedUnimplementedEventsServer() {}
func (UnimplementedEventsServer) testEmbeddedByValue()                {}

// UnsafeEventsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to EventsServer will
// result in compilation errors.
type UnsafeEventsServer interface {
	mustEmbedUnimplementedEventsServer()
}

func RegisterEventsServer(s grpc.ServiceRegistrar, srv EventsServer) {
	// If the following call pancis, it indicates UnimplementedEventsServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&Events_ServiceDesc, srv)
}

func _Events_SendEvent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SendEventRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EventsServer).SendEvent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Events_SendEvent_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EventsServer).SendEvent(ctx, req.(*SendEventRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Events_ServiceDesc is the grpc.ServiceDesc for Events service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Events_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "pb.Events",
	HandlerType: (*EventsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "SendEvent",
			Handler:    _Events_SendEvent_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "sdk/plugin/pb/backend.proto",
}

const (
	Observations_RecordObservation_FullMethodName = "/pb.Observations/RecordObservation"
)

// ObservationsClient is the client API for Observations service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ObservationsClient interface {
	RecordObservation(ctx context.Context, in *RecordObservationRequest, opts ...grpc.CallOption) (*Empty, error)
}

type observationsClient struct {
	cc grpc.ClientConnInterface
}

func NewObservationsClient(cc grpc.ClientConnInterface) ObservationsClient {
	return &observationsClient{cc}
}

func (c *observationsClient) RecordObservation(ctx context.Context, in *RecordObservationRequest, opts ...grpc.CallOption) (*Empty, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Empty)
	err := c.cc.Invoke(ctx, Observations_RecordObservation_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ObservationsServer is the server API for Observations service.
// All implementations must embed UnimplementedObservationsServer
// for forward compatibility.
type ObservationsServer interface {
	RecordObservation(context.Context, *RecordObservationRequest) (*Empty, error)
	mustEmbedUnimplementedObservationsServer()
}

// UnimplementedObservationsServer must be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedObservationsServer struct{}

func (UnimplementedObservationsServer) RecordObservation(context.Context, *RecordObservationRequest) (*Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RecordObservation not implemented")
}
func (UnimplementedObservationsServer) mustEmbedUnimplementedObservationsServer() {}
func (UnimplementedObservationsServer) testEmbeddedByValue()                      {}

// UnsafeObservationsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ObservationsServer will
// result in compilation errors.
type UnsafeObservationsServer interface {
	mustEmbedUnimplementedObservationsServer()
}

func RegisterObservationsServer(s grpc.ServiceRegistrar, srv ObservationsServer) {
	// If the following call pancis, it indicates UnimplementedObservationsServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&Observations_ServiceDesc, srv)
}

func _Observations_RecordObservation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RecordObservationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ObservationsServer).RecordObservation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Observations_RecordObservation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ObservationsServer).RecordObservation(ctx, req.(*RecordObservationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Observations_ServiceDesc is the grpc.ServiceDesc for Observations service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Observations_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "pb.Observations",
	HandlerType: (*ObservationsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "RecordObservation",
			Handler:    _Observations_RecordObservation_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "sdk/plugin/pb/backend.proto",
}
