/*
 * Copyright (c) 2020-2025 Valve Corporation
 * Copyright (c) 2020-2025 LunarG, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Authors:
 * - Christophe Riccio <christophe@lunarg.com>
 */

#include "widget_setting_group.h"

#include <cassert>

WidgetSettingGroup::WidgetSettingGroup(QTreeWidget* tree, QTreeWidgetItem* item, const SettingMetaGroup& meta,
                                       SettingDataSet& data_set)
    : WidgetSettingBase(tree, item), meta(meta), data_set(data_set) {
    this->item->setText(0, meta.label.c_str());
    this->item->setToolTip(0, meta.description.c_str());
    this->item->setFont(0, tree->font());

    this->item->setSizeHint(0, QSize(0, ITEM_HEIGHT));
    this->tree->setItemWidget(this->item, 0, this);

    this->Refresh(REFRESH_ENABLE_AND_STATE);
}

void WidgetSettingGroup::Refresh(RefreshAreas refresh_areas) {
    (void)refresh_areas;

    const SettingDependenceMode enabled = ::CheckDependence(this->meta, this->data_set);

    this->item->setHidden(enabled == SETTING_DEPENDENCE_HIDE);
    this->item->setDisabled(enabled != SETTING_DEPENDENCE_ENABLE);
    this->setEnabled(enabled == SETTING_DEPENDENCE_ENABLE);
}
