/* Generated by wayland-scanner 1.24.0 */

#ifndef LINUX_DMABUF_V1_SERVER_PROTOCOL_H
#define LINUX_DMABUF_V1_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_linux_dmabuf_v1 The linux_dmabuf_v1 protocol
 * @section page_ifaces_linux_dmabuf_v1 Interfaces
 * - @subpage page_iface_zwp_linux_dmabuf_v1 - factory for creating dmabuf-based wl_buffers
 * - @subpage page_iface_zwp_linux_buffer_params_v1 - parameters for creating a dmabuf-based wl_buffer
 * - @subpage page_iface_zwp_linux_dmabuf_feedback_v1 - dmabuf feedback
 * @section page_copyright_linux_dmabuf_v1 Copyright
 * <pre>
 *
 * Copyright © 2014, 2015 Collabora, Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct wl_buffer;
struct wl_surface;
struct zwp_linux_buffer_params_v1;
struct zwp_linux_dmabuf_feedback_v1;
struct zwp_linux_dmabuf_v1;

#ifndef ZWP_LINUX_DMABUF_V1_INTERFACE
#define ZWP_LINUX_DMABUF_V1_INTERFACE
/**
 * @page page_iface_zwp_linux_dmabuf_v1 zwp_linux_dmabuf_v1
 * @section page_iface_zwp_linux_dmabuf_v1_desc Description
 *
 * This interface offers ways to create generic dmabuf-based wl_buffers.
 *
 * For more information about dmabuf, see:
 * https://www.kernel.org/doc/html/next/userspace-api/dma-buf-alloc-exchange.html
 *
 * Clients can use the get_surface_feedback request to get dmabuf feedback
 * for a particular surface. If the client wants to retrieve feedback not
 * tied to a surface, they can use the get_default_feedback request.
 *
 * The following are required from clients:
 *
 * - Clients must ensure that either all data in the dma-buf is
 * coherent for all subsequent read access or that coherency is
 * correctly handled by the underlying kernel-side dma-buf
 * implementation.
 *
 * - Don't make any more attachments after sending the buffer to the
 * compositor. Making more attachments later increases the risk of
 * the compositor not being able to use (re-import) an existing
 * dmabuf-based wl_buffer.
 *
 * The underlying graphics stack must ensure the following:
 *
 * - The dmabuf file descriptors relayed to the server will stay valid
 * for the whole lifetime of the wl_buffer. This means the server may
 * at any time use those fds to import the dmabuf into any kernel
 * sub-system that might accept it.
 *
 * However, when the underlying graphics stack fails to deliver the
 * promise, because of e.g. a device hot-unplug which raises internal
 * errors, after the wl_buffer has been successfully created the
 * compositor must not raise protocol errors to the client when dmabuf
 * import later fails.
 *
 * To create a wl_buffer from one or more dmabufs, a client creates a
 * zwp_linux_dmabuf_params_v1 object with a zwp_linux_dmabuf_v1.create_params
 * request. All planes required by the intended format are added with
 * the 'add' request. Finally, a 'create' or 'create_immed' request is
 * issued, which has the following outcome depending on the import success.
 *
 * The 'create' request,
 * - on success, triggers a 'created' event which provides the final
 * wl_buffer to the client.
 * - on failure, triggers a 'failed' event to convey that the server
 * cannot use the dmabufs received from the client.
 *
 * For the 'create_immed' request,
 * - on success, the server immediately imports the added dmabufs to
 * create a wl_buffer. No event is sent from the server in this case.
 * - on failure, the server can choose to either:
 * - terminate the client by raising a fatal error.
 * - mark the wl_buffer as failed, and send a 'failed' event to the
 * client. If the client uses a failed wl_buffer as an argument to any
 * request, the behaviour is compositor implementation-defined.
 *
 * For all DRM formats and unless specified in another protocol extension,
 * pre-multiplied alpha is used for pixel values.
 *
 * Unless specified otherwise in another protocol extension, implicit
 * synchronization is used. In other words, compositors and clients must
 * wait and signal fences implicitly passed via the DMA-BUF's reservation
 * mechanism.
 * @section page_iface_zwp_linux_dmabuf_v1_api API
 * See @ref iface_zwp_linux_dmabuf_v1.
 */
/**
 * @defgroup iface_zwp_linux_dmabuf_v1 The zwp_linux_dmabuf_v1 interface
 *
 * This interface offers ways to create generic dmabuf-based wl_buffers.
 *
 * For more information about dmabuf, see:
 * https://www.kernel.org/doc/html/next/userspace-api/dma-buf-alloc-exchange.html
 *
 * Clients can use the get_surface_feedback request to get dmabuf feedback
 * for a particular surface. If the client wants to retrieve feedback not
 * tied to a surface, they can use the get_default_feedback request.
 *
 * The following are required from clients:
 *
 * - Clients must ensure that either all data in the dma-buf is
 * coherent for all subsequent read access or that coherency is
 * correctly handled by the underlying kernel-side dma-buf
 * implementation.
 *
 * - Don't make any more attachments after sending the buffer to the
 * compositor. Making more attachments later increases the risk of
 * the compositor not being able to use (re-import) an existing
 * dmabuf-based wl_buffer.
 *
 * The underlying graphics stack must ensure the following:
 *
 * - The dmabuf file descriptors relayed to the server will stay valid
 * for the whole lifetime of the wl_buffer. This means the server may
 * at any time use those fds to import the dmabuf into any kernel
 * sub-system that might accept it.
 *
 * However, when the underlying graphics stack fails to deliver the
 * promise, because of e.g. a device hot-unplug which raises internal
 * errors, after the wl_buffer has been successfully created the
 * compositor must not raise protocol errors to the client when dmabuf
 * import later fails.
 *
 * To create a wl_buffer from one or more dmabufs, a client creates a
 * zwp_linux_dmabuf_params_v1 object with a zwp_linux_dmabuf_v1.create_params
 * request. All planes required by the intended format are added with
 * the 'add' request. Finally, a 'create' or 'create_immed' request is
 * issued, which has the following outcome depending on the import success.
 *
 * The 'create' request,
 * - on success, triggers a 'created' event which provides the final
 * wl_buffer to the client.
 * - on failure, triggers a 'failed' event to convey that the server
 * cannot use the dmabufs received from the client.
 *
 * For the 'create_immed' request,
 * - on success, the server immediately imports the added dmabufs to
 * create a wl_buffer. No event is sent from the server in this case.
 * - on failure, the server can choose to either:
 * - terminate the client by raising a fatal error.
 * - mark the wl_buffer as failed, and send a 'failed' event to the
 * client. If the client uses a failed wl_buffer as an argument to any
 * request, the behaviour is compositor implementation-defined.
 *
 * For all DRM formats and unless specified in another protocol extension,
 * pre-multiplied alpha is used for pixel values.
 *
 * Unless specified otherwise in another protocol extension, implicit
 * synchronization is used. In other words, compositors and clients must
 * wait and signal fences implicitly passed via the DMA-BUF's reservation
 * mechanism.
 */
extern const struct wl_interface zwp_linux_dmabuf_v1_interface;
#endif
#ifndef ZWP_LINUX_BUFFER_PARAMS_V1_INTERFACE
#define ZWP_LINUX_BUFFER_PARAMS_V1_INTERFACE
/**
 * @page page_iface_zwp_linux_buffer_params_v1 zwp_linux_buffer_params_v1
 * @section page_iface_zwp_linux_buffer_params_v1_desc Description
 *
 * This temporary object is a collection of dmabufs and other
 * parameters that together form a single logical buffer. The temporary
 * object may eventually create one wl_buffer unless cancelled by
 * destroying it before requesting 'create'.
 *
 * Single-planar formats only require one dmabuf, however
 * multi-planar formats may require more than one dmabuf. For all
 * formats, an 'add' request must be called once per plane (even if the
 * underlying dmabuf fd is identical).
 *
 * You must use consecutive plane indices ('plane_idx' argument for 'add')
 * from zero to the number of planes used by the drm_fourcc format code.
 * All planes required by the format must be given exactly once, but can
 * be given in any order. Each plane index can only be set once; subsequent
 * calls with a plane index which has already been set will result in a
 * plane_set error being generated.
 * @section page_iface_zwp_linux_buffer_params_v1_api API
 * See @ref iface_zwp_linux_buffer_params_v1.
 */
/**
 * @defgroup iface_zwp_linux_buffer_params_v1 The zwp_linux_buffer_params_v1 interface
 *
 * This temporary object is a collection of dmabufs and other
 * parameters that together form a single logical buffer. The temporary
 * object may eventually create one wl_buffer unless cancelled by
 * destroying it before requesting 'create'.
 *
 * Single-planar formats only require one dmabuf, however
 * multi-planar formats may require more than one dmabuf. For all
 * formats, an 'add' request must be called once per plane (even if the
 * underlying dmabuf fd is identical).
 *
 * You must use consecutive plane indices ('plane_idx' argument for 'add')
 * from zero to the number of planes used by the drm_fourcc format code.
 * All planes required by the format must be given exactly once, but can
 * be given in any order. Each plane index can only be set once; subsequent
 * calls with a plane index which has already been set will result in a
 * plane_set error being generated.
 */
extern const struct wl_interface zwp_linux_buffer_params_v1_interface;
#endif
#ifndef ZWP_LINUX_DMABUF_FEEDBACK_V1_INTERFACE
#define ZWP_LINUX_DMABUF_FEEDBACK_V1_INTERFACE
/**
 * @page page_iface_zwp_linux_dmabuf_feedback_v1 zwp_linux_dmabuf_feedback_v1
 * @section page_iface_zwp_linux_dmabuf_feedback_v1_desc Description
 *
 * This object advertises dmabuf parameters feedback. This includes the
 * preferred devices and the supported formats/modifiers.
 *
 * The parameters are sent once when this object is created and whenever they
 * change. The done event is always sent once after all parameters have been
 * sent. When a single parameter changes, all parameters are re-sent by the
 * compositor.
 *
 * Compositors can re-send the parameters when the current client buffer
 * allocations are sub-optimal. Compositors should not re-send the
 * parameters if re-allocating the buffers would not result in a more optimal
 * configuration. In particular, compositors should avoid sending the exact
 * same parameters multiple times in a row.
 *
 * The tranche_target_device and tranche_formats events are grouped by
 * tranches of preference. For each tranche, a tranche_target_device, one
 * tranche_flags and one or more tranche_formats events are sent, followed
 * by a tranche_done event finishing the list. The tranches are sent in
 * descending order of preference. All formats and modifiers in the same
 * tranche have the same preference.
 *
 * To send parameters, the compositor sends one main_device event, tranches
 * (each consisting of one tranche_target_device event, one tranche_flags
 * event, tranche_formats events and then a tranche_done event), then one
 * done event.
 * @section page_iface_zwp_linux_dmabuf_feedback_v1_api API
 * See @ref iface_zwp_linux_dmabuf_feedback_v1.
 */
/**
 * @defgroup iface_zwp_linux_dmabuf_feedback_v1 The zwp_linux_dmabuf_feedback_v1 interface
 *
 * This object advertises dmabuf parameters feedback. This includes the
 * preferred devices and the supported formats/modifiers.
 *
 * The parameters are sent once when this object is created and whenever they
 * change. The done event is always sent once after all parameters have been
 * sent. When a single parameter changes, all parameters are re-sent by the
 * compositor.
 *
 * Compositors can re-send the parameters when the current client buffer
 * allocations are sub-optimal. Compositors should not re-send the
 * parameters if re-allocating the buffers would not result in a more optimal
 * configuration. In particular, compositors should avoid sending the exact
 * same parameters multiple times in a row.
 *
 * The tranche_target_device and tranche_formats events are grouped by
 * tranches of preference. For each tranche, a tranche_target_device, one
 * tranche_flags and one or more tranche_formats events are sent, followed
 * by a tranche_done event finishing the list. The tranches are sent in
 * descending order of preference. All formats and modifiers in the same
 * tranche have the same preference.
 *
 * To send parameters, the compositor sends one main_device event, tranches
 * (each consisting of one tranche_target_device event, one tranche_flags
 * event, tranche_formats events and then a tranche_done event), then one
 * done event.
 */
extern const struct wl_interface zwp_linux_dmabuf_feedback_v1_interface;
#endif

/**
 * @ingroup iface_zwp_linux_dmabuf_v1
 * @struct zwp_linux_dmabuf_v1_interface
 */
struct zwp_linux_dmabuf_v1_interface {
	/**
	 * unbind the factory
	 *
	 * Objects created through this interface, especially wl_buffers,
	 * will remain valid.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * create a temporary object for buffer parameters
	 *
	 * This temporary object is used to collect multiple dmabuf
	 * handles into a single batch to create a wl_buffer. It can only
	 * be used once and should be destroyed after a 'created' or
	 * 'failed' event has been received.
	 * @param params_id the new temporary
	 */
	void (*create_params)(struct wl_client *client,
			      struct wl_resource *resource,
			      uint32_t params_id);
	/**
	 * get default feedback
	 *
	 * This request creates a new wp_linux_dmabuf_feedback object not
	 * bound to a particular surface. This object will deliver feedback
	 * about dmabuf parameters to use if the client doesn't support
	 * per-surface feedback (see get_surface_feedback).
	 * @since 4
	 */
	void (*get_default_feedback)(struct wl_client *client,
				     struct wl_resource *resource,
				     uint32_t id);
	/**
	 * get feedback for a surface
	 *
	 * This request creates a new wp_linux_dmabuf_feedback object for
	 * the specified wl_surface. This object will deliver feedback
	 * about dmabuf parameters to use for buffers attached to this
	 * surface.
	 *
	 * If the surface is destroyed before the wp_linux_dmabuf_feedback
	 * object, the feedback object becomes inert.
	 * @since 4
	 */
	void (*get_surface_feedback)(struct wl_client *client,
				     struct wl_resource *resource,
				     uint32_t id,
				     struct wl_resource *surface);
};

#define ZWP_LINUX_DMABUF_V1_FORMAT 0
#define ZWP_LINUX_DMABUF_V1_MODIFIER 1

/**
 * @ingroup iface_zwp_linux_dmabuf_v1
 */
#define ZWP_LINUX_DMABUF_V1_FORMAT_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_linux_dmabuf_v1
 */
#define ZWP_LINUX_DMABUF_V1_MODIFIER_SINCE_VERSION 3

/**
 * @ingroup iface_zwp_linux_dmabuf_v1
 */
#define ZWP_LINUX_DMABUF_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_linux_dmabuf_v1
 */
#define ZWP_LINUX_DMABUF_V1_CREATE_PARAMS_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_linux_dmabuf_v1
 */
#define ZWP_LINUX_DMABUF_V1_GET_DEFAULT_FEEDBACK_SINCE_VERSION 4
/**
 * @ingroup iface_zwp_linux_dmabuf_v1
 */
#define ZWP_LINUX_DMABUF_V1_GET_SURFACE_FEEDBACK_SINCE_VERSION 4

/**
 * @ingroup iface_zwp_linux_dmabuf_v1
 * Sends an format event to the client owning the resource.
 * @param resource_ The client's resource
 * @param format DRM_FORMAT code
 */
static inline void
zwp_linux_dmabuf_v1_send_format(struct wl_resource *resource_, uint32_t format)
{
	wl_resource_post_event(resource_, ZWP_LINUX_DMABUF_V1_FORMAT, format);
}

/**
 * @ingroup iface_zwp_linux_dmabuf_v1
 * Sends an modifier event to the client owning the resource.
 * @param resource_ The client's resource
 * @param format DRM_FORMAT code
 * @param modifier_hi high 32 bits of layout modifier
 * @param modifier_lo low 32 bits of layout modifier
 */
static inline void
zwp_linux_dmabuf_v1_send_modifier(struct wl_resource *resource_, uint32_t format, uint32_t modifier_hi, uint32_t modifier_lo)
{
	wl_resource_post_event(resource_, ZWP_LINUX_DMABUF_V1_MODIFIER, format, modifier_hi, modifier_lo);
}

#ifndef ZWP_LINUX_BUFFER_PARAMS_V1_ERROR_ENUM
#define ZWP_LINUX_BUFFER_PARAMS_V1_ERROR_ENUM
enum zwp_linux_buffer_params_v1_error {
	/**
	 * the dmabuf_batch object has already been used to create a wl_buffer
	 */
	ZWP_LINUX_BUFFER_PARAMS_V1_ERROR_ALREADY_USED = 0,
	/**
	 * plane index out of bounds
	 */
	ZWP_LINUX_BUFFER_PARAMS_V1_ERROR_PLANE_IDX = 1,
	/**
	 * the plane index was already set
	 */
	ZWP_LINUX_BUFFER_PARAMS_V1_ERROR_PLANE_SET = 2,
	/**
	 * missing or too many planes to create a buffer
	 */
	ZWP_LINUX_BUFFER_PARAMS_V1_ERROR_INCOMPLETE = 3,
	/**
	 * format not supported
	 */
	ZWP_LINUX_BUFFER_PARAMS_V1_ERROR_INVALID_FORMAT = 4,
	/**
	 * invalid width or height
	 */
	ZWP_LINUX_BUFFER_PARAMS_V1_ERROR_INVALID_DIMENSIONS = 5,
	/**
	 * offset + stride * height goes out of dmabuf bounds
	 */
	ZWP_LINUX_BUFFER_PARAMS_V1_ERROR_OUT_OF_BOUNDS = 6,
	/**
	 * invalid wl_buffer resulted from importing dmabufs via                the create_immed request on given buffer_params
	 */
	ZWP_LINUX_BUFFER_PARAMS_V1_ERROR_INVALID_WL_BUFFER = 7,
};
#endif /* ZWP_LINUX_BUFFER_PARAMS_V1_ERROR_ENUM */

#ifndef ZWP_LINUX_BUFFER_PARAMS_V1_ERROR_ENUM_IS_VALID
#define ZWP_LINUX_BUFFER_PARAMS_V1_ERROR_ENUM_IS_VALID
/**
 * @ingroup iface_zwp_linux_buffer_params_v1
 * Validate a zwp_linux_buffer_params_v1 error value.
 *
 * @return true on success, false on error.
 * @ref zwp_linux_buffer_params_v1_error
 */
static inline bool
zwp_linux_buffer_params_v1_error_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case ZWP_LINUX_BUFFER_PARAMS_V1_ERROR_ALREADY_USED:
		return version >= 1;
	case ZWP_LINUX_BUFFER_PARAMS_V1_ERROR_PLANE_IDX:
		return version >= 1;
	case ZWP_LINUX_BUFFER_PARAMS_V1_ERROR_PLANE_SET:
		return version >= 1;
	case ZWP_LINUX_BUFFER_PARAMS_V1_ERROR_INCOMPLETE:
		return version >= 1;
	case ZWP_LINUX_BUFFER_PARAMS_V1_ERROR_INVALID_FORMAT:
		return version >= 1;
	case ZWP_LINUX_BUFFER_PARAMS_V1_ERROR_INVALID_DIMENSIONS:
		return version >= 1;
	case ZWP_LINUX_BUFFER_PARAMS_V1_ERROR_OUT_OF_BOUNDS:
		return version >= 1;
	case ZWP_LINUX_BUFFER_PARAMS_V1_ERROR_INVALID_WL_BUFFER:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* ZWP_LINUX_BUFFER_PARAMS_V1_ERROR_ENUM_IS_VALID */

#ifndef ZWP_LINUX_BUFFER_PARAMS_V1_FLAGS_ENUM
#define ZWP_LINUX_BUFFER_PARAMS_V1_FLAGS_ENUM
enum zwp_linux_buffer_params_v1_flags {
	/**
	 * contents are y-inverted
	 */
	ZWP_LINUX_BUFFER_PARAMS_V1_FLAGS_Y_INVERT = 1,
	/**
	 * content is interlaced
	 */
	ZWP_LINUX_BUFFER_PARAMS_V1_FLAGS_INTERLACED = 2,
	/**
	 * bottom field first
	 */
	ZWP_LINUX_BUFFER_PARAMS_V1_FLAGS_BOTTOM_FIRST = 4,
};
#endif /* ZWP_LINUX_BUFFER_PARAMS_V1_FLAGS_ENUM */

#ifndef ZWP_LINUX_BUFFER_PARAMS_V1_FLAGS_ENUM_IS_VALID
#define ZWP_LINUX_BUFFER_PARAMS_V1_FLAGS_ENUM_IS_VALID
/**
 * @ingroup iface_zwp_linux_buffer_params_v1
 * Validate a zwp_linux_buffer_params_v1 flags value.
 *
 * @return true on success, false on error.
 * @ref zwp_linux_buffer_params_v1_flags
 */
static inline bool
zwp_linux_buffer_params_v1_flags_is_valid(uint32_t value, uint32_t version) {
	uint32_t valid = 0;
	if (version >= 1)
		valid |= ZWP_LINUX_BUFFER_PARAMS_V1_FLAGS_Y_INVERT;
	if (version >= 1)
		valid |= ZWP_LINUX_BUFFER_PARAMS_V1_FLAGS_INTERLACED;
	if (version >= 1)
		valid |= ZWP_LINUX_BUFFER_PARAMS_V1_FLAGS_BOTTOM_FIRST;
	return (value & ~valid) == 0;
}
#endif /* ZWP_LINUX_BUFFER_PARAMS_V1_FLAGS_ENUM_IS_VALID */

/**
 * @ingroup iface_zwp_linux_buffer_params_v1
 * @struct zwp_linux_buffer_params_v1_interface
 */
struct zwp_linux_buffer_params_v1_interface {
	/**
	 * delete this object, used or not
	 *
	 * Cleans up the temporary data sent to the server for
	 * dmabuf-based wl_buffer creation.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * add a dmabuf to the temporary set
	 *
	 * This request adds one dmabuf to the set in this
	 * zwp_linux_buffer_params_v1.
	 *
	 * The 64-bit unsigned value combined from modifier_hi and
	 * modifier_lo is the dmabuf layout modifier. DRM AddFB2 ioctl
	 * calls this the fb modifier, which is defined in drm_mode.h of
	 * Linux UAPI. This is an opaque token. Drivers use this token to
	 * express tiling, compression, etc. driver-specific modifications
	 * to the base format defined by the DRM fourcc code.
	 *
	 * Starting from version 4, the invalid_format protocol error is
	 * sent if the format + modifier pair was not advertised as
	 * supported.
	 *
	 * Starting from version 5, the invalid_format protocol error is
	 * sent if all planes don't use the same modifier.
	 *
	 * This request raises the PLANE_IDX error if plane_idx is too
	 * large. The error PLANE_SET is raised if attempting to set a
	 * plane that was already set.
	 * @param fd dmabuf fd
	 * @param plane_idx plane index
	 * @param offset offset in bytes
	 * @param stride stride in bytes
	 * @param modifier_hi high 32 bits of layout modifier
	 * @param modifier_lo low 32 bits of layout modifier
	 */
	void (*add)(struct wl_client *client,
		    struct wl_resource *resource,
		    int32_t fd,
		    uint32_t plane_idx,
		    uint32_t offset,
		    uint32_t stride,
		    uint32_t modifier_hi,
		    uint32_t modifier_lo);
	/**
	 * create a wl_buffer from the given dmabufs
	 *
	 * This asks for creation of a wl_buffer from the added dmabuf
	 * buffers. The wl_buffer is not created immediately but returned
	 * via the 'created' event if the dmabuf sharing succeeds. The
	 * sharing may fail at runtime for reasons a client cannot predict,
	 * in which case the 'failed' event is triggered.
	 *
	 * The 'format' argument is a DRM_FORMAT code, as defined by the
	 * libdrm's drm_fourcc.h. The Linux kernel's DRM sub-system is the
	 * authoritative source on how the format codes should work.
	 *
	 * The 'flags' is a bitfield of the flags defined in enum "flags".
	 * 'y_invert' means the that the image needs to be y-flipped.
	 *
	 * Flag 'interlaced' means that the frame in the buffer is not
	 * progressive as usual, but interlaced. An interlaced buffer as
	 * supported here must always contain both top and bottom fields.
	 * The top field always begins on the first pixel row. The temporal
	 * ordering between the two fields is top field first, unless
	 * 'bottom_first' is specified. It is undefined whether
	 * 'bottom_first' is ignored if 'interlaced' is not set.
	 *
	 * This protocol does not convey any information about field rate,
	 * duration, or timing, other than the relative ordering between
	 * the two fields in one buffer. A compositor may have to estimate
	 * the intended field rate from the incoming buffer rate. It is
	 * undefined whether the time of receiving wl_surface.commit with a
	 * new buffer attached, applying the wl_surface state,
	 * wl_surface.frame callback trigger, presentation, or any other
	 * point in the compositor cycle is used to measure the frame or
	 * field times. There is no support for detecting missed or late
	 * frames/fields/buffers either, and there is no support whatsoever
	 * for cooperating with interlaced compositor output.
	 *
	 * The composited image quality resulting from the use of
	 * interlaced buffers is explicitly undefined. A compositor may use
	 * elaborate hardware features or software to deinterlace and
	 * create progressive output frames from a sequence of interlaced
	 * input buffers, or it may produce substandard image quality.
	 * However, compositors that cannot guarantee reasonable image
	 * quality in all cases are recommended to just reject all
	 * interlaced buffers.
	 *
	 * Any argument errors, including non-positive width or height,
	 * mismatch between the number of planes and the format, bad
	 * format, bad offset or stride, may be indicated by fatal protocol
	 * errors: INCOMPLETE, INVALID_FORMAT, INVALID_DIMENSIONS,
	 * OUT_OF_BOUNDS.
	 *
	 * Dmabuf import errors in the server that are not obvious client
	 * bugs are returned via the 'failed' event as non-fatal. This
	 * allows attempting dmabuf sharing and falling back in the client
	 * if it fails.
	 *
	 * This request can be sent only once in the object's lifetime,
	 * after which the only legal request is destroy. This object
	 * should be destroyed after issuing a 'create' request. Attempting
	 * to use this object after issuing 'create' raises ALREADY_USED
	 * protocol error.
	 *
	 * It is not mandatory to issue 'create'. If a client wants to
	 * cancel the buffer creation, it can just destroy this object.
	 * @param width base plane width in pixels
	 * @param height base plane height in pixels
	 * @param format DRM_FORMAT code
	 * @param flags see enum flags
	 */
	void (*create)(struct wl_client *client,
		       struct wl_resource *resource,
		       int32_t width,
		       int32_t height,
		       uint32_t format,
		       uint32_t flags);
	/**
	 * immediately create a wl_buffer from the given                      dmabufs
	 *
	 * This asks for immediate creation of a wl_buffer by importing
	 * the added dmabufs.
	 *
	 * In case of import success, no event is sent from the server, and
	 * the wl_buffer is ready to be used by the client.
	 *
	 * Upon import failure, either of the following may happen, as seen
	 * fit by the implementation: - the client is terminated with one
	 * of the following fatal protocol errors: - INCOMPLETE,
	 * INVALID_FORMAT, INVALID_DIMENSIONS, OUT_OF_BOUNDS, in case of
	 * argument errors such as mismatch between the number of planes
	 * and the format, bad format, non-positive width or height, or bad
	 * offset or stride. - INVALID_WL_BUFFER, in case the cause for
	 * failure is unknown or platform specific. - the server creates an
	 * invalid wl_buffer, marks it as failed and sends a 'failed' event
	 * to the client. The result of using this invalid wl_buffer as an
	 * argument in any request by the client is defined by the
	 * compositor implementation.
	 *
	 * This takes the same arguments as a 'create' request, and obeys
	 * the same restrictions.
	 * @param buffer_id id for the newly created wl_buffer
	 * @param width base plane width in pixels
	 * @param height base plane height in pixels
	 * @param format DRM_FORMAT code
	 * @param flags see enum flags
	 * @since 2
	 */
	void (*create_immed)(struct wl_client *client,
			     struct wl_resource *resource,
			     uint32_t buffer_id,
			     int32_t width,
			     int32_t height,
			     uint32_t format,
			     uint32_t flags);
};

#define ZWP_LINUX_BUFFER_PARAMS_V1_CREATED 0
#define ZWP_LINUX_BUFFER_PARAMS_V1_FAILED 1

/**
 * @ingroup iface_zwp_linux_buffer_params_v1
 */
#define ZWP_LINUX_BUFFER_PARAMS_V1_CREATED_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_linux_buffer_params_v1
 */
#define ZWP_LINUX_BUFFER_PARAMS_V1_FAILED_SINCE_VERSION 1

/**
 * @ingroup iface_zwp_linux_buffer_params_v1
 */
#define ZWP_LINUX_BUFFER_PARAMS_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_linux_buffer_params_v1
 */
#define ZWP_LINUX_BUFFER_PARAMS_V1_ADD_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_linux_buffer_params_v1
 */
#define ZWP_LINUX_BUFFER_PARAMS_V1_CREATE_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_linux_buffer_params_v1
 */
#define ZWP_LINUX_BUFFER_PARAMS_V1_CREATE_IMMED_SINCE_VERSION 2

/**
 * @ingroup iface_zwp_linux_buffer_params_v1
 * Sends an created event to the client owning the resource.
 * @param resource_ The client's resource
 * @param buffer the newly created wl_buffer
 */
static inline void
zwp_linux_buffer_params_v1_send_created(struct wl_resource *resource_, struct wl_resource *buffer)
{
	wl_resource_post_event(resource_, ZWP_LINUX_BUFFER_PARAMS_V1_CREATED, buffer);
}

/**
 * @ingroup iface_zwp_linux_buffer_params_v1
 * Sends an failed event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
zwp_linux_buffer_params_v1_send_failed(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, ZWP_LINUX_BUFFER_PARAMS_V1_FAILED);
}

#ifndef ZWP_LINUX_DMABUF_FEEDBACK_V1_TRANCHE_FLAGS_ENUM
#define ZWP_LINUX_DMABUF_FEEDBACK_V1_TRANCHE_FLAGS_ENUM
enum zwp_linux_dmabuf_feedback_v1_tranche_flags {
	/**
	 * direct scan-out tranche
	 */
	ZWP_LINUX_DMABUF_FEEDBACK_V1_TRANCHE_FLAGS_SCANOUT = 1,
};
#endif /* ZWP_LINUX_DMABUF_FEEDBACK_V1_TRANCHE_FLAGS_ENUM */

#ifndef ZWP_LINUX_DMABUF_FEEDBACK_V1_TRANCHE_FLAGS_ENUM_IS_VALID
#define ZWP_LINUX_DMABUF_FEEDBACK_V1_TRANCHE_FLAGS_ENUM_IS_VALID
/**
 * @ingroup iface_zwp_linux_dmabuf_feedback_v1
 * Validate a zwp_linux_dmabuf_feedback_v1 tranche_flags value.
 *
 * @return true on success, false on error.
 * @ref zwp_linux_dmabuf_feedback_v1_tranche_flags
 */
static inline bool
zwp_linux_dmabuf_feedback_v1_tranche_flags_is_valid(uint32_t value, uint32_t version) {
	uint32_t valid = 0;
	if (version >= 1)
		valid |= ZWP_LINUX_DMABUF_FEEDBACK_V1_TRANCHE_FLAGS_SCANOUT;
	return (value & ~valid) == 0;
}
#endif /* ZWP_LINUX_DMABUF_FEEDBACK_V1_TRANCHE_FLAGS_ENUM_IS_VALID */

/**
 * @ingroup iface_zwp_linux_dmabuf_feedback_v1
 * @struct zwp_linux_dmabuf_feedback_v1_interface
 */
struct zwp_linux_dmabuf_feedback_v1_interface {
	/**
	 * destroy the feedback object
	 *
	 * Using this request a client can tell the server that it is not
	 * going to use the wp_linux_dmabuf_feedback object anymore.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};

#define ZWP_LINUX_DMABUF_FEEDBACK_V1_DONE 0
#define ZWP_LINUX_DMABUF_FEEDBACK_V1_FORMAT_TABLE 1
#define ZWP_LINUX_DMABUF_FEEDBACK_V1_MAIN_DEVICE 2
#define ZWP_LINUX_DMABUF_FEEDBACK_V1_TRANCHE_DONE 3
#define ZWP_LINUX_DMABUF_FEEDBACK_V1_TRANCHE_TARGET_DEVICE 4
#define ZWP_LINUX_DMABUF_FEEDBACK_V1_TRANCHE_FORMATS 5
#define ZWP_LINUX_DMABUF_FEEDBACK_V1_TRANCHE_FLAGS 6

/**
 * @ingroup iface_zwp_linux_dmabuf_feedback_v1
 */
#define ZWP_LINUX_DMABUF_FEEDBACK_V1_DONE_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_linux_dmabuf_feedback_v1
 */
#define ZWP_LINUX_DMABUF_FEEDBACK_V1_FORMAT_TABLE_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_linux_dmabuf_feedback_v1
 */
#define ZWP_LINUX_DMABUF_FEEDBACK_V1_MAIN_DEVICE_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_linux_dmabuf_feedback_v1
 */
#define ZWP_LINUX_DMABUF_FEEDBACK_V1_TRANCHE_DONE_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_linux_dmabuf_feedback_v1
 */
#define ZWP_LINUX_DMABUF_FEEDBACK_V1_TRANCHE_TARGET_DEVICE_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_linux_dmabuf_feedback_v1
 */
#define ZWP_LINUX_DMABUF_FEEDBACK_V1_TRANCHE_FORMATS_SINCE_VERSION 1
/**
 * @ingroup iface_zwp_linux_dmabuf_feedback_v1
 */
#define ZWP_LINUX_DMABUF_FEEDBACK_V1_TRANCHE_FLAGS_SINCE_VERSION 1

/**
 * @ingroup iface_zwp_linux_dmabuf_feedback_v1
 */
#define ZWP_LINUX_DMABUF_FEEDBACK_V1_DESTROY_SINCE_VERSION 1

/**
 * @ingroup iface_zwp_linux_dmabuf_feedback_v1
 * Sends an done event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
zwp_linux_dmabuf_feedback_v1_send_done(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, ZWP_LINUX_DMABUF_FEEDBACK_V1_DONE);
}

/**
 * @ingroup iface_zwp_linux_dmabuf_feedback_v1
 * Sends an format_table event to the client owning the resource.
 * @param resource_ The client's resource
 * @param fd table file descriptor
 * @param size table size, in bytes
 */
static inline void
zwp_linux_dmabuf_feedback_v1_send_format_table(struct wl_resource *resource_, int32_t fd, uint32_t size)
{
	wl_resource_post_event(resource_, ZWP_LINUX_DMABUF_FEEDBACK_V1_FORMAT_TABLE, fd, size);
}

/**
 * @ingroup iface_zwp_linux_dmabuf_feedback_v1
 * Sends an main_device event to the client owning the resource.
 * @param resource_ The client's resource
 * @param device device dev_t value
 */
static inline void
zwp_linux_dmabuf_feedback_v1_send_main_device(struct wl_resource *resource_, struct wl_array *device)
{
	wl_resource_post_event(resource_, ZWP_LINUX_DMABUF_FEEDBACK_V1_MAIN_DEVICE, device);
}

/**
 * @ingroup iface_zwp_linux_dmabuf_feedback_v1
 * Sends an tranche_done event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
zwp_linux_dmabuf_feedback_v1_send_tranche_done(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, ZWP_LINUX_DMABUF_FEEDBACK_V1_TRANCHE_DONE);
}

/**
 * @ingroup iface_zwp_linux_dmabuf_feedback_v1
 * Sends an tranche_target_device event to the client owning the resource.
 * @param resource_ The client's resource
 * @param device device dev_t value
 */
static inline void
zwp_linux_dmabuf_feedback_v1_send_tranche_target_device(struct wl_resource *resource_, struct wl_array *device)
{
	wl_resource_post_event(resource_, ZWP_LINUX_DMABUF_FEEDBACK_V1_TRANCHE_TARGET_DEVICE, device);
}

/**
 * @ingroup iface_zwp_linux_dmabuf_feedback_v1
 * Sends an tranche_formats event to the client owning the resource.
 * @param resource_ The client's resource
 * @param indices array of 16-bit indexes
 */
static inline void
zwp_linux_dmabuf_feedback_v1_send_tranche_formats(struct wl_resource *resource_, struct wl_array *indices)
{
	wl_resource_post_event(resource_, ZWP_LINUX_DMABUF_FEEDBACK_V1_TRANCHE_FORMATS, indices);
}

/**
 * @ingroup iface_zwp_linux_dmabuf_feedback_v1
 * Sends an tranche_flags event to the client owning the resource.
 * @param resource_ The client's resource
 * @param flags tranche flags
 */
static inline void
zwp_linux_dmabuf_feedback_v1_send_tranche_flags(struct wl_resource *resource_, uint32_t flags)
{
	wl_resource_post_event(resource_, ZWP_LINUX_DMABUF_FEEDBACK_V1_TRANCHE_FLAGS, flags);
}

#ifdef  __cplusplus
}
#endif

#endif
