/* Generated by wayland-scanner 1.24.0 */

#ifndef WPE_BRIDGE_SERVER_PROTOCOL_H
#define WPE_BRIDGE_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_wpe_bridge The wpe_bridge protocol
 * @section page_ifaces_wpe_bridge Interfaces
 * - @subpage page_iface_wpe_bridge - 
 * @section page_copyright_wpe_bridge Copyright
 * <pre>
 *
 * Copyright © 2019 Igalia S.L.
 *
 * Permission to use, copy, modify, distribute, and sell this
 * software and its documentation for any purpose is hereby granted
 * without fee, provided that the above copyright notice appear in
 * all copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the name of
 * the copyright holders not be used in advertising or publicity
 * pertaining to distribution of the software without specific,
 * written prior permission.  The copyright holders make no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.
 *
 * THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
 * THIS SOFTWARE.
 * </pre>
 */
struct wl_surface;
struct wpe_bridge;

#ifndef WPE_BRIDGE_INTERFACE
#define WPE_BRIDGE_INTERFACE
/**
 * @page page_iface_wpe_bridge wpe_bridge
 * @section page_iface_wpe_bridge_api API
 * See @ref iface_wpe_bridge.
 */
/**
 * @defgroup iface_wpe_bridge The wpe_bridge interface
 */
extern const struct wl_interface wpe_bridge_interface;
#endif

#ifndef WPE_BRIDGE_CLIENT_IMPLEMENTATION_TYPE_ENUM
#define WPE_BRIDGE_CLIENT_IMPLEMENTATION_TYPE_ENUM
enum wpe_bridge_client_implementation_type {
	WPE_BRIDGE_CLIENT_IMPLEMENTATION_TYPE_WAYLAND = 0,
	WPE_BRIDGE_CLIENT_IMPLEMENTATION_TYPE_DMABUF_POOL = 1,
};
#endif /* WPE_BRIDGE_CLIENT_IMPLEMENTATION_TYPE_ENUM */

#ifndef WPE_BRIDGE_CLIENT_IMPLEMENTATION_TYPE_ENUM_IS_VALID
#define WPE_BRIDGE_CLIENT_IMPLEMENTATION_TYPE_ENUM_IS_VALID
/**
 * @ingroup iface_wpe_bridge
 * Validate a wpe_bridge client_implementation_type value.
 *
 * @return true on success, false on error.
 * @ref wpe_bridge_client_implementation_type
 */
static inline bool
wpe_bridge_client_implementation_type_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case WPE_BRIDGE_CLIENT_IMPLEMENTATION_TYPE_WAYLAND:
		return version >= 1;
	case WPE_BRIDGE_CLIENT_IMPLEMENTATION_TYPE_DMABUF_POOL:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* WPE_BRIDGE_CLIENT_IMPLEMENTATION_TYPE_ENUM_IS_VALID */

/**
 * @ingroup iface_wpe_bridge
 * @struct wpe_bridge_interface
 */
struct wpe_bridge_interface {
	/**
	 */
	void (*initialize)(struct wl_client *client,
			   struct wl_resource *resource);
	/**
	 */
	void (*connect)(struct wl_client *client,
			struct wl_resource *resource,
			struct wl_resource *surface);
};

#define WPE_BRIDGE_IMPLEMENTATION_INFO 0
#define WPE_BRIDGE_CONNECTED 1

/**
 * @ingroup iface_wpe_bridge
 */
#define WPE_BRIDGE_IMPLEMENTATION_INFO_SINCE_VERSION 1
/**
 * @ingroup iface_wpe_bridge
 */
#define WPE_BRIDGE_CONNECTED_SINCE_VERSION 1

/**
 * @ingroup iface_wpe_bridge
 */
#define WPE_BRIDGE_INITIALIZE_SINCE_VERSION 1
/**
 * @ingroup iface_wpe_bridge
 */
#define WPE_BRIDGE_CONNECT_SINCE_VERSION 1

/**
 * @ingroup iface_wpe_bridge
 * Sends an implementation_info event to the client owning the resource.
 * @param resource_ The client's resource
 * @param type See enum `implementation_type`
 */
static inline void
wpe_bridge_send_implementation_info(struct wl_resource *resource_, uint32_t type)
{
	wl_resource_post_event(resource_, WPE_BRIDGE_IMPLEMENTATION_INFO, type);
}

/**
 * @ingroup iface_wpe_bridge
 * Sends an connected event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
wpe_bridge_send_connected(struct wl_resource *resource_, uint32_t id)
{
	wl_resource_post_event(resource_, WPE_BRIDGE_CONNECTED, id);
}

#ifdef  __cplusplus
}
#endif

#endif
