/* extension-store.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from extension-store.vala, do not modify */

/* extension-store.vala
 *
 * Copyright © 2011 Collabora Ltd.
 *             By Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "zeitgeist-engine.h"
#include "zeitgeist-internal.h"
#include <sqlite3.h>
#include <glib-object.h>
#include <glib.h>
#include "zeitgeist-datamodel.h"
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	ZEITGEIST_EXTENSION_STORE_0_PROPERTY,
	ZEITGEIST_EXTENSION_STORE_NUM_PROPERTIES
};
static GParamSpec* zeitgeist_extension_store_properties[ZEITGEIST_EXTENSION_STORE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_byte_array_unref0(var) ((var == NULL) ? NULL : (var = (g_byte_array_unref (var), NULL)))

struct _ZeitgeistExtensionStorePrivate {
	ZeitgeistSQLiteDatabase* database;
	sqlite3* db;
	sqlite3_stmt* storage_stmt;
	sqlite3_stmt* retrieval_stmt;
};

static gint ZeitgeistExtensionStore_private_offset;
static gpointer zeitgeist_extension_store_parent_class = NULL;

static void zeitgeist_extension_store_prepare_queries (ZeitgeistExtensionStore* self,
                                                GError** error);
static void zeitgeist_extension_store_finalize (GObject * obj);
static GType zeitgeist_extension_store_get_type_once (void);

static inline gpointer
zeitgeist_extension_store_get_instance_private (ZeitgeistExtensionStore* self)
{
	return G_STRUCT_MEMBER_P (self, ZeitgeistExtensionStore_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

ZeitgeistExtensionStore*
zeitgeist_extension_store_construct (GType object_type,
                                     ZeitgeistEngine* engine)
{
	ZeitgeistExtensionStore * self = NULL;
	ZeitgeistSQLiteDatabase* _tmp0_;
	ZeitgeistSQLiteDatabase* _tmp1_;
	ZeitgeistSQLiteDatabase* _tmp2_;
	ZeitgeistSQLiteDatabase* _tmp3_;
	sqlite3* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (engine != NULL, NULL);
	self = (ZeitgeistExtensionStore*) g_object_new (object_type, NULL);
	_tmp0_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) engine);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->database);
	self->priv->database = _tmp2_;
	_tmp3_ = self->priv->database;
	_tmp4_ = _tmp3_->database;
	self->priv->db = _tmp4_;
	{
		zeitgeist_extension_store_prepare_queries (self, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = err;
		_tmp6_ = _tmp5_->message;
		g_warning ("extension-store.vala:42: %s", _tmp6_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	return self;
}

ZeitgeistExtensionStore*
zeitgeist_extension_store_new (ZeitgeistEngine* engine)
{
	return zeitgeist_extension_store_construct (ZEITGEIST_TYPE_EXTENSION_STORE, engine);
}

static void
zeitgeist_extension_store_prepare_queries (ZeitgeistExtensionStore* self,
                                           GError** error)
{
	gint rc = 0;
	gchar* sql = NULL;
	gchar* _tmp0_;
	ZeitgeistSQLiteDatabase* _tmp1_;
	sqlite3* _tmp2_;
	const gchar* _tmp3_;
	sqlite3_stmt* _tmp4_ = NULL;
	gint _tmp5_;
	ZeitgeistSQLiteDatabase* _tmp6_;
	gchar* _tmp7_;
	ZeitgeistSQLiteDatabase* _tmp8_;
	sqlite3* _tmp9_;
	const gchar* _tmp10_;
	sqlite3_stmt* _tmp11_ = NULL;
	gint _tmp12_;
	ZeitgeistSQLiteDatabase* _tmp13_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("\n" \
"                INSERT OR REPLACE INTO extensions_conf (\n" \
"                    extension, key, value\n" \
"                ) VALUES (\n" \
"                    ?, ?, ?\n" \
"                )");
	_g_free0 (sql);
	sql = _tmp0_;
	_tmp1_ = self->priv->database;
	_tmp2_ = _tmp1_->database;
	_tmp3_ = sql;
	_tmp5_ = sqlite3_prepare_v2 (_tmp2_, _tmp3_, -1, &_tmp4_, NULL);
	_sqlite3_finalize0 (self->priv->storage_stmt);
	self->priv->storage_stmt = _tmp4_;
	rc = _tmp5_;
	_tmp6_ = self->priv->database;
	zeitgeist_sq_lite_database_assert_query_success (_tmp6_, rc, "extension-store.vala:59: Storage query error", SQLITE_OK, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (sql);
			return;
		} else {
			_g_free0 (sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp7_ = g_strdup ("\n" \
"                SELECT value\n" \
"                FROM extensions_conf\n" \
"                WHERE extension=? AND key=?\n" \
"                ");
	_g_free0 (sql);
	sql = _tmp7_;
	_tmp8_ = self->priv->database;
	_tmp9_ = _tmp8_->database;
	_tmp10_ = sql;
	_tmp12_ = sqlite3_prepare_v2 (_tmp9_, _tmp10_, -1, &_tmp11_, NULL);
	_sqlite3_finalize0 (self->priv->retrieval_stmt);
	self->priv->retrieval_stmt = _tmp11_;
	rc = _tmp12_;
	_tmp13_ = self->priv->database;
	zeitgeist_sq_lite_database_assert_query_success (_tmp13_, rc, "extension-store.vala:68: Retrieval query error", SQLITE_OK, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (sql);
			return;
		} else {
			_g_free0 (sql);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_g_free0 (sql);
}

/**
         * Store the given Variant under the given (extension, key)
         * identifier, replacing any previous value.
         */
void
zeitgeist_extension_store_store (ZeitgeistExtensionStore* self,
                                 const gchar* extension,
                                 const gchar* key,
                                 GVariant* data)
{
	gint rc = 0;
	sqlite3_stmt* _tmp0_;
	sqlite3_stmt* _tmp1_;
	gchar* _tmp2_;
	GDestroyNotify _tmp3_;
	sqlite3_stmt* _tmp4_;
	gchar* _tmp5_;
	GDestroyNotify _tmp6_;
	sqlite3_stmt* _tmp7_;
	void* _tmp8_;
	sqlite3_stmt* _tmp9_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (extension != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (data != NULL);
	_tmp0_ = self->priv->storage_stmt;
	sqlite3_reset (_tmp0_);
	_tmp1_ = self->priv->storage_stmt;
	_tmp2_ = g_strdup (extension);
	_tmp3_ = g_free;
	sqlite3_bind_text (_tmp1_, 1, _tmp2_, -1, _tmp3_);
	_tmp4_ = self->priv->storage_stmt;
	_tmp5_ = g_strdup (key);
	_tmp6_ = g_free;
	sqlite3_bind_text (_tmp4_, 2, _tmp5_, -1, _tmp6_);
	_tmp7_ = self->priv->storage_stmt;
	_tmp8_ = g_variant_get_data (data);
	sqlite3_bind_blob (_tmp7_, 3, _tmp8_, (gint) g_variant_get_size (data), NULL);
	_tmp9_ = self->priv->storage_stmt;
	rc = sqlite3_step (_tmp9_);
	if (rc != SQLITE_DONE) {
		sqlite3* _tmp11_;
		const gchar* _tmp12_;
		{
			ZeitgeistSQLiteDatabase* _tmp10_;
			_tmp10_ = self->priv->database;
			zeitgeist_sq_lite_database_assert_not_corrupt (_tmp10_, rc, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
					goto __catch0_zeitgeist_engine_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		goto __finally0;
		__catch0_zeitgeist_engine_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp11_ = self->priv->db;
		_tmp12_ = sqlite3_errmsg (_tmp11_);
		g_warning ("extension-store.vala:90: SQL error: %d, %s", rc, _tmp12_);
	}
}

/**
         * Retrieve a previously stored value.
         */
static gpointer
_g_byte_array_ref0 (gpointer self)
{
	return self ? g_byte_array_ref (self) : NULL;
}

GVariant*
zeitgeist_extension_store_retrieve (ZeitgeistExtensionStore* self,
                                    const gchar* extension,
                                    const gchar* key,
                                    const GVariantType* format)
{
	sqlite3_stmt* _tmp0_;
	sqlite3_stmt* _tmp1_;
	gchar* _tmp2_;
	GDestroyNotify _tmp3_;
	sqlite3_stmt* _tmp4_;
	gchar* _tmp5_;
	GDestroyNotify _tmp6_;
	gint rc = 0;
	sqlite3_stmt* _tmp7_;
	guchar* blob = NULL;
	gint blob_length1 = 0;
	gint _blob_size_ = 0;
	sqlite3_stmt* _tmp11_;
	void* _tmp12_;
	sqlite3_stmt* _tmp13_;
	GVariant* data = NULL;
	guchar* _tmp14_;
	gint _tmp14__length1;
	sqlite3_stmt* _tmp24_;
	GError* _inner_error0_ = NULL;
	GVariant* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (extension != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	g_return_val_if_fail (format != NULL, NULL);
	_tmp0_ = self->priv->retrieval_stmt;
	sqlite3_reset (_tmp0_);
	_tmp1_ = self->priv->retrieval_stmt;
	_tmp2_ = g_strdup (extension);
	_tmp3_ = g_free;
	sqlite3_bind_text (_tmp1_, 1, _tmp2_, -1, _tmp3_);
	_tmp4_ = self->priv->retrieval_stmt;
	_tmp5_ = g_strdup (key);
	_tmp6_ = g_free;
	sqlite3_bind_text (_tmp4_, 2, _tmp5_, -1, _tmp6_);
	_tmp7_ = self->priv->retrieval_stmt;
	rc = sqlite3_step (_tmp7_);
	if (rc != SQLITE_ROW) {
		if (rc != SQLITE_DONE) {
			sqlite3* _tmp9_;
			const gchar* _tmp10_;
			{
				ZeitgeistSQLiteDatabase* _tmp8_;
				_tmp8_ = self->priv->database;
				zeitgeist_sq_lite_database_assert_not_corrupt (_tmp8_, rc, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == ZEITGEIST_ENGINE_ERROR) {
						goto __catch0_zeitgeist_engine_error;
					}
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			goto __finally0;
			__catch0_zeitgeist_engine_error:
			{
				g_clear_error (&_inner_error0_);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_tmp9_ = self->priv->db;
			_tmp10_ = sqlite3_errmsg (_tmp9_);
			g_warning ("extension-store.vala:113: SQL error: %d, %s", rc, _tmp10_);
		}
		result = NULL;
		return result;
	}
	_tmp11_ = self->priv->retrieval_stmt;
	_tmp12_ = sqlite3_column_blob (_tmp11_, 0);
	blob = (guchar*) _tmp12_;
	blob_length1 = -1;
	_blob_size_ = blob_length1;
	_tmp13_ = self->priv->retrieval_stmt;
	blob_length1 = sqlite3_column_bytes (_tmp13_, 0);
	data = NULL;
	_tmp14_ = blob;
	_tmp14__length1 = blob_length1;
	if (_tmp14_ != NULL) {
		GByteArray* byte_array = NULL;
		guchar* _tmp15_;
		gint _tmp15__length1;
		GByteArray* _tmp16_;
		GByteArray* _tmp17_;
		guchar* _tmp18_;
		gint _tmp18__length1;
		GByteArray* _tmp19_;
		guint8* _tmp20_;
		gint _tmp20__length1;
		GByteArray* _tmp21_;
		GByteArray* _tmp22_;
		GVariant* _tmp23_;
		_tmp15_ = blob;
		_tmp15__length1 = blob_length1;
		_tmp16_ = g_byte_array_sized_new ((guint) _tmp15__length1);
		byte_array = _tmp16_;
		_tmp17_ = byte_array;
		_tmp18_ = blob;
		_tmp18__length1 = blob_length1;
		g_byte_array_append (_tmp17_, _tmp18_, (gint) _tmp18__length1);
		_tmp19_ = byte_array;
		_tmp20_ = _tmp19_->data;
		_tmp20__length1 = _tmp19_->len;
		_tmp21_ = byte_array;
		_tmp22_ = _g_byte_array_ref0 (_tmp21_);
		_tmp23_ = g_variant_new_from_data (format, _tmp20_, (gint) _tmp20__length1, FALSE, g_byte_array_unref, _tmp22_);
		g_variant_ref_sink (_tmp23_);
		_g_variant_unref0 (data);
		data = _tmp23_;
		_g_byte_array_unref0 (byte_array);
	}
	_tmp24_ = self->priv->retrieval_stmt;
	sqlite3_reset (_tmp24_);
	result = data;
	return result;
}

static void
zeitgeist_extension_store_class_init (ZeitgeistExtensionStoreClass * klass,
                                      gpointer klass_data)
{
	zeitgeist_extension_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ZeitgeistExtensionStore_private_offset);
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_extension_store_finalize;
}

static void
zeitgeist_extension_store_instance_init (ZeitgeistExtensionStore * self,
                                         gpointer klass)
{
	self->priv = zeitgeist_extension_store_get_instance_private (self);
}

static void
zeitgeist_extension_store_finalize (GObject * obj)
{
	ZeitgeistExtensionStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_EXTENSION_STORE, ZeitgeistExtensionStore);
	_g_object_unref0 (self->priv->database);
	_sqlite3_finalize0 (self->priv->storage_stmt);
	_sqlite3_finalize0 (self->priv->retrieval_stmt);
	G_OBJECT_CLASS (zeitgeist_extension_store_parent_class)->finalize (obj);
}

static GType
zeitgeist_extension_store_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistExtensionStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_extension_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistExtensionStore), 0, (GInstanceInitFunc) zeitgeist_extension_store_instance_init, NULL };
	GType zeitgeist_extension_store_type_id;
	zeitgeist_extension_store_type_id = g_type_register_static (G_TYPE_OBJECT, "ZeitgeistExtensionStore", &g_define_type_info, 0);
	ZeitgeistExtensionStore_private_offset = g_type_add_instance_private (zeitgeist_extension_store_type_id, sizeof (ZeitgeistExtensionStorePrivate));
	return zeitgeist_extension_store_type_id;
}

GType
zeitgeist_extension_store_get_type (void)
{
	static volatile gsize zeitgeist_extension_store_type_id__once = 0;
	if (g_once_init_enter (&zeitgeist_extension_store_type_id__once)) {
		GType zeitgeist_extension_store_type_id;
		zeitgeist_extension_store_type_id = zeitgeist_extension_store_get_type_once ();
		g_once_init_leave (&zeitgeist_extension_store_type_id__once, zeitgeist_extension_store_type_id);
	}
	return zeitgeist_extension_store_type_id__once;
}

