{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- /No description available in the introspection data./

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Atk.Structs.Implementor
    ( 

-- * Exported types
    Implementor(..)                         ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [refAccessible]("GI.Atk.Structs.Implementor#g:method:refAccessible").
-- 
-- ==== Getters
-- /None/.
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveImplementorMethod                ,
#endif

-- ** refAccessible #method:refAccessible#

#if defined(ENABLE_OVERLOADING)
    ImplementorRefAccessibleMethodInfo      ,
#endif
    implementorRefAccessible                ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import {-# SOURCE #-} qualified GI.Atk.Enums as Atk.Enums
import {-# SOURCE #-} qualified GI.Atk.Objects.Object as Atk.Object
import {-# SOURCE #-} qualified GI.Atk.Objects.Relation as Atk.Relation
import {-# SOURCE #-} qualified GI.Atk.Objects.RelationSet as Atk.RelationSet
import {-# SOURCE #-} qualified GI.Atk.Objects.StateSet as Atk.StateSet
import {-# SOURCE #-} qualified GI.Atk.Structs.PropertyValues as Atk.PropertyValues
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.GObject.Structs.ValueArray as GObject.ValueArray

#else
import {-# SOURCE #-} qualified GI.Atk.Objects.Object as Atk.Object

#endif

-- | Memory-managed wrapper type.
newtype Implementor = Implementor (SP.ManagedPtr Implementor)
    deriving (Eq)

instance SP.ManagedPtrNewtype Implementor where
    toManagedPtr (Implementor p) = p

-- XXX Wrapping a foreign struct/union with no known destructor or size, leak?
instance BoxedPtr Implementor where
    boxedPtrCopy = return
    boxedPtrFree = \_x -> return ()


#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Implementor
type instance O.AttributeList Implementor = ImplementorAttributeList
type ImplementorAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

-- method Implementor::ref_accessible
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "implementor"
--           , argType =
--               TInterface Name { namespace = "Atk" , name = "Implementor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The #GObject instance which should implement #AtkImplementorIface\nif a non-null return value is required."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Atk" , name = "Object" })
-- throws : False
-- Skip return : False

foreign import ccall "atk_implementor_ref_accessible" atk_implementor_ref_accessible :: 
    Ptr Implementor ->                      -- implementor : TInterface (Name {namespace = "Atk", name = "Implementor"})
    IO (Ptr Atk.Object.Object)

-- | Gets a reference to an object\'s t'GI.Atk.Objects.Object.Object' implementation, if
-- the object implements @/AtkObjectIface/@
implementorRefAccessible ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Implementor
    -- ^ /@implementor@/: The t'GI.GObject.Objects.Object.Object' instance which should implement t'GI.Atk.Interfaces.ImplementorIface.ImplementorIface'
    -- if a non-null return value is required.
    -> m Atk.Object.Object
    -- ^ __Returns:__ a reference to an object\'s t'GI.Atk.Objects.Object.Object'
    -- implementation
implementorRefAccessible implementor = liftIO $ do
    implementor' <- unsafeManagedPtrGetPtr implementor
    result <- atk_implementor_ref_accessible implementor'
    checkUnexpectedReturnNULL "implementorRefAccessible" result
    result' <- (wrapObject Atk.Object.Object) result
    touchManagedPtr implementor
    return result'

#if defined(ENABLE_OVERLOADING)
data ImplementorRefAccessibleMethodInfo
instance (signature ~ (m Atk.Object.Object), MonadIO m) => O.OverloadedMethod ImplementorRefAccessibleMethodInfo Implementor signature where
    overloadedMethod = implementorRefAccessible

instance O.OverloadedMethodInfo ImplementorRefAccessibleMethodInfo Implementor where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Structs.Implementor.implementorRefAccessible",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Structs-Implementor.html#v:implementorRefAccessible"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveImplementorMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveImplementorMethod "refAccessible" o = ImplementorRefAccessibleMethodInfo
    ResolveImplementorMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveImplementorMethod t Implementor, O.OverloadedMethod info Implementor p) => OL.IsLabel t (Implementor -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveImplementorMethod t Implementor, O.OverloadedMethod info Implementor p, R.HasField t Implementor p) => R.HasField t Implementor p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveImplementorMethod t Implementor, O.OverloadedMethodInfo info Implementor) => OL.IsLabel t (O.MethodProxy info Implementor) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


