// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.10
// 	protoc        v6.33.2
// source: envoy/service/auth/v3/attribute_context.proto

package authv3

import (
	_ "github.com/cncf/xds/go/udpa/annotations"
	v3 "github.com/envoyproxy/go-control-plane/envoy/config/core/v3"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// An attribute is a piece of metadata that describes an activity on a network.
// For example, the size of an HTTP request, or the status code of an HTTP response.
//
// Each attribute has a type and a name, which is logically defined as a proto message field
// of the “AttributeContext“. The “AttributeContext“ is a collection of individual attributes
// supported by Envoy authorization system.
// [#comment: The following items are left out of this proto
// Request.Auth field for JWTs
// Request.Api for api management
// Origin peer that originated the request
// Caching Protocol
// request_context return values to inject back into the filter chain
// peer.claims -- from X.509 extensions
// Configuration
// - field mask to send
// - which return values from request_context are copied back
// - which return values are copied into request_headers]
// [#next-free-field: 14]
type AttributeContext struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The source of a network activity, such as starting a TCP connection.
	// In a multi hop network activity, the source represents the sender of the
	// last hop.
	Source *AttributeContext_Peer `protobuf:"bytes,1,opt,name=source,proto3" json:"source,omitempty"`
	// The destination of a network activity, such as accepting a TCP connection.
	// In a multi hop network activity, the destination represents the receiver of
	// the last hop.
	Destination *AttributeContext_Peer `protobuf:"bytes,2,opt,name=destination,proto3" json:"destination,omitempty"`
	// Represents a network request, such as an HTTP request.
	Request *AttributeContext_Request `protobuf:"bytes,4,opt,name=request,proto3" json:"request,omitempty"`
	// This is analogous to http_request.headers, however these contents will not be sent to the
	// upstream server. Context_extensions provide an extension mechanism for sending additional
	// information to the auth server without modifying the proto definition. It maps to the
	// internal opaque context in the filter chain.
	ContextExtensions map[string]string `protobuf:"bytes,10,rep,name=context_extensions,json=contextExtensions,proto3" json:"context_extensions,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Dynamic metadata associated with the request.
	MetadataContext *v3.Metadata `protobuf:"bytes,11,opt,name=metadata_context,json=metadataContext,proto3" json:"metadata_context,omitempty"`
	// Metadata associated with the selected route.
	RouteMetadataContext *v3.Metadata `protobuf:"bytes,13,opt,name=route_metadata_context,json=routeMetadataContext,proto3" json:"route_metadata_context,omitempty"`
	// TLS session details of the underlying connection.
	// This is not populated by default and will be populated only if the ext_authz filter has
	// been specifically configured to include this information.
	// For HTTP ext_authz, that requires :ref:`include_tls_session <config_http_filters_ext_authz>`
	// to be set to true.
	// For network ext_authz, that requires :ref:`include_tls_session <config_network_filters_ext_authz>`
	// to be set to true.
	TlsSession    *AttributeContext_TLSSession `protobuf:"bytes,12,opt,name=tls_session,json=tlsSession,proto3" json:"tls_session,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AttributeContext) Reset() {
	*x = AttributeContext{}
	mi := &file_envoy_service_auth_v3_attribute_context_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AttributeContext) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttributeContext) ProtoMessage() {}

func (x *AttributeContext) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_service_auth_v3_attribute_context_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttributeContext.ProtoReflect.Descriptor instead.
func (*AttributeContext) Descriptor() ([]byte, []int) {
	return file_envoy_service_auth_v3_attribute_context_proto_rawDescGZIP(), []int{0}
}

func (x *AttributeContext) GetSource() *AttributeContext_Peer {
	if x != nil {
		return x.Source
	}
	return nil
}

func (x *AttributeContext) GetDestination() *AttributeContext_Peer {
	if x != nil {
		return x.Destination
	}
	return nil
}

func (x *AttributeContext) GetRequest() *AttributeContext_Request {
	if x != nil {
		return x.Request
	}
	return nil
}

func (x *AttributeContext) GetContextExtensions() map[string]string {
	if x != nil {
		return x.ContextExtensions
	}
	return nil
}

func (x *AttributeContext) GetMetadataContext() *v3.Metadata {
	if x != nil {
		return x.MetadataContext
	}
	return nil
}

func (x *AttributeContext) GetRouteMetadataContext() *v3.Metadata {
	if x != nil {
		return x.RouteMetadataContext
	}
	return nil
}

func (x *AttributeContext) GetTlsSession() *AttributeContext_TLSSession {
	if x != nil {
		return x.TlsSession
	}
	return nil
}

// This message defines attributes for a node that handles a network request.
// The node can be either a service or an application that sends, forwards,
// or receives the request. Service peers should fill in the “service“,
// “principal“, and “labels“ as appropriate.
// [#next-free-field: 6]
type AttributeContext_Peer struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The address of the peer, this is typically the IP address.
	// It can also be UDS path, or others.
	Address *v3.Address `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	// The canonical service name of the peer.
	// It should be set to :ref:`the HTTP x-envoy-downstream-service-cluster
	// <config_http_conn_man_headers_downstream-service-cluster>`
	// If a more trusted source of the service name is available through mTLS/secure naming, it
	// should be used.
	Service string `protobuf:"bytes,2,opt,name=service,proto3" json:"service,omitempty"`
	// The labels associated with the peer.
	// These could be pod labels for Kubernetes or tags for VMs.
	// The source of the labels could be an X.509 certificate or other configuration.
	Labels map[string]string `protobuf:"bytes,3,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// The authenticated identity of this peer.
	// For example, the identity associated with the workload such as a service account.
	// If an X.509 certificate is used to assert the identity this field should be sourced from
	// “URI Subject Alternative Names“, “DNS Subject Alternate Names“ or “Subject“ in that order.
	// The primary identity should be the principal. The principal format is issuer specific.
	//
	// Examples:
	//
	// - SPIFFE format is “spiffe://trust-domain/path“.
	// - Google account format is “https://accounts.google.com/{userid}“.
	Principal string `protobuf:"bytes,4,opt,name=principal,proto3" json:"principal,omitempty"`
	// The X.509 certificate used to authenticate the identify of this peer.
	// When present, the certificate contents are encoded in URL and PEM format.
	Certificate   string `protobuf:"bytes,5,opt,name=certificate,proto3" json:"certificate,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AttributeContext_Peer) Reset() {
	*x = AttributeContext_Peer{}
	mi := &file_envoy_service_auth_v3_attribute_context_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AttributeContext_Peer) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttributeContext_Peer) ProtoMessage() {}

func (x *AttributeContext_Peer) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_service_auth_v3_attribute_context_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttributeContext_Peer.ProtoReflect.Descriptor instead.
func (*AttributeContext_Peer) Descriptor() ([]byte, []int) {
	return file_envoy_service_auth_v3_attribute_context_proto_rawDescGZIP(), []int{0, 0}
}

func (x *AttributeContext_Peer) GetAddress() *v3.Address {
	if x != nil {
		return x.Address
	}
	return nil
}

func (x *AttributeContext_Peer) GetService() string {
	if x != nil {
		return x.Service
	}
	return ""
}

func (x *AttributeContext_Peer) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *AttributeContext_Peer) GetPrincipal() string {
	if x != nil {
		return x.Principal
	}
	return ""
}

func (x *AttributeContext_Peer) GetCertificate() string {
	if x != nil {
		return x.Certificate
	}
	return ""
}

// Represents a network request, such as an HTTP request.
type AttributeContext_Request struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The timestamp when the proxy receives the first byte of the request.
	Time *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=time,proto3" json:"time,omitempty"`
	// Represents an HTTP request or an HTTP-like request.
	Http          *AttributeContext_HttpRequest `protobuf:"bytes,2,opt,name=http,proto3" json:"http,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AttributeContext_Request) Reset() {
	*x = AttributeContext_Request{}
	mi := &file_envoy_service_auth_v3_attribute_context_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AttributeContext_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttributeContext_Request) ProtoMessage() {}

func (x *AttributeContext_Request) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_service_auth_v3_attribute_context_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttributeContext_Request.ProtoReflect.Descriptor instead.
func (*AttributeContext_Request) Descriptor() ([]byte, []int) {
	return file_envoy_service_auth_v3_attribute_context_proto_rawDescGZIP(), []int{0, 1}
}

func (x *AttributeContext_Request) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

func (x *AttributeContext_Request) GetHttp() *AttributeContext_HttpRequest {
	if x != nil {
		return x.Http
	}
	return nil
}

// This message defines attributes for an HTTP request.
// HTTP/1.x, HTTP/2, gRPC are all considered as HTTP requests.
// [#next-free-field: 14]
type AttributeContext_HttpRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The unique ID for a request, which can be propagated to downstream
	// systems. The ID should have low probability of collision
	// within a single day for a specific service.
	// For HTTP requests, it should be X-Request-ID or equivalent.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The HTTP request method, such as “GET“, “POST“.
	Method string `protobuf:"bytes,2,opt,name=method,proto3" json:"method,omitempty"`
	// The HTTP request headers. If multiple headers share the same key, they
	// must be merged according to the HTTP spec. All header keys must be
	// lower-cased, because HTTP header keys are case-insensitive.
	// Header value is encoded as UTF-8 string. Non-UTF-8 characters will be replaced by "!".
	// This field will not be set if
	// :ref:`encode_raw_headers <envoy_v3_api_field_extensions.filters.http.ext_authz.v3.ExtAuthz.encode_raw_headers>`
	// is set to true.
	Headers map[string]string `protobuf:"bytes,3,rep,name=headers,proto3" json:"headers,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// A list of the raw HTTP request headers. This is used instead of
	// :ref:`headers <envoy_v3_api_field_service.auth.v3.AttributeContext.HttpRequest.headers>` when
	// :ref:`encode_raw_headers <envoy_v3_api_field_extensions.filters.http.ext_authz.v3.ExtAuthz.encode_raw_headers>`
	// is set to true.
	//
	// Note that this is not actually a map type. “header_map“ contains a single repeated field
	// “headers“.
	//
	// Here, only the “key“ and “raw_value“ fields will be populated for each HeaderValue, and
	// that is only when
	// :ref:`encode_raw_headers <envoy_v3_api_field_extensions.filters.http.ext_authz.v3.ExtAuthz.encode_raw_headers>`
	// is set to true.
	//
	// Also, unlike the
	// :ref:`headers <envoy_v3_api_field_service.auth.v3.AttributeContext.HttpRequest.headers>`
	// field, headers with the same key are not combined into a single comma separated header.
	HeaderMap *v3.HeaderMap `protobuf:"bytes,13,opt,name=header_map,json=headerMap,proto3" json:"header_map,omitempty"`
	// The request target, as it appears in the first line of the HTTP request. This includes
	// the URL path and query-string. No decoding is performed.
	Path string `protobuf:"bytes,4,opt,name=path,proto3" json:"path,omitempty"`
	// The HTTP request “Host“ or “:authority“ header value.
	Host string `protobuf:"bytes,5,opt,name=host,proto3" json:"host,omitempty"`
	// The HTTP URL scheme, such as “http“ and “https“.
	Scheme string `protobuf:"bytes,6,opt,name=scheme,proto3" json:"scheme,omitempty"`
	// This field is always empty, and exists for compatibility reasons. The HTTP URL query is
	// included in “path“ field.
	Query string `protobuf:"bytes,7,opt,name=query,proto3" json:"query,omitempty"`
	// This field is always empty, and exists for compatibility reasons. The URL fragment is
	// not submitted as part of HTTP requests; it is unknowable.
	Fragment string `protobuf:"bytes,8,opt,name=fragment,proto3" json:"fragment,omitempty"`
	// The HTTP request size in bytes. If unknown, it must be -1.
	Size int64 `protobuf:"varint,9,opt,name=size,proto3" json:"size,omitempty"`
	// The network protocol used with the request, such as "HTTP/1.0", "HTTP/1.1", or "HTTP/2".
	//
	// See :repo:`headers.h:ProtocolStrings <source/common/http/headers.h>` for a list of all
	// possible values.
	Protocol string `protobuf:"bytes,10,opt,name=protocol,proto3" json:"protocol,omitempty"`
	// The HTTP request body.
	Body string `protobuf:"bytes,11,opt,name=body,proto3" json:"body,omitempty"`
	// The HTTP request body in bytes. This is used instead of
	// :ref:`body <envoy_v3_api_field_service.auth.v3.AttributeContext.HttpRequest.body>` when
	// :ref:`pack_as_bytes <envoy_v3_api_field_extensions.filters.http.ext_authz.v3.BufferSettings.pack_as_bytes>`
	// is set to true.
	RawBody       []byte `protobuf:"bytes,12,opt,name=raw_body,json=rawBody,proto3" json:"raw_body,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AttributeContext_HttpRequest) Reset() {
	*x = AttributeContext_HttpRequest{}
	mi := &file_envoy_service_auth_v3_attribute_context_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AttributeContext_HttpRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttributeContext_HttpRequest) ProtoMessage() {}

func (x *AttributeContext_HttpRequest) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_service_auth_v3_attribute_context_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttributeContext_HttpRequest.ProtoReflect.Descriptor instead.
func (*AttributeContext_HttpRequest) Descriptor() ([]byte, []int) {
	return file_envoy_service_auth_v3_attribute_context_proto_rawDescGZIP(), []int{0, 2}
}

func (x *AttributeContext_HttpRequest) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *AttributeContext_HttpRequest) GetMethod() string {
	if x != nil {
		return x.Method
	}
	return ""
}

func (x *AttributeContext_HttpRequest) GetHeaders() map[string]string {
	if x != nil {
		return x.Headers
	}
	return nil
}

func (x *AttributeContext_HttpRequest) GetHeaderMap() *v3.HeaderMap {
	if x != nil {
		return x.HeaderMap
	}
	return nil
}

func (x *AttributeContext_HttpRequest) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *AttributeContext_HttpRequest) GetHost() string {
	if x != nil {
		return x.Host
	}
	return ""
}

func (x *AttributeContext_HttpRequest) GetScheme() string {
	if x != nil {
		return x.Scheme
	}
	return ""
}

func (x *AttributeContext_HttpRequest) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *AttributeContext_HttpRequest) GetFragment() string {
	if x != nil {
		return x.Fragment
	}
	return ""
}

func (x *AttributeContext_HttpRequest) GetSize() int64 {
	if x != nil {
		return x.Size
	}
	return 0
}

func (x *AttributeContext_HttpRequest) GetProtocol() string {
	if x != nil {
		return x.Protocol
	}
	return ""
}

func (x *AttributeContext_HttpRequest) GetBody() string {
	if x != nil {
		return x.Body
	}
	return ""
}

func (x *AttributeContext_HttpRequest) GetRawBody() []byte {
	if x != nil {
		return x.RawBody
	}
	return nil
}

// This message defines attributes for the underlying TLS session.
type AttributeContext_TLSSession struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// SNI used for TLS session.
	Sni           string `protobuf:"bytes,1,opt,name=sni,proto3" json:"sni,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AttributeContext_TLSSession) Reset() {
	*x = AttributeContext_TLSSession{}
	mi := &file_envoy_service_auth_v3_attribute_context_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AttributeContext_TLSSession) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttributeContext_TLSSession) ProtoMessage() {}

func (x *AttributeContext_TLSSession) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_service_auth_v3_attribute_context_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttributeContext_TLSSession.ProtoReflect.Descriptor instead.
func (*AttributeContext_TLSSession) Descriptor() ([]byte, []int) {
	return file_envoy_service_auth_v3_attribute_context_proto_rawDescGZIP(), []int{0, 3}
}

func (x *AttributeContext_TLSSession) GetSni() string {
	if x != nil {
		return x.Sni
	}
	return ""
}

var File_envoy_service_auth_v3_attribute_context_proto protoreflect.FileDescriptor

const file_envoy_service_auth_v3_attribute_context_proto_rawDesc = "" +
	"\n" +
	"-envoy/service/auth/v3/attribute_context.proto\x12\x15envoy.service.auth.v3\x1a\"envoy/config/core/v3/address.proto\x1a\x1fenvoy/config/core/v3/base.proto\x1a\x1fgoogle/protobuf/timestamp.proto\x1a\x1eudpa/annotations/migrate.proto\x1a\x1dudpa/annotations/status.proto\x1a!udpa/annotations/versioning.proto\"\xce\x0e\n" +
	"\x10AttributeContext\x12D\n" +
	"\x06source\x18\x01 \x01(\v2,.envoy.service.auth.v3.AttributeContext.PeerR\x06source\x12N\n" +
	"\vdestination\x18\x02 \x01(\v2,.envoy.service.auth.v3.AttributeContext.PeerR\vdestination\x12I\n" +
	"\arequest\x18\x04 \x01(\v2/.envoy.service.auth.v3.AttributeContext.RequestR\arequest\x12m\n" +
	"\x12context_extensions\x18\n" +
	" \x03(\v2>.envoy.service.auth.v3.AttributeContext.ContextExtensionsEntryR\x11contextExtensions\x12I\n" +
	"\x10metadata_context\x18\v \x01(\v2\x1e.envoy.config.core.v3.MetadataR\x0fmetadataContext\x12T\n" +
	"\x16route_metadata_context\x18\r \x01(\v2\x1e.envoy.config.core.v3.MetadataR\x14routeMetadataContext\x12S\n" +
	"\vtls_session\x18\f \x01(\v22.envoy.service.auth.v3.AttributeContext.TLSSessionR\n" +
	"tlsSession\x1a\xda\x02\n" +
	"\x04Peer\x127\n" +
	"\aaddress\x18\x01 \x01(\v2\x1d.envoy.config.core.v3.AddressR\aaddress\x12\x18\n" +
	"\aservice\x18\x02 \x01(\tR\aservice\x12P\n" +
	"\x06labels\x18\x03 \x03(\v28.envoy.service.auth.v3.AttributeContext.Peer.LabelsEntryR\x06labels\x12\x1c\n" +
	"\tprincipal\x18\x04 \x01(\tR\tprincipal\x12 \n" +
	"\vcertificate\x18\x05 \x01(\tR\vcertificate\x1a9\n" +
	"\vLabelsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01:2\x9aň\x1e-\n" +
	"+envoy.service.auth.v2.AttributeContext.Peer\x1a\xb9\x01\n" +
	"\aRequest\x12.\n" +
	"\x04time\x18\x01 \x01(\v2\x1a.google.protobuf.TimestampR\x04time\x12G\n" +
	"\x04http\x18\x02 \x01(\v23.envoy.service.auth.v3.AttributeContext.HttpRequestR\x04http:5\x9aň\x1e0\n" +
	".envoy.service.auth.v2.AttributeContext.Request\x1a\xc5\x04\n" +
	"\vHttpRequest\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\x12\x16\n" +
	"\x06method\x18\x02 \x01(\tR\x06method\x12p\n" +
	"\aheaders\x18\x03 \x03(\v2@.envoy.service.auth.v3.AttributeContext.HttpRequest.HeadersEntryB\x14\xf2\x98\xfe\x8f\x05\x0e\x12\fheaders_typeR\aheaders\x12T\n" +
	"\n" +
	"header_map\x18\r \x01(\v2\x1f.envoy.config.core.v3.HeaderMapB\x14\xf2\x98\xfe\x8f\x05\x0e\x12\fheaders_typeR\theaderMap\x12\x12\n" +
	"\x04path\x18\x04 \x01(\tR\x04path\x12\x12\n" +
	"\x04host\x18\x05 \x01(\tR\x04host\x12\x16\n" +
	"\x06scheme\x18\x06 \x01(\tR\x06scheme\x12\x14\n" +
	"\x05query\x18\a \x01(\tR\x05query\x12\x1a\n" +
	"\bfragment\x18\b \x01(\tR\bfragment\x12\x12\n" +
	"\x04size\x18\t \x01(\x03R\x04size\x12\x1a\n" +
	"\bprotocol\x18\n" +
	" \x01(\tR\bprotocol\x12\x12\n" +
	"\x04body\x18\v \x01(\tR\x04body\x12\x19\n" +
	"\braw_body\x18\f \x01(\fR\arawBody\x1a:\n" +
	"\fHeadersEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01:9\x9aň\x1e4\n" +
	"2envoy.service.auth.v2.AttributeContext.HttpRequest\x1a\x1e\n" +
	"\n" +
	"TLSSession\x12\x10\n" +
	"\x03sni\x18\x01 \x01(\tR\x03sni\x1aD\n" +
	"\x16ContextExtensionsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01:-\x9aň\x1e(\n" +
	"&envoy.service.auth.v2.AttributeContextB\x8b\x01\xba\x80\xc8\xd1\x06\x02\x10\x02\n" +
	"#io.envoyproxy.envoy.service.auth.v3B\x15AttributeContextProtoP\x01ZCgithub.com/envoyproxy/go-control-plane/envoy/service/auth/v3;authv3b\x06proto3"

var (
	file_envoy_service_auth_v3_attribute_context_proto_rawDescOnce sync.Once
	file_envoy_service_auth_v3_attribute_context_proto_rawDescData []byte
)

func file_envoy_service_auth_v3_attribute_context_proto_rawDescGZIP() []byte {
	file_envoy_service_auth_v3_attribute_context_proto_rawDescOnce.Do(func() {
		file_envoy_service_auth_v3_attribute_context_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_envoy_service_auth_v3_attribute_context_proto_rawDesc), len(file_envoy_service_auth_v3_attribute_context_proto_rawDesc)))
	})
	return file_envoy_service_auth_v3_attribute_context_proto_rawDescData
}

var file_envoy_service_auth_v3_attribute_context_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_envoy_service_auth_v3_attribute_context_proto_goTypes = []any{
	(*AttributeContext)(nil),             // 0: envoy.service.auth.v3.AttributeContext
	(*AttributeContext_Peer)(nil),        // 1: envoy.service.auth.v3.AttributeContext.Peer
	(*AttributeContext_Request)(nil),     // 2: envoy.service.auth.v3.AttributeContext.Request
	(*AttributeContext_HttpRequest)(nil), // 3: envoy.service.auth.v3.AttributeContext.HttpRequest
	(*AttributeContext_TLSSession)(nil),  // 4: envoy.service.auth.v3.AttributeContext.TLSSession
	nil,                                  // 5: envoy.service.auth.v3.AttributeContext.ContextExtensionsEntry
	nil,                                  // 6: envoy.service.auth.v3.AttributeContext.Peer.LabelsEntry
	nil,                                  // 7: envoy.service.auth.v3.AttributeContext.HttpRequest.HeadersEntry
	(*v3.Metadata)(nil),                  // 8: envoy.config.core.v3.Metadata
	(*v3.Address)(nil),                   // 9: envoy.config.core.v3.Address
	(*timestamppb.Timestamp)(nil),        // 10: google.protobuf.Timestamp
	(*v3.HeaderMap)(nil),                 // 11: envoy.config.core.v3.HeaderMap
}
var file_envoy_service_auth_v3_attribute_context_proto_depIdxs = []int32{
	1,  // 0: envoy.service.auth.v3.AttributeContext.source:type_name -> envoy.service.auth.v3.AttributeContext.Peer
	1,  // 1: envoy.service.auth.v3.AttributeContext.destination:type_name -> envoy.service.auth.v3.AttributeContext.Peer
	2,  // 2: envoy.service.auth.v3.AttributeContext.request:type_name -> envoy.service.auth.v3.AttributeContext.Request
	5,  // 3: envoy.service.auth.v3.AttributeContext.context_extensions:type_name -> envoy.service.auth.v3.AttributeContext.ContextExtensionsEntry
	8,  // 4: envoy.service.auth.v3.AttributeContext.metadata_context:type_name -> envoy.config.core.v3.Metadata
	8,  // 5: envoy.service.auth.v3.AttributeContext.route_metadata_context:type_name -> envoy.config.core.v3.Metadata
	4,  // 6: envoy.service.auth.v3.AttributeContext.tls_session:type_name -> envoy.service.auth.v3.AttributeContext.TLSSession
	9,  // 7: envoy.service.auth.v3.AttributeContext.Peer.address:type_name -> envoy.config.core.v3.Address
	6,  // 8: envoy.service.auth.v3.AttributeContext.Peer.labels:type_name -> envoy.service.auth.v3.AttributeContext.Peer.LabelsEntry
	10, // 9: envoy.service.auth.v3.AttributeContext.Request.time:type_name -> google.protobuf.Timestamp
	3,  // 10: envoy.service.auth.v3.AttributeContext.Request.http:type_name -> envoy.service.auth.v3.AttributeContext.HttpRequest
	7,  // 11: envoy.service.auth.v3.AttributeContext.HttpRequest.headers:type_name -> envoy.service.auth.v3.AttributeContext.HttpRequest.HeadersEntry
	11, // 12: envoy.service.auth.v3.AttributeContext.HttpRequest.header_map:type_name -> envoy.config.core.v3.HeaderMap
	13, // [13:13] is the sub-list for method output_type
	13, // [13:13] is the sub-list for method input_type
	13, // [13:13] is the sub-list for extension type_name
	13, // [13:13] is the sub-list for extension extendee
	0,  // [0:13] is the sub-list for field type_name
}

func init() { file_envoy_service_auth_v3_attribute_context_proto_init() }
func file_envoy_service_auth_v3_attribute_context_proto_init() {
	if File_envoy_service_auth_v3_attribute_context_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_envoy_service_auth_v3_attribute_context_proto_rawDesc), len(file_envoy_service_auth_v3_attribute_context_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_envoy_service_auth_v3_attribute_context_proto_goTypes,
		DependencyIndexes: file_envoy_service_auth_v3_attribute_context_proto_depIdxs,
		MessageInfos:      file_envoy_service_auth_v3_attribute_context_proto_msgTypes,
	}.Build()
	File_envoy_service_auth_v3_attribute_context_proto = out.File
	file_envoy_service_auth_v3_attribute_context_proto_goTypes = nil
	file_envoy_service_auth_v3_attribute_context_proto_depIdxs = nil
}
