/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1alpha1

// ListenerSetSpecApplyConfiguration represents a declarative configuration of the ListenerSetSpec type for use
// with apply.
type ListenerSetSpecApplyConfiguration struct {
	ParentRef *ParentGatewayReferenceApplyConfiguration `json:"parentRef,omitempty"`
	Listeners []ListenerEntryApplyConfiguration         `json:"listeners,omitempty"`
}

// ListenerSetSpecApplyConfiguration constructs a declarative configuration of the ListenerSetSpec type for use with
// apply.
func ListenerSetSpec() *ListenerSetSpecApplyConfiguration {
	return &ListenerSetSpecApplyConfiguration{}
}

// WithParentRef sets the ParentRef field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ParentRef field is set to the value of the last call.
func (b *ListenerSetSpecApplyConfiguration) WithParentRef(value *ParentGatewayReferenceApplyConfiguration) *ListenerSetSpecApplyConfiguration {
	b.ParentRef = value
	return b
}

// WithListeners adds the given value to the Listeners field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Listeners field.
func (b *ListenerSetSpecApplyConfiguration) WithListeners(values ...*ListenerEntryApplyConfiguration) *ListenerSetSpecApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithListeners")
		}
		b.Listeners = append(b.Listeners, *values[i])
	}
	return b
}
