/*
 * Copyright (C) 2020 Collabora, Ltd.
 * SPDX-License-Identifier: MIT
 */

/* Autogenerated file, do not edit */

#include <stdio.h>
#include "compiler.h"

static const char *
bi_swizzle_as_str(enum bi_swizzle swz)
{
        switch (swz) {
        case BI_SWIZZLE_H00: return ".h00";
        case BI_SWIZZLE_H01: return "";
        case BI_SWIZZLE_H10: return ".h10";
        case BI_SWIZZLE_H11: return ".h11";
        case BI_SWIZZLE_B0000: return ".b0";
        case BI_SWIZZLE_B1111: return ".b1";
        case BI_SWIZZLE_B2222: return ".b2";
        case BI_SWIZZLE_B3333: return ".b3";
        case BI_SWIZZLE_B0011: return ".b0011";
        case BI_SWIZZLE_B2233: return ".b2233";
        case BI_SWIZZLE_B1032: return ".b1032";
        case BI_SWIZZLE_B3210: return ".b3210";
        case BI_SWIZZLE_B0022: return ".b0022";
        case BI_SWIZZLE_B1100: return ".b1100";
        case BI_SWIZZLE_B2200: return ".b2200";
        case BI_SWIZZLE_B3300: return ".b3300";
        case BI_SWIZZLE_B2211: return ".b2211";
        case BI_SWIZZLE_B3311: return ".b3311";
        case BI_SWIZZLE_B1122: return ".b1122";
        case BI_SWIZZLE_B3322: return ".b3322";
        case BI_SWIZZLE_B0033: return ".b0033";
        case BI_SWIZZLE_B1133: return ".b1133";
        case BI_SWIZZLE_B1123: return ".b1123";
        }

        UNREACHABLE("Invalid swizzle");
}

static const char *
bir_fau_name(unsigned fau_idx)
{
    const char *names[] = {
            "zero", "lane-id", "warp-id", "core-id", "fb-extent",
            "atest-param", "sample-pos", "reserved",
            "blend_descriptor_0", "blend_descriptor_1",
            "blend_descriptor_2", "blend_descriptor_3",
            "blend_descriptor_4", "blend_descriptor_5",
            "blend_descriptor_6", "blend_descriptor_7",
            "tls_ptr", "wls_ptr", "program_counter",
    };

    assert(fau_idx < ARRAY_SIZE(names));
    return names[fau_idx];
}

static const char *
bir_passthrough_name(unsigned idx)
{
    const char *names[] = {
            "s0", "s1", "s2", "t", "fau.x", "fau.y", "t0", "t1"
    };

    assert(idx < ARRAY_SIZE(names));
    return names[idx];
}

static void
bi_print_index(FILE *fp, bi_index index)
{
    if (index.discard)
        fputs("^", fp);
    if (index.kill_ssa)
        fputs("!", fp);

    if (bi_is_null(index))
        fprintf(fp, "_");
    else if (index.type == BI_INDEX_CONSTANT)
        fprintf(fp, "#0x%x", index.value);
    else if (index.type == BI_INDEX_FAU && index.memory)
        fprintf(fp, "m%u", index.value);
    else if (index.type == BI_INDEX_FAU && index.value >= BIR_FAU_UNIFORM)
        fprintf(fp, "u%u", index.value & ~BIR_FAU_UNIFORM);
    else if (index.type == BI_INDEX_FAU)
        fprintf(fp, "%s", bir_fau_name(index.value));
    else if (index.type == BI_INDEX_PASS)
        fprintf(fp, "%s", bir_passthrough_name(index.value));
    else if (index.type == BI_INDEX_REGISTER)
        fprintf(fp, "r%u", index.value);
    else if (index.type == BI_INDEX_NORMAL)
        fprintf(fp, "%u", index.value);
    else
        UNREACHABLE("Invalid index");

    if (index.offset)
        fprintf(fp, "[%u]", index.offset);

    if (index.abs)
        fputs(".abs", fp);

    if (index.neg)
        fputs(".neg", fp);

    fputs(bi_swizzle_as_str(index.swizzle), fp);
}


UNUSED static inline const char *
bi_adj_as_str(enum bi_adj adj)
{
    switch (adj) {
    case BI_ADJ_LOW: return ".low";
    case BI_ADJ_NONE: return "";
    case BI_ADJ_SMALL: return ".small";
    }

    UNREACHABLE("Invalid adj");
};

UNUSED static inline const char *
bi_atom_opc_as_str(enum bi_atom_opc atom_opc)
{
    switch (atom_opc) {
    case BI_ATOM_OPC_AADD: return ".aadd";
    case BI_ATOM_OPC_AADDS: return ".aadds";
    case BI_ATOM_OPC_AADDU: return ".aaddu";
    case BI_ATOM_OPC_AAND: return ".aand";
    case BI_ATOM_OPC_ACMPXCHG: return ".acmpxchg";
    case BI_ATOM_OPC_ADEC: return ".adec";
    case BI_ATOM_OPC_AINC: return ".ainc";
    case BI_ATOM_OPC_AOR: return ".aor";
    case BI_ATOM_OPC_AOR1: return ".aor1";
    case BI_ATOM_OPC_ASMAX: return ".asmax";
    case BI_ATOM_OPC_ASMAX1: return ".asmax1";
    case BI_ATOM_OPC_ASMIN: return ".asmin";
    case BI_ATOM_OPC_AUMAX: return ".aumax";
    case BI_ATOM_OPC_AUMAX1: return ".aumax1";
    case BI_ATOM_OPC_AUMIN: return ".aumin";
    case BI_ATOM_OPC_AXCHG: return ".axchg";
    case BI_ATOM_OPC_AXOR: return ".axor";
    }

    UNREACHABLE("Invalid atom_opc");
};

UNUSED static inline const char *
bi_clamp_as_str(enum bi_clamp clamp)
{
    switch (clamp) {
    case BI_CLAMP_CLAMP_0_1: return ".clamp_0_1";
    case BI_CLAMP_CLAMP_0_INF: return ".clamp_0_inf";
    case BI_CLAMP_CLAMP_M1_1: return ".clamp_m1_1";
    case BI_CLAMP_NONE: return "";
    }

    UNREACHABLE("Invalid clamp");
};

UNUSED static inline const char *
bi_cmpf_as_str(enum bi_cmpf cmpf)
{
    switch (cmpf) {
    case BI_CMPF_EQ: return ".eq";
    case BI_CMPF_GE: return ".ge";
    case BI_CMPF_GT: return ".gt";
    case BI_CMPF_GTLT: return ".gtlt";
    case BI_CMPF_LE: return ".le";
    case BI_CMPF_LT: return ".lt";
    case BI_CMPF_NE: return ".ne";
    case BI_CMPF_TOTAL: return ".total";
    }

    UNREACHABLE("Invalid cmpf");
};

UNUSED static inline const char *
bi_dimension_as_str(enum bi_dimension dimension)
{
    switch (dimension) {
    case BI_DIMENSION_1D: return ".1d";
    case BI_DIMENSION_2D: return ".2d";
    case BI_DIMENSION_3D: return ".3d";
    case BI_DIMENSION_CUBE: return ".cube";
    }

    UNREACHABLE("Invalid dimension");
};

UNUSED static inline const char *
bi_extend_as_str(enum bi_extend extend)
{
    switch (extend) {
    case BI_EXTEND_NONE: return "";
    case BI_EXTEND_SEXT: return ".sext";
    case BI_EXTEND_ZEXT: return ".zext";
    }

    UNREACHABLE("Invalid extend");
};

UNUSED static inline const char *
bi_fetch_component_as_str(enum bi_fetch_component fetch_component)
{
    switch (fetch_component) {
    case BI_FETCH_COMPONENT_GATHER4_A: return ".gather4_a";
    case BI_FETCH_COMPONENT_GATHER4_B: return ".gather4_b";
    case BI_FETCH_COMPONENT_GATHER4_G: return ".gather4_g";
    case BI_FETCH_COMPONENT_GATHER4_R: return ".gather4_r";
    }

    UNREACHABLE("Invalid fetch_component");
};

UNUSED static inline const char *
bi_func_as_str(enum bi_func func)
{
    switch (func) {
    case BI_FUNC_POW: return ".pow";
    case BI_FUNC_POWN: return ".pown";
    case BI_FUNC_POWR: return ".powr";
    case BI_FUNC_ROOTN: return ".rootn";
    }

    UNREACHABLE("Invalid func");
};

UNUSED static inline const char *
bi_function_as_str(enum bi_function function)
{
    switch (function) {
    case BI_FUNCTION_AND: return ".and";
    case BI_FUNCTION_NONE: return "";
    case BI_FUNCTION_OR: return ".or";
    }

    UNREACHABLE("Invalid function");
};

UNUSED static inline const char *
bi_inactive_result_as_str(enum bi_inactive_result inactive_result)
{
    switch (inactive_result) {
    case BI_INACTIVE_RESULT_F1: return ".f1";
    case BI_INACTIVE_RESULT_I1: return ".i1";
    case BI_INACTIVE_RESULT_INF: return ".inf";
    case BI_INACTIVE_RESULT_INFN: return ".infn";
    case BI_INACTIVE_RESULT_SMAX: return ".smax";
    case BI_INACTIVE_RESULT_SMIN: return ".smin";
    case BI_INACTIVE_RESULT_UMAX: return ".umax";
    case BI_INACTIVE_RESULT_V2F1: return ".v2f1";
    case BI_INACTIVE_RESULT_V2I1: return ".v2i1";
    case BI_INACTIVE_RESULT_V2INF: return ".v2inf";
    case BI_INACTIVE_RESULT_V2INFN: return ".v2infn";
    case BI_INACTIVE_RESULT_V2SMAX: return ".v2smax";
    case BI_INACTIVE_RESULT_V2SMIN: return ".v2smin";
    case BI_INACTIVE_RESULT_V4SMAX: return ".v4smax";
    case BI_INACTIVE_RESULT_V4SMIN: return ".v4smin";
    case BI_INACTIVE_RESULT_ZERO: return ".zero";
    }

    UNREACHABLE("Invalid inactive_result");
};

UNUSED static inline const char *
bi_lane_as_str(enum bi_lane lane)
{
    switch (lane) {
    case BI_LANE_B0: return ".b0";
    case BI_LANE_B1: return ".b1";
    case BI_LANE_B2: return ".b2";
    case BI_LANE_B3: return ".b3";
    case BI_LANE_H0: return ".h0";
    case BI_LANE_H1: return ".h1";
    case BI_LANE_NONE: return "";
    }

    UNREACHABLE("Invalid lane");
};

UNUSED static inline const char *
bi_lane_dest_as_str(enum bi_lane_dest lane_dest)
{
    switch (lane_dest) {
    case BI_LANE_DEST_B0: return ".b0";
    case BI_LANE_DEST_B1: return ".b1";
    case BI_LANE_DEST_B2: return ".b2";
    case BI_LANE_DEST_B3: return ".b3";
    case BI_LANE_DEST_D0: return ".d0";
    case BI_LANE_DEST_H0: return ".h0";
    case BI_LANE_DEST_H1: return ".h1";
    case BI_LANE_DEST_NONE: return "";
    case BI_LANE_DEST_W0: return ".w0";
    }

    UNREACHABLE("Invalid lane_dest");
};

UNUSED static inline const char *
bi_lane_op_as_str(enum bi_lane_op lane_op)
{
    switch (lane_op) {
    case BI_LANE_OP_ACCUMULATE: return ".accumulate";
    case BI_LANE_OP_NONE: return "";
    case BI_LANE_OP_SHIFT: return ".shift";
    case BI_LANE_OP_XOR: return ".xor";
    }

    UNREACHABLE("Invalid lane_op");
};

UNUSED static inline const char *
bi_lanes_as_str(enum bi_lanes lanes)
{
    switch (lanes) {
    case BI_LANES_B0: return ".b0";
    case BI_LANES_B00: return ".b00";
    case BI_LANES_B0000: return ".b0000";
    case BI_LANES_B01: return ".b01";
    case BI_LANES_B0101: return ".b0101";
    case BI_LANES_B0123: return ".b0123";
    case BI_LANES_B02: return ".b02";
    case BI_LANES_B1: return ".b1";
    case BI_LANES_B11: return ".b11";
    case BI_LANES_B1111: return ".b1111";
    case BI_LANES_B2: return ".b2";
    case BI_LANES_B22: return ".b22";
    case BI_LANES_B2222: return ".b2222";
    case BI_LANES_B23: return ".b23";
    case BI_LANES_B2323: return ".b2323";
    case BI_LANES_B3: return ".b3";
    case BI_LANES_B33: return ".b33";
    case BI_LANES_B3333: return ".b3333";
    case BI_LANES_H0: return ".h0";
    case BI_LANES_H00: return ".h00";
    case BI_LANES_H01: return ".h01";
    case BI_LANES_H1: return ".h1";
    case BI_LANES_H10: return ".h10";
    case BI_LANES_H11: return ".h11";
    case BI_LANES_NONE: return "";
    }

    UNREACHABLE("Invalid lanes");
};

UNUSED static inline const char *
bi_mode_as_str(enum bi_mode mode)
{
    switch (mode) {
    case BI_MODE_BASE2: return ".base2";
    case BI_MODE_NATURAL: return ".natural";
    case BI_MODE_RED: return ".red";
    }

    UNREACHABLE("Invalid mode");
};

UNUSED static inline const char *
bi_mux_as_str(enum bi_mux mux)
{
    switch (mux) {
    case BI_MUX_BIT: return ".bit";
    case BI_MUX_FP_ZERO: return ".fp_zero";
    case BI_MUX_INT_ZERO: return ".int_zero";
    case BI_MUX_NEG: return ".neg";
    }

    UNREACHABLE("Invalid mux");
};

UNUSED static inline const char *
bi_precision_as_str(enum bi_precision precision)
{
    switch (precision) {
    case BI_PRECISION_HIGH: return ".high";
    case BI_PRECISION_LOW: return ".low";
    case BI_PRECISION_NONE: return "";
    }

    UNREACHABLE("Invalid precision");
};

UNUSED static inline const char *
bi_register_format_as_str(enum bi_register_format register_format)
{
    switch (register_format) {
    case BI_REGISTER_FORMAT_AUTO: return ".auto";
    case BI_REGISTER_FORMAT_F16: return ".f16";
    case BI_REGISTER_FORMAT_F32: return ".f32";
    case BI_REGISTER_FORMAT_F64: return ".f64";
    case BI_REGISTER_FORMAT_I64: return ".i64";
    case BI_REGISTER_FORMAT_S16: return ".s16";
    case BI_REGISTER_FORMAT_S32: return ".s32";
    case BI_REGISTER_FORMAT_U16: return ".u16";
    case BI_REGISTER_FORMAT_U32: return ".u32";
    }

    UNREACHABLE("Invalid register_format");
};

UNUSED static inline const char *
bi_replicate_as_str(enum bi_replicate replicate)
{
    switch (replicate) {
    case BI_REPLICATE_B0000: return ".b0000";
    case BI_REPLICATE_B0123: return ".b0123";
    case BI_REPLICATE_B1111: return ".b1111";
    case BI_REPLICATE_B2222: return ".b2222";
    case BI_REPLICATE_B3333: return ".b3333";
    }

    UNREACHABLE("Invalid replicate");
};

UNUSED static inline const char *
bi_result_type_as_str(enum bi_result_type result_type)
{
    switch (result_type) {
    case BI_RESULT_TYPE_F1: return ".f1";
    case BI_RESULT_TYPE_I1: return ".i1";
    case BI_RESULT_TYPE_M1: return ".m1";
    }

    UNREACHABLE("Invalid result_type");
};

UNUSED static inline const char *
bi_round_as_str(enum bi_round round)
{
    switch (round) {
    case BI_ROUND_INF: return ".inf";
    case BI_ROUND_INF0: return ".inf0";
    case BI_ROUND_NONE: return "";
    case BI_ROUND_RTN: return ".rtn";
    case BI_ROUND_RTNA: return ".rtna";
    case BI_ROUND_RTO: return ".rto";
    case BI_ROUND_RTP: return ".rtp";
    case BI_ROUND_RTZ: return ".rtz";
    }

    UNREACHABLE("Invalid round");
};

UNUSED static inline const char *
bi_sample_as_str(enum bi_sample sample)
{
    switch (sample) {
    case BI_SAMPLE_CENTER: return ".center";
    case BI_SAMPLE_CENTROID: return ".centroid";
    case BI_SAMPLE_EXPLICIT: return ".explicit";
    case BI_SAMPLE_NONE: return "";
    case BI_SAMPLE_SAMPLE: return ".sample";
    }

    UNREACHABLE("Invalid sample");
};

UNUSED static inline const char *
bi_seg_as_str(enum bi_seg seg)
{
    switch (seg) {
    case BI_SEG_NONE: return "";
    case BI_SEG_POS: return ".pos";
    case BI_SEG_STREAM: return ".stream";
    case BI_SEG_TL: return ".tl";
    case BI_SEG_UBO: return ".ubo";
    case BI_SEG_VARY: return ".vary";
    case BI_SEG_WLS: return ".wls";
    }

    UNREACHABLE("Invalid seg");
};

UNUSED static inline const char *
bi_sem_as_str(enum bi_sem sem)
{
    switch (sem) {
    case BI_SEM_C: return ".c";
    case BI_SEM_INVERSE_C: return ".inverse_c";
    case BI_SEM_NAN_PROPAGATE: return ".nan_propagate";
    case BI_SEM_NAN_SUPPRESS: return ".nan_suppress";
    }

    UNREACHABLE("Invalid sem");
};

UNUSED static inline const char *
bi_source_as_str(enum bi_source source)
{
    switch (source) {
    case BI_SOURCE_CYCLE_COUNTER: return ".cycle_counter";
    case BI_SOURCE_SYSTEM_TIMESTAMP: return ".system_timestamp";
    }

    UNREACHABLE("Invalid source");
};

UNUSED static inline const char *
bi_source_format_as_str(enum bi_source_format source_format)
{
    switch (source_format) {
    case BI_SOURCE_FORMAT_F16: return ".f16";
    case BI_SOURCE_FORMAT_F32: return ".f32";
    case BI_SOURCE_FORMAT_FLAT16: return ".flat16";
    case BI_SOURCE_FORMAT_FLAT32: return ".flat32";
    }

    UNREACHABLE("Invalid source_format");
};

UNUSED static inline const char *
bi_special_as_str(enum bi_special special)
{
    switch (special) {
    case BI_SPECIAL_LEFT: return ".left";
    case BI_SPECIAL_N: return ".n";
    case BI_SPECIAL_NONE: return "";
    case BI_SPECIAL_SCALE16: return ".scale16";
    }

    UNREACHABLE("Invalid special");
};

UNUSED static inline const char *
bi_stack_mode_as_str(enum bi_stack_mode stack_mode)
{
    switch (stack_mode) {
    case BI_STACK_MODE_CALL: return ".call";
    case BI_STACK_MODE_NONE: return "";
    case BI_STACK_MODE_REPLACE: return ".replace";
    case BI_STACK_MODE_RETURN: return ".return";
    }

    UNREACHABLE("Invalid stack_mode");
};

UNUSED static inline const char *
bi_subgroup_as_str(enum bi_subgroup subgroup)
{
    switch (subgroup) {
    case BI_SUBGROUP_SUBGROUP16: return ".subgroup16";
    case BI_SUBGROUP_SUBGROUP2: return ".subgroup2";
    case BI_SUBGROUP_SUBGROUP4: return ".subgroup4";
    case BI_SUBGROUP_SUBGROUP8: return ".subgroup8";
    }

    UNREACHABLE("Invalid subgroup");
};

UNUSED static inline const char *
bi_swz_as_str(enum bi_swz swz)
{
    switch (swz) {
    case BI_SWZ_B00: return ".b00";
    case BI_SWZ_B0000: return ".b0000";
    case BI_SWZ_B0011: return ".b0011";
    case BI_SWZ_B01: return ".b01";
    case BI_SWZ_B02: return ".b02";
    case BI_SWZ_B03: return ".b03";
    case BI_SWZ_B10: return ".b10";
    case BI_SWZ_B1032: return ".b1032";
    case BI_SWZ_B11: return ".b11";
    case BI_SWZ_B1111: return ".b1111";
    case BI_SWZ_B12: return ".b12";
    case BI_SWZ_B13: return ".b13";
    case BI_SWZ_B20: return ".b20";
    case BI_SWZ_B21: return ".b21";
    case BI_SWZ_B22: return ".b22";
    case BI_SWZ_B2222: return ".b2222";
    case BI_SWZ_B2233: return ".b2233";
    case BI_SWZ_B23: return ".b23";
    case BI_SWZ_B30: return ".b30";
    case BI_SWZ_B31: return ".b31";
    case BI_SWZ_B32: return ".b32";
    case BI_SWZ_B3210: return ".b3210";
    case BI_SWZ_B33: return ".b33";
    case BI_SWZ_B3333: return ".b3333";
    case BI_SWZ_H00: return ".h00";
    case BI_SWZ_H01: return ".h01";
    case BI_SWZ_H10: return ".h10";
    case BI_SWZ_H11: return ".h11";
    }

    UNREACHABLE("Invalid swz");
};

UNUSED static inline const char *
bi_table_as_str(enum bi_table table)
{
    switch (table) {
    case BI_TABLE_ATTRIBUTE_1: return ".attribute_1";
    case BI_TABLE_ATTRIBUTE_2: return ".attribute_2";
    case BI_TABLE_FLAT: return ".flat";
    case BI_TABLE_NONE: return "";
    }

    UNREACHABLE("Invalid table");
};

UNUSED static inline const char *
bi_update_as_str(enum bi_update update)
{
    switch (update) {
    case BI_UPDATE_CLOBBER: return ".clobber";
    case BI_UPDATE_CONDITIONAL: return ".conditional";
    case BI_UPDATE_RETRIEVE: return ".retrieve";
    case BI_UPDATE_STORE: return ".store";
    }

    UNREACHABLE("Invalid update");
};

UNUSED static inline const char *
bi_va_lod_mode_as_str(enum bi_va_lod_mode va_lod_mode)
{
    switch (va_lod_mode) {
    case BI_VA_LOD_MODE_COMPUTED_BIAS: return ".computed_bias";
    case BI_VA_LOD_MODE_COMPUTED_LOD: return ".computed_lod";
    case BI_VA_LOD_MODE_EXPLICIT: return ".explicit";
    case BI_VA_LOD_MODE_GRDESC: return ".grdesc";
    case BI_VA_LOD_MODE_ZERO_LOD: return ".zero_lod";
    }

    UNREACHABLE("Invalid va_lod_mode");
};

UNUSED static inline const char *
bi_varying_name_as_str(enum bi_varying_name varying_name)
{
    switch (varying_name) {
    case BI_VARYING_NAME_FRAG_W: return ".frag_w";
    case BI_VARYING_NAME_FRAG_Z: return ".frag_z";
    case BI_VARYING_NAME_POINT: return ".point";
    }

    UNREACHABLE("Invalid varying_name");
};

UNUSED static inline const char *
bi_vecsize_as_str(enum bi_vecsize vecsize)
{
    switch (vecsize) {
    case BI_VECSIZE_NONE: return "";
    case BI_VECSIZE_V2: return ".v2";
    case BI_VECSIZE_V3: return ".v3";
    case BI_VECSIZE_V4: return ".v4";
    }

    UNREACHABLE("Invalid vecsize");
};

UNUSED static inline const char *
bi_widen_as_str(enum bi_widen widen)
{
    switch (widen) {
    case BI_WIDEN_B0: return ".b0";
    case BI_WIDEN_B1: return ".b1";
    case BI_WIDEN_B2: return ".b2";
    case BI_WIDEN_B3: return ".b3";
    case BI_WIDEN_H0: return ".h0";
    case BI_WIDEN_H1: return ".h1";
    case BI_WIDEN_NONE: return "";
    }

    UNREACHABLE("Invalid widen");
};

UNUSED static inline const char *
bi_write_mask_as_str(enum bi_write_mask write_mask)
{
    switch (write_mask) {
    case BI_WRITE_MASK_A: return ".a";
    case BI_WRITE_MASK_B: return ".b";
    case BI_WRITE_MASK_BA: return ".ba";
    case BI_WRITE_MASK_G: return ".g";
    case BI_WRITE_MASK_GA: return ".ga";
    case BI_WRITE_MASK_GB: return ".gb";
    case BI_WRITE_MASK_GBA: return ".gba";
    case BI_WRITE_MASK_NONE: return "";
    case BI_WRITE_MASK_R: return ".r";
    case BI_WRITE_MASK_RA: return ".ra";
    case BI_WRITE_MASK_RB: return ".rb";
    case BI_WRITE_MASK_RBA: return ".rba";
    case BI_WRITE_MASK_RG: return ".rg";
    case BI_WRITE_MASK_RGA: return ".rga";
    case BI_WRITE_MASK_RGB: return ".rgb";
    case BI_WRITE_MASK_RGBA: return ".rgba";
    }

    UNREACHABLE("Invalid write_mask");
};





void
bi_print_instr(const bi_instr *I, FILE *fp)
{
    fputs("   ", fp);

    bi_foreach_dest(I, d) {
        if (d > 0) fprintf(fp, ", ");

        bi_print_index(fp, I->dest[d]);
    }

    if (I->nr_dests > 0)
        fputs(" = ", fp);

    fprintf(fp, "%s", bi_get_opcode_props(I)->name);

    if (I->table)
        fprintf(fp, ".table%u", I->table);

    if (I->flow)
        fprintf(fp, ".flow%u", I->flow);

    if (I->op == BI_OPCODE_COLLECT_I32 || I->op == BI_OPCODE_PHI) {
        for (unsigned i = 0; i < I->nr_srcs; ++i) {
            if (i > 0)
                fputs(", ", fp);
            else
                fputs(" ", fp);

            bi_print_index(fp, I->src[i]);
        }
    }

    switch (I->op) {

    case BI_OPCODE_ACMPSTORE_I32:
        
        fputs(bi_seg_as_str(I->seg), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_ACMPSTORE_I64:
        
        fputs(bi_seg_as_str(I->seg), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_ACMPXCHG_I32:
        
        fputs(bi_seg_as_str(I->seg), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_ACMPXCHG_I64:
        
        fputs(bi_seg_as_str(I->seg), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_ARSHIFT_I32:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_ARSHIFT_V2I16:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_ARSHIFT_V4I8:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_ARSHIFT_DOUBLE_I32:
        
        if (I->result_word) fputs(".result_word", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        
        if (I->bytes2) fputs(".bytes", fp);

        break;

    case BI_OPCODE_ATEST:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_ATOM_I32:
        
        fputs(bi_atom_opc_as_str(I->atom_opc), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        fprintf(fp, ", sr_count:%u", I->sr_count);
        break;

    case BI_OPCODE_ATOM_I64:
        
        fputs(bi_atom_opc_as_str(I->atom_opc), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        fprintf(fp, ", sr_count:%u", I->sr_count);
        break;

    case BI_OPCODE_ATOM1_RETURN_I32:
        
        fputs(bi_atom_opc_as_str(I->atom_opc), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fprintf(fp, ", sr_count:%u", I->sr_count);
        break;

    case BI_OPCODE_ATOM1_RETURN_I64:
        
        fputs(bi_atom_opc_as_str(I->atom_opc), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fprintf(fp, ", sr_count:%u", I->sr_count);
        break;

    case BI_OPCODE_ATOM_C_I32:
        
        fputs(bi_atom_opc_as_str(I->atom_opc), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_ATOM_C_I64:
        
        fputs(bi_atom_opc_as_str(I->atom_opc), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_ATOM_C1_I32:
        
        fputs(bi_atom_opc_as_str(I->atom_opc), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_ATOM_C1_I64:
        
        fputs(bi_atom_opc_as_str(I->atom_opc), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_ATOM_C1_RETURN_I32:
        
        fputs(bi_atom_opc_as_str(I->atom_opc), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_ATOM_C1_RETURN_I64:
        
        fputs(bi_atom_opc_as_str(I->atom_opc), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_ATOM_CX:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[3]);
        

        fprintf(fp, ", sr_count:%u", I->sr_count);
        break;

    case BI_OPCODE_ATOM_C_RETURN_I32:
        
        fputs(bi_atom_opc_as_str(I->atom_opc), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_ATOM_C_RETURN_I64:
        
        fputs(bi_atom_opc_as_str(I->atom_opc), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_ATOM_POST_I32:
        
        fputs(bi_atom_opc_as_str(I->atom_opc), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_ATOM_POST_I64:
        
        fputs(bi_atom_opc_as_str(I->atom_opc), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_ATOM_PRE_I64:
        
        fputs(bi_atom_opc_as_str(I->atom_opc), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_ATOM_RETURN_I32:
        
        fputs(bi_atom_opc_as_str(I->atom_opc), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        fprintf(fp, ", sr_count:%u", I->sr_count);
        break;

    case BI_OPCODE_ATOM_RETURN_I64:
        
        fputs(bi_atom_opc_as_str(I->atom_opc), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        fprintf(fp, ", sr_count:%u", I->sr_count);
        break;

    case BI_OPCODE_AXCHG_I32:
        
        fputs(bi_seg_as_str(I->seg), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_AXCHG_I64:
        
        fputs(bi_seg_as_str(I->seg), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_BARRIER:
        

        fputs(" ", fp);
        break;

    case BI_OPCODE_BITREV_I32:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_BLEND:
        
        fputs(bi_register_format_as_str(I->register_format), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[3]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[4]);
        

        fprintf(fp, ", sr_count:%u", I->sr_count);
        fprintf(fp, ", sr_count_2:%u", I->sr_count_2);
        break;

    case BI_OPCODE_BRANCH_F16:
        
        fputs(bi_cmpf_as_str(I->cmpf), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_BRANCH_F32:
        
        fputs(bi_cmpf_as_str(I->cmpf), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_BRANCH_I16:
        
        fputs(bi_cmpf_as_str(I->cmpf), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_BRANCH_I32:
        
        fputs(bi_cmpf_as_str(I->cmpf), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_BRANCH_S16:
        
        fputs(bi_cmpf_as_str(I->cmpf), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_BRANCH_S32:
        
        fputs(bi_cmpf_as_str(I->cmpf), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_BRANCH_U16:
        
        fputs(bi_cmpf_as_str(I->cmpf), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_BRANCH_U32:
        
        fputs(bi_cmpf_as_str(I->cmpf), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_BRANCHC_I16:
        
        if (I->combine) fputs(".combine", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_BRANCHC_I32:
        
        if (I->combine) fputs(".combine", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_BRANCHZ_F16:
        
        fputs(bi_cmpf_as_str(I->cmpf), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_BRANCHZ_F32:
        
        fputs(bi_cmpf_as_str(I->cmpf), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_BRANCHZ_I16:
        
        fputs(bi_cmpf_as_str(I->cmpf), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_BRANCHZ_I32:
        
        fputs(bi_cmpf_as_str(I->cmpf), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_BRANCHZ_S16:
        
        fputs(bi_cmpf_as_str(I->cmpf), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_BRANCHZ_S32:
        
        fputs(bi_cmpf_as_str(I->cmpf), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_BRANCHZ_U16:
        
        fputs(bi_cmpf_as_str(I->cmpf), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_BRANCHZ_U32:
        
        fputs(bi_cmpf_as_str(I->cmpf), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_BRANCHZI:
        
        fputs(bi_cmpf_as_str(I->cmpf), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_BRANCH_DIVERG:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_BRANCH_LOWBITS_F32:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_BRANCH_NO_DIVERG:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_CLPER_I32:
        
        fputs(bi_lane_op_as_str(I->lane_op), fp);
        fputs(bi_subgroup_as_str(I->subgroup), fp);
        fputs(bi_inactive_result_as_str(I->inactive_result), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_CLPER_OLD_I32:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_CLZ_U32:
        
        if (I->mask) fputs(".mask", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_CLZ_V2U16:
        
        if (I->mask) fputs(".mask", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_CLZ_V4U8:
        
        if (I->mask) fputs(".mask", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_COLLECT_I32:
        

        fputs(" ", fp);
        break;

    case BI_OPCODE_CSEL_F32:
        
        fputs(bi_cmpf_as_str(I->cmpf), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[3]);
        

        break;

    case BI_OPCODE_CSEL_I32:
        
        fputs(bi_cmpf_as_str(I->cmpf), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[3]);
        

        break;

    case BI_OPCODE_CSEL_S32:
        
        fputs(bi_cmpf_as_str(I->cmpf), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[3]);
        

        break;

    case BI_OPCODE_CSEL_U32:
        
        fputs(bi_cmpf_as_str(I->cmpf), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[3]);
        

        break;

    case BI_OPCODE_CSEL_V2F16:
        
        fputs(bi_cmpf_as_str(I->cmpf), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[3]);
        

        break;

    case BI_OPCODE_CSEL_V2I16:
        
        fputs(bi_cmpf_as_str(I->cmpf), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[3]);
        

        break;

    case BI_OPCODE_CSEL_V2S16:
        
        fputs(bi_cmpf_as_str(I->cmpf), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[3]);
        

        break;

    case BI_OPCODE_CSEL_V2U16:
        
        fputs(bi_cmpf_as_str(I->cmpf), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[3]);
        

        break;

    case BI_OPCODE_CUBEFACE:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_CUBEFACE1:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_CUBEFACE2:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_CUBEFACE2_V9:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_CUBE_SSEL:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_CUBE_TSEL:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_DISCARD_B32:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_DISCARD_F32:
        
        fputs(bi_cmpf_as_str(I->cmpf), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_DTSEL_IMM:
        
        fputs(bi_table_as_str(I->table), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_F16_TO_F32:
        
        if (I->ftz) fputs(".ftz", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_F16_TO_S32:
        
        fputs(bi_round_as_str(I->round), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_F16_TO_U32:
        
        fputs(bi_round_as_str(I->round), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_F32_TO_S32:
        
        fputs(bi_round_as_str(I->round), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_F32_TO_U32:
        
        fputs(bi_round_as_str(I->round), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_FABSNEG_F32:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_FABSNEG_V2F16:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_FADD_F32:
        
        fputs(bi_round_as_str(I->round), fp);
        fputs(bi_clamp_as_str(I->clamp), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_FADD_V2F16:
        
        fputs(bi_round_as_str(I->round), fp);
        fputs(bi_clamp_as_str(I->clamp), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_FADD_IMM_F32:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fprintf(fp, ", index:%u", I->index);
        break;

    case BI_OPCODE_FADD_IMM_V2F16:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fprintf(fp, ", index:%u", I->index);
        break;

    case BI_OPCODE_FADD_LSCALE_F32:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_FADD_RSCALE_F32:
        
        fputs(bi_clamp_as_str(I->clamp), fp);
        fputs(bi_special_as_str(I->special), fp);
        fputs(bi_round_as_str(I->round), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_FCLAMP_F32:
        
        fputs(bi_clamp_as_str(I->clamp), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_FCLAMP_V2F16:
        
        fputs(bi_clamp_as_str(I->clamp), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_FCMP_F32:
        
        fputs(bi_cmpf_as_str(I->cmpf), fp);
        fputs(bi_result_type_as_str(I->result_type), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_FCMP_V2F16:
        
        fputs(bi_cmpf_as_str(I->cmpf), fp);
        fputs(bi_result_type_as_str(I->result_type), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_FCMP_AND_F32:
        
        fputs(bi_cmpf_as_str(I->cmpf), fp);
        fputs(bi_result_type_as_str(I->result_type), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_FCMP_AND_V2F16:
        
        fputs(bi_cmpf_as_str(I->cmpf), fp);
        fputs(bi_result_type_as_str(I->result_type), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_FCMP_OR_F32:
        
        fputs(bi_cmpf_as_str(I->cmpf), fp);
        fputs(bi_result_type_as_str(I->result_type), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_FCMP_OR_V2F16:
        
        fputs(bi_cmpf_as_str(I->cmpf), fp);
        fputs(bi_result_type_as_str(I->result_type), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_FCOS_TABLE_U6:
        
        if (I->offset) fputs(".offset", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_FEXP_F32:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_FEXP_TABLE_U4:
        
        fputs(bi_adj_as_str(I->adj), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_FLOGD_F32:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_FLOG_TABLE_F32:
        
        fputs(bi_mode_as_str(I->mode), fp);
        fputs(bi_precision_as_str(I->precision), fp);
        if (I->divzero) fputs(".divzero", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_FLSHIFT_DOUBLE_I32:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        
        if (I->bytes2) fputs(".bytes", fp);

        break;

    case BI_OPCODE_FLUSH_F32:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_FLUSH_V2F16:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_FMA_F32:
        
        fputs(bi_round_as_str(I->round), fp);
        fputs(bi_clamp_as_str(I->clamp), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_FMA_V2F16:
        
        fputs(bi_round_as_str(I->round), fp);
        fputs(bi_clamp_as_str(I->clamp), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_FMAX_F32:
        
        fputs(bi_clamp_as_str(I->clamp), fp);
        fputs(bi_sem_as_str(I->sem), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_FMAX_V2F16:
        
        fputs(bi_sem_as_str(I->sem), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_FMA_RSCALE_F32:
        
        fputs(bi_round_as_str(I->round), fp);
        fputs(bi_clamp_as_str(I->clamp), fp);
        fputs(bi_special_as_str(I->special), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[3]);
        

        break;

    case BI_OPCODE_FMA_RSCALE_V2F16:
        
        fputs(bi_round_as_str(I->round), fp);
        fputs(bi_clamp_as_str(I->clamp), fp);
        fputs(bi_special_as_str(I->special), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[3]);
        

        break;

    case BI_OPCODE_FMIN_F32:
        
        fputs(bi_clamp_as_str(I->clamp), fp);
        fputs(bi_sem_as_str(I->sem), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_FMIN_V2F16:
        
        fputs(bi_sem_as_str(I->sem), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_FMUL_CSLICE:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_FMUL_SLICE_F32:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_FPCLASS_F16:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_FPCLASS_F32:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_FPOW_SC_APPLY:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_FPOW_SC_DET_F16:
        
        fputs(bi_func_as_str(I->func), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_FPOW_SC_DET_F32:
        
        fputs(bi_func_as_str(I->func), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_FRCP_F16:
        
        if (I->divzero) fputs(".divzero", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_FRCP_F32:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_FRCP_APPROX_F32:
        
        if (I->divzero) fputs(".divzero", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_FREXPE_F32:
        
        if (I->sqrt) fputs(".sqrt", fp);
        if (I->log) fputs(".log", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_FREXPE_V2F16:
        
        if (I->sqrt) fputs(".sqrt", fp);
        if (I->log) fputs(".log", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_FREXPM_F32:
        
        if (I->sqrt) fputs(".sqrt", fp);
        if (I->log) fputs(".log", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_FREXPM_V2F16:
        
        if (I->sqrt) fputs(".sqrt", fp);
        if (I->log) fputs(".log", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_FROUND_F32:
        
        fputs(bi_round_as_str(I->round), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_FROUND_V2F16:
        
        fputs(bi_round_as_str(I->round), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_FRSHIFT_DOUBLE_I32:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        
        if (I->bytes2) fputs(".bytes", fp);

        break;

    case BI_OPCODE_FRSQ_F16:
        
        if (I->divzero) fputs(".divzero", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_FRSQ_F32:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_FRSQ_APPROX_F32:
        
        if (I->divzero) fputs(".divzero", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_FSINCOS_OFFSET_U6:
        
        if (I->scale) fputs(".scale", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_FSIN_TABLE_U6:
        
        if (I->offset) fputs(".offset", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_HADD_S32:
        
        fputs(bi_round_as_str(I->round), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_HADD_U32:
        
        fputs(bi_round_as_str(I->round), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_HADD_V2S16:
        
        fputs(bi_round_as_str(I->round), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_HADD_V2U16:
        
        fputs(bi_round_as_str(I->round), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_HADD_V4S8:
        
        fputs(bi_round_as_str(I->round), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_HADD_V4U8:
        
        fputs(bi_round_as_str(I->round), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_IABS_S32:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_IABS_V2S16:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_IABS_V4S8:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_IADD_S32:
        
        if (I->saturate) fputs(".saturate", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_IADD_U32:
        
        if (I->saturate) fputs(".saturate", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_IADD_V2S16:
        
        if (I->saturate) fputs(".saturate", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_IADD_V2U16:
        
        if (I->saturate) fputs(".saturate", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_IADD_V4S8:
        
        if (I->saturate) fputs(".saturate", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_IADD_V4U8:
        
        if (I->saturate) fputs(".saturate", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_IADDC_I32:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_IADD_IMM_I32:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fprintf(fp, ", index:%u", I->index);
        break;

    case BI_OPCODE_IADD_IMM_V2I16:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fprintf(fp, ", index:%u", I->index);
        break;

    case BI_OPCODE_IADD_IMM_V4I8:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fprintf(fp, ", index:%u", I->index);
        break;

    case BI_OPCODE_ICMP_I32:
        
        fputs(bi_result_type_as_str(I->result_type), fp);
        fputs(bi_cmpf_as_str(I->cmpf), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_ICMP_S32:
        
        fputs(bi_result_type_as_str(I->result_type), fp);
        fputs(bi_cmpf_as_str(I->cmpf), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_ICMP_U32:
        
        fputs(bi_result_type_as_str(I->result_type), fp);
        fputs(bi_cmpf_as_str(I->cmpf), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_ICMP_V2I16:
        
        fputs(bi_result_type_as_str(I->result_type), fp);
        fputs(bi_cmpf_as_str(I->cmpf), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_ICMP_V2S16:
        
        fputs(bi_result_type_as_str(I->result_type), fp);
        fputs(bi_cmpf_as_str(I->cmpf), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_ICMP_V2U16:
        
        fputs(bi_result_type_as_str(I->result_type), fp);
        fputs(bi_cmpf_as_str(I->cmpf), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_ICMP_V4I8:
        
        fputs(bi_result_type_as_str(I->result_type), fp);
        fputs(bi_cmpf_as_str(I->cmpf), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_ICMP_V4S8:
        
        fputs(bi_result_type_as_str(I->result_type), fp);
        fputs(bi_cmpf_as_str(I->cmpf), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_ICMP_V4U8:
        
        fputs(bi_result_type_as_str(I->result_type), fp);
        fputs(bi_cmpf_as_str(I->cmpf), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_ICMPF_I32:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_ICMPI_I32:
        
        fputs(bi_result_type_as_str(I->result_type), fp);
        fputs(bi_cmpf_as_str(I->cmpf), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_ICMPI_S32:
        
        fputs(bi_result_type_as_str(I->result_type), fp);
        fputs(bi_cmpf_as_str(I->cmpf), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_ICMPI_U32:
        
        fputs(bi_result_type_as_str(I->result_type), fp);
        fputs(bi_cmpf_as_str(I->cmpf), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_ICMPM_I32:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_ICMP_AND_S32:
        
        fputs(bi_cmpf_as_str(I->cmpf), fp);
        fputs(bi_result_type_as_str(I->result_type), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_ICMP_AND_U32:
        
        fputs(bi_cmpf_as_str(I->cmpf), fp);
        fputs(bi_result_type_as_str(I->result_type), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_ICMP_AND_V2S16:
        
        fputs(bi_cmpf_as_str(I->cmpf), fp);
        fputs(bi_result_type_as_str(I->result_type), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_ICMP_AND_V2U16:
        
        fputs(bi_cmpf_as_str(I->cmpf), fp);
        fputs(bi_result_type_as_str(I->result_type), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_ICMP_AND_V4S8:
        
        fputs(bi_cmpf_as_str(I->cmpf), fp);
        fputs(bi_result_type_as_str(I->result_type), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_ICMP_AND_V4U8:
        
        fputs(bi_cmpf_as_str(I->cmpf), fp);
        fputs(bi_result_type_as_str(I->result_type), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_ICMP_MULTI_S32:
        
        fputs(bi_cmpf_as_str(I->cmpf), fp);
        fputs(bi_result_type_as_str(I->result_type), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_ICMP_MULTI_U32:
        
        fputs(bi_cmpf_as_str(I->cmpf), fp);
        fputs(bi_result_type_as_str(I->result_type), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_ICMP_OR_S32:
        
        fputs(bi_cmpf_as_str(I->cmpf), fp);
        fputs(bi_result_type_as_str(I->result_type), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_ICMP_OR_U32:
        
        fputs(bi_cmpf_as_str(I->cmpf), fp);
        fputs(bi_result_type_as_str(I->result_type), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_ICMP_OR_V2S16:
        
        fputs(bi_cmpf_as_str(I->cmpf), fp);
        fputs(bi_result_type_as_str(I->result_type), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_ICMP_OR_V2U16:
        
        fputs(bi_cmpf_as_str(I->cmpf), fp);
        fputs(bi_result_type_as_str(I->result_type), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_ICMP_OR_V4S8:
        
        fputs(bi_cmpf_as_str(I->cmpf), fp);
        fputs(bi_result_type_as_str(I->result_type), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_ICMP_OR_V4U8:
        
        fputs(bi_cmpf_as_str(I->cmpf), fp);
        fputs(bi_result_type_as_str(I->result_type), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_IDP_V4I8:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_IDPADD_V4S8:
        
        if (I->saturate) fputs(".saturate", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_IDPADD_V4U8:
        
        if (I->saturate) fputs(".saturate", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_ILOGB_F32:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_ILOGB_V2F16:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_IMOV_FMA:
        
        if (I->threads) fputs(".threads", fp);

        fputs(" ", fp);
        break;

    case BI_OPCODE_IMUL_I32:
        
        fputs(bi_extend_as_str(I->extend), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_IMUL_V2I16:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_IMUL_V4I8:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_IMULD:
        
        if (I->threads) fputs(".threads", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_ISUB_S32:
        
        if (I->saturate) fputs(".saturate", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_ISUB_U32:
        
        if (I->saturate) fputs(".saturate", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_ISUB_V2S16:
        
        if (I->saturate) fputs(".saturate", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_ISUB_V2U16:
        
        if (I->saturate) fputs(".saturate", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_ISUB_V4S8:
        
        if (I->saturate) fputs(".saturate", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_ISUB_V4U8:
        
        if (I->saturate) fputs(".saturate", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_ISUBB_I32:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_JUMP:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_JUMP_EX:
        
        if (I->test_mode) fputs(".test_mode", fp);
        fputs(bi_stack_mode_as_str(I->stack_mode), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_KABOOM:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_LDEXP_F32:
        
        fputs(bi_round_as_str(I->round), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_LDEXP_V2F16:
        
        fputs(bi_round_as_str(I->round), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_LD_ATTR:
        
        fputs(bi_register_format_as_str(I->register_format), fp);
        fputs(bi_vecsize_as_str(I->vecsize), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_LD_ATTR_IMM:
        
        fputs(bi_register_format_as_str(I->register_format), fp);
        fputs(bi_vecsize_as_str(I->vecsize), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fprintf(fp, ", attribute_index:%u", I->attribute_index);
        break;

    case BI_OPCODE_LD_ATTR_TEX:
        
        fputs(bi_register_format_as_str(I->register_format), fp);
        fputs(bi_vecsize_as_str(I->vecsize), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_LD_CVT:
        
        fputs(bi_register_format_as_str(I->register_format), fp);
        fputs(bi_vecsize_as_str(I->vecsize), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_LD_GCLK_U64:
        
        fputs(bi_source_as_str(I->source), fp);

        fputs(" ", fp);
        break;

    case BI_OPCODE_LD_PKA_I128:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_LD_PKA_I16:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_LD_PKA_I24:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_LD_PKA_I32:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_LD_PKA_I48:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_LD_PKA_I64:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_LD_PKA_I8:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_LD_PKA_I96:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_LD_TEX:
        
        fputs(bi_vecsize_as_str(I->vecsize), fp);
        fputs(bi_register_format_as_str(I->register_format), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_LD_TEX_IMM:
        
        fputs(bi_vecsize_as_str(I->vecsize), fp);
        fputs(bi_register_format_as_str(I->register_format), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fprintf(fp, ", texture_index:%u", I->texture_index);
        break;

    case BI_OPCODE_LD_TILE:
        
        fputs(bi_vecsize_as_str(I->vecsize), fp);
        fputs(bi_register_format_as_str(I->register_format), fp);
        if (I->z_stencil) fputs(".z_stencil", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_LD_VAR:
        
        fputs(bi_vecsize_as_str(I->vecsize), fp);
        fputs(bi_update_as_str(I->update), fp);
        fputs(bi_register_format_as_str(I->register_format), fp);
        fputs(bi_sample_as_str(I->sample), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_LD_VAR_BUF_F16:
        
        fputs(bi_vecsize_as_str(I->vecsize), fp);
        fputs(bi_source_format_as_str(I->source_format), fp);
        fputs(bi_register_format_as_str(I->register_format), fp);
        fputs(bi_sample_as_str(I->sample), fp);
        fputs(bi_update_as_str(I->update), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_LD_VAR_BUF_F32:
        
        fputs(bi_vecsize_as_str(I->vecsize), fp);
        fputs(bi_source_format_as_str(I->source_format), fp);
        fputs(bi_register_format_as_str(I->register_format), fp);
        fputs(bi_sample_as_str(I->sample), fp);
        fputs(bi_update_as_str(I->update), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_LD_VAR_BUF_IMM_F16:
        
        fputs(bi_vecsize_as_str(I->vecsize), fp);
        fputs(bi_source_format_as_str(I->source_format), fp);
        fputs(bi_register_format_as_str(I->register_format), fp);
        fputs(bi_sample_as_str(I->sample), fp);
        fputs(bi_update_as_str(I->update), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fprintf(fp, ", index:%u", I->index);
        break;

    case BI_OPCODE_LD_VAR_BUF_IMM_F32:
        
        fputs(bi_vecsize_as_str(I->vecsize), fp);
        fputs(bi_source_format_as_str(I->source_format), fp);
        fputs(bi_register_format_as_str(I->register_format), fp);
        fputs(bi_sample_as_str(I->sample), fp);
        fputs(bi_update_as_str(I->update), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fprintf(fp, ", index:%u", I->index);
        break;

    case BI_OPCODE_LD_VAR_FLAT:
        
        fputs(bi_vecsize_as_str(I->vecsize), fp);
        fputs(bi_register_format_as_str(I->register_format), fp);
        fputs(bi_function_as_str(I->function), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_LD_VAR_FLAT_IMM:
        
        fputs(bi_vecsize_as_str(I->vecsize), fp);
        fputs(bi_register_format_as_str(I->register_format), fp);
        fputs(bi_function_as_str(I->function), fp);

        fputs(" ", fp);
        fprintf(fp, ", index:%u", I->index);
        break;

    case BI_OPCODE_LD_VAR_IMM:
        
        fputs(bi_vecsize_as_str(I->vecsize), fp);
        fputs(bi_update_as_str(I->update), fp);
        fputs(bi_register_format_as_str(I->register_format), fp);
        fputs(bi_sample_as_str(I->sample), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fprintf(fp, ", index:%u", I->index);
        break;

    case BI_OPCODE_LD_VAR_SPECIAL:
        
        fputs(bi_varying_name_as_str(I->varying_name), fp);
        fputs(bi_vecsize_as_str(I->vecsize), fp);
        fputs(bi_update_as_str(I->update), fp);
        fputs(bi_register_format_as_str(I->register_format), fp);
        fputs(bi_sample_as_str(I->sample), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_LEA_ATTR:
        
        fputs(bi_register_format_as_str(I->register_format), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_LEA_ATTR_IMM:
        
        fputs(bi_register_format_as_str(I->register_format), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fprintf(fp, ", attribute_index:%u", I->attribute_index);
        break;

    case BI_OPCODE_LEA_ATTR_TEX:
        
        fputs(bi_register_format_as_str(I->register_format), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_LEA_BUF:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_LEA_BUF_IMM:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_LEA_PKA:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_LEA_TEX:
        
        if (I->format) fputs(".format", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_LEA_TEX_IMM:
        
        if (I->format) fputs(".format", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fprintf(fp, ", texture_index:%u", I->texture_index);
        break;

    case BI_OPCODE_LOAD_I128:
        
        fputs(bi_seg_as_str(I->seg), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fprintf(fp, ", byte_offset:%u", I->byte_offset);
        break;

    case BI_OPCODE_LOAD_I16:
        
        fputs(bi_seg_as_str(I->seg), fp);
        fputs(bi_extend_as_str(I->extend), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fprintf(fp, ", byte_offset:%u", I->byte_offset);
        break;

    case BI_OPCODE_LOAD_I24:
        
        fputs(bi_seg_as_str(I->seg), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fprintf(fp, ", byte_offset:%u", I->byte_offset);
        break;

    case BI_OPCODE_LOAD_I32:
        
        fputs(bi_seg_as_str(I->seg), fp);
        fputs(bi_extend_as_str(I->extend), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fprintf(fp, ", byte_offset:%u", I->byte_offset);
        break;

    case BI_OPCODE_LOAD_I48:
        
        fputs(bi_seg_as_str(I->seg), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fprintf(fp, ", byte_offset:%u", I->byte_offset);
        break;

    case BI_OPCODE_LOAD_I64:
        
        fputs(bi_seg_as_str(I->seg), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fprintf(fp, ", byte_offset:%u", I->byte_offset);
        break;

    case BI_OPCODE_LOAD_I8:
        
        fputs(bi_seg_as_str(I->seg), fp);
        fputs(bi_extend_as_str(I->extend), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fprintf(fp, ", byte_offset:%u", I->byte_offset);
        break;

    case BI_OPCODE_LOAD_I96:
        
        fputs(bi_seg_as_str(I->seg), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fprintf(fp, ", byte_offset:%u", I->byte_offset);
        break;

    case BI_OPCODE_LOGB_F32:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_LOGB_V2F16:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_LROT_DOUBLE_I32:
        
        if (I->result_word) fputs(".result_word", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        
        if (I->bytes2) fputs(".bytes", fp);

        break;

    case BI_OPCODE_LSHIFT_AND_I32:
        
        if (I->not_result) fputs(".not_result", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_LSHIFT_AND_V2I16:
        
        if (I->not_result) fputs(".not_result", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_LSHIFT_AND_V4I8:
        
        if (I->not_result) fputs(".not_result", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_LSHIFT_DOUBLE_I32:
        
        if (I->result_word) fputs(".result_word", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        
        if (I->bytes2) fputs(".bytes", fp);

        break;

    case BI_OPCODE_LSHIFT_OR_I32:
        
        if (I->not_result) fputs(".not_result", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_LSHIFT_OR_V2I16:
        
        if (I->not_result) fputs(".not_result", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_LSHIFT_OR_V4I8:
        
        if (I->not_result) fputs(".not_result", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_LSHIFT_XOR_I32:
        
        if (I->not_result) fputs(".not_result", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_LSHIFT_XOR_V2I16:
        
        if (I->not_result) fputs(".not_result", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_LSHIFT_XOR_V4I8:
        
        if (I->not_result) fputs(".not_result", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_MKVEC_V2I16:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_MKVEC_V2I8:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_MKVEC_V4I8:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[3]);
        

        break;

    case BI_OPCODE_MOV_I32:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_MUX_I32:
        
        fputs(bi_mux_as_str(I->mux), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_MUX_V2I16:
        
        fputs(bi_mux_as_str(I->mux), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_MUX_V4I8:
        
        fputs(bi_mux_as_str(I->mux), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_NOP:
        

        fputs(" ", fp);
        break;

    case BI_OPCODE_PHI:
        

        fputs(" ", fp);
        break;

    case BI_OPCODE_POPCOUNT_I32:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_QUIET_F32:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_QUIET_V2F16:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_RROT_DOUBLE_I32:
        
        if (I->result_word) fputs(".result_word", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        
        if (I->bytes2) fputs(".bytes", fp);

        break;

    case BI_OPCODE_RSHIFT_AND_I32:
        
        if (I->not_result) fputs(".not_result", fp);
        if (I->arithmetic) fputs(".arithmetic", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_RSHIFT_AND_V2I16:
        
        if (I->not_result) fputs(".not_result", fp);
        if (I->arithmetic) fputs(".arithmetic", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_RSHIFT_AND_V4I8:
        
        if (I->arithmetic) fputs(".arithmetic", fp);
        if (I->not_result) fputs(".not_result", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_RSHIFT_DOUBLE_I32:
        
        if (I->result_word) fputs(".result_word", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        
        if (I->bytes2) fputs(".bytes", fp);

        break;

    case BI_OPCODE_RSHIFT_OR_I32:
        
        if (I->arithmetic) fputs(".arithmetic", fp);
        if (I->not_result) fputs(".not_result", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_RSHIFT_OR_V2I16:
        
        if (I->not_result) fputs(".not_result", fp);
        if (I->arithmetic) fputs(".arithmetic", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_RSHIFT_OR_V4I8:
        
        if (I->not_result) fputs(".not_result", fp);
        if (I->arithmetic) fputs(".arithmetic", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_RSHIFT_XOR_I32:
        
        if (I->not_result) fputs(".not_result", fp);
        if (I->arithmetic) fputs(".arithmetic", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_RSHIFT_XOR_V2I16:
        
        if (I->not_result) fputs(".not_result", fp);
        if (I->arithmetic) fputs(".arithmetic", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_RSHIFT_XOR_V4I8:
        
        if (I->not_result) fputs(".not_result", fp);
        if (I->arithmetic) fputs(".arithmetic", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_S16_TO_F32:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_S16_TO_S32:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_S32_TO_F32:
        
        fputs(bi_round_as_str(I->round), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_S8_TO_F32:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_S8_TO_S32:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_SEG_ADD:
        
        fputs(bi_seg_as_str(I->seg), fp);
        if (I->preserve_null) fputs(".preserve_null", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_SEG_ADD_I64:
        
        fputs(bi_seg_as_str(I->seg), fp);
        if (I->preserve_null) fputs(".preserve_null", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_SHADDXH_I32:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_SHADDXL_I64:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fprintf(fp, ", shift:%u", I->shift);
        break;

    case BI_OPCODE_SHADDXL_S32:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fprintf(fp, ", shift:%u", I->shift);
        break;

    case BI_OPCODE_SHADDXL_U32:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fprintf(fp, ", shift:%u", I->shift);
        break;

    case BI_OPCODE_SHIFT_DOUBLE_I32:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_SPLIT_I32:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_STORE_I128:
        
        fputs(bi_seg_as_str(I->seg), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        fprintf(fp, ", byte_offset:%u", I->byte_offset);
        break;

    case BI_OPCODE_STORE_I16:
        
        fputs(bi_seg_as_str(I->seg), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        fprintf(fp, ", byte_offset:%u", I->byte_offset);
        break;

    case BI_OPCODE_STORE_I24:
        
        fputs(bi_seg_as_str(I->seg), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        fprintf(fp, ", byte_offset:%u", I->byte_offset);
        break;

    case BI_OPCODE_STORE_I32:
        
        fputs(bi_seg_as_str(I->seg), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        fprintf(fp, ", byte_offset:%u", I->byte_offset);
        break;

    case BI_OPCODE_STORE_I48:
        
        fputs(bi_seg_as_str(I->seg), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        fprintf(fp, ", byte_offset:%u", I->byte_offset);
        break;

    case BI_OPCODE_STORE_I64:
        
        fputs(bi_seg_as_str(I->seg), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        fprintf(fp, ", byte_offset:%u", I->byte_offset);
        break;

    case BI_OPCODE_STORE_I8:
        
        fputs(bi_seg_as_str(I->seg), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        fprintf(fp, ", byte_offset:%u", I->byte_offset);
        break;

    case BI_OPCODE_STORE_I96:
        
        fputs(bi_seg_as_str(I->seg), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        fprintf(fp, ", byte_offset:%u", I->byte_offset);
        break;

    case BI_OPCODE_ST_CVT:
        
        fputs(bi_register_format_as_str(I->register_format), fp);
        fputs(bi_vecsize_as_str(I->vecsize), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[3]);
        

        break;

    case BI_OPCODE_ST_TILE:
        
        fputs(bi_vecsize_as_str(I->vecsize), fp);
        fputs(bi_register_format_as_str(I->register_format), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[3]);
        

        break;

    case BI_OPCODE_SWZ_V2I16:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_SWZ_V4I8:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_TEXC:
        
        if (I->skip) fputs(".skip", fp);
        if (I->lod_mode) fputs(".lod_mode", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[3]);
        

        fprintf(fp, ", sr_count:%u", I->sr_count);
        fprintf(fp, ", sr_count_2:%u", I->sr_count_2);
        break;

    case BI_OPCODE_TEXC_DUAL:
        
        if (I->skip) fputs(".skip", fp);
        if (I->lod_mode) fputs(".lod_mode", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[3]);
        

        fprintf(fp, ", sr_count:%u", I->sr_count);
        fprintf(fp, ", sr_count_2:%u", I->sr_count_2);
        break;

    case BI_OPCODE_TEXS_2D_F16:
        
        if (I->skip) fputs(".skip", fp);
        if (I->lod_mode) fputs(".lod_mode", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fprintf(fp, ", sampler_index:%u", I->sampler_index);
        fprintf(fp, ", texture_index:%u", I->texture_index);
        break;

    case BI_OPCODE_TEXS_2D_F32:
        
        if (I->skip) fputs(".skip", fp);
        if (I->lod_mode) fputs(".lod_mode", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fprintf(fp, ", sampler_index:%u", I->sampler_index);
        fprintf(fp, ", texture_index:%u", I->texture_index);
        break;

    case BI_OPCODE_TEXS_CUBE_F16:
        
        if (I->skip) fputs(".skip", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        fprintf(fp, ", sampler_index:%u", I->sampler_index);
        fprintf(fp, ", texture_index:%u", I->texture_index);
        break;

    case BI_OPCODE_TEXS_CUBE_F32:
        
        if (I->skip) fputs(".skip", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        fprintf(fp, ", sampler_index:%u", I->sampler_index);
        fprintf(fp, ", texture_index:%u", I->texture_index);
        break;

    case BI_OPCODE_TEX_FETCH:
        
        if (I->skip) fputs(".skip", fp);
        fputs(bi_write_mask_as_str(I->write_mask), fp);
        fputs(bi_dimension_as_str(I->dimension), fp);
        if (I->wide_indices) fputs(".wide_indices", fp);
        if (I->array_enable) fputs(".array_enable", fp);
        if (I->texel_offset) fputs(".texel_offset", fp);
        fputs(bi_register_format_as_str(I->register_format), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        fprintf(fp, ", sr_count:%u", I->sr_count);
        break;

    case BI_OPCODE_TEX_GATHER:
        
        if (I->skip) fputs(".skip", fp);
        fputs(bi_write_mask_as_str(I->write_mask), fp);
        fputs(bi_dimension_as_str(I->dimension), fp);
        if (I->wide_indices) fputs(".wide_indices", fp);
        if (I->array_enable) fputs(".array_enable", fp);
        if (I->texel_offset) fputs(".texel_offset", fp);
        if (I->integer_coordinates) fputs(".integer_coordinates", fp);
        fputs(bi_fetch_component_as_str(I->fetch_component), fp);
        fputs(bi_register_format_as_str(I->register_format), fp);
        if (I->shadow) fputs(".shadow", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        fprintf(fp, ", sr_count:%u", I->sr_count);
        break;

    case BI_OPCODE_TEX_GRADIENT:
        
        if (I->skip) fputs(".skip", fp);
        fputs(bi_write_mask_as_str(I->write_mask), fp);
        fputs(bi_dimension_as_str(I->dimension), fp);
        if (I->wide_indices) fputs(".wide_indices", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        fprintf(fp, ", sr_count:%u", I->sr_count);
        break;

    case BI_OPCODE_TEX_SINGLE:
        
        if (I->skip) fputs(".skip", fp);
        fputs(bi_write_mask_as_str(I->write_mask), fp);
        fputs(bi_dimension_as_str(I->dimension), fp);
        if (I->wide_indices) fputs(".wide_indices", fp);
        if (I->array_enable) fputs(".array_enable", fp);
        if (I->texel_offset) fputs(".texel_offset", fp);
        fputs(bi_register_format_as_str(I->register_format), fp);
        if (I->shadow) fputs(".shadow", fp);
        fputs(bi_va_lod_mode_as_str(I->va_lod_mode), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        fprintf(fp, ", sr_count:%u", I->sr_count);
        break;

    case BI_OPCODE_U16_TO_F32:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_U16_TO_U32:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_U32_TO_F32:
        
        fputs(bi_round_as_str(I->round), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_U8_TO_F32:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_U8_TO_U32:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_V2F16_TO_V2S16:
        
        fputs(bi_round_as_str(I->round), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_V2F16_TO_V2U16:
        
        fputs(bi_round_as_str(I->round), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_V2F32_TO_V2F16:
        
        fputs(bi_clamp_as_str(I->clamp), fp);
        fputs(bi_round_as_str(I->round), fp);
        if (I->ftz) fputs(".ftz", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        break;

    case BI_OPCODE_V2S16_TO_V2F16:
        
        fputs(bi_round_as_str(I->round), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_V2S8_TO_V2F16:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_V2S8_TO_V2S16:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_V2U16_TO_V2F16:
        
        fputs(bi_round_as_str(I->round), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_V2U8_TO_V2F16:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_V2U8_TO_V2U16:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_VAR_TEX_F16:
        
        fputs(bi_update_as_str(I->update), fp);
        if (I->skip) fputs(".skip", fp);
        if (I->lod_mode) fputs(".lod_mode", fp);
        fputs(bi_sample_as_str(I->sample), fp);

        fputs(" ", fp);
        fprintf(fp, ", texture_index:%u", I->texture_index);
        fprintf(fp, ", varying_index:%u", I->varying_index);
        break;

    case BI_OPCODE_VAR_TEX_F32:
        
        fputs(bi_update_as_str(I->update), fp);
        if (I->skip) fputs(".skip", fp);
        if (I->lod_mode) fputs(".lod_mode", fp);
        fputs(bi_sample_as_str(I->sample), fp);

        fputs(" ", fp);
        fprintf(fp, ", texture_index:%u", I->texture_index);
        fprintf(fp, ", varying_index:%u", I->varying_index);
        break;

    case BI_OPCODE_VN_ASST1_F16:
        
        if (I->h) fputs(".h", fp);
        if (I->l) fputs(".l", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;

    case BI_OPCODE_VN_ASST1_F32:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[3]);
        

        break;

    case BI_OPCODE_VN_ASST2_F32:
        
        if (I->scale) fputs(".scale", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_VN_ASST2_V2F16:
        

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        break;

    case BI_OPCODE_WMASK:
        
        fputs(bi_subgroup_as_str(I->subgroup), fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fprintf(fp, ", fill:%u", I->fill);
        break;

    case BI_OPCODE_ZS_EMIT:
        
        if (I->stencil) fputs(".stencil", fp);
        if (I->z) fputs(".z", fp);

        fputs(" ", fp);
        bi_print_index(fp, I->src[0]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[1]);
        

        fputs(", ", fp);
        bi_print_index(fp, I->src[2]);
        

        break;
    default:
        UNREACHABLE("Invalid opcode");
    }

    if (I->branch_target)
            fprintf(fp, " -> block%u", I->branch_target->index);

    fputs("\n", fp);

}
